#ifndef _TUNED_HEAP_HPP_
#define _TUNED_HEAP_HPP_
//                                        Ruler
//       1         2         3         4         5         6         7         8
//345678901234567890123456789012345678901234567890123456789012345678901234567890

    /********************************************************************/
    /*                                                                  */
    /*   The standard layout.                                           */
    /*                                                                  */
    /*   The standard layout for 'hpp' files for this code is as        */
    /*   follows:                                                       */
    /*                                                                  */
    /*      1. Include files.                                           */
    /*      2. Constants exported from the class.                       */
    /*      3. Data structures exported from the class.                 */
	/*      4. Forward references to other data structures.             */
	/*      5. Class specifications (including inline functions).       */
    /*      6. Additional large inline functions.                       */
    /*                                                                  */
    /*   Any portion that is not required is simply omitted.            */
    /*                                                                  */
    /********************************************************************/

#include "RockallFrontEnd.hpp"

    /********************************************************************/
    /*                                                                  */
    /*   A fast heap.                                                   */
    /*                                                                  */
    /*   A fast heap tries to provide very good performance even        */
    /*   if that comes at a significant cost in terms of additional     */
    /*   memory usage.                                                  */
    /*                                                                  */
    /********************************************************************/

class TUNED_HEAP : public ROCKALL_FRONT_END
    {
   public:
        //
        //   Public functions.
        //
        TUNED_HEAP
			( 
			int						  MaxFreeSpace = (128 * 4194304),
			bool					  Recycle = true,
			bool					  SingleImage = true,
			bool					  ThreadSafe = true 
			);

        ~TUNED_HEAP( void );

	private:
        //
        //   Disabled operations.
 		//
		//   All copy constructors and class assignment 
		//   operations are disabled.
        //
        TUNED_HEAP( const TUNED_HEAP & Copy );

        void operator=( const TUNED_HEAP & Copy );
    };
#endif
