//--------------------------------------------------------------------------------------
// SurveyError.h
// 
// This file contains error codes generated by SurveyLib 
// 
// Microsoft Game Studios Tools and Technology Group
// Copyright (C) Microsoft Corporation. All rights reserved.
//--------------------------------------------------------------------------------------

#pragma once

#ifndef MAKE_HRESULT
#define MAKE_HRESULT(sev,fac,code) ((HRESULT)(((unsigned long)(sev)<<31)|((unsigned long)(fac)<<16)|((unsigned long)(code))))
#endif

#define SURVEY_FACILITY   0x72

// Success codes
#define SURVEY_S_OK       S_OK

// Error codes
#define SURVEY_E_FIRST_ERROR                    MAKE_HRESULT(SEVERITY_ERROR, SURVEY_FACILITY, 0x0000) 
#define SURVEY_E_FAIL                           SURVEY_E_FIRST_ERROR +  1   // 0x80720001    // Unspecified failure
#define SURVEY_E_MEMORY                         SURVEY_E_FIRST_ERROR +  2   // 0x80720002    // Out of memory   
#define SURVEY_E_INVALID_ARGUMENT  				SURVEY_E_FIRST_ERROR +  3   // 0x80720003    // Invalid argument
#define SURVEY_E_OPEN_FILE_FAILED               SURVEY_E_FIRST_ERROR +  4   // 0x80720004    // Couldn't open file
#define SURVEY_E_LABEL_TOO_LONG					SURVEY_E_FIRST_ERROR +  5   // 0x80720005    // Survey label too long
#define SURVEY_E_INVALID_LINE_TYPE				SURVEY_E_FIRST_ERROR +  6   // 0x80720006    // Survey file invalid line type
#define SURVEY_E_FILE_PARSE_ERROR				SURVEY_E_FIRST_ERROR +  7   // 0x80720007    // Survey file parse error
#define SURVEY_E_INVALID_QUESTION_TYPE			SURVEY_E_FIRST_ERROR +  8   // 0x80720008    // Survey file invalid question type string
#define SURVEY_E_TOO_MANY_QUESTIONS				SURVEY_E_FIRST_ERROR +  9   // 0x80720009    // Exceeded maximum number of questions
#define SURVEY_E_NO_RENDERER					SURVEY_E_FIRST_ERROR + 10   // 0x8072000A    // No survey renderer set
#define SURVEY_E_UNSUPPORTED_QUESTION_TYPE		SURVEY_E_FIRST_ERROR + 11   // 0x8072000B    // Renderer can't draw this question type
#define SURVEY_E_ALREADY_SHOWN					SURVEY_E_FIRST_ERROR + 12   // 0x8072000C    // A survey is already being shown
#define SURVEY_E_TOO_MANY_ANSWERS  				SURVEY_E_FIRST_ERROR + 13   // 0x8072000D    // Exeeded maximum number of answers
#define SURVEY_E_CANT_FIND_QUESTION				SURVEY_E_FIRST_ERROR + 14   // 0x8072000E    // Named question can't be found
#define SURVEY_E_TOO_MANY_FONTS    				SURVEY_E_FIRST_ERROR + 15   // 0x8072000F    // Exeeded maximum number of fonts   
#define SURVEY_E_CREATE_FONT_FAILED    			SURVEY_E_FIRST_ERROR + 16   // 0x80720010    // Failed to create survey font   
#define SURVEY_E_INVALID_FONT          			SURVEY_E_FIRST_ERROR + 17   // 0x80720011    // Attempted to draw text with a nonexistent font
#define SURVEY_E_INVALID_XML_SYNTAX    			SURVEY_E_FIRST_ERROR + 18   // 0x80720012    // Invalid syntax in XML survey file (element in wrong place)
#define SURVEY_E_XML_MISSING_NAME    			SURVEY_E_FIRST_ERROR + 19   // 0x80720013    // Question element missing 'name' attribute
#define SURVEY_E_XML_MISSING_TYPE    			SURVEY_E_FIRST_ERROR + 20   // 0x80720014    // Question element missing 'type' attribute
