/***********************************************************************
  The content of this file includes source code for the sound engine
  portion of the AUDIOKINETIC Wwise Technology and constitutes "Level
  Two Source Code" as defined in the Source Code Addendum attached
  with this file.  Any use of the Level Two Source Code shall be
  subject to the terms and conditions outlined in the Source Code
  Addendum and the End User License Agreement for Wwise(R).

  Version: v2008.2.1  Build: 2821
  Copyright (c) 2006-2008 Audiokinetic Inc.
 ***********************************************************************/

#pragma once

static const int kStrSize = 129; ///< Length of a Sound Frame string buffer (includes trailing zero).

enum SFObjectType
{
	SFType_Unknown = 0,

	SFType_Event = 1,
	SFType_SoundObject = 2,
	SFType_StateGroup = 3,
	SFType_GameObject = 4,
	SFType_SwitchGroup = 5,
	SFType_GameParameter = 6,
	SFType_Trigger = 7,
	SFType_Environment = 8
	// Add new types here ...
};

#pragma pack(1)
struct SFNotifData
{
	long eNotif;
	long eType;
	UINT32 objectID;
};
#pragma pack()

// Windows message

#define WM_SFBASE           (WM_USER+0x514)

#define WM_SF_STARTUP		(WM_SFBASE+0)
#define WM_SF_SHUTDOWN		(WM_SFBASE+1)
#define WM_SF_REQEVENTS		(WM_SFBASE+2)
#define WM_SF_REQPROJ		(WM_SFBASE+3)
#define WM_SF_PLAY			(WM_SFBASE+4)
#define WM_SF_STOP			(WM_SFBASE+5)
#define WM_SF_CLIENTVERSION	(WM_SFBASE+6)
#define WM_SF_REQSTATES     (WM_SFBASE+7)
#define WM_SF_REQGAMEOBJECTS (WM_SFBASE+8)
#define WM_SF_REQSWITCHES	(WM_SFBASE+9)
#define WM_SF_REQGAMEPARAMETERS	(WM_SFBASE+10)
#define WM_SF_REQTRIGGERS	(WM_SFBASE+11)
#define WM_SF_REQENVIRONMENTS	(WM_SFBASE+12)

// COPYDATASTRUCT.dwData values:

#define SF_COPYDATA_BASE		0x10

//#define SF_COPYDATA_EVENTLIST	(SF_COPYDATA_BASE+0)	// Do not use anymore
#define SF_COPYDATA_PLAYEVENTS	(SF_COPYDATA_BASE+1)
//#define SF_COPYDATA_REQEVENTS	(SF_COPYDATA_BASE+2)	// Do not use anymore
#define SF_COPYDATA_NOTIF		(SF_COPYDATA_BASE+3)
#define SF_COPYDATA_PROJ		(SF_COPYDATA_BASE+4)
//#define SF_COPYDATA_PROJNOTIF	(SF_COPYDATA_BASE+5)	// Do not use anymore
//#define SF_COPYDATA_REQSOUNDS	(SF_COPYDATA_BASE+6)	// Do not use anymore
//#define SF_COPYDATA_SOUNDLIST	(SF_COPYDATA_BASE+7)	// Do not use anymore
#define SF_COPYDATA_PLAYEVENTSBYSTRING	(SF_COPYDATA_BASE+8)
//#define SF_COPYDATA_REQEVENTSBYSTRING	(SF_COPYDATA_BASE+9)	// Do not use anymore
#define SF_COPYDATA_PROCESSDEFINITIONFILES (SF_COPYDATA_BASE+10)
#define SF_COPYDATA_GENERATESOUNDBANKS (SF_COPYDATA_BASE+11)
#define SF_COPYDATA_LISTENRADIUSFORSOUNDS (SF_COPYDATA_BASE+12)
#define SF_COPYDATA_OBJECTLIST	(SF_COPYDATA_BASE+13)
#define SF_COPYDATA_REQOBJECTS	(SF_COPYDATA_BASE+14)
#define SF_COPYDATA_REQOBJECTSBYSTRING (SF_COPYDATA_BASE+15)
#define SF_COPYDATA_REQCURRENTSTATE (SF_COPYDATA_BASE+16)
#define SF_COPYDATA_CURRENTSTATE (SF_COPYDATA_BASE+17)
#define SF_COPYDATA_SETCURRENTSTATE (SF_COPYDATA_BASE+18)
#define SF_COPYDATA_REGISTERGAMEOBJECT (SF_COPYDATA_BASE+19)
#define SF_COPYDATA_UNREGISTERGAMEOBJECT (SF_COPYDATA_BASE+20)
#define SF_COPYDATA_REQCURRENTSWITCH (SF_COPYDATA_BASE+21)
#define SF_COPYDATA_CURRENTSWITCH (SF_COPYDATA_BASE+22)
#define SF_COPYDATA_SETCURRENTSWITCH (SF_COPYDATA_BASE+23)
#define SF_COPYDATA_SETRTPCVALUE (SF_COPYDATA_BASE+24)
#define SF_COPYDATA_TRIGGER (SF_COPYDATA_BASE+25)
#define SF_COPYDATA_SETACTIVELISTENER (SF_COPYDATA_BASE+26)
#define SF_COPYDATA_SETPOSITION (SF_COPYDATA_BASE+27)
#define SF_COPYDATA_SETLISTENERPOSITION (SF_COPYDATA_BASE+28)
#define SF_COPYDATA_SETLISTENERSPATIALIZATION (SF_COPYDATA_BASE+29)
#define SF_COPYDATA_SETGAMEOBJECTENVIRONMENTSVALUES (SF_COPYDATA_BASE+30)
#define SF_COPYDATA_SETGAMEOBJECTDRYLEVELVALUE (SF_COPYDATA_BASE+31)
#define SF_COPYDATA_SETENVIRONMENTVOLUME (SF_COPYDATA_BASE+32)
#define SF_COPYDATA_BYPASSENVIRONMENT (SF_COPYDATA_BASE+33)
#define SF_COPYDATA_SETOBJECTOBSTRUCTIONANDOCCLUSION (SF_COPYDATA_BASE+34)
#define SF_COPYDATA_POSTMONITORINGMESSAGE (SF_COPYDATA_BASE+35)
#define SF_COPYDATA_STOPALL (SF_COPYDATA_BASE+36)
#define SF_COPYDATA_STOPPLAYINGID (SF_COPYDATA_BASE+37)

#define SF_CLIENTWINDOWNAME _T("WWISECLIENT")
#define SF_SERVERWINDOWNAME _T("WWISESERVER")

// Persistence versions: ( always modify SF_PERSIST_*_VERSION_CURRENT to point to the latest one ! ) 

#define SF_SOUNDFRAME_VERSION_FIRST				0x01
#define SF_SOUNDFRAME_VERSION_CURRENT			SF_SOUNDFRAME_VERSION_FIRST

#define SF_PERSIST_EVENT_VERSION_FIRST			0x01
#define SF_PERSIST_EVENT_VERSION_UNIQUEID		0x02
#define SF_PERSIST_EVENT_VERSION_CURRENT		SF_PERSIST_EVENT_VERSION_UNIQUEID

#define SF_PERSIST_SOUNDOBJECT_VERSION_FIRST	0x01
#define SF_PERSIST_SOUNDOBJECT_VERSION_NOTRANS	0x02
#define SF_PERSIST_SOUNDOBJECT_VERSION_UNIQUEID	0x03
#define SF_PERSIST_SOUNDOBJECT_VERSION_CURRENT	SF_PERSIST_SOUNDOBJECT_VERSION_UNIQUEID

#define SF_PERSIST_STATEGROUP_VERSION_FIRST		0x01
#define SF_PERSIST_STATEGROUP_VERSION_CURRENT	SF_PERSIST_STATEGROUP_VERSION_FIRST

#define SF_PERSIST_SWITCHGROUP_VERSION_FIRST	0x01
#define SF_PERSIST_SWITCHGROUP_VERSION_CURRENT	SF_PERSIST_SWITCHGROUP_VERSION_FIRST

#define SF_PERSIST_GAMEOBJECT_VERSION_FIRST		0x01
#define SF_PERSIST_GAMEOBJECT_VERSION_CURRENT	SF_PERSIST_GAMEOBJECT_VERSION_FIRST

#define SF_PERSIST_GAMEPARAMETER_VERSION_FIRST		0x01
#define SF_PERSIST_GAMEPARAMETER_VERSION_CURRENT	SF_PERSIST_GAMEPARAMETER_VERSION_FIRST

#define SF_PERSIST_TRIGGER_VERSION_FIRST		0x01
#define SF_PERSIST_TRIGGER_VERSION_CURRENT	SF_PERSIST_TRIGGER_VERSION_FIRST

#define SF_PERSIST_ENVIRONMENT_VERSION_FIRST		0x01
#define SF_PERSIST_ENVIRONMENT_VERSION_CURRENT	SF_PERSIST_ENVIRONMENT_VERSION_FIRST
