//==============================================================================
// mode.cpp
//
// Copyright (c) 2002, Ensemble Studios
//==============================================================================

// Includes
#include "common.h"
#include "mode.h"
#include "primDraw2D.h"
#include "ui.h"
#include "configsgame.h"

#include "grannyInstanceRenderer.h"
#include "renderThread.h"

//==============================================================================
// BMode::BMode
//==============================================================================
BMode::BMode(long modeType) :
   mModeType(modeType)
{
}

//==============================================================================
// BMode::~BMode
//==============================================================================
BMode::~BMode()
{
}

//==============================================================================
// BMode::setup
//==============================================================================
bool BMode::setup()
{
   return true;
}

//==============================================================================
// BMode::shutdown
//==============================================================================
void BMode::shutdown()
{
}

//==============================================================================
// BMode::preEnter
//==============================================================================
void BMode::preEnter(BMode* lastMode)
{
   lastMode;
}

//==============================================================================
// BMode::enter
//==============================================================================
void BMode::enter(BMode* lastMode)
{
   lastMode;
   
   gRenderThread.blockUntilGPUIdle();
}

//==============================================================================
// BMode::leave
//==============================================================================
void BMode::leave(BMode* newMode)
{
   newMode;
         
   gRenderThread.blockUntilGPUIdle();
}

//==============================================================================
// BMode::postLeave
//==============================================================================
void BMode::postLeave(BMode* newMode)
{
   newMode;
}


//==============================================================================
// BMode::update
//==============================================================================
void BMode::update()
{
}

//==============================================================================
// BMode::frameStart
//==============================================================================
void BMode::frameStart()
{
}

//==============================================================================
// BMode::frameEnd
//==============================================================================
void BMode::frameEnd()
{
}

//==============================================================================
// BMode::renderBegin
//==============================================================================
void BMode::renderBegin()
{
}

//==============================================================================
// BMode::render
//==============================================================================
void BMode::render()
{
}

//==============================================================================
// BMode::renderEnd
//==============================================================================
void BMode::renderEnd()
{
}

//==============================================================================
// BMode::handleInput
//==============================================================================
bool BMode::handleInput(long port, long event, long controlType, BInputEventDetail& detail)
{
   port; event; controlType; detail;
   return false;
}


//==============================================================================
//==============================================================================
void BMode::renderSafeAreas()
{
#ifndef BUILD_FINAL
   if (!gConfig.isDefined(cConfigShowSafeArea))
      return;

   int sx=(int)gUI.mfSafeX1;
   int sy=(int)gUI.mfSafeY1;

   int ex=(int)gUI.mfSafeX2;
   int ey=(int)gUI.mfSafeY2;


   // top
   BPrimDraw2D::drawLine2D(sx, sy, ex, sy, cDWORDWhite);

   // bottom
   BPrimDraw2D::drawLine2D(sx, ey, ex, ey, cDWORDWhite);

   // left
   BPrimDraw2D::drawLine2D(sx, sy, sx, ey, cDWORDWhite);

   // right
   BPrimDraw2D::drawLine2D(ex, sy, ex, ey, cDWORDWhite);
#endif
}

