#pragma once

// Includes
#include "D3D11ProxyDriver.h"
#include "stringutils.h"
#include "d3d11_1.h"


// Defines
#define	D3D11_PROXYDRIVER_DLLNAME	"D3D11ProxyDriver.dll"
#define D3D11_DEVICE_11NULLREF	"d3d11.dll"
#define GDI32_DLLNAME "gdi32.dll"

// Defines
#define DDISETPFN(PFN,TYPE) TYPE PFN(TYPE)
#define STRLENGTH 256

// Enums
enum PROXY_SETUP
{
	PROXY_SETUP_OK,
	PROXY_SETUP_PROXY_DLL_FAILED,
	PROXY_SETUP_DEVICE_DLL_FAILED,
};

enum PROXY_LISTENERS
{
	PROXY_LISTENERS_OK,
	PROXY_LISTENERS_10_DDI_DEVFUNCTS_FAILED,
	PROXY_LISTENERS_10_1_DDI_DEVFUNCTS_FAILED,
	PROXY_LISTENERS_11_DDI_DEVFUNCTS_FAILED,
	PROXY_LISTENERS_11_1_DDI_DEVFUNCTS_FAILED,
	PROXY_LISTENERS_10_DDI_ADAPFUNCTS_FAILED,
	PROXY_LISTENERS_10_2_DDI_ADAPFUNCTS_FAILED,
	PROXY_LISTENERS_DXGI_BASE_CALLBACKS_FAILED,
	PROXY_LISTENERS_DXGI_BASE_FUNCTS_FAILED,
	PROXY_LISTENERS_DXGI_KMTHUNKS_FAILED,
};

// DXGI1_1 DDI typedef's
typedef HRESULT (__stdcall /*APIENTRY*/ *PFNDXGIDDI_PRESENT)(DXGI_DDI_ARG_PRESENT*);
typedef HRESULT (__stdcall /*APIENTRY*/ *PFNDXGIDDI_GETGAMMACAPS)(DXGI_DDI_ARG_GET_GAMMA_CONTROL_CAPS*);
typedef HRESULT (__stdcall /*APIENTRY*/ *PFNDXGIDDI_SETDISPLAYMODE)(DXGI_DDI_ARG_SETDISPLAYMODE*);
typedef HRESULT (__stdcall /*APIENTRY*/ *PFNDXGIDDI_SETRESOURCEPRIORITY)(DXGI_DDI_ARG_SETRESOURCEPRIORITY*);
typedef HRESULT (__stdcall /*APIENTRY*/ *PFNDXGIDDI_QUERYRESOURCERESIDENCY)(DXGI_DDI_ARG_QUERYRESOURCERESIDENCY*);
typedef HRESULT (__stdcall /*APIENTRY*/ *PFNDXGIDDI_ROTATERESOURCEIDENTITIES)(DXGI_DDI_ARG_ROTATE_RESOURCE_IDENTITIES*);
typedef HRESULT (__stdcall /*APIENTRY*/ *PFNDXGIDDI_BLT)(DXGI_DDI_ARG_BLT*);
typedef HRESULT (__stdcall /*APIENTRY*/ *PFNDXGIDDI_RESOLVESHAREDRESOURCE)(DXGI_DDI_ARG_RESOLVESHAREDRESOURCE*);

////////////////////////

class CProxyRef11
{
public:
	CProxyRef11( void );
	~CProxyRef11( void );

	PROXY_SETUP		Setup( tstring d3dProxyDriverDll, tstring d3d11DeviceDLL, 
							   PD_OPENADAPTER10_FP* openAdapterCallback = NULL );
	void			Cleanup( );
	HRESULT			CreateDevice10(ID3D10Device** ppDevice, UINT createDeviceFlags = D3D10_CREATE_DEVICE_SINGLETHREADED);
	HRESULT			CreateDevice10_1(ID3D10Device1** ppDevice, D3D10_FEATURE_LEVEL1 fl = D3D10_FEATURE_LEVEL_10_1, 
		                          UINT createDeviceFlags = D3D10_CREATE_DEVICE_SINGLETHREADED);
	HRESULT			CreateDevice10_1(ID3D10Device1** ppDevice, D3D10_DRIVER_TYPE DriverType, D3D10_FEATURE_LEVEL1 fl = D3D10_FEATURE_LEVEL_10_1, 
		                          UINT createDeviceFlags = D3D10_CREATE_DEVICE_SINGLETHREADED);
	
	// ??? D3D10_CREATE_DEVICE_SINGLETHREADED, 
	HRESULT			CreateDevice11(ID3D11Device** ppDevice, ID3D11DeviceContext** ppContext = NULL, 
		                           D3D_FEATURE_LEVEL fl = D3D_FEATURE_LEVEL_11_0, 
		                           UINT createDeviceFlags = 0);

	HRESULT			CreateDevice11(ID3D11Device** ppDevice, D3D_DRIVER_TYPE DriverType, ID3D11DeviceContext** ppContext = NULL, 
		                           D3D_FEATURE_LEVEL fl = D3D_FEATURE_LEVEL_11_0, 
		                           UINT createDeviceFlags = 0);

	HRESULT			CreateDevice11(ID3D11Device** ppDevice, ID3D11DeviceContext** ppContext = NULL,
									D3D_FEATURE_LEVEL* pFl = NULL, UINT numFeatureLevels = 0,
									D3D_FEATURE_LEVEL* pOutFl = NULL, UINT createDeviceFlags = 0);
	
	eOpenAdapterVersion 	GetOpenAdapterVersionUsed();
	D3D10DDI_HRTDEVICE		GetRealRTDevice();
	HMODULE					GetProxyDriverHandle();
	PROXY_LISTENERS			CaptureDriverListenerFunctions();
	DXGI_DDI_BASE_CALLBACKS* GetDxgiDDICallbacks() { return m_pDXGIDDI_BASECALLBACKS; }

	void			ResetDeviceFunctions();
	void			SetError( HRESULT hr );

protected:
	PROXY_SETUP		LoadProxyDriverDLL( tstring );
	

public:
	// Here are the setter functions for the device function pointers
	void SetOpenAdapterCallback(PD_OPENADAPTER10_FP*);

	DDISETPFN( SetOADDI_CreateDevice, PFND3D10DDI_CREATEDEVICE );
	DDISETPFN( SetOADDI_GetCaps, PFND3D10_2DDI_GETCAPS );
	DDISETPFN( SetOADDI_GetSupportedVersions, PFND3D10_2DDI_GETSUPPORTEDVERSIONS );

	DDISETPFN( SetDDI_ConstantBufferUpdateSubresourceUP, PFND3D10DDI_RESOURCEUPDATESUBRESOURCEUP );
	DDISETPFN( SetDDI_ConstantBufferUpdateSubresourceUP11_1, PFND3D11_1DDI_RESOURCEUPDATESUBRESOURCEUP );

	DDISETPFN( SetDDI_VsSetConstantBuffers, PFND3D10DDI_SETCONSTANTBUFFERS );
	DDISETPFN( SetDDI_VsSetConstantBuffers11_1, PFND3D11_1DDI_SETCONSTANTBUFFERS );

	DDISETPFN( SetDDI_PSSetShaderResources, PFND3D10DDI_SETSHADERRESOURCES );
	DDISETPFN( SetDDI_PsSetShader, PFND3D10DDI_SETSHADER );
	DDISETPFN( SetDDI_PSSetSamplers, PFND3D10DDI_SETSAMPLERS );
	DDISETPFN( SetDDI_VsSetShader, PFND3D10DDI_SETSHADER );
	DDISETPFN( SetDDI_DrawIndexed, PFND3D10DDI_DRAWINDEXED );
	DDISETPFN( SetDDI_Draw, PFND3D10DDI_DRAW );
	DDISETPFN( SetDDI_DynamicIABufferMapNoOverwrite, PFND3D10DDI_RESOURCEMAP );
	DDISETPFN( SetDDI_DynamicIABufferUnmap, PFND3D10DDI_RESOURCEUNMAP );
	DDISETPFN( SetDDI_DynamicConstantBufferMapDiscard, PFND3D10DDI_RESOURCEMAP );
	DDISETPFN( SetDDI_DynamicIABufferMapDiscard, PFND3D10DDI_RESOURCEMAP );
	DDISETPFN( SetDDI_DynamicConstantBufferUnmap, PFND3D10DDI_RESOURCEUNMAP );

	DDISETPFN( SetDDI_PsSetConstantBuffers, PFND3D10DDI_SETCONSTANTBUFFERS );
	DDISETPFN( SetDDI_PsSetConstantBuffers11_1, PFND3D11_1DDI_SETCONSTANTBUFFERS );

	DDISETPFN( SetDDI_IaSetInputLayout, PFND3D10DDI_SETINPUTLAYOUT );
	DDISETPFN( SetDDI_IaSetVertexBuffers, PFND3D10DDI_IA_SETVERTEXBUFFERS );
	DDISETPFN( SetDDI_IaSetIndexBuffer, PFND3D10DDI_IA_SETINDEXBUFFER );

	DDISETPFN( SetDDI_DrawIndexedInstanced, PFND3D10DDI_DRAWINDEXEDINSTANCED );
	DDISETPFN( SetDDI_DrawInstanced, PFND3D10DDI_DRAWINSTANCED );
	DDISETPFN( SetDDI_DynamicResourceMapDiscard, PFND3D10DDI_RESOURCEMAP );
	DDISETPFN( SetDDI_DynamicResourceUnmap, PFND3D10DDI_RESOURCEUNMAP );

	DDISETPFN( SetDDI_GsSetConstantBuffers, PFND3D10DDI_SETCONSTANTBUFFERS );
	DDISETPFN( SetDDI_GsSetConstantBuffers11_1, PFND3D11_1DDI_SETCONSTANTBUFFERS );

	DDISETPFN( SetDDI_GsSetShader, PFND3D10DDI_SETSHADER );
	DDISETPFN( SetDDI_IaSetTopology, PFND3D10DDI_IA_SETTOPOLOGY );
	DDISETPFN( SetDDI_StagingResourceMap, PFND3D10DDI_RESOURCEMAP );
	DDISETPFN( SetDDI_StagingResourceUnmap, PFND3D10DDI_RESOURCEUNMAP );
	DDISETPFN( SetDDI_VSSetShaderResources, PFND3D10DDI_SETSHADERRESOURCES );
	DDISETPFN( SetDDI_VSSetSamplers, PFND3D10DDI_SETSAMPLERS );
	DDISETPFN( SetDDI_GSSetShaderResources, PFND3D10DDI_SETSHADERRESOURCES );

	
	DDISETPFN( SetDDI_GSSetSamplers, PFND3D10DDI_SETSAMPLERS );
    DDISETPFN( SetDDI_SetRenderTargets10, PFND3D10DDI_SETRENDERTARGETS );
    DDISETPFN( SetDDI_SetRenderTargets11, PFND3D11DDI_SETRENDERTARGETS );
	DDISETPFN( SetDDI_ShaderResourceViewReadAfterWriteHazard, PFND3D10DDI_SHADERRESOURCEVIEWREADAFTERWRITEHAZARD);
	DDISETPFN( SetDDI_ResourceReadAfterWriteHazard, PFND3D10DDI_RESOURCEREADAFTERWRITEHAZARD);
	DDISETPFN( SetDDI_SetBlendState, PFND3D10DDI_SETBLENDSTATE);
    DDISETPFN( SetDDI_SetDepthStencilState, PFND3D10DDI_SETDEPTHSTENCILSTATE);
    DDISETPFN( SetDDI_SetRasterizerState, PFND3D10DDI_SETRASTERIZERSTATE);
    DDISETPFN( SetDDI_QueryEnd, PFND3D10DDI_QUERYEND);
    DDISETPFN( SetDDI_QueryBegin, PFND3D10DDI_QUERYBEGIN);

    DDISETPFN( SetDDI_ResourceCopyRegion, PFND3D10DDI_RESOURCECOPYREGION);
	DDISETPFN( SetDDI_ResourceCopyRegion11_1, PFND3D11_1DDI_RESOURCECOPYREGION);

	DDISETPFN( SetDDI_ResourceUpdateSubresourceUP, PFND3D10DDI_RESOURCEUPDATESUBRESOURCEUP);
	DDISETPFN( SetDDI_ResourceUpdateSubresourceUP11_1, PFND3D11_1DDI_RESOURCEUPDATESUBRESOURCEUP);

    DDISETPFN( SetDDI_SOSetTargets, PFND3D10DDI_SO_SETTARGETS);
    DDISETPFN( SetDDI_DrawAuto, PFND3D10DDI_DRAWAUTO);
	DDISETPFN( SetDDI_SetViewports, PFND3D10DDI_SETVIEWPORTS);
	DDISETPFN( SetDDI_SetScissorRects, PFND3D10DDI_SETSCISSORRECTS);
	DDISETPFN( SetDDI_ClearRenderTargetView, PFND3D10DDI_CLEARRENDERTARGETVIEW);
	DDISETPFN( SetDDI_ClearDepthStencilView, PFND3D10DDI_CLEARDEPTHSTENCILVIEW);
    DDISETPFN( SetDDI_SetPredication, PFND3D10DDI_SETPREDICATION);
    DDISETPFN( SetDDI_QueryGetData, PFND3D10DDI_QUERYGETDATA);
    DDISETPFN( SetDDI_Flush, PFND3D10DDI_FLUSH);
    DDISETPFN( SetDDI_Flush11_1, PFND3D11_1DDI_FLUSH);
    DDISETPFN( SetDDI_GenerateMips, PFND3D10DDI_GENMIPS);
	DDISETPFN( SetDDI_ResourceCopy, PFND3D10DDI_RESOURCECOPY);
    DDISETPFN( SetDDI_ResourceResolveSubresource, PFND3D10DDI_RESOURCERESOLVESUBRESOURCE);

	DDISETPFN( SetDDI_ResourceMap, PFND3D10DDI_RESOURCEMAP);
    DDISETPFN( SetDDI_ResourceUnmap, PFND3D10DDI_RESOURCEUNMAP);
	DDISETPFN( SetDDI_ResourceIsStagingBusy, PFND3D10DDI_RESOURCEISSTAGINGBUSY);

	DDISETPFN( SetDDI_RelocateDeviceFuncs11_1, PFND3D11_1DDI_RELOCATEDEVICEFUNCS);
	DDISETPFN( SetDDI_RelocateDeviceFuncs11, PFND3D11DDI_RELOCATEDEVICEFUNCS);
	DDISETPFN( SetDDI_RelocateDeviceFuncs10_1, PFND3D10_1DDI_RELOCATEDEVICEFUNCS);
	DDISETPFN( SetDDI_RelocateDeviceFuncs10, PFND3D10DDI_RELOCATEDEVICEFUNCS);

	DDISETPFN( SetDDI_CalcPrivateResourceSize10, PFND3D10DDI_CALCPRIVATERESOURCESIZE);
	DDISETPFN( SetDDI_CalcPrivateResourceSize11, PFND3D11DDI_CALCPRIVATERESOURCESIZE);
    DDISETPFN( SetDDI_CalcPrivateOpenedResourceSize, PFND3D10DDI_CALCPRIVATEOPENEDRESOURCESIZE); 
	DDISETPFN( SetDDI_CreateResource10, PFND3D10DDI_CREATERESOURCE );
	DDISETPFN( SetDDI_CreateResource11, PFND3D11DDI_CREATERESOURCE );
    DDISETPFN( SetDDI_OpenResource, PFND3D10DDI_OPENRESOURCE);
	DDISETPFN( SetDDI_DestroyResource, PFND3D10DDI_DESTROYRESOURCE);
	DDISETPFN( SetDDI_CalcPrivateShaderResourceViewSize10, PFND3D10DDI_CALCPRIVATESHADERRESOURCEVIEWSIZE);
	DDISETPFN( SetDDI_CalcPrivateShaderResourceViewSize10_1, PFND3D10_1DDI_CALCPRIVATESHADERRESOURCEVIEWSIZE);
	DDISETPFN( SetDDI_CalcPrivateShaderResourceViewSize11, PFND3D11DDI_CALCPRIVATESHADERRESOURCEVIEWSIZE);
	DDISETPFN( SetDDI_CreateShaderResourceView10, PFND3D10DDI_CREATESHADERRESOURCEVIEW); // Check this one
	DDISETPFN( SetDDI_CreateShaderResourceView10_1, PFND3D10_1DDI_CREATESHADERRESOURCEVIEW); // Check this one
	DDISETPFN( SetDDI_CreateShaderResourceView11, PFND3D11DDI_CREATESHADERRESOURCEVIEW); // Check this one
    DDISETPFN( SetDDI_DestroyShaderResourceView, PFND3D10DDI_DESTROYSHADERRESOURCEVIEW);
    DDISETPFN( SetDDI_CalcPrivateRenderTargetViewSize, PFND3D10DDI_CALCPRIVATERENDERTARGETVIEWSIZE);
	DDISETPFN( SetDDI_CreateRenderTargetView, PFND3D10DDI_CREATERENDERTARGETVIEW);
	DDISETPFN( SetDDI_DestroyRenderTargetView, PFND3D10DDI_DESTROYRENDERTARGETVIEW);

	DDISETPFN( SetDDI_CalcPrivateDepthStencilViewSize, PFND3D10DDI_CALCPRIVATEDEPTHSTENCILVIEWSIZE);
	DDISETPFN( SetDDI_CalcPrivateDepthStencilViewSize11, PFND3D11DDI_CALCPRIVATEDEPTHSTENCILVIEWSIZE);

	DDISETPFN( SetDDI_CreateDepthStencilView, PFND3D10DDI_CREATEDEPTHSTENCILVIEW);
	DDISETPFN( SetDDI_CreateDepthStencilView11, PFND3D11DDI_CREATEDEPTHSTENCILVIEW);
	DDISETPFN( SetDDI_DestroyDepthStencilView, PFND3D10DDI_DESTROYDEPTHSTENCILVIEW);
	DDISETPFN( SetDDI_CalcPrivateElementLayoutSize, PFND3D10DDI_CALCPRIVATEELEMENTLAYOUTSIZE);
    DDISETPFN( SetDDI_CreateElementLayout, PFND3D10DDI_CREATEELEMENTLAYOUT);
    DDISETPFN( SetDDI_DestroyElementLayout, PFND3D10DDI_DESTROYELEMENTLAYOUT);

    DDISETPFN( SetDDI_CalcPrivateBlendStateSize10, PFND3D10DDI_CALCPRIVATEBLENDSTATESIZE);
	DDISETPFN( SetDDI_CalcPrivateBlendStateSize10_1, PFND3D10_1DDI_CALCPRIVATEBLENDSTATESIZE);
	DDISETPFN( SetDDI_CalcPrivateBlendStateSize11_1, PFND3D11_1DDI_CALCPRIVATEBLENDSTATESIZE);

    DDISETPFN( SetDDI_CreateBlendState10, PFND3D10DDI_CREATEBLENDSTATE);
	DDISETPFN( SetDDI_CreateBlendState10_1, PFND3D10_1DDI_CREATEBLENDSTATE);
	DDISETPFN( SetDDI_CreateBlendState11_1, PFND3D11_1DDI_CREATEBLENDSTATE);

    DDISETPFN( SetDDI_DestroyBlendState, PFND3D10DDI_DESTROYBLENDSTATE);
    DDISETPFN( SetDDI_CalcPrivateDepthStencilStateSize, PFND3D10DDI_CALCPRIVATEDEPTHSTENCILSTATESIZE);
    DDISETPFN( SetDDI_CreateDepthStencilState, PFND3D10DDI_CREATEDEPTHSTENCILSTATE);
    DDISETPFN( SetDDI_DestroyDepthStencilState, PFND3D10DDI_DESTROYDEPTHSTENCILSTATE);

    DDISETPFN( SetDDI_CalcPrivateRasterizerStateSize, PFND3D10DDI_CALCPRIVATERASTERIZERSTATESIZE);
	DDISETPFN( SetDDI_CalcPrivateRasterizerStateSize11_1, PFND3D11_1DDI_CALCPRIVATERASTERIZERSTATESIZE);

    DDISETPFN( SetDDI_CreateRasterizerState, PFND3D10DDI_CREATERASTERIZERSTATE);
	DDISETPFN( SetDDI_CreateRasterizerState11_1, PFND3D11_1DDI_CREATERASTERIZERSTATE);

    DDISETPFN( SetDDI_DestroyRasterizerState, PFND3D10DDI_DESTROYRASTERIZERSTATE);
    DDISETPFN( SetDDI_CalcPrivateShaderSize, PFND3D10DDI_CALCPRIVATESHADERSIZE);
    DDISETPFN( SetDDI_CalcPrivateShaderSize11_1, PFND3D11_1DDI_CALCPRIVATESHADERSIZE);
    DDISETPFN( SetDDI_CreateVertexShader, PFND3D10DDI_CREATEVERTEXSHADER);
    DDISETPFN( SetDDI_CreateVertexShader11_1, PFND3D11_1DDI_CREATEVERTEXSHADER);
    DDISETPFN( SetDDI_CreateGeometryShader, PFND3D10DDI_CREATEGEOMETRYSHADER);
    DDISETPFN( SetDDI_CreateGeometryShader11_1, PFND3D11_1DDI_CREATEGEOMETRYSHADER);
    DDISETPFN( SetDDI_CreatePixelShader, PFND3D10DDI_CREATEPIXELSHADER);
    DDISETPFN( SetDDI_CreatePixelShader11_1, PFND3D11_1DDI_CREATEPIXELSHADER);
    DDISETPFN( SetDDI_CalcPrivateGeometryShaderWithStreamOutputSize10, PFND3D10DDI_CALCPRIVATEGEOMETRYSHADERWITHSTREAMOUTPUT);
	DDISETPFN( SetDDI_CalcPrivateGeometryShaderWithStreamOutputSize11, PFND3D11DDI_CALCPRIVATEGEOMETRYSHADERWITHSTREAMOUTPUT);
	DDISETPFN( SetDDI_CalcPrivateGeometryShaderWithStreamOutputSize11_1, PFND3D11_1DDI_CALCPRIVATEGEOMETRYSHADERWITHSTREAMOUTPUT);
	DDISETPFN( SetDDI_CreateGeometryShaderWithStreamOutput10, PFND3D10DDI_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT);
    DDISETPFN( SetDDI_CreateGeometryShaderWithStreamOutput11, PFND3D11DDI_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT);
    DDISETPFN( SetDDI_CreateGeometryShaderWithStreamOutput11_1, PFND3D11_1DDI_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT);
    DDISETPFN( SetDDI_DestroyShader, PFND3D10DDI_DESTROYSHADER);
    DDISETPFN( SetDDI_CalcPrivateSamplerSize, PFND3D10DDI_CALCPRIVATESAMPLERSIZE);
    DDISETPFN( SetDDI_CreateSampler, PFND3D10DDI_CREATESAMPLER);
    DDISETPFN( SetDDI_DestroySampler, PFND3D10DDI_DESTROYSAMPLER);
    DDISETPFN( SetDDI_CalcPrivateQuerySize, PFND3D10DDI_CALCPRIVATEQUERYSIZE);
    DDISETPFN( SetDDI_CreateQuery, PFND3D10DDI_CREATEQUERY);
    DDISETPFN( SetDDI_DestroyQuery, PFND3D10DDI_DESTROYQUERY);

    DDISETPFN( SetDDI_CheckFormatSupport, PFND3D10DDI_CHECKFORMATSUPPORT);
    DDISETPFN( SetDDI_CheckMultisampleQualityLevels, PFND3D10DDI_CHECKMULTISAMPLEQUALITYLEVELS);
    DDISETPFN( SetDDI_CheckCounterInfo, PFND3D10DDI_CHECKCOUNTERINFO);
    DDISETPFN( SetDDI_CheckCounter, PFND3D10DDI_CHECKCOUNTER);

	DDISETPFN( SetDDI_DestroyDevice, PFND3D10DDI_DESTROYDEVICE);
    DDISETPFN( SetDDI_SetTextFilter, PFND3D10DDI_SETTEXTFILTERSIZE);

	DDISETPFN( SetDDI_ResourceConvert, PFND3D10DDI_RESOURCECOPY);

	DDISETPFN( SetDDI_ResourceConvertRegion, PFND3D10DDI_RESOURCECOPYREGION);
	DDISETPFN( SetDDI_ResourceConvertRegion11_1, PFND3D11_1DDI_RESOURCECOPYREGION);

#if !defined( REF10_LDK_BUILD )
#ifdef D3D10PSGP
	DDISETPFN( SetDDI_IaResetPrimitiveID, PFND3D10DDI_RESETPRIMITIVEID);
	DDISETPFN( SetDDI_IaSetVertexPipelineOutput, PFND3D10DDI_SETVERTEXPIPELINEOUTPUT);
#endif
#endif

	DDISETPFN( SetDDI_DrawIndexedInstancedIndirect, PFND3D11DDI_DRAWINDEXEDINSTANCEDINDIRECT);
	DDISETPFN( SetDDI_DrawInstancedIndirect, PFND3D11DDI_DRAWINSTANCEDINDIRECT);
	DDISETPFN( SetDDI_CommandListExecute, PFND3D11DDI_COMMANDLISTEXECUTE);
	DDISETPFN( SetDDI_CheckDeferredContextHandleSizes, PFND3D11DDI_CHECKDEFERREDCONTEXTHANDLESIZES);
	DDISETPFN( SetDDI_CalcDeferredContextHandleSize, PFND3D11DDI_CALCDEFERREDCONTEXTHANDLESIZE);
	DDISETPFN( SetDDI_CalcPrivateCommandListSize, PFND3D11DDI_CALCPRIVATECOMMANDLISTSIZE);
	DDISETPFN( SetDDI_CreateCommandList, PFND3D11DDI_CREATECOMMANDLIST);
	DDISETPFN( SetDDI_DestroyCommandList, PFND3D11DDI_DESTROYCOMMANDLIST);
	DDISETPFN( SetDDI_HsSetShaderResources, PFND3D10DDI_SETSHADERRESOURCES);
	DDISETPFN( SetDDI_HsSetShader, PFND3D10DDI_SETSHADER);
	DDISETPFN( SetDDI_HsSetSamplers, PFND3D10DDI_SETSAMPLERS);

	DDISETPFN( SetDDI_HsSetConstantBuffers, PFND3D10DDI_SETCONSTANTBUFFERS);
	DDISETPFN( SetDDI_HsSetConstantBuffers11_1, PFND3D11_1DDI_SETCONSTANTBUFFERS);

	DDISETPFN( SetDDI_DsSetShaderResources, PFND3D10DDI_SETSHADERRESOURCES);
	DDISETPFN( SetDDI_DsSetShader, PFND3D10DDI_SETSHADER);
	DDISETPFN( SetDDI_DsSetSamplers, PFND3D10DDI_SETSAMPLERS);

	DDISETPFN( SetDDI_DsSetConstantBuffers, PFND3D10DDI_SETCONSTANTBUFFERS);
	DDISETPFN( SetDDI_DsSetConstantBuffers11_1, PFND3D11_1DDI_SETCONSTANTBUFFERS);

	DDISETPFN( SetDDI_CreateHullShader, PFND3D11DDI_CREATEHULLSHADER);
	DDISETPFN( SetDDI_CreateHullShader11_1, PFND3D11_1DDI_CREATEHULLSHADER);
	DDISETPFN( SetDDI_CreateDomainShader, PFND3D11DDI_CREATEDOMAINSHADER);
	DDISETPFN( SetDDI_CreateDomainShader11_1, PFND3D11_1DDI_CREATEDOMAINSHADER);
	DDISETPFN( SetDDI_PsSetShaderWithIfaces, PFND3D11DDI_SETSHADER_WITH_IFACES);
	DDISETPFN( SetDDI_VsSetShaderWithIfaces, PFND3D11DDI_SETSHADER_WITH_IFACES);
	DDISETPFN( SetDDI_GsSetShaderWithIfaces, PFND3D11DDI_SETSHADER_WITH_IFACES);
	DDISETPFN( SetDDI_HsSetShaderWithIfaces, PFND3D11DDI_SETSHADER_WITH_IFACES);
	DDISETPFN( SetDDI_DsSetShaderWithIfaces, PFND3D11DDI_SETSHADER_WITH_IFACES);
	DDISETPFN( SetDDI_CsSetShaderWithIfaces, PFND3D11DDI_SETSHADER_WITH_IFACES);
	DDISETPFN( SetDDI_CreateComputeShader, PFND3D11DDI_CREATECOMPUTESHADER);
	DDISETPFN( SetDDI_CsSetShaderResources, PFND3D10DDI_SETSHADERRESOURCES);
	DDISETPFN( SetDDI_CsSetShader, PFND3D10DDI_SETSHADER);
	DDISETPFN( SetDDI_CsSetSamplers, PFND3D10DDI_SETSAMPLERS);

	DDISETPFN( SetDDI_CsSetConstantBuffers, PFND3D10DDI_SETCONSTANTBUFFERS);
	DDISETPFN( SetDDI_CsSetConstantBuffers11_1, PFND3D11_1DDI_SETCONSTANTBUFFERS);

    DDISETPFN( SetDDI_CalcPrivateUnorderedAccessViewSize, PFND3D11DDI_CALCPRIVATEUNORDEREDACCESSVIEWSIZE);
	DDISETPFN( SetDDI_CreateUnorderedAccessView, PFND3D11DDI_CREATEUNORDEREDACCESSVIEW);
	DDISETPFN( SetDDI_DestroyUnorderedAccessView, PFND3D11DDI_DESTROYUNORDEREDACCESSVIEW);
	DDISETPFN( SetDDI_ClearUnorderedAccessViewUint, PFND3D11DDI_CLEARUNORDEREDACCESSVIEWUINT);
	DDISETPFN( SetDDI_ClearUnorderedAccessViewFloat, PFND3D11DDI_CLEARUNORDEREDACCESSVIEWFLOAT);
	DDISETPFN( SetDDI_CsSetUnorderedAccessViews, PFND3D11DDI_SETUNORDEREDACCESSVIEWS);
	DDISETPFN( SetDDI_Dispatch, PFND3D11DDI_DISPATCH);
	DDISETPFN( SetDDI_DispatchIndirect, PFND3D11DDI_DISPATCHINDIRECT);
	DDISETPFN( SetDDI_SetResourceMinLOD, PFND3D11DDI_SETRESOURCEMINLOD);
	DDISETPFN( SetDDI_CopyStructureCount, PFND3D11DDI_COPYSTRUCTURECOUNT);

	DDISETPFN( SetDDI_RecycleCommandList, PFND3D11DDI_RECYCLECOMMANDLIST );    
	DDISETPFN( SetDDI_RecycleCreateCommandList, PFND3D11DDI_RECYCLECREATECOMMANDLIST );    
	DDISETPFN( SetDDI_RecycleCreateDeferredContext, PFND3D11DDI_RECYCLECREATEDEFERREDCONTEXT );   
	DDISETPFN( SetDDI_RecycleDestroyCommandList, PFND3D11DDI_DESTROYCOMMANDLIST );

	DDISETPFN( SetDDI_Discard, PFND3D11_1DDI_DISCARD );
	DDISETPFN( SetDDI_AssignDebugBinary, PFND3D11_1DDI_ASSIGNDEBUGBINARY );
	DDISETPFN( SetDDI_DynamicConstantBufferMapNoOverwrite, PFND3D10DDI_RESOURCEMAP );

    DDISETPFN( SetDDI_CheckDirectFlipSupport, PFND3D11_1DDI_CHECKDIRECTFLIPSUPPORT );
    DDISETPFN( SetDDI_ClearView, PFND3D11_1DDI_CLEARVIEW );

	// Dxgi UMD DDI's
	DDISETPFN( SetDXGIDDI_PresentCb, PFNDDXGIDDI_PRESENTCB );    

	// Dxgi UMD DDI's
	DDISETPFN( SetDXGIDDI_Present, PFNDXGIDDI_PRESENT );    
	DDISETPFN( SetDXGIDDI_GetGammaCaps, PFNDXGIDDI_GETGAMMACAPS );    
	DDISETPFN( SetDXGIDDI_SetDisplayMode, PFNDXGIDDI_SETDISPLAYMODE );    
	DDISETPFN( SetDXGIDDI_SetResourcePriority, PFNDXGIDDI_SETRESOURCEPRIORITY );    
	DDISETPFN( SetDXGIDDI_QueryResourceResidency, PFNDXGIDDI_QUERYRESOURCERESIDENCY );    
	DDISETPFN( SetDXGIDDI_RotateResourceIdentities, PFNDXGIDDI_ROTATERESOURCEIDENTITIES );    
	DDISETPFN( SetDXGIDDI_Blt, PFNDXGIDDI_BLT );    
	DDISETPFN( SetDXGIDDI_ResolveSharedResource, PFNDXGIDDI_RESOLVESHAREDRESOURCE );    

	//PFND3DKMT_OPENADAPTERFROMGDIDISPLAYNAME SetDXGIKMT_OpenAdapterFromGdiDisplayName( PFND3DKMT_OPENADAPTERFROMGDIDISPLAYNAME pThunks );
	DDISETPFN( SetDXGIKMT_OpenAdapterFromGdiDisplayName, PFND3DKMT_OPENADAPTERFROMGDIDISPLAYNAME );    
	DDISETPFN( SetDXGIKMT_OpenAdapterFromDeviceName, PFND3DKMT_OPENADAPTERFROMDEVICENAME );    
	DDISETPFN( SetDXGIKMT_GetDisplayModeList, PFND3DKMT_GETDISPLAYMODELIST );    
	DDISETPFN( SetDXGIKMT_SetVIDPnSourceOwner, PFND3DKMT_SETVIDPNSOURCEOWNER );    
	DDISETPFN( SetDXGIKMT_SetDisplayMode, PFND3DKMT_SETDISPLAYMODE );    
	DDISETPFN( SetDXGIKMT_CloseAdapter, PFND3DKMT_CLOSEADAPTER );    
	DDISETPFN( SetDXGIKMT_SetGammaRamp, PFND3DKMT_SETGAMMARAMP );    
	DDISETPFN( SetDXGIKMT_GetDeviceState, PFND3DKMT_GETDEVICESTATE );    
	DDISETPFN( SetDXGIKMT_QueryAdapterInfo, PFND3DKMT_QUERYADAPTERINFO );    
	DDISETPFN( SetDXGIKMT_WaitForVerticalBlankEvent, PFND3DKMT_WAITFORVERTICALBLANKEVENT );    


private:
	template <typename _T> _T SetDDIHelper(_T callBackFn, _T* pfn10, _T* pfn10_1, _T* pfn11, _T* pfn11_1);
	template <typename _T> _T SetOADDIHelper(_T callBackFn, _T* pfn10, _T* pfn10_2);
	template <typename _T> _T SetDXGIDDIHelper(_T callBackFn, _T* pfnDxgi);

	PD_GET_DEVICE_DLL_FP PD_GetDeviceDLL;
	PD_GET_THUNK_DLL_FP PD_GetThunkDLL;
	PD_GET_DEVICE_VERSION_FP PD_GetDeviceVersion;
	PD_GET_OPEN_ADAPTER_VERSION_FP PD_GetOpenAdapterVersion;
	PD_GET_RT_DEVICE_FP PD_GetRuntimeDevice;
	PD_SET_ERROR_CB_FP PD_SetErrorCb;
	PD_RESET_RUNTIME_FUNCS_FP PD_ResetRuntimeFunctions;

	HMODULE			m_hD3DProxyDLL;	// This is the handle to the proxy driver dll
	PROXY_SETUP		m_proxySetup;
	UINT			m_deviceVersion;
	char			m_dllName[STRLENGTH];
	char			m_thunkDllName[STRLENGTH];

	D3D10_1DDI_DEVICEFUNCS*  m_pD3D10_1DDI_DEVFUNCS;
	D3D10DDI_DEVICEFUNCS*    m_pD3D10DDI_DEVFUNCS;
	D3D11DDI_DEVICEFUNCS*    m_pD3D11DDI_DEVFUNCS;
	D3D11_1DDI_DEVICEFUNCS*  m_pD3D11_1DDI_DEVFUNCS;
	D3D10_2DDI_ADAPTERFUNCS* m_pD3D10_2DDI_ADAPTERFUNCS;
	D3D10DDI_ADAPTERFUNCS*   m_pD3D10DDI_ADAPTERFUNCS;
	DXGI_DDI_BASE_CALLBACKS* m_pDXGIDDI_BASECALLBACKS;
	DXGI1_1_DDI_BASE_FUNCTIONS*	m_pDXGI11DDI_BASEFUNCS;
	DXGI_KMTHUNKS* m_pDXGI_KMTHUNKS;
};
