//*****************************************************************************
//***                        THIS FILE IS GENERATED                        ****
//***                       DO NOT MODIFY THIS FILE !!!                    ****
//*****************************************************************************
//*****************************************************************************
//* File: D3DWrappedTypes.h
//* 
//* Description: 
//*     Types used by D3D wrapper classes.
//*
//*****************************************************************************

// Ignore Prefast warnings 26060 (Range Precondition violation) and 28930 (Unused assignment of pointer variable)
#pragma warning( disable: 26060 )
#pragma warning( disable: 28930 )

#pragma once


////////////////////////////////////////////////////////////
//
// Wrapper types
//
////////////////////////////////////////////////////////////

#include <windows.h>
#include <dxgi.h>
#include "NResult.h"
#include <d3dcommon.h>
#include <GraphicsTest.h>
enum WrapperException
{
    WRAPPER_METHOD_UNSUPPORTED,
    WRAPPER_DOWNLEVEL_CONVERSION_UNSUPPORTED,
    WRAPPER_UPLEVEL_CONVERSION_UNSUPPORTED,
    WRAPPER_OUT_OF_MEMORY,
};


////////////////////////////////////////////////////////////
//
// Forward Declarations
//
////////////////////////////////////////////////////////////

struct ID3D10DeviceChild;
struct ID3D11DeviceChild;
class CDeviceChild;
class CMultiDeviceChild;
class C10DeviceChild;
struct ID3D10DepthStencilState;
struct ID3D11DepthStencilState;
class CDepthStencilState;
class CMultiDepthStencilState;
class C10DepthStencilState;
struct ID3D10BlendState;
struct ID3D11BlendState;
class CBlendState;
class CMultiBlendState;
class C10BlendState;
struct ID3D10RasterizerState;
struct ID3D11RasterizerState;
class CRasterizerState;
class CMultiRasterizerState;
class C10RasterizerState;
struct ID3D10Resource;
struct ID3D11Resource;
class CResource;
class CMultiResource;
class C10Resource;
struct ID3D10Buffer;
struct ID3D11Buffer;
class CBuffer;
class CMultiBuffer;
class C10Buffer;
struct ID3D10Texture1D;
struct ID3D11Texture1D;
class CTexture1D;
class CMultiTexture1D;
class C10Texture1D;
struct ID3D10Texture2D;
struct ID3D11Texture2D;
class CTexture2D;
class CMultiTexture2D;
class C10Texture2D;
struct ID3D10Texture3D;
struct ID3D11Texture3D;
class CTexture3D;
class CMultiTexture3D;
class C10Texture3D;
struct ID3D10View;
struct ID3D11View;
class CView;
class CMultiView;
class C10View;
struct ID3D10ShaderResourceView;
struct ID3D11ShaderResourceView;
class CShaderResourceView;
class CMultiShaderResourceView;
class C10ShaderResourceView;
struct ID3D10RenderTargetView;
struct ID3D11RenderTargetView;
class CRenderTargetView;
class CMultiRenderTargetView;
class C10RenderTargetView;
struct ID3D10DepthStencilView;
struct ID3D11DepthStencilView;
class CDepthStencilView;
class CMultiDepthStencilView;
class C10DepthStencilView;
struct ID3D10VertexShader;
struct ID3D11VertexShader;
class CVertexShader;
class CMultiVertexShader;
class C10VertexShader;
struct ID3D10GeometryShader;
struct ID3D11GeometryShader;
class CGeometryShader;
class CMultiGeometryShader;
class C10GeometryShader;
struct ID3D10PixelShader;
struct ID3D11PixelShader;
class CPixelShader;
class CMultiPixelShader;
class C10PixelShader;
struct ID3D10InputLayout;
struct ID3D11InputLayout;
class CInputLayout;
class CMultiInputLayout;
class C10InputLayout;
struct ID3D10SamplerState;
struct ID3D11SamplerState;
class CSamplerState;
class CMultiSamplerState;
class C10SamplerState;
struct ID3D10Asynchronous;
struct ID3D11Asynchronous;
class CAsynchronous;
class CMultiAsynchronous;
class C10Asynchronous;
struct ID3D10Query;
struct ID3D11Query;
class CQuery;
class CMultiQuery;
class C10Query;
struct ID3D10Predicate;
struct ID3D11Predicate;
class CPredicate;
class CMultiPredicate;
class C10Predicate;
struct ID3D10Counter;
struct ID3D11Counter;
class CCounter;
class CMultiCounter;
class C10Counter;
struct ID3D10Device;
struct ID3D11Device;
class CDevice;
class CMultiDevice;
class C10Device;
struct ID3D10Multithread;
class CMultithread;
class CMultiMultithread;
class C10Multithread;
struct ID3D10Debug;
struct ID3D11Debug;
class CDebug;
class CMultiDebug;
class C10Debug;
struct ID3D10SwitchToRef;
struct ID3D11SwitchToRef;
class CSwitchToRef;
class CMultiSwitchToRef;
class C10SwitchToRef;
struct ID3D10InfoQueue;
struct ID3D11InfoQueue;
class CInfoQueue;
class CMultiInfoQueue;
class C10InfoQueue;
struct ID3D10Blob;
struct ID3D11Blob;
class CBlob;
class CMultiBlob;
class C10Blob;
struct ID3D10BlendState1;
class CBlendState1;
class CMultiBlendState1;
class C10BlendState1;
struct ID3D10ShaderResourceView1;
class CShaderResourceView1;
class CMultiShaderResourceView1;
class C10ShaderResourceView1;
struct ID3D10Device1;
class C10Device1;


////////////////////////////////////////////////////////////
//
// Enum Declarations
//
////////////////////////////////////////////////////////////



////////////////////////////////////////////////////////////
// D3D_INPUT_CLASSIFICATION
////////////////////////////////////////////////////////////
enum D3D_INPUT_CLASSIFICATION
{
    D3D_INPUT_PER_VERTEX_DATA = 0,
    D3D_INPUT_PER_INSTANCE_DATA = 1,
};


////////////////////////////////////////////////////////////
// D3D_FILL_MODE
////////////////////////////////////////////////////////////
enum D3D_FILL_MODE
{
    D3D_FILL_WIREFRAME = 2,
    D3D_FILL_SOLID = 3,
};


////////////////////////////////////////////////////////////
// D3D_CULL_MODE
////////////////////////////////////////////////////////////
enum D3D_CULL_MODE
{
    D3D_CULL_NONE = 1,
    D3D_CULL_FRONT = 2,
    D3D_CULL_BACK = 3,
};


////////////////////////////////////////////////////////////
// D3D_RESOURCE_DIMENSION
////////////////////////////////////////////////////////////
enum D3D_RESOURCE_DIMENSION
{
    D3D_RESOURCE_DIMENSION_UNKNOWN = 0,
    D3D_RESOURCE_DIMENSION_BUFFER = 1,
    D3D_RESOURCE_DIMENSION_TEXTURE1D = 2,
    D3D_RESOURCE_DIMENSION_TEXTURE2D = 3,
    D3D_RESOURCE_DIMENSION_TEXTURE3D = 4,
};


////////////////////////////////////////////////////////////
// D3D_DSV_DIMENSION
////////////////////////////////////////////////////////////
enum D3D_DSV_DIMENSION
{
    D3D_DSV_DIMENSION_UNKNOWN = 0,
    D3D_DSV_DIMENSION_TEXTURE1D = 1,
    D3D_DSV_DIMENSION_TEXTURE1DARRAY = 2,
    D3D_DSV_DIMENSION_TEXTURE2D = 3,
    D3D_DSV_DIMENSION_TEXTURE2DARRAY = 4,
    D3D_DSV_DIMENSION_TEXTURE2DMS = 5,
    D3D_DSV_DIMENSION_TEXTURE2DMSARRAY = 6,
};


////////////////////////////////////////////////////////////
// D3D_RTV_DIMENSION
////////////////////////////////////////////////////////////
enum D3D_RTV_DIMENSION
{
    D3D_RTV_DIMENSION_UNKNOWN = 0,
    D3D_RTV_DIMENSION_BUFFER = 1,
    D3D_RTV_DIMENSION_TEXTURE1D = 2,
    D3D_RTV_DIMENSION_TEXTURE1DARRAY = 3,
    D3D_RTV_DIMENSION_TEXTURE2D = 4,
    D3D_RTV_DIMENSION_TEXTURE2DARRAY = 5,
    D3D_RTV_DIMENSION_TEXTURE2DMS = 6,
    D3D_RTV_DIMENSION_TEXTURE2DMSARRAY = 7,
    D3D_RTV_DIMENSION_TEXTURE3D = 8,
};


////////////////////////////////////////////////////////////
// D3D_USAGE
////////////////////////////////////////////////////////////
enum D3D_USAGE
{
    D3D_USAGE_DEFAULT = 0,
    D3D_USAGE_IMMUTABLE = 1,
    D3D_USAGE_DYNAMIC = 2,
    D3D_USAGE_STAGING = 3,
};


////////////////////////////////////////////////////////////
// D3D_BIND_FLAG
////////////////////////////////////////////////////////////
enum D3D_BIND_FLAG
{
    D3D_BIND_VERTEX_BUFFER = 0x1L,
    D3D_BIND_INDEX_BUFFER = 0x2L,
    D3D_BIND_CONSTANT_BUFFER = 0x4L,
    D3D_BIND_SHADER_RESOURCE = 0x8L,
    D3D_BIND_STREAM_OUTPUT = 0x10L,
    D3D_BIND_RENDER_TARGET = 0x20L,
    D3D_BIND_DEPTH_STENCIL = 0x40L,
};


////////////////////////////////////////////////////////////
// D3D_CPU_ACCESS_FLAG
////////////////////////////////////////////////////////////
enum D3D_CPU_ACCESS_FLAG
{
    D3D_CPU_ACCESS_WRITE = 0x10000L,
    D3D_CPU_ACCESS_READ = 0x20000L,
};


////////////////////////////////////////////////////////////
// D3D_RESOURCE_MISC_FLAG
////////////////////////////////////////////////////////////
enum D3D_RESOURCE_MISC_FLAG
{
    D3D_RESOURCE_MISC_GENERATE_MIPS = 0x1L,
    D3D_RESOURCE_MISC_SHARED = 0x2L,
    D3D_RESOURCE_MISC_TEXTURECUBE = 0x4L,
    D3D_RESOURCE_MISC_SHARED_KEYEDMUTEX = 0x10L,
    D3D_RESOURCE_MISC_GDI_COMPATIBLE = 0x20L,
    D3D_RESOURCE_MISC_HW_PROTECTED = 0x40L,
};


////////////////////////////////////////////////////////////
// D3D_MAP
////////////////////////////////////////////////////////////
enum D3D_MAP
{
    D3D_MAP_READ = 1,
    D3D_MAP_WRITE = 2,
    D3D_MAP_READ_WRITE = 3,
    D3D_MAP_WRITE_DISCARD = 4,
    D3D_MAP_WRITE_NO_OVERWRITE = 5,
};


////////////////////////////////////////////////////////////
// D3D_MAP_FLAG
////////////////////////////////////////////////////////////
enum D3D_MAP_FLAG
{
    D3D_MAP_FLAG_DO_NOT_WAIT = 0x100000L,
};


////////////////////////////////////////////////////////////
// D3D_RAISE_FLAG
////////////////////////////////////////////////////////////
enum D3D_RAISE_FLAG
{
    D3D_RAISE_FLAG_DRIVER_INTERNAL_ERROR = 0x1L,
};


////////////////////////////////////////////////////////////
// D3D_CLEAR_FLAG
////////////////////////////////////////////////////////////
enum D3D_CLEAR_FLAG
{
    D3D_CLEAR_DEPTH = 0x1L,
    D3D_CLEAR_STENCIL = 0x2L,
};


////////////////////////////////////////////////////////////
// D3D_COMPARISON_FUNC
////////////////////////////////////////////////////////////
enum D3D_COMPARISON_FUNC
{
    D3D_COMPARISON_NEVER = 1,
    D3D_COMPARISON_LESS = 2,
    D3D_COMPARISON_EQUAL = 3,
    D3D_COMPARISON_LESS_EQUAL = 4,
    D3D_COMPARISON_GREATER = 5,
    D3D_COMPARISON_NOT_EQUAL = 6,
    D3D_COMPARISON_GREATER_EQUAL = 7,
    D3D_COMPARISON_ALWAYS = 8,
};


////////////////////////////////////////////////////////////
// D3D_DEPTH_WRITE_MASK
////////////////////////////////////////////////////////////
enum D3D_DEPTH_WRITE_MASK
{
    D3D_DEPTH_WRITE_MASK_ZERO = 0,
    D3D_DEPTH_WRITE_MASK_ALL = 1,
};


////////////////////////////////////////////////////////////
// D3D_STENCIL_OP
////////////////////////////////////////////////////////////
enum D3D_STENCIL_OP
{
    D3D_STENCIL_OP_KEEP = 1,
    D3D_STENCIL_OP_ZERO = 2,
    D3D_STENCIL_OP_REPLACE = 3,
    D3D_STENCIL_OP_INCR_SAT = 4,
    D3D_STENCIL_OP_DECR_SAT = 5,
    D3D_STENCIL_OP_INVERT = 6,
    D3D_STENCIL_OP_INCR = 7,
    D3D_STENCIL_OP_DECR = 8,
};


////////////////////////////////////////////////////////////
// D3D_BLEND
////////////////////////////////////////////////////////////
enum D3D_BLEND
{
    D3D_BLEND_ZERO = 1,
    D3D_BLEND_ONE = 2,
    D3D_BLEND_SRC_COLOR = 3,
    D3D_BLEND_INV_SRC_COLOR = 4,
    D3D_BLEND_SRC_ALPHA = 5,
    D3D_BLEND_INV_SRC_ALPHA = 6,
    D3D_BLEND_DEST_ALPHA = 7,
    D3D_BLEND_INV_DEST_ALPHA = 8,
    D3D_BLEND_DEST_COLOR = 9,
    D3D_BLEND_INV_DEST_COLOR = 10,
    D3D_BLEND_SRC_ALPHA_SAT = 11,
    D3D_BLEND_BLEND_FACTOR = 14,
    D3D_BLEND_INV_BLEND_FACTOR = 15,
    D3D_BLEND_SRC1_COLOR = 16,
    D3D_BLEND_INV_SRC1_COLOR = 17,
    D3D_BLEND_SRC1_ALPHA = 18,
    D3D_BLEND_INV_SRC1_ALPHA = 19,
};


////////////////////////////////////////////////////////////
// D3D_BLEND_OP
////////////////////////////////////////////////////////////
enum D3D_BLEND_OP
{
    D3D_BLEND_OP_ADD = 1,
    D3D_BLEND_OP_SUBTRACT = 2,
    D3D_BLEND_OP_REV_SUBTRACT = 3,
    D3D_BLEND_OP_MIN = 4,
    D3D_BLEND_OP_MAX = 5,
};


////////////////////////////////////////////////////////////
// D3D_COLOR_WRITE_ENABLE
////////////////////////////////////////////////////////////
enum D3D_COLOR_WRITE_ENABLE
{
    D3D_COLOR_WRITE_ENABLE_RED = 1,
    D3D_COLOR_WRITE_ENABLE_GREEN = 2,
    D3D_COLOR_WRITE_ENABLE_BLUE = 4,
    D3D_COLOR_WRITE_ENABLE_ALPHA = 8,
    D3D_COLOR_WRITE_ENABLE_ALL = ( ( ( D3D_COLOR_WRITE_ENABLE_RED | D3D_COLOR_WRITE_ENABLE_GREEN )  | D3D_COLOR_WRITE_ENABLE_BLUE )  | D3D_COLOR_WRITE_ENABLE_ALPHA ),
};


////////////////////////////////////////////////////////////
// D3D_TEXTURECUBE_FACE
////////////////////////////////////////////////////////////
enum D3D_TEXTURECUBE_FACE
{
    D3D_TEXTURECUBE_FACE_POSITIVE_X = 0,
    D3D_TEXTURECUBE_FACE_NEGATIVE_X = 1,
    D3D_TEXTURECUBE_FACE_POSITIVE_Y = 2,
    D3D_TEXTURECUBE_FACE_NEGATIVE_Y = 3,
    D3D_TEXTURECUBE_FACE_POSITIVE_Z = 4,
    D3D_TEXTURECUBE_FACE_NEGATIVE_Z = 5,
};


////////////////////////////////////////////////////////////
// D3D_FILTER
////////////////////////////////////////////////////////////
enum D3D_FILTER
{
    D3D_FILTER_MIN_MAG_MIP_POINT = 0,
    D3D_FILTER_MIN_MAG_POINT_MIP_LINEAR = 0x1,
    D3D_FILTER_MIN_POINT_MAG_LINEAR_MIP_POINT = 0x4,
    D3D_FILTER_MIN_POINT_MAG_MIP_LINEAR = 0x5,
    D3D_FILTER_MIN_LINEAR_MAG_MIP_POINT = 0x10,
    D3D_FILTER_MIN_LINEAR_MAG_POINT_MIP_LINEAR = 0x11,
    D3D_FILTER_MIN_MAG_LINEAR_MIP_POINT = 0x14,
    D3D_FILTER_MIN_MAG_MIP_LINEAR = 0x15,
    D3D_FILTER_ANISOTROPIC = 0x55,
    D3D_FILTER_COMPARISON_MIN_MAG_MIP_POINT = 0x80,
    D3D_FILTER_COMPARISON_MIN_MAG_POINT_MIP_LINEAR = 0x81,
    D3D_FILTER_COMPARISON_MIN_POINT_MAG_LINEAR_MIP_POINT = 0x84,
    D3D_FILTER_COMPARISON_MIN_POINT_MAG_MIP_LINEAR = 0x85,
    D3D_FILTER_COMPARISON_MIN_LINEAR_MAG_MIP_POINT = 0x90,
    D3D_FILTER_COMPARISON_MIN_LINEAR_MAG_POINT_MIP_LINEAR = 0x91,
    D3D_FILTER_COMPARISON_MIN_MAG_LINEAR_MIP_POINT = 0x94,
    D3D_FILTER_COMPARISON_MIN_MAG_MIP_LINEAR = 0x95,
    D3D_FILTER_COMPARISON_ANISOTROPIC = 0xd5,
    D3D_FILTER_TEXT_1BIT = 0x80000000,
};


////////////////////////////////////////////////////////////
// D3D_FILTER_TYPE
////////////////////////////////////////////////////////////
enum D3D_FILTER_TYPE
{
    D3D_FILTER_TYPE_POINT = 0,
    D3D_FILTER_TYPE_LINEAR = 1,
};


////////////////////////////////////////////////////////////
// D3D_TEXTURE_ADDRESS_MODE
////////////////////////////////////////////////////////////
enum D3D_TEXTURE_ADDRESS_MODE
{
    D3D_TEXTURE_ADDRESS_WRAP = 1,
    D3D_TEXTURE_ADDRESS_MIRROR = 2,
    D3D_TEXTURE_ADDRESS_CLAMP = 3,
    D3D_TEXTURE_ADDRESS_BORDER = 4,
    D3D_TEXTURE_ADDRESS_MIRROR_ONCE = 5,
};


////////////////////////////////////////////////////////////
// D3D_FORMAT_SUPPORT
////////////////////////////////////////////////////////////
enum D3D_FORMAT_SUPPORT
{
    D3D_FORMAT_SUPPORT_BUFFER = 0x1,
    D3D_FORMAT_SUPPORT_IA_VERTEX_BUFFER = 0x2,
    D3D_FORMAT_SUPPORT_IA_INDEX_BUFFER = 0x4,
    D3D_FORMAT_SUPPORT_SO_BUFFER = 0x8,
    D3D_FORMAT_SUPPORT_TEXTURE1D = 0x10,
    D3D_FORMAT_SUPPORT_TEXTURE2D = 0x20,
    D3D_FORMAT_SUPPORT_TEXTURE3D = 0x40,
    D3D_FORMAT_SUPPORT_TEXTURECUBE = 0x80,
    D3D_FORMAT_SUPPORT_SHADER_LOAD = 0x100,
    D3D_FORMAT_SUPPORT_SHADER_SAMPLE = 0x200,
    D3D_FORMAT_SUPPORT_SHADER_SAMPLE_COMPARISON = 0x400,
    D3D_FORMAT_SUPPORT_SHADER_SAMPLE_MONO_TEXT = 0x800,
    D3D_FORMAT_SUPPORT_MIP = 0x1000,
    D3D_FORMAT_SUPPORT_MIP_AUTOGEN = 0x2000,
    D3D_FORMAT_SUPPORT_RENDER_TARGET = 0x4000,
    D3D_FORMAT_SUPPORT_BLENDABLE = 0x8000,
    D3D_FORMAT_SUPPORT_DEPTH_STENCIL = 0x10000,
    D3D_FORMAT_SUPPORT_CPU_LOCKABLE = 0x20000,
    D3D_FORMAT_SUPPORT_MULTISAMPLE_RESOLVE = 0x40000,
    D3D_FORMAT_SUPPORT_DISPLAY = 0x80000,
    D3D_FORMAT_SUPPORT_CAST_WITHIN_BIT_LAYOUT = 0x100000,
    D3D_FORMAT_SUPPORT_MULTISAMPLE_RENDERTARGET = 0x200000,
    D3D_FORMAT_SUPPORT_MULTISAMPLE_LOAD = 0x400000,
    D3D_FORMAT_SUPPORT_SHADER_GATHER = 0x800000,
    D3D_FORMAT_SUPPORT_BACK_BUFFER_CAST = 0x1000000,
	D3D_FORMAT_SUPPORT_TYPED_UNORDERED_ACCESS_VIEW	= 0x2000000,
    D3D_FORMAT_SUPPORT_SHADER_GATHER_COMPARISON	= 0x4000000,
    D3D_FORMAT_SUPPORT_DECODER_OUTPUT	= 0x8000000,
    D3D_FORMAT_SUPPORT_VIDEO_PROCESSOR_OUTPUT	= 0x10000000,
    D3D_FORMAT_SUPPORT_VIDEO_PROCESSOR_INPUT	= 0x20000000,
    D3D_FORMAT_SUPPORT_VIDEO_ENCODER	= 0x40000000
};


////////////////////////////////////////////////////////////
// D3D_ASYNC_GETDATA_FLAG
////////////////////////////////////////////////////////////
enum D3D_ASYNC_GETDATA_FLAG
{
    D3D_ASYNC_GETDATA_DONOTFLUSH = 0x1,
};


////////////////////////////////////////////////////////////
// D3D_QUERY
////////////////////////////////////////////////////////////
enum D3D_QUERY
{
    D3D_QUERY_EVENT = 0,
    D3D_QUERY_OCCLUSION = ( D3D_QUERY_EVENT + 1 ),
    D3D_QUERY_TIMESTAMP = ( D3D_QUERY_OCCLUSION + 1 ),
    D3D_QUERY_TIMESTAMP_DISJOINT = ( D3D_QUERY_TIMESTAMP + 1 ),
    D3D_QUERY_PIPELINE_STATISTICS = ( D3D_QUERY_TIMESTAMP_DISJOINT + 1 ),
    D3D_QUERY_OCCLUSION_PREDICATE = ( D3D_QUERY_PIPELINE_STATISTICS + 1 ),
    D3D_QUERY_SO_STATISTICS = ( D3D_QUERY_OCCLUSION_PREDICATE + 1 ),
    D3D_QUERY_SO_OVERFLOW_PREDICATE = ( D3D_QUERY_SO_STATISTICS + 1 ),
};


////////////////////////////////////////////////////////////
// D3D_QUERY_MISC_FLAG
////////////////////////////////////////////////////////////
enum D3D_QUERY_MISC_FLAG
{
    D3D_QUERY_MISC_PREDICATEHINT = 0x1,
};


////////////////////////////////////////////////////////////
// D3D_COUNTER
////////////////////////////////////////////////////////////
enum D3D_COUNTER
{
    D3D_COUNTER_GPU_IDLE = 0,
    D3D_COUNTER_VERTEX_PROCESSING = ( D3D_COUNTER_GPU_IDLE + 1 ),
    D3D_COUNTER_GEOMETRY_PROCESSING = ( D3D_COUNTER_VERTEX_PROCESSING + 1 ),
    D3D_COUNTER_PIXEL_PROCESSING = ( D3D_COUNTER_GEOMETRY_PROCESSING + 1 ),
    D3D_COUNTER_OTHER_GPU_PROCESSING = ( D3D_COUNTER_PIXEL_PROCESSING + 1 ),
    D3D_COUNTER_HOST_ADAPTER_BANDWIDTH_UTILIZATION = ( D3D_COUNTER_OTHER_GPU_PROCESSING + 1 ),
    D3D_COUNTER_LOCAL_VIDMEM_BANDWIDTH_UTILIZATION = ( D3D_COUNTER_HOST_ADAPTER_BANDWIDTH_UTILIZATION + 1 ),
    D3D_COUNTER_VERTEX_THROUGHPUT_UTILIZATION = ( D3D_COUNTER_LOCAL_VIDMEM_BANDWIDTH_UTILIZATION + 1 ),
    D3D_COUNTER_TRIANGLE_SETUP_THROUGHPUT_UTILIZATION = ( D3D_COUNTER_VERTEX_THROUGHPUT_UTILIZATION + 1 ),
    D3D_COUNTER_FILLRATE_THROUGHPUT_UTILIZATION = ( D3D_COUNTER_TRIANGLE_SETUP_THROUGHPUT_UTILIZATION + 1 ),
    D3D_COUNTER_VS_MEMORY_LIMITED = ( D3D_COUNTER_FILLRATE_THROUGHPUT_UTILIZATION + 1 ),
    D3D_COUNTER_VS_COMPUTATION_LIMITED = ( D3D_COUNTER_VS_MEMORY_LIMITED + 1 ),
    D3D_COUNTER_GS_MEMORY_LIMITED = ( D3D_COUNTER_VS_COMPUTATION_LIMITED + 1 ),
    D3D_COUNTER_GS_COMPUTATION_LIMITED = ( D3D_COUNTER_GS_MEMORY_LIMITED + 1 ),
    D3D_COUNTER_PS_MEMORY_LIMITED = ( D3D_COUNTER_GS_COMPUTATION_LIMITED + 1 ),
    D3D_COUNTER_PS_COMPUTATION_LIMITED = ( D3D_COUNTER_PS_MEMORY_LIMITED + 1 ),
    D3D_COUNTER_POST_TRANSFORM_CACHE_HIT_RATE = ( D3D_COUNTER_PS_COMPUTATION_LIMITED + 1 ),
    D3D_COUNTER_TEXTURE_CACHE_HIT_RATE = ( D3D_COUNTER_POST_TRANSFORM_CACHE_HIT_RATE + 1 ),
    D3D_COUNTER_DEVICE_DEPENDENT_0 = 0x40000000,
};


////////////////////////////////////////////////////////////
// D3D_COUNTER_TYPE
////////////////////////////////////////////////////////////
enum D3D_COUNTER_TYPE
{
    D3D_COUNTER_TYPE_FLOAT32 = 0,
    D3D_COUNTER_TYPE_UINT16 = ( D3D_COUNTER_TYPE_FLOAT32 + 1 ),
    D3D_COUNTER_TYPE_UINT32 = ( D3D_COUNTER_TYPE_UINT16 + 1 ),
    D3D_COUNTER_TYPE_UINT64 = ( D3D_COUNTER_TYPE_UINT32 + 1 ),
};


////////////////////////////////////////////////////////////
// D3D_CREATE_DEVICE_FLAG
////////////////////////////////////////////////////////////
enum D3D_CREATE_DEVICE_FLAG
{
    D3D_CREATE_DEVICE_SINGLETHREADED = 0x1,
    D3D_CREATE_DEVICE_DEBUG = 0x2,
    D3D_CREATE_DEVICE_SWITCH_TO_REF = 0x4,
    D3D_CREATE_DEVICE_PREVENT_INTERNAL_THREADING_OPTIMIZATIONS = 0x8,
    D3D_CREATE_DEVICE_ALLOW_NULL_FROM_MAP = 0x10,
    D3D_CREATE_DEVICE_BGRA_SUPPORT = 0x20,
    D3D_CREATE_DEVICE_STRICT_VALIDATION = 0x200,
};


////////////////////////////////////////////////////////////
// D3D_MESSAGE_CATEGORY
////////////////////////////////////////////////////////////
enum D3D_MESSAGE_CATEGORY
{
    D3D_MESSAGE_CATEGORY_APPLICATION_DEFINED = 0,
    D3D_MESSAGE_CATEGORY_MISCELLANEOUS = ( D3D_MESSAGE_CATEGORY_APPLICATION_DEFINED + 1 ),
    D3D_MESSAGE_CATEGORY_INITIALIZATION = ( D3D_MESSAGE_CATEGORY_MISCELLANEOUS + 1 ),
    D3D_MESSAGE_CATEGORY_CLEANUP = ( D3D_MESSAGE_CATEGORY_INITIALIZATION + 1 ),
    D3D_MESSAGE_CATEGORY_COMPILATION = ( D3D_MESSAGE_CATEGORY_CLEANUP + 1 ),
    D3D_MESSAGE_CATEGORY_STATE_CREATION = ( D3D_MESSAGE_CATEGORY_COMPILATION + 1 ),
    D3D_MESSAGE_CATEGORY_STATE_SETTING = ( D3D_MESSAGE_CATEGORY_STATE_CREATION + 1 ),
    D3D_MESSAGE_CATEGORY_STATE_GETTING = ( D3D_MESSAGE_CATEGORY_STATE_SETTING + 1 ),
    D3D_MESSAGE_CATEGORY_RESOURCE_MANIPULATION = ( D3D_MESSAGE_CATEGORY_STATE_GETTING + 1 ),
    D3D_MESSAGE_CATEGORY_EXECUTION = ( D3D_MESSAGE_CATEGORY_RESOURCE_MANIPULATION + 1 ),
};


////////////////////////////////////////////////////////////
// D3D_MESSAGE_SEVERITY
////////////////////////////////////////////////////////////
enum D3D_MESSAGE_SEVERITY
{
    D3D_MESSAGE_SEVERITY_CORRUPTION = 0,
    D3D_MESSAGE_SEVERITY_ERROR = ( D3D_MESSAGE_SEVERITY_CORRUPTION + 1 ),
    D3D_MESSAGE_SEVERITY_WARNING = ( D3D_MESSAGE_SEVERITY_ERROR + 1 ),
    D3D_MESSAGE_SEVERITY_INFO = ( D3D_MESSAGE_SEVERITY_WARNING + 1 ),
};


////////////////////////////////////////////////////////////
// D3D_MESSAGE_ID
////////////////////////////////////////////////////////////
enum D3D_MESSAGE_ID
{
    D3D_MESSAGE_ID_UNKNOWN = 0,
    D3D_MESSAGE_ID_DEVICE_IASETVERTEXBUFFERS_HAZARD = ( D3D_MESSAGE_ID_UNKNOWN + 1 ),
    D3D_MESSAGE_ID_DEVICE_IASETINDEXBUFFER_HAZARD = ( D3D_MESSAGE_ID_DEVICE_IASETVERTEXBUFFERS_HAZARD + 1 ),
    D3D_MESSAGE_ID_DEVICE_VSSETSHADERRESOURCES_HAZARD = ( D3D_MESSAGE_ID_DEVICE_IASETINDEXBUFFER_HAZARD + 1 ),
    D3D_MESSAGE_ID_DEVICE_VSSETCONSTANTBUFFERS_HAZARD = ( D3D_MESSAGE_ID_DEVICE_VSSETSHADERRESOURCES_HAZARD + 1 ),
    D3D_MESSAGE_ID_DEVICE_GSSETSHADERRESOURCES_HAZARD = ( D3D_MESSAGE_ID_DEVICE_VSSETCONSTANTBUFFERS_HAZARD + 1 ),
    D3D_MESSAGE_ID_DEVICE_GSSETCONSTANTBUFFERS_HAZARD = ( D3D_MESSAGE_ID_DEVICE_GSSETSHADERRESOURCES_HAZARD + 1 ),
    D3D_MESSAGE_ID_DEVICE_PSSETSHADERRESOURCES_HAZARD = ( D3D_MESSAGE_ID_DEVICE_GSSETCONSTANTBUFFERS_HAZARD + 1 ),
    D3D_MESSAGE_ID_DEVICE_PSSETCONSTANTBUFFERS_HAZARD = ( D3D_MESSAGE_ID_DEVICE_PSSETSHADERRESOURCES_HAZARD + 1 ),
    D3D_MESSAGE_ID_DEVICE_OMSETRENDERTARGETS_HAZARD = ( D3D_MESSAGE_ID_DEVICE_PSSETCONSTANTBUFFERS_HAZARD + 1 ),
    D3D_MESSAGE_ID_DEVICE_SOSETTARGETS_HAZARD = ( D3D_MESSAGE_ID_DEVICE_OMSETRENDERTARGETS_HAZARD + 1 ),
    D3D_MESSAGE_ID_STRING_FROM_APPLICATION = ( D3D_MESSAGE_ID_DEVICE_SOSETTARGETS_HAZARD + 1 ),
    D3D_MESSAGE_ID_CORRUPTED_THIS = ( D3D_MESSAGE_ID_STRING_FROM_APPLICATION + 1 ),
    D3D_MESSAGE_ID_CORRUPTED_PARAMETER1 = ( D3D_MESSAGE_ID_CORRUPTED_THIS + 1 ),
    D3D_MESSAGE_ID_CORRUPTED_PARAMETER2 = ( D3D_MESSAGE_ID_CORRUPTED_PARAMETER1 + 1 ),
    D3D_MESSAGE_ID_CORRUPTED_PARAMETER3 = ( D3D_MESSAGE_ID_CORRUPTED_PARAMETER2 + 1 ),
    D3D_MESSAGE_ID_CORRUPTED_PARAMETER4 = ( D3D_MESSAGE_ID_CORRUPTED_PARAMETER3 + 1 ),
    D3D_MESSAGE_ID_CORRUPTED_PARAMETER5 = ( D3D_MESSAGE_ID_CORRUPTED_PARAMETER4 + 1 ),
    D3D_MESSAGE_ID_CORRUPTED_PARAMETER6 = ( D3D_MESSAGE_ID_CORRUPTED_PARAMETER5 + 1 ),
    D3D_MESSAGE_ID_CORRUPTED_PARAMETER7 = ( D3D_MESSAGE_ID_CORRUPTED_PARAMETER6 + 1 ),
    D3D_MESSAGE_ID_CORRUPTED_PARAMETER8 = ( D3D_MESSAGE_ID_CORRUPTED_PARAMETER7 + 1 ),
    D3D_MESSAGE_ID_CORRUPTED_PARAMETER9 = ( D3D_MESSAGE_ID_CORRUPTED_PARAMETER8 + 1 ),
    D3D_MESSAGE_ID_CORRUPTED_PARAMETER10 = ( D3D_MESSAGE_ID_CORRUPTED_PARAMETER9 + 1 ),
    D3D_MESSAGE_ID_CORRUPTED_PARAMETER11 = ( D3D_MESSAGE_ID_CORRUPTED_PARAMETER10 + 1 ),
    D3D_MESSAGE_ID_CORRUPTED_PARAMETER12 = ( D3D_MESSAGE_ID_CORRUPTED_PARAMETER11 + 1 ),
    D3D_MESSAGE_ID_CORRUPTED_PARAMETER13 = ( D3D_MESSAGE_ID_CORRUPTED_PARAMETER12 + 1 ),
    D3D_MESSAGE_ID_CORRUPTED_PARAMETER14 = ( D3D_MESSAGE_ID_CORRUPTED_PARAMETER13 + 1 ),
    D3D_MESSAGE_ID_CORRUPTED_PARAMETER15 = ( D3D_MESSAGE_ID_CORRUPTED_PARAMETER14 + 1 ),
    D3D_MESSAGE_ID_CORRUPTED_MULTITHREADING = ( D3D_MESSAGE_ID_CORRUPTED_PARAMETER15 + 1 ),
    D3D_MESSAGE_ID_MESSAGE_REPORTING_OUTOFMEMORY = ( D3D_MESSAGE_ID_CORRUPTED_MULTITHREADING + 1 ),
    D3D_MESSAGE_ID_IASETINPUTLAYOUT_UNBINDDELETINGOBJECT = ( D3D_MESSAGE_ID_MESSAGE_REPORTING_OUTOFMEMORY + 1 ),
    D3D_MESSAGE_ID_IASETVERTEXBUFFERS_UNBINDDELETINGOBJECT = ( D3D_MESSAGE_ID_IASETINPUTLAYOUT_UNBINDDELETINGOBJECT + 1 ),
    D3D_MESSAGE_ID_IASETINDEXBUFFER_UNBINDDELETINGOBJECT = ( D3D_MESSAGE_ID_IASETVERTEXBUFFERS_UNBINDDELETINGOBJECT + 1 ),
    D3D_MESSAGE_ID_VSSETSHADER_UNBINDDELETINGOBJECT = ( D3D_MESSAGE_ID_IASETINDEXBUFFER_UNBINDDELETINGOBJECT + 1 ),
    D3D_MESSAGE_ID_VSSETSHADERRESOURCES_UNBINDDELETINGOBJECT = ( D3D_MESSAGE_ID_VSSETSHADER_UNBINDDELETINGOBJECT + 1 ),
    D3D_MESSAGE_ID_VSSETCONSTANTBUFFERS_UNBINDDELETINGOBJECT = ( D3D_MESSAGE_ID_VSSETSHADERRESOURCES_UNBINDDELETINGOBJECT + 1 ),
    D3D_MESSAGE_ID_VSSETSAMPLERS_UNBINDDELETINGOBJECT = ( D3D_MESSAGE_ID_VSSETCONSTANTBUFFERS_UNBINDDELETINGOBJECT + 1 ),
    D3D_MESSAGE_ID_GSSETSHADER_UNBINDDELETINGOBJECT = ( D3D_MESSAGE_ID_VSSETSAMPLERS_UNBINDDELETINGOBJECT + 1 ),
    D3D_MESSAGE_ID_GSSETSHADERRESOURCES_UNBINDDELETINGOBJECT = ( D3D_MESSAGE_ID_GSSETSHADER_UNBINDDELETINGOBJECT + 1 ),
    D3D_MESSAGE_ID_GSSETCONSTANTBUFFERS_UNBINDDELETINGOBJECT = ( D3D_MESSAGE_ID_GSSETSHADERRESOURCES_UNBINDDELETINGOBJECT + 1 ),
    D3D_MESSAGE_ID_GSSETSAMPLERS_UNBINDDELETINGOBJECT = ( D3D_MESSAGE_ID_GSSETCONSTANTBUFFERS_UNBINDDELETINGOBJECT + 1 ),
    D3D_MESSAGE_ID_SOSETTARGETS_UNBINDDELETINGOBJECT = ( D3D_MESSAGE_ID_GSSETSAMPLERS_UNBINDDELETINGOBJECT + 1 ),
    D3D_MESSAGE_ID_PSSETSHADER_UNBINDDELETINGOBJECT = ( D3D_MESSAGE_ID_SOSETTARGETS_UNBINDDELETINGOBJECT + 1 ),
    D3D_MESSAGE_ID_PSSETSHADERRESOURCES_UNBINDDELETINGOBJECT = ( D3D_MESSAGE_ID_PSSETSHADER_UNBINDDELETINGOBJECT + 1 ),
    D3D_MESSAGE_ID_PSSETCONSTANTBUFFERS_UNBINDDELETINGOBJECT = ( D3D_MESSAGE_ID_PSSETSHADERRESOURCES_UNBINDDELETINGOBJECT + 1 ),
    D3D_MESSAGE_ID_PSSETSAMPLERS_UNBINDDELETINGOBJECT = ( D3D_MESSAGE_ID_PSSETCONSTANTBUFFERS_UNBINDDELETINGOBJECT + 1 ),
    D3D_MESSAGE_ID_RSSETSTATE_UNBINDDELETINGOBJECT = ( D3D_MESSAGE_ID_PSSETSAMPLERS_UNBINDDELETINGOBJECT + 1 ),
    D3D_MESSAGE_ID_OMSETBLENDSTATE_UNBINDDELETINGOBJECT = ( D3D_MESSAGE_ID_RSSETSTATE_UNBINDDELETINGOBJECT + 1 ),
    D3D_MESSAGE_ID_OMSETDEPTHSTENCILSTATE_UNBINDDELETINGOBJECT = ( D3D_MESSAGE_ID_OMSETBLENDSTATE_UNBINDDELETINGOBJECT + 1 ),
    D3D_MESSAGE_ID_OMSETRENDERTARGETS_UNBINDDELETINGOBJECT = ( D3D_MESSAGE_ID_OMSETDEPTHSTENCILSTATE_UNBINDDELETINGOBJECT + 1 ),
    D3D_MESSAGE_ID_SETPREDICATION_UNBINDDELETINGOBJECT = ( D3D_MESSAGE_ID_OMSETRENDERTARGETS_UNBINDDELETINGOBJECT + 1 ),
    D3D_MESSAGE_ID_GETPRIVATEDATA_MOREDATA = ( D3D_MESSAGE_ID_SETPREDICATION_UNBINDDELETINGOBJECT + 1 ),
    D3D_MESSAGE_ID_SETPRIVATEDATA_INVALIDFREEDATA = ( D3D_MESSAGE_ID_GETPRIVATEDATA_MOREDATA + 1 ),
    D3D_MESSAGE_ID_SETPRIVATEDATA_INVALIDIUNKNOWN = ( D3D_MESSAGE_ID_SETPRIVATEDATA_INVALIDFREEDATA + 1 ),
    D3D_MESSAGE_ID_SETPRIVATEDATA_INVALIDFLAGS = ( D3D_MESSAGE_ID_SETPRIVATEDATA_INVALIDIUNKNOWN + 1 ),
    D3D_MESSAGE_ID_SETPRIVATEDATA_CHANGINGPARAMS = ( D3D_MESSAGE_ID_SETPRIVATEDATA_INVALIDFLAGS + 1 ),
    D3D_MESSAGE_ID_SETPRIVATEDATA_OUTOFMEMORY = ( D3D_MESSAGE_ID_SETPRIVATEDATA_CHANGINGPARAMS + 1 ),
    D3D_MESSAGE_ID_CREATEBUFFER_UNRECOGNIZEDFORMAT = ( D3D_MESSAGE_ID_SETPRIVATEDATA_OUTOFMEMORY + 1 ),
    D3D_MESSAGE_ID_CREATEBUFFER_INVALIDSAMPLES = ( D3D_MESSAGE_ID_CREATEBUFFER_UNRECOGNIZEDFORMAT + 1 ),
    D3D_MESSAGE_ID_CREATEBUFFER_UNRECOGNIZEDUSAGE = ( D3D_MESSAGE_ID_CREATEBUFFER_INVALIDSAMPLES + 1 ),
    D3D_MESSAGE_ID_CREATEBUFFER_UNRECOGNIZEDBINDFLAGS = ( D3D_MESSAGE_ID_CREATEBUFFER_UNRECOGNIZEDUSAGE + 1 ),
    D3D_MESSAGE_ID_CREATEBUFFER_UNRECOGNIZEDCPUACCESSFLAGS = ( D3D_MESSAGE_ID_CREATEBUFFER_UNRECOGNIZEDBINDFLAGS + 1 ),
    D3D_MESSAGE_ID_CREATEBUFFER_UNRECOGNIZEDMISCFLAGS = ( D3D_MESSAGE_ID_CREATEBUFFER_UNRECOGNIZEDCPUACCESSFLAGS + 1 ),
    D3D_MESSAGE_ID_CREATEBUFFER_INVALIDCPUACCESSFLAGS = ( D3D_MESSAGE_ID_CREATEBUFFER_UNRECOGNIZEDMISCFLAGS + 1 ),
    D3D_MESSAGE_ID_CREATEBUFFER_INVALIDBINDFLAGS = ( D3D_MESSAGE_ID_CREATEBUFFER_INVALIDCPUACCESSFLAGS + 1 ),
    D3D_MESSAGE_ID_CREATEBUFFER_INVALIDINITIALDATA = ( D3D_MESSAGE_ID_CREATEBUFFER_INVALIDBINDFLAGS + 1 ),
    D3D_MESSAGE_ID_CREATEBUFFER_INVALIDDIMENSIONS = ( D3D_MESSAGE_ID_CREATEBUFFER_INVALIDINITIALDATA + 1 ),
    D3D_MESSAGE_ID_CREATEBUFFER_INVALIDMIPLEVELS = ( D3D_MESSAGE_ID_CREATEBUFFER_INVALIDDIMENSIONS + 1 ),
    D3D_MESSAGE_ID_CREATEBUFFER_INVALIDMISCFLAGS = ( D3D_MESSAGE_ID_CREATEBUFFER_INVALIDMIPLEVELS + 1 ),
    D3D_MESSAGE_ID_CREATEBUFFER_INVALIDARG_RETURN = ( D3D_MESSAGE_ID_CREATEBUFFER_INVALIDMISCFLAGS + 1 ),
    D3D_MESSAGE_ID_CREATEBUFFER_OUTOFMEMORY_RETURN = ( D3D_MESSAGE_ID_CREATEBUFFER_INVALIDARG_RETURN + 1 ),
    D3D_MESSAGE_ID_CREATEBUFFER_NULLDESC = ( D3D_MESSAGE_ID_CREATEBUFFER_OUTOFMEMORY_RETURN + 1 ),
    D3D_MESSAGE_ID_CREATEBUFFER_INVALIDCONSTANTBUFFERBINDINGS = ( D3D_MESSAGE_ID_CREATEBUFFER_NULLDESC + 1 ),
    D3D_MESSAGE_ID_CREATEBUFFER_LARGEALLOCATION = ( D3D_MESSAGE_ID_CREATEBUFFER_INVALIDCONSTANTBUFFERBINDINGS + 1 ),
    D3D_MESSAGE_ID_CREATETEXTURE1D_UNRECOGNIZEDFORMAT = ( D3D_MESSAGE_ID_CREATEBUFFER_LARGEALLOCATION + 1 ),
    D3D_MESSAGE_ID_CREATETEXTURE1D_UNSUPPORTEDFORMAT = ( D3D_MESSAGE_ID_CREATETEXTURE1D_UNRECOGNIZEDFORMAT + 1 ),
    D3D_MESSAGE_ID_CREATETEXTURE1D_INVALIDSAMPLES = ( D3D_MESSAGE_ID_CREATETEXTURE1D_UNSUPPORTEDFORMAT + 1 ),
    D3D_MESSAGE_ID_CREATETEXTURE1D_UNRECOGNIZEDUSAGE = ( D3D_MESSAGE_ID_CREATETEXTURE1D_INVALIDSAMPLES + 1 ),
    D3D_MESSAGE_ID_CREATETEXTURE1D_UNRECOGNIZEDBINDFLAGS = ( D3D_MESSAGE_ID_CREATETEXTURE1D_UNRECOGNIZEDUSAGE + 1 ),
    D3D_MESSAGE_ID_CREATETEXTURE1D_UNRECOGNIZEDCPUACCESSFLAGS = ( D3D_MESSAGE_ID_CREATETEXTURE1D_UNRECOGNIZEDBINDFLAGS + 1 ),
    D3D_MESSAGE_ID_CREATETEXTURE1D_UNRECOGNIZEDMISCFLAGS = ( D3D_MESSAGE_ID_CREATETEXTURE1D_UNRECOGNIZEDCPUACCESSFLAGS + 1 ),
    D3D_MESSAGE_ID_CREATETEXTURE1D_INVALIDCPUACCESSFLAGS = ( D3D_MESSAGE_ID_CREATETEXTURE1D_UNRECOGNIZEDMISCFLAGS + 1 ),
    D3D_MESSAGE_ID_CREATETEXTURE1D_INVALIDBINDFLAGS = ( D3D_MESSAGE_ID_CREATETEXTURE1D_INVALIDCPUACCESSFLAGS + 1 ),
    D3D_MESSAGE_ID_CREATETEXTURE1D_INVALIDINITIALDATA = ( D3D_MESSAGE_ID_CREATETEXTURE1D_INVALIDBINDFLAGS + 1 ),
    D3D_MESSAGE_ID_CREATETEXTURE1D_INVALIDDIMENSIONS = ( D3D_MESSAGE_ID_CREATETEXTURE1D_INVALIDINITIALDATA + 1 ),
    D3D_MESSAGE_ID_CREATETEXTURE1D_INVALIDMIPLEVELS = ( D3D_MESSAGE_ID_CREATETEXTURE1D_INVALIDDIMENSIONS + 1 ),
    D3D_MESSAGE_ID_CREATETEXTURE1D_INVALIDMISCFLAGS = ( D3D_MESSAGE_ID_CREATETEXTURE1D_INVALIDMIPLEVELS + 1 ),
    D3D_MESSAGE_ID_CREATETEXTURE1D_INVALIDARG_RETURN = ( D3D_MESSAGE_ID_CREATETEXTURE1D_INVALIDMISCFLAGS + 1 ),
    D3D_MESSAGE_ID_CREATETEXTURE1D_OUTOFMEMORY_RETURN = ( D3D_MESSAGE_ID_CREATETEXTURE1D_INVALIDARG_RETURN + 1 ),
    D3D_MESSAGE_ID_CREATETEXTURE1D_NULLDESC = ( D3D_MESSAGE_ID_CREATETEXTURE1D_OUTOFMEMORY_RETURN + 1 ),
    D3D_MESSAGE_ID_CREATETEXTURE1D_LARGEALLOCATION = ( D3D_MESSAGE_ID_CREATETEXTURE1D_NULLDESC + 1 ),
    D3D_MESSAGE_ID_CREATETEXTURE2D_UNRECOGNIZEDFORMAT = ( D3D_MESSAGE_ID_CREATETEXTURE1D_LARGEALLOCATION + 1 ),
    D3D_MESSAGE_ID_CREATETEXTURE2D_UNSUPPORTEDFORMAT = ( D3D_MESSAGE_ID_CREATETEXTURE2D_UNRECOGNIZEDFORMAT + 1 ),
    D3D_MESSAGE_ID_CREATETEXTURE2D_INVALIDSAMPLES = ( D3D_MESSAGE_ID_CREATETEXTURE2D_UNSUPPORTEDFORMAT + 1 ),
    D3D_MESSAGE_ID_CREATETEXTURE2D_UNRECOGNIZEDUSAGE = ( D3D_MESSAGE_ID_CREATETEXTURE2D_INVALIDSAMPLES + 1 ),
    D3D_MESSAGE_ID_CREATETEXTURE2D_UNRECOGNIZEDBINDFLAGS = ( D3D_MESSAGE_ID_CREATETEXTURE2D_UNRECOGNIZEDUSAGE + 1 ),
    D3D_MESSAGE_ID_CREATETEXTURE2D_UNRECOGNIZEDCPUACCESSFLAGS = ( D3D_MESSAGE_ID_CREATETEXTURE2D_UNRECOGNIZEDBINDFLAGS + 1 ),
    D3D_MESSAGE_ID_CREATETEXTURE2D_UNRECOGNIZEDMISCFLAGS = ( D3D_MESSAGE_ID_CREATETEXTURE2D_UNRECOGNIZEDCPUACCESSFLAGS + 1 ),
    D3D_MESSAGE_ID_CREATETEXTURE2D_INVALIDCPUACCESSFLAGS = ( D3D_MESSAGE_ID_CREATETEXTURE2D_UNRECOGNIZEDMISCFLAGS + 1 ),
    D3D_MESSAGE_ID_CREATETEXTURE2D_INVALIDBINDFLAGS = ( D3D_MESSAGE_ID_CREATETEXTURE2D_INVALIDCPUACCESSFLAGS + 1 ),
    D3D_MESSAGE_ID_CREATETEXTURE2D_INVALIDINITIALDATA = ( D3D_MESSAGE_ID_CREATETEXTURE2D_INVALIDBINDFLAGS + 1 ),
    D3D_MESSAGE_ID_CREATETEXTURE2D_INVALIDDIMENSIONS = ( D3D_MESSAGE_ID_CREATETEXTURE2D_INVALIDINITIALDATA + 1 ),
    D3D_MESSAGE_ID_CREATETEXTURE2D_INVALIDMIPLEVELS = ( D3D_MESSAGE_ID_CREATETEXTURE2D_INVALIDDIMENSIONS + 1 ),
    D3D_MESSAGE_ID_CREATETEXTURE2D_INVALIDMISCFLAGS = ( D3D_MESSAGE_ID_CREATETEXTURE2D_INVALIDMIPLEVELS + 1 ),
    D3D_MESSAGE_ID_CREATETEXTURE2D_INVALIDARG_RETURN = ( D3D_MESSAGE_ID_CREATETEXTURE2D_INVALIDMISCFLAGS + 1 ),
    D3D_MESSAGE_ID_CREATETEXTURE2D_OUTOFMEMORY_RETURN = ( D3D_MESSAGE_ID_CREATETEXTURE2D_INVALIDARG_RETURN + 1 ),
    D3D_MESSAGE_ID_CREATETEXTURE2D_NULLDESC = ( D3D_MESSAGE_ID_CREATETEXTURE2D_OUTOFMEMORY_RETURN + 1 ),
    D3D_MESSAGE_ID_CREATETEXTURE2D_LARGEALLOCATION = ( D3D_MESSAGE_ID_CREATETEXTURE2D_NULLDESC + 1 ),
    D3D_MESSAGE_ID_CREATETEXTURE3D_UNRECOGNIZEDFORMAT = ( D3D_MESSAGE_ID_CREATETEXTURE2D_LARGEALLOCATION + 1 ),
    D3D_MESSAGE_ID_CREATETEXTURE3D_UNSUPPORTEDFORMAT = ( D3D_MESSAGE_ID_CREATETEXTURE3D_UNRECOGNIZEDFORMAT + 1 ),
    D3D_MESSAGE_ID_CREATETEXTURE3D_INVALIDSAMPLES = ( D3D_MESSAGE_ID_CREATETEXTURE3D_UNSUPPORTEDFORMAT + 1 ),
    D3D_MESSAGE_ID_CREATETEXTURE3D_UNRECOGNIZEDUSAGE = ( D3D_MESSAGE_ID_CREATETEXTURE3D_INVALIDSAMPLES + 1 ),
    D3D_MESSAGE_ID_CREATETEXTURE3D_UNRECOGNIZEDBINDFLAGS = ( D3D_MESSAGE_ID_CREATETEXTURE3D_UNRECOGNIZEDUSAGE + 1 ),
    D3D_MESSAGE_ID_CREATETEXTURE3D_UNRECOGNIZEDCPUACCESSFLAGS = ( D3D_MESSAGE_ID_CREATETEXTURE3D_UNRECOGNIZEDBINDFLAGS + 1 ),
    D3D_MESSAGE_ID_CREATETEXTURE3D_UNRECOGNIZEDMISCFLAGS = ( D3D_MESSAGE_ID_CREATETEXTURE3D_UNRECOGNIZEDCPUACCESSFLAGS + 1 ),
    D3D_MESSAGE_ID_CREATETEXTURE3D_INVALIDCPUACCESSFLAGS = ( D3D_MESSAGE_ID_CREATETEXTURE3D_UNRECOGNIZEDMISCFLAGS + 1 ),
    D3D_MESSAGE_ID_CREATETEXTURE3D_INVALIDBINDFLAGS = ( D3D_MESSAGE_ID_CREATETEXTURE3D_INVALIDCPUACCESSFLAGS + 1 ),
    D3D_MESSAGE_ID_CREATETEXTURE3D_INVALIDINITIALDATA = ( D3D_MESSAGE_ID_CREATETEXTURE3D_INVALIDBINDFLAGS + 1 ),
    D3D_MESSAGE_ID_CREATETEXTURE3D_INVALIDDIMENSIONS = ( D3D_MESSAGE_ID_CREATETEXTURE3D_INVALIDINITIALDATA + 1 ),
    D3D_MESSAGE_ID_CREATETEXTURE3D_INVALIDMIPLEVELS = ( D3D_MESSAGE_ID_CREATETEXTURE3D_INVALIDDIMENSIONS + 1 ),
    D3D_MESSAGE_ID_CREATETEXTURE3D_INVALIDMISCFLAGS = ( D3D_MESSAGE_ID_CREATETEXTURE3D_INVALIDMIPLEVELS + 1 ),
    D3D_MESSAGE_ID_CREATETEXTURE3D_INVALIDARG_RETURN = ( D3D_MESSAGE_ID_CREATETEXTURE3D_INVALIDMISCFLAGS + 1 ),
    D3D_MESSAGE_ID_CREATETEXTURE3D_OUTOFMEMORY_RETURN = ( D3D_MESSAGE_ID_CREATETEXTURE3D_INVALIDARG_RETURN + 1 ),
    D3D_MESSAGE_ID_CREATETEXTURE3D_NULLDESC = ( D3D_MESSAGE_ID_CREATETEXTURE3D_OUTOFMEMORY_RETURN + 1 ),
    D3D_MESSAGE_ID_CREATETEXTURE3D_LARGEALLOCATION = ( D3D_MESSAGE_ID_CREATETEXTURE3D_NULLDESC + 1 ),
    D3D_MESSAGE_ID_CREATESHADERRESOURCEVIEW_UNRECOGNIZEDFORMAT = ( D3D_MESSAGE_ID_CREATETEXTURE3D_LARGEALLOCATION + 1 ),
    D3D_MESSAGE_ID_CREATESHADERRESOURCEVIEW_INVALIDDESC = ( D3D_MESSAGE_ID_CREATESHADERRESOURCEVIEW_UNRECOGNIZEDFORMAT + 1 ),
    D3D_MESSAGE_ID_CREATESHADERRESOURCEVIEW_INVALIDFORMAT = ( D3D_MESSAGE_ID_CREATESHADERRESOURCEVIEW_INVALIDDESC + 1 ),
    D3D_MESSAGE_ID_CREATESHADERRESOURCEVIEW_INVALIDDIMENSIONS = ( D3D_MESSAGE_ID_CREATESHADERRESOURCEVIEW_INVALIDFORMAT + 1 ),
    D3D_MESSAGE_ID_CREATESHADERRESOURCEVIEW_INVALIDRESOURCE = ( D3D_MESSAGE_ID_CREATESHADERRESOURCEVIEW_INVALIDDIMENSIONS + 1 ),
    D3D_MESSAGE_ID_CREATESHADERRESOURCEVIEW_TOOMANYOBJECTS = ( D3D_MESSAGE_ID_CREATESHADERRESOURCEVIEW_INVALIDRESOURCE + 1 ),
    D3D_MESSAGE_ID_CREATESHADERRESOURCEVIEW_INVALIDARG_RETURN = ( D3D_MESSAGE_ID_CREATESHADERRESOURCEVIEW_TOOMANYOBJECTS + 1 ),
    D3D_MESSAGE_ID_CREATESHADERRESOURCEVIEW_OUTOFMEMORY_RETURN = ( D3D_MESSAGE_ID_CREATESHADERRESOURCEVIEW_INVALIDARG_RETURN + 1 ),
    D3D_MESSAGE_ID_CREATERENDERTARGETVIEW_UNRECOGNIZEDFORMAT = ( D3D_MESSAGE_ID_CREATESHADERRESOURCEVIEW_OUTOFMEMORY_RETURN + 1 ),
    D3D_MESSAGE_ID_CREATERENDERTARGETVIEW_UNSUPPORTEDFORMAT = ( D3D_MESSAGE_ID_CREATERENDERTARGETVIEW_UNRECOGNIZEDFORMAT + 1 ),
    D3D_MESSAGE_ID_CREATERENDERTARGETVIEW_INVALIDDESC = ( D3D_MESSAGE_ID_CREATERENDERTARGETVIEW_UNSUPPORTEDFORMAT + 1 ),
    D3D_MESSAGE_ID_CREATERENDERTARGETVIEW_INVALIDFORMAT = ( D3D_MESSAGE_ID_CREATERENDERTARGETVIEW_INVALIDDESC + 1 ),
    D3D_MESSAGE_ID_CREATERENDERTARGETVIEW_INVALIDDIMENSIONS = ( D3D_MESSAGE_ID_CREATERENDERTARGETVIEW_INVALIDFORMAT + 1 ),
    D3D_MESSAGE_ID_CREATERENDERTARGETVIEW_INVALIDRESOURCE = ( D3D_MESSAGE_ID_CREATERENDERTARGETVIEW_INVALIDDIMENSIONS + 1 ),
    D3D_MESSAGE_ID_CREATERENDERTARGETVIEW_TOOMANYOBJECTS = ( D3D_MESSAGE_ID_CREATERENDERTARGETVIEW_INVALIDRESOURCE + 1 ),
    D3D_MESSAGE_ID_CREATERENDERTARGETVIEW_INVALIDARG_RETURN = ( D3D_MESSAGE_ID_CREATERENDERTARGETVIEW_TOOMANYOBJECTS + 1 ),
    D3D_MESSAGE_ID_CREATERENDERTARGETVIEW_OUTOFMEMORY_RETURN = ( D3D_MESSAGE_ID_CREATERENDERTARGETVIEW_INVALIDARG_RETURN + 1 ),
    D3D_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_UNRECOGNIZEDFORMAT = ( D3D_MESSAGE_ID_CREATERENDERTARGETVIEW_OUTOFMEMORY_RETURN + 1 ),
    D3D_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_INVALIDDESC = ( D3D_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_UNRECOGNIZEDFORMAT + 1 ),
    D3D_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_INVALIDFORMAT = ( D3D_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_INVALIDDESC + 1 ),
    D3D_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_INVALIDDIMENSIONS = ( D3D_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_INVALIDFORMAT + 1 ),
    D3D_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_INVALIDRESOURCE = ( D3D_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_INVALIDDIMENSIONS + 1 ),
    D3D_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_TOOMANYOBJECTS = ( D3D_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_INVALIDRESOURCE + 1 ),
    D3D_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_INVALIDARG_RETURN = ( D3D_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_TOOMANYOBJECTS + 1 ),
    D3D_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_OUTOFMEMORY_RETURN = ( D3D_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_INVALIDARG_RETURN + 1 ),
    D3D_MESSAGE_ID_CREATEINPUTLAYOUT_OUTOFMEMORY = ( D3D_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_OUTOFMEMORY_RETURN + 1 ),
    D3D_MESSAGE_ID_CREATEINPUTLAYOUT_TOOMANYELEMENTS = ( D3D_MESSAGE_ID_CREATEINPUTLAYOUT_OUTOFMEMORY + 1 ),
    D3D_MESSAGE_ID_CREATEINPUTLAYOUT_INVALIDFORMAT = ( D3D_MESSAGE_ID_CREATEINPUTLAYOUT_TOOMANYELEMENTS + 1 ),
    D3D_MESSAGE_ID_CREATEINPUTLAYOUT_INCOMPATIBLEFORMAT = ( D3D_MESSAGE_ID_CREATEINPUTLAYOUT_INVALIDFORMAT + 1 ),
    D3D_MESSAGE_ID_CREATEINPUTLAYOUT_INVALIDSLOT = ( D3D_MESSAGE_ID_CREATEINPUTLAYOUT_INCOMPATIBLEFORMAT + 1 ),
    D3D_MESSAGE_ID_CREATEINPUTLAYOUT_INVALIDINPUTSLOTCLASS = ( D3D_MESSAGE_ID_CREATEINPUTLAYOUT_INVALIDSLOT + 1 ),
    D3D_MESSAGE_ID_CREATEINPUTLAYOUT_STEPRATESLOTCLASSMISMATCH = ( D3D_MESSAGE_ID_CREATEINPUTLAYOUT_INVALIDINPUTSLOTCLASS + 1 ),
    D3D_MESSAGE_ID_CREATEINPUTLAYOUT_INVALIDSLOTCLASSCHANGE = ( D3D_MESSAGE_ID_CREATEINPUTLAYOUT_STEPRATESLOTCLASSMISMATCH + 1 ),
    D3D_MESSAGE_ID_CREATEINPUTLAYOUT_INVALIDSTEPRATECHANGE = ( D3D_MESSAGE_ID_CREATEINPUTLAYOUT_INVALIDSLOTCLASSCHANGE + 1 ),
    D3D_MESSAGE_ID_CREATEINPUTLAYOUT_INVALIDALIGNMENT = ( D3D_MESSAGE_ID_CREATEINPUTLAYOUT_INVALIDSTEPRATECHANGE + 1 ),
    D3D_MESSAGE_ID_CREATEINPUTLAYOUT_DUPLICATESEMANTIC = ( D3D_MESSAGE_ID_CREATEINPUTLAYOUT_INVALIDALIGNMENT + 1 ),
    D3D_MESSAGE_ID_CREATEINPUTLAYOUT_UNPARSEABLEINPUTSIGNATURE = ( D3D_MESSAGE_ID_CREATEINPUTLAYOUT_DUPLICATESEMANTIC + 1 ),
    D3D_MESSAGE_ID_CREATEINPUTLAYOUT_NULLSEMANTIC = ( D3D_MESSAGE_ID_CREATEINPUTLAYOUT_UNPARSEABLEINPUTSIGNATURE + 1 ),
    D3D_MESSAGE_ID_CREATEINPUTLAYOUT_MISSINGELEMENT = ( D3D_MESSAGE_ID_CREATEINPUTLAYOUT_NULLSEMANTIC + 1 ),
    D3D_MESSAGE_ID_CREATEINPUTLAYOUT_NULLDESC = ( D3D_MESSAGE_ID_CREATEINPUTLAYOUT_MISSINGELEMENT + 1 ),
    D3D_MESSAGE_ID_CREATEVERTEXSHADER_OUTOFMEMORY = ( D3D_MESSAGE_ID_CREATEINPUTLAYOUT_NULLDESC + 1 ),
    D3D_MESSAGE_ID_CREATEVERTEXSHADER_INVALIDSHADERBYTECODE = ( D3D_MESSAGE_ID_CREATEVERTEXSHADER_OUTOFMEMORY + 1 ),
    D3D_MESSAGE_ID_CREATEVERTEXSHADER_INVALIDSHADERTYPE = ( D3D_MESSAGE_ID_CREATEVERTEXSHADER_INVALIDSHADERBYTECODE + 1 ),
    D3D_MESSAGE_ID_CREATEGEOMETRYSHADER_OUTOFMEMORY = ( D3D_MESSAGE_ID_CREATEVERTEXSHADER_INVALIDSHADERTYPE + 1 ),
    D3D_MESSAGE_ID_CREATEGEOMETRYSHADER_INVALIDSHADERBYTECODE = ( D3D_MESSAGE_ID_CREATEGEOMETRYSHADER_OUTOFMEMORY + 1 ),
    D3D_MESSAGE_ID_CREATEGEOMETRYSHADER_INVALIDSHADERTYPE = ( D3D_MESSAGE_ID_CREATEGEOMETRYSHADER_INVALIDSHADERBYTECODE + 1 ),
    D3D_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_OUTOFMEMORY = ( D3D_MESSAGE_ID_CREATEGEOMETRYSHADER_INVALIDSHADERTYPE + 1 ),
    D3D_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDSHADERBYTECODE = ( D3D_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_OUTOFMEMORY + 1 ),
    D3D_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDSHADERTYPE = ( D3D_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDSHADERBYTECODE + 1 ),
    D3D_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDNUMENTRIES = ( D3D_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDSHADERTYPE + 1 ),
    D3D_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_OUTPUTSTREAMSTRIDEUNUSED = ( D3D_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDNUMENTRIES + 1 ),
    D3D_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_UNEXPECTEDDECL = ( D3D_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_OUTPUTSTREAMSTRIDEUNUSED + 1 ),
    D3D_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_EXPECTEDDECL = ( D3D_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_UNEXPECTEDDECL + 1 ),
    D3D_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_OUTPUTSLOT0EXPECTED = ( D3D_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_EXPECTEDDECL + 1 ),
    D3D_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDOUTPUTSLOT = ( D3D_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_OUTPUTSLOT0EXPECTED + 1 ),
    D3D_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_ONLYONEELEMENTPERSLOT = ( D3D_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDOUTPUTSLOT + 1 ),
    D3D_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDCOMPONENTCOUNT = ( D3D_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_ONLYONEELEMENTPERSLOT + 1 ),
    D3D_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDSTARTCOMPONENTANDCOMPONENTCOUNT = ( D3D_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDCOMPONENTCOUNT + 1 ),
    D3D_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDGAPDEFINITION = ( D3D_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDSTARTCOMPONENTANDCOMPONENTCOUNT + 1 ),
    D3D_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_REPEATEDOUTPUT = ( D3D_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDGAPDEFINITION + 1 ),
    D3D_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDOUTPUTSTREAMSTRIDE = ( D3D_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_REPEATEDOUTPUT + 1 ),
    D3D_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_MISSINGSEMANTIC = ( D3D_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDOUTPUTSTREAMSTRIDE + 1 ),
    D3D_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_MASKMISMATCH = ( D3D_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_MISSINGSEMANTIC + 1 ),
    D3D_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_CANTHAVEONLYGAPS = ( D3D_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_MASKMISMATCH + 1 ),
    D3D_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_DECLTOOCOMPLEX = ( D3D_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_CANTHAVEONLYGAPS + 1 ),
    D3D_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_MISSINGOUTPUTSIGNATURE = ( D3D_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_DECLTOOCOMPLEX + 1 ),
    D3D_MESSAGE_ID_CREATEPIXELSHADER_OUTOFMEMORY = ( D3D_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_MISSINGOUTPUTSIGNATURE + 1 ),
    D3D_MESSAGE_ID_CREATEPIXELSHADER_INVALIDSHADERBYTECODE = ( D3D_MESSAGE_ID_CREATEPIXELSHADER_OUTOFMEMORY + 1 ),
    D3D_MESSAGE_ID_CREATEPIXELSHADER_INVALIDSHADERTYPE = ( D3D_MESSAGE_ID_CREATEPIXELSHADER_INVALIDSHADERBYTECODE + 1 ),
    D3D_MESSAGE_ID_CREATERASTERIZERSTATE_INVALIDFILLMODE = ( D3D_MESSAGE_ID_CREATEPIXELSHADER_INVALIDSHADERTYPE + 1 ),
    D3D_MESSAGE_ID_CREATERASTERIZERSTATE_INVALIDCULLMODE = ( D3D_MESSAGE_ID_CREATERASTERIZERSTATE_INVALIDFILLMODE + 1 ),
    D3D_MESSAGE_ID_CREATERASTERIZERSTATE_INVALIDDEPTHBIASCLAMP = ( D3D_MESSAGE_ID_CREATERASTERIZERSTATE_INVALIDCULLMODE + 1 ),
    D3D_MESSAGE_ID_CREATERASTERIZERSTATE_INVALIDSLOPESCALEDDEPTHBIAS = ( D3D_MESSAGE_ID_CREATERASTERIZERSTATE_INVALIDDEPTHBIASCLAMP + 1 ),
    D3D_MESSAGE_ID_CREATERASTERIZERSTATE_TOOMANYOBJECTS = ( D3D_MESSAGE_ID_CREATERASTERIZERSTATE_INVALIDSLOPESCALEDDEPTHBIAS + 1 ),
    D3D_MESSAGE_ID_CREATERASTERIZERSTATE_NULLDESC = ( D3D_MESSAGE_ID_CREATERASTERIZERSTATE_TOOMANYOBJECTS + 1 ),
    D3D_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDDEPTHWRITEMASK = ( D3D_MESSAGE_ID_CREATERASTERIZERSTATE_NULLDESC + 1 ),
    D3D_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDDEPTHFUNC = ( D3D_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDDEPTHWRITEMASK + 1 ),
    D3D_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDFRONTFACESTENCILFAILOP = ( D3D_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDDEPTHFUNC + 1 ),
    D3D_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDFRONTFACESTENCILZFAILOP = ( D3D_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDFRONTFACESTENCILFAILOP + 1 ),
    D3D_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDFRONTFACESTENCILPASSOP = ( D3D_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDFRONTFACESTENCILZFAILOP + 1 ),
    D3D_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDFRONTFACESTENCILFUNC = ( D3D_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDFRONTFACESTENCILPASSOP + 1 ),
    D3D_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDBACKFACESTENCILFAILOP = ( D3D_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDFRONTFACESTENCILFUNC + 1 ),
    D3D_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDBACKFACESTENCILZFAILOP = ( D3D_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDBACKFACESTENCILFAILOP + 1 ),
    D3D_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDBACKFACESTENCILPASSOP = ( D3D_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDBACKFACESTENCILZFAILOP + 1 ),
    D3D_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDBACKFACESTENCILFUNC = ( D3D_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDBACKFACESTENCILPASSOP + 1 ),
    D3D_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_TOOMANYOBJECTS = ( D3D_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDBACKFACESTENCILFUNC + 1 ),
    D3D_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_NULLDESC = ( D3D_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_TOOMANYOBJECTS + 1 ),
    D3D_MESSAGE_ID_CREATEBLENDSTATE_INVALIDSRCBLEND = ( D3D_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_NULLDESC + 1 ),
    D3D_MESSAGE_ID_CREATEBLENDSTATE_INVALIDDESTBLEND = ( D3D_MESSAGE_ID_CREATEBLENDSTATE_INVALIDSRCBLEND + 1 ),
    D3D_MESSAGE_ID_CREATEBLENDSTATE_INVALIDBLENDOP = ( D3D_MESSAGE_ID_CREATEBLENDSTATE_INVALIDDESTBLEND + 1 ),
    D3D_MESSAGE_ID_CREATEBLENDSTATE_INVALIDSRCBLENDALPHA = ( D3D_MESSAGE_ID_CREATEBLENDSTATE_INVALIDBLENDOP + 1 ),
    D3D_MESSAGE_ID_CREATEBLENDSTATE_INVALIDDESTBLENDALPHA = ( D3D_MESSAGE_ID_CREATEBLENDSTATE_INVALIDSRCBLENDALPHA + 1 ),
    D3D_MESSAGE_ID_CREATEBLENDSTATE_INVALIDBLENDOPALPHA = ( D3D_MESSAGE_ID_CREATEBLENDSTATE_INVALIDDESTBLENDALPHA + 1 ),
    D3D_MESSAGE_ID_CREATEBLENDSTATE_INVALIDRENDERTARGETWRITEMASK = ( D3D_MESSAGE_ID_CREATEBLENDSTATE_INVALIDBLENDOPALPHA + 1 ),
    D3D_MESSAGE_ID_CREATEBLENDSTATE_TOOMANYOBJECTS = ( D3D_MESSAGE_ID_CREATEBLENDSTATE_INVALIDRENDERTARGETWRITEMASK + 1 ),
    D3D_MESSAGE_ID_CREATEBLENDSTATE_NULLDESC = ( D3D_MESSAGE_ID_CREATEBLENDSTATE_TOOMANYOBJECTS + 1 ),
    D3D_MESSAGE_ID_CREATESAMPLERSTATE_INVALIDFILTER = ( D3D_MESSAGE_ID_CREATEBLENDSTATE_NULLDESC + 1 ),
    D3D_MESSAGE_ID_CREATESAMPLERSTATE_INVALIDADDRESSU = ( D3D_MESSAGE_ID_CREATESAMPLERSTATE_INVALIDFILTER + 1 ),
    D3D_MESSAGE_ID_CREATESAMPLERSTATE_INVALIDADDRESSV = ( D3D_MESSAGE_ID_CREATESAMPLERSTATE_INVALIDADDRESSU + 1 ),
    D3D_MESSAGE_ID_CREATESAMPLERSTATE_INVALIDADDRESSW = ( D3D_MESSAGE_ID_CREATESAMPLERSTATE_INVALIDADDRESSV + 1 ),
    D3D_MESSAGE_ID_CREATESAMPLERSTATE_INVALIDMIPLODBIAS = ( D3D_MESSAGE_ID_CREATESAMPLERSTATE_INVALIDADDRESSW + 1 ),
    D3D_MESSAGE_ID_CREATESAMPLERSTATE_INVALIDMAXANISOTROPY = ( D3D_MESSAGE_ID_CREATESAMPLERSTATE_INVALIDMIPLODBIAS + 1 ),
    D3D_MESSAGE_ID_CREATESAMPLERSTATE_INVALIDCOMPARISONFUNC = ( D3D_MESSAGE_ID_CREATESAMPLERSTATE_INVALIDMAXANISOTROPY + 1 ),
    D3D_MESSAGE_ID_CREATESAMPLERSTATE_INVALIDMINLOD = ( D3D_MESSAGE_ID_CREATESAMPLERSTATE_INVALIDCOMPARISONFUNC + 1 ),
    D3D_MESSAGE_ID_CREATESAMPLERSTATE_INVALIDMAXLOD = ( D3D_MESSAGE_ID_CREATESAMPLERSTATE_INVALIDMINLOD + 1 ),
    D3D_MESSAGE_ID_CREATESAMPLERSTATE_TOOMANYOBJECTS = ( D3D_MESSAGE_ID_CREATESAMPLERSTATE_INVALIDMAXLOD + 1 ),
    D3D_MESSAGE_ID_CREATESAMPLERSTATE_NULLDESC = ( D3D_MESSAGE_ID_CREATESAMPLERSTATE_TOOMANYOBJECTS + 1 ),
    D3D_MESSAGE_ID_CREATEQUERYORPREDICATE_INVALIDQUERY = ( D3D_MESSAGE_ID_CREATESAMPLERSTATE_NULLDESC + 1 ),
    D3D_MESSAGE_ID_CREATEQUERYORPREDICATE_INVALIDMISCFLAGS = ( D3D_MESSAGE_ID_CREATEQUERYORPREDICATE_INVALIDQUERY + 1 ),
    D3D_MESSAGE_ID_CREATEQUERYORPREDICATE_UNEXPECTEDMISCFLAG = ( D3D_MESSAGE_ID_CREATEQUERYORPREDICATE_INVALIDMISCFLAGS + 1 ),
    D3D_MESSAGE_ID_CREATEQUERYORPREDICATE_NULLDESC = ( D3D_MESSAGE_ID_CREATEQUERYORPREDICATE_UNEXPECTEDMISCFLAG + 1 ),
    D3D_MESSAGE_ID_DEVICE_IASETPRIMITIVETOPOLOGY_TOPOLOGY_UNRECOGNIZED = ( D3D_MESSAGE_ID_CREATEQUERYORPREDICATE_NULLDESC + 1 ),
    D3D_MESSAGE_ID_DEVICE_IASETPRIMITIVETOPOLOGY_TOPOLOGY_UNDEFINED = ( D3D_MESSAGE_ID_DEVICE_IASETPRIMITIVETOPOLOGY_TOPOLOGY_UNRECOGNIZED + 1 ),
    D3D_MESSAGE_ID_IASETVERTEXBUFFERS_INVALIDBUFFER = ( D3D_MESSAGE_ID_DEVICE_IASETPRIMITIVETOPOLOGY_TOPOLOGY_UNDEFINED + 1 ),
    D3D_MESSAGE_ID_DEVICE_IASETVERTEXBUFFERS_OFFSET_TOO_LARGE = ( D3D_MESSAGE_ID_IASETVERTEXBUFFERS_INVALIDBUFFER + 1 ),
    D3D_MESSAGE_ID_DEVICE_IASETVERTEXBUFFERS_BUFFERS_EMPTY = ( D3D_MESSAGE_ID_DEVICE_IASETVERTEXBUFFERS_OFFSET_TOO_LARGE + 1 ),
    D3D_MESSAGE_ID_IASETINDEXBUFFER_INVALIDBUFFER = ( D3D_MESSAGE_ID_DEVICE_IASETVERTEXBUFFERS_BUFFERS_EMPTY + 1 ),
    D3D_MESSAGE_ID_DEVICE_IASETINDEXBUFFER_FORMAT_INVALID = ( D3D_MESSAGE_ID_IASETINDEXBUFFER_INVALIDBUFFER + 1 ),
    D3D_MESSAGE_ID_DEVICE_IASETINDEXBUFFER_OFFSET_TOO_LARGE = ( D3D_MESSAGE_ID_DEVICE_IASETINDEXBUFFER_FORMAT_INVALID + 1 ),
    D3D_MESSAGE_ID_DEVICE_IASETINDEXBUFFER_OFFSET_UNALIGNED = ( D3D_MESSAGE_ID_DEVICE_IASETINDEXBUFFER_OFFSET_TOO_LARGE + 1 ),
    D3D_MESSAGE_ID_DEVICE_VSSETSHADERRESOURCES_VIEWS_EMPTY = ( D3D_MESSAGE_ID_DEVICE_IASETINDEXBUFFER_OFFSET_UNALIGNED + 1 ),
    D3D_MESSAGE_ID_VSSETCONSTANTBUFFERS_INVALIDBUFFER = ( D3D_MESSAGE_ID_DEVICE_VSSETSHADERRESOURCES_VIEWS_EMPTY + 1 ),
    D3D_MESSAGE_ID_DEVICE_VSSETCONSTANTBUFFERS_BUFFERS_EMPTY = ( D3D_MESSAGE_ID_VSSETCONSTANTBUFFERS_INVALIDBUFFER + 1 ),
    D3D_MESSAGE_ID_DEVICE_VSSETSAMPLERS_SAMPLERS_EMPTY = ( D3D_MESSAGE_ID_DEVICE_VSSETCONSTANTBUFFERS_BUFFERS_EMPTY + 1 ),
    D3D_MESSAGE_ID_DEVICE_GSSETSHADERRESOURCES_VIEWS_EMPTY = ( D3D_MESSAGE_ID_DEVICE_VSSETSAMPLERS_SAMPLERS_EMPTY + 1 ),
    D3D_MESSAGE_ID_GSSETCONSTANTBUFFERS_INVALIDBUFFER = ( D3D_MESSAGE_ID_DEVICE_GSSETSHADERRESOURCES_VIEWS_EMPTY + 1 ),
    D3D_MESSAGE_ID_DEVICE_GSSETCONSTANTBUFFERS_BUFFERS_EMPTY = ( D3D_MESSAGE_ID_GSSETCONSTANTBUFFERS_INVALIDBUFFER + 1 ),
    D3D_MESSAGE_ID_DEVICE_GSSETSAMPLERS_SAMPLERS_EMPTY = ( D3D_MESSAGE_ID_DEVICE_GSSETCONSTANTBUFFERS_BUFFERS_EMPTY + 1 ),
    D3D_MESSAGE_ID_SOSETTARGETS_INVALIDBUFFER = ( D3D_MESSAGE_ID_DEVICE_GSSETSAMPLERS_SAMPLERS_EMPTY + 1 ),
    D3D_MESSAGE_ID_DEVICE_SOSETTARGETS_OFFSET_UNALIGNED = ( D3D_MESSAGE_ID_SOSETTARGETS_INVALIDBUFFER + 1 ),
    D3D_MESSAGE_ID_DEVICE_PSSETSHADERRESOURCES_VIEWS_EMPTY = ( D3D_MESSAGE_ID_DEVICE_SOSETTARGETS_OFFSET_UNALIGNED + 1 ),
    D3D_MESSAGE_ID_PSSETCONSTANTBUFFERS_INVALIDBUFFER = ( D3D_MESSAGE_ID_DEVICE_PSSETSHADERRESOURCES_VIEWS_EMPTY + 1 ),
    D3D_MESSAGE_ID_DEVICE_PSSETCONSTANTBUFFERS_BUFFERS_EMPTY = ( D3D_MESSAGE_ID_PSSETCONSTANTBUFFERS_INVALIDBUFFER + 1 ),
    D3D_MESSAGE_ID_DEVICE_PSSETSAMPLERS_SAMPLERS_EMPTY = ( D3D_MESSAGE_ID_DEVICE_PSSETCONSTANTBUFFERS_BUFFERS_EMPTY + 1 ),
    D3D_MESSAGE_ID_DEVICE_RSSETVIEWPORTS_INVALIDVIEWPORT = ( D3D_MESSAGE_ID_DEVICE_PSSETSAMPLERS_SAMPLERS_EMPTY + 1 ),
    D3D_MESSAGE_ID_DEVICE_RSSETSCISSORRECTS_INVALIDSCISSOR = ( D3D_MESSAGE_ID_DEVICE_RSSETVIEWPORTS_INVALIDVIEWPORT + 1 ),
    D3D_MESSAGE_ID_CLEARRENDERTARGETVIEW_DENORMFLUSH = ( D3D_MESSAGE_ID_DEVICE_RSSETSCISSORRECTS_INVALIDSCISSOR + 1 ),
    D3D_MESSAGE_ID_CLEARDEPTHSTENCILVIEW_DENORMFLUSH = ( D3D_MESSAGE_ID_CLEARRENDERTARGETVIEW_DENORMFLUSH + 1 ),
    D3D_MESSAGE_ID_CLEARDEPTHSTENCILVIEW_INVALID = ( D3D_MESSAGE_ID_CLEARDEPTHSTENCILVIEW_DENORMFLUSH + 1 ),
    D3D_MESSAGE_ID_DEVICE_IAGETVERTEXBUFFERS_BUFFERS_EMPTY = ( D3D_MESSAGE_ID_CLEARDEPTHSTENCILVIEW_INVALID + 1 ),
    D3D_MESSAGE_ID_DEVICE_VSGETSHADERRESOURCES_VIEWS_EMPTY = ( D3D_MESSAGE_ID_DEVICE_IAGETVERTEXBUFFERS_BUFFERS_EMPTY + 1 ),
    D3D_MESSAGE_ID_DEVICE_VSGETCONSTANTBUFFERS_BUFFERS_EMPTY = ( D3D_MESSAGE_ID_DEVICE_VSGETSHADERRESOURCES_VIEWS_EMPTY + 1 ),
    D3D_MESSAGE_ID_DEVICE_VSGETSAMPLERS_SAMPLERS_EMPTY = ( D3D_MESSAGE_ID_DEVICE_VSGETCONSTANTBUFFERS_BUFFERS_EMPTY + 1 ),
    D3D_MESSAGE_ID_DEVICE_GSGETSHADERRESOURCES_VIEWS_EMPTY = ( D3D_MESSAGE_ID_DEVICE_VSGETSAMPLERS_SAMPLERS_EMPTY + 1 ),
    D3D_MESSAGE_ID_DEVICE_GSGETCONSTANTBUFFERS_BUFFERS_EMPTY = ( D3D_MESSAGE_ID_DEVICE_GSGETSHADERRESOURCES_VIEWS_EMPTY + 1 ),
    D3D_MESSAGE_ID_DEVICE_GSGETSAMPLERS_SAMPLERS_EMPTY = ( D3D_MESSAGE_ID_DEVICE_GSGETCONSTANTBUFFERS_BUFFERS_EMPTY + 1 ),
    D3D_MESSAGE_ID_DEVICE_SOGETTARGETS_BUFFERS_EMPTY = ( D3D_MESSAGE_ID_DEVICE_GSGETSAMPLERS_SAMPLERS_EMPTY + 1 ),
    D3D_MESSAGE_ID_DEVICE_PSGETSHADERRESOURCES_VIEWS_EMPTY = ( D3D_MESSAGE_ID_DEVICE_SOGETTARGETS_BUFFERS_EMPTY + 1 ),
    D3D_MESSAGE_ID_DEVICE_PSGETCONSTANTBUFFERS_BUFFERS_EMPTY = ( D3D_MESSAGE_ID_DEVICE_PSGETSHADERRESOURCES_VIEWS_EMPTY + 1 ),
    D3D_MESSAGE_ID_DEVICE_PSGETSAMPLERS_SAMPLERS_EMPTY = ( D3D_MESSAGE_ID_DEVICE_PSGETCONSTANTBUFFERS_BUFFERS_EMPTY + 1 ),
    D3D_MESSAGE_ID_DEVICE_RSGETVIEWPORTS_VIEWPORTS_EMPTY = ( D3D_MESSAGE_ID_DEVICE_PSGETSAMPLERS_SAMPLERS_EMPTY + 1 ),
    D3D_MESSAGE_ID_DEVICE_RSGETSCISSORRECTS_RECTS_EMPTY = ( D3D_MESSAGE_ID_DEVICE_RSGETVIEWPORTS_VIEWPORTS_EMPTY + 1 ),
    D3D_MESSAGE_ID_DEVICE_GENERATEMIPS_RESOURCE_INVALID = ( D3D_MESSAGE_ID_DEVICE_RSGETSCISSORRECTS_RECTS_EMPTY + 1 ),
    D3D_MESSAGE_ID_COPYSUBRESOURCEREGION_INVALIDDESTINATIONSUBRESOURCE = ( D3D_MESSAGE_ID_DEVICE_GENERATEMIPS_RESOURCE_INVALID + 1 ),
    D3D_MESSAGE_ID_COPYSUBRESOURCEREGION_INVALIDSOURCESUBRESOURCE = ( D3D_MESSAGE_ID_COPYSUBRESOURCEREGION_INVALIDDESTINATIONSUBRESOURCE + 1 ),
    D3D_MESSAGE_ID_COPYSUBRESOURCEREGION_INVALIDSOURCEBOX = ( D3D_MESSAGE_ID_COPYSUBRESOURCEREGION_INVALIDSOURCESUBRESOURCE + 1 ),
    D3D_MESSAGE_ID_COPYSUBRESOURCEREGION_INVALIDSOURCE = ( D3D_MESSAGE_ID_COPYSUBRESOURCEREGION_INVALIDSOURCEBOX + 1 ),
    D3D_MESSAGE_ID_COPYSUBRESOURCEREGION_INVALIDDESTINATIONSTATE = ( D3D_MESSAGE_ID_COPYSUBRESOURCEREGION_INVALIDSOURCE + 1 ),
    D3D_MESSAGE_ID_COPYSUBRESOURCEREGION_INVALIDSOURCESTATE = ( D3D_MESSAGE_ID_COPYSUBRESOURCEREGION_INVALIDDESTINATIONSTATE + 1 ),
    D3D_MESSAGE_ID_COPYRESOURCE_INVALIDSOURCE = ( D3D_MESSAGE_ID_COPYSUBRESOURCEREGION_INVALIDSOURCESTATE + 1 ),
    D3D_MESSAGE_ID_COPYRESOURCE_INVALIDDESTINATIONSTATE = ( D3D_MESSAGE_ID_COPYRESOURCE_INVALIDSOURCE + 1 ),
    D3D_MESSAGE_ID_COPYRESOURCE_INVALIDSOURCESTATE = ( D3D_MESSAGE_ID_COPYRESOURCE_INVALIDDESTINATIONSTATE + 1 ),
    D3D_MESSAGE_ID_UPDATESUBRESOURCE_INVALIDDESTINATIONSUBRESOURCE = ( D3D_MESSAGE_ID_COPYRESOURCE_INVALIDSOURCESTATE + 1 ),
    D3D_MESSAGE_ID_UPDATESUBRESOURCE_INVALIDDESTINATIONBOX = ( D3D_MESSAGE_ID_UPDATESUBRESOURCE_INVALIDDESTINATIONSUBRESOURCE + 1 ),
    D3D_MESSAGE_ID_UPDATESUBRESOURCE_INVALIDDESTINATIONSTATE = ( D3D_MESSAGE_ID_UPDATESUBRESOURCE_INVALIDDESTINATIONBOX + 1 ),
    D3D_MESSAGE_ID_DEVICE_RESOLVESUBRESOURCE_DESTINATION_INVALID = ( D3D_MESSAGE_ID_UPDATESUBRESOURCE_INVALIDDESTINATIONSTATE + 1 ),
    D3D_MESSAGE_ID_DEVICE_RESOLVESUBRESOURCE_DESTINATION_SUBRESOURCE_INVALID = ( D3D_MESSAGE_ID_DEVICE_RESOLVESUBRESOURCE_DESTINATION_INVALID + 1 ),
    D3D_MESSAGE_ID_DEVICE_RESOLVESUBRESOURCE_SOURCE_INVALID = ( D3D_MESSAGE_ID_DEVICE_RESOLVESUBRESOURCE_DESTINATION_SUBRESOURCE_INVALID + 1 ),
    D3D_MESSAGE_ID_DEVICE_RESOLVESUBRESOURCE_SOURCE_SUBRESOURCE_INVALID = ( D3D_MESSAGE_ID_DEVICE_RESOLVESUBRESOURCE_SOURCE_INVALID + 1 ),
    D3D_MESSAGE_ID_DEVICE_RESOLVESUBRESOURCE_FORMAT_INVALID = ( D3D_MESSAGE_ID_DEVICE_RESOLVESUBRESOURCE_SOURCE_SUBRESOURCE_INVALID + 1 ),
    D3D_MESSAGE_ID_BUFFER_MAP_INVALIDMAPTYPE = ( D3D_MESSAGE_ID_DEVICE_RESOLVESUBRESOURCE_FORMAT_INVALID + 1 ),
    D3D_MESSAGE_ID_BUFFER_MAP_INVALIDFLAGS = ( D3D_MESSAGE_ID_BUFFER_MAP_INVALIDMAPTYPE + 1 ),
    D3D_MESSAGE_ID_BUFFER_MAP_ALREADYMAPPED = ( D3D_MESSAGE_ID_BUFFER_MAP_INVALIDFLAGS + 1 ),
    D3D_MESSAGE_ID_BUFFER_MAP_DEVICEREMOVED_RETURN = ( D3D_MESSAGE_ID_BUFFER_MAP_ALREADYMAPPED + 1 ),
    D3D_MESSAGE_ID_BUFFER_UNMAP_NOTMAPPED = ( D3D_MESSAGE_ID_BUFFER_MAP_DEVICEREMOVED_RETURN + 1 ),
    D3D_MESSAGE_ID_TEXTURE1D_MAP_INVALIDMAPTYPE = ( D3D_MESSAGE_ID_BUFFER_UNMAP_NOTMAPPED + 1 ),
    D3D_MESSAGE_ID_TEXTURE1D_MAP_INVALIDSUBRESOURCE = ( D3D_MESSAGE_ID_TEXTURE1D_MAP_INVALIDMAPTYPE + 1 ),
    D3D_MESSAGE_ID_TEXTURE1D_MAP_INVALIDFLAGS = ( D3D_MESSAGE_ID_TEXTURE1D_MAP_INVALIDSUBRESOURCE + 1 ),
    D3D_MESSAGE_ID_TEXTURE1D_MAP_ALREADYMAPPED = ( D3D_MESSAGE_ID_TEXTURE1D_MAP_INVALIDFLAGS + 1 ),
    D3D_MESSAGE_ID_TEXTURE1D_MAP_DEVICEREMOVED_RETURN = ( D3D_MESSAGE_ID_TEXTURE1D_MAP_ALREADYMAPPED + 1 ),
    D3D_MESSAGE_ID_TEXTURE1D_UNMAP_INVALIDSUBRESOURCE = ( D3D_MESSAGE_ID_TEXTURE1D_MAP_DEVICEREMOVED_RETURN + 1 ),
    D3D_MESSAGE_ID_TEXTURE1D_UNMAP_NOTMAPPED = ( D3D_MESSAGE_ID_TEXTURE1D_UNMAP_INVALIDSUBRESOURCE + 1 ),
    D3D_MESSAGE_ID_TEXTURE2D_MAP_INVALIDMAPTYPE = ( D3D_MESSAGE_ID_TEXTURE1D_UNMAP_NOTMAPPED + 1 ),
    D3D_MESSAGE_ID_TEXTURE2D_MAP_INVALIDSUBRESOURCE = ( D3D_MESSAGE_ID_TEXTURE2D_MAP_INVALIDMAPTYPE + 1 ),
    D3D_MESSAGE_ID_TEXTURE2D_MAP_INVALIDFLAGS = ( D3D_MESSAGE_ID_TEXTURE2D_MAP_INVALIDSUBRESOURCE + 1 ),
    D3D_MESSAGE_ID_TEXTURE2D_MAP_ALREADYMAPPED = ( D3D_MESSAGE_ID_TEXTURE2D_MAP_INVALIDFLAGS + 1 ),
    D3D_MESSAGE_ID_TEXTURE2D_MAP_DEVICEREMOVED_RETURN = ( D3D_MESSAGE_ID_TEXTURE2D_MAP_ALREADYMAPPED + 1 ),
    D3D_MESSAGE_ID_TEXTURE2D_UNMAP_INVALIDSUBRESOURCE = ( D3D_MESSAGE_ID_TEXTURE2D_MAP_DEVICEREMOVED_RETURN + 1 ),
    D3D_MESSAGE_ID_TEXTURE2D_UNMAP_NOTMAPPED = ( D3D_MESSAGE_ID_TEXTURE2D_UNMAP_INVALIDSUBRESOURCE + 1 ),
    D3D_MESSAGE_ID_TEXTURE3D_MAP_INVALIDMAPTYPE = ( D3D_MESSAGE_ID_TEXTURE2D_UNMAP_NOTMAPPED + 1 ),
    D3D_MESSAGE_ID_TEXTURE3D_MAP_INVALIDSUBRESOURCE = ( D3D_MESSAGE_ID_TEXTURE3D_MAP_INVALIDMAPTYPE + 1 ),
    D3D_MESSAGE_ID_TEXTURE3D_MAP_INVALIDFLAGS = ( D3D_MESSAGE_ID_TEXTURE3D_MAP_INVALIDSUBRESOURCE + 1 ),
    D3D_MESSAGE_ID_TEXTURE3D_MAP_ALREADYMAPPED = ( D3D_MESSAGE_ID_TEXTURE3D_MAP_INVALIDFLAGS + 1 ),
    D3D_MESSAGE_ID_TEXTURE3D_MAP_DEVICEREMOVED_RETURN = ( D3D_MESSAGE_ID_TEXTURE3D_MAP_ALREADYMAPPED + 1 ),
    D3D_MESSAGE_ID_TEXTURE3D_UNMAP_INVALIDSUBRESOURCE = ( D3D_MESSAGE_ID_TEXTURE3D_MAP_DEVICEREMOVED_RETURN + 1 ),
    D3D_MESSAGE_ID_TEXTURE3D_UNMAP_NOTMAPPED = ( D3D_MESSAGE_ID_TEXTURE3D_UNMAP_INVALIDSUBRESOURCE + 1 ),
    D3D_MESSAGE_ID_CHECKFORMATSUPPORT_FORMAT_DEPRECATED = ( D3D_MESSAGE_ID_TEXTURE3D_UNMAP_NOTMAPPED + 1 ),
    D3D_MESSAGE_ID_CHECKMULTISAMPLEQUALITYLEVELS_FORMAT_DEPRECATED = ( D3D_MESSAGE_ID_CHECKFORMATSUPPORT_FORMAT_DEPRECATED + 1 ),
    D3D_MESSAGE_ID_SETEXCEPTIONMODE_UNRECOGNIZEDFLAGS = ( D3D_MESSAGE_ID_CHECKMULTISAMPLEQUALITYLEVELS_FORMAT_DEPRECATED + 1 ),
    D3D_MESSAGE_ID_SETEXCEPTIONMODE_INVALIDARG_RETURN = ( D3D_MESSAGE_ID_SETEXCEPTIONMODE_UNRECOGNIZEDFLAGS + 1 ),
    D3D_MESSAGE_ID_SETEXCEPTIONMODE_DEVICEREMOVED_RETURN = ( D3D_MESSAGE_ID_SETEXCEPTIONMODE_INVALIDARG_RETURN + 1 ),
    D3D_MESSAGE_ID_REF_SIMULATING_INFINITELY_FAST_HARDWARE = ( D3D_MESSAGE_ID_SETEXCEPTIONMODE_DEVICEREMOVED_RETURN + 1 ),
    D3D_MESSAGE_ID_REF_THREADING_MODE = ( D3D_MESSAGE_ID_REF_SIMULATING_INFINITELY_FAST_HARDWARE + 1 ),
    D3D_MESSAGE_ID_REF_UMDRIVER_EXCEPTION = ( D3D_MESSAGE_ID_REF_THREADING_MODE + 1 ),
    D3D_MESSAGE_ID_REF_KMDRIVER_EXCEPTION = ( D3D_MESSAGE_ID_REF_UMDRIVER_EXCEPTION + 1 ),
    D3D_MESSAGE_ID_REF_HARDWARE_EXCEPTION = ( D3D_MESSAGE_ID_REF_KMDRIVER_EXCEPTION + 1 ),
    D3D_MESSAGE_ID_REF_ACCESSING_INDEXABLE_TEMP_OUT_OF_RANGE = ( D3D_MESSAGE_ID_REF_HARDWARE_EXCEPTION + 1 ),
    D3D_MESSAGE_ID_REF_PROBLEM_PARSING_SHADER = ( D3D_MESSAGE_ID_REF_ACCESSING_INDEXABLE_TEMP_OUT_OF_RANGE + 1 ),
    D3D_MESSAGE_ID_REF_OUT_OF_MEMORY = ( D3D_MESSAGE_ID_REF_PROBLEM_PARSING_SHADER + 1 ),
    D3D_MESSAGE_ID_REF_INFO = ( D3D_MESSAGE_ID_REF_OUT_OF_MEMORY + 1 ),
    D3D_MESSAGE_ID_DEVICE_DRAW_VERTEXPOS_OVERFLOW = ( D3D_MESSAGE_ID_REF_INFO + 1 ),
    D3D_MESSAGE_ID_DEVICE_DRAWINDEXED_INDEXPOS_OVERFLOW = ( D3D_MESSAGE_ID_DEVICE_DRAW_VERTEXPOS_OVERFLOW + 1 ),
    D3D_MESSAGE_ID_DEVICE_DRAWINSTANCED_VERTEXPOS_OVERFLOW = ( D3D_MESSAGE_ID_DEVICE_DRAWINDEXED_INDEXPOS_OVERFLOW + 1 ),
    D3D_MESSAGE_ID_DEVICE_DRAWINSTANCED_INSTANCEPOS_OVERFLOW = ( D3D_MESSAGE_ID_DEVICE_DRAWINSTANCED_VERTEXPOS_OVERFLOW + 1 ),
    D3D_MESSAGE_ID_DEVICE_DRAWINDEXEDINSTANCED_INSTANCEPOS_OVERFLOW = ( D3D_MESSAGE_ID_DEVICE_DRAWINSTANCED_INSTANCEPOS_OVERFLOW + 1 ),
    D3D_MESSAGE_ID_DEVICE_DRAWINDEXEDINSTANCED_INDEXPOS_OVERFLOW = ( D3D_MESSAGE_ID_DEVICE_DRAWINDEXEDINSTANCED_INSTANCEPOS_OVERFLOW + 1 ),
    D3D_MESSAGE_ID_DEVICE_DRAW_VERTEX_SHADER_NOT_SET = ( D3D_MESSAGE_ID_DEVICE_DRAWINDEXEDINSTANCED_INDEXPOS_OVERFLOW + 1 ),
    D3D_MESSAGE_ID_DEVICE_SHADER_LINKAGE_SEMANTICNAME_NOT_FOUND = ( D3D_MESSAGE_ID_DEVICE_DRAW_VERTEX_SHADER_NOT_SET + 1 ),
    D3D_MESSAGE_ID_DEVICE_SHADER_LINKAGE_REGISTERINDEX = ( D3D_MESSAGE_ID_DEVICE_SHADER_LINKAGE_SEMANTICNAME_NOT_FOUND + 1 ),
    D3D_MESSAGE_ID_DEVICE_SHADER_LINKAGE_COMPONENTTYPE = ( D3D_MESSAGE_ID_DEVICE_SHADER_LINKAGE_REGISTERINDEX + 1 ),
    D3D_MESSAGE_ID_DEVICE_SHADER_LINKAGE_REGISTERMASK = ( D3D_MESSAGE_ID_DEVICE_SHADER_LINKAGE_COMPONENTTYPE + 1 ),
    D3D_MESSAGE_ID_DEVICE_SHADER_LINKAGE_SYSTEMVALUE = ( D3D_MESSAGE_ID_DEVICE_SHADER_LINKAGE_REGISTERMASK + 1 ),
    D3D_MESSAGE_ID_DEVICE_SHADER_LINKAGE_NEVERWRITTEN_ALWAYSREADS = ( D3D_MESSAGE_ID_DEVICE_SHADER_LINKAGE_SYSTEMVALUE + 1 ),
    D3D_MESSAGE_ID_DEVICE_DRAW_VERTEX_BUFFER_NOT_SET = ( D3D_MESSAGE_ID_DEVICE_SHADER_LINKAGE_NEVERWRITTEN_ALWAYSREADS + 1 ),
    D3D_MESSAGE_ID_DEVICE_DRAW_INPUTLAYOUT_NOT_SET = ( D3D_MESSAGE_ID_DEVICE_DRAW_VERTEX_BUFFER_NOT_SET + 1 ),
    D3D_MESSAGE_ID_DEVICE_DRAW_CONSTANT_BUFFER_NOT_SET = ( D3D_MESSAGE_ID_DEVICE_DRAW_INPUTLAYOUT_NOT_SET + 1 ),
    D3D_MESSAGE_ID_DEVICE_DRAW_CONSTANT_BUFFER_TOO_SMALL = ( D3D_MESSAGE_ID_DEVICE_DRAW_CONSTANT_BUFFER_NOT_SET + 1 ),
    D3D_MESSAGE_ID_DEVICE_DRAW_SAMPLER_NOT_SET = ( D3D_MESSAGE_ID_DEVICE_DRAW_CONSTANT_BUFFER_TOO_SMALL + 1 ),
    D3D_MESSAGE_ID_DEVICE_DRAW_SHADERRESOURCEVIEW_NOT_SET = ( D3D_MESSAGE_ID_DEVICE_DRAW_SAMPLER_NOT_SET + 1 ),
    D3D_MESSAGE_ID_DEVICE_DRAW_VIEW_DIMENSION_MISMATCH = ( D3D_MESSAGE_ID_DEVICE_DRAW_SHADERRESOURCEVIEW_NOT_SET + 1 ),
    D3D_MESSAGE_ID_DEVICE_DRAW_VERTEX_BUFFER_STRIDE_TOO_SMALL = ( D3D_MESSAGE_ID_DEVICE_DRAW_VIEW_DIMENSION_MISMATCH + 1 ),
    D3D_MESSAGE_ID_DEVICE_DRAW_VERTEX_BUFFER_TOO_SMALL = ( D3D_MESSAGE_ID_DEVICE_DRAW_VERTEX_BUFFER_STRIDE_TOO_SMALL + 1 ),
    D3D_MESSAGE_ID_DEVICE_DRAW_INDEX_BUFFER_NOT_SET = ( D3D_MESSAGE_ID_DEVICE_DRAW_VERTEX_BUFFER_TOO_SMALL + 1 ),
    D3D_MESSAGE_ID_DEVICE_DRAW_INDEX_BUFFER_FORMAT_INVALID = ( D3D_MESSAGE_ID_DEVICE_DRAW_INDEX_BUFFER_NOT_SET + 1 ),
    D3D_MESSAGE_ID_DEVICE_DRAW_INDEX_BUFFER_TOO_SMALL = ( D3D_MESSAGE_ID_DEVICE_DRAW_INDEX_BUFFER_FORMAT_INVALID + 1 ),
    D3D_MESSAGE_ID_DEVICE_DRAW_GS_INPUT_PRIMITIVE_MISMATCH = ( D3D_MESSAGE_ID_DEVICE_DRAW_INDEX_BUFFER_TOO_SMALL + 1 ),
    D3D_MESSAGE_ID_DEVICE_DRAW_RESOURCE_RETURN_TYPE_MISMATCH = ( D3D_MESSAGE_ID_DEVICE_DRAW_GS_INPUT_PRIMITIVE_MISMATCH + 1 ),
    D3D_MESSAGE_ID_DEVICE_DRAW_POSITION_NOT_PRESENT = ( D3D_MESSAGE_ID_DEVICE_DRAW_RESOURCE_RETURN_TYPE_MISMATCH + 1 ),
    D3D_MESSAGE_ID_DEVICE_DRAW_OUTPUT_STREAM_NOT_SET = ( D3D_MESSAGE_ID_DEVICE_DRAW_POSITION_NOT_PRESENT + 1 ),
    D3D_MESSAGE_ID_DEVICE_DRAW_BOUND_RESOURCE_MAPPED = ( D3D_MESSAGE_ID_DEVICE_DRAW_OUTPUT_STREAM_NOT_SET + 1 ),
    D3D_MESSAGE_ID_DEVICE_DRAW_INVALID_PRIMITIVETOPOLOGY = ( D3D_MESSAGE_ID_DEVICE_DRAW_BOUND_RESOURCE_MAPPED + 1 ),
    D3D_MESSAGE_ID_DEVICE_DRAW_VERTEX_OFFSET_UNALIGNED = ( D3D_MESSAGE_ID_DEVICE_DRAW_INVALID_PRIMITIVETOPOLOGY + 1 ),
    D3D_MESSAGE_ID_DEVICE_DRAW_VERTEX_STRIDE_UNALIGNED = ( D3D_MESSAGE_ID_DEVICE_DRAW_VERTEX_OFFSET_UNALIGNED + 1 ),
    D3D_MESSAGE_ID_DEVICE_DRAW_INDEX_OFFSET_UNALIGNED = ( D3D_MESSAGE_ID_DEVICE_DRAW_VERTEX_STRIDE_UNALIGNED + 1 ),
    D3D_MESSAGE_ID_DEVICE_DRAW_OUTPUT_STREAM_OFFSET_UNALIGNED = ( D3D_MESSAGE_ID_DEVICE_DRAW_INDEX_OFFSET_UNALIGNED + 1 ),
    D3D_MESSAGE_ID_DEVICE_DRAW_RESOURCE_FORMAT_LD_UNSUPPORTED = ( D3D_MESSAGE_ID_DEVICE_DRAW_OUTPUT_STREAM_OFFSET_UNALIGNED + 1 ),
    D3D_MESSAGE_ID_DEVICE_DRAW_RESOURCE_FORMAT_SAMPLE_UNSUPPORTED = ( D3D_MESSAGE_ID_DEVICE_DRAW_RESOURCE_FORMAT_LD_UNSUPPORTED + 1 ),
    D3D_MESSAGE_ID_DEVICE_DRAW_RESOURCE_FORMAT_SAMPLE_C_UNSUPPORTED = ( D3D_MESSAGE_ID_DEVICE_DRAW_RESOURCE_FORMAT_SAMPLE_UNSUPPORTED + 1 ),
    D3D_MESSAGE_ID_DEVICE_DRAW_RESOURCE_MULTISAMPLE_UNSUPPORTED = ( D3D_MESSAGE_ID_DEVICE_DRAW_RESOURCE_FORMAT_SAMPLE_C_UNSUPPORTED + 1 ),
    D3D_MESSAGE_ID_DEVICE_DRAW_SO_TARGETS_BOUND_WITHOUT_SOURCE = ( D3D_MESSAGE_ID_DEVICE_DRAW_RESOURCE_MULTISAMPLE_UNSUPPORTED + 1 ),
    D3D_MESSAGE_ID_DEVICE_DRAW_SO_STRIDE_LARGER_THAN_BUFFER = ( D3D_MESSAGE_ID_DEVICE_DRAW_SO_TARGETS_BOUND_WITHOUT_SOURCE + 1 ),
    D3D_MESSAGE_ID_DEVICE_DRAW_OM_RENDER_TARGET_DOES_NOT_SUPPORT_BLENDING = ( D3D_MESSAGE_ID_DEVICE_DRAW_SO_STRIDE_LARGER_THAN_BUFFER + 1 ),
    D3D_MESSAGE_ID_DEVICE_DRAW_OM_DUAL_SOURCE_BLENDING_CAN_ONLY_HAVE_RENDER_TARGET_0 = ( D3D_MESSAGE_ID_DEVICE_DRAW_OM_RENDER_TARGET_DOES_NOT_SUPPORT_BLENDING + 1 ),
    D3D_MESSAGE_ID_DEVICE_REMOVAL_PROCESS_AT_FAULT = ( D3D_MESSAGE_ID_DEVICE_DRAW_OM_DUAL_SOURCE_BLENDING_CAN_ONLY_HAVE_RENDER_TARGET_0 + 1 ),
    D3D_MESSAGE_ID_DEVICE_REMOVAL_PROCESS_POSSIBLY_AT_FAULT = ( D3D_MESSAGE_ID_DEVICE_REMOVAL_PROCESS_AT_FAULT + 1 ),
    D3D_MESSAGE_ID_DEVICE_REMOVAL_PROCESS_NOT_AT_FAULT = ( D3D_MESSAGE_ID_DEVICE_REMOVAL_PROCESS_POSSIBLY_AT_FAULT + 1 ),
    D3D_MESSAGE_ID_DEVICE_OPEN_SHARED_RESOURCE_INVALIDARG_RETURN = ( D3D_MESSAGE_ID_DEVICE_REMOVAL_PROCESS_NOT_AT_FAULT + 1 ),
    D3D_MESSAGE_ID_DEVICE_OPEN_SHARED_RESOURCE_OUTOFMEMORY_RETURN = ( D3D_MESSAGE_ID_DEVICE_OPEN_SHARED_RESOURCE_INVALIDARG_RETURN + 1 ),
    D3D_MESSAGE_ID_DEVICE_OPEN_SHARED_RESOURCE_BADINTERFACE_RETURN = ( D3D_MESSAGE_ID_DEVICE_OPEN_SHARED_RESOURCE_OUTOFMEMORY_RETURN + 1 ),
    D3D_MESSAGE_ID_DEVICE_DRAW_VIEWPORT_NOT_SET = ( D3D_MESSAGE_ID_DEVICE_OPEN_SHARED_RESOURCE_BADINTERFACE_RETURN + 1 ),
    D3D_MESSAGE_ID_CREATEINPUTLAYOUT_TRAILING_DIGIT_IN_SEMANTIC = ( D3D_MESSAGE_ID_DEVICE_DRAW_VIEWPORT_NOT_SET + 1 ),
    D3D_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_TRAILING_DIGIT_IN_SEMANTIC = ( D3D_MESSAGE_ID_CREATEINPUTLAYOUT_TRAILING_DIGIT_IN_SEMANTIC + 1 ),
    D3D_MESSAGE_ID_DEVICE_RSSETVIEWPORTS_DENORMFLUSH = ( D3D_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_TRAILING_DIGIT_IN_SEMANTIC + 1 ),
    D3D_MESSAGE_ID_OMSETRENDERTARGETS_INVALIDVIEW = ( D3D_MESSAGE_ID_DEVICE_RSSETVIEWPORTS_DENORMFLUSH + 1 ),
    D3D_MESSAGE_ID_DEVICE_SETTEXTFILTERSIZE_INVALIDDIMENSIONS = ( D3D_MESSAGE_ID_OMSETRENDERTARGETS_INVALIDVIEW + 1 ),
    D3D_MESSAGE_ID_DEVICE_DRAW_SAMPLER_MISMATCH = ( D3D_MESSAGE_ID_DEVICE_SETTEXTFILTERSIZE_INVALIDDIMENSIONS + 1 ),
    D3D_MESSAGE_ID_CREATEINPUTLAYOUT_TYPE_MISMATCH = ( D3D_MESSAGE_ID_DEVICE_DRAW_SAMPLER_MISMATCH + 1 ),
    D3D_MESSAGE_ID_BLENDSTATE_GETDESC_LEGACY = ( D3D_MESSAGE_ID_CREATEINPUTLAYOUT_TYPE_MISMATCH + 1 ),
    D3D_MESSAGE_ID_SHADERRESOURCEVIEW_GETDESC_LEGACY = ( D3D_MESSAGE_ID_BLENDSTATE_GETDESC_LEGACY + 1 ),
    D3D_MESSAGE_ID_CREATEQUERY_OUTOFMEMORY_RETURN = ( D3D_MESSAGE_ID_SHADERRESOURCEVIEW_GETDESC_LEGACY + 1 ),
    D3D_MESSAGE_ID_CREATEPREDICATE_OUTOFMEMORY_RETURN = ( D3D_MESSAGE_ID_CREATEQUERY_OUTOFMEMORY_RETURN + 1 ),
    D3D_MESSAGE_ID_CREATECOUNTER_OUTOFRANGE_COUNTER = ( D3D_MESSAGE_ID_CREATEPREDICATE_OUTOFMEMORY_RETURN + 1 ),
    D3D_MESSAGE_ID_CREATECOUNTER_SIMULTANEOUS_ACTIVE_COUNTERS_EXHAUSTED = ( D3D_MESSAGE_ID_CREATECOUNTER_OUTOFRANGE_COUNTER + 1 ),
    D3D_MESSAGE_ID_CREATECOUNTER_UNSUPPORTED_WELLKNOWN_COUNTER = ( D3D_MESSAGE_ID_CREATECOUNTER_SIMULTANEOUS_ACTIVE_COUNTERS_EXHAUSTED + 1 ),
    D3D_MESSAGE_ID_CREATECOUNTER_OUTOFMEMORY_RETURN = ( D3D_MESSAGE_ID_CREATECOUNTER_UNSUPPORTED_WELLKNOWN_COUNTER + 1 ),
    D3D_MESSAGE_ID_CREATECOUNTER_NONEXCLUSIVE_RETURN = ( D3D_MESSAGE_ID_CREATECOUNTER_OUTOFMEMORY_RETURN + 1 ),
    D3D_MESSAGE_ID_CREATECOUNTER_NULLDESC = ( D3D_MESSAGE_ID_CREATECOUNTER_NONEXCLUSIVE_RETURN + 1 ),
    D3D_MESSAGE_ID_CHECKCOUNTER_OUTOFRANGE_COUNTER = ( D3D_MESSAGE_ID_CREATECOUNTER_NULLDESC + 1 ),
    D3D_MESSAGE_ID_CHECKCOUNTER_UNSUPPORTED_WELLKNOWN_COUNTER = ( D3D_MESSAGE_ID_CHECKCOUNTER_OUTOFRANGE_COUNTER + 1 ),
    D3D_MESSAGE_ID_SETPREDICATION_INVALID_PREDICATE_STATE = ( D3D_MESSAGE_ID_CHECKCOUNTER_UNSUPPORTED_WELLKNOWN_COUNTER + 1 ),
    D3D_MESSAGE_ID_QUERY_BEGIN_UNSUPPORTED = ( D3D_MESSAGE_ID_SETPREDICATION_INVALID_PREDICATE_STATE + 1 ),
    D3D_MESSAGE_ID_PREDICATE_BEGIN_DURING_PREDICATION = ( D3D_MESSAGE_ID_QUERY_BEGIN_UNSUPPORTED + 1 ),
    D3D_MESSAGE_ID_QUERY_BEGIN_DUPLICATE = ( D3D_MESSAGE_ID_PREDICATE_BEGIN_DURING_PREDICATION + 1 ),
    D3D_MESSAGE_ID_QUERY_BEGIN_ABANDONING_PREVIOUS_RESULTS = ( D3D_MESSAGE_ID_QUERY_BEGIN_DUPLICATE + 1 ),
    D3D_MESSAGE_ID_PREDICATE_END_DURING_PREDICATION = ( D3D_MESSAGE_ID_QUERY_BEGIN_ABANDONING_PREVIOUS_RESULTS + 1 ),
    D3D_MESSAGE_ID_QUERY_END_ABANDONING_PREVIOUS_RESULTS = ( D3D_MESSAGE_ID_PREDICATE_END_DURING_PREDICATION + 1 ),
    D3D_MESSAGE_ID_QUERY_END_WITHOUT_BEGIN = ( D3D_MESSAGE_ID_QUERY_END_ABANDONING_PREVIOUS_RESULTS + 1 ),
    D3D_MESSAGE_ID_QUERY_GETDATA_INVALID_DATASIZE = ( D3D_MESSAGE_ID_QUERY_END_WITHOUT_BEGIN + 1 ),
    D3D_MESSAGE_ID_QUERY_GETDATA_INVALID_FLAGS = ( D3D_MESSAGE_ID_QUERY_GETDATA_INVALID_DATASIZE + 1 ),
    D3D_MESSAGE_ID_QUERY_GETDATA_INVALID_CALL = ( D3D_MESSAGE_ID_QUERY_GETDATA_INVALID_FLAGS + 1 ),
    D3D_MESSAGE_ID_DEVICE_DRAW_PS_OUTPUT_TYPE_MISMATCH = ( D3D_MESSAGE_ID_QUERY_GETDATA_INVALID_CALL + 1 ),
    D3D_MESSAGE_ID_DEVICE_DRAW_RESOURCE_FORMAT_GATHER_UNSUPPORTED = ( D3D_MESSAGE_ID_DEVICE_DRAW_PS_OUTPUT_TYPE_MISMATCH + 1 ),
    D3D_MESSAGE_ID_DEVICE_DRAW_INVALID_USE_OF_CENTER_MULTISAMPLE_PATTERN = ( D3D_MESSAGE_ID_DEVICE_DRAW_RESOURCE_FORMAT_GATHER_UNSUPPORTED + 1 ),
    D3D_MESSAGE_ID_DEVICE_IASETVERTEXBUFFERS_STRIDE_TOO_LARGE = ( D3D_MESSAGE_ID_DEVICE_DRAW_INVALID_USE_OF_CENTER_MULTISAMPLE_PATTERN + 1 ),
    D3D_MESSAGE_ID_DEVICE_IASETVERTEXBUFFERS_INVALIDRANGE = ( D3D_MESSAGE_ID_DEVICE_IASETVERTEXBUFFERS_STRIDE_TOO_LARGE + 1 ),
    D3D_MESSAGE_ID_CREATEINPUTLAYOUT_EMPTY_LAYOUT = ( D3D_MESSAGE_ID_DEVICE_IASETVERTEXBUFFERS_INVALIDRANGE + 1 ),
    D3D_MESSAGE_ID_DEVICE_DRAW_RESOURCE_SAMPLE_COUNT_MISMATCH = ( D3D_MESSAGE_ID_CREATEINPUTLAYOUT_EMPTY_LAYOUT + 1 ),
    D3D_MESSAGE_ID_D3D_MESSAGES_END = ( D3D_MESSAGE_ID_DEVICE_DRAW_RESOURCE_SAMPLE_COUNT_MISMATCH + 1 ),
    D3D_MESSAGE_ID_D3D_L9_MESSAGES_START = 0x100000,
    D3D_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_STENCIL_NO_TWO_SIDED = ( D3D_MESSAGE_ID_D3D_L9_MESSAGES_START + 1 ),
    D3D_MESSAGE_ID_CREATERASTERIZERSTATE_DepthBiasClamp_NOT_SUPPORTED = ( D3D_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_STENCIL_NO_TWO_SIDED + 1 ),
    D3D_MESSAGE_ID_CREATESAMPLERSTATE_NO_COMPARISON_SUPPORT = ( D3D_MESSAGE_ID_CREATERASTERIZERSTATE_DepthBiasClamp_NOT_SUPPORTED + 1 ),
    D3D_MESSAGE_ID_CREATESAMPLERSTATE_EXCESSIVE_ANISOTROPY = ( D3D_MESSAGE_ID_CREATESAMPLERSTATE_NO_COMPARISON_SUPPORT + 1 ),
    D3D_MESSAGE_ID_CREATESAMPLERSTATE_BORDER_OUT_OF_RANGE = ( D3D_MESSAGE_ID_CREATESAMPLERSTATE_EXCESSIVE_ANISOTROPY + 1 ),
    D3D_MESSAGE_ID_VSSETSAMPLERS_NOT_SUPPORTED = ( D3D_MESSAGE_ID_CREATESAMPLERSTATE_BORDER_OUT_OF_RANGE + 1 ),
    D3D_MESSAGE_ID_VSSETSAMPLERS_TOO_MANY_SAMPLERS = ( D3D_MESSAGE_ID_VSSETSAMPLERS_NOT_SUPPORTED + 1 ),
    D3D_MESSAGE_ID_PSSETSAMPLERS_TOO_MANY_SAMPLERS = ( D3D_MESSAGE_ID_VSSETSAMPLERS_TOO_MANY_SAMPLERS + 1 ),
    D3D_MESSAGE_ID_CREATERESOURCE_NO_ARRAYS = ( D3D_MESSAGE_ID_PSSETSAMPLERS_TOO_MANY_SAMPLERS + 1 ),
    D3D_MESSAGE_ID_CREATERESOURCE_NO_VB_AND_IB_BIND = ( D3D_MESSAGE_ID_CREATERESOURCE_NO_ARRAYS + 1 ),
    D3D_MESSAGE_ID_CREATERESOURCE_NO_TEXTURE_1D = ( D3D_MESSAGE_ID_CREATERESOURCE_NO_VB_AND_IB_BIND + 1 ),
    D3D_MESSAGE_ID_CREATERESOURCE_DIMENSION_OUT_OF_RANGE = ( D3D_MESSAGE_ID_CREATERESOURCE_NO_TEXTURE_1D + 1 ),
    D3D_MESSAGE_ID_CREATERESOURCE_NOT_BINDABLE_AS_SHADER_RESOURCE = ( D3D_MESSAGE_ID_CREATERESOURCE_DIMENSION_OUT_OF_RANGE + 1 ),
    D3D_MESSAGE_ID_OMSETRENDERTARGETS_TOO_MANY_RENDER_TARGETS = ( D3D_MESSAGE_ID_CREATERESOURCE_NOT_BINDABLE_AS_SHADER_RESOURCE + 1 ),
    D3D_MESSAGE_ID_OMSETRENDERTARGETS_NO_DIFFERING_BIT_DEPTHS = ( D3D_MESSAGE_ID_OMSETRENDERTARGETS_TOO_MANY_RENDER_TARGETS + 1 ),
    D3D_MESSAGE_ID_IASETVERTEXBUFFERS_BAD_BUFFER_INDEX = ( D3D_MESSAGE_ID_OMSETRENDERTARGETS_NO_DIFFERING_BIT_DEPTHS + 1 ),
    D3D_MESSAGE_ID_DEVICE_RSSETVIEWPORTS_TOO_MANY_VIEWPORTS = ( D3D_MESSAGE_ID_IASETVERTEXBUFFERS_BAD_BUFFER_INDEX + 1 ),
    D3D_MESSAGE_ID_DEVICE_IASETPRIMITIVETOPOLOGY_ADJACENCY_UNSUPPORTED = ( D3D_MESSAGE_ID_DEVICE_RSSETVIEWPORTS_TOO_MANY_VIEWPORTS + 1 ),
    D3D_MESSAGE_ID_DEVICE_RSSETSCISSORRECTS_TOO_MANY_SCISSORS = ( D3D_MESSAGE_ID_DEVICE_IASETPRIMITIVETOPOLOGY_ADJACENCY_UNSUPPORTED + 1 ),
    D3D_MESSAGE_ID_COPYRESOURCE_ONLY_TEXTURE_2D_WITHIN_GPU_MEMORY = ( D3D_MESSAGE_ID_DEVICE_RSSETSCISSORRECTS_TOO_MANY_SCISSORS + 1 ),
    D3D_MESSAGE_ID_COPYRESOURCE_NO_TEXTURE_3D_READBACK = ( D3D_MESSAGE_ID_COPYRESOURCE_ONLY_TEXTURE_2D_WITHIN_GPU_MEMORY + 1 ),
    D3D_MESSAGE_ID_COPYRESOURCE_NO_TEXTURE_ONLY_READBACK = ( D3D_MESSAGE_ID_COPYRESOURCE_NO_TEXTURE_3D_READBACK + 1 ),
    D3D_MESSAGE_ID_CREATEINPUTLAYOUT_UNSUPPORTED_FORMAT = ( D3D_MESSAGE_ID_COPYRESOURCE_NO_TEXTURE_ONLY_READBACK + 1 ),
    D3D_MESSAGE_ID_CREATEBLENDSTATE_NO_ALPHA_TO_COVERAGE = ( D3D_MESSAGE_ID_CREATEINPUTLAYOUT_UNSUPPORTED_FORMAT + 1 ),
    D3D_MESSAGE_ID_CREATERASTERIZERSTATE_DepthClipEnable_MUST_BE_TRUE = ( D3D_MESSAGE_ID_CREATEBLENDSTATE_NO_ALPHA_TO_COVERAGE + 1 ),
    D3D_MESSAGE_ID_DRAWINDEXED_STARTINDEXLOCATION_MUST_BE_POSITIVE = ( D3D_MESSAGE_ID_CREATERASTERIZERSTATE_DepthClipEnable_MUST_BE_TRUE + 1 ),
    D3D_MESSAGE_ID_CREATESHADERRESOURCEVIEW_MUST_USE_LOWEST_LOD = ( D3D_MESSAGE_ID_DRAWINDEXED_STARTINDEXLOCATION_MUST_BE_POSITIVE + 1 ),
    D3D_MESSAGE_ID_CREATESAMPLERSTATE_MINLOD_MUST_NOT_BE_FRACTIONAL = ( D3D_MESSAGE_ID_CREATESHADERRESOURCEVIEW_MUST_USE_LOWEST_LOD + 1 ),
    D3D_MESSAGE_ID_CREATESAMPLERSTATE_MAXLOD_MUST_BE_FLT_MAX = ( D3D_MESSAGE_ID_CREATESAMPLERSTATE_MINLOD_MUST_NOT_BE_FRACTIONAL + 1 ),
    D3D_MESSAGE_ID_CREATESHADERRESOURCEVIEW_FIRSTARRAYSLICE_MUST_BE_ZERO = ( D3D_MESSAGE_ID_CREATESAMPLERSTATE_MAXLOD_MUST_BE_FLT_MAX + 1 ),
    D3D_MESSAGE_ID_CREATESHADERRESOURCEVIEW_CUBES_MUST_HAVE_6_SIDES = ( D3D_MESSAGE_ID_CREATESHADERRESOURCEVIEW_FIRSTARRAYSLICE_MUST_BE_ZERO + 1 ),
    D3D_MESSAGE_ID_CREATERESOURCE_NOT_BINDABLE_AS_RENDER_TARGET = ( D3D_MESSAGE_ID_CREATESHADERRESOURCEVIEW_CUBES_MUST_HAVE_6_SIDES + 1 ),
    D3D_MESSAGE_ID_CREATERESOURCE_NO_DWORD_INDEX_BUFFER = ( D3D_MESSAGE_ID_CREATERESOURCE_NOT_BINDABLE_AS_RENDER_TARGET + 1 ),
    D3D_MESSAGE_ID_CREATERESOURCE_MSAA_PRECLUDES_SHADER_RESOURCE = ( D3D_MESSAGE_ID_CREATERESOURCE_NO_DWORD_INDEX_BUFFER + 1 ),
    D3D_MESSAGE_ID_CREATERESOURCE_PRESENTATION_PRECLUDES_SHADER_RESOURCE = ( D3D_MESSAGE_ID_CREATERESOURCE_MSAA_PRECLUDES_SHADER_RESOURCE + 1 ),
    D3D_MESSAGE_ID_CREATEBLENDSTATE_NO_INDEPENDENT_BLEND_ENABLE = ( D3D_MESSAGE_ID_CREATERESOURCE_PRESENTATION_PRECLUDES_SHADER_RESOURCE + 1 ),
    D3D_MESSAGE_ID_CREATEBLENDSTATE_NO_INDEPENDENT_WRITE_MASKS = ( D3D_MESSAGE_ID_CREATEBLENDSTATE_NO_INDEPENDENT_BLEND_ENABLE + 1 ),
    D3D_MESSAGE_ID_CREATERESOURCE_NO_STREAM_OUT = ( D3D_MESSAGE_ID_CREATEBLENDSTATE_NO_INDEPENDENT_WRITE_MASKS + 1 ),
    D3D_MESSAGE_ID_CREATERESOURCE_ONLY_VB_IB_FOR_BUFFERS = ( D3D_MESSAGE_ID_CREATERESOURCE_NO_STREAM_OUT + 1 ),
    D3D_MESSAGE_ID_CREATERESOURCE_NO_AUTOGEN_FOR_VOLUMES = ( D3D_MESSAGE_ID_CREATERESOURCE_ONLY_VB_IB_FOR_BUFFERS + 1 ),
    D3D_MESSAGE_ID_CREATERESOURCE_DXGI_FORMAT_R8G8B8A8_CANNOT_BE_SHARED = ( D3D_MESSAGE_ID_CREATERESOURCE_NO_AUTOGEN_FOR_VOLUMES + 1 ),
    D3D_MESSAGE_ID_VSSHADERRESOURCES_NOT_SUPPORTED = ( D3D_MESSAGE_ID_CREATERESOURCE_DXGI_FORMAT_R8G8B8A8_CANNOT_BE_SHARED + 1 ),
    D3D_MESSAGE_ID_GEOMETRY_SHADER_NOT_SUPPORTED = ( D3D_MESSAGE_ID_VSSHADERRESOURCES_NOT_SUPPORTED + 1 ),
    D3D_MESSAGE_ID_STREAM_OUT_NOT_SUPPORTED = ( D3D_MESSAGE_ID_GEOMETRY_SHADER_NOT_SUPPORTED + 1 ),
    D3D_MESSAGE_ID_TEXT_FILTER_NOT_SUPPORTED = ( D3D_MESSAGE_ID_STREAM_OUT_NOT_SUPPORTED + 1 ),
    D3D_MESSAGE_ID_CREATEBLENDSTATE_NO_SEPARATE_ALPHA_BLEND = ( D3D_MESSAGE_ID_TEXT_FILTER_NOT_SUPPORTED + 1 ),
    D3D_MESSAGE_ID_CREATEBLENDSTATE_NO_MRT_BLEND = ( D3D_MESSAGE_ID_CREATEBLENDSTATE_NO_SEPARATE_ALPHA_BLEND + 1 ),
    D3D_MESSAGE_ID_CREATEBLENDSTATE_OPERATION_NOT_SUPPORTED = ( D3D_MESSAGE_ID_CREATEBLENDSTATE_NO_MRT_BLEND + 1 ),
    D3D_MESSAGE_ID_CREATESAMPLERSTATE_NO_MIRRORONCE = ( D3D_MESSAGE_ID_CREATEBLENDSTATE_OPERATION_NOT_SUPPORTED + 1 ),
    D3D_MESSAGE_ID_DRAWINSTANCED_NOT_SUPPORTED = ( D3D_MESSAGE_ID_CREATESAMPLERSTATE_NO_MIRRORONCE + 1 ),
    D3D_MESSAGE_ID_DRAWINDEXEDINSTANCED_NOT_SUPPORTED_BELOW_9_3 = ( D3D_MESSAGE_ID_DRAWINSTANCED_NOT_SUPPORTED + 1 ),
    D3D_MESSAGE_ID_DRAWINDEXED_POINTLIST_UNSUPPORTED = ( D3D_MESSAGE_ID_DRAWINDEXEDINSTANCED_NOT_SUPPORTED_BELOW_9_3 + 1 ),
    D3D_MESSAGE_ID_SETBLENDSTATE_SAMPLE_MASK_CANNOT_BE_ZERO = ( D3D_MESSAGE_ID_DRAWINDEXED_POINTLIST_UNSUPPORTED + 1 ),
    D3D_MESSAGE_ID_CREATERESOURCE_DIMENSION_EXCEEDS_FEATURE_LEVEL_DEFINITION = ( D3D_MESSAGE_ID_SETBLENDSTATE_SAMPLE_MASK_CANNOT_BE_ZERO + 1 ),
    D3D_MESSAGE_ID_CREATERESOURCE_ONLY_SINGLE_MIP_LEVEL_DEPTH_STENCIL_SUPPORTED = ( D3D_MESSAGE_ID_CREATERESOURCE_DIMENSION_EXCEEDS_FEATURE_LEVEL_DEFINITION + 1 ),
    D3D_MESSAGE_ID_DEVICE_RSSETSCISSORRECTS_NEGATIVESCISSOR = ( D3D_MESSAGE_ID_CREATERESOURCE_ONLY_SINGLE_MIP_LEVEL_DEPTH_STENCIL_SUPPORTED + 1 ),
    D3D_MESSAGE_ID_SLOT_ZERO_MUST_BE_D3D_INPUT_PER_VERTEX_DATA = ( D3D_MESSAGE_ID_DEVICE_RSSETSCISSORRECTS_NEGATIVESCISSOR + 1 ),
    D3D_MESSAGE_ID_CREATERESOURCE_NON_POW_2_MIPMAP = ( D3D_MESSAGE_ID_SLOT_ZERO_MUST_BE_D3D_INPUT_PER_VERTEX_DATA + 1 ),
    D3D_MESSAGE_ID_CREATESAMPLERSTATE_BORDER_NOT_SUPPORTED = ( D3D_MESSAGE_ID_CREATERESOURCE_NON_POW_2_MIPMAP + 1 ),
    D3D_MESSAGE_ID_OMSETRENDERTARGETS_NO_SRGB_MRT = ( D3D_MESSAGE_ID_CREATESAMPLERSTATE_BORDER_NOT_SUPPORTED + 1 ),
    D3D_MESSAGE_ID_D3D_L9_MESSAGES_END = ( D3D_MESSAGE_ID_OMSETRENDERTARGETS_NO_SRGB_MRT + 1 ),
};


////////////////////////////////////////////////////////////
// D3D_FEATURE_LEVEL1
////////////////////////////////////////////////////////////
typedef D3D_FEATURE_LEVEL D3D_FEATURE_LEVEL1;


////////////////////////////////////////////////////////////
// D3D_STANDARD_MULTISAMPLE_QUALITY_LEVELS
////////////////////////////////////////////////////////////
enum D3D_STANDARD_MULTISAMPLE_QUALITY_LEVELS
{
    D3D_STANDARD_MULTISAMPLE_PATTERN = 0xffffffff,
    D3D_CENTER_MULTISAMPLE_PATTERN = 0xfffffffe,
};


////////////////////////////////////////////////////////////
// D3D_INPUT_ELEMENT_DESC
////////////////////////////////////////////////////////////
struct D3D_INPUT_ELEMENT_DESC
{
    LPCSTR SemanticName;
    UINT SemanticIndex;
    DXGI_FORMAT Format;
    UINT InputSlot;
    UINT AlignedByteOffset;
    D3D_INPUT_CLASSIFICATION InputSlotClass;
    UINT InstanceDataStepRate;
};


////////////////////////////////////////////////////////////
// D3D_SO_DECLARATION_ENTRY
////////////////////////////////////////////////////////////
struct D3D_SO_DECLARATION_ENTRY
{
    LPCSTR SemanticName;
    UINT SemanticIndex;
    BYTE StartComponent;
    BYTE ComponentCount;
    BYTE OutputSlot;
};


////////////////////////////////////////////////////////////
// D3D_VIEWPORT
////////////////////////////////////////////////////////////
struct D3D_VIEWPORT
{
    INT TopLeftX;
    INT TopLeftY;
    UINT Width;
    UINT Height;
    FLOAT MinDepth;
    FLOAT MaxDepth;
};


////////////////////////////////////////////////////////////
// D3D_BOX
////////////////////////////////////////////////////////////
struct D3D_BOX
{
    UINT left;
    UINT top;
    UINT front;
    UINT right;
    UINT bottom;
    UINT back;
};


////////////////////////////////////////////////////////////
// D3D_DEPTH_STENCILOP_DESC
////////////////////////////////////////////////////////////
struct D3D_DEPTH_STENCILOP_DESC
{
    D3D_STENCIL_OP StencilFailOp;
    D3D_STENCIL_OP StencilDepthFailOp;
    D3D_STENCIL_OP StencilPassOp;
    D3D_COMPARISON_FUNC StencilFunc;
};


////////////////////////////////////////////////////////////
// D3D_DEPTH_STENCIL_DESC
////////////////////////////////////////////////////////////
struct D3D_DEPTH_STENCIL_DESC
{
    BOOL DepthEnable;
    D3D_DEPTH_WRITE_MASK DepthWriteMask;
    D3D_COMPARISON_FUNC DepthFunc;
    BOOL StencilEnable;
    UINT8 StencilReadMask;
    UINT8 StencilWriteMask;
    D3D_DEPTH_STENCILOP_DESC FrontFace;
    D3D_DEPTH_STENCILOP_DESC BackFace;
};


////////////////////////////////////////////////////////////
// D3D_BLEND_DESC
////////////////////////////////////////////////////////////
struct D3D_BLEND_DESC
{
    BOOL AlphaToCoverageEnable;
    BOOL BlendEnable[8];
    D3D_BLEND SrcBlend;
    D3D_BLEND DestBlend;
    D3D_BLEND_OP BlendOp;
    D3D_BLEND SrcBlendAlpha;
    D3D_BLEND DestBlendAlpha;
    D3D_BLEND_OP BlendOpAlpha;
    UINT8 RenderTargetWriteMask[8];
};


////////////////////////////////////////////////////////////
// D3D_RASTERIZER_DESC
////////////////////////////////////////////////////////////
struct D3D_RASTERIZER_DESC
{
    D3D_FILL_MODE FillMode;
    D3D_CULL_MODE CullMode;
    BOOL FrontCounterClockwise;
    INT DepthBias;
    FLOAT DepthBiasClamp;
    FLOAT SlopeScaledDepthBias;
    BOOL DepthClipEnable;
    BOOL ScissorEnable;
    BOOL MultisampleEnable;
    BOOL AntialiasedLineEnable;
};


////////////////////////////////////////////////////////////
// D3D_SUBRESOURCE_DATA
////////////////////////////////////////////////////////////
struct D3D_SUBRESOURCE_DATA
{
    const void * pSysMem;
    UINT SysMemPitch;
    UINT SysMemSlicePitch;
};


////////////////////////////////////////////////////////////
// D3D_BUFFER_DESC
////////////////////////////////////////////////////////////
struct D3D_BUFFER_DESC
{
    UINT ByteWidth;
    D3D_USAGE Usage;
    UINT BindFlags;
    UINT CPUAccessFlags;
    UINT MiscFlags;
};


////////////////////////////////////////////////////////////
// D3D_TEXTURE1D_DESC
////////////////////////////////////////////////////////////
struct D3D_TEXTURE1D_DESC
{
    UINT Width;
    UINT MipLevels;
    UINT ArraySize;
    DXGI_FORMAT Format;
    D3D_USAGE Usage;
    UINT BindFlags;
    UINT CPUAccessFlags;
    UINT MiscFlags;
};


////////////////////////////////////////////////////////////
// D3D_TEXTURE2D_DESC
////////////////////////////////////////////////////////////
struct D3D_TEXTURE2D_DESC
{
    UINT Width;
    UINT Height;
    UINT MipLevels;
    UINT ArraySize;
    DXGI_FORMAT Format;
    DXGI_SAMPLE_DESC SampleDesc;
    D3D_USAGE Usage;
    UINT BindFlags;
    UINT CPUAccessFlags;
    UINT MiscFlags;
};


////////////////////////////////////////////////////////////
// D3D_MAPPED_TEXTURE2D
////////////////////////////////////////////////////////////
struct D3D_MAPPED_TEXTURE2D
{
    void * pData;
    UINT RowPitch;
};


////////////////////////////////////////////////////////////
// D3D_TEXTURE3D_DESC
////////////////////////////////////////////////////////////
struct D3D_TEXTURE3D_DESC
{
    UINT Width;
    UINT Height;
    UINT Depth;
    UINT MipLevels;
    DXGI_FORMAT Format;
    D3D_USAGE Usage;
    UINT BindFlags;
    UINT CPUAccessFlags;
    UINT MiscFlags;
};


////////////////////////////////////////////////////////////
// D3D_MAPPED_TEXTURE3D
////////////////////////////////////////////////////////////
struct D3D_MAPPED_TEXTURE3D
{
    void * pData;
    UINT RowPitch;
    UINT DepthPitch;
};


////////////////////////////////////////////////////////////
// D3D_BUFFER_SRV
////////////////////////////////////////////////////////////
struct D3D_BUFFER_SRV
{
    union
    {
        UINT FirstElement;
        UINT ElementOffset;
    };
    union
    {
        UINT NumElements;
        UINT ElementWidth;
    };
};


////////////////////////////////////////////////////////////
// D3D_TEX1D_SRV
////////////////////////////////////////////////////////////
struct D3D_TEX1D_SRV
{
    UINT MostDetailedMip;
    UINT MipLevels;
};


////////////////////////////////////////////////////////////
// D3D_TEX1D_ARRAY_SRV
////////////////////////////////////////////////////////////
struct D3D_TEX1D_ARRAY_SRV
{
    UINT MostDetailedMip;
    UINT MipLevels;
    UINT FirstArraySlice;
    UINT ArraySize;
};


////////////////////////////////////////////////////////////
// D3D_TEX2D_SRV
////////////////////////////////////////////////////////////
struct D3D_TEX2D_SRV
{
    UINT MostDetailedMip;
    UINT MipLevels;
};


////////////////////////////////////////////////////////////
// D3D_TEX2D_ARRAY_SRV
////////////////////////////////////////////////////////////
struct D3D_TEX2D_ARRAY_SRV
{
    UINT MostDetailedMip;
    UINT MipLevels;
    UINT FirstArraySlice;
    UINT ArraySize;
};


////////////////////////////////////////////////////////////
// D3D_TEX3D_SRV
////////////////////////////////////////////////////////////
struct D3D_TEX3D_SRV
{
    UINT MostDetailedMip;
    UINT MipLevels;
};


////////////////////////////////////////////////////////////
// D3D_TEXCUBE_SRV
////////////////////////////////////////////////////////////
struct D3D_TEXCUBE_SRV
{
    UINT MostDetailedMip;
    UINT MipLevels;
};


////////////////////////////////////////////////////////////
// D3D_TEX2DMS_SRV
////////////////////////////////////////////////////////////
struct D3D_TEX2DMS_SRV
{
    UINT UnusedField_NothingToDefine;
};


////////////////////////////////////////////////////////////
// D3D_TEX2DMS_ARRAY_SRV
////////////////////////////////////////////////////////////
struct D3D_TEX2DMS_ARRAY_SRV
{
    UINT FirstArraySlice;
    UINT ArraySize;
};


////////////////////////////////////////////////////////////
// D3D_SHADER_RESOURCE_VIEW_DESC
////////////////////////////////////////////////////////////
struct D3D_SHADER_RESOURCE_VIEW_DESC
{
    DXGI_FORMAT Format;
    D3D_SRV_DIMENSION ViewDimension;
    union
    {
        D3D_BUFFER_SRV Buffer;
        D3D_TEX1D_SRV Texture1D;
        D3D_TEX1D_ARRAY_SRV Texture1DArray;
        D3D_TEX2D_SRV Texture2D;
        D3D_TEX2D_ARRAY_SRV Texture2DArray;
        D3D_TEX2DMS_SRV Texture2DMS;
        D3D_TEX2DMS_ARRAY_SRV Texture2DMSArray;
        D3D_TEX3D_SRV Texture3D;
        D3D_TEXCUBE_SRV TextureCube;
    };
};


////////////////////////////////////////////////////////////
// D3D_BUFFER_RTV
////////////////////////////////////////////////////////////
struct D3D_BUFFER_RTV
{
    union
    {
        UINT FirstElement;
        UINT ElementOffset;
    };
    union
    {
        UINT NumElements;
        UINT ElementWidth;
    };
};


////////////////////////////////////////////////////////////
// D3D_TEX1D_RTV
////////////////////////////////////////////////////////////
struct D3D_TEX1D_RTV
{
    UINT MipSlice;
};


////////////////////////////////////////////////////////////
// D3D_TEX1D_ARRAY_RTV
////////////////////////////////////////////////////////////
struct D3D_TEX1D_ARRAY_RTV
{
    UINT MipSlice;
    UINT FirstArraySlice;
    UINT ArraySize;
};


////////////////////////////////////////////////////////////
// D3D_TEX2D_RTV
////////////////////////////////////////////////////////////
struct D3D_TEX2D_RTV
{
    UINT MipSlice;
};


////////////////////////////////////////////////////////////
// D3D_TEX2DMS_RTV
////////////////////////////////////////////////////////////
struct D3D_TEX2DMS_RTV
{
    UINT UnusedField_NothingToDefine;
};


////////////////////////////////////////////////////////////
// D3D_TEX2D_ARRAY_RTV
////////////////////////////////////////////////////////////
struct D3D_TEX2D_ARRAY_RTV
{
    UINT MipSlice;
    UINT FirstArraySlice;
    UINT ArraySize;
};


////////////////////////////////////////////////////////////
// D3D_TEX2DMS_ARRAY_RTV
////////////////////////////////////////////////////////////
struct D3D_TEX2DMS_ARRAY_RTV
{
    UINT FirstArraySlice;
    UINT ArraySize;
};


////////////////////////////////////////////////////////////
// D3D_TEX3D_RTV
////////////////////////////////////////////////////////////
struct D3D_TEX3D_RTV
{
    UINT MipSlice;
    UINT FirstWSlice;
    UINT WSize;
};


////////////////////////////////////////////////////////////
// D3D_RENDER_TARGET_VIEW_DESC
////////////////////////////////////////////////////////////
struct D3D_RENDER_TARGET_VIEW_DESC
{
    DXGI_FORMAT Format;
    D3D_RTV_DIMENSION ViewDimension;
    union
    {
        D3D_BUFFER_RTV Buffer;
        D3D_TEX1D_RTV Texture1D;
        D3D_TEX1D_ARRAY_RTV Texture1DArray;
        D3D_TEX2D_RTV Texture2D;
        D3D_TEX2D_ARRAY_RTV Texture2DArray;
        D3D_TEX2DMS_RTV Texture2DMS;
        D3D_TEX2DMS_ARRAY_RTV Texture2DMSArray;
        D3D_TEX3D_RTV Texture3D;
    };
};


////////////////////////////////////////////////////////////
// D3D_TEX1D_DSV
////////////////////////////////////////////////////////////
struct D3D_TEX1D_DSV
{
    UINT MipSlice;
};


////////////////////////////////////////////////////////////
// D3D_TEX1D_ARRAY_DSV
////////////////////////////////////////////////////////////
struct D3D_TEX1D_ARRAY_DSV
{
    UINT MipSlice;
    UINT FirstArraySlice;
    UINT ArraySize;
};


////////////////////////////////////////////////////////////
// D3D_TEX2D_DSV
////////////////////////////////////////////////////////////
struct D3D_TEX2D_DSV
{
    UINT MipSlice;
};


////////////////////////////////////////////////////////////
// D3D_TEX2D_ARRAY_DSV
////////////////////////////////////////////////////////////
struct D3D_TEX2D_ARRAY_DSV
{
    UINT MipSlice;
    UINT FirstArraySlice;
    UINT ArraySize;
};


////////////////////////////////////////////////////////////
// D3D_TEX2DMS_DSV
////////////////////////////////////////////////////////////
struct D3D_TEX2DMS_DSV
{
    UINT UnusedField_NothingToDefine;
};


////////////////////////////////////////////////////////////
// D3D_TEX2DMS_ARRAY_DSV
////////////////////////////////////////////////////////////
struct D3D_TEX2DMS_ARRAY_DSV
{
    UINT FirstArraySlice;
    UINT ArraySize;
};


////////////////////////////////////////////////////////////
// D3D_DEPTH_STENCIL_VIEW_DESC
////////////////////////////////////////////////////////////
struct D3D_DEPTH_STENCIL_VIEW_DESC
{
    DXGI_FORMAT Format;
    D3D_DSV_DIMENSION ViewDimension;
    union
    {
        D3D_TEX1D_DSV Texture1D;
        D3D_TEX1D_ARRAY_DSV Texture1DArray;
        D3D_TEX2D_DSV Texture2D;
        D3D_TEX2D_ARRAY_DSV Texture2DArray;
        D3D_TEX2DMS_DSV Texture2DMS;
        D3D_TEX2DMS_ARRAY_DSV Texture2DMSArray;
    };
};


////////////////////////////////////////////////////////////
// D3D_SAMPLER_DESC
////////////////////////////////////////////////////////////
struct D3D_SAMPLER_DESC
{
    D3D_FILTER Filter;
    D3D_TEXTURE_ADDRESS_MODE AddressU;
    D3D_TEXTURE_ADDRESS_MODE AddressV;
    D3D_TEXTURE_ADDRESS_MODE AddressW;
    FLOAT MipLODBias;
    UINT MaxAnisotropy;
    D3D_COMPARISON_FUNC ComparisonFunc;
    FLOAT BorderColor[4];
    FLOAT MinLOD;
    FLOAT MaxLOD;
};


////////////////////////////////////////////////////////////
// D3D_QUERY_DESC
////////////////////////////////////////////////////////////
struct D3D_QUERY_DESC
{
    D3D_QUERY Query;
    UINT MiscFlags;
};


////////////////////////////////////////////////////////////
// D3D_QUERY_DATA_TIMESTAMP_DISJOINT
////////////////////////////////////////////////////////////
struct D3D_QUERY_DATA_TIMESTAMP_DISJOINT
{
    UINT64 Frequency;
    BOOL Disjoint;
};


////////////////////////////////////////////////////////////
// D3D_QUERY_DATA_PIPELINE_STATISTICS
////////////////////////////////////////////////////////////
struct D3D_QUERY_DATA_PIPELINE_STATISTICS
{
    UINT64 IAVertices;
    UINT64 IAPrimitives;
    UINT64 VSInvocations;
    UINT64 GSInvocations;
    UINT64 GSPrimitives;
    UINT64 CInvocations;
    UINT64 CPrimitives;
    UINT64 PSInvocations;
};


////////////////////////////////////////////////////////////
// D3D_QUERY_DATA_SO_STATISTICS
////////////////////////////////////////////////////////////
struct D3D_QUERY_DATA_SO_STATISTICS
{
    UINT64 NumPrimitivesWritten;
    UINT64 PrimitivesStorageNeeded;
};


////////////////////////////////////////////////////////////
// D3D_COUNTER_DESC
////////////////////////////////////////////////////////////
struct D3D_COUNTER_DESC
{
    D3D_COUNTER Counter;
    UINT MiscFlags;
};


////////////////////////////////////////////////////////////
// D3D_COUNTER_INFO
////////////////////////////////////////////////////////////
struct D3D_COUNTER_INFO
{
    D3D_COUNTER LastDeviceDependentCounter;
    UINT NumSimultaneousCounters;
    UINT8 NumDetectableParallelUnits;
};


////////////////////////////////////////////////////////////
// D3D_MESSAGE
////////////////////////////////////////////////////////////
struct D3D_MESSAGE
{
    D3D_MESSAGE_CATEGORY Category;
    D3D_MESSAGE_SEVERITY Severity;
    D3D_MESSAGE_ID ID;
    const char * pDescription;
    SIZE_T DescriptionByteLength;
};


////////////////////////////////////////////////////////////
// D3D_INFO_QUEUE_FILTER_DESC
////////////////////////////////////////////////////////////
struct D3D_INFO_QUEUE_FILTER_DESC
{
    UINT NumCategories;
    D3D_MESSAGE_CATEGORY * pCategoryList;
    UINT NumSeverities;
    D3D_MESSAGE_SEVERITY * pSeverityList;
    UINT NumIDs;
    D3D_MESSAGE_ID * pIDList;
};


////////////////////////////////////////////////////////////
// D3D_INFO_QUEUE_FILTER
////////////////////////////////////////////////////////////
struct D3D_INFO_QUEUE_FILTER
{
    D3D_INFO_QUEUE_FILTER_DESC AllowList;
    D3D_INFO_QUEUE_FILTER_DESC DenyList;
};


////////////////////////////////////////////////////////////
// D3D_RENDER_TARGET_BLEND_DESC1
////////////////////////////////////////////////////////////
struct D3D_RENDER_TARGET_BLEND_DESC1
{
    BOOL BlendEnable;
    D3D_BLEND SrcBlend;
    D3D_BLEND DestBlend;
    D3D_BLEND_OP BlendOp;
    D3D_BLEND SrcBlendAlpha;
    D3D_BLEND DestBlendAlpha;
    D3D_BLEND_OP BlendOpAlpha;
    UINT8 RenderTargetWriteMask;
};


////////////////////////////////////////////////////////////
// D3D_BLEND_DESC1
////////////////////////////////////////////////////////////
struct D3D_BLEND_DESC1
{
    BOOL AlphaToCoverageEnable;
    BOOL IndependentBlendEnable;
    D3D_RENDER_TARGET_BLEND_DESC1 RenderTarget[8];
};


////////////////////////////////////////////////////////////
// D3D_TEXCUBE_ARRAY_SRV1
////////////////////////////////////////////////////////////
struct D3D_TEXCUBE_ARRAY_SRV1
{
    UINT MostDetailedMip;
    UINT MipLevels;
    UINT First2DArrayFace;
    UINT NumCubes;
};


////////////////////////////////////////////////////////////
// D3D_SHADER_RESOURCE_VIEW_DESC1
////////////////////////////////////////////////////////////
struct D3D_SHADER_RESOURCE_VIEW_DESC1
{
    DXGI_FORMAT Format;
    D3D_SRV_DIMENSION ViewDimension;
    union
    {
        D3D_BUFFER_SRV Buffer;
        D3D_TEX1D_SRV Texture1D;
        D3D_TEX1D_ARRAY_SRV Texture1DArray;
        D3D_TEX2D_SRV Texture2D;
        D3D_TEX2D_ARRAY_SRV Texture2DArray;
        D3D_TEX2DMS_SRV Texture2DMS;
        D3D_TEX2DMS_ARRAY_SRV Texture2DMSArray;
        D3D_TEX3D_SRV Texture3D;
        D3D_TEXCUBE_SRV TextureCube;
        D3D_TEXCUBE_ARRAY_SRV1 TextureCubeArray;
    };
};
