//****************************************************************************
// File:  HReusultHelp.cpp
//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
// Purpose:
// Contains helper function to convert HRESULTs into a string form.
//
// History:
//
// 17 Nov 2010  olanh     Initial creation from code extracted from 
//                        D3DTest.cpp and D3D11Test.cpp.
//****************************************************************************

#include <windows.h>
#include <StringUtils.h>
#include <d3d11_1.h>
#include <d3d11.h>
#include <d3d10_1.h>
#include <d3d10.h>
#include <d3d9.h>
#include <d3dX10.h>

///////////////////////////////////////////////////////
// Function: D3DHResultToString
//
// Purpose:
// Converts a D3D/DXGI HResult to a string form.  Does
// not return a detailed description of the error as 
// provided by StringUtil's HRESULTToString().
///////////////////////////////////////////////////////
#define HR_STR_CASE(x) case (x): return (tstring(_T(#x)) + tstring(FormatString(_T(" (%#x)"), (long)hr)))
tstring D3DHResultToString( HRESULT hr )
{
	switch (hr)
	{
		default:
			return tstring( FormatString(_T("%#x"), (long)hr) );

		HR_STR_CASE(S_OK);
		HR_STR_CASE(S_FALSE);

		HR_STR_CASE(__HRESULT_FROM_WIN32(ERROR_PROC_NOT_FOUND));

		HR_STR_CASE(E_FAIL);
		HR_STR_CASE(E_INVALIDARG);
		HR_STR_CASE(E_OUTOFMEMORY);
		HR_STR_CASE(E_UNEXPECTED);
		HR_STR_CASE(E_NOTIMPL);
		HR_STR_CASE(E_NOINTERFACE);
		HR_STR_CASE(E_POINTER);
		HR_STR_CASE(E_HANDLE);
		HR_STR_CASE(E_ABORT);
		HR_STR_CASE(E_ACCESSDENIED);

		HR_STR_CASE(DXGI_ERROR_INVALID_CALL);
		HR_STR_CASE(DXGI_ERROR_NOT_FOUND);
		HR_STR_CASE(DXGI_ERROR_MORE_DATA);
		HR_STR_CASE(DXGI_ERROR_UNSUPPORTED);
		HR_STR_CASE(DXGI_ERROR_DEVICE_REMOVED);
		HR_STR_CASE(DXGI_ERROR_DEVICE_HUNG);
		HR_STR_CASE(DXGI_ERROR_DEVICE_RESET);
		HR_STR_CASE(DXGI_ERROR_WAS_STILL_DRAWING);
		HR_STR_CASE(DXGI_ERROR_DRIVER_INTERNAL_ERROR);
		HR_STR_CASE(DXGI_ERROR_NONEXCLUSIVE);
		HR_STR_CASE(DXGI_ERROR_NOT_CURRENTLY_AVAILABLE);
		HR_STR_CASE(DXGI_ERROR_FRAME_STATISTICS_DISJOINT);
		HR_STR_CASE(DXGI_ERROR_GRAPHICS_VIDPN_SOURCE_IN_USE);
		HR_STR_CASE(DXGI_ERROR_REMOTE_CLIENT_DISCONNECTED);
		HR_STR_CASE(DXGI_ERROR_REMOTE_OUTOFMEMORY);

		HR_STR_CASE(DXGI_ERROR_ACCESS_LOST);
		HR_STR_CASE(DXGI_ERROR_WAIT_TIMEOUT);
		HR_STR_CASE(DXGI_ERROR_SESSION_DISCONNECTED);
		HR_STR_CASE(DXGI_ERROR_RESTRICT_TO_OUTPUT_STALE);
		HR_STR_CASE(DXGI_ERROR_CANNOT_PROTECT_CONTENT);


		HR_STR_CASE(DXGI_STATUS_OCCLUDED);
		HR_STR_CASE(DXGI_STATUS_CLIPPED);
		HR_STR_CASE(DXGI_STATUS_NO_REDIRECTION);
		HR_STR_CASE(DXGI_STATUS_NO_DESKTOP_ACCESS);
		HR_STR_CASE(DXGI_STATUS_GRAPHICS_VIDPN_SOURCE_IN_USE);
		HR_STR_CASE(DXGI_STATUS_MODE_CHANGED);
		HR_STR_CASE(DXGI_STATUS_MODE_CHANGE_IN_PROGRESS);


		HR_STR_CASE(D3D11_ERROR_TOO_MANY_UNIQUE_STATE_OBJECTS);
		HR_STR_CASE(D3D11_ERROR_FILE_NOT_FOUND);
		HR_STR_CASE(D3D11_ERROR_TOO_MANY_UNIQUE_VIEW_OBJECTS); 
		HR_STR_CASE(D3D11_ERROR_DEFERRED_CONTEXT_MAP_WITHOUT_INITIAL_DISCARD);

		HR_STR_CASE(D3DERR_INVALIDCALL);
		HR_STR_CASE(D3DERR_WASSTILLDRAWING);
		HR_STR_CASE(D3DERR_OUTOFVIDEOMEMORY);

		HR_STR_CASE(D3DX10_ERR_CANNOT_MODIFY_INDEX_BUFFER);
		HR_STR_CASE(D3DX10_ERR_INVALID_MESH);
		HR_STR_CASE(D3DX10_ERR_CANNOT_ATTR_SORT);
		HR_STR_CASE(D3DX10_ERR_SKINNING_NOT_SUPPORTED);
		HR_STR_CASE(D3DX10_ERR_TOO_MANY_INFLUENCES);
		HR_STR_CASE(D3DX10_ERR_INVALID_DATA);
		HR_STR_CASE(D3DX10_ERR_LOADED_MESH_HAS_NO_DATA);
		HR_STR_CASE(D3DX10_ERR_DUPLICATE_NAMED_FRAGMENT);
		HR_STR_CASE(D3DX10_ERR_CANNOT_REMOVE_LAST_ITEM);
	}
}
#undef HR_STR_CASE
