#pragma once

#include <windows.h>
#include "WexTestClass.h"
#include "XMLConfig.h"
#include "MFTDiagTestDLLCommon.h"
#include "MFTDTaefBase.h"
#include "XMLConfig.h"

BEGIN_MODULE()
    MODULE_PROPERTY(L"Feature", L"WLKDecDXVAHDTAEF")
    MODULE_PROPERTY(L"ThreadingModel", L"MTA")
END_MODULE()

#pragma prefast(push)
#pragma prefast(disable:28718, "disabling warning for test code")

class CWLKDecDXVAHDTAEF : public WEX::TestClass<CWLKDecDXVAHDTAEF>, public CMFTDTaefBase
{
public:
    CWLKDecDXVAHDTAEF(void);
    ~CWLKDecDXVAHDTAEF(void);

    BEGIN_TEST_CLASS(CWLKDecDXVAHDTAEF)
    END_TEST_CLASS()

    TEST_CLASS_SETUP(InitializeTestClass)
    TEST_CLASS_CLEANUP(FinalizeTestClass)

    BEGIN_TEST_METHOD(XVPTest1)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"8594C77D-4374-0108-906E-F6B146E0BC58")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"2f220f20-c2c3-43dc-8acc-65d37434c1a2")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"XVP test 1")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"DXVAHD XVP Test - Video Processor Quality XVP")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM.Render.VideoProcessing")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the HMFT to test - {DETECT} should be used for certification, this can be overridden to test a specific HMFT")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\MSHDRef_Difficult_Edge_02_720x480p30f_NV12.avi")
    END_TEST_METHOD()

    BEGIN_TEST_METHOD(XVPTest2)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"752ba963-cc9e-4dce-9be4-9a061c5743f9")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"51c68bac-c16b-4687-b80d-265615d148a7")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"XVP test 2")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"DXVAHD XVP Test - Video Processor Quality XVP")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM.Render.VideoProcessing")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the HMFT to test - {DETECT} should be used for certification, this can be overridden to test a specific HMFT")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\MJPEG_176x144_15fps.avi")
    END_TEST_METHOD()

    BEGIN_TEST_METHOD(XVPTest3)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"B8CF1EF4-4468-0D0F-A0BD-88957C2103DE")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"1c4cdaf5-f01b-41d3-905e-47a513735df4")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"XVP test 3")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"DXVAHD Test: InputType H264 - Video Processor Quality XVP Color Conversion VV YUY2ex to ARGB32")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM.Render.VideoProcessing")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the HMFT to test - {DETECT} should be used for certification, this can be overridden to test a specific HMFT")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\MJPEG_320x240_30fps.avi")
    END_TEST_METHOD()

    BEGIN_TEST_METHOD(XVPTest4)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"785b177e-2f01-4255-b11d-53fb7aef8fa3")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"d86150af-b4ed-4ed4-9dba-eb63748d5945")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"XVP test 4")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"DXVAHD XVP Test - Video Processor Quality XVP")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM.Render.VideoProcessing")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the HMFT to test - {DETECT} should be used for certification, this can be overridden to test a specific HMFT")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\MJPEG_640x360_30fps.avi")
    END_TEST_METHOD()

    BEGIN_TEST_METHOD(XVPTest5)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"fd87fb6b-1540-4654-8de5-fc0b9818eeb5")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"39b6a497-f991-45bc-a29b-104d93118985")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"XVP test 5")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"DXVAHD XVP Test - Video Processor Quality XVP")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM.Render.VideoProcessing")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the HMFT to test - {DETECT} should be used for certification, this can be overridden to test a specific HMFT")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\MJPEG_1280x720_30fps.avi")
    END_TEST_METHOD()

    BEGIN_TEST_METHOD(XVPTest6)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"47454F8E-4E0F-6FA1-8E3A-33BC50462418")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"bd4355e8-e216-44e0-9ca3-a44247b87d1c")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"XVP test 6")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"DXVAHD XVP Test - Video Processor Quality XVP")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM.Render.VideoProcessing")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the HMFT to test - {DETECT} should be used for certification, this can be overridden to test a specific HMFT")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\MSHDRef_Difficult_Edge_02_720x480p30f_NV12.avi")
    END_TEST_METHOD()

    BEGIN_TEST_METHOD(XVPTest10)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"dbd78f7d-9f2e-4497-9571-7db0b94a4625")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"a738557a-126f-4a0a-a5c7-ecb5a8e6b5b6")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"XVP test 10")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"DXVAHD XVP Test - Video Processor Quality XVP")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM.Render.VideoProcessing")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the HMFT to test - {DETECT} should be used for certification, this can be overridden to test a specific HMFT")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\MJPEG_640x360_30fps.avi")
    END_TEST_METHOD()

    BEGIN_TEST_METHOD(XVPTest11)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"4e2aeacb-8824-4af8-aee0-bf1df3dd49b9")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"5ccec547-56c7-4448-aac2-9e4b9d2fff60")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"XVP test 11")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"DXVAHD XVP Test - Video Processor Quality XVP")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM.Render.VideoProcessing")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the HMFT to test - {DETECT} should be used for certification, this can be overridden to test a specific HMFT")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\MJPEG_1280x720_30fps.avi")
    END_TEST_METHOD()

    BEGIN_TEST_METHOD(XVPTest92)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"2dac36cb-0c64-4896-b6c4-477c729476e7")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"a6af0095-ca91-4548-8ab7-487c69f5ad2e")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"XVP test 92")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"DXVAHD XVP Test - Video Processor Quality XVP")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM.Render.VideoProcessing")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the HMFT to test - {DETECT} should be used for certification, this can be overridden to test a specific HMFT")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\Highway720x480p.wmv")
    END_TEST_METHOD()

    BEGIN_TEST_METHOD(XVPTest109)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"8890D733-57A5-43BA-98AF-87A085E8DA8C")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"8355e969-5b66-4b64-b5f7-7f913b0972b6")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"XVP test 109")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"DXVAHD XVP Test - Video Processor Quality XVP")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM.Render.VideoProcessing")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the HMFT to test - {DETECT} should be used for certification, this can be overridden to test a specific HMFT")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\Boats1280x720p.wmv")
    END_TEST_METHOD()

    BEGIN_TEST_METHOD(XVPTest110)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"C73824C6-5631-4DFE-A6AC-247C645EE0E9")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"8f917ff2-4e8e-4626-b222-0412bff35381")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"XVP test 110")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"DXVAHD XVP Test - Video Processor Quality XVP")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM.Render.VideoProcessing")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the HMFT to test - {DETECT} should be used for certification, this can be overridden to test a specific HMFT")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\Boats1280x720p.wmv")
    END_TEST_METHOD()

    BEGIN_TEST_METHOD(CustomXML)
        TEST_METHOD_PROPERTY(L"CustomXML",  L"TRUE")
    END_TEST_METHOD()

protected:
    HRESULT RunTestsWithIDs(const DWORD* pdwTestIDs, const DWORD dwNumTestIDs);
    HRESULT RunActualTest(const DWORD dwTestID, const GUID* pGUIDMFTUnderTest, const WCHAR* pszHWURL);
    HRESULT GetGUIDsToTest(const DWORD dwTestID, GUID pGUIDsToTest[], WCHAR* pppszHWURLs[], const DWORD dwMaxGUIDsToTest, DWORD *pdwNumGUIDs);
    HRESULT VerifyHWRegKeys(void);
};

#pragma prefast(pop)
