#pragma once

#include <windows.h>
#include "WexTestClass.h"
#include "XMLConfig.h"
#include "MFTDiagTestDLLCommon.h"
#include "MFTDTaefBase.h"
#include "XMLConfig.h"

BEGIN_MODULE()
MODULE_PROPERTY(L"Feature", L"WLKDecDXVATAEF")
MODULE_PROPERTY(L"ThreadingModel", L"MTA")
END_MODULE()

#pragma prefast(push)
#pragma prefast(disable:28718, "disabling warning for test code")

class CWLKDecDXVATAEF : public WEX::TestClass<CWLKDecDXVATAEF>, public CMFTDTaefBase
{
public:
    CWLKDecDXVATAEF(void);
    ~CWLKDecDXVATAEF(void);

    BEGIN_TEST_CLASS(CWLKDecDXVATAEF)
        END_TEST_CLASS()

        TEST_CLASS_SETUP(InitializeTestClass)
        TEST_CLASS_CLEANUP(FinalizeTestClass)

        //Soccer_1280x720p_3mbps_25fps_High_at_L4.1_Cabac_frext_slice.mp4

        BEGIN_TEST_METHOD(H264PlaybackTest1)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"A5A01625-412E-5491-C53F-CAAD773D59C2")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"4237391a-9f76-4b67-98ed-ce75393e04da")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"H264 playback test 1")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"Decoder H.264 Compliance: InputType H264 - Verify DXVA Decoding for H.264")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\Soccer_1280x720p_3mbps_25fps_High_at_L4.1_Cabac_frext_slice.mp4")
        END_TEST_METHOD()

        BEGIN_TEST_METHOD(H264PlaybackTest2)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"C9515A60-CA57-4178-92BA-21F47864264D")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"92d7050e-25a9-4153-a844-783e2f4056c9")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"H264 playback test 2")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"Decoder H.264 Compliance: InputType H264 - Verify DXVA Decoding for H.264")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\Tallship_1920x1088i_field_14mbps_25fps_High_at_L4.1_Cabac_Slice.mp4")
        END_TEST_METHOD()

        BEGIN_TEST_METHOD(H264PlaybackTest3)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"CC8389C1-1644-4696-AD7A-9388407F43D4")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"a9757a74-df9f-4c62-bee6-4e862906cf25")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"H264 playback test 3")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"Decoder H.264 Compliance: InputType H264 - Verify DXVA Decoding for H.264")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\Tallship_720x480p_5mbps_24fps_Main_at_L3.2_CABAC_DifficultEdge.mp4")
        END_TEST_METHOD()

        BEGIN_TEST_METHOD(H264PlaybackTest4)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"746CDBA3-D0A4-4058-B99E-B014AF320331")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"f57c021c-cde2-4312-9e50-29d5ece89c38")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"H264 playback test 4")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"Decoder H.264 Compliance: InputType H264 - Verify DXVA Decoding for H.264")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\Dancing_1920x1088p_9mbps_25fps_High_at_L4.1_Cabac_Frext.mp4")
        END_TEST_METHOD()

        BEGIN_TEST_METHOD(H264PlaybackTest5)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"5614065D-D34F-45A5-989E-37F3C7F6080B")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"b3b70868-1dba-4037-a094-03474ef73b96")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"H264 playback test 5")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"Decoder H.264 Compliance: InputType H264 - Verify DXVA Decoding for H.264")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\Dancing_1920x1088_6mbps_25fps_High_at_L4.1_Cavlc.mp4")
        END_TEST_METHOD()

        BEGIN_TEST_METHOD(H264PlaybackTest6)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"237C0151-3341-4E0E-AE86-041BE6D6FB88")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"bc76d04d-ac76-40cf-bc6c-0c438a00871e")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"H264 playback test 6")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"Decoder H.264 Compliance: InputType H264 - Verify DXVA Decoding for H.264")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\Dancing_1920x1088i_6mbps_25fps_High_at_L4.1_Cabac_Frext.mp4")
        END_TEST_METHOD()

        BEGIN_TEST_METHOD(H264PlaybackTest7)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"9201FD89-5532-45D2-9854-761D032B069D")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"d08545b9-7f67-4874-b256-c677e705a581")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"H264 playback test 7")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"Decoder H.264 Compliance: InputType H264 - Verify DXVA Decoding for H.264")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\Dancing_1920x1088i_9mbps_25fps_Main_at_L4.1_Cabac_PureMbaff.mp4")
        END_TEST_METHOD()

        BEGIN_TEST_METHOD(H264PlaybackTest8)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"616D8773-EB79-491E-8EDB-A056EFAB8FB6")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"084f47fd-24f2-45e9-860a-411329d79a5f")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"H264 playback test 8")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"Decoder H.264 Compliance: InputType H264 - Verify DXVA Decoding for H.264")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\Dancing_1920x1088i_8mbps_25fps_Main_at_L4.1_Cabac_Frext_Frm.mp4")
        END_TEST_METHOD()

        BEGIN_TEST_METHOD(H264PlaybackTest9)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"89FE28E2-5E6D-4EBB-A8CA-B90D92818945")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"dd37b121-ca6d-41be-85a1-e8e3856ec5dd")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"H264 playback test 9")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"Decoder H.264 Compliance: InputType H264 - Verify DXVA Decoding for H.264")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\Soccer_544x480_1mbps_29.97fps_Main_at_L3.0_Cabac_DTV.mp4")
        END_TEST_METHOD()


        //Soccer_1920x1080i_17mbps_29.97fps_High_at_L4.0_Cabac.mts
        BEGIN_TEST_METHOD(H264PlaybackTest10)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"15AB952A-4F2A-8EF5-0848-89A15F9FB326")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"353a36b3-1846-4a41-bb45-e1db2ae208ac")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"H264 playback test 10")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"Decoder H.264 Compliance: InputType H264 - Verify DXVA Decoding for H.264")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\Soccer_1920x1080i_17mbps_29.97fps_High_at_L4.0_Cabac.mts")
        END_TEST_METHOD()

        BEGIN_TEST_METHOD(H264PlaybackTest11)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"772F6F99-91A5-47BD-AA21-33F356DE7ECA")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"c3510698-dde7-4162-8187-6dc051ced843")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"H264 playback test 11")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"Decoder H.264 Compliance: InputType H264 - Verify DXVA Decoding for H.264")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\Dancing_1920x1088p_9mbps_25fps_High_at_L4.1_Cabac_Frext.mp4")
        END_TEST_METHOD()

        BEGIN_TEST_METHOD(H264PlaybackTest12)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"45E1CFCF-9C43-453D-9E76-A7622E6FBD43")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"ae88467e-269c-424a-8174-c281b7299588")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"H264 playback test 12")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"Decoder H.264 Compliance: InputType H264 - Verify DXVA Decoding for H.264")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\Dancing_1920x1088_9mbps_25fps_Main_at_L4.1_Cabac_NoFrext.mp4")
        END_TEST_METHOD()

        BEGIN_TEST_METHOD(H264PlaybackTest13)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"1DE081B4-B7A4-45D7-A2DF-4F381DE99219")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"abf54746-b09c-4d2e-9a3d-748a54dd47fd")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"H264 playback test 13")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"Decoder H.264 Compliance: InputType H264 - Verify DXVA Decoding for H.264")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\Soccer_1280x720p_5mbps_60fps_Main_at_L4.0_Cabac_ChromaMoving_VBR_DTV.mp4")
        END_TEST_METHOD()

        BEGIN_TEST_METHOD(H264PlaybackTest14)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"7973CF0C-4A46-4AF4-8DC7-570F629ECB2B")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"e403b76a-6366-470a-ab77-dcecc7a94f70")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"H264 playback test 14")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"Decoder H.264 Compliance: InputType H264 - Verify DXVA Decoding for H.264")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\Soccer_1280x720p_4mbps_30fps_Baseline_at_L3.1_8slices.mp4")
        END_TEST_METHOD()

        BEGIN_TEST_METHOD(H264PlaybackTest15)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"C2F7BF38-616B-449C-8C75-1E4580068F0A")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"544eeee7-fc78-4183-a4d6-ac4974f29b31")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"H264 playback test 15")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"Decoder H.264 Compliance: InputType H264 - Verify DXVA Decoding for H.264")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\Singing_320x240p_62kbps_24fps_Baseline_at_L3.0_TextureSkinTones.mp4")
        END_TEST_METHOD()

        BEGIN_TEST_METHOD(H264PlaybackTest16)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"AB0BAA82-6EC0-4B82-B545-F422CDDBA87E")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"754ea266-97ad-4a5e-b25b-8f898a94503f")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"H264 playback test 16")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"Decoder H.264 Compliance: InputType H264 - Verify DXVA Decoding for H.264")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\Tallship_1920x1080i_10mbps_30fps_Baseline_at_L4.0_fmoaso.mp4")
        END_TEST_METHOD()

        BEGIN_TEST_METHOD(H264PlaybackTest17)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"B2565BEE-44F0-4724-B908-5D6B1B9E3A95")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"becdbc4a-8256-4aa9-9bac-a7d4ef9b45a6")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"H264 playback test 17")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"Decoder H.264 Compliance: InputType H264 - Verify DXVA Decoding for H.264")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\Soccer_544x480i_2mbps_29.97fps_Main_at_L3.0_Cabac.mp4")
        END_TEST_METHOD()

        BEGIN_TEST_METHOD(H264PlaybackTest18)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"C96ADD7B-733E-4324-9EA6-9E808F9DB1B0")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"f25f5776-dc7e-49b7-9916-65f9983cf3b8")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"H264 playback test 18")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"Decoder H.264 Compliance: InputType H264 - Verify DXVA Decoding for H.264")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\H264FormatChange_720x480p_HP_at_L3.0_320x240p_MP.264")
        END_TEST_METHOD()

        BEGIN_TEST_METHOD(H264PlaybackTest19)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"29AAB814-8BFD-4F37-9952-8816441FC98E")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"e39739dd-0f6e-486d-9138-a19612a31667")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"H264 playback test 19")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"Decoder H.264 Compliance: InputType H264 - Verify DXVA Decoding for H.264")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\H264formatChange_1920x1088_High_at_L4.1_1280x720_Main.264")
        END_TEST_METHOD()



        //Soccer_MPG1_352x240p_1145kbps_24fps_Main_at_Main.m2ts
        BEGIN_TEST_METHOD(MPEG2PlaybackTest20)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"F466B676-491E-CA33-BF31-0AA6DC3FEA19")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"8d215f29-561e-484c-8ace-fa51be40ef7a")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"MPEG2 playback test 20")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"MPEG2 Playback DXVA Test: InputType MPEG2 - Verify DXVA Decoding for MPEG2")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\Soccer_MPG1_352x240p_1145kbps_24fps_Main_at_Main.m2ts")
        END_TEST_METHOD()

        BEGIN_TEST_METHOD(MPEG2PlaybackTest21)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"C7BD7408-DB68-43E0-80C1-2C0F4D3D6959")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"0d5c288b-bcc6-489b-8672-023094b97407")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"MPEG2 playback test 21")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"MPEG2 Playback DXVA Test: InputType MPEG2 - Verify DXVA Decoding for MPEG2")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\Soccer_1280x720p_17.5mbps_29.97fps_Main_at_High.m2v")
        END_TEST_METHOD()

        BEGIN_TEST_METHOD(MPEG2PlaybackTest22)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"E07F9DBA-AAA1-4941-A7E9-5F79E7F6B954")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"122eaf57-b3df-481e-85a9-999611e4f79b")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"MPEG2 playback test 22")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"MPEG2 Playback DXVA Test: InputType MPEG2 - Verify DXVA Decoding for MPEG2")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\Tallship_1920x1080p_10mbps_29.97fps_Main_at_High.m2v")
        END_TEST_METHOD()

        BEGIN_TEST_METHOD(MPEG2PlaybackTest23)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"CCD7F578-D81B-42F4-B161-B0EE0E548AA6")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"01fec4b0-034e-4ca5-84ad-524e6b7f0e05")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"MPEG2 playback test 23")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"MPEG2 Playback DXVA Test: InputType MPEG2 - Verify DXVA Decoding for MPEG2")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\foursquares_320x240_10mbps_30fps_Main_at_Main.m2v")
        END_TEST_METHOD()

        BEGIN_TEST_METHOD(MPEG2PlaybackTest24)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"CBF37842-09F3-4453-85A8-04C8E82172FA")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"1beff00f-e426-490e-aee7-7333c188c080")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"MPEG2 playback test 24")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"MPEG2 Playback DXVA Test: InputType MPEG2 - Verify DXVA Decoding for MPEG2")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\Dancing_1920x1080p_10mbps_23.97fps_Main_at_High.m2v")
        END_TEST_METHOD()

        BEGIN_TEST_METHOD(MPEG2PlaybackTest25)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"0092117B-D10A-47D2-97B9-22B6F598F6BE")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"5ea6431c-bab4-4697-9a30-efce5c66be84")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"MPEG2 playback test 25")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"MPEG2 Playback DXVA Test: InputType MPEG2 - Verify DXVA Decoding for MPEG2")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\Dancing_1920x1080p_17mbps_23.97fps_Main_at_High.m2v")
        END_TEST_METHOD()

        BEGIN_TEST_METHOD(MPEG2PlaybackTest27)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"81FCDC9B-DB3B-4800-9920-8DA776E2F73D")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"7394cf53-1547-4b1e-a4a1-75445337412c")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"MPEG2 playback test 27")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"MPEG2 Playback DXVA Test: InputType MPEG2 - Verify DXVA Decoding for MPEG2")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\TallShip_1920x1080p_15mbps_29.97fps_Main_at_High.m2v")
        END_TEST_METHOD()

        BEGIN_TEST_METHOD(MPEG2PlaybackTest28)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"AEC8FE22-68D4-40C2-ADD1-E5498C713332")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"304fc377-e688-461a-8f23-d945dde738e3")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"MPEG2 playback test 28")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"MPEG2 Playback DXVA Test: InputType MPEG2 - Verify DXVA Decoding for MPEG2")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\Dancing_1920x1080p_20mbps_23.97fps_Main_at_High.m2v")
        END_TEST_METHOD()

        BEGIN_TEST_METHOD(MPEG2PlaybackTest30)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"7859136F-6B0A-455C-A550-64877FEAAE76")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"2e84aa95-0cb5-4e9a-97ba-77ec3d5e2a38")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"MPEG2 playback test 30")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"MPEG2 Playback DXVA Test: InputType MPEG2 - Verify DXVA Decoding for MPEG2")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\Tallship_720x480i_field_60mbps_29.97fps_Main_at_High.m2v")
        END_TEST_METHOD()

        BEGIN_TEST_METHOD(MPEG2PlaybackTest31)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"D003B9A6-519D-452D-A46E-2735FE677003")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"313da978-9bca-40a9-8b75-a7c81aeaf090")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"MPEG2 playback test 31")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"MPEG2 Playback DXVA Test: InputType MPEG2 - Verify DXVA Decoding for MPEG2")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\Tallship_720x480i_frame_900kbps_29.97fps_main_at_main.m2v")
        END_TEST_METHOD()

        //Singing_352x288p_10mbps_15fps_AP_at_L0_cbr_TextureSkinTones_Noloopfilter.wmv
        BEGIN_TEST_METHOD(WMVPlaybackTest32)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"3F3DEDE6-40CD-254D-1E3F-33AE5C4D5D51")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"2ebe9f76-dc73-4fe2-8c9b-a54208307bf7")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"WMV playback test 32")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"WMV Playback DXVA Test: InputType WMV - Verify DXVA Decoding for VC-1")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\Singing_352x288p_10mbps_15fps_AP_at_L0_cbr_TextureSkinTones_Noloopfilter.wmv")
        END_TEST_METHOD()

        BEGIN_TEST_METHOD(WMVPlaybackTest33)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"3D63B71E-FEAD-4CD2-A519-DDAC1673CBD7")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"df1053a2-2e63-430c-bfa3-cac477cfd226")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"WMV playback test 33")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"WMV Playback DXVA Test: InputType WMV - Verify DXVA Decoding for VC-1")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\Soccer_720x480i_Field_TFF_3mbps_29.97fps_AP_at_L1_7BFr.wmv")
        END_TEST_METHOD()

        BEGIN_TEST_METHOD(WMVPlaybackTest34)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"6F903F12-3D93-4130-921B-159B62A5122A")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"5c88a53b-b858-4eef-9f03-d9fa79ef3c43")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"WMV playback test 34")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"WMV Playback DXVA Test: InputType WMV - Verify DXVA Decoding for VC-1")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\Tallship_720x576p_10mbps_25fps_AP_at_L1_6BFr_Noloopfilter.wmv")
        END_TEST_METHOD()

        BEGIN_TEST_METHOD(WMVPlaybackTest35)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"D88C421D-427B-4B7D-B063-6AC0C8732A23")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"7fb97249-ae9e-40a0-839e-315addac548f")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"WMV playback test 35")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"WMV Playback DXVA Test: InputType WMV - Verify DXVA Decoding for VC-1")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\Soccer_1280x720p_15mbps_60fps_AP_at_L2.wmv")
        END_TEST_METHOD()

        BEGIN_TEST_METHOD(WMVPlaybackTest36)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"61A93211-75FA-4D54-ACA6-C06608B965BB")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"34dae043-90a3-49b9-a600-3f510e0cc0d1")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"WMV playback test 36")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"WMV Playback DXVA Test: InputType WMV - Verify DXVA Decoding for VC-1")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\Soccer_1920x1080i_Frame_18mbps_29.97fps_AP_at_L2.wmv")
        END_TEST_METHOD()

        BEGIN_TEST_METHOD(WMVPlaybackTest37)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"17AB700F-F761-48D8-82FF-C63AC4915229")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"68eac8f4-05a8-48c5-9382-f4c280a9f2cb")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"WMV playback test 37")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"WMV Playback DXVA Test: InputType WMV - Verify DXVA Decoding for VC-1")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\Soccer_1920x1080p_10mbps_30fps_AP_at_L3_Motion_VBR_5bFr_0Complx_3Smoothe_Loopfilter.wmv")
        END_TEST_METHOD()

        BEGIN_TEST_METHOD(WMVPlaybackTest38)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"399F7753-8215-47F0-968F-2B09AC6F5BE4")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"214ba518-d1f8-4956-90ec-442703651e7e")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"WMV playback test 38")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"WMV Playback DXVA Test: InputType WMV - Verify DXVA Decoding for VC-1")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\Soccer_1280x720p_10mbps_24fps_AP_at_L3_CBR_1BFr_Noloopfilter.wmv")
        END_TEST_METHOD()

        BEGIN_TEST_METHOD(WMVPlaybackTest39)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"003C7519-81D3-443E-B320-A4FB3C9EFBDF")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"33c09f66-a8e3-41ec-9b33-d25e11c619db")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"WMV playback test 39")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"WMV Playback DXVA Test: InputType WMV - Verify DXVA Decoding for VC-1")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\Tallship_1920x1080i_MBR_4mbps_29.97fps_AP_at_L3.wmv")
        END_TEST_METHOD()

        BEGIN_TEST_METHOD(WMVPlaybackTest40)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"2B3E23F3-93A6-4F20-98AA-3842A6C6D8FF")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"e9de3aaa-8264-440f-b609-caaecf4a313a")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"WMV playback test 40")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"WMV Playback DXVA Test: InputType WMV - Verify DXVA Decoding for VC-1")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\Soccer_320x240p_500kbps_29.97fps_WMV3_MP.wmv")
        END_TEST_METHOD()

        BEGIN_TEST_METHOD(WMVPlaybackTest41)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"BD9D1D48-F243-431C-9A97-AF7BC7AE739A")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"495afbcb-09b8-4dd5-84d6-5fd3147ba4e0")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"WMV playback test 41")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"WMV Playback DXVA Test: InputType WMV - Verify DXVA Decoding for VC-1")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\Soccer_1280x720p_15mbps_60fps_MP_at_HL.wmv")
        END_TEST_METHOD()

        BEGIN_TEST_METHOD(WMVPlaybackTest42)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"C5FCBC03-D725-4114-AAE5-AD28A9B62992")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"591cfe1a-b128-4382-8bcb-a9bb4f7bf7fa")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"WMV playback test 42")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"WMV Playback DXVA Test: InputType WMV - Verify DXVA Decoding for VC-1")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\multi_resolution_with_sp.asf")
        END_TEST_METHOD()

        BEGIN_TEST_METHOD(WMVPlaybackTest43)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"934D5E6C-92B0-48AA-9D2D-688FA729E1D4")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"ae1dd40a-a242-408e-80f9-b1341d359854")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"WMV playback test 43")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"WMV Playback DXVA Test: InputType WMV - Verify DXVA Decoding for VC-1")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\no_sp_cif_hd_vga.asf")
        END_TEST_METHOD()


        //Singing_320x240p_380kbps_24fps_Baseline_at_L3.0_ - fuzztype5_ - RFrs4.264
        BEGIN_TEST_METHOD(H264FuzzTest100)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"818299D2-49FC-D295-170E-F7B2644EAB75")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"a68c31f6-2eea-4e62-b992-ae854c6dba74")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"H264 fuzz test 100")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"H264 Fuzz DXVA Test: InputType H264 - H.264 Fuzzing test")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\Singing_320x240p_380kbps_24fps_Baseline_at_L3.0_-fuzztype5_-RFrs4.264")
        END_TEST_METHOD()

        //Soccer_640x480p_1.2mbps_29.97fps_High_at_L4.1_ - fuzztype0_ - RFrp2_ - RFer21_ - RFrs121_ - RFep26_ - RFf38.264
        BEGIN_TEST_METHOD(H264FuzzTest101)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"F324C442-46C8-799F-2493-89A599368C88")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"042b79ee-3c15-4345-a316-220d9fbcc3f9")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"H264 fuzz test 101")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"H264 Fuzz DXVA Test: InputType H264 - H.264 Fuzzing test")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\Soccer_640x480p_1.2mbps_29.97fps_High_at_L4.1_-fuzztype0_-RFrp2_-RFer21_-RFrs121_-RFep26_-RFf38.264")
        END_TEST_METHOD()

        //Tallship_1920x1088i_field_14mbps_FuzzNalu_PPS_ER5.264
        BEGIN_TEST_METHOD(H264FuzzTest102)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"0C882B5B-4C77-F2DC-43D4-6F90F04E618A")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"4c4a9c83-d083-4d5c-9819-8d332d9bd1ee")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"H264 fuzz test 102")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"H264 Fuzz DXVA Test: InputType H264 - H.264 Fuzzing test")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\Tallship_1920x1088i_field_14mbps_FuzzNalu_PPS_ER5.264")
        END_TEST_METHOD()


        //Soccer_1280x720p_17.5mbps_29.97fps_Main_at_High_ - fuzztype0_ - RFrp2_ - RFer28_ - RFrs35_ - RFep39_ - RFf26.m2v
        BEGIN_TEST_METHOD(MPEG2FuzzTest107)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"051C9F56-4742-FE53-7A6D-E88D0F37A953")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"136eccfc-9061-4136-9f0a-8a164017c71e")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"MPEG2 fuzz test 107")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"MPEG2 Fuzz DXVA Test: InputType MPEG2 - MPEG2 Fuzzing Test")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\Soccer_1280x720p_17.5mbps_29.97fps_Main_at_High_-fuzztype0_-RFrp2_-RFer28_-RFrs35_-RFep39_-RFf26.m2v")
        END_TEST_METHOD()

        //Dancing_1920x1080p_20mbps_FuzzElement_PictH_SeqHExt_ER20.m2v
        BEGIN_TEST_METHOD(MPEG2FuzzTest108)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"AA96B905-4F0F-05E5-0097-FFAA3669AC75")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"c38f7291-786f-46d6-af1c-024a6c3b5ee4")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"MPEG2 fuzz test 108")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"MPEG2 Fuzz DXVA Test: InputType M2V - MPEG2 Fuzzing Test")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\Dancing_1920x1080p_20mbps_FuzzElement_PictH_SeqHExt_ER20.m2v")
        END_TEST_METHOD()

        //M2VFormatChange_FuzzElement_SeqtH_GOP_ER20.m2v
        BEGIN_TEST_METHOD(MPEG2FuzzTest109)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"5AA2A021-488A-15CA-553E-BD8BBF9CBA27")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"762f5815-b310-46a7-9286-390a03a18803")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"MPEG2 fuzz test 109")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"MPEG2 Fuzz DXVA Test: InputType M2V - MPEG2 Fuzzing Test")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\M2VFormatChange_FuzzElement_SeqtH_GOP_ER20.m2v")
        END_TEST_METHOD()

        //Singing_320x240p_10mbps_FuzzAction_DropBDU_ER20.wmv
        BEGIN_TEST_METHOD(WMVFuzzTest114)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"480B547F-4A49-D009-2766-75B6DFC291C0")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"6574c53e-c0d2-4cc1-a67b-3fbfc7a90ab2")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"WMV fuzz test 114")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"WMV Fuzz DXVA Test: InputType WMV - WMV/VC-1 Fuzzing Test")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\Singing_320x240p_10mbps_FuzzAction_DropBDU_ER20.wmv")
        END_TEST_METHOD()

        //Soccer_720x480i_Field_TFF_3mbps_FuzzActions_RepeatBDU_ER15.wmv
        BEGIN_TEST_METHOD(WMVFuzzTest115)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"6835DD75-42FB-D7AD-DC26-C1976D212960")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"59cb483b-5ab0-490f-9728-0706fe6f82ce")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"WMV fuzz test 115")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"WMV Fuzz DXVA Test: InputType WMV - WMV/VC-1 Fuzzing Test")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\Soccer_720x480i_Field_TFF_3mbps_FuzzActions_RepeatBDU_ER15.wmv")
        END_TEST_METHOD()

        //Soccer_720x480i_frame_3mbps_FuzzActions_ReplaceBDU_ER25.wmv
        BEGIN_TEST_METHOD(WMVFuzzTest116)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"A0EE2C4F-43FF-DEE5-32A6-548A1C06DEC7")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"f6b7d7d4-7edc-461b-9559-e8f7d320c40d")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"WMV fuzz test 116")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"WMV Fuzz DXVA Test: InputType WMV - WMV/VC-1 Fuzzing Test")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\Soccer_720x480i_frame_3mbps_FuzzActions_ReplaceBDU_ER25.wmv")
        END_TEST_METHOD()


        //Tallship_1920x1088_10mbps_25fps_High_at_L4.1_Cabac_Mbaff.mp4
        BEGIN_TEST_METHOD(H264QualityTest200)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"0EC4D82F-4AFB-7112-4021-578B36A0BD50")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"5b4d4bb0-3dca-4122-abc2-9e48ff484d32")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"H264 quality test 200")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"H264 Quality DXVA Test: InputType H264 - H264 Quality")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\Tallship_1920x1088_10mbps_25fps_High_at_L4.1_Cabac_Mbaff.mp4")
        END_TEST_METHOD()

        //Tallship_1920x1088_6mbps_25fps_High_at_L4.1_Cabac_Picaff.mp4
        BEGIN_TEST_METHOD(H264QualityTest201)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"6C51F717-4D18-D0D3-7851-3DA811AA7EA0")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"21c9682b-19ac-4cb3-8e19-74d28d0d0fe7")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"H264 quality test 201")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"H264 Quality DXVA Test: InputType H264 - H264 Quality")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\Tallship_1920x1088_6mbps_25fps_High_at_L4.1_Cabac_Picaff.mp4")
        END_TEST_METHOD()

        //Tallship_1920x1088_10mbps_25fps_High_at_L4.1_Cabac_Prog.mp4
        BEGIN_TEST_METHOD(H264QualityTest202)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"C82C4794-4AFB-7062-89E0-FCB19B189593")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"cd2316b5-f95a-450e-9ec4-384e1e8f6e7a")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"H264 quality test 202")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"H264 Quality DXVA Test: InputType H264 - H264 Quality")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\Tallship_1920x1088_10mbps_25fps_High_at_L4.1_Cabac_Prog.mp4")
        END_TEST_METHOD()

        //Soccer_1280x720p_5mbps_60fps_Main_at_L4.0_Cabac_ChromaMoving_VBR_DTV.mp4
        BEGIN_TEST_METHOD(H264QualityTest203)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"AF808565-425C-1476-D8FF-1CBE1996B315")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"10be76af-d868-4c9f-97c2-c8102372a944")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"H264 quality test 203")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"H264 Quality DXVA Test: InputType H264 - H264 Quality")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\Soccer_1280x720p_5mbps_60fps_Main_at_L4.0_Cabac_ChromaMoving_VBR_DTV.mp4")
        END_TEST_METHOD()

        //Lanczos_Mobileportrait_720x1280p_9mbps_25fps_Main_at_L3.1_Cabac.mp4
        BEGIN_TEST_METHOD(H264QualityTest204)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"DC95A170-4EBF-ABB6-E561-C896AEBF0FD9")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"841b3766-2800-4b82-ae71-b50a2a3de057")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"H264 quality test 204")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"H264 Quality DXVA Test: InputType H264 - H264 Quality")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\Lanczos_Mobileportrait_720x1280p_9mbps_25fps_Main_at_L3.1_Cabac.mp4")
        END_TEST_METHOD()

        //Tallship_1920x1080p_4mbps_30fps_Baseline_at_L4.0_4slices.mp4
        BEGIN_TEST_METHOD(H264QualityTest205)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"798B8ABA-45EF-60FE-BBCA-D6B823DF85FF")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"d836c299-161c-49c1-a9b0-803e98f0fc4d")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"H264 quality test 205")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"H264 Quality DXVA Test: InputType H264 - H264 Quality")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\Tallship_1920x1080p_4mbps_30fps_Baseline_at_L4.0_4slices.mp4")
        END_TEST_METHOD()

        //Dancing_1920x1080p_20mbps_23.97fps_Main_at_High.m2v
        BEGIN_TEST_METHOD(MPEG2QualityTest206)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"B046572A-4E2A-896B-0028-54930C657883")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"19625a28-e3ac-4f51-b17b-fc26c9bf3573")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"MPEG2 quality test 206")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"MPEG2 Quality DXVA Test: InputType MPEG2 - MPEG2 Quality")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\Dancing_1920x1080p_20mbps_23.97fps_Main_at_High.m2v")
        END_TEST_METHOD()

        //Soccer_1280x720p_18mbps_25fps_Main_at_High.m2ts
        BEGIN_TEST_METHOD(MPEG2QualityTest207)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"BFF3FA40-4228-DC23-DFEB-0A980E85F0DA")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"a2141b86-4486-47ef-9185-88b1d684d73a")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"MPEG2 quality test 207")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"MPEG2 Quality DXVA Test: InputType MPEG2 - MPEG2 Quality")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\Soccer_1280x720p_18mbps_25fps_Main_at_High.m2ts")
        END_TEST_METHOD()

        //Tallship_720x480i_frame_900kbps_29.97fps_main_at_main.m2v
        BEGIN_TEST_METHOD(MPEG2QualityTest211)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"C1AE4AF1-4E4C-71C5-23DD-E8AC90635D0C")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"a97ae666-b9ff-4e48-a0b7-65882d32f489")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"MPEG2 quality test 211")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"MPEG2 Quality DXVA Test: InputType MPEG2 - MPEG2 Quality")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\Tallship_720x480i_frame_900kbps_29.97fps_main_at_main.m2v")
        END_TEST_METHOD()

        //Tallship_320x240p_10mbps_29.97fps_AP_at_L0_6BFr_CBR_Noloopfilter.wmv
        BEGIN_TEST_METHOD(WMVQualityTest212)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"41F16BD0-4029-9BD5-1761-1EBF1407ED85")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"81b11531-11f2-42c3-aa8c-746fe12431c7")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"WMV quality test 212")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"WMV Quality DXVA Test: InputType WMV - WMV Quality")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\Tallship_320x240p_10mbps_29.97fps_AP_at_L0_6BFr_CBR_Noloopfilter.wmv")
        END_TEST_METHOD()

        //Soccer_720x480i_Field_TFF_3mbps_29.97fps_AP_at_L1_2BFr.wmv
        BEGIN_TEST_METHOD(WMVQualityTest213)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"3227F2CF-4A5D-119F-A588-B0AF01CEAC67")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"143fea07-b1d8-4c91-8b5a-d3208a75ada2")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"WMV quality test 213")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"WMV Quality DXVA Test: InputType WMV - WMV Quality")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\Soccer_720x480i_Field_TFF_3mbps_29.97fps_AP_at_L1_2BFr.wmv")
        END_TEST_METHOD()

        //Soccer_720x480i_frame_3mbps_29.97fps_AP_at_L1_4444rangeredux.wmv
        BEGIN_TEST_METHOD(WMVQualityTest214)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"BC2C149B-428F-EAC0-6BF0-6594D5E827FF")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"a792e7cc-c16f-4d90-aa11-5a110dfc6050")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"WMV quality test 214")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"WMV Quality DXVA Test: InputType WMV - WMV Quality")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\Soccer_720x480i_frame_3mbps_29.97fps_AP_at_L1_4444rangeredux.wmv")
        END_TEST_METHOD()

        //Soccer_1280x720_15mbps_29.97fps_AP_at_L2.wmv
        BEGIN_TEST_METHOD(WMVQualityTest215)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"AADB05DE-493F-83F7-8AAD-838226E4E11F")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"f932f050-86b0-4d2c-8f93-590d30f76f47")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"WMV quality test 215")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"WMV Quality DXVA Test: InputType WMV - WMV Quality")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\Soccer_1280x720_15mbps_29.97fps_AP_at_L2.wmv")
        END_TEST_METHOD()

        //Soccer_MotionDifDirect_1280x720p_10mbps_24fps_AP_at_L2_vbr_5bfr_2complx_55smoothe_loopfilter.wmv
        BEGIN_TEST_METHOD(WMVQualityTest216)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"21C36A5C-428E-E689-F60C-9EA21FD42D5F")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"644c8e43-1e8c-472b-9bbb-c8509043ff5c")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"WMV quality test 216")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"WMV Quality DXVA Test: InputType WMV - WMV Quality")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\Soccer_MotionDifDirect_1280x720p_10mbps_24fps_AP_at_L2_vbr_5bfr_2complx_55smoothe_loopfilter.wmv")
        END_TEST_METHOD()

        //Soccer_1280x720p_15mbps_60fps_AP_at_L3_2dquantoption.wmv
        BEGIN_TEST_METHOD(WMVQualityTest217)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"6D6365A5-4837-FF9B-25FF-3EAE0BADDC3C")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"1b9907d0-e64c-481c-88bf-79b4f3747127")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"WMV quality test 217")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"WMV Quality DXVA Test: InputType WMV - WMV Quality")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\Soccer_1280x720p_15mbps_60fps_AP_at_L3_2dquantoption.wmv")
        END_TEST_METHOD()

        //Soccer_960x720p_15mbps_60fps_AP_at_L3_4x3PAR.wmv
        BEGIN_TEST_METHOD(WMVQualityTest218)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"515485B4-4988-1A48-0BDE-EA97904ABB82")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"951ed8b3-e540-4942-b7b9-7bebab7116c5")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"WMV quality test 218")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"WMV Quality DXVA Test: InputType WMV - WMV Quality")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\Soccer_960x720p_15mbps_60fps_AP_at_L3_4x3PAR.wmv")
        END_TEST_METHOD()

        //Soccer_1920x1080i_Field_TFF_18mbps_29.97fps_AP_at_L3_1LoopFilter.wmv
        BEGIN_TEST_METHOD(WMVQualityTest219)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"02F061AE-4D6A-DEDF-986C-79BBF8797624")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"5f81d511-69f7-4415-b4c4-4e27e0ce7eb3")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"WMV quality test 219")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"WMV Quality DXVA Test: InputType WMV - WMV Quality")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\Soccer_1920x1080i_Field_TFF_18mbps_29.97fps_AP_at_L3_1LoopFilter.wmv")
        END_TEST_METHOD()

        //Soccer_1920x1080i_Frame_18mbps_29.97fps_AP_at_L3.wmv
        BEGIN_TEST_METHOD(WMVQualityTest220)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"7BA4B746-C8B9-4063-B472-265E72B4B638")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"a34f7dde-5339-4dda-ab4d-b15221c25628")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"WMV quality test 220")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"WMV Quality DXVA Test: InputType WMV - WMV Quality")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\Soccer_1920x1080i_Frame_18mbps_29.97fps_AP_at_L3.wmv")
        END_TEST_METHOD()

        //spFramesNewBitstreamLayout.asf
        BEGIN_TEST_METHOD(WMVQualityTest221)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"0F55175D-13ED-4EF2-A2EB-9802CD1E926D")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"2117bca6-1616-4ff0-93fb-a1ad15c0eaa9")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"WMV quality test 221")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"WMV Quality DXVA Test: InputType ASF - WMV Quality")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\spFramesNewBitstreamLayout.asf")
        END_TEST_METHOD()

        //Rotate_180.mov
        BEGIN_TEST_METHOD(H264QualityTest299)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"F067DFB2-BFDE-463D-9D3C-3C2DFDD7605F")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"8acc7f79-b956-4294-9ac8-b75e03cac340")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"H264 quality test 299")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"H264 Quality DXVA Test: InputType H264 - H264 Quality")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\Rotate_180.mov")
        END_TEST_METHOD()


        //Dancing_1920x1080p_13mbps_23.97fps_Main_at_4.0L_Cabac_VBR_DTV.mp4
        BEGIN_TEST_METHOD(H264StressTest300)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"10997168-451F-CCDE-A4F6-7C9CC869351D")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"20fdd249-eeb3-45a6-802e-88c00b0e72e0")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"H264 stress test 300")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"120")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"120")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"H264 Stress DXVA Test: InputType H264 - H.264 Stress 15min DXVA Decode of H.264")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\Dancing_1920x1080p_13mbps_23.97fps_Main_at_4.0L_Cabac_VBR_DTV.mp4")
        END_TEST_METHOD()

        //Soccer_1280x720p_3mbps_25fps_High_at_L4.1_Cabac_frext_slice.mp4
        BEGIN_TEST_METHOD(H264MultiInstanceTest400)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"F2EF5380-4FC1-9BA5-69AA-02902578C13C")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"f8b13f44-a93f-48ea-adab-06c63021d123")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"H264 multi instance test 400")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"Multi Instance DXVA Test: InputType H264 - Multi Instance DXVA Test H264")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\Soccer_1280x720p_3mbps_25fps_High_at_L4.1_Cabac_frext_slice.mp4")
        END_TEST_METHOD()

        //Singing_320x240p_10mbps_23.97fps_AP_at_L0_2BFr_TextureSkinTones_Noloopfilter.wmv
        BEGIN_TEST_METHOD(WMVMultiInstanceTest405)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"4C1D16A3-4046-5D3F-5DF7-DF9D85D10759")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"66dce2fd-b576-4a45-b3e9-f452a1357078")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"WMV multiInstance test 405")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"Multi Instance DXVA Test: InputType WMV - Multi Instance DXVA Test WMV")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\Singing_320x240p_10mbps_23.97fps_AP_at_L0_2BFr_TextureSkinTones_Noloopfilter.wmv")
        END_TEST_METHOD()

      BEGIN_TEST_METHOD(MPEG2StressTest303)
          TEST_METHOD_PROPERTY(L"Kits.TestId", L"DA4D8ECA-1E52-4AE4-B0A4-06BFFDCBB526")
          TEST_METHOD_PROPERTY(L"Kits.TestId2", L"0ceaa672-5629-4eb8-9780-7a089c333b0f")
          TEST_METHOD_PROPERTY(L"Kits.TestName", L"MPEG2 Stress test 303")
          TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
          TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
          TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"120")
          TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"120")
          TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
          TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
          TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
          TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
          TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
          TEST_METHOD_PROPERTY(L"Kits.Description", L"MPEG2 Stress DXVA Test: InputType MPEG2 - Verify DXVA Decoding for MPEG2")
          TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
          TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
          TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
          TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
          TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
          TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
          TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
          TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
          TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
          TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
          TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
          TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\M2VFormatChange_1280x720p_MP_at_HL_1920x1080p_MP.m2v")
        END_TEST_METHOD()

        BEGIN_TEST_METHOD(WMVStressTest305)
            TEST_METHOD_PROPERTY(L"Kits.TestId", L"3B0B1D3B-2906-40DC-B231-7AFAF40CFCE4")
            TEST_METHOD_PROPERTY(L"Kits.TestId2", L"61920cbf-489d-4af8-9a5a-fd3146cedaa3")
            TEST_METHOD_PROPERTY(L"Kits.TestName", L"WMV Stress test 305")
            TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
            TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
            TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"120")
            TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"120")
            TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
            TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
            TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
            TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
            TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
            TEST_METHOD_PROPERTY(L"Kits.Description", L"WMV Playback DXVA Test: InputType WMV - Verify DXVA Decoding for VC-1")
            TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
            TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
            TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
            TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
            TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
            TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
            TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
            TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
            TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
            TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
            TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
            TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\Tallship_1920x1080i_MBR_8mbps_29.97_AP_at_L3.wmv")
        END_TEST_METHOD()


        BEGIN_TEST_METHOD(MPEG2MultiInstanceTest403)
            TEST_METHOD_PROPERTY(L"Kits.TestId", L"F9B0959E-6139-4C6F-9ACE-50AF1F0DA4B7")
            TEST_METHOD_PROPERTY(L"Kits.TestId2", L"5b879946-83c2-4b08-883a-4b2cd587fb52")
            TEST_METHOD_PROPERTY(L"Kits.TestName", L"MPEG2 Multi-Instance test 403")
            TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
            TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
            TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
            TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
            TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
            TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
            TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
            TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
            TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
            TEST_METHOD_PROPERTY(L"Kits.Description", L"MPEG2 Multi-Instance DXVA Test: InputType MPEG2 - Verify DXVA Decoding for MPEG2")
            TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
            TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
            TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
            TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
            TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
            TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
            TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
            TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
            TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
            TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
            TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
            TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\m2vformatchange_320x240iFrame_MP_at_ML_1920x1080iField_MP.m2v")
        END_TEST_METHOD()


        BEGIN_TEST_METHOD(WMVMultiInstanceTest406)
            TEST_METHOD_PROPERTY(L"Kits.TestId", L"226C688F-5958-4AEA-A1DF-3E6C487005CC")
            TEST_METHOD_PROPERTY(L"Kits.TestId2", L"feee9b11-65d9-4331-bebb-e9d983f91c98")
            TEST_METHOD_PROPERTY(L"Kits.TestName", L"WMV Multi-Instance test 406")
            TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
            TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
            TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
            TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
            TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
            TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
            TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
            TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
            TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
            TEST_METHOD_PROPERTY(L"Kits.Description", L"WMV Playback DXVA Test: InputType WMV - Verify DXVA Decoding for VC-1")
            TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
            TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Graphics.WDDM12.Render.D3D11VideoDecoding")
            TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
            TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
            TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\DXVAContent")
            TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
            TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
            TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
            TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
            TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
            TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the DXVA Decoder to test - {DETECT} should be used for certification, this can be overridden to test a specific decoder")
            TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\DXVAContent\\Soccer_1280x720p_10mbps_24fps_AP_at_L3_CBR_1BFr_Noloopfilter.wmv")
        END_TEST_METHOD()

        BEGIN_TEST_METHOD(CustomXML)
        TEST_METHOD_PROPERTY(L"CustomXML", L"TRUE")
        END_TEST_METHOD()

protected:
    HRESULT RunTestsWithIDs(const DWORD* pdwTestIDs, const DWORD dwNumTestIDs);
    HRESULT RunActualTest(const DWORD dwTestID, const GUID* pGUIDMFTUnderTest, const WCHAR* pszHWURL);
    HRESULT GetGUIDsToTest(const DWORD dwTestID, GUID pGUIDsToTest[], WCHAR* pppszHWURLs[], const DWORD dwMaxGUIDsToTest, DWORD *pdwNumGUIDs);
    HRESULT VerifyHWRegKeys(void);
};

#pragma prefast(pop)
