// Copyright(C) Microsoft.All rights reserved.

// testcases.h

#pragma once

#include "common.h"

#include "drmstruct.h"

#ifndef KSPROPERTY_AUDIOENGINE_PROCESSINGPERIOD
#define KSPROPERTY_AUDIOENGINE_PROCESSINGPERIOD 3
#endif

// Macros for entry definition
// ------------------------------------------------------------------------------
// Shell98 test definition
//typedef struct dv_dvinfo_tag
//{
//        LPSTR       pszCaseID;      // shell    - test case ID
//    LPSTR       pszName;        // shell    - test case name
//    LPARAM      lpCaseFlags;    // shell    - test case flags
//    LPARAM      lpDeviceFlags;  // shell    - device type flags
//    LPARAM      lpSTFlags;      // selftest - server/cable/input flags
//    LPARAM      lpUser;         // User-defined field
//    TESTFNPROC  pfnTest;        // shell    - Pointer to the test case function
//    LPSTR       pszGuid;        // shell    - test case GUID identifier
//} DV_TCINFO, *PDV_TCINFO;

// helper functions to create test cases
LPARAM Gaudit_Test_Entry_Prop(
        ULONG flags,
        GUID propSet,
        ULONG propId,
        LPSTR szPropSetName,
        LPSTR szPropIdName,
        ULONG outSize
) {
    GAUDITTESTDEF* p = new GAUDITTESTDEF; // will live forever (until process closes)
    p->ulGauditFlags = flags;
    p->KsProp.guidPropSet = propSet;
    p->KsProp.ulPropId = propId;
    p->KsProp.szPropSetName = szPropSetName;
    p->KsProp.szPropIdName = szPropIdName;
    p->Ioctl.ulIoctl = INVALID_IOCTL;
    p->Ioctl.szIoctlName = NULL;
    p->pReserved = 0;
    p->cbOutSize = outSize;

    return (LPARAM)p;
}

LPARAM Gaudit_Test_Entry_Ioctl(
        ULONG flags,
        ULONG ioctl,
        LPSTR szIoctlName,
        ULONG outSize
) {
    GAUDITTESTDEF* p = new GAUDITTESTDEF; // will live forever (until process closes)
    p->ulGauditFlags = flags;
    p->KsProp.guidPropSet.Data1 = 0;
    p->KsProp.guidPropSet.Data2 = 0;
    p->KsProp.guidPropSet.Data3 = 0;
    for (int i = 0; i < 8; i++) {
        p->KsProp.guidPropSet.Data4[i] = 0;
    }
    p->KsProp.ulPropId = INVALID_PROPERTY;
    p->KsProp.szPropSetName = NULL;
    p->KsProp.szPropIdName = NULL;
    p->Ioctl.ulIoctl = ioctl;
    p->Ioctl.szIoctlName = szIoctlName;
    p->pReserved = 0;
    p->cbOutSize = outSize;

    return (LPARAM)p;
}

#define GAUDIT_TEST_ENTRY_PROP(Flags, Set, Id, Size) \
    (Gaudit_Test_Entry_Prop((Flags), (Set), (Id), #Set, #Id, (Size)))

#define GAUDIT_TEST_ENTRY_IOCTL(Flags, Ioctl, Size) \
    (Gaudit_Test_Entry_Ioctl((Flags), (Ioctl), #Ioctl, (Size)))

LPARAM lpTest = Gaudit_Test_Entry_Prop(
    GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED,
    KSPROPSETID_Audio,
    KSPROPERTY_AUDIO_MIX_LEVEL_CAPS,
    "KSPROPSETID_Audio",
    "KSPROPERTY_AUDIO_MIX_LEVEL_CAPS",
    sizeof(KSAUDIO_MIXCAP_TABLE)
);

#ifndef BUILD_TAEF
DV_TCINFO rgTestCaseInfo[] =
{
    { "", "KS properties",							0, 0, 0, 0, NULL, "{d95355c8-f679-4986-a498-c86350af0b79}" },

    // KSPROPSETID_Audio
    { "", " KSPROPSETID_Audio",						0, 0, 0, 0, NULL, "{5db39b7d-2070-4a41-a428-292dfb9112ff}" },
    { "", "  KSPROPERTY_AUDIO_MIX_LEVEL_CAPS",		0, 0, 0, 0, NULL, "{461f14fd-c3af-4877-8950-7793847951a3}"},
    { "100.1.1", "   0 for in/out channels",				0, 0, 0,
        // parameters to pass to test function
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_MIX_LEVEL_CAPS, sizeof(KSAUDIO_MIXCAP_TABLE)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIO_MIX_LEVEL_CAPS_1, "{7d5aadce-2f0a-4967-97f4-141722354c1a}"},
    { "100.1.2", "   ULONG_MAX for in/out channels",		0, 0, 0, 
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_MIX_LEVEL_CAPS, sizeof(KSAUDIO_MIXCAP_TABLE)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIO_MIX_LEVEL_CAPS_2, "{68553ef1-3de4-494b-95c0-a0aa19785696}"},
    { "100.1.3", "   0x80000001/2 for in/out channels",		0, 0, 0, 
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_MIX_LEVEL_CAPS, sizeof(KSAUDIO_MIXCAP_TABLE)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIO_MIX_LEVEL_CAPS_3, "{61e7b53f-15df-461f-b0c6-c8da960604ac}"},
    { "100.1.4", "   Out buffer small",						0, 0, 0, 
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_MIX_LEVEL_CAPS, sizeof(KSAUDIO_MIXCAP_TABLE)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIO_MIX_LEVEL_CAPS_4, "{4b93c48e-e2cf-4f97-92a8-128421c72b98}"},
    { "100.1.5", "   invalid node id",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_MIX_LEVEL_CAPS, sizeof(KSAUDIO_MIXCAP_TABLE)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIO_MIX_LEVEL_CAPS_5, "{53C11D41-5448-4933-B6C3-1E065B8855F9}"},
    { "100.1.6", "   valid Test data",						0, 0, 0, 
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_MIX_LEVEL_CAPS, sizeof(KSAUDIO_MIXCAP_TABLE)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIO_MIX_LEVEL_CAPS, "{36D080F7-514D-4045-B29C-33618817924C}"},        
        
    { "", "  KSPROPERTY_AUDIO_NUM_EQ_BANDS",		0, 0, 0, 0, NULL, "{2df54bc6-a73d-4fe0-9d78-4ede8108688c}"},
    { "100.2.2", "   Invalid Node ID - ULONG_MAX",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_NUM_EQ_BANDS, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_NodeID_ULONGMAX, "{A6673AA6-6D0E-4351-8934-E64A81CD48EE}"},
    { "100.2.3", "   Invalid Node ID - 0x80000001",               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_NUM_EQ_BANDS, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_NodeID_0x80000001, "{EDD3CE9D-5FBB-4008-B7AF-0459CE5ED276}"},
    { "100.2.4", "   Invalid Channel ID - 0xFFFFFFFE",            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_NUM_EQ_BANDS, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_ChannelID_0xFFFFFFFE, "{DD17A656-FCD3-4d97-947E-67CCA95A91AD}"},
    { "100.2.5", "   NULL IN/OUT Buffer",					0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_NUM_EQ_BANDS, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_NULL_Buffer, "{53AFC8E2-D00E-4b69-9D3C-F3C58ED550C1}"},
    { "100.2.6", "   Small IN/OUT Buffer",                             0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_NUM_EQ_BANDS, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_Small_Buffer, "{1B3CC923-88E7-4dd7-80E3-BF0FD6AE6FDC}"},
    { "100.2.7", "   Out buffer Large",                                   0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_NUM_EQ_BANDS, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_Large_Buffer, "{00D57899-0ED9-4688-8331-F51097BCD32F}"},
    { "100.2.8", "   valid Test data",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_NUM_EQ_BANDS, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_Valid_Test, "{00D40979-BCEB-42b6-9BB8-4A6C1E3D8710}"},

    { "", "  KSPROPERTY_AUDIO_CHORUS_LEVEL",                0, 0, 0, 0, NULL, "{1DD9AF5D-79EA-4229-88E1-218B0429D9D5}"},
	{ "100.3.1", "   Invalid Node ID - ULONG_MAX",               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_CHORUS_LEVEL, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_NodeID_ULONGMAX, "{123D8664-6EC9-4151-9BE2-E80253715379}"},
	{ "100.3.2", "   Invalid Node ID - 0x80000001",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_CHORUS_LEVEL, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_NodeID_0x80000001, "{49BDAE38-0CEF-457d-9348-DFB05337A6CB}"},
	{ "100.3.3", "   NULL IN/OUT Buffer",                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_CHORUS_LEVEL, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_NULL_Buffer, "{4633F24D-ED5B-4d09-AA74-97C7B08B8FE9}"},
    { "100.3.4", "   Small IN/OUT Buffer",                              0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_CHORUS_LEVEL, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_Small_Buffer, "{3ADE351A-D688-412b-8A0C-7B89DF537FF3}"},
	{ "100.3.5", "   Out buffer Large",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_CHORUS_LEVEL, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_Large_Buffer, "{AD0AC2C9-ED91-499f-9515-A9A9180F9976}"},	
    { "100.3.6", "   valid test data",                                       0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_CHORUS_LEVEL, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_Valid_Test, "{310904D2-E188-4ee1-824E-0252B686D360}"},   

    { "", "  KSPROPERTY_AUDIO_CPU_RESOURCES",             0, 0, 0, 0, NULL, "{F33E9C73-0809-4be6-8988-7DFEDF515615}"},
	{ "100.4.1", "   Invalid Node ID - ULONG_MAX",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_CPU_RESOURCES, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_NodeID_ULONGMAX, "{FD6ADE34-00AD-40d1-AEA8-D3481222D5D8}"},
	{ "100.4.2", "   Invalid Node ID - 0x80000001",  		0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_CPU_RESOURCES, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_NodeID_0x80000001, "{50217166-5CB3-4814-897C-7219C62C1B55}"},
	{ "100.4.3", "   NULL IN/OUT Buffer",  					0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_CPU_RESOURCES, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_NULL_Buffer, "{5D4EFB21-DA90-463a-BABB-EF673E595DCD}"},
	{ "100.4.4", "   Small IN/OUT Buffer",  				0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_CPU_RESOURCES, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_Small_Buffer, "{6ECF0651-21B4-40de-878F-C970DE2BF115}"},
	{ "100.4.5", "   Out buffer Large",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_CPU_RESOURCES, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_Large_Buffer, "{C231EEFB-FFC5-47fb-9044-60492921497A}"},	
    { "100.4.6", "   valid test data",                                       0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_CPU_RESOURCES, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_Valid_Test, "{9622D0E7-FD00-42a6-9E78-C40150B8216B}"},   	

    { "", "  KSPROPERTY_AUDIO_DEMUX_DEST",			0, 0, 0, 0, NULL, "{384344BD-3218-4611-879B-E41F2AE0951D}"},
	{ "100.5.1", "   Invalid Node ID - ULONG_MAX",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_DEMUX_DEST, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_NodeID_ULONGMAX, "{74FA1540-BC6A-4a82-B566-CDE022DC5362}"},
	{ "100.5.2", "   Invalid Node ID - 0x80000001",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_DEMUX_DEST, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_NodeID_0x80000001, "{1CF205F0-15C7-4010-932A-EA382BC64276}"},
	{ "100.5.3", "   NULL IN/OUT Buffer",					0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_DEMUX_DEST, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_NULL_Buffer, "{658D9F14-6612-471d-ABF9-E53B0A9A8BBB}"},
	{ "100.5.4", "   Small IN/OUT Buffer",					0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_DEMUX_DEST, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_Small_Buffer, "{39C052F8-B278-41d4-B296-9ECC310A63EF}"},
	{ "100.5.5", "   Out buffer Large",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_DEMUX_DEST, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_Large_Buffer, "{B297ACFA-4D2D-40d1-8EB6-10E818F8098F}"},	
    { "100.5.6", "   valid test data",                                       0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_DEMUX_DEST, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_Valid_Test, "{E8507423-4A1C-4f4f-B82C-B358FF18EDFD}"},   	
	
	{ "", "  KSPROPERTY_AUDIO_MUX_SOURCE",			0, 0, 0, 0, NULL, "{49E25442-4C0A-4ba4-B523-FF870A79EFCB}"},
	{ "100.7.1", "   Invalid Node ID - ULONG_MAX",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_MUX_SOURCE, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_NodeID_ULONGMAX, "{A995EB26-E702-4951-877F-DC14426BFE5E}"},
	{ "100.7.2", "   Invalid Node ID - 0x80000001",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_MUX_SOURCE, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_NodeID_0x80000001, "{AD16A56F-1480-47b0-8EE5-2A885217B693}"},
	{ "100.7.3", "   NULL IN/OUT Buffer",					0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_MUX_SOURCE, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_NULL_Buffer, "{F8B19CF8-1859-4c3f-9CA3-02C16C8CE29B}"},
	{ "100.7.4", "   Small IN/OUT Buffer",					0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_MUX_SOURCE, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_Small_Buffer, "{6419295A-5F99-427a-82B8-8EBF23197AE6}"},
	{ "100.7.5", "   Out buffer Large",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_MUX_SOURCE, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_Large_Buffer, "{E2B90D84-94B9-41fb-84E8-EA5F9F03C0B4}"},	
    { "100.7.6", "   valid test data",                                       0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_MUX_SOURCE, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_Valid_Test, "{B817B4F5-34DE-4e0c-B52C-EC321448792A}"},   
    { "100.7.7", "   Setting mux source to to Invalid value - DEADBEEF",         0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_MUX_SOURCE, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_SETINVALIDVALUE, "{21C461BE-6CD5-4c2e-B323-151C6390B9E0}"},          
    { "100.7.8", "   Test for Basic support",                                 0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_MUX_SOURCE, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_Basic_Support, "{3FEC8345-F421-4151-893B-F06BC0EBC378}"},

    { "", "  KSPROPERTY_AUDIO_QUALITY",				0, 0, 0, 0, NULL, "{8FADA295-EF05-4755-A38D-7DBBDD27233B}"},
	{ "100.8.1", "   Invalid Node ID - ULONG_MAX",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_QUALITY, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_NodeID_ULONGMAX, "{F5BB11F1-09E4-42b0-83A3-545319387664}"},
	{ "100.8.2", "   Invalid Node ID - 0x80000001",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_QUALITY, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_NodeID_0x80000001, "{8D4CD3C2-62AA-4a60-B767-3454B34DC84B}"},
	{ "100.8.3", "   NULL IN/OUT Buffer",					0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_QUALITY, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_NULL_Buffer, "{3B22FD0C-E991-4cd5-90A1-B027146BC711}"},
	{ "100.8.4", "   Small IN/OUT Buffer",					0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_QUALITY, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_Small_Buffer, "{80668ADC-D0B9-448c-848F-669A13300665}"},
	{ "100.8.5", "   Out buffer Large",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_QUALITY, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_Large_Buffer, "{6DCCA099-22EF-4352-90BD-976784AC0600}"},	
    { "100.8.6", "   valid test data",                                       0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_QUALITY, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_Valid_Test, "{F80C5238-0675-44d6-B4A8-69E82F253E5F}"},   
       
    { "", "  KSPROPERTY_AUDIO_REVERB_LEVEL",			0, 0, 0, 0, NULL, "{72246B71-CCA2-4ab5-B1DE-958233E3FA61}"},
    { "100.9.1", "   Invalid Node ID - ULONG_MAX",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_REVERB_LEVEL, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_NodeID_ULONGMAX, "{1B20F74E-AC5D-4d15-8E51-FE15D74944E5}"},
    { "100.9.2", "   Invalid Node ID - 0x80000001",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_REVERB_LEVEL, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_NodeID_0x80000001, "{D9475056-E844-4793-AF89-561E2C7D7D89}"},
    { "100.9.3", "   NULL IN/OUT Buffer",					0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_REVERB_LEVEL, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_NULL_Buffer, "{5859D4D9-4056-4286-BAA9-69D66246F476}"},	
    { "100.9.4", "   Small IN/OUT Buffer",					0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_REVERB_LEVEL, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_Small_Buffer, "{0B52DF1F-94D8-4125-A692-EF5CB7B807B2}"},	
    { "100.9.5", "   Out buffer Large",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_REVERB_LEVEL, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_Large_Buffer, "{D044EDB9-2042-404d-9A38-B658901A0C8E}"},	
    { "100.9.6", "   valid test data",                                       0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_REVERB_LEVEL, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_Valid_Test, "{D79CA75F-366B-4f46-8C1D-9636E7909ECF}"},   
    { "100.9.7", "   Test for Basic support",                                 0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_REVERB_LEVEL, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_Basic_Support, "{39C16F2F-F967-4f2c-97CC-814D2195F735}"},    

    { "", "  KSPROPERTY_AUDIO_SAMPLING_RATE",			0, 0, 0, 0, NULL, "{6DD0EDA8-1CB8-4bd4-A4E1-B12FBFC537CB}"},
    { "100.10.1", "   Invalid Node ID - ULONG_MAX",		0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_SAMPLING_RATE, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_NodeID_ULONGMAX, "{C164A54B-7221-41fc-AB1B-61EF376E5553}"},
    { "100.10.2", "   Invalid Node ID - 0x80000001",		0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_SAMPLING_RATE, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_NodeID_0x80000001, "{400B23EF-8745-4d8c-A9C9-0A871195B8E7}"},
    { "100.10.3", "   NULL IN/OUT Buffer",					0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_SAMPLING_RATE, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_NULL_Buffer, "{EA18146B-D290-4278-AD17-8E310BA76186}"},
    { "100.10.4", "   Small IN/OUT Buffer",				0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_SAMPLING_RATE, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_Small_Buffer, "{B3C9ACCD-C28A-4ebc-93E7-73C314D5CDD8}"},
    { "100.10.5", "   Out buffer Large",					0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_SAMPLING_RATE, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_Large_Buffer, "{C60EE8F0-C78F-4bfa-B68A-2F21F5BF520B}"},	
    { "100.10.6", "   valid test data",                                      0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_SAMPLING_RATE, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_Valid_Test, "{23D25BE8-37BC-4af4-A563-5C12267D154B}"},   
    { "100.10.7", "   setting sampling rate to to Invalid value - DEADBEEF",     0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_SAMPLING_RATE, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_SETINVALIDVALUE, "{9D274E36-0992-462e-8722-C1D7E6F5813D}"},   

    { "", "  KSPROPERTY_AUDIO_STEREO_SPEAKER_GEOMETRY",	0, 0, 0, 0, NULL, "{40BFB6DE-11CD-4c01-B86C-13164090F925}"},
    { "100.11.1", "   Invalid Node ID - ULONG_MAX",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_STEREO_SPEAKER_GEOMETRY, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_NodeID_ULONGMAX, "{0D341BC4-4DC7-417c-B257-24093461C8A3}"},
    { "100.11.2", "   Invalid Node ID - 0x80000001",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_STEREO_SPEAKER_GEOMETRY, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_NodeID_0x80000001, "{A8C4B6CE-C2B4-4262-B09F-001E1EC6002C}"},
    { "100.11.3", "   NULL IN/OUT Buffer",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_STEREO_SPEAKER_GEOMETRY, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_NULL_Buffer, "{916CE253-91CF-4fe4-BD19-1AFC1EBC1990}"},
    { "100.11.4", "   Small IN/OUT Buffer",					0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_STEREO_SPEAKER_GEOMETRY, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_Small_Buffer, "{0C4B5588-60DA-477e-ACBC-9C24A23FFADB}"},
    { "100.11.5", "   Out buffer Large",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_STEREO_SPEAKER_GEOMETRY, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_Large_Buffer, "{A835AF8D-322E-4db5-A4AE-AA389DB9B0B0}"},	
    { "100.11.6", "   valid test data",                                             0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_STEREO_SPEAKER_GEOMETRY, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_Valid_Test, "{83DC41A8-0014-4ad2-A28B-B07A81FA7B28}"},   
    { "100.11.7", "   setting Speaker Geometry to Invalid value - DEADBEEF",            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_STEREO_SPEAKER_GEOMETRY, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_SETINVALIDVALUE, "{18A56C4E-B6B0-4df8-B88B-0F05AE4C2E41}"},   

    { "", "  KSPROPERTY_AUDIO_DYNAMIC_SAMPLING_RATE",	0, 0, 0, 0, NULL, "{737152CB-13D9-4856-BCCD-B3A6FAF4677B}"},
    { "100.12.1", "   Invalid Node ID - ULONG_MAX",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_DYNAMIC_SAMPLING_RATE, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_NodeID_ULONGMAX, "{ADD1A7C3-B5C6-415e-80DC-20A135F57121}"},
    { "100.12.2", "   Invalid Node ID - 0x80000001",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_DYNAMIC_SAMPLING_RATE, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_NodeID_0x80000001, "{65C2D0DC-A45A-4773-BD69-99ACDD74BD24}"},
    { "100.12.3", "   NULL IN/OUT Buffer",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_DYNAMIC_SAMPLING_RATE, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_NULL_Buffer, "{6472A619-E143-42b6-823F-71922C484EA9}"},
    { "100.12.4", "   Small IN/OUT Buffer",					0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_DYNAMIC_SAMPLING_RATE, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_Small_Buffer, "{5C71A807-9D7B-4ad7-AC10-1ABE860BA063}"},
    { "100.12.5", "   Out buffer Large",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_DYNAMIC_SAMPLING_RATE, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_Large_Buffer, "{24F652CE-430A-4857-8E83-02CAC9FA28CB}"},	
    { "100.12.6", "   valid test data",                                            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_DYNAMIC_SAMPLING_RATE, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_Valid_Test, "{E9842860-4877-4be1-B51A-E598DEE1E0E2}"},   

    { "", "  KSPROPERTY_AUDIO_SURROUND_ENCODE",		       0, 0, 0, 0, NULL, "{5597425E-F518-411a-B231-FA48E2DA08F3}"},
    { "100.13.1", "   Invalid Node ID - ULONG_MAX",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_SURROUND_ENCODE, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_NodeID_ULONGMAX, "{BE2B1130-31A6-46df-87F2-4ECB52EC225F}"},
    { "100.13.2", "   Invalid Node ID - 0x80000001",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_SURROUND_ENCODE, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_NodeID_0x80000001, "{830D4107-3B8F-42da-AA93-3358690237A8}"},
    { "100.13.3", "   NULL IN/OUT Buffer",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_SURROUND_ENCODE, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_NULL_Buffer, "{22177F32-895E-4a1b-BD1F-87303643429E}"},
    { "100.13.4", "   Small IN/OUT Buffer",					0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_SURROUND_ENCODE, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_Small_Buffer, "{15354493-C30E-4fdc-B8AB-0ECB6CF1A361}"},
    { "100.13.5", "   Out buffer Large",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_SURROUND_ENCODE, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_Large_Buffer, "{63774103-0AE8-4330-B81B-F760D1B354E0}"},	
    { "100.13.6", "   valid test data",                                             0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_SURROUND_ENCODE, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_Valid_Test, "{41EF24D5-0855-44cf-A8D6-2326C66FEBFE}"},   

    { "", "  KSPROPERTY_AUDIO_3D_INTERFACE",			       0, 0, 0, 0, NULL, "{1244FD11-C3A9-485c-85E3-22754D33168D}"},
    { "100.14.1", "   Invalid Node ID - ULONG_MAX",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_3D_INTERFACE, sizeof(GUID)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIO_3D_INTERFACE_1, "{47C6349E-B544-4a35-B24C-5F0C140F6B23}"},
    { "100.14.2", "   Invalid Node ID - 0x80000001",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_3D_INTERFACE, sizeof(GUID)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIO_3D_INTERFACE_2, "{5694458D-F49E-440c-8BDF-A317291EDDFA}"},
    { "100.14.3", "   NULL IN/OUT Buffer",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_3D_INTERFACE, sizeof(GUID)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIO_3D_INTERFACE_3, "{5B855657-32D7-4c6e-9AA5-323D98534D41}"},
    { "100.14.4", "   Small IN/OUT Buffer",					0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_3D_INTERFACE, sizeof(GUID)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIO_3D_INTERFACE_4, "{113278F2-6DC5-41b0-9D35-4AD9786EF1DF}"},
    { "100.14.5", "   Out buffer Large",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_3D_INTERFACE, sizeof(GUID)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIO_3D_INTERFACE_5, "{8762D88F-DB15-4f26-B0C9-2ECDC198222C}"},	
    { "100.14.6", "   valid test data",						       0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_3D_INTERFACE, sizeof(GUID)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIO_3D_INTERFACE, "{5320868E-DBA7-4bda-AF0B-252BEC43FF8E}"},	

    { "", "  KSPROPERTY_AUDIO_ALGORITHM_INSTANCE",	       0, 0, 0, 0, NULL, "{42A72B38-36DA-446a-8D46-27916C8DF82E}"},
    { "100.15.1", "   Invalid Node ID - ULONG_MAX",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_ALGORITHM_INSTANCE, sizeof(GUID)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIO_ALGORITHM_INSTANCE_1, "{F24250DE-188F-4da9-B2F7-3B838F7945B6}"},
    { "100.15.2", "   Invalid Node ID - 0x80000001",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_ALGORITHM_INSTANCE, sizeof(GUID)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIO_ALGORITHM_INSTANCE_2, "{74774631-1196-4449-BEDE-1C91F394ECE3}"},
    { "100.15.3", "   NULL IN/OUT Buffer",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_ALGORITHM_INSTANCE, sizeof(GUID)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIO_ALGORITHM_INSTANCE_3, "{A80C4B4C-3049-481c-B1E2-DC528AC16F4E}"},
    { "100.15.4", "   Small IN/OUT Buffer",					0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_ALGORITHM_INSTANCE, sizeof(GUID)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIO_ALGORITHM_INSTANCE_4, "{8C87A8B4-E4FB-490c-B47A-F12FC06A6A64}"},	
    { "100.15.5", "   Out buffer Large",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_ALGORITHM_INSTANCE, sizeof(GUID)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIO_ALGORITHM_INSTANCE_5, "{37C30526-CA14-4104-8383-E654F874EEBF}"},	
    { "100.15.6", "   valid test data",						       0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_ALGORITHM_INSTANCE, sizeof(GUID)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIO_ALGORITHM_INSTANCE, "{22258091-184A-46de-85CC-121EF88C1C30}"},	

    { "", "  KSPROPERTY_AUDIO_CHANNEL_CONFIG",		       0, 0, 0, 0, NULL, "{6924C9E3-8AEF-4689-85F9-86B0A47774BA}"},
    { "100.16.1", "   Invalid Node ID - ULONG_MAX",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_CHANNEL_CONFIG, sizeof(KSAUDIO_CHANNEL_CONFIG)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIO_CHANNEL_CONFIG_1, "{599A8DF2-4715-4f22-9CD1-260BA88CFE9A}"},
    { "100.16.2", "   Invalid Node ID - 0x80000001",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_CHANNEL_CONFIG, sizeof(KSAUDIO_CHANNEL_CONFIG)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIO_CHANNEL_CONFIG_2, "{3FE71893-88AD-4ce2-B8BF-D4043F7A6B79}"},
    { "100.16.3", "   NULL IN/OUT Buffer",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_CHANNEL_CONFIG, sizeof(KSAUDIO_CHANNEL_CONFIG)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIO_CHANNEL_CONFIG_3, "{9582438D-055F-4867-B8AB-E0D1F54ED868}"},
    { "100.16.4", "   Small IN/OUT Buffer",					0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_CHANNEL_CONFIG, sizeof(KSAUDIO_CHANNEL_CONFIG)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIO_CHANNEL_CONFIG_4, "{7BEF44D8-41D5-4edc-AEE0-CFE37C243BD6}"},
    { "100.16.5", "   Out buffer Large",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_CHANNEL_CONFIG, sizeof(KSAUDIO_CHANNEL_CONFIG)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIO_CHANNEL_CONFIG_5, "{8EFC6E96-8FB4-419e-9B49-0ED9CB8B6935}"},	
    { "100.16.6", "   Invalid Channel Config",                                0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_CHANNEL_CONFIG, sizeof(KSAUDIO_CHANNEL_CONFIG)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIO_CHANNEL_CONFIG_6, "{E36DF4E8-5E0F-4976-940A-88BA2657A207}"},
    { "100.16.7", "   valid test data",						       0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_CHANNEL_CONFIG, sizeof(KSAUDIO_CHANNEL_CONFIG)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIO_CHANNEL_CONFIG, "{A56C10A0-70AF-4c50-BD98-2E7EBE3E4314}"},	

    { "", "  KSPROPERTY_AUDIO_BASS",				    0, 0, 0, 0, NULL, "{4A9DB271-B3A7-40bd-84D8-D6660892F7A1}"},
    { "100.17.1", "   Invalid Node ID - ULONG_MAX",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_BASS, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_NodeID_ULONGMAX, "{00CE9F83-7D48-4081-B05F-DD9D4DDDCAAE}"},
    { "100.17.2", "   Invalid Node ID - 0x80000001",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_BASS, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_NodeID_0x80000001, "{7E240AFB-6ADA-46ba-9E50-3AA2D442DAEB}"},
    { "100.17.3", "   Invalid Channel ID - 0xFFFFFFFE",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_BASS, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_ChannelID_0xFFFFFFFE, "{685A39DD-F1A6-4ccd-B2C7-38A69CE0B112}"},
    { "100.17.4", "   Invalid Channel ID - 0x80000001",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_BASS, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_ChannelID_0x80000001, "{7E08099C-E059-42d8-8DEF-AB7C93454F61}"},
    { "100.17.5", "   NULL IN/OUT Buffer",                                    0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_BASS, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_NULL_Buffer, "{E50DA2C2-7C4E-4e15-9151-EDD4A980BA66}"},
    { "100.17.6", "   Small IN/OUT Buffer",                                   0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_BASS, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_Small_Buffer, "{38A62637-C155-479a-846F-0023EF3CF157}"},
    { "100.17.7", "   Out buffer Large",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_BASS, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_Large_Buffer, "{CCD2EFF8-0F7F-4837-B8B7-4929A23578B9}"},
    { "100.17.8", "   valid test data",                                            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_BASS, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_Valid_Test, "{187C5FBD-504D-4ed3-8EB7-0ED04B41733E}"},
    { "100.17.9", "   Test for Basic support",                                 0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_BASS, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_Basic_Support, "{6B1A34FC-C069-49bf-956F-E4FBF1987738}"},    

    { "", "  KSPROPERTY_AUDIO_MID",				              0, 0, 0, 0, NULL, "{E5DD8B76-0610-4abc-B490-FA08420C8BD8}"},
    { "100.18.1", "   Invalid Node ID - ULONG_MAX",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_MID, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_NodeID_ULONGMAX, "{C10ECB67-6DC0-4a40-AA0C-B17F38E1D496}"},
    { "100.18.2", "   Invalid Node ID - 0x80000001",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_MID, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_NodeID_0x80000001, "{4A97B95E-DDBD-4ed5-8907-48618A81FD07}"},
    { "100.18.3", "   Invalid Channel ID - 0xFFFFFFFE",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_MID, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_ChannelID_0xFFFFFFFE, "{DB89E340-1B37-4523-B765-35BA9698559F}"},
    { "100.18.4", "   Invalid Channel ID - 0x80000001",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_MID, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_ChannelID_0x80000001, "{0D2F816A-4520-427b-906B-F37A5AD0B26D}"},
    { "100.18.5", "   NULL IN/OUT Buffer",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_MID, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_NULL_Buffer, "{75C49AB5-8150-44e1-8313-8681986D8993}"},
    { "100.18.6", "   Small IN/OUT Buffer",                                   0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_MID, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_Small_Buffer, "{173BE0F0-F523-4f84-9A85-8B5B7D07374F}"},
    { "100.18.7", "   Out buffer Large",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_MID, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_Large_Buffer, "{9535AE53-22A6-4d19-8F6F-F915E35F1CAD}"},
    { "100.18.8", "   valid test data",                                            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_MID, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_Valid_Test, "{8A5F623E-B90B-4eb3-9ABD-E6572F5CA41D}"},
    { "100.18.9", "   Test for Basic support",                                 0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_MID, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_Basic_Support, "{AA6C9B3A-493A-47bc-89CC-8DC9BE4CFC3F}"},

    { "", "  KSPROPERTY_AUDIO_PEAKMETER",				       0, 0, 0, 0, NULL, "{A990B431-0033-408c-8A2F-8110AA9BF790}"},
    { "100.19.1", "   Invalid Node ID - ULONG_MAX",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_PEAKMETER, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_NodeID_ULONGMAX, "{97978CFB-7B2B-4efe-BEEC-A233AFE45EA5}"},
    { "100.19.2", "   Invalid Node ID - 0x80000001",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_PEAKMETER, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_NodeID_0x80000001, "{EEE6F065-6351-4827-BE43-7671A802E969}"},
    { "100.19.3", "   Invalid Channel ID - 0xFFFFFFFE",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_PEAKMETER, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_ChannelID_0xFFFFFFFE, "{20288B10-6284-4440-9053-3AC4249A5276}"},
    { "100.19.4", "   Invalid Channel ID - 0x80000001",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_PEAKMETER, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_ChannelID_0x80000001, "{0B37080D-967B-4d71-BC09-A66847D011FA}"},
    { "100.19.5", "   NULL IN/OUT Buffer",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_PEAKMETER, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_NULL_Buffer, "{624D9DC6-D051-44da-B106-C47A757E4FAC}"},
    { "100.19.6", "   Small IN/OUT Buffer",                                   0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_PEAKMETER, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_Small_Buffer, "{AAD9CF8B-E97E-4e9d-BB8B-702CD50D713B}"},
    { "100.19.7", "   Out buffer Large",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_PEAKMETER, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_Large_Buffer, "{7D3F4F43-6D56-4356-8797-507B2BD785CE}"},
    { "100.19.8", "   valid test data",                                            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_PEAKMETER, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_Valid_Test, "{B3E01053-460D-4be8-9031-CBA90AF52B87}"},
    { "100.19.9", "   Test for Basic support",                                 0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_PEAKMETER, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_Basic_Support, "{03174B72-9675-47c5-A93A-70A63E6BEA97}"},
    
    { "", "  KSPROPERTY_AUDIO_TREBLE",				              0, 0, 0, 0, NULL, "{8CFC9326-3087-4f4d-8422-C701E1CA0511}"},
    { "100.20.1", "   Invalid Node ID - ULONG_MAX",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_TREBLE, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_NodeID_ULONGMAX, "{BC2E941E-5855-47f1-BCC7-8384EA3DEC76}"},
    { "100.20.2", "   Invalid Node ID - 0x80000001",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_TREBLE, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_NodeID_0x80000001, "{838DD8FA-7323-486c-A031-55AFC6EF78CE}"},
    { "100.20.3", "   Invalid Channel ID - 0xFFFFFFFE",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_TREBLE, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_ChannelID_0xFFFFFFFE, "{FBE5A50C-511C-4593-B514-176D81E13C02}"},
    { "100.20.4", "   Invalid Channel ID - 0x80000001",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_TREBLE, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_ChannelID_0x80000001, "{EE8A7183-A90B-4d6a-BDAF-BF3893BCF024}"},
    { "100.20.5", "   NULL IN/OUT Buffer",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_TREBLE, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_NULL_Buffer, "{9E58FCEF-3E7F-428b-A7F0-E34EDDB1B3D3}"},
    { "100.20.6", "   Small IN/OUT Buffer",                                   0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_TREBLE, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_Small_Buffer, "{9954E81E-58E8-45cb-BA79-C9235A1A4809}"},
    { "100.20.7", "   Out buffer Large",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_TREBLE, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_Large_Buffer, "{1C3863A3-A38A-4520-869E-A931D538E6BC}"},
    { "100.20.8", "   valid test data",                                            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_TREBLE, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_Valid_Test, "{4DB5D16F-A839-4478-B730-FF2F07F0A88A}"},
    { "100.20.9", "   Test for Basic support",                                 0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_TREBLE, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_Basic_Support, "{6F8CBFE3-D6EE-42c9-8765-9C8C0F671A15}"},
    
    { "", "  KSPROPERTY_AUDIO_VOLUMELEVEL",			0, 0, 0, 0, NULL, "{4469B699-CB5E-40bb-8FF4-EF24026FC4D9}"},
    { "100.21.1", "   Invalid Node ID - ULONG_MAX",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_VOLUMELEVEL, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_NodeID_ULONGMAX, "{044DF31F-3194-4763-9359-3AE43D88271F}"},
    { "100.21.2", "   Invalid Node ID - 0x80000001",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_VOLUMELEVEL, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_NodeID_0x80000001, "{27BB6D0E-6601-44e8-A4E4-5E3D910BE614}"},
    { "100.21.3", "   Invalid Channel ID - 0xFFFFFFFE",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_VOLUMELEVEL, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_ChannelID_0xFFFFFFFE, "{4BEB2159-2A35-497e-B858-33740393A9DF}"},
    { "100.21.4", "   Invalid Channel ID - 0x80000001",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_VOLUMELEVEL, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_ChannelID_0x80000001, "{89C8AC0C-6B2F-4b65-B5E1-D5413FD81CE9}"},
    { "100.21.5", "   NULL IN/OUT Buffer",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_VOLUMELEVEL, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_NULL_Buffer, "{DC6111B1-E257-4b04-9789-E1CDAF85F230}"},
    { "100.21.6", "   Small IN/OUT Buffer",                                   0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_VOLUMELEVEL, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_Small_Buffer, "{D7BE5B69-4AD7-40c0-B495-0238C8AAD026}"},
    { "100.21.7", "   Out buffer Large",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_VOLUMELEVEL, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_Large_Buffer, "{1A7C3717-213D-49f9-8329-C42CFBDD9CC8}"},
    { "100.21.8", "   valid test data",                                            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_VOLUMELEVEL, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_Valid_Test, "{F4D3CD56-6DD3-4bf9-B7CA-D16368CCE61F}"},
    { "100.21.9", "   Test for Basic support",                                 0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_VOLUMELEVEL, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_Basic_Support, "{C85C6FF8-13B9-45d5-9D05-BEC07490BFF5}"},
    
    { "", "  KSPROPERTY_AUDIO_AGC",				    0, 0, 0, 0, NULL, "{DE7E8DA1-D0FF-4ecc-A569-AAFD957186B7}"},
    { "100.22.1", "   Invalid Node ID - ULONG_MAX",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_AGC, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_NodeID_ULONGMAX, "{5F71F59E-314B-45a5-AE18-553E6AC6F996}"},
    { "100.22.2", "   Invalid Node ID - 0x80000001",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_AGC, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_NodeID_0x80000001, "{53962891-154F-4c07-A23A-0246FD0AE828}"},
    { "100.22.3", "   Invalid Channel ID - 0xFFFFFFFE",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_AGC, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_ChannelID_0xFFFFFFFE, "{4D2FE53E-BDF4-47ba-B7FE-B05D7B5EE70D}"},
    { "100.22.4", "   Invalid Channel ID - 0x80000001",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_AGC, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_ChannelID_0x80000001, "{3F15A3E2-B8C2-4ecb-9531-B125E1750E4E}"},
    { "100.22.5", "   NULL IN/OUT Buffer",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_AGC, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_NULL_Buffer, "{09EEF5DA-F78B-4a8a-8E77-A499B5265135}"},
    { "100.22.6", "   Small IN/OUT Buffer",                                   0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_AGC, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_Small_Buffer, "{E7DD52BD-27E3-4a03-BD88-8E8053612635}"},
    { "100.22.7", "   Out buffer Large",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_AGC, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_Large_Buffer, "{4C0B5B2D-2D64-4154-B2FF-4C1838D7EC90}"},
    { "100.22.8", "   valid test data",                                            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_AGC, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_Valid_Test, "{DB8F7AC1-1629-44c8-8A7D-726AA15DC079}"},
    { "100.22.9", "   Test for Basic support",                                 0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_AGC, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_Basic_Support, "{8B0C3121-87DA-4d82-83BB-0C5353C58683}"},
    
    { "", "  KSPROPERTY_AUDIO_BASS_BOOST",			0, 0, 0, 0, NULL, "{D9483D96-97C7-4870-BF8D-334F9D27BDC7}"},
    { "100.23.1", "   Invalid Node ID - ULONG_MAX",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_BASS_BOOST, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_NodeID_ULONGMAX, "{C84A394A-2DEE-4b01-AB6E-22CB88BA42A8}"},
    { "100.23.2", "   Invalid Node ID - 0x80000001",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_BASS_BOOST, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_NodeID_0x80000001, "{DD4F9DCD-05ED-471f-B750-91A0A4772D91}"},
    { "100.23.3", "   Invalid Channel ID - 0xFFFFFFFE",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_BASS_BOOST, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_ChannelID_0xFFFFFFFE, "{1DF244CB-8EAA-4f33-AE83-B1D8F3A22532}"},
    { "100.23.4", "   Invalid Channel ID - 0x80000001",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_BASS_BOOST, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_ChannelID_0x80000001, "{02E3FA64-D7B7-43a6-BCE2-1C9C5CB0888E}"},
    { "100.23.5", "   NULL IN/OUT Buffer",                                    0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_BASS_BOOST, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_NULL_Buffer, "{30B0C779-E1E0-45ac-AB09-E69C304F1433}"},
    { "100.23.6", "   Small IN/OUT Buffer",                                   0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_BASS_BOOST, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_Small_Buffer, "{6B2D9D51-F230-4dde-872C-B8A72066B747}"},
    { "100.23.7", "   Out buffer Large",                                         0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_BASS_BOOST, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_Large_Buffer, "{04BD52C6-3B9F-4499-A6CF-5CD86B1F854C}"},
    { "100.23.8", "   valid test data",                                            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_BASS_BOOST, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_Valid_Test, "{3F2D87CE-6450-4f87-8EA9-4748DC565C1F}"},	
    { "100.23.9", "   Test for Basic support",                                 0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_BASS_BOOST, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_Basic_Support, "{461F5F4C-D42B-4b91-83CD-F260B1C2FC1C}"},
    
    { "", "  KSPROPERTY_AUDIO_LOUDNESS",				0, 0, 0, 0, NULL, "{6B2EE1C5-6264-4b9e-88CE-E2E6D0C3675B}"},
    { "100.24.1", "   Invalid Node ID - ULONG_MAX",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_LOUDNESS, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_NodeID_ULONGMAX, "{F81BA94A-207B-466a-8777-8316E086828B}"},
    { "100.24.2", "   Invalid Node ID - 0x80000001",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_LOUDNESS, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_NodeID_0x80000001, "{BDC73CE2-B20D-4d9d-A2FE-F2264ABFAF79}"},
    { "100.24.3", "   Invalid Channel ID - 0xFFFFFFFE",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_LOUDNESS, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_ChannelID_0xFFFFFFFE, "{E07232C8-886A-4cc6-A538-12CC23343AD2}"},
    { "100.24.4", "   Invalid Channel ID - 0x80000001",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_LOUDNESS, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_ChannelID_0x80000001, "{0D7DA0EA-291A-4b90-9340-7D2D4936F75B}"},
    { "100.24.5", "   NULL IN/OUT Buffer",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_LOUDNESS, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_NULL_Buffer, "{33677C79-0998-4f61-979E-D2C3A31D230F}"},
    { "100.24.6", "   Small IN/OUT Buffer",                                   0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_LOUDNESS, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_Small_Buffer, "{6C85E181-C0CF-426c-9D83-C317CFC14CE9}"},
    { "100.24.7", "   Out buffer Large",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_LOUDNESS, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_Large_Buffer, "{B6BAC5F0-5EEE-4c11-993B-524060BBBC43}"},
    { "100.24.8", "   valid test data",                                            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_LOUDNESS, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_Valid_Test, "{D69035EF-10D5-40b2-9254-E7DCD4BD29B0}"},
    { "100.24.9", "   Test for Basic support",                                 0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_LOUDNESS, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_Basic_Support, "{2F16C748-1A07-4a54-89D9-367144963D16}"},
    
    { "", "  KSPROPERTY_AUDIO_MUTE",				0, 0, 0, 0, NULL, "{F2F08C62-23B2-4961-8303-DC437BA15DBF}"},
    { "100.25.1", "   Invalid Node ID - ULONG_MAX",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_MUTE, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_NodeID_ULONGMAX, "{44E39107-4538-4db8-B9C1-1EBF2FEDF81E}"},
    { "100.25.2", "   Invalid Node ID - 0x80000001",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_MUTE, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_NodeID_0x80000001, "{93DD7FB5-F5DE-49db-8E94-C9128C1BBE02}"},
    { "100.25.3", "   Invalid Channel ID - 0xFFFFFFFE",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_MUTE, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_ChannelID_0xFFFFFFFE, "{EE9D94C7-7CE7-4a73-B2DD-16616409E193}"},
    { "100.25.4", "   Invalid Channel ID - 0x80000001",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_MUTE, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_ChannelID_0x80000001, "{A67BB2D8-226D-4488-9CE8-FBAEFF1E55C3}"},
    { "100.25.5", "   NULL IN/OUT Buffer",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_MUTE, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_NULL_Buffer, "{AF6698DC-E50A-448f-A88F-43E5B40FE63E}"},
    { "100.25.6", "   Small IN/OUT Buffer",                                   0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_MUTE, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_Small_Buffer, "{0BD9A469-FC58-4c0c-B191-48A4165CBCCD}"},
    { "100.25.7", "   Out buffer Large",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_MUTE, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_Large_Buffer, "{7D41C95C-551C-434f-AEAE-186957CE39F4}"},
    { "100.25.8", "   valid test data",                                            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_MUTE, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_Valid_Test, "{A6650402-60B7-47ce-B17A-63390016BC84}"},	
    { "100.25.9", "   Test for Basic support",                                 0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_MUTE, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_Basic_Support, "{B5BB6EAD-1A77-42dc-A29C-86A95E236572}"},
    
    { "", "  KSPROPERTY_AUDIO_DELAY",				0, 0, 0, 0, NULL, "{4B3FD21B-AC9C-4d34-96D9-6D5C9CE1DEB6}"},
    { "100.26.1", "   Invalid Node ID - ULONG_MAX",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_DELAY, sizeof(KSTIME)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIO_DELAY_1, "{5CF445CC-AC1A-4c6c-928A-A62E5CEFB44F}"},
    { "100.26.2", "   Invalid Node ID - 0x80000001",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_DELAY, sizeof(KSTIME)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIO_DELAY_2, "{A16A72E6-25E9-40a3-9E8C-716D3BCEE317}"},
    { "100.26.3", "   Invalid Channel ID - 0xFFFFFFFE",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_DELAY, sizeof(KSTIME)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIO_DELAY_3, "{95E36F80-4848-4de9-A414-5E076B2EB2F8}"},
    { "100.26.4", "   Invalid Channel ID - 0x80000001",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_DELAY, sizeof(KSTIME)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIO_DELAY_4, "{7A0E3D57-2BC9-4692-8D7A-9B85CF52D57C}"},
    { "100.26.5", "   NULL IN/OUT Buffer",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_DELAY, sizeof(KSTIME)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIO_DELAY_5, "{23342700-C0F6-4dd9-919F-ECB2E650AA4C}"},
    { "100.26.6", "   Small IN/OUT Buffer",                                   0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_DELAY, sizeof(KSTIME)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIO_DELAY_6, "{843E1EF0-8165-4aa3-8E7F-D86159FE9F2F}"},
    { "100.26.7", "   Out buffer Large",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_DELAY, sizeof(KSTIME)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIO_DELAY_7, "{178FF288-74A8-4a00-A8DF-BA2A17D8861A}"},
    { "100.26.8", "   Negative Time Value",                                   0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_DELAY, sizeof(KSTIME)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIO_DELAY_8, "{2D35CCF5-34CA-417e-9BD4-4B8E98AEBA68}"},
    { "100.26.9", "   Zero Numerator",                                          0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_DELAY, sizeof(KSTIME)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIO_DELAY_9, "{2B652B82-DC58-4744-9472-3E1980488E4E}"},
    { "100.26.10", "   Zero Denominator",                                     0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_DELAY, sizeof(KSTIME)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIO_DELAY_10, "{2C77758D-A2EB-4fde-85A9-A8CAF3F1F2B2}"},
    { "100.26.11", "   valid test data",                                           0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_DELAY, sizeof(KSTIME)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIO_DELAY, "{EC01D791-134D-41d0-9BAA-F14070EA4877}"},

    { "", "  KSPROPERTY_AUDIO_LATENCY",				0, 0, 0, 0, NULL, "{F5047800-FFC7-4628-829D-E72D021C0652}"},
    { "100.27.1", "   NULL IN/OUT Buffer",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_LATENCY, sizeof(KSTIME)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIO_LATENCY_1, "{ACFDA42A-77F9-4693-B955-AA33BE30D277}"},
    { "100.27.2", "   Small IN/OUT Buffer",                                   0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_LATENCY, sizeof(KSTIME)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIO_LATENCY_2, "{6B7CB9AF-8F3A-427e-9FFA-B2675A83E140}"},
    { "100.27.3", "   Out buffer Large",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_LATENCY, sizeof(KSTIME)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIO_LATENCY_3, "{8A6AFFC7-5855-482a-99B8-D4010D163240}"},
    { "100.27.4", "   Valid test",                                                    0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_LATENCY, sizeof(KSTIME)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIO_LATENCY, "{C0D38A8E-0107-4b08-9D19-C06424301B15}"},

    { "", "  KSPROPERTY_AUDIO_DYNAMIC_RANGE",		0, 0, 0, 0, NULL, "{EBB45F92-9E8D-4d3e-9477-705EE21753FE}"},
    { "100.28.1", "   Invalid Node ID - ULONG_MAX",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_DYNAMIC_RANGE, sizeof(KSAUDIO_DYNAMIC_RANGE)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIO_DYNAMIC_RANGE_1, "{F328EEC6-970F-4a66-8656-1C67044AFDDE}"},
    { "100.28.2", "   Invalid Node ID - 0x80000001",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_DYNAMIC_RANGE, sizeof(KSAUDIO_DYNAMIC_RANGE)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIO_DYNAMIC_RANGE_2, "{AE233D1E-3FBC-4f02-9BBB-3D0CEDDE97F5}"},
    { "100.28.3", "   NULL IN/OUT Buffer",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_DYNAMIC_RANGE, sizeof(KSAUDIO_DYNAMIC_RANGE)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIO_DYNAMIC_RANGE_3, "{3CA94D1F-A7BC-4599-858B-EDC82FD820D0}"},
    { "100.28.4", "   Small IN/OUT Buffer",					0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_DYNAMIC_RANGE, sizeof(KSAUDIO_DYNAMIC_RANGE)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIO_DYNAMIC_RANGE_4, "{96C4BD26-2D56-4c4f-ADC1-E584D56BC0C5}"},		
    { "100.28.5", "   Out buffer Large",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_DYNAMIC_RANGE, sizeof(KSAUDIO_DYNAMIC_RANGE)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIO_DYNAMIC_RANGE_5, "{BEB6BFA3-E9EA-44df-BFF8-D51910EF3080}"},	
    { "100.28.6", "   Valid Test",                                                   0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_DYNAMIC_RANGE, sizeof(KSAUDIO_DYNAMIC_RANGE)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIO_DYNAMIC_RANGE, "{45D513EE-C121-4942-BF31-0BEA8BAD71CB}"},  

    { "", "  KSPROPERTY_AUDIO_EQ_BANDS",		                    0, 0, 0, 0, NULL, "{5b4d5aa1-b294-48b9-a37d-5a37b71db28b}"},
    { "100.29.1", "   Invalid Node ID - ULONG_MAX",		      0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_EQ_BANDS, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIO_EQ_BANDS_1, "{fdf84d5e-f4e4-4f16-a72d-dbf25ee9e9bd}"},
    { "100.29.2", "   Invalid Node ID - 0x80000001",                    0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_EQ_BANDS, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIO_EQ_BANDS_2, "{6e795520-526b-40b9-8cb2-1a25b98ec233}"},
    { "100.29.3", "   Invalid Channel Number - 0xFFFFFFFE",          0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_EQ_BANDS, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIO_EQ_BANDS_3, "{e79f6100-c715-432c-b12b-7f68c994332c}"},
    { "100.29.4", "   Invalid Channel Number - 0x80000001",        0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_EQ_BANDS, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIO_EQ_BANDS_4, "{6e6e03c0-c85b-42a9-9746-8eadb131ba26}"},
    { "100.29.5", "   Out buffer NULL",                                         0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_EQ_BANDS, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIO_EQ_BANDS_5, "{b821f657-2d2d-4c41-aae2-aeced1caff1d}"},
    { "100.29.6", "   Out buffer Small",                                        0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_EQ_BANDS, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIO_EQ_BANDS_6, "{148a3a50-b1b7-44d2-8855-d963361a523e}"},
    { "100.29.7", "   Out buffer Large",                                        0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_EQ_BANDS, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIO_EQ_BANDS_7, "{46FBA26D-F104-4c40-A725-33DB30FAF92A}"},
    { "100.29.8", "   Valid Test",                                                  0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_EQ_BANDS, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIO_EQ_BANDS, "{243D6CB0-DD18-48d4-BD84-83576D367B49}"},

    { "", "  KSPROPERTY_AUDIO_EQ_LEVEL",                            0, 0, 0, 0, NULL, "{7e08af24-0e83-4533-b212-7e816cb046ad}"},
    { "100.30.1", "   Invalid Node ID - ULONG_MAX",                 0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_EQ_LEVEL, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIO_EQ_LEVEL_1, "{3c2bcaa3-eefa-45ea-9b09-20502d7fda2e}"},
    { "100.30.2", "   Invalid Node ID - 0x80000001",                  0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_EQ_LEVEL, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIO_EQ_LEVEL_2, "{5d95bb54-da25-4b95-8bb0-09e85ded8e45}"},
    { "100.30.3", "   Invalid Channel Number - 0xFFFFFFFE",       0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_EQ_LEVEL, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIO_EQ_LEVEL_3, "{a6ea9207-637e-4c9c-83df-92dbcd116508}"},
    { "100.30.4", "   Invalid Channel Number - 0x80000001",      0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_EQ_LEVEL, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIO_EQ_LEVEL_4, "{521bd184-0835-445c-96b6-97c625f684c5}"},
    { "100.30.5", "   NULL IN/OUT Buffer",                                 0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_EQ_LEVEL, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIO_EQ_LEVEL_5, "{61826a63-ae13-4a45-9a59-2cb15a3f0b0c}"},
    { "100.30.6", "   Small IN/OUT Buffer",                                0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_EQ_LEVEL, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIO_EQ_LEVEL_6, "{65d583ea-6776-46fd-9cca-a872751b18eb}"},
    { "100.30.7", "   Out buffer Large",                                      0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_EQ_LEVEL, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIO_EQ_LEVEL_7, "{7c8aa568-3eed-49c1-a44f-0ca6d26b2e7d}"},
    { "100.30.8", "   Valid Test",                                                0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_EQ_LEVEL, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIO_EQ_LEVEL, "{E2546E15-9DFE-4ef9-B90D-7D354CDE4813}"},

    { "", "  KSPROPERTY_AUDIO_FILTER_STATE",                0, 0, 0, 0, NULL, "{c01aba3e-b346-432e-837d-e28373440aa4}"},
    { "100.31.1", "   Out buffer NULL",                                 0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_FILTER_STATE, sizeof(GUID)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIO_FILTER_STATE_1, "{f00b4250-fb97-46f6-96f7-3688ff477ec1}"},
    { "100.31.2", "   Out buffer Small",                                0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_FILTER_STATE, sizeof(GUID)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIO_FILTER_STATE_2, "{5c410ce1-8989-490e-b9ca-3aeedf58c123}"},
    { "100.31.3", "   Out buffer Large",                                0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_FILTER_STATE, sizeof(GUID)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIO_FILTER_STATE_3, "{863324bd-fa81-4621-9745-7cb0fedde430}"},
    { "100.31.4", "   Valid Testing",                                     0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_FILTER_STATE, sizeof(GUID)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIO_FILTER_STATE, "{79422876-B67F-4a96-AEF0-E0FB826A1D70}"},

    { "", "  KSPROPERTY_AUDIO_MIX_LEVEL_TABLE",         0, 0, 0, 0, NULL, "{e9d27c8b-5687-4193-802a-1c876e6697eb}"},
    { "100.32.1", "   Invalid Node ID - ULONG_MAX",          0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_MIX_LEVEL_TABLE, sizeof(KSAUDIO_MIXLEVEL)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIO_MIX_LEVEL_TABLE_1, "{2a32b494-4014-4626-a967-e6dca1c892e6}"},
    { "100.32.2", "   Invalid Node ID - 0x80000001",           0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_MIX_LEVEL_TABLE, sizeof(KSAUDIO_MIXLEVEL)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIO_MIX_LEVEL_TABLE_2, "{967192a6-3e47-479e-b803-af386302ef60}"},
    { "100.32.3", "   NULL IN/OUT Buffer",                          0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_MIX_LEVEL_TABLE, sizeof(KSAUDIO_MIXLEVEL)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIO_MIX_LEVEL_TABLE_3, "{2a1ba6c9-229b-4f45-bd2d-087760a92112}"},
    { "100.32.4", "   Small IN/OUT Buffer",                         0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_MIX_LEVEL_TABLE, sizeof(KSAUDIO_MIXLEVEL)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIO_MIX_LEVEL_TABLE_4, "{2ec97c6b-ed9d-4c5b-ae41-3f40b73860b4}"},
    { "100.32.5", "   Out buffer Large",                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_MIX_LEVEL_TABLE, sizeof(KSAUDIO_MIXLEVEL)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIO_MIX_LEVEL_TABLE_5, "{0e1102dd-a105-476e-8e3e-a47831c90dcb}"},
    { "100.32.6", "   Valid Test",                                         0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_MIX_LEVEL_TABLE, sizeof(KSAUDIO_MIXLEVEL)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIO_MIX_LEVEL_TABLE, "{FFD1DAEF-C857-41d7-B5A7-E2E10BA1F1A9}"},
    { "100.32.9", "   Test for Basic support",                                 0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_MIX_LEVEL_TABLE, sizeof(KSAUDIO_MIXLEVEL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_Basic_Support, "{5C6774EC-67B5-4d60-A669-7F9B24D0181E}"},

    { "", "  KSPROPERTY_AUDIO_POSITION",                    0, 0, 0, 0, NULL, "{e4229548-afc7-4ea2-b5d2-0b434332dea9}"},
    { "100.33.1", "   NULL IN/OUT Buffer",                         0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_POSITION, sizeof(KSAUDIO_POSITION)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIO_POSITION_1, "{b51e9464-57b1-4c06-9785-5c83f7e35642}"},
    { "100.33.2", "   Small IN/OUT Buffer",                         0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_POSITION, sizeof(KSAUDIO_POSITION)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIO_POSITION_2, "{3c3d076c-6697-4fb1-b730-6195f053d2f2}"},
    { "100.33.3", "   Out buffer Large",                                0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_POSITION, sizeof(KSAUDIO_POSITION)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIO_POSITION_3, "{335b04fb-7919-408e-9222-5c5b0d7890c2}"},
    // following test case is removed as we are not doing correct here(not submitting buffer to pin before testing. Similiar test case will be added into KSPOSTST  
    //	{ "100.33.4", "   Write Offset < Play Offset",                  0, 0, 0,
    //    GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_POSITION, sizeof(KSAUDIO_POSITION)),
    //    (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIO_POSITION_4, "{2dc627c3-7086-4b8e-9820-fbfa30dc4597}"},

// preferred status ended in XP
#if (NTDDI_VERSION < NTDDI_VISTA)
    { "", "  KSPROPERTY_AUDIO_PREFERRED_STATUS",       0, 0, 0, 0, NULL, "{52c53bcd-8498-4d08-92ae-664ef56e6f53}"},
    { "100.34.1", "   Out buffer NULL",                                 0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_PREFERRED_STATUS, sizeof(KSAUDIO_PREFERRED_STATUS)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIO_PREFERRED_STATUS_1, "{63917dfd-a2cc-4cb3-8346-fd65c6a4ed7c}"},
    { "100.34.2", "   Out buffer Small",                                0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_PREFERRED_STATUS, sizeof(KSAUDIO_PREFERRED_STATUS)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIO_PREFERRED_STATUS_2, "{31748ef8-7c5d-49f4-824b-cf1f26ce6154}"},
    { "100.34.3", "   Out buffer Large",                                0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_PREFERRED_STATUS, sizeof(KSAUDIO_PREFERRED_STATUS)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIO_PREFERRED_STATUS_3, "{f8e42185-464a-46fe-8d0b-e23b4f16f741}"},
    { "100.34.4", "   Invalid Device Type - ULONG_MAX",     0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_PREFERRED_STATUS, sizeof(KSAUDIO_PREFERRED_STATUS)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIO_PREFERRED_STATUS_4, "{d0cef935-1d79-4399-bbf6-b543706cc7c1}"},
    { "100.34.5", "   Invalid Device Type - 0x80000001",      0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_PREFERRED_STATUS, sizeof(KSAUDIO_PREFERRED_STATUS)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIO_PREFERRED_STATUS_5, "{B1F4604F-E54B-4ccb-B277-33B49AC0FAAD}"},
#endif

    { "", "  KSPROPERTY_AUDIO_WIDE_MODE",                   0, 0, 0, 0, NULL, "{3D2F73CE-96EF-4b45-8357-76B58F97148E}"},
    { "100.35.1", "   Test for Basic support",              0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_WIDE_MODE, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_Basic_Support, "{EC5B471E-108F-47ca-833B-348E3DD8D4F9}"},

    { "", "  KSPROPERTY_AUDIO_WIDENESS",                    0, 0, 0, 0, NULL, "{4CDC1FD8-E882-46b5-93A6-1DE7E3A970B7}"},
    { "100.36.1", "   Test for Basic support",              0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_WIDENESS, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_Basic_Support, "{D9C62CFA-1600-4ef1-A1AE-DD78BB7E88D5}"},

#if (NTDDI_VERSION >= NTDDI_WINBLUE)

    { "", "  KSPROPERTY_AUDIO_WAVERT_CURRENT_WRITE_LASTBUFFER_POSITION",                    0, 0, 0, 0, NULL, "{1131889B-A142-48a4-B606-972084ED2491}"},
    { "100.37.1", "   Test for Basic support",                         0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_WAVERT_CURRENT_WRITE_LASTBUFFER_POSITION, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_Basic_Support, "{595B97A9-CA88-4d9b-9F16-89CF3B6C2322}"},
    { "100.37.2", "   NULL IN/OUT Buffer",                         0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_WAVERT_CURRENT_WRITE_LASTBUFFER_POSITION, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_NULL_Buffer, "{7F246D08-8C38-4402-BD66-D046698F29E6}"},
    { "100.37.3", "   Small IN/OUT Buffer",                         0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_WAVERT_CURRENT_WRITE_LASTBUFFER_POSITION, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_Small_Buffer, "{3DFF01A9-07EA-46cd-AF86-F98310C6DA34}"},
    { "100.37.4", "   Large IN/OUT Buffer",                         0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_WAVERT_CURRENT_WRITE_LASTBUFFER_POSITION, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_Large_Buffer, "{374C252E-9290-4037-BA63-82FE0EA0B048}"},
    { "100.37.5", "   Valid Test",                         0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_WAVERT_CURRENT_WRITE_LASTBUFFER_POSITION, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_Valid_Test, "{667B46A3-0923-4286-8327-666D588E374D}"},

#endif // #if (NTDDI_VERSION >= NTDDI_WINBLUE)


// sysaudio ended in XP
#if (NTDDI_VERSION < NTDDI_VISTA)

    // KSPROPSETID_Sysaudio
    { "",   " KSPROPSETID_Sysaudio",                                0, 0, 0, 0, NULL, "{A7452474-799F-4c8d-A552-B0B116C412CE}"},

    { "", "  KSPROPERTY_SYSAUDIO_DEVICE_FRIENDLY_NAME",     0, 0, 0, 0, NULL, "{1df031c6-a96e-47ad-8ec7-34a3d0b46abb}"},
    { "200.1.1", "   Rejects topology calls",                                     0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED | RUN_NODE_PROP, KSPROPSETID_Sysaudio,  KSPROPERTY_SYSAUDIO_DEVICE_FRIENDLY_NAME, 0),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYSAUDIO_DEVICE_INTERFACE_NAME_1, "{b2dbf6b6-610a-44a1-b7e5-a7fb3e58f4bc}"},
    { "200.1.2", "   Out buffer small",                                             0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED | RUN_NODE_PROP, KSPROPSETID_Sysaudio,  KSPROPERTY_SYSAUDIO_DEVICE_FRIENDLY_NAME, 0),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYSAUDIO_DEVICE_INTERFACE_NAME_2, "{e03aa4f6-4d52-4b12-9ba6-8719fd78a158}"},
    { "200.1.3", "   Null string",                                                      0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED | RUN_NODE_PROP, KSPROPSETID_Sysaudio,  KSPROPERTY_SYSAUDIO_DEVICE_FRIENDLY_NAME, 0),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYSAUDIO_DEVICE_INTERFACE_NAME_3, "{2308769b-4997-4f0e-bb56-ee3c681a91f7}"},
    { "200.1.4", "   Invalid size string",                                           0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED | RUN_NODE_PROP, KSPROPSETID_Sysaudio,  KSPROPERTY_SYSAUDIO_DEVICE_FRIENDLY_NAME, 0),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYSAUDIO_DEVICE_INTERFACE_NAME_4, "{cc422ff0-cff9-4b2c-b66a-5ffaeb4691bd}"},
    { "200.1.5", "   One char string",                                              0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED | RUN_NODE_PROP, KSPROPSETID_Sysaudio,  KSPROPERTY_SYSAUDIO_DEVICE_FRIENDLY_NAME, 0),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYSAUDIO_DEVICE_INTERFACE_NAME_5, "{576711af-a6bc-4fb5-af2a-d69594cfd74f}"},
    { "200.1.6", "   Get string for invalid device",                            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED | RUN_NODE_PROP, KSPROPSETID_Sysaudio,  KSPROPERTY_SYSAUDIO_DEVICE_FRIENDLY_NAME, 0),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYSAUDIO_DEVICE_INTERFACE_NAME_6, "{79867f3f-7337-49e5-9f11-1fc28992a409}"},
    { "200.1.7", "   Get string length",                                            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED | RUN_NODE_PROP, KSPROPSETID_Sysaudio,  KSPROPERTY_SYSAUDIO_DEVICE_FRIENDLY_NAME, 0),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYSAUDIO_DEVICE_INTERFACE_NAME_7, "{20e914ac-b58b-489d-950c-b90a1945b51d}"},
    { "200.1.8", "   String unaligned",                                             0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED | RUN_NODE_PROP, KSPROPSETID_Sysaudio,  KSPROPERTY_SYSAUDIO_DEVICE_FRIENDLY_NAME, 0),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYSAUDIO_DEVICE_INTERFACE_NAME_8, "{6f2885c7-07f7-47da-9d31-bcdad69479cf}"},


    { "", "  KSPROPERTY_SYSAUDIO_DEVICE_INTERFACE_NAME",    0, 0, 0, 0, NULL, "{cb723984-1424-495e-8b73-6af534e4ff19}"},
    { "200.2.1", "   Rejects topology calls",                                   0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED | RUN_NODE_PROP, KSPROPSETID_Sysaudio,  KSPROPERTY_SYSAUDIO_DEVICE_INTERFACE_NAME, 0),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYSAUDIO_DEVICE_INTERFACE_NAME_1, "{fa2db052-4422-42e5-882e-9f3918dcec26}"},
    { "200.2.2", "   Out buffer small",                                           0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED | RUN_NODE_PROP, KSPROPSETID_Sysaudio,  KSPROPERTY_SYSAUDIO_DEVICE_INTERFACE_NAME, 0),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYSAUDIO_DEVICE_INTERFACE_NAME_2, "{f438a639-0b93-469f-a44e-38bcf2414f16}"},
    { "200.2.3", "   Null string",                                                    0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED | RUN_NODE_PROP, KSPROPSETID_Sysaudio,  KSPROPERTY_SYSAUDIO_DEVICE_INTERFACE_NAME, 0),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYSAUDIO_DEVICE_INTERFACE_NAME_3, "{f6d53033-992b-4c76-9199-9862132ebff4}"},
    { "200.2.4", "   Invalid size string",                                         0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED | RUN_NODE_PROP, KSPROPSETID_Sysaudio,  KSPROPERTY_SYSAUDIO_DEVICE_INTERFACE_NAME, 0),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYSAUDIO_DEVICE_INTERFACE_NAME_4, "{8d3b05e0-98fe-43d6-9f7f-9c79f2618b0b}"},
    { "200.2.5", "   One char string",                                              0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED | RUN_NODE_PROP, KSPROPSETID_Sysaudio,  KSPROPERTY_SYSAUDIO_DEVICE_INTERFACE_NAME, 0),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYSAUDIO_DEVICE_INTERFACE_NAME_5, "{fc9cb94a-9f2a-4f2f-b9dd-9800352fcb74}"},
    { "200.2.6", "   Get string for invalid device",                          0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED | RUN_NODE_PROP, KSPROPSETID_Sysaudio,  KSPROPERTY_SYSAUDIO_DEVICE_INTERFACE_NAME, 0),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYSAUDIO_DEVICE_INTERFACE_NAME_6, "{4ede8472-0abd-4ccc-81a1-73275cbae11b}"},
    { "200.2.7", "   Get string length",                                          0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED | RUN_NODE_PROP, KSPROPSETID_Sysaudio,  KSPROPERTY_SYSAUDIO_DEVICE_INTERFACE_NAME, 0),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYSAUDIO_DEVICE_INTERFACE_NAME_6, "{81eb05d8-c7fe-41ea-8070-766cf5a94fb4}"},
    { "200.2.8", "   String unaligned",                                           0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED | RUN_NODE_PROP, KSPROPSETID_Sysaudio,  KSPROPERTY_SYSAUDIO_DEVICE_INTERFACE_NAME, 0),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYSAUDIO_DEVICE_INTERFACE_NAME_7, "{497cea78-c09e-4df9-b31a-c69d8a8cb70c}"},

    { "", "  KSPROPERTY_SYSAUDIO_PREFERRED_DEVICE",         0, 0, 0, 0, NULL, "{5a84bf16-c07e-408b-a6fe-ca153eab2e1c}"},
    // since Generic_Property_KSPROPERTY_SYSAUDIO_PREFERRED_DEVICE_1 is not written - it is just returning FNS_FAIL, I have commented this test case.
    //  { "200.3.1", "   Not supported",                        0, 0, 0,
    //    GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Sysaudio, KSPROPERTY_SYSAUDIO_PREFERRED_DEVICE, sizeof(ULONG)),
    //    (TESTFNPROC)Generic_Property_KSPROPERTY_SYSAUDIO_PREFERRED_DEVICE_1, "{172e5937-a679-4726-9a44-f3b3c8722eb4}"},

    { "", "  KSPROPERTY_SYSAUDIO_SELECT_GRAPH",         0, 0, 0, 0, NULL, "{738ffd36-0b63-4fe3-a317-3dceca41fcb4}"},
    { "200.4.1", "   Invalid node",                                        0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Sysaudio, KSPROPERTY_SYSAUDIO_SELECT_GRAPH, 0),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYSAUDIO_SELECT_GRAPH_1, "{361eacac-cc1a-4f01-9d0b-b6a65aad54dd}"},
    { "200.4.2", "   Invalid pin",                                           0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Sysaudio, KSPROPERTY_SYSAUDIO_SELECT_GRAPH, 0),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYSAUDIO_SELECT_GRAPH_2, "{1be2068f-856c-4fc4-9a48-986560c7958f}"},
    { "200.4.3", "   Selects all nodes(some twice)",                0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Sysaudio, KSPROPERTY_SYSAUDIO_SELECT_GRAPH, 0),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYSAUDIO_SELECT_GRAPH_3, "{8596bea1-416f-4f30-8738-877dc793f2dc}"},

    { "", "  KSPROPERTY_SYSAUDIO_ADDREMOVE_GFX",        0, 0, 0, 0, NULL, "{f1612aaa-0bc1-4c7e-8c21-f6670531661c}"},
    { "200.5.1", "   Bad handle argument",                              0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Sysaudio, KSPROPERTY_SYSAUDIO_ADDREMOVE_GFX, sizeof(SYSAUDIO_GFX)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYSAUDIO_ADDREMOVE_GFX_1, "{539c7715-3082-45ef-8c2d-37ae56b3f255}"},
    { "200.5.2", "   Unallocated string",                                   0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Sysaudio, KSPROPERTY_SYSAUDIO_ADDREMOVE_GFX, sizeof(SYSAUDIO_GFX)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYSAUDIO_ADDREMOVE_GFX_2, "{ed46af41-de32-4b1f-8eeb-be9c4dbf9f93}"},
    { "200.5.3", "   Unallocated string - overflow",                   0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Sysaudio, KSPROPERTY_SYSAUDIO_ADDREMOVE_GFX, sizeof(SYSAUDIO_GFX)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYSAUDIO_ADDREMOVE_GFX_3, "{456d48f9-00c4-40cf-8dae-9693859a3273}"},

    { "", "  KSPROPERTY_SYSAUDIO_RENDER_PIN_INSTANCES",     0, 0, 0, 0, NULL, "{2c149039-a535-4b74-94da-5e679fb5ae03}"},
    { "200.6.1", "   Out buffer small",                                             0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Sysaudio, KSPROPERTY_SYSAUDIO_RENDER_PIN_INSTANCES, sizeof(KSPIN_CINSTANCES)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYSAUDIO_RENDER_PIN_INSTANCES_1, "{5d71ad36-00ab-4666-a4ab-4ded4190199b}"},
    { "200.6.2", "   Good in size",                                                   0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Sysaudio, KSPROPERTY_SYSAUDIO_RENDER_PIN_INSTANCES, sizeof(KSPIN_CINSTANCES)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYSAUDIO_RENDER_PIN_INSTANCES_2, "{094d728c-378c-40a4-9089-caaad6dcae2f}"},

    { "", "  KSPROPERTY_SYSAUDIO_CREATE_VIRTUAL_SOURCE",    0, 0, 0, 0, NULL, "{536328ff-e39e-401e-b783-4852a43700ad}"},
    { "200.7.1", "   Set not supported",                                            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Sysaudio, KSPROPERTY_SYSAUDIO_CREATE_VIRTUAL_SOURCE, sizeof(SYSAUDIO_CREATE_VIRTUAL_SOURCE)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYSAUDIO_CREATE_VIRTUAL_SOURCE_1, "{5426b25c-7a22-472b-917d-907713bf6179}"},
    { "200.7.2", "   Out buffer small",                                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Sysaudio, KSPROPERTY_SYSAUDIO_CREATE_VIRTUAL_SOURCE, sizeof(SYSAUDIO_CREATE_VIRTUAL_SOURCE)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYSAUDIO_CREATE_VIRTUAL_SOURCE_2, "{62d13837-59a5-40c7-b5fe-8be021b0321a}"},
    { "200.7.3", "   Invalid source get",                                            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Sysaudio, KSPROPERTY_SYSAUDIO_CREATE_VIRTUAL_SOURCE, sizeof(SYSAUDIO_CREATE_VIRTUAL_SOURCE)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYSAUDIO_CREATE_VIRTUAL_SOURCE_3, "{d140c176-9708-46ac-a8f5-08112b23a664}"},

    { "", "  KSPROPERTY_SYSAUDIO_ATTACH_VIRTUAL_SOURCE",     0, 0, 0, 0, NULL, "{496a6a01-b474-4cea-980c-a11d2d26a200}"},
    { "200.8.1", "   Invalid mixer id",                                                 0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Sysaudio, KSPROPERTY_SYSAUDIO_ATTACH_VIRTUAL_SOURCE, sizeof(SYSAUDIO_ATTACH_VIRTUAL_SOURCE)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYSAUDIO_ATTACH_VIRTUAL_SOURCE_1, "{0037a468-467d-4cd2-b5e6-eed5fbf5eadb}"},
    { "200.8.2", "   Attach valid source",                                            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Sysaudio, KSPROPERTY_SYSAUDIO_ATTACH_VIRTUAL_SOURCE, sizeof(SYSAUDIO_ATTACH_VIRTUAL_SOURCE)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYSAUDIO_ATTACH_VIRTUAL_SOURCE_2, "{df6d58f6-873e-4ac9-b891-b88bab9e66bb}"},
#endif // (NTDDI_VERSION < NTDDI_VISTA)

    // KSPROPSETID_AudioEngine
    { "", " KSPROPSETID_AudioEngine",						0, 0, 0, 0, NULL, "{4d8fee10-b239-4665-a9d8-fd3903c03770}" },
    { "", "  KSPROPERTY_AUDIOENGINE_LFXENABLE",		0, 0, 0, 0, NULL, "{aa942095-6ccd-497d-b873-c80946155094}"},
    { "300.1.1", "   Invalid Node ID - ULONG_MAX",		0, 0, 0, 
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_LFXENABLE, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_NodeID_ULONGMAX, "{909e43d7-00a7-4189-98ee-73c7804f468e}"},
    { "300.1.2", "   Invalid Node ID - 0x80000001",		0, 0, 0, 
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_LFXENABLE, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_NodeID_0x80000001, "{11e6386c-d578-470e-b3fc-e83b806df79a}"},
    { "300.1.3", "   NULL IN/OUT Buffer",						0, 0, 0, 
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_LFXENABLE, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_NULL_Buffer, "{136013df-31b5-4c72-bdfc-7df1b0411763}"},
    { "300.1.4","   Small IN/OUT Buffer",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_LFXENABLE, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_Small_Buffer, "{aa2b24ff-d1b1-4eaa-a9a2-0b49cd82c3c1}"},
    { "300.1.5", "   Out buffer Large",						0, 0, 0, 
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_LFXENABLE, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_Large_Buffer, "{86c82afe-d650-40bb-8811-4f282a6c0c5c}"},
    { "300.1.6", "   valid test data",				0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_LFXENABLE, sizeof(BOOL)),
        (TESTFNPROC)AudioEngine_Property_AUDIOENGINE_Generic_Valid, "{c3fe259b-74a5-418e-8d83-f006965ac380}"},
    { "300.1.7", "   Test for Basic support",              0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_LFXENABLE, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_Basic_Support, "{27469b6b-1e77-4118-9864-e127349e4998}"},

    { "", "  KSPROPERTY_AUDIOENGINE_GFXENABLE",		0, 0, 0, 0, NULL, "{975a020a-849d-4582-a275-a0dc583c09a4}"},
    { "300.2.1", "   Invalid Node ID - ULONG_MAX",		0, 0, 0, 
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_GFXENABLE, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_NodeID_ULONGMAX, "{5da60194-a47e-471f-9d3e-d4db2bead0c5}"},
    { "300.2.2", "   Invalid Node ID - 0x80000001",		0, 0, 0, 
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_GFXENABLE, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_NodeID_0x80000001, "{8e97c809-0c21-478e-92f9-dc605ed0c113}"},
    { "300.2.3", "   NULL IN/OUT Buffer",						0, 0, 0, 
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_GFXENABLE, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_NULL_Buffer, "{a180098c-243b-4571-82e9-8ce190f68afc}"},
    { "300.2.4","   Small IN/OUT Buffer",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_GFXENABLE, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_Small_Buffer, "{336f740d-23d5-4487-afdf-1b32c74ec21c}"},
    { "300.2.5", "   Out buffer Large",						0, 0, 0, 
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_GFXENABLE, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_Large_Buffer, "{f5eb3aa5-34b5-49de-84f2-0acf795e2267}"},
    { "300.2.6", "   valid test data",				0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_GFXENABLE, sizeof(BOOL)),
        (TESTFNPROC)AudioEngine_Property_AUDIOENGINE_Generic_Valid, "{ccb47a12-71f5-4b79-928f-06c207dcd7f5}"},
    { "300.2.7", "   Test for Basic support",              0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_GFXENABLE, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_Basic_Support, "{e736c239-3566-41fd-83d7-6e0c302b532d}"},

    { "", "  KSPROPERTY_AUDIOENGINE_MIXFORMAT",		0, 0, 0, 0, NULL, "{f8502e54-1e16-4a71-816a-aa5236419a9d}"},
    { "300.3.1", "   Invalid Node ID - ULONG_MAX",		0, 0, 0, 
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_MIXFORMAT, sizeof(KSDATAFORMAT)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_NodeID_ULONGMAX, "{638d2f04-67be-48ff-b838-377b1d6eeee0}"},
    { "300.3.2", "   Invalid Node ID - 0x80000001",		0, 0, 0, 
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_MIXFORMAT, sizeof(KSDATAFORMAT)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_NodeID_0x80000001, "{a6be0c84-01d4-497e-b298-5a1d5437b9bb}"},
    { "300.3.3", "   NULL IN/OUT Buffer",						0, 0, 0, 
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_MIXFORMAT, sizeof(KSDATAFORMAT)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_NULL_Buffer, "{85991737-a06c-43c8-b28a-0083ad51bf16}"},
    { "300.3.4","   Small IN/OUT Buffer",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_MIXFORMAT, sizeof(KSDATAFORMAT)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_Small_Buffer, "{f82ba282-2e1b-4427-9ac0-051283872520}"},
    { "300.3.5", "   Out buffer Large",						0, 0, 0, 
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_MIXFORMAT, sizeof(KSDATAFORMAT)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_Large_Buffer, "{a12425ee-ac95-4775-8125-7c3e3c71dd14}"},
    { "300.3.6", "   Valid Test Data",				0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_MIXFORMAT, sizeof(KSDATAFORMAT)),
        (TESTFNPROC)AudioEngine_Property_AUDIOENGINE_Generic_Valid, "{5f3cde91-1b7e-4120-91ea-542fd5a61881}"},
    { "300.3.7", "   Test for Basic support",              0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_MIXFORMAT, sizeof(KSDATAFORMAT)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_Basic_Support, "{0fb24331-b26d-4e82-a1f9-73b214d85a8b}"},

    { "", "  KSPROPERTY_AUDIOENGINE_DEVICEFORMAT",		0, 0, 0, 0, NULL, "{ce7d9a20-36b3-490a-833d-6937b0b152f5}"},
    { "300.5.1", "   Invalid Node ID - ULONG_MAX",		0, 0, 0, 
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_DEVICEFORMAT, sizeof(KSDATAFORMAT)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_NodeID_ULONGMAX, "{09b5e067-b932-4a65-8564-64b6f2090d83}"},
    { "300.5.2", "   Invalid Node ID - 0x80000001",		0, 0, 0, 
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_DEVICEFORMAT, sizeof(KSDATAFORMAT)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_NodeID_0x80000001, "{34e9a3c3-0382-4fdc-ad2c-80a2a0d053f9}"},
    { "300.5.3", "   NULL IN/OUT Buffer",						0, 0, 0, 
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_DEVICEFORMAT, sizeof(KSDATAFORMAT)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_NULL_Buffer, "{958eaf47-e82e-4c54-b0b7-e01287f286b1}"},
    { "300.5.4","   Small IN/OUT Buffer",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_DEVICEFORMAT, sizeof(KSDATAFORMAT)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_Small_Buffer, "{6f5ba691-8860-4188-a00a-7bc2b6f1ec80}"},
    { "300.5.5", "   Out buffer Large",						0, 0, 0, 
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_DEVICEFORMAT, sizeof(KSDATAFORMAT)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_Large_Buffer, "{412bd72f-023a-41fb-b105-bd578ed1feda}"},
    { "300.5.6", "   Valid Test Data",				0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_DEVICEFORMAT, sizeof(KSDATAFORMAT)),
        (TESTFNPROC)AudioEngine_Property_DEVICEFORMAT_Valid, "{28b83b07-7ff0-4c3a-9add-60541a5f9dcb}"},
    { "300.5.7", "   Test for Basic support",              0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_DEVICEFORMAT, sizeof(KSDATAFORMAT)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_Basic_Support, "{fa0541f7-78db-4ae0-ab7c-5d973bb4aeca}"},

    { "", "  KSPROPERTY_AUDIOENGINE_SUPPORTEDDEVICEFORMATS",		0, 0, 0, 0, NULL, "{c483f6d3-b59b-4f15-b225-88b4a5d339b4}"},
    { "400.11.1", "   Bad node id - 0x80000001", 0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_SUPPORTEDDEVICEFORMATS, sizeof(KSMULTIPLE_ITEM)),
        (TESTFNPROC)AudioEngine_Property_SUPPORTEDDEVICEFORMATS_1, "{210f7f0b-fb43-4785-9c9f-789bd5706da5}"},
    { "400.11.2", "   Bad node id - ULONG_MAX",             0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_SUPPORTEDDEVICEFORMATS, sizeof(KSMULTIPLE_ITEM)),
        (TESTFNPROC)AudioEngine_Property_SUPPORTEDDEVICEFORMATS_2, "{344a3f1f-50e2-4fa2-a249-f875bac1adfd}"},
    { "400.11.3", "   Passing NULL buffer",                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_SUPPORTEDDEVICEFORMATS, sizeof(KSMULTIPLE_ITEM)),
        (TESTFNPROC)AudioEngine_Property_SUPPORTEDDEVICEFORMATS_3, "{070ac342-4070-47a4-ba5b-7b4364077b51}"},
    { "400.11.4", "   Passing small buffer",                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_SUPPORTEDDEVICEFORMATS, sizeof(KSMULTIPLE_ITEM)),
        (TESTFNPROC)AudioEngine_Property_SUPPORTEDDEVICEFORMATS_4, "{34c4e209-93f9-47f7-967c-f830ada7d1d3}"},
    { "400.11.5", "   Passing large buffer",                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_SUPPORTEDDEVICEFORMATS, sizeof(KSMULTIPLE_ITEM)),
        (TESTFNPROC)AudioEngine_Property_SUPPORTEDDEVICEFORMATS_5, "{5cef95b2-17dd-4741-8685-91fc9d1378b3}"},
    { "400.11.6", "   Passing valid data",                                0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_SUPPORTEDDEVICEFORMATS, sizeof(KSMULTIPLE_ITEM)),
        (TESTFNPROC)AudioEngine_Property_SUPPORTEDDEVICEFORMATS_6, "{e4afaed7-0727-4cf9-8b6b-28e0d1aa58e8}"},

    { "", "  KSPROPERTY_AUDIOENGINE_DESCRIPTOR",		0, 0, 0, 0, NULL, "{304ad188-d507-4314-ba1c-b6711972ab48}"},
    { "300.7.1", "   Invalid Node ID - ULONG_MAX",		0, 0, 0, 
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_DESCRIPTOR, sizeof(KSAUDIOENGINE_DESCRIPTOR)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_NodeID_ULONGMAX, "{658307f1-de37-4181-ae1e-e3f82fcc604a}"},
    { "300.7.2", "   Invalid Node ID - 0x80000001",		0, 0, 0, 
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_DESCRIPTOR, sizeof(KSAUDIOENGINE_DESCRIPTOR)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_NodeID_0x80000001, "{9351c646-50fd-444f-84e8-6cac7b82b149}"},
    { "300.7.3", "   NULL IN/OUT Buffer",						0, 0, 0, 
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_DESCRIPTOR, sizeof(KSAUDIOENGINE_DESCRIPTOR)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_NULL_Buffer, "{d60e64cc-aaad-4325-ba66-58ac79b98135}"},
    { "300.7.4","   Small IN/OUT Buffer",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_DESCRIPTOR, sizeof(KSAUDIOENGINE_DESCRIPTOR)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_Small_Buffer, "{1c9e87d5-de4c-4514-afe9-2b72c6a5a8a5}"},
    { "300.7.5", "   Out buffer Large",						0, 0, 0, 
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_DESCRIPTOR, sizeof(KSAUDIOENGINE_DESCRIPTOR)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_Large_Buffer, "{f7e87661-1018-408e-b795-cdab4e633969}"},
    { "300.7.6", "   Valid Test Data",				0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_DESCRIPTOR, sizeof(KSAUDIOENGINE_DESCRIPTOR)),
        (TESTFNPROC)AudioEngine_Property_AUDIOENGINE_Generic_Valid, "{6708dc91-d44f-4f79-9a92-236fc4b7765a}"},
    { "300.7.7", "   Test for Basic support",              0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_DESCRIPTOR, sizeof(KSAUDIOENGINE_DESCRIPTOR)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTY_AUDIO_Basic_Support, "{def24391-e7f1-4727-b408-878d069ad171}"},

    // KSPROPSETID_Itd3d
    { "",   " KSPROPSETID_Itd3d",							    0, 0, 0, 0, NULL, "{3bd0316e-17e0-468a-801d-88f8d052c3fe}"},

    { "", "  KSPROPERTY_ITD3D_PARAMS",					    0, 0, 0, 0, NULL, "{cd9287b4-9d2c-4dde-b008-0f8b7c5bb147}"},
    { "600.1.1", "   Passing Invalid Node id - 0x80000001",		0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP |RUN_NODE_PROP | RUN_IF_SUPPORTED | RUN_PROP, KSPROPSETID_Itd3d, KSPROPERTY_ITD3D_PARAMS, sizeof(KSDS3D_ITD_PARAMS_MSG)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_ITD3D_PARAMS_1, "{44253445-0766-4265-b6b3-2e01249e7243}"},
    { "600.1.2", "   Passing Invalid Node id - ULONG_MAX",           0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP |RUN_NODE_PROP | RUN_IF_SUPPORTED | RUN_PROP, KSPROPSETID_Itd3d, KSPROPERTY_ITD3D_PARAMS, sizeof(KSDS3D_ITD_PARAMS_MSG)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_ITD3D_PARAMS_2, "{BC4B2C8A-0CCE-4547-8776-C50D10F88615}"},
    { "600.1.3", "   Passing NULL Buffer",                                     0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP |RUN_NODE_PROP | RUN_IF_SUPPORTED | RUN_PROP, KSPROPSETID_Itd3d, KSPROPERTY_ITD3D_PARAMS, sizeof(KSDS3D_ITD_PARAMS_MSG)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_ITD3D_PARAMS_3, "{5CE555C0-B0F1-4fd8-AD31-F3FF162D0936}"},
    { "600.1.4", "   Passing Small Buffer",                                    0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP |RUN_NODE_PROP | RUN_IF_SUPPORTED | RUN_PROP, KSPROPSETID_Itd3d, KSPROPERTY_ITD3D_PARAMS, sizeof(KSDS3D_ITD_PARAMS_MSG)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_ITD3D_PARAMS_4, "{D8B0F7BD-D88D-45db-B3AF-7F17A987A13B}"},
    { "600.1.5", "   Passing Large Buffer",                                    0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP |RUN_NODE_PROP | RUN_IF_SUPPORTED | RUN_PROP, KSPROPSETID_Itd3d, KSPROPERTY_ITD3D_PARAMS, sizeof(KSDS3D_ITD_PARAMS_MSG)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_ITD3D_PARAMS_5, "{34D6D4B9-C564-4173-9EDA-CA2B267FB671}"},
    { "600.1.6", "   Passing Valid Data",                                       0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP |RUN_NODE_PROP | RUN_IF_SUPPORTED | RUN_PROP, KSPROPSETID_Itd3d, KSPROPERTY_ITD3D_PARAMS, sizeof(KSDS3D_ITD_PARAMS_MSG)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_ITD3D_PARAMS_6, "{17153299-E9E0-4a3d-A8A6-5FD53C0FFB4C}"},

    // KSPROPSETID_Hrtf3d
    { "",   " KSPROPSETID_Hrtf3d",						    0, 0, 0, 0, NULL, "{9c6272d2-cf79-4f88-b17c-61227b688704}"},

    { "", "  KSPROPERTY_HRTF3D_PARAMS",				   0, 0, 0, 0, NULL, "{834707e4-d235-4fd8-92e8-fcea39c10074}"},
    { "700.1.1", "   Invalid size",							   0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_NODE_PROP |RUN_IF_SUPPORTED | RUN_PROP, KSPROPSETID_Hrtf3d, KSPROPERTY_HRTF3D_PARAMS, sizeof(KSDS3D_HRTF_PARAMS_MSG)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_HRTF3D_PARAMS_1, "{9542f59f-e2a8-45c3-812f-6a5af05674e9}"},
    { "700.1.2", "   Disable 3D",							   0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_NODE_PROP |RUN_IF_SUPPORTED | RUN_PROP, KSPROPSETID_Hrtf3d, KSPROPERTY_HRTF3D_PARAMS, sizeof(KSDS3D_HRTF_PARAMS_MSG)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_HRTF3D_PARAMS_2, "{e4b0993e-3d45-4960-9120-e494e0bfbc7f}"},
    { "700.1.3", "   Dynamic invalid struct size",  		          0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_NODE_PROP |RUN_IF_SUPPORTED | RUN_PROP, KSPROPSETID_Hrtf3d, KSPROPERTY_HRTF3D_PARAMS, sizeof(KSDS3D_HRTF_PARAMS_MSG)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_HRTF3D_PARAMS_3, "{a66c2993-a8b0-45d3-97be-443b2d4d0005}"},
    { "700.1.4", "   Dynamic invalid filter size",			          0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_NODE_PROP |RUN_IF_SUPPORTED | RUN_PROP, KSPROPSETID_Hrtf3d, KSPROPERTY_HRTF3D_PARAMS, sizeof(KSDS3D_HRTF_PARAMS_MSG)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_HRTF3D_PARAMS_4, "{3b9a45a7-f98f-4080-86e4-8388f10c51ea}"},
    { "700.1.5", "   Zero size struct",						   0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_NODE_PROP |RUN_IF_SUPPORTED | RUN_PROP, KSPROPSETID_Hrtf3d, KSPROPERTY_HRTF3D_PARAMS, sizeof(KSDS3D_HRTF_PARAMS_MSG)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_HRTF3D_PARAMS_5, "{72e37952-9e1f-458a-8e91-419a6366a476}"},

    { "", "  KSPROPERTY_HRTF3D_FILTER_FORMAT",			    0, 0, 0, 0, NULL, "{3744356d-a496-4bb4-89c9-8562efe7a850}"},
    { "700.2.1", "   Out buffer invalid size",				           0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_NODE_PROP |RUN_IF_SUPPORTED | RUN_PROP, KSPROPSETID_Hrtf3d, KSPROPERTY_HRTF3D_FILTER_FORMAT, sizeof(KSDS3D_HRTF_FILTER_FORMAT_MSG)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_HRTF3D_FILTER_FORMAT_1, "{d8602562-b03e-491b-b589-df237381c09d}"},

    { "", "  KSPROPERTY_HRTF3D_INITIALIZE",				    0, 0, 0, 0, NULL, "{01c27533-0a84-45b3-88af-120faa0e2452}"},
    { "700.3.1", "   Out buffer invalid size",			                  0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_NODE_PROP |RUN_IF_SUPPORTED | RUN_PROP, KSPROPSETID_Hrtf3d, KSPROPERTY_HRTF3D_INITIALIZE, sizeof(KSDS3D_HRTF_INIT_MSG)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_HRTF3D_INITIALIZE_1, "{83dfb9ee-03f7-4e80-977b-a1f80abf4d32}"},

// Acoustic Echo Cancel ended in XP
#if (NTDDI_VERSION < NTDDI_VISTA)

    //KSPROPSETID_Acoustic_Echo_Cancel	
    { "",   " KSPROPSETID_Acoustic_Echo_Cancel",				0, 0, 0, 0, NULL, "{F135F5E2-4D5D-41f1-8414-F62ACE6FCC5F}"},

    { "", "  KSPROPERTY_AEC_MODE",                                         0, 0, 0, 0, NULL, "{9DB63CC2-6EBF-4feb-A12B-CF478537762D}"},
    { "1200.1.1", "   Invalid Node ID - ULONG_MAX",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP |RUN_NODE_PROP |RUN_IF_SUPPORTED, KSPROPSETID_Acoustic_Echo_Cancel, KSPROPERTY_AEC_MODE, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_NodeID_ULONGMAX, "{4F896715-DE40-4369-8169-9A76FAED4659}"},
    { "1200.1.2", "   Invalid Node ID - 0x80000001",  			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP |RUN_NODE_PROP |RUN_IF_SUPPORTED, KSPROPSETID_Acoustic_Echo_Cancel, KSPROPERTY_AEC_MODE, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_NodeID_0x80000001, "{45E5AB73-16E8-4c1e-8244-FF5901C96FDA}"},
    { "1200.1.3", "   NULL IN/OUT Buffer",  					0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP |RUN_NODE_PROP |RUN_IF_SUPPORTED, KSPROPSETID_Acoustic_Echo_Cancel, KSPROPERTY_AEC_MODE, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_NULL_Buffer, "{9FD12C3C-28D3-44ac-9EBE-432B6E8556B8}"},
    { "1200.1.4", "   Small IN/OUT Buffer",  					0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP |RUN_NODE_PROP |RUN_IF_SUPPORTED, KSPROPSETID_Acoustic_Echo_Cancel, KSPROPERTY_AEC_MODE, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_Small_Buffer, "{3408C884-4B27-4067-80B1-FA1F6169E101}"},
    { "1200.1.5", "   Out buffer Large",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP |RUN_NODE_PROP |RUN_IF_SUPPORTED, KSPROPSETID_Acoustic_Echo_Cancel, KSPROPERTY_AEC_MODE, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_Large_Buffer, "{D11ABBB3-C4B3-4966-808F-9A71CBD5EC1E}"},	

    { "", "  KSPROPERTY_AEC_NOISE_FILL_ENABLE",                    0, 0, 0, 0, NULL, "{85F32BCE-1027-465d-B5CC-6182A2291B6A}"},
    { "1200.2.1", "   Invalid Node ID - ULONG_MAX",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP |RUN_NODE_PROP |RUN_IF_SUPPORTED, KSPROPSETID_Acoustic_Echo_Cancel, KSPROPERTY_AEC_NOISE_FILL_ENABLE, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_NodeID_ULONGMAX, "{6DAEDB74-04D4-405e-8480-462DF6911424}"},
    { "1200.2.2", "   Invalid Node ID - 0x80000001",  			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP |RUN_NODE_PROP |RUN_IF_SUPPORTED, KSPROPSETID_Acoustic_Echo_Cancel, KSPROPERTY_AEC_NOISE_FILL_ENABLE, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_NodeID_0x80000001, "{D0604866-353E-4481-9B1A-852470595B51}"},
    { "1200.2.3", "   NULL IN/OUT Buffer",  					0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP |RUN_NODE_PROP |RUN_IF_SUPPORTED, KSPROPSETID_Acoustic_Echo_Cancel, KSPROPERTY_AEC_NOISE_FILL_ENABLE, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_NULL_Buffer, "{A87C5A55-B6F1-4357-9FBC-208ED799CB3F}"},
    { "1200.2.4", "   Small IN/OUT Buffer",  					0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP |RUN_NODE_PROP |RUN_IF_SUPPORTED, KSPROPSETID_Acoustic_Echo_Cancel, KSPROPERTY_AEC_NOISE_FILL_ENABLE, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_Small_Buffer, "{B719ABAB-8DDE-471f-9804-23808CD9A22A}"},
    { "1200.2.5", "   Out buffer Large",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP |RUN_NODE_PROP |RUN_IF_SUPPORTED, KSPROPSETID_Acoustic_Echo_Cancel, KSPROPERTY_AEC_NOISE_FILL_ENABLE, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_Large_Buffer, "{326FFB20-808C-450d-8101-7B519CEEE5D4}"},	

    { "", "  KSPROPERTY_AEC_STATUS",                                      0, 0, 0, 0, NULL, "{08F81455-0A01-4d5c-B4CD-CC12F913C176}"},
    { "1200.3.1", "   Invalid Node ID - ULONG_MAX",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP |RUN_NODE_PROP |RUN_IF_SUPPORTED, KSPROPSETID_Acoustic_Echo_Cancel, KSPROPERTY_AEC_STATUS, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_NodeID_ULONGMAX, "{18DDE772-D032-4532-9B5C-4CECF6A8931A}"},
    { "1200.3.2", "   Invalid Node ID - 0x80000001",  			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP |RUN_NODE_PROP |RUN_IF_SUPPORTED, KSPROPSETID_Acoustic_Echo_Cancel, KSPROPERTY_AEC_STATUS, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_NodeID_0x80000001, "{C73AD9D7-5E84-4bb3-B807-2F225579985C}"},
    { "1200.3.3", "   NULL IN/OUT Buffer",  					0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP |RUN_NODE_PROP |RUN_IF_SUPPORTED, KSPROPSETID_Acoustic_Echo_Cancel, KSPROPERTY_AEC_STATUS, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_NULL_Buffer, "{3C2017B3-0ACC-4ef7-9519-255FD0EC7FDB}"},
    { "1200.3.4", "   Small IN/OUT Buffer",  					0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP |RUN_NODE_PROP |RUN_IF_SUPPORTED, KSPROPSETID_Acoustic_Echo_Cancel, KSPROPERTY_AEC_STATUS, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_Small_Buffer, "{24F6ACA7-86D6-4a5c-A617-5576A9B770C0}"},
    { "1200.3.5", "   Out buffer Large",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP |RUN_NODE_PROP |RUN_IF_SUPPORTED, KSPROPSETID_Acoustic_Echo_Cancel, KSPROPERTY_AEC_STATUS, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_Large_Buffer, "{0633C366-2987-4f79-97BA-D716F97A4C42}"},	

#endif // (NTDDI_VERSION < NTDDI_VISTA)

    //KSPROPSETID_DirectSound3DBuffer  
    { "",   " KSPROPSETID_DirectSound3DBuffer",                     0, 0, 0, 0, NULL, "{3B70FD61-A6AF-416c-B7C9-C31D8281F7B4}"},

    { "", "  KSPROPERTY_DIRECTSOUND3DBUFFER_CONEOUTSIDEVOLUME",    0, 0, 0, 0, NULL, "{D31F815C-8611-4b7e-9BC2-900421CD554C}"},
    { "1300.1.1", "   Invalid Node ID - ULONG_MAX",                                      0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_CONEOUTSIDEVOLUME, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_NodeID_ULONGMAX, "{0855B3C1-62B7-440d-B251-0E9FF134EF3B}"},
    { "1300.1.2", "   Invalid Node ID - 0x80000001",                                       0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_CONEOUTSIDEVOLUME, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_NodeID_0x80000001, "{37B8F0AB-0C39-4c1f-92C9-3273D58D6236}"},
    { "1300.1.3", "   NULL IN/OUT Buffer",                                                      0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_CONEOUTSIDEVOLUME, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_NULL_Buffer, "{7D6B730C-E002-4747-8D93-9D9EB354BA98}"},
    { "1300.1.4", "   Small IN/OUT Buffer",                                                     0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_CONEOUTSIDEVOLUME, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_Small_Buffer, "{B05B0EE6-F852-4d3c-8292-92854FE1A711}"},
    { "1300.1.5", "   Out buffer Large",                                                            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_CONEOUTSIDEVOLUME, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_Large_Buffer, "{8082B45B-F9EE-45c2-BF33-33A1BD210BAC}"},  

    { "", "  KSPROPERTY_DIRECTSOUND3DBUFFER_MODE",        0, 0, 0, 0, NULL, "{7BED58FA-7A15-456f-9953-9667A69ADAE6}"},
    { "1300.2.1", "   Invalid Node ID - ULONG_MAX",                  0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_MODE, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_NodeID_ULONGMAX, "{AE511624-E68B-4164-B78E-FFA9E1C09F0E}"},
    { "1300.2.2", "   Invalid Node ID - 0x80000001",                   0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_MODE, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_NodeID_0x80000001, "{78EE7885-59F8-4ba1-A63C-11D75290D582}"},
    { "1300.2.3", "   NULL IN/OUT Buffer",                                  0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_MODE, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_NULL_Buffer, "{C5EE08B4-2E41-40d1-A813-9ACA637FCB7C}"},
    { "1300.2.4", "   Small IN/OUT Buffer",                                 0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_MODE, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_Small_Buffer, "{D0978D94-D9C3-4eef-A56A-E8756EC600E2}"},
    { "1300.2.5", "   Out buffer Large",                                        0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_MODE, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_Large_Buffer, "{B8016942-1D6D-4311-AFD0-A3478AD58661}"},  

    { "", "  KSPROPERTY_DIRECTSOUND3DBUFFER_ALL",       0, 0, 0, 0, NULL, "{FC44048B-5C71-4c05-8BB9-750540911C54}"},
    { "1300.3.1", "   Invalid Node ID - ULONG_MAX",             0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_ALL, sizeof(KSDS3D_BUFFER_ALL)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_ALL_1, "{860A183C-20A5-4a8b-A5A4-B1A7363A092E}"},
    { "1300.3.2", "   Invalid Node ID - 0x80000001",              0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_ALL, sizeof(KSDS3D_BUFFER_ALL)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_ALL_2, "{699ECC8F-7DB3-453c-AF7A-72BAF0943214}"},
    { "1300.3.3", "   NULL IN/OUT Buffer",                             0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_ALL, sizeof(KSDS3D_BUFFER_ALL)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_ALL_3, "{85C62F41-4A63-4516-BCC6-FD22BBDDC7AF}"},
    { "1300.3.4", "   Small IN/OUT Buffer",                            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_ALL, sizeof(KSDS3D_BUFFER_ALL)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_ALL_4, "{D614D8A4-A875-4a35-92D2-8D210A8BA9EA}"},
    { "1300.3.5", "   Out buffer Large",                                  0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_ALL, sizeof(KSDS3D_BUFFER_ALL)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_ALL_5, "{7885DFED-4E9E-46a7-B1F8-8C80F64C7C44}"},
    { "1300.3.6", "   Invalid  Mode  - ULONG_MAX",               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_ALL, sizeof(KSDS3D_BUFFER_ALL)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_ALL_6, "{F3B8A03F-F4CF-4a99-8E38-7C5476A51675}"},
    { "1300.3.7", "   Invalid  Mode - 0x80000001",                 0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_ALL, sizeof(KSDS3D_BUFFER_ALL)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_ALL_7, "{98951774-6DB0-49ce-AE39-6C7AC49444E8}"},
    { "1300.3.8", "   Invalid Inside Cone angles - MIN-1",       0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_ALL, sizeof(KSDS3D_BUFFER_ALL)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_ALL_8, "{4ABB35CD-5241-4bfc-AB2C-E7FF5138345B}"},
    { "1300.3.9", "   Invalid Inside Cone angles - MAX+1",      0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_ALL, sizeof(KSDS3D_BUFFER_ALL)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_ALL_9, "{A81ADC36-EFFE-433f-B96B-2104BE02917F}"},
    { "1300.3.10", "   Invalid Outside Cone angles - MIN-1",    0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_ALL, sizeof(KSDS3D_BUFFER_ALL)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_ALL_10, "{60CAA0D4-6349-49c9-832B-71C6F07E83E6}"},
    { "1300.3.11", "   Invalid Outside Cone angles - MAX+1",   0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_ALL, sizeof(KSDS3D_BUFFER_ALL)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_ALL_11, "{53915D42-7337-410b-93D9-BFA0A31094BF}"},
    { "1300.3.12", "   Invalid Min Distance - (-1)",                   0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_ALL, sizeof(KSDS3D_BUFFER_ALL)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_ALL_12, "{7AE7F38A-94E4-4237-9807-9447B4A525FC}"},
    { "1300.3.13", "   Invalid Max Distance - (-1)",                  0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_ALL, sizeof(KSDS3D_BUFFER_ALL)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_ALL_13, "{529C85C4-128C-4c15-B259-FA2C3555F8EA}"},

    { "", "  KSPROPERTY_DIRECTSOUND3DBUFFER_CONEANGLES", 0, 0, 0, 0, NULL, "{98F8EC37-F5F4-4789-8B5A-6970CD122696}"},
    { "1300.4.1", "   Invalid Node ID - ULONG_MAX",                      0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_CONEANGLES, sizeof(KSDS3D_BUFFER_CONE_ANGLES)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_CONEANGLES_1, "{537336BC-CF4F-4591-BC38-16BDF7E4B157}"},
    { "1300.4.2", "   Invalid Node ID - 0x80000001",                       0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_CONEANGLES, sizeof(KSDS3D_BUFFER_CONE_ANGLES)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_CONEANGLES_2, "{B9600587-C81D-4b37-9971-F0573E6FAEC0}"},
    { "1300.4.3", "   NULL IN/OUT Buffer",                                      0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_CONEANGLES, sizeof(KSDS3D_BUFFER_CONE_ANGLES)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_CONEANGLES_3, "{81E2B45F-FFDC-4072-9D54-A7423BF94CFC}"},
    { "1300.4.4", "   Small IN/OUT Buffer",                                     0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_CONEANGLES, sizeof(KSDS3D_BUFFER_CONE_ANGLES)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_CONEANGLES_4, "{4F4F9004-ACE8-4548-A486-209B7AC616BA}"},
    { "1300.4.5", "   Out buffer Large",                                            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_CONEANGLES, sizeof(KSDS3D_BUFFER_CONE_ANGLES)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_CONEANGLES_5, "{A9A1B48C-3F4B-4346-95F3-EA7090687381}"},
    { "1300.4.6", "   Invalid Inside Cone angles - MIN-1",                 0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_CONEANGLES, sizeof(KSDS3D_BUFFER_CONE_ANGLES)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_CONEANGLES_6, "{7D9D1E5E-AFD8-43e9-9865-A90FD865FAE0}"},
    { "1300.4.7", "   Invalid Inside Cone angles - MAX+1",                0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_CONEANGLES, sizeof(KSDS3D_BUFFER_CONE_ANGLES)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_CONEANGLES_7, "{57CC3B1A-7745-4c50-8CFA-1B20FCCD9B91}"},
    { "1300.4.8", "   Invalid Outside Cone angles - MIN-1",               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_CONEANGLES, sizeof(KSDS3D_BUFFER_CONE_ANGLES)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_CONEANGLES_8, "{7D70DA85-F5EC-4e84-95D9-9BDD428BC2A4}"},
    { "1300.4.9", "   Invalid Outside Cone angles - MAX+1",              0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_CONEANGLES, sizeof(KSDS3D_BUFFER_CONE_ANGLES)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_CONEANGLES_9, "{E0435D14-ED6A-400c-9BDE-26E7061B67DA}"},

    { "", "  KSPROPERTY_DIRECTSOUND3DBUFFER_CONEORIENTATION",    0, 0, 0, 0, NULL, "{5DE789B5-F47E-4fc5-871E-D7CAD5B17F0D}"},
    { "1300.5.1", "   Invalid Node ID - ULONG_MAX",                                  0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_CONEORIENTATION, sizeof(DS3DVECTOR)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_CONEORIENTATION_1, "{3231C7B4-9264-4eed-A728-BF2C913391F9}"},
    { "1300.5.2", "   Invalid Node ID - 0x80000001",                                   0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_CONEORIENTATION, sizeof(DS3DVECTOR)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_CONEORIENTATION_2, "{181390B3-0D98-4f7b-9037-C6F72F63B4FB}"},
    { "1300.5.3", "   NULL IN/OUT Buffer",                                                  0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_CONEORIENTATION, sizeof(DS3DVECTOR)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_CONEORIENTATION_3, "{430FCF76-D9B4-4f9a-9F0F-DF1880166C77}"},
    { "1300.5.4", "   Small IN/OUT Buffer",                                                 0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_CONEORIENTATION, sizeof(DS3DVECTOR)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_CONEORIENTATION_4, "{C792252B-9C63-465f-860C-820F7C33FCB6}"},
    { "1300.5.5", "   Out buffer Large",                                                       0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_CONEORIENTATION, sizeof(DS3DVECTOR)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_CONEORIENTATION_5, "{BB5EA579-1679-438b-9EF9-D19E65BAC020}"},

    { "", "  KSPROPERTY_DIRECTSOUND3DBUFFER_MAXDISTANCE",        0, 0, 0, 0, NULL, "{B905355C-7AA5-4d9a-8726-95B6BF879643}"},
    { "1300.6.1", "   Invalid Node ID - ULONG_MAX",                              0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_MAXDISTANCE, sizeof(FLOAT)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_MAXDISTANCE_1, "{B51F8D25-D7BB-44b1-B7DB-D718854E140C}"},
    { "1300.6.2", "   Invalid Node ID - 0x80000001",                                 0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_MAXDISTANCE, sizeof(FLOAT)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_MAXDISTANCE_2, "{15643C88-A810-4f04-BB5C-3E434D1F8040}"},
    { "1300.6.3", "   NULL IN/OUT Buffer",                                                0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_MAXDISTANCE, sizeof(FLOAT)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_MAXDISTANCE_3, "{5348498C-8E05-4645-AF9E-67A836D65826}"},
    { "1300.6.4", "   Small IN/OUT Buffer",                                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_MAXDISTANCE, sizeof(FLOAT)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_MAXDISTANCE_4, "{9739520A-FEEF-4048-AD4D-3C4C5A7CA155}"},
    { "1300.6.5", "   Out buffer Large",                                                     0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_MAXDISTANCE, sizeof(FLOAT)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_MAXDISTANCE_5, "{8D3D3221-2EA3-401a-AEC0-C9FEDB604AC9}"},
    { "1300.6.6", "   Invalid Max Distance - (-1)",                                     0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_MAXDISTANCE, sizeof(FLOAT)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_MAXDISTANCE_6, "{C998F1E6-1A6F-466f-A02F-4B6B3BA1B175}"},

    { "", "  KSPROPERTY_DIRECTSOUND3DBUFFER_MINDISTANCE",       0, 0, 0, 0, NULL, "{CF567DC9-28A9-4332-B06E-A6527AF7F47D}"},
    { "1300.7.1", "   Invalid Node ID - ULONG_MAX",                          0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_MINDISTANCE, sizeof(FLOAT)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_MINDISTANCE_1, "{00F7F420-6944-4d1a-AB18-98777024DBB3}"},
    { "1300.7.2", "   Invalid Node ID - 0x80000001",                           0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_MINDISTANCE, sizeof(FLOAT)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_MINDISTANCE_2, "{8F8B80A7-2867-4361-8AB9-C91F9905ADFF}"},
    { "1300.7.3", "   NULL IN/OUT Buffer",                                          0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_MINDISTANCE, sizeof(FLOAT)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_MINDISTANCE_3, "{3F8D2F31-74D8-4e01-96F0-E52D80FFF05D}"},
    { "1300.7.4", "   Small IN/OUT Buffer",                                         0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_MINDISTANCE, sizeof(FLOAT)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_MINDISTANCE_4, "{704F4873-7062-46da-B4C1-FBF299367ECE}"},
    { "1300.7.5", "   Out buffer Large",                                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_MINDISTANCE, sizeof(FLOAT)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_MINDISTANCE_5, "{50F9065B-E73B-467c-8947-87D95C24E57F}"},
    { "1300.7.6", "   Invalid Min Distance - (-1)",                                0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_MINDISTANCE, sizeof(FLOAT)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_MINDISTANCE_6, "{CFAC5FBB-342F-4bc6-B6A1-D00B142E7FDD}"},

    { "", "  KSPROPERTY_DIRECTSOUND3DBUFFER_POSITION",      0, 0, 0, 0, NULL, "{8C5B0090-7F55-490f-BBAC-CFB69CD26CB5}"},
    { "1300.8.1", "   Invalid Node ID - ULONG_MAX",                      0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_POSITION, sizeof(DS3DVECTOR)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_POSITION_1, "{DFFFACE1-D98C-4e93-AC69-E2248F79E0D4}"},
    { "1300.8.2", "   Invalid Node ID - 0x80000001",                       0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_POSITION, sizeof(DS3DVECTOR)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_POSITION_2, "{5A551A41-A6F6-4739-BBB4-0D2D7ACF0334}"},
    { "1300.8.3", "   NULL IN/OUT Buffer",                                       0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_POSITION, sizeof(DS3DVECTOR)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_POSITION_3, "{97571D7B-A84A-4429-A921-EF80BB83690C}"},
    { "1300.8.4", "   Small IN/OUT Buffer",                                      0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_POSITION, sizeof(DS3DVECTOR)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_POSITION_4, "{ED05A8F1-3C68-4f5e-BEFA-5E65B6263705}"},
    { "1300.8.5", "   Out buffer Large",                                             0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_POSITION, sizeof(DS3DVECTOR)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_POSITION_5, "{290B90F3-0951-4580-87CC-A26269C2E60B}"},

    { "", "  KSPROPERTY_DIRECTSOUND3DBUFFER_VELOCITY",      0, 0, 0, 0, NULL, "{9FE18A49-E852-4401-8F90-7B126D4CE43A}"},
    { "1300.9.1", "   Invalid Node ID - ULONG_MAX",                      0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_VELOCITY, sizeof(DS3DVECTOR)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_VELOCITY_1, "{2A521A33-B2C6-44cb-AF4A-FC982803F3CA}"},
    { "1300.9.2", "   Invalid Node ID - 0x80000001",                       0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_VELOCITY, sizeof(DS3DVECTOR)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_VELOCITY_2, "{6C4D871F-09F3-448c-8077-3020B1728E8F}"},
    { "1300.9.3", "   NULL IN/OUT Buffer",                                      0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_VELOCITY, sizeof(DS3DVECTOR)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_VELOCITY_3, "{F00DC9AD-BE59-4240-BE79-6A3A2042638A}"},
    { "1300.9.4", "   Small IN/OUT Buffer",                                     0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_VELOCITY, sizeof(DS3DVECTOR)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_VELOCITY_4, "{1200A5D3-91B9-4d34-BD7D-10D3B0C5E6DA}"},
    { "1300.9.5", "   Out buffer Large",                                           0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_VELOCITY, sizeof(DS3DVECTOR)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_VELOCITY_5, "{21298B1F-2DFD-45e9-A0DF-344159BD94E0}"},

    //KSPROPSETID_DirectSound3DListener 
    { "",   " KSPROPSETID_DirectSound3DListener",                       0, 0, 0, 0, NULL, "{28B2217E-62B3-4d4f-9027-5724DC48AE91}"},

    { "", "  KSPROPERTY_DIRECTSOUND3DLISTENER_ALLOCATION",   0, 0, 0, 0, NULL, "{3B16E8F5-BEE1-49b0-99A2-AA7DD2B6E843}"},
    { "1400.1.1", "   Invalid Node ID - ULONG_MAX",                          0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_ALLOCATION, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_NodeID_ULONGMAX, "{BCDBE515-BBDD-48e1-A0AF-2C4AD90BBCAD}"},
    { "1400.1.2", "   Invalid Node ID - 0x80000001",                           0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_ALLOCATION, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_NodeID_0x80000001, "{9C5154DD-BFF1-4d3c-93EE-9ACD60E81E39}"},
    { "1400.1.3", "   NULL IN/OUT Buffer",                                          0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_ALLOCATION, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_NULL_Buffer, "{FF29CBCC-B132-4f9b-A61C-40DAE616CF51}"},
    { "1400.1.4", "   Small IN/OUT Buffer",                                         0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_ALLOCATION, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_Small_Buffer, "{23AF1D82-6501-4563-A97C-559B26DC699F}"},
    { "1400.1.5", "   Out buffer Large",                                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_ALLOCATION, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_Large_Buffer, "{CBD93E2D-3EBB-4c29-B500-049D9C92FD6A}"},  

    { "", "  KSPROPERTY_DIRECTSOUND3DLISTENER_BATCH",        0, 0, 0, 0, NULL, "{A7941052-3820-4e81-B70C-57C9954399AF}"},
    { "1400.2.1", "   Invalid Node ID - ULONG_MAX",                      0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_BATCH, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_NodeID_ULONGMAX, "{54D93ADA-446B-46e6-B00D-9F949819674B}"},
    { "1400.2.2", "   Invalid Node ID - 0x80000001",                         0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_BATCH, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_NodeID_0x80000001, "{8E29CE84-9B6D-4612-BA93-6FBA0624B624}"},
    { "1400.2.3", "   NULL IN/OUT Buffer",                                       0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_BATCH, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_NULL_Buffer, "{F7AB3ECD-8A79-47d4-B0C1-4DEE7E6A99B9}"},
    { "1400.2.4", "   Small IN/OUT Buffer",                                      0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_BATCH, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_Small_Buffer, "{5BD0CE82-B4AF-423a-9302-6D2135536BBF}"},
    { "1400.2.5", "   Out buffer Large",                                             0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_BATCH, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_Large_Buffer, "{07C5DCC0-5CDE-49f6-B683-E3F7EEC11B6E}"},  

    { "", "  KSPROPERTY_DIRECTSOUND3DLISTENER_ALL",         0, 0, 0, 0, NULL, "{AD3F4B0F-AC9D-455a-98DE-C936C0C2E42F}"},
    { "1400.3.1", "   Invalid Node ID - ULONG_MAX",                  0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_ALL, sizeof(KSDS3D_LISTENER_ALL)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_ALL_1, "{E711BAC8-7860-4ed1-94CF-D4DCC7850E2A}"},
    { "1400.3.2", "   Invalid Node ID - 0x80000001",                   0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_ALL, sizeof(KSDS3D_LISTENER_ALL)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_ALL_2, "{99B106C5-67A4-43d7-AF91-6F9203F9BE46}"},
    { "1400.3.3", "   NULL IN/OUT Buffer",                                  0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_ALL, sizeof(KSDS3D_LISTENER_ALL)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_ALL_3, "{88877074-3DAF-48ec-9F55-6A2906DEA207}"},
    { "1400.3.4", "   Small IN/OUT Buffer",                                 0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_ALL, sizeof(KSDS3D_LISTENER_ALL)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_ALL_4, "{FD09E34F-F620-4d43-9E30-C31511470EC2}"},
    { "1400.3.5", "   Out buffer Large",                                       0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_ALL, sizeof(KSDS3D_LISTENER_ALL)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_ALL_5, "{87BC12C5-4E45-4b52-830C-512A8F468C1E}"},
    { "1400.3.6", "   Invalid RolloffFactor - MIN-1",                     0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_ALL, sizeof(KSDS3D_LISTENER_ALL)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_ALL_6, "{1DBA0717-5999-4352-8B8D-B15220381599}"},
    { "1400.3.7", "   Invalid RolloffFactor - MAX+1",                    0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_ALL, sizeof(KSDS3D_LISTENER_ALL)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_ALL_7, "{8D47E7F9-44C1-4a29-8B31-2B6BC6342E92}"},
    { "1400.3.8", "   Invalid DopplerFactor - MIN-1",                   0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_ALL, sizeof(KSDS3D_LISTENER_ALL)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_ALL_8, "{34C384E9-9413-4f60-AF54-A4BCD3C8A5E7}"},
    { "1400.3.9", "   Invalid DopplerFactor - MAX+1",                  0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_ALL, sizeof(KSDS3D_LISTENER_ALL)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_ALL_9, "{EB1452D4-E154-4a89-A715-9933A36E1F22}"},
    { "1400.3.10", "   Invalid Distance Factor - (-1)",                   0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_ALL, sizeof(KSDS3D_LISTENER_ALL)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_ALL_10, "{C61D196C-5A86-483b-A7E0-11E91748A5DA}"},

    { "", "  KSPROPERTY_DIRECTSOUND3DLISTENER_DISTANCEFACTOR",   0, 0, 0, 0, NULL, "{00A62896-08FB-4e5b-9B31-ABFB5B8F6464}"},
    { "1400.4.1", "   Invalid Node ID - ULONG_MAX",                                  0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_DISTANCEFACTOR, sizeof(FLOAT)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_DISTANCEFACTOR_1, "{FFCA4F6E-FFA9-46b5-8920-C3026B9864F2}"},
    { "1400.4.2", "   Invalid Node ID - 0x80000001",                                   0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_DISTANCEFACTOR, sizeof(FLOAT)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_DISTANCEFACTOR_2, "{E92EF3AE-F75A-4e71-A06C-F3B3901806AC}"},
    { "1400.4.3", "   NULL IN/OUT Buffer",                                                  0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_DISTANCEFACTOR, sizeof(FLOAT)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_DISTANCEFACTOR_3, "{F70D7E87-EC04-443f-98D4-21B40E3E9D85}"},
    { "1400.4.4", "   Small IN/OUT Buffer",                                                 0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_DISTANCEFACTOR, sizeof(FLOAT)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_DISTANCEFACTOR_4, "{C5325D27-3795-49f0-81B2-31A362E6617C}"},
    { "1400.4.5", "   Out buffer Large",                                                       0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_DISTANCEFACTOR, sizeof(FLOAT)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_DISTANCEFACTOR_5, "{0DFA9C7D-EEF6-40da-ABA3-BF8A8066CF0E}"},

    { "", "  KSPROPERTY_DIRECTSOUND3DLISTENER_DOPPLERFACTOR",   0, 0, 0, 0, NULL, "{E522B087-9D49-4a81-BAA7-92F09EB12115}"},
    { "1400.5.1", "   Invalid Node ID - ULONG_MAX",                                 0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_DOPPLERFACTOR, sizeof(FLOAT)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_DOPPLERFACTOR_1, "{838F5C3F-C6EE-417b-B97F-F63F66F568F4}"},
    { "1400.5.2", "   Invalid Node ID - 0x80000001",                                 0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_DOPPLERFACTOR, sizeof(FLOAT)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_DOPPLERFACTOR_2, "{DDB829DB-865E-4dc2-A2A5-979FE201E7AD}"},
    { "1400.5.3", "   NULL IN/OUT Buffer",                                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_DOPPLERFACTOR, sizeof(FLOAT)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_DOPPLERFACTOR_3, "{A79D8823-FD27-4930-82C9-E18855D47254}"},
    { "1400.5.4", "   Small IN/OUT Buffer",                                              0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_DOPPLERFACTOR, sizeof(FLOAT)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_DOPPLERFACTOR_4, "{4832389F-0B6A-467d-AEC1-C8B61C13CC1A}"},
    { "1400.5.5", "   Out buffer Large",                                                     0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_DOPPLERFACTOR, sizeof(FLOAT)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_DOPPLERFACTOR_5, "{3EF7941C-292C-4795-8E52-371182DA36E5}"},
    { "1400.5.6", "   Invalid Doppler factor - MIN-1",                                0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_DOPPLERFACTOR, sizeof(FLOAT)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_DOPPLERFACTOR_6, "{0569C75F-85C8-4e60-B96D-2FA49E75B87C}"},
    { "1400.5.7", "   Invalid Doppler factor - MAX+1",                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_DOPPLERFACTOR, sizeof(FLOAT)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_DOPPLERFACTOR_7, "{835EBBB4-16A4-4fcb-8C63-457BAC9669FC}"},

    { "", "  KSPROPERTY_DIRECTSOUND3DLISTENER_ORIENTATION",     0, 0, 0, 0, NULL, "{4D79E546-3AE9-47fa-987D-97FA60066438}"},
    { "1400.6.1", "   Invalid Node ID - ULONG_MAX",                              0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_ORIENTATION, sizeof(KSDS3D_LISTENER_ORIENTATION)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_ORIENTATION_1, "{D1BAE0C4-7C4E-4df8-8194-E4D6D45A9FD8}"},
    { "1400.6.2", "   Invalid Node ID - 0x80000001",                              0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_ORIENTATION, sizeof(KSDS3D_LISTENER_ORIENTATION)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_ORIENTATION_2, "{46DB7584-B7D1-4ea4-A671-271F09E349C1}"},
    { "1400.6.3", "   NULL IN/OUT Buffer",                                             0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_ORIENTATION, sizeof(KSDS3D_LISTENER_ORIENTATION)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_ORIENTATION_3, "{3A5729E3-4BCB-4e77-9F15-FFCA32E13F76}"},
    { "1400.6.4", "   Small IN/OUT Buffer",                                            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_ORIENTATION, sizeof(KSDS3D_LISTENER_ORIENTATION)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_ORIENTATION_4, "{60E0F923-D6B0-4f21-B94D-398C1591D7F9}"},
    { "1400.6.5", "   Out buffer Large",                                                 0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_ORIENTATION, sizeof(KSDS3D_LISTENER_ORIENTATION)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_ORIENTATION_5, "{66423753-170D-4381-9D76-7D7E96A4A3CD}"},

    { "", "  KSPROPERTY_DIRECTSOUND3DLISTENER_POSITION",        0, 0, 0, 0, NULL, "{8DE442CD-085F-4132-A620-1C486DD182E3}"},
    { "1400.7.1", "   Invalid Node ID - ULONG_MAX",             0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_POSITION, sizeof(DS3DVECTOR)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_POSITION_1, "{07A47A70-8703-43bf-BE3D-82405B9ADFDF}"},
    { "1400.7.2", "   Invalid Node ID - 0x80000001",            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_POSITION, sizeof(DS3DVECTOR)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_POSITION_2, "{EEEF03AE-149B-42dd-8BC8-F317B4F941EB}"},
    { "1400.7.3", "   NULL IN/OUT Buffer",                      0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_POSITION, sizeof(DS3DVECTOR)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_POSITION_3, "{548BA212-78A3-4552-B48C-16277C74A5E4}"},
    { "1400.7.4", "   Small IN/OUT Buffer",                     0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_POSITION, sizeof(DS3DVECTOR)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_POSITION_4, "{F2E5ABB7-6BFF-4866-99A3-09DC327A51B1}"},
    { "1400.7.5", "   Out buffer Large",                        0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_POSITION, sizeof(DS3DVECTOR)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_POSITION_5, "{9966C175-361F-4361-9282-A2C9F776FA43}"},

    { "", "  KSPROPERTY_DIRECTSOUND3DLISTENER_ROLLOFFFACTOR",   0, 0, 0, 0, NULL, "{2E0EEDD4-9056-4deb-8BFE-9183E0D451C5}"},
    { "1400.8.1", "   Invalid Node ID - ULONG_MAX",             0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_ROLLOFFFACTOR, sizeof(FLOAT)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_ROLLOFFFACTOR_1, "{74B9C929-256F-40ac-9324-B405897D7F44}"},
    { "1400.8.2", "   Invalid Node ID - 0x80000001",            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_ROLLOFFFACTOR, sizeof(FLOAT)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_ROLLOFFFACTOR_2, "{DD887902-FCA6-4518-979C-475E2D10DDE4}"},
    { "1400.8.3", "   NULL IN/OUT Buffer",                      0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_ROLLOFFFACTOR, sizeof(FLOAT)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_ROLLOFFFACTOR_3, "{D603BA2E-F6B4-4bd6-AD5E-22BCE7EC21F4}"},
    { "1400.8.4", "   Small IN/OUT Buffer",                     0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_ROLLOFFFACTOR, sizeof(FLOAT)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_ROLLOFFFACTOR_4, "{66136181-41B8-44a4-8E33-A3569E736991}"},
    { "1400.8.5", "   Out buffer Large",                        0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_ROLLOFFFACTOR, sizeof(FLOAT)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_ROLLOFFFACTOR_5, "{F7A426F4-82A2-41ef-8733-4FBC2921E63C}"},
    { "1400.8.6", "   Invalid rolloff factor - FLT_MIN",        0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_ROLLOFFFACTOR, sizeof(FLOAT)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_ROLLOFFFACTOR_6, "{EF1BE54E-B49D-4b53-93BA-3EB19F80FF99}"},
    { "1400.8.7", "   Invalid rolloff factor - FLT_MAX",        0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_ROLLOFFFACTOR, sizeof(FLOAT)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_ROLLOFFFACTOR_7, "{A9AFAD1E-5EA6-48fc-A77C-B1B5C95B5C84}"},

    { "", "  KSPROPERTY_DIRECTSOUND3DLISTENER_VELOCITY",        0, 0, 0, 0, NULL, "{5E0A0799-52B7-4d16-AE66-3FCFF751FF8D}"},
    { "1400.9.1", "   Invalid Node ID - ULONG_MAX",             0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_VELOCITY, sizeof(DS3DVECTOR)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_VELOCITY_1, "{F0CCC7BB-D8EB-445e-9649-B625861649CD}"},
    { "1400.9.2", "   Invalid Node ID - 0x80000001",            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_VELOCITY, sizeof(DS3DVECTOR)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_VELOCITY_2, "{68C79700-B6B7-49d5-860D-ED55CED0FF29}"},
    { "1400.9.3", "   NULL IN/OUT Buffer",                      0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_VELOCITY, sizeof(DS3DVECTOR)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_VELOCITY_3, "{B6D65322-538F-420f-91AB-7085B8B07CD4}"},
    { "1400.9.4", "   Small IN/OUT Buffer",                     0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_VELOCITY, sizeof(DS3DVECTOR)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_VELOCITY_4, "{835B6C0C-BB1E-43c0-9335-06D79CBD7E0A}"},
    { "1400.9.5", "   Out buffer Large",                        0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_VELOCITY, sizeof(DS3DVECTOR)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_VELOCITY_5, "{DC1106BC-4B60-4145-B542-7D3D657C6E42}"},

    //KSPROPSETID_Synth	
    { "",   " KSPROPSETID_Synth",						0, 0, 0, 0, NULL, "{16AEFF18-05D8-49b6-843C-6F9AF0B73C16}"},

    { "", "  KSPROPERTY_SYNTH_CAPS",				            0, 0, 0, 0, NULL, "{9F78EA66-D65C-4eb2-883D-B400AA59445B}"},
    { "1500.1.1", "   Invalid Node ID - ULONG_MAX",	            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_CAPS, sizeof(SYNTHCAPS)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYNTH_CAPS_1, "{3031EB25-4D90-4454-B1D3-5E95D8E6D83F}"},
    { "1500.1.2", "   Invalid Node ID - 0x80000001",		    0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_CAPS, sizeof(SYNTHCAPS)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYNTH_CAPS_2, "{959CD575-D4CD-4138-BC20-BAD985B7A77F}"},
    { "1500.1.3", "   Out buffer NULL",						  0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_CAPS, sizeof(SYNTHCAPS)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYNTH_CAPS_3, "{87F35E76-D2ED-484b-90BB-DB82D7811F2D}"},
    { "1500.1.4", "   Out buffer Small",                                    0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_CAPS, sizeof(SYNTHCAPS)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYNTH_CAPS_4, "{BD6FD9BF-2CAA-4e93-89B1-5978BE81AEE4}"},
    { "1500.1.5", "   Out buffer Large",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_CAPS, sizeof(SYNTHCAPS)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYNTH_CAPS_5, "{92DE9AAA-B1CE-4ffe-B908-D0752C5839E8}"},

    { "", "  KSPROPERTY_SYNTH_CHANNELGROUPS",				    0, 0, 0, 0, NULL, "{38E05C4E-5FAD-4e56-855B-1D38E318CCE1}"},
    { "1500.2.1", "   Invalid Node ID - ULONG_MAX",			    0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_CHANNELGROUPS, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYNTH_CHANNELGROUPS_1, "{8A8CF3FC-CBFB-4ee5-A952-78B6D602AFD2}"},
    { "1500.2.2", "   Invalid Node ID - 0x80000001",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_CHANNELGROUPS, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYNTH_CHANNELGROUPS_2, "{083CA500-B559-45ad-9B72-55C8B25A7A06}"},
    { "1500.2.3", "   Invalid Channel Group - 0xFFFFFFFE",	    0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_CHANNELGROUPS, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYNTH_CHANNELGROUPS_3, "{C4CB835A-34FA-4f52-A986-CB7971337B4A}"},
    { "1500.2.4", "   NULL IN/OUT Buffer",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_CHANNELGROUPS, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYNTH_CHANNELGROUPS_4, "{78F9B9A0-F08D-40f7-8997-FADA05A9909B}"},
    { "1500.2.5", "   Small IN/OUT Buffer",                     0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_CHANNELGROUPS, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYNTH_CHANNELGROUPS_5, "{A3DE9406-B7D3-4206-8F82-E0B2F3B5A549}"},
    { "1500.2.6", "   Out buffer Large",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_CHANNELGROUPS, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYNTH_CHANNELGROUPS_6, "{0AF61B87-27EF-40aa-A568-20217384FF60}"},
    { "1500.2.7", "   Invalid Channel Group - 0x80000001",	    0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_CHANNELGROUPS, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYNTH_CHANNELGROUPS_7, "{F8EAC02A-5C19-47c1-86DF-E4CD90E40CE2}"},

    { "", "  KSPROPERTY_SYNTH_LATENCYCLOCK",				    0, 0, 0, 0, NULL, "{D2897807-B649-46e2-B41B-243E5A59D44B}"},
    { "1500.3.1", "   Invalid Node ID - ULONG_MAX",			    0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_LATENCYCLOCK, sizeof(ULONGLONG)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYNTH_LATENCYCLOCK_1, "{98AEDC6A-5F7F-4097-AEE8-C7987EAA633B}"},
    { "1500.3.2", "   Invalid Node ID - 0x80000001",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_LATENCYCLOCK, sizeof(ULONGLONG)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYNTH_LATENCYCLOCK_2, "{86763ECA-D250-4a26-B880-35BE9292C1D6}"},
    { "1500.3.5", "   Out Buffer NULL",						    0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_LATENCYCLOCK, sizeof(ULONGLONG)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYNTH_LATENCYCLOCK_3, "{AA499CDF-1CFF-4667-AE8E-CADAD5DDF7FE}"},
    { "1500.3.6", "   Out Buffer Small",                        0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_LATENCYCLOCK, sizeof(ULONGLONG)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYNTH_LATENCYCLOCK_4, "{D86046BA-841D-4b5f-8079-94AD335A2509}"},
    { "1500.3.7", "   Out buffer Large",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_LATENCYCLOCK, sizeof(ULONGLONG)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYNTH_LATENCYCLOCK_5, "{90EDAD0B-FAB4-44e3-8781-546F0EB891BB}"},

    { "", "  KSPROPERTY_SYNTH_MASTERCLOCK",				        0, 0, 0, 0, NULL, "{3B75C90B-726F-4fcf-A2E4-5BA5AF4D3A80}"},
    { "1500.4.1", "   Out Buffer NULL",			                0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_SynthClock, KSPROPERTY_SYNTH_MASTERCLOCK, sizeof(ULONGLONG)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYNTH_MASTERCLOCK_1, "{CC16DBB3-84F7-44e6-9561-B430177B19DD}"},
    { "1500.4.2", "   Out Buffer Small",			            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_SynthClock, KSPROPERTY_SYNTH_MASTERCLOCK, sizeof(ULONGLONG)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYNTH_MASTERCLOCK_2, "{AA043967-6E4E-47e6-9810-1C9EA5642DF5}"},
    { "1500.4.3", "   Out buffer Large",			            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_SynthClock, KSPROPERTY_SYNTH_MASTERCLOCK, sizeof(ULONGLONG)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYNTH_MASTERCLOCK_3, "{75C1EAEC-8C95-4e37-AE84-DDD11E666280}"},

    { "", "  KSPROPERTY_SYNTH_PORTPARAMETERS",				    0, 0, 0, 0, NULL, "{4D4A61EA-E7F4-4a77-B1BD-52690D6D2489}"},
    { "1500.5.1", "   Invalid Node ID - ULONG_MAX",			    0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_PORTPARAMETERS, sizeof(SYNTH_PORTPARAMS)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYNTH_PORTPARAMETERS_1, "{E1851FC2-E106-48be-ABCE-8087001C2238}"},
    { "1500.5.2", "   Invalid Node ID - 0x80000001",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_PORTPARAMETERS, sizeof(SYNTH_PORTPARAMS)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYNTH_PORTPARAMETERS_2, "{B2D38440-94F4-488c-83CB-8431E44D2326}"},
    { "1500.5.3", "   Out Buffer NULL",						    0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_PORTPARAMETERS, sizeof(SYNTH_PORTPARAMS)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYNTH_PORTPARAMETERS_3, "{CB05906D-FABB-4bce-BE54-917D4F8BD76D}"},
    { "1500.5.4", "   Out Buffer Small",                        0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_PORTPARAMETERS, sizeof(SYNTH_PORTPARAMS)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYNTH_PORTPARAMETERS_4, "{1EE33611-3716-46ee-A0B7-943AB6A6DD0B}"},
    { "1500.5.5", "   Out buffer Large",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_PORTPARAMETERS, sizeof(SYNTH_PORTPARAMS)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYNTH_PORTPARAMETERS_5, "{4422F021-8C1C-4e94-A1C2-8BB24D5584C7}"},
    { "1500.5.6", "   Invalid Channel Groups - ULONG_MAX",	    0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_PORTPARAMETERS, sizeof(SYNTH_PORTPARAMS)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYNTH_PORTPARAMETERS_6, "{E8124388-1BEB-4011-AAA7-8D60D3786907}"},
    { "1500.5.7", "   Invalid Channel Groups - 0x80000001",     0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_PORTPARAMETERS, sizeof(SYNTH_PORTPARAMS)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYNTH_PORTPARAMETERS_7, "{E330CFB8-E772-417c-8182-6E86D496FBE2}"},
    { "1500.5.8", "   Invalid Channel ID - ULONG_MAX",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_PORTPARAMETERS, sizeof(SYNTH_PORTPARAMS)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYNTH_PORTPARAMETERS_8, "{1F39F260-5E83-4c08-94FE-3A0808BED0F1}"},
    { "1500.5.9", "   Invalid Channel ID - 0x80000001",         0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_PORTPARAMETERS, sizeof(SYNTH_PORTPARAMS)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYNTH_PORTPARAMETERS_9, "{0AAEB6FB-0ECE-4693-85C0-45B7F3769B3F}"},
    { "1500.5.10", "   Invalid Sample Rate - ULONG_MAX",		0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_PORTPARAMETERS, sizeof(SYNTH_PORTPARAMS)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYNTH_PORTPARAMETERS_10, "{EE868701-34FD-4b37-BFAD-551E6D29341E}"},
    { "1500.5.11", "   Invalid Sample Rate - 0x80000001",       0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_PORTPARAMETERS, sizeof(SYNTH_PORTPARAMS)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYNTH_PORTPARAMETERS_11, "{D4A98CF2-C305-4d30-95FB-9CE8376CFF47}"},
    { "1500.5.12", "   Invalid Effects Flags - 0xFFFFFFFF",	    0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_PORTPARAMETERS, sizeof(SYNTH_PORTPARAMS)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYNTH_PORTPARAMETERS_12, "{C4052422-8C04-493d-92D7-D1FCB24FB192}"},

    { "1500.5.13", "   Invalid Voices - ULONG_MAX",             0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_PORTPARAMETERS, sizeof(SYNTH_PORTPARAMS)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYNTH_PORTPARAMETERS_13, "{A71474DA-D423-4794-B4B3-38716FAAE20B}"},
    { "1500.5.14", "   Invalid Voices - 0x80000001",	        0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_PORTPARAMETERS, sizeof(SYNTH_PORTPARAMS)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYNTH_PORTPARAMETERS_14, "{A1D5E9D3-0699-45a8-8DEF-2172E8B08323}"},


    { "", "  KSPROPERTY_SYNTH_RUNNINGSTATS",				    0, 0, 0, 0, NULL, "{55F76CF6-BB11-4024-86E5-E2332CC70218}"},
    { "1500.6.1", "   Invalid Node ID - ULONG_MAX",		        0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_RUNNINGSTATS, sizeof(SYNTH_STATS)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYNTH_RUNNINGSTATS_1, "{1AA5B4A7-4AF1-459e-998D-DB25F1F8B6FD}"},
    { "1500.6.2", "   Invalid Node ID - 0x80000001",		    0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_RUNNINGSTATS, sizeof(SYNTH_STATS)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYNTH_RUNNINGSTATS_2, "{02FF5B16-FF8A-4588-83B8-EBF70B374186}"},
    { "1500.6.3", "   Out Buffer NULL",						    0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_RUNNINGSTATS, sizeof(SYNTH_STATS)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYNTH_RUNNINGSTATS_3, "{B6BB4F41-A88F-49f2-B995-741A03190743}"},
    { "1500.6.4", "   Out Buffer Small",            		    0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_RUNNINGSTATS, sizeof(SYNTH_STATS)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYNTH_RUNNINGSTATS_4, "{A007DCFF-37E1-4666-B4B1-CB541792A1FB}"},
    { "1500.6.5", "   Out buffer Large",					    0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_RUNNINGSTATS, sizeof(SYNTH_STATS)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYNTH_RUNNINGSTATS_5, "{34A79F62-914E-4867-9983-F0B6B02F7B58}"},

    { "", "  KSPROPERTY_SYNTH_VOICEPRIORITY",				    0, 0, 0, 0, NULL, "{E2355A53-2091-49f9-A4C7-880D2558F20B}"},
    { "1500.7.1", "   Invalid Node ID - ULONG_MAX",			    0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_VOICEPRIORITY, sizeof(DWORD)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYNTH_VOICEPRIORITY_1, "{C495B1D5-194F-4c46-8FF6-7D28E7A515E0}"},
    { "1500.7.2", "   Invalid Node ID - 0x80000001",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_VOICEPRIORITY, sizeof(DWORD)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYNTH_VOICEPRIORITY_2, "{EBE505F5-6122-4c6e-9A53-E84D276F1366}"},
    { "1500.7.3", "   Invalid Channel ID - 0xFFFFFFFE",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_VOICEPRIORITY, sizeof(DWORD)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYNTH_VOICEPRIORITY_3, "{0361BE8F-EB07-4d4c-A21C-C35D7FB4DB1D}"},
    { "1500.7.4", "   Invalid Channel ID - 0x80000001",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_VOICEPRIORITY, sizeof(DWORD)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYNTH_VOICEPRIORITY_4, "{AB44F711-DD42-4894-BC4F-C627700942F6}"},
    { "1500.7.5", "   NULL IN/OUT Buffer",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_VOICEPRIORITY, sizeof(DWORD)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYNTH_VOICEPRIORITY_5, "{3CD3846B-583F-4b1d-8E63-A76655E1B473}"},
    { "1500.7.6", "   Small IN/OUT Buffer",                     0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_VOICEPRIORITY, sizeof(DWORD)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYNTH_VOICEPRIORITY_6, "{185A5888-3206-4e22-A8C9-DC7AF099DB88}"},
    { "1500.7.7", "   Out buffer Large",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_VOICEPRIORITY, sizeof(DWORD)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYNTH_VOICEPRIORITY_7, "{DDDE7C84-B337-4b42-A033-0C61A61D2BE9}"},
    { "1500.7.8", "   Invalid Voice Priority - 0x FFFFFFFF",	0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_VOICEPRIORITY, sizeof(DWORD)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYNTH_VOICEPRIORITY_8, "{CA6885BB-26B8-4509-BE7E-FF674C683E39}"},
    { "1500.7.9", "   Invalid Channel Group - 0xFFFFFFFE",      0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_VOICEPRIORITY, sizeof(DWORD)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYNTH_VOICEPRIORITY_9, "{8FC9098B-4B9F-4547-80DF-FDD96DE1E334}"},
    { "1500.7.10", "   Invalid Channel Group - 0x80000001",		0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_VOICEPRIORITY, sizeof(DWORD)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYNTH_VOICEPRIORITY_10, "{367DC697-2785-4bd4-93F6-0F5E5349410B}"},

    { "", "  KSPROPERTY_SYNTH_VOLUME",				            0, 0, 0, 0, NULL, "{1B6F9D79-9FCF-43e6-B583-C32E00FF6308}"},
    { "1500.8.1", "   NULL IN/OUT Buffer",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_VOLUME, sizeof(LONG)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYNTH_VOLUME_1, "{685AD07F-12F8-4ecc-90B5-CB76C382D7B9}"},
    { "1500.8.2", "   Small IN/OUT Buffer",                     0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_VOLUME, sizeof(LONG)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYNTH_VOLUME_2, "{8FCDE819-CDA6-4091-BA01-5802D99E0CBD}"},
    { "1500.8.3", "   Out buffer Large",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_VOLUME, sizeof(LONG)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYNTH_VOLUME_3, "{440CACFE-7274-48a0-B0F8-10FEB02B8F5C}"},

    { "", "  KSPROPERTY_SYNTH_VOLUMEBOOST",               0, 0, 0, 0, NULL, "{75734A5D-48E0-468d-ADA2-46B3F9F5B3C7}"},
    { "1500.9.1", "   Invalid Node ID - ULONG_MAX",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_VOLUMEBOOST, sizeof(LONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_NodeID_ULONGMAX, "{9B68E313-BA50-477a-A02F-2C35778DCEF7}"},
    { "1500.9.2", "   Invalid Node ID - 0x80000001",  			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_VOLUMEBOOST, sizeof(LONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_NodeID_0x80000001, "{470FC021-C6DB-4599-9E12-8C03CAF9D875}"},
    { "1500.9.3", "   NULL IN/OUT Buffer",  					0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_VOLUMEBOOST, sizeof(LONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_NULL_Buffer, "{90BCE734-16F0-41cd-AED6-1E58ACFF39EE}"},
    { "1500.9.4", "   Small IN/OUT Buffer",  					0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_VOLUMEBOOST, sizeof(LONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_Small_Buffer, "{02F3996B-4A28-4a65-B8FB-28BF4DD942FC}"},
    { "1500.9.5", "   Out buffer Large",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_VOLUMEBOOST, sizeof(LONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_Large_Buffer, "{45E4128C-1EC0-4221-9E29-7D454B365D3A}"},	

    //KSPROPSETID_Synth_Dls	
    { "",   " KSPROPSETID_Synth_Dls",						0, 0, 0, 0, NULL, "{73273F57-2A15-4a41-940A-414E2161CA7C}"},

    { "", "  KSPROPERTY_SYNTH_DLS_APPEND",               0, 0, 0, 0, NULL, "{E4590023-8D9A-49d4-8E87-1A7E9935A38A}"},
    { "1600.1.1", "   Invalid Node ID - ULONG_MAX",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth_Dls, KSPROPERTY_SYNTH_DLS_APPEND, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_NodeID_ULONGMAX, "{67C5F035-E48D-471a-900A-1D8D755E288F}"},
    { "1600.1.2", "   Invalid Node ID - 0x80000001",  			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth_Dls, KSPROPERTY_SYNTH_DLS_APPEND, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_NodeID_0x80000001, "{24F7057F-0DDD-4a9e-B3AC-2D930D97E646}"},
    { "1600.1.3", "   NULL IN/OUT Buffer",  					0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth_Dls, KSPROPERTY_SYNTH_DLS_APPEND, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_NULL_Buffer, "{ABE0B45B-D8EE-4a19-845A-53625A2A79E0}"},
    { "1600.1.4", "   Small IN/OUT Buffer",  					0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth_Dls, KSPROPERTY_SYNTH_DLS_APPEND, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_Small_Buffer, "{36EEF65D-24BA-44d8-9755-EA802056D39F}"},
    { "1600.1.5", "   Out buffer Large",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth_Dls, KSPROPERTY_SYNTH_DLS_APPEND, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_Large_Buffer, "{DB285B91-E85D-4a23-B8AA-837BD6FB7817}"},	

    { "", "  KSPROPERTY_SYNTH_DLS_COMPACT",                     0, 0, 0, 0, NULL, "{9DB47638-E980-4046-99F6-1954C62E2AC1}"},
    { "1600.2.1", "   Invalid Node ID - ULONG_MAX",             0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth_Dls, KSPROPERTY_SYNTH_DLS_COMPACT, 0),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYNTH_DLS_COMPACT_1, "{E10A330C-3E57-419d-9669-8D7405A2D84D}"},
    { "1600.2.2", "   Invalid Node ID - 0x80000001",            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth_Dls, KSPROPERTY_SYNTH_DLS_COMPACT, 0),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYNTH_DLS_COMPACT_2, "{973DA47D-2038-42fe-BD28-273B016B0C56}"},

    { "", "  KSPROPERTY_SYNTH_DLS_DOWNLOAD",                    0, 0, 0, 0, NULL, "{4E4CAB16-CCBB-44f9-AE12-F16388CDC81B}"},
    { "1600.3.1", "   Invalid Node ID - ULONG_MAX",             0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth_Dls, KSPROPERTY_SYNTH_DLS_DOWNLOAD, sizeof(SYNTHDOWNLOAD)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYNTH_DLS_DOWNLOAD_1, "{C430A68D-72DD-4d6a-8CF9-2BDD6AD888B7}"},
    { "1600.3.2", "   Invalid Node ID - 0x80000001",            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth_Dls, KSPROPERTY_SYNTH_DLS_DOWNLOAD, sizeof(SYNTHDOWNLOAD)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYNTH_DLS_DOWNLOAD_2, "{62BC70A0-6795-4e12-8211-E2350EC715C9}"},
    { "1600.3.3", "   Out buffer NULL",                         0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth_Dls, KSPROPERTY_SYNTH_DLS_DOWNLOAD, sizeof(SYNTHDOWNLOAD)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYNTH_DLS_DOWNLOAD_3, "{705F31F7-4CBD-44e8-BED8-0DA8DBF1F880}"},
    { "1600.3.4", "   Out buffer Small",                        0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth_Dls, KSPROPERTY_SYNTH_DLS_DOWNLOAD, sizeof(SYNTHDOWNLOAD)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYNTH_DLS_DOWNLOAD_4, "{EC17BED0-BD83-4653-8730-4A11F8C31B4E}"},
    { "1600.3.5", "   Out buffer Large",                        0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth_Dls, KSPROPERTY_SYNTH_DLS_DOWNLOAD, sizeof(SYNTHDOWNLOAD)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYNTH_DLS_DOWNLOAD_5, "{742F34BB-887B-4d60-8AE1-E2285B272795}"},
    { "1600.3.6", "   Synth buffer NULL",                       0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth_Dls, KSPROPERTY_SYNTH_DLS_DOWNLOAD, sizeof(SYNTHDOWNLOAD)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYNTH_DLS_DOWNLOAD_6, "{44899498-80B1-486a-B123-FC60F24E13BC}"},
    { "1600.3.7", "   Synth buffer Small",                      0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth_Dls, KSPROPERTY_SYNTH_DLS_DOWNLOAD, sizeof(SYNTHDOWNLOAD)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYNTH_DLS_DOWNLOAD_7, "{7C57A8A4-A719-4256-A77A-F9879221436B}"},


    { "", "  KSPROPERTY_SYNTH_DLS_UNLOAD",                      0, 0, 0, 0, NULL, "{3A942039-021A-4158-942D-9ADF89039321}"},
    { "1600.4.1", "   Invalid Node ID - ULONG_MAX",             0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth_Dls, KSPROPERTY_SYNTH_DLS_UNLOAD, sizeof(HANDLE)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYNTH_DLS_UNLOAD_1, "{1698BED1-C6CC-403b-944B-706DE0C385D1}"},
    { "1600.4.2", "   Invalid Node ID - 0x80000001",            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth_Dls, KSPROPERTY_SYNTH_DLS_UNLOAD, sizeof(HANDLE)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYNTH_DLS_UNLOAD_2, "{61487FE7-486E-4f6c-A9C1-A82C734D4925}"},
    { "1600.4.3", "   Invalid Handle - NULL",                   0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth_Dls, KSPROPERTY_SYNTH_DLS_UNLOAD, sizeof(HANDLE)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYNTH_DLS_UNLOAD_3, "{60D94B61-08FD-4fb5-8F46-876C3DDC542F}"},
    //  { "1600.4.4", "   Invalid Handle - ULONG_MAX",          0, 0, 0,
    //    GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth_Dls, KSPROPERTY_SYNTH_DLS_UNLOAD, sizeof(HANDLE)),
    //    (TESTFNPROC)Generic_Property_KSPROPERTY_SYNTH_DLS_UNLOAD_4, "{FDD96331-431A-42b5-8E2C-9D39B54E6D28}"},

    { "", "  KSPROPERTY_SYNTH_DLS_WAVEFORMAT",                  0, 0, 0, 0, NULL, "{0CB3E16C-2105-41e3-B018-C7C81A5D8F2F}"},
    { "1600.5.1", "   Invalid Node ID - ULONG_MAX",             0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth_Dls, KSPROPERTY_SYNTH_DLS_WAVEFORMAT, sizeof(WAVEFORMATEX)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYNTH_DLS_WAVEFORMAT_1, "{50E6CCEA-1C0B-4fb3-8467-EA5B2050A593}"},
    { "1600.5.2", "   Invalid Node ID - 0x80000001",            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth_Dls, KSPROPERTY_SYNTH_DLS_WAVEFORMAT, sizeof(WAVEFORMATEX)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYNTH_DLS_WAVEFORMAT_2, "{948CC394-94D4-4c68-819F-344B9AD2EC30}"},
    //  { "1600.5.3", "   Invalid Channel ID - 0xFFFFFFFE",         0, 0, 0,
    //    GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth_Dls, KSPROPERTY_SYNTH_DLS_WAVEFORMAT, sizeof(WAVEFORMATEX)),
    //    (TESTFNPROC)Generic_Property_KSPROPERTY_SYNTH_DLS_WAVEFORMAT_3, "{89D521EF-E682-47f9-804F-C3CF36EC2691}"},
    //  { "1600.5.4", "   Invalid Channel ID - 0x80000001",         0, 0, 0,
    //    GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth_Dls, KSPROPERTY_SYNTH_DLS_WAVEFORMAT, sizeof(WAVEFORMATEX)),
    //    (TESTFNPROC)Generic_Property_KSPROPERTY_SYNTH_DLS_WAVEFORMAT_4, "{0E9323B9-F857-4b9e-B586-FE73FF7DB102}"},
    { "1600.5.3", "   Out buffer NULL",                         0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth_Dls, KSPROPERTY_SYNTH_DLS_WAVEFORMAT, sizeof(WAVEFORMATEX)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYNTH_DLS_WAVEFORMAT_3, "{FE36985D-1E10-4fbe-830D-33F3CB77613B}"},
    { "1600.5.4", "   Out buffer Small",                        0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth_Dls, KSPROPERTY_SYNTH_DLS_WAVEFORMAT, sizeof(WAVEFORMATEX)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYNTH_DLS_WAVEFORMAT_4, "{FE9AC560-2586-4e54-9981-1956C5119C9C}"},
    { "1600.5.5", "   Out buffer Large",                        0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth_Dls, KSPROPERTY_SYNTH_DLS_WAVEFORMAT, sizeof(WAVEFORMATEX)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_SYNTH_DLS_WAVEFORMAT_5, "{C2F5BB0E-74C3-48f2-9BE9-CA7C8A178E69}"},

    //KSPROPSETID_DrmAudioStream
    { "",   " KSPROPSETID_DrmAudioStream",                      0, 0, 0, 0, NULL, "{6A322910-3B36-4035-89CA-1B859504B28C}"},

    { "", "  KSPROPERTY_DRMAUDIOSTREAM_CONTENTID",              0, 0, 0, 0, NULL, "{BEF8BF21-3AE5-4533-8323-85344BE2FF64}"},
    { "1700.1.1", "   Invalid Content ID - ULONG_MAX",          0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DrmAudioStream, KSPROPERTY_DRMAUDIOSTREAM_CONTENTID, sizeof(KSDRMAUDIOSTREAM_CONTENTID)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DRMAUDIOSTREAM_CONTENTID_1, "{7866F451-8AEA-4334-9291-8028DAE61E23}"},
    { "1700.1.2", "   Invalid Content ID - 0x80000001",         0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DrmAudioStream, KSPROPERTY_DRMAUDIOSTREAM_CONTENTID, sizeof(KSDRMAUDIOSTREAM_CONTENTID)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DRMAUDIOSTREAM_CONTENTID_2, "{C71B8A2A-D974-48f8-9A23-1424AF5E8D7F}"},
    { "1700.1.3", "   NULL IN/OUT Buffer",                      0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DrmAudioStream, KSPROPERTY_DRMAUDIOSTREAM_CONTENTID, sizeof(KSDRMAUDIOSTREAM_CONTENTID)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DRMAUDIOSTREAM_CONTENTID_3, "{8FB45D07-5587-4cca-9193-7717B19942A8}"},
    { "1700.1.4", "   Small IN/OUT Buffer",                     0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DrmAudioStream, KSPROPERTY_DRMAUDIOSTREAM_CONTENTID, sizeof(KSDRMAUDIOSTREAM_CONTENTID)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DRMAUDIOSTREAM_CONTENTID_4, "{D9DC83A7-871A-4f60-81ED-EA43C6CA591F}"},
    { "1700.1.5", "   Out buffer Large",                        0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DrmAudioStream, KSPROPERTY_DRMAUDIOSTREAM_CONTENTID, sizeof(KSDRMAUDIOSTREAM_CONTENTID)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DRMAUDIOSTREAM_CONTENTID_5, "{19E35B6A-C214-4a91-BB2D-D68ABB730A16}"},
    { "1700.1.6", "   Context buffer NULL",                     0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DrmAudioStream, KSPROPERTY_DRMAUDIOSTREAM_CONTENTID, sizeof(KSDRMAUDIOSTREAM_CONTENTID)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DRMAUDIOSTREAM_CONTENTID_6, "{5A517285-F279-46cc-9710-1DD3A871F348}"},
    { "1700.1.7", "   Context buffer small",                    0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DrmAudioStream, KSPROPERTY_DRMAUDIOSTREAM_CONTENTID, sizeof(KSDRMAUDIOSTREAM_CONTENTID)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_DRMAUDIOSTREAM_CONTENTID_7, "{FF0F6864-B340-4de3-BAEA-247C6B9E1009}"},

// AudioGfx ended in XP
#if (NTDDI_VERSION < NTDDI_VISTA)
    //KSPROPSETID_AudioGfx
    { "",   " KSPROPSETID_AudioGfx",                            0, 0, 0, 0, NULL, "{28429094-85B6-4bfc-A865-BC30C53B3AE6}"},

    { "", "  KSPROPERTY_AUDIOGFX_CAPTURETARGETDEVICEID",        0, 0, 0, 0, NULL, "{04E71DEB-BB7B-4f78-9827-05F08F6B5235}"},
    { "1800.1.1", "   NULL String",                             0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioGfx,  KSPROPERTY_AUDIOGFX_CAPTURETARGETDEVICEID, sizeof(WCHAR[256])),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIOGFX_CAPTURETARGETDEVICEID_1, "{021355CA-0B30-4bd9-91F3-C1B0C2B2DB0A}"},
    { "1800.1.2", "   One char string",                         0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioGfx,  KSPROPERTY_AUDIOGFX_CAPTURETARGETDEVICEID, sizeof(WCHAR[256])),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIOGFX_CAPTURETARGETDEVICEID_2, "{111D28B9-3A5A-4d0c-A1C4-7553D9378F4E}"},
    //  { "1800.1.3", "   NULL IN/OUT Buffer",                      0, 0, 0,
    //    GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioGfx,  KSPROPERTY_AUDIOGFX_CAPTURETARGETDEVICEID, sizeof(WCHAR[256])),
    //    (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIOGFX_CAPTURETARGETDEVICEID_3, "{41DA1F09-20A0-4b63-AD0C-2CF26C9A6FCB}"},

    { "", "  KSPROPERTY_AUDIOGFX_RENDERTARGETDEVICEID",         0, 0, 0, 0, NULL, "{BCB09CBA-6AB9-4e49-A855-972EE90E138B}"},
    { "1800.2.1", "   NULL String",                             0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioGfx,  KSPROPERTY_AUDIOGFX_RENDERTARGETDEVICEID, sizeof(WCHAR[256])),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIOGFX_RENDERTARGETDEVICEID_1, "{6D2C8BED-9D5B-449a-8711-AAD384780360}"},
    { "1800.2.2", "   One char string",                         0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioGfx,  KSPROPERTY_AUDIOGFX_RENDERTARGETDEVICEID, sizeof(WCHAR[256])),
        (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIOGFX_RENDERTARGETDEVICEID_2, "{817BADCA-728A-4f47-8B5F-6705849BC260}"},
    //  { "1800.2.3", "   NULL IN/OUT Buffer",                      0, 0, 0,
    //    GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioGfx,  KSPROPERTY_AUDIOGFX_RENDERTARGETDEVICEID, sizeof(WCHAR[256])),
    //    (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_NULL_Buffer, "{B3EFAC1E-A3B5-4918-98AB-9328A4E2B761}"},
#endif // NTDDI_VERSION < NTDDI_VISTA

    // KSPROPSETID_Topology
    { "",   " KSPROPSETID_Topology",						0, 0, 0, 0, NULL, "{6a9d5807-d3b8-451f-95d7-b893f0c2439f}"},

    { "", "  KSPROPERTY_TOPOLOGY_NAME",						0, 0, 0, 0, NULL, "{98cabf6f-8b0f-432b-82a4-ccb8ab3590ac}"},
    { "500.1.1", "   Null string",							0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Topology, KSPROPERTY_TOPOLOGY_NAME, 0),
        (TESTFNPROC)Generic_Property_KSPROPERTY_TOPOLOGY_NAME_1, "{a4b20fd6-cbac-4b05-9ffc-5b9a4b734f08}"},
    { "500.1.2", "   One char string",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Topology, KSPROPERTY_TOPOLOGY_NAME, 0),
        (TESTFNPROC)Generic_Property_KSPROPERTY_TOPOLOGY_NAME_2, "{9b84993c-7689-46d5-a206-110ec57a790e}"},

    { "", "  KSPROPERTY_TOPOLOGY_CATEGORIES",               0, 0, 0, 0, NULL, "{DFF8728F-DAF9-42c3-AEC6-9502C5C0B497}"},
    { "500.2.1", "   Out buffer NULL",			            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Topology, KSPROPERTY_TOPOLOGY_CATEGORIES, sizeof(KSMULTIPLE_ITEM)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_TOPOLOGY_CATEGORIES_1, "{2E4A2CC5-1272-411c-899D-34DB5C186D44}"},
    { "500.2.2", "   Out buffer Small",  		            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Topology, KSPROPERTY_TOPOLOGY_CATEGORIES, sizeof(KSMULTIPLE_ITEM)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_TOPOLOGY_CATEGORIES_2, "{0D16484A-047C-4fea-B152-CC6B0A940A4D}"},
    { "500.2.3", "   Out buffer Large",  					0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Topology, KSPROPERTY_TOPOLOGY_CATEGORIES, sizeof(KSMULTIPLE_ITEM)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_TOPOLOGY_CATEGORIES_3, "{AF823BA2-76A7-4667-9B48-42E1113049E1}"},

    { "", "  KSPROPERTY_TOPOLOGY_CONNECTIONS",              0, 0, 0, 0, NULL, "{C8A54671-53CB-4c29-B098-6FE4F621F483}"},
    { "500.3.1", "   Out buffer NULL",			            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Topology, KSPROPERTY_TOPOLOGY_CONNECTIONS, sizeof(KSMULTIPLE_ITEM)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_TOPOLOGY_CONNECTIONS_1, "{651AC863-4319-4e7b-A763-B3077F381248}"},
    { "500.3.2", "   Out buffer Small",  		            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Topology, KSPROPERTY_TOPOLOGY_CONNECTIONS, sizeof(KSMULTIPLE_ITEM)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_TOPOLOGY_CONNECTIONS_2, "{4B058F34-0B21-46ed-B561-D32A28635006}"},
    { "500.3.3", "   Out buffer Large",  					0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Topology, KSPROPERTY_TOPOLOGY_CONNECTIONS, sizeof(KSMULTIPLE_ITEM)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_TOPOLOGY_CONNECTIONS_3, "{35CB6807-2CA9-42e0-B30E-4FD76A0D0833}"},

    { "", "  KSPROPERTY_TOPOLOGY_NODES",                    0, 0, 0, 0, NULL, "{E0C986AB-2554-4a42-AC67-72A798511420}"},
    { "500.4.1", "   Out buffer NULL",			            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Topology, KSPROPERTY_TOPOLOGY_NODES, sizeof(KSMULTIPLE_ITEM)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_TOPOLOGY_NODES_1, "{362E4C2E-7DA8-403e-AB3A-28C5FF93771B}"},
    { "500.4.2", "   Out buffer Small",  		            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Topology, KSPROPERTY_TOPOLOGY_NODES, sizeof(KSMULTIPLE_ITEM)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_TOPOLOGY_NODES_2, "{B0F0F2A0-8260-4273-8141-DE240834A84D}"},
    { "500.4.3", "   Out buffer Large",  					0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Topology, KSPROPERTY_TOPOLOGY_NODES, sizeof(KSMULTIPLE_ITEM)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_TOPOLOGY_NODES_3, "{415E53AA-11BC-483a-987A-15DC84CD3C2E}"},

    //KSPROPSETID_TopologyNode	
    { "",   " KSPROPSETID_TopologyNode",						0, 0, 0, 0, NULL, "{B35E645A-A93A-42e1-8A03-31863BF8CF2F}"},

    { "", "  KSPROPERTY_TOPOLOGYNODE_ENABLE",               0, 0, 0, 0, NULL, "{50DBA3A1-4C00-4a54-B996-34E0629451C8}"},
    { "1900.1.1", "   Invalid Node ID - ULONG_MAX",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_TopologyNode, KSPROPERTY_TOPOLOGYNODE_ENABLE, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_NodeID_ULONGMAX, "{1B9D80BA-9F3B-4ba1-AB56-D31C7ED82654}"},
    { "1900.1.2", "   Invalid Node ID - 0x80000001",  			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_TopologyNode, KSPROPERTY_TOPOLOGYNODE_ENABLE, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_NodeID_0x80000001, "{06433821-D3D2-4dff-A360-FA4E1B9EBFE3}"},
    { "1900.1.3", "   NULL IN/OUT Buffer",  					0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_TopologyNode, KSPROPERTY_TOPOLOGYNODE_ENABLE, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_NULL_Buffer, "{A09F248E-9D5E-4736-BB79-2097E795C542}"},
    { "1900.1.4", "   Small IN/OUT Buffer",  					0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_TopologyNode, KSPROPERTY_TOPOLOGYNODE_ENABLE, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_Small_Buffer, "{9E591860-4578-4d06-935D-5668337684F4}"},
    { "1900.1.5", "   Out buffer Large",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_TopologyNode, KSPROPERTY_TOPOLOGYNODE_ENABLE, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_Large_Buffer, "{164101E7-EEF9-4c87-8506-1329306CFA04}"},	

    { "", "  KSPROPERTY_TOPOLOGYNODE_RESET",               0, 0, 0, 0, NULL, "{9075B7C5-2C81-4ac6-A7C7-69C422744216}"},
    { "1900.2.1", "   Invalid Node ID - ULONG_MAX",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_TopologyNode, KSPROPERTY_TOPOLOGYNODE_RESET, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_NodeID_ULONGMAX, "{AD4C7CF4-C19D-44dd-9827-A08E10163A34}"},
    { "1900.2.2", "   Invalid Node ID - 0x80000001",  			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_TopologyNode, KSPROPERTY_TOPOLOGYNODE_RESET, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_NodeID_0x80000001, "{6C84159B-81DB-4c61-9F71-B4327F1AFFB3}"},
    { "1900.2.3", "   NULL IN/OUT Buffer",  					0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_TopologyNode, KSPROPERTY_TOPOLOGYNODE_RESET, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_NULL_Buffer, "{9EBD54BA-B806-494c-9FC3-A2F4C79E5D6E}"},
    { "1900.2.4", "   Small IN/OUT Buffer",  					0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_TopologyNode, KSPROPERTY_TOPOLOGYNODE_RESET, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_Small_Buffer, "{880C7304-07FE-4299-922A-159DAB775BFF}"},
    { "1900.2.5", "   Out buffer Large",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_TopologyNode, KSPROPERTY_TOPOLOGYNODE_RESET, sizeof(BOOL)),
        (TESTFNPROC)Generic_Property_KSNODEPROPERTYULONG_Large_Buffer, "{308F9E32-3AAD-4f0d-8EA4-C00EF7378BA2}"},	

    // KSPROPSETID_Connection
    { "",   " KSPROPSETID_Connection",						0, 0, 0, 0, NULL, "{9B04C1E6-6FFE-4685-81AB-DAD532BFB0A0}"},

    { "", "  KSPROPERTY_CONNECTION_DATAFORMAT",				0, 0, 0, 0, NULL, "{d1256bdf-7405-468a-bfcf-0cff3a10b83f}"},
    { "300.1.1", "   Zero size out buffer",					0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Connection, KSPROPERTY_CONNECTION_DATAFORMAT, sizeof(KSDATAFORMAT)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_CONNECTION_DATAFORMAT_1, "{06e2b5aa-9f57-49b1-8c64-f46c00b6a9aa}"},
    { "300.1.2", "   Invalid bit depth",					0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Connection, KSPROPERTY_CONNECTION_DATAFORMAT, sizeof(KSDATAFORMAT)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_CONNECTION_DATAFORMAT_2, "{18563b10-fb46-4d1f-aeba-5d0b83047303}"},
    { "300.1.3", "   Invalid no. of channels",				0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Connection, KSPROPERTY_CONNECTION_DATAFORMAT, sizeof(KSDATAFORMAT)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_CONNECTION_DATAFORMAT_3, "{78f76557-69c5-4b02-a088-6409713583fa}"},
    { "300.1.4", "   Four bytes out buffer",				0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Connection, KSPROPERTY_CONNECTION_DATAFORMAT, sizeof(KSDATAFORMAT)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_CONNECTION_DATAFORMAT_4, "{A686D5BF-498D-4cdf-9BAF-92364FB839B5}"},
    { "300.1.5", "   Missing specifier struct in the out buffer",	0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Connection, KSPROPERTY_CONNECTION_DATAFORMAT, sizeof(KSDATAFORMAT)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_CONNECTION_DATAFORMAT_5, "{37C2DA14-7442-4212-AFE8-B5A3FCA3151E}"},
    { "300.1.6", "   Sending invalid format size",	0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Connection, KSPROPERTY_CONNECTION_DATAFORMAT, sizeof(KSDATAFORMAT)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_CONNECTION_DATAFORMAT_6, "{70E334D0-65EC-4529-AE08-6C828E32F5C2}"},
    // TODO: in future add more test cases same as we did in the case of KSPROPERTY_PIN_DATAINTERSECTION.

    { "", "  KSPROPERTY_CONNECTION_STATE",					0, 0, 0, 0, NULL, "{052b76c7-b1e3-4d80-918d-e7edf1d1e1cb}"},
    { "300.2.1", "   Invalid state",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Connection, KSPROPERTY_CONNECTION_STATE, sizeof(KSSTATE)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_CONNECTION_STATE_1, "{3edcd7f0-cc8d-469c-af54-bb147380a411}"},

    { "", "  KSPROPERTY_CONNECTION_PROPOSEDATAFORMAT",              0, 0, 0, 0, NULL, "{AFCE1A3E-E05D-42e2-91B2-555B6BCBE68C}"},
    { "300.3.1", "   Zero size out buffer",                 0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Connection, KSPROPERTY_CONNECTION_PROPOSEDATAFORMAT, sizeof(KSDATAFORMAT)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_CONNECTION_DATAFORMAT_1, "{B00369C0-A5CD-4cb4-80B7-F2CEEE2DB7D8}"},
    { "300.3.2", "   Invalid bit depth",                    0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Connection, KSPROPERTY_CONNECTION_PROPOSEDATAFORMAT, sizeof(KSDATAFORMAT)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_CONNECTION_DATAFORMAT_2, "{F9B293F3-21D5-4426-8A40-0C42407E9BE7}"},
    { "300.3.3", "   Invalid no. of channels",              0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Connection, KSPROPERTY_CONNECTION_PROPOSEDATAFORMAT, sizeof(KSDATAFORMAT)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_CONNECTION_DATAFORMAT_3, "{7C47DE24-2496-4502-A1E4-1BE6607359AB}"},
    { "300.3.4", "   Four bytes out buffer",                0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Connection, KSPROPERTY_CONNECTION_PROPOSEDATAFORMAT, sizeof(KSDATAFORMAT)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_CONNECTION_DATAFORMAT_4, "{FF27D1AA-3ABC-4437-98C8-0AA7B55A28F7}"},
    { "300.3.5", "   Missing specifier struct in the out buffer",   0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Connection, KSPROPERTY_CONNECTION_PROPOSEDATAFORMAT, sizeof(KSDATAFORMAT)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_CONNECTION_DATAFORMAT_5, "{039F1C9B-DBE4-4387-BC61-9AEF4B05C1F4}"},

    { "", "  KSPROPERTY_CONNECTION_PRIORITY",              0, 0, 0, 0, NULL, "{2B095D1A-FDCE-4aba-AE18-B3ED2CFCD3D2}"},
    { "300.4.1", "   NULL Buffer",              0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Connection, KSPROPERTY_CONNECTION_PRIORITY, sizeof(KSPRIORITY)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_CONNECTION_PRIORITY_1, "{7F5533A8-3B23-4746-A944-14081F903CEA}"},
    { "300.4.2", "   Small Buffer",             0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Connection, KSPROPERTY_CONNECTION_PRIORITY, sizeof(KSPRIORITY)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_CONNECTION_PRIORITY_2, "{AFE20CCF-3758-4812-BB9D-017CD651F89F}"},
    { "300.4.3", "   Large Buffer",             0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Connection, KSPROPERTY_CONNECTION_PRIORITY, sizeof(KSPRIORITY)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_CONNECTION_PRIORITY_3, "{A6B06B96-F90C-4ab1-A929-0882C0587D5C}"},
    { "300.4.4", "   Valid test",                 0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Connection, KSPROPERTY_CONNECTION_PRIORITY, sizeof(KSPRIORITY)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_CONNECTION_PRIORITY_4, "{9C6595CA-6B5F-4753-B0BE-42F367FCDAE4}"},
    { "300.4.5", "   Invalid data",             0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Connection, KSPROPERTY_CONNECTION_PRIORITY, sizeof(KSPRIORITY)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_CONNECTION_PRIORITY_5, "{FBCA30B6-B6CE-4d06-8500-E26084622D8A}"},

    // KSPROPSETID_Pin
    { "",   " KSPROPSETID_Pin",								0, 0, 0, 0, NULL, "{748a65b9-8162-47a9-8095-ddd0060188d2}"},

    { "", "  KSPROPERTY_PIN_DATAINTERSECTION",				0, 0, 0, 0, NULL, "{1FF58F2D-0FF5-467f-8860-F21167B82AC6}"},
    { "400.1.1", "   In buffer small",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin, KSPROPERTY_PIN_DATAINTERSECTION, sizeof(KSDATAFORMAT)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_DATAINTERSECTION_1, "{9e20fb79-5d4c-428f-83bc-a367aedfd0ce}"},
    { "400.1.2", "   Missing specifier",					0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin, KSPROPERTY_PIN_DATAINTERSECTION, sizeof(KSDATAFORMAT)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_DATAINTERSECTION_2, "{2ec257cc-e435-4301-b9a6-461778c73c60}"},
    { "400.1.3", "   Passing Large Range size",					       0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin, KSPROPERTY_PIN_DATAINTERSECTION, sizeof(KSDATAFORMAT)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_DATAINTERSECTION_3, "{aa575f6b-e996-42d0-9285-a955b5d50dbd}"},
    { "400.1.4", "   Out size less than specifier required size",					0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin, KSPROPERTY_PIN_DATAINTERSECTION, sizeof(KSDATAFORMAT)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_DATAINTERSECTION_4, "{A8518EAD-D117-41d9-BD0D-D6EC12BE25F8}"},
    // TODO: needs to find that if we supply multiple count  = 0x80000000, will ti work or not? - in test when we supply count = 0x8000000, it passes and not fails
    //	{ "400.1.5", "   Multiple items count overflow check",			0, 0, 0,
    //  GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin, KSPROPERTY_PIN_DATAINTERSECTION, sizeof(KSDATAFORMAT)),
    //  (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_DATAINTERSECTION_5, "{86B0DB00-1C1E-44d6-A6D0-491E73BA7E68}"},
    { "400.1.6", "   Bad pin factory id - one more then reported by Filter",          0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin, KSPROPERTY_PIN_DATAINTERSECTION, sizeof(KSDATAFORMAT)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_DATAINTERSECTION_6, "{B23BFE02-F38A-4a84-A7FB-A6646C6CD715}"},
    { "400.1.7", "   Bad pin factory id - ULONG_MAX",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin, KSPROPERTY_PIN_DATAINTERSECTION, sizeof(KSDATAFORMAT)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_DATAINTERSECTION_7, "{C6A7D4FE-C23F-4e19-971E-0652A931817C}"},
    { "400.1.8", "   Passing Bigger range size",            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin, KSPROPERTY_PIN_DATAINTERSECTION, sizeof(KSDATAFORMAT)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_DATAINTERSECTION_8, "{816122DB-5E1F-4bc6-8B93-30663E1EE96F}"},
    { "400.1.9", "   Passing Smaller range size",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin, KSPROPERTY_PIN_DATAINTERSECTION, sizeof(KSDATAFORMAT)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_DATAINTERSECTION_9, "{2A4ED6B4-55F0-47e9-A983-18CBEEDD3174}"},        
    { "400.1.10", "   Passing NULL Buffer",            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin, KSPROPERTY_PIN_DATAINTERSECTION, sizeof(KSDATAFORMAT)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_DATAINTERSECTION_10, "{168C3200-6228-4ca5-A343-BB0EB8C810E3}"},        
    { "400.1.11", "   Passing Invalid Audio Range",            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin, KSPROPERTY_PIN_DATAINTERSECTION, sizeof(KSDATAFORMAT)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_DATAINTERSECTION_11, "{0FDFD36B-6D45-468c-A32F-F00070B848F4}"},        
    { "400.1.12", "   Passing Invalid Audio Range -2",            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin, KSPROPERTY_PIN_DATAINTERSECTION, sizeof(KSDATAFORMAT)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_DATAINTERSECTION_12, "{B3F83945-BE9E-4ece-A74D-A5CB7655C513}"},                

    { "", "  KSPROPERTY_PIN_CINSTANCES",					0, 0, 0, 0, NULL, "{04605457-8C32-410e-A515-025577344037}"},
    { "400.2.1", "   Bad pin id",				   0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin, KSPROPERTY_PIN_CINSTANCES, sizeof(KSPIN_CINSTANCES)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_CINSTANCES_1, "{E71ED0D5-5A99-443e-8888-FD8D5651055D}"},
    { "400.2.2", "   Bad pin factory id - one more then reported by Filter",                           0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin, KSPROPERTY_PIN_CINSTANCES, sizeof(KSPIN_CINSTANCES)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_CINSTANCES_2, "{F3A09546-F66E-46c4-8394-38F85DADDCE9}"},
    { "400.2.3", "   Bad pin factory id - ULONG_MAX",                           0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin, KSPROPERTY_PIN_CINSTANCES, sizeof(KSPIN_CINSTANCES)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_CINSTANCES_3, "{99661D7F-A51E-46b6-B89A-D63B391194E4}"},
    { "400.2.4", "   Passing NULL buffer",				   0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin, KSPROPERTY_PIN_CINSTANCES, sizeof(KSPIN_CINSTANCES)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_CINSTANCES_4, "{C24A4927-1FC9-4993-B3D0-8E1CA23F8EFB}"},
    { "400.2.5", "   Passing small buffer",                           0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin, KSPROPERTY_PIN_CINSTANCES, sizeof(KSPIN_CINSTANCES)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_CINSTANCES_5, "{2D7BFE02-0EFF-4127-B9B3-D1A3BC4B97F5}"},
    { "400.2.6", "   Passing large buffer",                           0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin, KSPROPERTY_PIN_CINSTANCES, sizeof(KSPIN_CINSTANCES)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_CINSTANCES_6, "{77A4A726-D538-40ce-AB57-DAA5DABC9CBF}"},
    { "400.2.7", "   Passing valid data",                           0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin, KSPROPERTY_PIN_CINSTANCES, sizeof(KSPIN_CINSTANCES)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_CINSTANCES_7, "{80A83389-B290-4576-B7C8-ECA2AFC8D820}"},

    { "", "  KSPROPERTY_PIN_CATEGORY",				0, 0, 0, 0, NULL, "{6E32EA4A-F9FF-45e9-8F74-4C786C053908}"},
    { "400.3.1", "   Bad pin factory id - one more then reported by Filter", 0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_CATEGORY, sizeof(GUID)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_CATEGORY_1, "{5D4738AE-27E7-471a-B658-037F552252D0}"},
    { "400.3.2", "   Bad pin factory id - ULONG_MAX",             0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_CATEGORY, sizeof(GUID)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_CATEGORY_2, "{A8705814-7999-425a-8357-2B6B670CE954}"},
    { "400.3.3", "   Passing NULL buffer",                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_CATEGORY, sizeof(GUID)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_CATEGORY_3, "{A71790B9-7284-4403-869B-F8AE50D8131B}"},
    { "400.3.4", "   Passing small buffer",                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_CATEGORY, sizeof(GUID)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_CATEGORY_4, "{21618B23-70D3-40a9-B544-334FF9845425}"},
    { "400.3.5", "   Passing large buffer",                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_CATEGORY, sizeof(GUID)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_CATEGORY_5, "{63E395CF-5175-4e8a-8EEC-6502D88CC585}"},
    { "400.3.6", "   Passing valid data",                                0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_CATEGORY, sizeof(GUID)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_CATEGORY_6, "{9F6DB02E-AF76-4851-96DE-AB36B65A6F0C}"},

    { "", "  KSPROPERTY_PIN_INTERFACES",				0, 0, 0, 0, NULL, "{565D7E98-3825-4790-92D1-EDC3E6130023}"},
    { "400.4.1", "   Bad pin factory id - one more then reported by Filter", 0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_INTERFACES, sizeof(KSMULTIPLE_ITEM)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_INTERFACES_1, "{0A7E5583-4AE4-4fa3-95E0-3907E16F11C5}"},
    { "400.4.2", "   Bad pin factory id - ULONG_MAX",             0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_INTERFACES, sizeof(KSMULTIPLE_ITEM)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_INTERFACES_2, "{40C8706A-3107-4797-BC8F-200C0C4F732C}"},
    { "400.4.3", "   Passing NULL buffer",                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_INTERFACES, sizeof(KSMULTIPLE_ITEM)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_INTERFACES_3, "{01851583-A025-446e-BE70-B18DCA40A5D1}"},
    { "400.4.4", "   Passing small buffer",                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_INTERFACES, sizeof(KSMULTIPLE_ITEM)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_INTERFACES_4, "{B1D973BE-5378-4eb3-955A-E60F7A4E4693}"},
    { "400.4.5", "   Passing large buffer",                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_INTERFACES, sizeof(KSMULTIPLE_ITEM)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_INTERFACES_5, "{46B6980C-0CE1-4ce9-BB33-84384FBA094A}"},
    { "400.4.6", "   Passing valid data",                                0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_INTERFACES, sizeof(KSMULTIPLE_ITEM)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_INTERFACES_6, "{CB69BF8C-962F-4160-AD00-3F9BD40D6869}"},

    { "", "  KSPROPERTY_PIN_COMMUNICATION",				0, 0, 0, 0, NULL, "{2B763D46-5A39-40fc-86F3-FFB83C1B0BE9}"},
    { "400.5.1", "   Bad pin factory id - one more then reported by Filter", 0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_COMMUNICATION, sizeof(KSPIN_COMMUNICATION)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_COMMUNICATION_1, "{5ED698B1-EA56-4eaf-B0A6-3ECFEC0FF294}"},
    { "400.5.2", "   Bad pin factory id - ULONG_MAX",             0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_COMMUNICATION, sizeof(KSPIN_COMMUNICATION)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_COMMUNICATION_2, "{9F325088-4CED-4d99-ABD6-3593B0C68D4C}"},
    { "400.5.3", "   Passing NULL buffer",                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_COMMUNICATION, sizeof(KSPIN_COMMUNICATION)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_COMMUNICATION_3, "{7C669898-B293-4cd0-9CCD-5C5703EE8174}"},
    { "400.5.4", "   Passing small buffer",                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_COMMUNICATION, sizeof(KSPIN_COMMUNICATION)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_COMMUNICATION_4, "{1FE6169D-B3CB-4286-AC7A-CED6CCA995A3}"},
    { "400.5.5", "   Passing large buffer",                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_COMMUNICATION, sizeof(KSPIN_COMMUNICATION)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_COMMUNICATION_5, "{F863702D-2CDD-4cc8-AC21-BBBA36AB83B0}"},
    { "400.5.6", "   Passing valid data",                                0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_COMMUNICATION, sizeof(KSPIN_COMMUNICATION)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_COMMUNICATION_6, "{28E68AD0-A340-486a-A23A-CC41736B351B}"},

    { "", "  KSPROPERTY_PIN_DATAFLOW",				0, 0, 0, 0, NULL, "{D89F3C08-D420-4b39-BFAE-C2950E960746}"},
    { "400.6.1", "   Bad pin factory id - one more then reported by Filter", 0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_DATAFLOW, sizeof(KSPIN_DATAFLOW)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_DATAFLOW_1, "{0B0B7455-4482-4d8d-916C-03509601BB2A}"},
    { "400.6.2", "   Bad pin factory id - ULONG_MAX",             0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_DATAFLOW, sizeof(KSPIN_DATAFLOW)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_DATAFLOW_2, "{ADA2F8CE-9AD9-46c8-BB9A-2DD23760B6AB}"},
    { "400.6.3", "   Passing NULL buffer",                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_DATAFLOW, sizeof(KSPIN_DATAFLOW)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_DATAFLOW_3, "{B5D1555A-86F7-4d4e-ACBD-0188BE58FD16}"},
    { "400.6.4", "   Passing small buffer",                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_DATAFLOW, sizeof(KSPIN_DATAFLOW)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_DATAFLOW_4, "{825D043A-60E1-46cd-961F-5693B0AA51A8}"},
    { "400.6.5", "   Passing large buffer",                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_DATAFLOW, sizeof(KSPIN_DATAFLOW)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_DATAFLOW_5, "{BDE25C6A-FE64-4635-B920-B1EE1A8716AE}"},
    { "400.6.6", "   Passing valid data",                                0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_DATAFLOW, sizeof(KSPIN_DATAFLOW)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_DATAFLOW_6, "{44047875-8676-485b-A7F8-BC637E18CD7E}"},

    { "", "  KSPROPERTY_PIN_GLOBALCINSTANCES",				0, 0, 0, 0, NULL, "{126CDC8F-E99D-47e5-B177-A6C554E9187F}"},
    { "400.7.1", "   Bad pin id",                  0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_GLOBALCINSTANCES, sizeof(KSPIN_CINSTANCES)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_CINSTANCES_1, "{71710694-B689-460e-B523-D22D28759397}"},
    { "400.7.2", "   Bad pin factory id - one more then reported by Filter", 0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_GLOBALCINSTANCES, sizeof(KSPIN_CINSTANCES)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_CINSTANCES_2, "{57ED8F9C-905A-40b0-BACA-6FB45AC94FE3}"},
    { "400.7.3", "   Bad pin factory id - ULONG_MAX",             0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_GLOBALCINSTANCES, sizeof(KSPIN_CINSTANCES)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_CINSTANCES_3, "{0B7F78A8-EAF9-4432-9347-20BC701EC851}"},
    { "400.7.4", "   Passing NULL buffer",                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_GLOBALCINSTANCES, sizeof(KSPIN_CINSTANCES)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_CINSTANCES_4, "{2ED371EB-503A-42ca-A458-68B3294FA124}"},
    { "400.7.5", "   Passing small buffer",                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_GLOBALCINSTANCES, sizeof(KSPIN_CINSTANCES)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_CINSTANCES_5, "{6129B740-B7D6-4516-BCAE-28BB254D0113}"},
    { "400.7.6", "   Passing large buffer",                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_GLOBALCINSTANCES, sizeof(KSPIN_CINSTANCES)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_CINSTANCES_6, "{BF39209B-1F2A-497e-902B-0A159E30C356}"},
    { "400.7.7", "   Passing valid data",                                0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_GLOBALCINSTANCES, sizeof(KSPIN_CINSTANCES)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_CINSTANCES_7, "{AE3FED63-3344-4199-881B-A647AD71C848}"},

    { "", "  KSPROPERTY_PIN_MEDIUMS",				0, 0, 0, 0, NULL, "{359DAAD9-490D-4c28-B0BD-879EC9FDA769}"},
    { "400.8.1", "   Bad pin factory id - one more then reported by Filter", 0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_MEDIUMS, sizeof(KSMULTIPLE_ITEM)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_MEDIUMS_1, "{44B514B7-CF04-4cd6-8943-22F39C3ECBBF}"},
    { "400.8.2", "   Bad pin factory id - ULONG_MAX",             0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_MEDIUMS, sizeof(KSMULTIPLE_ITEM)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_MEDIUMS_2, "{EF16297D-E3B0-480c-B8C2-9432621B54A5}"},
    { "400.8.3", "   Passing NULL buffer",                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_MEDIUMS, sizeof(KSMULTIPLE_ITEM)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_MEDIUMS_3, "{EC09C38A-FB6E-4984-835C-88C065E3560C}"},
    { "400.8.4", "   Passing small buffer",                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_MEDIUMS, sizeof(KSMULTIPLE_ITEM)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_MEDIUMS_4, "{48AA8866-09E6-45b8-95FD-24D152B53110}"},
    { "400.8.5", "   Passing large buffer",                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_MEDIUMS, sizeof(KSMULTIPLE_ITEM)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_MEDIUMS_5, "{58473487-01D8-4fb3-AF8A-9042DE0BD9AA}"},
    { "400.8.6", "   Passing valid data",                                0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_MEDIUMS, sizeof(KSMULTIPLE_ITEM)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_MEDIUMS_6, "{8B78A9B0-7D9F-4274-B0C2-82C095EC62A0}"},

    { "", "  KSPROPERTY_PIN_NECESSARYINSTANCES",				0, 0, 0, 0, NULL, "{541BF790-8521-4e23-B2D5-3315888FA260}"},
    { "400.9.1", "   Bad pin factory id - one more then reported by Filter", 0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_NECESSARYINSTANCES, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_NECESSARYINSTANCES_1, "{DBC78413-F12A-42e9-B174-193EC625903B}"},
    { "400.9.2", "   Bad pin factory id - ULONG_MAX",             0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_NECESSARYINSTANCES, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_NECESSARYINSTANCES_2, "{2DE98761-B69F-472c-A756-DC188BC3932F}"},
    { "400.9.3", "   Passing NULL buffer",                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_NECESSARYINSTANCES, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_NECESSARYINSTANCES_3, "{468615D4-550B-4dad-929A-DB9721B8BA1D}"},
    { "400.9.4", "   Passing small buffer",                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_NECESSARYINSTANCES, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_NECESSARYINSTANCES_4, "{BE939FF8-D9F2-4356-9187-6A0AD26ADDE4}"},
    { "400.9.5", "   Passing large buffer",                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_NECESSARYINSTANCES, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_NECESSARYINSTANCES_5, "{64C8A273-3452-442e-B615-9981D271CE17}"},
    { "400.9.6", "   Passing valid data",                                0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_NECESSARYINSTANCES, sizeof(ULONG)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_NECESSARYINSTANCES_6, "{1A99F524-A636-48b0-A031-793E5A2ACAA8}"},

    { "", "  KSPROPERTY_PIN_CONSTRAINEDDATARANGES",				0, 0, 0, 0, NULL, "{BF56D569-18A3-4cf7-9E9F-635557BAB894}"},
    { "400.10.1", "   Bad pin factory id - one more then reported by Filter", 0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_CONSTRAINEDDATARANGES , sizeof(KSMULTIPLE_ITEM)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_CONSTRAINEDDATARANGES_1, "{4792A10D-D6C9-4472-9C98-313FAE4502E4}"},
    { "400.10.2", "   Bad pin factory id - ULONG_MAX",             0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_CONSTRAINEDDATARANGES , sizeof(KSMULTIPLE_ITEM)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_CONSTRAINEDDATARANGES_2, "{1F3D9745-665E-459c-9133-23CC58CAFDF3}"},
    { "400.10.3", "   Passing NULL buffer",                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_CONSTRAINEDDATARANGES , sizeof(KSMULTIPLE_ITEM)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_CONSTRAINEDDATARANGES_3, "{3C0932EE-F5E9-4711-B8B5-0387991ED485}"},
    { "400.10.4", "   Passing small buffer",                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_CONSTRAINEDDATARANGES , sizeof(KSMULTIPLE_ITEM)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_CONSTRAINEDDATARANGES_4, "{502C83DA-35D3-4bd6-8CF1-A33A96227307}"},
    { "400.10.5", "   Passing large buffer",                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_CONSTRAINEDDATARANGES , sizeof(KSMULTIPLE_ITEM)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_CONSTRAINEDDATARANGES_5, "{A9047A36-5D2E-43f9-BC30-A01B9E7107F4}"},
    { "400.10.6", "   Passing valid data",                                0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_CONSTRAINEDDATARANGES , sizeof(KSMULTIPLE_ITEM)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_CONSTRAINEDDATARANGES_6, "{6C683D65-CBB0-483c-89A4-691CD268D252}"},

    { "", "  KSPROPERTY_PIN_DATARANGES",				0, 0, 0, 0, NULL, "{B0053EB3-03B0-4b20-92B3-4D7FE97F405C}"},
    { "400.11.1", "   Bad pin factory id - one more then reported by Filter", 0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_DATARANGES , sizeof(KSMULTIPLE_ITEM)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_DATARANGES_1, "{098528DA-F324-4174-B628-C8BA6536C595}"},
    { "400.11.2", "   Bad pin factory id - ULONG_MAX",             0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_DATARANGES , sizeof(KSMULTIPLE_ITEM)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_DATARANGES_2, "{B2C1BBFE-B44E-48c9-BC7A-2E11F1AFDDF2}"},
    { "400.11.3", "   Passing NULL buffer",                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_DATARANGES , sizeof(KSMULTIPLE_ITEM)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_DATARANGES_3, "{644769F3-B22D-4168-B55E-C265AE6476C2}"},
    { "400.11.4", "   Passing small buffer",                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_DATARANGES , sizeof(KSMULTIPLE_ITEM)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_DATARANGES_4, "{B9B30748-51D1-44ec-9E8C-50412B8266C9}"},
    { "400.11.5", "   Passing large buffer",                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_DATARANGES , sizeof(KSMULTIPLE_ITEM)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_DATARANGES_5, "{A70868FF-2482-4c38-9561-F6AC7DC5FE02}"},
    { "400.11.6", "   Passing valid data",                                0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_DATARANGES , sizeof(KSMULTIPLE_ITEM)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_DATARANGES_6, "{F6605B8F-3386-418e-AA43-2A60B0A69F2C}"},

    { "", "  KSPROPERTY_PIN_NAME",				0, 0, 0, 0, NULL, "{342931D3-70E0-4d6d-A90C-830494EFEF59}"},
    { "400.12.1", "   Bad pin factory id - one more then reported by Filter", 0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_NAME, 0),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_NAME_1, "{4AC17533-0935-4eb8-B486-C1910F55ECA6}"},
    { "400.12.2", "   Bad pin factory id - ULONG_MAX",             0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_NAME, 0),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_NAME_2, "{C3AAD8C5-8047-4d87-9C25-354C5C1F69A5}"},
    { "400.12.3", "   Passing NULL buffer",                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_NAME, 0),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_NAME_3, "{447F9C55-E43C-4ddd-9DE6-3BFCD6C30ED2}"},
    { "400.12.4", "   Passing small buffer",                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_NAME, 0),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_NAME_4, "{BC3CD50D-B0B1-475a-A542-C479C57B7F09}"},
    { "400.12.5", "   Passing large buffer",                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_NAME, 0),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_NAME_5, "{8ADD58C8-B3F8-458c-AEDE-7D59DD06936C}"},
    { "400.12.6", "   Passing valid data",                                0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_NAME, 0),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_NAME_6, "{CF21B5CB-98AC-4647-845C-48D905486D68}"},

    { "", "  KSPROPERTY_PIN_PROPOSEDATAFORMAT",				0, 0, 0, 0, NULL, "{0FAEE6F2-5B3D-45c9-BF3E-1421502396D5}"},
    { "400.13.1", "   Bad pin factory id - one more then reported by Filter", 0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_PROPOSEDATAFORMAT , sizeof(KSDATAFORMAT)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_PROPOSEDATAFORMAT_1, "{70864445-388B-49d9-A8E5-F6CBADF1B4E6}"},
    { "400.13.2", "   Bad pin factory id - ULONG_MAX",             0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_PROPOSEDATAFORMAT , sizeof(KSDATAFORMAT)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_PROPOSEDATAFORMAT_2, "{7EF578DB-4186-4c78-A1A3-254F38894B1E}"},
    { "400.13.3", "   Passing NULL buffer",                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_PROPOSEDATAFORMAT , sizeof(KSDATAFORMAT)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_PROPOSEDATAFORMAT_3, "{701AB3A9-5705-4025-A53B-35254EC2D518}"},
    { "400.13.4", "   Passing small buffer",                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_PROPOSEDATAFORMAT , sizeof(KSDATAFORMAT)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_PROPOSEDATAFORMAT_4, "{439A933A-55E8-481a-A570-6FB7921BA4DE}"},
    { "400.13.5", "   Passing large buffer",                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_PROPOSEDATAFORMAT , sizeof(KSDATAFORMAT)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_PROPOSEDATAFORMAT_5, "{FCA2324C-889B-4c2c-AEC0-810DE7FF6CE5}"},
    { "400.13.6", "   Passing valid data",                                0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_PROPOSEDATAFORMAT , sizeof(KSDATAFORMAT)),
        (TESTFNPROC)Generic_Property_KSPROPERTY_PIN_PROPOSEDATAFORMAT_6, "{067BC14C-762C-46dc-B5FB-FE6BFA213866}"},

#if (NTDDI_VERSION >= NTDDI_WINBLUE)
    { "",   " KSPROPSETID_AudioSignalProcessing",			0, 0, 0, 0, NULL, "{4891F381-5999-4032-86BD-4152F1A839BA}"},
    { "", "  KSPROPERTY_AUDIOSIGNALPROCESSING_MODES",		0, 0, 0, 0, NULL, "{CB58D38F-BDDE-4302-8025-98803AC7EEE6}"},

    { "2000.0.1", "   Bad pin factory id - one more then reported by Filter", 0, 0, 0,
    GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioSignalProcessing,
    KSPROPERTY_AUDIOSIGNALPROCESSING_MODES , sizeof(KSMULTIPLE_ITEM)),
    (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIOSIGNALPROCESSING_MODES_1, "{505714A9-B1E7-46FA-B1DE-21B489BAD810}"},

    { "2000.0.2", "   Bad pin factory id - ULONG_MAX",             0, 0, 0,
    GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioSignalProcessing,
    KSPROPERTY_AUDIOSIGNALPROCESSING_MODES , sizeof(KSMULTIPLE_ITEM)),
    (TESTFNPROC)Generic_Property_KSPROPERTY_AUDIOSIGNALPROCESSING_MODES_2, "{14941E8B-E018-4349-B98E-B6A249F90E3F}"},

    { "2000.0.3", "   Out buffer NULL",			            0, 0, 0,
    GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioSignalProcessing, 
    KSPROPERTY_AUDIOSIGNALPROCESSING_MODES, sizeof(KSMULTIPLE_ITEM)),
    (TESTFNPROC)Generic_Property_KSPROPERTY_TOPOLOGY_NODES_1, "{CE4D6D12-FF3F-46B7-96CD-EDE2EA25EE40}"},
    
    { "2000.0.4", "   Out buffer Small",  		            0, 0, 0,
    GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioSignalProcessing, 
    KSPROPERTY_AUDIOSIGNALPROCESSING_MODES, sizeof(KSMULTIPLE_ITEM)),
    (TESTFNPROC)Generic_Property_KSPROPERTY_TOPOLOGY_NODES_2, "{7D0A332A-6B99-40A3-B5B5-F38016F9F174}"},
    
    { "2000.0.5", "   Out buffer Large",  					0, 0, 0,
    GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioSignalProcessing, 
    KSPROPERTY_AUDIOSIGNALPROCESSING_MODES, sizeof(KSMULTIPLE_ITEM)),
    (TESTFNPROC)Generic_Property_KSPROPERTY_TOPOLOGY_NODES_3, "{2C50617F-F4FF-4D83-A38F-B90C7F8C8BE3}"},
#endif

    // Create test cases
    { "", "Create",										    0, 0, 0, 0, NULL, "{F1C05861-0C86-4da8-82D7-F51EE77421D1}"},

    { "", " Create pin",	    							0, 0, 0, 0, NULL, "{63A1B73D-A488-4311-B1CD-8D2B73E9DE59}"},

    { "1000.1.1", "  Invalid cbSize",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP( RUN_PIN_CREATE , GUID_NULL, INVALID_PROPERTY, 0),
        (TESTFNPROC)Generic_Create_Pin_1, "{11711615-EECD-46bc-9ADD-D09F2BB705D4}"},
    { "1000.1.2", "  cbSize==0",							0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP( RUN_PIN_CREATE , GUID_NULL, INVALID_PROPERTY, 0),
        (TESTFNPROC)Generic_Create_Pin_2, "{244C88E4-1E20-4d6d-84CD-437D60365357}"},
    { "1000.1.3", "  Change tag for WFX",					0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP( RUN_PIN_CREATE , GUID_NULL, INVALID_PROPERTY, 0),
        (TESTFNPROC)Generic_Create_Pin_3, "{F33F3656-B372-4780-B686-52F0995E9B3A}"},
    { "1000.1.4", "  Specifier information missing",		0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP( RUN_PIN_CREATE , GUID_NULL, INVALID_PROPERTY, 0),
        (TESTFNPROC)Generic_Create_Pin_4, "{8BFAD39B-2023-45ed-A77A-BB7F473199DD}"},
    { "1000.1.5", "  Invalid KSPRIORITY",		0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP( RUN_PIN_CREATE , GUID_NULL, INVALID_PROPERTY, 0),
        (TESTFNPROC)Generic_Create_Pin_5, "{22C60EBD-7D09-44dc-8A23-F369F33BE92F}"},        
    { "1000.1.6", "  Invalid KSPIN Medium",		0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP( RUN_PIN_CREATE , GUID_NULL, INVALID_PROPERTY, 0),
        (TESTFNPROC)Generic_Create_Pin_6, "{2A40210D-298D-483a-A041-D7DFF66C04B5}"},                
    { "1000.1.7", "  Invalid KSPIN Interface",		0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP( RUN_PIN_CREATE , GUID_NULL, INVALID_PROPERTY, 0),
        (TESTFNPROC)Generic_Create_Pin_7, "{29DE6ED7-6538-4f87-BDCB-9EE371BA6D27}"},                
    { "1000.1.8", "  CreateValid Pins",		0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP( RUN_PIN_CREATE , GUID_NULL, INVALID_PROPERTY, 0),
        (TESTFNPROC)Tst_KCP_AllPinsValid , "{789E0D63-3A6A-4e23-B054-DEC349D02370}"},    
#if (NTDDI_VERSION >= NTDDI_WINBLUE)
    { "1000.1.9", "  Invalid Pin ID Raw Mode",		0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP( RUN_PIN_CREATE , GUID_NULL, INVALID_PROPERTY, 0),
        (TESTFNPROC)Create_Mode_Pin_ULONG_PINID_RAW, "{EA01F07B-5C65-4713-91CA-D258232CF993}"},                
    { "1000.1.10", "  Invalid Pin ID Default Mode",		0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP( RUN_PIN_CREATE , GUID_NULL, INVALID_PROPERTY, 0),
        (TESTFNPROC)Create_Mode_Pin_ULONG_PINID_DEFAULT, "{35E346F6-BF2E-4A7F-9D25-E19B145C7F0C}"},   
    { "1000.1.11", "  GUID_NULL Mode",		0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP( RUN_PIN_CREATE , GUID_NULL, INVALID_PROPERTY, 0),
        (TESTFNPROC)Create_Mode_Pin_GUIDNULL, "{A5A815F2-C27F-4E4F-B95A-063A64D87521}"},   
    { "1000.1.12", "  Random GUID Mode",		0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP( RUN_PIN_CREATE , GUID_NULL, INVALID_PROPERTY, 0),
        (TESTFNPROC)Create_Mode_Pin_GUID_RANDOM, "{E9CBDADF-C205-4852-8F59-BF95E8850D2F}"},   
#endif
    { "", "IOCTL",										    0, 0, 0, 0, NULL, "{342643ae-88f7-4cd0-be00-2dd32ed4e969}"},

    // KS Ioctls
    { "", " KS defined",									0, 0, 0, 0, NULL, "{02549af6-d62b-4536-9ba9-0caa63a8aef7}"},
    { "", "  IOCTL_KS_WRITE_STREAM",					    0, 0, 0, 0, NULL, "{fbced59c-d134-4972-ab00-48bfabd325ea}"},
    { "800.1.1", "   Cancel IO",							0, 0, 0,
        GAUDIT_TEST_ENTRY_IOCTL(GOF_IOCTL | RUN_PROP, IOCTL_KS_WRITE_STREAM, 0),
        (TESTFNPROC)Generic_Ioctl_IOCTL_KS_WRITE_1, "{84b6454b-c37a-42e5-8259-3623e87ec5f3}"},
    //  { "800.1.2", "   Test PCM format pins' ability to render PCM data",	0, 0, 0,
    //      GAUDIT_TEST_ENTRY_IOCTL(GOF_IOCTL | RUN_PROP, IOCTL_KS_WRITE_STREAM, 0),
    //      (TESTFNPROC)Tst_PinRenderTest, "{3D748503-6032-4963-8FC0-BA946705CC91}"},

    { "", " WDMAUD defined",								0, 0, 0, 0, NULL, "{7945D95E-99CA-40a9-A44D-8B269D9B269D}"},
    { "", "  IOCTL_WDMAUD_INIT",					0, 0, 0, 0, NULL, "{EC3DE7D8-A24B-46cd-BA93-53BE4E114F58}"},
    { "1100.1.1", "   Initialize WDMAUD",			            0, 0, 0,
        GAUDIT_TEST_ENTRY_IOCTL(GOF_IOCTL | RUN_PROP, IOCTL_WDMAUD_INIT, 0),
        (TESTFNPROC)Generic_Ioctl_IOCTL_WDMAUD_INIT, "{A2D662A5-F1FD-4918-B136-5D97BFC12F11}"},

    { "", "  IOCTL_WDMAUD_ADD_DEVNODE",					0, 0, 0, 0, NULL, "{E3609B40-A955-4d9f-BFB4-B7362B8F4652}"},
    { "1100.1.2", "   Test Add and Remove Device Node",			            0, 0, 0,
        GAUDIT_TEST_ENTRY_IOCTL(GOF_IOCTL | RUN_PROP, IOCTL_WDMAUD_ADD_DEVNODE, 0),
        (TESTFNPROC)Generic_Ioctl_IOCTL_WDMAUD_ADD_DEVNODE, "{CC99F476-1F31-48b9-9FFA-AD241042F0C5}"},

    { "", "  IOCTL_WDMAUD_GET_CAPABILITIES",					0, 0, 0, 0, NULL, "{DE9764D6-256C-4424-9A08-A2FD0450DBCE}"},
    { "1100.1.3", "   Get Capabilities",			            0, 0, 0,
        GAUDIT_TEST_ENTRY_IOCTL(GOF_IOCTL | RUN_PROP, IOCTL_WDMAUD_GET_CAPABILITIES, 0),
        (TESTFNPROC)Generic_Ioctl_IOCTL_WDMAUD_GET_CAPABILITIES, "{D9E488E6-1C8F-46d1-84E2-41E86305EE62}"}

    /*{ "", "  IOCTL_WDMAUD_REMOVE_DEVNODE",					0, 0, 0, 0, NULL, "{8F7BF6FB-1F7C-4368-BE02-EBD3F7557068}"},
    { "1100.1.2", "   Remove Device Node",			            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_CATEGORY, sizeof(GUID)),
        (TESTFNPROC)Generic_Ioctl_IOCTL_WDMAUD_ADD_DEVNODE, "{E927EF8E-B211-4aee-BDD9-C114AA74EA0F}"}*/
};
#else
#undef DEVICE_TEST_METHOD
#define DEVICE_TEST_METHOD(testID, testCaseName, testCaseFlags, deviceTypeFlags, stFlags, userField, testCaseFunction, testCaseGuid, ksProperty)                    \
    }                                                                                                                                                               \
    TAEF_TEST_METHOD(testCaseFunction##_##ksProperty)                                                                                                               \
    {                                                                                                                                                               \
    DV_TCINFO testCaseInfo = {testID, testCaseName, testCaseFlags, deviceTypeFlags, stFlags, userField, (TESTFNPROC)::##testCaseFunction, testCaseGuid};            \
        g_pModule = new TaefModuleType(&testCaseInfo);                                                                                                              \
        g_pModule->OnInitialUpdate();                                                                                                                               \
        g_IShell->RunTestOnDevices(g_pModule);                                                                                                                      \
        /*DWORD result = ::testCaseFunction();                                                                                                                   */ \
        /* Handle result value and convert to TAEF result */                                                                                                        \
        g_pModule->Destroy();                                                                                                                                       \
        g_pModule = NULL;                                                                                                                                           

BEGIN_TEST_CASE_INFO(GAudiT, CGauditModule)
    DEVICE_TEST_PARENT( "", "KS properties",							0, 0, 0, 0, NULL, "{d95355c8-f679-4986-a498-c86350af0b79}" )

    // KSPROPSETID_Audio
    DEVICE_TEST_PARENT( "", " KSPROPSETID_Audio",						0, 0, 0, 0, NULL, "{5db39b7d-2070-4a41-a428-292dfb9112ff}" )
    DEVICE_TEST_PARENT( "", "  KSPROPERTY_AUDIO_MIX_LEVEL_CAPS",		0, 0, 0, 0, NULL, "{461f14fd-c3af-4877-8950-7793847951a3}")
    DEVICE_TEST_METHOD( "100.1.1", "   0 for in/out channels",				0, 0, 0,
        // parameters to pass to test function
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_MIX_LEVEL_CAPS, sizeof(KSAUDIO_MIXCAP_TABLE)),
        Generic_Property_KSPROPERTY_AUDIO_MIX_LEVEL_CAPS_1, "{7d5aadce-2f0a-4967-97f4-141722354c1a}", AUDIO_MIX_LEVEL_CAPS)
    DEVICE_TEST_METHOD( "100.1.2", "   ULONG_MAX for in/out channels",		0, 0, 0, 
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_MIX_LEVEL_CAPS, sizeof(KSAUDIO_MIXCAP_TABLE)),
        Generic_Property_KSPROPERTY_AUDIO_MIX_LEVEL_CAPS_2, "{68553ef1-3de4-494b-95c0-a0aa19785696}", AUDIO_MIX_LEVEL_CAPS)
    DEVICE_TEST_METHOD( "100.1.3", "   0x80000001/2 for in/out channels",		0, 0, 0, 
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_MIX_LEVEL_CAPS, sizeof(KSAUDIO_MIXCAP_TABLE)),
        Generic_Property_KSPROPERTY_AUDIO_MIX_LEVEL_CAPS_3, "{61e7b53f-15df-461f-b0c6-c8da960604ac}", AUDIO_MIX_LEVEL_CAPS)
    DEVICE_TEST_METHOD( "100.1.4", "   Out buffer small",						0, 0, 0, 
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_MIX_LEVEL_CAPS, sizeof(KSAUDIO_MIXCAP_TABLE)),
        Generic_Property_KSPROPERTY_AUDIO_MIX_LEVEL_CAPS_4, "{4b93c48e-e2cf-4f97-92a8-128421c72b98}", AUDIO_MIX_LEVEL_CAPS)
    DEVICE_TEST_METHOD( "100.1.5", "   invalid node id",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_MIX_LEVEL_CAPS, sizeof(KSAUDIO_MIXCAP_TABLE)),
        Generic_Property_KSPROPERTY_AUDIO_MIX_LEVEL_CAPS_5, "{53C11D41-5448-4933-B6C3-1E065B8855F9}", AUDIO_MIX_LEVEL_CAPS)
    DEVICE_TEST_METHOD( "100.1.6", "   valid Test data",						0, 0, 0, 
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_MIX_LEVEL_CAPS, sizeof(KSAUDIO_MIXCAP_TABLE)),
        Generic_Property_KSPROPERTY_AUDIO_MIX_LEVEL_CAPS, "{36D080F7-514D-4045-B29C-33618817924C}", AUDIO_MIX_LEVEL_CAPS)
        
    DEVICE_TEST_PARENT( "", "  KSPROPERTY_AUDIO_NUM_EQ_BANDS",		0, 0, 0, 0, NULL, "{2df54bc6-a73d-4fe0-9d78-4ede8108688c}")
    DEVICE_TEST_METHOD( "100.2.2", "   Invalid Node ID - ULONG_MAX",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_NUM_EQ_BANDS, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_NodeID_ULONGMAX, "{A6673AA6-6D0E-4351-8934-E64A81CD48EE}", AUDIO_NUM_EQ_BANDS)
    DEVICE_TEST_METHOD( "100.2.3", "   Invalid Node ID - 0x80000001",               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_NUM_EQ_BANDS, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_NodeID_0x80000001, "{EDD3CE9D-5FBB-4008-B7AF-0459CE5ED276}", AUDIO_NUM_EQ_BANDS)
    DEVICE_TEST_METHOD( "100.2.4", "   Invalid Channel ID - 0xFFFFFFFE",            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_NUM_EQ_BANDS, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_ChannelID_0xFFFFFFFE, "{DD17A656-FCD3-4d97-947E-67CCA95A91AD}", AUDIO_NUM_EQ_BANDS)
    DEVICE_TEST_METHOD( "100.2.5", "   NULL IN/OUT Buffer",					0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_NUM_EQ_BANDS, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_NULL_Buffer, "{53AFC8E2-D00E-4b69-9D3C-F3C58ED550C1}", AUDIO_NUM_EQ_BANDS)
    DEVICE_TEST_METHOD( "100.2.6", "   Small IN/OUT Buffer",                             0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_NUM_EQ_BANDS, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_Small_Buffer, "{1B3CC923-88E7-4dd7-80E3-BF0FD6AE6FDC}", AUDIO_NUM_EQ_BANDS)
    DEVICE_TEST_METHOD( "100.2.7", "   Out buffer Large",                                   0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_NUM_EQ_BANDS, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_Large_Buffer, "{00D57899-0ED9-4688-8331-F51097BCD32F}", AUDIO_NUM_EQ_BANDS)
    DEVICE_TEST_METHOD( "100.2.8", "   valid Test data",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_NUM_EQ_BANDS, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_Valid_Test, "{00D40979-BCEB-42b6-9BB8-4A6C1E3D8710}", AUDIO_NUM_EQ_BANDS)

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_AUDIO_CHORUS_LEVEL",                0, 0, 0, 0, NULL, "{1DD9AF5D-79EA-4229-88E1-218B0429D9D5}")
    DEVICE_TEST_METHOD( "100.3.1", "   Invalid Node ID - ULONG_MAX",               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_CHORUS_LEVEL, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTYULONG_NodeID_ULONGMAX, "{123D8664-6EC9-4151-9BE2-E80253715379}", AUDIO_CHORUS_LEVEL)
    DEVICE_TEST_METHOD( "100.3.2", "   Invalid Node ID - 0x80000001",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_CHORUS_LEVEL, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTYULONG_NodeID_0x80000001, "{49BDAE38-0CEF-457d-9348-DFB05337A6CB}", AUDIO_CHORUS_LEVEL)
    DEVICE_TEST_METHOD( "100.3.3", "   NULL IN/OUT Buffer",                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_CHORUS_LEVEL, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTYULONG_NULL_Buffer, "{4633F24D-ED5B-4d09-AA74-97C7B08B8FE9}", AUDIO_CHORUS_LEVEL)
    DEVICE_TEST_METHOD( "100.3.4", "   Small IN/OUT Buffer",                              0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_CHORUS_LEVEL, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTYULONG_Small_Buffer, "{3ADE351A-D688-412b-8A0C-7B89DF537FF3}", AUDIO_CHORUS_LEVEL)
    DEVICE_TEST_METHOD( "100.3.5", "   Out buffer Large",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_CHORUS_LEVEL, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTYULONG_Large_Buffer, "{AD0AC2C9-ED91-499f-9515-A9A9180F9976}", AUDIO_CHORUS_LEVEL)
    DEVICE_TEST_METHOD( "100.3.6", "   valid test data",                                       0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_CHORUS_LEVEL, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTYULONG_Valid_Test, "{310904D2-E188-4ee1-824E-0252B686D360}", AUDIO_CHORUS_LEVEL)

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_AUDIO_CPU_RESOURCES",             0, 0, 0, 0, NULL, "{F33E9C73-0809-4be6-8988-7DFEDF515615}")
    DEVICE_TEST_METHOD( "100.4.1", "   Invalid Node ID - ULONG_MAX",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_CPU_RESOURCES, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTYULONG_NodeID_ULONGMAX, "{FD6ADE34-00AD-40d1-AEA8-D3481222D5D8}", AUDIO_CPU_RESOURCES)
    DEVICE_TEST_METHOD( "100.4.2", "   Invalid Node ID - 0x80000001",  		0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_CPU_RESOURCES, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTYULONG_NodeID_0x80000001, "{50217166-5CB3-4814-897C-7219C62C1B55}", AUDIO_CPU_RESOURCES)
    DEVICE_TEST_METHOD( "100.4.3", "   NULL IN/OUT Buffer",  					0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_CPU_RESOURCES, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTYULONG_NULL_Buffer, "{5D4EFB21-DA90-463a-BABB-EF673E595DCD}", AUDIO_CPU_RESOURCES)
    DEVICE_TEST_METHOD( "100.4.4", "   Small IN/OUT Buffer",  				0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_CPU_RESOURCES, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTYULONG_Small_Buffer, "{6ECF0651-21B4-40de-878F-C970DE2BF115}", AUDIO_CPU_RESOURCES)
    DEVICE_TEST_METHOD( "100.4.5", "   Out buffer Large",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_CPU_RESOURCES, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTYULONG_Large_Buffer, "{C231EEFB-FFC5-47fb-9044-60492921497A}", AUDIO_CPU_RESOURCES)
    DEVICE_TEST_METHOD( "100.4.6", "   valid test data",                                       0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_CPU_RESOURCES, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTYULONG_Valid_Test, "{9622D0E7-FD00-42a6-9E78-C40150B8216B}", AUDIO_CPU_RESOURCES)

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_AUDIO_DEMUX_DEST",			0, 0, 0, 0, NULL, "{384344BD-3218-4611-879B-E41F2AE0951D}")
    DEVICE_TEST_METHOD( "100.5.1", "   Invalid Node ID - ULONG_MAX",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_DEMUX_DEST, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTYULONG_NodeID_ULONGMAX, "{74FA1540-BC6A-4a82-B566-CDE022DC5362}", AUDIO_DEMUX_DEST)
    DEVICE_TEST_METHOD( "100.5.2", "   Invalid Node ID - 0x80000001",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_DEMUX_DEST, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTYULONG_NodeID_0x80000001, "{1CF205F0-15C7-4010-932A-EA382BC64276}", AUDIO_DEMUX_DEST)
    DEVICE_TEST_METHOD( "100.5.3", "   NULL IN/OUT Buffer",					0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_DEMUX_DEST, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTYULONG_NULL_Buffer, "{658D9F14-6612-471d-ABF9-E53B0A9A8BBB}", AUDIO_DEMUX_DEST)
    DEVICE_TEST_METHOD( "100.5.4", "   Small IN/OUT Buffer",					0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_DEMUX_DEST, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTYULONG_Small_Buffer, "{39C052F8-B278-41d4-B296-9ECC310A63EF}", AUDIO_DEMUX_DEST)
    DEVICE_TEST_METHOD( "100.5.5", "   Out buffer Large",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_DEMUX_DEST, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTYULONG_Large_Buffer, "{B297ACFA-4D2D-40d1-8EB6-10E818F8098F}", AUDIO_DEMUX_DEST)
    DEVICE_TEST_METHOD( "100.5.6", "   valid test data",                                       0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_DEMUX_DEST, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTYULONG_Valid_Test, "{E8507423-4A1C-4f4f-B82C-B358FF18EDFD}", AUDIO_DEMUX_DEST)
	
    DEVICE_TEST_PARENT( "", "  KSPROPERTY_AUDIO_MUX_SOURCE",			0, 0, 0, 0, NULL, "{49E25442-4C0A-4ba4-B523-FF870A79EFCB}")
    DEVICE_TEST_METHOD( "100.7.1", "   Invalid Node ID - ULONG_MAX",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_MUX_SOURCE, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTYULONG_NodeID_ULONGMAX, "{A995EB26-E702-4951-877F-DC14426BFE5E}", AUDIO_MUX_SOURCE)
    DEVICE_TEST_METHOD( "100.7.2", "   Invalid Node ID - 0x80000001",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_MUX_SOURCE, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTYULONG_NodeID_0x80000001, "{AD16A56F-1480-47b0-8EE5-2A885217B693}", AUDIO_MUX_SOURCE)
    DEVICE_TEST_METHOD( "100.7.3", "   NULL IN/OUT Buffer",					0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_MUX_SOURCE, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTYULONG_NULL_Buffer, "{F8B19CF8-1859-4c3f-9CA3-02C16C8CE29B}", AUDIO_MUX_SOURCE)
    DEVICE_TEST_METHOD( "100.7.4", "   Small IN/OUT Buffer",					0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_MUX_SOURCE, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTYULONG_Small_Buffer, "{6419295A-5F99-427a-82B8-8EBF23197AE6}", AUDIO_MUX_SOURCE)
    DEVICE_TEST_METHOD( "100.7.5", "   Out buffer Large",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_MUX_SOURCE, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTYULONG_Large_Buffer, "{E2B90D84-94B9-41fb-84E8-EA5F9F03C0B4}", AUDIO_MUX_SOURCE)
    DEVICE_TEST_METHOD( "100.7.6", "   valid test data",                                       0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_MUX_SOURCE, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTYULONG_Valid_Test, "{B817B4F5-34DE-4e0c-B52C-EC321448792A}", AUDIO_MUX_SOURCE)
    DEVICE_TEST_METHOD( "100.7.7", "   Setting mux source to to Invalid value - DEADBEEF",         0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_MUX_SOURCE, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTYULONG_SETINVALIDVALUE, "{21C461BE-6CD5-4c2e-B323-151C6390B9E0}", AUDIO_MUX_SOURCE)
    DEVICE_TEST_METHOD( "100.7.8", "   Test for Basic support",                                 0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_MUX_SOURCE, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTY_AUDIO_Basic_Support, "{3FEC8345-F421-4151-893B-F06BC0EBC378}", AUDIO_MUX_SOURCE)

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_AUDIO_QUALITY",				0, 0, 0, 0, NULL, "{8FADA295-EF05-4755-A38D-7DBBDD27233B}")
    DEVICE_TEST_METHOD( "100.8.1", "   Invalid Node ID - ULONG_MAX",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_QUALITY, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTYULONG_NodeID_ULONGMAX, "{F5BB11F1-09E4-42b0-83A3-545319387664}", AUDIO_QUALITY)
    DEVICE_TEST_METHOD( "100.8.2", "   Invalid Node ID - 0x80000001",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_QUALITY, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTYULONG_NodeID_0x80000001, "{8D4CD3C2-62AA-4a60-B767-3454B34DC84B}", AUDIO_QUALITY)
    DEVICE_TEST_METHOD( "100.8.3", "   NULL IN/OUT Buffer",					0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_QUALITY, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTYULONG_NULL_Buffer, "{3B22FD0C-E991-4cd5-90A1-B027146BC711}", AUDIO_QUALITY)
    DEVICE_TEST_METHOD( "100.8.4", "   Small IN/OUT Buffer",					0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_QUALITY, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTYULONG_Small_Buffer, "{80668ADC-D0B9-448c-848F-669A13300665}", AUDIO_QUALITY)
    DEVICE_TEST_METHOD( "100.8.5", "   Out buffer Large",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_QUALITY, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTYULONG_Large_Buffer, "{6DCCA099-22EF-4352-90BD-976784AC0600}", AUDIO_QUALITY)
    DEVICE_TEST_METHOD( "100.8.6", "   valid test data",                                       0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_QUALITY, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTYULONG_Valid_Test, "{F80C5238-0675-44d6-B4A8-69E82F253E5F}", AUDIO_QUALITY)
       
    DEVICE_TEST_PARENT( "", "  KSPROPERTY_AUDIO_REVERB_LEVEL",			0, 0, 0, 0, NULL, "{72246B71-CCA2-4ab5-B1DE-958233E3FA61}")
    DEVICE_TEST_METHOD( "100.9.1", "   Invalid Node ID - ULONG_MAX",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_REVERB_LEVEL, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTYULONG_NodeID_ULONGMAX, "{1B20F74E-AC5D-4d15-8E51-FE15D74944E5}", AUDIO_REVERB_LEVEL)
    DEVICE_TEST_METHOD( "100.9.2", "   Invalid Node ID - 0x80000001",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_REVERB_LEVEL, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTYULONG_NodeID_0x80000001, "{D9475056-E844-4793-AF89-561E2C7D7D89}", AUDIO_REVERB_LEVEL)
    DEVICE_TEST_METHOD( "100.9.3", "   NULL IN/OUT Buffer",					0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_REVERB_LEVEL, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTYULONG_NULL_Buffer, "{5859D4D9-4056-4286-BAA9-69D66246F476}", AUDIO_REVERB_LEVEL)
    DEVICE_TEST_METHOD( "100.9.4", "   Small IN/OUT Buffer",					0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_REVERB_LEVEL, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTYULONG_Small_Buffer, "{0B52DF1F-94D8-4125-A692-EF5CB7B807B2}", AUDIO_REVERB_LEVEL)
    DEVICE_TEST_METHOD( "100.9.5", "   Out buffer Large",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_REVERB_LEVEL, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTYULONG_Large_Buffer, "{D044EDB9-2042-404d-9A38-B658901A0C8E}", AUDIO_REVERB_LEVEL)
    DEVICE_TEST_METHOD( "100.9.6", "   valid test data",                                       0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_REVERB_LEVEL, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTYULONG_Valid_Test, "{D79CA75F-366B-4f46-8C1D-9636E7909ECF}", AUDIO_REVERB_LEVEL)
    DEVICE_TEST_METHOD( "100.9.7", "   Test for Basic support",                                 0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_REVERB_LEVEL, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTY_AUDIO_Basic_Support, "{39C16F2F-F967-4f2c-97CC-814D2195F735}", AUDIO_REVERB_LEVEL)

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_AUDIO_SAMPLING_RATE",			0, 0, 0, 0, NULL, "{6DD0EDA8-1CB8-4bd4-A4E1-B12FBFC537CB}")
    DEVICE_TEST_METHOD( "100.10.1", "   Invalid Node ID - ULONG_MAX",		0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_SAMPLING_RATE, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTYULONG_NodeID_ULONGMAX, "{C164A54B-7221-41fc-AB1B-61EF376E5553}", AUDIO_SAMPLING_RATE)
    DEVICE_TEST_METHOD( "100.10.2", "   Invalid Node ID - 0x80000001",		0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_SAMPLING_RATE, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTYULONG_NodeID_0x80000001, "{400B23EF-8745-4d8c-A9C9-0A871195B8E7}", AUDIO_SAMPLING_RATE)
    DEVICE_TEST_METHOD( "100.10.3", "   NULL IN/OUT Buffer",					0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_SAMPLING_RATE, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTYULONG_NULL_Buffer, "{EA18146B-D290-4278-AD17-8E310BA76186}", AUDIO_SAMPLING_RATE)
    DEVICE_TEST_METHOD( "100.10.4", "   Small IN/OUT Buffer",				0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_SAMPLING_RATE, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTYULONG_Small_Buffer, "{B3C9ACCD-C28A-4ebc-93E7-73C314D5CDD8}", AUDIO_SAMPLING_RATE)
    DEVICE_TEST_METHOD( "100.10.5", "   Out buffer Large",					0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_SAMPLING_RATE, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTYULONG_Large_Buffer, "{C60EE8F0-C78F-4bfa-B68A-2F21F5BF520B}", AUDIO_SAMPLING_RATE)
    DEVICE_TEST_METHOD( "100.10.6", "   valid test data",                                      0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_SAMPLING_RATE, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTYULONG_Valid_Test, "{23D25BE8-37BC-4af4-A563-5C12267D154B}", AUDIO_SAMPLING_RATE)
    DEVICE_TEST_METHOD( "100.10.7", "   setting sampling rate to to Invalid value - DEADBEEF",     0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_SAMPLING_RATE, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTYULONG_SETINVALIDVALUE, "{9D274E36-0992-462e-8722-C1D7E6F5813D}", AUDIO_SAMPLING_RATE)

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_AUDIO_STEREO_SPEAKER_GEOMETRY",	0, 0, 0, 0, NULL, "{40BFB6DE-11CD-4c01-B86C-13164090F925}")
    DEVICE_TEST_METHOD( "100.11.1", "   Invalid Node ID - ULONG_MAX",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_STEREO_SPEAKER_GEOMETRY, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTYULONG_NodeID_ULONGMAX, "{0D341BC4-4DC7-417c-B257-24093461C8A3}", AUDIO_STEREO_SPEAKER_GEOMETRY)
    DEVICE_TEST_METHOD( "100.11.2", "   Invalid Node ID - 0x80000001",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_STEREO_SPEAKER_GEOMETRY, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTYULONG_NodeID_0x80000001, "{A8C4B6CE-C2B4-4262-B09F-001E1EC6002C}", AUDIO_STEREO_SPEAKER_GEOMETRY)
    DEVICE_TEST_METHOD( "100.11.3", "   NULL IN/OUT Buffer",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_STEREO_SPEAKER_GEOMETRY, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTYULONG_NULL_Buffer, "{916CE253-91CF-4fe4-BD19-1AFC1EBC1990}", AUDIO_STEREO_SPEAKER_GEOMETRY)
    DEVICE_TEST_METHOD( "100.11.4", "   Small IN/OUT Buffer",					0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_STEREO_SPEAKER_GEOMETRY, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTYULONG_Small_Buffer, "{0C4B5588-60DA-477e-ACBC-9C24A23FFADB}", AUDIO_STEREO_SPEAKER_GEOMETRY)
    DEVICE_TEST_METHOD( "100.11.5", "   Out buffer Large",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_STEREO_SPEAKER_GEOMETRY, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTYULONG_Large_Buffer, "{A835AF8D-322E-4db5-A4AE-AA389DB9B0B0}", AUDIO_STEREO_SPEAKER_GEOMETRY)
    DEVICE_TEST_METHOD( "100.11.6", "   valid test data",                                             0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_STEREO_SPEAKER_GEOMETRY, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTYULONG_Valid_Test, "{83DC41A8-0014-4ad2-A28B-B07A81FA7B28}", AUDIO_STEREO_SPEAKER_GEOMETRY)
    DEVICE_TEST_METHOD( "100.11.7", "   setting Speaker Geometry to Invalid value - DEADBEEF",            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_STEREO_SPEAKER_GEOMETRY, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTYULONG_SETINVALIDVALUE, "{18A56C4E-B6B0-4df8-B88B-0F05AE4C2E41}", AUDIO_STEREO_SPEAKER_GEOMETRY)

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_AUDIO_DYNAMIC_SAMPLING_RATE",	0, 0, 0, 0, NULL, "{737152CB-13D9-4856-BCCD-B3A6FAF4677B}")
    DEVICE_TEST_METHOD( "100.12.1", "   Invalid Node ID - ULONG_MAX",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_DYNAMIC_SAMPLING_RATE, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTYULONG_NodeID_ULONGMAX, "{ADD1A7C3-B5C6-415e-80DC-20A135F57121}", AUDIO_DYNAMIC_SAMPLING_RATE)
    DEVICE_TEST_METHOD( "100.12.2", "   Invalid Node ID - 0x80000001",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_DYNAMIC_SAMPLING_RATE, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTYULONG_NodeID_0x80000001, "{65C2D0DC-A45A-4773-BD69-99ACDD74BD24}", AUDIO_DYNAMIC_SAMPLING_RATE)
    DEVICE_TEST_METHOD( "100.12.3", "   NULL IN/OUT Buffer",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_DYNAMIC_SAMPLING_RATE, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTYULONG_NULL_Buffer, "{6472A619-E143-42b6-823F-71922C484EA9}", AUDIO_DYNAMIC_SAMPLING_RATE)
    DEVICE_TEST_METHOD( "100.12.4", "   Small IN/OUT Buffer",					0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_DYNAMIC_SAMPLING_RATE, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTYULONG_Small_Buffer, "{5C71A807-9D7B-4ad7-AC10-1ABE860BA063}", AUDIO_DYNAMIC_SAMPLING_RATE)
    DEVICE_TEST_METHOD( "100.12.5", "   Out buffer Large",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_DYNAMIC_SAMPLING_RATE, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTYULONG_Large_Buffer, "{24F652CE-430A-4857-8E83-02CAC9FA28CB}", AUDIO_DYNAMIC_SAMPLING_RATE)
    DEVICE_TEST_METHOD( "100.12.6", "   valid test data",                                            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_DYNAMIC_SAMPLING_RATE, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTYULONG_Valid_Test, "{E9842860-4877-4be1-B51A-E598DEE1E0E2}", AUDIO_DYNAMIC_SAMPLING_RATE)

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_AUDIO_SURROUND_ENCODE",		       0, 0, 0, 0, NULL, "{5597425E-F518-411a-B231-FA48E2DA08F3}")
    DEVICE_TEST_METHOD( "100.13.1", "   Invalid Node ID - ULONG_MAX",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_SURROUND_ENCODE, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTYULONG_NodeID_ULONGMAX, "{BE2B1130-31A6-46df-87F2-4ECB52EC225F}", AUDIO_SURROUND_ENCODE)
    DEVICE_TEST_METHOD( "100.13.2", "   Invalid Node ID - 0x80000001",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_SURROUND_ENCODE, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTYULONG_NodeID_0x80000001, "{830D4107-3B8F-42da-AA93-3358690237A8}", AUDIO_SURROUND_ENCODE)
    DEVICE_TEST_METHOD( "100.13.3", "   NULL IN/OUT Buffer",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_SURROUND_ENCODE, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTYULONG_NULL_Buffer, "{22177F32-895E-4a1b-BD1F-87303643429E}", AUDIO_SURROUND_ENCODE)
    DEVICE_TEST_METHOD( "100.13.4", "   Small IN/OUT Buffer",					0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_SURROUND_ENCODE, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTYULONG_Small_Buffer, "{15354493-C30E-4fdc-B8AB-0ECB6CF1A361}", AUDIO_SURROUND_ENCODE)
    DEVICE_TEST_METHOD( "100.13.5", "   Out buffer Large",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_SURROUND_ENCODE, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTYULONG_Large_Buffer, "{63774103-0AE8-4330-B81B-F760D1B354E0}", AUDIO_SURROUND_ENCODE)
    DEVICE_TEST_METHOD( "100.13.6", "   valid test data",                                             0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_SURROUND_ENCODE, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTYULONG_Valid_Test, "{41EF24D5-0855-44cf-A8D6-2326C66FEBFE}", AUDIO_SURROUND_ENCODE)

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_AUDIO_3D_INTERFACE",			       0, 0, 0, 0, NULL, "{1244FD11-C3A9-485c-85E3-22754D33168D}")
    DEVICE_TEST_METHOD( "100.14.1", "   Invalid Node ID - ULONG_MAX",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_3D_INTERFACE, sizeof(GUID)),
        Generic_Property_KSPROPERTY_AUDIO_3D_INTERFACE_1, "{47C6349E-B544-4a35-B24C-5F0C140F6B23}", AUDIO_3D_INTERFACE)
    DEVICE_TEST_METHOD( "100.14.2", "   Invalid Node ID - 0x80000001",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_3D_INTERFACE, sizeof(GUID)),
        Generic_Property_KSPROPERTY_AUDIO_3D_INTERFACE_2, "{5694458D-F49E-440c-8BDF-A317291EDDFA}", AUDIO_3D_INTERFACE)
    DEVICE_TEST_METHOD( "100.14.3", "   NULL IN/OUT Buffer",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_3D_INTERFACE, sizeof(GUID)),
        Generic_Property_KSPROPERTY_AUDIO_3D_INTERFACE_3, "{5B855657-32D7-4c6e-9AA5-323D98534D41}", AUDIO_3D_INTERFACE)
    DEVICE_TEST_METHOD( "100.14.4", "   Small IN/OUT Buffer",					0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_3D_INTERFACE, sizeof(GUID)),
        Generic_Property_KSPROPERTY_AUDIO_3D_INTERFACE_4, "{113278F2-6DC5-41b0-9D35-4AD9786EF1DF}", AUDIO_3D_INTERFACE)
    DEVICE_TEST_METHOD( "100.14.5", "   Out buffer Large",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_3D_INTERFACE, sizeof(GUID)),
        Generic_Property_KSPROPERTY_AUDIO_3D_INTERFACE_5, "{8762D88F-DB15-4f26-B0C9-2ECDC198222C}", AUDIO_3D_INTERFACE)
    DEVICE_TEST_METHOD( "100.14.6", "   valid test data",						       0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_3D_INTERFACE, sizeof(GUID)),
        Generic_Property_KSPROPERTY_AUDIO_3D_INTERFACE, "{5320868E-DBA7-4bda-AF0B-252BEC43FF8E}", AUDIO_3D_INTERFACE)

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_AUDIO_ALGORITHM_INSTANCE",	       0, 0, 0, 0, NULL, "{42A72B38-36DA-446a-8D46-27916C8DF82E}")
    DEVICE_TEST_METHOD( "100.15.1", "   Invalid Node ID - ULONG_MAX",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_ALGORITHM_INSTANCE, sizeof(GUID)),
        Generic_Property_KSPROPERTY_AUDIO_ALGORITHM_INSTANCE_1, "{F24250DE-188F-4da9-B2F7-3B838F7945B6}", AUDIO_ALGORITHM_INSTANCE)
    DEVICE_TEST_METHOD( "100.15.2", "   Invalid Node ID - 0x80000001",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_ALGORITHM_INSTANCE, sizeof(GUID)),
        Generic_Property_KSPROPERTY_AUDIO_ALGORITHM_INSTANCE_2, "{74774631-1196-4449-BEDE-1C91F394ECE3}", AUDIO_ALGORITHM_INSTANCE)
    DEVICE_TEST_METHOD( "100.15.3", "   NULL IN/OUT Buffer",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_ALGORITHM_INSTANCE, sizeof(GUID)),
        Generic_Property_KSPROPERTY_AUDIO_ALGORITHM_INSTANCE_3, "{A80C4B4C-3049-481c-B1E2-DC528AC16F4E}", AUDIO_ALGORITHM_INSTANCE)
    DEVICE_TEST_METHOD( "100.15.4", "   Small IN/OUT Buffer",					0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_ALGORITHM_INSTANCE, sizeof(GUID)),
        Generic_Property_KSPROPERTY_AUDIO_ALGORITHM_INSTANCE_4, "{8C87A8B4-E4FB-490c-B47A-F12FC06A6A64}", AUDIO_ALGORITHM_INSTANCE)
    DEVICE_TEST_METHOD( "100.15.5", "   Out buffer Large",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_ALGORITHM_INSTANCE, sizeof(GUID)),
        Generic_Property_KSPROPERTY_AUDIO_ALGORITHM_INSTANCE_5, "{37C30526-CA14-4104-8383-E654F874EEBF}", AUDIO_ALGORITHM_INSTANCE)
    DEVICE_TEST_METHOD( "100.15.6", "   valid test data",						       0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_ALGORITHM_INSTANCE, sizeof(GUID)),
        Generic_Property_KSPROPERTY_AUDIO_ALGORITHM_INSTANCE, "{22258091-184A-46de-85CC-121EF88C1C30}", AUDIO_ALGORITHM_INSTANCE)

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_AUDIO_CHANNEL_CONFIG",		       0, 0, 0, 0, NULL, "{6924C9E3-8AEF-4689-85F9-86B0A47774BA}")
    DEVICE_TEST_METHOD( "100.16.1", "   Invalid Node ID - ULONG_MAX",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_CHANNEL_CONFIG, sizeof(KSAUDIO_CHANNEL_CONFIG)),
        Generic_Property_KSPROPERTY_AUDIO_CHANNEL_CONFIG_1, "{599A8DF2-4715-4f22-9CD1-260BA88CFE9A}", AUDIO_CHANNEL_CONFIG)
    DEVICE_TEST_METHOD( "100.16.2", "   Invalid Node ID - 0x80000001",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_CHANNEL_CONFIG, sizeof(KSAUDIO_CHANNEL_CONFIG)),
        Generic_Property_KSPROPERTY_AUDIO_CHANNEL_CONFIG_2, "{3FE71893-88AD-4ce2-B8BF-D4043F7A6B79}", AUDIO_CHANNEL_CONFIG)
    DEVICE_TEST_METHOD( "100.16.3", "   NULL IN/OUT Buffer",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_CHANNEL_CONFIG, sizeof(KSAUDIO_CHANNEL_CONFIG)),
        Generic_Property_KSPROPERTY_AUDIO_CHANNEL_CONFIG_3, "{9582438D-055F-4867-B8AB-E0D1F54ED868}", AUDIO_CHANNEL_CONFIG)
    DEVICE_TEST_METHOD( "100.16.4", "   Small IN/OUT Buffer",					0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_CHANNEL_CONFIG, sizeof(KSAUDIO_CHANNEL_CONFIG)),
        Generic_Property_KSPROPERTY_AUDIO_CHANNEL_CONFIG_4, "{7BEF44D8-41D5-4edc-AEE0-CFE37C243BD6}", AUDIO_CHANNEL_CONFIG)
    DEVICE_TEST_METHOD( "100.16.5", "   Out buffer Large",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_CHANNEL_CONFIG, sizeof(KSAUDIO_CHANNEL_CONFIG)),
        Generic_Property_KSPROPERTY_AUDIO_CHANNEL_CONFIG_5, "{8EFC6E96-8FB4-419e-9B49-0ED9CB8B6935}", AUDIO_CHANNEL_CONFIG)
    DEVICE_TEST_METHOD( "100.16.6", "   Invalid Channel Config",                                0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_CHANNEL_CONFIG, sizeof(KSAUDIO_CHANNEL_CONFIG)),
        Generic_Property_KSPROPERTY_AUDIO_CHANNEL_CONFIG_6, "{E36DF4E8-5E0F-4976-940A-88BA2657A207}", AUDIO_CHANNEL_CONFIG)
    DEVICE_TEST_METHOD( "100.16.7", "   valid test data",						       0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_CHANNEL_CONFIG, sizeof(KSAUDIO_CHANNEL_CONFIG)),
        Generic_Property_KSPROPERTY_AUDIO_CHANNEL_CONFIG, "{A56C10A0-70AF-4c50-BD98-2E7EBE3E4314}", AUDIO_CHANNEL_CONFIG)

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_AUDIO_BASS",				    0, 0, 0, 0, NULL, "{4A9DB271-B3A7-40bd-84D8-D6660892F7A1}")
    DEVICE_TEST_METHOD( "100.17.1", "   Invalid Node ID - ULONG_MAX",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_BASS, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_NodeID_ULONGMAX, "{00CE9F83-7D48-4081-B05F-DD9D4DDDCAAE}", AUDIO_BASS)
    DEVICE_TEST_METHOD( "100.17.2", "   Invalid Node ID - 0x80000001",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_BASS, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_NodeID_0x80000001, "{7E240AFB-6ADA-46ba-9E50-3AA2D442DAEB}", AUDIO_BASS)
    DEVICE_TEST_METHOD( "100.17.3", "   Invalid Channel ID - 0xFFFFFFFE",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_BASS, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_ChannelID_0xFFFFFFFE, "{685A39DD-F1A6-4ccd-B2C7-38A69CE0B112}", AUDIO_BASS)
    DEVICE_TEST_METHOD( "100.17.4", "   Invalid Channel ID - 0x80000001",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_BASS, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_ChannelID_0x80000001, "{7E08099C-E059-42d8-8DEF-AB7C93454F61}", AUDIO_BASS)
    DEVICE_TEST_METHOD( "100.17.5", "   NULL IN/OUT Buffer",                                    0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_BASS, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_NULL_Buffer, "{E50DA2C2-7C4E-4e15-9151-EDD4A980BA66}", AUDIO_BASS)
    DEVICE_TEST_METHOD( "100.17.6", "   Small IN/OUT Buffer",                                   0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_BASS, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_Small_Buffer, "{38A62637-C155-479a-846F-0023EF3CF157}", AUDIO_BASS)
    DEVICE_TEST_METHOD( "100.17.7", "   Out buffer Large",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_BASS, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_Large_Buffer, "{CCD2EFF8-0F7F-4837-B8B7-4929A23578B9}", AUDIO_BASS)
    DEVICE_TEST_METHOD( "100.17.8", "   valid test data",                                            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_BASS, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_Valid_Test, "{187C5FBD-504D-4ed3-8EB7-0ED04B41733E}", AUDIO_BASS)
    DEVICE_TEST_METHOD( "100.17.9", "   Test for Basic support",                                 0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_BASS, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTY_AUDIO_Basic_Support, "{6B1A34FC-C069-49bf-956F-E4FBF1987738}", AUDIO_BASS)

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_AUDIO_MID",				              0, 0, 0, 0, NULL, "{E5DD8B76-0610-4abc-B490-FA08420C8BD8}")
    DEVICE_TEST_METHOD( "100.18.1", "   Invalid Node ID - ULONG_MAX",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_MID, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_NodeID_ULONGMAX, "{C10ECB67-6DC0-4a40-AA0C-B17F38E1D496}", AUDIO_MID)
    DEVICE_TEST_METHOD( "100.18.2", "   Invalid Node ID - 0x80000001",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_MID, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_NodeID_0x80000001, "{4A97B95E-DDBD-4ed5-8907-48618A81FD07}", AUDIO_MID)
    DEVICE_TEST_METHOD( "100.18.3", "   Invalid Channel ID - 0xFFFFFFFE",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_MID, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_ChannelID_0xFFFFFFFE, "{DB89E340-1B37-4523-B765-35BA9698559F}", AUDIO_MID)
    DEVICE_TEST_METHOD( "100.18.4", "   Invalid Channel ID - 0x80000001",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_MID, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_ChannelID_0x80000001, "{0D2F816A-4520-427b-906B-F37A5AD0B26D}", AUDIO_MID)
    DEVICE_TEST_METHOD( "100.18.5", "   NULL IN/OUT Buffer",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_MID, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_NULL_Buffer, "{75C49AB5-8150-44e1-8313-8681986D8993}", AUDIO_MID)
    DEVICE_TEST_METHOD( "100.18.6", "   Small IN/OUT Buffer",                                   0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_MID, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_Small_Buffer, "{173BE0F0-F523-4f84-9A85-8B5B7D07374F}", AUDIO_MID)
    DEVICE_TEST_METHOD( "100.18.7", "   Out buffer Large",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_MID, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_Large_Buffer, "{9535AE53-22A6-4d19-8F6F-F915E35F1CAD}", AUDIO_MID)
    DEVICE_TEST_METHOD( "100.18.8", "   valid test data",                                            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_MID, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_Valid_Test, "{8A5F623E-B90B-4eb3-9ABD-E6572F5CA41D}", AUDIO_MID)
    DEVICE_TEST_METHOD( "100.18.9", "   Test for Basic support",                                 0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_MID, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTY_AUDIO_Basic_Support, "{AA6C9B3A-493A-47bc-89CC-8DC9BE4CFC3F}", AUDIO_MID)

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_AUDIO_PEAKMETER",				       0, 0, 0, 0, NULL, "{A990B431-0033-408c-8A2F-8110AA9BF790}")
    DEVICE_TEST_METHOD( "100.19.1", "   Invalid Node ID - ULONG_MAX",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_PEAKMETER, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_NodeID_ULONGMAX, "{97978CFB-7B2B-4efe-BEEC-A233AFE45EA5}", AUDIO_PEAKMETER)
    DEVICE_TEST_METHOD( "100.19.2", "   Invalid Node ID - 0x80000001",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_PEAKMETER, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_NodeID_0x80000001, "{EEE6F065-6351-4827-BE43-7671A802E969}", AUDIO_PEAKMETER)
    DEVICE_TEST_METHOD( "100.19.3", "   Invalid Channel ID - 0xFFFFFFFE",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_PEAKMETER, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_ChannelID_0xFFFFFFFE, "{20288B10-6284-4440-9053-3AC4249A5276}", AUDIO_PEAKMETER)
    DEVICE_TEST_METHOD( "100.19.4", "   Invalid Channel ID - 0x80000001",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_PEAKMETER, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_ChannelID_0x80000001, "{0B37080D-967B-4d71-BC09-A66847D011FA}", AUDIO_PEAKMETER)
    DEVICE_TEST_METHOD( "100.19.5", "   NULL IN/OUT Buffer",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_PEAKMETER, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_NULL_Buffer, "{624D9DC6-D051-44da-B106-C47A757E4FAC}", AUDIO_PEAKMETER)
    DEVICE_TEST_METHOD( "100.19.6", "   Small IN/OUT Buffer",                                   0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_PEAKMETER, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_Small_Buffer, "{AAD9CF8B-E97E-4e9d-BB8B-702CD50D713B}", AUDIO_PEAKMETER)
    DEVICE_TEST_METHOD( "100.19.7", "   Out buffer Large",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_PEAKMETER, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_Large_Buffer, "{7D3F4F43-6D56-4356-8797-507B2BD785CE}", AUDIO_PEAKMETER)
    DEVICE_TEST_METHOD( "100.19.8", "   valid test data",                                            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_PEAKMETER, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_Valid_Test, "{B3E01053-460D-4be8-9031-CBA90AF52B87}", AUDIO_PEAKMETER)
    DEVICE_TEST_METHOD( "100.19.9", "   Test for Basic support",                                 0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_PEAKMETER, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTY_AUDIO_Basic_Support, "{03174B72-9675-47c5-A93A-70A63E6BEA97}", AUDIO_PEAKMETER)
    
    DEVICE_TEST_PARENT( "", "  KSPROPERTY_AUDIO_TREBLE",				              0, 0, 0, 0, NULL, "{8CFC9326-3087-4f4d-8422-C701E1CA0511}")
    DEVICE_TEST_METHOD( "100.20.1", "   Invalid Node ID - ULONG_MAX",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_TREBLE, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_NodeID_ULONGMAX, "{BC2E941E-5855-47f1-BCC7-8384EA3DEC76}", AUDIO_TREBLE)
    DEVICE_TEST_METHOD( "100.20.2", "   Invalid Node ID - 0x80000001",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_TREBLE, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_NodeID_0x80000001, "{838DD8FA-7323-486c-A031-55AFC6EF78CE}", AUDIO_TREBLE)
    DEVICE_TEST_METHOD( "100.20.3", "   Invalid Channel ID - 0xFFFFFFFE",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_TREBLE, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_ChannelID_0xFFFFFFFE, "{FBE5A50C-511C-4593-B514-176D81E13C02}", AUDIO_TREBLE)
    DEVICE_TEST_METHOD( "100.20.4", "   Invalid Channel ID - 0x80000001",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_TREBLE, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_ChannelID_0x80000001, "{EE8A7183-A90B-4d6a-BDAF-BF3893BCF024}", AUDIO_TREBLE)
    DEVICE_TEST_METHOD( "100.20.5", "   NULL IN/OUT Buffer",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_TREBLE, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_NULL_Buffer, "{9E58FCEF-3E7F-428b-A7F0-E34EDDB1B3D3}", AUDIO_TREBLE)
    DEVICE_TEST_METHOD( "100.20.6", "   Small IN/OUT Buffer",                                   0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_TREBLE, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_Small_Buffer, "{9954E81E-58E8-45cb-BA79-C9235A1A4809}", AUDIO_TREBLE)
    DEVICE_TEST_METHOD( "100.20.7", "   Out buffer Large",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_TREBLE, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_Large_Buffer, "{1C3863A3-A38A-4520-869E-A931D538E6BC}", AUDIO_TREBLE)
    DEVICE_TEST_METHOD( "100.20.8", "   valid test data",                                            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_TREBLE, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_Valid_Test, "{4DB5D16F-A839-4478-B730-FF2F07F0A88A}", AUDIO_TREBLE)
    DEVICE_TEST_METHOD( "100.20.9", "   Test for Basic support",                                 0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_TREBLE, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTY_AUDIO_Basic_Support, "{6F8CBFE3-D6EE-42c9-8765-9C8C0F671A15}", AUDIO_TREBLE)
    
    DEVICE_TEST_PARENT( "", "  KSPROPERTY_AUDIO_VOLUMELEVEL",			0, 0, 0, 0, NULL, "{4469B699-CB5E-40bb-8FF4-EF24026FC4D9}")
    DEVICE_TEST_METHOD( "100.21.1", "   Invalid Node ID - ULONG_MAX",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_VOLUMELEVEL, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_NodeID_ULONGMAX, "{044DF31F-3194-4763-9359-3AE43D88271F}", AUDIO_VOLUMELEVEL)
    DEVICE_TEST_METHOD( "100.21.2", "   Invalid Node ID - 0x80000001",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_VOLUMELEVEL, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_NodeID_0x80000001, "{27BB6D0E-6601-44e8-A4E4-5E3D910BE614}", AUDIO_VOLUMELEVEL)
    DEVICE_TEST_METHOD( "100.21.3", "   Invalid Channel ID - 0xFFFFFFFE",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_VOLUMELEVEL, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_ChannelID_0xFFFFFFFE, "{4BEB2159-2A35-497e-B858-33740393A9DF}", AUDIO_VOLUMELEVEL)
    DEVICE_TEST_METHOD( "100.21.4", "   Invalid Channel ID - 0x80000001",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_VOLUMELEVEL, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_ChannelID_0x80000001, "{89C8AC0C-6B2F-4b65-B5E1-D5413FD81CE9}", AUDIO_VOLUMELEVEL)
    DEVICE_TEST_METHOD( "100.21.5", "   NULL IN/OUT Buffer",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_VOLUMELEVEL, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_NULL_Buffer, "{DC6111B1-E257-4b04-9789-E1CDAF85F230}", AUDIO_VOLUMELEVEL)
    DEVICE_TEST_METHOD( "100.21.6", "   Small IN/OUT Buffer",                                   0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_VOLUMELEVEL, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_Small_Buffer, "{D7BE5B69-4AD7-40c0-B495-0238C8AAD026}", AUDIO_VOLUMELEVEL)
    DEVICE_TEST_METHOD( "100.21.7", "   Out buffer Large",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_VOLUMELEVEL, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_Large_Buffer, "{1A7C3717-213D-49f9-8329-C42CFBDD9CC8}", AUDIO_VOLUMELEVEL)
    DEVICE_TEST_METHOD( "100.21.8", "   valid test data",                                            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_VOLUMELEVEL, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_Valid_Test, "{F4D3CD56-6DD3-4bf9-B7CA-D16368CCE61F}", AUDIO_VOLUMELEVEL)
    DEVICE_TEST_METHOD( "100.21.9", "   Test for Basic support",                                 0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_VOLUMELEVEL, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTY_AUDIO_Basic_Support, "{C85C6FF8-13B9-45d5-9D05-BEC07490BFF5}", AUDIO_VOLUMELEVEL)
    
    DEVICE_TEST_PARENT( "", "  KSPROPERTY_AUDIO_AGC",				    0, 0, 0, 0, NULL, "{DE7E8DA1-D0FF-4ecc-A569-AAFD957186B7}")
    DEVICE_TEST_METHOD( "100.22.1", "   Invalid Node ID - ULONG_MAX",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_AGC, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_NodeID_ULONGMAX, "{5F71F59E-314B-45a5-AE18-553E6AC6F996}", AUDIO_AGC)
    DEVICE_TEST_METHOD( "100.22.2", "   Invalid Node ID - 0x80000001",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_AGC, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_NodeID_0x80000001, "{53962891-154F-4c07-A23A-0246FD0AE828}", AUDIO_AGC)
    DEVICE_TEST_METHOD( "100.22.3", "   Invalid Channel ID - 0xFFFFFFFE",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_AGC, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_ChannelID_0xFFFFFFFE, "{4D2FE53E-BDF4-47ba-B7FE-B05D7B5EE70D}", AUDIO_AGC)
    DEVICE_TEST_METHOD( "100.22.4", "   Invalid Channel ID - 0x80000001",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_AGC, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_ChannelID_0x80000001, "{3F15A3E2-B8C2-4ecb-9531-B125E1750E4E}", AUDIO_AGC)
    DEVICE_TEST_METHOD( "100.22.5", "   NULL IN/OUT Buffer",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_AGC, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_NULL_Buffer, "{09EEF5DA-F78B-4a8a-8E77-A499B5265135}", AUDIO_AGC)
    DEVICE_TEST_METHOD( "100.22.6", "   Small IN/OUT Buffer",                                   0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_AGC, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_Small_Buffer, "{E7DD52BD-27E3-4a03-BD88-8E8053612635}", AUDIO_AGC)
    DEVICE_TEST_METHOD( "100.22.7", "   Out buffer Large",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_AGC, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_Large_Buffer, "{4C0B5B2D-2D64-4154-B2FF-4C1838D7EC90}", AUDIO_AGC)
    DEVICE_TEST_METHOD( "100.22.8", "   valid test data",                                            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_AGC, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_Valid_Test, "{DB8F7AC1-1629-44c8-8A7D-726AA15DC079}", AUDIO_AGC)
    DEVICE_TEST_METHOD( "100.22.9", "   Test for Basic support",                                 0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_AGC, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTY_AUDIO_Basic_Support, "{8B0C3121-87DA-4d82-83BB-0C5353C58683}", AUDIO_AGC)
    
    DEVICE_TEST_PARENT( "", "  KSPROPERTY_AUDIO_BASS_BOOST",			0, 0, 0, 0, NULL, "{D9483D96-97C7-4870-BF8D-334F9D27BDC7}")
    DEVICE_TEST_METHOD( "100.23.1", "   Invalid Node ID - ULONG_MAX",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_BASS_BOOST, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_NodeID_ULONGMAX, "{C84A394A-2DEE-4b01-AB6E-22CB88BA42A8}", AUDIO_BASS_BOOST)
    DEVICE_TEST_METHOD( "100.23.2", "   Invalid Node ID - 0x80000001",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_BASS_BOOST, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_NodeID_0x80000001, "{DD4F9DCD-05ED-471f-B750-91A0A4772D91}", AUDIO_BASS_BOOST)
    DEVICE_TEST_METHOD( "100.23.3", "   Invalid Channel ID - 0xFFFFFFFE",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_BASS_BOOST, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_ChannelID_0xFFFFFFFE, "{1DF244CB-8EAA-4f33-AE83-B1D8F3A22532}", AUDIO_BASS_BOOST)
    DEVICE_TEST_METHOD( "100.23.4", "   Invalid Channel ID - 0x80000001",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_BASS_BOOST, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_ChannelID_0x80000001, "{02E3FA64-D7B7-43a6-BCE2-1C9C5CB0888E}", AUDIO_BASS_BOOST)
    DEVICE_TEST_METHOD( "100.23.5", "   NULL IN/OUT Buffer",                                    0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_BASS_BOOST, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_NULL_Buffer, "{30B0C779-E1E0-45ac-AB09-E69C304F1433}", AUDIO_BASS_BOOST)
    DEVICE_TEST_METHOD( "100.23.6", "   Small IN/OUT Buffer",                                   0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_BASS_BOOST, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_Small_Buffer, "{6B2D9D51-F230-4dde-872C-B8A72066B747}", AUDIO_BASS_BOOST)
    DEVICE_TEST_METHOD( "100.23.7", "   Out buffer Large",                                         0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_BASS_BOOST, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_Large_Buffer, "{04BD52C6-3B9F-4499-A6CF-5CD86B1F854C}", AUDIO_BASS_BOOST)
    DEVICE_TEST_METHOD( "100.23.8", "   valid test data",                                            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_BASS_BOOST, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_Valid_Test, "{3F2D87CE-6450-4f87-8EA9-4748DC565C1F}", AUDIO_BASS_BOOST)
    DEVICE_TEST_METHOD( "100.23.9", "   Test for Basic support",                                 0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_BASS_BOOST, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTY_AUDIO_Basic_Support, "{461F5F4C-D42B-4b91-83CD-F260B1C2FC1C}", AUDIO_BASS_BOOST)
    
    DEVICE_TEST_PARENT( "", "  KSPROPERTY_AUDIO_LOUDNESS",				0, 0, 0, 0, NULL, "{6B2EE1C5-6264-4b9e-88CE-E2E6D0C3675B}")
    DEVICE_TEST_METHOD( "100.24.1", "   Invalid Node ID - ULONG_MAX",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_LOUDNESS, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_NodeID_ULONGMAX, "{F81BA94A-207B-466a-8777-8316E086828B}", AUDIO_LOUDNESS)
    DEVICE_TEST_METHOD( "100.24.2", "   Invalid Node ID - 0x80000001",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_LOUDNESS, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_NodeID_0x80000001, "{BDC73CE2-B20D-4d9d-A2FE-F2264ABFAF79}", AUDIO_LOUDNESS)
    DEVICE_TEST_METHOD( "100.24.3", "   Invalid Channel ID - 0xFFFFFFFE",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_LOUDNESS, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_ChannelID_0xFFFFFFFE, "{E07232C8-886A-4cc6-A538-12CC23343AD2}", AUDIO_LOUDNESS)
    DEVICE_TEST_METHOD( "100.24.4", "   Invalid Channel ID - 0x80000001",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_LOUDNESS, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_ChannelID_0x80000001, "{0D7DA0EA-291A-4b90-9340-7D2D4936F75B}", AUDIO_LOUDNESS)
    DEVICE_TEST_METHOD( "100.24.5", "   NULL IN/OUT Buffer",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_LOUDNESS, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_NULL_Buffer, "{33677C79-0998-4f61-979E-D2C3A31D230F}", AUDIO_LOUDNESS)
    DEVICE_TEST_METHOD( "100.24.6", "   Small IN/OUT Buffer",                                   0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_LOUDNESS, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_Small_Buffer, "{6C85E181-C0CF-426c-9D83-C317CFC14CE9}", AUDIO_LOUDNESS)
    DEVICE_TEST_METHOD( "100.24.7", "   Out buffer Large",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_LOUDNESS, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_Large_Buffer, "{B6BAC5F0-5EEE-4c11-993B-524060BBBC43}", AUDIO_LOUDNESS)
    DEVICE_TEST_METHOD( "100.24.8", "   valid test data",                                            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_LOUDNESS, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_Valid_Test, "{D69035EF-10D5-40b2-9254-E7DCD4BD29B0}", AUDIO_LOUDNESS)
    DEVICE_TEST_METHOD( "100.24.9", "   Test for Basic support",                                 0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_LOUDNESS, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTY_AUDIO_Basic_Support, "{2F16C748-1A07-4a54-89D9-367144963D16}", AUDIO_LOUDNESS)
    
    DEVICE_TEST_PARENT( "", "  KSPROPERTY_AUDIO_MUTE",				0, 0, 0, 0, NULL, "{F2F08C62-23B2-4961-8303-DC437BA15DBF}")
    DEVICE_TEST_METHOD( "100.25.1", "   Invalid Node ID - ULONG_MAX",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_MUTE, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_NodeID_ULONGMAX, "{44E39107-4538-4db8-B9C1-1EBF2FEDF81E}", AUDIO_MUTE)
    DEVICE_TEST_METHOD( "100.25.2", "   Invalid Node ID - 0x80000001",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_MUTE, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_NodeID_0x80000001, "{93DD7FB5-F5DE-49db-8E94-C9128C1BBE02}", AUDIO_MUTE)
    DEVICE_TEST_METHOD( "100.25.3", "   Invalid Channel ID - 0xFFFFFFFE",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_MUTE, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_ChannelID_0xFFFFFFFE, "{EE9D94C7-7CE7-4a73-B2DD-16616409E193}", AUDIO_MUTE)
    DEVICE_TEST_METHOD( "100.25.4", "   Invalid Channel ID - 0x80000001",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_MUTE, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_ChannelID_0x80000001, "{A67BB2D8-226D-4488-9CE8-FBAEFF1E55C3}", AUDIO_MUTE)
    DEVICE_TEST_METHOD( "100.25.5", "   NULL IN/OUT Buffer",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_MUTE, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_NULL_Buffer, "{AF6698DC-E50A-448f-A88F-43E5B40FE63E}", AUDIO_MUTE)
    DEVICE_TEST_METHOD( "100.25.6", "   Small IN/OUT Buffer",                                   0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_MUTE, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_Small_Buffer, "{0BD9A469-FC58-4c0c-B191-48A4165CBCCD}", AUDIO_MUTE)
    DEVICE_TEST_METHOD( "100.25.7", "   Out buffer Large",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_MUTE, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_Large_Buffer, "{7D41C95C-551C-434f-AEAE-186957CE39F4}", AUDIO_MUTE)
    DEVICE_TEST_METHOD( "100.25.8", "   valid test data",                                            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_MUTE, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTY_AUDIO_CHANNELULONG_Valid_Test, "{A6650402-60B7-47ce-B17A-63390016BC84}", AUDIO_MUTE)
    DEVICE_TEST_METHOD( "100.25.9", "   Test for Basic support",                                 0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_MUTE, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTY_AUDIO_Basic_Support, "{B5BB6EAD-1A77-42dc-A29C-86A95E236572}", AUDIO_MUTE)
    
    DEVICE_TEST_PARENT( "", "  KSPROPERTY_AUDIO_DELAY",				0, 0, 0, 0, NULL, "{4B3FD21B-AC9C-4d34-96D9-6D5C9CE1DEB6}")
    DEVICE_TEST_METHOD( "100.26.1", "   Invalid Node ID - ULONG_MAX",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_DELAY, sizeof(KSTIME)),
        Generic_Property_KSPROPERTY_AUDIO_DELAY_1, "{5CF445CC-AC1A-4c6c-928A-A62E5CEFB44F}", AUDIO_DELAY)
    DEVICE_TEST_METHOD( "100.26.2", "   Invalid Node ID - 0x80000001",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_DELAY, sizeof(KSTIME)),
        Generic_Property_KSPROPERTY_AUDIO_DELAY_2, "{A16A72E6-25E9-40a3-9E8C-716D3BCEE317}", AUDIO_DELAY)
    DEVICE_TEST_METHOD( "100.26.3", "   Invalid Channel ID - 0xFFFFFFFE",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_DELAY, sizeof(KSTIME)),
        Generic_Property_KSPROPERTY_AUDIO_DELAY_3, "{95E36F80-4848-4de9-A414-5E076B2EB2F8}", AUDIO_DELAY)
    DEVICE_TEST_METHOD( "100.26.4", "   Invalid Channel ID - 0x80000001",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_DELAY, sizeof(KSTIME)),
        Generic_Property_KSPROPERTY_AUDIO_DELAY_4, "{7A0E3D57-2BC9-4692-8D7A-9B85CF52D57C}", AUDIO_DELAY)
    DEVICE_TEST_METHOD( "100.26.5", "   NULL IN/OUT Buffer",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_DELAY, sizeof(KSTIME)),
        Generic_Property_KSPROPERTY_AUDIO_DELAY_5, "{23342700-C0F6-4dd9-919F-ECB2E650AA4C}", AUDIO_DELAY)
    DEVICE_TEST_METHOD( "100.26.6", "   Small IN/OUT Buffer",                                   0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_DELAY, sizeof(KSTIME)),
        Generic_Property_KSPROPERTY_AUDIO_DELAY_6, "{843E1EF0-8165-4aa3-8E7F-D86159FE9F2F}", AUDIO_DELAY)
    DEVICE_TEST_METHOD( "100.26.7", "   Out buffer Large",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_DELAY, sizeof(KSTIME)),
        Generic_Property_KSPROPERTY_AUDIO_DELAY_7, "{178FF288-74A8-4a00-A8DF-BA2A17D8861A}", AUDIO_DELAY)
    DEVICE_TEST_METHOD( "100.26.8", "   Negative Time Value",                                   0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_DELAY, sizeof(KSTIME)),
        Generic_Property_KSPROPERTY_AUDIO_DELAY_8, "{2D35CCF5-34CA-417e-9BD4-4B8E98AEBA68}", AUDIO_DELAY)
    DEVICE_TEST_METHOD( "100.26.9", "   Zero Numerator",                                          0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_DELAY, sizeof(KSTIME)),
        Generic_Property_KSPROPERTY_AUDIO_DELAY_9, "{2B652B82-DC58-4744-9472-3E1980488E4E}", AUDIO_DELAY)
    DEVICE_TEST_METHOD( "100.26.10", "   Zero Denominator",                                     0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_DELAY, sizeof(KSTIME)),
        Generic_Property_KSPROPERTY_AUDIO_DELAY_10, "{2C77758D-A2EB-4fde-85A9-A8CAF3F1F2B2}", AUDIO_DELAY)
    DEVICE_TEST_METHOD( "100.26.11", "   valid test data",                                           0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_DELAY, sizeof(KSTIME)),
        Generic_Property_KSPROPERTY_AUDIO_DELAY, "{EC01D791-134D-41d0-9BAA-F14070EA4877}", AUDIO_DELAY)

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_AUDIO_LATENCY",				0, 0, 0, 0, NULL, "{F5047800-FFC7-4628-829D-E72D021C0652}")
    DEVICE_TEST_METHOD( "100.27.1", "   NULL IN/OUT Buffer",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_LATENCY, sizeof(KSTIME)),
        Generic_Property_KSPROPERTY_AUDIO_LATENCY_1, "{ACFDA42A-77F9-4693-B955-AA33BE30D277}", AUDIO_LATENCY)
    DEVICE_TEST_METHOD( "100.27.2", "   Small IN/OUT Buffer",                                   0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_LATENCY, sizeof(KSTIME)),
        Generic_Property_KSPROPERTY_AUDIO_LATENCY_2, "{6B7CB9AF-8F3A-427e-9FFA-B2675A83E140}", AUDIO_LATENCY)
    DEVICE_TEST_METHOD( "100.27.3", "   Out buffer Large",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_LATENCY, sizeof(KSTIME)),
        Generic_Property_KSPROPERTY_AUDIO_LATENCY_3, "{8A6AFFC7-5855-482a-99B8-D4010D163240}", AUDIO_LATENCY)
    DEVICE_TEST_METHOD( "100.27.4", "   Valid test",                                                    0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_LATENCY, sizeof(KSTIME)),
        Generic_Property_KSPROPERTY_AUDIO_LATENCY, "{C0D38A8E-0107-4b08-9D19-C06424301B15}", AUDIO_LATENCY)

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_AUDIO_DYNAMIC_RANGE",		0, 0, 0, 0, NULL, "{EBB45F92-9E8D-4d3e-9477-705EE21753FE}")
    DEVICE_TEST_METHOD( "100.28.1", "   Invalid Node ID - ULONG_MAX",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_DYNAMIC_RANGE, sizeof(KSAUDIO_DYNAMIC_RANGE)),
        Generic_Property_KSPROPERTY_AUDIO_DYNAMIC_RANGE_1, "{F328EEC6-970F-4a66-8656-1C67044AFDDE}", AUDIO_DYNAMIC_RANGE)
    DEVICE_TEST_METHOD( "100.28.2", "   Invalid Node ID - 0x80000001",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_DYNAMIC_RANGE, sizeof(KSAUDIO_DYNAMIC_RANGE)),
        Generic_Property_KSPROPERTY_AUDIO_DYNAMIC_RANGE_2, "{AE233D1E-3FBC-4f02-9BBB-3D0CEDDE97F5}", AUDIO_DYNAMIC_RANGE)
    DEVICE_TEST_METHOD( "100.28.3", "   NULL IN/OUT Buffer",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_DYNAMIC_RANGE, sizeof(KSAUDIO_DYNAMIC_RANGE)),
        Generic_Property_KSPROPERTY_AUDIO_DYNAMIC_RANGE_3, "{3CA94D1F-A7BC-4599-858B-EDC82FD820D0}", AUDIO_DYNAMIC_RANGE)
    DEVICE_TEST_METHOD( "100.28.4", "   Small IN/OUT Buffer",					0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_DYNAMIC_RANGE, sizeof(KSAUDIO_DYNAMIC_RANGE)),
        Generic_Property_KSPROPERTY_AUDIO_DYNAMIC_RANGE_4, "{96C4BD26-2D56-4c4f-ADC1-E584D56BC0C5}", AUDIO_DYNAMIC_RANGE)
    DEVICE_TEST_METHOD( "100.28.5", "   Out buffer Large",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_DYNAMIC_RANGE, sizeof(KSAUDIO_DYNAMIC_RANGE)),
        Generic_Property_KSPROPERTY_AUDIO_DYNAMIC_RANGE_5, "{BEB6BFA3-E9EA-44df-BFF8-D51910EF3080}", AUDIO_DYNAMIC_RANGE)
    DEVICE_TEST_METHOD( "100.28.6", "   Valid Test",                                                   0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_DYNAMIC_RANGE, sizeof(KSAUDIO_DYNAMIC_RANGE)),
        Generic_Property_KSPROPERTY_AUDIO_DYNAMIC_RANGE, "{45D513EE-C121-4942-BF31-0BEA8BAD71CB}", AUDIO_DYNAMIC_RANGE)

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_AUDIO_EQ_BANDS",		                    0, 0, 0, 0, NULL, "{5b4d5aa1-b294-48b9-a37d-5a37b71db28b}")
    DEVICE_TEST_METHOD( "100.29.1", "   Invalid Node ID - ULONG_MAX",		      0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_EQ_BANDS, sizeof(ULONG)),
        Generic_Property_KSPROPERTY_AUDIO_EQ_BANDS_1, "{fdf84d5e-f4e4-4f16-a72d-dbf25ee9e9bd}", AUDIO_EQ_BANDS)
    DEVICE_TEST_METHOD( "100.29.2", "   Invalid Node ID - 0x80000001",                    0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_EQ_BANDS, sizeof(ULONG)),
        Generic_Property_KSPROPERTY_AUDIO_EQ_BANDS_2, "{6e795520-526b-40b9-8cb2-1a25b98ec233}", AUDIO_EQ_BANDS)
    DEVICE_TEST_METHOD( "100.29.3", "   Invalid Channel Number - 0xFFFFFFFE",          0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_EQ_BANDS, sizeof(ULONG)),
        Generic_Property_KSPROPERTY_AUDIO_EQ_BANDS_3, "{e79f6100-c715-432c-b12b-7f68c994332c}", AUDIO_EQ_BANDS)
    DEVICE_TEST_METHOD( "100.29.4", "   Invalid Channel Number - 0x80000001",        0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_EQ_BANDS, sizeof(ULONG)),
        Generic_Property_KSPROPERTY_AUDIO_EQ_BANDS_4, "{6e6e03c0-c85b-42a9-9746-8eadb131ba26}", AUDIO_EQ_BANDS)
    DEVICE_TEST_METHOD( "100.29.5", "   Out buffer NULL",                                         0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_EQ_BANDS, sizeof(ULONG)),
        Generic_Property_KSPROPERTY_AUDIO_EQ_BANDS_5, "{b821f657-2d2d-4c41-aae2-aeced1caff1d}", AUDIO_EQ_BANDS)
    DEVICE_TEST_METHOD( "100.29.6", "   Out buffer Small",                                        0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_EQ_BANDS, sizeof(ULONG)),
        Generic_Property_KSPROPERTY_AUDIO_EQ_BANDS_6, "{148a3a50-b1b7-44d2-8855-d963361a523e}", AUDIO_EQ_BANDS)
    DEVICE_TEST_METHOD( "100.29.7", "   Out buffer Large",                                        0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_EQ_BANDS, sizeof(ULONG)),
        Generic_Property_KSPROPERTY_AUDIO_EQ_BANDS_7, "{46FBA26D-F104-4c40-A725-33DB30FAF92A}", AUDIO_EQ_BANDS)
    DEVICE_TEST_METHOD( "100.29.8", "   Valid Test",                                                  0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_EQ_BANDS, sizeof(ULONG)),
        Generic_Property_KSPROPERTY_AUDIO_EQ_BANDS, "{243D6CB0-DD18-48d4-BD84-83576D367B49}", AUDIO_EQ_BANDS)

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_AUDIO_EQ_LEVEL",                            0, 0, 0, 0, NULL, "{7e08af24-0e83-4533-b212-7e816cb046ad}")
    DEVICE_TEST_METHOD( "100.30.1", "   Invalid Node ID - ULONG_MAX",                 0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_EQ_LEVEL, sizeof(ULONG)),
        Generic_Property_KSPROPERTY_AUDIO_EQ_LEVEL_1, "{3c2bcaa3-eefa-45ea-9b09-20502d7fda2e}", AUDIO_EQ_LEVEL)
    DEVICE_TEST_METHOD( "100.30.2", "   Invalid Node ID - 0x80000001",                  0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_EQ_LEVEL, sizeof(ULONG)),
        Generic_Property_KSPROPERTY_AUDIO_EQ_LEVEL_2, "{5d95bb54-da25-4b95-8bb0-09e85ded8e45}", AUDIO_EQ_LEVEL)
    DEVICE_TEST_METHOD( "100.30.3", "   Invalid Channel Number - 0xFFFFFFFE",       0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_EQ_LEVEL, sizeof(ULONG)),
        Generic_Property_KSPROPERTY_AUDIO_EQ_LEVEL_3, "{a6ea9207-637e-4c9c-83df-92dbcd116508}", AUDIO_EQ_LEVEL)
    DEVICE_TEST_METHOD( "100.30.4", "   Invalid Channel Number - 0x80000001",      0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_EQ_LEVEL, sizeof(ULONG)),
        Generic_Property_KSPROPERTY_AUDIO_EQ_LEVEL_4, "{521bd184-0835-445c-96b6-97c625f684c5}", AUDIO_EQ_LEVEL)
    DEVICE_TEST_METHOD( "100.30.5", "   NULL IN/OUT Buffer",                                 0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_EQ_LEVEL, sizeof(ULONG)),
        Generic_Property_KSPROPERTY_AUDIO_EQ_LEVEL_5, "{61826a63-ae13-4a45-9a59-2cb15a3f0b0c}", AUDIO_EQ_LEVEL)
    DEVICE_TEST_METHOD( "100.30.6", "   Small IN/OUT Buffer",                                0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_EQ_LEVEL, sizeof(ULONG)),
        Generic_Property_KSPROPERTY_AUDIO_EQ_LEVEL_6, "{65d583ea-6776-46fd-9cca-a872751b18eb}", AUDIO_EQ_LEVEL)
    DEVICE_TEST_METHOD( "100.30.7", "   Out buffer Large",                                      0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_EQ_LEVEL, sizeof(ULONG)),
        Generic_Property_KSPROPERTY_AUDIO_EQ_LEVEL_7, "{7c8aa568-3eed-49c1-a44f-0ca6d26b2e7d}", AUDIO_EQ_LEVEL)
    DEVICE_TEST_METHOD( "100.30.8", "   Valid Test",                                                0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_EQ_LEVEL, sizeof(ULONG)),
        Generic_Property_KSPROPERTY_AUDIO_EQ_LEVEL, "{E2546E15-9DFE-4ef9-B90D-7D354CDE4813}", AUDIO_EQ_LEVEL)

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_AUDIO_FILTER_STATE",                0, 0, 0, 0, NULL, "{c01aba3e-b346-432e-837d-e28373440aa4}")
    DEVICE_TEST_METHOD( "100.31.1", "   Out buffer NULL",                                 0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_FILTER_STATE, sizeof(GUID)),
        Generic_Property_KSPROPERTY_AUDIO_FILTER_STATE_1, "{f00b4250-fb97-46f6-96f7-3688ff477ec1}", AUDIO_FILTER_STATE)
    DEVICE_TEST_METHOD( "100.31.2", "   Out buffer Small",                                0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_FILTER_STATE, sizeof(GUID)),
        Generic_Property_KSPROPERTY_AUDIO_FILTER_STATE_2, "{5c410ce1-8989-490e-b9ca-3aeedf58c123}", AUDIO_FILTER_STATE)
    DEVICE_TEST_METHOD( "100.31.3", "   Out buffer Large",                                0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_FILTER_STATE, sizeof(GUID)),
        Generic_Property_KSPROPERTY_AUDIO_FILTER_STATE_3, "{863324bd-fa81-4621-9745-7cb0fedde430}", AUDIO_FILTER_STATE)
    DEVICE_TEST_METHOD( "100.31.4", "   Valid Testing",                                     0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_FILTER_STATE, sizeof(GUID)),
        Generic_Property_KSPROPERTY_AUDIO_FILTER_STATE, "{79422876-B67F-4a96-AEF0-E0FB826A1D70}", AUDIO_FILTER_STATE)

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_AUDIO_MIX_LEVEL_TABLE",         0, 0, 0, 0, NULL, "{e9d27c8b-5687-4193-802a-1c876e6697eb}")
    DEVICE_TEST_METHOD( "100.32.1", "   Invalid Node ID - ULONG_MAX",          0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_MIX_LEVEL_TABLE, sizeof(KSAUDIO_MIXLEVEL)),
        Generic_Property_KSPROPERTY_AUDIO_MIX_LEVEL_TABLE_1, "{2a32b494-4014-4626-a967-e6dca1c892e6}", AUDIO_MIX_LEVEL_TABLE)
    DEVICE_TEST_METHOD( "100.32.2", "   Invalid Node ID - 0x80000001",           0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_MIX_LEVEL_TABLE, sizeof(KSAUDIO_MIXLEVEL)),
        Generic_Property_KSPROPERTY_AUDIO_MIX_LEVEL_TABLE_2, "{967192a6-3e47-479e-b803-af386302ef60}", AUDIO_MIX_LEVEL_TABLE)
    DEVICE_TEST_METHOD( "100.32.3", "   NULL IN/OUT Buffer",                          0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_MIX_LEVEL_TABLE, sizeof(KSAUDIO_MIXLEVEL)),
        Generic_Property_KSPROPERTY_AUDIO_MIX_LEVEL_TABLE_3, "{2a1ba6c9-229b-4f45-bd2d-087760a92112}", AUDIO_MIX_LEVEL_TABLE)
    DEVICE_TEST_METHOD( "100.32.4", "   Small IN/OUT Buffer",                         0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_MIX_LEVEL_TABLE, sizeof(KSAUDIO_MIXLEVEL)),
        Generic_Property_KSPROPERTY_AUDIO_MIX_LEVEL_TABLE_4, "{2ec97c6b-ed9d-4c5b-ae41-3f40b73860b4}", AUDIO_MIX_LEVEL_TABLE)
    DEVICE_TEST_METHOD( "100.32.5", "   Out buffer Large",                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_MIX_LEVEL_TABLE, sizeof(KSAUDIO_MIXLEVEL)),
        Generic_Property_KSPROPERTY_AUDIO_MIX_LEVEL_TABLE_5, "{0e1102dd-a105-476e-8e3e-a47831c90dcb}", AUDIO_MIX_LEVEL_TABLE)
    DEVICE_TEST_METHOD( "100.32.6", "   Valid Test",                                         0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_MIX_LEVEL_TABLE, sizeof(KSAUDIO_MIXLEVEL)),
        Generic_Property_KSPROPERTY_AUDIO_MIX_LEVEL_TABLE, "{FFD1DAEF-C857-41d7-B5A7-E2E10BA1F1A9}", AUDIO_MIX_LEVEL_TABLE)
    DEVICE_TEST_METHOD( "100.32.9", "   Test for Basic support",                                 0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_MIX_LEVEL_TABLE, sizeof(KSAUDIO_MIXLEVEL)),
        Generic_Property_KSNODEPROPERTY_AUDIO_Basic_Support, "{5C6774EC-67B5-4d60-A669-7F9B24D0181E}", AUDIO_MIX_LEVEL_TABLE)

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_AUDIO_POSITION",                    0, 0, 0, 0, NULL, "{e4229548-afc7-4ea2-b5d2-0b434332dea9}")
    DEVICE_TEST_METHOD( "100.33.1", "   NULL IN/OUT Buffer",                         0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_POSITION, sizeof(KSAUDIO_POSITION)),
        Generic_Property_KSPROPERTY_AUDIO_POSITION_1, "{b51e9464-57b1-4c06-9785-5c83f7e35642}", AUDIO_POSITION)
    DEVICE_TEST_METHOD( "100.33.2", "   Small IN/OUT Buffer",                         0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_POSITION, sizeof(KSAUDIO_POSITION)),
        Generic_Property_KSPROPERTY_AUDIO_POSITION_2, "{3c3d076c-6697-4fb1-b730-6195f053d2f2}", AUDIO_POSITION)
    DEVICE_TEST_METHOD( "100.33.3", "   Out buffer Large",                                0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_POSITION, sizeof(KSAUDIO_POSITION)),
        Generic_Property_KSPROPERTY_AUDIO_POSITION_3, "{335b04fb-7919-408e-9222-5c5b0d7890c2}", AUDIO_POSITION)
    // following test case is removed as we are not doing correct here(not submitting buffer to pin before testing. Similiar test case will be added into KSPOSTST  
    //	{ "100.33.4", "   Write Offset < Play Offset",                  0, 0, 0,
    //    GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_POSITION, sizeof(KSAUDIO_POSITION)),
    //    Generic_Property_KSPROPERTY_AUDIO_POSITION_4, "{2dc627c3-7086-4b8e-9820-fbfa30dc4597}", AUDIO_POSITION)

// preferred status ended in XP
#if (NTDDI_VERSION < NTDDI_VISTA)
    DEVICE_TEST_PARENT( "", "  KSPROPERTY_AUDIO_PREFERRED_STATUS",       0, 0, 0, 0, NULL, "{52c53bcd-8498-4d08-92ae-664ef56e6f53}")
    DEVICE_TEST_METHOD( "100.34.1", "   Out buffer NULL",                                 0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_PREFERRED_STATUS, sizeof(KSAUDIO_PREFERRED_STATUS)),
        Generic_Property_KSPROPERTY_AUDIO_PREFERRED_STATUS_1, "{63917dfd-a2cc-4cb3-8346-fd65c6a4ed7c}", AUDIO_PREFERRED_STATUS)
    DEVICE_TEST_METHOD( "100.34.2", "   Out buffer Small",                                0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_PREFERRED_STATUS, sizeof(KSAUDIO_PREFERRED_STATUS)),
        Generic_Property_KSPROPERTY_AUDIO_PREFERRED_STATUS_2, "{31748ef8-7c5d-49f4-824b-cf1f26ce6154}", AUDIO_PREFERRED_STATUS)
    DEVICE_TEST_METHOD( "100.34.3", "   Out buffer Large",                                0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_PREFERRED_STATUS, sizeof(KSAUDIO_PREFERRED_STATUS)),
        Generic_Property_KSPROPERTY_AUDIO_PREFERRED_STATUS_3, "{f8e42185-464a-46fe-8d0b-e23b4f16f741}", AUDIO_PREFERRED_STATUS)
    DEVICE_TEST_METHOD( "100.34.4", "   Invalid Device Type - ULONG_MAX",     0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_PREFERRED_STATUS, sizeof(KSAUDIO_PREFERRED_STATUS)),
        Generic_Property_KSPROPERTY_AUDIO_PREFERRED_STATUS_4, "{d0cef935-1d79-4399-bbf6-b543706cc7c1}", AUDIO_PREFERRED_STATUS)
    DEVICE_TEST_METHOD( "100.34.5", "   Invalid Device Type - 0x80000001",      0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_PREFERRED_STATUS, sizeof(KSAUDIO_PREFERRED_STATUS)),
        Generic_Property_KSPROPERTY_AUDIO_PREFERRED_STATUS_5, "{B1F4604F-E54B-4ccb-B277-33B49AC0FAAD}", AUDIO_PREFERRED_STATUS)
#endif

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_AUDIO_WIDE_MODE",                   0, 0, 0, 0, NULL, "{3D2F73CE-96EF-4b45-8357-76B58F97148E}")
    DEVICE_TEST_METHOD( "100.35.1", "   Test for Basic support",              0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_WIDE_MODE, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTY_AUDIO_Basic_Support, "{EC5B471E-108F-47ca-833B-348E3DD8D4F9}", AUDIO_WIDE_MODE)

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_AUDIO_WIDENESS",                    0, 0, 0, 0, NULL, "{4CDC1FD8-E882-46b5-93A6-1DE7E3A970B7}")
    DEVICE_TEST_METHOD( "100.36.1", "   Test for Basic support",              0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_WIDENESS, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTY_AUDIO_Basic_Support, "{D9C62CFA-1600-4ef1-A1AE-DD78BB7E88D5}", AUDIO_WIDENESS)

#if (NTDDI_VERSION >= NTDDI_WINBLUE)

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_AUDIO_WAVERT_CURRENT_WRITE_LASTBUFFER_POSITION",                    0, 0, 0, 0, NULL, "{1131889B-A142-48a4-B606-972084ED2491}")
    DEVICE_TEST_METHOD( "100.37.1", "   Test for Basic support",                         0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_WAVERT_CURRENT_WRITE_LASTBUFFER_POSITION, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTY_AUDIO_Basic_Support, "{595B97A9-CA88-4d9b-9F16-89CF3B6C2322}", AUDIO_WAVERT_CURRENT_WRITE_LASTBUFFER_POSITION)
    DEVICE_TEST_METHOD( "100.37.2", "   NULL IN/OUT Buffer",                         0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_WAVERT_CURRENT_WRITE_LASTBUFFER_POSITION, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTYULONG_NULL_Buffer, "{7F246D08-8C38-4402-BD66-D046698F29E6}", AUDIO_WAVERT_CURRENT_WRITE_LASTBUFFER_POSITION)
    DEVICE_TEST_METHOD( "100.37.3", "   Small IN/OUT Buffer",                         0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_WAVERT_CURRENT_WRITE_LASTBUFFER_POSITION, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTYULONG_Small_Buffer, "{3DFF01A9-07EA-46cd-AF86-F98310C6DA34}", AUDIO_WAVERT_CURRENT_WRITE_LASTBUFFER_POSITION)
    DEVICE_TEST_METHOD( "100.37.4", "   Large IN/OUT Buffer",                         0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_WAVERT_CURRENT_WRITE_LASTBUFFER_POSITION, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTYULONG_Large_Buffer, "{374C252E-9290-4037-BA63-82FE0EA0B048}", AUDIO_WAVERT_CURRENT_WRITE_LASTBUFFER_POSITION)
    DEVICE_TEST_METHOD( "100.37.5", "   Valid Test",                         0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Audio, KSPROPERTY_AUDIO_WAVERT_CURRENT_WRITE_LASTBUFFER_POSITION, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTYULONG_Valid_Test, "{667B46A3-0923-4286-8327-666D588E374D}", AUDIO_WAVERT_CURRENT_WRITE_LASTBUFFER_POSITION)

#endif // #if (NTDDI_VERSION >= NTDDI_WINBLUE)

// sysaudio ended in XP
#if (NTDDI_VERSION < NTDDI_VISTA)

    // KSPROPSETID_Sysaudio
    DEVICE_TEST_PARENT( "",   " KSPROPSETID_Sysaudio",                                0, 0, 0, 0, NULL, "{A7452474-799F-4c8d-A552-B0B116C412CE}")

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_SYSAUDIO_DEVICE_FRIENDLY_NAME",     0, 0, 0, 0, NULL, "{1df031c6-a96e-47ad-8ec7-34a3d0b46abb}")
    DEVICE_TEST_METHOD( "200.1.1", "   Rejects topology calls",                                     0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED | RUN_NODE_PROP, KSPROPSETID_Sysaudio,  KSPROPERTY_SYSAUDIO_DEVICE_FRIENDLY_NAME, 0),
        Generic_Property_KSPROPERTY_SYSAUDIO_DEVICE_INTERFACE_NAME_1, "{b2dbf6b6-610a-44a1-b7e5-a7fb3e58f4bc}")
    DEVICE_TEST_METHOD( "200.1.2", "   Out buffer small",                                             0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED | RUN_NODE_PROP, KSPROPSETID_Sysaudio,  KSPROPERTY_SYSAUDIO_DEVICE_FRIENDLY_NAME, 0),
        Generic_Property_KSPROPERTY_SYSAUDIO_DEVICE_INTERFACE_NAME_2, "{e03aa4f6-4d52-4b12-9ba6-8719fd78a158}")
    DEVICE_TEST_METHOD( "200.1.3", "   Null string",                                                      0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED | RUN_NODE_PROP, KSPROPSETID_Sysaudio,  KSPROPERTY_SYSAUDIO_DEVICE_FRIENDLY_NAME, 0),
        Generic_Property_KSPROPERTY_SYSAUDIO_DEVICE_INTERFACE_NAME_3, "{2308769b-4997-4f0e-bb56-ee3c681a91f7}")
    DEVICE_TEST_METHOD( "200.1.4", "   Invalid size string",                                           0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED | RUN_NODE_PROP, KSPROPSETID_Sysaudio,  KSPROPERTY_SYSAUDIO_DEVICE_FRIENDLY_NAME, 0),
        Generic_Property_KSPROPERTY_SYSAUDIO_DEVICE_INTERFACE_NAME_4, "{cc422ff0-cff9-4b2c-b66a-5ffaeb4691bd}")
    DEVICE_TEST_METHOD( "200.1.5", "   One char string",                                              0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED | RUN_NODE_PROP, KSPROPSETID_Sysaudio,  KSPROPERTY_SYSAUDIO_DEVICE_FRIENDLY_NAME, 0),
        Generic_Property_KSPROPERTY_SYSAUDIO_DEVICE_INTERFACE_NAME_5, "{576711af-a6bc-4fb5-af2a-d69594cfd74f}")
    DEVICE_TEST_METHOD( "200.1.6", "   Get string for invalid device",                            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED | RUN_NODE_PROP, KSPROPSETID_Sysaudio,  KSPROPERTY_SYSAUDIO_DEVICE_FRIENDLY_NAME, 0),
        Generic_Property_KSPROPERTY_SYSAUDIO_DEVICE_INTERFACE_NAME_6, "{79867f3f-7337-49e5-9f11-1fc28992a409}")
    DEVICE_TEST_METHOD( "200.1.7", "   Get string length",                                            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED | RUN_NODE_PROP, KSPROPSETID_Sysaudio,  KSPROPERTY_SYSAUDIO_DEVICE_FRIENDLY_NAME, 0),
        Generic_Property_KSPROPERTY_SYSAUDIO_DEVICE_INTERFACE_NAME_7, "{20e914ac-b58b-489d-950c-b90a1945b51d}")
    DEVICE_TEST_METHOD( "200.1.8", "   String unaligned",                                             0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED | RUN_NODE_PROP, KSPROPSETID_Sysaudio,  KSPROPERTY_SYSAUDIO_DEVICE_FRIENDLY_NAME, 0),
        Generic_Property_KSPROPERTY_SYSAUDIO_DEVICE_INTERFACE_NAME_8, "{6f2885c7-07f7-47da-9d31-bcdad69479cf}")


    DEVICE_TEST_PARENT( "", "  KSPROPERTY_SYSAUDIO_DEVICE_INTERFACE_NAME",    0, 0, 0, 0, NULL, "{cb723984-1424-495e-8b73-6af534e4ff19}")
    DEVICE_TEST_METHOD( "200.2.1", "   Rejects topology calls",                                   0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED | RUN_NODE_PROP, KSPROPSETID_Sysaudio,  KSPROPERTY_SYSAUDIO_DEVICE_INTERFACE_NAME, 0),
        Generic_Property_KSPROPERTY_SYSAUDIO_DEVICE_INTERFACE_NAME_1, "{fa2db052-4422-42e5-882e-9f3918dcec26}")
    DEVICE_TEST_METHOD( "200.2.2", "   Out buffer small",                                           0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED | RUN_NODE_PROP, KSPROPSETID_Sysaudio,  KSPROPERTY_SYSAUDIO_DEVICE_INTERFACE_NAME, 0),
        Generic_Property_KSPROPERTY_SYSAUDIO_DEVICE_INTERFACE_NAME_2, "{f438a639-0b93-469f-a44e-38bcf2414f16}")
    DEVICE_TEST_METHOD( "200.2.3", "   Null string",                                                    0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED | RUN_NODE_PROP, KSPROPSETID_Sysaudio,  KSPROPERTY_SYSAUDIO_DEVICE_INTERFACE_NAME, 0),
        Generic_Property_KSPROPERTY_SYSAUDIO_DEVICE_INTERFACE_NAME_3, "{f6d53033-992b-4c76-9199-9862132ebff4}")
    DEVICE_TEST_METHOD( "200.2.4", "   Invalid size string",                                         0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED | RUN_NODE_PROP, KSPROPSETID_Sysaudio,  KSPROPERTY_SYSAUDIO_DEVICE_INTERFACE_NAME, 0),
        Generic_Property_KSPROPERTY_SYSAUDIO_DEVICE_INTERFACE_NAME_4, "{8d3b05e0-98fe-43d6-9f7f-9c79f2618b0b}")
    DEVICE_TEST_METHOD( "200.2.5", "   One char string",                                              0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED | RUN_NODE_PROP, KSPROPSETID_Sysaudio,  KSPROPERTY_SYSAUDIO_DEVICE_INTERFACE_NAME, 0),
        Generic_Property_KSPROPERTY_SYSAUDIO_DEVICE_INTERFACE_NAME_5, "{fc9cb94a-9f2a-4f2f-b9dd-9800352fcb74}")
    DEVICE_TEST_METHOD( "200.2.6", "   Get string for invalid device",                          0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED | RUN_NODE_PROP, KSPROPSETID_Sysaudio,  KSPROPERTY_SYSAUDIO_DEVICE_INTERFACE_NAME, 0),
        Generic_Property_KSPROPERTY_SYSAUDIO_DEVICE_INTERFACE_NAME_6, "{4ede8472-0abd-4ccc-81a1-73275cbae11b}")
    DEVICE_TEST_METHOD( "200.2.7", "   Get string length",                                          0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED | RUN_NODE_PROP, KSPROPSETID_Sysaudio,  KSPROPERTY_SYSAUDIO_DEVICE_INTERFACE_NAME, 0),
        Generic_Property_KSPROPERTY_SYSAUDIO_DEVICE_INTERFACE_NAME_6, "{81eb05d8-c7fe-41ea-8070-766cf5a94fb4}")
    DEVICE_TEST_METHOD( "200.2.8", "   String unaligned",                                           0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED | RUN_NODE_PROP, KSPROPSETID_Sysaudio,  KSPROPERTY_SYSAUDIO_DEVICE_INTERFACE_NAME, 0),
        Generic_Property_KSPROPERTY_SYSAUDIO_DEVICE_INTERFACE_NAME_7, "{497cea78-c09e-4df9-b31a-c69d8a8cb70c}")

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_SYSAUDIO_PREFERRED_DEVICE",         0, 0, 0, 0, NULL, "{5a84bf16-c07e-408b-a6fe-ca153eab2e1c}")
    // since Generic_Property_KSPROPERTY_SYSAUDIO_PREFERRED_DEVICE_1 is not written - it is just returning FNS_FAIL, I have commented this test case.
    //  { "200.3.1", "   Not supported",                        0, 0, 0,
    //    GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Sysaudio, KSPROPERTY_SYSAUDIO_PREFERRED_DEVICE, sizeof(ULONG)),
    //    Generic_Property_KSPROPERTY_SYSAUDIO_PREFERRED_DEVICE_1, "{172e5937-a679-4726-9a44-f3b3c8722eb4}", SYSAUDIO_PREFERRED_DEVICE)

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_SYSAUDIO_SELECT_GRAPH",         0, 0, 0, 0, NULL, "{738ffd36-0b63-4fe3-a317-3dceca41fcb4}")
    DEVICE_TEST_METHOD( "200.4.1", "   Invalid node",                                        0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Sysaudio, KSPROPERTY_SYSAUDIO_SELECT_GRAPH, 0),
        Generic_Property_KSPROPERTY_SYSAUDIO_SELECT_GRAPH_1, "{361eacac-cc1a-4f01-9d0b-b6a65aad54dd}", SYSAUDIO_SELECT_GRAPH)
    DEVICE_TEST_METHOD( "200.4.2", "   Invalid pin",                                           0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Sysaudio, KSPROPERTY_SYSAUDIO_SELECT_GRAPH, 0),
        Generic_Property_KSPROPERTY_SYSAUDIO_SELECT_GRAPH_2, "{1be2068f-856c-4fc4-9a48-986560c7958f}", SYSAUDIO_SELECT_GRAPH)
    DEVICE_TEST_METHOD( "200.4.3", "   Selects all nodes(some twice)",                0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Sysaudio, KSPROPERTY_SYSAUDIO_SELECT_GRAPH, 0),
        Generic_Property_KSPROPERTY_SYSAUDIO_SELECT_GRAPH_3, "{8596bea1-416f-4f30-8738-877dc793f2dc}", SYSAUDIO_SELECT_GRAPH)

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_SYSAUDIO_ADDREMOVE_GFX",        0, 0, 0, 0, NULL, "{f1612aaa-0bc1-4c7e-8c21-f6670531661c}")
    DEVICE_TEST_METHOD( "200.5.1", "   Bad handle argument",                              0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Sysaudio, KSPROPERTY_SYSAUDIO_ADDREMOVE_GFX, sizeof(SYSAUDIO_GFX)),
        Generic_Property_KSPROPERTY_SYSAUDIO_ADDREMOVE_GFX_1, "{539c7715-3082-45ef-8c2d-37ae56b3f255}", SYSAUDIO_ADDREMOVE_GFX)
    DEVICE_TEST_METHOD( "200.5.2", "   Unallocated string",                                   0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Sysaudio, KSPROPERTY_SYSAUDIO_ADDREMOVE_GFX, sizeof(SYSAUDIO_GFX)),
        Generic_Property_KSPROPERTY_SYSAUDIO_ADDREMOVE_GFX_2, "{ed46af41-de32-4b1f-8eeb-be9c4dbf9f93}", SYSAUDIO_ADDREMOVE_GFX)
    DEVICE_TEST_METHOD( "200.5.3", "   Unallocated string - overflow",                   0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Sysaudio, KSPROPERTY_SYSAUDIO_ADDREMOVE_GFX, sizeof(SYSAUDIO_GFX)),
        Generic_Property_KSPROPERTY_SYSAUDIO_ADDREMOVE_GFX_3, "{456d48f9-00c4-40cf-8dae-9693859a3273}", SYSAUDIO_ADDREMOVE_GFX)

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_SYSAUDIO_RENDER_PIN_INSTANCES",     0, 0, 0, 0, NULL, "{2c149039-a535-4b74-94da-5e679fb5ae03}")
    DEVICE_TEST_METHOD( "200.6.1", "   Out buffer small",                                             0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Sysaudio, KSPROPERTY_SYSAUDIO_RENDER_PIN_INSTANCES, sizeof(KSPIN_CINSTANCES)),
        Generic_Property_KSPROPERTY_SYSAUDIO_RENDER_PIN_INSTANCES_1, "{5d71ad36-00ab-4666-a4ab-4ded4190199b}", SYSAUDIO_RENDER_PIN_INSTANCES)
    DEVICE_TEST_METHOD( "200.6.2", "   Good in size",                                                   0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Sysaudio, KSPROPERTY_SYSAUDIO_RENDER_PIN_INSTANCES, sizeof(KSPIN_CINSTANCES)),
        Generic_Property_KSPROPERTY_SYSAUDIO_RENDER_PIN_INSTANCES_2, "{094d728c-378c-40a4-9089-caaad6dcae2f}", SYSAUDIO_RENDER_PIN_INSTANCES)

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_SYSAUDIO_CREATE_VIRTUAL_SOURCE",    0, 0, 0, 0, NULL, "{536328ff-e39e-401e-b783-4852a43700ad}")
    DEVICE_TEST_METHOD( "200.7.1", "   Set not supported",                                            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Sysaudio, KSPROPERTY_SYSAUDIO_CREATE_VIRTUAL_SOURCE, sizeof(SYSAUDIO_CREATE_VIRTUAL_SOURCE)),
        Generic_Property_KSPROPERTY_SYSAUDIO_CREATE_VIRTUAL_SOURCE_1, "{5426b25c-7a22-472b-917d-907713bf6179}", SYSAUDIO_CREATE_VIRTUAL_SOURCE)
    DEVICE_TEST_METHOD( "200.7.2", "   Out buffer small",                                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Sysaudio, KSPROPERTY_SYSAUDIO_CREATE_VIRTUAL_SOURCE, sizeof(SYSAUDIO_CREATE_VIRTUAL_SOURCE)),
        Generic_Property_KSPROPERTY_SYSAUDIO_CREATE_VIRTUAL_SOURCE_2, "{62d13837-59a5-40c7-b5fe-8be021b0321a}", SYSAUDIO_CREATE_VIRTUAL_SOURCE)
    DEVICE_TEST_METHOD( "200.7.3", "   Invalid source get",                                            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Sysaudio, KSPROPERTY_SYSAUDIO_CREATE_VIRTUAL_SOURCE, sizeof(SYSAUDIO_CREATE_VIRTUAL_SOURCE)),
        Generic_Property_KSPROPERTY_SYSAUDIO_CREATE_VIRTUAL_SOURCE_3, "{d140c176-9708-46ac-a8f5-08112b23a664}", SYSAUDIO_CREATE_VIRTUAL_SOURCE)

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_SYSAUDIO_ATTACH_VIRTUAL_SOURCE",     0, 0, 0, 0, NULL, "{496a6a01-b474-4cea-980c-a11d2d26a200}")
    DEVICE_TEST_METHOD( "200.8.1", "   Invalid mixer id",                                                 0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Sysaudio, KSPROPERTY_SYSAUDIO_ATTACH_VIRTUAL_SOURCE, sizeof(SYSAUDIO_ATTACH_VIRTUAL_SOURCE)),
        Generic_Property_KSPROPERTY_SYSAUDIO_ATTACH_VIRTUAL_SOURCE_1, "{0037a468-467d-4cd2-b5e6-eed5fbf5eadb}", SYSAUDIO_ATTACH_VIRTUAL_SOURCE)
    DEVICE_TEST_METHOD( "200.8.2", "   Attach valid source",                                            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Sysaudio, KSPROPERTY_SYSAUDIO_ATTACH_VIRTUAL_SOURCE, sizeof(SYSAUDIO_ATTACH_VIRTUAL_SOURCE)),
        Generic_Property_KSPROPERTY_SYSAUDIO_ATTACH_VIRTUAL_SOURCE_2, "{df6d58f6-873e-4ac9-b891-b88bab9e66bb}", SYSAUDIO_ATTACH_VIRTUAL_SOURCE)
#endif // (NTDDI_VERSION < NTDDI_VISTA)

    // KSPROPSETID_AudioEngine
    DEVICE_TEST_PARENT( "", " KSPROPSETID_AudioEngine",						0, 0, 0, 0, NULL, "{4d8fee10-b239-4665-a9d8-fd3903c03770}" )
    DEVICE_TEST_PARENT( "", "  KSPROPERTY_AUDIOENGINE_LFXENABLE",		0, 0, 0, 0, NULL, "{aa942095-6ccd-497d-b873-c80946155094}")
    DEVICE_TEST_METHOD( "300.1.1", "   Invalid Node ID - ULONG_MAX",		0, 0, 0, 
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_LFXENABLE, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTYULONG_NodeID_ULONGMAX, "{909e43d7-00a7-4189-98ee-73c7804f468e}", AUDIOENGINE_LFXENABLE)
    DEVICE_TEST_METHOD( "300.1.2", "   Invalid Node ID - 0x80000001",		0, 0, 0, 
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_LFXENABLE, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTYULONG_NodeID_0x80000001, "{11e6386c-d578-470e-b3fc-e83b806df79a}", AUDIOENGINE_LFXENABLE)
    DEVICE_TEST_METHOD( "300.1.3", "   NULL IN/OUT Buffer",						0, 0, 0, 
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_LFXENABLE, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTYULONG_NULL_Buffer, "{136013df-31b5-4c72-bdfc-7df1b0411763}", AUDIOENGINE_LFXENABLE)
    DEVICE_TEST_METHOD( "300.1.4","   Small IN/OUT Buffer",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_LFXENABLE, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTYULONG_Small_Buffer, "{aa2b24ff-d1b1-4eaa-a9a2-0b49cd82c3c1}", AUDIOENGINE_LFXENABLE)
    DEVICE_TEST_METHOD( "300.1.5", "   Out buffer Large",						0, 0, 0, 
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_LFXENABLE, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTYULONG_Large_Buffer, "{86c82afe-d650-40bb-8811-4f282a6c0c5c}", AUDIOENGINE_LFXENABLE)
    DEVICE_TEST_METHOD( "300.1.6", "   valid test data",				0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_LFXENABLE, sizeof(BOOL)),
        AudioEngine_Property_AUDIOENGINE_Generic_Valid, "{c3fe259b-74a5-418e-8d83-f006965ac380}", AUDIOENGINE_LFXENABLE)
    DEVICE_TEST_METHOD( "300.1.7", "   Test for Basic support",              0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_LFXENABLE, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTY_AUDIO_Basic_Support, "{27469b6b-1e77-4118-9864-e127349e4998}", AUDIOENGINE_LFXENABLE)

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_AUDIOENGINE_GFXENABLE",		0, 0, 0, 0, NULL, "{975a020a-849d-4582-a275-a0dc583c09a4}")
    DEVICE_TEST_METHOD( "300.2.1", "   Invalid Node ID - ULONG_MAX",		0, 0, 0, 
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_GFXENABLE, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTYULONG_NodeID_ULONGMAX, "{5da60194-a47e-471f-9d3e-d4db2bead0c5}", AUDIOENGINE_GFXENABLE)
    DEVICE_TEST_METHOD( "300.2.2", "   Invalid Node ID - 0x80000001",		0, 0, 0, 
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_GFXENABLE, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTYULONG_NodeID_0x80000001, "{8e97c809-0c21-478e-92f9-dc605ed0c113}", AUDIOENGINE_GFXENABLE)
    DEVICE_TEST_METHOD( "300.2.3", "   NULL IN/OUT Buffer",						0, 0, 0, 
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_GFXENABLE, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTYULONG_NULL_Buffer, "{a180098c-243b-4571-82e9-8ce190f68afc}", AUDIOENGINE_GFXENABLE)
    DEVICE_TEST_METHOD( "300.2.4","   Small IN/OUT Buffer",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_GFXENABLE, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTYULONG_Small_Buffer, "{336f740d-23d5-4487-afdf-1b32c74ec21c}", AUDIOENGINE_GFXENABLE)
    DEVICE_TEST_METHOD( "300.2.5", "   Out buffer Large",						0, 0, 0, 
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_GFXENABLE, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTYULONG_Large_Buffer, "{f5eb3aa5-34b5-49de-84f2-0acf795e2267}", AUDIOENGINE_GFXENABLE)
    DEVICE_TEST_METHOD( "300.2.6", "   valid test data",				0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_GFXENABLE, sizeof(BOOL)),
        AudioEngine_Property_AUDIOENGINE_Generic_Valid, "{ccb47a12-71f5-4b79-928f-06c207dcd7f5}", AUDIOENGINE_GFXENABLE)
    DEVICE_TEST_METHOD( "300.2.7", "   Test for Basic support",              0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_GFXENABLE, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTY_AUDIO_Basic_Support, "{e736c239-3566-41fd-83d7-6e0c302b532d}", AUDIOENGINE_GFXENABLE)

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_AUDIOENGINE_MIXFORMAT",		0, 0, 0, 0, NULL, "{f8502e54-1e16-4a71-816a-aa5236419a9d}")
    DEVICE_TEST_METHOD( "300.3.1", "   Invalid Node ID - ULONG_MAX",		0, 0, 0, 
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_MIXFORMAT, sizeof(KSDATAFORMAT)),
        Generic_Property_KSNODEPROPERTYULONG_NodeID_ULONGMAX, "{638d2f04-67be-48ff-b838-377b1d6eeee0}", AUDIOENGINE_MIXFORMAT)
    DEVICE_TEST_METHOD( "300.3.2", "   Invalid Node ID - 0x80000001",		0, 0, 0, 
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_MIXFORMAT, sizeof(KSDATAFORMAT)),
        Generic_Property_KSNODEPROPERTYULONG_NodeID_0x80000001, "{a6be0c84-01d4-497e-b298-5a1d5437b9bb}", AUDIOENGINE_MIXFORMAT)
    DEVICE_TEST_METHOD( "300.3.3", "   NULL IN/OUT Buffer",						0, 0, 0, 
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_MIXFORMAT, sizeof(KSDATAFORMAT)),
        Generic_Property_KSNODEPROPERTYULONG_NULL_Buffer, "{85991737-a06c-43c8-b28a-0083ad51bf16}", AUDIOENGINE_MIXFORMAT)
    DEVICE_TEST_METHOD( "300.3.4","   Small IN/OUT Buffer",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_MIXFORMAT, sizeof(KSDATAFORMAT)),
        Generic_Property_KSNODEPROPERTYULONG_Small_Buffer, "{f82ba282-2e1b-4427-9ac0-051283872520}", AUDIOENGINE_MIXFORMAT)
    DEVICE_TEST_METHOD( "300.3.5", "   Out buffer Large",						0, 0, 0, 
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_MIXFORMAT, sizeof(KSDATAFORMAT)),
        Generic_Property_KSNODEPROPERTYULONG_Large_Buffer, "{a12425ee-ac95-4775-8125-7c3e3c71dd14}", AUDIOENGINE_MIXFORMAT)
    DEVICE_TEST_METHOD( "300.3.6", "   Valid Test Data",				0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_MIXFORMAT, sizeof(KSDATAFORMAT)),
        AudioEngine_Property_AUDIOENGINE_Generic_Valid, "{5f3cde91-1b7e-4120-91ea-542fd5a61881}", AUDIOENGINE_MIXFORMAT)
    DEVICE_TEST_METHOD( "300.3.7", "   Test for Basic support",              0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_MIXFORMAT, sizeof(KSDATAFORMAT)),
        Generic_Property_KSNODEPROPERTY_AUDIO_Basic_Support, "{0fb24331-b26d-4e82-a1f9-73b214d85a8b}", AUDIOENGINE_MIXFORMAT)

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_AUDIOENGINE_PROCESSINGPERIOD",		0, 0, 0, 0, NULL, "{8fd46f9d-1d37-4ace-8c46-9ae9b5c8e77d}")
    DEVICE_TEST_METHOD( "300.4.1", "   Invalid Node ID - ULONG_MAX",		0, 0, 0, 
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_PROCESSINGPERIOD, sizeof(LONGLONG)),
        Generic_Property_KSNODEPROPERTYULONG_NodeID_ULONGMAX, "{31d55713-bb94-4537-ae93-a3823c050494}", AUDIOENGINE_PROCESSINGPERIOD)
    DEVICE_TEST_METHOD( "300.4.2", "   Invalid Node ID - 0x80000001",		0, 0, 0, 
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_PROCESSINGPERIOD, sizeof(LONGLONG)),
        Generic_Property_KSNODEPROPERTYULONG_NodeID_0x80000001, "{7859123b-272b-47fd-a5b0-a7c793de6d19}", AUDIOENGINE_PROCESSINGPERIOD)
    DEVICE_TEST_METHOD( "300.4.3", "   NULL IN/OUT Buffer",						0, 0, 0, 
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_PROCESSINGPERIOD, sizeof(LONGLONG)),
        Generic_Property_KSNODEPROPERTYULONG_NULL_Buffer, "{d2ea0de7-fb69-432b-9d2e-1586fe038c6d}", AUDIOENGINE_PROCESSINGPERIOD)
    DEVICE_TEST_METHOD( "300.4.4","   Small IN/OUT Buffer",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_PROCESSINGPERIOD, sizeof(LONGLONG)),
        Generic_Property_KSNODEPROPERTYULONG_Small_Buffer, "{913fcdda-6de8-40cf-9382-449a7dfa18b5}", AUDIOENGINE_PROCESSINGPERIOD)
    DEVICE_TEST_METHOD( "300.4.5", "   Out buffer Large",						0, 0, 0, 
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_PROCESSINGPERIOD, sizeof(LONGLONG)),
        Generic_Property_KSNODEPROPERTYULONG_Large_Buffer, "{5981486d-d4b6-47b0-b187-88e90a9bca33}", AUDIOENGINE_PROCESSINGPERIOD)
    DEVICE_TEST_METHOD( "300.4.6", "   Valid Test Data",				0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_PROCESSINGPERIOD, sizeof(LONGLONG)),
        AudioEngine_Property_AUDIOENGINE_Generic_Valid, "{7ec9db24-97af-409e-ad6d-096006b7f8f5}", AUDIOENGINE_PROCESSINGPERIOD)
    DEVICE_TEST_METHOD( "300.4.7", "   Test for Basic support",              0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_PROCESSINGPERIOD, sizeof(LONGLONG)),
        Generic_Property_KSNODEPROPERTY_AUDIO_Basic_Support, "{85a652c5-c305-471f-a5de-4029f3ee9a5f}", AUDIOENGINE_PROCESSINGPERIOD)

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_AUDIOENGINE_DEVICEFORMAT",		0, 0, 0, 0, NULL, "{ce7d9a20-36b3-490a-833d-6937b0b152f5}")
    DEVICE_TEST_METHOD( "300.5.1", "   Invalid Node ID - ULONG_MAX",		0, 0, 0, 
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_DEVICEFORMAT, sizeof(KSDATAFORMAT)),
        Generic_Property_KSNODEPROPERTYULONG_NodeID_ULONGMAX, "{09b5e067-b932-4a65-8564-64b6f2090d83}", AUDIOENGINE_DEVICEFORMAT)
    DEVICE_TEST_METHOD( "300.5.2", "   Invalid Node ID - 0x80000001",		0, 0, 0, 
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_DEVICEFORMAT, sizeof(KSDATAFORMAT)),
        Generic_Property_KSNODEPROPERTYULONG_NodeID_0x80000001, "{34e9a3c3-0382-4fdc-ad2c-80a2a0d053f9}", AUDIOENGINE_DEVICEFORMAT)
    DEVICE_TEST_METHOD( "300.5.3", "   NULL IN/OUT Buffer",						0, 0, 0, 
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_DEVICEFORMAT, sizeof(KSDATAFORMAT)),
        Generic_Property_KSNODEPROPERTYULONG_NULL_Buffer, "{958eaf47-e82e-4c54-b0b7-e01287f286b1}", AUDIOENGINE_DEVICEFORMAT)
    DEVICE_TEST_METHOD( "300.5.4","   Small IN/OUT Buffer",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_DEVICEFORMAT, sizeof(KSDATAFORMAT)),
        Generic_Property_KSNODEPROPERTYULONG_Small_Buffer, "{6f5ba691-8860-4188-a00a-7bc2b6f1ec80}", AUDIOENGINE_DEVICEFORMAT)
    DEVICE_TEST_METHOD( "300.5.5", "   Out buffer Large",						0, 0, 0, 
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_DEVICEFORMAT, sizeof(KSDATAFORMAT)),
        Generic_Property_KSNODEPROPERTYULONG_Large_Buffer, "{412bd72f-023a-41fb-b105-bd578ed1feda}", AUDIOENGINE_DEVICEFORMAT)
    DEVICE_TEST_METHOD( "300.5.6", "   Valid Test Data",				0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_DEVICEFORMAT, sizeof(KSDATAFORMAT)),
        AudioEngine_Property_DEVICEFORMAT_Valid, "{28b83b07-7ff0-4c3a-9add-60541a5f9dcb}", AUDIOENGINE_DEVICEFORMAT)
    DEVICE_TEST_METHOD( "300.5.7", "   Test for Basic support",              0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_DEVICEFORMAT, sizeof(KSDATAFORMAT)),
        Generic_Property_KSNODEPROPERTY_AUDIO_Basic_Support, "{fa0541f7-78db-4ae0-ab7c-5d973bb4aeca}", AUDIOENGINE_DEVICEFORMAT)

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_AUDIOENGINE_SUPPORTEDDEVICEFORMATS",		0, 0, 0, 0, NULL, "{c483f6d3-b59b-4f15-b225-88b4a5d339b4}")
    DEVICE_TEST_METHOD( "400.11.1", "   Bad node id - one more then reported by Filter", 0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_SUPPORTEDDEVICEFORMATS, sizeof(KSMULTIPLE_ITEM)),
        AudioEngine_Property_SUPPORTEDDEVICEFORMATS_1, "{210f7f0b-fb43-4785-9c9f-789bd5706da5}", AUDIOENGINE_SUPPORTEDDEVICEFORMATS)
    DEVICE_TEST_METHOD( "400.11.2", "   Bad node id - ULONG_MAX",             0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_SUPPORTEDDEVICEFORMATS, sizeof(KSMULTIPLE_ITEM)),
        AudioEngine_Property_SUPPORTEDDEVICEFORMATS_2, "{344a3f1f-50e2-4fa2-a249-f875bac1adfd}", AUDIOENGINE_SUPPORTEDDEVICEFORMATS)
    DEVICE_TEST_METHOD( "400.11.3", "   Passing NULL buffer",                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_SUPPORTEDDEVICEFORMATS, sizeof(KSMULTIPLE_ITEM)),
        AudioEngine_Property_SUPPORTEDDEVICEFORMATS_3, "{070ac342-4070-47a4-ba5b-7b4364077b51}", AUDIOENGINE_SUPPORTEDDEVICEFORMATS)
    DEVICE_TEST_METHOD( "400.11.4", "   Passing small buffer",                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_SUPPORTEDDEVICEFORMATS, sizeof(KSMULTIPLE_ITEM)),
        AudioEngine_Property_SUPPORTEDDEVICEFORMATS_4, "{34c4e209-93f9-47f7-967c-f830ada7d1d3}", AUDIOENGINE_SUPPORTEDDEVICEFORMATS)
    DEVICE_TEST_METHOD( "400.11.5", "   Passing large buffer",                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_SUPPORTEDDEVICEFORMATS, sizeof(KSMULTIPLE_ITEM)),
        AudioEngine_Property_SUPPORTEDDEVICEFORMATS_5, "{5cef95b2-17dd-4741-8685-91fc9d1378b3}", AUDIOENGINE_SUPPORTEDDEVICEFORMATS)
    DEVICE_TEST_METHOD( "400.11.6", "   Passing valid data",                                0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_SUPPORTEDDEVICEFORMATS, sizeof(KSMULTIPLE_ITEM)),
        AudioEngine_Property_SUPPORTEDDEVICEFORMATS_6, "{e4afaed7-0727-4cf9-8b6b-28e0d1aa58e8}", AUDIOENGINE_SUPPORTEDDEVICEFORMATS)

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_AUDIOENGINE_DESCRIPTOR",		0, 0, 0, 0, NULL, "{304ad188-d507-4314-ba1c-b6711972ab48}")
    DEVICE_TEST_METHOD( "300.7.1", "   Invalid Node ID - ULONG_MAX",		0, 0, 0, 
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_DESCRIPTOR, sizeof(KSAUDIOENGINE_DESCRIPTOR)),
        Generic_Property_KSNODEPROPERTYULONG_NodeID_ULONGMAX, "{658307f1-de37-4181-ae1e-e3f82fcc604a}", AUDIOENGINE_DESCRIPTOR)
    DEVICE_TEST_METHOD( "300.7.2", "   Invalid Node ID - 0x80000001",		0, 0, 0, 
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_DESCRIPTOR, sizeof(KSAUDIOENGINE_DESCRIPTOR)),
        Generic_Property_KSNODEPROPERTYULONG_NodeID_0x80000001, "{9351c646-50fd-444f-84e8-6cac7b82b149}", AUDIOENGINE_DESCRIPTOR)
    DEVICE_TEST_METHOD( "300.7.3", "   NULL IN/OUT Buffer",						0, 0, 0, 
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_DESCRIPTOR, sizeof(KSAUDIOENGINE_DESCRIPTOR)),
        Generic_Property_KSNODEPROPERTYULONG_NULL_Buffer, "{d60e64cc-aaad-4325-ba66-58ac79b98135}", AUDIOENGINE_DESCRIPTOR)
    DEVICE_TEST_METHOD( "300.7.4","   Small IN/OUT Buffer",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_DESCRIPTOR, sizeof(KSAUDIOENGINE_DESCRIPTOR)),
        Generic_Property_KSNODEPROPERTYULONG_Small_Buffer, "{1c9e87d5-de4c-4514-afe9-2b72c6a5a8a5}", AUDIOENGINE_DESCRIPTOR)
    DEVICE_TEST_METHOD( "300.7.5", "   Out buffer Large",						0, 0, 0, 
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_DESCRIPTOR, sizeof(KSAUDIOENGINE_DESCRIPTOR)),
        Generic_Property_KSNODEPROPERTYULONG_Large_Buffer, "{f7e87661-1018-408e-b795-cdab4e633969}", AUDIOENGINE_DESCRIPTOR)
    DEVICE_TEST_METHOD( "300.7.6", "   Valid Test Data",				0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_DESCRIPTOR, sizeof(KSAUDIOENGINE_DESCRIPTOR)),
        AudioEngine_Property_AUDIOENGINE_Generic_Valid, "{6708dc91-d44f-4f79-9a92-236fc4b7765a}", AUDIOENGINE_DESCRIPTOR)
    DEVICE_TEST_METHOD( "300.7.7", "   Test for Basic support",              0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioEngine, KSPROPERTY_AUDIOENGINE_DESCRIPTOR, sizeof(KSAUDIOENGINE_DESCRIPTOR)),
        Generic_Property_KSNODEPROPERTY_AUDIO_Basic_Support, "{def24391-e7f1-4727-b408-878d069ad171}", AUDIOENGINE_DESCRIPTOR)

    // KSPROPSETID_Itd3d
    DEVICE_TEST_PARENT( "",   " KSPROPSETID_Itd3d",							    0, 0, 0, 0, NULL, "{3bd0316e-17e0-468a-801d-88f8d052c3fe}")

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_ITD3D_PARAMS",					    0, 0, 0, 0, NULL, "{cd9287b4-9d2c-4dde-b008-0f8b7c5bb147}")
    DEVICE_TEST_METHOD( "600.1.1", "   Passing Invalid Node id - 0x80000001",		0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP |RUN_NODE_PROP | RUN_IF_SUPPORTED | RUN_PROP, KSPROPSETID_Itd3d, KSPROPERTY_ITD3D_PARAMS, sizeof(KSDS3D_ITD_PARAMS_MSG)),
        Generic_Property_KSPROPERTY_ITD3D_PARAMS_1, "{44253445-0766-4265-b6b3-2e01249e7243}", ITD3D_PARAMS)
    DEVICE_TEST_METHOD( "600.1.2", "   Passing Invalid Node id - ULONG_MAX",           0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP |RUN_NODE_PROP | RUN_IF_SUPPORTED | RUN_PROP, KSPROPSETID_Itd3d, KSPROPERTY_ITD3D_PARAMS, sizeof(KSDS3D_ITD_PARAMS_MSG)),
        Generic_Property_KSPROPERTY_ITD3D_PARAMS_2, "{BC4B2C8A-0CCE-4547-8776-C50D10F88615}", ITD3D_PARAMS)
    DEVICE_TEST_METHOD( "600.1.3", "   Passing NULL Buffer",                                     0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP |RUN_NODE_PROP | RUN_IF_SUPPORTED | RUN_PROP, KSPROPSETID_Itd3d, KSPROPERTY_ITD3D_PARAMS, sizeof(KSDS3D_ITD_PARAMS_MSG)),
        Generic_Property_KSPROPERTY_ITD3D_PARAMS_3, "{5CE555C0-B0F1-4fd8-AD31-F3FF162D0936}", ITD3D_PARAMS)
    DEVICE_TEST_METHOD( "600.1.4", "   Passing Small Buffer",                                    0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP |RUN_NODE_PROP | RUN_IF_SUPPORTED | RUN_PROP, KSPROPSETID_Itd3d, KSPROPERTY_ITD3D_PARAMS, sizeof(KSDS3D_ITD_PARAMS_MSG)),
        Generic_Property_KSPROPERTY_ITD3D_PARAMS_4, "{D8B0F7BD-D88D-45db-B3AF-7F17A987A13B}", ITD3D_PARAMS)
    DEVICE_TEST_METHOD( "600.1.5", "   Passing Large Buffer",                                    0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP |RUN_NODE_PROP | RUN_IF_SUPPORTED | RUN_PROP, KSPROPSETID_Itd3d, KSPROPERTY_ITD3D_PARAMS, sizeof(KSDS3D_ITD_PARAMS_MSG)),
        Generic_Property_KSPROPERTY_ITD3D_PARAMS_5, "{34D6D4B9-C564-4173-9EDA-CA2B267FB671}", ITD3D_PARAMS)
    DEVICE_TEST_METHOD( "600.1.6", "   Passing Valid Data",                                       0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP |RUN_NODE_PROP | RUN_IF_SUPPORTED | RUN_PROP, KSPROPSETID_Itd3d, KSPROPERTY_ITD3D_PARAMS, sizeof(KSDS3D_ITD_PARAMS_MSG)),
        Generic_Property_KSPROPERTY_ITD3D_PARAMS_6, "{17153299-E9E0-4a3d-A8A6-5FD53C0FFB4C}", ITD3D_PARAMS)

    // KSPROPSETID_Hrtf3d
    DEVICE_TEST_PARENT( "",   " KSPROPSETID_Hrtf3d",						    0, 0, 0, 0, NULL, "{9c6272d2-cf79-4f88-b17c-61227b688704}")

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_HRTF3D_PARAMS",				   0, 0, 0, 0, NULL, "{834707e4-d235-4fd8-92e8-fcea39c10074}")
    DEVICE_TEST_METHOD( "700.1.1", "   Invalid size",							   0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_NODE_PROP |RUN_IF_SUPPORTED | RUN_PROP, KSPROPSETID_Hrtf3d, KSPROPERTY_HRTF3D_PARAMS, sizeof(KSDS3D_HRTF_PARAMS_MSG)),
        Generic_Property_KSPROPERTY_HRTF3D_PARAMS_1, "{9542f59f-e2a8-45c3-812f-6a5af05674e9}", HRTF3D_PARAMS)
    DEVICE_TEST_METHOD( "700.1.2", "   Disable 3D",							   0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_NODE_PROP |RUN_IF_SUPPORTED | RUN_PROP, KSPROPSETID_Hrtf3d, KSPROPERTY_HRTF3D_PARAMS, sizeof(KSDS3D_HRTF_PARAMS_MSG)),
        Generic_Property_KSPROPERTY_HRTF3D_PARAMS_2, "{e4b0993e-3d45-4960-9120-e494e0bfbc7f}", HRTF3D_PARAMS)
    DEVICE_TEST_METHOD( "700.1.3", "   Dynamic invalid struct size",  		          0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_NODE_PROP |RUN_IF_SUPPORTED | RUN_PROP, KSPROPSETID_Hrtf3d, KSPROPERTY_HRTF3D_PARAMS, sizeof(KSDS3D_HRTF_PARAMS_MSG)),
        Generic_Property_KSPROPERTY_HRTF3D_PARAMS_3, "{a66c2993-a8b0-45d3-97be-443b2d4d0005}", HRTF3D_PARAMS)
    DEVICE_TEST_METHOD( "700.1.4", "   Dynamic invalid filter size",			          0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_NODE_PROP |RUN_IF_SUPPORTED | RUN_PROP, KSPROPSETID_Hrtf3d, KSPROPERTY_HRTF3D_PARAMS, sizeof(KSDS3D_HRTF_PARAMS_MSG)),
        Generic_Property_KSPROPERTY_HRTF3D_PARAMS_4, "{3b9a45a7-f98f-4080-86e4-8388f10c51ea}", HRTF3D_PARAMS)
    DEVICE_TEST_METHOD( "700.1.5", "   Zero size struct",						   0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_NODE_PROP |RUN_IF_SUPPORTED | RUN_PROP, KSPROPSETID_Hrtf3d, KSPROPERTY_HRTF3D_PARAMS, sizeof(KSDS3D_HRTF_PARAMS_MSG)),
        Generic_Property_KSPROPERTY_HRTF3D_PARAMS_5, "{72e37952-9e1f-458a-8e91-419a6366a476}", HRTF3D_PARAMS)

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_HRTF3D_FILTER_FORMAT",			    0, 0, 0, 0, NULL, "{3744356d-a496-4bb4-89c9-8562efe7a850}")
    DEVICE_TEST_METHOD( "700.2.1", "   Out buffer invalid size",				           0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_NODE_PROP |RUN_IF_SUPPORTED | RUN_PROP, KSPROPSETID_Hrtf3d, KSPROPERTY_HRTF3D_FILTER_FORMAT, sizeof(KSDS3D_HRTF_FILTER_FORMAT_MSG)),
        Generic_Property_KSPROPERTY_HRTF3D_FILTER_FORMAT_1, "{d8602562-b03e-491b-b589-df237381c09d}", HRTF3D_FILTER_FORMAT)

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_HRTF3D_INITIALIZE",				    0, 0, 0, 0, NULL, "{01c27533-0a84-45b3-88af-120faa0e2452}")
    DEVICE_TEST_METHOD( "700.3.1", "   Out buffer invalid size",			                  0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_NODE_PROP |RUN_IF_SUPPORTED | RUN_PROP, KSPROPSETID_Hrtf3d, KSPROPERTY_HRTF3D_INITIALIZE, sizeof(KSDS3D_HRTF_INIT_MSG)),
        Generic_Property_KSPROPERTY_HRTF3D_INITIALIZE_1, "{83dfb9ee-03f7-4e80-977b-a1f80abf4d32}", HRTF3D_INITIALIZE)

// Acoustic Echo Cancel ended in XP
#if (NTDDI_VERSION < NTDDI_VISTA)

    //KSPROPSETID_Acoustic_Echo_Cancel	
    DEVICE_TEST_PARENT( "",   " KSPROPSETID_Acoustic_Echo_Cancel",				0, 0, 0, 0, NULL, "{F135F5E2-4D5D-41f1-8414-F62ACE6FCC5F}")

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_AEC_MODE",                                         0, 0, 0, 0, NULL, "{9DB63CC2-6EBF-4feb-A12B-CF478537762D}")
    DEVICE_TEST_METHOD( "1200.1.1", "   Invalid Node ID - ULONG_MAX",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP |RUN_NODE_PROP |RUN_IF_SUPPORTED, KSPROPSETID_Acoustic_Echo_Cancel, KSPROPERTY_AEC_MODE, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTYULONG_NodeID_ULONGMAX, "{4F896715-DE40-4369-8169-9A76FAED4659}", AEC_MODE)
    DEVICE_TEST_METHOD( "1200.1.2", "   Invalid Node ID - 0x80000001",  			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP |RUN_NODE_PROP |RUN_IF_SUPPORTED, KSPROPSETID_Acoustic_Echo_Cancel, KSPROPERTY_AEC_MODE, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTYULONG_NodeID_0x80000001, "{45E5AB73-16E8-4c1e-8244-FF5901C96FDA}", AEC_MODE)
    DEVICE_TEST_METHOD( "1200.1.3", "   NULL IN/OUT Buffer",  					0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP |RUN_NODE_PROP |RUN_IF_SUPPORTED, KSPROPSETID_Acoustic_Echo_Cancel, KSPROPERTY_AEC_MODE, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTYULONG_NULL_Buffer, "{9FD12C3C-28D3-44ac-9EBE-432B6E8556B8}", AEC_MODE)
    DEVICE_TEST_METHOD( "1200.1.4", "   Small IN/OUT Buffer",  					0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP |RUN_NODE_PROP |RUN_IF_SUPPORTED, KSPROPSETID_Acoustic_Echo_Cancel, KSPROPERTY_AEC_MODE, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTYULONG_Small_Buffer, "{3408C884-4B27-4067-80B1-FA1F6169E101}", AEC_MODE)
    DEVICE_TEST_METHOD( "1200.1.5", "   Out buffer Large",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP |RUN_NODE_PROP |RUN_IF_SUPPORTED, KSPROPSETID_Acoustic_Echo_Cancel, KSPROPERTY_AEC_MODE, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTYULONG_Large_Buffer, "{D11ABBB3-C4B3-4966-808F-9A71CBD5EC1E}", AEC_MODE)

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_AEC_NOISE_FILL_ENABLE",                    0, 0, 0, 0, NULL, "{85F32BCE-1027-465d-B5CC-6182A2291B6A}")
    DEVICE_TEST_METHOD( "1200.2.1", "   Invalid Node ID - ULONG_MAX",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP |RUN_NODE_PROP |RUN_IF_SUPPORTED, KSPROPSETID_Acoustic_Echo_Cancel, KSPROPERTY_AEC_NOISE_FILL_ENABLE, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTYULONG_NodeID_ULONGMAX, "{6DAEDB74-04D4-405e-8480-462DF6911424}", AEC_NOISE_FILL_ENABLE)
    DEVICE_TEST_METHOD( "1200.2.2", "   Invalid Node ID - 0x80000001",  			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP |RUN_NODE_PROP |RUN_IF_SUPPORTED, KSPROPSETID_Acoustic_Echo_Cancel, KSPROPERTY_AEC_NOISE_FILL_ENABLE, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTYULONG_NodeID_0x80000001, "{D0604866-353E-4481-9B1A-852470595B51}", AEC_NOISE_FILL_ENABLE)
    DEVICE_TEST_METHOD( "1200.2.3", "   NULL IN/OUT Buffer",  					0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP |RUN_NODE_PROP |RUN_IF_SUPPORTED, KSPROPSETID_Acoustic_Echo_Cancel, KSPROPERTY_AEC_NOISE_FILL_ENABLE, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTYULONG_NULL_Buffer, "{A87C5A55-B6F1-4357-9FBC-208ED799CB3F}", AEC_NOISE_FILL_ENABLE)
    DEVICE_TEST_METHOD( "1200.2.4", "   Small IN/OUT Buffer",  					0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP |RUN_NODE_PROP |RUN_IF_SUPPORTED, KSPROPSETID_Acoustic_Echo_Cancel, KSPROPERTY_AEC_NOISE_FILL_ENABLE, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTYULONG_Small_Buffer, "{B719ABAB-8DDE-471f-9804-23808CD9A22A}", AEC_NOISE_FILL_ENABLE)
    DEVICE_TEST_METHOD( "1200.2.5", "   Out buffer Large",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP |RUN_NODE_PROP |RUN_IF_SUPPORTED, KSPROPSETID_Acoustic_Echo_Cancel, KSPROPERTY_AEC_NOISE_FILL_ENABLE, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTYULONG_Large_Buffer, "{326FFB20-808C-450d-8101-7B519CEEE5D4}", AEC_NOISE_FILL_ENABLE)

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_AEC_STATUS",                                      0, 0, 0, 0, NULL, "{08F81455-0A01-4d5c-B4CD-CC12F913C176}")
    DEVICE_TEST_METHOD( "1200.3.1", "   Invalid Node ID - ULONG_MAX",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP |RUN_NODE_PROP |RUN_IF_SUPPORTED, KSPROPSETID_Acoustic_Echo_Cancel, KSPROPERTY_AEC_STATUS, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTYULONG_NodeID_ULONGMAX, "{18DDE772-D032-4532-9B5C-4CECF6A8931A}", AEC_STATUS)
    DEVICE_TEST_METHOD( "1200.3.2", "   Invalid Node ID - 0x80000001",  			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP |RUN_NODE_PROP |RUN_IF_SUPPORTED, KSPROPSETID_Acoustic_Echo_Cancel, KSPROPERTY_AEC_STATUS, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTYULONG_NodeID_0x80000001, "{C73AD9D7-5E84-4bb3-B807-2F225579985C}", AEC_STATUS)
    DEVICE_TEST_METHOD( "1200.3.3", "   NULL IN/OUT Buffer",  					0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP |RUN_NODE_PROP |RUN_IF_SUPPORTED, KSPROPSETID_Acoustic_Echo_Cancel, KSPROPERTY_AEC_STATUS, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTYULONG_NULL_Buffer, "{3C2017B3-0ACC-4ef7-9519-255FD0EC7FDB}", AEC_STATUS)
    DEVICE_TEST_METHOD( "1200.3.4", "   Small IN/OUT Buffer",  					0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP |RUN_NODE_PROP |RUN_IF_SUPPORTED, KSPROPSETID_Acoustic_Echo_Cancel, KSPROPERTY_AEC_STATUS, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTYULONG_Small_Buffer, "{24F6ACA7-86D6-4a5c-A617-5576A9B770C0}", AEC_STATUS)
    DEVICE_TEST_METHOD( "1200.3.5", "   Out buffer Large",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP |RUN_NODE_PROP |RUN_IF_SUPPORTED, KSPROPSETID_Acoustic_Echo_Cancel, KSPROPERTY_AEC_STATUS, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTYULONG_Large_Buffer, "{0633C366-2987-4f79-97BA-D716F97A4C42}", AEC_STATUS)

#endif // (NTDDI_VERSION < NTDDI_VISTA)

    //KSPROPSETID_DirectSound3DBuffer  
    DEVICE_TEST_PARENT( "",   " KSPROPSETID_DirectSound3DBuffer",                     0, 0, 0, 0, NULL, "{3B70FD61-A6AF-416c-B7C9-C31D8281F7B4}")

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_DIRECTSOUND3DBUFFER_CONEOUTSIDEVOLUME",    0, 0, 0, 0, NULL, "{D31F815C-8611-4b7e-9BC2-900421CD554C}")
    DEVICE_TEST_METHOD( "1300.1.1", "   Invalid Node ID - ULONG_MAX",                                      0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_CONEOUTSIDEVOLUME, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTYULONG_NodeID_ULONGMAX, "{0855B3C1-62B7-440d-B251-0E9FF134EF3B}", DIRECTSOUND3DBUFFER_CONEOUTSIDEVOLUME)
    DEVICE_TEST_METHOD( "1300.1.2", "   Invalid Node ID - 0x80000001",                                       0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_CONEOUTSIDEVOLUME, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTYULONG_NodeID_0x80000001, "{37B8F0AB-0C39-4c1f-92C9-3273D58D6236}", DIRECTSOUND3DBUFFER_CONEOUTSIDEVOLUME)
    DEVICE_TEST_METHOD( "1300.1.3", "   NULL IN/OUT Buffer",                                                      0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_CONEOUTSIDEVOLUME, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTYULONG_NULL_Buffer, "{7D6B730C-E002-4747-8D93-9D9EB354BA98}", DIRECTSOUND3DBUFFER_CONEOUTSIDEVOLUME)
    DEVICE_TEST_METHOD( "1300.1.4", "   Small IN/OUT Buffer",                                                     0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_CONEOUTSIDEVOLUME, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTYULONG_Small_Buffer, "{B05B0EE6-F852-4d3c-8292-92854FE1A711}", DIRECTSOUND3DBUFFER_CONEOUTSIDEVOLUME)
    DEVICE_TEST_METHOD( "1300.1.5", "   Out buffer Large",                                                            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_CONEOUTSIDEVOLUME, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTYULONG_Large_Buffer, "{8082B45B-F9EE-45c2-BF33-33A1BD210BAC}", DIRECTSOUND3DBUFFER_CONEOUTSIDEVOLUME)

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_DIRECTSOUND3DBUFFER_MODE",        0, 0, 0, 0, NULL, "{7BED58FA-7A15-456f-9953-9667A69ADAE6}")
    DEVICE_TEST_METHOD( "1300.2.1", "   Invalid Node ID - ULONG_MAX",                  0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_MODE, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTYULONG_NodeID_ULONGMAX, "{AE511624-E68B-4164-B78E-FFA9E1C09F0E}", DIRECTSOUND3DBUFFER_MODE)
    DEVICE_TEST_METHOD( "1300.2.2", "   Invalid Node ID - 0x80000001",                   0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_MODE, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTYULONG_NodeID_0x80000001, "{78EE7885-59F8-4ba1-A63C-11D75290D582}", DIRECTSOUND3DBUFFER_MODE)
    DEVICE_TEST_METHOD( "1300.2.3", "   NULL IN/OUT Buffer",                                  0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_MODE, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTYULONG_NULL_Buffer, "{C5EE08B4-2E41-40d1-A813-9ACA637FCB7C}", DIRECTSOUND3DBUFFER_MODE)
    DEVICE_TEST_METHOD( "1300.2.4", "   Small IN/OUT Buffer",                                 0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_MODE, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTYULONG_Small_Buffer, "{D0978D94-D9C3-4eef-A56A-E8756EC600E2}", DIRECTSOUND3DBUFFER_MODE)
    DEVICE_TEST_METHOD( "1300.2.5", "   Out buffer Large",                                        0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_MODE, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTYULONG_Large_Buffer, "{B8016942-1D6D-4311-AFD0-A3478AD58661}", DIRECTSOUND3DBUFFER_MODE)

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_DIRECTSOUND3DBUFFER_ALL",       0, 0, 0, 0, NULL, "{FC44048B-5C71-4c05-8BB9-750540911C54}")
    DEVICE_TEST_METHOD( "1300.3.1", "   Invalid Node ID - ULONG_MAX",             0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_ALL, sizeof(KSDS3D_BUFFER_ALL)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_ALL_1, "{860A183C-20A5-4a8b-A5A4-B1A7363A092E}", DIRECTSOUND3DBUFFER_ALL)
    DEVICE_TEST_METHOD( "1300.3.2", "   Invalid Node ID - 0x80000001",              0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_ALL, sizeof(KSDS3D_BUFFER_ALL)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_ALL_2, "{699ECC8F-7DB3-453c-AF7A-72BAF0943214}", DIRECTSOUND3DBUFFER_ALL)
    DEVICE_TEST_METHOD( "1300.3.3", "   NULL IN/OUT Buffer",                             0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_ALL, sizeof(KSDS3D_BUFFER_ALL)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_ALL_3, "{85C62F41-4A63-4516-BCC6-FD22BBDDC7AF}", DIRECTSOUND3DBUFFER_ALL)
    DEVICE_TEST_METHOD( "1300.3.4", "   Small IN/OUT Buffer",                            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_ALL, sizeof(KSDS3D_BUFFER_ALL)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_ALL_4, "{D614D8A4-A875-4a35-92D2-8D210A8BA9EA}", DIRECTSOUND3DBUFFER_ALL)
    DEVICE_TEST_METHOD( "1300.3.5", "   Out buffer Large",                                  0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_ALL, sizeof(KSDS3D_BUFFER_ALL)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_ALL_5, "{7885DFED-4E9E-46a7-B1F8-8C80F64C7C44}", DIRECTSOUND3DBUFFER_ALL)
    DEVICE_TEST_METHOD( "1300.3.6", "   Invalid  Mode  - ULONG_MAX",               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_ALL, sizeof(KSDS3D_BUFFER_ALL)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_ALL_6, "{F3B8A03F-F4CF-4a99-8E38-7C5476A51675}", DIRECTSOUND3DBUFFER_ALL)
    DEVICE_TEST_METHOD( "1300.3.7", "   Invalid  Mode - 0x80000001",                 0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_ALL, sizeof(KSDS3D_BUFFER_ALL)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_ALL_7, "{98951774-6DB0-49ce-AE39-6C7AC49444E8}", DIRECTSOUND3DBUFFER_ALL)
    DEVICE_TEST_METHOD( "1300.3.8", "   Invalid Inside Cone angles - MIN-1",       0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_ALL, sizeof(KSDS3D_BUFFER_ALL)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_ALL_8, "{4ABB35CD-5241-4bfc-AB2C-E7FF5138345B}", DIRECTSOUND3DBUFFER_ALL)
    DEVICE_TEST_METHOD( "1300.3.9", "   Invalid Inside Cone angles - MAX+1",      0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_ALL, sizeof(KSDS3D_BUFFER_ALL)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_ALL_9, "{A81ADC36-EFFE-433f-B96B-2104BE02917F}", DIRECTSOUND3DBUFFER_ALL)
    DEVICE_TEST_METHOD( "1300.3.10", "   Invalid Outside Cone angles - MIN-1",    0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_ALL, sizeof(KSDS3D_BUFFER_ALL)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_ALL_10, "{60CAA0D4-6349-49c9-832B-71C6F07E83E6}", DIRECTSOUND3DBUFFER_ALL)
    DEVICE_TEST_METHOD( "1300.3.11", "   Invalid Outside Cone angles - MAX+1",   0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_ALL, sizeof(KSDS3D_BUFFER_ALL)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_ALL_11, "{53915D42-7337-410b-93D9-BFA0A31094BF}", DIRECTSOUND3DBUFFER_ALL)
    DEVICE_TEST_METHOD( "1300.3.12", "   Invalid Min Distance - (-1)",                   0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_ALL, sizeof(KSDS3D_BUFFER_ALL)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_ALL_12, "{7AE7F38A-94E4-4237-9807-9447B4A525FC}", DIRECTSOUND3DBUFFER_ALL)
    DEVICE_TEST_METHOD( "1300.3.13", "   Invalid Max Distance - (-1)",                  0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_ALL, sizeof(KSDS3D_BUFFER_ALL)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_ALL_13, "{529C85C4-128C-4c15-B259-FA2C3555F8EA}", DIRECTSOUND3DBUFFER_ALL)

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_DIRECTSOUND3DBUFFER_CONEANGLES", 0, 0, 0, 0, NULL, "{98F8EC37-F5F4-4789-8B5A-6970CD122696}")
    DEVICE_TEST_METHOD( "1300.4.1", "   Invalid Node ID - ULONG_MAX",                      0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_CONEANGLES, sizeof(KSDS3D_BUFFER_CONE_ANGLES)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_CONEANGLES_1, "{537336BC-CF4F-4591-BC38-16BDF7E4B157}", DIRECTSOUND3DBUFFER_CONEANGLES)
    DEVICE_TEST_METHOD( "1300.4.2", "   Invalid Node ID - 0x80000001",                       0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_CONEANGLES, sizeof(KSDS3D_BUFFER_CONE_ANGLES)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_CONEANGLES_2, "{B9600587-C81D-4b37-9971-F0573E6FAEC0}", DIRECTSOUND3DBUFFER_CONEANGLES)
    DEVICE_TEST_METHOD( "1300.4.3", "   NULL IN/OUT Buffer",                                      0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_CONEANGLES, sizeof(KSDS3D_BUFFER_CONE_ANGLES)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_CONEANGLES_3, "{81E2B45F-FFDC-4072-9D54-A7423BF94CFC}", DIRECTSOUND3DBUFFER_CONEANGLES)
    DEVICE_TEST_METHOD( "1300.4.4", "   Small IN/OUT Buffer",                                     0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_CONEANGLES, sizeof(KSDS3D_BUFFER_CONE_ANGLES)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_CONEANGLES_4, "{4F4F9004-ACE8-4548-A486-209B7AC616BA}", DIRECTSOUND3DBUFFER_CONEANGLES)
    DEVICE_TEST_METHOD( "1300.4.5", "   Out buffer Large",                                            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_CONEANGLES, sizeof(KSDS3D_BUFFER_CONE_ANGLES)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_CONEANGLES_5, "{A9A1B48C-3F4B-4346-95F3-EA7090687381}", DIRECTSOUND3DBUFFER_CONEANGLES)
    DEVICE_TEST_METHOD( "1300.4.6", "   Invalid Inside Cone angles - MIN-1",                 0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_CONEANGLES, sizeof(KSDS3D_BUFFER_CONE_ANGLES)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_CONEANGLES_6, "{7D9D1E5E-AFD8-43e9-9865-A90FD865FAE0}", DIRECTSOUND3DBUFFER_CONEANGLES)
    DEVICE_TEST_METHOD( "1300.4.7", "   Invalid Inside Cone angles - MAX+1",                0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_CONEANGLES, sizeof(KSDS3D_BUFFER_CONE_ANGLES)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_CONEANGLES_7, "{57CC3B1A-7745-4c50-8CFA-1B20FCCD9B91}", DIRECTSOUND3DBUFFER_CONEANGLES)
    DEVICE_TEST_METHOD( "1300.4.8", "   Invalid Outside Cone angles - MIN-1",               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_CONEANGLES, sizeof(KSDS3D_BUFFER_CONE_ANGLES)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_CONEANGLES_8, "{7D70DA85-F5EC-4e84-95D9-9BDD428BC2A4}", DIRECTSOUND3DBUFFER_CONEANGLES)
    DEVICE_TEST_METHOD( "1300.4.9", "   Invalid Outside Cone angles - MAX+1",              0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_CONEANGLES, sizeof(KSDS3D_BUFFER_CONE_ANGLES)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_CONEANGLES_9, "{E0435D14-ED6A-400c-9BDE-26E7061B67DA}", DIRECTSOUND3DBUFFER_CONEANGLES)

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_DIRECTSOUND3DBUFFER_CONEORIENTATION",    0, 0, 0, 0, NULL, "{5DE789B5-F47E-4fc5-871E-D7CAD5B17F0D}")
    DEVICE_TEST_METHOD( "1300.5.1", "   Invalid Node ID - ULONG_MAX",                                  0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_CONEORIENTATION, sizeof(DS3DVECTOR)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_CONEORIENTATION_1, "{3231C7B4-9264-4eed-A728-BF2C913391F9}", DIRECTSOUND3DBUFFER_CONEORIENTATION)
    DEVICE_TEST_METHOD( "1300.5.2", "   Invalid Node ID - 0x80000001",                                   0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_CONEORIENTATION, sizeof(DS3DVECTOR)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_CONEORIENTATION_2, "{181390B3-0D98-4f7b-9037-C6F72F63B4FB}", DIRECTSOUND3DBUFFER_CONEORIENTATION)
    DEVICE_TEST_METHOD( "1300.5.3", "   NULL IN/OUT Buffer",                                                  0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_CONEORIENTATION, sizeof(DS3DVECTOR)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_CONEORIENTATION_3, "{430FCF76-D9B4-4f9a-9F0F-DF1880166C77}", DIRECTSOUND3DBUFFER_CONEORIENTATION)
    DEVICE_TEST_METHOD( "1300.5.4", "   Small IN/OUT Buffer",                                                 0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_CONEORIENTATION, sizeof(DS3DVECTOR)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_CONEORIENTATION_4, "{C792252B-9C63-465f-860C-820F7C33FCB6}", DIRECTSOUND3DBUFFER_CONEORIENTATION)
    DEVICE_TEST_METHOD( "1300.5.5", "   Out buffer Large",                                                       0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_CONEORIENTATION, sizeof(DS3DVECTOR)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_CONEORIENTATION_5, "{BB5EA579-1679-438b-9EF9-D19E65BAC020}", DIRECTSOUND3DBUFFER_CONEORIENTATION)

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_DIRECTSOUND3DBUFFER_MAXDISTANCE",        0, 0, 0, 0, NULL, "{B905355C-7AA5-4d9a-8726-95B6BF879643}")
    DEVICE_TEST_METHOD( "1300.6.1", "   Invalid Node ID - ULONG_MAX",                              0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_MAXDISTANCE, sizeof(FLOAT)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_MAXDISTANCE_1, "{B51F8D25-D7BB-44b1-B7DB-D718854E140C}", DIRECTSOUND3DBUFFER_MAXDISTANCE)
    DEVICE_TEST_METHOD( "1300.6.2", "   Invalid Node ID - 0x80000001",                                 0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_MAXDISTANCE, sizeof(FLOAT)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_MAXDISTANCE_2, "{15643C88-A810-4f04-BB5C-3E434D1F8040}", DIRECTSOUND3DBUFFER_MAXDISTANCE)
    DEVICE_TEST_METHOD( "1300.6.3", "   NULL IN/OUT Buffer",                                                0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_MAXDISTANCE, sizeof(FLOAT)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_MAXDISTANCE_3, "{5348498C-8E05-4645-AF9E-67A836D65826}", DIRECTSOUND3DBUFFER_MAXDISTANCE)
    DEVICE_TEST_METHOD( "1300.6.4", "   Small IN/OUT Buffer",                                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_MAXDISTANCE, sizeof(FLOAT)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_MAXDISTANCE_4, "{9739520A-FEEF-4048-AD4D-3C4C5A7CA155}", DIRECTSOUND3DBUFFER_MAXDISTANCE)
    DEVICE_TEST_METHOD( "1300.6.5", "   Out buffer Large",                                                     0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_MAXDISTANCE, sizeof(FLOAT)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_MAXDISTANCE_5, "{8D3D3221-2EA3-401a-AEC0-C9FEDB604AC9}", DIRECTSOUND3DBUFFER_MAXDISTANCE)
    DEVICE_TEST_METHOD( "1300.6.6", "   Invalid Max Distance - (-1)",                                     0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_MAXDISTANCE, sizeof(FLOAT)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_MAXDISTANCE_6, "{C998F1E6-1A6F-466f-A02F-4B6B3BA1B175}", DIRECTSOUND3DBUFFER_MAXDISTANCE)

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_DIRECTSOUND3DBUFFER_MINDISTANCE",       0, 0, 0, 0, NULL, "{CF567DC9-28A9-4332-B06E-A6527AF7F47D}")
    DEVICE_TEST_METHOD( "1300.7.1", "   Invalid Node ID - ULONG_MAX",                          0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_MINDISTANCE, sizeof(FLOAT)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_MINDISTANCE_1, "{00F7F420-6944-4d1a-AB18-98777024DBB3}", DIRECTSOUND3DBUFFER_MINDISTANCE)
    DEVICE_TEST_METHOD( "1300.7.2", "   Invalid Node ID - 0x80000001",                           0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_MINDISTANCE, sizeof(FLOAT)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_MINDISTANCE_2, "{8F8B80A7-2867-4361-8AB9-C91F9905ADFF}", DIRECTSOUND3DBUFFER_MINDISTANCE)
    DEVICE_TEST_METHOD( "1300.7.3", "   NULL IN/OUT Buffer",                                          0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_MINDISTANCE, sizeof(FLOAT)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_MINDISTANCE_3, "{3F8D2F31-74D8-4e01-96F0-E52D80FFF05D}", DIRECTSOUND3DBUFFER_MINDISTANCE)
    DEVICE_TEST_METHOD( "1300.7.4", "   Small IN/OUT Buffer",                                         0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_MINDISTANCE, sizeof(FLOAT)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_MINDISTANCE_4, "{704F4873-7062-46da-B4C1-FBF299367ECE}", DIRECTSOUND3DBUFFER_MINDISTANCE)
    DEVICE_TEST_METHOD( "1300.7.5", "   Out buffer Large",                                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_MINDISTANCE, sizeof(FLOAT)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_MINDISTANCE_5, "{50F9065B-E73B-467c-8947-87D95C24E57F}", DIRECTSOUND3DBUFFER_MINDISTANCE)
    DEVICE_TEST_METHOD( "1300.7.6", "   Invalid Min Distance - (-1)",                                0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_MINDISTANCE, sizeof(FLOAT)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_MINDISTANCE_6, "{CFAC5FBB-342F-4bc6-B6A1-D00B142E7FDD}", DIRECTSOUND3DBUFFER_MINDISTANCE)

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_DIRECTSOUND3DBUFFER_POSITION",      0, 0, 0, 0, NULL, "{8C5B0090-7F55-490f-BBAC-CFB69CD26CB5}")
    DEVICE_TEST_METHOD( "1300.8.1", "   Invalid Node ID - ULONG_MAX",                      0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_POSITION, sizeof(DS3DVECTOR)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_POSITION_1, "{DFFFACE1-D98C-4e93-AC69-E2248F79E0D4}", DIRECTSOUND3DBUFFER_POSITION)
    DEVICE_TEST_METHOD( "1300.8.2", "   Invalid Node ID - 0x80000001",                       0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_POSITION, sizeof(DS3DVECTOR)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_POSITION_2, "{5A551A41-A6F6-4739-BBB4-0D2D7ACF0334}", DIRECTSOUND3DBUFFER_POSITION)
    DEVICE_TEST_METHOD( "1300.8.3", "   NULL IN/OUT Buffer",                                       0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_POSITION, sizeof(DS3DVECTOR)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_POSITION_3, "{97571D7B-A84A-4429-A921-EF80BB83690C}", DIRECTSOUND3DBUFFER_POSITION)
    DEVICE_TEST_METHOD( "1300.8.4", "   Small IN/OUT Buffer",                                      0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_POSITION, sizeof(DS3DVECTOR)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_POSITION_4, "{ED05A8F1-3C68-4f5e-BEFA-5E65B6263705}", DIRECTSOUND3DBUFFER_POSITION)
    DEVICE_TEST_METHOD( "1300.8.5", "   Out buffer Large",                                             0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_POSITION, sizeof(DS3DVECTOR)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_POSITION_5, "{290B90F3-0951-4580-87CC-A26269C2E60B}", DIRECTSOUND3DBUFFER_POSITION)

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_DIRECTSOUND3DBUFFER_VELOCITY",      0, 0, 0, 0, NULL, "{9FE18A49-E852-4401-8F90-7B126D4CE43A}")
    DEVICE_TEST_METHOD( "1300.9.1", "   Invalid Node ID - ULONG_MAX",                      0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_VELOCITY, sizeof(DS3DVECTOR)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_VELOCITY_1, "{2A521A33-B2C6-44cb-AF4A-FC982803F3CA}", DIRECTSOUND3DBUFFER_VELOCITY)
    DEVICE_TEST_METHOD( "1300.9.2", "   Invalid Node ID - 0x80000001",                       0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_VELOCITY, sizeof(DS3DVECTOR)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_VELOCITY_2, "{6C4D871F-09F3-448c-8077-3020B1728E8F}", DIRECTSOUND3DBUFFER_VELOCITY)
    DEVICE_TEST_METHOD( "1300.9.3", "   NULL IN/OUT Buffer",                                      0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_VELOCITY, sizeof(DS3DVECTOR)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_VELOCITY_3, "{F00DC9AD-BE59-4240-BE79-6A3A2042638A}", DIRECTSOUND3DBUFFER_VELOCITY)
    DEVICE_TEST_METHOD( "1300.9.4", "   Small IN/OUT Buffer",                                     0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_VELOCITY, sizeof(DS3DVECTOR)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_VELOCITY_4, "{1200A5D3-91B9-4d34-BD7D-10D3B0C5E6DA}", DIRECTSOUND3DBUFFER_VELOCITY)
    DEVICE_TEST_METHOD( "1300.9.5", "   Out buffer Large",                                           0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DBuffer, KSPROPERTY_DIRECTSOUND3DBUFFER_VELOCITY, sizeof(DS3DVECTOR)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DBUFFER_VELOCITY_5, "{21298B1F-2DFD-45e9-A0DF-344159BD94E0}", DIRECTSOUND3DBUFFER_VELOCITY)

    //KSPROPSETID_DirectSound3DListener 
    DEVICE_TEST_PARENT( "",   " KSPROPSETID_DirectSound3DListener",                       0, 0, 0, 0, NULL, "{28B2217E-62B3-4d4f-9027-5724DC48AE91}")

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_DIRECTSOUND3DLISTENER_ALLOCATION",   0, 0, 0, 0, NULL, "{3B16E8F5-BEE1-49b0-99A2-AA7DD2B6E843}")
    DEVICE_TEST_METHOD( "1400.1.1", "   Invalid Node ID - ULONG_MAX",                          0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_ALLOCATION, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTYULONG_NodeID_ULONGMAX, "{BCDBE515-BBDD-48e1-A0AF-2C4AD90BBCAD}", DIRECTSOUND3DLISTENER_ALLOCATION)
    DEVICE_TEST_METHOD( "1400.1.2", "   Invalid Node ID - 0x80000001",                           0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_ALLOCATION, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTYULONG_NodeID_0x80000001, "{9C5154DD-BFF1-4d3c-93EE-9ACD60E81E39}", DIRECTSOUND3DLISTENER_ALLOCATION)
    DEVICE_TEST_METHOD( "1400.1.3", "   NULL IN/OUT Buffer",                                          0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_ALLOCATION, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTYULONG_NULL_Buffer, "{FF29CBCC-B132-4f9b-A61C-40DAE616CF51}", DIRECTSOUND3DLISTENER_ALLOCATION)
    DEVICE_TEST_METHOD( "1400.1.4", "   Small IN/OUT Buffer",                                         0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_ALLOCATION, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTYULONG_Small_Buffer, "{23AF1D82-6501-4563-A97C-559B26DC699F}", DIRECTSOUND3DLISTENER_ALLOCATION)
    DEVICE_TEST_METHOD( "1400.1.5", "   Out buffer Large",                                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_ALLOCATION, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTYULONG_Large_Buffer, "{CBD93E2D-3EBB-4c29-B500-049D9C92FD6A}", DIRECTSOUND3DLISTENER_ALLOCATION)

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_DIRECTSOUND3DLISTENER_BATCH",        0, 0, 0, 0, NULL, "{A7941052-3820-4e81-B70C-57C9954399AF}")
    DEVICE_TEST_METHOD( "1400.2.1", "   Invalid Node ID - ULONG_MAX",                      0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_BATCH, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTYULONG_NodeID_ULONGMAX, "{54D93ADA-446B-46e6-B00D-9F949819674B}", DIRECTSOUND3DLISTENER_BATCH)
    DEVICE_TEST_METHOD( "1400.2.2", "   Invalid Node ID - 0x80000001",                         0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_BATCH, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTYULONG_NodeID_0x80000001, "{8E29CE84-9B6D-4612-BA93-6FBA0624B624}", DIRECTSOUND3DLISTENER_BATCH)
    DEVICE_TEST_METHOD( "1400.2.3", "   NULL IN/OUT Buffer",                                       0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_BATCH, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTYULONG_NULL_Buffer, "{F7AB3ECD-8A79-47d4-B0C1-4DEE7E6A99B9}", DIRECTSOUND3DLISTENER_BATCH)
    DEVICE_TEST_METHOD( "1400.2.4", "   Small IN/OUT Buffer",                                      0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_BATCH, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTYULONG_Small_Buffer, "{5BD0CE82-B4AF-423a-9302-6D2135536BBF}", DIRECTSOUND3DLISTENER_BATCH)
    DEVICE_TEST_METHOD( "1400.2.5", "   Out buffer Large",                                             0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_BATCH, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTYULONG_Large_Buffer, "{07C5DCC0-5CDE-49f6-B683-E3F7EEC11B6E}", DIRECTSOUND3DLISTENER_BATCH)

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_DIRECTSOUND3DLISTENER_ALL",         0, 0, 0, 0, NULL, "{AD3F4B0F-AC9D-455a-98DE-C936C0C2E42F}")
    DEVICE_TEST_METHOD( "1400.3.1", "   Invalid Node ID - ULONG_MAX",                  0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_ALL, sizeof(KSDS3D_LISTENER_ALL)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_ALL_1, "{E711BAC8-7860-4ed1-94CF-D4DCC7850E2A}", DIRECTSOUND3DLISTENER_ALL)
    DEVICE_TEST_METHOD( "1400.3.2", "   Invalid Node ID - 0x80000001",                   0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_ALL, sizeof(KSDS3D_LISTENER_ALL)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_ALL_2, "{99B106C5-67A4-43d7-AF91-6F9203F9BE46}", DIRECTSOUND3DLISTENER_ALL)
    DEVICE_TEST_METHOD( "1400.3.3", "   NULL IN/OUT Buffer",                                  0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_ALL, sizeof(KSDS3D_LISTENER_ALL)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_ALL_3, "{88877074-3DAF-48ec-9F55-6A2906DEA207}", DIRECTSOUND3DLISTENER_ALL)
    DEVICE_TEST_METHOD( "1400.3.4", "   Small IN/OUT Buffer",                                 0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_ALL, sizeof(KSDS3D_LISTENER_ALL)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_ALL_4, "{FD09E34F-F620-4d43-9E30-C31511470EC2}", DIRECTSOUND3DLISTENER_ALL)
    DEVICE_TEST_METHOD( "1400.3.5", "   Out buffer Large",                                       0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_ALL, sizeof(KSDS3D_LISTENER_ALL)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_ALL_5, "{87BC12C5-4E45-4b52-830C-512A8F468C1E}", DIRECTSOUND3DLISTENER_ALL)
    DEVICE_TEST_METHOD( "1400.3.6", "   Invalid RolloffFactor - MIN-1",                     0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_ALL, sizeof(KSDS3D_LISTENER_ALL)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_ALL_6, "{1DBA0717-5999-4352-8B8D-B15220381599}", DIRECTSOUND3DLISTENER_ALL)
    DEVICE_TEST_METHOD( "1400.3.7", "   Invalid RolloffFactor - MAX+1",                    0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_ALL, sizeof(KSDS3D_LISTENER_ALL)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_ALL_7, "{8D47E7F9-44C1-4a29-8B31-2B6BC6342E92}", DIRECTSOUND3DLISTENER_ALL)
    DEVICE_TEST_METHOD( "1400.3.8", "   Invalid DopplerFactor - MIN-1",                   0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_ALL, sizeof(KSDS3D_LISTENER_ALL)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_ALL_8, "{34C384E9-9413-4f60-AF54-A4BCD3C8A5E7}", DIRECTSOUND3DLISTENER_ALL)
    DEVICE_TEST_METHOD( "1400.3.9", "   Invalid DopplerFactor - MAX+1",                  0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_ALL, sizeof(KSDS3D_LISTENER_ALL)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_ALL_9, "{EB1452D4-E154-4a89-A715-9933A36E1F22}", DIRECTSOUND3DLISTENER_ALL)
    DEVICE_TEST_METHOD( "1400.3.10", "   Invalid Distance Factor - (-1)",                   0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_ALL, sizeof(KSDS3D_LISTENER_ALL)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_ALL_10, "{C61D196C-5A86-483b-A7E0-11E91748A5DA}", DIRECTSOUND3DLISTENER_ALL)

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_DIRECTSOUND3DLISTENER_DISTANCEFACTOR",   0, 0, 0, 0, NULL, "{00A62896-08FB-4e5b-9B31-ABFB5B8F6464}")
    DEVICE_TEST_METHOD( "1400.4.1", "   Invalid Node ID - ULONG_MAX",                                  0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_DISTANCEFACTOR, sizeof(FLOAT)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_DISTANCEFACTOR_1, "{FFCA4F6E-FFA9-46b5-8920-C3026B9864F2}", DIRECTSOUND3DLISTENER_DISTANCEFACTOR)
    DEVICE_TEST_METHOD( "1400.4.2", "   Invalid Node ID - 0x80000001",                                   0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_DISTANCEFACTOR, sizeof(FLOAT)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_DISTANCEFACTOR_2, "{E92EF3AE-F75A-4e71-A06C-F3B3901806AC}", DIRECTSOUND3DLISTENER_DISTANCEFACTOR)
    DEVICE_TEST_METHOD( "1400.4.3", "   NULL IN/OUT Buffer",                                                  0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_DISTANCEFACTOR, sizeof(FLOAT)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_DISTANCEFACTOR_3, "{F70D7E87-EC04-443f-98D4-21B40E3E9D85}", DIRECTSOUND3DLISTENER_DISTANCEFACTOR)
    DEVICE_TEST_METHOD( "1400.4.4", "   Small IN/OUT Buffer",                                                 0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_DISTANCEFACTOR, sizeof(FLOAT)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_DISTANCEFACTOR_4, "{C5325D27-3795-49f0-81B2-31A362E6617C}", DIRECTSOUND3DLISTENER_DISTANCEFACTOR)
    DEVICE_TEST_METHOD( "1400.4.5", "   Out buffer Large",                                                       0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_DISTANCEFACTOR, sizeof(FLOAT)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_DISTANCEFACTOR_5, "{0DFA9C7D-EEF6-40da-ABA3-BF8A8066CF0E}", DIRECTSOUND3DLISTENER_DISTANCEFACTOR)

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_DIRECTSOUND3DLISTENER_DOPPLERFACTOR",   0, 0, 0, 0, NULL, "{E522B087-9D49-4a81-BAA7-92F09EB12115}")
    DEVICE_TEST_METHOD( "1400.5.1", "   Invalid Node ID - ULONG_MAX",                                 0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_DOPPLERFACTOR, sizeof(FLOAT)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_DOPPLERFACTOR_1, "{838F5C3F-C6EE-417b-B97F-F63F66F568F4}", DIRECTSOUND3DLISTENER_DOPPLERFACTOR)
    DEVICE_TEST_METHOD( "1400.5.2", "   Invalid Node ID - 0x80000001",                                 0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_DOPPLERFACTOR, sizeof(FLOAT)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_DOPPLERFACTOR_2, "{DDB829DB-865E-4dc2-A2A5-979FE201E7AD}", DIRECTSOUND3DLISTENER_DOPPLERFACTOR)
    DEVICE_TEST_METHOD( "1400.5.3", "   NULL IN/OUT Buffer",                                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_DOPPLERFACTOR, sizeof(FLOAT)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_DOPPLERFACTOR_3, "{A79D8823-FD27-4930-82C9-E18855D47254}", DIRECTSOUND3DLISTENER_DOPPLERFACTOR)
    DEVICE_TEST_METHOD( "1400.5.4", "   Small IN/OUT Buffer",                                              0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_DOPPLERFACTOR, sizeof(FLOAT)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_DOPPLERFACTOR_4, "{4832389F-0B6A-467d-AEC1-C8B61C13CC1A}", DIRECTSOUND3DLISTENER_DOPPLERFACTOR)
    DEVICE_TEST_METHOD( "1400.5.5", "   Out buffer Large",                                                     0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_DOPPLERFACTOR, sizeof(FLOAT)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_DOPPLERFACTOR_5, "{3EF7941C-292C-4795-8E52-371182DA36E5}", DIRECTSOUND3DLISTENER_DOPPLERFACTOR)
    DEVICE_TEST_METHOD( "1400.5.6", "   Invalid Doppler factor - MIN-1",                                0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_DOPPLERFACTOR, sizeof(FLOAT)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_DOPPLERFACTOR_6, "{0569C75F-85C8-4e60-B96D-2FA49E75B87C}", DIRECTSOUND3DLISTENER_DOPPLERFACTOR)
    DEVICE_TEST_METHOD( "1400.5.7", "   Invalid Doppler factor - MAX+1",                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_DOPPLERFACTOR, sizeof(FLOAT)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_DOPPLERFACTOR_7, "{835EBBB4-16A4-4fcb-8C63-457BAC9669FC}", DIRECTSOUND3DLISTENER_DOPPLERFACTOR)

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_DIRECTSOUND3DLISTENER_ORIENTATION",     0, 0, 0, 0, NULL, "{4D79E546-3AE9-47fa-987D-97FA60066438}")
    DEVICE_TEST_METHOD( "1400.6.1", "   Invalid Node ID - ULONG_MAX",                              0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_ORIENTATION, sizeof(KSDS3D_LISTENER_ORIENTATION)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_ORIENTATION_1, "{D1BAE0C4-7C4E-4df8-8194-E4D6D45A9FD8}", DIRECTSOUND3DLISTENER_ORIENTATION)
    DEVICE_TEST_METHOD( "1400.6.2", "   Invalid Node ID - 0x80000001",                              0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_ORIENTATION, sizeof(KSDS3D_LISTENER_ORIENTATION)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_ORIENTATION_2, "{46DB7584-B7D1-4ea4-A671-271F09E349C1}", DIRECTSOUND3DLISTENER_ORIENTATION)
    DEVICE_TEST_METHOD( "1400.6.3", "   NULL IN/OUT Buffer",                                             0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_ORIENTATION, sizeof(KSDS3D_LISTENER_ORIENTATION)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_ORIENTATION_3, "{3A5729E3-4BCB-4e77-9F15-FFCA32E13F76}", DIRECTSOUND3DLISTENER_ORIENTATION)
    DEVICE_TEST_METHOD( "1400.6.4", "   Small IN/OUT Buffer",                                            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_ORIENTATION, sizeof(KSDS3D_LISTENER_ORIENTATION)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_ORIENTATION_4, "{60E0F923-D6B0-4f21-B94D-398C1591D7F9}", DIRECTSOUND3DLISTENER_ORIENTATION)
    DEVICE_TEST_METHOD( "1400.6.5", "   Out buffer Large",                                                 0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_ORIENTATION, sizeof(KSDS3D_LISTENER_ORIENTATION)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_ORIENTATION_5, "{66423753-170D-4381-9D76-7D7E96A4A3CD}", DIRECTSOUND3DLISTENER_ORIENTATION)

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_DIRECTSOUND3DLISTENER_POSITION",        0, 0, 0, 0, NULL, "{8DE442CD-085F-4132-A620-1C486DD182E3}")
    DEVICE_TEST_METHOD( "1400.7.1", "   Invalid Node ID - ULONG_MAX",             0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_POSITION, sizeof(DS3DVECTOR)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_POSITION_1, "{07A47A70-8703-43bf-BE3D-82405B9ADFDF}", DIRECTSOUND3DLISTENER_POSITION)
    DEVICE_TEST_METHOD( "1400.7.2", "   Invalid Node ID - 0x80000001",            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_POSITION, sizeof(DS3DVECTOR)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_POSITION_2, "{EEEF03AE-149B-42dd-8BC8-F317B4F941EB}", DIRECTSOUND3DLISTENER_POSITION)
    DEVICE_TEST_METHOD( "1400.7.3", "   NULL IN/OUT Buffer",                      0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_POSITION, sizeof(DS3DVECTOR)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_POSITION_3, "{548BA212-78A3-4552-B48C-16277C74A5E4}", DIRECTSOUND3DLISTENER_POSITION)
    DEVICE_TEST_METHOD( "1400.7.4", "   Small IN/OUT Buffer",                     0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_POSITION, sizeof(DS3DVECTOR)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_POSITION_4, "{F2E5ABB7-6BFF-4866-99A3-09DC327A51B1}", DIRECTSOUND3DLISTENER_POSITION)
    DEVICE_TEST_METHOD( "1400.7.5", "   Out buffer Large",                        0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_POSITION, sizeof(DS3DVECTOR)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_POSITION_5, "{9966C175-361F-4361-9282-A2C9F776FA43}", DIRECTSOUND3DLISTENER_POSITION)

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_DIRECTSOUND3DLISTENER_ROLLOFFFACTOR",   0, 0, 0, 0, NULL, "{2E0EEDD4-9056-4deb-8BFE-9183E0D451C5}")
    DEVICE_TEST_METHOD( "1400.8.1", "   Invalid Node ID - ULONG_MAX",             0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_ROLLOFFFACTOR, sizeof(FLOAT)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_ROLLOFFFACTOR_1, "{74B9C929-256F-40ac-9324-B405897D7F44}", DIRECTSOUND3DLISTENER_ROLLOFFFACTOR)
    DEVICE_TEST_METHOD( "1400.8.2", "   Invalid Node ID - 0x80000001",            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_ROLLOFFFACTOR, sizeof(FLOAT)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_ROLLOFFFACTOR_2, "{DD887902-FCA6-4518-979C-475E2D10DDE4}", DIRECTSOUND3DLISTENER_ROLLOFFFACTOR)
    DEVICE_TEST_METHOD( "1400.8.3", "   NULL IN/OUT Buffer",                      0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_ROLLOFFFACTOR, sizeof(FLOAT)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_ROLLOFFFACTOR_3, "{D603BA2E-F6B4-4bd6-AD5E-22BCE7EC21F4}", DIRECTSOUND3DLISTENER_ROLLOFFFACTOR)
    DEVICE_TEST_METHOD( "1400.8.4", "   Small IN/OUT Buffer",                     0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_ROLLOFFFACTOR, sizeof(FLOAT)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_ROLLOFFFACTOR_4, "{66136181-41B8-44a4-8E33-A3569E736991}", DIRECTSOUND3DLISTENER_ROLLOFFFACTOR)
    DEVICE_TEST_METHOD( "1400.8.5", "   Out buffer Large",                        0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_ROLLOFFFACTOR, sizeof(FLOAT)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_ROLLOFFFACTOR_5, "{F7A426F4-82A2-41ef-8733-4FBC2921E63C}", DIRECTSOUND3DLISTENER_ROLLOFFFACTOR)
    DEVICE_TEST_METHOD( "1400.8.6", "   Invalid rolloff factor - FLT_MIN",        0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_ROLLOFFFACTOR, sizeof(FLOAT)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_ROLLOFFFACTOR_6, "{EF1BE54E-B49D-4b53-93BA-3EB19F80FF99}", DIRECTSOUND3DLISTENER_ROLLOFFFACTOR)
    DEVICE_TEST_METHOD( "1400.8.7", "   Invalid rolloff factor - FLT_MAX",        0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_ROLLOFFFACTOR, sizeof(FLOAT)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_ROLLOFFFACTOR_7, "{A9AFAD1E-5EA6-48fc-A77C-B1B5C95B5C84}", DIRECTSOUND3DLISTENER_ROLLOFFFACTOR)

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_DIRECTSOUND3DLISTENER_VELOCITY",        0, 0, 0, 0, NULL, "{5E0A0799-52B7-4d16-AE66-3FCFF751FF8D}")
    DEVICE_TEST_METHOD( "1400.9.1", "   Invalid Node ID - ULONG_MAX",             0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_VELOCITY, sizeof(DS3DVECTOR)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_VELOCITY_1, "{F0CCC7BB-D8EB-445e-9649-B625861649CD}", DIRECTSOUND3DLISTENER_VELOCITY)
    DEVICE_TEST_METHOD( "1400.9.2", "   Invalid Node ID - 0x80000001",            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_VELOCITY, sizeof(DS3DVECTOR)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_VELOCITY_2, "{68C79700-B6B7-49d5-860D-ED55CED0FF29}", DIRECTSOUND3DLISTENER_VELOCITY)
    DEVICE_TEST_METHOD( "1400.9.3", "   NULL IN/OUT Buffer",                      0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_VELOCITY, sizeof(DS3DVECTOR)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_VELOCITY_3, "{B6D65322-538F-420f-91AB-7085B8B07CD4}", DIRECTSOUND3DLISTENER_VELOCITY)
    DEVICE_TEST_METHOD( "1400.9.4", "   Small IN/OUT Buffer",                     0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_VELOCITY, sizeof(DS3DVECTOR)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_VELOCITY_4, "{835B6C0C-BB1E-43c0-9335-06D79CBD7E0A}", DIRECTSOUND3DLISTENER_VELOCITY)
    DEVICE_TEST_METHOD( "1400.9.5", "   Out buffer Large",                        0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DirectSound3DListener, KSPROPERTY_DIRECTSOUND3DLISTENER_VELOCITY, sizeof(DS3DVECTOR)),
        Generic_Property_KSPROPERTY_DIRECTSOUND3DLISTENER_VELOCITY_5, "{DC1106BC-4B60-4145-B542-7D3D657C6E42}", DIRECTSOUND3DLISTENER_VELOCITY)

    //KSPROPSETID_Synth	
    DEVICE_TEST_PARENT( "",   " KSPROPSETID_Synth",						0, 0, 0, 0, NULL, "{16AEFF18-05D8-49b6-843C-6F9AF0B73C16}")

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_SYNTH_CAPS",				            0, 0, 0, 0, NULL, "{9F78EA66-D65C-4eb2-883D-B400AA59445B}")
    DEVICE_TEST_METHOD( "1500.1.1", "   Invalid Node ID - ULONG_MAX",	            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_CAPS, sizeof(SYNTHCAPS)),
        Generic_Property_KSPROPERTY_SYNTH_CAPS_1, "{3031EB25-4D90-4454-B1D3-5E95D8E6D83F}", SYNTH_CAPS)
    DEVICE_TEST_METHOD( "1500.1.2", "   Invalid Node ID - 0x80000001",		    0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_CAPS, sizeof(SYNTHCAPS)),
        Generic_Property_KSPROPERTY_SYNTH_CAPS_2, "{959CD575-D4CD-4138-BC20-BAD985B7A77F}", SYNTH_CAPS)
    DEVICE_TEST_METHOD( "1500.1.3", "   Out buffer NULL",						  0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_CAPS, sizeof(SYNTHCAPS)),
        Generic_Property_KSPROPERTY_SYNTH_CAPS_3, "{87F35E76-D2ED-484b-90BB-DB82D7811F2D}", SYNTH_CAPS)
    DEVICE_TEST_METHOD( "1500.1.4", "   Out buffer Small",                                    0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_CAPS, sizeof(SYNTHCAPS)),
        Generic_Property_KSPROPERTY_SYNTH_CAPS_4, "{BD6FD9BF-2CAA-4e93-89B1-5978BE81AEE4}", SYNTH_CAPS)
    DEVICE_TEST_METHOD( "1500.1.5", "   Out buffer Large",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_CAPS, sizeof(SYNTHCAPS)),
        Generic_Property_KSPROPERTY_SYNTH_CAPS_5, "{92DE9AAA-B1CE-4ffe-B908-D0752C5839E8}", SYNTH_CAPS)

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_SYNTH_CHANNELGROUPS",				    0, 0, 0, 0, NULL, "{38E05C4E-5FAD-4e56-855B-1D38E318CCE1}")
    DEVICE_TEST_METHOD( "1500.2.1", "   Invalid Node ID - ULONG_MAX",			    0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_CHANNELGROUPS, sizeof(ULONG)),
        Generic_Property_KSPROPERTY_SYNTH_CHANNELGROUPS_1, "{8A8CF3FC-CBFB-4ee5-A952-78B6D602AFD2}", SYNTH_CHANNELGROUPS)
    DEVICE_TEST_METHOD( "1500.2.2", "   Invalid Node ID - 0x80000001",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_CHANNELGROUPS, sizeof(ULONG)),
        Generic_Property_KSPROPERTY_SYNTH_CHANNELGROUPS_2, "{083CA500-B559-45ad-9B72-55C8B25A7A06}", SYNTH_CHANNELGROUPS)
    DEVICE_TEST_METHOD( "1500.2.3", "   Invalid Channel Group - 0xFFFFFFFE",	    0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_CHANNELGROUPS, sizeof(ULONG)),
        Generic_Property_KSPROPERTY_SYNTH_CHANNELGROUPS_3, "{C4CB835A-34FA-4f52-A986-CB7971337B4A}", SYNTH_CHANNELGROUPS)
    DEVICE_TEST_METHOD( "1500.2.4", "   NULL IN/OUT Buffer",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_CHANNELGROUPS, sizeof(ULONG)),
        Generic_Property_KSPROPERTY_SYNTH_CHANNELGROUPS_4, "{78F9B9A0-F08D-40f7-8997-FADA05A9909B}", SYNTH_CHANNELGROUPS)
    DEVICE_TEST_METHOD( "1500.2.5", "   Small IN/OUT Buffer",                     0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_CHANNELGROUPS, sizeof(ULONG)),
        Generic_Property_KSPROPERTY_SYNTH_CHANNELGROUPS_5, "{A3DE9406-B7D3-4206-8F82-E0B2F3B5A549}", SYNTH_CHANNELGROUPS)
    DEVICE_TEST_METHOD( "1500.2.6", "   Out buffer Large",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_CHANNELGROUPS, sizeof(ULONG)),
        Generic_Property_KSPROPERTY_SYNTH_CHANNELGROUPS_6, "{0AF61B87-27EF-40aa-A568-20217384FF60}", SYNTH_CHANNELGROUPS)
    DEVICE_TEST_METHOD( "1500.2.7", "   Invalid Channel Group - 0x80000001",	    0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_CHANNELGROUPS, sizeof(ULONG)),
        Generic_Property_KSPROPERTY_SYNTH_CHANNELGROUPS_7, "{F8EAC02A-5C19-47c1-86DF-E4CD90E40CE2}", SYNTH_CHANNELGROUPS)

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_SYNTH_LATENCYCLOCK",				    0, 0, 0, 0, NULL, "{D2897807-B649-46e2-B41B-243E5A59D44B}")
    DEVICE_TEST_METHOD( "1500.3.1", "   Invalid Node ID - ULONG_MAX",			    0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_LATENCYCLOCK, sizeof(ULONGLONG)),
        Generic_Property_KSPROPERTY_SYNTH_LATENCYCLOCK_1, "{98AEDC6A-5F7F-4097-AEE8-C7987EAA633B}", SYNTH_LATENCYCLOCK)
    DEVICE_TEST_METHOD( "1500.3.2", "   Invalid Node ID - 0x80000001",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_LATENCYCLOCK, sizeof(ULONGLONG)),
        Generic_Property_KSPROPERTY_SYNTH_LATENCYCLOCK_2, "{86763ECA-D250-4a26-B880-35BE9292C1D6}", SYNTH_LATENCYCLOCK)
    DEVICE_TEST_METHOD( "1500.3.5", "   Out Buffer NULL",						    0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_LATENCYCLOCK, sizeof(ULONGLONG)),
        Generic_Property_KSPROPERTY_SYNTH_LATENCYCLOCK_3, "{AA499CDF-1CFF-4667-AE8E-CADAD5DDF7FE}", SYNTH_LATENCYCLOCK)
    DEVICE_TEST_METHOD( "1500.3.6", "   Out Buffer Small",                        0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_LATENCYCLOCK, sizeof(ULONGLONG)),
        Generic_Property_KSPROPERTY_SYNTH_LATENCYCLOCK_4, "{D86046BA-841D-4b5f-8079-94AD335A2509}", SYNTH_LATENCYCLOCK)
    DEVICE_TEST_METHOD( "1500.3.7", "   Out buffer Large",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_LATENCYCLOCK, sizeof(ULONGLONG)),
        Generic_Property_KSPROPERTY_SYNTH_LATENCYCLOCK_5, "{90EDAD0B-FAB4-44e3-8781-546F0EB891BB}", SYNTH_LATENCYCLOCK)

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_SYNTH_MASTERCLOCK",				        0, 0, 0, 0, NULL, "{3B75C90B-726F-4fcf-A2E4-5BA5AF4D3A80}")
    DEVICE_TEST_METHOD( "1500.4.1", "   Out Buffer NULL",			                0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_SynthClock, KSPROPERTY_SYNTH_MASTERCLOCK, sizeof(ULONGLONG)),
        Generic_Property_KSPROPERTY_SYNTH_MASTERCLOCK_1, "{CC16DBB3-84F7-44e6-9561-B430177B19DD}", SYNTH_MASTERCLOCK)
    DEVICE_TEST_METHOD( "1500.4.2", "   Out Buffer Small",			            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_SynthClock, KSPROPERTY_SYNTH_MASTERCLOCK, sizeof(ULONGLONG)),
        Generic_Property_KSPROPERTY_SYNTH_MASTERCLOCK_2, "{AA043967-6E4E-47e6-9810-1C9EA5642DF5}", SYNTH_MASTERCLOCK)
    DEVICE_TEST_METHOD( "1500.4.3", "   Out buffer Large",			            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_SynthClock, KSPROPERTY_SYNTH_MASTERCLOCK, sizeof(ULONGLONG)),
        Generic_Property_KSPROPERTY_SYNTH_MASTERCLOCK_3, "{75C1EAEC-8C95-4e37-AE84-DDD11E666280}", SYNTH_MASTERCLOCK)

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_SYNTH_PORTPARAMETERS",				    0, 0, 0, 0, NULL, "{4D4A61EA-E7F4-4a77-B1BD-52690D6D2489}")
    DEVICE_TEST_METHOD( "1500.5.1", "   Invalid Node ID - ULONG_MAX",			    0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_PORTPARAMETERS, sizeof(SYNTH_PORTPARAMS)),
        Generic_Property_KSPROPERTY_SYNTH_PORTPARAMETERS_1, "{E1851FC2-E106-48be-ABCE-8087001C2238}", SYNTH_PORTPARAMETERS)
    DEVICE_TEST_METHOD( "1500.5.2", "   Invalid Node ID - 0x80000001",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_PORTPARAMETERS, sizeof(SYNTH_PORTPARAMS)),
        Generic_Property_KSPROPERTY_SYNTH_PORTPARAMETERS_2, "{B2D38440-94F4-488c-83CB-8431E44D2326}", SYNTH_PORTPARAMETERS)
    DEVICE_TEST_METHOD( "1500.5.3", "   Out Buffer NULL",						    0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_PORTPARAMETERS, sizeof(SYNTH_PORTPARAMS)),
        Generic_Property_KSPROPERTY_SYNTH_PORTPARAMETERS_3, "{CB05906D-FABB-4bce-BE54-917D4F8BD76D}", SYNTH_PORTPARAMETERS)
    DEVICE_TEST_METHOD( "1500.5.4", "   Out Buffer Small",                        0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_PORTPARAMETERS, sizeof(SYNTH_PORTPARAMS)),
        Generic_Property_KSPROPERTY_SYNTH_PORTPARAMETERS_4, "{1EE33611-3716-46ee-A0B7-943AB6A6DD0B}", SYNTH_PORTPARAMETERS)
    DEVICE_TEST_METHOD( "1500.5.5", "   Out buffer Large",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_PORTPARAMETERS, sizeof(SYNTH_PORTPARAMS)),
        Generic_Property_KSPROPERTY_SYNTH_PORTPARAMETERS_5, "{4422F021-8C1C-4e94-A1C2-8BB24D5584C7}", SYNTH_PORTPARAMETERS)
    DEVICE_TEST_METHOD( "1500.5.6", "   Invalid Channel Groups - ULONG_MAX",	    0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_PORTPARAMETERS, sizeof(SYNTH_PORTPARAMS)),
        Generic_Property_KSPROPERTY_SYNTH_PORTPARAMETERS_6, "{E8124388-1BEB-4011-AAA7-8D60D3786907}", SYNTH_PORTPARAMETERS)
    DEVICE_TEST_METHOD( "1500.5.7", "   Invalid Channel Groups - 0x80000001",     0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_PORTPARAMETERS, sizeof(SYNTH_PORTPARAMS)),
        Generic_Property_KSPROPERTY_SYNTH_PORTPARAMETERS_7, "{E330CFB8-E772-417c-8182-6E86D496FBE2}", SYNTH_PORTPARAMETERS)
    DEVICE_TEST_METHOD( "1500.5.8", "   Invalid Channel ID - ULONG_MAX",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_PORTPARAMETERS, sizeof(SYNTH_PORTPARAMS)),
        Generic_Property_KSPROPERTY_SYNTH_PORTPARAMETERS_8, "{1F39F260-5E83-4c08-94FE-3A0808BED0F1}", SYNTH_PORTPARAMETERS)
    DEVICE_TEST_METHOD( "1500.5.9", "   Invalid Channel ID - 0x80000001",         0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_PORTPARAMETERS, sizeof(SYNTH_PORTPARAMS)),
        Generic_Property_KSPROPERTY_SYNTH_PORTPARAMETERS_9, "{0AAEB6FB-0ECE-4693-85C0-45B7F3769B3F}", SYNTH_PORTPARAMETERS)
    DEVICE_TEST_METHOD( "1500.5.10", "   Invalid Sample Rate - ULONG_MAX",		0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_PORTPARAMETERS, sizeof(SYNTH_PORTPARAMS)),
        Generic_Property_KSPROPERTY_SYNTH_PORTPARAMETERS_10, "{EE868701-34FD-4b37-BFAD-551E6D29341E}", SYNTH_PORTPARAMETERS)
    DEVICE_TEST_METHOD( "1500.5.11", "   Invalid Sample Rate - 0x80000001",       0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_PORTPARAMETERS, sizeof(SYNTH_PORTPARAMS)),
        Generic_Property_KSPROPERTY_SYNTH_PORTPARAMETERS_11, "{D4A98CF2-C305-4d30-95FB-9CE8376CFF47}", SYNTH_PORTPARAMETERS)
    DEVICE_TEST_METHOD( "1500.5.12", "   Invalid Effects Flags - 0xFFFFFFFF",	    0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_PORTPARAMETERS, sizeof(SYNTH_PORTPARAMS)),
        Generic_Property_KSPROPERTY_SYNTH_PORTPARAMETERS_12, "{C4052422-8C04-493d-92D7-D1FCB24FB192}", SYNTH_PORTPARAMETERS)

    DEVICE_TEST_METHOD( "1500.5.13", "   Invalid Voices - ULONG_MAX",             0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_PORTPARAMETERS, sizeof(SYNTH_PORTPARAMS)),
        Generic_Property_KSPROPERTY_SYNTH_PORTPARAMETERS_13, "{A71474DA-D423-4794-B4B3-38716FAAE20B}", SYNTH_PORTPARAMETERS)
    DEVICE_TEST_METHOD( "1500.5.14", "   Invalid Voices - 0x80000001",	        0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_PORTPARAMETERS, sizeof(SYNTH_PORTPARAMS)),
        Generic_Property_KSPROPERTY_SYNTH_PORTPARAMETERS_14, "{A1D5E9D3-0699-45a8-8DEF-2172E8B08323}", SYNTH_PORTPARAMETERS)


    DEVICE_TEST_PARENT( "", "  KSPROPERTY_SYNTH_RUNNINGSTATS",				    0, 0, 0, 0, NULL, "{55F76CF6-BB11-4024-86E5-E2332CC70218}")
    DEVICE_TEST_METHOD( "1500.6.1", "   Invalid Node ID - ULONG_MAX",		        0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_RUNNINGSTATS, sizeof(SYNTH_STATS)),
        Generic_Property_KSPROPERTY_SYNTH_RUNNINGSTATS_1, "{1AA5B4A7-4AF1-459e-998D-DB25F1F8B6FD}", SYNTH_RUNNINGSTATS)
    DEVICE_TEST_METHOD( "1500.6.2", "   Invalid Node ID - 0x80000001",		    0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_RUNNINGSTATS, sizeof(SYNTH_STATS)),
        Generic_Property_KSPROPERTY_SYNTH_RUNNINGSTATS_2, "{02FF5B16-FF8A-4588-83B8-EBF70B374186}", SYNTH_RUNNINGSTATS)
    DEVICE_TEST_METHOD( "1500.6.3", "   Out Buffer NULL",						    0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_RUNNINGSTATS, sizeof(SYNTH_STATS)),
        Generic_Property_KSPROPERTY_SYNTH_RUNNINGSTATS_3, "{B6BB4F41-A88F-49f2-B995-741A03190743}", SYNTH_RUNNINGSTATS)
    DEVICE_TEST_METHOD( "1500.6.4", "   Out Buffer Small",            		    0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_RUNNINGSTATS, sizeof(SYNTH_STATS)),
        Generic_Property_KSPROPERTY_SYNTH_RUNNINGSTATS_4, "{A007DCFF-37E1-4666-B4B1-CB541792A1FB}", SYNTH_RUNNINGSTATS)
    DEVICE_TEST_METHOD( "1500.6.5", "   Out buffer Large",					    0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_RUNNINGSTATS, sizeof(SYNTH_STATS)),
        Generic_Property_KSPROPERTY_SYNTH_RUNNINGSTATS_5, "{34A79F62-914E-4867-9983-F0B6B02F7B58}", SYNTH_RUNNINGSTATS)

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_SYNTH_VOICEPRIORITY",				    0, 0, 0, 0, NULL, "{E2355A53-2091-49f9-A4C7-880D2558F20B}")
    DEVICE_TEST_METHOD( "1500.7.1", "   Invalid Node ID - ULONG_MAX",			    0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_VOICEPRIORITY, sizeof(DWORD)),
        Generic_Property_KSPROPERTY_SYNTH_VOICEPRIORITY_1, "{C495B1D5-194F-4c46-8FF6-7D28E7A515E0}", SYNTH_VOICEPRIORITY)
    DEVICE_TEST_METHOD( "1500.7.2", "   Invalid Node ID - 0x80000001",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_VOICEPRIORITY, sizeof(DWORD)),
        Generic_Property_KSPROPERTY_SYNTH_VOICEPRIORITY_2, "{EBE505F5-6122-4c6e-9A53-E84D276F1366}", SYNTH_VOICEPRIORITY)
    DEVICE_TEST_METHOD( "1500.7.3", "   Invalid Channel ID - 0xFFFFFFFE",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_VOICEPRIORITY, sizeof(DWORD)),
        Generic_Property_KSPROPERTY_SYNTH_VOICEPRIORITY_3, "{0361BE8F-EB07-4d4c-A21C-C35D7FB4DB1D}", SYNTH_VOICEPRIORITY)
    DEVICE_TEST_METHOD( "1500.7.4", "   Invalid Channel ID - 0x80000001",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_VOICEPRIORITY, sizeof(DWORD)),
        Generic_Property_KSPROPERTY_SYNTH_VOICEPRIORITY_4, "{AB44F711-DD42-4894-BC4F-C627700942F6}", SYNTH_VOICEPRIORITY)
    DEVICE_TEST_METHOD( "1500.7.5", "   NULL IN/OUT Buffer",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_VOICEPRIORITY, sizeof(DWORD)),
        Generic_Property_KSPROPERTY_SYNTH_VOICEPRIORITY_5, "{3CD3846B-583F-4b1d-8E63-A76655E1B473}", SYNTH_VOICEPRIORITY)
    DEVICE_TEST_METHOD( "1500.7.6", "   Small IN/OUT Buffer",                     0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_VOICEPRIORITY, sizeof(DWORD)),
        Generic_Property_KSPROPERTY_SYNTH_VOICEPRIORITY_6, "{185A5888-3206-4e22-A8C9-DC7AF099DB88}", SYNTH_VOICEPRIORITY)
    DEVICE_TEST_METHOD( "1500.7.7", "   Out buffer Large",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_VOICEPRIORITY, sizeof(DWORD)),
        Generic_Property_KSPROPERTY_SYNTH_VOICEPRIORITY_7, "{DDDE7C84-B337-4b42-A033-0C61A61D2BE9}", SYNTH_VOICEPRIORITY)
    DEVICE_TEST_METHOD( "1500.7.8", "   Invalid Voice Priority - 0x FFFFFFFF",	0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_VOICEPRIORITY, sizeof(DWORD)),
        Generic_Property_KSPROPERTY_SYNTH_VOICEPRIORITY_8, "{CA6885BB-26B8-4509-BE7E-FF674C683E39}", SYNTH_VOICEPRIORITY)
    DEVICE_TEST_METHOD( "1500.7.9", "   Invalid Channel Group - 0xFFFFFFFE",      0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_VOICEPRIORITY, sizeof(DWORD)),
        Generic_Property_KSPROPERTY_SYNTH_VOICEPRIORITY_9, "{8FC9098B-4B9F-4547-80DF-FDD96DE1E334}", SYNTH_VOICEPRIORITY)
    DEVICE_TEST_METHOD( "1500.7.10", "   Invalid Channel Group - 0x80000001",		0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_VOICEPRIORITY, sizeof(DWORD)),
        Generic_Property_KSPROPERTY_SYNTH_VOICEPRIORITY_10, "{367DC697-2785-4bd4-93F6-0F5E5349410B}", SYNTH_VOICEPRIORITY)

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_SYNTH_VOLUME",				            0, 0, 0, 0, NULL, "{1B6F9D79-9FCF-43e6-B583-C32E00FF6308}")
    DEVICE_TEST_METHOD( "1500.8.1", "   NULL IN/OUT Buffer",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_VOLUME, sizeof(LONG)),
        Generic_Property_KSPROPERTY_SYNTH_VOLUME_1, "{685AD07F-12F8-4ecc-90B5-CB76C382D7B9}", SYNTH_VOLUME)
    DEVICE_TEST_METHOD( "1500.8.2", "   Small IN/OUT Buffer",                     0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_VOLUME, sizeof(LONG)),
        Generic_Property_KSPROPERTY_SYNTH_VOLUME_2, "{8FCDE819-CDA6-4091-BA01-5802D99E0CBD}", SYNTH_VOLUME)
    DEVICE_TEST_METHOD( "1500.8.3", "   Out buffer Large",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_VOLUME, sizeof(LONG)),
        Generic_Property_KSPROPERTY_SYNTH_VOLUME_3, "{440CACFE-7274-48a0-B0F8-10FEB02B8F5C}", SYNTH_VOLUME)

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_SYNTH_VOLUMEBOOST",               0, 0, 0, 0, NULL, "{75734A5D-48E0-468d-ADA2-46B3F9F5B3C7}")
    DEVICE_TEST_METHOD( "1500.9.1", "   Invalid Node ID - ULONG_MAX",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_VOLUMEBOOST, sizeof(LONG)),
        Generic_Property_KSNODEPROPERTYULONG_NodeID_ULONGMAX, "{9B68E313-BA50-477a-A02F-2C35778DCEF7}", SYNTH_VOLUMEBOOST)
    DEVICE_TEST_METHOD( "1500.9.2", "   Invalid Node ID - 0x80000001",  			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_VOLUMEBOOST, sizeof(LONG)),
        Generic_Property_KSNODEPROPERTYULONG_NodeID_0x80000001, "{470FC021-C6DB-4599-9E12-8C03CAF9D875}", SYNTH_VOLUMEBOOST)
    DEVICE_TEST_METHOD( "1500.9.3", "   NULL IN/OUT Buffer",  					0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_VOLUMEBOOST, sizeof(LONG)),
        Generic_Property_KSNODEPROPERTYULONG_NULL_Buffer, "{90BCE734-16F0-41cd-AED6-1E58ACFF39EE}", SYNTH_VOLUMEBOOST)
    DEVICE_TEST_METHOD( "1500.9.4", "   Small IN/OUT Buffer",  					0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_VOLUMEBOOST, sizeof(LONG)),
        Generic_Property_KSNODEPROPERTYULONG_Small_Buffer, "{02F3996B-4A28-4a65-B8FB-28BF4DD942FC}", SYNTH_VOLUMEBOOST)
    DEVICE_TEST_METHOD( "1500.9.5", "   Out buffer Large",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth, KSPROPERTY_SYNTH_VOLUMEBOOST, sizeof(LONG)),
        Generic_Property_KSNODEPROPERTYULONG_Large_Buffer, "{45E4128C-1EC0-4221-9E29-7D454B365D3A}", SYNTH_VOLUMEBOOST)

    //KSPROPSETID_Synth_Dls	
    DEVICE_TEST_PARENT( "",   " KSPROPSETID_Synth_Dls",						0, 0, 0, 0, NULL, "{73273F57-2A15-4a41-940A-414E2161CA7C}")

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_SYNTH_DLS_APPEND",               0, 0, 0, 0, NULL, "{E4590023-8D9A-49d4-8E87-1A7E9935A38A}")
    DEVICE_TEST_METHOD( "1600.1.1", "   Invalid Node ID - ULONG_MAX",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth_Dls, KSPROPERTY_SYNTH_DLS_APPEND, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTYULONG_NodeID_ULONGMAX, "{67C5F035-E48D-471a-900A-1D8D755E288F}", SYNTH_DLS_APPEND)
    DEVICE_TEST_METHOD( "1600.1.2", "   Invalid Node ID - 0x80000001",  			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth_Dls, KSPROPERTY_SYNTH_DLS_APPEND, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTYULONG_NodeID_0x80000001, "{24F7057F-0DDD-4a9e-B3AC-2D930D97E646}", SYNTH_DLS_APPEND)
    DEVICE_TEST_METHOD( "1600.1.3", "   NULL IN/OUT Buffer",  					0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth_Dls, KSPROPERTY_SYNTH_DLS_APPEND, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTYULONG_NULL_Buffer, "{ABE0B45B-D8EE-4a19-845A-53625A2A79E0}", SYNTH_DLS_APPEND)
    DEVICE_TEST_METHOD( "1600.1.4", "   Small IN/OUT Buffer",  					0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth_Dls, KSPROPERTY_SYNTH_DLS_APPEND, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTYULONG_Small_Buffer, "{36EEF65D-24BA-44d8-9755-EA802056D39F}", SYNTH_DLS_APPEND)
    DEVICE_TEST_METHOD( "1600.1.5", "   Out buffer Large",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth_Dls, KSPROPERTY_SYNTH_DLS_APPEND, sizeof(ULONG)),
        Generic_Property_KSNODEPROPERTYULONG_Large_Buffer, "{DB285B91-E85D-4a23-B8AA-837BD6FB7817}", SYNTH_DLS_APPEND)

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_SYNTH_DLS_COMPACT",                     0, 0, 0, 0, NULL, "{9DB47638-E980-4046-99F6-1954C62E2AC1}")
    DEVICE_TEST_METHOD( "1600.2.1", "   Invalid Node ID - ULONG_MAX",             0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth_Dls, KSPROPERTY_SYNTH_DLS_COMPACT, 0),
        Generic_Property_KSPROPERTY_SYNTH_DLS_COMPACT_1, "{E10A330C-3E57-419d-9669-8D7405A2D84D}", SYNTH_DLS_COMPACT)
    DEVICE_TEST_METHOD( "1600.2.2", "   Invalid Node ID - 0x80000001",            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth_Dls, KSPROPERTY_SYNTH_DLS_COMPACT, 0),
        Generic_Property_KSPROPERTY_SYNTH_DLS_COMPACT_2, "{973DA47D-2038-42fe-BD28-273B016B0C56}", SYNTH_DLS_COMPACT)

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_SYNTH_DLS_DOWNLOAD",                    0, 0, 0, 0, NULL, "{4E4CAB16-CCBB-44f9-AE12-F16388CDC81B}")
    DEVICE_TEST_METHOD( "1600.3.1", "   Invalid Node ID - ULONG_MAX",             0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth_Dls, KSPROPERTY_SYNTH_DLS_DOWNLOAD, sizeof(SYNTHDOWNLOAD)),
        Generic_Property_KSPROPERTY_SYNTH_DLS_DOWNLOAD_1, "{C430A68D-72DD-4d6a-8CF9-2BDD6AD888B7}", SYNTH_DLS_DOWNLOAD)
    DEVICE_TEST_METHOD( "1600.3.2", "   Invalid Node ID - 0x80000001",            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth_Dls, KSPROPERTY_SYNTH_DLS_DOWNLOAD, sizeof(SYNTHDOWNLOAD)),
        Generic_Property_KSPROPERTY_SYNTH_DLS_DOWNLOAD_2, "{62BC70A0-6795-4e12-8211-E2350EC715C9}", SYNTH_DLS_DOWNLOAD)
    DEVICE_TEST_METHOD( "1600.3.3", "   Out buffer NULL",                         0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth_Dls, KSPROPERTY_SYNTH_DLS_DOWNLOAD, sizeof(SYNTHDOWNLOAD)),
        Generic_Property_KSPROPERTY_SYNTH_DLS_DOWNLOAD_3, "{705F31F7-4CBD-44e8-BED8-0DA8DBF1F880}", SYNTH_DLS_DOWNLOAD)
    DEVICE_TEST_METHOD( "1600.3.4", "   Out buffer Small",                        0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth_Dls, KSPROPERTY_SYNTH_DLS_DOWNLOAD, sizeof(SYNTHDOWNLOAD)),
        Generic_Property_KSPROPERTY_SYNTH_DLS_DOWNLOAD_4, "{EC17BED0-BD83-4653-8730-4A11F8C31B4E}", SYNTH_DLS_DOWNLOAD)
    DEVICE_TEST_METHOD( "1600.3.5", "   Out buffer Large",                        0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth_Dls, KSPROPERTY_SYNTH_DLS_DOWNLOAD, sizeof(SYNTHDOWNLOAD)),
        Generic_Property_KSPROPERTY_SYNTH_DLS_DOWNLOAD_5, "{742F34BB-887B-4d60-8AE1-E2285B272795}", SYNTH_DLS_DOWNLOAD)
    DEVICE_TEST_METHOD( "1600.3.6", "   Synth buffer NULL",                       0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth_Dls, KSPROPERTY_SYNTH_DLS_DOWNLOAD, sizeof(SYNTHDOWNLOAD)),
        Generic_Property_KSPROPERTY_SYNTH_DLS_DOWNLOAD_6, "{44899498-80B1-486a-B123-FC60F24E13BC}", SYNTH_DLS_DOWNLOAD)
    DEVICE_TEST_METHOD( "1600.3.7", "   Synth buffer Small",                      0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth_Dls, KSPROPERTY_SYNTH_DLS_DOWNLOAD, sizeof(SYNTHDOWNLOAD)),
        Generic_Property_KSPROPERTY_SYNTH_DLS_DOWNLOAD_7, "{7C57A8A4-A719-4256-A77A-F9879221436B}", SYNTH_DLS_DOWNLOAD)


    DEVICE_TEST_PARENT( "", "  KSPROPERTY_SYNTH_DLS_UNLOAD",                      0, 0, 0, 0, NULL, "{3A942039-021A-4158-942D-9ADF89039321}")
    DEVICE_TEST_METHOD( "1600.4.1", "   Invalid Node ID - ULONG_MAX",             0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth_Dls, KSPROPERTY_SYNTH_DLS_UNLOAD, sizeof(HANDLE)),
        Generic_Property_KSPROPERTY_SYNTH_DLS_UNLOAD_1, "{1698BED1-C6CC-403b-944B-706DE0C385D1}", SYNTH_DLS_UNLOAD)
    DEVICE_TEST_METHOD( "1600.4.2", "   Invalid Node ID - 0x80000001",            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth_Dls, KSPROPERTY_SYNTH_DLS_UNLOAD, sizeof(HANDLE)),
        Generic_Property_KSPROPERTY_SYNTH_DLS_UNLOAD_2, "{61487FE7-486E-4f6c-A9C1-A82C734D4925}", SYNTH_DLS_UNLOAD)
    DEVICE_TEST_METHOD( "1600.4.3", "   Invalid Handle - NULL",                   0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth_Dls, KSPROPERTY_SYNTH_DLS_UNLOAD, sizeof(HANDLE)),
        Generic_Property_KSPROPERTY_SYNTH_DLS_UNLOAD_3, "{60D94B61-08FD-4fb5-8F46-876C3DDC542F}", SYNTH_DLS_UNLOAD)
    //  { "1600.4.4", "   Invalid Handle - ULONG_MAX",          0, 0, 0,
    //    GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth_Dls, KSPROPERTY_SYNTH_DLS_UNLOAD, sizeof(HANDLE)),
    //    Generic_Property_KSPROPERTY_SYNTH_DLS_UNLOAD_4, "{FDD96331-431A-42b5-8E2C-9D39B54E6D28}", SYNTH_DLS_UNLOAD)

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_SYNTH_DLS_WAVEFORMAT",                  0, 0, 0, 0, NULL, "{0CB3E16C-2105-41e3-B018-C7C81A5D8F2F}")
    DEVICE_TEST_METHOD( "1600.5.1", "   Invalid Node ID - ULONG_MAX",             0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth_Dls, KSPROPERTY_SYNTH_DLS_WAVEFORMAT, sizeof(WAVEFORMATEX)),
        Generic_Property_KSPROPERTY_SYNTH_DLS_WAVEFORMAT_1, "{50E6CCEA-1C0B-4fb3-8467-EA5B2050A593}", SYNTH_DLS_WAVEFORMAT)
    DEVICE_TEST_METHOD( "1600.5.2", "   Invalid Node ID - 0x80000001",            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth_Dls, KSPROPERTY_SYNTH_DLS_WAVEFORMAT, sizeof(WAVEFORMATEX)),
        Generic_Property_KSPROPERTY_SYNTH_DLS_WAVEFORMAT_2, "{948CC394-94D4-4c68-819F-344B9AD2EC30}", SYNTH_DLS_WAVEFORMAT)
    //  { "1600.5.3", "   Invalid Channel ID - 0xFFFFFFFE",         0, 0, 0,
    //    GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth_Dls, KSPROPERTY_SYNTH_DLS_WAVEFORMAT, sizeof(WAVEFORMATEX)),
    //    Generic_Property_KSPROPERTY_SYNTH_DLS_WAVEFORMAT_3, "{89D521EF-E682-47f9-804F-C3CF36EC2691}", SYNTH_DLS_WAVEFORMAT)
    //  { "1600.5.4", "   Invalid Channel ID - 0x80000001",         0, 0, 0,
    //    GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth_Dls, KSPROPERTY_SYNTH_DLS_WAVEFORMAT, sizeof(WAVEFORMATEX)),
    //    Generic_Property_KSPROPERTY_SYNTH_DLS_WAVEFORMAT_4, "{0E9323B9-F857-4b9e-B586-FE73FF7DB102}", SYNTH_DLS_WAVEFORMAT)
    DEVICE_TEST_METHOD( "1600.5.3", "   Out buffer NULL",                         0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth_Dls, KSPROPERTY_SYNTH_DLS_WAVEFORMAT, sizeof(WAVEFORMATEX)),
        Generic_Property_KSPROPERTY_SYNTH_DLS_WAVEFORMAT_3, "{FE36985D-1E10-4fbe-830D-33F3CB77613B}", SYNTH_DLS_WAVEFORMAT)
    DEVICE_TEST_METHOD( "1600.5.4", "   Out buffer Small",                        0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth_Dls, KSPROPERTY_SYNTH_DLS_WAVEFORMAT, sizeof(WAVEFORMATEX)),
        Generic_Property_KSPROPERTY_SYNTH_DLS_WAVEFORMAT_4, "{FE9AC560-2586-4e54-9981-1956C5119C9C}", SYNTH_DLS_WAVEFORMAT)
    DEVICE_TEST_METHOD( "1600.5.5", "   Out buffer Large",                        0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Synth_Dls, KSPROPERTY_SYNTH_DLS_WAVEFORMAT, sizeof(WAVEFORMATEX)),
        Generic_Property_KSPROPERTY_SYNTH_DLS_WAVEFORMAT_5, "{C2F5BB0E-74C3-48f2-9BE9-CA7C8A178E69}", SYNTH_DLS_WAVEFORMAT)

    //KSPROPSETID_DrmAudioStream
    DEVICE_TEST_PARENT( "",   " KSPROPSETID_DrmAudioStream",                      0, 0, 0, 0, NULL, "{6A322910-3B36-4035-89CA-1B859504B28C}")

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_DRMAUDIOSTREAM_CONTENTID",              0, 0, 0, 0, NULL, "{BEF8BF21-3AE5-4533-8323-85344BE2FF64}")
    DEVICE_TEST_METHOD( "1700.1.1", "   Invalid Content ID - ULONG_MAX",          0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DrmAudioStream, KSPROPERTY_DRMAUDIOSTREAM_CONTENTID, sizeof(KSDRMAUDIOSTREAM_CONTENTID)),
        Generic_Property_KSPROPERTY_DRMAUDIOSTREAM_CONTENTID_1, "{7866F451-8AEA-4334-9291-8028DAE61E23}", DRMAUDIOSTREAM_CONTENTID)
    DEVICE_TEST_METHOD( "1700.1.2", "   Invalid Content ID - 0x80000001",         0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DrmAudioStream, KSPROPERTY_DRMAUDIOSTREAM_CONTENTID, sizeof(KSDRMAUDIOSTREAM_CONTENTID)),
        Generic_Property_KSPROPERTY_DRMAUDIOSTREAM_CONTENTID_2, "{C71B8A2A-D974-48f8-9A23-1424AF5E8D7F}", DRMAUDIOSTREAM_CONTENTID)
    DEVICE_TEST_METHOD( "1700.1.3", "   NULL IN/OUT Buffer",                      0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DrmAudioStream, KSPROPERTY_DRMAUDIOSTREAM_CONTENTID, sizeof(KSDRMAUDIOSTREAM_CONTENTID)),
        Generic_Property_KSPROPERTY_DRMAUDIOSTREAM_CONTENTID_3, "{8FB45D07-5587-4cca-9193-7717B19942A8}", DRMAUDIOSTREAM_CONTENTID)
    DEVICE_TEST_METHOD( "1700.1.4", "   Small IN/OUT Buffer",                     0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DrmAudioStream, KSPROPERTY_DRMAUDIOSTREAM_CONTENTID, sizeof(KSDRMAUDIOSTREAM_CONTENTID)),
        Generic_Property_KSPROPERTY_DRMAUDIOSTREAM_CONTENTID_4, "{D9DC83A7-871A-4f60-81ED-EA43C6CA591F}", DRMAUDIOSTREAM_CONTENTID)
    DEVICE_TEST_METHOD( "1700.1.5", "   Out buffer Large",                        0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DrmAudioStream, KSPROPERTY_DRMAUDIOSTREAM_CONTENTID, sizeof(KSDRMAUDIOSTREAM_CONTENTID)),
        Generic_Property_KSPROPERTY_DRMAUDIOSTREAM_CONTENTID_5, "{19E35B6A-C214-4a91-BB2D-D68ABB730A16}", DRMAUDIOSTREAM_CONTENTID)
    DEVICE_TEST_METHOD( "1700.1.6", "   Context buffer NULL",                     0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DrmAudioStream, KSPROPERTY_DRMAUDIOSTREAM_CONTENTID, sizeof(KSDRMAUDIOSTREAM_CONTENTID)),
        Generic_Property_KSPROPERTY_DRMAUDIOSTREAM_CONTENTID_6, "{5A517285-F279-46cc-9710-1DD3A871F348}", DRMAUDIOSTREAM_CONTENTID)
    DEVICE_TEST_METHOD( "1700.1.7", "   Context buffer small",                    0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_DrmAudioStream, KSPROPERTY_DRMAUDIOSTREAM_CONTENTID, sizeof(KSDRMAUDIOSTREAM_CONTENTID)),
        Generic_Property_KSPROPERTY_DRMAUDIOSTREAM_CONTENTID_7, "{FF0F6864-B340-4de3-BAEA-247C6B9E1009}", DRMAUDIOSTREAM_CONTENTID)

// AudioGfx ended in XP
#if (NTDDI_VERSION < NTDDI_VISTA)
    //KSPROPSETID_AudioGfx
    DEVICE_TEST_PARENT( "",   " KSPROPSETID_AudioGfx",                            0, 0, 0, 0, NULL, "{28429094-85B6-4bfc-A865-BC30C53B3AE6}")

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_AUDIOGFX_CAPTURETARGETDEVICEID",        0, 0, 0, 0, NULL, "{04E71DEB-BB7B-4f78-9827-05F08F6B5235}")
    DEVICE_TEST_METHOD( "1800.1.1", "   NULL String",                             0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioGfx,  KSPROPERTY_AUDIOGFX_CAPTURETARGETDEVICEID, sizeof(WCHAR[256])),
        Generic_Property_KSPROPERTY_AUDIOGFX_CAPTURETARGETDEVICEID_1, "{021355CA-0B30-4bd9-91F3-C1B0C2B2DB0A}")
    DEVICE_TEST_METHOD( "1800.1.2", "   One char string",                         0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioGfx,  KSPROPERTY_AUDIOGFX_CAPTURETARGETDEVICEID, sizeof(WCHAR[256])),
        Generic_Property_KSPROPERTY_AUDIOGFX_CAPTURETARGETDEVICEID_2, "{111D28B9-3A5A-4d0c-A1C4-7553D9378F4E}")
    //  { "1800.1.3", "   NULL IN/OUT Buffer",                      0, 0, 0,
    //    GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioGfx,  KSPROPERTY_AUDIOGFX_CAPTURETARGETDEVICEID, sizeof(WCHAR[256])),
    //    Generic_Property_KSPROPERTY_AUDIOGFX_CAPTURETARGETDEVICEID_3, "{41DA1F09-20A0-4b63-AD0C-2CF26C9A6FCB}")

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_AUDIOGFX_RENDERTARGETDEVICEID",         0, 0, 0, 0, NULL, "{BCB09CBA-6AB9-4e49-A855-972EE90E138B}")
    DEVICE_TEST_METHOD( "1800.2.1", "   NULL String",                             0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioGfx,  KSPROPERTY_AUDIOGFX_RENDERTARGETDEVICEID, sizeof(WCHAR[256])),
        Generic_Property_KSPROPERTY_AUDIOGFX_RENDERTARGETDEVICEID_1, "{6D2C8BED-9D5B-449a-8711-AAD384780360}")
    DEVICE_TEST_METHOD( "1800.2.2", "   One char string",                         0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioGfx,  KSPROPERTY_AUDIOGFX_RENDERTARGETDEVICEID, sizeof(WCHAR[256])),
        Generic_Property_KSPROPERTY_AUDIOGFX_RENDERTARGETDEVICEID_2, "{817BADCA-728A-4f47-8B5F-6705849BC260}")
    //  { "1800.2.3", "   NULL IN/OUT Buffer",                      0, 0, 0,
    //    GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_AudioGfx,  KSPROPERTY_AUDIOGFX_RENDERTARGETDEVICEID, sizeof(WCHAR[256])),
    //    Generic_Property_KSNODEPROPERTYULONG_NULL_Buffer, "{B3EFAC1E-A3B5-4918-98AB-9328A4E2B761}")
#endif // NTDDI_VERSION < NTDDI_VISTA

    // KSPROPSETID_Topology
    DEVICE_TEST_PARENT( "",   " KSPROPSETID_Topology",						0, 0, 0, 0, NULL, "{6a9d5807-d3b8-451f-95d7-b893f0c2439f}")

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_TOPOLOGY_NAME",						0, 0, 0, 0, NULL, "{98cabf6f-8b0f-432b-82a4-ccb8ab3590ac}")
    DEVICE_TEST_METHOD( "500.1.1", "   Null string",							0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Topology, KSPROPERTY_TOPOLOGY_NAME, 0),
        Generic_Property_KSPROPERTY_TOPOLOGY_NAME_1, "{a4b20fd6-cbac-4b05-9ffc-5b9a4b734f08}", TOPOLOGY_NAME)
    DEVICE_TEST_METHOD( "500.1.2", "   One char string",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Topology, KSPROPERTY_TOPOLOGY_NAME, 0),
        Generic_Property_KSPROPERTY_TOPOLOGY_NAME_2, "{9b84993c-7689-46d5-a206-110ec57a790e}", TOPOLOGY_NAME)

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_TOPOLOGY_CATEGORIES",               0, 0, 0, 0, NULL, "{DFF8728F-DAF9-42c3-AEC6-9502C5C0B497}")
    DEVICE_TEST_METHOD( "500.2.1", "   Out buffer NULL",			            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Topology, KSPROPERTY_TOPOLOGY_CATEGORIES, sizeof(KSMULTIPLE_ITEM)),
        Generic_Property_KSPROPERTY_TOPOLOGY_CATEGORIES_1, "{2E4A2CC5-1272-411c-899D-34DB5C186D44}", TOPOLOGY_CATEGORIES)
    DEVICE_TEST_METHOD( "500.2.2", "   Out buffer Small",  		            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Topology, KSPROPERTY_TOPOLOGY_CATEGORIES, sizeof(KSMULTIPLE_ITEM)),
        Generic_Property_KSPROPERTY_TOPOLOGY_CATEGORIES_2, "{0D16484A-047C-4fea-B152-CC6B0A940A4D}", TOPOLOGY_CATEGORIES)
    DEVICE_TEST_METHOD( "500.2.3", "   Out buffer Large",  					0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Topology, KSPROPERTY_TOPOLOGY_CATEGORIES, sizeof(KSMULTIPLE_ITEM)),
        Generic_Property_KSPROPERTY_TOPOLOGY_CATEGORIES_3, "{AF823BA2-76A7-4667-9B48-42E1113049E1}", TOPOLOGY_CATEGORIES)

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_TOPOLOGY_CONNECTIONS",              0, 0, 0, 0, NULL, "{C8A54671-53CB-4c29-B098-6FE4F621F483}")
    DEVICE_TEST_METHOD( "500.3.1", "   Out buffer NULL",			            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Topology, KSPROPERTY_TOPOLOGY_CONNECTIONS, sizeof(KSMULTIPLE_ITEM)),
        Generic_Property_KSPROPERTY_TOPOLOGY_CONNECTIONS_1, "{651AC863-4319-4e7b-A763-B3077F381248}", TOPOLOGY_CONNECTIONS)
    DEVICE_TEST_METHOD( "500.3.2", "   Out buffer Small",  		            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Topology, KSPROPERTY_TOPOLOGY_CONNECTIONS, sizeof(KSMULTIPLE_ITEM)),
        Generic_Property_KSPROPERTY_TOPOLOGY_CONNECTIONS_2, "{4B058F34-0B21-46ed-B561-D32A28635006}", TOPOLOGY_CONNECTIONS)
    DEVICE_TEST_METHOD( "500.3.3", "   Out buffer Large",  					0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Topology, KSPROPERTY_TOPOLOGY_CONNECTIONS, sizeof(KSMULTIPLE_ITEM)),
        Generic_Property_KSPROPERTY_TOPOLOGY_CONNECTIONS_3, "{35CB6807-2CA9-42e0-B30E-4FD76A0D0833}", TOPOLOGY_CONNECTIONS)

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_TOPOLOGY_NODES",                    0, 0, 0, 0, NULL, "{E0C986AB-2554-4a42-AC67-72A798511420}")
    DEVICE_TEST_METHOD( "500.4.1", "   Out buffer NULL",			            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Topology, KSPROPERTY_TOPOLOGY_NODES, sizeof(KSMULTIPLE_ITEM)),
        Generic_Property_KSPROPERTY_TOPOLOGY_NODES_1, "{362E4C2E-7DA8-403e-AB3A-28C5FF93771B}", TOPOLOGY_NODES)
    DEVICE_TEST_METHOD( "500.4.2", "   Out buffer Small",  		            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Topology, KSPROPERTY_TOPOLOGY_NODES, sizeof(KSMULTIPLE_ITEM)),
        Generic_Property_KSPROPERTY_TOPOLOGY_NODES_2, "{B0F0F2A0-8260-4273-8141-DE240834A84D}", TOPOLOGY_NODES)
    DEVICE_TEST_METHOD( "500.4.3", "   Out buffer Large",  					0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Topology, KSPROPERTY_TOPOLOGY_NODES, sizeof(KSMULTIPLE_ITEM)),
        Generic_Property_KSPROPERTY_TOPOLOGY_NODES_3, "{415E53AA-11BC-483a-987A-15DC84CD3C2E}", TOPOLOGY_NODES)

    //KSPROPSETID_TopologyNode	
    DEVICE_TEST_PARENT( "",   " KSPROPSETID_TopologyNode",						0, 0, 0, 0, NULL, "{B35E645A-A93A-42e1-8A03-31863BF8CF2F}")

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_TOPOLOGYNODE_ENABLE",               0, 0, 0, 0, NULL, "{50DBA3A1-4C00-4a54-B996-34E0629451C8}")
    DEVICE_TEST_METHOD( "1900.1.1", "   Invalid Node ID - ULONG_MAX",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_TopologyNode, KSPROPERTY_TOPOLOGYNODE_ENABLE, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTYULONG_NodeID_ULONGMAX, "{1B9D80BA-9F3B-4ba1-AB56-D31C7ED82654}", TOPOLOGYNODE_ENABLE)
    DEVICE_TEST_METHOD( "1900.1.2", "   Invalid Node ID - 0x80000001",  			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_TopologyNode, KSPROPERTY_TOPOLOGYNODE_ENABLE, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTYULONG_NodeID_0x80000001, "{06433821-D3D2-4dff-A360-FA4E1B9EBFE3}", TOPOLOGYNODE_ENABLE)
    DEVICE_TEST_METHOD( "1900.1.3", "   NULL IN/OUT Buffer",  					0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_TopologyNode, KSPROPERTY_TOPOLOGYNODE_ENABLE, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTYULONG_NULL_Buffer, "{A09F248E-9D5E-4736-BB79-2097E795C542}", TOPOLOGYNODE_ENABLE)
    DEVICE_TEST_METHOD( "1900.1.4", "   Small IN/OUT Buffer",  					0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_TopologyNode, KSPROPERTY_TOPOLOGYNODE_ENABLE, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTYULONG_Small_Buffer, "{9E591860-4578-4d06-935D-5668337684F4}", TOPOLOGYNODE_ENABLE)
    DEVICE_TEST_METHOD( "1900.1.5", "   Out buffer Large",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_TopologyNode, KSPROPERTY_TOPOLOGYNODE_ENABLE, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTYULONG_Large_Buffer, "{164101E7-EEF9-4c87-8506-1329306CFA04}", TOPOLOGYNODE_ENABLE)

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_TOPOLOGYNODE_RESET",               0, 0, 0, 0, NULL, "{9075B7C5-2C81-4ac6-A7C7-69C422744216}")
    DEVICE_TEST_METHOD( "1900.2.1", "   Invalid Node ID - ULONG_MAX",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_TopologyNode, KSPROPERTY_TOPOLOGYNODE_RESET, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTYULONG_NodeID_ULONGMAX, "{AD4C7CF4-C19D-44dd-9827-A08E10163A34}", TOPOLOGYNODE_RESET)
    DEVICE_TEST_METHOD( "1900.2.2", "   Invalid Node ID - 0x80000001",  			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_TopologyNode, KSPROPERTY_TOPOLOGYNODE_RESET, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTYULONG_NodeID_0x80000001, "{6C84159B-81DB-4c61-9F71-B4327F1AFFB3}", TOPOLOGYNODE_RESET)
    DEVICE_TEST_METHOD( "1900.2.3", "   NULL IN/OUT Buffer",  					0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_TopologyNode, KSPROPERTY_TOPOLOGYNODE_RESET, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTYULONG_NULL_Buffer, "{9EBD54BA-B806-494c-9FC3-A2F4C79E5D6E}", TOPOLOGYNODE_RESET)
    DEVICE_TEST_METHOD( "1900.2.4", "   Small IN/OUT Buffer",  					0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_TopologyNode, KSPROPERTY_TOPOLOGYNODE_RESET, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTYULONG_Small_Buffer, "{880C7304-07FE-4299-922A-159DAB775BFF}", TOPOLOGYNODE_RESET)
    DEVICE_TEST_METHOD( "1900.2.5", "   Out buffer Large",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_NODE_PROP | RUN_IF_SUPPORTED, KSPROPSETID_TopologyNode, KSPROPERTY_TOPOLOGYNODE_RESET, sizeof(BOOL)),
        Generic_Property_KSNODEPROPERTYULONG_Large_Buffer, "{308F9E32-3AAD-4f0d-8EA4-C00EF7378BA2}", TOPOLOGYNODE_RESET)

    // KSPROPSETID_Connection
    DEVICE_TEST_PARENT( "",   " KSPROPSETID_Connection",						0, 0, 0, 0, NULL, "{9B04C1E6-6FFE-4685-81AB-DAD532BFB0A0}")

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_CONNECTION_DATAFORMAT",				0, 0, 0, 0, NULL, "{d1256bdf-7405-468a-bfcf-0cff3a10b83f}")
    DEVICE_TEST_METHOD( "300.1.1", "   Zero size out buffer",					0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Connection, KSPROPERTY_CONNECTION_DATAFORMAT, sizeof(KSDATAFORMAT)),
        Generic_Property_KSPROPERTY_CONNECTION_DATAFORMAT_1, "{06e2b5aa-9f57-49b1-8c64-f46c00b6a9aa}", CONNECTION_DATAFORMAT)
    DEVICE_TEST_METHOD( "300.1.2", "   Invalid bit depth",					0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Connection, KSPROPERTY_CONNECTION_DATAFORMAT, sizeof(KSDATAFORMAT)),
        Generic_Property_KSPROPERTY_CONNECTION_DATAFORMAT_2, "{18563b10-fb46-4d1f-aeba-5d0b83047303}", CONNECTION_DATAFORMAT)
    DEVICE_TEST_METHOD( "300.1.3", "   Invalid no. of channels",				0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Connection, KSPROPERTY_CONNECTION_DATAFORMAT, sizeof(KSDATAFORMAT)),
        Generic_Property_KSPROPERTY_CONNECTION_DATAFORMAT_3, "{78f76557-69c5-4b02-a088-6409713583fa}", CONNECTION_DATAFORMAT)
    DEVICE_TEST_METHOD( "300.1.4", "   Four bytes out buffer",				0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Connection, KSPROPERTY_CONNECTION_DATAFORMAT, sizeof(KSDATAFORMAT)),
        Generic_Property_KSPROPERTY_CONNECTION_DATAFORMAT_4, "{A686D5BF-498D-4cdf-9BAF-92364FB839B5}", CONNECTION_DATAFORMAT)
    DEVICE_TEST_METHOD( "300.1.5", "   Missing specifier struct in the out buffer",	0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Connection, KSPROPERTY_CONNECTION_DATAFORMAT, sizeof(KSDATAFORMAT)),
        Generic_Property_KSPROPERTY_CONNECTION_DATAFORMAT_5, "{37C2DA14-7442-4212-AFE8-B5A3FCA3151E}", CONNECTION_DATAFORMAT)
    DEVICE_TEST_METHOD( "300.1.6", "   Sending invalid format size",	0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Connection, KSPROPERTY_CONNECTION_DATAFORMAT, sizeof(KSDATAFORMAT)),
        Generic_Property_KSPROPERTY_CONNECTION_DATAFORMAT_6, "{70E334D0-65EC-4529-AE08-6C828E32F5C2}", CONNECTION_DATAFORMAT)
    // TODO: in future add more test cases same as we did in the case of KSPROPERTY_PIN_DATAINTERSECTION.

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_CONNECTION_STATE",					0, 0, 0, 0, NULL, "{052b76c7-b1e3-4d80-918d-e7edf1d1e1cb}")
    DEVICE_TEST_METHOD( "300.2.1", "   Invalid state",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Connection, KSPROPERTY_CONNECTION_STATE, sizeof(KSSTATE)),
        Generic_Property_KSPROPERTY_CONNECTION_STATE_1, "{3edcd7f0-cc8d-469c-af54-bb147380a411}", CONNECTION_STATE)

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_CONNECTION_PROPOSEDATAFORMAT",              0, 0, 0, 0, NULL, "{AFCE1A3E-E05D-42e2-91B2-555B6BCBE68C}")
    DEVICE_TEST_METHOD( "300.3.1", "   Zero size out buffer",                 0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Connection, KSPROPERTY_CONNECTION_PROPOSEDATAFORMAT, sizeof(KSDATAFORMAT)),
        Generic_Property_KSPROPERTY_CONNECTION_DATAFORMAT_1, "{B00369C0-A5CD-4cb4-80B7-F2CEEE2DB7D8}", CONNECTION_PROPOSEDATAFORMAT)
    DEVICE_TEST_METHOD( "300.3.2", "   Invalid bit depth",                    0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Connection, KSPROPERTY_CONNECTION_PROPOSEDATAFORMAT, sizeof(KSDATAFORMAT)),
        Generic_Property_KSPROPERTY_CONNECTION_DATAFORMAT_2, "{F9B293F3-21D5-4426-8A40-0C42407E9BE7}", CONNECTION_PROPOSEDATAFORMAT)
    DEVICE_TEST_METHOD( "300.3.3", "   Invalid no. of channels",              0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Connection, KSPROPERTY_CONNECTION_PROPOSEDATAFORMAT, sizeof(KSDATAFORMAT)),
        Generic_Property_KSPROPERTY_CONNECTION_DATAFORMAT_3, "{7C47DE24-2496-4502-A1E4-1BE6607359AB}", CONNECTION_PROPOSEDATAFORMAT)
    DEVICE_TEST_METHOD( "300.3.4", "   Four bytes out buffer",                0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Connection, KSPROPERTY_CONNECTION_PROPOSEDATAFORMAT, sizeof(KSDATAFORMAT)),
        Generic_Property_KSPROPERTY_CONNECTION_DATAFORMAT_4, "{FF27D1AA-3ABC-4437-98C8-0AA7B55A28F7}", CONNECTION_PROPOSEDATAFORMAT)
    DEVICE_TEST_METHOD( "300.3.5", "   Missing specifier struct in the out buffer",   0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Connection, KSPROPERTY_CONNECTION_PROPOSEDATAFORMAT, sizeof(KSDATAFORMAT)),
        Generic_Property_KSPROPERTY_CONNECTION_DATAFORMAT_5, "{039F1C9B-DBE4-4387-BC61-9AEF4B05C1F4}", CONNECTION_PROPOSEDATAFORMAT)

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_CONNECTION_PRIORITY",              0, 0, 0, 0, NULL, "{2B095D1A-FDCE-4aba-AE18-B3ED2CFCD3D2}")
    DEVICE_TEST_METHOD( "300.4.1", "   NULL Buffer",              0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Connection, KSPROPERTY_CONNECTION_PRIORITY, sizeof(KSPRIORITY)),
        Generic_Property_KSPROPERTY_CONNECTION_PRIORITY_1, "{7F5533A8-3B23-4746-A944-14081F903CEA}", CONNECTION_PRIORITY)
    DEVICE_TEST_METHOD( "300.4.2", "   Small Buffer",             0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Connection, KSPROPERTY_CONNECTION_PRIORITY, sizeof(KSPRIORITY)),
        Generic_Property_KSPROPERTY_CONNECTION_PRIORITY_2, "{AFE20CCF-3758-4812-BB9D-017CD651F89F}", CONNECTION_PRIORITY)
    DEVICE_TEST_METHOD( "300.4.3", "   Large Buffer",             0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Connection, KSPROPERTY_CONNECTION_PRIORITY, sizeof(KSPRIORITY)),
        Generic_Property_KSPROPERTY_CONNECTION_PRIORITY_3, "{A6B06B96-F90C-4ab1-A929-0882C0587D5C}", CONNECTION_PRIORITY)
    DEVICE_TEST_METHOD( "300.4.4", "   Valid test",                 0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Connection, KSPROPERTY_CONNECTION_PRIORITY, sizeof(KSPRIORITY)),
        Generic_Property_KSPROPERTY_CONNECTION_PRIORITY_4, "{9C6595CA-6B5F-4753-B0BE-42F367FCDAE4}", CONNECTION_PRIORITY)
    DEVICE_TEST_METHOD( "300.4.5", "   Invalid data",             0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Connection, KSPROPERTY_CONNECTION_PRIORITY, sizeof(KSPRIORITY)),
        Generic_Property_KSPROPERTY_CONNECTION_PRIORITY_5, "{FBCA30B6-B6CE-4d06-8500-E26084622D8A}", CONNECTION_PRIORITY)

    // KSPROPSETID_Pin
    DEVICE_TEST_PARENT( "",   " KSPROPSETID_Pin",								0, 0, 0, 0, NULL, "{748a65b9-8162-47a9-8095-ddd0060188d2}")

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_PIN_DATAINTERSECTION",				0, 0, 0, 0, NULL, "{1FF58F2D-0FF5-467f-8860-F21167B82AC6}")
    DEVICE_TEST_METHOD( "400.1.1", "   In buffer small",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin, KSPROPERTY_PIN_DATAINTERSECTION, sizeof(KSDATAFORMAT)),
        Generic_Property_KSPROPERTY_PIN_DATAINTERSECTION_1, "{9e20fb79-5d4c-428f-83bc-a367aedfd0ce}", PIN_DATAINTERSECTION)
    DEVICE_TEST_METHOD( "400.1.2", "   Missing specifier",					0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin, KSPROPERTY_PIN_DATAINTERSECTION, sizeof(KSDATAFORMAT)),
        Generic_Property_KSPROPERTY_PIN_DATAINTERSECTION_2, "{2ec257cc-e435-4301-b9a6-461778c73c60}", PIN_DATAINTERSECTION)
    DEVICE_TEST_METHOD( "400.1.3", "   Passing Large Range size",					       0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin, KSPROPERTY_PIN_DATAINTERSECTION, sizeof(KSDATAFORMAT)),
        Generic_Property_KSPROPERTY_PIN_DATAINTERSECTION_3, "{aa575f6b-e996-42d0-9285-a955b5d50dbd}", PIN_DATAINTERSECTION)
    DEVICE_TEST_METHOD( "400.1.4", "   Out size less than specifier required size",					0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin, KSPROPERTY_PIN_DATAINTERSECTION, sizeof(KSDATAFORMAT)),
        Generic_Property_KSPROPERTY_PIN_DATAINTERSECTION_4, "{A8518EAD-D117-41d9-BD0D-D6EC12BE25F8}", PIN_DATAINTERSECTION)
    // TODO: needs to find that if we supply multiple count  = 0x80000000, will ti work or not? - in test when we supply count = 0x8000000, it passes and not fails
    //	{ "400.1.5", "   Multiple items count overflow check",			0, 0, 0,
    //  GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin, KSPROPERTY_PIN_DATAINTERSECTION, sizeof(KSDATAFORMAT)),
    //  Generic_Property_KSPROPERTY_PIN_DATAINTERSECTION_5, "{86B0DB00-1C1E-44d6-A6D0-491E73BA7E68}", PIN_DATAINTERSECTION)
    DEVICE_TEST_METHOD( "400.1.6", "   Bad pin factory id - one more then reported by Filter",          0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin, KSPROPERTY_PIN_DATAINTERSECTION, sizeof(KSDATAFORMAT)),
        Generic_Property_KSPROPERTY_PIN_DATAINTERSECTION_6, "{B23BFE02-F38A-4a84-A7FB-A6646C6CD715}", PIN_DATAINTERSECTION)
    DEVICE_TEST_METHOD( "400.1.7", "   Bad pin factory id - ULONG_MAX",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin, KSPROPERTY_PIN_DATAINTERSECTION, sizeof(KSDATAFORMAT)),
        Generic_Property_KSPROPERTY_PIN_DATAINTERSECTION_7, "{C6A7D4FE-C23F-4e19-971E-0652A931817C}", PIN_DATAINTERSECTION)
    DEVICE_TEST_METHOD( "400.1.8", "   Passing Bigger range size",            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin, KSPROPERTY_PIN_DATAINTERSECTION, sizeof(KSDATAFORMAT)),
        Generic_Property_KSPROPERTY_PIN_DATAINTERSECTION_8, "{816122DB-5E1F-4bc6-8B93-30663E1EE96F}", PIN_DATAINTERSECTION)
    DEVICE_TEST_METHOD( "400.1.9", "   Passing Smaller range size",			0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin, KSPROPERTY_PIN_DATAINTERSECTION, sizeof(KSDATAFORMAT)),
        Generic_Property_KSPROPERTY_PIN_DATAINTERSECTION_9, "{2A4ED6B4-55F0-47e9-A983-18CBEEDD3174}", PIN_DATAINTERSECTION)
    DEVICE_TEST_METHOD( "400.1.10", "   Passing NULL Buffer",            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin, KSPROPERTY_PIN_DATAINTERSECTION, sizeof(KSDATAFORMAT)),
        Generic_Property_KSPROPERTY_PIN_DATAINTERSECTION_10, "{168C3200-6228-4ca5-A343-BB0EB8C810E3}", PIN_DATAINTERSECTION)
    DEVICE_TEST_METHOD( "400.1.11", "   Passing Invalid Audio Range",            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin, KSPROPERTY_PIN_DATAINTERSECTION, sizeof(KSDATAFORMAT)),
        Generic_Property_KSPROPERTY_PIN_DATAINTERSECTION_11, "{0FDFD36B-6D45-468c-A32F-F00070B848F4}", PIN_DATAINTERSECTION)
    DEVICE_TEST_METHOD( "400.1.12", "   Passing Invalid Audio Range -2",            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin, KSPROPERTY_PIN_DATAINTERSECTION, sizeof(KSDATAFORMAT)),
        Generic_Property_KSPROPERTY_PIN_DATAINTERSECTION_12, "{B3F83945-BE9E-4ece-A74D-A5CB7655C513}", PIN_DATAINTERSECTION)

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_PIN_CINSTANCES",					0, 0, 0, 0, NULL, "{04605457-8C32-410e-A515-025577344037}")
    DEVICE_TEST_METHOD( "400.2.1", "   Bad pin id",				   0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin, KSPROPERTY_PIN_CINSTANCES, sizeof(KSPIN_CINSTANCES)),
        Generic_Property_KSPROPERTY_PIN_CINSTANCES_1, "{E71ED0D5-5A99-443e-8888-FD8D5651055D}", PIN_CINSTANCES)
    DEVICE_TEST_METHOD( "400.2.2", "   Bad pin factory id - one more then reported by Filter",                           0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin, KSPROPERTY_PIN_CINSTANCES, sizeof(KSPIN_CINSTANCES)),
        Generic_Property_KSPROPERTY_PIN_CINSTANCES_2, "{F3A09546-F66E-46c4-8394-38F85DADDCE9}", PIN_CINSTANCES)
    DEVICE_TEST_METHOD( "400.2.3", "   Bad pin factory id - ULONG_MAX",                           0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin, KSPROPERTY_PIN_CINSTANCES, sizeof(KSPIN_CINSTANCES)),
        Generic_Property_KSPROPERTY_PIN_CINSTANCES_3, "{99661D7F-A51E-46b6-B89A-D63B391194E4}", PIN_CINSTANCES)
    DEVICE_TEST_METHOD( "400.2.4", "   Passing NULL buffer",				   0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin, KSPROPERTY_PIN_CINSTANCES, sizeof(KSPIN_CINSTANCES)),
        Generic_Property_KSPROPERTY_PIN_CINSTANCES_4, "{C24A4927-1FC9-4993-B3D0-8E1CA23F8EFB}", PIN_CINSTANCES)
    DEVICE_TEST_METHOD( "400.2.5", "   Passing small buffer",                           0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin, KSPROPERTY_PIN_CINSTANCES, sizeof(KSPIN_CINSTANCES)),
        Generic_Property_KSPROPERTY_PIN_CINSTANCES_5, "{2D7BFE02-0EFF-4127-B9B3-D1A3BC4B97F5}", PIN_CINSTANCES)
    DEVICE_TEST_METHOD( "400.2.6", "   Passing large buffer",                           0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin, KSPROPERTY_PIN_CINSTANCES, sizeof(KSPIN_CINSTANCES)),
        Generic_Property_KSPROPERTY_PIN_CINSTANCES_6, "{77A4A726-D538-40ce-AB57-DAA5DABC9CBF}", PIN_CINSTANCES)
    DEVICE_TEST_METHOD( "400.2.7", "   Passing valid data",                           0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin, KSPROPERTY_PIN_CINSTANCES, sizeof(KSPIN_CINSTANCES)),
        Generic_Property_KSPROPERTY_PIN_CINSTANCES_7, "{80A83389-B290-4576-B7C8-ECA2AFC8D820}", PIN_CINSTANCES)

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_PIN_CATEGORY",				0, 0, 0, 0, NULL, "{6E32EA4A-F9FF-45e9-8F74-4C786C053908}")
    DEVICE_TEST_METHOD( "400.3.1", "   Bad pin factory id - one more then reported by Filter", 0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_CATEGORY, sizeof(GUID)),
        Generic_Property_KSPROPERTY_PIN_CATEGORY_1, "{5D4738AE-27E7-471a-B658-037F552252D0}", PIN_CATEGORY)
    DEVICE_TEST_METHOD( "400.3.2", "   Bad pin factory id - ULONG_MAX",             0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_CATEGORY, sizeof(GUID)),
        Generic_Property_KSPROPERTY_PIN_CATEGORY_2, "{A8705814-7999-425a-8357-2B6B670CE954}", PIN_CATEGORY)
    DEVICE_TEST_METHOD( "400.3.3", "   Passing NULL buffer",                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_CATEGORY, sizeof(GUID)),
        Generic_Property_KSPROPERTY_PIN_CATEGORY_3, "{A71790B9-7284-4403-869B-F8AE50D8131B}", PIN_CATEGORY)
    DEVICE_TEST_METHOD( "400.3.4", "   Passing small buffer",                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_CATEGORY, sizeof(GUID)),
        Generic_Property_KSPROPERTY_PIN_CATEGORY_4, "{21618B23-70D3-40a9-B544-334FF9845425}", PIN_CATEGORY)
    DEVICE_TEST_METHOD( "400.3.5", "   Passing large buffer",                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_CATEGORY, sizeof(GUID)),
        Generic_Property_KSPROPERTY_PIN_CATEGORY_5, "{63E395CF-5175-4e8a-8EEC-6502D88CC585}", PIN_CATEGORY)
    DEVICE_TEST_METHOD( "400.3.6", "   Passing valid data",                                0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_CATEGORY, sizeof(GUID)),
        Generic_Property_KSPROPERTY_PIN_CATEGORY_6, "{9F6DB02E-AF76-4851-96DE-AB36B65A6F0C}", PIN_CATEGORY)

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_PIN_INTERFACES",				0, 0, 0, 0, NULL, "{565D7E98-3825-4790-92D1-EDC3E6130023}")
    DEVICE_TEST_METHOD( "400.4.1", "   Bad pin factory id - one more then reported by Filter", 0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_INTERFACES, sizeof(KSMULTIPLE_ITEM)),
        Generic_Property_KSPROPERTY_PIN_INTERFACES_1, "{0A7E5583-4AE4-4fa3-95E0-3907E16F11C5}", PIN_INTERFACES)
    DEVICE_TEST_METHOD( "400.4.2", "   Bad pin factory id - ULONG_MAX",             0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_INTERFACES, sizeof(KSMULTIPLE_ITEM)),
        Generic_Property_KSPROPERTY_PIN_INTERFACES_2, "{40C8706A-3107-4797-BC8F-200C0C4F732C}", PIN_INTERFACES)
    DEVICE_TEST_METHOD( "400.4.3", "   Passing NULL buffer",                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_INTERFACES, sizeof(KSMULTIPLE_ITEM)),
        Generic_Property_KSPROPERTY_PIN_INTERFACES_3, "{01851583-A025-446e-BE70-B18DCA40A5D1}", PIN_INTERFACES)
    DEVICE_TEST_METHOD( "400.4.4", "   Passing small buffer",                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_INTERFACES, sizeof(KSMULTIPLE_ITEM)),
        Generic_Property_KSPROPERTY_PIN_INTERFACES_4, "{B1D973BE-5378-4eb3-955A-E60F7A4E4693}", PIN_INTERFACES)
    DEVICE_TEST_METHOD( "400.4.5", "   Passing large buffer",                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_INTERFACES, sizeof(KSMULTIPLE_ITEM)),
        Generic_Property_KSPROPERTY_PIN_INTERFACES_5, "{46B6980C-0CE1-4ce9-BB33-84384FBA094A}", PIN_INTERFACES)
    DEVICE_TEST_METHOD( "400.4.6", "   Passing valid data",                                0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_INTERFACES, sizeof(KSMULTIPLE_ITEM)),
        Generic_Property_KSPROPERTY_PIN_INTERFACES_6, "{CB69BF8C-962F-4160-AD00-3F9BD40D6869}", PIN_INTERFACES)

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_PIN_COMMUNICATION",				0, 0, 0, 0, NULL, "{2B763D46-5A39-40fc-86F3-FFB83C1B0BE9}")
    DEVICE_TEST_METHOD( "400.5.1", "   Bad pin factory id - one more then reported by Filter", 0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_COMMUNICATION, sizeof(KSPIN_COMMUNICATION)),
        Generic_Property_KSPROPERTY_PIN_COMMUNICATION_1, "{5ED698B1-EA56-4eaf-B0A6-3ECFEC0FF294}", PIN_COMMUNICATION)
    DEVICE_TEST_METHOD( "400.5.2", "   Bad pin factory id - ULONG_MAX",             0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_COMMUNICATION, sizeof(KSPIN_COMMUNICATION)),
        Generic_Property_KSPROPERTY_PIN_COMMUNICATION_2, "{9F325088-4CED-4d99-ABD6-3593B0C68D4C}", PIN_COMMUNICATION)
    DEVICE_TEST_METHOD( "400.5.3", "   Passing NULL buffer",                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_COMMUNICATION, sizeof(KSPIN_COMMUNICATION)),
        Generic_Property_KSPROPERTY_PIN_COMMUNICATION_3, "{7C669898-B293-4cd0-9CCD-5C5703EE8174}", PIN_COMMUNICATION)
    DEVICE_TEST_METHOD( "400.5.4", "   Passing small buffer",                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_COMMUNICATION, sizeof(KSPIN_COMMUNICATION)),
        Generic_Property_KSPROPERTY_PIN_COMMUNICATION_4, "{1FE6169D-B3CB-4286-AC7A-CED6CCA995A3}", PIN_COMMUNICATION)
    DEVICE_TEST_METHOD( "400.5.5", "   Passing large buffer",                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_COMMUNICATION, sizeof(KSPIN_COMMUNICATION)),
        Generic_Property_KSPROPERTY_PIN_COMMUNICATION_5, "{F863702D-2CDD-4cc8-AC21-BBBA36AB83B0}", PIN_COMMUNICATION)
    DEVICE_TEST_METHOD( "400.5.6", "   Passing valid data",                                0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_COMMUNICATION, sizeof(KSPIN_COMMUNICATION)),
        Generic_Property_KSPROPERTY_PIN_COMMUNICATION_6, "{28E68AD0-A340-486a-A23A-CC41736B351B}", PIN_COMMUNICATION)

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_PIN_DATAFLOW",				0, 0, 0, 0, NULL, "{D89F3C08-D420-4b39-BFAE-C2950E960746}")
    DEVICE_TEST_METHOD( "400.6.1", "   Bad pin factory id - one more then reported by Filter", 0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_DATAFLOW, sizeof(KSPIN_DATAFLOW)),
        Generic_Property_KSPROPERTY_PIN_DATAFLOW_1, "{0B0B7455-4482-4d8d-916C-03509601BB2A}", PIN_DATAFLOW)
    DEVICE_TEST_METHOD( "400.6.2", "   Bad pin factory id - ULONG_MAX",             0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_DATAFLOW, sizeof(KSPIN_DATAFLOW)),
        Generic_Property_KSPROPERTY_PIN_DATAFLOW_2, "{ADA2F8CE-9AD9-46c8-BB9A-2DD23760B6AB}", PIN_DATAFLOW)
    DEVICE_TEST_METHOD( "400.6.3", "   Passing NULL buffer",                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_DATAFLOW, sizeof(KSPIN_DATAFLOW)),
        Generic_Property_KSPROPERTY_PIN_DATAFLOW_3, "{B5D1555A-86F7-4d4e-ACBD-0188BE58FD16}", PIN_DATAFLOW)
    DEVICE_TEST_METHOD( "400.6.4", "   Passing small buffer",                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_DATAFLOW, sizeof(KSPIN_DATAFLOW)),
        Generic_Property_KSPROPERTY_PIN_DATAFLOW_4, "{825D043A-60E1-46cd-961F-5693B0AA51A8}", PIN_DATAFLOW)
    DEVICE_TEST_METHOD( "400.6.5", "   Passing large buffer",                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_DATAFLOW, sizeof(KSPIN_DATAFLOW)),
        Generic_Property_KSPROPERTY_PIN_DATAFLOW_5, "{BDE25C6A-FE64-4635-B920-B1EE1A8716AE}", PIN_DATAFLOW)
    DEVICE_TEST_METHOD( "400.6.6", "   Passing valid data",                                0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_DATAFLOW, sizeof(KSPIN_DATAFLOW)),
        Generic_Property_KSPROPERTY_PIN_DATAFLOW_6, "{44047875-8676-485b-A7F8-BC637E18CD7E}", PIN_DATAFLOW)

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_PIN_GLOBALCINSTANCES",				0, 0, 0, 0, NULL, "{126CDC8F-E99D-47e5-B177-A6C554E9187F}")
    DEVICE_TEST_METHOD( "400.7.1", "   Bad pin id",                  0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_GLOBALCINSTANCES, sizeof(KSPIN_CINSTANCES)),
        Generic_Property_KSPROPERTY_PIN_CINSTANCES_1, "{71710694-B689-460e-B523-D22D28759397}", PIN_GLOBALCINSTANCES)
    DEVICE_TEST_METHOD( "400.7.2", "   Bad pin factory id - one more then reported by Filter", 0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_GLOBALCINSTANCES, sizeof(KSPIN_CINSTANCES)),
        Generic_Property_KSPROPERTY_PIN_CINSTANCES_2, "{57ED8F9C-905A-40b0-BACA-6FB45AC94FE3}", PIN_GLOBALCINSTANCES)
    DEVICE_TEST_METHOD( "400.7.3", "   Bad pin factory id - ULONG_MAX",             0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_GLOBALCINSTANCES, sizeof(KSPIN_CINSTANCES)),
        Generic_Property_KSPROPERTY_PIN_CINSTANCES_3, "{0B7F78A8-EAF9-4432-9347-20BC701EC851}", PIN_GLOBALCINSTANCES)
    DEVICE_TEST_METHOD( "400.7.4", "   Passing NULL buffer",                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_GLOBALCINSTANCES, sizeof(KSPIN_CINSTANCES)),
        Generic_Property_KSPROPERTY_PIN_CINSTANCES_4, "{2ED371EB-503A-42ca-A458-68B3294FA124}", PIN_GLOBALCINSTANCES)
    DEVICE_TEST_METHOD( "400.7.5", "   Passing small buffer",                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_GLOBALCINSTANCES, sizeof(KSPIN_CINSTANCES)),
        Generic_Property_KSPROPERTY_PIN_CINSTANCES_5, "{6129B740-B7D6-4516-BCAE-28BB254D0113}", PIN_GLOBALCINSTANCES)
    DEVICE_TEST_METHOD( "400.7.6", "   Passing large buffer",                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_GLOBALCINSTANCES, sizeof(KSPIN_CINSTANCES)),
        Generic_Property_KSPROPERTY_PIN_CINSTANCES_6, "{BF39209B-1F2A-497e-902B-0A159E30C356}", PIN_GLOBALCINSTANCES)
    DEVICE_TEST_METHOD( "400.7.7", "   Passing valid data",                                0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_GLOBALCINSTANCES, sizeof(KSPIN_CINSTANCES)),
        Generic_Property_KSPROPERTY_PIN_CINSTANCES_7, "{AE3FED63-3344-4199-881B-A647AD71C848}", PIN_GLOBALCINSTANCES)

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_PIN_MEDIUMS",				0, 0, 0, 0, NULL, "{359DAAD9-490D-4c28-B0BD-879EC9FDA769}")
    DEVICE_TEST_METHOD( "400.8.1", "   Bad pin factory id - one more then reported by Filter", 0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_MEDIUMS, sizeof(KSMULTIPLE_ITEM)),
        Generic_Property_KSPROPERTY_PIN_MEDIUMS_1, "{44B514B7-CF04-4cd6-8943-22F39C3ECBBF}", PIN_MEDIUMS)
    DEVICE_TEST_METHOD( "400.8.2", "   Bad pin factory id - ULONG_MAX",             0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_MEDIUMS, sizeof(KSMULTIPLE_ITEM)),
        Generic_Property_KSPROPERTY_PIN_MEDIUMS_2, "{EF16297D-E3B0-480c-B8C2-9432621B54A5}", PIN_MEDIUMS)
    DEVICE_TEST_METHOD( "400.8.3", "   Passing NULL buffer",                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_MEDIUMS, sizeof(KSMULTIPLE_ITEM)),
        Generic_Property_KSPROPERTY_PIN_MEDIUMS_3, "{EC09C38A-FB6E-4984-835C-88C065E3560C}", PIN_MEDIUMS)
    DEVICE_TEST_METHOD( "400.8.4", "   Passing small buffer",                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_MEDIUMS, sizeof(KSMULTIPLE_ITEM)),
        Generic_Property_KSPROPERTY_PIN_MEDIUMS_4, "{48AA8866-09E6-45b8-95FD-24D152B53110}", PIN_MEDIUMS)
    DEVICE_TEST_METHOD( "400.8.5", "   Passing large buffer",                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_MEDIUMS, sizeof(KSMULTIPLE_ITEM)),
        Generic_Property_KSPROPERTY_PIN_MEDIUMS_5, "{58473487-01D8-4fb3-AF8A-9042DE0BD9AA}", PIN_MEDIUMS)
    DEVICE_TEST_METHOD( "400.8.6", "   Passing valid data",                                0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_MEDIUMS, sizeof(KSMULTIPLE_ITEM)),
        Generic_Property_KSPROPERTY_PIN_MEDIUMS_6, "{8B78A9B0-7D9F-4274-B0C2-82C095EC62A0}", PIN_MEDIUMS)

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_PIN_NECESSARYINSTANCES",				0, 0, 0, 0, NULL, "{541BF790-8521-4e23-B2D5-3315888FA260}")
    DEVICE_TEST_METHOD( "400.9.1", "   Bad pin factory id - one more then reported by Filter", 0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_NECESSARYINSTANCES, sizeof(ULONG)),
        Generic_Property_KSPROPERTY_PIN_NECESSARYINSTANCES_1, "{DBC78413-F12A-42e9-B174-193EC625903B}", PIN_NECESSARYINSTANCES)
    DEVICE_TEST_METHOD( "400.9.2", "   Bad pin factory id - ULONG_MAX",             0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_NECESSARYINSTANCES, sizeof(ULONG)),
        Generic_Property_KSPROPERTY_PIN_NECESSARYINSTANCES_2, "{2DE98761-B69F-472c-A756-DC188BC3932F}", PIN_NECESSARYINSTANCES)
    DEVICE_TEST_METHOD( "400.9.3", "   Passing NULL buffer",                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_NECESSARYINSTANCES, sizeof(ULONG)),
        Generic_Property_KSPROPERTY_PIN_NECESSARYINSTANCES_3, "{468615D4-550B-4dad-929A-DB9721B8BA1D}", PIN_NECESSARYINSTANCES)
    DEVICE_TEST_METHOD( "400.9.4", "   Passing small buffer",                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_NECESSARYINSTANCES, sizeof(ULONG)),
        Generic_Property_KSPROPERTY_PIN_NECESSARYINSTANCES_4, "{BE939FF8-D9F2-4356-9187-6A0AD26ADDE4}", PIN_NECESSARYINSTANCES)
    DEVICE_TEST_METHOD( "400.9.5", "   Passing large buffer",                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_NECESSARYINSTANCES, sizeof(ULONG)),
        Generic_Property_KSPROPERTY_PIN_NECESSARYINSTANCES_5, "{64C8A273-3452-442e-B615-9981D271CE17}", PIN_NECESSARYINSTANCES)
    DEVICE_TEST_METHOD( "400.9.6", "   Passing valid data",                                0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_NECESSARYINSTANCES, sizeof(ULONG)),
        Generic_Property_KSPROPERTY_PIN_NECESSARYINSTANCES_6, "{1A99F524-A636-48b0-A031-793E5A2ACAA8}", PIN_NECESSARYINSTANCES)

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_PIN_CONSTRAINEDDATARANGES",				0, 0, 0, 0, NULL, "{BF56D569-18A3-4cf7-9E9F-635557BAB894}")
    DEVICE_TEST_METHOD( "400.10.1", "   Bad pin factory id - one more then reported by Filter", 0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_CONSTRAINEDDATARANGES , sizeof(KSMULTIPLE_ITEM)),
        Generic_Property_KSPROPERTY_PIN_CONSTRAINEDDATARANGES_1, "{4792A10D-D6C9-4472-9C98-313FAE4502E4}", PIN_CONSTRAINEDDATARANGES )
    DEVICE_TEST_METHOD( "400.10.2", "   Bad pin factory id - ULONG_MAX",             0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_CONSTRAINEDDATARANGES , sizeof(KSMULTIPLE_ITEM)),
        Generic_Property_KSPROPERTY_PIN_CONSTRAINEDDATARANGES_2, "{1F3D9745-665E-459c-9133-23CC58CAFDF3}", PIN_CONSTRAINEDDATARANGES )
    DEVICE_TEST_METHOD( "400.10.3", "   Passing NULL buffer",                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_CONSTRAINEDDATARANGES , sizeof(KSMULTIPLE_ITEM)),
        Generic_Property_KSPROPERTY_PIN_CONSTRAINEDDATARANGES_3, "{3C0932EE-F5E9-4711-B8B5-0387991ED485}", PIN_CONSTRAINEDDATARANGES )
    DEVICE_TEST_METHOD( "400.10.4", "   Passing small buffer",                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_CONSTRAINEDDATARANGES , sizeof(KSMULTIPLE_ITEM)),
        Generic_Property_KSPROPERTY_PIN_CONSTRAINEDDATARANGES_4, "{502C83DA-35D3-4bd6-8CF1-A33A96227307}", PIN_CONSTRAINEDDATARANGES )
    DEVICE_TEST_METHOD( "400.10.5", "   Passing large buffer",                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_CONSTRAINEDDATARANGES , sizeof(KSMULTIPLE_ITEM)),
        Generic_Property_KSPROPERTY_PIN_CONSTRAINEDDATARANGES_5, "{A9047A36-5D2E-43f9-BC30-A01B9E7107F4}", PIN_CONSTRAINEDDATARANGES )
    DEVICE_TEST_METHOD( "400.10.6", "   Passing valid data",                                0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_CONSTRAINEDDATARANGES , sizeof(KSMULTIPLE_ITEM)),
        Generic_Property_KSPROPERTY_PIN_CONSTRAINEDDATARANGES_6, "{6C683D65-CBB0-483c-89A4-691CD268D252}", PIN_CONSTRAINEDDATARANGES )

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_PIN_DATARANGES",				0, 0, 0, 0, NULL, "{B0053EB3-03B0-4b20-92B3-4D7FE97F405C}")
    DEVICE_TEST_METHOD( "400.11.1", "   Bad pin factory id - one more then reported by Filter", 0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_DATARANGES , sizeof(KSMULTIPLE_ITEM)),
        Generic_Property_KSPROPERTY_PIN_DATARANGES_1, "{098528DA-F324-4174-B628-C8BA6536C595}", PIN_DATARANGES )
    DEVICE_TEST_METHOD( "400.11.2", "   Bad pin factory id - ULONG_MAX",             0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_DATARANGES , sizeof(KSMULTIPLE_ITEM)),
        Generic_Property_KSPROPERTY_PIN_DATARANGES_2, "{B2C1BBFE-B44E-48c9-BC7A-2E11F1AFDDF2}", PIN_DATARANGES )
    DEVICE_TEST_METHOD( "400.11.3", "   Passing NULL buffer",                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_DATARANGES , sizeof(KSMULTIPLE_ITEM)),
        Generic_Property_KSPROPERTY_PIN_DATARANGES_3, "{644769F3-B22D-4168-B55E-C265AE6476C2}", PIN_DATARANGES )
    DEVICE_TEST_METHOD( "400.11.4", "   Passing small buffer",                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_DATARANGES , sizeof(KSMULTIPLE_ITEM)),
        Generic_Property_KSPROPERTY_PIN_DATARANGES_4, "{B9B30748-51D1-44ec-9E8C-50412B8266C9}", PIN_DATARANGES )
    DEVICE_TEST_METHOD( "400.11.5", "   Passing large buffer",                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_DATARANGES , sizeof(KSMULTIPLE_ITEM)),
        Generic_Property_KSPROPERTY_PIN_DATARANGES_5, "{A70868FF-2482-4c38-9561-F6AC7DC5FE02}", PIN_DATARANGES )
    DEVICE_TEST_METHOD( "400.11.6", "   Passing valid data",                                0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_DATARANGES , sizeof(KSMULTIPLE_ITEM)),
        Generic_Property_KSPROPERTY_PIN_DATARANGES_6, "{F6605B8F-3386-418e-AA43-2A60B0A69F2C}", PIN_DATARANGES )

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_PIN_NAME",				0, 0, 0, 0, NULL, "{342931D3-70E0-4d6d-A90C-830494EFEF59}")
    DEVICE_TEST_METHOD( "400.12.1", "   Bad pin factory id - one more then reported by Filter", 0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_NAME, 0),
        Generic_Property_KSPROPERTY_PIN_NAME_1, "{4AC17533-0935-4eb8-B486-C1910F55ECA6}", PIN_NAME)
    DEVICE_TEST_METHOD( "400.12.2", "   Bad pin factory id - ULONG_MAX",             0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_NAME, 0),
        Generic_Property_KSPROPERTY_PIN_NAME_2, "{C3AAD8C5-8047-4d87-9C25-354C5C1F69A5}", PIN_NAME)
    DEVICE_TEST_METHOD( "400.12.3", "   Passing NULL buffer",                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_NAME, 0),
        Generic_Property_KSPROPERTY_PIN_NAME_3, "{447F9C55-E43C-4ddd-9DE6-3BFCD6C30ED2}", PIN_NAME)
    DEVICE_TEST_METHOD( "400.12.4", "   Passing small buffer",                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_NAME, 0),
        Generic_Property_KSPROPERTY_PIN_NAME_4, "{BC3CD50D-B0B1-475a-A542-C479C57B7F09}", PIN_NAME)
    DEVICE_TEST_METHOD( "400.12.5", "   Passing large buffer",                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_NAME, 0),
        Generic_Property_KSPROPERTY_PIN_NAME_5, "{8ADD58C8-B3F8-458c-AEDE-7D59DD06936C}", PIN_NAME)
    DEVICE_TEST_METHOD( "400.12.6", "   Passing valid data",                                0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_NAME, 0),
        Generic_Property_KSPROPERTY_PIN_NAME_6, "{CF21B5CB-98AC-4647-845C-48D905486D68}", PIN_NAME)

    DEVICE_TEST_PARENT( "", "  KSPROPERTY_PIN_PROPOSEDATAFORMAT",				0, 0, 0, 0, NULL, "{0FAEE6F2-5B3D-45c9-BF3E-1421502396D5}")
    DEVICE_TEST_METHOD( "400.13.1", "   Bad pin factory id - one more then reported by Filter", 0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_PROPOSEDATAFORMAT , sizeof(KSDATAFORMAT)),
        Generic_Property_KSPROPERTY_PIN_PROPOSEDATAFORMAT_1, "{70864445-388B-49d9-A8E5-F6CBADF1B4E6}", PIN_PROPOSEDATAFORMAT )
    DEVICE_TEST_METHOD( "400.13.2", "   Bad pin factory id - ULONG_MAX",             0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_PROPOSEDATAFORMAT , sizeof(KSDATAFORMAT)),
        Generic_Property_KSPROPERTY_PIN_PROPOSEDATAFORMAT_2, "{7EF578DB-4186-4c78-A1A3-254F38894B1E}", PIN_PROPOSEDATAFORMAT )
    DEVICE_TEST_METHOD( "400.13.3", "   Passing NULL buffer",                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_PROPOSEDATAFORMAT , sizeof(KSDATAFORMAT)),
        Generic_Property_KSPROPERTY_PIN_PROPOSEDATAFORMAT_3, "{701AB3A9-5705-4025-A53B-35254EC2D518}", PIN_PROPOSEDATAFORMAT )
    DEVICE_TEST_METHOD( "400.13.4", "   Passing small buffer",                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_PROPOSEDATAFORMAT , sizeof(KSDATAFORMAT)),
        Generic_Property_KSPROPERTY_PIN_PROPOSEDATAFORMAT_4, "{439A933A-55E8-481a-A570-6FB7921BA4DE}", PIN_PROPOSEDATAFORMAT )
    DEVICE_TEST_METHOD( "400.13.5", "   Passing large buffer",                               0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_PROPOSEDATAFORMAT , sizeof(KSDATAFORMAT)),
        Generic_Property_KSPROPERTY_PIN_PROPOSEDATAFORMAT_5, "{FCA2324C-889B-4c2c-AEC0-810DE7FF6CE5}", PIN_PROPOSEDATAFORMAT )
    DEVICE_TEST_METHOD( "400.13.6", "   Passing valid data",                                0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_PROPOSEDATAFORMAT , sizeof(KSDATAFORMAT)),
        Generic_Property_KSPROPERTY_PIN_PROPOSEDATAFORMAT_6, "{067BC14C-762C-46dc-B5FB-FE6BFA213866}", PIN_PROPOSEDATAFORMAT )

    // Create test cases
    DEVICE_TEST_PARENT( "", "Create",										    0, 0, 0, 0, NULL, "{F1C05861-0C86-4da8-82D7-F51EE77421D1}")

    DEVICE_TEST_PARENT( "", " Create pin",	    							0, 0, 0, 0, NULL, "{63A1B73D-A488-4311-B1CD-8D2B73E9DE59}")

    DEVICE_TEST_METHOD( "1000.1.1", "  Invalid cbSize",						0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP( RUN_PIN_CREATE , GUID_NULL, INVALID_PROPERTY, 0),
        Generic_Create_Pin_1, "{11711615-EECD-46bc-9ADD-D09F2BB705D4}", INVALID_PROPERTY)
    DEVICE_TEST_METHOD( "1000.1.2", "  cbSize==0",							0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP( RUN_PIN_CREATE , GUID_NULL, INVALID_PROPERTY, 0),
        Generic_Create_Pin_2, "{244C88E4-1E20-4d6d-84CD-437D60365357}", INVALID_PROPERTY)
    DEVICE_TEST_METHOD( "1000.1.3", "  Change tag for WFX",					0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP( RUN_PIN_CREATE , GUID_NULL, INVALID_PROPERTY, 0),
        Generic_Create_Pin_3, "{F33F3656-B372-4780-B686-52F0995E9B3A}", INVALID_PROPERTY)
    DEVICE_TEST_METHOD( "1000.1.4", "  Specifier information missing",		0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP( RUN_PIN_CREATE , GUID_NULL, INVALID_PROPERTY, 0),
        Generic_Create_Pin_4, "{8BFAD39B-2023-45ed-A77A-BB7F473199DD}", INVALID_PROPERTY)
    DEVICE_TEST_METHOD( "1000.1.5", "  Invaid KSPRIORITY",		0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP( RUN_PIN_CREATE , GUID_NULL, INVALID_PROPERTY, 0),
        Generic_Create_Pin_5, "{22C60EBD-7D09-44dc-8A23-F369F33BE92F}", INVALID_PROPERTY)
    DEVICE_TEST_METHOD( "1000.1.6", "  Invaid KSPIN Medium",		0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP( RUN_PIN_CREATE , GUID_NULL, INVALID_PROPERTY, 0),
        Generic_Create_Pin_6, "{2A40210D-298D-483a-A041-D7DFF66C04B5}", INVALID_PROPERTY)
    DEVICE_TEST_METHOD( "1000.1.7", "  Invaid KSPIN Interface",		0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP( RUN_PIN_CREATE , GUID_NULL, INVALID_PROPERTY, 0),
        Generic_Create_Pin_7, "{29DE6ED7-6538-4f87-BDCB-9EE371BA6D27}", INVALID_PROPERTY)
    DEVICE_TEST_METHOD( "1000.1.8", "  CreateValid Pins",		0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP( RUN_PIN_CREATE , GUID_NULL, INVALID_PROPERTY, 0),
        Tst_KCP_AllPinsValid , "{789E0D63-3A6A-4e23-B054-DEC349D02370}", INVALID_PROPERTY)


    DEVICE_TEST_PARENT( "", "IOCTL",										    0, 0, 0, 0, NULL, "{342643ae-88f7-4cd0-be00-2dd32ed4e969}")

    // KS Ioctls
    DEVICE_TEST_PARENT( "", " KS defined",									0, 0, 0, 0, NULL, "{02549af6-d62b-4536-9ba9-0caa63a8aef7}")
    DEVICE_TEST_PARENT( "", "  IOCTL_KS_WRITE_STREAM",					    0, 0, 0, 0, NULL, "{fbced59c-d134-4972-ab00-48bfabd325ea}")
    DEVICE_TEST_METHOD( "800.1.1", "   Cancel IO",							0, 0, 0,
        GAUDIT_TEST_ENTRY_IOCTL(GOF_IOCTL | RUN_PROP, IOCTL_KS_WRITE_STREAM, 0),
        Generic_Ioctl_IOCTL_KS_WRITE_1, "{84b6454b-c37a-42e5-8259-3623e87ec5f3}", IOCTL_KS_WRITE_STREAM)
    //  { "800.1.2", "   Test PCM format pins' ability to render PCM data",	0, 0, 0,
    //      GAUDIT_TEST_ENTRY_IOCTL(GOF_IOCTL | RUN_PROP, IOCTL_KS_WRITE_STREAM, 0),
    //      Tst_PinRenderTest, "{3D748503-6032-4963-8FC0-BA946705CC91}", IOCTL_KS_WRITE_STREAM)

    DEVICE_TEST_PARENT( "", " WDMAUD defined",								0, 0, 0, 0, NULL, "{7945D95E-99CA-40a9-A44D-8B269D9B269D}")
    DEVICE_TEST_PARENT( "", "  IOCTL_WDMAUD_INIT",					0, 0, 0, 0, NULL, "{EC3DE7D8-A24B-46cd-BA93-53BE4E114F58}")
    DEVICE_TEST_METHOD( "1100.1.1", "   Initialize WDMAUD",			            0, 0, 0,
        GAUDIT_TEST_ENTRY_IOCTL(GOF_IOCTL | RUN_PROP, IOCTL_WDMAUD_INIT, 0),
        Generic_Ioctl_IOCTL_WDMAUD_INIT, "{A2D662A5-F1FD-4918-B136-5D97BFC12F11}", IOCTL_WDMAUD_INIT)

    DEVICE_TEST_PARENT( "", "  IOCTL_WDMAUD_ADD_DEVNODE",					0, 0, 0, 0, NULL, "{E3609B40-A955-4d9f-BFB4-B7362B8F4652}")
    DEVICE_TEST_METHOD( "1100.1.2", "   Test Add and Remove Device Node",			            0, 0, 0,
        GAUDIT_TEST_ENTRY_IOCTL(GOF_IOCTL | RUN_PROP, IOCTL_WDMAUD_ADD_DEVNODE, 0),
        Generic_Ioctl_IOCTL_WDMAUD_ADD_DEVNODE, "{CC99F476-1F31-48b9-9FFA-AD241042F0C5}", IOCTL_WDMAUD_ADD_DEVNODE)

    DEVICE_TEST_PARENT( "", "  IOCTL_WDMAUD_GET_CAPABILITIES",					0, 0, 0, 0, NULL, "{DE9764D6-256C-4424-9A08-A2FD0450DBCE}")
    DEVICE_TEST_METHOD( "1100.1.3", "   Get Capabilities",			            0, 0, 0,
        GAUDIT_TEST_ENTRY_IOCTL(GOF_IOCTL | RUN_PROP, IOCTL_WDMAUD_GET_CAPABILITIES, 0),
        Generic_Ioctl_IOCTL_WDMAUD_GET_CAPABILITIES, "{D9E488E6-1C8F-46d1-84E2-41E86305EE62}", IOCTL_WDMAUD_GET_CAPABILITIES)

    /*{ "", "  IOCTL_WDMAUD_REMOVE_DEVNODE",					0, 0, 0, 0, NULL, "{8F7BF6FB-1F7C-4368-BE02-EBD3F7557068}")
    DEVICE_TEST_METHOD( "1100.1.2", "   Remove Device Node",			            0, 0, 0,
        GAUDIT_TEST_ENTRY_PROP(GOF_PROP | RUN_PIN_PROP | RUN_IF_SUPPORTED, KSPROPSETID_Pin,KSPROPERTY_PIN_CATEGORY, sizeof(GUID)),
        Generic_Ioctl_IOCTL_WDMAUD_ADD_DEVNODE, "{E927EF8E-B211-4aee-BDD9-C114AA74EA0F}"}*/
END_TEST_CASE_INFO(GAudiT)
#endif

