#pragma once
#ifndef __MFTDiagPlaybackTAEF_H__
#define __MFTDiagPlaybackTAEF_H__

#include "WexTestClass.h"
#include "MFTDTaefBase.h"

BEGIN_MODULE()
    MODULE_PROPERTY(L"Feature", L"MFTDiagCompliance")
    MODULE_PROPERTY(L"ThreadingModel", L"MTA")
END_MODULE()

class CMFTDiagComplianceTAEF : public WEX::TestClass<CMFTDiagComplianceTAEF>, public CMFTDTaefBase
{
public:
    CMFTDiagComplianceTAEF(void);
    ~CMFTDiagComplianceTAEF(void);

    BEGIN_TEST_CLASS(CMFTDiagComplianceTAEF)
    END_TEST_CLASS()

    TEST_CLASS_SETUP(InitializeTestClass)
    TEST_CLASS_CLEANUP(FinalizeTestClass);

    BEGIN_TEST_METHOD(ComplianceDecodeTest13)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"119FF99E-41EA-6D22-291A-2F9157696E61")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"74954bbe-c3d2-43f9-a3ef-58bc521fa62c")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"MPEG4 Decoder - HMFT compliance test 13")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"MPEG4 Decoder HMFT Compliance Test: InputType MPEG4 - Verifies IMFTransform for MPEG4 Decoder")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Streaming.HMFT.Decoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\HMFTContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the HMFT to test - {DETECT} should be used for certification, this can be overridden to test a specific HMFT")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\HMFTContent\\MSHDRef_Motion_FastCam_Action_03_1920x1080i30f_IYUV_30000kbps.mp4")
    END_TEST_METHOD() 
 

    BEGIN_TEST_METHOD(ComplianceDecodeTest14)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"4c941d3e-d757-4150-a0a9-6fb407b223e4")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"43209a09-8c76-4088-8026-1c102d0e7b83")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"MPEG4 Decoder - HMFT compliance test 14")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"MPEG4 Decoder HMFT Compliance Test: InputType MPEG4 - Verifies IMFTransform for MPEG4 Decoder")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Streaming.HMFT.Decoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\HMFTContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the HMFT to test - {DETECT} should be used for certification, this can be overridden to test a specific HMFT")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\HMFTContent\\MSHDRef_Texture_SkinTones_05_352x288p15f_900kbps_XVid_MP4.avi")
    END_TEST_METHOD()
 

    BEGIN_TEST_METHOD(ComplianceDecodeTest15)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"59ddd4b8-1dd6-43e2-8345-4dd98e626156")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"8d08d9d1-ad46-49d0-8366-95cd73f5071e")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"MPEG4 Decoder - HMFT compliance test 15")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"MPEG4 Decoder HMFT Compliance Test: InputType MPEG4 - Verifies IMFTransform for MPEG4 Decoder")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Streaming.HMFT.Decoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\HMFTContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the HMFT to test - {DETECT} should be used for certification, this can be overridden to test a specific HMFT")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\HMFTContent\\14_MSHDRef_Difficult_Edge_02_720x480i30f_MPEG_1700kbps.avi")
    END_TEST_METHOD()
 

    BEGIN_TEST_METHOD(ComplianceDecodeTest16)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"6cde2dcd-b854-4b85-8153-725395102778")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"d0f39f98-c8f3-46c3-a4e3-19efb7fcac00")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"MPEG4 Decoder - HMFT compliance test 16")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"MPEG4 Decoder HMFT Compliance Test: InputType MPEG4 - Verifies IMFTransform for MPEG4 Decoder")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Streaming.HMFT.Decoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\HMFTContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the HMFT to test - {DETECT} should be used for certification, this can be overridden to test a specific HMFT")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\HMFTContent\\27_MSHDRef_Difficult_Edge_06_720x576i25f_h263_3080kbps.avi")
    END_TEST_METHOD()
 

    BEGIN_TEST_METHOD(ComplianceDecodeTest17)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"b45a1eb8-4e9e-4116-8ecf-527d4d912b2e")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"7807465a-9809-452f-9a28-d12d4dab5c60")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"MPEG4 Decoder - HMFT compliance test 17")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"MPEG4 Decoder HMFT Compliance Test: InputType MPEG4 - Verifies IMFTransform for MPEG4 Decoder")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Streaming.HMFT.Decoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\HMFTContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the HMFT to test - {DETECT} should be used for certification, this can be overridden to test a specific HMFT")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\HMFTContent\\41_MSHDRef_Motion_DifDirect_01_1280x720p24f_h263_1100kbps.avi")
    END_TEST_METHOD()
 

    BEGIN_TEST_METHOD(ComplianceDecodeTest18)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"7ea4494b-5c7c-4269-8817-3136ea7f5989")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"99a78984-54ce-4516-a176-543fa16353e4")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"MPEG4 Decoder - HMFT compliance test 18")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"MPEG4 Decoder HMFT Compliance Test: InputType MPEG4 - Verifies IMFTransform for MPEG4 Decoder")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Streaming.HMFT.Decoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\HMFTContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the HMFT to test - {DETECT} should be used for certification, this can be overridden to test a specific HMFT")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\HMFTContent\\51_MSHDRef_Motion_FastCam_Action_03_1920x1080p24f_h263_2700kpbs.avi")
    END_TEST_METHOD()
 
    BEGIN_TEST_METHOD(ComplianceEnccodeTest30) 
        TEST_METHOD_PROPERTY(L"InputType",  L"RGB") 
        TEST_METHOD_PROPERTY(L"TestType",   L"Encoder") 
        TEST_METHOD_PROPERTY(L"ID",         L"30") 
        TEST_METHOD_PROPERTY(L"TestLevel",  L"3")
        TEST_METHOD_PROPERTY(L"TestLevel",  L"4")
    END_TEST_METHOD() 
 
    BEGIN_TEST_METHOD(ComplianceEnccodeTest31) 
        TEST_METHOD_PROPERTY(L"InputType",  L"RGB") 
        TEST_METHOD_PROPERTY(L"TestType",   L"Encoder") 
        TEST_METHOD_PROPERTY(L"ID",         L"31") 
        TEST_METHOD_PROPERTY(L"TestLevel",  L"3")
        TEST_METHOD_PROPERTY(L"TestLevel",  L"4")
    END_TEST_METHOD() 
 
    BEGIN_TEST_METHOD(ComplianceEnccodeTest32) 
        TEST_METHOD_PROPERTY(L"InputType",  L"RGB") 
        TEST_METHOD_PROPERTY(L"TestType",   L"Encoder") 
        TEST_METHOD_PROPERTY(L"ID",         L"32") 
        TEST_METHOD_PROPERTY(L"TestLevel",  L"3")
        TEST_METHOD_PROPERTY(L"TestLevel",  L"4")
    END_TEST_METHOD() 
 
    BEGIN_TEST_METHOD(ComplianceEnccodeTest33) 
        TEST_METHOD_PROPERTY(L"InputType",  L"RGB") 
        TEST_METHOD_PROPERTY(L"TestType",   L"Encoder") 
        TEST_METHOD_PROPERTY(L"ID",         L"33") 
        TEST_METHOD_PROPERTY(L"TestLevel",  L"3")
        TEST_METHOD_PROPERTY(L"TestLevel",  L"4")
    END_TEST_METHOD() 
 
    BEGIN_TEST_METHOD(ComplianceEnccodeTest34) 
        TEST_METHOD_PROPERTY(L"InputType",  L"RGB") 
        TEST_METHOD_PROPERTY(L"TestType",   L"Encoder") 
        TEST_METHOD_PROPERTY(L"ID",         L"34") 
        TEST_METHOD_PROPERTY(L"TestLevel",  L"3")
        TEST_METHOD_PROPERTY(L"TestLevel",  L"4")
    END_TEST_METHOD() 
 
    BEGIN_TEST_METHOD(ComplianceEnccodeTest35) 
        TEST_METHOD_PROPERTY(L"InputType",  L"YUV") 
        TEST_METHOD_PROPERTY(L"TestType",   L"Encoder") 
        TEST_METHOD_PROPERTY(L"ID",         L"35") 
        TEST_METHOD_PROPERTY(L"TestLevel",  L"3")
        TEST_METHOD_PROPERTY(L"TestLevel",  L"4")
    END_TEST_METHOD() 
 
    BEGIN_TEST_METHOD(ComplianceEnccodeTest36) 
        TEST_METHOD_PROPERTY(L"InputType",  L"YUV") 
        TEST_METHOD_PROPERTY(L"TestType",   L"Encoder") 
        TEST_METHOD_PROPERTY(L"ID",         L"36") 
        TEST_METHOD_PROPERTY(L"TestLevel",  L"3")
        TEST_METHOD_PROPERTY(L"TestLevel",  L"4")
    END_TEST_METHOD() 
 
    BEGIN_TEST_METHOD(ComplianceEnccodeTest37) 
        TEST_METHOD_PROPERTY(L"InputType",  L"YUV") 
        TEST_METHOD_PROPERTY(L"TestType",   L"Encoder") 
        TEST_METHOD_PROPERTY(L"ID",         L"37") 
        TEST_METHOD_PROPERTY(L"TestLevel",  L"3")
        TEST_METHOD_PROPERTY(L"TestLevel",  L"4")
    END_TEST_METHOD() 
 
    BEGIN_TEST_METHOD(ComplianceEnccodeTest38) 
        TEST_METHOD_PROPERTY(L"InputType",  L"YUV") 
        TEST_METHOD_PROPERTY(L"TestType",   L"Encoder") 
        TEST_METHOD_PROPERTY(L"ID",         L"38") 
        TEST_METHOD_PROPERTY(L"TestLevel",  L"3")
        TEST_METHOD_PROPERTY(L"TestLevel",  L"4")
    END_TEST_METHOD() 
 
    BEGIN_TEST_METHOD(ComplianceEnccodeTest39) 
        TEST_METHOD_PROPERTY(L"InputType",  L"YUV") 
        TEST_METHOD_PROPERTY(L"TestType",   L"Encoder") 
        TEST_METHOD_PROPERTY(L"ID",         L"39") 
        TEST_METHOD_PROPERTY(L"TestLevel",  L"3")
        TEST_METHOD_PROPERTY(L"TestLevel",  L"4")
    END_TEST_METHOD() 
 
    BEGIN_TEST_METHOD(ComplianceEnccodeTest40) 
        TEST_METHOD_PROPERTY(L"InputType",  L"YUV") 
        TEST_METHOD_PROPERTY(L"TestType",   L"Encoder") 
        TEST_METHOD_PROPERTY(L"ID",         L"40") 
        TEST_METHOD_PROPERTY(L"TestLevel",  L"3")
        TEST_METHOD_PROPERTY(L"TestLevel",  L"4")
    END_TEST_METHOD() 
 
    BEGIN_TEST_METHOD(ComplianceEnccodeTest41) 
        TEST_METHOD_PROPERTY(L"InputType",  L"YUV") 
        TEST_METHOD_PROPERTY(L"TestType",   L"Encoder") 
        TEST_METHOD_PROPERTY(L"ID",         L"41") 
        TEST_METHOD_PROPERTY(L"TestLevel",  L"3")
        TEST_METHOD_PROPERTY(L"TestLevel",  L"4")
    END_TEST_METHOD() 
 
    BEGIN_TEST_METHOD(ComplianceEnccodeTest42) 
        TEST_METHOD_PROPERTY(L"InputType",  L"YUV") 
        TEST_METHOD_PROPERTY(L"TestType",   L"Encoder") 
        TEST_METHOD_PROPERTY(L"ID",         L"42") 
        TEST_METHOD_PROPERTY(L"TestLevel",  L"3")
        TEST_METHOD_PROPERTY(L"TestLevel",  L"4")
    END_TEST_METHOD() 
 
    BEGIN_TEST_METHOD(ComplianceEnccodeTest43) 
        TEST_METHOD_PROPERTY(L"InputType",  L"YUV") 
        TEST_METHOD_PROPERTY(L"TestType",   L"Encoder") 
        TEST_METHOD_PROPERTY(L"ID",         L"43") 
        TEST_METHOD_PROPERTY(L"TestLevel",  L"3")
        TEST_METHOD_PROPERTY(L"TestLevel",  L"4")
    END_TEST_METHOD() 
 
    BEGIN_TEST_METHOD(ComplianceEnccodeTest44) 
        TEST_METHOD_PROPERTY(L"InputType",  L"YUV") 
        TEST_METHOD_PROPERTY(L"TestType",   L"Encoder") 
        TEST_METHOD_PROPERTY(L"ID",         L"44") 
        TEST_METHOD_PROPERTY(L"TestLevel",  L"3")
        TEST_METHOD_PROPERTY(L"TestLevel",  L"4")
    END_TEST_METHOD() 
 
    BEGIN_TEST_METHOD(ComplianceEnccodeTest45) 
        TEST_METHOD_PROPERTY(L"InputType",  L"YUV") 
        TEST_METHOD_PROPERTY(L"TestType",   L"Encoder") 
        TEST_METHOD_PROPERTY(L"ID",         L"45") 
        TEST_METHOD_PROPERTY(L"TestLevel",  L"3")
        TEST_METHOD_PROPERTY(L"TestLevel",  L"4")
    END_TEST_METHOD() 
 
    BEGIN_TEST_METHOD(ComplianceEnccodeTest46) 
        TEST_METHOD_PROPERTY(L"InputType",  L"YUV") 
        TEST_METHOD_PROPERTY(L"TestType",   L"Encoder") 
        TEST_METHOD_PROPERTY(L"ID",         L"46") 
        TEST_METHOD_PROPERTY(L"TestLevel",  L"3")
        TEST_METHOD_PROPERTY(L"TestLevel",  L"4")
    END_TEST_METHOD() 
 
    BEGIN_TEST_METHOD(ComplianceEnccodeTest47) 
        TEST_METHOD_PROPERTY(L"InputType",  L"YUY2") 
        TEST_METHOD_PROPERTY(L"TestType",   L"Encoder") 
        TEST_METHOD_PROPERTY(L"ID",         L"47") 
        TEST_METHOD_PROPERTY(L"TestLevel",  L"3")
        TEST_METHOD_PROPERTY(L"TestLevel",  L"4")
    END_TEST_METHOD() 
 
    BEGIN_TEST_METHOD(ComplianceEnccodeTest48) 
        TEST_METHOD_PROPERTY(L"InputType",  L"YUY2") 
        TEST_METHOD_PROPERTY(L"TestType",   L"Encoder") 
        TEST_METHOD_PROPERTY(L"ID",         L"48") 
        TEST_METHOD_PROPERTY(L"TestLevel",  L"3")
        TEST_METHOD_PROPERTY(L"TestLevel",  L"4")
    END_TEST_METHOD() 
 
    BEGIN_TEST_METHOD(ComplianceEnccodeTest49) 
        TEST_METHOD_PROPERTY(L"InputType",  L"YUY2") 
        TEST_METHOD_PROPERTY(L"TestType",   L"Encoder") 
        TEST_METHOD_PROPERTY(L"ID",         L"49") 
        TEST_METHOD_PROPERTY(L"TestLevel",  L"3")
        TEST_METHOD_PROPERTY(L"TestLevel",  L"4")
    END_TEST_METHOD() 

    BEGIN_TEST_METHOD(ComplianceEnccodeTest50) 
        TEST_METHOD_PROPERTY(L"InputType",  L"NV12") 
        TEST_METHOD_PROPERTY(L"TestType",   L"Encoder") 
        TEST_METHOD_PROPERTY(L"ID",         L"50") 
        TEST_METHOD_PROPERTY(L"TestLevel",  L"3")
        TEST_METHOD_PROPERTY(L"TestLevel",  L"4")
    END_TEST_METHOD() 

    BEGIN_TEST_METHOD(ComplianceEnccodeTest51) 
        TEST_METHOD_PROPERTY(L"InputType",  L"NV12") 
        TEST_METHOD_PROPERTY(L"TestType",   L"Encoder") 
        TEST_METHOD_PROPERTY(L"ID",         L"51") 
        TEST_METHOD_PROPERTY(L"DriverDrop", L"TRUE") 
        TEST_METHOD_PROPERTY(L"TestLevel",  L"1")
        TEST_METHOD_PROPERTY(L"TestLevel",  L"2")
        TEST_METHOD_PROPERTY(L"TestLevel",  L"4")
    END_TEST_METHOD() 

    BEGIN_TEST_METHOD(ComplianceEnccodeTest60) 
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"0D576CDB-46B2-3CF8-2F67-2BAAA01732B6")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"d936ac91-d4fa-40b8-98b8-1acc10069cab")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"MJPEG Encoder - HMFT compliance test 60")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"MJPEG Encoder HMFT Compliance Test: InputType MJPEG - Verifies IMFTransform for MPJEG")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Streaming.HMFT.Decoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\HMFTContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the HMFT to test - {DETECT} should be used for certification, this can be overridden to test a specific HMFT")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\HMFTContent\\22_AVI_MJPEG_1920x1080_44Mbps_2997_ADPCM_11025kHz.avi")
    END_TEST_METHOD() 

    BEGIN_TEST_METHOD(ComplianceEnccodeTest61) 
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"0EBD0C70-4FDA-DE6F-EB2A-E5AAE0AB2476")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"bcd5c43d-e2e4-43e7-9cf7-8f962ffbb939")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"MJPEG Decoder - HMFT compliance test 61")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"MJPEG Decoder HMFT Compliance Test: InputType MJPEG - Verifies IMFTransform for MPJEG")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Streaming.HMFT.Decoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\HMFTContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the HMFT to test - {DETECT} should be used for certification, this can be overridden to test a specific HMFT")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\HMFTContent\\24_AVI_MJPEG_1280x720_21800Kbps_2997_ADPCM_11025kHz.avi")
    END_TEST_METHOD() 

    BEGIN_TEST_METHOD(ComplianceEnccodeTest62) 
        TEST_METHOD_PROPERTY(L"InputType",  L"MJPEG") 
        TEST_METHOD_PROPERTY(L"TestType",   L"Decoder") 
        TEST_METHOD_PROPERTY(L"ID",         L"62") 
        TEST_METHOD_PROPERTY(L"TestLevel",  L"3")
        TEST_METHOD_PROPERTY(L"TestLevel",  L"4")
    END_TEST_METHOD() 
 
    BEGIN_TEST_METHOD(CustomXML)
        TEST_METHOD_PROPERTY(L"CustomXML", L"TRUE")
    END_TEST_METHOD()

protected:
    virtual HRESULT RunActualTest(const DWORD dwTestID, const GUID* pGUIDMFTUnderTest, const WCHAR* pszHWURL);
};

#endif //__MFTDiagTAEF_H__
