#pragma once
// File: DoublesDDivData.h

//////////////////////////////////////////////////////////////////////////
// Test data from here to the end.
//////////////////////////////////////////////////////////////////////////
#ifdef WGF11SHADER5X
CShader5xTest_DoubleArith::Binary64Vec2 const CShader5xTest_ddiv::s_DDivSrc0[] = 
#else
#ifdef CALCDOUBLES
dataLayout  s_DDivSrc0[] = 
#endif
#endif
{
	{ 0xFFF0000000000000ull, 0xFFF0000000000000ull },
	{ 0xBFF0000000000000ull, 0xBFF0000000000000ull },
	{ 0x7FF0000000000000ull, 0x7FF0000000000000ull },
	{ 0x7FFFCB8D9A5D4659ull, 0x7FFFCB8D9A5D4659ull },
	{ 0x8000000000000000ull, 0x8000000000000000ull },
	{ 0x0000000000000000ull, 0x0000000000000000ull },
	{ 0x0000000000000000ull, 0x0000000000000000ull },
	{ 0x8000000000000000ull, 0x8000000000000000ull },
	{ 0x7FF6B0586EF53833ull, 0x7FF6B0586EF53833ull },
	{ 0xE832B30C2F906709ull, 0xE832B30C2F906709ull },
	{ 0x7FF0000000000000ull, 0x7FF0000000000000ull },
	{ 0xD3DC7C4B89F05653ull, 0xD3DC7C4B89F05653ull },
	{ 0xFFF0000000000000ull, 0xFFF0000000000000ull },
	{ 0xC4DA8FD9E6AA3677ull, 0xC4DA8FD9E6AA3677ull },
	{ 0x7FF0000000000000ull, 0x7FF0000000000000ull },
	{ 0xC8CB013B39FB3E20ull, 0xC8CB013B39FB3E20ull },
	{ 0x7FF0000000000000ull, 0x7FF0000000000000ull },
	{ 0x5C01D1EEEABC7754ull, 0x5C01D1EEEABC7754ull },
	{ 0x41E21AD82491B346ull, 0x41E21AD82491B346ull },
	{ 0xFFF0000000000000ull, 0xFFF0000000000000ull },
	{ 0x7FF84E1BFCCABC0Bull, 0x7FF84E1BFCCABC0Bull },
	{ 0x0000000000000001ull, 0x0000000000000001ull },
	{ 0x7FF0000000000000ull, 0x7FF0000000000000ull },
	{ 0x8000000000000864ull, 0x8000000000000864ull },
	{ 0xFFF0000000000000ull, 0xFFF0000000000000ull },
	{ 0x800000000010DD88ull, 0x800000000010DD88ull },
	{ 0x7FF0000000000000ull, 0x7FF0000000000000ull },
	{ 0x800000000001F606ull, 0x800000000001F606ull },
	{ 0x7FF0000000000000ull, 0x7FF0000000000000ull },
	{ 0x0000046A7CD1A70Cull, 0x0000046A7CD1A70Cull },
	{ 0x000000000003952Full, 0x000000000003952Full },
	{ 0xFFF0000000000000ull, 0xFFF0000000000000ull },
	{ 0x0D0656509E98A510ull, 0x0D0656509E98A510ull },
	{ 0xCD4086C5BFCDA2BBull, 0xCD4086C5BFCDA2BBull },
	{ 0xE495B5F9B32EFE04ull, 0xE495B5F9B32EFE04ull },
	{ 0x3031A2686B267CF5ull, 0x3031A2686B267CF5ull },
	{ 0x0F381FC69ED1CCAEull, 0x0F381FC69ED1CCAEull },
	{ 0x744BABA648DF8839ull, 0x744BABA648DF8839ull },
	{ 0xDB9CAB673523DFAFull, 0xDB9CAB673523DFAFull },
	{ 0xE456D172A0AADA0Bull, 0xE456D172A0AADA0Bull },
	{ 0xCECA2AF0E92E414Dull, 0xCECA2AF0E92E414Dull },
	{ 0x1D8555184AB52152ull, 0x1D8555184AB52152ull },
	{ 0x9BFE5AC3AF82F4F2ull, 0x9BFE5AC3AF82F4F2ull },
	{ 0x873FBA508FDC665Bull, 0x873FBA508FDC665Bull },
	{ 0x1CA71232DE87B82Cull, 0x1CA71232DE87B82Cull },
	{ 0xCAFAF77E0A8ECB55ull, 0xCAFAF77E0A8ECB55ull },
	{ 0xC89572920CA8C32Dull, 0xC89572920CA8C32Dull },
	{ 0x4CB8A54B86514DD4ull, 0x4CB8A54B86514DD4ull },
	{ 0xADCB17E5F1B387CBull, 0xADCB17E5F1B387CBull },
	{ 0x22812F0EDF2E83D1ull, 0x22812F0EDF2E83D1ull },
	{ 0x686148F945D970FFull, 0x686148F945D970FFull },
	{ 0x8CD802AFE20D5EA7ull, 0x8CD802AFE20D5EA7ull },
	{ 0x9B1A2675A39AA4E8ull, 0x9B1A2675A39AA4E8ull },
	{ 0xEE29C0532D6FE815ull, 0xEE29C0532D6FE815ull },
	{ 0xE67BDC206518C2C8ull, 0xE67BDC206518C2C8ull },
	{ 0xC3746AE9109A05C0ull, 0xC3746AE9109A05C0ull },
	{ 0xE185D03B8651A483ull, 0xE185D03B8651A483ull },
	{ 0x9BC997A06BA03630ull, 0x9BC997A06BA03630ull },
	{ 0x119FD2EA83C21E25ull, 0x119FD2EA83C21E25ull },
	{ 0x908A9E7D8FDE51D1ull, 0x908A9E7D8FDE51D1ull },
	{ 0xE2034F7B3BB0BD5Aull, 0xE2034F7B3BB0BD5Aull },
	{ 0x3D4EC9751F564B72ull, 0x3D4EC9751F564B72ull },
	{ 0x9CBE7B72CC608975ull, 0x9CBE7B72CC608975ull },
	{ 0x37F3858AED76EF47ull, 0x37F3858AED76EF47ull },
	{ 0x619186BE756BC3EDull, 0x619186BE756BC3EDull },
	{ 0x08B69214DE0AA469ull, 0x08B69214DE0AA469ull },
	{ 0x1EE5CC0877C6A959ull, 0x1EE5CC0877C6A959ull },
	{ 0x21CA30A1C70E2BD2ull, 0x21CA30A1C70E2BD2ull },
	{ 0x891F0050F52A2E79ull, 0x891F0050F52A2E79ull },
	{ 0xD7E355A44E2F5FE3ull, 0xD7E355A44E2F5FE3ull },
	{ 0x92F6632AD066C32Full, 0x92F6632AD066C32Full },
	{ 0x59E1D801CAB3F561ull, 0x59E1D801CAB3F561ull },
	{ 0x657FEE9C8CDF1180ull, 0x657FEE9C8CDF1180ull },
	{ 0xA8D2A0E524C83AF1ull, 0xA8D2A0E524C83AF1ull },
	{ 0xD7D987252F6ABD15ull, 0xD7D987252F6ABD15ull },
	{ 0x103BDC35B5F5D8A2ull, 0x103BDC35B5F5D8A2ull },
	{ 0x67A42BE51DE123BEull, 0x67A42BE51DE123BEull },
	{ 0x9D83283228029261ull, 0x9D83283228029261ull },
	{ 0xB087266AFECC1CECull, 0xB087266AFECC1CECull },
	{ 0x18ADC56F56770404ull, 0x18ADC56F56770404ull },
	{ 0x649D3AA49A42B9B4ull, 0x649D3AA49A42B9B4ull },
	{ 0xFBCAC79B2D4D64C3ull, 0xFBCAC79B2D4D64C3ull },
	{ 0xC3FBD753B8AC06D1ull, 0xC3FBD753B8AC06D1ull },
	{ 0xEB3744238A0844B8ull, 0xEB3744238A0844B8ull },
	{ 0x1534454703E9C9A1ull, 0x1534454703E9C9A1ull },
	{ 0xAD9C83A11AF14EE4ull, 0xAD9C83A11AF14EE4ull },
	{ 0x9D1ED836E66B4124ull, 0x9D1ED836E66B4124ull },
	{ 0x23B830C63EC007ABull, 0x23B830C63EC007ABull },
	{ 0x96801E266C27E802ull, 0x96801E266C27E802ull },
	{ 0xC0DE88F1E6288ED4ull, 0xC0DE88F1E6288ED4ull },
	{ 0x2AC80F8821C23184ull, 0x2AC80F8821C23184ull },
	{ 0x82468BA672125B0Cull, 0x82468BA672125B0Cull },
	{ 0x695B3F86F5124B99ull, 0x695B3F86F5124B99ull },
	{ 0xE7902B6494F70163ull, 0xE7902B6494F70163ull },
	{ 0x3FF60B931498DDD0ull, 0x3FF60B931498DDD0ull },
	{ 0xEAB47D0A31A8ECCCull, 0xEAB47D0A31A8ECCCull },
	{ 0xF2B9CBD2D059C962ull, 0xF2B9CBD2D059C962ull },
	{ 0x77BFE7D53C82241Full, 0x77BFE7D53C82241Full },
	{ 0x93B402D778DEEA27ull, 0x93B402D778DEEA27ull },
	{ 0xE4F6558A9B7B0918ull, 0xE4F6558A9B7B0918ull },
	{ 0xFB8F8D763FA2D61Eull, 0xFB8F8D763FA2D61Eull },
	{ 0x6B11626103A915D7ull, 0x6B11626103A915D7ull },
	{ 0xC0DFD36517A39D68ull, 0xC0DFD36517A39D68ull },
	{ 0x9CF88D4FDCE59E5Full, 0x9CF88D4FDCE59E5Full },
	{ 0xB0B5F6DB949D88CBull, 0xB0B5F6DB949D88CBull },
	{ 0x5FB367621F5C921Aull, 0x5FB367621F5C921Aull },
	{ 0xC6500417CB6DDC32ull, 0xC6500417CB6DDC32ull },
	{ 0xE2B5C4CD340339D2ull, 0xE2B5C4CD340339D2ull },
	{ 0xA3322247315D95A9ull, 0xA3322247315D95A9ull },
	{ 0x9795EB6BD5B6F7B7ull, 0x9795EB6BD5B6F7B7ull },
	{ 0x8719C2F37D942C63ull, 0x8719C2F37D942C63ull },
	{ 0xAA2CC45CEEC408DDull, 0xAA2CC45CEEC408DDull },
	{ 0x47FAD21387725236ull, 0x47FAD21387725236ull },
	{ 0xF8800AA67C1443BDull, 0xF8800AA67C1443BDull },
	{ 0xCA16E66027D4B31Cull, 0xCA16E66027D4B31Cull },
	{ 0x8B167C7C6A85D932ull, 0x8B167C7C6A85D932ull },
	{ 0xF7EE70CD187EB532ull, 0xF7EE70CD187EB532ull },
	{ 0x0C8609AB78AA13FCull, 0x0C8609AB78AA13FCull },
	{ 0x3A4BECE5D42D36BAull, 0x3A4BECE5D42D36BAull },
	{ 0x419C0548152C183Eull, 0x419C0548152C183Eull },
	{ 0x700910AE7651529Bull, 0x700910AE7651529Bull },
	{ 0x818F54A140DFA501ull, 0x818F54A140DFA501ull },
	{ 0x668DFCC89C331C5Dull, 0x668DFCC89C331C5Dull },
	{ 0x2D9C9F976C77D3B1ull, 0x2D9C9F976C77D3B1ull },
	{ 0x513A6C3C42FC60B0ull, 0x513A6C3C42FC60B0ull },
	{ 0xA97C80175AA5D59Dull, 0xA97C80175AA5D59Dull },
	{ 0x41D8E464A96B68E4ull, 0x41D8E464A96B68E4ull },
	{ 0x52F3B358FE1FB8F9ull, 0x52F3B358FE1FB8F9ull },
	{ 0xA06BE5812FADB571ull, 0xA06BE5812FADB571ull },
	{ 0x7A3D48425B8F22DEull, 0x7A3D48425B8F22DEull },
	{ 0x23151A2A35E2C26Eull, 0x23151A2A35E2C26Eull },
	{ 0x59AED0EE67E81546ull, 0x59AED0EE67E81546ull },
	{ 0x46868749FE46C51Cull, 0x46868749FE46C51Cull },
	{ 0x8DD691B7E967A993ull, 0x8DD691B7E967A993ull },
	{ 0x454DBC798B456DDAull, 0x454DBC798B456DDAull },
	{ 0x108903A180F4A630ull, 0x108903A180F4A630ull },
	{ 0x2228688ABA0D284Bull, 0x2228688ABA0D284Bull },
	{ 0xC756919F03B751C7ull, 0xC756919F03B751C7ull },
	{ 0x5ED633E28AFF896Aull, 0x5ED633E28AFF896Aull },
	{ 0xAF5DB52C99080DEDull, 0xAF5DB52C99080DEDull },
	{ 0x993401669346FBD5ull, 0x993401669346FBD5ull },
	{ 0xAC32080F086BF294ull, 0xAC32080F086BF294ull },
	{ 0x612E61DFCF735C5Full, 0x612E61DFCF735C5Full },
	{ 0x37E09E26388D51D1ull, 0x37E09E26388D51D1ull },
	{ 0x78D1B88C4ADE21C1ull, 0x78D1B88C4ADE21C1ull },
	{ 0x5AC73602133E76DFull, 0x5AC73602133E76DFull },
	{ 0xCC9E6B2603011C15ull, 0xCC9E6B2603011C15ull },
	{ 0x233568FB6164669Cull, 0x233568FB6164669Cull },
	{ 0xEB07124DC675375Cull, 0xEB07124DC675375Cull },
	{ 0x9DF7DA30ADC9A289ull, 0x9DF7DA30ADC9A289ull },
	{ 0xFD08A87A13D9377Aull, 0xFD08A87A13D9377Aull },
	{ 0x4E2D67E72498E34Cull, 0x4E2D67E72498E34Cull },
	{ 0xBDBCBB09FBA07AB7ull, 0xBDBCBB09FBA07AB7ull },
	{ 0x24D65A8F727FDCAFull, 0x24D65A8F727FDCAFull },
	{ 0xF27599FBFF09BA3Eull, 0xF27599FBFF09BA3Eull },
	{ 0x799D956EA4B9FC20ull, 0x799D956EA4B9FC20ull },
	{ 0x62D48748F07DC920ull, 0x62D48748F07DC920ull },
	{ 0x823BC5CB0A432A32ull, 0x823BC5CB0A432A32ull },
	{ 0x50C9E802D2D65350ull, 0x50C9E802D2D65350ull },
	{ 0xCA9493FD12F28798ull, 0xCA9493FD12F28798ull },
	{ 0x705F7377BA8C9FA6ull, 0x705F7377BA8C9FA6ull },
	{ 0xAD1DD2242F7D302Full, 0xAD1DD2242F7D302Full },
	{ 0xDFEC6318AC904F5Eull, 0xDFEC6318AC904F5Eull },
	{ 0x4A00ADBFB160FA72ull, 0x4A00ADBFB160FA72ull },
	{ 0x0054DE0BAB773506ull, 0x0054DE0BAB773506ull },
	{ 0x0BDC0396BA6E9C58ull, 0x0BDC0396BA6E9C58ull },
	{ 0xE4E5D521D16F6A2Eull, 0xE4E5D521D16F6A2Eull },
	{ 0xD032645A7574FC85ull, 0xD032645A7574FC85ull },
	{ 0x3AF1EFDE58321DD6ull, 0x3AF1EFDE58321DD6ull },
	{ 0x6475E9A139A5C76Cull, 0x6475E9A139A5C76Cull },
	{ 0x6C03A4C8D52B8C8Aull, 0x6C03A4C8D52B8C8Aull },
	{ 0x826E29FDE18D9E3Dull, 0x826E29FDE18D9E3Dull },
	{ 0x7FD4B5C11F7E6F7Dull, 0x7FD4B5C11F7E6F7Dull },
	{ 0x9DCB5DE3787FFE0Bull, 0x9DCB5DE3787FFE0Bull },
	{ 0x147B5ED02E5EB705ull, 0x147B5ED02E5EB705ull },
	{ 0xDCB090E81A05FDCDull, 0xDCB090E81A05FDCDull },
	{ 0x5601867CFA94501Cull, 0x5601867CFA94501Cull },
	{ 0x8FA7D0ABD4350E61ull, 0x8FA7D0ABD4350E61ull },
	{ 0xF705EDA55E65DF5Full, 0xF705EDA55E65DF5Full },
	{ 0x29205D8384ADB906ull, 0x29205D8384ADB906ull },
	{ 0x2847601AF42B8511ull, 0x2847601AF42B8511ull },
	{ 0xB606DA27BAC264E0ull, 0xB606DA27BAC264E0ull },
	{ 0x90C9E3A3F7499A96ull, 0x90C9E3A3F7499A96ull },
	{ 0x55877C2796C60EF6ull, 0x55877C2796C60EF6ull },
	{ 0xC5B5E900251373FAull, 0xC5B5E900251373FAull },
	{ 0x30EA3B1FAA030FB5ull, 0x30EA3B1FAA030FB5ull },
	{ 0x42917B519AD61EEAull, 0x42917B519AD61EEAull },
	{ 0x73D90134D699DAECull, 0x73D90134D699DAECull },
	{ 0xE1236FE9B74B2238ull, 0xE1236FE9B74B2238ull },
	{ 0x442FDB732FC7BC4Full, 0x442FDB732FC7BC4Full },
	{ 0xD16096D9FAB340D9ull, 0xD16096D9FAB340D9ull },
	{ 0xBA072910D9D59B77ull, 0xBA072910D9D59B77ull },
	{ 0x1192EAC8E5193568ull, 0x1192EAC8E5193568ull },
	{ 0xD7C7CBD4E9AEB85Full, 0xD7C7CBD4E9AEB85Full },
	{ 0xE62AC0CAD8BC7622ull, 0xE62AC0CAD8BC7622ull },
	{ 0x0209580245DF6DE6ull, 0x0209580245DF6DE6ull },
	{ 0xD1E9F83EF7A3F2EAull, 0xD1E9F83EF7A3F2EAull },
	{ 0x77AA4486857BF0D2ull, 0x77AA4486857BF0D2ull },
	{ 0xC9C21AACD0AF1049ull, 0xC9C21AACD0AF1049ull },
	{ 0xD3BDA614C0B0F3D7ull, 0xD3BDA614C0B0F3D7ull },
	{ 0xB940B0EF65931200ull, 0xB940B0EF65931200ull },
	{ 0xB325252D3FE5DF6Dull, 0xB325252D3FE5DF6Dull },
	{ 0xE2168C2D42B6A2A0ull, 0xE2168C2D42B6A2A0ull },
	{ 0xBFFC78B36964EE5Full, 0xBFFC78B36964EE5Full },
	{ 0xBD87D404E8318353ull, 0xBD87D404E8318353ull },
	{ 0xB44B6CB95D5CAE17ull, 0xB44B6CB95D5CAE17ull },
	{ 0x537CBF1E8F8E1E7Bull, 0x537CBF1E8F8E1E7Bull },
	{ 0x26C2AB48332E9A79ull, 0x26C2AB48332E9A79ull },
	{ 0x392F3E88267DDDD1ull, 0x392F3E88267DDDD1ull },
	{ 0x4C9F5ABC89E2A0EEull, 0x4C9F5ABC89E2A0EEull },
	{ 0x980B44386E2E787Aull, 0x980B44386E2E787Aull },
	{ 0xA8D057D5926B60BEull, 0xA8D057D5926B60BEull },
	{ 0x2921683E33D8E1BEull, 0x2921683E33D8E1BEull },
	{ 0x48E342CDED5ED314ull, 0x48E342CDED5ED314ull },
	{ 0x0C22DDD8A51BC70Cull, 0x0C22DDD8A51BC70Cull },
	{ 0xBC6AADB68D150A81ull, 0xBC6AADB68D150A81ull },
	{ 0x3EA4A28430EE50F7ull, 0x3EA4A28430EE50F7ull },
	{ 0x0D2E4D95952EF3F8ull, 0x0D2E4D95952EF3F8ull },
	{ 0x14CCAE6B66BADFB2ull, 0x14CCAE6B66BADFB2ull },
	{ 0x3745296939451551ull, 0x3745296939451551ull },
	{ 0xB0A9241BD721D09Aull, 0xB0A9241BD721D09Aull },
	{ 0x2129CB2E9EFE4FC8ull, 0x2129CB2E9EFE4FC8ull },
	{ 0x7AD1807EF3E4382Bull, 0x7AD1807EF3E4382Bull },
	{ 0x93786F4CBC4E9DFEull, 0x93786F4CBC4E9DFEull },
	{ 0x9A11CB16F036A687ull, 0x9A11CB16F036A687ull },
	{ 0x30F73443389DD475ull, 0x30F73443389DD475ull },
	{ 0xEB5FC61F9F3BE5F5ull, 0xEB5FC61F9F3BE5F5ull },
	{ 0x6EE84BBD4C166195ull, 0x6EE84BBD4C166195ull },
	{ 0xF9DA1DF355E7B8DDull, 0xF9DA1DF355E7B8DDull },
	{ 0x771199D3CA099DCFull, 0x771199D3CA099DCFull },
	{ 0x32EC4B36F23F8C7Bull, 0x32EC4B36F23F8C7Bull },
	{ 0x4F38C18FB91BB182ull, 0x4F38C18FB91BB182ull },
	{ 0x9A71FF7A1EB2FCB5ull, 0x9A71FF7A1EB2FCB5ull },
	{ 0x18669CFA756823F1ull, 0x18669CFA756823F1ull },
	{ 0xC40EBBD75192D935ull, 0xC40EBBD75192D935ull },
	{ 0x309435BBC4EBAD4Bull, 0x309435BBC4EBAD4Bull },
	{ 0x20BAE9A40174EB25ull, 0x20BAE9A40174EB25ull },
	{ 0x43CE493809527CF6ull, 0x43CE493809527CF6ull },
	{ 0x1A79711248D805DDull, 0x1A79711248D805DDull },
	{ 0x363E7CF743D5F608ull, 0x363E7CF743D5F608ull },
	{ 0x7AB41DDDF697B5EFull, 0x7AB41DDDF697B5EFull },
	{ 0x8BADFE358286FA4Aull, 0x8BADFE358286FA4Aull },
	{ 0x74B59AA4D6D465A5ull, 0x74B59AA4D6D465A5ull },
	{ 0xC81A347C59360DB4ull, 0xC81A347C59360DB4ull },
	{ 0x6A453DE085020245ull, 0x6A453DE085020245ull },
	{ 0xE811ACAF83A3410Dull, 0xE811ACAF83A3410Dull },
	{ 0x17EB92B8540F45C0ull, 0x17EB92B8540F45C0ull },
	{ 0xD23AB2C1ADC42C90ull, 0xD23AB2C1ADC42C90ull },
	{ 0x34FE0A062463BA82ull, 0x34FE0A062463BA82ull },
	{ 0xF558DC9CA8474F38ull, 0xF558DC9CA8474F38ull },
	{ 0x6E9B05994FDFF37Eull, 0x6E9B05994FDFF37Eull },
	{ 0x742FB2F64880A78Bull, 0x742FB2F64880A78Bull },
	{ 0xA0E118A0F6CFABDCull, 0xA0E118A0F6CFABDCull },
	{ 0x6C9DCDE873809749ull, 0x6C9DCDE873809749ull },
	{ 0x7F915A2DFFD182B1ull, 0x7F915A2DFFD182B1ull },
	{ 0xFE8B2790E6B38F2Bull, 0xFE8B2790E6B38F2Bull },
	{ 0x5A1E5A13B876409Bull, 0x5A1E5A13B876409Bull },
	{ 0xE86BA14D0DB41B92ull, 0xE86BA14D0DB41B92ull },
	{ 0x656104FE7CAEC455ull, 0x656104FE7CAEC455ull },
	{ 0xB1FB764119C75624ull, 0xB1FB764119C75624ull },
	{ 0xD31DBC6106E31A96ull, 0xD31DBC6106E31A96ull },
	{ 0xEDBAD34B070702EEull, 0xEDBAD34B070702EEull },
	{ 0x5BF138C752D5CEF5ull, 0x5BF138C752D5CEF5ull },
	{ 0x1981459591B01554ull, 0x1981459591B01554ull },
	{ 0xA0D5A73BB6BA1CC9ull, 0xA0D5A73BB6BA1CC9ull },
	{ 0x1D8E06CAE2777E52ull, 0x1D8E06CAE2777E52ull },
	{ 0x17A20B7A4D90F028ull, 0x17A20B7A4D90F028ull },
	{ 0xAC123A01B0831FC2ull, 0xAC123A01B0831FC2ull },
	{ 0x062508FA61FF5587ull, 0x062508FA61FF5587ull },
	{ 0x956DEA6E6C7EA5D2ull, 0x956DEA6E6C7EA5D2ull },
	{ 0x3524DEF38EE841DFull, 0x3524DEF38EE841DFull },
	{ 0x109110B739A41B95ull, 0x109110B739A41B95ull },
	{ 0xAFA088F477C0C6D6ull, 0xAFA088F477C0C6D6ull },
	{ 0x874B0772C833DC4Bull, 0x874B0772C833DC4Bull },
	{ 0x0F857A572D095695ull, 0x0F857A572D095695ull },
	{ 0x8273A2F1EA3DE141ull, 0x8273A2F1EA3DE141ull },
	{ 0x30C2F6E01088B548ull, 0x30C2F6E01088B548ull },
	{ 0x9EC3733AF4D76AF0ull, 0x9EC3733AF4D76AF0ull },
	{ 0xA307F43A40FA1860ull, 0xA307F43A40FA1860ull },
	{ 0xB93727E544874311ull, 0xB93727E544874311ull },
	{ 0x908144EDF2AD272Bull, 0x908144EDF2AD272Bull },
	{ 0x867AEEC6459C1FDCull, 0x867AEEC6459C1FDCull },
	{ 0x0766459B4204F603ull, 0x0766459B4204F603ull },
	{ 0x9CCA42EBD0420960ull, 0x9CCA42EBD0420960ull },
	{ 0x01AF7DE61D6AA0F3ull, 0x01AF7DE61D6AA0F3ull },
	{ 0x092A6042A29F6B74ull, 0x092A6042A29F6B74ull },
	{ 0x2E166E5978AF4C8Aull, 0x2E166E5978AF4C8Aull },
	{ 0x8DC4C6306650CCA2ull, 0x8DC4C6306650CCA2ull },
	{ 0x29FAED8F94B315AFull, 0x29FAED8F94B315AFull },
	{ 0x3EA43EA36EDE13DBull, 0x3EA43EA36EDE13DBull },
	{ 0x3DF4A1254BC39F3Bull, 0x3DF4A1254BC39F3Bull },
	{ 0x2B7872920351F0DDull, 0x2B7872920351F0DDull },
	{ 0x291B9A45DCF9EB89ull, 0x291B9A45DCF9EB89ull },
	{ 0x9BC1CBCB76FB7689ull, 0x9BC1CBCB76FB7689ull },
	{ 0x988B5C3356CF8688ull, 0x988B5C3356CF8688ull },
	{ 0x9CBDC1D48CCB5298ull, 0x9CBDC1D48CCB5298ull },
	{ 0x2EE8BF113D6CAFF0ull, 0x2EE8BF113D6CAFF0ull },
	{ 0x2D0B61CECC718F06ull, 0x2D0B61CECC718F06ull },
	{ 0xA04DD83CDB215AB2ull, 0xA04DD83CDB215AB2ull },
	{ 0x1D6C0D7AF4738E71ull, 0x1D6C0D7AF4738E71ull },
	{ 0x0F47D6A0F1C6C223ull, 0x0F47D6A0F1C6C223ull },
	{ 0x8B10730F409ACBCFull, 0x8B10730F409ACBCFull },
	{ 0xA242B764DA359BB5ull, 0xA242B764DA359BB5ull },
	{ 0xAC1D739FC69D5265ull, 0xAC1D739FC69D5265ull },
	{ 0x1E48D4713E29B904ull, 0x1E48D4713E29B904ull },
	{ 0x8928DA0FFD93A904ull, 0x8928DA0FFD93A904ull },
	{ 0x157A18B4A28F3E13ull, 0x157A18B4A28F3E13ull },
	{ 0x2D7EC387F143684Dull, 0x2D7EC387F143684Dull },
	{ 0xB803631FCA59ED4Dull, 0xB803631FCA59ED4Dull },
	{ 0x322066949217508Aull, 0x322066949217508Aull },
	{ 0x1250AD333C9C6706ull, 0x1250AD333C9C6706ull },
	{ 0x8B108A35C6A396DFull, 0x8B108A35C6A396DFull },
	{ 0x2EF43E040FF04664ull, 0x2EF43E040FF04664ull },
	{ 0x32B0D1341ABE44D3ull, 0x32B0D1341ABE44D3ull },
	{ 0x88F67E7CFCD88E17ull, 0x88F67E7CFCD88E17ull },
	{ 0x83B0E75F4AEB3EC7ull, 0x83B0E75F4AEB3EC7ull },
	{ 0x09FA75E61E4AEF54ull, 0x09FA75E61E4AEF54ull },
	{ 0x08D1F3AE8A374265ull, 0x08D1F3AE8A374265ull },
	{ 0x0F4E517FE97993DDull, 0x0F4E517FE97993DDull },
	{ 0xAD2ADB544AD754CAull, 0xAD2ADB544AD754CAull },
	{ 0x2A712F723AFF42E6ull, 0x2A712F723AFF42E6ull },
	{ 0x8C643811D763E9BFull, 0x8C643811D763E9BFull },
	{ 0x3863BF66257C4457ull, 0x3863BF66257C4457ull },
	{ 0x866D8A46C1C1D47Bull, 0x866D8A46C1C1D47Bull },
	{ 0x23BB139BDC035FDDull, 0x23BB139BDC035FDDull },
	{ 0x8F9364142920EED8ull, 0x8F9364142920EED8ull },
	{ 0x8FB99FDEE0A6BF63ull, 0x8FB99FDEE0A6BF63ull },
	{ 0x29FBE990A5859B0Eull, 0x29FBE990A5859B0Eull },
	{ 0x290D7305C10C752Aull, 0x290D7305C10C752Aull },
	{ 0xA5AE85DA92E0A914ull, 0xA5AE85DA92E0A914ull },
	{ 0x8000000000000577ull, 0x8000000000000577ull },
	{ 0x00000000019AA91Aull, 0x00000000019AA91Aull },
	{ 0x00000000000016DFull, 0x00000000000016DFull },
	{ 0x00000000000000DBull, 0x00000000000000DBull },
	{ 0x80000E0838C74EBBull, 0x80000E0838C74EBBull },
	{ 0x8000000000000077ull, 0x8000000000000077ull },
	{ 0x800000000001141Eull, 0x800000000001141Eull },
	{ 0x800006E9F26ECD66ull, 0x800006E9F26ECD66ull },
	{ 0x0000000003AD81A9ull, 0x0000000003AD81A9ull },
	{ 0x80000000042FB495ull, 0x80000000042FB495ull },
	{ 0x8000E0AFD45E2CD3ull, 0x8000E0AFD45E2CD3ull },
	{ 0x80000000000000E4ull, 0x80000000000000E4ull },
	{ 0x8000000076E98EA1ull, 0x8000000076E98EA1ull },
	{ 0x0000000000000067ull, 0x0000000000000067ull },
	{ 0x8000000000000005ull, 0x8000000000000005ull },
	{ 0x800000000809CDE6ull, 0x800000000809CDE6ull },
	{ 0x000000000647D91Eull, 0x000000000647D91Eull },
	{ 0x0000000000091640ull, 0x0000000000091640ull },
	{ 0x00003FEE414FECA7ull, 0x00003FEE414FECA7ull },
	{ 0x8000000006CC636Aull, 0x8000000006CC636Aull },
	{ 0x00000000001F7C97ull, 0x00000000001F7C97ull },
	{ 0x8000000000000003ull, 0x8000000000000003ull },
	{ 0x8000065F8EA9A9A8ull, 0x8000065F8EA9A9A8ull },
	{ 0x00000000000012D6ull, 0x00000000000012D6ull },
	{ 0x8000000000452189ull, 0x8000000000452189ull },
	{ 0x00040D69802EC1E3ull, 0x00040D69802EC1E3ull },
	{ 0x0000000000691F70ull, 0x0000000000691F70ull },
	{ 0x8000001AD0E5C0F8ull, 0x8000001AD0E5C0F8ull },
	{ 0x000003166F733F57ull, 0x000003166F733F57ull },
	{ 0x0000001B88B3E173ull, 0x0000001B88B3E173ull },
	{ 0x0000000000000A37ull, 0x0000000000000A37ull },
	{ 0x000000000000004Eull, 0x000000000000004Eull },
	{ 0x0000001EC97A5624ull, 0x0000001EC97A5624ull },
	{ 0x000000904BC6BC0Full, 0x000000904BC6BC0Full },
	{ 0x80000000022356E1ull, 0x80000000022356E1ull },
	{ 0x00000002EC6DFD11ull, 0x00000002EC6DFD11ull },
	{ 0x00000000003AB52Full, 0x00000000003AB52Full },
	{ 0x800000008C301BACull, 0x800000008C301BACull },
	{ 0x800000000009A17Dull, 0x800000000009A17Dull },
	{ 0x000000294549A362ull, 0x000000294549A362ull },
	{ 0x8000000000000001ull, 0x8000000000000001ull },
	{ 0x00000027E5601BC9ull, 0x00000027E5601BC9ull },
	{ 0x80079436665C3B0Cull, 0x80079436665C3B0Cull },
	{ 0x8000000000000027ull, 0x8000000000000027ull },
	{ 0x8000000000000017ull, 0x8000000000000017ull },
	{ 0x800000000703979Full, 0x800000000703979Full },
	{ 0x0003FD127856072Dull, 0x0003FD127856072Dull },
	{ 0x0005A2E3841F0467ull, 0x0005A2E3841F0467ull },
	{ 0x8000000000000260ull, 0x8000000000000260ull },
	{ 0x0000000000000449ull, 0x0000000000000449ull },
	{ 0x800000000009DA43ull, 0x800000000009DA43ull },
	{ 0x0000000000DE491Full, 0x0000000000DE491Full },
	{ 0x000000178325FADBull, 0x000000178325FADBull },
	{ 0x800000000009F6CDull, 0x800000000009F6CDull },
	{ 0x0000196A650713E9ull, 0x0000196A650713E9ull },
	{ 0x8000000000662662ull, 0x8000000000662662ull },
	{ 0x8000001BB7ACCC93ull, 0x8000001BB7ACCC93ull },
	{ 0x0000000000000B5Aull, 0x0000000000000B5Aull },
	{ 0x8000000004BD89F2ull, 0x8000000004BD89F2ull },
	{ 0x0000007534319DA4ull, 0x0000007534319DA4ull },
	{ 0x800000C625EFEFD9ull, 0x800000C625EFEFD9ull },
	{ 0x0000000016E1994Full, 0x0000000016E1994Full },
	{ 0x0000000325B9AE76ull, 0x0000000325B9AE76ull },
	{ 0x800000000002DA23ull, 0x800000000002DA23ull },
	{ 0x0000000000164488ull, 0x0000000000164488ull },
	{ 0x80000000000A2119ull, 0x80000000000A2119ull },
	{ 0x000000057BD92A6Dull, 0x000000057BD92A6Dull },
	{ 0x80000C63B951CF29ull, 0x80000C63B951CF29ull },
	{ 0x00077C19CA25C7B8ull, 0x00077C19CA25C7B8ull },
	{ 0x000000000DEC9159ull, 0x000000000DEC9159ull },
	{ 0x80000000000000FAull, 0x80000000000000FAull },
	{ 0x8000003D783DAA21ull, 0x8000003D783DAA21ull },
	{ 0x00000000000000A8ull, 0x00000000000000A8ull },
	{ 0x00000000000001E6ull, 0x00000000000001E6ull },
	{ 0x8005C64DD3F7D2CFull, 0x8005C64DD3F7D2CFull },
	{ 0x000000000000066Dull, 0x000000000000066Dull },
	{ 0x00000000000578AAull, 0x00000000000578AAull },
	{ 0x0000000000A3F965ull, 0x0000000000A3F965ull },
	{ 0x800000000B90DE02ull, 0x800000000B90DE02ull },
	{ 0x8000000000004F30ull, 0x8000000000004F30ull },
	{ 0x000002A306F5B15Aull, 0x000002A306F5B15Aull },
	{ 0x80000000000001E0ull, 0x80000000000001E0ull },
	{ 0x80000000000003A8ull, 0x80000000000003A8ull },
	{ 0x8000000000000007ull, 0x8000000000000007ull },
	{ 0x8000000001B61B74ull, 0x8000000001B61B74ull },
	{ 0x800012E84E0D05CFull, 0x800012E84E0D05CFull },
	{ 0x000000000000004Cull, 0x000000000000004Cull },
	{ 0x800017CEC12E1ADAull, 0x800017CEC12E1ADAull },
	{ 0x80000000000032F4ull, 0x80000000000032F4ull },
	{ 0x0000000000001890ull, 0x0000000000001890ull },
	{ 0x000000000000005Dull, 0x000000000000005Dull },
	{ 0x0000000FBB08DA4Dull, 0x0000000FBB08DA4Dull },
	{ 0x000000000000001Full, 0x000000000000001Full },
	{ 0x8000011CFD8B298Dull, 0x8000011CFD8B298Dull },
	{ 0x80000000007CD81Dull, 0x80000000007CD81Dull },
	{ 0x8000000000BD86E9ull, 0x8000000000BD86E9ull },
	{ 0x000000000CEEBF9Eull, 0x000000000CEEBF9Eull },
	{ 0x8000EB4C1D1E4BD7ull, 0x8000EB4C1D1E4BD7ull },
	{ 0x80000000000001C7ull, 0x80000000000001C7ull },
	{ 0x80000000000000CAull, 0x80000000000000CAull },
	{ 0x4026BF0356F867C5ull, 0x4026BF0356F867C5ull },
	{ 0x5731EAC77A63F5E1ull, 0x5731EAC77A63F5E1ull },
	{ 0xA94CF7C3C3FC1107ull, 0xA94CF7C3C3FC1107ull },
	{ 0x7C5B900A6282944Eull, 0x7C5B900A6282944Eull },
	{ 0x1B715EFABF9A824Full, 0x1B715EFABF9A824Full },
	{ 0xB4BFDE1AABE8EE49ull, 0xB4BFDE1AABE8EE49ull },
	{ 0xDAC94BB09EEF8176ull, 0xDAC94BB09EEF8176ull },
	{ 0xEAB6474E06C69FABull, 0xEAB6474E06C69FABull },
	{ 0x15A397C8A6BD2F36ull, 0x15A397C8A6BD2F36ull },
	{ 0xCEB598B20543FE74ull, 0xCEB598B20543FE74ull },
	{ 0xDCA6CFABED2AC730ull, 0xDCA6CFABED2AC730ull },
	{ 0x4F8F29E8FA14D9C3ull, 0x4F8F29E8FA14D9C3ull },
	{ 0x1A996218396B5DE8ull, 0x1A996218396B5DE8ull },
	{ 0x12140D0AD8B33B60ull, 0x12140D0AD8B33B60ull },
	{ 0x8CB3D032E3CCA0C6ull, 0x8CB3D032E3CCA0C6ull },
	{ 0xE9A43E6A15C22733ull, 0xE9A43E6A15C22733ull },
	{ 0xBA4CDDFFB5ED9995ull, 0xBA4CDDFFB5ED9995ull },
	{ 0x4FC7D57C87985B4Cull, 0x4FC7D57C87985B4Cull },
	{ 0xECFFC1BBC95D6B06ull, 0xECFFC1BBC95D6B06ull },
	{ 0xDC12334844330E5Cull, 0xDC12334844330E5Cull },
	{ 0xA89C541C69A211ACull, 0xA89C541C69A211ACull },
	{ 0x3CBF34348390B2B8ull, 0x3CBF34348390B2B8ull },
	{ 0x23514071F327247Full, 0x23514071F327247Full },
	{ 0x2DCA5EDE7EB3B45Bull, 0x2DCA5EDE7EB3B45Bull },
	{ 0xBD80348EB294935Bull, 0xBD80348EB294935Bull },
	{ 0xF1D013F24ECD3862ull, 0xF1D013F24ECD3862ull },
	{ 0x79CC10D1C68D6900ull, 0x79CC10D1C68D6900ull },
	{ 0x4998BF27CF0FDE90ull, 0x4998BF27CF0FDE90ull },
	{ 0x74E117F5FE568B12ull, 0x74E117F5FE568B12ull },
	{ 0x6C1E06C37AEA80CAull, 0x6C1E06C37AEA80CAull },
	{ 0x5E271F44BA257799ull, 0x5E271F44BA257799ull },
	{ 0x7E89FB1B4F2AF29Aull, 0x7E89FB1B4F2AF29Aull },
	{ 0xEEDDBE8CCAD70700ull, 0xEEDDBE8CCAD70700ull },
	{ 0x0C70473FA988C1AEull, 0x0C70473FA988C1AEull },
	{ 0xD193926345DDB0F3ull, 0xD193926345DDB0F3ull },
	{ 0x82EE31BB8FA7BAE1ull, 0x82EE31BB8FA7BAE1ull },
	{ 0x01D113AACBF6FAA5ull, 0x01D113AACBF6FAA5ull },
	{ 0xA8D8049EF2F5BF1Cull, 0xA8D8049EF2F5BF1Cull },
	{ 0x5EB4FF4D8DFB99D6ull, 0x5EB4FF4D8DFB99D6ull },
	{ 0x18DF66FB76E07C32ull, 0x18DF66FB76E07C32ull },
	{ 0xC60AC05CDC538896ull, 0xC60AC05CDC538896ull },
	{ 0x849F93431B314AF1ull, 0x849F93431B314AF1ull },
	{ 0x5A2E1C589554AAFDull, 0x5A2E1C589554AAFDull },
	{ 0x6F77E5731AA08636ull, 0x6F77E5731AA08636ull },
	{ 0x8FD1C813DD37E699ull, 0x8FD1C813DD37E699ull },
	{ 0xAD27D6FBFA3AD421ull, 0xAD27D6FBFA3AD421ull },
	{ 0xA7B4AECC907DCF7Eull, 0xA7B4AECC907DCF7Eull },
	{ 0x19A5B0796711E397ull, 0x19A5B0796711E397ull },
	{ 0x66FDA20525136043ull, 0x66FDA20525136043ull },
	{ 0x511F38CE17D52D42ull, 0x511F38CE17D52D42ull },
	{ 0xCEC10A028A5EC081ull, 0xCEC10A028A5EC081ull },
	{ 0x67D46563AC12B50Full, 0x67D46563AC12B50Full },
	{ 0x54D0958E08340059ull, 0x54D0958E08340059ull },
	{ 0xA2BC0A2E8C1FC7ADull, 0xA2BC0A2E8C1FC7ADull },
	{ 0x1AD4E99B1F71D8EEull, 0x1AD4E99B1F71D8EEull },
	{ 0x2E828995C969BC93ull, 0x2E828995C969BC93ull },
	{ 0x26E151D169C66F65ull, 0x26E151D169C66F65ull },
	{ 0xD882849EFEAEB4F8ull, 0xD882849EFEAEB4F8ull },
	{ 0x1B41709A7ADC10E9ull, 0x1B41709A7ADC10E9ull },
	{ 0xC6178A7E2EDE5B5Aull, 0xC6178A7E2EDE5B5Aull },
	{ 0xEE90EE53BE6DF6ABull, 0xEE90EE53BE6DF6ABull },
	{ 0xACFAC949A722A5FAull, 0xACFAC949A722A5FAull },
	{ 0x239D2A6458C502DCull, 0x239D2A6458C502DCull },
	{ 0x0AF9BD51DC50935Cull, 0x0AF9BD51DC50935Cull },
	{ 0x0150EA9708DC80B4ull, 0x0150EA9708DC80B4ull },
	{ 0x5E66E1BD4D00ECC9ull, 0x5E66E1BD4D00ECC9ull },
	{ 0xCB2A0AB8052EE76Cull, 0xCB2A0AB8052EE76Cull },
	{ 0xDDA45FA86151054Full, 0xDDA45FA86151054Full },
	{ 0xF8992DB6DDAA96C5ull, 0xF8992DB6DDAA96C5ull },
	{ 0xAF58BF2948CB7ABEull, 0xAF58BF2948CB7ABEull },
	{ 0xED7B6CAC5B4E9882ull, 0xED7B6CAC5B4E9882ull },
	{ 0xA27D96B7DDB8F3ABull, 0xA27D96B7DDB8F3ABull },
	{ 0x31CE0724602F61E8ull, 0x31CE0724602F61E8ull },
	{ 0x66383B3981D8E16Full, 0x66383B3981D8E16Full },
	{ 0x29EC13ABC7238FC2ull, 0x29EC13ABC7238FC2ull },
	{ 0x41FC6FF100C23F27ull, 0x41FC6FF100C23F27ull },
	{ 0xCE562E824418ABE1ull, 0xCE562E824418ABE1ull },
	{ 0x4D7916F26FAC5233ull, 0x4D7916F26FAC5233ull },
	{ 0xE3F42B10440FE696ull, 0xE3F42B10440FE696ull },
	{ 0x289EE0BB0B1F69B9ull, 0x289EE0BB0B1F69B9ull },
	{ 0x33C0C2E0CD42DDB9ull, 0x33C0C2E0CD42DDB9ull },
	{ 0xB370FBED1A0D9EA1ull, 0xB370FBED1A0D9EA1ull },
	{ 0x430F465F5EB056A4ull, 0x430F465F5EB056A4ull },
	{ 0xC6AFC64FCC139498ull, 0xC6AFC64FCC139498ull },
	{ 0x8B6B4BD9CF9101B6ull, 0x8B6B4BD9CF9101B6ull },
	{ 0x6ACD7B9319213810ull, 0x6ACD7B9319213810ull },
	{ 0xB29260A631F43952ull, 0xB29260A631F43952ull },
	{ 0x90BCE637A30A813Cull, 0x90BCE637A30A813Cull },
	{ 0xC2B7B88CAEC4C0DFull, 0xC2B7B88CAEC4C0DFull },
	{ 0xC9BA0F3A94403097ull, 0xC9BA0F3A94403097ull },
	{ 0xE201DDB569B587C8ull, 0xE201DDB569B587C8ull },
	{ 0x7F2CEDC5807091DCull, 0x7F2CEDC5807091DCull },
	{ 0x8B22609A5E56657Bull, 0x8B22609A5E56657Bull },
	{ 0xAAC618024390390Cull, 0xAAC618024390390Cull },
	{ 0xC4D7889D41D0DBEDull, 0xC4D7889D41D0DBEDull },
	{ 0x0E657272E38AC6EEull, 0x0E657272E38AC6EEull },
	{ 0xDA380321624CD712ull, 0xDA380321624CD712ull },
	{ 0xEC5ADFAD6E9BA308ull, 0xEC5ADFAD6E9BA308ull },
	{ 0x927894C9867D6EE7ull, 0x927894C9867D6EE7ull },
	{ 0xBEF0F17BDC4EC229ull, 0xBEF0F17BDC4EC229ull },
	{ 0x693BC7D9CE55A16Aull, 0x693BC7D9CE55A16Aull },
	{ 0x70F1977FED2960E1ull, 0x70F1977FED2960E1ull },
	{ 0xC64B9DBD92E51A1Eull, 0xC64B9DBD92E51A1Eull },
	{ 0xE0DD24951366BAC6ull, 0xE0DD24951366BAC6ull },
	{ 0xD885CA8755BF0A3Bull, 0xD885CA8755BF0A3Bull },
	{ 0xD0A98367B7E0CD80ull, 0xD0A98367B7E0CD80ull },
	{ 0x628A38DE8216EE43ull, 0x628A38DE8216EE43ull },
	{ 0xEE0779C9C946D5A3ull, 0xEE0779C9C946D5A3ull },
	{ 0xDDE46A93B48C5373ull, 0xDDE46A93B48C5373ull },
	{ 0xCBF1AC78030620C7ull, 0xCBF1AC78030620C7ull },
	{ 0xE6956EE915EE452Aull, 0xE6956EE915EE452Aull },
	{ 0xBEE64665728260D7ull, 0xBEE64665728260D7ull },
	{ 0x5832BA5E355E76EEull, 0x5832BA5E355E76EEull },
	{ 0x73101B92BE052042ull, 0x73101B92BE052042ull },
	{ 0xF96B634F6E5D2408ull, 0xF96B634F6E5D2408ull },
	{ 0x4D55F4B9ADA07924ull, 0x4D55F4B9ADA07924ull },
	{ 0xF5D3398CB112FEA0ull, 0xF5D3398CB112FEA0ull },
	{ 0x4D9D4D225F927085ull, 0x4D9D4D225F927085ull },
	{ 0xC9145248B4921E2Cull, 0xC9145248B4921E2Cull },
	{ 0xD0F7D3347D48F240ull, 0xD0F7D3347D48F240ull },
	{ 0x564B69C07045E06Cull, 0x564B69C07045E06Cull },
	{ 0x473EBFC3656D0DDAull, 0x473EBFC3656D0DDAull },
	{ 0xC2AE3E7C0AAFDD99ull, 0xC2AE3E7C0AAFDD99ull },
	{ 0xDE4DA255E451150Full, 0xDE4DA255E451150Full },
	{ 0xF46E0307A03672CBull, 0xF46E0307A03672CBull },
	{ 0x706DDF3B3F5FC491ull, 0x706DDF3B3F5FC491ull },
	{ 0xF62D0F3990E8F2F1ull, 0xF62D0F3990E8F2F1ull },
	{ 0x5F370A3334B4D6F5ull, 0x5F370A3334B4D6F5ull },
	{ 0xDEDB7B16F675FE4Bull, 0xDEDB7B16F675FE4Bull },
	{ 0xC767A54395CCB230ull, 0xC767A54395CCB230ull },
	{ 0xFFA383F1ACEDAEDFull, 0xFFA383F1ACEDAEDFull },
	{ 0xC90FC949FA590B99ull, 0xC90FC949FA590B99ull },
	{ 0xFB8A3CDF58112983ull, 0xFB8A3CDF58112983ull },
	{ 0x4DDE446CD7657FDBull, 0x4DDE446CD7657FDBull },
	{ 0xD25125C9F6327D65ull, 0xD25125C9F6327D65ull },
	{ 0x6E8AF6B982E2A296ull, 0x6E8AF6B982E2A296ull },
	{ 0xD62EA9846EDF2C74ull, 0xD62EA9846EDF2C74ull },
	{ 0xE3916B19EA5B8D4Eull, 0xE3916B19EA5B8D4Eull },
	{ 0xC498520D50DB02E2ull, 0xC498520D50DB02E2ull },
	{ 0xEC8679FD45DD4B45ull, 0xEC8679FD45DD4B45ull },
	{ 0xF127C7B286460CCDull, 0xF127C7B286460CCDull },
	{ 0x5CBE7683430C3EAEull, 0x5CBE7683430C3EAEull },
	{ 0x474E813A26C1D146ull, 0x474E813A26C1D146ull },
	{ 0x525BE4EC9CEA240Dull, 0x525BE4EC9CEA240Dull },
	{ 0xEE3FF96E1B3B1766ull, 0xEE3FF96E1B3B1766ull },
	{ 0x5EA5F89205021DF1ull, 0x5EA5F89205021DF1ull },
	{ 0x5FF17D224E8FE580ull, 0x5FF17D224E8FE580ull },
	{ 0xFAE64FA96720A609ull, 0xFAE64FA96720A609ull },
	{ 0xC22E4A0A05CFBD96ull, 0xC22E4A0A05CFBD96ull },
	{ 0xF94A45915247B969ull, 0xF94A45915247B969ull },
	{ 0x542C9DA625CB06FEull, 0x542C9DA625CB06FEull },
	{ 0x78FEFECABB3C7BC3ull, 0x78FEFECABB3C7BC3ull },
	{ 0x75F5130C14823391ull, 0x75F5130C14823391ull },
	{ 0x41ABE3BB886C2F7Eull, 0x41ABE3BB886C2F7Eull },
	{ 0xCA39BA3FB5034D0Eull, 0xCA39BA3FB5034D0Eull },
	{ 0xDCC3EBF91511ED46ull, 0xDCC3EBF91511ED46ull },
	{ 0xC1020D60B9A19F87ull, 0xC1020D60B9A19F87ull },
	{ 0x604813F0772D342Cull, 0x604813F0772D342Cull },
	{ 0x7E7329A8A20780CDull, 0x7E7329A8A20780CDull },
	{ 0x7AD701B575789B95ull, 0x7AD701B575789B95ull },
	{ 0xE7B8B199360AF504ull, 0xE7B8B199360AF504ull },
	{ 0x5CCD5E0B1AC9586Eull, 0x5CCD5E0B1AC9586Eull },
	{ 0x6B6700373276F3E3ull, 0x6B6700373276F3E3ull },
	{ 0xE4721246C3FCF499ull, 0xE4721246C3FCF499ull },
	{ 0xD4587E8C662B8263ull, 0xD4587E8C662B8263ull },
	{ 0x5AB5308508CB9A61ull, 0x5AB5308508CB9A61ull },
	{ 0xE2D6C84034C38FF4ull, 0xE2D6C84034C38FF4ull },
	{ 0xFF66CDE1CD5C603Bull, 0xFF66CDE1CD5C603Bull },
	{ 0xE70E2A1D39487DEDull, 0xE70E2A1D39487DEDull },
	{ 0x67BF2390DE8D050Full, 0x67BF2390DE8D050Full },
	{ 0x5EFD24DE7B4EE176ull, 0x5EFD24DE7B4EE176ull },
	{ 0xCC9B2B7FD22B8276ull, 0xCC9B2B7FD22B8276ull },
	{ 0x59169E07206518A6ull, 0x59169E07206518A6ull },
	{ 0xF7D9F076614DD8C7ull, 0xF7D9F076614DD8C7ull },
	{ 0xD9EDA9B65669AFFEull, 0xD9EDA9B65669AFFEull },
	{ 0xE29E164B573E7E71ull, 0xE29E164B573E7E71ull },
	{ 0x6955ABDD425332E8ull, 0x6955ABDD425332E8ull },
	{ 0xF8857F3FA63A2D68ull, 0xF8857F3FA63A2D68ull },
	{ 0xE03F7CFE9CC64D73ull, 0xE03F7CFE9CC64D73ull },
	{ 0xD5A613217D28040Full, 0xD5A613217D28040Full },
	{ 0xE1B2FE96142FFA0Full, 0xE1B2FE96142FFA0Full },
	{ 0x7C12C4614614ACEAull, 0x7C12C4614614ACEAull },
	{ 0x753FBEF9F104D070ull, 0x753FBEF9F104D070ull },
	{ 0x5728DB4545EA3A4Dull, 0x5728DB4545EA3A4Dull },
	{ 0xC26785A364F1B0A8ull, 0xC26785A364F1B0A8ull },
	{ 0x57DF294305F53F8Bull, 0x57DF294305F53F8Bull },
	{ 0x7DC56607D2BD3622ull, 0x7DC56607D2BD3622ull },
	{ 0xBEA4181B1C083CFEull, 0xBEA4181B1C083CFEull },
	{ 0x55B4BC0BDE1DF551ull, 0x55B4BC0BDE1DF551ull },
	{ 0x40F452F21553E4CEull, 0x40F452F21553E4CEull },
	{ 0x65A4A5962D9C6280ull, 0x65A4A5962D9C6280ull },
	{ 0xD0B9C7AFE5C0B53Cull, 0xD0B9C7AFE5C0B53Cull },
	{ 0x5F4A2F375E723FCBull, 0x5F4A2F375E723FCBull },
	{ 0x61FF03B1B8B802B6ull, 0x61FF03B1B8B802B6ull },
	{ 0xE2E72311CE047965ull, 0xE2E72311CE047965ull },
	{ 0xFB6D6C11A1F82829ull, 0xFB6D6C11A1F82829ull },
	{ 0x6F7486E66CCC9CA4ull, 0x6F7486E66CCC9CA4ull },
	{ 0xF9DE1E7C3D034CA1ull, 0xF9DE1E7C3D034CA1ull },
	{ 0x59FC147EDFCAF23Bull, 0x59FC147EDFCAF23Bull },
	{ 0xE55D31D6A5D10764ull, 0xE55D31D6A5D10764ull },
	{ 0x561C657510C8A3C2ull, 0x561C657510C8A3C2ull },
	{ 0x6C204F028161801Full, 0x6C204F028161801Full },
	{ 0x525C93BF4B242676ull, 0x525C93BF4B242676ull },
	{ 0xE1DC679EDEAD4F0Dull, 0xE1DC679EDEAD4F0Dull },
	{ 0xD5121E5F28A1C467ull, 0xD5121E5F28A1C467ull },
	{ 0x641663B37CD9F29Eull, 0x641663B37CD9F29Eull },
	{ 0x5A246BF6DF89E653ull, 0x5A246BF6DF89E653ull },
	{ 0x560F0431615809A9ull, 0x560F0431615809A9ull },
	{ 0x4158191AFD0FA9FFull, 0x4158191AFD0FA9FFull },
	{ 0xEBDF2A30E89E1A5Bull, 0xEBDF2A30E89E1A5Bull },
	{ 0xE2ECFC1E02E53977ull, 0xE2ECFC1E02E53977ull },
	{ 0x66FAA6A09047D893ull, 0x66FAA6A09047D893ull },
	{ 0x6C2DE479A1CA3A51ull, 0x6C2DE479A1CA3A51ull },
	{ 0x7A1835FC39256CAAull, 0x7A1835FC39256CAAull },
	{ 0x7DDF8732428B4D54ull, 0x7DDF8732428B4D54ull },
	{ 0xBD4E64F75275212Cull, 0xBD4E64F75275212Cull },
	{ 0xF1F07BEC85FD5AF7ull, 0xF1F07BEC85FD5AF7ull },
	{ 0xE2027F5ED5FFB8C1ull, 0xE2027F5ED5FFB8C1ull },
	{ 0x56B3E8007523E8E2ull, 0x56B3E8007523E8E2ull },
	{ 0xCF45CCEA86946600ull, 0xCF45CCEA86946600ull },
	{ 0x669F8E0B12C16C04ull, 0x669F8E0B12C16C04ull },
	{ 0xEFA0B731CE473A42ull, 0xEFA0B731CE473A42ull },
	{ 0x64B4A0474A0764D6ull, 0x64B4A0474A0764D6ull },
	{ 0xF63F7C63DEDD4F60ull, 0xF63F7C63DEDD4F60ull },
	{ 0xF956A6AEA48AF864ull, 0xF956A6AEA48AF864ull },
	{ 0xC6DF8DCB1797F51Eull, 0xC6DF8DCB1797F51Eull },
	{ 0x44FB34BCE7BA792Full, 0x44FB34BCE7BA792Full },
	{ 0xE434A7C5ACDDAADEull, 0xE434A7C5ACDDAADEull },
	{ 0x744403E34B4028EAull, 0x744403E34B4028EAull },
	{ 0x7063A91AA76D3FA5ull, 0x7063A91AA76D3FA5ull },
	{ 0x51DDC38747A4A4A7ull, 0x51DDC38747A4A4A7ull },
	{ 0x7F2AA641A7240793ull, 0x7F2AA641A7240793ull },
	{ 0xE5C90541F4ABE953ull, 0xE5C90541F4ABE953ull },
	{ 0xFD041C15CDB16A86ull, 0xFD041C15CDB16A86ull },
	{ 0x7B59226BACD26BD1ull, 0x7B59226BACD26BD1ull },
	{ 0xFDC7C411EF478F00ull, 0xFDC7C411EF478F00ull },
	{ 0xC84C8C9D804FEFD2ull, 0xC84C8C9D804FEFD2ull },
	{ 0x66B5CBB2214841D8ull, 0x66B5CBB2214841D8ull },
	{ 0x5D7DD5C4D62B1E94ull, 0x5D7DD5C4D62B1E94ull },
	{ 0xCC3D0335521DCB4Eull, 0xCC3D0335521DCB4Eull },
	{ 0xF9C9D2C87DF2A9F7ull, 0xF9C9D2C87DF2A9F7ull },
	{ 0xCAE48FEEA8277985ull, 0xCAE48FEEA8277985ull },
	{ 0x5F85A15A611FB9C1ull, 0x5F85A15A611FB9C1ull },
	{ 0x4EB6B37DC36550D7ull, 0x4EB6B37DC36550D7ull },
	{ 0x3F289E18A1AFDF1Aull, 0x3F289E18A1AFDF1Aull },
	{ 0xBF06165AA740DCFBull, 0xBF06165AA740DCFBull },
	{ 0xBF767BB8EF44AA92ull, 0xBF767BB8EF44AA92ull },
	{ 0x40BD43D97FF8FFC8ull, 0x40BD43D97FF8FFC8ull },
	{ 0xBFF51F86FE8E0666ull, 0xBFF51F86FE8E0666ull },
	{ 0x41A3507967F099E8ull, 0x41A3507967F099E8ull },
	{ 0x4032F3605EA7AC02ull, 0x4032F3605EA7AC02ull },
	{ 0xBE02564B6BF4E8CEull, 0xBE02564B6BF4E8CEull },
	{ 0x419E614614796E09ull, 0x419E614614796E09ull },
	{ 0xC185872FEB645D04ull, 0xC185872FEB645D04ull },
	{ 0x41965237E43324B1ull, 0x41965237E43324B1ull },
	{ 0xC132E312671922DDull, 0xC132E312671922DDull },
	{ 0xC133B4EDB5C91857ull, 0xC133B4EDB5C91857ull },
	{ 0xC16CF6A35D67653Cull, 0xC16CF6A35D67653Cull },
	{ 0xBF1E90A593E4885Aull, 0xBF1E90A593E4885Aull },
	{ 0xC06B9C86B5EA02D4ull, 0xC06B9C86B5EA02D4ull },
	{ 0x406070BC60E28520ull, 0x406070BC60E28520ull },
	{ 0x3F4DC21BBD58A3C3ull, 0x3F4DC21BBD58A3C3ull },
	{ 0xBD8A35164F235552ull, 0xBD8A35164F235552ull },
	{ 0xBF4B0C04AE2486E2ull, 0xBF4B0C04AE2486E2ull },
	{ 0xC0D426430941AD7Cull, 0xC0D426430941AD7Cull },
	{ 0xC1ADBBA5FBB0ECB4ull, 0xC1ADBBA5FBB0ECB4ull },
	{ 0x3F977F46CA0D9E1Aull, 0x3F977F46CA0D9E1Aull },
	{ 0x3DD472A604EA4D2Eull, 0x3DD472A604EA4D2Eull },
	{ 0xC00435589B0BCA47ull, 0xC00435589B0BCA47ull },
	{ 0x40790523EBDC03B4ull, 0x40790523EBDC03B4ull },
	{ 0xBEDA5FF81963E67Dull, 0xBEDA5FF81963E67Dull },
	{ 0x402C94D819B88801ull, 0x402C94D819B88801ull },
	{ 0xC0455326F394C1DAull, 0xC0455326F394C1DAull },
	{ 0xBD88CCC5301B88ADull, 0xBD88CCC5301B88ADull },
	{ 0xC12E5C3D14C1E52Bull, 0xC12E5C3D14C1E52Bull },
	{ 0xC032E9056B3D2D6Cull, 0xC032E9056B3D2D6Cull },
	{ 0xBF30D65C29149628ull, 0xBF30D65C29149628ull },
	{ 0xC0FBE08BF5B25F1Bull, 0xC0FBE08BF5B25F1Bull },
	{ 0xBE777221F7B2E5F8ull, 0xBE777221F7B2E5F8ull },
	{ 0xC00EF624CB86FD00ull, 0xC00EF624CB86FD00ull },
	{ 0xBEC54A28C04962AEull, 0xBEC54A28C04962AEull },
	{ 0x3EFB46489CC5637Bull, 0x3EFB46489CC5637Bull },
	{ 0x3DEA660C6744AC0Eull, 0x3DEA660C6744AC0Eull },
	{ 0x412F96B8550AA78Bull, 0x412F96B8550AA78Bull },
	{ 0x3F690B80764C83FEull, 0x3F690B80764C83FEull },
	{ 0xBF04E61EFE3B1AB0ull, 0xBF04E61EFE3B1AB0ull },
	{ 0x3EF784FB0D7B108Aull, 0x3EF784FB0D7B108Aull },
	{ 0x403CC3F4ACF23746ull, 0x403CC3F4ACF23746ull },
	{ 0xC0F747DD03F7D9F2ull, 0xC0F747DD03F7D9F2ull },
	{ 0x42B77776AD205D81ull, 0x42B77776AD205D81ull },
	{ 0x40B0EEFBB624FD36ull, 0x40B0EEFBB624FD36ull },
	{ 0xBEF2D08D3A50014Cull, 0xBEF2D08D3A50014Cull },
	{ 0xC213852329BE50CDull, 0xC213852329BE50CDull },
	{ 0x3EC0AE0ABA5FAE97ull, 0x3EC0AE0ABA5FAE97ull },
	{ 0x3EA1582CD5FE1C5Cull, 0x3EA1582CD5FE1C5Cull },
	{ 0x3DF0B43ACB08A4A2ull, 0x3DF0B43ACB08A4A2ull },
	{ 0xBE41D02F50F331BFull, 0xBE41D02F50F331BFull },
	{ 0x3EE2C177A96A996Aull, 0x3EE2C177A96A996Aull },
	{ 0x3EF8624F5188E138ull, 0x3EF8624F5188E138ull },
	{ 0x40FBBF3089420BD5ull, 0x40FBBF3089420BD5ull },
	{ 0xBFED582445C334E4ull, 0xBFED582445C334E4ull },
	{ 0xC06FC6B624CA7677ull, 0xC06FC6B624CA7677ull },
	{ 0x3F3B4353F3465843ull, 0x3F3B4353F3465843ull },
	{ 0x41FAB0D72028B92Cull, 0x41FAB0D72028B92Cull },
	{ 0xBE78AA2EB7BDC220ull, 0xBE78AA2EB7BDC220ull },
	{ 0x3E58A02D943A972Aull, 0x3E58A02D943A972Aull },
	{ 0x3FA364C8EEB6340Full, 0x3FA364C8EEB6340Full },
	{ 0xBEDD907A8FEF2101ull, 0xBEDD907A8FEF2101ull },
	{ 0x3FBF577DBB6D5851ull, 0x3FBF577DBB6D5851ull },
	{ 0xC012A93FB2BB358Cull, 0xC012A93FB2BB358Cull },
	{ 0xC056EB1E2C22B27Full, 0xC056EB1E2C22B27Full },
	{ 0x3DD67C0EA84EDA6Dull, 0x3DD67C0EA84EDA6Dull },
	{ 0x3F5A684E606F01ACull, 0x3F5A684E606F01ACull },
	{ 0x41965733EB58825Cull, 0x41965733EB58825Cull },
	{ 0x3E9AE49223437A0Bull, 0x3E9AE49223437A0Bull },
	{ 0x3E254545CAE545F1ull, 0x3E254545CAE545F1ull },
	{ 0x3EAE10E1883B9B3Full, 0x3EAE10E1883B9B3Full },
	{ 0x41273A5CA7BBE316ull, 0x41273A5CA7BBE316ull },
	{ 0xC15E08060E17AB18ull, 0xC15E08060E17AB18ull },
	{ 0x429A2FC5C1234AE9ull, 0x429A2FC5C1234AE9ull },
	{ 0xBFE80AE42C518FD4ull, 0xBFE80AE42C518FD4ull },
	{ 0xC19F4E9EB8CDC189ull, 0xC19F4E9EB8CDC189ull },
	{ 0xC1C1F6AC26C8E2E0ull, 0xC1C1F6AC26C8E2E0ull },
	{ 0x4196D9684CD2B901ull, 0x4196D9684CD2B901ull },
	{ 0xC198A91B066A1F74ull, 0xC198A91B066A1F74ull },
	{ 0x404BEFF34F7C3469ull, 0x404BEFF34F7C3469ull },
	{ 0x424E7D801E002E84ull, 0x424E7D801E002E84ull },
	{ 0x3FFF4378646DBF40ull, 0x3FFF4378646DBF40ull },
	{ 0x432371000126C62Dull, 0x432371000126C62Dull },
	{ 0x42C81855ABD2867Cull, 0x42C81855ABD2867Cull },
	{ 0xC203C961494F59A4ull, 0xC203C961494F59A4ull },
	{ 0x4119A9619C53D7D3ull, 0x4119A9619C53D7D3ull },
	{ 0x420F6FF230DCDF9Dull, 0x420F6FF230DCDF9Dull },
	{ 0x42B9475551391AA4ull, 0x42B9475551391AA4ull },
	{ 0x8000000000001058ull, 0x8000000000001058ull },
	{ 0x000000000050F83Dull, 0x000000000050F83Dull },
	{ 0x800000000000000Aull, 0x800000000000000Aull },
	{ 0x000000000097CB65ull, 0x000000000097CB65ull },
	{ 0x8003AD9E4E2C68AAull, 0x8003AD9E4E2C68AAull },
	{ 0x0000000000000114ull, 0x0000000000000114ull },
	{ 0x0000000000000082ull, 0x0000000000000082ull },
	{ 0x800000000000000Eull, 0x800000000000000Eull },
	{ 0x0000000000AE5B26ull, 0x0000000000AE5B26ull },
	{ 0x0000000000018F36ull, 0x0000000000018F36ull },
	{ 0x00062F3A0E6049D1ull, 0x00062F3A0E6049D1ull },
	{ 0x0000000FEBFCBD2Bull, 0x0000000FEBFCBD2Bull },
	{ 0x800000000000B0F4ull, 0x800000000000B0F4ull },
	{ 0x8000FF49301F91E6ull, 0x8000FF49301F91E6ull },
	{ 0x0000000000000005ull, 0x0000000000000005ull },
	{ 0x00000000000B3D34ull, 0x00000000000B3D34ull },
	{ 0x0002884DCB6A28D0ull, 0x0002884DCB6A28D0ull },
	{ 0x8000000086D75388ull, 0x8000000086D75388ull },
	{ 0x8000000000019AABull, 0x8000000000019AABull },
	{ 0x800000000000000Full, 0x800000000000000Full },
	{ 0x800000005D13055Aull, 0x800000005D13055Aull },
	{ 0x8000000000000A52ull, 0x8000000000000A52ull },
	{ 0x8006A50E14E6275Cull, 0x8006A50E14E6275Cull },
	{ 0x00000013CC323849ull, 0x00000013CC323849ull },
	{ 0x800000003A5926F6ull, 0x800000003A5926F6ull },
	{ 0x80000000C05AA880ull, 0x80000000C05AA880ull },
	{ 0x00000002E4E75B57ull, 0x00000002E4E75B57ull },
	{ 0x80000000000868F7ull, 0x80000000000868F7ull },
	{ 0x800000101F75E560ull, 0x800000101F75E560ull },
	{ 0x8000000FB29654AEull, 0x8000000FB29654AEull },
	{ 0x0000000003AE70EFull, 0x0000000003AE70EFull },
	{ 0x000000002E1D4635ull, 0x000000002E1D4635ull },
	{ 0x0000000000002EA5ull, 0x0000000000002EA5ull },
	{ 0x00000039CF4B90F1ull, 0x00000039CF4B90F1ull },
	{ 0x8000000000000ECEull, 0x8000000000000ECEull },
	{ 0x8000000091BBBEE7ull, 0x8000000091BBBEE7ull },
	{ 0x000000000000130Cull, 0x000000000000130Cull },
	{ 0x8000000608235BD7ull, 0x8000000608235BD7ull },
	{ 0x00003184C1A4A0A2ull, 0x00003184C1A4A0A2ull },
	{ 0x00000000002CDCF2ull, 0x00000000002CDCF2ull },
	{ 0x800003146049E5C6ull, 0x800003146049E5C6ull },
	{ 0x00000003CFBA48B2ull, 0x00000003CFBA48B2ull },
	{ 0x0000000000BE41DCull, 0x0000000000BE41DCull },
	{ 0x000011A84A2BCA65ull, 0x000011A84A2BCA65ull },
	{ 0x00000000001CF732ull, 0x00000000001CF732ull },
	{ 0x8000000054231040ull, 0x8000000054231040ull },
	{ 0x00001D62BDC79D4Cull, 0x00001D62BDC79D4Cull },
	{ 0x80000000003341A3ull, 0x80000000003341A3ull },
	{ 0x0000008061EE394Bull, 0x0000008061EE394Bull },
	{ 0x8000000045074245ull, 0x8000000045074245ull },
	{ 0x00000000ACE9F1C6ull, 0x00000000ACE9F1C6ull },
	{ 0x80000079E6B5D83Bull, 0x80000079E6B5D83Bull },
	{ 0x80000000000001D1ull, 0x80000000000001D1ull },
	{ 0x0000000000000001ull, 0x0000000000000001ull },
	{ 0x0000000000000619ull, 0x0000000000000619ull },
	{ 0x800047AB8CE3AF3Cull, 0x800047AB8CE3AF3Cull },
	{ 0x8000000000000F54ull, 0x8000000000000F54ull },
	{ 0x8000000017F27C04ull, 0x8000000017F27C04ull },
	{ 0x0000000000000003ull, 0x0000000000000003ull },
	{ 0x80000000002B016Eull, 0x80000000002B016Eull },
	{ 0x8000000004AE73BDull, 0x8000000004AE73BDull },
	{ 0x80000000006CBDBDull, 0x80000000006CBDBDull },
	{ 0x000000000001D495ull, 0x000000000001D495ull },
	{ 0x800000000002FDFEull, 0x800000000002FDFEull },
	{ 0x80004C2A63AD6F60ull, 0x80004C2A63AD6F60ull },
	{ 0x800000E7AB819760ull, 0x800000E7AB819760ull },
	{ 0x800000000000003Bull, 0x800000000000003Bull },
	{ 0x000000000015C42Bull, 0x000000000015C42Bull },
	{ 0x80007297231CF225ull, 0x80007297231CF225ull },
	{ 0x0002DEF0CE737634ull, 0x0002DEF0CE737634ull },
	{ 0x00000000000A5257ull, 0x00000000000A5257ull },
	{ 0x80000000000002D5ull, 0x80000000000002D5ull },
	{ 0x0000000000000002ull, 0x0000000000000002ull },
	{ 0x00000110978FFB5Aull, 0x00000110978FFB5Aull },
	{ 0x80000000119F9C16ull, 0x80000000119F9C16ull },
	{ 0x8000000000000D95ull, 0x8000000000000D95ull },
	{ 0x0000000000020F1Aull, 0x0000000000020F1Aull },
	{ 0x0004759D65CB393Full, 0x0004759D65CB393Full },
	{ 0x000000DC65A8F3A4ull, 0x000000DC65A8F3A4ull },
	{ 0x0000000000003CE0ull, 0x0000000000003CE0ull },
	{ 0x00000000000545C0ull, 0x00000000000545C0ull },
	{ 0x80000000000B4AA7ull, 0x80000000000B4AA7ull },
	{ 0x80000C1C29FBF2A4ull, 0x80000C1C29FBF2A4ull },
	{ 0x0000000000000101ull, 0x0000000000000101ull },
	{ 0x800000000000B988ull, 0x800000000000B988ull },
	{ 0x00000000000F472Eull, 0x00000000000F472Eull },
	{ 0x00000F72229BA88Full, 0x00000F72229BA88Full },
	{ 0x0000000000000017ull, 0x0000000000000017ull },
	{ 0x800000000006917Dull, 0x800000000006917Dull },
	{ 0x8000000000000434ull, 0x8000000000000434ull },
	{ 0x000147C7612E0C02ull, 0x000147C7612E0C02ull },
	{ 0x0001C79F104A2318ull, 0x0001C79F104A2318ull },
	{ 0x8000000000000421ull, 0x8000000000000421ull },
	{ 0x8000002519BA8E13ull, 0x8000002519BA8E13ull },
	{ 0x000000000128FF95ull, 0x000000000128FF95ull },
	{ 0x800000003BBBF9E5ull, 0x800000003BBBF9E5ull },
	{ 0x000000003C7F1656ull, 0x000000003C7F1656ull },
	{ 0x0000000001EAEEF8ull, 0x0000000001EAEEF8ull },
	{ 0x8001E8D05885A92Full, 0x8001E8D05885A92Full },
	{ 0x0000000000000006ull, 0x0000000000000006ull },
	{ 0x8000000091DF26AFull, 0x8000000091DF26AFull },
	{ 0x8000000000001528ull, 0x8000000000001528ull },
	{ 0x8000003A8F0FDF30ull, 0x8000003A8F0FDF30ull },
	{ 0x80000006A40E1255ull, 0x80000006A40E1255ull },
	{ 0x0000000000000024ull, 0x0000000000000024ull },
	{ 0x00000000000001F4ull, 0x00000000000001F4ull },
	{ 0x0000000B806A3587ull, 0x0000000B806A3587ull },
	{ 0x8000000000000003ull, 0x8000000000000003ull },
	{ 0x0000000347FB5DC9ull, 0x0000000347FB5DC9ull },
	{ 0x000001CDC24DC993ull, 0x000001CDC24DC993ull },
	{ 0x80000000028C911Dull, 0x80000000028C911Dull },
	{ 0x800000000014477Eull, 0x800000000014477Eull },
	{ 0x00000000000000DDull, 0x00000000000000DDull },
	{ 0x00000000001EDEAFull, 0x00000000001EDEAFull },
	{ 0x800000FA3C6917C8ull, 0x800000FA3C6917C8ull },
	{ 0x000000000D5ADDF0ull, 0x000000000D5ADDF0ull },
	{ 0x8000000007E79B4Dull, 0x8000000007E79B4Dull },
	{ 0x0000000029CF4577ull, 0x0000000029CF4577ull },
	{ 0x8000000000064989ull, 0x8000000000064989ull },
	{ 0x80000000000008ABull, 0x80000000000008ABull },
	{ 0x0000000000000011ull, 0x0000000000000011ull },
	{ 0x800064E47E4A645Cull, 0x800064E47E4A645Cull },
	{ 0x000000011E9CF0E1ull, 0x000000011E9CF0E1ull },
	{ 0x800000000000C05Bull, 0x800000000000C05Bull },
	{ 0x0000000000063B96ull, 0x0000000000063B96ull },
	{ 0x0000003DE9B12B6Aull, 0x0000003DE9B12B6Aull },
	{ 0x800000001083F4FFull, 0x800000001083F4FFull },
	{ 0x8000000065DEFB5Aull, 0x8000000065DEFB5Aull },
	{ 0x8000000000000003ull, 0x8000000000000003ull },
	{ 0x0000009F05571856ull, 0x0000009F05571856ull },
	{ 0x000000000000000Bull, 0x000000000000000Bull },
	{ 0x8000A5460CAD01EFull, 0x8000A5460CAD01EFull },
	{ 0x0000000000000072ull, 0x0000000000000072ull },
	{ 0x800000000527E7DEull, 0x800000000527E7DEull },
	{ 0x8000000000000008ull, 0x8000000000000008ull },
	{ 0x0000000025F9E344ull, 0x0000000025F9E344ull },
	{ 0x800000FD042E7F20ull, 0x800000FD042E7F20ull },
	{ 0x8000C5B5B8FF361Cull, 0x8000C5B5B8FF361Cull },
	{ 0x800000000000134Eull, 0x800000000000134Eull },
	{ 0x000000000001ABCFull, 0x000000000001ABCFull },
	{ 0x000000000048F264ull, 0x000000000048F264ull },
	{ 0x8000000EBDCC278Dull, 0x8000000EBDCC278Dull },
	{ 0x800000000894599Bull, 0x800000000894599Bull },
	{ 0x8000000000000B98ull, 0x8000000000000B98ull },
	{ 0x8000000000000001ull, 0x8000000000000001ull },
	{ 0x8000000000001ED1ull, 0x8000000000001ED1ull },
	{ 0x000E28DEB65085A2ull, 0x000E28DEB65085A2ull },
	{ 0x0000000000000010ull, 0x0000000000000010ull },
	{ 0x000000001862A486ull, 0x000000001862A486ull },
	{ 0x8000000000000001ull, 0x8000000000000001ull },
	{ 0x80000026EBF55E0Eull, 0x80000026EBF55E0Eull },
	{ 0x8000002CF4CE690Full, 0x8000002CF4CE690Full },
	{ 0x000000000000000Aull, 0x000000000000000Aull },
	{ 0x000000000000009Dull, 0x000000000000009Dull },
	{ 0x8000000001B5067Full, 0x8000000001B5067Full },
	{ 0x8000000000000040ull, 0x8000000000000040ull },
	{ 0x00000360E398A24Aull, 0x00000360E398A24Aull },
	{ 0x8001E1B744C35CF8ull, 0x8001E1B744C35CF8ull },
	{ 0x00000AEC565498D6ull, 0x00000AEC565498D6ull },
	{ 0x8000C7045CE11540ull, 0x8000C7045CE11540ull },
	{ 0x0004D69E48478331ull, 0x0004D69E48478331ull },
	{ 0x800038093BED09B4ull, 0x800038093BED09B4ull },
	{ 0x800000001C9A020Eull, 0x800000001C9A020Eull },
	{ 0x0000000038E5B692ull, 0x0000000038E5B692ull },
	{ 0x80008996EAE46244ull, 0x80008996EAE46244ull },
	{ 0x8000000000000076ull, 0x8000000000000076ull },
	{ 0x80000000B8B5DFE8ull, 0x80000000B8B5DFE8ull },
	{ 0x800000ABB5659344ull, 0x800000ABB5659344ull },
	{ 0x0000000072D98434ull, 0x0000000072D98434ull },
	{ 0x8000000000B24F2Cull, 0x8000000000B24F2Cull },
	{ 0x00000570A0046D88ull, 0x00000570A0046D88ull },
	{ 0x800001E5128BA2A0ull, 0x800001E5128BA2A0ull },
	{ 0x00000000061A55E3ull, 0x00000000061A55E3ull },
	{ 0x800001A5A659D8BBull, 0x800001A5A659D8BBull },
	{ 0x80000000041536C7ull, 0x80000000041536C7ull },
	{ 0x8000000BF13A1E90ull, 0x8000000BF13A1E90ull },
	{ 0x00000000003A6A78ull, 0x00000000003A6A78ull },
	{ 0x000000000000003Cull, 0x000000000000003Cull },
	{ 0x0000000000000029ull, 0x0000000000000029ull },
	{ 0x000000003F5DC697ull, 0x000000003F5DC697ull },
	{ 0x000000000002E7FDull, 0x000000000002E7FDull },
	{ 0x000000C9AB739315ull, 0x000000C9AB739315ull },
	{ 0x8000000DDCFBBBB6ull, 0x8000000DDCFBBBB6ull },
	{ 0x0000000000000007ull, 0x0000000000000007ull },
	{ 0x000000012B65BF42ull, 0x000000012B65BF42ull },
	{ 0x800000000103FF2Full, 0x800000000103FF2Full },
	{ 0x00000000012E4E62ull, 0x00000000012E4E62ull },
	{ 0x00000000000324C0ull, 0x00000000000324C0ull },
	{ 0x8000005EE1B5988Full, 0x8000005EE1B5988Full },
	{ 0x0000000000000275ull, 0x0000000000000275ull },
	{ 0x00000000010DDEC9ull, 0x00000000010DDEC9ull },
	{ 0x8000000000000015ull, 0x8000000000000015ull },
	{ 0x0000000000000C9Dull, 0x0000000000000C9Dull },
	{ 0x000000000012B528ull, 0x000000000012B528ull },
	{ 0x000000000000000Cull, 0x000000000000000Cull },
	{ 0x800000031C75986Eull, 0x800000031C75986Eull },
	{ 0x8000000000000F3Full, 0x8000000000000F3Full },
	{ 0x8000000000118BD3ull, 0x8000000000118BD3ull },
	{ 0x0000000000000A41ull, 0x0000000000000A41ull },
	{ 0x800D9A11AA6A400Bull, 0x800D9A11AA6A400Bull },
	{ 0x000000009F10DFF2ull, 0x000000009F10DFF2ull },
	{ 0x8000000000000048ull, 0x8000000000000048ull },
	{ 0x000001B407FE6504ull, 0x000001B407FE6504ull },
	{ 0x8000000295C1FC28ull, 0x8000000295C1FC28ull },
	{ 0x8000000E40DF75D7ull, 0x8000000E40DF75D7ull },
	{ 0x8000000000000001ull, 0x8000000000000001ull },
	{ 0x80000000000000D9ull, 0x80000000000000D9ull },
	{ 0x0000000000B04D59ull, 0x0000000000B04D59ull },
	{ 0x00008C5CC2C8BB6Dull, 0x00008C5CC2C8BB6Dull },
	{ 0x800000000000000Eull, 0x800000000000000Eull },
	{ 0x00000019ADFC8F90ull, 0x00000019ADFC8F90ull },
	{ 0x0000000000BBBAD8ull, 0x0000000000BBBAD8ull },
	{ 0x0000000000000397ull, 0x0000000000000397ull },
	{ 0x000C00BDB69BB76Aull, 0x000C00BDB69BB76Aull },
	{ 0x8000000000000003ull, 0x8000000000000003ull },
	{ 0x80000001F8A2F366ull, 0x80000001F8A2F366ull },
	{ 0x8000000D119BD779ull, 0x8000000D119BD779ull },
	{ 0x800000000000000Eull, 0x800000000000000Eull },
	{ 0x8000000000014CE8ull, 0x8000000000014CE8ull },
	{ 0x800000000000002Dull, 0x800000000000002Dull },
	{ 0x0000001A3DF52890ull, 0x0000001A3DF52890ull },
	{ 0x0000000006006659ull, 0x0000000006006659ull },
	{ 0x8005A730999DFF83ull, 0x8005A730999DFF83ull },
	{ 0x800000036686F8E4ull, 0x800000036686F8E4ull },
	{ 0x800006C5321DFBFAull, 0x800006C5321DFBFAull },
	{ 0x000B77BA9477CED3ull, 0x000B77BA9477CED3ull },
	{ 0x00010599D8ECEA57ull, 0x00010599D8ECEA57ull },
	{ 0x0000175147CCA07Full, 0x0000175147CCA07Full },
	{ 0x800000004D0F1A1Aull, 0x800000004D0F1A1Aull },
	{ 0x00000000D01F7A58ull, 0x00000000D01F7A58ull },
	{ 0x80000091CB28B352ull, 0x80000091CB28B352ull },
	{ 0x8000000000AA715Dull, 0x8000000000AA715Dull },
	{ 0x0002C892054531A4ull, 0x0002C892054531A4ull },
	{ 0x0000000008CE899Cull, 0x0000000008CE899Cull },
	{ 0x0000000040283EF8ull, 0x0000000040283EF8ull },
	{ 0x8000004C927676E9ull, 0x8000004C927676E9ull },
	{ 0x800000079B4F512Full, 0x800000079B4F512Full },
	{ 0x0000000A929BFC51ull, 0x0000000A929BFC51ull },
	{ 0x80000000001CA414ull, 0x80000000001CA414ull },
	{ 0x0000BA5BE109DBB6ull, 0x0000BA5BE109DBB6ull },
	{ 0x8000006E8B24F295ull, 0x8000006E8B24F295ull },
	{ 0x8000000000000001ull, 0x8000000000000001ull },
	{ 0x8000000001272038ull, 0x8000000001272038ull },
	{ 0x0000000000007CBCull, 0x0000000000007CBCull },
	{ 0x0000012B508FC86Cull, 0x0000012B508FC86Cull },
	{ 0x80000000000000AAull, 0x80000000000000AAull },
	{ 0x8000000000000018ull, 0x8000000000000018ull },
	{ 0x000000000000002Dull, 0x000000000000002Dull },
	{ 0x000000003F50902Dull, 0x000000003F50902Dull },
	{ 0x0000D4A470056051ull, 0x0000D4A470056051ull },
	{ 0x00000000000005B0ull, 0x00000000000005B0ull },
	{ 0x80092E7F39E3083Cull, 0x80092E7F39E3083Cull },
	{ 0x800000000410811Cull, 0x800000000410811Cull },
	{ 0x80000F96A851E3EBull, 0x80000F96A851E3EBull },
	{ 0x000001CFF2F07447ull, 0x000001CFF2F07447ull },
	{ 0x800ABF1BC2854460ull, 0x800ABF1BC2854460ull },
	{ 0x80032701F0D1A11Eull, 0x80032701F0D1A11Eull },
	{ 0x80000001906502F9ull, 0x80000001906502F9ull },
	{ 0x00068D6C22F2814Cull, 0x00068D6C22F2814Cull },
	{ 0x000000000000000Eull, 0x000000000000000Eull },
	{ 0x800000000750FE30ull, 0x800000000750FE30ull },
	{ 0x00000000000001AEull, 0x00000000000001AEull },
	{ 0x800002DE3BF9BF4Cull, 0x800002DE3BF9BF4Cull },
	{ 0x800000000DF5A44Dull, 0x800000000DF5A44Dull },
	{ 0x80000000003936F3ull, 0x80000000003936F3ull },
	{ 0x0000000000AA9F90ull, 0x0000000000AA9F90ull },
	{ 0x0000000AFA64F531ull, 0x0000000AFA64F531ull },
	{ 0x0000078ED0BF92B7ull, 0x0000078ED0BF92B7ull },
	{ 0x000059E02B2E9C2Eull, 0x000059E02B2E9C2Eull },
	{ 0x800000000007979Aull, 0x800000000007979Aull },
	{ 0x8000000000000003ull, 0x8000000000000003ull },
	{ 0x00000000C21532B2ull, 0x00000000C21532B2ull },
	{ 0x000000000007B3FCull, 0x000000000007B3FCull },
	{ 0x80005844F0704CE3ull, 0x80005844F0704CE3ull },
	{ 0x000000000E3952E7ull, 0x000000000E3952E7ull },
	{ 0x00000E6CD8DF1B93ull, 0x00000E6CD8DF1B93ull },
	{ 0x0000000000000002ull, 0x0000000000000002ull },
	{ 0x000001E56E7E2D3Full, 0x000001E56E7E2D3Full },
	{ 0x0000134DDBDB4FD8ull, 0x0000134DDBDB4FD8ull },
	{ 0x0000000000000563ull, 0x0000000000000563ull },
	{ 0x80000000126B051Cull, 0x80000000126B051Cull },
	{ 0x8000000000001736ull, 0x8000000000001736ull },
	{ 0x000000000000068Eull, 0x000000000000068Eull },
	{ 0x8000000000008146ull, 0x8000000000008146ull },
	{ 0x8000000000000027ull, 0x8000000000000027ull },
	{ 0x000000000001C9FEull, 0x000000000001C9FEull },
	{ 0x8000000DACD2EDA0ull, 0x8000000DACD2EDA0ull },
	{ 0x80000001D097773Bull, 0x80000001D097773Bull },
	{ 0x000013EA3250E08Eull, 0x000013EA3250E08Eull },
	{ 0x800000177643D0A2ull, 0x800000177643D0A2ull },
	{ 0x0000036311AB1C05ull, 0x0000036311AB1C05ull },
	{ 0x0000000000000017ull, 0x0000000000000017ull },
	{ 0x80000000013CF620ull, 0x80000000013CF620ull },
	{ 0x000000000FA5A3F3ull, 0x000000000FA5A3F3ull },
	{ 0x800000017B05B2D5ull, 0x800000017B05B2D5ull },
	{ 0x800477F44D5AE9A6ull, 0x800477F44D5AE9A6ull },
	{ 0x80007E1CC1D83AD5ull, 0x80007E1CC1D83AD5ull },
	{ 0x00000000005E24D1ull, 0x00000000005E24D1ull },
	{ 0x800000000000001Aull, 0x800000000000001Aull },
	{ 0x80002EE806BE1224ull, 0x80002EE806BE1224ull },
	{ 0x800000000069CC5Dull, 0x800000000069CC5Dull },
	{ 0x000000000000000Eull, 0x000000000000000Eull },
	{ 0x8000000002346671ull, 0x8000000002346671ull },
	{ 0x0001A1C22A8407B8ull, 0x0001A1C22A8407B8ull },
	{ 0x8000000000000027ull, 0x8000000000000027ull },
	{ 0x0000000FA574F5E0ull, 0x0000000FA574F5E0ull },
	{ 0x8000000000000066ull, 0x8000000000000066ull },
	{ 0x0000000C4CDE4E89ull, 0x0000000C4CDE4E89ull },
	{ 0x00000000000003BDull, 0x00000000000003BDull },
	{ 0x000000000169D892ull, 0x000000000169D892ull },
	{ 0x800000000000001Full, 0x800000000000001Full },
	{ 0x0000000002E699E5ull, 0x0000000002E699E5ull },
	{ 0x000000000003F481ull, 0x000000000003F481ull },
	{ 0x0000901BED3866F6ull, 0x0000901BED3866F6ull },
	{ 0x00000000A4B0A5B7ull, 0x00000000A4B0A5B7ull },
	{ 0x0000000000000B61ull, 0x0000000000000B61ull },
	{ 0x00000F3385EB831Eull, 0x00000F3385EB831Eull },
	{ 0x0001740091F0175Aull, 0x0001740091F0175Aull },
	{ 0x0000018BC72B707Eull, 0x0000018BC72B707Eull },
	{ 0x8000000002D0C319ull, 0x8000000002D0C319ull },
	{ 0x8000006024C20E94ull, 0x8000006024C20E94ull },
	{ 0x00000000AA560C19ull, 0x00000000AA560C19ull },
	{ 0x800007EA1936D3F7ull, 0x800007EA1936D3F7ull },
	{ 0x0000000000000004ull, 0x0000000000000004ull },
	{ 0x800CCD4212E8B310ull, 0x800CCD4212E8B310ull },
	{ 0x80000000193DEE5Dull, 0x80000000193DEE5Dull },
	{ 0x00000CA850522375ull, 0x00000CA850522375ull },
	{ 0x00000000003A6225ull, 0x00000000003A6225ull },
	{ 0x0000000000000632ull, 0x0000000000000632ull },
	{ 0x000000000000000Aull, 0x000000000000000Aull },
	{ 0x800027875839F473ull, 0x800027875839F473ull },
	{ 0x8000000000001DCEull, 0x8000000000001DCEull },
	{ 0x000008CE8E3E61AFull, 0x000008CE8E3E61AFull },
	{ 0x000000003E75AAB4ull, 0x000000003E75AAB4ull },
	{ 0x8000000000000050ull, 0x8000000000000050ull }
};

#ifdef WGF11SHADER5X
CShader5xTest_DoubleArith::Binary64Vec2 const CShader5xTest_ddiv::s_DDivSrc1[] = 
#else
#ifdef CALCDOUBLES
dataLayout  s_DDivSrc1[] = 
#endif
#endif
{
	{ 0x3FF0000000000000ull, 0x3FF0000000000000ull },
	{ 0xFFF0000000000000ull, 0xFFF0000000000000ull },
	{ 0x8000000000000000ull, 0x8000000000000000ull },
	{ 0x7FF3F89B51837A9Dull, 0x7FF3F89B51837A9Dull },
	{ 0x0000000000000000ull, 0x0000000000000000ull },
	{ 0x8000000000000000ull, 0x8000000000000000ull },
	{ 0x0000000000000000ull, 0x0000000000000000ull },
	{ 0x8000000000000000ull, 0x8000000000000000ull },
	{ 0xB7854F713C689E44ull, 0xB7854F713C689E44ull },
	{ 0x7FF9436DD07BF2E5ull, 0x7FF9436DD07BF2E5ull },
	{ 0x4F57F53BE90A6D77ull, 0x4F57F53BE90A6D77ull },
	{ 0xFFF0000000000000ull, 0xFFF0000000000000ull },
	{ 0xBCAEA0E7896C803Dull, 0xBCAEA0E7896C803Dull },
	{ 0xFFF0000000000000ull, 0xFFF0000000000000ull },
	{ 0xDDF4900A52A14BA1ull, 0xDDF4900A52A14BA1ull },
	{ 0x7FF0000000000000ull, 0x7FF0000000000000ull },
	{ 0x351E5198B30372FDull, 0x351E5198B30372FDull },
	{ 0x7FF0000000000000ull, 0x7FF0000000000000ull },
	{ 0xFFF0000000000000ull, 0xFFF0000000000000ull },
	{ 0x5744B484274AA4EEull, 0x5744B484274AA4EEull },
	{ 0x8000000003F9D285ull, 0x8000000003F9D285ull },
	{ 0x7FFB37D2241C3B1Dull, 0x7FFB37D2241C3B1Dull },
	{ 0x0000001983B94C92ull, 0x0000001983B94C92ull },
	{ 0x7FF0000000000000ull, 0x7FF0000000000000ull },
	{ 0x80009443E584F4A5ull, 0x80009443E584F4A5ull },
	{ 0xFFF0000000000000ull, 0xFFF0000000000000ull },
	{ 0x8000000855A82C2Cull, 0x8000000855A82C2Cull },
	{ 0x7FF0000000000000ull, 0x7FF0000000000000ull },
	{ 0x000000000005B6ABull, 0x000000000005B6ABull },
	{ 0x7FF0000000000000ull, 0x7FF0000000000000ull },
	{ 0xFFF0000000000000ull, 0xFFF0000000000000ull },
	{ 0x00000000B58DC413ull, 0x00000000B58DC413ull },
	{ 0xB3E6B297EC29791Dull, 0xB3E6B297EC29791Dull },
	{ 0x538FB3BC5CFA6759ull, 0x538FB3BC5CFA6759ull },
	{ 0xBA000797F4C7DEA1ull, 0xBA000797F4C7DEA1ull },
	{ 0x0C1C8FF2F41F16DAull, 0x0C1C8FF2F41F16DAull },
	{ 0x30B5C1676C56DD62ull, 0x30B5C1676C56DD62ull },
	{ 0x5CCB5C56E7C5AC0Bull, 0x5CCB5C56E7C5AC0Bull },
	{ 0x63068E39A09E6158ull, 0x63068E39A09E6158ull },
	{ 0x07B3FB8E47099176ull, 0x07B3FB8E47099176ull },
	{ 0x184F31A158F1807Dull, 0x184F31A158F1807Dull },
	{ 0x8758FF530896B7E7ull, 0x8758FF530896B7E7ull },
	{ 0x4C0A36D2B4A33B50ull, 0x4C0A36D2B4A33B50ull },
	{ 0xC64C5756ED525E6Full, 0xC64C5756ED525E6Full },
	{ 0x66199E890D233BD4ull, 0x66199E890D233BD4ull },
	{ 0x578E020B5EEBCB63ull, 0x578E020B5EEBCB63ull },
	{ 0xF28A90D0D4429690ull, 0xF28A90D0D4429690ull },
	{ 0x2E44BC8D4F15105Cull, 0x2E44BC8D4F15105Cull },
	{ 0xD9830B957560898Full, 0xD9830B957560898Full },
	{ 0xD5F0B21519E3C836ull, 0xD5F0B21519E3C836ull },
	{ 0x17D9939333BF3CE0ull, 0x17D9939333BF3CE0ull },
	{ 0x2A282C8A6399D814ull, 0x2A282C8A6399D814ull },
	{ 0xF616E3ED0C808295ull, 0xF616E3ED0C808295ull },
	{ 0x8EEE447BF9D63059ull, 0x8EEE447BF9D63059ull },
	{ 0x41719E46964A9745ull, 0x41719E46964A9745ull },
	{ 0x285390BBB32D882Eull, 0x285390BBB32D882Eull },
	{ 0x0333FB01DF54E08Cull, 0x0333FB01DF54E08Cull },
	{ 0x12E0D6DE4EAB2400ull, 0x12E0D6DE4EAB2400ull },
	{ 0xB8DB78A14FDCAF88ull, 0xB8DB78A14FDCAF88ull },
	{ 0x9B3BBA9F54F99101ull, 0x9B3BBA9F54F99101ull },
	{ 0x8C428C6D88C1FDDDull, 0x8C428C6D88C1FDDDull },
	{ 0xF6556E68F7B36624ull, 0xF6556E68F7B36624ull },
	{ 0x0B7451FF444C2F30ull, 0x0B7451FF444C2F30ull },
	{ 0xF943635FF0DC04A4ull, 0xF943635FF0DC04A4ull },
	{ 0x60BA3B4D3516D22Dull, 0x60BA3B4D3516D22Dull },
	{ 0x51A1F8B3648057FCull, 0x51A1F8B3648057FCull },
	{ 0x0AA3C17DE7265F82ull, 0x0AA3C17DE7265F82ull },
	{ 0xBCF12C70BEFF94EEull, 0xBCF12C70BEFF94EEull },
	{ 0x9408133D9FA4F8E4ull, 0x9408133D9FA4F8E4ull },
	{ 0xC14B4AFB957BFA7Eull, 0xC14B4AFB957BFA7Eull },
	{ 0xCBF1C6783C472A07ull, 0xCBF1C6783C472A07ull },
	{ 0xE4B59F4986B39276ull, 0xE4B59F4986B39276ull },
	{ 0xFDA487571458AA28ull, 0xFDA487571458AA28ull },
	{ 0x65BB22A219C0EF62ull, 0x65BB22A219C0EF62ull },
	{ 0xA8BCC882D7B11885ull, 0xA8BCC882D7B11885ull },
	{ 0xF2F12D229FC3EE93ull, 0xF2F12D229FC3EE93ull },
	{ 0xB8F973296F10BFE2ull, 0xB8F973296F10BFE2ull },
	{ 0xE356252611F2779Eull, 0xE356252611F2779Eull },
	{ 0xBE6F96E7DCA55404ull, 0xBE6F96E7DCA55404ull },
	{ 0x6E1A2F90F2513BDCull, 0x6E1A2F90F2513BDCull },
	{ 0xA5681A181B76B3B7ull, 0xA5681A181B76B3B7ull },
	{ 0x6291DFC12CD4766Aull, 0x6291DFC12CD4766Aull },
	{ 0x6E876922FF3BA6CAull, 0x6E876922FF3BA6CAull },
	{ 0xE092E7C1F5A8AB28ull, 0xE092E7C1F5A8AB28ull },
	{ 0xE67F277615169F0Full, 0xE67F277615169F0Full },
	{ 0x8FFAC7E3AAA36B3Cull, 0x8FFAC7E3AAA36B3Cull },
	{ 0x5E69DE7D833A79DDull, 0x5E69DE7D833A79DDull },
	{ 0xD8EF7F37B1DC0E0Eull, 0xD8EF7F37B1DC0E0Eull },
	{ 0x6390AE81E8373B90ull, 0x6390AE81E8373B90ull },
	{ 0x9BCA3AF05AEC78CCull, 0x9BCA3AF05AEC78CCull },
	{ 0x779AFE4A3BEED607ull, 0x779AFE4A3BEED607ull },
	{ 0xE96C0724BE59D6E5ull, 0xE96C0724BE59D6E5ull },
	{ 0x48282AC1AFF1E2A3ull, 0x48282AC1AFF1E2A3ull },
	{ 0x3A9C7E589DA56010ull, 0x3A9C7E589DA56010ull },
	{ 0xE76337E18D84664Cull, 0xE76337E18D84664Cull },
	{ 0x28927928434515C4ull, 0x28927928434515C4ull },
	{ 0x83A07FBF184A8DEDull, 0x83A07FBF184A8DEDull },
	{ 0xA4D6BF58628482C0ull, 0xA4D6BF58628482C0ull },
	{ 0x9F6562DD6BDD72F5ull, 0x9F6562DD6BDD72F5ull },
	{ 0xB0F0B669F80D7C82ull, 0xB0F0B669F80D7C82ull },
	{ 0x4979F8835D07D6D6ull, 0x4979F8835D07D6D6ull },
	{ 0x16DD13522958E2D2ull, 0x16DD13522958E2D2ull },
	{ 0x54E4BE755A6AE588ull, 0x54E4BE755A6AE588ull },
	{ 0x20CE889624875DB7ull, 0x20CE889624875DB7ull },
	{ 0x910048B34A0AF605ull, 0x910048B34A0AF605ull },
	{ 0x512877AB01A220FEull, 0x512877AB01A220FEull },
	{ 0x017AF1FA6CC4484Cull, 0x017AF1FA6CC4484Cull },
	{ 0x1AA3A0B9A083A938ull, 0x1AA3A0B9A083A938ull },
	{ 0x15D08B6B3B27C660ull, 0x15D08B6B3B27C660ull },
	{ 0x982CD1C68B287EBAull, 0x982CD1C68B287EBAull },
	{ 0xE26E0CD3473FC4C9ull, 0xE26E0CD3473FC4C9ull },
	{ 0xC4ED983DD3E7F21Dull, 0xC4ED983DD3E7F21Dull },
	{ 0x575F445B1BBCC090ull, 0x575F445B1BBCC090ull },
	{ 0xB45EEF22F5D4DE3Eull, 0xB45EEF22F5D4DE3Eull },
	{ 0xF94686781CCA2344ull, 0xF94686781CCA2344ull },
	{ 0x4A05F0A4B5C668BDull, 0x4A05F0A4B5C668BDull },
	{ 0x18EE5E82678AFEFAull, 0x18EE5E82678AFEFAull },
	{ 0x720A85150148C080ull, 0x720A85150148C080ull },
	{ 0x0B653E2EB23ECE47ull, 0x0B653E2EB23ECE47ull },
	{ 0xD8781344CEF5DF2Full, 0xD8781344CEF5DF2Full },
	{ 0x62032DAC2ACE3946ull, 0x62032DAC2ACE3946ull },
	{ 0x21C830C3FDB647B8ull, 0x21C830C3FDB647B8ull },
	{ 0x22597B665A3FCF16ull, 0x22597B665A3FCF16ull },
	{ 0xA2A751653669C6CBull, 0xA2A751653669C6CBull },
	{ 0x7E1C6CEB0114CADAull, 0x7E1C6CEB0114CADAull },
	{ 0x97F377C5CA38345Cull, 0x97F377C5CA38345Cull },
	{ 0x8B66ED93F90DCFB9ull, 0x8B66ED93F90DCFB9ull },
	{ 0xDEF4E4B993CA3126ull, 0xDEF4E4B993CA3126ull },
	{ 0xFC983FB515D7AC5Full, 0xFC983FB515D7AC5Full },
	{ 0xAD10C77AD6E9E824ull, 0xAD10C77AD6E9E824ull },
	{ 0x582BABEE02A018F8ull, 0x582BABEE02A018F8ull },
	{ 0x47F5EE3E1F4BCF18ull, 0x47F5EE3E1F4BCF18ull },
	{ 0xB0EA316024D2773Aull, 0xB0EA316024D2773Aull },
	{ 0xBD83752A237F6507ull, 0xBD83752A237F6507ull },
	{ 0xDDF635E87A7C93D9ull, 0xDDF635E87A7C93D9ull },
	{ 0x3281359D7A1B6513ull, 0x3281359D7A1B6513ull },
	{ 0xA9B3BE5D3F5D4CBBull, 0xA9B3BE5D3F5D4CBBull },
	{ 0xB63B72F0F40FCAA4ull, 0xB63B72F0F40FCAA4ull },
	{ 0x1D6E71BB6F948EDEull, 0x1D6E71BB6F948EDEull },
	{ 0xDCDDA755F17B4FD0ull, 0xDCDDA755F17B4FD0ull },
	{ 0x5614C83C4AF0E037ull, 0x5614C83C4AF0E037ull },
	{ 0xBE7CB24A93C4E75Full, 0xBE7CB24A93C4E75Full },
	{ 0x12D9B693739C329Full, 0x12D9B693739C329Full },
	{ 0xCF574A05F645B01Aull, 0xCF574A05F645B01Aull },
	{ 0xAB1AA029F5480133ull, 0xAB1AA029F5480133ull },
	{ 0x980DAB6A0CDDB250ull, 0x980DAB6A0CDDB250ull },
	{ 0xC69C0732247610D4ull, 0xC69C0732247610D4ull },
	{ 0x6D63495984B0A056ull, 0x6D63495984B0A056ull },
	{ 0x15303BDF7EA930A5ull, 0x15303BDF7EA930A5ull },
	{ 0x287A7D91A34A9581ull, 0x287A7D91A34A9581ull },
	{ 0x07280CE28A3DFA92ull, 0x07280CE28A3DFA92ull },
	{ 0x5E8A3848282CD92Cull, 0x5E8A3848282CD92Cull },
	{ 0x04DD7828B6AB90C5ull, 0x04DD7828B6AB90C5ull },
	{ 0x192DB04D2AC29AB6ull, 0x192DB04D2AC29AB6ull },
	{ 0xA6F859603C6C6131ull, 0xA6F859603C6C6131ull },
	{ 0x8E1E1290FC7DB483ull, 0x8E1E1290FC7DB483ull },
	{ 0x6E6D1AFFFCCEE30Aull, 0x6E6D1AFFFCCEE30Aull },
	{ 0x578632EE071B6B78ull, 0x578632EE071B6B78ull },
	{ 0xFC7565D362AE56C9ull, 0xFC7565D362AE56C9ull },
	{ 0x2B903B56AD512C81ull, 0x2B903B56AD512C81ull },
	{ 0xCA62D14A4153882Aull, 0xCA62D14A4153882Aull },
	{ 0x94FD5CA72BE1508Dull, 0x94FD5CA72BE1508Dull },
	{ 0xE20B936CB53D8CAFull, 0xE20B936CB53D8CAFull },
	{ 0x2A777E1B76D7D98Eull, 0x2A777E1B76D7D98Eull },
	{ 0xC70CED291CEF347Cull, 0xC70CED291CEF347Cull },
	{ 0x36212BE17B38547Bull, 0x36212BE17B38547Bull },
	{ 0x42160E1D249CF651ull, 0x42160E1D249CF651ull },
	{ 0xCF4FB68853557399ull, 0xCF4FB68853557399ull },
	{ 0xA7150B9DEDC69F8Dull, 0xA7150B9DEDC69F8Dull },
	{ 0xDB4C60678CB99E85ull, 0xDB4C60678CB99E85ull },
	{ 0xEDEF86D1121E5B31ull, 0xEDEF86D1121E5B31ull },
	{ 0xFD00C816D0AE9C15ull, 0xFD00C816D0AE9C15ull },
	{ 0x3292476542E7BC45ull, 0x3292476542E7BC45ull },
	{ 0xB7C94A7151B0FDE2ull, 0xB7C94A7151B0FDE2ull },
	{ 0x6D6EEB802B2481D5ull, 0x6D6EEB802B2481D5ull },
	{ 0xA6F7B2C5AAD0DE49ull, 0xA6F7B2C5AAD0DE49ull },
	{ 0x2AE397F04F2953EDull, 0x2AE397F04F2953EDull },
	{ 0xB63FEB49C17AA36Bull, 0xB63FEB49C17AA36Bull },
	{ 0xC3FCA7A2EBDA8423ull, 0xC3FCA7A2EBDA8423ull },
	{ 0xD97EAC12A227BB2Cull, 0xD97EAC12A227BB2Cull },
	{ 0x95905C9DD6D0CF8Cull, 0x95905C9DD6D0CF8Cull },
	{ 0xC4EA2C5063B76035ull, 0xC4EA2C5063B76035ull },
	{ 0x39148EBD5FA61BC3ull, 0x39148EBD5FA61BC3ull },
	{ 0x24FCD14E05EF54F4ull, 0x24FCD14E05EF54F4ull },
	{ 0x3C0E5CD62DAA3967ull, 0x3C0E5CD62DAA3967ull },
	{ 0xD659DEF550A4A619ull, 0xD659DEF550A4A619ull },
	{ 0xD83BDBFB223FA19Cull, 0xD83BDBFB223FA19Cull },
	{ 0x1DEC27B6B5CC6C19ull, 0x1DEC27B6B5CC6C19ull },
	{ 0x2BA7C7C737203987ull, 0x2BA7C7C737203987ull },
	{ 0x60FEBC952FF4872Cull, 0x60FEBC952FF4872Cull },
	{ 0xF0B7328B5F4A0FD4ull, 0xF0B7328B5F4A0FD4ull },
	{ 0xDCCF9CD622246351ull, 0xDCCF9CD622246351ull },
	{ 0x35E1350067141BB2ull, 0x35E1350067141BB2ull },
	{ 0x5F2C667538E5B447ull, 0x5F2C667538E5B447ull },
	{ 0x96009E5CD32AFF54ull, 0x96009E5CD32AFF54ull },
	{ 0xFDF905FC4A353A93ull, 0xFDF905FC4A353A93ull },
	{ 0x703FA3EEC1B5C770ull, 0x703FA3EEC1B5C770ull },
	{ 0x4F60661F33DB7F7Full, 0x4F60661F33DB7F7Full },
	{ 0x21EF207BBDAD9498ull, 0x21EF207BBDAD9498ull },
	{ 0xB4282CDD7835D8ADull, 0xB4282CDD7835D8ADull },
	{ 0xA904E9E41CE3E903ull, 0xA904E9E41CE3E903ull },
	{ 0x6D1391A59C84B2D4ull, 0x6D1391A59C84B2D4ull },
	{ 0x9EB58C1AD41B447Dull, 0x9EB58C1AD41B447Dull },
	{ 0x13D713F6EDA95366ull, 0x13D713F6EDA95366ull },
	{ 0x1184E8913A6C3640ull, 0x1184E8913A6C3640ull },
	{ 0x78DC5D0B0C572003ull, 0x78DC5D0B0C572003ull },
	{ 0x7C9939A61D1BAAE1ull, 0x7C9939A61D1BAAE1ull },
	{ 0x9EC8961DEBA76093ull, 0x9EC8961DEBA76093ull },
	{ 0xB2CD9B2ACC847BE8ull, 0xB2CD9B2ACC847BE8ull },
	{ 0x71B9312DDBA5109Aull, 0x71B9312DDBA5109Aull },
	{ 0x51B0F0B3510D008Bull, 0x51B0F0B3510D008Bull },
	{ 0x6228FBE36B249343ull, 0x6228FBE36B249343ull },
	{ 0xEAF240D8E2A9A9AAull, 0xEAF240D8E2A9A9AAull },
	{ 0x90C6A203F3159601ull, 0x90C6A203F3159601ull },
	{ 0x3C5488D0F22D9126ull, 0x3C5488D0F22D9126ull },
	{ 0x86735E197513CF88ull, 0x86735E197513CF88ull },
	{ 0xE7D26C57094F3AE8ull, 0xE7D26C57094F3AE8ull },
	{ 0x6C8BA8DE7B1FC251ull, 0x6C8BA8DE7B1FC251ull },
	{ 0x2BDBE57AAB955559ull, 0x2BDBE57AAB955559ull },
	{ 0x4439E9CDF93F7818ull, 0x4439E9CDF93F7818ull },
	{ 0x9ADDF51134EB78E9ull, 0x9ADDF51134EB78E9ull },
	{ 0x1F5326F72B0746E0ull, 0x1F5326F72B0746E0ull },
	{ 0xD3B4520BB99EE70Aull, 0xD3B4520BB99EE70Aull },
	{ 0x57CDB4B576CA8D6Bull, 0x57CDB4B576CA8D6Bull },
	{ 0x39651A70E8434CB4ull, 0x39651A70E8434CB4ull },
	{ 0xC7C1E5CC4AF474C4ull, 0xC7C1E5CC4AF474C4ull },
	{ 0xAB56821AE7FF8062ull, 0xAB56821AE7FF8062ull },
	{ 0x81A4BBE6FE48B037ull, 0x81A4BBE6FE48B037ull },
	{ 0x3CFE83B938024091ull, 0x3CFE83B938024091ull },
	{ 0xEE2C90B691DEF9C6ull, 0xEE2C90B691DEF9C6ull },
	{ 0x62FD4062C7527E06ull, 0x62FD4062C7527E06ull },
	{ 0xADD0FD1938EFC8D9ull, 0xADD0FD1938EFC8D9ull },
	{ 0x6E9C1C75858E879Cull, 0x6E9C1C75858E879Cull },
	{ 0xF747BF6A98C71410ull, 0xF747BF6A98C71410ull },
	{ 0x4510B9B0DB8B205Bull, 0x4510B9B0DB8B205Bull },
	{ 0xE008F97004989A95ull, 0xE008F97004989A95ull },
	{ 0x6D9FDBDA718A0B3Full, 0x6D9FDBDA718A0B3Full },
	{ 0x086E1E517D348804ull, 0x086E1E517D348804ull },
	{ 0xB64962CBA402306Bull, 0xB64962CBA402306Bull },
	{ 0x9A86D959EC5A82A1ull, 0x9A86D959EC5A82A1ull },
	{ 0xEC1CE074FE1B6E19ull, 0xEC1CE074FE1B6E19ull },
	{ 0xFF26EACEC4F307B7ull, 0xFF26EACEC4F307B7ull },
	{ 0x3D0D13EC1205FD0Eull, 0x3D0D13EC1205FD0Eull },
	{ 0x60B478814647C781ull, 0x60B478814647C781ull },
	{ 0xA3DA5CB1149A68B0ull, 0xA3DA5CB1149A68B0ull },
	{ 0xC361598FAA4691B2ull, 0xC361598FAA4691B2ull },
	{ 0x7F206B283FC634CAull, 0x7F206B283FC634CAull },
	{ 0xDF4024749D006AE0ull, 0xDF4024749D006AE0ull },
	{ 0x711847F760D09E32ull, 0x711847F760D09E32ull },
	{ 0xEBE6F595E742462Bull, 0xEBE6F595E742462Bull },
	{ 0xFD593744FEC02C13ull, 0xFD593744FEC02C13ull },
	{ 0x3D2AD79F636FB22Eull, 0x3D2AD79F636FB22Eull },
	{ 0x52C18D9D90D9770Eull, 0x52C18D9D90D9770Eull },
	{ 0x7F06164A8E84928Bull, 0x7F06164A8E84928Bull },
	{ 0x5623837A1EA0F74Dull, 0x5623837A1EA0F74Dull },
	{ 0x7F1948767F3C7D71ull, 0x7F1948767F3C7D71ull },
	{ 0x76642F3676FB0B34ull, 0x76642F3676FB0B34ull },
	{ 0x6B77EFB22B3865DCull, 0x6B77EFB22B3865DCull },
	{ 0xFEAD56A8D2A8EEA2ull, 0xFEAD56A8D2A8EEA2ull },
	{ 0x0B7A0605FE9716CBull, 0x0B7A0605FE9716CBull },
	{ 0x7807942AEFE28A7Aull, 0x7807942AEFE28A7Aull },
	{ 0x67E8464F2A6CDD95ull, 0x67E8464F2A6CDD95ull },
	{ 0x7F3CFC016FB7AFBFull, 0x7F3CFC016FB7AFBFull },
	{ 0x2585ECC6432AEBB1ull, 0x2585ECC6432AEBB1ull },
	{ 0x9DEF3515B19916A5ull, 0x9DEF3515B19916A5ull },
	{ 0x224431BEECD4A9AEull, 0x224431BEECD4A9AEull },
	{ 0x27A2D5D0C9755C84ull, 0x27A2D5D0C9755C84ull },
	{ 0x10A07D8918A070B3ull, 0x10A07D8918A070B3ull },
	{ 0x373EAB981556BF3Aull, 0x373EAB981556BF3Aull },
	{ 0x27E78AAC88657CABull, 0x27E78AAC88657CABull },
	{ 0x887577EE641A6E2Cull, 0x887577EE641A6E2Cull },
	{ 0xAEDD7223C0500686ull, 0xAEDD7223C0500686ull },
	{ 0x8E0137305F85593Full, 0x8E0137305F85593Full },
	{ 0xB84C642C630279F8ull, 0xB84C642C630279F8ull },
	{ 0x2F23DF8753B53A5Cull, 0x2F23DF8753B53A5Cull },
	{ 0x3A6F715B393C1D38ull, 0x3A6F715B393C1D38ull },
	{ 0x0E5372D8308B39F2ull, 0x0E5372D8308B39F2ull },
	{ 0xA0380A0B4690CDA7ull, 0xA0380A0B4690CDA7ull },
	{ 0x1BFB493D59B0687Cull, 0x1BFB493D59B0687Cull },
	{ 0x857A69431226DEC1ull, 0x857A69431226DEC1ull },
	{ 0xAECB6DDADEA9C6DCull, 0xAECB6DDADEA9C6DCull },
	{ 0x37877A72EB782690ull, 0x37877A72EB782690ull },
	{ 0xB62D4C34F7A7F757ull, 0xB62D4C34F7A7F757ull },
	{ 0x21066482BD27A692ull, 0x21066482BD27A692ull },
	{ 0x3D77C3B186915232ull, 0x3D77C3B186915232ull },
	{ 0x346C2386FEF215E2ull, 0x346C2386FEF215E2ull },
	{ 0x8EE70DEA78D847A4ull, 0x8EE70DEA78D847A4ull },
	{ 0xB02463A646BB941Cull, 0xB02463A646BB941Cull },
	{ 0x92BCE23D7BF947B1ull, 0x92BCE23D7BF947B1ull },
	{ 0x81208EEFEB87646Cull, 0x81208EEFEB87646Cull },
	{ 0x81B9FBB41E057ABFull, 0x81B9FBB41E057ABFull },
	{ 0x147BEF1A81B3F2DEull, 0x147BEF1A81B3F2DEull },
	{ 0x13BBF8369033C039ull, 0x13BBF8369033C039ull },
	{ 0x216BBA95B2BDC553ull, 0x216BBA95B2BDC553ull },
	{ 0xA65897C7511317E3ull, 0xA65897C7511317E3ull },
	{ 0xA07A73FBE340EA37ull, 0xA07A73FBE340EA37ull },
	{ 0x904A621F1FCFD441ull, 0x904A621F1FCFD441ull },
	{ 0x12636942884DA213ull, 0x12636942884DA213ull },
	{ 0x9D2606A8F54684E3ull, 0x9D2606A8F54684E3ull },
	{ 0xA14F77FFC248DE22ull, 0xA14F77FFC248DE22ull },
	{ 0xAEE21EA1F7AB4AC7ull, 0xAEE21EA1F7AB4AC7ull },
	{ 0x32465FBD9EFF4AFAull, 0x32465FBD9EFF4AFAull },
	{ 0x1D1EDC8A4C94326Eull, 0x1D1EDC8A4C94326Eull },
	{ 0x113BC956FF05C93Bull, 0x113BC956FF05C93Bull },
	{ 0x213C621327450D29ull, 0x213C621327450D29ull },
	{ 0x364F41B3E183D913ull, 0x364F41B3E183D913ull },
	{ 0x27AA9A5297F5F6D2ull, 0x27AA9A5297F5F6D2ull },
	{ 0x1134216A9B07AD10ull, 0x1134216A9B07AD10ull },
	{ 0x85F70AA190098446ull, 0x85F70AA190098446ull },
	{ 0x8AF82498C5949E80ull, 0x8AF82498C5949E80ull },
	{ 0xACE83D5A57E54979ull, 0xACE83D5A57E54979ull },
	{ 0xB2A9EE9419760B2Bull, 0xB2A9EE9419760B2Bull },
	{ 0x11004C71908C6720ull, 0x11004C71908C6720ull },
	{ 0x8D4B0C15D5B9E9ADull, 0x8D4B0C15D5B9E9ADull },
	{ 0xB702F05163B26A36ull, 0xB702F05163B26A36ull },
	{ 0x3C3EEA440C04B56Aull, 0x3C3EEA440C04B56Aull },
	{ 0x3600476751ABC298ull, 0x3600476751ABC298ull },
	{ 0x3727188344DB837Aull, 0x3727188344DB837Aull },
	{ 0x30AE61B08C2F1920ull, 0x30AE61B08C2F1920ull },
	{ 0x92D213D790AED017ull, 0x92D213D790AED017ull },
	{ 0x9589F9EDE4C17E13ull, 0x9589F9EDE4C17E13ull },
	{ 0x3390FE8B608782A3ull, 0x3390FE8B608782A3ull },
	{ 0x8790BE26492774EDull, 0x8790BE26492774EDull },
	{ 0xB98DDC832ED859C3ull, 0xB98DDC832ED859C3ull },
	{ 0x1C35DE8C9C6A7DCAull, 0x1C35DE8C9C6A7DCAull },
	{ 0x305BF973C5314DD7ull, 0x305BF973C5314DD7ull },
	{ 0x3034A29E24C35613ull, 0x3034A29E24C35613ull },
	{ 0x95F3243DCF28DAA1ull, 0x95F3243DCF28DAA1ull },
	{ 0x96E55865C552B028ull, 0x96E55865C552B028ull },
	{ 0x1A46B71555AFCD64ull, 0x1A46B71555AFCD64ull },
	{ 0x000002CDD8F4A2BAull, 0x000002CDD8F4A2BAull },
	{ 0x000000026CFAB210ull, 0x000000026CFAB210ull },
	{ 0x000EA5DD919B356Cull, 0x000EA5DD919B356Cull },
	{ 0x0001147EB2545912ull, 0x0001147EB2545912ull },
	{ 0x000000003EF20726ull, 0x000000003EF20726ull },
	{ 0x0000000000027AB5ull, 0x0000000000027AB5ull },
	{ 0x000000000000E251ull, 0x000000000000E251ull },
	{ 0x800000000000000Full, 0x800000000000000Full },
	{ 0x0000000000010CD1ull, 0x0000000000010CD1ull },
	{ 0x8000000000000D7Bull, 0x8000000000000D7Bull },
	{ 0x800000000002366Full, 0x800000000002366Full },
	{ 0x8000000000000051ull, 0x8000000000000051ull },
	{ 0x8000000000000002ull, 0x8000000000000002ull },
	{ 0x0000058786E782ECull, 0x0000058786E782ECull },
	{ 0x00000000300D5C5Bull, 0x00000000300D5C5Bull },
	{ 0x8000000000000003ull, 0x8000000000000003ull },
	{ 0x00000000A453CD9Cull, 0x00000000A453CD9Cull },
	{ 0x80002A6FD740C9E7ull, 0x80002A6FD740C9E7ull },
	{ 0x8000000000000011ull, 0x8000000000000011ull },
	{ 0x00000377B18BD0A3ull, 0x00000377B18BD0A3ull },
	{ 0x800000000000078Dull, 0x800000000000078Dull },
	{ 0x80000000000017F5ull, 0x80000000000017F5ull },
	{ 0x800000000019F989ull, 0x800000000019F989ull },
	{ 0x00000442AF84BB53ull, 0x00000442AF84BB53ull },
	{ 0x00058F9A696D7761ull, 0x00058F9A696D7761ull },
	{ 0x0000000000000D28ull, 0x0000000000000D28ull },
	{ 0x0000000010C834C9ull, 0x0000000010C834C9ull },
	{ 0x8000002C06F8C3E0ull, 0x8000002C06F8C3E0ull },
	{ 0x0000000D18136CDAull, 0x0000000D18136CDAull },
	{ 0x0000000000000674ull, 0x0000000000000674ull },
	{ 0x800000000685837Aull, 0x800000000685837Aull },
	{ 0x000016EFAF8E1252ull, 0x000016EFAF8E1252ull },
	{ 0x800006F2C793B324ull, 0x800006F2C793B324ull },
	{ 0x8000052EA0692A19ull, 0x8000052EA0692A19ull },
	{ 0x8000012D06D2BA69ull, 0x8000012D06D2BA69ull },
	{ 0x000024A242B24418ull, 0x000024A242B24418ull },
	{ 0x8000000898A7B3D8ull, 0x8000000898A7B3D8ull },
	{ 0x8000000000000053ull, 0x8000000000000053ull },
	{ 0x00000000031E9784ull, 0x00000000031E9784ull },
	{ 0x00000000000031D3ull, 0x00000000000031D3ull },
	{ 0x80015D52CB68E331ull, 0x80015D52CB68E331ull },
	{ 0x00000735DF11D7A7ull, 0x00000735DF11D7A7ull },
	{ 0x8000000000000024ull, 0x8000000000000024ull },
	{ 0x80000002DEAC1A3Bull, 0x80000002DEAC1A3Bull },
	{ 0x8000000000000E5Dull, 0x8000000000000E5Dull },
	{ 0x000000000323F913ull, 0x000000000323F913ull },
	{ 0x00000000194BD424ull, 0x00000000194BD424ull },
	{ 0x800000FD63DB3F44ull, 0x800000FD63DB3F44ull },
	{ 0x00000046D8F1D0A4ull, 0x00000046D8F1D0A4ull },
	{ 0x80005978ED086304ull, 0x80005978ED086304ull },
	{ 0x0000000160BF5EA7ull, 0x0000000160BF5EA7ull },
	{ 0x800013221AD288F1ull, 0x800013221AD288F1ull },
	{ 0x80000001F08FBC40ull, 0x80000001F08FBC40ull },
	{ 0x800000C3C0239782ull, 0x800000C3C0239782ull },
	{ 0x0000887DAB1EC9B3ull, 0x0000887DAB1EC9B3ull },
	{ 0x0000000000000CACull, 0x0000000000000CACull },
	{ 0x800000000005F75Eull, 0x800000000005F75Eull },
	{ 0x800104474FB90E6Cull, 0x800104474FB90E6Cull },
	{ 0x80000003FD3A30F1ull, 0x80000003FD3A30F1ull },
	{ 0x8002E562E67F6A5Bull, 0x8002E562E67F6A5Bull },
	{ 0x00000000000001F5ull, 0x00000000000001F5ull },
	{ 0x0000000026620DC4ull, 0x0000000026620DC4ull },
	{ 0x00040DCD31AB7AB3ull, 0x00040DCD31AB7AB3ull },
	{ 0x000000000017F117ull, 0x000000000017F117ull },
	{ 0x8000000B461046D4ull, 0x8000000B461046D4ull },
	{ 0x0003035883E7F263ull, 0x0003035883E7F263ull },
	{ 0x0000000074D6C48Eull, 0x0000000074D6C48Eull },
	{ 0x80005C0D18A1F637ull, 0x80005C0D18A1F637ull },
	{ 0x00000000019985BEull, 0x00000000019985BEull },
	{ 0x0000001E963BBF53ull, 0x0000001E963BBF53ull },
	{ 0x00000000000EE202ull, 0x00000000000EE202ull },
	{ 0x800000000000B104ull, 0x800000000000B104ull },
	{ 0x000000C6B9561C11ull, 0x000000C6B9561C11ull },
	{ 0x000000000032C97Eull, 0x000000000032C97Eull },
	{ 0x0000000B641FADDCull, 0x0000000B641FADDCull },
	{ 0x80000000000000A1ull, 0x80000000000000A1ull },
	{ 0x0000000000001F9Cull, 0x0000000000001F9Cull },
	{ 0x0000009DE2CCB50Full, 0x0000009DE2CCB50Full },
	{ 0x8000000000002779ull, 0x8000000000002779ull },
	{ 0x00008871904FAA05ull, 0x00008871904FAA05ull },
	{ 0x8002E445B3687355ull, 0x8002E445B3687355ull },
	{ 0x0005D28E0783A6AFull, 0x0005D28E0783A6AFull },
	{ 0x8000009A5F03FCE4ull, 0x8000009A5F03FCE4ull },
	{ 0x80000000000001B3ull, 0x80000000000001B3ull },
	{ 0x8000000000000001ull, 0x8000000000000001ull },
	{ 0x00000000000019DEull, 0x00000000000019DEull },
	{ 0x8000000000010542ull, 0x8000000000010542ull },
	{ 0x00000000001B7C58ull, 0x00000000001B7C58ull },
	{ 0x00000000000018CBull, 0x00000000000018CBull },
	{ 0x00070E8E4A859180ull, 0x00070E8E4A859180ull },
	{ 0x00000000000000DEull, 0x00000000000000DEull },
	{ 0x800000000000032Aull, 0x800000000000032Aull },
	{ 0x8000000000000045ull, 0x8000000000000045ull },
	{ 0x800000000000088Full, 0x800000000000088Full },
	{ 0x800066B451E6FFC6ull, 0x800066B451E6FFC6ull },
	{ 0x8000000000000031ull, 0x8000000000000031ull },
	{ 0x000000002C049D54ull, 0x000000002C049D54ull },
	{ 0x00000236220A6AF1ull, 0x00000236220A6AF1ull },
	{ 0x80000001A884ADC4ull, 0x80000001A884ADC4ull },
	{ 0x8000000000009B78ull, 0x8000000000009B78ull },
	{ 0x00000000000336EBull, 0x00000000000336EBull },
	{ 0x00000001EB4971DDull, 0x00000001EB4971DDull },
	{ 0x0000000000007EDDull, 0x0000000000007EDDull },
	{ 0x00000001C532482Aull, 0x00000001C532482Aull },
	{ 0x0000000F1E212955ull, 0x0000000F1E212955ull },
	{ 0x0000000000000E7Bull, 0x0000000000000E7Bull },
	{ 0x000000000000000Cull, 0x000000000000000Cull },
	{ 0x800002AB1FD23851ull, 0x800002AB1FD23851ull },
	{ 0x80000013F3BE3D82ull, 0x80000013F3BE3D82ull },
	{ 0x800000040C088F2Eull, 0x800000040C088F2Eull },
	{ 0x80000016AE1D6071ull, 0x80000016AE1D6071ull },
	{ 0x00000B6902D67F9Cull, 0x00000B6902D67F9Cull },
	{ 0x00012699FC5E07F4ull, 0x00012699FC5E07F4ull },
	{ 0x000000000000001Cull, 0x000000000000001Cull },
	{ 0x800000000013351Bull, 0x800000000013351Bull },
	{ 0x000117B7C2FB8459ull, 0x000117B7C2FB8459ull },
	{ 0x0000000000000003ull, 0x0000000000000003ull },
	{ 0x80000000007FC092ull, 0x80000000007FC092ull },
	{ 0x8000002E93EBE321ull, 0x8000002E93EBE321ull },
	{ 0x000000008A5342C3ull, 0x000000008A5342C3ull },
	{ 0x00000002E595D68Aull, 0x00000002E595D68Aull },
	{ 0x800001F26AE6FF61ull, 0x800001F26AE6FF61ull },
	{ 0x8000009CBDBF0632ull, 0x8000009CBDBF0632ull },
	{ 0x00000000002D1468ull, 0x00000000002D1468ull },
	{ 0x8000000000000005ull, 0x8000000000000005ull },
	{ 0x0000000000000005ull, 0x0000000000000005ull },
	{ 0x00000000009A4813ull, 0x00000000009A4813ull },
	{ 0x8000000000033018ull, 0x8000000000033018ull },
	{ 0x00000000007689D5ull, 0x00000000007689D5ull },
	{ 0x000B3226FB4156DFull, 0x000B3226FB4156DFull },
	{ 0x0000000180DC7649ull, 0x0000000180DC7649ull },
	{ 0x80017238D79B926Bull, 0x80017238D79B926Bull },
	{ 0x80001F0DCEBC58D7ull, 0x80001F0DCEBC58D7ull },
	{ 0x8000952BF1414019ull, 0x8000952BF1414019ull },
	{ 0x00000000008D8BBFull, 0x00000000008D8BBFull },
	{ 0x800000000000006Bull, 0x800000000000006Bull },
	{ 0x00000000000738D3ull, 0x00000000000738D3ull },
	{ 0x8000000000D61674ull, 0x8000000000D61674ull },
	{ 0x80000006CE9E627Aull, 0x80000006CE9E627Aull },
	{ 0x800000000000F6F7ull, 0x800000000000F6F7ull },
	{ 0x0000000000000C89ull, 0x0000000000000C89ull },
	{ 0x800000F43A59C6F3ull, 0x800000F43A59C6F3ull },
	{ 0x800000000702B24Eull, 0x800000000702B24Eull },
	{ 0x800000000000374Cull, 0x800000000000374Cull },
	{ 0x000767A6B1E4E329ull, 0x000767A6B1E4E329ull },
	{ 0x00000001F26E9A1Dull, 0x00000001F26E9A1Dull },
	{ 0x800000000000CD7Eull, 0x800000000000CD7Eull },
	{ 0x0000000074C49B18ull, 0x0000000074C49B18ull },
	{ 0x0000000000000007ull, 0x0000000000000007ull },
	{ 0x000000000063FB34ull, 0x000000000063FB34ull },
	{ 0x00000670541BB5C8ull, 0x00000670541BB5C8ull },
	{ 0x8000BF125ACD97EAull, 0x8000BF125ACD97EAull },
	{ 0x800000000000000Full, 0x800000000000000Full },
	{ 0x00000000000312CBull, 0x00000000000312CBull },
	{ 0x00000000000004B9ull, 0x00000000000004B9ull },
	{ 0x80000031EA35834Dull, 0x80000031EA35834Dull },
	{ 0x80000000000BD049ull, 0x80000000000BD049ull },
	{ 0x80000000DBEC9FEDull, 0x80000000DBEC9FEDull },
	{ 0x0000000000000026ull, 0x0000000000000026ull },
	{ 0x00000000033227BFull, 0x00000000033227BFull },
	{ 0x8000075B1529480Full, 0x8000075B1529480Full },
	{ 0x8000018296905BEEull, 0x8000018296905BEEull },
	{ 0x00016B1390638429ull, 0x00016B1390638429ull },
	{ 0x000000016C8E97FCull, 0x000000016C8E97FCull },
	{ 0x0000000000000003ull, 0x0000000000000003ull },
	{ 0x800000018FC1BF67ull, 0x800000018FC1BF67ull },
	{ 0x800000000000B26Eull, 0x800000000000B26Eull },
	{ 0x80031FFAD7665759ull, 0x80031FFAD7665759ull },
	{ 0x8000000000001FACull, 0x8000000000001FACull },
	{ 0x80000001354C9157ull, 0x80000001354C9157ull },
	{ 0x000000000000421Full, 0x000000000000421Full },
	{ 0x000005128452EF21ull, 0x000005128452EF21ull },
	{ 0x00000000000007B3ull, 0x00000000000007B3ull },
	{ 0x000000D43CF66B0Aull, 0x000000D43CF66B0Aull },
	{ 0x000000002726A58Dull, 0x000000002726A58Dull },
	{ 0x00000003886C3147ull, 0x00000003886C3147ull },
	{ 0x0000000003897113ull, 0x0000000003897113ull },
	{ 0x8000000177856717ull, 0x8000000177856717ull },
	{ 0x80000000000031E1ull, 0x80000000000031E1ull },
	{ 0x800000102E74E307ull, 0x800000102E74E307ull },
	{ 0x8000000000000BE6ull, 0x8000000000000BE6ull },
	{ 0x000015EE09A1C2EDull, 0x000015EE09A1C2EDull },
	{ 0x0000000000003762ull, 0x0000000000003762ull },
	{ 0x8000740A8CD3309Aull, 0x8000740A8CD3309Aull },
	{ 0x8000000000000167ull, 0x8000000000000167ull },
	{ 0x0000000000033BBAull, 0x0000000000033BBAull },
	{ 0x8000208FEFD553D2ull, 0x8000208FEFD553D2ull },
	{ 0x000000000000E6FBull, 0x000000000000E6FBull },
	{ 0x8000000007FE6B79ull, 0x8000000007FE6B79ull },
	{ 0x000000000000150Dull, 0x000000000000150Dull },
	{ 0x00000006FA634E96ull, 0x00000006FA634E96ull },
	{ 0x000000002F60B8D7ull, 0x000000002F60B8D7ull },
	{ 0x0000000002C9303Cull, 0x0000000002C9303Cull },
	{ 0x80024DCC0AADAECAull, 0x80024DCC0AADAECAull },
	{ 0x8000000000034D1Full, 0x8000000000034D1Full },
	{ 0x0000000A0C03FBC6ull, 0x0000000A0C03FBC6ull },
	{ 0x000000001BAA0560ull, 0x000000001BAA0560ull },
	{ 0x80000000000006B1ull, 0x80000000000006B1ull },
	{ 0x0000000000000087ull, 0x0000000000000087ull },
	{ 0x800000012CAD1530ull, 0x800000012CAD1530ull },
	{ 0x000000000000005Cull, 0x000000000000005Cull },
	{ 0x800000022A82FFE6ull, 0x800000022A82FFE6ull },
	{ 0x800000001AE76E60ull, 0x800000001AE76E60ull },
	{ 0x0000FEF8183D8459ull, 0x0000FEF8183D8459ull },
	{ 0x0000000000B2EA0Full, 0x0000000000B2EA0Full },
	{ 0x0000000007AC5335ull, 0x0000000007AC5335ull },
	{ 0x8000000000169BCEull, 0x8000000000169BCEull },
	{ 0x00014BDB4942BA1Full, 0x00014BDB4942BA1Full },
	{ 0x0002B93E168D4532ull, 0x0002B93E168D4532ull },
	{ 0x0003904D6DCBCDD2ull, 0x0003904D6DCBCDD2ull },
	{ 0x8000000000671640ull, 0x8000000000671640ull },
	{ 0x80013A2564A1D6BEull, 0x80013A2564A1D6BEull },
	{ 0x000000000000045Bull, 0x000000000000045Bull },
	{ 0x000000000000086Bull, 0x000000000000086Bull },
	{ 0x8000000000000001ull, 0x8000000000000001ull },
	{ 0x80000131514DA8E4ull, 0x80000131514DA8E4ull },
	{ 0x8003071752CD6E85ull, 0x8003071752CD6E85ull },
	{ 0x800000000009401Bull, 0x800000000009401Bull },
	{ 0x0000000000000004ull, 0x0000000000000004ull },
	{ 0x000000000000010Cull, 0x000000000000010Cull },
	{ 0x800000000065D617ull, 0x800000000065D617ull },
	{ 0x8000000000453541ull, 0x8000000000453541ull },
	{ 0x80000000000000ABull, 0x80000000000000ABull },
	{ 0x000000130BE2E0DCull, 0x000000130BE2E0DCull },
	{ 0x000000000010F85Cull, 0x000000000010F85Cull },
	{ 0x800000000000002Aull, 0x800000000000002Aull },
	{ 0x0000000001A7C098ull, 0x0000000001A7C098ull },
	{ 0x0000000001027F30ull, 0x0000000001027F30ull },
	{ 0x8000000000000010ull, 0x8000000000000010ull },
	{ 0x8000001CB253CC9Full, 0x8000001CB253CC9Full },
	{ 0x000000043BE39F7Dull, 0x000000043BE39F7Dull },
	{ 0x0000000000000002ull, 0x0000000000000002ull },
	{ 0x0000000001D2AC12ull, 0x0000000001D2AC12ull },
	{ 0x8000000DF7007E9Bull, 0x8000000DF7007E9Bull },
	{ 0x000000102E884086ull, 0x000000102E884086ull },
	{ 0x0000000000000003ull, 0x0000000000000003ull },
	{ 0x0000000000000002ull, 0x0000000000000002ull },
	{ 0x80000000000006F0ull, 0x80000000000006F0ull },
	{ 0x80011EC3A41DD56Dull, 0x80011EC3A41DD56Dull },
	{ 0x800000EC3146F12Aull, 0x800000EC3146F12Aull },
	{ 0x0000000000000722ull, 0x0000000000000722ull },
	{ 0x000000036157CD0Cull, 0x000000036157CD0Cull },
	{ 0x8000000000000F0Dull, 0x8000000000000F0Dull },
	{ 0x80000000C6488435ull, 0x80000000C6488435ull },
	{ 0x000031CD12EAE039ull, 0x000031CD12EAE039ull },
	{ 0x800000000052E0BFull, 0x800000000052E0BFull },
	{ 0x000000000000F6B9ull, 0x000000000000F6B9ull },
	{ 0x800003A03444D2E2ull, 0x800003A03444D2E2ull },
	{ 0x800000055B9DD6C1ull, 0x800000055B9DD6C1ull },
	{ 0x8000000000000029ull, 0x8000000000000029ull },
	{ 0x800000001844C451ull, 0x800000001844C451ull },
	{ 0x0000000000000F77ull, 0x0000000000000F77ull },
	{ 0x00000000000F27B6ull, 0x00000000000F27B6ull },
	{ 0x000000000000000Eull, 0x000000000000000Eull },
	{ 0x0000000001BC90A2ull, 0x0000000001BC90A2ull },
	{ 0x00000000000003EAull, 0x00000000000003EAull },
	{ 0x00001C673B99FCACull, 0x00001C673B99FCACull },
	{ 0x0000000002B61B8Bull, 0x0000000002B61B8Bull },
	{ 0x8000000000000052ull, 0x8000000000000052ull },
	{ 0x0000000000000001ull, 0x0000000000000001ull },
	{ 0x800027F18F11DEF3ull, 0x800027F18F11DEF3ull },
	{ 0x0000000000000006ull, 0x0000000000000006ull },
	{ 0x000001917B4822E3ull, 0x000001917B4822E3ull },
	{ 0x8000040E0505D097ull, 0x8000040E0505D097ull },
	{ 0x00000001DEACC588ull, 0x00000001DEACC588ull },
	{ 0x800000000001343Cull, 0x800000000001343Cull },
	{ 0x00000000005E71C0ull, 0x00000000005E71C0ull },
	{ 0x800000000000001Aull, 0x800000000000001Aull },
	{ 0x80000000000002C6ull, 0x80000000000002C6ull },
	{ 0x8000000000264CBCull, 0x8000000000264CBCull },
	{ 0x0000000000000070ull, 0x0000000000000070ull },
	{ 0x8005C6CC64DC08D0ull, 0x8005C6CC64DC08D0ull },
	{ 0x00000000000000D4ull, 0x00000000000000D4ull },
	{ 0x0000038ED6BDAE9Dull, 0x0000038ED6BDAE9Dull },
	{ 0x00000004F0F66D92ull, 0x00000004F0F66D92ull },
	{ 0x8000000000000063ull, 0x8000000000000063ull },
	{ 0x80000000009AEA2Full, 0x80000000009AEA2Full },
	{ 0x8000000000002A41ull, 0x8000000000002A41ull },
	{ 0x0000000000000089ull, 0x0000000000000089ull },
	{ 0x80000005932AE4DCull, 0x80000005932AE4DCull },
	{ 0x0000000000000005ull, 0x0000000000000005ull },
	{ 0x0000000000008771ull, 0x0000000000008771ull },
	{ 0x80000016B0C3523Eull, 0x80000016B0C3523Eull },
	{ 0x80071F83B5077BC2ull, 0x80071F83B5077BC2ull },
	{ 0x00000169F391D74Full, 0x00000169F391D74Full },
	{ 0x0000000121B0D915ull, 0x0000000121B0D915ull },
	{ 0x80000C6BCA41DE00ull, 0x80000C6BCA41DE00ull },
	{ 0x8000000015E9B383ull, 0x8000000015E9B383ull },
	{ 0x80000001C98013A4ull, 0x80000001C98013A4ull },
	{ 0x0000000017C5B30Bull, 0x0000000017C5B30Bull },
	{ 0x00000000000000FEull, 0x00000000000000FEull },
	{ 0x000000800C2991F5ull, 0x000000800C2991F5ull },
	{ 0x8000000000007E8Dull, 0x8000000000007E8Dull },
	{ 0x0000000007BD03EEull, 0x0000000007BD03EEull },
	{ 0x8000000000000DEFull, 0x8000000000000DEFull },
	{ 0x800D7787B545379Dull, 0x800D7787B545379Dull },
	{ 0x800000000000004Full, 0x800000000000004Full },
	{ 0x0000000000000147ull, 0x0000000000000147ull },
	{ 0x80000000CAFC3C6Cull, 0x80000000CAFC3C6Cull },
	{ 0x000063C7B3574D49ull, 0x000063C7B3574D49ull },
	{ 0x80000000001B88BAull, 0x80000000001B88BAull },
	{ 0x000B4C72A978965Full, 0x000B4C72A978965Full },
	{ 0x8000000000000024ull, 0x8000000000000024ull },
	{ 0x0000000000000B60ull, 0x0000000000000B60ull },
	{ 0x8000001827CC2E77ull, 0x8000001827CC2E77ull },
	{ 0x80000000000000B3ull, 0x80000000000000B3ull },
	{ 0x000002562FD6B879ull, 0x000002562FD6B879ull },
	{ 0x0000005174EEB699ull, 0x0000005174EEB699ull },
	{ 0x800000000000008Eull, 0x800000000000008Eull },
	{ 0x00000006D3589455ull, 0x00000006D3589455ull },
	{ 0x8000000000000011ull, 0x8000000000000011ull },
	{ 0x80000000000000C2ull, 0x80000000000000C2ull },
	{ 0x80000000000002A6ull, 0x80000000000002A6ull },
	{ 0x000000000A0B4CB8ull, 0x000000000A0B4CB8ull },
	{ 0x800000000000A1B2ull, 0x800000000000A1B2ull },
	{ 0x8007E9FAF8AE552Bull, 0x8007E9FAF8AE552Bull },
	{ 0x00000000000000DDull, 0x00000000000000DDull },
	{ 0x80000000003DAE83ull, 0x80000000003DAE83ull },
	{ 0x000000000001EA61ull, 0x000000000001EA61ull },
	{ 0x000000000205C1DAull, 0x000000000205C1DAull },
	{ 0x8000000000000001ull, 0x8000000000000001ull },
	{ 0x000471C90C7CDB14ull, 0x000471C90C7CDB14ull },
	{ 0x8000000000032DF6ull, 0x8000000000032DF6ull },
	{ 0x800000022F86D04Eull, 0x800000022F86D04Eull },
	{ 0x800001F3625A6088ull, 0x800001F3625A6088ull },
	{ 0x000000000017E493ull, 0x000000000017E493ull },
	{ 0x8003FB2FE5FB6C2Dull, 0x8003FB2FE5FB6C2Dull },
	{ 0x00000D8840B8EC98ull, 0x00000D8840B8EC98ull },
	{ 0x00000000029261DBull, 0x00000000029261DBull },
	{ 0x8000000000D60B89ull, 0x8000000000D60B89ull },
	{ 0x0000000000B80C77ull, 0x0000000000B80C77ull },
	{ 0x0000000000E3CB1Cull, 0x0000000000E3CB1Cull },
	{ 0x0000000001956172ull, 0x0000000001956172ull },
	{ 0x000020BD381B5170ull, 0x000020BD381B5170ull },
	{ 0x8000000000005C20ull, 0x8000000000005C20ull },
	{ 0x00000CE274585AD1ull, 0x00000CE274585AD1ull },
	{ 0x8000000D5104DCD3ull, 0x8000000D5104DCD3ull },
	{ 0x00000F431E047ECDull, 0x00000F431E047ECDull },
	{ 0x000000000000CE7Bull, 0x000000000000CE7Bull },
	{ 0x8000000000000555ull, 0x8000000000000555ull },
	{ 0x0000000000000003ull, 0x0000000000000003ull },
	{ 0x00000000234FBCA5ull, 0x00000000234FBCA5ull },
	{ 0x80000000001A2E1Eull, 0x80000000001A2E1Eull },
	{ 0x000000014B442FE1ull, 0x000000014B442FE1ull },
	{ 0x80001ABD6625202Bull, 0x80001ABD6625202Bull },
	{ 0x8001F31ED168C878ull, 0x8001F31ED168C878ull },
	{ 0x00000000000BBD25ull, 0x00000000000BBD25ull },
	{ 0x000000001CABDCFBull, 0x000000001CABDCFBull },
	{ 0x0000000000005861ull, 0x0000000000005861ull },
	{ 0x8000000001491890ull, 0x8000000001491890ull },
	{ 0x80000000040A5892ull, 0x80000000040A5892ull },
	{ 0x800000400BF745A3ull, 0x800000400BF745A3ull },
	{ 0x8000000000000D34ull, 0x8000000000000D34ull },
	{ 0x0000000000016EFAull, 0x0000000000016EFAull },
	{ 0x800000000198FBFEull, 0x800000000198FBFEull },
	{ 0x8000000000007327ull, 0x8000000000007327ull },
	{ 0x8000000000000002ull, 0x8000000000000002ull },
	{ 0x8000000000000081ull, 0x8000000000000081ull },
	{ 0x800002795372E376ull, 0x800002795372E376ull },
	{ 0x0000000000000001ull, 0x0000000000000001ull },
	{ 0x8000000000000050ull, 0x8000000000000050ull },
	{ 0x80000000000067BAull, 0x80000000000067BAull },
	{ 0x000013ECF2ABE024ull, 0x000013ECF2ABE024ull },
	{ 0x800001BF935FBBF9ull, 0x800001BF935FBBF9ull },
	{ 0x0000000000003406ull, 0x0000000000003406ull },
	{ 0x000000000002460Bull, 0x000000000002460Bull },
	{ 0x8000000DE9457EA6ull, 0x8000000DE9457EA6ull },
	{ 0x8000003FC3F0B6BBull, 0x8000003FC3F0B6BBull },
	{ 0x00000000354D75A9ull, 0x00000000354D75A9ull },
	{ 0x00000000001DD2C3ull, 0x00000000001DD2C3ull },
	{ 0x0000000042DA2230ull, 0x0000000042DA2230ull },
	{ 0x8000000004E7605Aull, 0x8000000004E7605Aull },
	{ 0x0000000090B0CEF9ull, 0x0000000090B0CEF9ull },
	{ 0x800212606D115383ull, 0x800212606D115383ull },
	{ 0x8000000000022C01ull, 0x8000000000022C01ull },
	{ 0x800000000049F853ull, 0x800000000049F853ull },
	{ 0x80000001E0F35365ull, 0x80000001E0F35365ull },
	{ 0x000000000000CBBAull, 0x000000000000CBBAull },
	{ 0x8000000002FDCA1Aull, 0x8000000002FDCA1Aull },
	{ 0x800000000BBCB3F5ull, 0x800000000BBCB3F5ull },
	{ 0x000000614D49C850ull, 0x000000614D49C850ull },
	{ 0x000059E8A1169D6Cull, 0x000059E8A1169D6Cull },
	{ 0x00000065080B529Eull, 0x00000065080B529Eull },
	{ 0x00000000000001E8ull, 0x00000000000001E8ull },
	{ 0x800000001730513Cull, 0x800000001730513Cull },
	{ 0x800CE317FADC8591ull, 0x800CE317FADC8591ull },
	{ 0x8000001A8B68E338ull, 0x8000001A8B68E338ull },
	{ 0x80000CBBF06DB357ull, 0x80000CBBF06DB357ull },
	{ 0x000000009B054413ull, 0x000000009B054413ull },
	{ 0x8000000000000001ull, 0x8000000000000001ull },
	{ 0x000000000001F568ull, 0x000000000001F568ull },
	{ 0x0000000002538E9Full, 0x0000000002538E9Full },
	{ 0x80000000000008C1ull, 0x80000000000008C1ull },
	{ 0x000002B38D0B5A48ull, 0x000002B38D0B5A48ull },
	{ 0x00000038631E3581ull, 0x00000038631E3581ull },
	{ 0x000000671E2DDD76ull, 0x000000671E2DDD76ull },
	{ 0x8000000139EDC8B8ull, 0x8000000139EDC8B8ull },
	{ 0x8000000020F7C1A4ull, 0x8000000020F7C1A4ull },
	{ 0x0000000388F47D54ull, 0x0000000388F47D54ull },
	{ 0x000000000000000Bull, 0x000000000000000Bull },
	{ 0x8000000000000011ull, 0x8000000000000011ull },
	{ 0x8000000001A0960Bull, 0x8000000001A0960Bull },
	{ 0x800000000016B417ull, 0x800000000016B417ull },
	{ 0x8000000000011C27ull, 0x8000000000011C27ull },
	{ 0x0000005AE5FC22CCull, 0x0000005AE5FC22CCull },
	{ 0x8000000119616C00ull, 0x8000000119616C00ull },
	{ 0x80003FE6C78C5339ull, 0x80003FE6C78C5339ull },
	{ 0x000000749A1F9C45ull, 0x000000749A1F9C45ull },
	{ 0x000000000185FCBAull, 0x000000000185FCBAull },
	{ 0x8000000000000218ull, 0x8000000000000218ull },
	{ 0x000000000003B756ull, 0x000000000003B756ull },
	{ 0x00000001C7A0EAACull, 0x00000001C7A0EAACull },
	{ 0x8000000063D992F3ull, 0x8000000063D992F3ull },
	{ 0x0000000000000065ull, 0x0000000000000065ull },
	{ 0x800000002B8A0752ull, 0x800000002B8A0752ull },
	{ 0x00000000299BF3D5ull, 0x00000000299BF3D5ull },
	{ 0x00000001C913E15Dull, 0x00000001C913E15Dull },
	{ 0x800000010751D720ull, 0x800000010751D720ull },
	{ 0x000000001D6ED2A7ull, 0x000000001D6ED2A7ull },
	{ 0x000000000000015Full, 0x000000000000015Full },
	{ 0x800DB2F9206D1791ull, 0x800DB2F9206D1791ull },
	{ 0x8000000001E9FACCull, 0x8000000001E9FACCull },
	{ 0x80000000003CF764ull, 0x80000000003CF764ull },
	{ 0x0000000002682EB8ull, 0x0000000002682EB8ull },
	{ 0x800000000167C7CBull, 0x800000000167C7CBull },
	{ 0x8000329433A40661ull, 0x8000329433A40661ull },
	{ 0x80000000000028C3ull, 0x80000000000028C3ull },
	{ 0x8004CA92A76F2FF4ull, 0x8004CA92A76F2FF4ull },
	{ 0x0000000000000001ull, 0x0000000000000001ull },
	{ 0x000000000000002Bull, 0x000000000000002Bull },
	{ 0x800000000004CD1Aull, 0x800000000004CD1Aull },
	{ 0x000000025B4CD5BDull, 0x000000025B4CD5BDull },
	{ 0x000000000002E753ull, 0x000000000002E753ull },
	{ 0x8000000000000083ull, 0x8000000000000083ull },
	{ 0x925D23D73313116Bull, 0x925D23D73313116Bull },
	{ 0x5A03641B4A9DCFF4ull, 0x5A03641B4A9DCFF4ull },
	{ 0xCAC40DA1ABC84504ull, 0xCAC40DA1ABC84504ull },
	{ 0x3867AFA5D9343E3Dull, 0x3867AFA5D9343E3Dull },
	{ 0xB26C12E63924A805ull, 0xB26C12E63924A805ull },
	{ 0xB8D5FD7583ED0C8Aull, 0xB8D5FD7583ED0C8Aull },
	{ 0x24D0BE397BD13395ull, 0x24D0BE397BD13395ull },
	{ 0x858F0001FA92DD8Eull, 0x858F0001FA92DD8Eull },
	{ 0xB0D866334A4BA3D0ull, 0xB0D866334A4BA3D0ull },
	{ 0xC8076ECED1D0F52Eull, 0xC8076ECED1D0F52Eull },
	{ 0xF0831EB50F403545ull, 0xF0831EB50F403545ull },
	{ 0x80E7F54BE330F983ull, 0x80E7F54BE330F983ull },
	{ 0x6FDDFD26B8191F0Aull, 0x6FDDFD26B8191F0Aull },
	{ 0x212445BFD2990988ull, 0x212445BFD2990988ull },
	{ 0x513838B41BF0CDCBull, 0x513838B41BF0CDCBull },
	{ 0x194F8CCD787C075Bull, 0x194F8CCD787C075Bull },
	{ 0xE3C53183B5B35B06ull, 0xE3C53183B5B35B06ull },
	{ 0x89E39D6AB9CF5FFEull, 0x89E39D6AB9CF5FFEull },
	{ 0x95AC42D1C1851F32ull, 0x95AC42D1C1851F32ull },
	{ 0xE749AE02AFC23F6Cull, 0xE749AE02AFC23F6Cull },
	{ 0x7F41CA606CAEC92Bull, 0x7F41CA606CAEC92Bull },
	{ 0x2BE5CFF3541A8BC2ull, 0x2BE5CFF3541A8BC2ull },
	{ 0x5B355882B51C2431ull, 0x5B355882B51C2431ull },
	{ 0x50821E4A6107A443ull, 0x50821E4A6107A443ull },
	{ 0xFE59E02B4A42D568ull, 0xFE59E02B4A42D568ull },
	{ 0x4403EF86331D22D3ull, 0x4403EF86331D22D3ull },
	{ 0xCFB7E67F6CB11B57ull, 0xCFB7E67F6CB11B57ull },
	{ 0xE3CB041AA6759AFEull, 0xE3CB041AA6759AFEull },
	{ 0xC0D9B30DCCC48E6Bull, 0xC0D9B30DCCC48E6Bull },
	{ 0x734AB6D9F8BD5A71ull, 0x734AB6D9F8BD5A71ull },
	{ 0x453180896D48E0F3ull, 0x453180896D48E0F3ull },
	{ 0x142D2D81A8E5287Eull, 0x142D2D81A8E5287Eull },
	{ 0x4AB9ABA881BEA024ull, 0x4AB9ABA881BEA024ull },
	{ 0x3E70880B567D079Aull, 0x3E70880B567D079Aull },
	{ 0x318EE3A74D49F315ull, 0x318EE3A74D49F315ull },
	{ 0x387E1101A276F360ull, 0x387E1101A276F360ull },
	{ 0xC3F45A2F064959C1ull, 0xC3F45A2F064959C1ull },
	{ 0x8E9B6D990E51A08Eull, 0x8E9B6D990E51A08Eull },
	{ 0xAEA1F3C0B2946F0Aull, 0xAEA1F3C0B2946F0Aull },
	{ 0x8BA5CD2CDD2B4005ull, 0x8BA5CD2CDD2B4005ull },
	{ 0xF87C77240922A833ull, 0xF87C77240922A833ull },
	{ 0x30A719DFF23C3B4Bull, 0x30A719DFF23C3B4Bull },
	{ 0xFA87BD9A525A12E3ull, 0xFA87BD9A525A12E3ull },
	{ 0x2CC52821B279F50Aull, 0x2CC52821B279F50Aull },
	{ 0x5832E2D5478618A7ull, 0x5832E2D5478618A7ull },
	{ 0x558AE736E3A18C10ull, 0x558AE736E3A18C10ull },
	{ 0xB0892D87A6555DC6ull, 0xB0892D87A6555DC6ull },
	{ 0xE0B405DF6D7D7EFCull, 0xE0B405DF6D7D7EFCull },
	{ 0x4C5E6DC51A50A3B2ull, 0x4C5E6DC51A50A3B2ull },
	{ 0x67B5E1C67F6375E1ull, 0x67B5E1C67F6375E1ull },
	{ 0x9C6464D520F47110ull, 0x9C6464D520F47110ull },
	{ 0x621490AE3423BEF9ull, 0x621490AE3423BEF9ull },
	{ 0xC0032F5D7DDA5997ull, 0xC0032F5D7DDA5997ull },
	{ 0x91DC5922F7C51EF0ull, 0x91DC5922F7C51EF0ull },
	{ 0xC650D2C9D2222890ull, 0xC650D2C9D2222890ull },
	{ 0x5B602717D81C6708ull, 0x5B602717D81C6708ull },
	{ 0x1DB327FA69B5D529ull, 0x1DB327FA69B5D529ull },
	{ 0x6C70587800D64D01ull, 0x6C70587800D64D01ull },
	{ 0x34ABA29E9CFB2745ull, 0x34ABA29E9CFB2745ull },
	{ 0xA3DAEF958DEFE6A7ull, 0xA3DAEF958DEFE6A7ull },
	{ 0xDFF1B4D90C532070ull, 0xDFF1B4D90C532070ull },
	{ 0x07C25F4FA45EE1B9ull, 0x07C25F4FA45EE1B9ull },
	{ 0xB67211EDE2C3B824ull, 0xB67211EDE2C3B824ull },
	{ 0xAC9CAFDA0F6A4D2Dull, 0xAC9CAFDA0F6A4D2Dull },
	{ 0x6C8230D838032231ull, 0x6C8230D838032231ull },
	{ 0x0B48BC398C4273BEull, 0x0B48BC398C4273BEull },
	{ 0xF5670CBA0886329Dull, 0xF5670CBA0886329Dull },
	{ 0xE7C29BA76F04239Dull, 0xE7C29BA76F04239Dull },
	{ 0x5C05153C95FE1F21ull, 0x5C05153C95FE1F21ull },
	{ 0xA984926BFF5A6CECull, 0xA984926BFF5A6CECull },
	{ 0x1A221E84C6DE412Bull, 0x1A221E84C6DE412Bull },
	{ 0x330A010CDA685F43ull, 0x330A010CDA685F43ull },
	{ 0xF12951BB86E9D2DCull, 0xF12951BB86E9D2DCull },
	{ 0xBA34542F523ACF2Dull, 0xBA34542F523ACF2Dull },
	{ 0x64918879F6397D21ull, 0x64918879F6397D21ull },
	{ 0xF29164578A4C78EDull, 0xF29164578A4C78EDull },
	{ 0xE2152CFF241CECA4ull, 0xE2152CFF241CECA4ull },
	{ 0xFE5A160FEF187E80ull, 0xFE5A160FEF187E80ull },
	{ 0xBC05189FD2655DD6ull, 0xBC05189FD2655DD6ull },
	{ 0x8380195B6C67EAD1ull, 0x8380195B6C67EAD1ull },
	{ 0x6AFB88D856AD2564ull, 0x6AFB88D856AD2564ull },
	{ 0x45800A4738163A72ull, 0x45800A4738163A72ull },
	{ 0x45DFA408A8F3313Cull, 0x45DFA408A8F3313Cull },
	{ 0xF4DDF5F7E51ABB8Aull, 0xF4DDF5F7E51ABB8Aull },
	{ 0xBCBEF98E4EED219Cull, 0xBCBEF98E4EED219Cull },
	{ 0xC743C992C31050D3ull, 0xC743C992C31050D3ull },
	{ 0x7104F0F7BAD3089Bull, 0x7104F0F7BAD3089Bull },
	{ 0x8FC1C31B3F452B9Bull, 0x8FC1C31B3F452B9Bull },
	{ 0xCD743A4BAC332A1Full, 0xCD743A4BAC332A1Full },
	{ 0x56B0E0A4431291C5ull, 0x56B0E0A4431291C5ull },
	{ 0x9DD23E248F0DBBE6ull, 0x9DD23E248F0DBBE6ull },
	{ 0xF187515595FC99C6ull, 0xF187515595FC99C6ull },
	{ 0xA7648DDFDCF8A57Full, 0xA7648DDFDCF8A57Full },
	{ 0x9AFEE4653AD9ECABull, 0x9AFEE4653AD9ECABull },
	{ 0x407052817BCB4150ull, 0x407052817BCB4150ull },
	{ 0x0B3D79C4D3438590ull, 0x0B3D79C4D3438590ull },
	{ 0xE8BBBECB1FD21B10ull, 0xE8BBBECB1FD21B10ull },
	{ 0x8F5F71C2FD0C7128ull, 0x8F5F71C2FD0C7128ull },
	{ 0x61017D07A88AB14Cull, 0x61017D07A88AB14Cull },
	{ 0x22041D40B2C18E3Aull, 0x22041D40B2C18E3Aull },
	{ 0xC3A6206A83A73365ull, 0xC3A6206A83A73365ull },
	{ 0x4F3A24A6BEFB7448ull, 0x4F3A24A6BEFB7448ull },
	{ 0xFE5E8D63E76AB4D0ull, 0xFE5E8D63E76AB4D0ull },
	{ 0xC07329058AFFBEC4ull, 0xC07329058AFFBEC4ull },
	{ 0x7621B6D238DE657Aull, 0x7621B6D238DE657Aull },
	{ 0x46D7AFBF24E4B5C6ull, 0x46D7AFBF24E4B5C6ull },
	{ 0xCE781C67D92BBAB5ull, 0xCE781C67D92BBAB5ull },
	{ 0xE2912719673A576Bull, 0xE2912719673A576Bull },
	{ 0xCEA37A032E800B67ull, 0xCEA37A032E800B67ull },
	{ 0x73A66A49A9B6E154ull, 0x73A66A49A9B6E154ull },
	{ 0xCA8336F3C939012Dull, 0xCA8336F3C939012Dull },
	{ 0xC0DA967C2BF5F463ull, 0xC0DA967C2BF5F463ull },
	{ 0xED86A8E1E53D6A4Cull, 0xED86A8E1E53D6A4Cull },
	{ 0x555AC9026B0EDBA0ull, 0x555AC9026B0EDBA0ull },
	{ 0xF2DE463D56F09581ull, 0xF2DE463D56F09581ull },
	{ 0x57E68E869B09F305ull, 0x57E68E869B09F305ull },
	{ 0x41FF27167CE64EBAull, 0x41FF27167CE64EBAull },
	{ 0xC3D14E994F81417Bull, 0xC3D14E994F81417Bull },
	{ 0x4442A3CA20CA3522ull, 0x4442A3CA20CA3522ull },
	{ 0x736749E9A521031Cull, 0x736749E9A521031Cull },
	{ 0x5AA9BEBB7837D4DDull, 0x5AA9BEBB7837D4DDull },
	{ 0x412CA52E2F8F32EBull, 0x412CA52E2F8F32EBull },
	{ 0x553408BFA44E1D46ull, 0x553408BFA44E1D46ull },
	{ 0x46AA140DF7F3B70Full, 0x46AA140DF7F3B70Full },
	{ 0xDA841D3DAFD03044ull, 0xDA841D3DAFD03044ull },
	{ 0xBF7B23FF1D5E7C8Aull, 0xBF7B23FF1D5E7C8Aull },
	{ 0xE341DA0669DC092Eull, 0xE341DA0669DC092Eull },
	{ 0xE76BC5C9B679A8B3ull, 0xE76BC5C9B679A8B3ull },
	{ 0xC6732744A62F74E6ull, 0xC6732744A62F74E6ull },
	{ 0xC56DD6CE51F83A7Full, 0xC56DD6CE51F83A7Full },
	{ 0xCDF4912743D56FFAull, 0xCDF4912743D56FFAull },
	{ 0xFA7AEFFB5F09F33Aull, 0xFA7AEFFB5F09F33Aull },
	{ 0x747A14F84AA2D63Aull, 0x747A14F84AA2D63Aull },
	{ 0xFE18D3F7ED24BC4Full, 0xFE18D3F7ED24BC4Full },
	{ 0xFC2D091E94AC2A20ull, 0xFC2D091E94AC2A20ull },
	{ 0x55757E5376DF6F4Bull, 0x55757E5376DF6F4Bull },
	{ 0xCA96D7E7378B4744ull, 0xCA96D7E7378B4744ull },
	{ 0xCF81299C12D145FFull, 0xCF81299C12D145FFull },
	{ 0x4D2976BDF99479D9ull, 0x4D2976BDF99479D9ull },
	{ 0xF1CE31B03FC5C3C2ull, 0xF1CE31B03FC5C3C2ull },
	{ 0xE6346B005DED2A00ull, 0xE6346B005DED2A00ull },
	{ 0xFE31D34A4CCE2C09ull, 0xFE31D34A4CCE2C09ull },
	{ 0x7CA01E2032D1BF8Dull, 0x7CA01E2032D1BF8Dull },
	{ 0xD9128DB987DCB5D4ull, 0xD9128DB987DCB5D4ull },
	{ 0xE6F543799F6EA951ull, 0xE6F543799F6EA951ull },
	{ 0x503FA78BADD6A0E6ull, 0x503FA78BADD6A0E6ull },
	{ 0xBF4F7473E4BA9D8Eull, 0xBF4F7473E4BA9D8Eull },
	{ 0xD5BAA3D66446B6EBull, 0xD5BAA3D66446B6EBull },
	{ 0xE46556266682EA75ull, 0xE46556266682EA75ull },
	{ 0xFD63480EFC0D420Eull, 0xFD63480EFC0D420Eull },
	{ 0xDCB1A3444AF2D678ull, 0xDCB1A3444AF2D678ull },
	{ 0xF87AF67CDEDDF629ull, 0xF87AF67CDEDDF629ull },
	{ 0x73DB68F135FB68D0ull, 0x73DB68F135FB68D0ull },
	{ 0xD796D0CF122DFA80ull, 0xD796D0CF122DFA80ull },
	{ 0xFE7961AC80725138ull, 0xFE7961AC80725138ull },
	{ 0x45C0967AAF689063ull, 0x45C0967AAF689063ull },
	{ 0xD2994F32474B1398ull, 0xD2994F32474B1398ull },
	{ 0xEFCE375DFBB9DD85ull, 0xEFCE375DFBB9DD85ull },
	{ 0xD4F18409D8229CCFull, 0xD4F18409D8229CCFull },
	{ 0xDE3E433E46726FAAull, 0xDE3E433E46726FAAull },
	{ 0xF94D65653C43D82Aull, 0xF94D65653C43D82Aull },
	{ 0x5F438E9708782157ull, 0x5F438E9708782157ull },
	{ 0xF0724B9E704887A2ull, 0xF0724B9E704887A2ull },
	{ 0xF7699CC4667D1283ull, 0xF7699CC4667D1283ull },
	{ 0x64FC4CB71FA96A5Full, 0x64FC4CB71FA96A5Full },
	{ 0xC46693EABD01C19Eull, 0xC46693EABD01C19Eull },
	{ 0xCF55F844303422ABull, 0xCF55F844303422ABull },
	{ 0xE99EAB54CB638FFBull, 0xE99EAB54CB638FFBull },
	{ 0x4AFF67210BC99FA5ull, 0x4AFF67210BC99FA5ull },
	{ 0x6D33074B17E4478Full, 0x6D33074B17E4478Full },
	{ 0xD15F4F1E0824B252ull, 0xD15F4F1E0824B252ull },
	{ 0xF750590FE7AAAFBDull, 0xF750590FE7AAAFBDull },
	{ 0xFDA499106315A563ull, 0xFDA499106315A563ull },
	{ 0xD8D6B9C0B68CFEB3ull, 0xD8D6B9C0B68CFEB3ull },
	{ 0xD5035D5346312667ull, 0xD5035D5346312667ull },
	{ 0xD1C3867CDE21DC3Dull, 0xD1C3867CDE21DC3Dull },
	{ 0x6673B5A8D980C6D0ull, 0x6673B5A8D980C6D0ull },
	{ 0xC03EF781142524EDull, 0xC03EF781142524EDull },
	{ 0xF723690D051FFCDFull, 0xF723690D051FFCDFull },
	{ 0x54E2A704DEF96F21ull, 0x54E2A704DEF96F21ull },
	{ 0xE02B6DB62A3CD955ull, 0xE02B6DB62A3CD955ull },
	{ 0xFB8B065BE935EE01ull, 0xFB8B065BE935EE01ull },
	{ 0x5BE346748B0E32BBull, 0x5BE346748B0E32BBull },
	{ 0x6653AD666D83F8DDull, 0x6653AD666D83F8DDull },
	{ 0x442F1E1E8543A624ull, 0x442F1E1E8543A624ull },
	{ 0x5CD8BA67E89BE12Bull, 0x5CD8BA67E89BE12Bull },
	{ 0x7BC33D2D5A9C9E74ull, 0x7BC33D2D5A9C9E74ull },
	{ 0x476EE6F531E80701ull, 0x476EE6F531E80701ull },
	{ 0x4E235B523A62A0D9ull, 0x4E235B523A62A0D9ull },
	{ 0xC8ADCD97F647E30Full, 0xC8ADCD97F647E30Full },
	{ 0xCDD134FC016F12CCull, 0xCDD134FC016F12CCull },
	{ 0xF9FFF5DA13A33D7Full, 0xF9FFF5DA13A33D7Full },
	{ 0x654AB36E88E470D6ull, 0x654AB36E88E470D6ull },
	{ 0xE9FDE9CAC3416D04ull, 0xE9FDE9CAC3416D04ull },
	{ 0x5A0493B159A89F4Dull, 0x5A0493B159A89F4Dull },
	{ 0x7F808F9D97866F1Aull, 0x7F808F9D97866F1Aull },
	{ 0x522045675018F3F2ull, 0x522045675018F3F2ull },
	{ 0x64559A2CD4AE8806ull, 0x64559A2CD4AE8806ull },
	{ 0x48ECD6CD88837370ull, 0x48ECD6CD88837370ull },
	{ 0xFAB19432B7CC3755ull, 0xFAB19432B7CC3755ull },
	{ 0xE4A9CF2ABEED7BECull, 0xE4A9CF2ABEED7BECull },
	{ 0x5C90546C4FBBD241ull, 0x5C90546C4FBBD241ull },
	{ 0xFCDC1CDC126463CAull, 0xFCDC1CDC126463CAull },
	{ 0xCD272F94975F6639ull, 0xCD272F94975F6639ull },
	{ 0x67F81EA4B85992F3ull, 0x67F81EA4B85992F3ull },
	{ 0x456EED08C96683C4ull, 0x456EED08C96683C4ull },
	{ 0x68BB39B2294B997Dull, 0x68BB39B2294B997Dull },
	{ 0xF142001C89C9F057ull, 0xF142001C89C9F057ull },
	{ 0x5550DCA31002FF08ull, 0x5550DCA31002FF08ull },
	{ 0x4367784327BEBE40ull, 0x4367784327BEBE40ull },
	{ 0xC52D85763D4C459Cull, 0xC52D85763D4C459Cull },
	{ 0x4DCE5B0FF2401C52ull, 0x4DCE5B0FF2401C52ull },
	{ 0x6102FCDA78CA32A2ull, 0x6102FCDA78CA32A2ull },
	{ 0xC7F0E3BAFD48A374ull, 0xC7F0E3BAFD48A374ull },
	{ 0xC26DF58EDFDFE171ull, 0xC26DF58EDFDFE171ull },
	{ 0x59ECCDA8509EF5A6ull, 0x59ECCDA8509EF5A6ull },
	{ 0xE95B99B4F1EC7313ull, 0xE95B99B4F1EC7313ull },
	{ 0xC9B1A7A9ADE80B43ull, 0xC9B1A7A9ADE80B43ull },
	{ 0x7933C2D5AAB4C2DEull, 0x7933C2D5AAB4C2DEull },
	{ 0x5A3B9AFCD426CA6Dull, 0x5A3B9AFCD426CA6Dull },
	{ 0xD4F2393B116C2450ull, 0xD4F2393B116C2450ull },
	{ 0xC46892EA630491EAull, 0xC46892EA630491EAull },
	{ 0xC93953A2DCAAA435ull, 0xC93953A2DCAAA435ull },
	{ 0xFD39E6E5D52B26E4ull, 0xFD39E6E5D52B26E4ull },
	{ 0xF500A79584527C7Full, 0xF500A79584527C7Full },
	{ 0x44CC06E105AFE4ADull, 0x44CC06E105AFE4ADull },
	{ 0x5E121860D3CAA097ull, 0x5E121860D3CAA097ull },
	{ 0x7E3432A0440A8C83ull, 0x7E3432A0440A8C83ull },
	{ 0xE7972D0FE5DAA189ull, 0xE7972D0FE5DAA189ull },
	{ 0xFE94B3398F48B22Aull, 0xFE94B3398F48B22Aull },
	{ 0x496B23BB23D5AA28ull, 0x496B23BB23D5AA28ull },
	{ 0x4A8B6A59DDD9E7DEull, 0x4A8B6A59DDD9E7DEull },
	{ 0x796093F283492A37ull, 0x796093F283492A37ull },
	{ 0xEF6A2E3EDF1E0994ull, 0xEF6A2E3EDF1E0994ull },
	{ 0xC2943ECE510ED5AEull, 0xC2943ECE510ED5AEull },
	{ 0xCBD8D2F6429190B9ull, 0xCBD8D2F6429190B9ull },
	{ 0x5437F40EF747CB50ull, 0x5437F40EF747CB50ull },
	{ 0xBEF0EBC216010359ull, 0xBEF0EBC216010359ull },
	{ 0x599A826199DFCB36ull, 0x599A826199DFCB36ull },
	{ 0xFC9C24A88261726Bull, 0xFC9C24A88261726Bull },
	{ 0x7013CFBC20BEBCB0ull, 0x7013CFBC20BEBCB0ull },
	{ 0x4B3AFC8891E2F585ull, 0x4B3AFC8891E2F585ull },
	{ 0x7F40F583F2252C6Full, 0x7F40F583F2252C6Full },
	{ 0xC3106E656F3A33C1ull, 0xC3106E656F3A33C1ull },
	{ 0xBD8D2C1702F279F4ull, 0xBD8D2C1702F279F4ull },
	{ 0xC06B993626858507ull, 0xC06B993626858507ull },
	{ 0x404A03A3C297C3F3ull, 0x404A03A3C297C3F3ull },
	{ 0x4276743D6C307FCFull, 0x4276743D6C307FCFull },
	{ 0xC0C3F3DD90BD7D57ull, 0xC0C3F3DD90BD7D57ull },
	{ 0xC01C5F8DDA6F7A10ull, 0xC01C5F8DDA6F7A10ull },
	{ 0x4160E7F4E701F501ull, 0x4160E7F4E701F501ull },
	{ 0xBE65C0D3CAE0F0BFull, 0xBE65C0D3CAE0F0BFull },
	{ 0xC05D0D8E746700C8ull, 0xC05D0D8E746700C8ull },
	{ 0x3EF4B9726634A103ull, 0x3EF4B9726634A103ull },
	{ 0x3FA3301A2F31E739ull, 0x3FA3301A2F31E739ull },
	{ 0x3E4D13910B039FEFull, 0x3E4D13910B039FEFull },
	{ 0xBD2ECF9EEBBB7948ull, 0xBD2ECF9EEBBB7948ull },
	{ 0x3FF553E9826AAFCEull, 0x3FF553E9826AAFCEull },
	{ 0xBF304545BB796E91ull, 0xBF304545BB796E91ull },
	{ 0x415B13D7322E34DAull, 0x415B13D7322E34DAull },
	{ 0x40874F6AEBFAAD36ull, 0x40874F6AEBFAAD36ull },
	{ 0xC1A769569DC453A3ull, 0xC1A769569DC453A3ull },
	{ 0x407C4518EB172CD8ull, 0x407C4518EB172CD8ull },
	{ 0xC11E7EFFF9DB2E9Aull, 0xC11E7EFFF9DB2E9Aull },
	{ 0xBF08DBCBD968083Cull, 0xBF08DBCBD968083Cull },
	{ 0x404E3E3D3C108809ull, 0x404E3E3D3C108809ull },
	{ 0x3F842E82A89E12ACull, 0x3F842E82A89E12ACull },
	{ 0xBF3509049B9F1C8Full, 0xBF3509049B9F1C8Full },
	{ 0x3FBEB16A811186C9ull, 0x3FBEB16A811186C9ull },
	{ 0xBF9CB7C5C83BEE33ull, 0xBF9CB7C5C83BEE33ull },
	{ 0xC237A798B0E0343Dull, 0xC237A798B0E0343Dull },
	{ 0xBE5EED188B14D5BBull, 0xBE5EED188B14D5BBull },
	{ 0xC1ED798CC57A77ABull, 0xC1ED798CC57A77ABull },
	{ 0xBD106E6432D17DEFull, 0xBD106E6432D17DEFull },
	{ 0xC0E9CAAE06367E79ull, 0xC0E9CAAE06367E79ull },
	{ 0xBF561DD69566AF74ull, 0xBF561DD69566AF74ull },
	{ 0x4218D477FFEDDA68ull, 0x4218D477FFEDDA68ull },
	{ 0x40867C1BC7186776ull, 0x40867C1BC7186776ull },
	{ 0xBE35538B10F44403ull, 0xBE35538B10F44403ull },
	{ 0xC07627EF28DB2039ull, 0xC07627EF28DB2039ull },
	{ 0xBEA837158357E320ull, 0xBEA837158357E320ull },
	{ 0x424D92B9E57B4484ull, 0x424D92B9E57B4484ull },
	{ 0x3F99A061EDD32946ull, 0x3F99A061EDD32946ull },
	{ 0x413F16270D5FDEDAull, 0x413F16270D5FDEDAull },
	{ 0x424D21CDB22E72A0ull, 0x424D21CDB22E72A0ull },
	{ 0xC03DC2084B35DDD5ull, 0xC03DC2084B35DDD5ull },
	{ 0xBE081A1DAA91E551ull, 0xBE081A1DAA91E551ull },
	{ 0x3E71D1CE6E9A403Cull, 0x3E71D1CE6E9A403Cull },
	{ 0x3E7E5DBB5DE25BD0ull, 0x3E7E5DBB5DE25BD0ull },
	{ 0x40B424FCE77CC546ull, 0x40B424FCE77CC546ull },
	{ 0x3F2111FBDDF4B992ull, 0x3F2111FBDDF4B992ull },
	{ 0x4066AEC6D6E7FF50ull, 0x4066AEC6D6E7FF50ull },
	{ 0x4110F15D0843E536ull, 0x4110F15D0843E536ull },
	{ 0xC00CA2103964C4A4ull, 0xC00CA2103964C4A4ull },
	{ 0xBDEFA259E5786F78ull, 0xBDEFA259E5786F78ull },
	{ 0xBECF57C3B97E26EAull, 0xBECF57C3B97E26EAull },
	{ 0xBD67D89A9D54F054ull, 0xBD67D89A9D54F054ull },
	{ 0x3F82B919EC88EA7Full, 0x3F82B919EC88EA7Full },
	{ 0xC1BD609F36213122ull, 0xC1BD609F36213122ull },
	{ 0x3F12AC68DA39DBE3ull, 0x3F12AC68DA39DBE3ull },
	{ 0x41A28C2E70A0B730ull, 0x41A28C2E70A0B730ull },
	{ 0x3FD9C53BE777E744ull, 0x3FD9C53BE777E744ull },
	{ 0x40356494579065E4ull, 0x40356494579065E4ull },
	{ 0x3CFA6969864FCE41ull, 0x3CFA6969864FCE41ull },
	{ 0x409A7B21B781CF60ull, 0x409A7B21B781CF60ull },
	{ 0x3DE8F609BF2FC19Full, 0x3DE8F609BF2FC19Full },
	{ 0xC19A79294F5D22B1ull, 0xC19A79294F5D22B1ull },
	{ 0x3EACBF98CDA310C7ull, 0x3EACBF98CDA310C7ull },
	{ 0xC22CB6E88614C42Full, 0xC22CB6E88614C42Full },
	{ 0xBF02330F4905531Full, 0xBF02330F4905531Full },
	{ 0xC218626AA28A78C6ull, 0xC218626AA28A78C6ull },
	{ 0xBFC8F7D64DEB5ECCull, 0xBFC8F7D64DEB5ECCull },
	{ 0xC0E6B212CB470E69ull, 0xC0E6B212CB470E69ull },
	{ 0xBEF978B1000923FFull, 0xBEF978B1000923FFull },
	{ 0x3EDC27B8821052C0ull, 0x3EDC27B8821052C0ull },
	{ 0x426FAFE27DBC213Aull, 0x426FAFE27DBC213Aull },
	{ 0xC062A53ADFC77834ull, 0xC062A53ADFC77834ull },
	{ 0xC01A3738BD6083B0ull, 0xC01A3738BD6083B0ull },
	{ 0x409BA6A8E25A793Eull, 0x409BA6A8E25A793Eull },
	{ 0xC19377A1464A6D88ull, 0xC19377A1464A6D88ull },
	{ 0xC0C214EA13065689ull, 0xC0C214EA13065689ull },
	{ 0xC13458EAC80891A3ull, 0xC13458EAC80891A3ull },
	{ 0x407BC53200ED9077ull, 0x407BC53200ED9077ull },
	{ 0xC30390D5AE0359FBull, 0xC30390D5AE0359FBull },
	{ 0xBFF1D1DA1FBA8541ull, 0xBFF1D1DA1FBA8541ull },
	{ 0x415EB176E978CA04ull, 0x415EB176E978CA04ull },
	{ 0x4064920AF08654B1ull, 0x4064920AF08654B1ull },
	{ 0x41C6B18A080434EEull, 0x41C6B18A080434EEull },
	{ 0x427D69E36AACE925ull, 0x427D69E36AACE925ull },
	{ 0xC2F10AAC0F9512FAull, 0xC2F10AAC0F9512FAull },
	{ 0x404C32B1D236D864ull, 0x404C32B1D236D864ull },
	{ 0x42562D9694E58BD4ull, 0x42562D9694E58BD4ull },
	{ 0xC06FF62ABB0FDD40ull, 0xC06FF62ABB0FDD40ull },
	{ 0x41482D2DDBA7A0D0ull, 0x41482D2DDBA7A0D0ull },
	{ 0x42C88433A0A1C883ull, 0x42C88433A0A1C883ull }
};

#ifdef WGF11SHADER5X
CShader5xTest_DoubleArith::Binary64Vec2 const CShader5xTest_ddiv::s_DDivRes[] = 
#else
#ifdef CALCDOUBLES
dataLayout  s_DDivRes[] = 
#endif
#endif
{
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0x7FFFCB8D9A5D4659ull, 0x7FFFCB8D9A5D4659ull },
    { 0xFFF8000000000000ull, 0xFFF8000000000000ull },
    { 0xFFF8000000000000ull, 0xFFF8000000000000ull },
    { 0xFFF8000000000000ull, 0xFFF8000000000000ull },
    { 0xFFF8000000000000ull, 0xFFF8000000000000ull },
    { 0x7FFEB0586EF53833ull, 0x7FFEB0586EF53833ull },
    { 0x7FF9436DD07BF2E5ull, 0x7FF9436DD07BF2E5ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0x7FF84E1BFCCABC0Bull, 0x7FF84E1BFCCABC0Bull },
    { 0x7FFB37D2241C3B1Dull, 0x7FFB37D2241C3B1Dull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0x990F7DE6F384466Eull, 0x990F7DE6F384466Eull },
    { 0xB9A0AE87840EEFD6ull, 0xB9A0AE87840EEFD6ull },
    { 0x6A85ABB0C5FB16FEull, 0x6A85ABB0C5FB16FEull },
    { 0x6403C1C0ABA223FFull, 0x6403C1C0ABA223FFull },
    { 0x1E71BDF4470D77F6ull, 0x1E71BDF4470D77F6ull },
    { 0x57702E610459CD7Cull, 0x57702E610459CD7Cull },
    { 0xB884564605F29B3Cull, 0xB884564605F29B3Cull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0xF66AD80F31CF42A5ull, 0xF66AD80F31CF42A5ull },
    { 0xD61B4EF082BEC3ECull, 0xD61B4EF082BEC3ECull },
    { 0x8FE286F1653C3752ull, 0x8FE286F1653C3752ull },
    { 0x00E1E973593E40CFull, 0x00E1E973593E40CFull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0xB35CC1C3F5C3304Cull, 0xB35CC1C3F5C3304Cull },
    { 0x15F9D5BAAC5657D3ull, 0x15F9D5BAAC5657D3ull },
    { 0x5E630428925EAE91ull, 0x5E630428925EAE91ull },
    { 0x1436C2E122A252DDull, 0x1436C2E122A252DDull },
    { 0x8C8077C4BAB96B49ull, 0x8C8077C4BAB96B49ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0xA29FC898CFE97368ull, 0xA29FC898CFE97368ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0xE4F94D07A1088A4Bull, 0xE4F94D07A1088A4Bull },
    { 0xDB10B26B4C58A7C8ull, 0xDB10B26B4C58A7C8ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0xC8D851123B5A17A7ull, 0xC8D851123B5A17A7ull },
    { 0x98B288FDC0F508D0ull, 0x98B288FDC0F508D0ull },
    { 0x353EB81AAB466CAAull, 0x353EB81AAB466CAAull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0x86E6FC134975E9B4ull, 0x86E6FC134975E9B4ull },
    { 0xD138005B41CDC230ull, 0xD138005B41CDC230ull },
    { 0x80000000203864D0ull, 0x80000000203864D0ull },
    { 0x40C56161A1FD16AEull, 0x40C56161A1FD16AEull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x5431A7331FD6AA9Full, 0x5431A7331FD6AA9Full },
    { 0xA4C86674C8DFD9ACull, 0xA4C86674C8DFD9ACull },
    { 0x35049A5C33BC8EEAull, 0x35049A5C33BC8EEAull },
    { 0x5686AB497532B5E5ull, 0x5686AB497532B5E5ull },
    { 0x06F426C71120B6F1ull, 0x06F426C71120B6F1ull },
    { 0xB51A6876F11FD815ull, 0xB51A6876F11FD815ull },
    { 0xA7C8E345FBF22E62ull, 0xA7C8E345FBF22E62ull },
    { 0x8305F7D8539A465Eull, 0x8305F7D8539A465Eull },
    { 0x6F0C617FBD52BAFAull, 0x6F0C617FBD52BAFAull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0xEE995CF37F9835D6ull, 0xEE995CF37F9835D6ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x3207736F75005255ull, 0x3207736F75005255ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0xFF236754F7EC0C8Full, 0xFF236754F7EC0C8Full },
    { 0xD927F8D0D4E62280ull, 0xD927F8D0D4E62280ull },
    { 0x956307291EA89DECull, 0x956307291EA89DECull },
    { 0x4A93B0D1C8EFA4E2ull, 0x4A93B0D1C8EFA4E2ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x5D91091BF1863A6Bull, 0x5D91091BF1863A6Bull },
    { 0x80000000262797C6ull, 0x80000000262797C6ull },
    { 0x8AB893AED10C6955ull, 0x8AB893AED10C6955ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x6502A03486A9E4DDull, 0x6502A03486A9E4DDull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x61220A3682F067AAull, 0x61220A3682F067AAull },
    { 0xECE228CB0D7D2756ull, 0xECE228CB0D7D2756ull },
    { 0x98825A810BC04566ull, 0x98825A810BC04566ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0x343DF1452D6DD3ADull, 0x343DF1452D6DD3ADull },
    { 0x73F561C4DEF94CB8ull, 0x73F561C4DEF94CB8ull },
    { 0xF2037057E426A2B9ull, 0xF2037057E426A2B9ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0xABE88C26FDA1CDDAull, 0xABE88C26FDA1CDDAull },
    { 0xBC19BB2E84B35E91ull, 0xBC19BB2E84B35E91ull },
    { 0x5FA594CC29587322ull, 0x5FA594CC29587322ull },
    { 0x4E7960A4298C4D0Full, 0x4E7960A4298C4D0Full },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0xCD5189776BC05D0Bull, 0xCD5189776BC05D0Bull },
    { 0x3F5856B529531440ull, 0x3F5856B529531440ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x252F1AE6AE18D461ull, 0x252F1AE6AE18D461ull },
    { 0x308B730936A63684ull, 0x308B730936A63684ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0x10C0441FA4D03FBCull, 0x10C0441FA4D03FBCull },
    { 0x810065FB55FF018Dull, 0x810065FB55FF018Dull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x6ED5087FA0A99B28ull, 0x6ED5087FA0A99B28ull },
    { 0xA9129F3C9A61E902ull, 0xA9129F3C9A61E902ull },
    { 0x4DF4E941321FBA6Full, 0x4DF4E941321FBA6Full },
    { 0x9FB4B8FAFB414E28ull, 0x9FB4B8FAFB414E28ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0xCAE3A3F2EA6CD9C6ull, 0xCAE3A3F2EA6CD9C6ull },
    { 0x130DBED8CE8B3AB5ull, 0x130DBED8CE8B3AB5ull },
    { 0x51776C6B4ED04CB9ull, 0x51776C6B4ED04CB9ull },
    { 0xF6615EE1DE45FA8Eull, 0xF6615EE1DE45FA8Eull },
    { 0xB3EE2C4A4ED6DE59ull, 0xB3EE2C4A4ED6DE59ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0x0AD8672C4BA689AEull, 0x0AD8672C4BA689AEull },
    { 0x51A67B8D2BA02944ull, 0x51A67B8D2BA02944ull },
    { 0xD58B85EF085A135Bull, 0xD58B85EF085A135Bull },
    { 0x10428F011B92F90Eull, 0x10428F011B92F90Eull },
    { 0xA7456BDAED3A2D3Eull, 0xA7456BDAED3A2D3Eull },
    { 0x1DF74199B36B65EDull, 0x1DF74199B36B65EDull },
    { 0xB863C7BF86FBE3C5ull, 0xB863C7BF86FBE3C5ull },
    { 0x510A4F8B49C77B09ull, 0x510A4F8B49C77B09ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0x127007777BC5357Dull, 0x127007777BC5357Dull },
    { 0x830ECDD67AB669B3ull, 0x830ECDD67AB669B3ull },
    { 0x2DA41B7630B8D837ull, 0x2DA41B7630B8D837ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0xA876D5545F24C25Aull, 0xA876D5545F24C25Aull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0x45F15D5625C0B557ull, 0x45F15D5625C0B557ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0xB56CD027EBD3CDDBull, 0xB56CD027EBD3CDDBull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0x2F91F1B64AF5ED11ull, 0x2F91F1B64AF5ED11ull },
    { 0xF8CF32A3BE045EA7ull, 0xF8CF32A3BE045EA7ull },
    { 0x4B981812B2429032ull, 0x4B981812B2429032ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0x345691EBF262DC5Cull, 0x345691EBF262DC5Cull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x94435F08626EAB39ull, 0x94435F08626EAB39ull },
    { 0xDEF448C2E181D8C2ull, 0xDEF448C2E181D8C2ull },
    { 0xE5EABDED13AE1E72ull, 0xE5EABDED13AE1E72ull },
    { 0x58104005AB16D2AEull, 0x58104005AB16D2AEull },
    { 0x3DD0787EA68C538Bull, 0x3DD0787EA68C538Bull },
    { 0x5F76B7F4AFC6B649ull, 0x5F76B7F4AFC6B649ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x15AA1A5A658795D9ull, 0x15AA1A5A658795D9ull },
    { 0xE2BFAD531CBBDC99ull, 0xE2BFAD531CBBDC99ull },
    { 0x40D28EF5FE6775BAull, 0x40D28EF5FE6775BAull },
    { 0xD3CB460BAD81B3F7ull, 0xD3CB460BAD81B3F7ull },
    { 0xC918B5ED20083270ull, 0xC918B5ED20083270ull },
    { 0xBE03F04AAD2DFCB0ull, 0xBE03F04AAD2DFCB0ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0x25F15036F2D90CAEull, 0x25F15036F2D90CAEull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x75A65E85C3AF1A09ull, 0x75A65E85C3AF1A09ull },
    { 0x6B0C9F4E01832BDFull, 0x6B0C9F4E01832BDFull },
    { 0x1957E01FE17D0D5Eull, 0x1957E01FE17D0D5Eull },
    { 0x72F87CFBEBF4A1C6ull, 0x72F87CFBEBF4A1C6ull },
    { 0x8F9112E23712D616ull, 0x8F9112E23712D616ull },
    { 0xD2A6DBC9ACF8067Full, 0xD2A6DBC9ACF8067Full },
    { 0x310BF09228FB685Aull, 0x310BF09228FB685Aull },
    { 0x97A4264E04C0F510ull, 0x97A4264E04C0F510ull },
    { 0x707A1417BD9B060Cull, 0x707A1417BD9B060Cull },
    { 0xC9971779B482E9C2ull, 0xC9971779B482E9C2ull },
    { 0x9A803900098B96F8ull, 0x9A803900098B96F8ull },
    { 0xAA44147B15BB8EA2ull, 0xAA44147B15BB8EA2ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0xF56A27D26C8C2B24ull, 0xF56A27D26C8C2B24ull },
    { 0x232095543C9F655Bull, 0x232095543C9F655Bull },
    { 0x2096E25F723ECE54ull, 0x2096E25F723ECE54ull },
    { 0x1D2771B7554285B0ull, 0x1D2771B7554285B0ull },
    { 0x1BA19712D7DDA812ull, 0x1BA19712D7DDA812ull },
    { 0xB88ACFFB25C42B83ull, 0xB88ACFFB25C42B83ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0xA19A43D015074159ull, 0xA19A43D015074159ull },
    { 0x6839A0F280A1761Eull, 0x6839A0F280A1761Eull },
    { 0xE7C29CAD97445A97ull, 0xE7C29CAD97445A97ull },
    { 0x5F839F5F3EAD215Aull, 0x5F839F5F3EAD215Aull },
    { 0x50298A06EDCC1D52ull, 0x50298A06EDCC1D52ull },
    { 0x860149EF60CD467Full, 0x860149EF60CD467Full },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0xEC13BD44302BC6C0ull, 0xEC13BD44302BC6C0ull },
    { 0xEBF23BFAF2A36E9Eull, 0xEBF23BFAF2A36E9Eull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x16D23BCA6709BD9Eull, 0x16D23BCA6709BD9Eull },
    { 0xC7E84C648519FD1Bull, 0xC7E84C648519FD1Bull },
    { 0xC650E2A3005D4178ull, 0xC650E2A3005D4178ull },
    { 0x1AD3E9F004CDB29Bull, 0x1AD3E9F004CDB29Bull },
    { 0x8649C0CBDCDFB088ull, 0x8649C0CBDCDFB088ull },
    { 0x8694EEC024C25FEFull, 0x8694EEC024C25FEFull },
    { 0x80000000001E8445ull, 0x80000000001E8445ull },
    { 0xF80B3B878F7C136Eull, 0xF80B3B878F7C136Eull },
    { 0x0FBD66A0CCFBD759ull, 0x0FBD66A0CCFBD759ull },
    { 0x75E60A2EDEC47580ull, 0x75E60A2EDEC47580ull },
    { 0x96C1EBB50D1C7708ull, 0x96C1EBB50D1C7708ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x28E0733FDD525B29ull, 0x28E0733FDD525B29ull },
    { 0x32FA21E4281E73C1ull, 0x32FA21E4281E73C1ull },
    { 0x55BADAF82E9E74C7ull, 0x55BADAF82E9E74C7ull },
    { 0x41C58C61F6EC2E2Dull, 0x41C58C61F6EC2E2Dull },
    { 0xE70B8FBA7ACF6602ull, 0xE70B8FBA7ACF6602ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0xA09AFB1E07B9C9B4ull, 0xA09AFB1E07B9C9B4ull },
    { 0xA924BE6DF63DEF73ull, 0xA924BE6DF63DEF73ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0xFCCB636C93ED580Dull, 0xFCCB636C93ED580Dull },
    { 0xC8D3B79C9EF043B9ull, 0xC8D3B79C9EF043B9ull },
    { 0x0FDEF3CAD527EE2Eull, 0x0FDEF3CAD527EE2Eull },
    { 0xE15750BE3822CED9ull, 0xE15750BE3822CED9ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0xBEED669FBE418552ull, 0xBEED669FBE418552ull },
    { 0x9079E52D1FF16518ull, 0x9079E52D1FF16518ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x7B5016CA53905977ull, 0x7B5016CA53905977ull },
    { 0xA42008FF6A2D3EB3ull, 0xA42008FF6A2D3EB3ull },
    { 0xDBA5596A9848BC50ull, 0xDBA5596A9848BC50ull },
    { 0xCE864ADBF0B6FE91ull, 0xCE864ADBF0B6FE91ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x7797C6725613D7F4ull, 0x7797C6725613D7F4ull },
    { 0xA7547B6135EE8185ull, 0xA7547B6135EE8185ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0x64A04CA83D61B282ull, 0x64A04CA83D61B282ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x32EA767645240CE4ull, 0x32EA767645240CE4ull },
    { 0x03D3CB53E3A844B4ull, 0x03D3CB53E3A844B4ull },
    { 0x49615366BA4D201Eull, 0x49615366BA4D201Eull },
    { 0xB131255B7E76A7C8ull, 0xB131255B7E76A7C8ull },
    { 0x76F2E51F841A4B5Full, 0x76F2E51F841A4B5Full },
    { 0x8E0F2ABAC5E0A023ull, 0x8E0F2ABAC5E0A023ull },
    { 0x2D859725D47250C9ull, 0x2D859725D47250C9ull },
    { 0x695C74A8277D12FFull, 0x695C74A8277D12FFull },
    { 0xBF612F3172DDB495ull, 0xBF612F3172DDB495ull },
    { 0x23A80F43FB7671D6ull, 0x23A80F43FB7671D6ull },
    { 0xBCE27814A6925B12ull, 0xBCE27814A6925B12ull },
    { 0xA6A2903EC724D407ull, 0xA6A2903EC724D407ull },
    { 0xE670E26613BF15A1ull, 0xE670E26613BF15A1ull },
    { 0x9B042D945C188278ull, 0x9B042D945C188278ull },
    { 0xC5C1AE65B411F6D1ull, 0xC5C1AE65B411F6D1ull },
    { 0x1CA3037A60B5EBFDull, 0x1CA3037A60B5EBFDull },
    { 0x33E9356CC32DB853ull, 0x33E9356CC32DB853ull },
    { 0x42D63406B3E0D372ull, 0x42D63406B3E0D372ull },
    { 0x3B37CA42DC91F7A6ull, 0x3B37CA42DC91F7A6ull },
    { 0x2FEEA83D3808A068ull, 0x2FEEA83D3808A068ull },
    { 0xDB61AF40FCF62FDAull, 0xDB61AF40FCF62FDAull },
    { 0x0ED5F2719E82263Cull, 0x0ED5F2719E82263Cull },
    { 0xAD7455041D0E1222ull, 0xAD7455041D0E1222ull },
    { 0xEC9F1BF98E75C712ull, 0xEC9F1BF98E75C712ull },
    { 0xA1A28BA8CB27168Full, 0xA1A28BA8CB27168Full },
    { 0x618EBC23195DF760ull, 0x618EBC23195DF760ull },
    { 0x0EEE76F334FD2503ull, 0x0EEE76F334FD2503ull },
    { 0x20514ABF451B8922ull, 0x20514ABF451B8922ull },
    { 0x87F3FC0731F225B3ull, 0x87F3FC0731F225B3ull },
    { 0x625F34069877F339ull, 0x625F34069877F339ull },
    { 0x3E79E4236305765Cull, 0x3E79E4236305765Cull },
    { 0xC6FC179F6A20A43Full, 0xC6FC179F6A20A43Full },
    { 0x73AC0E49563BDE39ull, 0x73AC0E49563BDE39ull },
    { 0x21A425A5D2002329ull, 0x21A425A5D2002329ull },
    { 0x8EE25AA66CF3B56Full, 0x8EE25AA66CF3B56Full },
    { 0x91285380BE1EE37Eull, 0x91285380BE1EE37Eull },
    { 0xBBB2C3AB4FEF0D0Aull, 0xBBB2C3AB4FEF0D0Aull },
    { 0x042533E06DE535A1ull, 0x042533E06DE535A1ull },
    { 0x14ADFECF4FDE40FDull, 0x14ADFECF4FDE40FDull },
    { 0xDF1F22849CF78B58ull, 0xDF1F22849CF78B58ull },
    { 0x1D904D539EDD77A9ull, 0x1D904D539EDD77A9ull },
    { 0xD72DD54D7F14180Full, 0xD72DD54D7F14180Full },
    { 0xFD738FE12B53552Bull, 0xFD738FE12B53552Bull },
    { 0xFC296811E9069C4Bull, 0xFC296811E9069C4Bull },
    { 0x56EC018D4D451231ull, 0x56EC018D4D451231ull },
    { 0x554F9485E1B7FFB9ull, 0x554F9485E1B7FFB9ull },
    { 0xBA4489896E46C9B2ull, 0xBA4489896E46C9B2ull },
    { 0x3221CCE5430B382Dull, 0x3221CCE5430B382Dull },
    { 0x3C31FF9B18F8340Dull, 0x3C31FF9B18F8340Dull },
    { 0xDE8E03BBD499F2D9ull, 0xDE8E03BBD499F2D9ull },
    { 0x5A9691F522DA8579ull, 0x5A9691F522DA8579ull },
    { 0x4315ADF9392B4F18ull, 0x4315ADF9392B4F18ull },
    { 0xBC0C86B7B846CA1Full, 0xBC0C86B7B846CA1Full },
    { 0xA0550CBC6CE08CA4ull, 0xA0550CBC6CE08CA4ull },
    { 0x98B786CB296126B9ull, 0x98B786CB296126B9ull },
    { 0xC513682761F8830Dull, 0xC513682761F8830Dull },
    { 0xDAD0F5767B8F7095ull, 0xDAD0F5767B8F7095ull },
    { 0x3CFBFE73B07DB92Cull, 0x3CFBFE73B07DB92Cull },
    { 0x92C9715D9EEEA98Cull, 0x92C9715D9EEEA98Cull },
    { 0x2DBF64161707AE19ull, 0x2DBF64161707AE19ull },
    { 0x5C387392210978FCull, 0x5C387392210978FCull },
    { 0x71FAECC55EEC31E3ull, 0x71FAECC55EEC31E3ull },
    { 0xE715BCF59D548B3Full, 0xE715BCF59D548B3Full },
    { 0xA55603FCA46FBCCBull, 0xA55603FCA46FBCCBull },
    { 0x18546902EF3A2804ull, 0x18546902EF3A2804ull },
    { 0x5DE3DF1368BF95E7ull, 0x5DE3DF1368BF95E7ull },
    { 0xE553E58EBF9DCD67ull, 0xE553E58EBF9DCD67ull },
    { 0x11E300F0377E83FDull, 0x11E300F0377E83FDull },
    { 0x87617F3B6A24D3C8ull, 0x87617F3B6A24D3C8ull },
    { 0x13EA01D607F55010ull, 0x13EA01D607F55010ull },
    { 0x1198DF7BADFBBBA7ull, 0x1198DF7BADFBBBA7ull },
    { 0x1E8FEEF29560306Bull, 0x1E8FEEF29560306Bull },
    { 0x5A47C5336F0C44CDull, 0x5A47C5336F0C44CDull },
    { 0xD4D52BA5681B1474ull, 0xD4D52BA5681B1474ull },
    { 0x98C309399272579Dull, 0x98C309399272579Dull },
    { 0xF0C2DF1F685251F5ull, 0xF0C2DF1F685251F5ull },
    { 0x0CCFA7DFD5535F37ull, 0x0CCFA7DFD5535F37ull },
    { 0x4773CF4A5EFB4C17ull, 0x4773CF4A5EFB4C17ull },
    { 0x9F262E6B814C7B7Aull, 0x9F262E6B814C7B7Aull },
    { 0x9F73DE58FB7F0A1Bull, 0x9F73DE58FB7F0A1Bull },
    { 0xD3F754D0933126BFull, 0xD3F754D0933126BFull },
    { 0xD21613189F1EFB9Eull, 0xD21613189F1EFB9Eull },
    { 0xCB557FE25977C363ull, 0xCB557FE25977C363ull },
    { 0xBDFF2E9ED620C50Bull, 0xBDFF2E9ED620C50Bull },
    { 0x3F6529761B7648ADull, 0x3F6529761B7648ADull },
    { 0x3D78FB7361D7141Bull, 0x3D78FB7361D7141Bull },
    { 0x3D695889FC72F3FDull, 0x3D695889FC72F3FDull },
    { 0xC0CC88CF8A44DA1Full, 0xC0CC88CF8A44DA1Full },
    { 0xBF47FF9BF9060791ull, 0xBF47FF9BF9060791ull },
    { 0xBFF385527B5BB77Bull, 0xBFF385527B5BB77Bull },
    { 0x425D7FC61D05F777ull, 0x425D7FC61D05F777ull },
    { 0x408C04F1E7A61843ull, 0x408C04F1E7A61843ull },
    { 0x40D3E009E279CE4Cull, 0x40D3E009E279CE4Cull },
    { 0x41D96307C21DDE70ull, 0x41D96307C21DDE70ull },
    { 0x400684BDA12F684Cull, 0x400684BDA12F684Cull },
    { 0x41CDBA63A8400000ull, 0x41CDBA63A8400000ull },
    { 0x3DB2A0B067547B89ull, 0x3DB2A0B067547B89ull },
    { 0xBE3AA340887485E4ull, 0xBE3AA340887485E4ull },
    { 0x41856F7A65555555ull, 0x41856F7A65555555ull },
    { 0x3FA3919FB1766434ull, 0x3FA3919FB1766434ull },
    { 0xBE4B6889EA786B26ull, 0xBE4B6889EA786B26ull },
    { 0xC28E15C461D8C70Full, 0xC28E15C461D8C70Full },
    { 0xBEFF5E823521B614ull, 0xBEFF5E823521B614ull },
    { 0xC090AE11BF1B2646ull, 0xC090AE11BF1B2646ull },
    { 0x3F400758B3523056ull, 0x3F400758B3523056ull },
    { 0x414F6817564BCDB2ull, 0x414F6817564BCDB2ull },
    { 0x3E11AF2D95099C4Cull, 0x3E11AF2D95099C4Cull },
    { 0xBE28DCEEB41C146Aull, 0xBE28DCEEB41C146Aull },
    { 0x4253B69A746C45FCull, 0x4253B69A746C45FCull },
    { 0x3F990E5621FB3381ull, 0x3F990E5621FB3381ull },
    { 0x3FE37D90810D4FE0ull, 0x3FE37D90810D4FE0ull },
    { 0x404E2ED974B3A4AEull, 0x404E2ED974B3A4AEull },
    { 0x4191112BEF8AD8F3ull, 0x4191112BEF8AD8F3ull },
    { 0xBEF90FAA438D4FFDull, 0xBEF90FAA438D4FFDull },
    { 0x3D8B34B054847824ull, 0x3D8B34B054847824ull },
    { 0xBF91B92CA8E84166ull, 0xBF91B92CA8E84166ull },
    { 0xBFBBD84AEE085BA7ull, 0xBFBBD84AEE085BA7ull },
    { 0x3EFD17852850A14Bull, 0x3EFD17852850A14Bull },
    { 0x3F346E155C0911F4ull, 0x3F346E155C0911F4ull },
    { 0xBF1B5151C69A5FB3ull, 0xBF1B5151C69A5FB3ull },
    { 0x417B063083DAFCEAull, 0x417B063083DAFCEAull },
    { 0xBF88B2C77A98A5C6ull, 0xBF88B2C77A98A5C6ull },
    { 0x416A81A3CDE8AD92ull, 0x416A81A3CDE8AD92ull },
    { 0x3CE77377D7FAE9D9ull, 0x3CE77377D7FAE9D9ull },
    { 0x3F9621E2C66053FFull, 0x3F9621E2C66053FFull },
    { 0x42CAF2888864602Bull, 0x42CAF2888864602Bull },
    { 0x3E2B2DF178F72553ull, 0x3E2B2DF178F72553ull },
    { 0x3F799EF26C7895D4ull, 0x3F799EF26C7895D4ull },
    { 0xC001DE003A1E6E56ull, 0xC001DE003A1E6E56ull },
    { 0x41442EAC682076CFull, 0x41442EAC682076CFull },
    { 0xC096C7009B331B63ull, 0xC096C7009B331B63ull },
    { 0xBE2129E45B0F3716ull, 0xBE2129E45B0F3716ull },
    { 0xBDA885837B91D255ull, 0xBDA885837B91D255ull },
    { 0xBF1C99F06A81563Aull, 0xBF1C99F06A81563Aull },
    { 0xBEA73C4E203468B0ull, 0xBEA73C4E203468B0ull },
    { 0xC0283E49FB238440ull, 0xC0283E49FB238440ull },
    { 0x3EAA0FCECBE75F4Cull, 0x3EAA0FCECBE75F4Cull },
    { 0x3FC7D5A44350180Aull, 0x3FC7D5A44350180Aull },
    { 0xC0A01F4F8BD6553Aull, 0xC0A01F4F8BD6553Aull },
    { 0x4112952FD9900790ull, 0x4112952FD9900790ull },
    { 0xBDA65475C800E060ull, 0xBDA65475C800E060ull },
    { 0x3F730355AF477AEEull, 0x3F730355AF477AEEull },
    { 0xBF443C35BC509EA2ull, 0xBF443C35BC509EA2ull },
    { 0xC1D94FF5C5BAA27Eull, 0xC1D94FF5C5BAA27Eull },
    { 0x3FE3137DD19DEF99ull, 0x3FE3137DD19DEF99ull },
    { 0x3EE8D814B9AE4FE8ull, 0x3EE8D814B9AE4FE8ull },
    { 0xBFBE7F1231983A48ull, 0xBFBE7F1231983A48ull },
    { 0xBEFF9A637DBA8D5Bull, 0xBEFF9A637DBA8D5Bull },
    { 0xBE0AE4EEE1E81D4Dull, 0xBE0AE4EEE1E81D4Dull },
    { 0x402807CE07536F26ull, 0x402807CE07536F26ull },
    { 0x3FC13A617ED576AFull, 0x3FC13A617ED576AFull },
    { 0x4192B728C11501AAull, 0x4192B728C11501AAull },
    { 0x3F5D2282B2B301EEull, 0x3F5D2282B2B301EEull },
    { 0xBF30CC40EF2B02EFull, 0xBF30CC40EF2B02EFull },
    { 0x415639701E0E2549ull, 0x415639701E0E2549ull },
    { 0x3DEB0D772B2C9A4Bull, 0x3DEB0D772B2C9A4Bull },
    { 0x3F232383907EF1B7ull, 0x3F232383907EF1B7ull },
    { 0xC0E038DD4960935Aull, 0xC0E038DD4960935Aull },
    { 0xC0246F4DE9BD37A7ull, 0xC0246F4DE9BD37A7ull },
    { 0x404627E4AA9511D8ull, 0x404627E4AA9511D8ull },
    { 0x3EF09DF2488C9D57ull, 0x3EF09DF2488C9D57ull },
    { 0x40D2C0AD7FF64591ull, 0x40D2C0AD7FF64591ull },
    { 0xBDE2925FD98E360Aull, 0xBDE2925FD98E360Aull },
    { 0xBF6D2DFC261AEE1Full, 0xBF6D2DFC261AEE1Full },
    { 0xBD549C1A410AFABDull, 0xBD549C1A410AFABDull },
    { 0x3E1840D40E472626ull, 0x3E1840D40E472626ull },
    { 0x3F907A68C107A68Cull, 0x3F907A68C107A68Cull },
    { 0x417B61B740000000ull, 0x417B61B740000000ull },
    { 0xC1E763E2AE9CB804ull, 0xC1E763E2AE9CB804ull },
    { 0xBF529E1CAD393922ull, 0xBF529E1CAD393922ull },
    { 0xC16BB7C367C65A15ull, 0xC16BB7C367C65A15ull },
    { 0xC00070EF6C375699ull, 0xC00070EF6C375699ull },
    { 0x3D8BD8625B0E262Aull, 0x3D8BD8625B0E262Aull },
    { 0x3FDACF914C1BACF9ull, 0x3FDACF914C1BACF9ull },
    { 0xC193E2F798B74F03ull, 0xC193E2F798B74F03ull },
    { 0xBFDCC0ED7303B5CCull, 0xBFDCC0ED7303B5CCull },
    { 0x41C0A63D2D131A86ull, 0x41C0A63D2D131A86ull },
    { 0x3E7372F7D9DC0A52ull, 0x3E7372F7D9DC0A52ull },
    { 0x410EF174687D6344ull, 0x410EF174687D6344ull },
    { 0x3FD2CDA9833751B3ull, 0x3FD2CDA9833751B3ull },
    { 0xC05A998D071DCCB2ull, 0xC05A998D071DCCB2ull },
    { 0x3E71261AFEE9BF1Eull, 0x3E71261AFEE9BF1Eull },
    { 0x3F74C9EB1BBC483Full, 0x3F74C9EB1BBC483Full },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0xEB7D3A361AFD6D2Dull, 0xEB7D3A361AFD6D2Dull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0x5C5262843012CA7Bull, 0x5C5262843012CA7Bull },
    { 0xF7219B180EDDEA79ull, 0xF7219B180EDDEA79ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0xD67F6C831212DB00ull, 0xD67F6C831212DB00ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0x5AB60EA6F14D47CEull, 0x5AB60EA6F14D47CEull },
    { 0x54E6EA5589F1686Eull, 0x54E6EA5589F1686Eull },
    { 0x4E908131C0D27B17ull, 0x4E908131C0D27B17ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0xFD533EAA7949110Eull, 0xFD533EAA7949110Eull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0xE9A38EF34C38155Dull, 0xE9A38EF34C38155Dull },
    { 0xFD5006F235FFDD3Bull, 0xFD5006F235FFDD3Bull },
    { 0xE3FC2D3A4FE0FC0Eull, 0xE3FC2D3A4FE0FC0Eull },
    { 0x6F92B8211EFDA5C4ull, 0x6F92B8211EFDA5C4ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0xCC9BEF99116DC99Aull, 0xCC9BEF99116DC99Aull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0x45A20F643936DDD6ull, 0x45A20F643936DDD6ull },
    { 0x43C2EAA1A911EFD8ull, 0x43C2EAA1A911EFD8ull },
    { 0x6A7CB858A2772C90ull, 0x6A7CB858A2772C90ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0xDB00468B1A406E3Dull, 0xDB00468B1A406E3Dull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0x45408C713D1E87C7ull, 0x45408C713D1E87C7ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0xCFC335EABC9989EAull, 0xCFC335EABC9989EAull },
    { 0xEE387D1D8899B6D8ull, 0xEE387D1D8899B6D8ull },
    { 0x69D9C434713D48D7ull, 0x69D9C434713D48D7ull },
    { 0x5AD7C6923E097596ull, 0x5AD7C6923E097596ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0xE4C23F26C395F94Dull, 0xE4C23F26C395F94Dull },
    { 0x5D51B66703211D5Full, 0x5D51B66703211D5Full },
    { 0xEF47C4B528FE2C30ull, 0xEF47C4B528FE2C30ull },
    { 0xE8C775074CFAC094ull, 0xE8C775074CFAC094ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0x5E0D5F5504D0F40Full, 0x5E0D5F5504D0F40Full },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0x6D91BCEB692918D2ull, 0x6D91BCEB692918D2ull },
    { 0x63B4907244704257ull, 0x63B4907244704257ull },
    { 0x4C12132A8C63AF62ull, 0x4C12132A8C63AF62ull },
    { 0x44568E1EB67B5645ull, 0x44568E1EB67B5645ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0x70747B78F538820Bull, 0x70747B78F538820Bull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0xE2F7555CACC384BCull, 0xE2F7555CACC384BCull },
    { 0x743F337398CE21EFull, 0x743F337398CE21EFull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0x6B36F2D5E5A8F9CAull, 0x6B36F2D5E5A8F9CAull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0xE97E8814C39E75C9ull, 0xE97E8814C39E75C9ull },
    { 0xF6268A016A1453ACull, 0xF6268A016A1453ACull },
    { 0xF3C8C87DB30A9B54ull, 0xF3C8C87DB30A9B54ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0x4E0376FADF9A085Aull, 0x4E0376FADF9A085Aull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0x72E20F69F4F061F3ull, 0x72E20F69F4F061F3ull },
    { 0xD2E003CAAFA17300ull, 0xD2E003CAAFA17300ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0xCCAA62E556F343D6ull, 0xCCAA62E556F343D6ull },
    { 0x6AD32DF44FD0416Full, 0x6AD32DF44FD0416Full },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0x4F5113D6E6A27C23ull, 0x4F5113D6E6A27C23ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0xD5274E7E9A10877Eull, 0xD5274E7E9A10877Eull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0x7F0226ECFE0604A2ull, 0x7F0226ECFE0604A2ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0x7D3EB988DAE091EBull, 0x7D3EB988DAE091EBull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0xFF7D75D21C4B4E81ull, 0xFF7D75D21C4B4E81ull },
    { 0x7F16A8433C03F3BFull, 0x7F16A8433C03F3BFull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0x7EC252DE61F9CCEFull, 0x7EC252DE61F9CCEFull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0x7FA8B5AEC6AD39F9ull, 0x7FA8B5AEC6AD39F9ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0xFDE50B5105C10CB7ull, 0xFDE50B5105C10CB7ull },
    { 0x7FDEF0AA6F542E1Full, 0x7FDEF0AA6F542E1Full },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0xFE9485E875BA04AFull, 0xFE9485E875BA04AFull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0x7D97F0CBC65A6220ull, 0x7D97F0CBC65A6220ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0xFF7C01A5C309D27Bull, 0xFF7C01A5C309D27Bull },
    { 0x7F336A3896B2AF5Cull, 0x7F336A3896B2AF5Cull },
    { 0x7EA0B8FEEF8940E0ull, 0x7EA0B8FEEF8940E0ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0x7EE9F2759D9AA2C3ull, 0x7EE9F2759D9AA2C3ull },
    { 0xFFCC5A691ACC6E54ull, 0xFFCC5A691ACC6E54ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0x7F48B2C7136F0599ull, 0x7F48B2C7136F0599ull },
    { 0x7F63AFA4659A0064ull, 0x7F63AFA4659A0064ull },
    { 0x7EA4BC12FE3ECEBCull, 0x7EA4BC12FE3ECEBCull },
    { 0x7F5D0D669A391B50ull, 0x7F5D0D669A391B50ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0xFF315DB555AD8BECull, 0xFF315DB555AD8BECull },
    { 0xFF76678A61959FB5ull, 0xFF76678A61959FB5ull },
    { 0xFFE36C706C9E4AC5ull, 0xFFE36C706C9E4AC5ull },
    { 0xFF903A26F6490B31ull, 0xFF903A26F6490B31ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0x7EE94435BE90F668ull, 0x7EE94435BE90F668ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0xFFE3C3F4827507A2ull, 0xFFE3C3F4827507A2ull },
    { 0x7F705BBF0645F06Aull, 0x7F705BBF0645F06Aull },
    { 0x7FC0D6DE416982A0ull, 0x7FC0D6DE416982A0ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0x7FCC14A8C0A6901Bull, 0x7FCC14A8C0A6901Bull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0x7FF0000000000000ull, 0x7FF0000000000000ull },
    { 0xFFF0000000000000ull, 0xFFF0000000000000ull },
    { 0x2B21F2A56A198F23ull, 0x2B21F2A56A198F23ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x05C9A263C1961F7Aull, 0x05C9A263C1961F7Aull },
    { 0x0D70C538B85B23DAull, 0x0D70C538B85B23DAull },
    { 0x84691A2C07325515ull, 0x84691A2C07325515ull },
    { 0x185F0EC134C5882Dull, 0x185F0EC134C5882Dull },
    { 0x376CE737F62456C6ull, 0x376CE737F62456C6ull },
    { 0x8D5C9578A914B671ull, 0x8D5C9578A914B671ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0xBE1544224DB741FCull, 0xBE1544224DB741FCull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x9E992F7C3B137664ull, 0x9E992F7C3B137664ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x24A6CC7AD98A69D8ull, 0x24A6CC7AD98A69D8ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x34CB7F67D40874A5ull, 0x34CB7F67D40874A5ull },
    { 0x281D100090A5372Dull, 0x281D100090A5372Dull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x918E47F44007AB1Full, 0x918E47F44007AB1Full },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x00000000002826BBull, 0x00000000002826BBull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x2A694992F4B97A0Aull, 0x2A694992F4B97A0Aull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x00ABF9C6DB3F07FAull, 0x00ABF9C6DB3F07FAull },
    { 0x8BEEAC90889823AFull, 0x8BEEAC90889823AFull },
    { 0x8633636015A4A1A2ull, 0x8633636015A4A1A2ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x304C2618ECB1EA52ull, 0x304C2618ECB1EA52ull },
    { 0x90F61120DD7EC7E0ull, 0x90F61120DD7EC7E0ull },
    { 0xB27076601E05AE7Eull, 0xB27076601E05AE7Eull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x0E351E60D86D4575ull, 0x0E351E60D86D4575ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x12BAB505BE704E23ull, 0x12BAB505BE704E23ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x8F02AC8BA1DD82DFull, 0x8F02AC8BA1DD82DFull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0xA250F519F6E7EE5Aull, 0xA250F519F6E7EE5Aull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x00000000000000C2ull, 0x00000000000000C2ull },
    { 0xAAE20FA56D133FE4ull, 0xAAE20FA56D133FE4ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x9FC99AF72E4E4B3Aull, 0x9FC99AF72E4E4B3Aull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x082BCA65799F5A92ull, 0x082BCA65799F5A92ull },
    { 0x1A398BA34FB7DEA4ull, 0x1A398BA34FB7DEA4ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0xB667ACCDACC63968ull, 0xB667ACCDACC63968ull },
    { 0x8759EE72C24067C1ull, 0x8759EE72C24067C1ull },
    { 0x113AB3A89CB3EFDCull, 0x113AB3A89CB3EFDCull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0xB3F2BB620CB7E79Cull, 0xB3F2BB620CB7E79Cull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x9651DCD887D2DB88ull, 0x9651DCD887D2DB88ull },
    { 0x23D23A961D00DAF7ull, 0x23D23A961D00DAF7ull },
    { 0x8A4BE155DBB9BA86ull, 0x8A4BE155DBB9BA86ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x850AD178C36866B4ull, 0x850AD178C36866B4ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x8334E4FDA75486F2ull, 0x8334E4FDA75486F2ull },
    { 0xBA1E400F0F2DC42Eull, 0xBA1E400F0F2DC42Eull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x00F7F57F2055AF80ull, 0x00F7F57F2055AF80ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0xAD44B7DDF72573DEull, 0xAD44B7DDF72573DEull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0xA1F1F7B657623D3Cull, 0xA1F1F7B657623D3Cull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x15F9B6670EC4B20Aull, 0x15F9B6670EC4B20Aull },
    { 0x2413372A12FE6DA5ull, 0x2413372A12FE6DA5ull },
    { 0x0000000000012322ull, 0x0000000000012322ull },
    { 0xB3603666ACFBB2EDull, 0xB3603666ACFBB2EDull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0xAEEF39BB37B55C78ull, 0xAEEF39BB37B55C78ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x1AE31746E4174B6Bull, 0x1AE31746E4174B6Bull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x00000000058BA6FBull, 0x00000000058BA6FBull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x0000000000000031ull, 0x0000000000000031ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x80000000070B5607ull, 0x80000000070B5607ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x8000247FBFDA81EFull, 0x8000247FBFDA81EFull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x80ACCF605AFF4F78ull, 0x80ACCF605AFF4F78ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x8000000000000002ull, 0x8000000000000002ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x8009FF4CFC51ED68ull, 0x8009FF4CFC51ED68ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x81B485411BF4A097ull, 0x81B485411BF4A097ull },
    { 0x0000000000000001ull, 0x0000000000000001ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x800000000001962Dull, 0x800000000001962Dull },
    { 0x80001DFA548270B5ull, 0x80001DFA548270B5ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x018B03609C4F339Cull, 0x018B03609C4F339Cull },
    { 0x000000000008F41Aull, 0x000000000008F41Aull },
    { 0x808811DE59704D32ull, 0x808811DE59704D32ull },
    { 0x0000305BC664B282ull, 0x0000305BC664B282ull },
    { 0x81A7A773BAF1896Eull, 0x81A7A773BAF1896Eull },
    { 0x02AA31325AA18034ull, 0x02AA31325AA18034ull },
    { 0x800000012C5FC4E2ull, 0x800000012C5FC4E2ull },
    { 0x80B9C619E7C3E5E0ull, 0x80B9C619E7C3E5E0ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x80000000000282CEull, 0x80000000000282CEull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x800000019F8E7DC1ull, 0x800000019F8E7DC1ull },
    { 0x00000000000001D5ull, 0x00000000000001D5ull },
    { 0x0000001269B0336Dull, 0x0000001269B0336Dull },
    { 0x000000000002D224ull, 0x000000000002D224ull },
    { 0x0000045A09AAB56Dull, 0x0000045A09AAB56Dull },
    { 0x8036FEB4A598B2ADull, 0x8036FEB4A598B2ADull },
    { 0x0002ED9F353B410Cull, 0x0002ED9F353B410Cull },
    { 0x00000000010EB77Dull, 0x00000000010EB77Dull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x80591A4D1C14E78Aull, 0x80591A4D1C14E78Aull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x02957CFA51C4A9BDull, 0x02957CFA51C4A9BDull },
    { 0x80000000000011A6ull, 0x80000000000011A6ull },
    { 0x8024DF1B3B93DA76ull, 0x8024DF1B3B93DA76ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x00000000ACB6EFA0ull, 0x00000000ACB6EFA0ull },
    { 0x814CF7380149EDC7ull, 0x814CF7380149EDC7ull },
    { 0x8000000000000004ull, 0x8000000000000004ull },
    { 0x0001856D4ACC6E1Cull, 0x0001856D4ACC6E1Cull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x00000000000105EBull, 0x00000000000105EBull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x8000000000000F64ull, 0x8000000000000F64ull },
    { 0x00F228021E7D4FDDull, 0x00F228021E7D4FDDull },
    { 0x805A126F4F2F7969ull, 0x805A126F4F2F7969ull },
    { 0x0104FC81B1E9E897ull, 0x0104FC81B1E9E897ull },
    { 0x80000000012A28C7ull, 0x80000000012A28C7ull },
    { 0x003965A71AAB249Full, 0x003965A71AAB249Full },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x800000000000004Bull, 0x800000000000004Bull },
    { 0x80000000045F2A48ull, 0x80000000045F2A48ull },
    { 0x00D7F67BE7EA8D7Eull, 0x00D7F67BE7EA8D7Eull },
    { 0x01123FC251589618ull, 0x01123FC251589618ull },
    { 0x024527848E0BF155ull, 0x024527848E0BF155ull },
    { 0x000000002839D0BEull, 0x000000002839D0BEull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x8084186BB2354096ull, 0x8084186BB2354096ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x0000000000000023ull, 0x0000000000000023ull },
    { 0x80000000001A61F3ull, 0x80000000001A61F3ull },
    { 0x02CFA25F73125077ull, 0x02CFA25F73125077ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x01140EFA47B933D0ull, 0x01140EFA47B933D0ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x004B6209EDE3CECBull, 0x004B6209EDE3CECBull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x8000009F0ED6E2DFull, 0x8000009F0ED6E2DFull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x800000000EDEF937ull, 0x800000000EDEF937ull },
    { 0x8000000000000006ull, 0x8000000000000006ull },
    { 0x80B6A17481624C4Dull, 0x80B6A17481624C4Dull },
    { 0x0001765C20BA0D88ull, 0x0001765C20BA0D88ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x8000001A16C7EC50ull, 0x8000001A16C7EC50ull },
    { 0x800038C29C720599ull, 0x800038C29C720599ull },
    { 0x000000003940D8BEull, 0x000000003940D8BEull },
    { 0x0000000000000001ull, 0x0000000000000001ull },
    { 0x0000000002A89944ull, 0x0000000002A89944ull },
    { 0x800000000000085Full, 0x800000000000085Full },
    { 0x800000048F58E3A6ull, 0x800000048F58E3A6ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x000B7E966BC06BF1ull, 0x000B7E966BC06BF1ull },
    { 0x8000000000000035ull, 0x8000000000000035ull },
    { 0x00000013B0B87B8Aull, 0x00000013B0B87B8Aull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x0000000000000000ull, 0x0000000000000000ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x800000B36EFE26E8ull, 0x800000B36EFE26E8ull },
    { 0x8000000000000000ull, 0x8000000000000000ull },
    { 0x80000008D143DD63ull, 0x80000008D143DD63ull },
    { 0x000000000000014Bull, 0x000000000000014Bull },
    { 0x8000000000000000ull, 0x8000000000000000ull }
};

