#pragma once
#ifndef __MFTDiagTranscodeTAEF_H__
#define __MFTDiagTranscodeTAEF_H__

#include "MFTDTaefBase.h"

BEGIN_MODULE()
    MODULE_PROPERTY(L"Feature", L"MFTDiagTranscode")
    MODULE_PROPERTY(L"ThreadingModel", L"MTA")
END_MODULE()

class CMFTDiagTranscodeTAEF : public WEX::TestClass<CMFTDiagTranscodeTAEF>, public CMFTDTaefBaseWithActivate
{
public:
    CMFTDiagTranscodeTAEF(void);
    ~CMFTDiagTranscodeTAEF(void);

    BEGIN_TEST_CLASS(CMFTDiagTranscodeTAEF)
    END_TEST_CLASS()

    TEST_CLASS_SETUP(InitializeTestClass)
    TEST_CLASS_CLEANUP(FinalizeTestClass)

    BEGIN_TEST_METHOD(TranscodeTest1)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"E3442ABD-426D-6A04-E0ED-73BF992C49EC")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"d576e19d-9d67-4163-ba44-a17f9861f3cb")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"H264 Encoder - HMFT Transcode test 1")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"HMFT Transcode Test: InputType H264, OutputType: H264 - H.264 Basic Functionality Transcodes source into H264 format")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Streaming.HMFT.Encoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\HMFTContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the HMFT to test - {DETECT} should be used for certification, this can be overridden to test a specific HMFT")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\HMFTContent\\005_MSHDRef_Texture_SkinTones_05_352x288p15f_baseline30_138kbps.mp4")
    END_TEST_METHOD()
 
    BEGIN_TEST_METHOD(TranscodeTest2) 
        TEST_METHOD_PROPERTY(L"InputType",      L"MJPEG") 
        TEST_METHOD_PROPERTY(L"OutputType",     L"H264") 
        TEST_METHOD_PROPERTY(L"ID",             L"2") 
        TEST_METHOD_PROPERTY(L"NumInstances",   L"1") 
        TEST_METHOD_PROPERTY(L"TestLevel",      L"3")
        TEST_METHOD_PROPERTY(L"TestLevel",      L"4")
    END_TEST_METHOD()
 
    BEGIN_TEST_METHOD(TranscodeTest3)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"741AB4C6-4896-C204-36C7-C69153199248")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"caecef00-cc33-4501-81ec-980717e9728c")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"MPEG4 Decoder - H264 Encoder - HMFT Transcode test 3")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"Transcode Test: InputType MPEG4, OutputType: H264 - MPEG4 Basic Functionality Transcode from MPEG4 to H264")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Streaming.HMFT.Decoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\HMFTContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the HMFT to test - {DETECT} should be used for certification, this can be overridden to test a specific HMFT")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\HMFTContent\\15_MSHDRef_Difficult_Edge_02_720x480i30f_h263_1000kbps.avi")
    END_TEST_METHOD()
 
    BEGIN_TEST_METHOD(TranscodeTest4) 
        TEST_METHOD_PROPERTY(L"InputType",      L"VC-1") 
        TEST_METHOD_PROPERTY(L"OutputType",     L"H264") 
        TEST_METHOD_PROPERTY(L"ID",             L"4") 
        TEST_METHOD_PROPERTY(L"NumInstances",   L"1") 
        TEST_METHOD_PROPERTY(L"TestLevel",      L"3")
        TEST_METHOD_PROPERTY(L"TestLevel",      L"4")
    END_TEST_METHOD()
 
    BEGIN_TEST_METHOD(TranscodeTest5) 
        TEST_METHOD_PROPERTY(L"InputType",      L"H264") 
        TEST_METHOD_PROPERTY(L"OutputType",     L"H264") 
        TEST_METHOD_PROPERTY(L"ID",             L"5") 
        TEST_METHOD_PROPERTY(L"NumInstances",   L"1") 
        TEST_METHOD_PROPERTY(L"DriverDrop",     L"TRUE") 
        TEST_METHOD_PROPERTY(L"TestLevel",      L"2")
        TEST_METHOD_PROPERTY(L"TestLevel",      L"4")
    END_TEST_METHOD()
 
    BEGIN_TEST_METHOD(TranscodeTest6) 
        TEST_METHOD_PROPERTY(L"InputType",      L"VC-1") 
        TEST_METHOD_PROPERTY(L"OutputType",     L"H264") 
        TEST_METHOD_PROPERTY(L"ID",             L"6") 
        TEST_METHOD_PROPERTY(L"NumInstances",   L"1") 
        TEST_METHOD_PROPERTY(L"TestLevel",      L"4")
    END_TEST_METHOD()
 
    BEGIN_TEST_METHOD(TranscodeTest7) 
        TEST_METHOD_PROPERTY(L"InputType",      L"MPEG4") 
        TEST_METHOD_PROPERTY(L"OutputType",     L"H264") 
        TEST_METHOD_PROPERTY(L"ID",             L"7") 
        TEST_METHOD_PROPERTY(L"NumInstances",   L"1") 
        TEST_METHOD_PROPERTY(L"TestLevel",      L"4")
    END_TEST_METHOD()
 
    BEGIN_TEST_METHOD(TranscodeTest8) 
        TEST_METHOD_PROPERTY(L"InputType",      L"VC-1") 
        TEST_METHOD_PROPERTY(L"OutputType",     L"H264") 
        TEST_METHOD_PROPERTY(L"ID",             L"8") 
        TEST_METHOD_PROPERTY(L"NumInstances",   L"1") 
        TEST_METHOD_PROPERTY(L"TestLevel",      L"4")
    END_TEST_METHOD()
 
    BEGIN_TEST_METHOD(TranscodeTest9) 
        TEST_METHOD_PROPERTY(L"InputType",      L"H264") 
        TEST_METHOD_PROPERTY(L"OutputType",     L"H264") 
        TEST_METHOD_PROPERTY(L"ID",             L"9") 
        TEST_METHOD_PROPERTY(L"NumInstances",   L"1") 
        TEST_METHOD_PROPERTY(L"DriverDrop",     L"TRUE") 
        TEST_METHOD_PROPERTY(L"TestLevel",      L"2")
        TEST_METHOD_PROPERTY(L"TestLevel",      L"4")
    END_TEST_METHOD()
 
    BEGIN_TEST_METHOD(TranscodeTest10) 
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"EBEC2B2C-4352-D20B-9921-F2943976EA4B")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"39aff3aa-f3de-40bc-b206-0f165d3d843b")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"MJPEG Decoder - H264 Encoder - HMFT Transcode test 10")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"Transcode Test: InputType MJPEG, OutputType: H264 - MJPEG Basic Functionality Transcode from MJPEG to H264")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Streaming.HMFT.Decoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\HMFTContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the HMFT to test - {DETECT} should be used for certification, this can be overridden to test a specific HMFT")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\HMFTContent\\23_AVI_MJPEG_720x480_10Mbps_2997_ADPCM_8kHz.avi")
    END_TEST_METHOD()
 
    BEGIN_TEST_METHOD(TranscodeTest11)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"CE180138-4862-A3C8-8B7E-F2961FDFA6D2")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"ded81e1f-bec3-4a89-8bc5-8ef2ee1022e6")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"H264 Encoder - HMFT Transcode test 11")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"HMFT Transcode Test: InputType RGB24, OutputType: H264 - H.264 Basic Functionality Transcodes source into H264 format")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Streaming.HMFT.Encoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\HMFTContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the HMFT to test - {DETECT} should be used for certification, this can be overridden to test a specific HMFT")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\HMFTContent\\MSHDRef_Difficult_Edge_03_1440x1080_25fps_RGB24.avi")
    END_TEST_METHOD()
 
    BEGIN_TEST_METHOD(TranscodeTest12) 
        TEST_METHOD_PROPERTY(L"InputType",      L"VC-1") 
        TEST_METHOD_PROPERTY(L"OutputType",     L"VC-1") 
        TEST_METHOD_PROPERTY(L"ID",             L"12") 
        TEST_METHOD_PROPERTY(L"NumInstances",   L"1") 
        TEST_METHOD_PROPERTY(L"TestLevel",      L"3")
        TEST_METHOD_PROPERTY(L"TestLevel",      L"4")
    END_TEST_METHOD()
 
    BEGIN_TEST_METHOD(TranscodeTest13) 
        TEST_METHOD_PROPERTY(L"InputType",      L"H264") 
        TEST_METHOD_PROPERTY(L"OutputType",     L"VC-1") 
        TEST_METHOD_PROPERTY(L"ID",             L"13") 
        TEST_METHOD_PROPERTY(L"NumInstances",   L"1") 
        TEST_METHOD_PROPERTY(L"TestLevel",      L"4")
    END_TEST_METHOD()
 
    BEGIN_TEST_METHOD(TranscodeTest14) 
        TEST_METHOD_PROPERTY(L"InputType",      L"MPEG4") 
        TEST_METHOD_PROPERTY(L"OutputType",     L"VC-1") 
        TEST_METHOD_PROPERTY(L"ID",             L"14") 
        TEST_METHOD_PROPERTY(L"NumInstances",   L"1") 
        TEST_METHOD_PROPERTY(L"TestLevel",      L"4")
    END_TEST_METHOD()
 
    BEGIN_TEST_METHOD(TranscodeTest15) 
        TEST_METHOD_PROPERTY(L"InputType",      L"IYUV") 
        TEST_METHOD_PROPERTY(L"OutputType",     L"VC-1") 
        TEST_METHOD_PROPERTY(L"ID",             L"15") 
        TEST_METHOD_PROPERTY(L"NumInstances",   L"1") 
        TEST_METHOD_PROPERTY(L"DriverDrop",     L"TRUE") 
        TEST_METHOD_PROPERTY(L"TestLevel",      L"2")
        TEST_METHOD_PROPERTY(L"TestLevel",      L"4")
    END_TEST_METHOD()
 
    BEGIN_TEST_METHOD(TranscodeTest16) 
        TEST_METHOD_PROPERTY(L"InputType",      L"VC-1") 
        TEST_METHOD_PROPERTY(L"OutputType",     L"VC-1") 
        TEST_METHOD_PROPERTY(L"ID",             L"16") 
        TEST_METHOD_PROPERTY(L"NumInstances",   L"1") 
        TEST_METHOD_PROPERTY(L"TestLevel",      L"4")
    END_TEST_METHOD()
 
    BEGIN_TEST_METHOD(TranscodeTest17) 
        TEST_METHOD_PROPERTY(L"InputType",      L"H264") 
        TEST_METHOD_PROPERTY(L"OutputType",     L"VC-1") 
        TEST_METHOD_PROPERTY(L"ID",             L"17") 
        TEST_METHOD_PROPERTY(L"NumInstances",   L"1") 
        TEST_METHOD_PROPERTY(L"TestLevel",      L"4")
    END_TEST_METHOD()
 
    BEGIN_TEST_METHOD(TranscodeTest18) 
        TEST_METHOD_PROPERTY(L"InputType",      L"VC-1") 
        TEST_METHOD_PROPERTY(L"OutputType",     L"VC-1") 
        TEST_METHOD_PROPERTY(L"ID",             L"18") 
        TEST_METHOD_PROPERTY(L"NumInstances",   L"1") 
        TEST_METHOD_PROPERTY(L"DriverDrop",     L"TRUE") 
        TEST_METHOD_PROPERTY(L"TestLevel",      L"2")
        TEST_METHOD_PROPERTY(L"TestLevel",      L"4")
    END_TEST_METHOD()
 
    BEGIN_TEST_METHOD(TranscodeTest19) 
        TEST_METHOD_PROPERTY(L"InputType",      L"MPEG4") 
        TEST_METHOD_PROPERTY(L"OutputType",     L"VC-1") 
        TEST_METHOD_PROPERTY(L"ID",             L"19") 
        TEST_METHOD_PROPERTY(L"NumInstances",   L"1") 
        TEST_METHOD_PROPERTY(L"TestLevel",      L"4")
    END_TEST_METHOD()
 
    BEGIN_TEST_METHOD(TranscodeTest20) 
        TEST_METHOD_PROPERTY(L"InputType",      L"DV") 
        TEST_METHOD_PROPERTY(L"OutputType",     L"VC-1") 
        TEST_METHOD_PROPERTY(L"ID",             L"20") 
        TEST_METHOD_PROPERTY(L"NumInstances",   L"1") 
        TEST_METHOD_PROPERTY(L"TestLevel",      L"3")
        TEST_METHOD_PROPERTY(L"TestLevel",      L"4")
    END_TEST_METHOD()
 
    BEGIN_TEST_METHOD(TranscodeTest21) 
        TEST_METHOD_PROPERTY(L"InputType",      L"WMV7") 
        TEST_METHOD_PROPERTY(L"OutputType",     L"VC-1") 
        TEST_METHOD_PROPERTY(L"ID",             L"21") 
        TEST_METHOD_PROPERTY(L"NumInstances",   L"1") 
        TEST_METHOD_PROPERTY(L"TestLevel",      L"3")
        TEST_METHOD_PROPERTY(L"TestLevel",      L"4")
    END_TEST_METHOD()
 
    BEGIN_TEST_METHOD(TranscodeTest22) 
        TEST_METHOD_PROPERTY(L"InputType",      L"MJPEG") 
        TEST_METHOD_PROPERTY(L"OutputType",     L"WMV9") 
        TEST_METHOD_PROPERTY(L"ID",             L"22") 
        TEST_METHOD_PROPERTY(L"NumInstances",   L"1") 
        TEST_METHOD_PROPERTY(L"TestLevel",      L"4")
    END_TEST_METHOD()
 
    BEGIN_TEST_METHOD(TranscodeTest23) 
        TEST_METHOD_PROPERTY(L"InputType",      L"WMV8") 
        TEST_METHOD_PROPERTY(L"OutputType",     L"WMV9") 
        TEST_METHOD_PROPERTY(L"ID",             L"23") 
        TEST_METHOD_PROPERTY(L"NumInstances",   L"1") 
        TEST_METHOD_PROPERTY(L"TestLevel",      L"3")
        TEST_METHOD_PROPERTY(L"TestLevel",      L"4")
    END_TEST_METHOD()
 
    BEGIN_TEST_METHOD(TranscodeTest24) 
        TEST_METHOD_PROPERTY(L"InputType",      L"H264") 
        TEST_METHOD_PROPERTY(L"OutputType",     L"WMV9") 
        TEST_METHOD_PROPERTY(L"ID",             L"24") 
        TEST_METHOD_PROPERTY(L"NumInstances",   L"1") 
        TEST_METHOD_PROPERTY(L"TestLevel",      L"4")
    END_TEST_METHOD()
 
    BEGIN_TEST_METHOD(TranscodeTest25) 
        TEST_METHOD_PROPERTY(L"InputType",      L"MPEG4") 
        TEST_METHOD_PROPERTY(L"OutputType",     L"WMV9") 
        TEST_METHOD_PROPERTY(L"ID",             L"25") 
        TEST_METHOD_PROPERTY(L"NumInstances",   L"1") 
        TEST_METHOD_PROPERTY(L"TestLevel",      L"4")
    END_TEST_METHOD()
 
    BEGIN_TEST_METHOD(TranscodeTest26) 
        TEST_METHOD_PROPERTY(L"InputType",      L"VC-1") 
        TEST_METHOD_PROPERTY(L"OutputType",     L"WMV9") 
        TEST_METHOD_PROPERTY(L"ID",             L"26") 
        TEST_METHOD_PROPERTY(L"NumInstances",   L"1") 
        TEST_METHOD_PROPERTY(L"TestLevel",      L"3")
        TEST_METHOD_PROPERTY(L"TestLevel",      L"4")
    END_TEST_METHOD()
 
    BEGIN_TEST_METHOD(TranscodeTest27) 
        TEST_METHOD_PROPERTY(L"InputType",      L"H264") 
        TEST_METHOD_PROPERTY(L"OutputType",     L"WMV9") 
        TEST_METHOD_PROPERTY(L"ID",             L"27")        
        TEST_METHOD_PROPERTY(L"NumInstances",   L"1") 
        TEST_METHOD_PROPERTY(L"TestLevel",      L"4")
    END_TEST_METHOD()
 
    BEGIN_TEST_METHOD(TranscodeTest28) 
        TEST_METHOD_PROPERTY(L"InputType",      L"YUY2") 
        TEST_METHOD_PROPERTY(L"OutputType",     L"WMV9") 
        TEST_METHOD_PROPERTY(L"ID",             L"28") 
        TEST_METHOD_PROPERTY(L"NumInstances",   L"1") 
        TEST_METHOD_PROPERTY(L"TestLevel",      L"4")
    END_TEST_METHOD()
 
    BEGIN_TEST_METHOD(TranscodeTest29) 
        TEST_METHOD_PROPERTY(L"InputType",      L"H264") 
        TEST_METHOD_PROPERTY(L"OutputType",     L"WMV9") 
        TEST_METHOD_PROPERTY(L"ID",             L"29") 
        TEST_METHOD_PROPERTY(L"TestLevel",      L"4")
        TEST_METHOD_PROPERTY(L"NumInstances",   L"1") 
    END_TEST_METHOD()
 
    BEGIN_TEST_METHOD(TranscodeTest30) 
        TEST_METHOD_PROPERTY(L"InputType",      L"MPEG4") 
        TEST_METHOD_PROPERTY(L"OutputType",     L"WMV9") 
        TEST_METHOD_PROPERTY(L"ID",             L"30") 
        TEST_METHOD_PROPERTY(L"NumInstances",   L"1") 
        TEST_METHOD_PROPERTY(L"TestLevel",      L"4")
    END_TEST_METHOD()
 
    BEGIN_TEST_METHOD(TranscodeTest31) 
        TEST_METHOD_PROPERTY(L"InputType",      L"VC-1") 
        TEST_METHOD_PROPERTY(L"OutputType",     L"WMV9") 
        TEST_METHOD_PROPERTY(L"ID",             L"31") 
        TEST_METHOD_PROPERTY(L"NumInstances",   L"1") 
        TEST_METHOD_PROPERTY(L"TestLevel",      L"4")
    END_TEST_METHOD()

    BEGIN_TEST_METHOD(MITranscodeTest32)
        TEST_METHOD_PROPERTY(L"Kits.TestId", L"775CE70F-4E09-91DF-AEF7-968A5120FFD5")
        TEST_METHOD_PROPERTY(L"Kits.TestId2", L"6678d96f-d611-4286-9938-1de792c60bff")
        TEST_METHOD_PROPERTY(L"Kits.TestName", L"H264 Encoder - HMFT Transcode test 32")
        TEST_METHOD_PROPERTY(L"Kits.TestType", L"Development")
        TEST_METHOD_PROPERTY(L"Kits.RequiresReboot", L"False")
        TEST_METHOD_PROPERTY(L"Kits.ExpectedRuntime", L"15")
        TEST_METHOD_PROPERTY(L"Kits.TimeoutInMinutes", L"15")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x86")
        TEST_METHOD_PROPERTY(L"Kits.SupportedOS", L"Windows v10.0 Client x64")
        TEST_METHOD_PROPERTY(L"Kits.MinRelease", L"TH1")
        TEST_METHOD_PROPERTY(L"Kits.CorePackageComposition", L"Full")
        TEST_METHOD_PROPERTY(L"Kits.PublishingOrganization", L"Microsoft Corporation")
        TEST_METHOD_PROPERTY(L"Kits.Description", L"MI Transcode Test: InputType H264, OutputType: H264 - H.264 Basic Functionality Transcodes source into H264 format")
        TEST_METHOD_PROPERTY(L"Kits.DevelopmentPhase", L"Development and Integration")
        TEST_METHOD_PROPERTY(L"Kits.Specification", L"Device.Streaming.HMFT.Encoding")
        TEST_METHOD_PROPERTY(L"Kits.HasSupplementalContent", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"ContentSource")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Default", L"[WTT\\TestBinRoot]\\..\\HMFTContent")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.ContentSource.Description", L"Path to source File")
        TEST_METHOD_PROPERTY(L"Kits.Parameter", L"GUID")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Default", L"#{DETECT}#")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.IsRequired", L"TRUE")
        TEST_METHOD_PROPERTY(L"Kits.Parameter.GUID.Description", L"The GUID of the HMFT to test - {DETECT} should be used for certification, this can be overridden to test a specific HMFT")
        TEST_METHOD_PROPERTY(L"Kits.DeploymentItem", L"..\\HMFTContent\\005_MSHDRef_Texture_SkinTones_05_352x288p15f_baseline30_138kbps.mp4")
    END_TEST_METHOD()
 
    BEGIN_TEST_METHOD(MITranscodeTest33) 
        TEST_METHOD_PROPERTY(L"InputType",      L"VC-1") 
        TEST_METHOD_PROPERTY(L"OutputType",     L"H264") 
        TEST_METHOD_PROPERTY(L"ID",             L"33") 
        TEST_METHOD_PROPERTY(L"NumInstances",   L"2") 
        TEST_METHOD_PROPERTY(L"TestLevel",      L"4")
    END_TEST_METHOD()
 
    BEGIN_TEST_METHOD(MITranscodeTest34) 
        TEST_METHOD_PROPERTY(L"InputType",      L"MPEG4") 
        TEST_METHOD_PROPERTY(L"OutputType",     L"H264") 
        TEST_METHOD_PROPERTY(L"ID",             L"34") 
        TEST_METHOD_PROPERTY(L"NumInstances",   L"2") 
        TEST_METHOD_PROPERTY(L"TestLevel",      L"3")
        TEST_METHOD_PROPERTY(L"TestLevel",      L"4")
    END_TEST_METHOD()
 
    BEGIN_TEST_METHOD(MITranscodeTest35) 
        TEST_METHOD_PROPERTY(L"InputType",      L"VC-1") 
        TEST_METHOD_PROPERTY(L"OutputType",     L"H264") 
        TEST_METHOD_PROPERTY(L"ID",             L"35") 
        TEST_METHOD_PROPERTY(L"NumInstances",   L"2") 
        TEST_METHOD_PROPERTY(L"TestLevel",      L"3")
        TEST_METHOD_PROPERTY(L"TestLevel",      L"4")
    END_TEST_METHOD()
 
    BEGIN_TEST_METHOD(MITranscodeTest36) 
        TEST_METHOD_PROPERTY(L"InputType",      L"H264") 
        TEST_METHOD_PROPERTY(L"OutputType",     L"H264") 
        TEST_METHOD_PROPERTY(L"ID",             L"36") 
        TEST_METHOD_PROPERTY(L"NumInstances",   L"2") 
        TEST_METHOD_PROPERTY(L"TestLevel",      L"4")
    END_TEST_METHOD()
 
    BEGIN_TEST_METHOD(MITranscodeTest37) 
        TEST_METHOD_PROPERTY(L"InputType",      L"VC-1") 
        TEST_METHOD_PROPERTY(L"OutputType",     L"H264") 
        TEST_METHOD_PROPERTY(L"ID",             L"37") 
        TEST_METHOD_PROPERTY(L"NumInstances",   L"2") 
        TEST_METHOD_PROPERTY(L"TestLevel",      L"4")
    END_TEST_METHOD()
 
    BEGIN_TEST_METHOD(MITranscodeTest38) 
        TEST_METHOD_PROPERTY(L"InputType",      L"MPEG4") 
        TEST_METHOD_PROPERTY(L"OutputType",     L"H264") 
        TEST_METHOD_PROPERTY(L"ID",             L"38") 
        TEST_METHOD_PROPERTY(L"NumInstances",   L"2") 
        TEST_METHOD_PROPERTY(L"TestLevel",      L"4")
    END_TEST_METHOD()
 
    BEGIN_TEST_METHOD(MITranscodeTest39) 
        TEST_METHOD_PROPERTY(L"InputType",      L"VC-1") 
        TEST_METHOD_PROPERTY(L"OutputType",     L"H264") 
        TEST_METHOD_PROPERTY(L"ID",             L"39") 
        TEST_METHOD_PROPERTY(L"NumInstances",   L"2") 
        TEST_METHOD_PROPERTY(L"TestLevel",      L"3")
        TEST_METHOD_PROPERTY(L"TestLevel",      L"4")
    END_TEST_METHOD()
 
    BEGIN_TEST_METHOD(MITranscodeTest40) 
        TEST_METHOD_PROPERTY(L"InputType",      L"H264") 
        TEST_METHOD_PROPERTY(L"OutputType",     L"H264") 
        TEST_METHOD_PROPERTY(L"ID",             L"40") 
        TEST_METHOD_PROPERTY(L"NumInstances",   L"2") 
        TEST_METHOD_PROPERTY(L"TestLevel",      L"4")
    END_TEST_METHOD()
 
    BEGIN_TEST_METHOD(MITranscodeTest41) 
        TEST_METHOD_PROPERTY(L"InputType",      L"H264") 
        TEST_METHOD_PROPERTY(L"OutputType",     L"H264") 
        TEST_METHOD_PROPERTY(L"ID",             L"41") 
        TEST_METHOD_PROPERTY(L"NumInstances",   L"2") 
        TEST_METHOD_PROPERTY(L"TestLevel",      L"4")
    END_TEST_METHOD()
 
    BEGIN_TEST_METHOD(MITranscodeTest42) 
        TEST_METHOD_PROPERTY(L"InputType",      L"RGB24") 
        TEST_METHOD_PROPERTY(L"OutputType",     L"H264") 
        TEST_METHOD_PROPERTY(L"ID",             L"42") 
        TEST_METHOD_PROPERTY(L"NumInstances",   L"2") 
        TEST_METHOD_PROPERTY(L"TestLevel",      L"4")
    END_TEST_METHOD()
 
    BEGIN_TEST_METHOD(MITranscodeTest43) 
        TEST_METHOD_PROPERTY(L"InputType",      L"VC-1") 
        TEST_METHOD_PROPERTY(L"OutputType",     L"VC-1") 
        TEST_METHOD_PROPERTY(L"ID",             L"43") 
        TEST_METHOD_PROPERTY(L"NumInstances",   L"2") 
        TEST_METHOD_PROPERTY(L"TestLevel",      L"3")
        TEST_METHOD_PROPERTY(L"TestLevel",      L"4")
    END_TEST_METHOD()
 
    BEGIN_TEST_METHOD(MITranscodeTest44) 
        TEST_METHOD_PROPERTY(L"InputType",      L"H264") 
        TEST_METHOD_PROPERTY(L"OutputType",     L"VC-1") 
        TEST_METHOD_PROPERTY(L"ID",             L"44") 
        TEST_METHOD_PROPERTY(L"NumInstances",   L"2") 
        TEST_METHOD_PROPERTY(L"TestLevel",      L"4")
    END_TEST_METHOD()
 
    BEGIN_TEST_METHOD(MITranscodeTest45) 
        TEST_METHOD_PROPERTY(L"InputType",      L"MPEG4") 
        TEST_METHOD_PROPERTY(L"OutputType",     L"VC-1") 
        TEST_METHOD_PROPERTY(L"ID",             L"45") 
        TEST_METHOD_PROPERTY(L"NumInstances",   L"2")
        TEST_METHOD_PROPERTY(L"TestLevel",      L"3")
        TEST_METHOD_PROPERTY(L"TestLevel",      L"4")
    END_TEST_METHOD()
 
    BEGIN_TEST_METHOD(MITranscodeTest46) 
        TEST_METHOD_PROPERTY(L"InputType",      L"IYUV") 
        TEST_METHOD_PROPERTY(L"OutputType",     L"VC-1") 
        TEST_METHOD_PROPERTY(L"ID",             L"46") 
        TEST_METHOD_PROPERTY(L"NumInstances",   L"2") 
        TEST_METHOD_PROPERTY(L"TestLevel",      L"4")
    END_TEST_METHOD()
 
    BEGIN_TEST_METHOD(MITranscodeTest47) 
        TEST_METHOD_PROPERTY(L"InputType",      L"VC-1") 
        TEST_METHOD_PROPERTY(L"OutputType",     L"VC-1") 
        TEST_METHOD_PROPERTY(L"ID",             L"47") 
        TEST_METHOD_PROPERTY(L"NumInstances",   L"2") 
        TEST_METHOD_PROPERTY(L"TestLevel",      L"3")
        TEST_METHOD_PROPERTY(L"TestLevel",      L"4")
    END_TEST_METHOD()
 
    BEGIN_TEST_METHOD(MITranscodeTest48) 
        TEST_METHOD_PROPERTY(L"InputType",      L"H264") 
        TEST_METHOD_PROPERTY(L"OutputType",     L"VC-1") 
        TEST_METHOD_PROPERTY(L"ID",             L"48") 
        TEST_METHOD_PROPERTY(L"NumInstances",   L"2") 
        TEST_METHOD_PROPERTY(L"TestLevel",      L"4")
    END_TEST_METHOD()
 
    BEGIN_TEST_METHOD(MITranscodeTest49) 
        TEST_METHOD_PROPERTY(L"InputType",      L"MPEG4") 
        TEST_METHOD_PROPERTY(L"OutputType",     L"VC-1") 
        TEST_METHOD_PROPERTY(L"ID",             L"49") 
        TEST_METHOD_PROPERTY(L"NumInstances",   L"2") 
        TEST_METHOD_PROPERTY(L"TestLevel",      L"3")
        TEST_METHOD_PROPERTY(L"TestLevel",      L"4")
    END_TEST_METHOD()
 
    BEGIN_TEST_METHOD(MITranscodeTest50) 
        TEST_METHOD_PROPERTY(L"InputType",      L"MPEG4") 
        TEST_METHOD_PROPERTY(L"OutputType",     L"VC-1") 
        TEST_METHOD_PROPERTY(L"ID",             L"50") 
        TEST_METHOD_PROPERTY(L"NumInstances",   L"2") 
        TEST_METHOD_PROPERTY(L"TestLevel",      L"4")
    END_TEST_METHOD()
 
    BEGIN_TEST_METHOD(MITranscodeTest51) 
        TEST_METHOD_PROPERTY(L"InputType",      L"DV") 
        TEST_METHOD_PROPERTY(L"OutputType",     L"VC-1") 
        TEST_METHOD_PROPERTY(L"ID",             L"51") 
        TEST_METHOD_PROPERTY(L"NumInstances",   L"2") 
        TEST_METHOD_PROPERTY(L"TestLevel",      L"4")
    END_TEST_METHOD()
 
    BEGIN_TEST_METHOD(MITranscodeTest52) 
        TEST_METHOD_PROPERTY(L"InputType",      L"WMV7") 
        TEST_METHOD_PROPERTY(L"OutputType",     L"VC-1") 
        TEST_METHOD_PROPERTY(L"ID",             L"52") 
        TEST_METHOD_PROPERTY(L"NumInstances",   L"2") 
        TEST_METHOD_PROPERTY(L"TestLevel",      L"3")
        TEST_METHOD_PROPERTY(L"TestLevel",      L"4")
    END_TEST_METHOD()
 
    BEGIN_TEST_METHOD(MITranscodeTest53) 
        TEST_METHOD_PROPERTY(L"InputType",      L"H264") 
        TEST_METHOD_PROPERTY(L"OutputType",     L"WMV9") 
        TEST_METHOD_PROPERTY(L"ID",             L"53") 
        TEST_METHOD_PROPERTY(L"NumInstances",   L"2") 
        TEST_METHOD_PROPERTY(L"TestLevel",      L"4")
    END_TEST_METHOD()
 
    BEGIN_TEST_METHOD(MITranscodeTest54) 
        TEST_METHOD_PROPERTY(L"InputType",      L"WMV8") 
        TEST_METHOD_PROPERTY(L"OutputType",     L"WMV9") 
        TEST_METHOD_PROPERTY(L"ID",             L"54") 
        TEST_METHOD_PROPERTY(L"NumInstances",   L"2") 
        TEST_METHOD_PROPERTY(L"TestLevel",      L"3")
        TEST_METHOD_PROPERTY(L"TestLevel",      L"4")
    END_TEST_METHOD()
 
    BEGIN_TEST_METHOD(MITranscodeTest55) 
        TEST_METHOD_PROPERTY(L"InputType",      L"MPEG4") 
        TEST_METHOD_PROPERTY(L"OutputType",     L"WMV9") 
        TEST_METHOD_PROPERTY(L"ID",             L"55") 
        TEST_METHOD_PROPERTY(L"NumInstances",   L"2") 
        TEST_METHOD_PROPERTY(L"TestLevel",      L"4")
    END_TEST_METHOD()
 
    BEGIN_TEST_METHOD(MITranscodeTest56) 
        TEST_METHOD_PROPERTY(L"InputType",      L"MPEG4") 
        TEST_METHOD_PROPERTY(L"OutputType",     L"WMV9") 
        TEST_METHOD_PROPERTY(L"ID",             L"56") 
        TEST_METHOD_PROPERTY(L"NumInstances",   L"2") 
        TEST_METHOD_PROPERTY(L"TestLevel",      L"4")
    END_TEST_METHOD()
 
    BEGIN_TEST_METHOD(MITranscodeTest57) 
        TEST_METHOD_PROPERTY(L"InputType",      L"VC-1") 
        TEST_METHOD_PROPERTY(L"OutputType",     L"WMV9") 
        TEST_METHOD_PROPERTY(L"ID",             L"57") 
        TEST_METHOD_PROPERTY(L"NumInstances",   L"2") 
        TEST_METHOD_PROPERTY(L"TestLevel",      L"3")
        TEST_METHOD_PROPERTY(L"TestLevel",      L"4")
    END_TEST_METHOD()
 
    BEGIN_TEST_METHOD(MITranscodeTest58) 
        TEST_METHOD_PROPERTY(L"InputType",      L"H264") 
        TEST_METHOD_PROPERTY(L"OutputType",     L"WMV9") 
        TEST_METHOD_PROPERTY(L"ID",             L"58") 
        TEST_METHOD_PROPERTY(L"NumInstances",   L"2") 
        TEST_METHOD_PROPERTY(L"TestLevel",      L"3")
        TEST_METHOD_PROPERTY(L"TestLevel",      L"4")
    END_TEST_METHOD()
 
    BEGIN_TEST_METHOD(MITranscodeTest59) 
        TEST_METHOD_PROPERTY(L"InputType",      L"YUY2") 
        TEST_METHOD_PROPERTY(L"OutputType",     L"WMV9") 
        TEST_METHOD_PROPERTY(L"ID",             L"59") 
        TEST_METHOD_PROPERTY(L"NumInstances",   L"2") 
        TEST_METHOD_PROPERTY(L"TestLevel",      L"3")
        TEST_METHOD_PROPERTY(L"TestLevel",      L"4")
    END_TEST_METHOD()
 
    BEGIN_TEST_METHOD(MITranscodeTest60) 
        TEST_METHOD_PROPERTY(L"InputType",      L"MPEG4") 
        TEST_METHOD_PROPERTY(L"OutputType",     L"WMV9") 
        TEST_METHOD_PROPERTY(L"ID",             L"60") 
        TEST_METHOD_PROPERTY(L"NumInstances",   L"2") 
        TEST_METHOD_PROPERTY(L"TestLevel",      L"3")
        TEST_METHOD_PROPERTY(L"TestLevel",      L"4")
    END_TEST_METHOD()
 
    BEGIN_TEST_METHOD(MITranscodeTest61) 
        TEST_METHOD_PROPERTY(L"InputType",      L"MPEG4") 
        TEST_METHOD_PROPERTY(L"OutputType",     L"WMV9") 
        TEST_METHOD_PROPERTY(L"ID",             L"61") 
        TEST_METHOD_PROPERTY(L"NumInstances",   L"2") 
        TEST_METHOD_PROPERTY(L"TestLevel",      L"4")
    END_TEST_METHOD()
 
    BEGIN_TEST_METHOD(MITranscodeTest62) 
        TEST_METHOD_PROPERTY(L"InputType",      L"VC-1") 
        TEST_METHOD_PROPERTY(L"OutputType",     L"WMV9") 
        TEST_METHOD_PROPERTY(L"ID",             L"62") 
        TEST_METHOD_PROPERTY(L"NumInstances",   L"2") 
        TEST_METHOD_PROPERTY(L"TestLevel",      L"3")
        TEST_METHOD_PROPERTY(L"TestLevel",      L"4")
    END_TEST_METHOD()

    BEGIN_TEST_METHOD(CustomXML)
        TEST_METHOD_PROPERTY(L"CustomXML", L"TRUE")
    END_TEST_METHOD()

protected:
    HRESULT RunActualTest(const DWORD dwTestID, const GUID* pGUIDMFTUnderTest, const WCHAR* pszHWURL);
};

#endif //__MFTDiagTAEF_H__
