/*++

Copyright (C) Microsoft. All rights reserved.

Module Name:

    trace.c

Abstract:

    This module implements the debugging and tracing support for the GPIO class
    extension driver.


Environment:

    Kernel mode

--*/

//
// ------------------------------------------------------------------- Includes
//

#include "pch.h"

#if defined(EVENT_TRACING)
#include "trace.tmh"         // auto-generated by WPP
#endif

//
// -------------------------------------------------------------------- Globals
//

#if !defined(EVENT_TRACING)
ULONG DebugFlag = 0xff;
#endif

//
// ------------------------------------------------------------------ Functions
//

#if !defined(EVENT_TRACING)

VOID
TraceEvents (
    __in HANDLE LogHandle,
    __in ULONG DebugPrintLevel,
    __in ULONG DebugPrintFlag,
    __drv_formatString(printf) __in PCSTR DebugMessage,
    ...
    )

/*++

Routine Description:

    This routine print debug information when event tracing is disabled.

Arguments:

    DebugPrintLevel - Supplies the debug print level.

    DebugPrintFlag - Supplies the flag controlling the tracing.

    DebugMessage - Supplies the format string for the output message.

Return Value:

    None.

 --*/
 {

#if DBG

    va_list    ArgList;

    UNREFERENCED_PARAMETER(LogHandle);

    va_start(ArgList, DebugMessage);

    //
    // Call the kernel function to print the message.
    //

    if ((DebugPrintFlag & DebugFlag) == DebugPrintFlag) {
        vDbgPrintEx(DPFLTR_GPIO_ID,
                    DebugPrintLevel,
                    (PSTR)DebugMessage,
                    ArgList);
    }

    va_end(ArgList);
    return;

#else

    UNREFERENCED_PARAMETER(LogHandle);
    UNREFERENCED_PARAMETER(DebugPrintLevel);
    UNREFERENCED_PARAMETER(DebugPrintFlag);
    UNREFERENCED_PARAMETER(DebugMessage);

#endif

}

#endif


