#
#
#  R E A D   T H I S
#
#  See the inference rules below (the section marked "Inference rules") to
#  see if any of them cover the rule that you want performed for your file.
#  The inference rules should cover most of the cases.  If they don't, try
#  to add a new inference rule rather than adding a special-case rule for
#  your file.
#


# Add intermediate build files to WORK_FILES so they can be cleaned up.
WORK_FILES = \
    wininet.x   \
    wininetp.x  \


# This cleans up everything in these macro lists.  The magic for() command below
# cleans up any .h and .tlb files generated from the .idl files.
clean:
    -del /F /Q $(FILES0a)
    -del /F /Q $(FILES0b)
    -del /F /Q $(FILES0c)
    -del /F /Q $(FILES0d)
    -del /F /Q $(FILESa)
    -del /F /Q $(FILESb)
    -del /F /Q $(FILESc)
    -del /F /Q $(WORK_FILES)
    -del /F /Q $(RELOCATED_FILES)
    -for %i in (*.idl) do del %~ni*.tlb 2>nul & del $(_OBJ_DIR)\%~ni*.h 2>nul


#
# Special rules for splitting out .w files
#

# intshcut.h and intshctp.h

$(SDK_INC_PATH)\intshcut.h $(PRIVATE_INC_PATH)\intshctp.h: intshcut.w
    hsplit -e -o $(SDK_INC_PATH)\intshcut.h $(PRIVATE_INC_PATH)\intshctp.h $?


# wininet.h and wininetp.h

$(O)\wininet.x $(O)\wininetp.x: wininet.w
    hsplit -e -o $(O)\wininet.x $(O)\wininetp.x $?

$(SDK_INC_PATH)\wininet.h: $(O)\wininet.x
    wcshdr < $? > $@

$(SDK_INC_PATH)\winineti.h: $(O)\wininetp.x
    wcshdr < $? > $@


#
# Non-obvious Dependencies
#


#
# Inference rules.  These help build whatever is in the NTTARGETFILES and
# NTTARGETFILE0 lists.  Most of these simply copy files.
#

.SUFFIXES:.h .w .hpp .tlb .dlg

# I'd explain this, but you probably don't have to worry about it.
{}.w{$(SDK_INC_PATH)}.h:
    hsplit -e -o $(?R).x $(?R)p.x $?
    wcshdr < $(?R).x > $*.h

{}.w{$O}.h:
    hsplit -e -o $(?R).x $(?R)p.x $?
    wcshdr < $(?R).x > $*.h

{}.w{}.h:
    hsplit -e -o $(?R).x $(?R)p.x $?
    wcshdr < $(?R).x > $*.h

# Copy .h file from here to private\inc
{}.h{$(PRIVATE_INC_PATH)}.h:
    copy $** $@

# Copy .idl file from here to sdk\inc
{}.idl{$(SDK_INC_PATH)}.idl:
    copy $? $@

# Copy .tlb file from here to sdk\lib\*
{}.tlb{$(SDK_LIB_PATH)}.tlb:
    copy $? $@

# Copy .h file from here to sdk\inc
{}.h{$(SDK_INC_PATH)}.h:
    copy $** $@

# Copy .h file from obj dir to sdk\inc
{$O}.h{$(SDK_INC_PATH)}.h:
    copy $** $@

# Copy .h file from obj dir (during pass 0) to sdk\inc
{$(PASS0_HEADERDIR)}.h{$(SDK_INC_PATH)}.h:
    copy $** $@

# Copy .dlg file from here to sdk\inc
{}.dlg{$(SDK_INC_PATH)}.dlg:
    copy $** $@

# Copy .hpp file from here to sdk\inc
{}.hpp{$(SDK_INC_PATH)}.hpp:
    copy $** $@

# Remove some files after PASS0 files are generated.

$(O)\dummy: 
    -del /q $(FILESdel)


#
# Other special rules
#

!if exist($(BASEDIR)\private\admin\services\sched\types\idl\mstask.idl)
$(SDK_INC_PATH)\mstask.idl: $(BASEDIR)\private\admin\services\sched\types\idl\mstask.idl
    copy /v $** $@

$(SDK_INC_PATH)\mstask.h : $(BASEDIR)\private\admin\services\sched\types\idl\mstask.idl \
                           $(BASEDIR)\private\admin\services\sched\types\mc\msterr.mc
    cd $(BASEDIR)\private\admin\services\sched\types\idl
    build -O
    nmake PASS0ONLY=1 BUILDMSG=
    cd..\mc
    build -O
    nmake PASS0ONLY=1 BUILDMSG=
    cd..\proxy
    build -O
    nmake PASS0ONLY=1 BUILDMSG=
    cd $(MAKEDIR)
!endif

#
#   mshtml.h and qcore.h have special funkiness:
#
#       mshtml.idl -> obj\mshtml.h -[copy]-> sdk\inc\mshtmlc.h
#                     obj\mshtml.h -[sed]--> sdk\inc\mshtml.h
#
#   obj\mshtml.h is generated by MIDL and contains both C and C++ support.
#   splthdr.sed removes the C support; the result goes to sdk\inc\mshtml.h.
#   The C version goes to sdk\inc\mshtmlc.h.

$(SDK_INC_PATH)\mshtmlc.h: $O\..\mshtml.h
    copy $O\..\mshtml.h $(SDK_INC_PATH)\mshtmlc.h

$(SDK_INC_PATH)\mshtml.h: $O\..\mshtml.h
    type << >$(SDK_INC_PATH)\mshtml.h
#if !defined(__cplusplus) || defined(CINTERFACE)
// Include the full header file that works for C
#include "mshtmlc.h"
#else
<<NOKEEP
    sed -f splthdr.sed $O\..\mshtml.h >>$(SDK_INC_PATH)\mshtml.h

#
#   Same goes for qcore.
#

$(SDK_INC_PATH)\qcorec.h: $O\..\qcore.h
    copy $O\..\qcore.h $(SDK_INC_PATH)\qcorec.h

$(SDK_INC_PATH)\qcore.h: $O\..\qcore.h
    type << >$(SDK_INC_PATH)\qcore.h
#if !defined(__cplusplus) || defined(CINTERFACE)
// Include the full header file that works for C
#include "qcorec.h"
#else
<<NOKEEP
    sed -f splthdr.sed $O\..\qcore.h >>$(SDK_INC_PATH)\qcore.h
