//==========================================================================;
//
//  THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY
//  KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
//  IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR
//  PURPOSE.
//
//  Copyright (c) 1992-1998  Microsoft Corporation.  All Rights Reserved.
//
//--------------------------------------------------------------------------;
//
// contains the GUIDs for the MediaType type, subtype fields and format types
// for standard media types, and also class ids for well-known components.


//
//  We want to use this list for generating strings for debugging too
//  so we redefine OUR_GUID_ENTRY depending on what we want to do
//
//  It is imperative that all entries in this file are declared using
//  OUR_GUID_ENTRY as that macro might have been defined in advance of
//  including this file.  See wxdebug.cpp in sdk\classes\base.
//

#ifndef OUR_GUID_ENTRY
    #define OUR_GUID_ENTRY(name, l, w1, w2, b1, b2, b3, b4, b5, b6, b7, b8) \
	DEFINE_GUID(name, l, w1, w2, b1, b2, b3, b4, b5, b6, b7, b8);
#endif


// -- to allow consistent labeling of Media types and subtypes --

#define MEDIATYPE_NULL       GUID_NULL
#define MEDIASUBTYPE_NULL    GUID_NULL


// -- major types ---


// 73646976-0000-0010-8000-00AA00389B71  'vids' == MEDIATYPE_Video
OUR_GUID_ENTRY(MEDIATYPE_Video,
0x73646976, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

// 73647561-0000-0010-8000-00AA00389B71  'auds' == MEDIATYPE_Audio
OUR_GUID_ENTRY(MEDIATYPE_Audio,
0x73647561, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

// 73747874-0000-0010-8000-00AA00389B71  'txts' == MEDIATYPE_Text
OUR_GUID_ENTRY(MEDIATYPE_Text,
0x73747874, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

// 7364696D-0000-0010-8000-00AA00389B71  'mids' == MEDIATYPE_Midi
OUR_GUID_ENTRY(MEDIATYPE_Midi,
0x7364696D, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

// e436eb83-524f-11ce-9f53-0020af0ba770            MEDIATYPE_Stream
OUR_GUID_ENTRY(MEDIATYPE_Stream,
0xe436eb83, 0x524f, 0x11ce, 0x9f, 0x53, 0x00, 0x20, 0xaf, 0x0b, 0xa7, 0x70)

// 73(s)76(v)61(a)69(i)-0000-0010-8000-00AA00389B71  'iavs' == MEDIATYPE_Interleaved
OUR_GUID_ENTRY(MEDIATYPE_Interleaved,
0x73766169, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)


// -- sub types ---


// 39555659-0000-0010-8000-00AA00389B71  'YVU9' == MEDIASUBTYPE_YVU9
OUR_GUID_ENTRY(MEDIASUBTYPE_YVU9,
0x39555659, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

// 31313459-0000-0010-8000-00AA00389B71  'Y411' == MEDIASUBTYPE_Y411
OUR_GUID_ENTRY(MEDIASUBTYPE_Y411,
0x31313459, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

// 50313459-0000-0010-8000-00AA00389B71  'Y41P' == MEDIASUBTYPE_Y41P
OUR_GUID_ENTRY(MEDIASUBTYPE_Y41P,
0x50313459, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

// 32595559-0000-0010-8000-00AA00389B71  'YUY2' == MEDIASUBTYPE_YUY2
OUR_GUID_ENTRY(MEDIASUBTYPE_YUY2,
0x32595559, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

// 55595659-0000-0010-8000-00AA00389B71  'YVYU' == MEDIASUBTYPE_YVYU
OUR_GUID_ENTRY(MEDIASUBTYPE_YVYU,
0x55595659, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

// 59565955-0000-0010-8000-00AA00389B71  'UYVY' ==  MEDIASUBTYPE_UYVY
OUR_GUID_ENTRY(MEDIASUBTYPE_UYVY,
0x59565955, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

// 31313259-0000-0010-8000-00AA00389B71  'Y211' ==  MEDIASUBTYPE_Y211
OUR_GUID_ENTRY(MEDIASUBTYPE_Y211,
0x31313259, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

// 524a4c43-0000-0010-8000-00AA00389B71  'CLJR' ==  MEDIASUBTYPE_CLJR
OUR_GUID_ENTRY(MEDIASUBTYPE_CLJR,
0x524a4c43, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

// 39304649-0000-0010-8000-00AA00389B71  'IF09' ==  MEDIASUBTYPE_IF09
OUR_GUID_ENTRY(MEDIASUBTYPE_IF09,
0x39304649, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

// 414c5043-0000-0010-8000-00AA00389B71  'CPLA' ==  MEDIASUBTYPE_CPLA
OUR_GUID_ENTRY(MEDIASUBTYPE_CPLA,
0x414c5043, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

// e436eb78-524f-11ce-9f53-0020af0ba770            MEDIASUBTYPE_RGB1
OUR_GUID_ENTRY(MEDIASUBTYPE_RGB1,
0xe436eb78, 0x524f, 0x11ce, 0x9f, 0x53, 0x00, 0x20, 0xaf, 0x0b, 0xa7, 0x70)

// e436eb79-524f-11ce-9f53-0020af0ba770            MEDIASUBTYPE_RGB4
OUR_GUID_ENTRY(MEDIASUBTYPE_RGB4,
0xe436eb79, 0x524f, 0x11ce, 0x9f, 0x53, 0x00, 0x20, 0xaf, 0x0b, 0xa7, 0x70)

// e436eb7a-524f-11ce-9f53-0020af0ba770            MEDIASUBTYPE_RGB8
OUR_GUID_ENTRY(MEDIASUBTYPE_RGB8,
0xe436eb7a, 0x524f, 0x11ce, 0x9f, 0x53, 0x00, 0x20, 0xaf, 0x0b, 0xa7, 0x70)

// e436eb7b-524f-11ce-9f53-0020af0ba770            MEDIASUBTYPE_RGB565
OUR_GUID_ENTRY(MEDIASUBTYPE_RGB565,
0xe436eb7b, 0x524f, 0x11ce, 0x9f, 0x53, 0x00, 0x20, 0xaf, 0x0b, 0xa7, 0x70)

// e436eb7c-524f-11ce-9f53-0020af0ba770            MEDIASUBTYPE_RGB555
OUR_GUID_ENTRY(MEDIASUBTYPE_RGB555,
0xe436eb7c, 0x524f, 0x11ce, 0x9f, 0x53, 0x00, 0x20, 0xaf, 0x0b, 0xa7, 0x70)

// e436eb7d-524f-11ce-9f53-0020af0ba770            MEDIASUBTYPE_RGB24
OUR_GUID_ENTRY(MEDIASUBTYPE_RGB24,
0xe436eb7d, 0x524f, 0x11ce, 0x9f, 0x53, 0x00, 0x20, 0xaf, 0x0b, 0xa7, 0x70)

// e436eb7e-524f-11ce-9f53-0020af0ba770            MEDIASUBTYPE_RGB32
OUR_GUID_ENTRY(MEDIASUBTYPE_RGB32,
0xe436eb7e, 0x524f, 0x11ce, 0x9f, 0x53, 0x00, 0x20, 0xaf, 0x0b, 0xa7, 0x70)

// e436eb7f-524f-11ce-9f53-0020af0ba770            MEDIASUBTYPE_Overlay
OUR_GUID_ENTRY(MEDIASUBTYPE_Overlay,
0xe436eb7f, 0x524f, 0x11ce, 0x9f, 0x53, 0x00, 0x20, 0xaf, 0x0b, 0xa7, 0x70)

// e436eb80-524f-11ce-9f53-0020af0ba770            MEDIASUBTYPE_MPEGPacket
OUR_GUID_ENTRY(MEDIASUBTYPE_MPEG1Packet,
0xe436eb80, 0x524f, 0x11ce, 0x9f, 0x53, 0x00, 0x20, 0xaf, 0x0b, 0xa7, 0x70)

// e436eb81-524f-11ce-9f53-0020af0ba770            MEDIASUBTYPE_MPEG1Payload
OUR_GUID_ENTRY(MEDIASUBTYPE_MPEG1Payload,
0xe436eb81, 0x524f, 0x11ce, 0x9f, 0x53, 0x00, 0x20, 0xaf, 0x0b, 0xa7, 0x70)

// e436eb82-524f-11ce-9f53-0020af0ba770            MEDIASUBTYPE_MPEG1SystemStream
OUR_GUID_ENTRY(MEDIATYPE_MPEG1SystemStream,
0xe436eb82, 0x524f, 0x11ce, 0x9f, 0x53, 0x00, 0x20, 0xaf, 0x0b, 0xa7, 0x70)

// the next consecutive number is assigned to MEDIATYPE_Stream and appears higher up
// e436eb84-524f-11ce-9f53-0020af0ba770            MEDIASUBTYPE_MPEG1System
OUR_GUID_ENTRY(MEDIASUBTYPE_MPEG1System,
0xe436eb84, 0x524f, 0x11ce, 0x9f, 0x53, 0x00, 0x20, 0xaf, 0x0b, 0xa7, 0x70)

// e436eb85-524f-11ce-9f53-0020af0ba770            MEDIASUBTYPE_MPEG1VideoCD
OUR_GUID_ENTRY(MEDIASUBTYPE_MPEG1VideoCD,
0xe436eb85, 0x524f, 0x11ce, 0x9f, 0x53, 0x00, 0x20, 0xaf, 0x0b, 0xa7, 0x70)

// e436eb86-524f-11ce-9f53-0020af0ba770            MEDIASUBTYPE_MPEG1Video
OUR_GUID_ENTRY(MEDIASUBTYPE_MPEG1Video,
0xe436eb86, 0x524f, 0x11ce, 0x9f, 0x53, 0x00, 0x20, 0xaf, 0x0b, 0xa7, 0x70)

// e436eb87-524f-11ce-9f53-0020af0ba770            MEDIASUBTYPE_MPEG1Audio
OUR_GUID_ENTRY(MEDIASUBTYPE_MPEG1Audio,
0xe436eb87, 0x524f, 0x11ce, 0x9f, 0x53, 0x00, 0x20, 0xaf, 0x0b, 0xa7, 0x70)

// e436eb88-524f-11ce-9f53-0020af0ba770            MEDIASUBTYPE_Avi
OUR_GUID_ENTRY(MEDIASUBTYPE_Avi,
0xe436eb88, 0x524f, 0x11ce, 0x9f, 0x53, 0x00, 0x20, 0xaf, 0x0b, 0xa7, 0x70)

// e436eb89-524f-11ce-9f53-0020af0ba770            MEDIASUBTYPE_QTMovie
OUR_GUID_ENTRY(MEDIASUBTYPE_QTMovie,
0xe436eb89, 0x524f, 0x11ce, 0x9f, 0x53, 0x00, 0x20, 0xaf, 0x0b, 0xa7, 0x70)


// e436eb8a-524f-11ce-9f53-0020af0ba770            MEDIASUBTYPE_PCMAudio
OUR_GUID_ENTRY(MEDIASUBTYPE_PCMAudio,
0xe436eb8a, 0x524f, 0x11ce, 0x9f, 0x53, 0x00, 0x20, 0xaf, 0x0b, 0xa7, 0x70)

// e436eb8b-524f-11ce-9f53-0020af0ba770            MEDIASUBTYPE_WAVE
OUR_GUID_ENTRY(MEDIASUBTYPE_WAVE,
0xe436eb8b, 0x524f, 0x11ce, 0x9f, 0x53, 0x00, 0x20, 0xaf, 0x0b, 0xa7, 0x70)

// e436eb8c-524f-11ce-9f53-0020af0ba770            MEDIASUBTYPE_AU
OUR_GUID_ENTRY(MEDIASUBTYPE_AU,
0xe436eb8c, 0x524f, 0x11ce, 0x9f, 0x53, 0x00, 0x20, 0xaf, 0x0b, 0xa7, 0x70)

// e436eb8d-524f-11ce-9f53-0020af0ba770            MEDIASUBTYPE_AIFF
OUR_GUID_ENTRY(MEDIASUBTYPE_AIFF,
0xe436eb8d, 0x524f, 0x11ce, 0x9f, 0x53, 0x00, 0x20, 0xaf, 0x0b, 0xa7, 0x70)

// 64(d)73(s)76(v)64(d)-0000-0010-8000-00AA00389B71  'dvsd' == MEDIASUBTYPE_dvsd
OUR_GUID_ENTRY(MEDIASUBTYPE_dvsd,
0x64737664, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

// 64(d)68(h)76(v)64(d)-0000-0010-8000-00AA00389B71  'dvhd' == MEDIASUBTYPE_dvhd
OUR_GUID_ENTRY(MEDIASUBTYPE_dvhd,
0x64687664, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)

// 6c(l)73(s)76(v)64(d)-0000-0010-8000-00AA00389B71  'dvsl' == MEDIASUBTYPE_dvsl
OUR_GUID_ENTRY(MEDIASUBTYPE_dvsl,
0x6c737664, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71)
									

// --- class IDs ---


// e436ebb0-524f-11ce-9f53-0020af0ba770            Prototype filtergraph
OUR_GUID_ENTRY(CLSID_ProtoFilterGraph,
0xe436ebb0, 0x524f, 0x11ce, 0x9f, 0x53, 0x00, 0x20, 0xaf, 0x0b, 0xa7, 0x70)

// e436ebb1-524f-11ce-9f53-0020af0ba770            Reference clock
OUR_GUID_ENTRY(CLSID_SystemClock,
0xe436ebb1, 0x524f, 0x11ce, 0x9f, 0x53, 0x00, 0x20, 0xaf, 0x0b, 0xa7, 0x70)

// e436ebb2-524f-11ce-9f53-0020af0ba770           Filter Mapper
OUR_GUID_ENTRY(CLSID_FilterMapper,
0xe436ebb2, 0x524f, 0x11ce, 0x9f, 0x53, 0x00, 0x20, 0xaf, 0x0b, 0xa7, 0x70)

// e436ebb3-524f-11ce-9f53-0020af0ba770           Filter Graph
OUR_GUID_ENTRY(CLSID_FilterGraph,
0xe436ebb3, 0x524f, 0x11ce, 0x9f, 0x53, 0x00, 0x20, 0xaf, 0x0b, 0xa7, 0x70)

// e4bbd160-4269-11ce-838d-00aa0055595a           MPEG System stream
OUR_GUID_ENTRY(CLSID_MPEG1Doc,
0xe4bbd160, 0x4269, 0x11ce, 0x83, 0x8d, 0x0, 0xaa, 0x0, 0x55, 0x59, 0x5a)

// 701722e0-8ae3-11ce-a85c-00aa002feab5           MPEG file reader
OUR_GUID_ENTRY(CLSID_FileSource,
0x701722e0, 0x8ae3, 0x11ce, 0xa8, 0x5c, 0x00, 0xaa, 0x00, 0x2f, 0xea, 0xb5)

// 26C25940-4CA9-11ce-A828-00AA002FEAB5           Takes MPEG1 packets as input
OUR_GUID_ENTRY(CLSID_MPEG1PacketPlayer,
0x26c25940, 0x4ca9, 0x11ce, 0xa8, 0x28, 0x0, 0xaa, 0x0, 0x2f, 0xea, 0xb5)

// 336475d0-942a-11ce-a870-00aa002feab5           MPEG splitter
OUR_GUID_ENTRY(CLSID_MPEG1Splitter,
0x336475d0, 0x942a, 0x11ce, 0xa8, 0x70, 0x00, 0xaa, 0x00, 0x2f, 0xea, 0xb5)

// feb50740-7bef-11ce-9bd9-0000e202599c           MPEG video decoder
OUR_GUID_ENTRY(CLSID_CMpegVideoCodec,
0xfeb50740, 0x7bef, 0x11ce, 0x9b, 0xd9, 0x0, 0x0, 0xe2, 0x2, 0x59, 0x9c)

// 4a2286e0-7bef-11ce-9bd9-0000e202599c           MPEG audio decoder
OUR_GUID_ENTRY(CLSID_CMpegAudioCodec,
0x4a2286e0, 0x7bef, 0x11ce, 0x9b, 0xd9, 0x0, 0x0, 0xe2, 0x2, 0x59, 0x9c)

// e30629d3-27e5-11ce-875d-00608cb78066           Text renderer
OUR_GUID_ENTRY(CLSID_TextRender,
0xe30629d3, 0x27e5, 0x11ce, 0x87, 0x5d, 0x0, 0x60, 0x8c, 0xb7, 0x80, 0x66)

// 1b544c20-fd0b-11ce-8c63-00aa0044b51e           Avi Stream Splitter
OUR_GUID_ENTRY(CLSID_AviSplitter,
0x1b544c20, 0xfd0b, 0x11ce, 0x8c, 0x63, 0x0, 0xaa, 0x00, 0x44, 0xb5, 0x1e)

// 1b544c21-fd0b-11ce-8c63-00aa0044b51e           Avi File Reader
OUR_GUID_ENTRY(CLSID_AviReader,
0x1b544c21, 0xfd0b, 0x11ce, 0x8c, 0x63, 0x0, 0xaa, 0x00, 0x44, 0xb5, 0x1e)

// 1b544c22-fd0b-11ce-8c63-00aa0044b51e           Vfw 2.0 Capture Driver
OUR_GUID_ENTRY(CLSID_VfwCapture,
0x1b544c22, 0xfd0b, 0x11ce, 0x8c, 0x63, 0x0, 0xaa, 0x00, 0x44, 0xb5, 0x1e)

OUR_GUID_ENTRY(CLSID_CaptureProperties,
0x1B544c22, 0xFD0B, 0x11ce, 0x8C, 0x63, 0x00, 0xAA, 0x00, 0x44, 0xB5, 0x1F)

//e436ebb4-524f-11ce-9f53-0020af0ba770            Control Distributor
OUR_GUID_ENTRY(CLSID_FGControl,
0xe436ebb4, 0x524f, 0x11ce, 0x9f, 0x53, 0x00, 0x20, 0xaf, 0x0b, 0xa7, 0x70)

// 44584800-F8EE-11ce-B2D4-00DD01101B85           .MOV reader
OUR_GUID_ENTRY(CLSID_MOVReader,
0x44584800, 0xf8ee, 0x11ce, 0xb2, 0xd4, 0x00, 0xdd, 0x1, 0x10, 0x1b, 0x85)

// D3588AB0-0781-11ce-B03A-0020AF0BA770           AVIFile-based reader
OUR_GUID_ENTRY(CLSID_AVIDoc,
0xd3588ab0, 0x0781, 0x11ce, 0xb0, 0x3a, 0x00, 0x20, 0xaf, 0xb, 0xa7, 0x70)

// D3588AB1-0781-11ce-B03A-0020AF0BA770           AVIFile-based writer
OUR_GUID_ENTRY(CLSID_AVIDocWriter,
0xd3588ab1, 0x0781, 0x11ce, 0xb0, 0x3a, 0x00, 0x20, 0xaf, 0xb, 0xa7, 0x70)

// 70e102b0-5556-11ce-97c0-00aa0055595a           Video renderer
OUR_GUID_ENTRY(CLSID_VideoRenderer,
0x70e102b0, 0x5556, 0x11ce, 0x97, 0xc0, 0x00, 0xaa, 0x00, 0x55, 0x59, 0x5a)

// 1643e180-90f5-11ce-97d5-00aa0055595a           Colour space convertor
OUR_GUID_ENTRY(CLSID_Colour,
0x1643e180, 0x90f5, 0x11ce, 0x97, 0xd5, 0x00, 0xaa, 0x00, 0x55, 0x59, 0x5a)

// 1da08500-9edc-11cf-bc10-00aa00ac74f6           VGA 16 color ditherer
OUR_GUID_ENTRY(CLSID_Dither,
0x1da08500, 0x9edc, 0x11cf, 0xbc, 0x10, 0x00, 0xaa, 0x00, 0xac, 0x74, 0xf6)

// 07167665-5011-11cf-BF33-00AA0055595A           Modex video renderer
OUR_GUID_ENTRY(CLSID_ModexRenderer,
0x7167665, 0x5011, 0x11cf, 0xbf, 0x33, 0x0, 0xaa, 0x0, 0x55, 0x59, 0x5a)

// e30629d1-27e5-11ce-875d-00608cb78066           Waveout audio renderer
OUR_GUID_ENTRY(CLSID_AudioRender,
0xe30629d1, 0x27e5, 0x11ce, 0x87, 0x5d, 0x0, 0x60, 0x8c, 0xb7, 0x80, 0x66)

// 05589faf-c356-11ce-bf01-00aa0055595a           Audio Renderer Property Page
OUR_GUID_ENTRY(CLSID_AudioProperties,
0x05589faf, 0xc356, 0x11ce, 0xbf, 0x01, 0x0, 0xaa, 0x0, 0x55, 0x59, 0x5a)

// 79376820-07D0-11cf-A24D-0020AFD79767           DSound audio renderer
OUR_GUID_ENTRY(CLSID_DSoundRender,
0x79376820, 0x07D0, 0x11CF, 0xA2, 0x4D, 0x0, 0x20, 0xAF, 0xD7, 0x97, 0x67)

// e30629d2-27e5-11ce-875d-00608cb78066           Wavein audio recorder
OUR_GUID_ENTRY(CLSID_AudioRecord,
0xe30629d2, 0x27e5, 0x11ce, 0x87, 0x5d, 0x0, 0x60, 0x8c, 0xb7, 0x80, 0x66)

// {CF49D4E0-1115-11ce-B03A-0020AF0BA770}         AVI Decoder
OUR_GUID_ENTRY(CLSID_AVIDec,
0xcf49d4e0, 0x1115, 0x11ce, 0xb0, 0x3a, 0x0, 0x20, 0xaf, 0xb, 0xa7, 0x70)

// 6a08cf80-0e18-11cf-a24d-0020afd79767       ACM Wrapper
OUR_GUID_ENTRY(CLSID_ACMWrapper,
0x6a08cf80, 0x0e18, 0x11cf, 0xa2, 0x4d, 0x0, 0x20, 0xaf, 0xd7, 0x97, 0x67)

// {e436ebb5-524f-11ce-9f53-0020af0ba770}    Async File Reader
OUR_GUID_ENTRY(CLSID_AsyncReader,
0xe436ebb5, 0x524f, 0x11ce, 0x9f, 0x53, 0x00, 0x20, 0xaf, 0x0b, 0xa7, 0x70)

// {e436ebb6-524f-11ce-9f53-0020af0ba770}    Async URL Reader
OUR_GUID_ENTRY(CLSID_URLReader,
0xe436ebb6, 0x524f, 0x11ce, 0x9f, 0x53, 0x00, 0x20, 0xaf, 0x0b, 0xa7, 0x70)

// {e436ebb7-524f-11ce-9f53-0020af0ba770}    IPersistMoniker PID
OUR_GUID_ENTRY(CLSID_PersistMonikerPID,
0xe436ebb7, 0x524f, 0x11ce, 0x9f, 0x53, 0x00, 0x20, 0xaf, 0x0b, 0xa7, 0x70)

// {5f2759c0-7685-11cf-8b23-00805f6cef60}    IAMovie plug-in distributor
OUR_GUID_ENTRY(CLSID_AMovie,
0x5f2759c0, 0x7685, 0x11cf, 0x8b, 0x23, 0x00, 0x80, 0x5f, 0x6c, 0xef, 0x60)

// {D76E2820-1563-11cf-AC98-00AA004C0FA9}
OUR_GUID_ENTRY(CLSID_AVICo,
0xd76e2820, 0x1563, 0x11cf, 0xac, 0x98, 0x0, 0xaa, 0x0, 0x4c, 0xf, 0xa9)

// {8596E5F0-0DA5-11d0-BD21-00A0C911CE86}
OUR_GUID_ENTRY(CLSID_FileWriter,
0x8596e5f0, 0xda5, 0x11d0, 0xbd, 0x21, 0x0, 0xa0, 0xc9, 0x11, 0xce, 0x86)

OUR_GUID_ENTRY(CLSID_AviDest,
0xe2510970, 0xf137, 0x11ce, 0x8b, 0x67, 0x0, 0xaa, 0x0, 0xa3, 0xf1, 0xa6)

// {C647B5C0-157C-11d0-BD23-00A0C911CE86}
OUR_GUID_ENTRY(CLSID_AviMuxProptyPage,
0xc647b5c0, 0x157c, 0x11d0, 0xbd, 0x23, 0x0, 0xa0, 0xc9, 0x11, 0xce, 0x86)

// {07b65360-c445-11ce-afde-00aa006c14f4}
OUR_GUID_ENTRY(CLSID_AVIMIDIRender,
0x07b65360, 0xc445, 0x11ce, 0xaf, 0xde, 0x00, 0xaa, 0x00, 0x6c, 0x14, 0xf4)


// {B1B77C00-C3E4-11cf-AF79-00AA00B67A42}               DV video decoder
OUR_GUID_ENTRY(CLSID_DVVideoCodec,
0xb1b77c00, 0xc3e4, 0x11cf, 0xaf, 0x79, 0x0, 0xaa, 0x0, 0xb6, 0x7a, 0x42)

// {4EB31670-9FC6-11cf-AF6E-00AA00B67A42}               DV splitter
OUR_GUID_ENTRY(CLSID_DVSplitter,
0x4eb31670, 0x9fc6, 0x11cf, 0xaf, 0x6e, 0x0, 0xaa, 0x0, 0xb6, 0x7a, 0x42)


// -- format types ---


// 05589f80-c356-11ce-bf01-00aa0055595a        FORMAT_VideoInfo
OUR_GUID_ENTRY(FORMAT_VideoInfo,
0x05589f80, 0xc356, 0x11ce, 0xbf, 0x01, 0x00, 0xaa, 0x00, 0x55, 0x59, 0x5a)

// 05589f81-c356-11ce-bf01-00aa0055595a        FORMAT_WaveFormatEx
OUR_GUID_ENTRY(FORMAT_WaveFormatEx,
0x05589f81, 0xc356, 0x11ce, 0xbf, 0x01, 0x00, 0xaa, 0x00, 0x55, 0x59, 0x5a)

// 05589f82-c356-11ce-bf01-00aa0055595a        FORMAT_MPEGVideo
OUR_GUID_ENTRY(FORMAT_MPEGVideo,
0x05589f82, 0xc356, 0x11ce, 0xbf, 0x01, 0x00, 0xaa, 0x00, 0x55, 0x59, 0x5a)

// 05589f83-c356-11ce-bf01-00aa0055595a        FORMAT_MPEGStreams
OUR_GUID_ENTRY(FORMAT_MPEGStreams,
0x05589f83, 0xc356, 0x11ce, 0xbf, 0x01, 0x00, 0xaa, 0x00, 0x55, 0x59, 0x5a)

// 05589f84-c356-11ce-bf01-00aa0055595a        FORMAT_DvInfo, DVINFO
OUR_GUID_ENTRY(FORMAT_DvInfo,
0x05589f84, 0xc356, 0x11ce, 0xbf, 0x01, 0x00, 0xaa, 0x00, 0x55, 0x59, 0x5a)


// -- Video related GUIDs ---


// 944d4c00-dd52-11ce-bf0e-00aa0055595a
OUR_GUID_ENTRY(CLSID_DirectDrawProperties,
0x944d4c00, 0xdd52, 0x11ce, 0xbf, 0x0e, 0x00, 0xaa, 0x00, 0x55, 0x59, 0x5a)

// 59ce6880-acf8-11cf-b56e-0080c7c4b68a
OUR_GUID_ENTRY(CLSID_PerformanceProperties,
0x59ce6880, 0xacf8, 0x11cf, 0xb5, 0x6e, 0x00, 0x80, 0xc7, 0xc4, 0xb6, 0x8a)

// 418afb70-f8b8-11ce-aac6-0020af0b99a3
OUR_GUID_ENTRY(CLSID_QualityProperties,
0x418afb70, 0xf8b8, 0x11ce, 0xaa, 0xc6, 0x00, 0x20, 0xaf, 0x0b, 0x99, 0xa3)

// 61ded640-e912-11ce-a099-00aa00479a58
OUR_GUID_ENTRY(IID_IBaseVideoMixer,
0x61ded640, 0xe912, 0x11ce, 0xa0, 0x99, 0x00, 0xaa, 0x00, 0x47, 0x9a, 0x58)

// 36d39eb0-dd75-11ce-bf0e-00aa0055595a
OUR_GUID_ENTRY(IID_IDirectDrawVideo,
0x36d39eb0, 0xdd75, 0x11ce, 0xbf, 0x0e, 0x00, 0xaa, 0x00, 0x55, 0x59, 0x5a)

// bd0ecb0-f8e2-11ce-aac6-0020af0b99a3
OUR_GUID_ENTRY(IID_IQualProp,
0x1bd0ecb0, 0xf8e2, 0x11ce, 0xaa, 0xc6, 0x00, 0x20, 0xaf, 0x0b, 0x99, 0xa3)

// This is a real pain in the neck. The OLE GUIDs are separated out into a
// different file from the main header files. The header files can then be
// included multiple times and are protected with the following statements,
//
//      #ifndef __SOMETHING_DEFINED__
//      #define __SOMETHING_DEFINED__
//          all the header contents
//      #endif // __SOMETHING_DEFINED__
//
// When the actual GUIDs are to be defined (using initguid) the GUID header
// file can then be included to really define them just once. Unfortunately
// DirectDraw has the GUIDs defined in the main header file. So if the base
// classes bring in ddraw.h to get at the DirectDraw structures and so on
// nobody would then be able to really include ddraw.h to allocate the GUID
// memory structures because of the aforementioned header file protection
// Therefore the DirectDraw GUIDs are defined and allocated for real here

OUR_GUID_ENTRY(CLSID_DirectDraw,        0xD7B70EE0,0x4340,0x11CF,0xB0,0x63,0x00,0x20,0xAF,0xC2,0xCD,0x35)
OUR_GUID_ENTRY(CLSID_DirectDrawClipper, 0x593817A0,0x7DB3,0x11CF,0xA2,0xDE,0x00,0xAA,0x00,0xb9,0x33,0x56)
OUR_GUID_ENTRY(IID_IDirectDraw,         0x6C14DB80,0xA733,0x11CE,0xA5,0x21,0x00,0x20,0xAF,0x0B,0xE5,0x60)
OUR_GUID_ENTRY(IID_IDirectDraw2,        0xB3A6F3E0,0x2B43,0x11CF,0xA2,0xDE,0x00,0xAA,0x00,0xB9,0x33,0x56)
OUR_GUID_ENTRY(IID_IDirectDrawSurface,  0x6C14DB81,0xA733,0x11CE,0xA5,0x21,0x00,0x20,0xAF,0x0B,0xE5,0x60)
OUR_GUID_ENTRY(IID_IDirectDrawSurface2, 0x57805885,0x6eec,0x11cf,0x94,0x41,0xa8,0x23,0x03,0xc1,0x0e,0x27)
OUR_GUID_ENTRY(IID_IDirectDrawPalette,  0x6C14DB84,0xA733,0x11CE,0xA5,0x21,0x00,0x20,0xAF,0x0B,0xE5,0x60)
OUR_GUID_ENTRY(IID_IDirectDrawClipper,  0x6C14DB85,0xA733,0x11CE,0xA5,0x21,0x00,0x20,0xAF,0x0B,0xE5,0x60)

// 0618aa30-6bc4-11cf-bf36-00aa0055595a
OUR_GUID_ENTRY(CLSID_ModexProperties,
0x0618aa30, 0x6bc4, 0x11cf, 0xbf, 0x36, 0x00, 0xaa, 0x00, 0x55, 0x59, 0x5a)

// dd1d7110-7836-11cf-bf47-00aa0055595a
OUR_GUID_ENTRY(IID_IFullScreenVideo,
0xdd1d7110, 0x7836, 0x11cf, 0xbf, 0x47, 0x00, 0xaa, 0x00, 0x55, 0x59, 0x5a)

// 53479470-f1dd-11cf-bc42-00aa00ac74f6
OUR_GUID_ENTRY(IID_IFullScreenVideoEx,
0x53479470, 0xf1dd, 0x11cf, 0xbc, 0x42, 0x00, 0xaa, 0x00, 0xac, 0x74, 0xf6)

// {101193C0-0BFE-11d0-AF91-00AA00B67A42}
OUR_GUID_ENTRY(CLSID_DVDecPropertiesPage,
0x101193c0, 0xbfe, 0x11d0, 0xaf, 0x91, 0x0, 0xaa, 0x0, 0xb6, 0x7a, 0x42)



// -- Direct Sound Audio related GUID ---

// 546F4260-D53E-11cf-B3F0-00AA003761C5
OUR_GUID_ENTRY(IID_IAMDirectSound,
0x546f4260, 0xd53e, 0x11cf, 0xb3, 0xf0, 0x0, 0xaa, 0x0, 0x37, 0x61, 0xc5)

// -- MPEG audio decoder properties

// {A8BB1580-B5EE-11ce-8D2B-0000E202599C}
OUR_GUID_ENTRY(IID_IMpegAudioDecoder,
0xa8bb1580, 0xb5ee, 0x11ce, 0x8d, 0x2b, 0x0, 0x0, 0xe2, 0x2, 0x59, 0x9c)


// -- Analog video related GUIDs ---


// -- format types ---
// 0482DDE0-7817-11cf-8A03-00AA006ECB65
OUR_GUID_ENTRY(FORMAT_AnalogVideo,
0x482dde0, 0x7817, 0x11cf, 0x8a, 0x3, 0x0, 0xaa, 0x0, 0x6e, 0xcb, 0x65)


// -- major type, Analog Video

// 0482DDE1-7817-11cf-8A03-00AA006ECB65
OUR_GUID_ENTRY(MEDIATYPE_AnalogVideo,
0x482dde1, 0x7817, 0x11cf, 0x8a, 0x3, 0x0, 0xaa, 0x0, 0x6e, 0xcb, 0x65)


// -- Analog Video subtypes, NTSC

// 0482DDE2-7817-11cf-8A03-00AA006ECB65
OUR_GUID_ENTRY(MEDIASUBTYPE_AnalogVideo_NTSC_M,
0x482dde2, 0x7817, 0x11cf, 0x8a, 0x3, 0x0, 0xaa, 0x0, 0x6e, 0xcb, 0x65)

// -- Analog Video subtypes, PAL

// 0482DDE5-7817-11cf-8A03-00AA006ECB65
OUR_GUID_ENTRY(MEDIASUBTYPE_AnalogVideo_PAL_B,
0x482dde5, 0x7817, 0x11cf, 0x8a, 0x3, 0x0, 0xaa, 0x0, 0x6e, 0xcb, 0x65)

// 0482DDE6-7817-11cf-8A03-00AA006ECB65
OUR_GUID_ENTRY(MEDIASUBTYPE_AnalogVideo_PAL_D,
0x482dde6, 0x7817, 0x11cf, 0x8a, 0x3, 0x0, 0xaa, 0x0, 0x6e, 0xcb, 0x65)

// 0482DDE7-7817-11cf-8A03-00AA006ECB65
OUR_GUID_ENTRY(MEDIASUBTYPE_AnalogVideo_PAL_G,
0x482dde7, 0x7817, 0x11cf, 0x8a, 0x3, 0x0, 0xaa, 0x0, 0x6e, 0xcb, 0x65)

// 0482DDE8-7817-11cf-8A03-00AA006ECB65
OUR_GUID_ENTRY(MEDIASUBTYPE_AnalogVideo_PAL_H,
0x482dde8, 0x7817, 0x11cf, 0x8a, 0x3, 0x0, 0xaa, 0x0, 0x6e, 0xcb, 0x65)

// 0482DDE9-7817-11cf-8A03-00AA006ECB65
OUR_GUID_ENTRY(MEDIASUBTYPE_AnalogVideo_PAL_I,
0x482dde9, 0x7817, 0x11cf, 0x8a, 0x3, 0x0, 0xaa, 0x0, 0x6e, 0xcb, 0x65)

// 0482DDEA-7817-11cf-8A03-00AA006ECB65
OUR_GUID_ENTRY(MEDIASUBTYPE_AnalogVideo_PAL_M,
0x482ddea, 0x7817, 0x11cf, 0x8a, 0x3, 0x0, 0xaa, 0x0, 0x6e, 0xcb, 0x65)

// 0482DDEB-7817-11cf-8A03-00AA006ECB65
OUR_GUID_ENTRY(MEDIASUBTYPE_AnalogVideo_PAL_N,
0x482ddeb, 0x7817, 0x11cf, 0x8a, 0x3, 0x0, 0xaa, 0x0, 0x6e, 0xcb, 0x65)

// -- Analog Video subtypes, SECAM

// 0482DDF0-7817-11cf-8A03-00AA006ECB65
OUR_GUID_ENTRY(MEDIASUBTYPE_AnalogVideo_SECAM_B,
0x482ddf0, 0x7817, 0x11cf, 0x8a, 0x3, 0x0, 0xaa, 0x0, 0x6e, 0xcb, 0x65)

// 0482DDF1-7817-11cf-8A03-00AA006ECB65
OUR_GUID_ENTRY(MEDIASUBTYPE_AnalogVideo_SECAM_D,
0x482ddf1, 0x7817, 0x11cf, 0x8a, 0x3, 0x0, 0xaa, 0x0, 0x6e, 0xcb, 0x65)

// 0482DDF2-7817-11cf-8A03-00AA006ECB65
OUR_GUID_ENTRY(MEDIASUBTYPE_AnalogVideo_SECAM_G,
0x482ddf2, 0x7817, 0x11cf, 0x8a, 0x3, 0x0, 0xaa, 0x0, 0x6e, 0xcb, 0x65)

// 0482DDF3-7817-11cf-8A03-00AA006ECB65
OUR_GUID_ENTRY(MEDIASUBTYPE_AnalogVideo_SECAM_H,
0x482ddf3, 0x7817, 0x11cf, 0x8a, 0x3, 0x0, 0xaa, 0x0, 0x6e, 0xcb, 0x65)

// 0482DDF4-7817-11cf-8A03-00AA006ECB65
OUR_GUID_ENTRY(MEDIASUBTYPE_AnalogVideo_SECAM_K,
0x482ddf4, 0x7817, 0x11cf, 0x8a, 0x3, 0x0, 0xaa, 0x0, 0x6e, 0xcb, 0x65)

// 0482DDF5-7817-11cf-8A03-00AA006ECB65
OUR_GUID_ENTRY(MEDIASUBTYPE_AnalogVideo_SECAM_K1,
0x482ddf5, 0x7817, 0x11cf, 0x8a, 0x3, 0x0, 0xaa, 0x0, 0x6e, 0xcb, 0x65)

// 0482DDF6-7817-11cf-8A03-00AA006ECB65
OUR_GUID_ENTRY(MEDIASUBTYPE_AnalogVideo_SECAM_L,
0x482ddf6, 0x7817, 0x11cf, 0x8a, 0x3, 0x0, 0xaa, 0x0, 0x6e, 0xcb, 0x65)


// -- Well known time format GUIDs ---


// 00000000-0000-0000-0000-000000000000
OUR_GUID_ENTRY(TIME_FORMAT_NONE,
0L, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)

// 7b785570-8c82-11cf-bc0c-00aa00ac74f6
OUR_GUID_ENTRY(TIME_FORMAT_FRAME,
0x7b785570, 0x8c82, 0x11cf, 0xbc, 0xc, 0x0, 0xaa, 0x0, 0xac, 0x74, 0xf6)

// 7b785571-8c82-11cf-bc0c-00aa00ac74f6
OUR_GUID_ENTRY(TIME_FORMAT_BYTE,
0x7b785571, 0x8c82, 0x11cf, 0xbc, 0xc, 0x0, 0xaa, 0x0, 0xac, 0x74, 0xf6)

// 7b785572-8c82-11cf-bc0c-00aa00ac74f6
OUR_GUID_ENTRY(TIME_FORMAT_SAMPLE,
0x7b785572, 0x8c82, 0x11cf, 0xbc, 0xc, 0x0, 0xaa, 0x0, 0xac, 0x74, 0xf6)

// 7b785573-8c82-11cf-bc0c-00aa00ac74f6
OUR_GUID_ENTRY(TIME_FORMAT_FIELD,
0x7b785573, 0x8c82, 0x11cf, 0xbc, 0xc, 0x0, 0xaa, 0x0, 0xac, 0x74, 0xf6)


// 7b785574-8c82-11cf-bc0c-00aa00ac74f6
OUR_GUID_ENTRY(TIME_FORMAT_MEDIA_TIME,
0x7b785574, 0x8c82, 0x11cf, 0xbc, 0xc, 0x0, 0xaa, 0x0, 0xac, 0x74, 0xf6)

#undef OUR_GUID_ENTRY

