//===========================================================================
//
// Copyright (c) Microsoft Corporation 1995-1999
//
//===========================================================================

#ifndef _SHLGUID_H_
#define _SHLGUID_H_
#ifndef _SHLGUIDP_H_                    ;Internal
#define _SHLGUIDP_H_                    ;Internal

;begin_both

#ifndef _WIN32_IE
#define _WIN32_IE 0x0501
#else
#if (_WIN32_IE < 0x0400) && defined(_WIN32_WINNT) && (_WIN32_WINNT >= 0x0500)
#error _WIN32_IE setting conflicts with _WIN32_WINNT setting
#endif
#endif

;end_both

#ifndef DEFINE_SHLGUID                  ;Internal
;begin_both
#define DEFINE_SHLGUID(name, l, w1, w2) DEFINE_GUID(name, l, w1, w2, 0xC0,0,0,0,0,0,0,0x46)
;end_both
#endif                                  ;Internal

DEFINE_SHLGUID(CLSID_ShellDesktop,      0x00021400L, 0, 0);
DEFINE_SHLGUID(CLSID_ShellLink,         0x00021401L, 0, 0);

DEFINE_GUID(CLSID_NetworkPlaces,        0x208D2C60, 0x3AEA, 0x1069, 0xA2,0xD7,0x08,0x00,0x2B,0x30,0x30,0x9D);//208D2C60-3AEA-1069-A2D7-08002B30309D
DEFINE_GUID(CLSID_NetworkDomain,        0x46e06680, 0x4bf0, 0x11d1, 0x83,0xee,0x00,0xa0,0xc9,0x0d,0xc8,0x49);//46e06680-4bf0-11d1-83ee-00a0c90dc849
DEFINE_GUID(CLSID_NetworkServer,        0xc0542a90, 0x4bf0, 0x11d1, 0x83,0xee,0x00,0xa0,0xc9,0x0d,0xc8,0x49);//c0542a90-4bf0-11d1-83ee-00a0c90dc849
DEFINE_GUID(CLSID_NetworkShare,         0x54a754c0, 0x4bf0, 0x11d1, 0x83,0xee,0x00,0xa0,0xc9,0x0d,0xc8,0x49);//54a754c0-4bf1-11d1-83ee-00a0c90dc849
DEFINE_GUID(CLSID_MyComputer,           0x20D04FE0, 0x3AEA, 0x1069, 0xA2,0xD8,0x08,0x00,0x2B,0x30,0x30,0x9D);//20D04FE0-3AEA-1069-A2D8-08002B30309D
DEFINE_GUID(CLSID_Internet,             0x871C5380, 0x42A0, 0x1069, 0xA2,0xEA,0x08,0x00,0x2B,0x30,0x30,0x9D);//871C5380-42A0-1069-A2EA-08002B30309D
DEFINE_GUID(CLSID_ShellFSFolder,        0xF3364BA0, 0x65B9, 0x11CE, 0xA9,0xBA,0x00,0xAA,0x00,0x4A,0xE8,0x37);//F3364BA0-65B9-11CE-A9BA-00AA004AE837
DEFINE_GUID(CLSID_RecycleBin,           0x645FF040, 0x5081, 0x101B, 0x9F,0x08,0x00,0xAA,0x00,0x2F,0x95,0x4E);//645FF040-5081-101B-9F08-00AA002F954E
DEFINE_GUID(CLSID_ControlPanel,         0x21EC2020, 0x3AEA, 0x1069, 0xA2,0xDD,0x08,0x00,0x2B,0x30,0x30,0x9D);//21EC2020-3AEA-1069-A2DD-08002B30309D
DEFINE_GUID(CLSID_Printers,             0x2227A280, 0x3AEA, 0x1069, 0xA2,0xDE,0x08,0x00,0x2B,0x30,0x30,0x9D);
DEFINE_GUID(CLSID_MyDocuments,          0x450d8fba, 0xad25, 0x11d0, 0x98,0xa8,0x08,0x00,0x36,0x1b,0x11,0x03);//450D8FBA-AD25-11D0-98A8-0800361B1103

// string version of above CLSIDs
// useful for doing psfDesktop->ParseDisplayName( L"::" L STR_MYDOCS_CLSID, ...);

#define STR_MYDOCS_CLSID   "{450D8FBA-AD25-11D0-98A8-0800361B1103}"

;begin_both
#if (_WIN32_IE >= 0x0400)
;end_both
DEFINE_SHLGUID(CATID_BrowsableShellExt, 0x00021490L, 0, 0);
DEFINE_SHLGUID(CATID_BrowseInPlace,     0x00021491L, 0, 0);
DEFINE_SHLGUID(CATID_DeskBand,          0x00021492L, 0, 0);
DEFINE_SHLGUID(CATID_InfoBand,          0x00021493L, 0, 0);
DEFINE_SHLGUID(CATID_CommBand,          0x00021494L, 0, 0);
;begin_both
#endif
;end_both

#define PSGUID_INTERNETSHORTCUT {0x000214A0, 0, 0, 0xC0,0,0,0,0,0,0,0x46}
DEFINE_SHLGUID(FMTID_Intshcut,          0x000214A0L, 0, 0);

#define PSGUID_INTERNETSITE {0x000214A1L, 0, 0, 0xC0,0,0,0,0,0,0,0x46}
DEFINE_SHLGUID(FMTID_InternetSite,      0x000214A1L, 0, 0);

DEFINE_SHLGUID(CGID_Explorer,           0x000214D0L, 0, 0);
DEFINE_SHLGUID(CGID_ShellDocView,       0x000214D1L, 0, 0);

#if (_WIN32_IE >= 0x0400)
DEFINE_SHLGUID(CGID_ShellServiceObject, 0x000214D2L, 0, 0);
DEFINE_SHLGUID(CGID_ExplorerBarDoc,     0x000214D3L, 0, 0);
#endif

DEFINE_SHLGUID(IID_INewShortcutHookA,   0x000214E1L, 0, 0);
DEFINE_SHLGUID(IID_IShellBrowser,       0x000214E2L, 0, 0);
DEFINE_SHLGUID(IID_IShellView,          0x000214E3L, 0, 0);
DEFINE_SHLGUID(IID_IContextMenu,        0x000214E4L, 0, 0);
DEFINE_SHLGUID(IID_IShellIcon,          0x000214E5L, 0, 0);
DEFINE_SHLGUID(IID_IShellFolder,        0x000214E6L, 0, 0);
DEFINE_SHLGUID(IID_IShellExtInit,       0x000214E8L, 0, 0);
DEFINE_SHLGUID(IID_IShellPropSheetExt,  0x000214E9L, 0, 0);
DEFINE_SHLGUID(IID_IPersistFolder,      0x000214EAL, 0, 0);
DEFINE_SHLGUID(IID_IExtractIconA,       0x000214EBL, 0, 0);
DEFINE_SHLGUID(IID_IShellDetails,       0x000214ECL, 0, 0);
DEFINE_SHLGUID(IID_IDelayedRelease,     0x000214EDL, 0, 0);
DEFINE_SHLGUID(IID_IShellLinkA,         0x000214EEL, 0, 0);
DEFINE_SHLGUID(IID_IShellCopyHookA,     0x000214EFL, 0, 0);
DEFINE_SHLGUID(IID_IFileViewerA,        0x000214F0L, 0, 0);
DEFINE_SHLGUID(IID_ICommDlgBrowser,     0x000214F1L, 0, 0);
DEFINE_SHLGUID(IID_IEnumIDList,         0x000214F2L, 0, 0);
DEFINE_SHLGUID(IID_IFileViewerSite,     0x000214F3L, 0, 0);
DEFINE_SHLGUID(IID_IContextMenu2,       0x000214F4L, 0, 0);
DEFINE_SHLGUID(IID_IShellExecuteHookA,  0x000214F5L, 0, 0);
DEFINE_SHLGUID(IID_IPropSheetPage,      0x000214F6L, 0, 0);
DEFINE_SHLGUID(IID_INewShortcutHookW,   0x000214F7L, 0, 0);
DEFINE_SHLGUID(IID_IFileViewerW,        0x000214F8L, 0, 0);
DEFINE_SHLGUID(IID_IShellLinkW,         0x000214F9L, 0, 0);
DEFINE_SHLGUID(IID_IExtractIconW,       0x000214FAL, 0, 0);
DEFINE_SHLGUID(IID_IShellExecuteHookW,  0x000214FBL, 0, 0);
DEFINE_SHLGUID(IID_IShellCopyHookW,     0x000214FCL, 0, 0);

DEFINE_SHLGUID(IID_IRemoteComputer,     0x000214FEL, 0, 0);

#define IID_ICopyHookA                  IID_IShellCopyHookA
#define IID_ICopyHookW                  IID_IShellCopyHookW

#define SID_LinkSite    IID_IShellLinkW     // IServiceProvider::QueryService() access the link object that is defering to you 

#if (_WIN32_IE >= 0x0400)
DEFINE_SHLGUID(IID_IQueryInfo,          0x00021500L, 0, 0);
#endif

DEFINE_GUID(IID_IBriefcaseStg,          0x8BCE1FA1L, 0x0921, 0x101B, 0xB1, 0xFF, 0x00, 0xDD, 0x01, 0x0C, 0xCC, 0x48);
DEFINE_GUID(IID_IShellView2,            0x88E39E80L, 0x3578, 0x11CF, 0xAE, 0x69, 0x08, 0x00, 0x2B, 0x2E, 0x12, 0x62);
DEFINE_GUID(IID_IShellLinkDataList,     0x45e2b4ae, 0xb1c3, 0x11d0, 0xb9, 0x2f, 0x0, 0xa0, 0xc9, 0x3, 0x12, 0xe1);
#if (_WIN32_IE >= 0x0500)
DEFINE_GUID(IID_IResolveShellLink,      0x5cd52983, 0x9449, 0x11d2, 0x96, 0x3a, 0x00, 0xc0, 0x4f, 0x79, 0xad, 0xf0);
#endif // _WIN32_IE >= 0x0500

;begin_both
#if (_WIN32_IE >= 0x0400)
;end_both
DEFINE_GUID(IID_IURLSearchHook,         0xAC60F6A0L, 0x0FD9, 0x11D0, 0x99, 0xCB, 0x00, 0xC0, 0x4F, 0xD6, 0x44, 0x97);
DEFINE_GUID(IID_IDelegateFolder,        0xADD8BA80L, 0x002B, 0x11D0, 0x8F, 0x0F, 0x00, 0xC0, 0x4F, 0xD7, 0xD0, 0x62);

#if (_WIN32_IE >= 0x0500)
// CLSID_FolderShortcut {0AFACED1-E828-11D1-9187-B532F1E9575D}
DEFINE_GUID(CLSID_FolderShortcut, 0x0AFACED1,0xE828,0x11D1,0x91,0x87,0xB5,0x32,0xF1,0xE9,0x57,0x5D);
#endif

DEFINE_GUID(IID_IInputObject,           0x68284faa, 0x6a48, 0x11d0, 0x8c, 0x78, 0x0, 0xc0, 0x4f, 0xd9, 0x18, 0xb4);
DEFINE_GUID(IID_IInputObjectSite,       0xf1db8392, 0x7331, 0x11d0, 0x8c, 0x99, 0x0, 0xa0, 0xc9, 0x2d, 0xbf, 0xe8);

DEFINE_GUID(IID_IDockingWindow,         0x12dd920, 0x7b26, 0x11d0, 0x8c, 0xa9, 0x0, 0xa0, 0xc9, 0x2d, 0xbf, 0xe8);
DEFINE_GUID(IID_IDockingWindowSite,     0x2a342fc2, 0x7b26, 0x11d0, 0x8c, 0xa9, 0x0, 0xa0, 0xc9, 0x2d, 0xbf, 0xe8);
DEFINE_GUID(IID_IDockingWindowFrame,    0x47d2657a, 0x7b27, 0x11d0, 0x8c, 0xa9, 0x0, 0xa0, 0xc9, 0x2d, 0xbf, 0xe8);

DEFINE_GUID(IID_IShellIconOverlay,      0x7D688A70L, 0xC613, 0x11D0, 0x99, 0x9B, 0x00, 0xC0, 0x4F, 0xD6, 0x55, 0xE1);
DEFINE_GUID(IID_IShellIconOverlayIdentifier,  0x0C6C4200L, 0xC589, 0x11D0, 0x99, 0x9A, 0x00, 0xC0, 0x4F, 0xD6, 0x55, 0xE1);

;begin_internal
DEFINE_GUID(IID_IShellIconOverlayManager, 0x63B51F80L, 0xC868, 0x11D0, 0x99, 0x9C, 0x00, 0xC0, 0x4F, 0xD6, 0x55, 0xE1);
;end_internal

// {10339516-2894-11d2-9039-00C04F8EEB3E}
DEFINE_GUID(IID_ICommDlgBrowser2,       0x10339516, 0x2894, 0x11d2, 0x90, 0x39, 0x0, 0xc0, 0x4f, 0x8e, 0xeb, 0x3e);

;begin_internal
// {6B707A1C-744F-11d2-86B9-00C04F8EEA99}
DEFINE_GUID(IID_IBrowserBand, 0x6b707a1c, 0x744f, 0x11d2, 0x86, 0xb9, 0x0, 0xc0, 0x4f, 0x8e, 0xea, 0x99);
;end_internal

;begin_internal
// {95CE8410-7027-11D1-B879-006008059382}
DEFINE_GUID(IID_IShellTreeWalker, 0x95CE8410L, 0x7027, 0x11D1, 0xB8, 0x79, 0x00, 0x60, 0x08, 0x05, 0x93, 0x82);
// {95CE8411-7027-11D1-B879-006008059382}
DEFINE_GUID(IID_IShellTreeWalkerCallBack, 0x95CE8411L, 0x7027, 0x11D1, 0xB8, 0x79, 0x00, 0x60, 0x08, 0x05, 0x93, 0x82);
// {be1af9f0-b231-11d2-963e-00c04f79adf0}
DEFINE_GUID(IID_IDropTargetWithDADSupport, 0xb0061660, 0xb231, 0x11d2, 0x96, 0x3e, 0x00, 0xc0, 0x4f, 0x79, 0xad, 0xf0);
;end_internal

// 2047E320-F2A9-11CE-AE65-08002B2E1262
DEFINE_GUID(IID_IShellFolderViewCB, 0x2047E320L, 0xF2A9, 0x11CE, 0xAE, 0x65, 0x08, 0x00, 0x2B, 0x2E, 0x12, 0x62);
#define SID_ShellFolderViewCB IID_IShellFolderViewCB

// {1AC3D9F0-175C-11d1-95BE-00609797EA4F}
DEFINE_GUID(IID_IPersistFolder2,        0x1ac3d9f0, 0x175c, 0x11d1, 0x95, 0xbe, 0x0, 0x60, 0x97, 0x97, 0xea, 0x4f);
// {CEF04FDF-FE72-11d2-87A5-00C04F6837CF}
DEFINE_GUID(IID_IPersistFolder3,        0xcef04fdf, 0xfe72, 0x11d2, 0x87, 0xa5, 0x0, 0xc0, 0x4f, 0x68, 0x37, 0xcf);

// {C7264BF0-EDB6-11d1-8546-006008059368}
DEFINE_GUID(IID_IPersistFreeThreadedObject,  0xc7264bf0, 0xedb6, 0x11d1, 0x85, 0x46, 0x0, 0x60, 0x8, 0x5, 0x93, 0x68);

// {63B51F81-C868-11D0-999C-00C04FD655E1}
DEFINE_GUID(CLSID_CFSIconOverlayManager, 0x63B51F81L, 0xC868, 0x11D0, 0x99, 0x9C, 0x00, 0xC0, 0x4F, 0xD6, 0x55, 0xE1);

;begin_internal
// {27DC26B1-41B3-11D1-B850-006008059382}
DEFINE_GUID(CLSID_CMultiMonConfig,           0x27DC26B1L, 0x41B3, 0x11D1, 0xB8, 0x50, 0x00, 0x60, 0x08, 0x05, 0x93, 0x82);
// {95CE8412-7027-11D1-B879-006008059382}
DEFINE_GUID(CLSID_CShellTreeWalker,          0x95CE8412L, 0x7027, 0x11D1, 0xB8, 0x79, 0x00, 0x60, 0x08, 0x05, 0x93, 0x82);
;end_internal

// {BB2E617C-0920-11d1-9A0B-00C04FC2D6C1}
DEFINE_GUID(IID_IExtractImage,               0xbb2e617c, 0x920, 0x11d1, 0x9a, 0xb, 0x0, 0xc0, 0x4f, 0xc2, 0xd6, 0xc1);

// {85788D00-6807-11d0-B810-00C04FD706EC}
DEFINE_GUID(IID_IRunnableTask,               0x85788d00, 0x6807, 0x11d0, 0xb8, 0x10, 0x0, 0xc0, 0x4f, 0xd7, 0x6, 0xec);


#if (_WIN32_IE >= 0x0500)
// {953BB1EE-93B4-11d1-98A3-00C04FB687DA}
DEFINE_GUID(IID_IExtractImage2,              0x953bb1ee, 0x93b4, 0x11d1, 0x98, 0xa3, 0x0, 0xc0, 0x4f, 0xb6, 0x87, 0xda);
#endif

;begin_internal
#if (_WIN32_IE >= 0x0500)
// {48C8118C-B924-11d1-98D5-00C04FB687DA}
DEFINE_GUID(IID_IShellImageStore,            0x48c8118c, 0xb924, 0x11d1, 0x98, 0xd5, 0x0, 0xc0, 0x4f, 0xb6, 0x87, 0xda);

// {6DFD582B-92E3-11d1-98A3-00C04FB687DA}
DEFINE_GUID(IID_IEnumShellImageStore,        0x6dfd582b, 0x92e3, 0x11d1, 0x98, 0xa3, 0x0, 0xc0, 0x4f, 0xb6, 0x87, 0xda);

// {1EBDCF80-A200-11d0-A3A4-00C04FD706EC}
DEFINE_GUID(CLSID_ShellThumbnailDiskCache,   0x1ebdcf80, 0xa200, 0x11d0, 0xa3, 0xa4, 0x0, 0xc0, 0x4f, 0xd7, 0x6, 0xec);
#endif

// same interface as IID_IExtractImage
// {D4029EC0-0920-11d1-9A0B-00C04FC2D6C1}
DEFINE_GUID(IID_IExtractLogo,                0xd4029ec0, 0x920, 0x11d1, 0x9a, 0xb, 0x0, 0xc0, 0x4f, 0xc2, 0xd6, 0xc1);

// {6CCB7BE0-6807-11d0-B810-00C04FD706EC}
DEFINE_GUID(IID_IShellTaskScheduler,         0x6ccb7be0, 0x6807, 0x11d0, 0xb8, 0x10, 0x0, 0xc0, 0x4f, 0xd7, 0x6, 0xec);

// {603D3800-BD81-11d0-A3A5-00C04FD706EC}
DEFINE_GUID(CLSID_ShellTaskScheduler,        0x603d3800, 0xbd81, 0x11d0, 0xa3, 0xa5, 0x0, 0xc0, 0x4f, 0xd7, 0x6, 0xec);

// {603D3801-BD81-11d0-A3A5-00C04FD706EC}
DEFINE_GUID(CLSID_SharedTaskScheduler,       0x603d3801, 0xbd81, 0x11d0, 0xa3, 0xa5, 0x0, 0xc0, 0x4f, 0xd7, 0x6, 0xec);

// {3F4EEF80-BFE8-11d0-A3A5-00C04FD706EC}
DEFINE_GUID(CLSID_ImageListCache,            0x3f4eef80, 0xbfe8, 0x11d0, 0xa3, 0xa5, 0x0, 0xc0, 0x4f, 0xd7, 0x6, 0xec);

// {4FCE9180-BFE8-11d0-A3A5-00C04FD706EC}
DEFINE_GUID(IID_IImageCache,                 0x4fce9180, 0xbfe8, 0x11d0, 0xa3, 0xa5, 0x0, 0xc0, 0x4f, 0xd7, 0x6, 0xec);

#if (_WIN32_IE >= 0x0500)
// {AC3E9E59-96D7-11d1-98A4-00C04FB687DA}
DEFINE_GUID(IID_IImageCache2,                0xac3e9e59, 0x96d7, 0x11d1, 0x98, 0xa4, 0x0, 0xc0, 0x4f, 0xb6, 0x87, 0xda);

// {7BB0B520-B1A7-11d2-BB23-00C04F79ABCD}
DEFINE_GUID(IID_IThumbnailView,              0x7bb0b520, 0xb1a7, 0x11d2, 0xbb, 0x23, 0x0, 0xc0, 0x4f, 0x79, 0xab, 0xcd);

#endif

DEFINE_GUID(IID_IMultiMonitorDockingSite, 0x03879DE0L, 0xA205, 0x11D0, 0x99, 0xCB, 0x00, 0xC0, 0x4F, 0xD6, 0x55, 0xE1); 
DEFINE_GUID(CGID_AddressEditBox, 0x72730b70, 0xe8f7, 0x11d0, 0xbc, 0x44, 0x0, 0xaa, 0x0, 0x6c, 0xe2, 0xf5);

// {27DC26B0-41B3-11D1-B850-006008059382}
DEFINE_GUID(IID_IMultiMonConfig, 0x27DC26B0L, 0x41B3, 0x11D1, 0xB8, 0x50, 0x00, 0x60, 0x08, 0x05, 0x93, 0x82);

// {45B324CE-B8A1-11d1-98D3-00C04FB687DA}
DEFINE_GUID(IID_IScaleAndSharpenImage2, 0x45b324ce, 0xb8a1, 0x11d1, 0x98, 0xd3, 0x0, 0xc0, 0x4f, 0xb6, 0x87, 0xda);

// {8A4D3EDC-13A4-11d1-9A22-00C04FC2D6C1}
DEFINE_GUID(CLSID_ThumbnailScaler, 0x8a4d3edc, 0x13a4, 0x11d1, 0x9a, 0x22, 0x0, 0xc0, 0x4f, 0xc2, 0xd6, 0xc1);

// {04B3813B-0A23-11d2-B5AC-006097DF5BD4} - For JITting in FTP Shell Extension.
DEFINE_GUID(CLSID_FTPShellExtension, 0x4b3813b, 0xa23, 0x11d2, 0xb5, 0xac, 0x0, 0x60, 0x97, 0xdf, 0x5b, 0xd4);

// {????} - For JITting in HTML Help Feature
DEFINE_GUID(CLSID_IEHelp, 0x45ea75a0L, 0xa269, 0x11d1, 0xb5, 0xbf, 0x00, 0x00, 0xf8, 0x05, 0x15, 0x15);

;end_internal

// {BCFCE0A0-EC17-11d0-8D10-00A0C90F2719}
DEFINE_GUID(IID_IContextMenu3,          0xbcfce0a0, 0xec17, 0x11d0, 0x8d, 0x10, 0x0, 0xa0, 0xc9, 0xf, 0x27, 0x19);


/// DeskBar stuff
DEFINE_GUID(IID_IDeskBand,              0xEB0FE172L, 0x1A3A, 0x11D0, 0x89, 0xB3, 0x00, 0xA0, 0xC9, 0x0A, 0x90, 0xAC);
#define CGID_DeskBand IID_IDeskBand
#ifdef ISHELLTOOLBAND_COMPAT
DEFINE_GUID(IID_IShellToolband,         0xEB0FE171L, 0x1A3A, 0x11D0, 0x89, 0xB3, 0x00, 0xA0, 0xC9, 0x0A, 0x90, 0xAC);  
#define CGID_ShellToolband IID_IDeskBand  // ;Internal
#endif
;begin_both
#endif // _WIN32_IE >= 0x0400
;end_both

;begin_internal
#if (_WIN32_IE >= 0x0400)
DEFINE_GUID(IID_IShellDetails2,         0xb1223e01, 0xb1db, 0x11d0, 0x82, 0xcc, 0x0, 0xc0, 0x4f, 0xd5, 0xae, 0x38);
DEFINE_GUID(IID_IDeskBar,               0xEB0FE173L, 0x1A3A, 0x11D0, 0x89, 0xB3, 0x00, 0xA0, 0xC9, 0x0A, 0x90, 0xAC);
DEFINE_GUID(IID_IDeskBarClient,         0xEB0FE175L, 0x1A3A, 0x11D0, 0x89, 0xB3, 0x00, 0xA0, 0xC9, 0x0A, 0x90, 0xAC);
DEFINE_GUID(IID_IBandSite,              0x4CF504B0L, 0xDE96, 0x11D0, 0x8B, 0x3F, 0x00, 0xA0, 0xC9, 0x11, 0xE8, 0xE5);
DEFINE_GUID(IID_IWinEventHandler,       0xEA5F2D61L, 0xE008, 0x11CF, 0x99, 0xCB, 0x00, 0xC0, 0x4F, 0xD6, 0x44, 0x97);
#define SID_SBandSite IID_IBandSite

#define CGID_BandSite  IID_IBandSite
#define CGID_DeskBar  IID_IDeskBar
#define CGID_DeskBarClient IID_IDeskBarClient

// These can probably move back to shell\inc\shellp.h...
DEFINE_GUID(SID_DefView,                0x6D12FE80, 0x7911, 0x11CF, 0x95, 0x34, 0x00, 0x00, 0xC0, 0x5B, 0xAE, 0x0B);
DEFINE_GUID(CGID_DefView,               0x4af07f10, 0xd231, 0x11d0, 0xb9, 0x42, 0x0, 0xa0, 0xc9, 0x3, 0x12, 0xe1);

DEFINE_GUID(CLSID_MenuBand,             0x5b4dae26, 0xb807, 0x11d0, 0x98, 0x15, 0x0, 0xc0, 0x4f, 0xd9, 0x19, 0x72);
#define CLSID_ShellMenu CLSID_MenuBand

// {568804CD-CBD7-11d0-9816-00C04FD91972}
DEFINE_GUID(IID_IMenuBand,                  0x568804cd, 0xcbd7, 0x11d0, 0x98, 0x16, 0x0, 0xc0, 0x4f, 0xd9, 0x19, 0x72);

// {EE1F7637-E138-11d1-8379-00C04FD918D0}
DEFINE_GUID(IID_IShellMenu,                 0xee1f7637, 0xe138, 0x11d1, 0x83, 0x79, 0x0, 0xc0, 0x4f, 0xd9, 0x18, 0xd0);

// {4CA300A1-9B8D-11d1-8B22-00C04FD918D0}
DEFINE_GUID(IID_IShellMenuCallback,         0x4ca300a1, 0x9b8d, 0x11d1, 0x8b, 0x22, 0x0, 0xc0, 0x4f, 0xd9, 0x18, 0xd0);

// {8278F931-2A3E-11d2-838F-00C04FD918D0}
DEFINE_GUID(CLSID_TrackShellMenu, 
0x8278f931, 0x2a3e, 0x11d2, 0x83, 0x8f, 0x0, 0xc0, 0x4f, 0xd9, 0x18, 0xd0);

// {8278F932-2A3E-11d2-838F-00C04FD918D0}
DEFINE_GUID(IID_ITrackShellMenu, 
0x8278f932, 0x2a3e, 0x11d2, 0x83, 0x8f, 0x0, 0xc0, 0x4f, 0xd9, 0x18, 0xd0);

// {0D14E31C-D8C0-11d0-9816-00C04FD91972}
DEFINE_GUID(SID_SMenuBandHandler,           0xd14e31c, 0xd8c0, 0x11d0, 0x98, 0x16, 0x0, 0xc0, 0x4f, 0xd9, 0x19, 0x72);

DEFINE_GUID(IID_IAddressBand,           0x106E86E1, 0x52B5, 0x11D0, 0xBF, 0xED, 0x0, 0xAA, 0x0, 0x5B, 0x43, 0x83);

/// AddressEditBox stuff
// {A08C11D1-A228-11d0-825B-00AA005B4383}
DEFINE_GUID(IID_IAddressEditBox, 0xa08c11d1, 0xa228, 0x11d0, 0x82, 0x5b, 0x0, 0xaa, 0x0, 0x5b, 0x43, 0x83);
DEFINE_GUID(CLSID_AddressEditBox,0xa08c11d2, 0xa228, 0x11d0, 0x82, 0x5b, 0x0, 0xaa, 0x0, 0x5b, 0x43, 0x83);


// {D12F26B1-D90A-11d0-830D-00AA005B4383}
DEFINE_GUID(IID_IRestrict, 0xd12f26b1, 0xd90a, 0x11d0, 0x83, 0xd, 0x0, 0xaa, 0x0, 0x5b, 0x43, 0x83);

// {D12F26B2-D90A-11d0-830D-00AA005B4383}
DEFINE_GUID(SID_SRestrictionHandler, 0xd12f26b2, 0xd90a, 0x11d0, 0x83, 0xd, 0x0, 0xaa, 0x0, 0x5b, 0x43, 0x83);

// {D12F26B3-D90A-11d0-830D-00AA005B4383}
DEFINE_GUID(RID_RDeskBars, 0xd12f26b3, 0xd90a, 0x11d0, 0x83, 0xd, 0x0, 0xaa, 0x0, 0x5b, 0x43, 0x83);

// IShellFolderBand stuff
// {7FE80CC8-C247-11d0-B93A-00A0C90312E1}
DEFINE_GUID(IID_IShellFolderBand, 0x7fe80cc8, 0xc247, 0x11d0, 0xb9, 0x3a, 0x0, 0xa0, 0xc9, 0x3, 0x12, 0xe1);
#define CGID_ShellFolderBand    IID_IShellFolderBand

// favorites band
// {EFA24E61-B078-11d0-89E4-00C04FC9E26E}
DEFINE_GUID(CLSID_FavBand,              0xefa24e61, 0xb078, 0x11d0, 0x89, 0xe4, 0x0, 0xc0, 0x4f, 0xc9, 0xe2, 0x6e);

// history band
// {EFA24E62-B078-11d0-89E4-00C04FC9E26E}
DEFINE_GUID(CLSID_HistBand,              0xefa24e62, 0xb078, 0x11d0, 0x89, 0xe4, 0x0, 0xc0, 0x4f, 0xc9, 0xe2, 0x6e);

// channels band
// {EFA24E63-B078-11d0-89E4-00C04FC9E26E}
DEFINE_GUID(CLSID_ChannelBand,          0xefa24e63, 0xb078, 0x11d0, 0x89, 0xe4, 0x0, 0xc0, 0x4f, 0xc9, 0xe2, 0x6e);

// IQueryCodePage {C7B236CE-EE80-11D0-985F-006008059382}
DEFINE_GUID(IID_IQueryCodePage, 0xC7B236CEL, 0xEE80, 0x11D0, 0x98, 0x5F, 0x00, 0x60, 0x08, 0x05, 0x93, 0x82);

#if (_WIN32_IE >= 0x0500)
// 37A378C0-F82D-11CE-AE65-08002B2E1262
DEFINE_GUID(IID_IShellFolderView, 0x37A378C0L, 0xF82D, 0x11CE, 0xAE, 0x65, 0x08, 0x00, 0x2B, 0x2E, 0x12, 0x62);
// 3D8ECEA0-0242-11CF-AE65-08002B2E1262
DEFINE_GUID(IID_IEnumSFVViews, 0x3D8ECEA0L, 0x0242, 0x11CF, 0xAE, 0x65, 0x08, 0x00, 0x2B, 0x2E, 0x12, 0x62);
// D5E37E20-0257-11CF-AE65-08002B2E1262
DEFINE_GUID(IID_IPersistString, 0xD5E37E20L, 0x0257, 0x11CF, 0xAE, 0x65, 0x08, 0x00, 0x2B, 0x2E, 0x12, 0x62);
// {8210BAC0-C6D2-11cf-89AA-00A0C9054129}
DEFINE_GUID(IID_IDefViewExtInit, 0x8210bac0, 0xc6d2, 0x11cf, 0x89, 0xaa, 0x0, 0xa0, 0xc9, 0x5, 0x41, 0x29);
// {2CEB7CB2-E64C-11d2-9652-00C04FC30871}
DEFINE_GUID(IID_IDefViewExtInit2, 0x2ceb7cb2, 0xe64c, 0x11d2, 0x96, 0x52, 0x0, 0xc0, 0x4f, 0xc3, 0x8, 0x71);


// 710EB7A0-45ED-11D0-924A-0020AFC7AC4D
DEFINE_GUID(IID_IDefViewFrame, 0x710EB7A0L, 0x45ED, 0x11D0, 0x92, 0x4A, 0x00, 0x20, 0xAF, 0xC7, 0xAC, 0x4D);


// 710EB7A1-45ED-11D0-924A-0020AFC7AC4D
DEFINE_GUID(IID_IDefViewFrame2, 0x710EB7A1L, 0x45ED, 0x11D0, 0x92, 0x4A, 0x00, 0x20, 0xAF, 0xC7, 0xAC, 0x4D);

#endif // _WIN32_IE >= 0x0500

DEFINE_GUID(IID_IExplorerToolbar,       0x8455F0C1L, 0x158F, 0x11D0, 0x89, 0xAE, 0x00, 0xA0, 0xC9, 0x0A, 0x90, 0xAC);
#define SID_SExplorerToolbar IID_IExplorerToolbar

//
//  When the browser is navigating to a document, we call IBC::SetObjectParam
// with "{d4db6850-5385-11d0-89e9-00a0c90a90ac}" so that the DocObject can get
// to the client site while processing IPersistMoniker::Load.
//
#define WSZGUID_OPID_DocObjClientSite L"{d4db6850-5385-11d0-89e9-00a0c90a90ac}"
DEFINE_GUID(OPID_DobObjClientSite,0xd4db6850L, 0x5385, 0x11d0, 0x89, 0xe9, 0x00, 0xa0, 0xc9, 0x0a, 0x90, 0xac);
#endif // _WIN32_IE >= 0x0400

// 0057D0E0-3573-11CF-AE69-08002B2E1262
DEFINE_GUID(VID_LargeIcons, 0x0057D0E0L, 0x3573, 0x11CF, 0xAE, 0x69, 0x08, 0x00, 0x2B, 0x2E, 0x12, 0x62);
// 089000C0-3573-11CF-AE69-08002B2E1262
DEFINE_GUID(VID_SmallIcons, 0x089000C0L, 0x3573, 0x11CF, 0xAE, 0x69, 0x08, 0x00, 0x2B, 0x2E, 0x12, 0x62);
// 0E1FA5E0-3573-11CF-AE69-08002B2E1262
DEFINE_GUID(VID_List      , 0x0E1FA5E0L, 0x3573, 0x11CF, 0xAE, 0x69, 0x08, 0x00, 0x2B, 0x2E, 0x12, 0x62);
// 137E7700-3573-11CF-AE69-08002B2E1262
DEFINE_GUID(VID_Details   , 0x137E7700L, 0x3573, 0x11CF, 0xAE, 0x69, 0x08, 0x00, 0x2B, 0x2E, 0x12, 0x62);
// 5984FFE0-28D4-11CF-AE66-08002B2E1262
#if (_WIN32_IE >= 0x0400)
DEFINE_GUID(VID_WebView, 0x5984FFE0L, 0x28D4, 0x11CF, 0xAE, 0x66, 0x08, 0x00, 0x2B, 0x2E, 0x12, 0x62);
// {BE098140-A513-11d0-A3A4-00C04FD706EC}
DEFINE_GUID(VID_FolderState, 0xbe098140, 0xa513, 0x11d0, 0xa3, 0xa4, 0x0, 0xc0, 0x4f, 0xd7, 0x6, 0xec);
#endif // _WIN32_IE >= 0x0400
;end_internal

#define SID_SShellBrowser IID_IShellBrowser
#if (_WIN32_IE >= 0x0400)
#define SID_SShellDesktop CLSID_ShellDesktop
#endif

#if (_WIN32_IE >= 0x0400)
//
//  IShellDiscardable is an IID-only interface. If the object supports this
// interface it can be discarded anytime. IWebBrowser::PutProperty QI's for
// this interface to detect discardable properties. 
//
DEFINE_GUID(IID_IDiscardableBrowserProperty, 0x49c3de7c, 0xd329, 0x11d0, 0xab, 0x73, 0x00, 0xc0, 0x4f, 0xc3, 0x3e, 0x80);

// IShellChangeNotify is a sink of LPCITEMIDLIST notification events
//
// D82BE2B1-5764-11D0-A96E-00C04FD705A2
DEFINE_GUID(IID_IShellChangeNotify, 0xD82BE2B1L, 0x5764, 0x11D0, 0xA9, 0x6E, 0x00, 0xC0, 0x4F, 0xD7, 0x05, 0xA2);

#endif // _WIN32_IE >= 0x0400

#ifdef UNICODE
#define IID_IFileViewer         IID_IFileViewerW
#define IID_IShellLink          IID_IShellLinkW
#define IID_IExtractIcon        IID_IExtractIconW
#define IID_IShellCopyHook      IID_IShellCopyHookW
#define IID_IShellExecuteHook   IID_IShellExecuteHookW
#define IID_INewShortcutHook    IID_INewShortcutHookW
#else
#define IID_IFileViewer         IID_IFileViewerA
#define IID_IShellLink          IID_IShellLinkA
#define IID_IExtractIcon        IID_IExtractIconA
#define IID_IShellCopyHook      IID_IShellCopyHookA
#define IID_IShellExecuteHook   IID_IShellExecuteHookA
#define IID_INewShortcutHook    IID_INewShortcutHookA
#endif


#ifndef NO_INTSHCUT_GUIDS
#include <isguids.h>            // internet shortcut GUIDs
#endif

#ifndef NO_SHDOCVW_GUIDS

#ifndef GUID_DEFS_ONLY
#include <exdisp.h>
#include <shldisp.h>
#endif

;begin_internal
// To keep people from breaking, let the old misnamed dudes work
#define IID_IShellExplorer        IID_IWebBrowser
#define DIID_DShellExplorerEvents DIID_DWebBrowserEvents
#define CLSID_ShellExplorer       CLSID_WebBrowser
#define IID_DIExplorer            IID_IWebBrowserApp
#define DIID_DExplorerEvents      DIID_DInternetExplorer
;end_internal

;begin_both
#if (_WIN32_IE >= 0x0400)
;end_both
// UrlHistory Guids
DEFINE_GUID(CLSID_CUrlHistory,          0x3C374A40L, 0xBAE4, 0x11CF, 0xBF, 0x7D, 0x00, 0xAA, 0x00, 0x69, 0x46, 0xEE);
#define SID_SUrlHistory         CLSID_CUrlHistory

//UrlSearchHook Guids
DEFINE_GUID(CLSID_CURLSearchHook,       0xCFBFAE00L, 0x17A6, 0x11D0, 0x99, 0xCB, 0x00, 0xC0, 0x4F, 0xD6, 0x44, 0x97);

;begin_internal
#define DIID_DInternetExplorerEvents DIID_DWebBrowserEvents
#define DInternetExplorerEvents DWebBrowserEvents
#define IID_IInternetExplorer IID_IWebBrowserApp

;end_internal

#define SID_SInternetExplorer IID_IWebBrowserApp
#define SID_SWebBrowserApp    IID_IWebBrowserApp

// AutoComplete Guids
DEFINE_GUID(IID_IAutoCompList,          0x00BB2760L, 0x6A77, 0x11D0, 0xA5, 0x35, 0x00, 0xC0, 0x4F, 0xD7, 0xD0, 0x62);
DEFINE_GUID(IID_IObjMgr,                0x00BB2761L, 0x6A77, 0x11D0, 0xA5, 0x35, 0x00, 0xC0, 0x4F, 0xD7, 0xD0, 0x62);
DEFINE_GUID(IID_IACList,                0x77A130B0L, 0x94FD, 0x11D0, 0xA5, 0x44, 0x00, 0xC0, 0x4F, 0xD7, 0xd0, 0x62);
DEFINE_GUID(IID_IACList2,               0x470141a0L, 0x5186, 0x11d2, 0xbb, 0xb6, 0x00, 0x60, 0x97, 0x7b, 0x46, 0x4c);
DEFINE_GUID(IID_ICurrentWorkingDirectory, 0x91956d21L, 0x9276, 0x11d1, 0x92, 0x1a, 0x00, 0x60, 0x97, 0xdf, 0x5b, 0xd4);     // {91956D21-9276-11d1-921A-006097DF5BD4}
DEFINE_GUID(CLSID_AutoComplete,         0x00BB2763L, 0x6A77, 0x11D0, 0xA5, 0x35, 0x00, 0xC0, 0x4F, 0xD7, 0xD0, 0x62);
DEFINE_GUID(CLSID_ACLHistory,           0x00BB2764L, 0x6A77, 0x11D0, 0xA5, 0x35, 0x00, 0xC0, 0x4F, 0xD7, 0xD0, 0x62);
DEFINE_GUID(CLSID_ACListISF,            0x03C036F1L, 0xA186, 0x11D0, 0x82, 0x4A, 0x00, 0xAA, 0x00, 0x5B, 0x43, 0x83);
DEFINE_GUID(CLSID_ACLMRU,               0x6756a641L, 0xde71, 0x11d0, 0x83, 0x1b, 0x0, 0xaa, 0x0, 0x5b, 0x43, 0x83);          // {6756A641-DE71-11d0-831B-00AA005B4383}
DEFINE_GUID(CLSID_ACLMulti,             0x00BB2765L, 0x6A77, 0x11D0, 0xA5, 0x35, 0x00, 0xC0, 0x4F, 0xD7, 0xD0, 0x62);

;begin_internal
// Thumbnail Guids
DEFINE_GUID(IID_IThumbnail,             0x6d45a930L, 0xf71a, 0x11d0, 0x9e, 0xa7, 0x00, 0x80, 0x5f, 0x71, 0x47, 0x72);
DEFINE_GUID(CLSID_Thumbnail,            0x7487cd30L, 0xf71a, 0x11d0, 0x9e, 0xa7, 0x00, 0x80, 0x5f, 0x71, 0x47, 0x72);
;end_internal


#if (_WIN32_IE >= 0x0500)
/// IProgressDialog
// {F8383852-FCD3-11d1-A6B9-006097DF5BD4}
DEFINE_GUID(CLSID_ProgressDialog,       0xf8383852, 0xfcd3, 0x11d1, 0xa6, 0xb9, 0x0, 0x60, 0x97, 0xdf, 0x5b, 0xd4);
// {EBBC7C04-315E-11d2-B62F-006097DF5BD4}
DEFINE_GUID(IID_IProgressDialog,        0xebbc7c04, 0x315e, 0x11d2, 0xb6, 0x2f, 0x0, 0x60, 0x97, 0xdf, 0x5b, 0xd4);
#endif // _WIN32_IE >= 0x0500

//
// Top-most browser implementation in the heirarchy. use IServiceProvider::QueryService()
// to get to interfaces (IID_IShellBrowser, IID_IBrowserService, etc.)
//
DEFINE_GUID(SID_STopLevelBrowser,       0x4C96BE40L, 0x915C, 0x11CF, 0x99, 0xD3, 0x00, 0xAA, 0x00, 0x4A, 0xE8, 0x37);

;begin_both
#endif // _WIN32_IE >= 0x0400
;end_both

#endif // !NO_SHDOCVW_GUIDS

;begin_internal

#if (_WIN32_IE >= 0x0400)

// 266F5E60-80E6-11CF-A12B-00AA004AE837
DEFINE_GUID(CLSID_CShellTargetFrame, 0x266F5E60L, 0x80E6, 0x11CF, 0xA1, 0x2B, 0x00, 0xAA, 0x00, 0x4A, 0xE8, 0x37);

//B091E540-83E3-11CF-A713-0020AFD79762
DEFINE_GUID(CLSID_FileTypes, 0xB091E540, 0x83E3, 0x11CF, 0xA7,0x13,0x00,0x20,0xAF,0xD7,0x97,0x62);

// CShellList implementation
//
// {FC2A24F0-5876-11d0-97D8-00C04FD91972}
DEFINE_GUID(CLSID_CShellList, 0xfc2a24f0, 0x5876, 0x11d0, 0x97, 0xd8, 0x0, 0xc0, 0x4f, 0xd9, 0x19, 0x72);

// {FE5C88F4-587F-11d0-97D8-00C04FD91972}
DEFINE_GUID(IID_IShellList, 0xfe5c88f4, 0x587f, 0x11d0, 0x97, 0xd8, 0x0, 0xc0, 0x4f, 0xd9, 0x19, 0x72);

// {FE5C88F5-587F-11d0-97D8-00C04FD91972}
DEFINE_GUID(IID_IShellListSink, 0xfe5c88f5, 0x587f, 0x11d0, 0x97, 0xd8, 0x0, 0xc0, 0x4f, 0xd9, 0x19, 0x72);

// {A2B0DD40-CC59-11d0-A3A5-00C04FD706EC}
DEFINE_GUID( CLSID_IESplashScreen, 0xa2b0dd40, 0xcc59, 0x11d0, 0xa3, 0xa5, 0x0, 0xc0, 0x4f, 0xd7, 0x6, 0xec);

// {CB81A3CB-1039-11d1-AB74-00C04FC30936}
DEFINE_GUID( IID_ISplashScreen, 0xcb81a3cb, 0x1039, 0x11d1, 0xab, 0x74, 0x0, 0xc0, 0x4f, 0xc3, 0x9, 0x36);


#endif

#if (_WIN32_IE >= 0x0300)
// {05f6fe1a-ecef-11d0-aae7-00c04fc9b304}
DEFINE_GUID( CLSID_IntDitherer, 0x05f6fe1a, 0xecef, 0x11d0, 0xaa, 0xe7, 0x0, 0xc0, 0x4f, 0xc9, 0xb3, 0x04 );

// {06670ca0-ecef-11d0-aae7-00c04fc9b304}
DEFINE_GUID( IID_IIntDitherer, 0x06670ca0, 0xecef, 0x11d0, 0xaa, 0xe7, 0x0, 0xc0, 0x4f, 0xc9, 0xb3, 0x04 );

#endif // _WIN32_IE >= 0x0300

;end_internal

;begin_both
#if (_WIN32_IE >= 0x0400)
;end_both

// {75048700-EF1F-11D0-9888-006097DEACF9}
DEFINE_GUID( CLSID_ActiveDesktop, 0x75048700L, 0xEF1F, 0x11D0, 0x98, 0x88, 0x00, 0x60, 0x97, 0xDE, 0xAC, 0xF9);

// {F490EB00-1240-11D1-9888-006097DEACF9}
DEFINE_GUID(IID_IActiveDesktop, 0xF490EB00L, 0x1240, 0x11D1, 0x98, 0x88, 0x00, 0x60, 0x97, 0xDE, 0xAC, 0xF9);

;begin_internal
// {52502EE0-EC80-11D0-89AB-00C04FC2972D}
DEFINE_GUID(IID_IActiveDesktopP, 0x52502EE0L, 0xEC80, 0x11D0, 0x89, 0xAB, 0x00, 0xC0, 0x4F, 0xC2, 0x97, 0x2D);

// {B22754E2-4574-11d1-9888-006097DEACF9}
DEFINE_GUID(IID_IADesktopP2, 0xb22754e2, 0x4574, 0x11d1, 0x98, 0x88, 0x0, 0x60, 0x97, 0xde, 0xac, 0xf9);
;end_internal

;begin_internal
// {f39a0dc0-9cc8-11d0-a599-00c04fd64433}
DEFINE_GUID(CLSID_CDFView, 0xf39a0dc0L, 0x9cc8, 0x11d0, 0xa5, 0x99, 0x00, 0xc0, 0x4f, 0xd6, 0x44, 0x33);
;end_internal

// {56FDF344-FD6D-11d0-958A-006097C9A090}
DEFINE_GUID(CLSID_TaskbarList, 0x56fdf344, 0xfd6d, 0x11d0, 0x95, 0x8a, 0x0, 0x60, 0x97, 0xc9, 0xa0, 0x90);

// {56FDF342-FD6D-11d0-958A-006097C9A090}
DEFINE_GUID(IID_ITaskbarList, 0x56fdf342, 0xfd6d, 0x11d0, 0x95, 0x8a, 0x0, 0x60, 0x97, 0xc9, 0xa0, 0x90);

// a5df1ea0-5702-11d1-83fa-00a0c90dc849
DEFINE_GUID(IID_IDocFindFolder, 0xa5df1ea0, 0x5702, 0x11d1, 0x83, 0xfa, 0x00, 0xa0, 0xc9, 0x0d, 0xc8, 0x49);

// {74C26041-70D1-11d1-B75A-00A0C90564FE}
DEFINE_GUID(IID_ISynchronizedCallBack, 0x74c26041, 0x70d1, 0x11d1, 0xb7, 0x5a, 0x0, 0xa0, 0xc9, 0x5, 0x64, 0xfe);

// Extended column handler interfaces
// {D2A105C0-87D5-11d1-8391-0000F80461CF}
DEFINE_GUID(IID_IShellDetails3,        0xd2a105c0, 0x87d5, 0x11d1, 0x83, 0x91, 0x0, 0x0, 0xf8, 0x4, 0x61, 0xcf);

//  {c46ca590-3c3f-11d2-bee6-0000f805ca57}
DEFINE_GUID(IID_IQueryAssociations,          0xc46ca590, 0x3c3f, 0x11d2, 0xbe, 0xe6, 0x00, 0x00, 0xf8, 0x05, 0xca, 0x57);

// {E8025004-1C42-11d2-BE2C-00A0C9A83DA1}
DEFINE_GUID(IID_IColumnProvider,        0xe8025004, 0x1c42, 0x11d2, 0xbe, 0x2c, 0x0, 0xa0, 0xc9, 0xa8, 0x3d, 0xa1);

// {24F14F01-7B1C-11d1-838f-0000F80461CF}
DEFINE_GUID(CLSID_DocFileColumnProvider, 0x24f14f01, 0x7b1c, 0x11d1, 0x83, 0x8f, 0x0, 0x0, 0xf8, 0x4, 0x61, 0xcf);

// {24F14F02-7B1C-11d1-838f-0000F80461CF}
DEFINE_GUID(CLSID_LinkColumnProvider,    0x24f14f02, 0x7b1c, 0x11d1, 0x83, 0x8f, 0x0, 0x0, 0xf8, 0x4, 0x61, 0xcf);

// {0D2E74C4-3C34-11d2-A27E-00C04FC30871}
DEFINE_GUID(CLSID_FileSysColumnProvider, 0xd2e74c4, 0x3c34, 0x11d2, 0xa2, 0x7e, 0x0, 0xc0, 0x4f, 0xc3, 0x8, 0x71);

// For Internet Shortcut Creation Command
// The shell uses this command to allow trident to save off it's per frame data in the shortcut
// and to allow it to fire the OnPersist() event on every frame
// {93A68750-951A-11d1-946F-000000000000}
DEFINE_GUID(CGID_ShortCut, 0x93a68750, 0x951a, 0x11d1, 0x94, 0x6f, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0);


// {FB700430-952C-11d1-946F-000000000000}
DEFINE_GUID(IID_INamedPropertyBag, 0xfb700430, 0x952c, 0x11d1, 0x94, 0x6f, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0);

// {1E796980-9CC5-11D1-A83F-00C04FC99D61}
DEFINE_GUID(CLSID_InternetButtons, 0x1E796980L, 0x9CC5, 0x11D1, 0xA8, 0x3F, 0x00, 0xC0, 0x4F, 0xC9, 0x9D, 0x61);

#if (_WIN32_IE >= 0x0500)
// {178F34B8-A282-11d2-86C5-00C04F8EEA99}
DEFINE_GUID(CLSID_MSOButtons, 0x178f34b8, 0xa282, 0x11d2, 0x86, 0xc5, 0x0, 0xc0, 0x4f, 0x8e, 0xea, 0x99);

// {2CE4B5D8-A28F-11d2-86C5-00C04F8EEA99}
DEFINE_GUID(CLSID_ToolbarExtButtons, 0x2ce4b5d8, 0xa28f, 0x11d2, 0x86, 0xc5, 0x0, 0xc0, 0x4f, 0x8e, 0xea, 0x99);
#endif // _WIN32_IE >= 0x0500

// {CFCCC7A0-A282-11D1-9082-006008059382}
DEFINE_GUID(CLSID_DarwinAppPublisher, 0xCFCCC7A0L, 0xA282, 0x11D1, 0x90, 0x82, 0x00, 0x60, 0x08, 0x05, 0x93, 0x82);

// {7057E952-BD1B-11d1-8919-00C04FC2C836}
DEFINE_GUID(CLSID_DocHostUIHandler, 0x7057e952, 0xbd1b, 0x11d1, 0x89, 0x19, 0x0, 0xc0, 0x4f, 0xc2, 0xc8, 0x36);
;begin_both
#endif  // _WIN32_IE >= 0x0400
;end_both

;begin_both
#if (_WIN32_IE >= 0x0500)
;end_both

// {93F2F68C-1D1B-11d3-A30E-00C04F79ABD1}
DEFINE_GUID(IID_IShellFolder2,  0x93f2f68c, 0x1d1b, 0x11d3, 0xa3, 0xe, 0x0, 0xc0, 0x4f, 0x79, 0xab, 0xd1);

#define PSGUID_SHELLDETAILS     {0x28636aa6, 0x953d, 0x11d2, 0xb5, 0xd6, 0x0, 0xc0, 0x4f, 0xd9, 0x18, 0xd0}
DEFINE_GUID(FMTID_ShellDetails,  0x28636aa6, 0x953d, 0x11d2, 0xb5, 0xd6, 0x0, 0xc0, 0x4f, 0xd9, 0x18, 0xd0);
#define PID_FINDDATA        0
#define PID_NETRESOURCE     1
#define PID_DESCRIPTIONID   2

// PSGUID_STORAGE comes from ntquery.h
//#define PSGUID_STORAGE    {0xb725f130, 0x47ef, 0x101a, 0xa5, 0xf1, 0x02, 0x60, 0x8c, 0x9e, 0xeb, 0xac}
DEFINE_GUID(FMTID_Storage,   0xb725f130, 0x47ef, 0x101a, 0xa5, 0xf1, 0x02, 0x60, 0x8c, 0x9e, 0xeb, 0xac);

// The GUIDs used to identify shell item attributes (columns). See IShellFolder2::GetDetailsEx implementations...

// {9B174B33-40FF-11d2-A27E-00C04FC30871}
#define PSGUID_DISPLACED    {0x9b174b33, 0x40ff, 0x11d2, 0xa2, 0x7e, 0x0, 0xc0, 0x4f, 0xc3, 0x8, 0x71}
DEFINE_GUID(FMTID_Displaced, 0x9b174b33, 0x40ff, 0x11d2, 0xa2, 0x7e, 0x0, 0xc0, 0x4f, 0xc3, 0x8, 0x71);
#define PID_DISPLACED_FROM  2
#define PID_DISPLACED_DATE  3

// {9B174B34-40FF-11d2-A27E-00C04FC30871}
#define PSGUID_MISC    {0x9b174b34, 0x40ff, 0x11d2, 0xa2, 0x7e, 0x0, 0xc0, 0x4f, 0xc3, 0x8, 0x71}
DEFINE_GUID(FMTID_Misc, 0x9b174b34, 0x40ff, 0x11d2, 0xa2, 0x7e, 0x0, 0xc0, 0x4f, 0xc3, 0x8, 0x71);
#define PID_MISC_STATUS			2
#define PID_MISC_ACCESSCOUNT	3
#define PID_MISC_OWNER			4
#define PID_HTMLINFOTIPFILE     5


// {9B174B35-40FF-11d2-A27E-00C04FC30871}
#define PSGUID_VOLUME    {0x9b174b35, 0x40ff, 0x11d2, 0xa2, 0x7e, 0x0, 0xc0, 0x4f, 0xc3, 0x8, 0x71}
DEFINE_GUID(FMTID_Volume, 0x9b174b35, 0x40ff, 0x11d2, 0xa2, 0x7e, 0x0, 0xc0, 0x4f, 0xc3, 0x8, 0x71);
#define PID_VOLUME_FREE      2

#define PSGUID_QUERY_D {0x49691c90,0x7e17,0x101a, 0xa9,0x1c,0x08,0x00,0x2b,0x2e,0xcd,0xa9}
DEFINE_GUID(FMTID_Query, 0x49691c90,0x7e17,0x101a, 0xa9,0x1c,0x08,0x00,0x2b,0x2e,0xcd,0xa9);
#define PID_QUERY_RANK	2

// FMTID_SummaryInformation, see OLE docs for PID_ values for these
#define PSGUID_SUMMARYINFORMATION	{0xf29f85e0L, 0x4ff9, 0x1068, 0xab, 0x91, 0x08, 0x00, 0x2b, 0x27, 0xb3, 0xd9}
// FMTID_DocumentSummaryInformation, see OLE docs on the PID_ values for this
#define PSGUID_DOCUMENTSUMMARYINFORMATION {0xd5cdd502L, 0x2e9c, 0x101b, 0x93, 0x97, 0x08, 0x00, 0x2b, 0x2c, 0xf9, 0xae}

// FMTID_MediaFileSummaryInformation, see propidl.h PID_ values for this
#define PSGUID_MEDIAFILESUMMARYINFORMATION {0x64440492L, 0x4c8b, 0x11d1, 0x8b, 0x70, 0x08, 0x00, 0x36, 0xb1, 0x1a, 0x03}

// {0E700BE1-9DB6-11d1-A1CE-00C04FD75D13}
DEFINE_GUID(IID_IEnumExtraSearch,  0xe700be1, 0x9db6, 0x11d1, 0xa1, 0xce, 0x0, 0xc0, 0x4f, 0xd7, 0x5d, 0x13);

// {12518493-00B2-11d2-9FA5-9E3420524153}
DEFINE_GUID(CLSID_MountedVolume, 0x12518493, 0x00B2, 0x11d2, 0x9F, 0xA5, 0x9E, 0x34, 0x20, 0x52, 0x41, 0x53);

// {12518492-00B2-11d2-9FA5-9E3420524153}
DEFINE_GUID(IID_IMountedVolume, 0x12518492, 0x00B2, 0x11d2, 0x9F, 0xA5, 0x9E, 0x34, 0x20, 0x52, 0x41, 0x53);

// {4657278A-411B-11d2-839A-00C04FD918D0}
DEFINE_GUID(CLSID_DragDropHelper,   0x4657278a, 0x411b, 0x11d2, 0x83, 0x9a, 0x0, 0xc0, 0x4f, 0xd9, 0x18, 0xd0);

// {4657278B-411B-11d2-839A-00C04FD918D0}
DEFINE_GUID(IID_IDropTargetHelper,  0x4657278b, 0x411b, 0x11d2, 0x83, 0x9a, 0x0, 0xc0, 0x4f, 0xd9, 0x18, 0xd0);

// {DE5BF786-477A-11d2-839D-00C04FD918D0}
DEFINE_GUID(IID_IDragSourceHelper,  0xde5bf786, 0x477a, 0x11d2, 0x83, 0x9d, 0x0, 0xc0, 0x4f, 0xd9, 0x18, 0xd0);

// {3050f3BB-98b5-11cf-bb82-00aa00bdce0b}
DEFINE_GUID(CLSID_CAnchorBrowsePropertyPage, 0x3050f3BB, 0x98b5, 0x11cf, 0xbb, 0x82, 0x00, 0xaa, 0x00, 0xbd, 0xce, 0x0b);

// {3050f3B3-98b5-11cf-bb82-00aa00bdce0b}
DEFINE_GUID(CLSID_CImageBrowsePropertyPage, 0x3050f3B3, 0x98b5, 0x11cf, 0xbb, 0x82, 0x00, 0xaa, 0x00, 0xbd, 0xce, 0x0b);

// {3050f3B4-98b5-11cf-bb82-00aa00bdce0b}
DEFINE_GUID(CLSID_CDocBrowsePropertyPage, 0x3050f3B4, 0x98b5, 0x11cf, 0xbb, 0x82, 0x00, 0xaa, 0x00, 0xbd, 0xce, 0x0b);

// {01E18D10-4D8B-11d2-855D-006008059367}
DEFINE_GUID(IID_IFileSystemBindData, 0x1e18d10, 0x4d8b, 0x11d2, 0x85, 0x5d, 0x0, 0x60, 0x8, 0x5, 0x93, 0x67);

;begin_internal
//  MonikerHelper is currently internal only.
// {679d9e36-f8f9-11d2-8deb-00c04f6837d5}
DEFINE_GUID(IID_IMonikerHelper, 0x679d9e36, 0xf8f9, 0x11d2, 0x8d, 0xeb, 0x00, 0xc0, 0x4f, 0x68, 0x37, 0xd5);

// {679d9e37-f8f9-11d2-8deb-00c04f6837d5}
DEFINE_GUID(CLSID_CShellMonikerHelper, 0x679d9e37, 0xf8f9, 0x11d2, 0x8d, 0xeb, 0x00, 0xc0, 0x4f, 0x68, 0x37, 0xd5);

// Define the CLSID for local and net users prop pages
// {D707877E-4D9C-11d2-8784-F6E920524153}
DEFINE_GUID(CLSID_UserPropertyPages, 
0xd707877e, 0x4d9c, 0x11d2, 0x87, 0x84, 0xf6, 0xe9, 0x20, 0x52, 0x41, 0x53);
;end_internal

;begin_internal
// IOleCommandTarget arugments for the Network Connections Folder.
// {EAF70CE4-B521-11d1-B550-00C04FD918D0}
DEFINE_GUID(CGID_ConnectionsFolder, 
    0xeaf70ce4, 0xb521, 0x11d1, 0xb5, 0x50, 0x0, 0xc0, 0x4f, 0xd9, 0x18, 0xd0);
;end_internal

;begin_internal
// {C0A651F5-B48B-11d2-B5ED-006097C686F6}
DEFINE_GUID(IID_IShellFolderFilterSite,  0xc0a651f5, 0xb48b, 0x11d2, 0xb5, 0xed, 0x0, 0x60, 0x97, 0xc6, 0x86, 0xf6);
// {9CC22886-DC8E-11d2-B1D0-00C04F8EEB3E}
DEFINE_GUID(IID_IShellFolderFilter,		 0x9cc22886, 0xdc8e, 0x11d2, 0xb1, 0xd0, 0x0, 0xc0, 0x4f, 0x8e, 0xeb, 0x3e);

// {A470F8CF-A1E8-4f65-8335-227475AA5C46}
DEFINE_GUID(CLSID_EncryptionContextMenuHandler, 0xa470f8cf, 0xa1e8, 0x4f65, 0x83, 0x35, 0x22, 0x74, 0x75, 0xAA, 0x5C, 0x46);
;end_internal

;begin_both
#endif // _WIN32_IE >= 0x0500
;end_both
#endif // _SHLGUID_H_
#endif // _SHLGUIDP_H_                  ;Internal
