/****************************************************************************
	MergePef.cpp

	Owner: JimMur
 	Copyright (c) 1995 Microsoft Corporation

	This file implements the Office bitmap processing tool

*****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <windows.h>

/* ---------------------------------------------------------------------------
	Constants
	-------------------------------------------------------------------JIMMUR -*/

const int kminArgs = 6;
const char kchlcOutFile= 'o';
const char kchupOutFile= 'O';
const char kchlcResFile = 'r';
const char kchupResFile = 'R';
const char kchlcHelp = 'h';
const char kchupHelp = 'H';
const char kchlcPefFile = 'p';
const char kchupPefFile = 'P';
const char kchQuestion = '?';
const char kchlcListFile = 'l';
const char kchupListFile = 'L';

const char kEOL [2] = {0x0D, 0x0A};
const char kTab[1] = {0x09}; 

const char* krgchHeaderStrs[] = 
	{ "/**********************************************************************************",
	  " * FILE GENERATED BY MergePEF DO NOT modify by hand",
	  " **********************************************************************************/",
	  " ",
	  "#include \"CodeFrag.r\"",
	  " ",
	  "resource 'cfrg' (0) {",
	  "	{"
	};

const int kcHeaderStrings = 8;


const char * krgchMemberStrs[] = 
	{ "kPowerPC,",
	  "kFullLib,",
	  "kNoVersionNum,",
	  "kNoVersionNum,",
	  "kDefaultStackSize,",
	  "kNoAppSubFolder,",
	  "kIsLib,",
	  "kOnDiskFlat,"
	};
	
const int kcMemberStrings = 8; 

const char kMemberEndStr[] = ",";
const char kStrDelim[] = "\"";

const char * krgchEndStrs[] =
	{ "	}",
	  "};"
	};
	
const int kcEndStrings = 2;	

/* ---------------------------------------------------------------------------
	Globals
	-------------------------------------------------------------------JIMMUR -*/

HANDLE 	vhOutFileR = INVALID_HANDLE_VALUE;  	// Output Mac Resource file
HANDLE	vhOutFilePEF = INVALID_HANDLE_VALUE; 	// Output combined PEF file
HANDLE	vhInFile	= INVALID_HANDLE_VALUE;			// Current Input file
HANDLE	vhListFile = INVALID_HANDLE_VALUE;		// Current List file
HANDLE 	vhInFileMap = INVALID_HANDLE_VALUE;		// File mapping for current input file
HANDLE	vhInListFileMap = INVALID_HANDLE_VALUE; // File mapping for current list file																
void*		vpvTopOfInFile = NULL;						// Address of mapping for current input file
void*		vpvTopOfListFile = NULL;					// Address of mapping for Current List file																
	
char* 	vszToolName = NULL;							// The name of this tool
DWORD 	vdwCurrentOffset = 0L; 						// Current offset in the combined PEF
DWORD		vdwNumMembersWritten = 0L;					// The number of resource written

/* ---------------------------------------------------------------------------
	Function Protypes
	-------------------------------------------------------------------JIMMUR -*/

void Usage();
void Error(const char *szError);
void ProcessListFile(char* szListFile);
DWORD CbAppendPef(char* szInputFile);
void WriteResHeader();
void WriteResMember(DWORD dwOffset, DWORD dwLength, const char* szPefName);
void 	WriteResEnd();
int main(short cArg, char *rgszArg[]);

/*---------------------------------------------------------------------------
    usage

    Print out the usage string for this tool
 ------------------------------------------------------------------ JIMMUR -*/
void Usage()
{
	printf("usage: %s [-h] -o outputPefFile -r outputRFile [-l listfile] [-p peffile pefname]",
		(NULL == vszToolName) ? "offbmp" : vszToolName);
			
	printf("\n\t-h\t\t\tThis help message");
	printf("\n\t-?\t\t\tThis help message");
	printf("\n\t-o outputPefFile\t\tName of output PEF file");
	printf("\n\t-r ourpurRFile\t\tName of the output Resource file");
	printf("\n\t-l listfile\t\tName of the list file");
	printf("\n\t-p peffile pefname\tperfile is the name of a PEF to merge");
	printf("\n\t\t\t\tpefname is the Mac PEF Name");
	printf("\n\nThere must be at lest two -p items"); 
	exit(1);	
}


 /*---------------------------------------------------------------------------
    Error

    Print out errors that occured while processing
 ------------------------------------------------------------------ JIMMUR -*/
void Error(const char *szError)
{

	if (NULL != vpvTopOfInFile)
		UnmapViewOfFile(vpvTopOfInFile);
	
	if (INVALID_HANDLE_VALUE != vhInFileMap)
		CloseHandle(vhInFileMap);
		
	if (INVALID_HANDLE_VALUE != vhInFile)
		CloseHandle(vhInFile);
	
	
	if (NULL != vpvTopOfListFile)
		UnmapViewOfFile(vpvTopOfListFile);
	
	if (INVALID_HANDLE_VALUE != vhInListFileMap)
		CloseHandle(vhInListFileMap);
		
	if (INVALID_HANDLE_VALUE != vhListFile)
		CloseHandle(vhListFile);
		

	if (INVALID_HANDLE_VALUE != vhOutFileR)
		CloseHandle(vhOutFileR);

	if (INVALID_HANDLE_VALUE != vhOutFilePEF)
		CloseHandle(vhOutFilePEF);


	printf("%s Error:  %s\n", (NULL == vszToolName) ? "MergePEF" : vszToolName,
		(NULL == szError) ? "Unknown Error" : szError);

	exit(1);
				
}

/*---------------------------------------------------------------------------
    ProcessListFile

	 Process a list file 
 ------------------------------------------------------------------ JIMMUR -*/
 
void ProcessListFile(char* szListFile)
{
	if (INVALID_HANDLE_VALUE !=  vhListFile)
		Error("List file failed to close!");
		
	vhListFile = CreateFile(szListFile, GENERIC_READ, 0, NULL, 
							OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);

	if (INVALID_HANDLE_VALUE == vhListFile)
		Error("Unable to open list file");

	DWORD dwFileSize = GetFileSize(vhListFile, NULL);

	if (0xFFFFFFFF == dwFileSize)	
		Error("Error getting the size of the list file");

	vhInListFileMap = CreateFileMapping(vhListFile, NULL, PAGE_READONLY, 0, 
									dwFileSize, NULL);
							
	vpvTopOfListFile = MapViewOfFile(vhInListFileMap, FILE_MAP_READ, 0, 0, 0);
	
	if (NULL == vpvTopOfListFile)
		Error("Error mapping view of List file");
	
	DWORD dwBytesRead = 0L;
	char szPEF[256];
	char szPEFName[256];
	char* pch = (char*)vpvTopOfListFile;
	char* pPEF = szPEF;
	char* pPEFName = szPEFName;
	
	while (1)
		{
		while (!isspace(*pch))
			{
			*pPEF++ = *pch++;
			dwBytesRead++;
			}
		
		*pPEF = '\0'; 
		if (dwBytesRead >= dwFileSize)
			break;
			
		while (isspace(*pch))
			{
			pch++;
			dwBytesRead++;
			}
			
		if (dwBytesRead >= dwFileSize)
			break;
		
		while (!isspace(*pch))
			{
			*pPEFName++ = *pch++;
			dwBytesRead++;
			}
		*pPEFName = '\0';	
		DWORD dwSize =  CbAppendPef(szPEF);
		WriteResMember(vdwCurrentOffset, dwSize, szPEFName);
		vdwCurrentOffset += dwSize;
			
		while (isspace(*pch))
			{
			pch++;
			dwBytesRead++;
			}
			
		if (dwBytesRead >= dwFileSize)
			break;
			
		pPEF = szPEF;
		pPEFName = szPEFName;
		}
		
	UnmapViewOfFile(vpvTopOfListFile);
	CloseHandle(vhInListFileMap);
	CloseHandle(vhListFile);
} 


/*---------------------------------------------------------------------------
    CbAppendPef

    Append the PEF file to the output pef  Return the number of bytes 
    appended

 ------------------------------------------------------------------ JIMMUR -*/
DWORD CbAppendPef(char* szInputFile) 
{
	if (INVALID_HANDLE_VALUE !=  vhInFile)
		Error("Input file failed to close!");
		
	vhInFile = CreateFile(szInputFile, GENERIC_READ, 0, NULL, 
							OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);

	if (INVALID_HANDLE_VALUE == vhInFile)
		Error("Unable to open input file");

	DWORD dwFileSize = GetFileSize(vhInFile, NULL);

	if (0xFFFFFFFF == dwFileSize)	
		Error("Error getting the size of the input file");

	vhInFileMap = CreateFileMapping(vhInFile, NULL, PAGE_READONLY, 0, 
									dwFileSize, NULL);
							
	vpvTopOfInFile = MapViewOfFile(vhInFileMap, FILE_MAP_READ, 0, 0, 0);
	
	if (NULL == vpvTopOfInFile)
		Error("Error mapping view of input file");

	DWORD cbWritten = 0L;
	WriteFile(vhOutFilePEF, vpvTopOfInFile, dwFileSize, &cbWritten, NULL);

	//  Pad the PEF to be at a 32 bit boundary

	DWORD dwFiller =  (dwFileSize	& 0x000000FF);
	if (0 != dwFiller)
		{
			dwFiller = 0x100 - dwFiller;
			BYTE bFill = 0;
			for (DWORD dwCounter = 0; dwCounter < dwFiller; dwCounter++)
				{
				WriteFile(vhOutFilePEF, &bFill, 1, &cbWritten, NULL);
				}

			dwFileSize += dwFiller;
		}

	UnmapViewOfFile(vpvTopOfInFile);
	CloseHandle(vhInFileMap);
	CloseHandle(vhInFile);
	vpvTopOfInFile = NULL;
	vhInFile = vhInFileMap = INVALID_HANDLE_VALUE;

	return  dwFileSize;
}

/*---------------------------------------------------------------------------
    WriteResHeader

    Write out Header for the Res File

 ------------------------------------------------------------------ JIMMUR -*/
void WriteResHeader()
{
	DWORD  cbWritten = 0;
	for ( int iCounter = 0; iCounter < kcHeaderStrings; iCounter++)
		{
		const char * szTemp = krgchHeaderStrs[iCounter];
		WriteFile(vhOutFileR, szTemp, strlen(szTemp), &cbWritten, NULL);
		WriteFile(vhOutFileR, kEOL, 2, &cbWritten, NULL);
		}
}

/*---------------------------------------------------------------------------
    WriteResMember

    Write out the member information for a pef 

 ------------------------------------------------------------------ JIMMUR -*/
void WriteResMember(DWORD dwOffset, DWORD dwLength, const char* szPefName)
{
	if (0 != (dwLength & 0x000000FF))
		Error("Member length is not on a 32 bit boundry");

	if ( 0 != (dwOffset & 0x000000FF))
		Error("Member Offset is not on a 32 bit boundry");

	if (NULL == szPefName)
		Error("Member Name is NULL!");

	DWORD  cbWritten = 0L;
	
	

	// Add a comma to the last member if it is not the first
	if (0 < vdwNumMembersWritten)
		{
		WriteFile(vhOutFileR, kMemberEndStr, 1, &cbWritten, NULL);
		WriteFile(vhOutFileR, kEOL, 2, &cbWritten, NULL);
		}

	 // put a comment into the file to show which member this is
	char szTemp[100];
	sprintf(szTemp,"\t\t\t\t/* [%d] */", vdwNumMembersWritten + 1);
	WriteFile(vhOutFileR, szTemp, strlen(szTemp), &cbWritten, NULL);
	WriteFile(vhOutFileR, kEOL, 2, &cbWritten, NULL);

	// Write out the common entries
	for ( int iCounter = 0; iCounter < kcMemberStrings; iCounter++)
		{
		const char * szTemp = krgchMemberStrs[iCounter];
		WriteFile(vhOutFileR, kTab, 1, &cbWritten, NULL);
		WriteFile(vhOutFileR, kTab, 1, &cbWritten, NULL);
		WriteFile(vhOutFileR, szTemp, strlen(szTemp), &cbWritten, NULL);
		WriteFile(vhOutFileR, kEOL, 2, &cbWritten, NULL);
		}

	// Write offset
	char szBuffer[100];
	sprintf(szBuffer,"%d",dwOffset);
	WriteFile(vhOutFileR, kTab, 1, &cbWritten, NULL);
	WriteFile(vhOutFileR, kTab, 1, &cbWritten, NULL);
	WriteFile(vhOutFileR, szBuffer, strlen(szBuffer), &cbWritten, NULL);
	WriteFile(vhOutFileR, kMemberEndStr, 1, &cbWritten, NULL);
	WriteFile(vhOutFileR, kEOL, 2, &cbWritten, NULL);

	// write length
	sprintf(szBuffer,"%d",dwLength);
	WriteFile(vhOutFileR, kTab, 1, &cbWritten, NULL);
	WriteFile(vhOutFileR, kTab, 1, &cbWritten, NULL);
	WriteFile(vhOutFileR, szBuffer, strlen(szBuffer), &cbWritten, NULL);
	WriteFile(vhOutFileR, kMemberEndStr, 1, &cbWritten, NULL);
	WriteFile(vhOutFileR, kEOL, 2, &cbWritten, NULL);

	// Write out the PEF name
	WriteFile(vhOutFileR, kTab, 1, &cbWritten, NULL);
	WriteFile(vhOutFileR, kTab, 1, &cbWritten, NULL);
	WriteFile(vhOutFileR, kStrDelim, 1, &cbWritten, NULL);
	WriteFile(vhOutFileR, szPefName, strlen(szPefName), &cbWritten, NULL);
	WriteFile(vhOutFileR, kStrDelim, 1, &cbWritten, NULL);

	vdwNumMembersWritten++;
}
/*---------------------------------------------------------------------------
    WriteResEnd

    Write out the end of the Res File 

 ------------------------------------------------------------------ JIMMUR -*/
void 	WriteResEnd()
{
	DWORD  cbWritten = 0;

	WriteFile(vhOutFileR, kEOL, 2, &cbWritten, NULL);

	for ( int iCounter = 0; iCounter < kcEndStrings; iCounter++)
		{
		const char * szTemp = krgchEndStrs[iCounter];
		WriteFile(vhOutFileR, szTemp, strlen(szTemp), &cbWritten, NULL);
		WriteFile(vhOutFileR, kEOL, 2, &cbWritten, NULL);
		}
}

/*---------------------------------------------------------------------------
    main

    Main entry point for this tool.  Parse the arguments and proceed 
	  accordingly
 ------------------------------------------------------------------ JIMMUR -*/
int main(short cArg, char *rgszArg[])
{
	int iArg = 0;
	int icbsz = 0;
	int ich = 0;
	char* szOutputPEF = NULL;
	char* szOutputR = NULL;

	vszToolName = rgszArg[0];	 	// Get the name of the tool

	if(cArg < kminArgs)
		Usage();

	for (iArg = 1; iArg < cArg; iArg++)
		{
		if ((rgszArg[iArg][0] == '-') || (rgszArg[iArg][0] == '/'))
			{
			icbsz = strlen(rgszArg[iArg]);
			for (ich = 1; ich < icbsz; ich++)
				{
				char ch = rgszArg[iArg][ich];
				switch (ch)
					{

					case kchlcOutFile:
					case kchupOutFile:
						if (INVALID_HANDLE_VALUE != vhOutFilePEF)
							Usage();

						szOutputPEF = 	rgszArg[++iArg];
						vhOutFilePEF = CreateFile(szOutputPEF, GENERIC_READ | GENERIC_WRITE, 0, NULL, 
								CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);
						if (INVALID_HANDLE_VALUE == vhOutFilePEF)
							Error("Unable to open input file");
						break;

					case kchlcResFile:
					case kchupResFile:
						if (INVALID_HANDLE_VALUE != vhOutFileR)
							Usage();

						szOutputR =  rgszArg[++iArg];
						vhOutFileR = CreateFile(szOutputR, GENERIC_READ | GENERIC_WRITE, 0, NULL, 
								CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);
						if (INVALID_HANDLE_VALUE == vhOutFileR)
							Error("Unable to open input file");
						WriteResHeader();
						break;

					case kchlcHelp:
					case kchupHelp:
					case kchQuestion:
						Usage();
						break;
						
					case kchlcListFile:
					case kchupListFile:
						{
						char* szListFile = rgszArg[++iArg];
						ProcessListFile(szListFile);
						}
						break;

					case kchlcPefFile:
					case kchupPefFile:
						{
						if ( (INVALID_HANDLE_VALUE == vhOutFilePEF) || (INVALID_HANDLE_VALUE == vhOutFileR) )
							Usage();

						char* szPEFFile = rgszArg[++iArg];
						char* szPEFName = rgszArg[++iArg];
						DWORD dwSize =  CbAppendPef(szPEFFile);
						WriteResMember(vdwCurrentOffset, dwSize, szPEFName);
						vdwCurrentOffset += dwSize;
						}
						break;

					default:
						Usage();
						break;
					} // switch (ch)
				} // for (ich = 1; ich < icbsz; ich++)
			} // if ((rgszArg[iArg][0] == '-') || (rgszArg[iArg][0] == '/'))
		} // for (iArg = 1; iArg < cArg; iArg++)

	if (INVALID_HANDLE_VALUE != vhOutFileR)
		{
		WriteResEnd();
		CloseHandle(vhOutFileR);
		vhOutFileR = INVALID_HANDLE_VALUE;
		}

	if (INVALID_HANDLE_VALUE != vhOutFilePEF)
		{
		CloseHandle(vhOutFilePEF);
		vhOutFilePEF = INVALID_HANDLE_VALUE;
		}

	return 0;

}

