#ifdef UNIX
#ifndef __STRING_WRAPPER_H__
#define __STRING_WRAPPER_H__
 
#include "mwconfig.h"
#include MW_INCLUDE_ANSI_HEADER(string.h)
#include <stddef.h>

MWBEGIN_EXTERN_C_BLOCK

#define _strupr    strupr
#define _strlwr    strlwr
#define _strset    strset
#define _strcmpi   strcmpi
#define _stricmp   stricmp
#define _strnicmp  strnicmp
#define _strnset  strnset
#define _strrev   strrev
#define _memicmp  memicmp

char* strupr(char*);
char* strlwr(char*);
char* strset(char* string, char c);
int strcmpi(const char*  s1, const char*  s2);
int stricmp(const char*  s1, const char*  s2);
int strnicmp(const char*  s1, const char*  s2, size_t len);
char* strnset(char* string, char c, size_t count);
char* strrev(char* string);
int memicmp(void *buf1, void *buf2, unsigned int count);
void* memmove(void* dest, const void* src, size_t count);
char* _strdup(const char* string);

MWEND_EXTERN_C_BLOCK

#endif /*  __STRING_WRAPPER_H__ */

#else /* !UNIX */

/***
*string.h - declarations for string manipulation functions
*
* Copyright (c) 1985 - 1999 Microsoft Corporation. All rights reserved.*
*Purpose:
*       This file contains the function declarations for the string
*       manipulation functions.
*       [ANSI/System V]
*
*       [Public]
*
****/

#if _MSC_VER > 1000
#pragma once
#endif  /* _MSC_VER > 1000 */

#ifndef _INC_STRING
#define _INC_STRING

#if !defined (_WIN32) && !defined (_MAC)
#error ERROR: Only Mac or Win32 targets supported!
#endif  /* !defined (_WIN32) && !defined (_MAC) */

#ifndef _CRTBLD
/* This version of the header files is NOT for user programs.
 * It is intended for use when building the C runtimes ONLY.
 * The version intended for public use will not have this message.
 */
#error ERROR: Use of C runtime library internal header file.
#endif  /* _CRTBLD */

#ifdef __cplusplus
extern "C" {
#endif  /* __cplusplus */

#ifndef _INTERNAL_IFSTRIP_
#include <cruntime.h>
#endif  /* _INTERNAL_IFSTRIP_ */


/* Define _CRTIMP */

#ifndef _CRTIMP
#ifdef CRTDLL
#define _CRTIMP __declspec(dllexport)
#else  /* CRTDLL */
#ifdef _DLL
#define _CRTIMP __declspec(dllimport)
#else  /* _DLL */
#define _CRTIMP
#endif  /* _DLL */
#endif  /* CRTDLL */
#endif  /* _CRTIMP */


/* Define __cdecl for non-Microsoft compilers */

#if (!defined (_MSC_VER) && !defined (__cdecl))
#define __cdecl
#endif  /* (!defined (_MSC_VER) && !defined (__cdecl)) */

#ifndef _SIZE_T_DEFINED
#ifdef  _WIN64
typedef unsigned __int64 size_t;
#else
typedef unsigned int     size_t;
#endif
#define _SIZE_T_DEFINED
#endif

  #ifndef _MAC
    #ifndef _WCHAR_T_DEFINED
     typedef unsigned short wchar_t;
     #define _WCHAR_T_DEFINED
    #endif  /* _WCHAR_T_DEFINED */
  #endif  /* _MAC */

#ifndef _NLSCMP_DEFINED
#define _NLSCMPERROR    2147483647  /* currently == INT_MAX */
#define _NLSCMP_DEFINED
#endif  /* _NLSCMP_DEFINED */

/* Define NULL pointer value */

#ifndef NULL
#ifdef __cplusplus
#define NULL    0
#else  /* __cplusplus */
#define NULL    ((void *)0)
#endif  /* __cplusplus */
#endif  /* NULL */


/* Function prototypes */

#ifdef _M_MRX000
_CRTIMP void *  __cdecl memcpy(void *, const void *, size_t);
_CRTIMP int     __cdecl memcmp(const void *, const void *, size_t);
_CRTIMP void *  __cdecl memset(void *, int, size_t);
_CRTIMP char *  __cdecl _strset(char *, int);
_CRTIMP char *  __cdecl strcpy(char *, const char *);
_CRTIMP char *  __cdecl strcat(char *, const char *);
_CRTIMP int     __cdecl strcmp(const char *, const char *);
_CRTIMP size_t  __cdecl strlen(const char *);
#else  /* _M_MRX000 */
        void *  __cdecl memcpy(void *, const void *, size_t);
        int     __cdecl memcmp(const void *, const void *, size_t);
        void *  __cdecl memset(void *, int, size_t);
        char *  __cdecl _strset(char *, int);
        char *  __cdecl strcpy(char *, const char *);
        char *  __cdecl strcat(char *, const char *);
        int     __cdecl strcmp(const char *, const char *);
        size_t  __cdecl strlen(const char *);
#endif  /* _M_MRX000 */
_CRTIMP void *  __cdecl _memccpy(void *, const void *, int, unsigned int);
_CRTIMP void *  __cdecl memchr(const void *, int, size_t);
_CRTIMP int     __cdecl _memicmp(const void *, const void *, unsigned int);

#ifdef _M_ALPHA
        /* memmove is available as an intrinsic in the Alpha compiler */
        void *  __cdecl memmove(void *, const void *, size_t);
#else  /* _M_ALPHA */
_CRTIMP void *  __cdecl memmove(void *, const void *, size_t);
#endif  /* _M_ALPHA */


_CRTIMP char *  __cdecl strchr(const char *, int);
_CRTIMP int     __cdecl _strcmpi(const char *, const char *);
_CRTIMP int     __cdecl _stricmp(const char *, const char *);
_CRTIMP int     __cdecl strcoll(const char *, const char *);
_CRTIMP int     __cdecl _stricoll(const char *, const char *);
_CRTIMP int     __cdecl _strncoll(const char *, const char *, size_t);
_CRTIMP int     __cdecl _strnicoll(const char *, const char *, size_t);
_CRTIMP size_t  __cdecl strcspn(const char *, const char *);
_CRTIMP char *  __cdecl _strdup(const char *);
_CRTIMP char *  __cdecl _strerror(const char *);
_CRTIMP char *  __cdecl strerror(int);
_CRTIMP char *  __cdecl _strlwr(char *);
_CRTIMP char *  __cdecl strncat(char *, const char *, size_t);
_CRTIMP int     __cdecl strncmp(const char *, const char *, size_t);
_CRTIMP int     __cdecl _strnicmp(const char *, const char *, size_t);
_CRTIMP char *  __cdecl strncpy(char *, const char *, size_t);
_CRTIMP char *  __cdecl _strnset(char *, int, size_t);
_CRTIMP char *  __cdecl strpbrk(const char *, const char *);
_CRTIMP char *  __cdecl strrchr(const char *, int);
_CRTIMP char *  __cdecl _strrev(char *);
_CRTIMP size_t  __cdecl strspn(const char *, const char *);
_CRTIMP char *  __cdecl strstr(const char *, const char *);
_CRTIMP char *  __cdecl strtok(char *, const char *);
_CRTIMP char *  __cdecl _strupr(char *);
_CRTIMP size_t  __cdecl strxfrm (char *, const char *, size_t);

#ifdef _MAC
unsigned char * __cdecl _c2pstr(char *);
char * __cdecl _p2cstr(unsigned char *);

#if !__STDC__
__inline unsigned char * __cdecl c2pstr(char *sz) { return _c2pstr(sz);};
__inline char * __cdecl p2cstr(unsigned char *sz) { return _p2cstr(sz);};
#endif  /* !__STDC__ */
#endif  /* _MAC */

#if !__STDC__

/* prototypes for oldnames.lib functions */
_CRTIMP void * __cdecl memccpy(void *, const void *, int, unsigned int);
_CRTIMP int __cdecl memicmp(const void *, const void *, unsigned int);
_CRTIMP int __cdecl strcmpi(const char *, const char *);
_CRTIMP int __cdecl stricmp(const char *, const char *);
_CRTIMP char * __cdecl strdup(const char *);
_CRTIMP char * __cdecl strlwr(char *);
_CRTIMP int __cdecl strnicmp(const char *, const char *, size_t);
_CRTIMP char * __cdecl strnset(char *, int, size_t);
_CRTIMP char * __cdecl strrev(char *);
        char * __cdecl strset(char *, int);
_CRTIMP char * __cdecl strupr(char *);

#endif  /* !__STDC__ */


#ifndef _MAC
#ifndef _WSTRING_DEFINED

/* wide function prototypes, also declared in wchar.h  */

_CRTIMP wchar_t * __cdecl wcscat(wchar_t *, const wchar_t *);
_CRTIMP wchar_t * __cdecl wcschr(const wchar_t *, wchar_t);
_CRTIMP int __cdecl wcscmp(const wchar_t *, const wchar_t *);
_CRTIMP wchar_t * __cdecl wcscpy(wchar_t *, const wchar_t *);
_CRTIMP size_t __cdecl wcscspn(const wchar_t *, const wchar_t *);
_CRTIMP size_t __cdecl wcslen(const wchar_t *);
_CRTIMP wchar_t * __cdecl wcsncat(wchar_t *, const wchar_t *, size_t);
_CRTIMP int __cdecl wcsncmp(const wchar_t *, const wchar_t *, size_t);
_CRTIMP wchar_t * __cdecl wcsncpy(wchar_t *, const wchar_t *, size_t);
_CRTIMP wchar_t * __cdecl wcspbrk(const wchar_t *, const wchar_t *);
_CRTIMP wchar_t * __cdecl wcsrchr(const wchar_t *, wchar_t);
_CRTIMP size_t __cdecl wcsspn(const wchar_t *, const wchar_t *);
_CRTIMP wchar_t * __cdecl wcsstr(const wchar_t *, const wchar_t *);
_CRTIMP wchar_t * __cdecl wcstok(wchar_t *, const wchar_t *);

_CRTIMP wchar_t * __cdecl _wcsdup(const wchar_t *);
_CRTIMP int __cdecl _wcsicmp(const wchar_t *, const wchar_t *);
_CRTIMP int __cdecl _wcsnicmp(const wchar_t *, const wchar_t *, size_t);
_CRTIMP wchar_t * __cdecl _wcsnset(wchar_t *, wchar_t, size_t);
_CRTIMP wchar_t * __cdecl _wcsrev(wchar_t *);
_CRTIMP wchar_t * __cdecl _wcsset(wchar_t *, wchar_t);

_CRTIMP wchar_t * __cdecl _wcslwr(wchar_t *);
_CRTIMP wchar_t * __cdecl _wcsupr(wchar_t *);
_CRTIMP size_t __cdecl wcsxfrm(wchar_t *, const wchar_t *, size_t);
_CRTIMP int __cdecl wcscoll(const wchar_t *, const wchar_t *);
_CRTIMP int __cdecl _wcsicoll(const wchar_t *, const wchar_t *);
_CRTIMP int __cdecl _wcsncoll(const wchar_t *, const wchar_t *, size_t);
_CRTIMP int __cdecl _wcsnicoll(const wchar_t *, const wchar_t *, size_t);

#if !__STDC__

/* old names */
#define wcswcs wcsstr

/* prototypes for oldnames.lib functions */
_CRTIMP wchar_t * __cdecl wcsdup(const wchar_t *);
_CRTIMP int __cdecl wcsicmp(const wchar_t *, const wchar_t *);
_CRTIMP int __cdecl wcsnicmp(const wchar_t *, const wchar_t *, size_t);
_CRTIMP wchar_t * __cdecl wcsnset(wchar_t *, wchar_t, size_t);
_CRTIMP wchar_t * __cdecl wcsrev(wchar_t *);
_CRTIMP wchar_t * __cdecl wcsset(wchar_t *, wchar_t);
_CRTIMP wchar_t * __cdecl wcslwr(wchar_t *);
_CRTIMP wchar_t * __cdecl wcsupr(wchar_t *);
_CRTIMP int __cdecl wcsicoll(const wchar_t *, const wchar_t *);

#endif  /* !__STDC__ */

#define _WSTRING_DEFINED
#endif  /* _WSTRING_DEFINED */

#endif  /* _MAC */

#ifdef __cplusplus
}
#endif  /* __cplusplus */

#endif  /* _INC_STRING */

#endif
