#include "private.h"
const MIMERFC1766 MimeRfc1766[] =
{
    { 0x0436, L"af",    IDS_RFC1766_LCID0436 },
    { 0x041C, L"sq",    IDS_RFC1766_LCID041C },
    { 0x0001, L"ar",    IDS_RFC1766_LCID0001 },
    { 0x0401, L"ar-sa", IDS_RFC1766_LCID0401 },
    { 0x0801, L"ar-iq", IDS_RFC1766_LCID0801 },
    { 0x0C01, L"ar-eg", IDS_RFC1766_LCID0C01 },
    { 0x1001, L"ar-ly", IDS_RFC1766_LCID1001 },
    { 0x1401, L"ar-dz", IDS_RFC1766_LCID1401 },
    { 0x1801, L"ar-ma", IDS_RFC1766_LCID1801 },
    { 0x1C01, L"ar-tn", IDS_RFC1766_LCID1C01 },
    { 0x2001, L"ar-om", IDS_RFC1766_LCID2001 },
    { 0x2401, L"ar-ye", IDS_RFC1766_LCID2401 },
    { 0x2801, L"ar-sy", IDS_RFC1766_LCID2801 },
    { 0x2C01, L"ar-jo", IDS_RFC1766_LCID2C01 },
    { 0x3001, L"ar-lb", IDS_RFC1766_LCID3001 },
    { 0x3401, L"ar-kw", IDS_RFC1766_LCID3401 },
    { 0x3801, L"ar-ae", IDS_RFC1766_LCID3801 },
    { 0x3C01, L"ar-bh", IDS_RFC1766_LCID3C01 },
    { 0x4001, L"ar-qa", IDS_RFC1766_LCID4001 },
    { 0x042D, L"eu",    IDS_RFC1766_LCID042D },
    { 0x0402, L"bg",    IDS_RFC1766_LCID0402 },
    { 0x0423, L"be",    IDS_RFC1766_LCID0423 },
    { 0x0403, L"ca",    IDS_RFC1766_LCID0403 },
    { 0x0004, L"zh",    IDS_RFC1766_LCID0004 },
    { 0x1404, L"zh",    IDS_RFC1766_LCID1404 },
    { 0x0404, L"zh-tw", IDS_RFC1766_LCID0404 },
    { 0x0804, L"zh-cn", IDS_RFC1766_LCID0804 },
    { 0x0C04, L"zh-hk", IDS_RFC1766_LCID0C04 },
    { 0x1004, L"zh-sg", IDS_RFC1766_LCID1004 },
    { 0x041A, L"hr",    IDS_RFC1766_LCID041A },
    { 0x0405, L"cs",    IDS_RFC1766_LCID0405 },
    { 0x0406, L"da",    IDS_RFC1766_LCID0406 },
    { 0x0413, L"nl",    IDS_RFC1766_LCID0413 },
    { 0x0813, L"nl-be", IDS_RFC1766_LCID0813 },
    { 0x0009, L"en",    IDS_RFC1766_LCID0009 },
    { 0x2409, L"en",    IDS_RFC1766_LCID2409 },
    { 0x0409, L"en-us", IDS_RFC1766_LCID0409 },
    { 0x0809, L"en-gb", IDS_RFC1766_LCID0809 },
    { 0x0C09, L"en-au", IDS_RFC1766_LCID0C09 },
    { 0x1009, L"en-ca", IDS_RFC1766_LCID1009 },
    { 0x1409, L"en-nz", IDS_RFC1766_LCID1409 },
    { 0x1809, L"en-ie", IDS_RFC1766_LCID1809 },
    { 0x1C09, L"en-za", IDS_RFC1766_LCID1C09 },
    { 0x3009, L"en-zw", IDS_RFC1766_LCID3009 },
    { 0x2009, L"en-jm", IDS_RFC1766_LCID2009 },
    { 0x2809, L"en-bz", IDS_RFC1766_LCID2809 },
    { 0x2C09, L"en-tt", IDS_RFC1766_LCID2C09 },
    { 0x3409, L"en-ph", IDS_RFC1766_LCID3409 },
    { 0x0425, L"et",    IDS_RFC1766_LCID0425 },
    { 0x0438, L"fo",    IDS_RFC1766_LCID0438 },
    { 0x0429, L"fa",    IDS_RFC1766_LCID0429 },
    { 0x040B, L"fi",    IDS_RFC1766_LCID040B },
    { 0x040C, L"fr",    IDS_RFC1766_LCID040C },
    { 0x080C, L"fr-be", IDS_RFC1766_LCID080C },
    { 0x0C0C, L"fr-ca", IDS_RFC1766_LCID0C0C },
    { 0x100C, L"fr-ch", IDS_RFC1766_LCID100C },
    { 0x140C, L"fr-lu", IDS_RFC1766_LCID140C },
    { 0x180C, L"fr-mc", IDS_RFC1766_LCID180C },
    { 0x043C, L"gd",    IDS_RFC1766_LCID043C },
    { 0x0407, L"de",    IDS_RFC1766_LCID0407 },
    { 0x0807, L"de-ch", IDS_RFC1766_LCID0807 },
    { 0x0C07, L"de-at", IDS_RFC1766_LCID0C07 },
    { 0x1007, L"de-lu", IDS_RFC1766_LCID1007 },
    { 0x1407, L"de-li", IDS_RFC1766_LCID1407 },
    { 0x0408, L"el",    IDS_RFC1766_LCID0408 },
    { 0x040D, L"he",    IDS_RFC1766_LCID040D },
    { 0x0439, L"hi",    IDS_RFC1766_LCID0439 },
    { 0x040E, L"hu",    IDS_RFC1766_LCID040E },
    { 0x040F, L"is",    IDS_RFC1766_LCID040F },
    { 0x0421, L"id",    IDS_RFC1766_LCID0421 },
    { 0x0410, L"it",    IDS_RFC1766_LCID0410 },
    { 0x0810, L"it-ch", IDS_RFC1766_LCID0810 },
    { 0x0411, L"ja",    IDS_RFC1766_LCID0411 },
    { 0x0412, L"ko",    IDS_RFC1766_LCID0412 },
    { 0x0426, L"lv",    IDS_RFC1766_LCID0426 },
    { 0x0427, L"lt",    IDS_RFC1766_LCID0427 },
    { 0x042F, L"mk",    IDS_RFC1766_LCID042F },
    { 0x043E, L"ms",    IDS_RFC1766_LCID043E },
    { 0x043A, L"mt",    IDS_RFC1766_LCID043A },
    { 0x0415, L"pl",    IDS_RFC1766_LCID0415 },
    { 0x0416, L"pt-br", IDS_RFC1766_LCID0416 },
    { 0x0816, L"pt",    IDS_RFC1766_LCID0816 },
    { 0x0417, L"rm",    IDS_RFC1766_LCID0417 },
    { 0x0418, L"ro",    IDS_RFC1766_LCID0418 },
    { 0x0818, L"ro-mo", IDS_RFC1766_LCID0818 },
    { 0x0419, L"ru",    IDS_RFC1766_LCID0419 },
    { 0x0819, L"ru-mo", IDS_RFC1766_LCID0819 },
    { 0x0C1A, L"sr",    IDS_RFC1766_LCID0C1A },
    { 0x081A, L"sr",    IDS_RFC1766_LCID081A },
    { 0x041B, L"sk",    IDS_RFC1766_LCID041B },
    { 0x0424, L"sl",    IDS_RFC1766_LCID0424 },
    { 0x042E, L"sb",    IDS_RFC1766_LCID042E },
    { 0x040A, L"es",    IDS_RFC1766_LCID040A },
    { 0x080A, L"es-mx", IDS_RFC1766_LCID080A },
    { 0x0C0A, L"es",    IDS_RFC1766_LCID0C0A },
    { 0x100A, L"es-gt", IDS_RFC1766_LCID100A },
    { 0x140A, L"es-cr", IDS_RFC1766_LCID140A },
    { 0x180A, L"es-pa", IDS_RFC1766_LCID180A },
    { 0x1C0A, L"es-do", IDS_RFC1766_LCID1C0A },
    { 0x200A, L"es-ve", IDS_RFC1766_LCID200A },
    { 0x240A, L"es-co", IDS_RFC1766_LCID240A },
    { 0x280A, L"es-pe", IDS_RFC1766_LCID280A },
    { 0x2C0A, L"es-ar", IDS_RFC1766_LCID2C0A },
    { 0x300A, L"es-ec", IDS_RFC1766_LCID300A },
    { 0x340A, L"es-cl", IDS_RFC1766_LCID340A },
    { 0x380A, L"es-uy", IDS_RFC1766_LCID380A },
    { 0x3C0A, L"es-py", IDS_RFC1766_LCID3C0A },
    { 0x400A, L"es-bo", IDS_RFC1766_LCID400A },
    { 0x440A, L"es-sv", IDS_RFC1766_LCID440A },
    { 0x480A, L"es-hn", IDS_RFC1766_LCID480A },
    { 0x4C0A, L"es-ni", IDS_RFC1766_LCID4C0A },
    { 0x500A, L"es-pr", IDS_RFC1766_LCID500A },
    { 0x0430, L"sx",    IDS_RFC1766_LCID0430 },
    { 0x041D, L"sv",    IDS_RFC1766_LCID041D },
    { 0x081D, L"sv-fi", IDS_RFC1766_LCID081D },
    { 0x041E, L"th",    IDS_RFC1766_LCID041E },
    { 0x0431, L"ts",    IDS_RFC1766_LCID0431 },
    { 0x0432, L"tn",    IDS_RFC1766_LCID0432 },
    { 0x041F, L"tr",    IDS_RFC1766_LCID041F },
    { 0x0422, L"uk",    IDS_RFC1766_LCID0422 },
    { 0x0420, L"ur",    IDS_RFC1766_LCID0420 },
    { 0x0443, L"uz",    IDS_RFC1766_LCID0443 },
    { 0x0843, L"uz",    IDS_RFC1766_LCID0843 },
    { 0x042A, L"vi",    IDS_RFC1766_LCID042A },
    { 0x0434, L"xh",    IDS_RFC1766_LCID0434 },
    { 0x043D, L"yi",    IDS_RFC1766_LCID043D },
    { 0x0435, L"zu",    IDS_RFC1766_LCID0435 },
    { 0x042B, L"hy",    IDS_RFC1766_LCID042B },
    { 0x0437, L"ka",    IDS_RFC1766_LCID0437 },
    { 0x043F, L"kk",    IDS_RFC1766_LCID043F },
    { 0x0441, L"sw",    IDS_RFC1766_LCID0441 },
    { 0x0444, L"tt",    IDS_RFC1766_LCID0444 },
    { 0x0445, L"bn",    IDS_RFC1766_LCID0445 },
    { 0x0446, L"pa",    IDS_RFC1766_LCID0446 },
    { 0x0447, L"gu",    IDS_RFC1766_LCID0447 },
    { 0x0448, L"or",    IDS_RFC1766_LCID0448 },
    { 0x0449, L"ta",    IDS_RFC1766_LCID0449 },
    { 0x044A, L"te",    IDS_RFC1766_LCID044A },
    { 0x044B, L"kn",    IDS_RFC1766_LCID044B },
    { 0x044C, L"ml",    IDS_RFC1766_LCID044C },
    { 0x044D, L"as",    IDS_RFC1766_LCID044D },
    { 0x044E, L"mr",    IDS_RFC1766_LCID044E },
    { 0x083E, L"ms",    IDS_RFC1766_LCID083E },
    { 0x0861, L"ne",    IDS_RFC1766_LCID0861 },
    { 0x044F, L"sa",    IDS_RFC1766_LCID044F },
    { 0x0827, L"it",    IDS_RFC1766_LCID0827 },
    { 0x0457, L"x-kok", IDS_RFC1766_LCID0457 },

// Following rfc1766 names are over already published MAX_RFC1766_NAME
// We have to modify them for IE5 release, will do better later

//  { 0x082C, L"x-az-cyrillic", IDS_RFC1766_LCID082C },
//  { 0x042C, L"x-az-latin",    IDS_RFC1766_LCID042C },
//  { 0x0414, L"no-nyn",IDS_RFC1766_LCID0414 },
//  { 0x0814, L"no-bok",IDS_RFC1766_LCID0814 },

    { 0x0414, L"no",    IDS_RFC1766_LCID0414 },
    { 0x0814, L"no",    IDS_RFC1766_LCID0814 },
    { 0x082C, L"az",    IDS_RFC1766_LCID082C },
    { 0x042C, L"az",    IDS_RFC1766_LCID042C },
};

UINT g_cRfc1766 = ARRAYSIZE(MimeRfc1766);
//
//  CEnumCodePage implementation
//
CEnumCodePage::CEnumCodePage(DWORD grfFlags, LANGID LangId, MIMECONTF dwSource) : _dwLevel( grfFlags ), _LangId( LangId), dwMimeSource(dwSource)
{
    DebugMsg(DM_TRACE, TEXT("constructor of CEnumCodePage 0x%08x"), this);
    DllAddRef();

    _cRef = 1;
    _iCur = 0;
}

CEnumCodePage::~CEnumCodePage()
{
    DebugMsg(DM_TRACE, TEXT("destructor of CEnumCodePage 0x%08x"), this);
    DllRelease();
}

STDAPI CEnumCodePage::QueryInterface(REFIID riid, void **ppvObj)
{
    DebugMsg(DM_TRACE, TEXT("CEnumCodePage::QueryInterface called."));
    if (IsEqualIID(riid, IID_IUnknown) || IsEqualIID(riid, IID_IEnumCodePage))
    {
        *ppvObj = SAFECAST(this, IEnumCodePage*);
        AddRef();
        return NOERROR;
    }
    *ppvObj = NULL;
    return E_NOINTERFACE;
}

STDAPI_(ULONG) CEnumCodePage::AddRef()
{
    _cRef++;
    DebugMsg(DM_TRACE, TEXT("CEnumCodePage::AddRef called. _cRef=%d"), _cRef);
    return _cRef;
}

STDAPI_(ULONG) CEnumCodePage::Release()
{
    _cRef--;
    DebugMsg(DM_TRACE, TEXT("CEnumCodePage::Release called. _cRef=%d"), _cRef);
    if (0 < _cRef)
        return _cRef;

    delete this;
    return 0;    
}

STDAPI CEnumCodePage::Clone(IEnumCodePage **ppEnumCodePage)
{
    DebugMsg(DM_TRACE, TEXT("CEnumCodePage::Clone called."));
    return E_NOTIMPL;
}

STDAPI CEnumCodePage::Next(ULONG celt, PMIMECPINFO rgcpInfo, ULONG *pceltFetched)
{    
    DebugMsg(DM_TRACE, TEXT("CEnumCodePage::Next called."));


    UINT cNum = 0;
    MIMECPINFO cpInfo;

    if (dwMimeSource &  MIMECONTF_MIME_REGISTRY)
    {
        if (NULL != g_pMimeDatabaseReg && NULL != rgcpInfo)
        {
            if (0 == _iCur)
                if (S_OK != g_pMimeDatabaseReg->EnumCodePageInfo())
                    return E_FAIL;

            while (cNum < celt)
            {
                HRESULT hr = g_pMimeDatabaseReg->GetCodePageInfoWithIndex(_iCur++, &cpInfo);
                if (SUCCEEDED(hr))
                {
                    if (_dwLevel == (cpInfo.dwFlags & _dwLevel))
                    {
                        *(rgcpInfo + cNum) = cpInfo;
                        cNum++;
                    }
                }
                else
                    break;
            }
            if (NULL != pceltFetched)
                *pceltFetched = cNum;
            return (0 < cNum)? S_OK: S_FALSE;
        }
        else
            return E_FAIL;
    } 

    while (cNum < celt)
    {
        if (SUCCEEDED(g_pMimeDatabase->GetCodePageInfoWithIndex(_iCur++, _LangId, &cpInfo)))
        {
            if (_dwLevel == (cpInfo.dwFlags & _dwLevel) &&
                (cpInfo.dwFlags & dwMimeSource))
            {
                *(rgcpInfo + cNum) = cpInfo;
                cNum++;
            }
        }
        else
            break;
    }

    if (NULL != pceltFetched)
       *pceltFetched = cNum;

    return (0 < cNum)? S_OK: S_FALSE;

}


STDAPI CEnumCodePage::Reset()
{
    DebugMsg(DM_TRACE, TEXT("CEnumCodePage::Reset called."));
    _iCur = 0;
    return NOERROR;
}

STDAPI CEnumCodePage::Skip(ULONG celt)
{
    DebugMsg(DM_TRACE, TEXT("CEnumCodePage::Skip called."));
    _iCur += celt;
    return NOERROR;
}

//
//  CEnumRfc1766 implementation
//
CEnumRfc1766::CEnumRfc1766(MIMECONTF dwSource, LANGID LangId) : _LangID(LangId)
{
    DebugMsg(DM_TRACE, TEXT("constructor of CEnumRfc1766 0x%08x"), this);
    dwMimeSource = dwSource;
    DllAddRef();
    _cRef = 1;
    _uCur = 0;
}

CEnumRfc1766::~CEnumRfc1766()
{
    DebugMsg(DM_TRACE, TEXT("destructor of CEnumRfc1766 0x%08x"), this);
    DllRelease();
}

STDAPI CEnumRfc1766::QueryInterface(REFIID riid, void **ppvObj)
{
    DebugMsg(DM_TRACE, TEXT("CEnumRfc1766::QueryInterface called."));
    if (IsEqualIID(riid, IID_IUnknown) || IsEqualIID(riid, IID_IEnumRfc1766))
    {
        *ppvObj = SAFECAST(this, IEnumRfc1766*);
        AddRef();
        return NOERROR;
    }
    *ppvObj = NULL;
    return E_NOINTERFACE;
}

STDAPI_(ULONG) CEnumRfc1766::AddRef()
{
    _cRef++;
    DebugMsg(DM_TRACE, TEXT("CEnumRfc1766::AddRef called. _cRef=%d"), _cRef);
    return _cRef;
}

STDAPI_(ULONG) CEnumRfc1766::Release()
{
    _cRef--;
    DebugMsg(DM_TRACE, TEXT("CEnumRfc1766::Release called. _cRef=%d"), _cRef);
    if (0 < _cRef)
        return _cRef;

    delete this;
    return 0;    
}

STDAPI CEnumRfc1766::Clone(IEnumRfc1766 **ppEnumRfc1766)
{
    DebugMsg(DM_TRACE, TEXT("CEnumRfc1766::Clone called."));
    return E_NOTIMPL;
}

STDAPI CEnumRfc1766::Next(ULONG celt, PRFC1766INFO rgRfc1766Info, ULONG *pceltFetched)
{
    DebugMsg(DM_TRACE, TEXT("CEnumRfc1766::Next called."));

    if (g_pMimeDatabaseReg && (dwMimeSource &  MIMECONTF_MIME_REGISTRY))
    {
        g_pMimeDatabaseReg->EnsureRfc1766Table();
        if (NULL != g_pRfc1766Reg && NULL != rgRfc1766Info)
        {
            UINT cNum = 0;

            while (cNum < celt)
            {
                if (_uCur < g_cRfc1766)
                {
                    (rgRfc1766Info + cNum)->lcid = g_pRfc1766Reg[_uCur].lcid;
                    MultiByteToWideChar(CP_ACP, 0, g_pRfc1766Reg[_uCur].szRfc1766, -1, (rgRfc1766Info + cNum)->wszRfc1766, MAX_RFC1766_NAME);
                    (rgRfc1766Info + cNum)->wszRfc1766[MAX_RFC1766_NAME-1] = 0;
                    MultiByteToWideChar(CP_ACP, 0, g_pRfc1766Reg[_uCur].szLocaleName, -1, (rgRfc1766Info + cNum)->wszLocaleName, MAX_LOCALE_NAME);
                    (rgRfc1766Info + cNum)->wszLocaleName[MAX_LOCALE_NAME-1] = 0;
                    cNum++;
                    _uCur++;
                }
                else
                    break;
            }
            if (NULL != pceltFetched)
                *pceltFetched = cNum;
            return (0 < cNum)? S_OK: S_FALSE;
        }
        else
            return E_FAIL;
    }
    if (NULL != rgRfc1766Info)
    {
        UINT cNum = 0;

        while (cNum < celt)
        {
            if (_uCur < g_cRfc1766)
            {
                (rgRfc1766Info + cNum)->lcid = MimeRfc1766[_uCur].LcId;
                MLStrCpyNW((rgRfc1766Info + cNum)->wszRfc1766, MimeRfc1766[_uCur].szRfc1766, MAX_RFC1766_NAME);

                (rgRfc1766Info + cNum)->wszRfc1766[MAX_RFC1766_NAME-1] = 0; 
                
                if (!_LoadStringExW(g_hInst, MimeRfc1766[_uCur].uidLCID, (rgRfc1766Info + cNum)->wszLocaleName, 
                                    MAX_LOCALE_NAME, _LangID))
                {
                        // Last try, switch to English, US
                        if (!_LoadStringExW(g_hInst, MimeRfc1766[_uCur].uidLCID, (rgRfc1766Info + cNum)->wszLocaleName, 
                                       MAX_LOCALE_NAME, MAKELANGID(LANG_ENGLISH, SUBLANG_ENGLISH_US)))
                             (rgRfc1766Info + cNum)->wszLocaleName[0] = 0x0000;
                }
                (rgRfc1766Info + cNum)->wszLocaleName[MAX_LOCALE_NAME-1] = 0;

                cNum++;
                _uCur++;
            }
            else
                break;
        }
        if (NULL != pceltFetched)
            *pceltFetched = cNum;
        return (0 < cNum)? S_OK: S_FALSE;
    }
    else
        return E_FAIL;
}

STDAPI CEnumRfc1766::Reset()
{
    DebugMsg(DM_TRACE, TEXT("CEnumRfc1766::Reset called."));
    _uCur = 0;
    return NOERROR;
}

STDAPI CEnumRfc1766::Skip(ULONG celt)
{
    DebugMsg(DM_TRACE, TEXT("CEnumRfc1766::Skip called."));
    _uCur += celt;
    return NOERROR;
}

//
// CEnumScript implementation
//
CEnumScript::CEnumScript(DWORD grfFlags, LANGID LangId, MIMECONTF dwSource) : _dwLevel(grfFlags), _LangId( LangId)
{
    DebugMsg(DM_TRACE, TEXT("constructor of CEnumScript 0x%08x"), this);
    DllAddRef();

    _cRef = 1;
    _uCur = 0;
}

CEnumScript::~CEnumScript()
{
    DebugMsg(DM_TRACE, TEXT("destructor of CEnumScript 0x%08x"), this);
    DllRelease();
}

STDAPI CEnumScript::QueryInterface(REFIID riid, void **ppvObj)
{
    DebugMsg(DM_TRACE, TEXT("CEnumScript::QueryInterface called."));
    if (IsEqualIID(riid, IID_IUnknown) || IsEqualIID(riid, IID_IEnumScript))
    {
        *ppvObj = SAFECAST(this, IEnumScript*);
        AddRef();
        return NOERROR;
    }
    *ppvObj = NULL;
    return E_NOINTERFACE;
}

STDAPI_(ULONG) CEnumScript::AddRef()
{
    _cRef++;
    DebugMsg(DM_TRACE, TEXT("CEnumScript::AddRef called. _cRef=%d"), _cRef);
    return _cRef;
}

STDAPI_(ULONG) CEnumScript::Release()
{
    _cRef--;
    DebugMsg(DM_TRACE, TEXT("CEnumScript::Release called. _cRef=%d"), _cRef);
    if (0 < _cRef)
        return _cRef;

    delete this;
    return 0;    
}

STDAPI CEnumScript::Clone(IEnumScript **ppEnumScript)
{
    DebugMsg(DM_TRACE, TEXT("CEnumScript::Clone called."));
    return E_NOTIMPL;
}

STDAPI CEnumScript::Next(ULONG celt, PSCRIPTINFO rgScriptInfo, ULONG *pceltFetched)
{    
    DebugMsg(DM_TRACE, TEXT("CEnumScript::Next called."));

    if (!_dwLevel)
        _dwLevel = ~0;

    if (NULL != rgScriptInfo)
    {
        UINT cNum = 0;
        LANGID LangId = _LangId;

        while (cNum < celt)
        {
            if (_uCur < g_cScript)
            {
                if (!(ScriptTable[_uCur].dwFlags & _dwLevel))
                { 
                    _uCur++;
                    continue;
                }

                (rgScriptInfo + cNum)->ScriptId = ScriptTable[_uCur].sid;

                (rgScriptInfo + cNum)->uiCodePage = ScriptTable[_uCur].uiCodePage;

                (rgScriptInfo + cNum)->wszDescription[0] = 0x0000;

                if (!_LoadStringExW(g_hInst, ScriptTable[_uCur].uidDescription, (rgScriptInfo + cNum)->wszDescription, 
                                    MAX_SCRIPT_NAME, LangId))
                {
                        // Last try, switch to English, US
                        LangId = MAKELANGID(LANG_ENGLISH, SUBLANG_ENGLISH_US);
                        _LoadStringExW(g_hInst, ScriptTable[_uCur].uidDescription, (rgScriptInfo + cNum)->wszDescription, 
                                       MAX_SCRIPT_NAME, LangId);
                }

                (rgScriptInfo + cNum)->wszFixedWidthFont[0] = 0x0000;
                if (ScriptTable[_uCur].uidFixedWidthFont)
                {
                    _LoadStringExW(g_hInst, ScriptTable[_uCur].uidFixedWidthFont, (rgScriptInfo + cNum)->wszFixedWidthFont,
                                   MAX_MIMEFACE_NAME, LangId);
                }

                (rgScriptInfo + cNum)->wszProportionalFont[0] = 0x0000;
                if (ScriptTable[_uCur].uidProportionalFont)
                {
                    _LoadStringExW(g_hInst, ScriptTable[_uCur].uidProportionalFont, (rgScriptInfo + cNum)->wszProportionalFont,
                                   MAX_MIMEFACE_NAME, LangId);
                }

                cNum++;
                _uCur++;
            }
            else
                break;
        }

        if (NULL != pceltFetched)
            *pceltFetched = cNum;
        return (0 < cNum)? S_OK: S_FALSE;
    }
    else
        return E_FAIL;
}


STDAPI CEnumScript::Reset()
{
    DebugMsg(DM_TRACE, TEXT("CEnumScript::Reset called."));
    _uCur = 0;
    return NOERROR;
}

STDAPI CEnumScript::Skip(ULONG celt)
{
    DebugMsg(DM_TRACE, TEXT("CEnumScript::Skip called."));
    _uCur += celt;
    return NOERROR;
}

