#include "private.h"

// Table pre-sorted by charset for binary search !!!
const MIMECHARSET MimeCharSet[] =
{
//  { Charset, CodePage, InternetEncoding, Flags }
    { L"_autodetect", 50932, 50932, MIMECONTF_MIME_LATEST | MIMECONTF_MIME_IE4 },
    { L"_autodetect_all", 50001, 50001, MIMECONTF_MIME_LATEST},
    { L"_autodetect_kr", 50949, 50949, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4 },
    { L"_iso-2022-jp$ESC", 932, 50221, MIMECONTF_MIME_IE4  },
    { L"_iso-2022-jp$SIO", 932, 50222, MIMECONTF_MIME_IE4  },
    { L"437", 1252, 437, MIMECONTF_MIME_LATEST},
    { L"ANSI_X3.4-1968", 1252, 20127, MIMECONTF_MIME_LATEST},
    { L"ANSI_X3.4-1968", 1252, 1252, MIMECONTF_MIME_IE4},
    { L"ANSI_X3.4-1986", 1252, 20127, MIMECONTF_MIME_LATEST},
    { L"ANSI_X3.4-1986", 1252, 1252, MIMECONTF_MIME_IE4},
    { L"arabic", 1256, 28596, MIMECONTF_MIME_LATEST},
    { L"arabic", 1256, 1256, MIMECONTF_MIME_IE4},
    { L"ascii", 1252, 20127, MIMECONTF_MIME_LATEST},
    { L"ascii", 1252, 1252, MIMECONTF_MIME_IE4},
    { L"ASMO-708", 1256, 708, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4},
    { L"Big5", 950, 950, MIMECONTF_MIME_LATEST | MIMECONTF_MIME_IE4 },
    { L"chinese", 936, 936, MIMECONTF_MIME_LATEST | MIMECONTF_MIME_IE4  },
    { L"cn-big5", 950, 950, MIMECONTF_MIME_LATEST},
    { L"CN-GB", 936, 936, MIMECONTF_MIME_LATEST },
    { L"CP1026", 1254, 1026, MIMECONTF_MIME_LATEST},
    { L"cp1256", 1256, 1256, MIMECONTF_MIME_LATEST },
    { L"cp367", 1252, 20127, MIMECONTF_MIME_LATEST},
    { L"cp367", 1252, 1252, MIMECONTF_MIME_IE4},
    { L"cp437", 1252, 437, MIMECONTF_MIME_LATEST},
    { L"CP500", 1252, 775, MIMECONTF_MIME_LATEST},
    { L"cp819", 1252, 28591, MIMECONTF_MIME_LATEST},
    { L"cp819", 1252, 1252, MIMECONTF_MIME_IE4},
    { L"cp852", 852, 852, MIMECONTF_MIME_LATEST | MIMECONTF_MIME_IE4  },
    { L"cp866", 866, 866, MIMECONTF_MIME_LATEST | MIMECONTF_MIME_IE4  },
    { L"CP870", 1250, 870, MIMECONTF_MIME_LATEST},
    { L"csASCII", 1252, 20127, MIMECONTF_MIME_LATEST},
    { L"csASCII", 1252, 1252, MIMECONTF_MIME_IE4},
    { L"csbig5", 950, 950, MIMECONTF_MIME_LATEST | MIMECONTF_MIME_IE4 },
    { L"csEUCKR", 949, 51949, MIMECONTF_MIME_LATEST },
    { L"csEUCPkdFmtJapanese", 932, 51932, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4 },
    { L"csGB2312", 936, 936, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4 },
    { L"csGB231280", 936, 936, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4 },
    { L"csISO2022JP", 932, 50221, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4 },
    { L"csISO2022KR", 949, 50225, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4 },
    { L"csISO58GB231280", 936, 936, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4 },
    { L"csISOLatin1", 1252, 28591, MIMECONTF_MIME_LATEST},
    { L"csISOLatin2", 1250, 28592, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4 },
    { L"csISOLatin3", 1254, 28593, MIMECONTF_MIME_LATEST},
    { L"csISOLatin4", 1257, 28594, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4 },
    { L"csISOLatin5", 1254, 28599, MIMECONTF_MIME_LATEST },
    { L"csISOLatin5", 1251, 28595, MIMECONTF_MIME_IE4},
    { L"csISOLatin9", 1252, 28605, MIMECONTF_MIME_LATEST },
    { L"csISOLatinArabic", 1256, 28596, MIMECONTF_MIME_LATEST},
    { L"csISOLatinArabic", 1256, 1256, MIMECONTF_MIME_IE4},
    { L"csISOLatinCyrillic", 1251, 28595, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4 },
    { L"csISOLatinGreek",  1253, 28597, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4 },
    { L"csISOLatinHebrew", 1255, 28598, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4 },
    { L"csKOI8R", 1251, 20866, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4 },
    { L"csKSC56011987", 949, 949, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4 },
    { L"csPC8CodePage437", 1252, 437, MIMECONTF_MIME_LATEST},
    { L"csShiftJIS", 932, 932, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4 },
    { L"csUnicode11UTF7", 1200, 65000, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4 },
    { L"csWindows31J", 932, 932, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4 },
    { L"cyrillic", 1251, 28595, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4 },
    { L"DIN_66003", 1252, 20106, MIMECONTF_MIME_LATEST},
    { L"DOS-720", 1256, 720, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4},
    { L"DOS-862", 1255, 862, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4},
    { L"DOS-874", 874, 874, MIMECONTF_MIME_LATEST},
    { L"ebcdic-cp-us", 1252, 37, MIMECONTF_MIME_LATEST},
    { L"ECMA-114", 1256, 28596, MIMECONTF_MIME_LATEST},
    { L"ECMA-114", 1256, 1256, MIMECONTF_MIME_IE4},
    { L"ECMA-118",  1253, 28597, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4 },
    { L"ELOT_928",  1253, 28597, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4 },
    { L"euc-cn", 936, 51936, MIMECONTF_MIME_LATEST},
    { L"euc-jp", 932, 51932, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4 },
    { L"euc-kr", 949, 51949, MIMECONTF_MIME_LATEST },
    { L"euc-kr", 949, 949, MIMECONTF_MIME_IE4 },
    { L"Extended_UNIX_Code_Packed_Format_for_Japanese", 932, 51932, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4 },
    { L"GB_2312-80", 936, 936, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4 },
    { L"GB2312", 936, 936, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4},
    { L"GB231280", 936, 936, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4},
    { L"GB2312-80", 936, 936, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4},
    { L"GBK", 936, 936, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4 },
    { L"German", 1252, 20106, MIMECONTF_MIME_LATEST},
    { L"greek",  1253, 28597, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4 },
    { L"greek8",  1253, 28597, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4 },
    { L"hebrew", 1255, 28598, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4 },
    { L"hz-gb-2312", 936, 52936, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4},
    { L"IBM367", 1252, 20127, MIMECONTF_MIME_LATEST},
    { L"IBM367", 1252, 1252, MIMECONTF_MIME_IE4},
    { L"IBM437", 1252, 437, MIMECONTF_MIME_LATEST},
    { L"ibm737", 1252, 737, MIMECONTF_MIME_LATEST},
    { L"ibm775", 1257, 775, MIMECONTF_MIME_LATEST},
    { L"ibm819", 1252, 28591, MIMECONTF_MIME_LATEST},
    { L"ibm819", 1252, 1252, MIMECONTF_MIME_IE4},
    { L"ibm850", 1252, 850, MIMECONTF_MIME_LATEST},
    { L"ibm852", 852, 852, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4},
    { L"ibm857", 1254, 857, MIMECONTF_MIME_LATEST},
    { L"ibm861", 1252, 861, MIMECONTF_MIME_LATEST},
    { L"ibm866", 866, 866, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4},
    { L"ibm869", 1253, 869, MIMECONTF_MIME_LATEST},
    { L"irv", 1252, 20105, MIMECONTF_MIME_LATEST},
    { L"ISO_646.irv:1991", 1252, 20127, MIMECONTF_MIME_LATEST},
    { L"ISO_646.irv:1991", 1252, 1252,  MIMECONTF_MIME_IE4},
    { L"iso_8859-1", 1252, 28591, MIMECONTF_MIME_LATEST},
    { L"iso_8859-1", 1252, 1252,  MIMECONTF_MIME_IE4 },
    { L"iso_8859-1:1987", 1252, 28591, MIMECONTF_MIME_LATEST },
    { L"iso_8859-1:1987", 1252, 1252, MIMECONTF_MIME_IE4 },
    { L"ISO_8859-15", 1252, 28605, MIMECONTF_MIME_LATEST},
    { L"iso_8859-2", 1250, 28592, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4 },
    { L"iso_8859-2:1987", 1250, 28592, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4 },
    { L"ISO_8859-3", 1254, 28593, MIMECONTF_MIME_LATEST},
    { L"ISO_8859-3:1988", 1254, 28593, MIMECONTF_MIME_LATEST},
    { L"ISO_8859-4", 1257, 28594, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4 },
    { L"ISO_8859-4:1988", 1257, 28594, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4 },
    { L"ISO_8859-5", 1251, 28595, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4 },
    { L"ISO_8859-5:1988", 1251, 28595, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4 },
    { L"ISO_8859-6", 1256, 28596, MIMECONTF_MIME_LATEST},
    { L"ISO_8859-6", 1256, 1256, MIMECONTF_MIME_IE4},
    { L"ISO_8859-6:1987", 1256, 28596, MIMECONTF_MIME_LATEST},
    { L"ISO_8859-6:1987", 1256, 1256, MIMECONTF_MIME_IE4},
    { L"ISO_8859-7",  1253, 28597, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4 },
    { L"ISO_8859-7:1987",  1253, 28597, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4 },
    { L"ISO_8859-8", 1255, 28598, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4 },
    { L"ISO_8859-8:1988", 1255, 28598, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4 },
    { L"ISO_8859-8-I", 1255, 1255, MIMECONTF_MIME_IE4 },
    { L"ISO_8859-9", 1254, 28599, MIMECONTF_MIME_LATEST},
    { L"ISO_8859-9", 1254, 1254, MIMECONTF_MIME_IE4 },
    { L"ISO_8859-9:1989", 1254, 28599, MIMECONTF_MIME_LATEST},
    { L"ISO_8859-9:1989", 1254, 1254, MIMECONTF_MIME_IE4 },
    { L"iso-2022-jp", 932, 50220, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4},
    { L"iso-2022-jpeuc", 932, 51932, MIMECONTF_MIME_LATEST},
    { L"iso-2022-kr", 949, 50225, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4},
    { L"iso-2022-kr-7", 949, 50225, MIMECONTF_MIME_LATEST},
    { L"iso-2022-kr-7bit", 949, 50225, MIMECONTF_MIME_LATEST},
    { L"iso-2022-kr-8", 949, 51949, MIMECONTF_MIME_LATEST },
    { L"iso-2022-kr-8bit", 949, 51949, MIMECONTF_MIME_LATEST },
    { L"ISO646-US", 1252, 20127, MIMECONTF_MIME_LATEST },
    { L"ISO646-US", 1252, 1252, MIMECONTF_MIME_IE4},
    { L"iso8859-1", 1252, 28591, MIMECONTF_MIME_LATEST },
    { L"iso8859-1", 1252, 1252, MIMECONTF_MIME_IE4 },
    { L"iso-8859-1", 1252, 28591, MIMECONTF_MIME_LATEST},
    { L"iso-8859-1", 1252, 1252, MIMECONTF_MIME_IE4},
    { L"iso-8859-11", 874, 874, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4},
    { L"iso-8859-15", 1252, 28605, MIMECONTF_MIME_LATEST},
    { L"iso8859-2", 1250, 28592, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4 },
    { L"iso-8859-2", 1250, 28592, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4},
    { L"iso-8859-3", 1254, 28593, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4},
    { L"iso-8859-4", 1257, 28594, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4},
    { L"iso-8859-5", 1251, 28595, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4},
    { L"iso-8859-6", 1256, 28596, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4},
    { L"iso-8859-7", 1253, 28597, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4},
    { L"iso-8859-8", 1255, 28598, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4},
    { L"ISO-8859-8 Visual", 1255, 28598, MIMECONTF_MIME_LATEST},
    { L"ISO-8859-8 Visual", 1255, 1255, MIMECONTF_MIME_IE4},
    { L"iso-8859-8-i", 1255, 38598, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4},
    { L"iso-8859-9", 1254, 28599, MIMECONTF_MIME_LATEST},
    { L"iso-8859-9", 1254, 1254, MIMECONTF_MIME_IE4 },
    { L"iso-ir-100", 1252, 28591, MIMECONTF_MIME_LATEST},
    { L"iso-ir-100", 1252, 1252, MIMECONTF_MIME_IE4 },
    { L"iso-ir-101", 1250, 28592, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4 },
    { L"iso-ir-109", 1254, 28593, MIMECONTF_MIME_LATEST},
    { L"iso-ir-110", 1257, 28594, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4 },
    { L"iso-ir-126",  1253, 28597, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4 },
    { L"iso-ir-127", 1256, 28596, MIMECONTF_MIME_LATEST },
    { L"iso-ir-127", 1256, 1256, MIMECONTF_MIME_IE4},
    { L"iso-ir-138", 1255, 28598, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4 },
    { L"iso-ir-144", 1251, 28595, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4 },
    { L"iso-ir-148", 1254, 28599, MIMECONTF_MIME_LATEST},
    { L"iso-ir-148", 1254, 1254, MIMECONTF_MIME_IE4 },
    { L"iso-ir-149", 949, 949, MIMECONTF_MIME_LATEST},
    { L"iso-ir-58", 936, 936, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4 },
    { L"iso-ir-6", 1252, 20127, MIMECONTF_MIME_LATEST},
    { L"iso-ir-6", 1252, 1252, MIMECONTF_MIME_IE4},
    { L"Johab", 1361, 1361, MIMECONTF_MIME_LATEST},
    { L"koi", 1251, 20866, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4 },
    { L"koi8", 1251, 20866, MIMECONTF_MIME_LATEST},
    { L"koi8r", 1251, 20866, MIMECONTF_MIME_LATEST},
    { L"koi8-r", 1251, 20866, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4},
    { L"koi8-ru", 1251, 21866, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4},
    { L"koi8-u", 1251, 21866, MIMECONTF_MIME_LATEST},
    { L"korean", 949, 949, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4 },
    { L"ks_c_5601", 949, 949, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4 },
    { L"ks_c_5601_1987", 949, 949, MIMECONTF_MIME_LATEST},
    { L"ks_c_5601-1987", 949, 949, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4},
    { L"ks_c_5601-1989", 949, 949, MIMECONTF_MIME_LATEST},
    { L"KSC_5601", 949, 949, MIMECONTF_MIME_LATEST},
    { L"KSC5601", 949, 949, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4 },
    { L"ks-c5601", 949, 949, MIMECONTF_MIME_LATEST},
    { L"ks-c-5601", 949, 949, MIMECONTF_MIME_LATEST},
    { L"l1", 1252, 28591, MIMECONTF_MIME_LATEST},
    { L"l2", 1250, 28592, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4 },
    { L"l3", 1254, 28593, MIMECONTF_MIME_LATEST},
    { L"l4", 1257, 28594, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4 },
    { L"l5", 1254, 28599, MIMECONTF_MIME_LATEST },
    { L"l5", 1251, 28595, MIMECONTF_MIME_IE4 },
    { L"l9", 1252, 28605, MIMECONTF_MIME_LATEST },
    { L"latin1", 1252, 28591, MIMECONTF_MIME_LATEST },
    { L"latin1", 1252, 1252,  MIMECONTF_MIME_IE4 },
    { L"latin2", 1250, 28592, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4 },
    { L"latin3", 1254, 28593, MIMECONTF_MIME_LATEST},
    { L"latin4", 1257, 28594, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4 },
    { L"latin5", 1254, 28599, MIMECONTF_MIME_LATEST},
    { L"latin5", 1254, 1254, MIMECONTF_MIME_IE4},
    { L"latin9", 1252, 28605, MIMECONTF_MIME_LATEST},
    { L"logical", 1255, 28598, MIMECONTF_MIME_LATEST},
    { L"logical", 1255, 1255, MIMECONTF_MIME_IE4},
    { L"macintosh", 1252, 10000, MIMECONTF_MIME_LATEST},
    { L"ms_Kanji", 932, 932, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4 },
    { L"Norwegian", 1252, 20108, MIMECONTF_MIME_LATEST},
    { L"NS_4551-1", 1252, 20108, MIMECONTF_MIME_LATEST},
    { L"SEN_850200_B", 1252, 20107, MIMECONTF_MIME_LATEST},
    { L"shift_jis", 932, 932, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4},
    { L"shift-jis", 932, 932, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4 },
    { L"sjis", 932, 932, MIMECONTF_MIME_LATEST},
    { L"Swedish", 1252, 20107, MIMECONTF_MIME_LATEST},
    { L"TIS-620", 874, 874, MIMECONTF_MIME_LATEST},
    { L"unicode", 1200, 1200, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4 },
    { L"unicode-1-1-utf-7", 1200, 65000, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4},
    { L"unicode-1-1-utf-8", 1200, 65001, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4},
    { L"unicode-2-0-utf-7", 1200, 65000, MIMECONTF_MIME_LATEST},
    { L"unicode-2-0-utf-8",1200, 65001, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4 },
    { L"unicodeFFFE", 1200, 1201, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4 },
    { L"us", 1252, 20127, MIMECONTF_MIME_LATEST},
    { L"us", 1252, 1252, MIMECONTF_MIME_IE4},
    { L"us-ascii", 1252, 20127, MIMECONTF_MIME_LATEST},
    { L"us-ascii", 1252, 1252, MIMECONTF_MIME_IE4},
    { L"utf-16", 1200, 1200, MIMECONTF_MIME_LATEST },
    { L"utf-7", 1200, 65000, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4 },
    { L"utf-8", 1200, 65001, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4 },
    { L"visual", 1255, 28598, MIMECONTF_MIME_LATEST},
    { L"visual", 1255, 1255, MIMECONTF_MIME_IE4 },
    { L"windows-1250", 1250, 1250, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4 },
    { L"windows-1251", 1251, 1251, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4 },
    { L"windows-1252", 1252, 1252, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4 },
    { L"windows-1253", 1253, 1253, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4 },
    { L"Windows-1254", 1254, 1254, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4 },
    { L"windows-1255", 1255, 1255, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4 },
    { L"windows-1256", 1256, 1256, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4 },
    { L"windows-1257", 1257, 1257, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4 },
    { L"windows-1258", 1258, 1258, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4 },
    { L"windows-874", 874, 874, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4 },
    { L"x-ansi", 1252, 1252, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4 },
    { L"x-Chinese-CNS", 950, 20000, MIMECONTF_MIME_LATEST},
    { L"x-Chinese-Eten", 950, 20002, MIMECONTF_MIME_LATEST},
    { L"x-cp1250", 1250, 1250, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4 },
    { L"x-cp1251", 1251, 1251, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4 },
    { L"X-EBCDIC-Arabic", 1256, 20420, MIMECONTF_MIME_LATEST},
    { L"x-ebcdic-cp-us-euro", 1252, 1140, MIMECONTF_MIME_LATEST},
    { L"X-EBCDIC-CyrillicRussian", 1251, 20880, MIMECONTF_MIME_LATEST},
    { L"X-EBCDIC-CyrillicSerbianBulgarian", 1251, 21025, MIMECONTF_MIME_LATEST},
    { L"X-EBCDIC-DenmarkNorway", 1252, 20277, MIMECONTF_MIME_LATEST},
    { L"x-ebcdic-denmarknorway-euro", 1252, 1142, MIMECONTF_MIME_LATEST},
    { L"X-EBCDIC-FinlandSweden", 1252, 20278, MIMECONTF_MIME_LATEST},
    { L"x-ebcdic-finlandsweden-euro", 1252, 1143, MIMECONTF_MIME_LATEST},
    { L"X-EBCDIC-France", 1252, 202297, MIMECONTF_MIME_LATEST},
    { L"x-ebcdic-france-euro", 1252, 1147, MIMECONTF_MIME_LATEST},
    { L"X-EBCDIC-Germany", 1252, 20273, MIMECONTF_MIME_LATEST},
    { L"x-ebcdic-germany-euro", 1252, 1141, MIMECONTF_MIME_LATEST},
    { L"X-EBCDIC-Greek", 1253, 20423, MIMECONTF_MIME_LATEST},
    { L"x-EBCDIC-GreekModern", 1253, 875, MIMECONTF_MIME_LATEST},
    { L"X-EBCDIC-Hebrew", 1255, 20424, MIMECONTF_MIME_LATEST},
    { L"X-EBCDIC-Icelandic", 1252, 20871, MIMECONTF_MIME_LATEST},
    { L"x-ebcdic-icelandic-euro", 1252, 1149, MIMECONTF_MIME_LATEST},
    { L"x-ebcdic-international-euro", 1252, 1148, MIMECONTF_MIME_LATEST},
    { L"X-EBCDIC-Italy", 1252, 20280, MIMECONTF_MIME_LATEST},
    { L"x-ebcdic-italy-euro", 1252, 1144, MIMECONTF_MIME_LATEST},
    { L"X-EBCDIC-JapaneseAndJapaneseLatin", 932, 50939, MIMECONTF_MIME_LATEST},
    { L"X-EBCDIC-JapaneseAndKana", 932, 50930, MIMECONTF_MIME_LATEST},
    { L"X-EBCDIC-JapaneseAndUSCanada", 932, 50931, MIMECONTF_MIME_LATEST},
    { L"X-EBCDIC-JapaneseKatakana", 932, 20290, MIMECONTF_MIME_LATEST},
    { L"X-EBCDIC-KoreanAndKoreanExtended", 949, 50933, MIMECONTF_MIME_LATEST},
    { L"X-EBCDIC-KoreanExtended", 949, 20833, MIMECONTF_MIME_LATEST},
    { L"X-EBCDIC-SimplifiedChinese", 936, 50935, MIMECONTF_MIME_LATEST},
    { L"X-EBCDIC-Spain", 1252, 20284, MIMECONTF_MIME_LATEST},
    { L"x-ebcdic-spain-euro", 1252, 1145, MIMECONTF_MIME_LATEST},
    { L"X-EBCDIC-Thai", 874, 20838, MIMECONTF_MIME_LATEST},
    { L"X-EBCDIC-TraditionalChinese", 950, 50937, MIMECONTF_MIME_LATEST},
    { L"X-EBCDIC-Turkish", 1254, 20905, MIMECONTF_MIME_LATEST},
    { L"X-EBCDIC-UK", 1252, 20285, MIMECONTF_MIME_LATEST},
    { L"x-ebcdic-uk-euro", 1252, 1146, MIMECONTF_MIME_LATEST},
    { L"x-euc", 932, 51932, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4 },
    { L"x-euc-cn", 936, 51936, MIMECONTF_MIME_LATEST},
    { L"x-euc-jp", 932, 51932, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4 },
    { L"x-Europa", 1252, 29001, MIMECONTF_MIME_LATEST},
    { L"x-IA5", 1252, 20105, MIMECONTF_MIME_LATEST},
    { L"x-IA5-German", 1252, 20106, MIMECONTF_MIME_LATEST},
    { L"x-IA5-Norwegian", 1252, 20108, MIMECONTF_MIME_LATEST},
    { L"x-IA5-Swedish", 1252, 20107, MIMECONTF_MIME_LATEST},
    { L"x-iscii-as", 57006, 57006, MIMECONTF_MIME_LATEST},
    { L"x-iscii-be", 57003, 57003, MIMECONTF_MIME_LATEST},
    { L"x-iscii-de", 57002, 57002, MIMECONTF_MIME_LATEST},
    { L"x-iscii-gu", 57010, 57010, MIMECONTF_MIME_LATEST},
    { L"x-iscii-ka", 57008, 57008, MIMECONTF_MIME_LATEST},
    { L"x-iscii-ma", 57009, 57009, MIMECONTF_MIME_LATEST},
    { L"x-iscii-or", 57007, 57007, MIMECONTF_MIME_LATEST},
    { L"x-iscii-pa", 57011, 57011, MIMECONTF_MIME_LATEST},
    { L"x-iscii-ta", 57004, 57004, MIMECONTF_MIME_LATEST},
    { L"x-iscii-te", 57005, 57005, MIMECONTF_MIME_LATEST},
    { L"x-mac-arabic", 1256, 10004, MIMECONTF_MIME_LATEST},
    { L"x-mac-ce", 1250, 10029, MIMECONTF_MIME_LATEST},
    { L"x-mac-chinesesimp", 936, 10008, MIMECONTF_MIME_LATEST},
    { L"x-mac-chinesetrad", 950, 10002, MIMECONTF_MIME_LATEST},
    { L"x-mac-cyrillic", 1251, 10007, MIMECONTF_MIME_LATEST},
    { L"x-mac-greek", 1253, 10006, MIMECONTF_MIME_LATEST},
    { L"x-mac-hebrew", 1255, 10005, MIMECONTF_MIME_LATEST},
    { L"x-mac-icelandic", 1252, 10079, MIMECONTF_MIME_LATEST},
    { L"x-mac-japanese", 932, 10001, MIMECONTF_MIME_LATEST},
    { L"x-mac-korean", 949, 10003, MIMECONTF_MIME_LATEST},
    { L"x-mac-turkish", 1254, 10081, MIMECONTF_MIME_LATEST},
    { L"x-ms-cp932", 932, 932, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4 },
    { L"x-sjis", 932, 932, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4 },
    { L"x-unicode-1-1-utf-7", 1200, 65000, MIMECONTF_MIME_LATEST},
    { L"x-unicode-1-1-utf-8", 1200, 65001, MIMECONTF_MIME_LATEST},
    { L"x-unicode-2-0-utf-7", 1200, 65000, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4},
    { L"x-unicode-2-0-utf-8", 1200, 65001, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4},
    { L"x-user-defined", 50000, 50000, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4},
    { L"x-x-big5", 950, 950, MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4},

//  { Charset, CodePage, InternetEncoding, Flags }
};

// Hard code sorted table by code page description and family code page.

MIMECODEPAGE MimeCodePage[] =
{
//  { CodePage, HeaderCharset, BodyCharset, WebCharset, FixedWidthFont, ProportionalFont, Description, FamilyCodePage, Flags }
    { 708, NULL, L"ASMO-708", NULL, 0, 0, IDS_DESC_708, 1256, 0x00000606|MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 708, NULL, L"ASMO-708", NULL, 0, 0, IDS_DESC_708, 1256, 0x00000707|MIMECONTF_MIME_IE4|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 51256, NULL, L"_autodetect_arabic", L"windows-1256", 0,  0, IDS_DESC_51256, 1256, MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT },
    { 720, NULL, L"DOS-720", NULL, 0, 0, IDS_DESC_720, 1256, 0x00000606|MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 720, NULL, L"DOS-720", NULL, 0, 0, IDS_DESC_720, 1256, 0x00000707|MIMECONTF_MIME_IE4|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 28596, NULL, L"iso-8859-6", NULL, 0, 0, IDS_DESC_28596, 1256, 0x00000707|MIMECONTF_MIME_LATEST|MIMECONTF_MIME_IE4|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 10004, NULL, L"x-mac-arabic", NULL, 0, 0, IDS_DESC_10004, 1256, MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 1256, NULL, L"windows-1256", NULL, IDS_FONT_ARABIC_FIXED, IDS_FONT_ARABIC_PROP, IDS_DESC_1256, 0, 0x00000303|MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 1256, NULL, L"windows-1256", L"windows-1256", IDS_FONT_WESTERN_FIXED, IDS_FONT_WESTERN_PROP, IDS_DESC_1256, 0, 0x00000707| MIMECONTF_MIME_IE4},
    { 50001, NULL, L"_autodetect_all", NULL, 0, 0, IDS_DESC_50001, 0, 0x00000007|MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT},
    { 775, NULL, L"ibm775", NULL, 0, 0, IDS_DESC_775, 1257, MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 28594, NULL, L"iso-8859-4", NULL, 0, 0, IDS_DESC_28594, 1257, 0x00000303|MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT},
    { 28594, NULL, L"iso-8859-4", NULL, 0, 0, IDS_DESC_28594, 1257, 0x00000301|MIMECONTF_MIME_IE4|MIMECONTF_IMPORT|MIMECONTF_EXPORT},
    { 1257, L"windows-1257", L"iso-8859-4", L"windows-1257", IDS_FONT_WESTERN_FIXED, IDS_FONT_WESTERN_PROP, IDS_DESC_1257, 0, 0x00000707|MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 1257, NULL, L"iso-8859-4", L"windows-1257", IDS_FONT_WESTERN_FIXED, IDS_FONT_WESTERN_PROP, IDS_DESC_1257, 0, 0x00000707|MIMECONTF_MIME_IE4|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 852, NULL, L"ibm852", NULL, 0, 0, IDS_DESC_852, 1250, 0x00000202|MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 28592, NULL, L"iso-8859-2", NULL, 0, 0, IDS_DESC_28592, 1250, 0x00000707|MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 10029, NULL, L"x-mac-ce", NULL, 0, 0, IDS_DESC_10029, 1250, MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 1250, L"windows-1250", L"iso-8859-2", L"windows-1250", IDS_FONT_WESTERN_FIXED, IDS_FONT_WESTERN_PROP, IDS_DESC_1250, 0, 0x00000303|MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 1250, NULL, L"iso-8859-2", L"windows-1250", IDS_FONT_WESTERN_FIXED, IDS_FONT_WESTERN_PROP, IDS_DESC_1250, 0, 0x00000303|MIMECONTF_MIME_IE4|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 50936, NULL, L"_autodetect_chs", NULL, 0, 0, IDS_DESC_50936, 936, MIMECONTF_MIME_LATEST| MIMECONTF_IMPORT },
    { 51936, NULL, L"EUC-CN", NULL, 0, 0, IDS_DESC_51936, 936, 0x00000000|MIMECONTF_MIME_LATEST|MIMECONTF_EXPORT|MIMECONTF_IMPORT},
    { 936, NULL, L"gb2312", NULL, IDS_FONT_CHINESE_FIXED, IDS_FONT_CHINESE_PROP, IDS_DESC_936, 0, 0x00000707|MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 52936, NULL, L"hz-gb-2312", NULL, 0, 0, IDS_DESC_52936, 936, 0x00000303|MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 10008, NULL, L"x-mac-chinesesimp", NULL, 0, 0, IDS_DESC_10008, 936, MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 50950, NULL, L"_autodetect_cht", NULL, 0, 0, IDS_DESC_50950, 950, MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT},
    { 950, NULL, L"big5", NULL, IDS_FONT_TAIWAN_FIXED, IDS_FONT_TAIWAN_PROP, IDS_DESC_950, 0, 0x00000707|MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 20000, NULL, L"x-Chinese-CNS", NULL, 0, 0, IDS_DESC_20000, 950, MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 20002, NULL, L"x-Chinese-Eten", NULL, 0, 0, IDS_DESC_20002, 950, MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 10002, NULL, L"x-mac-chinesetrad", NULL, 0, 0, IDS_DESC_10002, 950, MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 51251, NULL, L"_auto_detect_cyrillic", L"windows-1251", 0, 0, IDS_DESC_51251, 1251, MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT},
    { 866, NULL, L"cp866", NULL, 0, 0, IDS_DESC_866, 1251, 0x00000202|MIMECONTF_MIME_LATEST|MIMECONTF_MIME_IE4|MIMECONTF_IMPORT|MIMECONTF_EXPORT},
    { 28595, NULL, L"iso-8859-5", NULL, 0, 0, IDS_DESC_28595, 1251, 0x00000707|MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4|MIMECONTF_IMPORT|MIMECONTF_EXPORT},
    { 20866, NULL, L"koi8-r", NULL, 0, 0, IDS_DESC_20866, 1251, 0x00000707|MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4|MIMECONTF_IMPORT|MIMECONTF_EXPORT},
    { 21866, NULL, L"koi8-u", NULL, 0, 0, IDS_DESC_21866, 1251, 0x00000707|MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT},
    { 21866, NULL, L"koi8-ru", NULL, 0, 0, IDS_DESC_21866, 1251, 0x00000707|MIMECONTF_MIME_IE4|MIMECONTF_IMPORT|MIMECONTF_EXPORT},
    { 10007, NULL, L"x-mac-cyrillic", NULL, 0, 0, IDS_DESC_10007, 1251, MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 1251, L"windows-1251", L"koi8-r", L"windows-1251", IDS_FONT_WESTERN_FIXED, IDS_FONT_WESTERN_PROP, IDS_DESC_1251, 0, 0x00000303|MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT},
    { 1251, NULL, L"koi8-r", L"windows-1251", IDS_FONT_WESTERN_FIXED, IDS_FONT_WESTERN_PROP, IDS_DESC_1251, 0, 0x00000303|MIMECONTF_MIME_IE4|MIMECONTF_IMPORT|MIMECONTF_EXPORT},
    { 28603, NULL, L"iso-8859-15", NULL, 0, 0, IDS_DESC_28603, 1257, MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 29001, NULL, L"x-Europa", NULL, 0, 0, IDS_DESC_29001, 1252, MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 20106, NULL, L"x-IA5-German", NULL, 0, 0, IDS_DESC_20106, 1252, MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 51253, NULL, L"_auto_detect_greek", L"windows-1253", 0, 0, IDS_DESC_51253, 1253, MIMECONTF_MIME_LATEST| MIMECONTF_IMPORT},
    { 737, NULL, L"ibm737", NULL, 0, 0, IDS_DESC_737, 1253, MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 28597, NULL, L"iso-8859-7", NULL, 0, 0, IDS_DESC_28597, 1253, 0x00000707|MIMECONTF_MIME_LATEST|MIMECONTF_MIME_IE4|MIMECONTF_IMPORT|MIMECONTF_EXPORT},
    { 10006, NULL, L"x-mac-greek", NULL, 0, 0, IDS_DESC_10006, 1253, MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 1253, L"windows-1253", L"iso-8859-7", L"windows-1253", IDS_FONT_WESTERN_FIXED, IDS_FONT_WESTERN_PROP, IDS_DESC_1253, 0, 0x00000303|MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 1253, NULL, L"iso-8859-7", L"windows-1253", IDS_FONT_WESTERN_FIXED, IDS_FONT_WESTERN_PROP, IDS_DESC_1253, 0, 0x00000303|MIMECONTF_MIME_IE4|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 869, NULL, L"ibm869", NULL, 0, 0, IDS_DESC_869, 1253, MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 862, NULL, L"DOS-862", NULL, 0, 0, IDS_DESC_862, 1255, 0x00000606|MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT},
    { 862, NULL, L"DOS-862", NULL, 0, 0, IDS_DESC_862, 1255, 0x00000707|MIMECONTF_MIME_IE4|MIMECONTF_IMPORT|MIMECONTF_EXPORT},
    { 38598, NULL, L"iso-8859-8-i", NULL, 0, 0, IDS_DESC_38598, 1255, 0x00000707|MIMECONTF_MIME_LATEST|MIMECONTF_MIME_IE4|MIMECONTF_IMPORT|MIMECONTF_EXPORT},
    { 28598, NULL, L"iso-8859-8", NULL, 0, 0, IDS_DESC_28598, 1255, 0x00000606|MIMECONTF_MIME_LATEST|MIMECONTF_MIME_IE4|MIMECONTF_IMPORT|MIMECONTF_EXPORT},
    { 10005, NULL, L"x-mac-hebrew", NULL, 0, 0, IDS_DESC_10005, 1255, MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 1255, NULL, L"windows-1255", NULL, IDS_FONT_HEBREW_FIXED, IDS_FONT_HEBREW_PROP, IDS_DESC_1255, 0, 0x00000303|MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT},
    { 1255, NULL, L"iso-8859-8", L"windows-1255", IDS_FONT_WESTERN_FIXED, IDS_FONT_WESTERN_PROP, IDS_DESC_1255, 0, 0x00000707|MIMECONTF_MIME_IE4},
    { 20420, NULL, L"x-EBCDIC-Arabic", NULL, 0, 0, IDS_DESC_20420, 1256, MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 20880, NULL, L"x-EBCDIC-CyrillicRussian", NULL, 0, 0, IDS_DESC_20880, 1251, MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 21025, NULL, L"x-EBCDIC-CyrillicSerbianBulgarian", NULL, 0, 0, IDS_DESC_21025, 1251, MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 20277, NULL, L"x-EBCDIC-DenmarkNorway", NULL, 0, 0, IDS_DESC_20277, 1252, MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 1142, NULL, L"x-ebcdic-denmarknorway-euro", NULL, 0, 0, IDS_DESC_1142, 1252, MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 20278, NULL, L"x-EBCDIC-FinlandSweden", NULL, 0, 0, IDS_DESC_20278, 1252, MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 1143, NULL, L"x-ebcdic-finlandsweden-euro", NULL, 0, 0, IDS_DESC_1143, 1252, MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 20297, NULL, L"x-EBCDIC-France", NULL, 0, 0, IDS_DESC_20297, 1252, MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 1147, NULL, L"x-ebcdic-france-euro", NULL, 0, 0, IDS_DESC_1147, 1252, MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 20273, NULL, L"x-EBCDIC-Germany", NULL, 0, 0, IDS_DESC_20273, 1252, MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 1141, NULL, L"x-ebcdic-germany-euro", NULL, 0, 0, IDS_DESC_1141, 1252, MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 20423, NULL, L"x-EBCDIC-Greek", NULL, 0, 0, IDS_DESC_20423, 1253, MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 875, NULL, L"x-EBCDIC-GreekModern", NULL, 0, 0, IDS_DESC_875, 1253, MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 20424, NULL, L"x-EBCDIC-Hebrew", NULL, 0, 0, IDS_DESC_20424, 1255, MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 20871, NULL, L"x-EBCDIC-Icelandic", NULL, 0, 0, IDS_DESC_20871, 1252, MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 1149, NULL, L"x-ebcdic-icelandic-euro", NULL, 0, 0, IDS_DESC_1149, 1252, MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 500, NULL, L"CP500", NULL, 0, 0, IDS_DESC_500, 1252, MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 1148, NULL, L"x-ebcdic-international-euro", NULL, 0, 0, IDS_DESC_1148, 1252, MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 20280, NULL, L"x-EBCDIC-Italy", NULL, 0, 0, IDS_DESC_20280, 1252, MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 1144, NULL, L"x-ebcdic-italy-euro", NULL, 0, 0, IDS_DESC_1144, 1252, MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 50930, NULL, L"x-EBCDIC-JapaneseAndKana", NULL, 0, 0, IDS_DESC_50930, 932, MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 50939, NULL, L"x-EBCDIC-JapaneseAndJapaneseLatin", NULL, 0, 0, IDS_DESC_50939, 932, MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 50931, NULL, L"x-EBCDIC-JapaneseAndUSCanada", NULL, 0, 0, IDS_DESC_50931, 932, MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 20290, NULL, L"x-EBCDIC-JapaneseKatakana", NULL, 0, 0, IDS_DESC_20290, 932, MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 50933, NULL, L"x-EBCDIC-KoreanAndKoreanExtended", NULL, 0, 0, IDS_DESC_50933, 949, MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 20833, NULL, L"x-EBCDIC-KoreanExtended", NULL, 0, 0, IDS_DESC_20833, 949, MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 870, NULL, L"CP870", NULL, 0, 0, IDS_DESC_870, 1250, MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 50935, NULL, L"x-EBCDIC-SimplifiedChinese", NULL, 0, 0, IDS_DESC_50935, 936, MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 20284, NULL, L"X-EBCDIC-Spain", NULL, 0, 0, IDS_DESC_20284, 1252, MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 1145, NULL, L"x-ebcdic-spain-euro", NULL, 0, 0, IDS_DESC_1145, 1252, MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 20838, NULL, L"x-EBCDIC-Thai", NULL, 0, 0, IDS_DESC_20838, 874, MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 50937, NULL, L"x-EBCDIC-TraditionalChinese", NULL, 0, 0, IDS_DESC_50937, 950, MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 20905, NULL, L"x-EBCDIC-Turkish", NULL, 0, 0, IDS_DESC_20905, 1254, MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 1026, NULL, L"CP1026", NULL, 0, 0, IDS_DESC_1026, 1254, MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT },    
    { 20285, NULL, L"x-EBCDIC-UK", NULL, 0, 0, IDS_DESC_20285, 1252, MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT },    
    { 1146, NULL, L"x-ebcdic-uk-euro", NULL, 0, 0, IDS_DESC_1146, 1252, MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 37, NULL, L"ebcdic-cp-us", NULL, 0, 0, IDS_DESC_37, 1252, MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 1140, NULL, L"x-ebcdic-cp-us-euro", NULL, 0, 0, IDS_DESC_1140, 1252, MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 861, NULL, L"ibm861", NULL, 0, 0, IDS_DESC_861, 1252, MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 10079, NULL, L"x-mac-icelandic", NULL, 0, 0, IDS_DESC_10079, 1252, MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 57006, NULL, L"x-iscii-as", NULL, 0, 0, IDS_DESC_57006, 0, MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 57003, NULL, L"x-iscii-be", NULL, 0, 0, IDS_DESC_57003, 0, MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 57002, NULL, L"x-iscii-de", NULL, IDS_FONT_DEVANAGARI_FIXED, IDS_FONT_DEVANAGARI_PROP, IDS_DESC_57002, 0, MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 57010, NULL, L"x-iscii-gu", NULL, 0, 0, IDS_DESC_57010, 0, MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 57008, NULL, L"x-iscii-ka", NULL, 0, 0, IDS_DESC_57008, 0, MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 57009, NULL, L"x-iscii-ma", NULL, 0, 0, IDS_DESC_57009, 0, MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 57007, NULL, L"x-iscii-or", NULL, 0, 0, IDS_DESC_57007, 0, MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 57011, NULL, L"x-iscii-pa", NULL, 0, 0, IDS_DESC_57011, 0, MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 57004, NULL, L"x-iscii-ta", NULL, IDS_FONT_TAMIL_FIXED, IDS_FONT_TAMIL_PROP, IDS_DESC_57004, 0, MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 57005, NULL, L"x-iscii-te", NULL, 0, 0, IDS_DESC_57005, 0, MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 50932, NULL, L"_autodetect", NULL, 0, 0, IDS_DESC_50932, 932, 0x00000007|MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4|MIMECONTF_IMPORT},
    { 51932, NULL, L"euc-jp", NULL, 0, 0, IDS_DESC_51932, 932, 0x00000707|MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4|MIMECONTF_IMPORT|MIMECONTF_EXPORT},
    { 50220, NULL, L"iso-2022-jp", NULL, 0, 0, IDS_DESC_50220, 932, 0x00000101|MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4|MIMECONTF_IMPORT|MIMECONTF_EXPORT},
    { 50221, NULL, L"iso-2022-jp", L"csISO2022JP", 0, 0, IDS_DESC_50221, 932, 0x00000301|MIMECONTF_MIME_LATEST|MIMECONTF_EXPORT},
    { 50221, NULL, L"_iso-2022-jp$ESC", L"csISO2022JP", 0, 0, IDS_DESC_50221, 932, 0x00000301|MIMECONTF_MIME_IE4|MIMECONTF_EXPORT},
    { 50222, NULL, L"iso-2022-jp", NULL, 0, 0, IDS_DESC_50222, 932, MIMECONTF_MIME_LATEST|MIMECONTF_EXPORT},
    { 50222, NULL, L"_iso-2022-jp$SIO", L"iso-2022-jp", 0, 0, IDS_DESC_50222, 932, MIMECONTF_MIME_IE4|MIMECONTF_EXPORT},
    { 10001, NULL, L"x-mac-japanese", NULL, 0, 0, IDS_DESC_10001, 932, MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 932, NULL, L"iso-2022-jp", L"shift_jis", IDS_FONT_JAPANESE_FIXED, IDS_FONT_JAPANESE_PROP, IDS_DESC_932, 0, 0x00000707|MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4|MIMECONTF_IMPORT|MIMECONTF_EXPORT},
    { 949, NULL, L"ks_c_5601-1987", NULL, IDS_FONT_KOREAN_FIXED, IDS_FONT_KOREAN_PROP, IDS_DESC_949, 0, 0x00000707|MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT},
    { 949, L"euc-kr", L"euc-kr", L"ks_c_5601-1987", IDS_FONT_KOREAN_FIXED4, IDS_FONT_KOREAN_PROP4, IDS_DESC_949, 0, 0x00000707| MIMECONTF_MIME_IE4|MIMECONTF_IMPORT|MIMECONTF_EXPORT},
    { 50949, NULL, L"_autodetect_kr", NULL, 0, 0, IDS_DESC_50949, 949, 0x00000001|MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4|MIMECONTF_IMPORT},
    { 51949, NULL, L"euc-kr", NULL, 0, 0, IDS_DESC_51949, 949, 0x00000000|MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT|MIMECONTF_MAILNEWS|MIMECONTF_SAVABLE_MAILNEWS},
    { 51949, NULL, L"euc-kr", NULL, 0, 0, IDS_DESC_51949, 949, 0x00000000| MIMECONTF_MIME_IE4|MIMECONTF_IMPORT|MIMECONTF_EXPORT},
    { 50225, L"euc-kr", L"iso-2022-kr", L"iso-2022-kr", 0, 0, IDS_DESC_50225, 949, 0x00000001|MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT},
    { 50225, NULL, L"iso-2022-kr", L"iso-2022-kr", 0, 0, IDS_DESC_50225, 949, 0x00000101| MIMECONTF_MIME_IE4|MIMECONTF_IMPORT|MIMECONTF_EXPORT},
    { 1361, NULL, L"Johab", NULL,IDS_FONT_KOREAN_FIXED, IDS_FONT_KOREAN_PROP, IDS_DESC_1361, 1361, 0x00000000|MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT},
    { 10003, NULL, L"x-mac-korean", NULL, 0, 0, IDS_DESC_10003, 949, MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 28593, NULL, L"iso-8859-3", NULL, 0, 0, IDS_DESC_28593, 1254, 0x00000501|MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4|MIMECONTF_IMPORT|MIMECONTF_EXPORT},
    { 28605, NULL, L"iso-8859-15", NULL, 0, 0, IDS_DESC_28605, 1252, 0x00000701|MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT},
    { 20108, NULL, L"x-IA5-Norwegian", NULL, 0, 0, IDS_DESC_20108, 1252, MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 437, NULL, L"IBM437", NULL, 0, 0, IDS_DESC_437, 1252, 0x00000000|MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT},
    { 20107, NULL, L"x-IA5-Swedish", NULL, 0, 0, IDS_DESC_20107, 1252, MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 874, NULL, L"windows-874", NULL, IDS_FONT_THAI_FIXED, IDS_FONT_THAI_PROP, IDS_DESC_874, 0, 0x00000707|MIMECONTF_MIME_LATEST|MIMECONTF_MIME_IE4|MIMECONTF_IMPORT|MIMECONTF_EXPORT},
    { 857, NULL, L"ibm857", NULL, 0, 0, IDS_DESC_857, 1254, MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 28599, NULL, L"iso-8859-9", NULL, 0, 0, IDS_DESC_28599, 1254, 0x00000707|MIMECONTF_MIME_LATEST| MIMECONTF_IMPORT|MIMECONTF_EXPORT},    
    { 10081, NULL, L"x-mac-turkish", NULL, 0, 0, IDS_DESC_10081, 1254, MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 1254, L"windows-1254", L"iso-8859-9", L"windows-1254", IDS_FONT_WESTERN_FIXED, IDS_FONT_WESTERN_PROP, IDS_DESC_1254, 0, 0x00000707|MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT},
    { 1254, NULL, L"iso-8859-9", L"iso-8859-9", IDS_FONT_WESTERN_FIXED, IDS_FONT_WESTERN_PROP, IDS_DESC_1254, 0, 0x00000707|MIMECONTF_MIME_IE4|MIMECONTF_IMPORT|MIMECONTF_EXPORT},
    { 1200, NULL, L"unicode", NULL, IDS_FONT_WESTERN_FIXED, IDS_FONT_WESTERN_PROP, IDS_DESC_1200, 0, 0x00000204|MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4|MIMECONTF_IMPORT|MIMECONTF_EXPORT},
    { 1201, NULL, L"unicodeFFFE",   NULL, 0, 0, IDS_DESC_1201, 1200, 0x00000000|MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4|MIMECONTF_IMPORT|MIMECONTF_EXPORT},
    { 65000, NULL, L"utf-7", NULL, 0, 0, IDS_DESC_65000, 1200, 0x00000101|MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4|MIMECONTF_IMPORT|MIMECONTF_EXPORT},
    { 65001, NULL, L"utf-8", NULL, 0, 0, IDS_DESC_65001, 1200, 0x00000303|MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4|MIMECONTF_IMPORT|MIMECONTF_EXPORT},
    { 20127, NULL, L"us-ascii", NULL, 0, 0, IDS_DESC_20127, 1252, MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT|MIMECONTF_MAILNEWS|MIMECONTF_SAVABLE_MAILNEWS},
    { 50000, NULL, L"x-user-defined", NULL, IDS_FONT_WESTERN_FIXED, IDS_FONT_UNICODE_PROP, IDS_DESC_50000, 0, 0x00000707|MIMECONTF_MIME_LATEST| MIMECONTF_MIME_IE4|MIMECONTF_IMPORT|MIMECONTF_EXPORT},
    { 1258, NULL, L"windows-1258", NULL, IDS_FONT_WESTERN_FIXED, IDS_FONT_WESTERN_PROP, IDS_DESC_1258, 0, 0x00000303|MIMECONTF_MIME_LATEST|MIMECONTF_MIME_IE4|MIMECONTF_IMPORT|MIMECONTF_EXPORT},
    { 1252, NULL, L"iso-8859-1", NULL, IDS_FONT_WESTERN_FIXED, IDS_FONT_WESTERN_PROP, IDS_DESC_1252_IE4, 0, 0x00000707| MIMECONTF_MIME_IE4},
    { 850, NULL, L"ibm850", NULL, 0, 0, IDS_DESC_850, 1252, MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 20105, NULL, L"x-IA5", NULL, 0, 0, IDS_DESC_20105, 1252, MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 28591, NULL, L"iso-8859-1", NULL, 0, 0, IDS_DESC_28591, 1252, 0x00000703|MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT},
    { 10000, NULL, L"macintosh", NULL, 0, 0, IDS_DESC_10000, 1252, MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT },
    { 1252, L"Windows-1252", L"iso-8859-1", L"Windows-1252", IDS_FONT_WESTERN_FIXED, IDS_FONT_WESTERN_PROP, IDS_DESC_1252, 0, 0x00000707|MIMECONTF_MIME_LATEST|MIMECONTF_IMPORT|MIMECONTF_EXPORT},
    { 0, 0, 0, 0, 0, 0, 0, 0, 0},
//  { CodePage, HeaderCharset, BodyCharset, WebCharset, FixedWidthFont, ProportionalFont, Description, FamilyCodePage, Flags }

}; 


#ifdef UNIX
/* Convert from little endian to big endian format */
#define CONVERTLONG(a,b,c,d) (((unsigned long )a) + \
                           ((unsigned long )b << 8) + \
                           ((unsigned long )c << 16) + \
                           ((unsigned long )d << 24))
#endif /* UNIX */

//
//  Globals
//
CMimeDatabase *g_pMimeDatabase = NULL;

//
//  CMimeDatabase implementation
//
STDAPI CMimeDatabase::GetNumberOfCodePageInfo(UINT *pcCodePage)
{
    HRESULT hr = S_OK;
    if (pcCodePage)
    {
        *pcCodePage = 0;
        for (int i=0;i<ARRAYSIZE(MimeCodePage);i++)
        {
            if (MimeCodePage[i].dwFlags & dwMimeSource)
               (*pcCodePage)++;
        }
    }
    else
        hr = E_INVALIDARG;
    return hr;
}

STDAPI CMimeDatabase::GetCodePageInfo(UINT uiCodePage, LANGID LangId, PMIMECPINFO pcpInfo )
{
    int idx;
    HRESULT hr = E_FAIL;

    DebugMsg(DM_TRACE, TEXT("CMimeDatabase::GetCodePageInfo called."));

    for (idx=0; idx < ARRAYSIZE(MimeCodePage); idx++)
    {
        if ((uiCodePage == MimeCodePage[idx].uiCodePage) &&
            (MimeCodePage[idx].dwFlags & dwMimeSource))
            break;
    }

    if (idx < ARRAYSIZE(MimeCodePage))
    {
        hr = GetCodePageInfoWithIndex(idx, LangId, pcpInfo);
    }

    return hr;
}


STDAPI CMimeDatabase::GetCodePageInfoWithIndex(UINT uidx, LANGID LangId, PMIMECPINFO pcpInfo)
{    
    HRESULT hr = E_FAIL;
    LANGID langid = LangId;
    CHARSETINFO rCharsetInfo;

    DebugMsg(DM_TRACE, TEXT("CMimeDatabase::GetCodePageInfoWithIndex called."));

    if (uidx >= ARRAYSIZE(MimeCodePage))
        return hr;  

    if (!_LoadStringExW(g_hInst, MimeCodePage[uidx].uidDescription, pcpInfo->wszDescription, MAX_MIMECP_NAME, langid))
    {
            // Last try, switch to English, US
            langid = MAKELANGID(LANG_ENGLISH, SUBLANG_ENGLISH_US);
            if (!_LoadStringExW(g_hInst, MimeCodePage[uidx].uidDescription, pcpInfo->wszDescription, MAX_MIMECP_NAME, langid))
                return hr;
    }

    if ((0 == MimeCodePage[uidx].uidFixedWidthFont || 0 == MimeCodePage[uidx].uidProportionalFont))         
    {
        pcpInfo->wszFixedWidthFont[0] = 0;
        pcpInfo->wszProportionalFont[0] = 0;

        if (0 != MimeCodePage[uidx].uiFamilyCodePage)
        {
            for (UINT j = 0; j < ARRAYSIZE(MimeCodePage); j++)
            {
                if (MimeCodePage[uidx].uiFamilyCodePage == MimeCodePage[j].uiCodePage)
                {
                    _LoadStringExW(g_hInst, MimeCodePage[j].uidFixedWidthFont, pcpInfo->wszFixedWidthFont, MAX_MIMEFACE_NAME, langid);
                    _LoadStringExW(g_hInst, MimeCodePage[j].uidProportionalFont, pcpInfo->wszProportionalFont, MAX_MIMEFACE_NAME, langid);
                    break;
                }
            }
        }

    }
    else
    {
        _LoadStringExW(g_hInst, MimeCodePage[uidx].uidFixedWidthFont, pcpInfo->wszFixedWidthFont, MAX_MIMEFACE_NAME, langid);
        _LoadStringExW(g_hInst, MimeCodePage[uidx].uidProportionalFont, pcpInfo->wszProportionalFont, MAX_MIMEFACE_NAME,langid);
    }


    // Copy internal buffer information
    pcpInfo->dwFlags = MimeCodePage[uidx].dwFlags;
    pcpInfo->uiCodePage = MimeCodePage[uidx].uiCodePage;
    if (MimeCodePage[uidx].uiFamilyCodePage)
        pcpInfo->uiFamilyCodePage = MimeCodePage[uidx].uiFamilyCodePage;
    else
        pcpInfo->uiFamilyCodePage = MimeCodePage[uidx].uiCodePage;
    MLStrCpyNW(pcpInfo->wszBodyCharset, MimeCodePage[uidx].wszBodyCharset, MAX_MIMECSET_NAME);

    if (MimeCodePage[uidx].wszWebCharset)
        MLStrCpyNW(pcpInfo->wszWebCharset, MimeCodePage[uidx].wszWebCharset, MAX_MIMECSET_NAME);
    else
        MLStrCpyNW(pcpInfo->wszWebCharset, MimeCodePage[uidx].wszBodyCharset, MAX_MIMECSET_NAME);

    if (MimeCodePage[uidx].wszHeaderCharset)
        MLStrCpyNW(pcpInfo->wszHeaderCharset, MimeCodePage[uidx].wszHeaderCharset, MAX_MIMECSET_NAME);
    else
        MLStrCpyNW(pcpInfo->wszHeaderCharset, MimeCodePage[uidx].wszBodyCharset, MAX_MIMECSET_NAME);

    if (0 != TranslateCharsetInfo((LPDWORD)pcpInfo->uiFamilyCodePage, &rCharsetInfo, TCI_SRCCODEPAGE))
        pcpInfo->bGDICharset = (BYTE)rCharsetInfo.ciCharset;
    else
        pcpInfo->bGDICharset = DEFAULT_CHARSET;

    if (1200 == pcpInfo->uiFamilyCodePage || 50000 == pcpInfo->uiFamilyCodePage || TRUE == _IsValidCodePage(pcpInfo->uiFamilyCodePage)) // 50000 means user defined
    {
       if (TRUE == CheckFont(pcpInfo->bGDICharset))
       {
           if (pcpInfo->uiCodePage == pcpInfo->uiFamilyCodePage || TRUE == _IsValidCodePage(pcpInfo->uiCodePage))
              pcpInfo->dwFlags |= MIMECONTF_VALID|MIMECONTF_VALID_NLS;
           else if (S_OK == IsConvertINetStringAvailable(pcpInfo->uiCodePage, pcpInfo->uiFamilyCodePage))
              pcpInfo->dwFlags |= MIMECONTF_VALID|MIMECONTF_VALID_NLS;
       }
       else
       {
           if (pcpInfo->uiCodePage == pcpInfo->uiFamilyCodePage || TRUE == _IsValidCodePage(pcpInfo->uiCodePage))
              pcpInfo->dwFlags |= MIMECONTF_VALID_NLS;
           else if (S_OK == IsConvertINetStringAvailable(pcpInfo->uiCodePage, pcpInfo->uiFamilyCodePage))
              pcpInfo->dwFlags |= MIMECONTF_VALID_NLS;
       }

    }

        
    hr = S_OK;

    return hr;
}


STDAPI CMimeDatabase::GetCharsetInfo(BSTR Charset, PMIMECSETINFO pcsetInfo)
{
    int idx = -1;
    int iStart, iEnd, iMiddle, iCmpResult;
    HRESULT hr = E_FAIL;

    DebugMsg(DM_TRACE, TEXT("CMimeDatabase::GetCharsetInfo called."));

    iStart = 0;
    iEnd = ARRAYSIZE(MimeCharSet) - 1;

    while (iStart <= iEnd)
    {
        iMiddle = (iStart + iEnd) / 2;
        iCmpResult = MLStrCmpIW(Charset, MimeCharSet[iMiddle].szCharset);
        if (iCmpResult < 0)
            iEnd = iMiddle - 1;
        else if (iCmpResult > 0)
            iStart = iMiddle + 1;
        else
        {
            if (MimeCharSet[iMiddle].dwFlags & dwMimeSource)
            {
                idx = iMiddle;                
            }
            else
                // !!! Tricky, search neighbors for correct data which matches MIME version
                // Only works for now, if we have data over two versions, we have to change here
                if ((iMiddle+1 <= iEnd) && 
                    MimeCharSet[iMiddle+1].dwFlags & dwMimeSource &&
                    !MLStrCmpIW(Charset, MimeCharSet[iMiddle+1].szCharset))
                {
                    idx = iMiddle+1;
                }
                else 
                    if ((iMiddle-1 >= 0) &&
                        MimeCharSet[iMiddle-1].dwFlags & dwMimeSource &&
                        !MLStrCmpIW(Charset, MimeCharSet[iMiddle-1].szCharset))
                    {
                
                        idx = iMiddle-1;
                    }
                    else
                    {
                        idx = ARRAYSIZE(MimeCharSet);
                    }
            break;
        }
    }


    if (0 <= idx && idx < ARRAYSIZE(MimeCharSet) && pcsetInfo )
    {
        MLStrCpyNW(pcsetInfo->wszCharset, MimeCharSet[idx].szCharset, MAX_MIMECSET_NAME);
        pcsetInfo->uiCodePage = MimeCharSet[idx].uiCodePage;
        pcsetInfo->uiInternetEncoding = MimeCharSet[idx].uiInternetEncoding;
        hr = S_OK;
    }

    return hr;
}

int CALLBACK EnumFontFamExProc(ENUMLOGFONTEX *lpelf, NEWTEXTMETRICEX *lpntm, int iFontType, LPARAM lParam)
{
    LOGFONT *lplf;
    BOOL *lpfOK = (BOOL *)lParam;

    lplf = &(lpelf->elfLogFont);
    // We don't use non TrueType fonts
    if (iFontType == DEVICE_FONTTYPE || iFontType == RASTER_FONTTYPE)
        return 1;   // keep going but don't use this font

    // We don't use the SYMBOL, Mac Charset fonts
    if(lplf->lfCharSet == SYMBOL_CHARSET || lplf->lfCharSet == MAC_CHARSET)
        return 1;

    // We don't handle vertical fonts
    if (TEXT('@') == lplf->lfFaceName[0])
        return 1;

    *lpfOK = TRUE;
    return 0;       // stop enumeration if we find any
}

BOOL CMimeDatabase::CheckFont(BYTE bGDICharset)
{
    BOOL fRet = FALSE;

    DebugMsg(DM_TRACE, TEXT("CMimeDatabase::CheckFont called."));

    // It is safe to assume that system always support DEFAULT_CHAR and ANSI_CHARSET
    if ((DEFAULT_CHARSET == bGDICharset) || (ANSI_CHARSET == bGDICharset))
        fRet = TRUE;
    else
    {
        HDC     hDC;
        LOGFONT lf;
        HWND    hWnd;

        hWnd = GetTopWindow(GetDesktopWindow());
        hDC = GetDC(hWnd);

        if (NULL != hDC)
        {
            lf.lfFaceName[0] = TEXT('\0');
            lf.lfPitchAndFamily = 0;
            lf.lfCharSet = bGDICharset;
            EnumFontFamiliesEx(hDC, &lf, (FONTENUMPROC)EnumFontFamExProc, (LPARAM)&fRet, 0);
        }
        ReleaseDC(hWnd, hDC);
    }
    return fRet;
}

// validates all cps that are in the same
// family of the given codepage
STDAPI CMimeDatabase::ValidateCP(UINT uiCodePage)
{
    UINT i;

    for (i = 0; i < ARRAYSIZE(MimeCodePage); i++)
    {
        if (MimeCodePage[i].uiFamilyCodePage == uiCodePage)
            MimeCodePage[i].dwFlags |=  MIMECONTF_VALID|MIMECONTF_VALID_NLS;
    }
        
    return S_OK; // never fail?
}
