#ifdef WIN32

// These things have direct equivalents.

// Shouldn't be using these things.
#define WINCAPI __cdecl
#define _huge
#define _export
#define _loadds
#define SELECTOROF(x)   ((UINT)(x))
#define OFFSETOF(x)     ((UINT)(x))
#define ISLPTR(pv)      ((BOOL)pv)
#define MAKELP(hmem,off) ((LPVOID)((LPBYTE)hmem+off))
#define MAKELRESULTFROMUINT(i)  ((LRESULT)i)
#define ISVALIDHINSTANCE(hinst) ((BOOL)hinst)

#define DATASEG_READONLY    ".text"	// read only data, same as one generated by linker
#define DATASEG_PERINSTANCE "INSTDATA"    // per instance data
#define DATASEG_SHARED                  // default data goes here
#define CODESEG_INIT 	    ".text"

#define GetWindowInt    	GetWindowLong
#define SetWindowInt    	SetWindowLong
#define SetWindowID(hwnd,id)    SetWindowLong(hwnd, GWL_ID, id)
#define GetClassCursor(hwnd)    ((HCURSOR)GetClassLong(hwnd, GCL_HCURSOR))
#define GetClassIcon(hwnd)      ((HICON)GetClassLong(hwnd, GCL_HICON))

#else  // !WIN32

#define ISLPTR(pv)      	(SELECTOROF(pv))
#define MAKELRESULTFROMUINT(i)  MAKELRESULT(i,0)
#define ISVALIDHINSTANCE(hinst) ((UINT)hinst>=(UINT)HINSTANCE_ERROR)

#define DATASEG_READONLY    "_TEXT"
#define DATASEG_PERINSTANCE
#define DATASEG_SHARED
#define CODESEG_INIT 	    "_INIT"

#define GetWindowInt    	GetWindowWord
#define SetWindowInt    	SetWindowWord
#define SetWindowID(hwnd,id)    SetWindowWord(hwnd, GWW_ID, id)
#define GetClassCursor(hwnd)    ((HCURSOR)GetClassWord(hwnd, GCW_HCURSOR))
#define GetClassIcon(hwnd)      ((HICON)GetClassWord(hwnd, GCW_HICON))

#define MAKEPOINTS(l)     (*((POINTS FAR*)&(l)))

#define GlobalAlloc16(f, s) GlobalAlloc(f, s)
#define GlobalLock16(h)     GlobalLock(h)
#define GlobalUnlock16(h)   GlobalUnlock(h)
#define GlobalFree16(h)     GlobalFree(h)
#define GlobalSize16(h)     GlobalSize(h)

#endif // WIN32
