/*++ 

Copyright (c) 1996  Microsoft Corporation

Module Name:

    datacach.c

Abstract:
       
    a file containing the constant data structures used by the Performance
    Monitor data for the Cache performance data objects

Created:

    Bob Watson  22-Oct-1996

Revision History:

    None.

--*/
//
//  Include Files
//

#include <windows.h>
#include <winperf.h>
#include <ntprfctr.h>
#include <perfutil.h>
#include "datacach.h"

// dummy variable for field sizing.
static CACHE_COUNTER_DATA ccd;

//
//  Constant structure initializations 
//      defined in datacach.h
//

CACHE_DATA_DEFINITION CacheDataDefinition = {

    {   sizeof(CACHE_DATA_DEFINITION) + sizeof (CACHE_COUNTER_DATA),
        sizeof(CACHE_DATA_DEFINITION),
        sizeof(PERF_OBJECT_TYPE),
        CACHE_OBJECT_TITLE_INDEX,
        0,
        87,
        0,
        PERF_DETAIL_ADVANCED,
        (sizeof(CACHE_DATA_DEFINITION)-sizeof(PERF_OBJECT_TYPE))/
        sizeof(PERF_COUNTER_DEFINITION),
        3,
        -1,
        UNICODE_CODE_PAGE,
        {0L,0L},
        {0L,0L}        
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        88,
        0,
        89,
        0,
        0,
        PERF_DETAIL_EXPERT,
        PERF_COUNTER_COUNTER,
        sizeof(ccd.DataMaps),
        (DWORD)(ULONG_PTR)&((PCACHE_COUNTER_DATA)0)->DataMaps
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        90,
        0,
        91,
        0,
        0,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_COUNTER,
        sizeof(ccd.SyncDataMaps),
        (DWORD)(ULONG_PTR)&((PCACHE_COUNTER_DATA)0)->SyncDataMaps
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        92,
        0,
        93,
        0,
        0,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_COUNTER,
        sizeof(ccd.AsyncDataMaps),
        (DWORD)(ULONG_PTR)&((PCACHE_COUNTER_DATA)0)->AsyncDataMaps
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        94,
        0,
        95,
        0,
        0,
        PERF_DETAIL_WIZARD,
        PERF_SAMPLE_FRACTION,
        sizeof(ccd.DataMapHits),
        (DWORD)(ULONG_PTR)&((PCACHE_COUNTER_DATA)0)->DataMapHits
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        94,
        0,
        95,
        0,
        0,
        PERF_DETAIL_WIZARD,
        PERF_SAMPLE_BASE,
        sizeof(ccd.DataMapHitsBase),
        (DWORD)(ULONG_PTR)&((PCACHE_COUNTER_DATA)0)->DataMapHitsBase
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        96,
        0,
        97,
        0,
        0,
        PERF_DETAIL_WIZARD,
        PERF_SAMPLE_FRACTION,
        sizeof(ccd.DataMapPins),
        (DWORD)(ULONG_PTR)&((PCACHE_COUNTER_DATA)0)->DataMapPins
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        96,
        0,
        97,
        0,
        0,
        PERF_DETAIL_WIZARD,
        PERF_SAMPLE_BASE,
        sizeof(ccd.DataMapPinsBase),
        (DWORD)(ULONG_PTR)&((PCACHE_COUNTER_DATA)0)->DataMapPinsBase
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        98,
        0,
        99,
        0,
        0,
        PERF_DETAIL_EXPERT,
        PERF_COUNTER_COUNTER,
        sizeof(ccd.PinReads),
        (DWORD)(ULONG_PTR)&((PCACHE_COUNTER_DATA)0)->PinReads
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        100,
        0,
        101,
        0,
        0,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_COUNTER,
        sizeof(ccd.SyncPinReads),
        (DWORD)(ULONG_PTR)&((PCACHE_COUNTER_DATA)0)->SyncPinReads
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        102,
        0,
        103,
        0,
        0,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_COUNTER,
        sizeof(ccd.AsyncPinReads),
        (DWORD)(ULONG_PTR)&((PCACHE_COUNTER_DATA)0)->AsyncPinReads
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        104,
        0,
        105,
        0,
        0,
        PERF_DETAIL_EXPERT,
        PERF_SAMPLE_FRACTION,
        sizeof(ccd.PinReadHits),
        (DWORD)(ULONG_PTR)&((PCACHE_COUNTER_DATA)0)->PinReadHits
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        104,
        0,
        105,
        0,
        0,
        PERF_DETAIL_EXPERT,
        PERF_SAMPLE_BASE,
        sizeof(ccd.PinReadHitsBase),
        (DWORD)(ULONG_PTR)&((PCACHE_COUNTER_DATA)0)->PinReadHitsBase
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        106,
        0,
        107,
        0,
        0,
        PERF_DETAIL_EXPERT,
        PERF_COUNTER_COUNTER,
        sizeof(ccd.CopyReads),
        (DWORD)(ULONG_PTR)&((PCACHE_COUNTER_DATA)0)->CopyReads
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        108,
        0,
        109,
        0,
        0,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_COUNTER,
        sizeof(ccd.SyncCopyReads),
        (DWORD)(ULONG_PTR)&((PCACHE_COUNTER_DATA)0)->SyncCopyReads
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        110,
        0,
        111,
        0,
        0,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_COUNTER,
        sizeof(ccd.AsyncCopyReads),
        (DWORD)(ULONG_PTR)&((PCACHE_COUNTER_DATA)0)->AsyncCopyReads
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        112,
        0,
        113,
        0,
        0,
        PERF_DETAIL_EXPERT,
        PERF_SAMPLE_FRACTION,
        sizeof(ccd.CopyReadHits),
        (DWORD)(ULONG_PTR)&((PCACHE_COUNTER_DATA)0)->CopyReadHits
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        112,
        0,
        113,
        0,
        0,
        PERF_DETAIL_EXPERT,
        PERF_SAMPLE_BASE,
        sizeof(ccd.CopyReadHitsBase),
        (DWORD)(ULONG_PTR)&((PCACHE_COUNTER_DATA)0)->CopyReadHitsBase
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        114,
        0,
        115,
        0,
        0,
        PERF_DETAIL_EXPERT,
        PERF_COUNTER_COUNTER,
        sizeof(ccd.MdlReads),
        (DWORD)(ULONG_PTR)&((PCACHE_COUNTER_DATA)0)->MdlReads
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        116,
        0,
        117,
        0,
        0,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_COUNTER,
        sizeof(ccd.SyncMdlReads),
        (DWORD)(ULONG_PTR)&((PCACHE_COUNTER_DATA)0)->SyncMdlReads
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        118,
        0,
        119,
        0,
        0,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_COUNTER,
        sizeof(ccd.AsyncMdlReads),
        (DWORD)(ULONG_PTR)&((PCACHE_COUNTER_DATA)0)->AsyncMdlReads
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        120,
        0,
        121,
        0,
        0,
        PERF_DETAIL_EXPERT,
        PERF_SAMPLE_FRACTION,
        sizeof(ccd.MdlReadHits),
        (DWORD)(ULONG_PTR)&((PCACHE_COUNTER_DATA)0)->MdlReadHits
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        120,
        0,
        121,
        0,
        0,
        PERF_DETAIL_EXPERT,
        PERF_SAMPLE_BASE,
        sizeof(ccd.MdlReadHitsBase),
        (DWORD)(ULONG_PTR)&((PCACHE_COUNTER_DATA)0)->MdlReadHitsBase
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        122,
        0,
        123,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_COUNTER,
        sizeof(ccd.ReadAheads),
        (DWORD)(ULONG_PTR)&((PCACHE_COUNTER_DATA)0)->ReadAheads
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        124,
        0,
        125,
        0,
        -1,
        PERF_DETAIL_EXPERT,
        PERF_COUNTER_COUNTER,
        sizeof(ccd.FastReads),
        (DWORD)(ULONG_PTR)&((PCACHE_COUNTER_DATA)0)->FastReads
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        126,
        0,
        127,
        0,
        -1,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_COUNTER,
        sizeof(ccd.SyncFastReads),
        (DWORD)(ULONG_PTR)&((PCACHE_COUNTER_DATA)0)->SyncFastReads
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        128,
        0,
        129,
        0,
        -1,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_COUNTER,
        sizeof(ccd.AsyncFastReads),
        (DWORD)(ULONG_PTR)&((PCACHE_COUNTER_DATA)0)->AsyncFastReads
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        130,
        0,
        131,
        0,
        0,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_COUNTER,
        sizeof(ccd.FastReadResourceMiss),
        (DWORD)(ULONG_PTR)&((PCACHE_COUNTER_DATA)0)->FastReadResourceMiss
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        132,
        0,
        133,
        0,
        0,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_COUNTER,
        sizeof(ccd.FastReadNotPossibles),
        (DWORD)(ULONG_PTR)&((PCACHE_COUNTER_DATA)0)->FastReadNotPossibles
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        134,
        0,
        135,
        0,
        0,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_COUNTER,
        sizeof(ccd.LazyWriteFlushes),
        (DWORD)(ULONG_PTR)&((PCACHE_COUNTER_DATA)0)->LazyWriteFlushes
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        136,
        0,
        137,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_COUNTER,
        sizeof(ccd.LazyWritePages),
        (DWORD)(ULONG_PTR)&((PCACHE_COUNTER_DATA)0)->LazyWritePages
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        138,
        0,
        139,
        0,
        0,
        PERF_DETAIL_WIZARD,
        PERF_COUNTER_COUNTER,
        sizeof(ccd.DataFlushes),
        (DWORD)(ULONG_PTR)&((PCACHE_COUNTER_DATA)0)->DataFlushes
    },
    {   sizeof(PERF_COUNTER_DEFINITION),
        140,
        0,
        141,
        0,
        0,
        PERF_DETAIL_ADVANCED,
        PERF_COUNTER_COUNTER,
        sizeof(ccd.DataPages),
        (DWORD)(ULONG_PTR)&((PCACHE_COUNTER_DATA)0)->DataPages
    }
};

