#----------------------------------------------------------------------------
#
# Copyright (c) 1998 Microsoft Corporation
#
# Description:
#   This will map the osksetti.reg file into a osksetti.h file. 
#   This is so that we add the defaults without adding this to the hives
#   or including the osksetti.reg file in the product.  If the osksetti.reg
#   ever changes then osksetti.h will have to be regenerated. 
#
# History:
#   kpeery - 02/04/1998 - wrote it.
#
#----------------------------------------------------------------------------


#----------------------------------------------------------------------------
#
# Description: 
#   First spit out the pre-header defintion.  Then use commas to find the
#   first line with numbers in it.  Once we have found that then remove the
#   extra 'junk' setting string.
#   We then use the commas to place in the first set of 0x prefixes to the
#   numbers.  We then must remove the trailing 0x\.
#   Last we must prefix the lines that begin with a space.
#
#----------------------------------------------------------------------------

($sec,$min,$hour,$day,$month,$year)=localtime(time);
$month++;

print "//-----------------------------------------------------------------\n";
print "//\n";
print "//  Copyright (c) 1998 Microsoft Corporation\n";
print "//\n";
print "//  This H file was generated by the perl script regtoh.pl.\n";
print "//\n";
print "//  This file was last generated on: $month/$day/$year at: ";
print "$hour:$min:$sec.\n";
print "//\n";
print "//  Be sure to bump up the CURRENT_STEPPING when the structure ";
print "changes.\n";
print "//  Changing the stepping will force an update to the registry.\n";
print "//\n";
print "//  Please do not edit this file directly.\n";
print "//\n";
print "//-----------------------------------------------------------------\n\n";

print "#define CURRENT_STEPPING 3\n\n";

print "BYTE g_DefaultSettings[] = {\n\n";

while (<>) 
{
    if (/,/)
    {
        $_=~s/"Setting"=hex:/ /g;       # replace junk line with space 
        $_=~s/,/,0x/g;
        $_=~s/0x\\/ /g;
        $_=~s/ 0/ 0x0/g;
        $_=~s/ 1/ 0x1/g;
        $_=~s/ 2/ 0x2/g;
        $_=~s/ 3/ 0x3/g;
        $_=~s/ 4/ 0x4/g;
        $_=~s/ 5/ 0x5/g;
        $_=~s/ 6/ 0x6/g;
        $_=~s/ 7/ 0x7/g;
        $_=~s/ 8/ 0x8/g;
        $_=~s/ 9/ 0x9/g;
        $_=~s/ [aA]/ 0xa/g;
        $_=~s/ [bB]/ 0xb/g;
        $_=~s/ [cC]/ 0xc/g;
        $_=~s/ [dD]/ 0xd/g;
        $_=~s/ [eE]/ 0xe/g;
        $_=~s/ [fF]/ 0xf/g;
        print $_;
    }
}

print "};\n\n";


