#include "manifest\InvalidChannel.h"
#include "manifest\testprov1.h"

#ifndef _EVENTLOG_GLOBALS_H_
#define _EVENTLOG_GLOBALS_H_

#define EVENTLOG_TEST_HOOKS 1

#define LOGLOCATION L""

#define MAX_PROVIDERS_PER_CHANNEL       100 //this is not actually a max, there is no max
#define MAX_SUBSCRIBERS_PER_CHANNEL     32  //this is not actually a max, there is no max
#define MAX_USER_DATACOUNT              128
#define MAX_CHANNELS                    32
#define MAX_EVENT_DATA_DESCRIPTORS           (128)
#define MAX_EVENT_FILTER_DATA_SIZE           (1024)
#define MAX_EVENTLOG_CHANNELS_PER_PROVIDER 8
#define MAX_EVENTLOG_CHANNEL 16*1024*1024
//#define MIN_EVENTLOG_CHANNEL 1024
#define MAX_EVENTLOG_CHANNEL_TYPE 0x3

#define MAX_MED_STRUCTS_PER_BUFFER      5
#define MAX_SMALL_STRUCTS_PER_BUFFER    10

#define EVENTLOG_CHANNEL_TYPE_ANALYTICAL 0x0
#define EVENTLOG_CHANNEL_TYPE_DEBUG 0x1
#define EVENTLOG_CHANNEL_TYPE_ADMIN 0x2
#define EVENTLOG_CHANNEL_TYPE_OPERATIONAL 0x3

#define EVENT_OVERHEAD                  20
/*
    if((dwTotalSize > 4096)
        ||(cbEventDescriptor > 1024))
*/
#define ERROR_UNKNOWN_ERROR             99999


#define TEST_EVENT_0                    0

#define TEST_EVENT_NO_VERIFY            1000


#define TEST_CHANNEL_1_BUFFER_SIZE      4096 //changing this value will change reg value

#define TEST_PROV2_CHANNEL_1_BUFFER_SIZE 10000
#define TEST_PROV2_CHANNEL_2_BUFFER_SIZE 3000


#define SMALL_STRUCT_SIZE               14
#define SMALL_STRUCT_ARRAY_COUNT        5

#define DEFAULT_TIMEOUT                 10000

#define DEFAULT_TEST_USER_DATACOUNT     1
#define DEFAULT_TEST_DATA_DESCRIPTOR    PCEVENT_DESCRIPTOR
#define DEFAULT_TEST_USER_DATA          0xDEADBEEF

#define TEST_CHANNEL_COUNT              12

#define TEST_CHANNEL_P0_SYSTEM           0
#define TEST_CHANNEL_P0_C1                  1
#define TEST_CHANNEL_P1_APPLICATION     2
#define TEST_CHANNEL_P1_C1              3
#define TEST_CHANNEL_P1_C2              4
#define TEST_CHANNEL_P2_INVALIDREG                 5
#define TEST_CHANNEL_P99_INVALID_NAME       6
#define TEST_CHANNEL_INVALID       7
#define TEST_CHANNEL_INDEX_SECURITY 8
#define TEST_CHANNEL_INDEX_APPLICATION TEST_CHANNEL_P1_APPLICATION
#define TEST_CHANNEL_INDEX_SYSTEM TEST_CHANNEL_P0_SYSTEM
#define VALID_TEST_PROVIDER_COUNT             6

const WCHAR g_arrProviderRegPaths[VALID_TEST_PROVIDER_COUNT][MAX_PATH]={
    L"System\\EventLog\\Provider\\{272BDCE3-4689-4b8b-8169-E5B2AAF8A0A1}\\Channels",
    L"System\\EventLog\\Provider\\{694A54A6-80E1-42b4-AF1E-0369F22FFB14}\\Channels",
    L"System\\EventLog\\Provider\\{80945A9C-F7B4-4c2b-B628-259724433ACC}\\Channels",
    L"System\\EventLog\\Provider\\{CB707539-FFD6-4840-A023-8C9AAEAA142D}\\Channels",
    L"System\\EventLog\\Provider\\{544A3F3D-03C1-4a7a-9019-D91F14E9C530}\\Channels",
    L"System\\EventLog\\Provider\\{E6043603-7F37-472e-9EDB-7B84E19E93BE}\\Channels"
};

const WCHAR g_arrProviderChannelNameValues[VALID_TEST_PROVIDER_COUNT][MAX_PATH]={
    L"System\0Microsoft-WindowsCE-EventLogTestPublisher-Operational\0\0",
    L"Microsoft-WindowsCE-EventLogTestPublisher-Operational-Prov2-C1\0Microsoft-WindowsCE-EventLogTestPublisher-Analytic-Prov2-C2\0\0",
    L"Microsoft-WindowsCE-EventLogTestPublisher-Operational-Prov3-C1\0\0",
    L"Application\0\0",
    L"System\0\0",
    L"Security\0\0"
};

const WCHAR g_arrChannelPaths[TEST_CHANNEL_COUNT][MAX_PATH * 2 + 2]={
    L"System",
    L"Microsoft-WindowsCE-EventLogTestPublisher-Operational",
    L"Application",
    L"Microsoft-WindowsCE-EventLogTestPublisher-Operational-Prov2-C1",
    L"Microsoft-WindowsCE-EventLogTestPublisher-Analytic-Prov2-C2", 
    L"Microsoft-WindowsCE-EventLogTestPublisher-Operational-Prov3-C1",
    L"Microsoft-WindowsCE-EventLogTest12345678901234567890123456789012Microsoft-WindowsCE-EventLogTest12345678901234567890123456789012Microsoft-WindowsCE-EventLogTest12345678901234567890123456789012Microsoft-WindowsCE-EventLogTest1234567890123456789012345678901"
    L"Microsoft-WindowsCE-EventLogTest12345678901234567890123456789012Microsoft-WindowsCE-EventLogTest12345678901234567890123456789012Microsoft-WindowsCE-EventLogTest12345678901234567890123456789012Microsoft-WindowsCE-EventLogTest12345678901234567890123456789012",
    L"Application",
    L"System",
    L"Security"
};

const int g_arrCIDs[TEST_CHANNEL_COUNT]={
    0x08,
    0x65,
    0x09,
    0x67,
    0x68,
    0x69,
    0x63,
    0x62,
    0x08,
    0x09,
    0x10
};


#define DEFAULT_TEST_CHANNEL_PATH       L"Microsoft-WindowsCE-EventLogTestPublisher-Operational"
#define INVALID_TEST_CHANNEL_PATH_257   L"Microsoft-WindowsCE-EventLogTest12345678901234567890123456789012Microsoft-WindowsCE-EventLogTest12345678901234567890123456789012Microsoft-WindowsCE-EventLogTest12345678901234567890123456789012Microsoft-WindowsCE-EventLogTest12345678901234567890123456789012X"
#define INVALID_TEST_CHANNEL_PATH_513   L"Microsoft-WindowsCE-EventLogTest12345678901234567890123456789012Microsoft-WindowsCE-EventLogTest12345678901234567890123456789012Microsoft-WindowsCE-EventLogTest12345678901234567890123456789012Microsoft-WindowsCE-EventLogTest12345678901234567890123456789012Microsoft-WindowsCE-EventLogTest12345678901234567890123456789012Microsoft-WindowsCE-EventLogTest12345678901234567890123456789012Microsoft-WindowsCE-EventLogTest12345678901234567890123456789012Microsoft-WindowsCE-EventLogTest12345678901234567890123456789012X"
#define P2C1_CHANNEL_PATH               L"Microsoft-WindowsCE-EventLogTestPublisher-Operational-Prov2-C1"


#define TEST_PROVIDER_COUNT             7

#define TEST_PROVIDER_0                 0
#define TEST_PROVIDER_1                 1
#define TEST_PROVIDER_2_INVALIDREG      2
#define TEST_PROVIDER_INVALID           3
#define TEST_PROVIDER_INDEX_APPLICATION            4
#define TEST_PROVIDER_INDEX_SYSTEM       5
#define TEST_PROVIDER_INDEX_SECURITY          6

const GUID g_arrProviderGUIDs[TEST_PROVIDER_COUNT]={
    WINDOWSCE_EVENTLOG_TEST_PUBLISHER,
    WINDOWSCE_EVENTLOG_TEST_PUBLISHER_2,
    WINDOWSCE_EVENTLOG_TEST_PUBLISHER_INVALIDREG,
    WINDOWSCE_EVENTLOG_TEST_PUBLISHER_INVALID,
    WINDOWSCE_EVENTLOG_TEST_PUBLISHER_APPLICATION,
    WINDOWSCE_EVENTLOG_TEST_PUBLISHER_SYSTEM,
    WINDOWSCE_EVENTLOG_TEST_PUBLISHER_SECURITY
};


//#define DEFAULT_TEST_CHANNEL_PATH       L"MyChannel"
#define DEFAULT_TEST_GRF_FLAGS          EvtSubscribeToFutureEvents
#define TEST_PROVIDER_GUID              WINDOWSCE_EVENTLOG_TEST_PUBLISHER
#define P2C1_PROVIDER_GUID              WINDOWSCE_EVENTLOG_TEST_PUBLISHER_2

#define TEST_PROVIDER_CHANNEL_GUID      TEST_CHANNEL_0

#define WINEVENT_LEVEL_LOGALWAYS        0x0
#define WINEVENT_LEVEL_CRITICAL         0x1
#define WINEVENT_LEVEL_ERROR            0x2
#define WINEVENT_LEVEL_WARNING          0x3
#define WINEVENT_LEVEL_INFO             0x4
#define WINEVENT_LEVEL_VERBOSE          0x5



#define DEFAULT_TEST_LEVEL              WINEVENT_LEVEL_VERBOSE
#define MATCH_ANY_KEYWORD_VERBOSE       0xFFFFFFFFFFFFFFFF
#define MATCH_ALL_KEYWORD_VERBOSE       0x0
#define DEFAULT_TEST_ANY_KEYWORD        MATCH_ANY_KEYWORD_VERBOSE
#define DEFAULT_TEST_ALL_KEYWORD        MATCH_ALL_KEYWORD_VERBOSE

#define TEST_KEYWORD_ONE                WINDOWSCE_EVENTLOG_TEST_PUBLISHER_KEYWORD_one
#define TEST_KEYWORD_TWO                WINDOWSCE_EVENTLOG_TEST_PUBLISHER_KEYWORD_two
#define TEST_KEYWORD_FOUR               WINDOWSCE_EVENTLOG_TEST_PUBLISHER_KEYWORD_four

#define NO_KEYWORDS                     0x0


#define LEVEL_ENUM_MAX                  WINEVENT_LEVEL_VERBOSE
#define LEVEL_ENUM_MIN                  WINEVENT_LEVEL_CRITICAL

#define ENUM_LOWEST_CHAMBER 1
#define ENUM_APPLICATION_CHAMBER 2
#define ENUM_SYSTEM_CHAMBER 3
#define ENUM_SECURITY_CHAMBER 4

/*
#define WINDOWSCE_EVENTLOG_TEST_PUBLISHER_CHANNEL_C0 0x8
#define TEST_CHANNEL_0 0x65
#define WINDOWSCE_EVENTLOG_TEST_PUBLISHER_2_CHANNEL_Prov2Application 0x9
#define P2_TEST_CHANNEL_1 0x67
#define P2_TEST_CHANNEL_2 0x68
*/

#define TEST_EVENT_DWORD                0
#define TEST_EVENT_DWORDANDSTRING       1
#define TEST_EVENT_SMALLEVENT           2
#define TEST_EVENT_DWORDANDSTRINGANDSTRUCT 3
#define TEST_EVENT_TOOBIG               4
#define TEST_EVENT_MEDEVENT             5
#define TEST_EVENT_STRUCTARRAY          6
#define TEST_EVENT_MAXDATACOUNT         7
#define TEST_EVENT_OVERMAXDATACOUNT     8

#define TEST_EVENT_KEYWORD_NONE         TEST_EVENT_DWORD
#define TEST_EVENT_KEYWORD_ONE          TEST_EVENT_DWORDANDSTRING
#define TEST_EVENT_KEYWORD_TWO          TEST_EVENT_SMALLEVENT
#define TEST_EVENT_KEYWORD_TWOONE       TEST_EVENT_DWORDANDSTRINGANDSTRUCT
#define TEST_EVENT_KEYWORD_FOUR         TEST_EVENT_TOOBIG
#define TEST_EVENT_KEYWORD_FOURONE      TEST_EVENT_MEDEVENT
#define TEST_EVENT_KEYWORD_FOURTWO      TEST_EVENT_STRUCTARRAY
#define TEST_EVENT_KEYWORD_FOURTWOONE   TEST_EVENT_MAXDATACOUNT

#define TEST_EVENT_LEVEL_WARNING        TEST_EVENT_DWORDANDSTRINGANDSTRUCT
#define TEST_EVENT_LEVEL_ERROR          TEST_EVENT_SMALLEVENT
#define TEST_EVENT_LEVEL_CRITICAL       TEST_EVENT_DWORD
#define TEST_EVENT_LEVEL_VERBOSE        TEST_EVENT_STRUCTARRAY
#define TEST_EVENT_LEVEL_INFO           TEST_EVENT_DWORDANDSTRING

#define TEST_EVENT_COUNT                8 
const EVENT_DESCRIPTOR g_arrDescriptors[TEST_CHANNEL_COUNT][TEST_EVENT_COUNT]= {
    //provider 1 - system channel
    {TEST_EVENT_PROV1_C0_L1_DWORD,
    TEST_EVENT_PROV1_C0_L1_DWORDANDSTRING,
    TEST_EVENT_PROV1_C0_L2_SMALLSTRUCT,
    TEST_EVENT_PROV1_C0_L3_DWORDANDSTRINGANDSTRUCT,
    TEST_EVENT_PROV1_C0_L4_TOOBIG,
    TEST_EVENT_PROV1_C0_L2_MEDSTRUCT,
    TEST_EVENT_PROV1_C0_L2_STRUCTARRAY,
    TEST_EVENT_PROV1_C0_L2_BYTEARRAY},
    //provider 1 - test channel 1
    {TEST_EVENT_LEVEL0_MYCHAN,
    TEST_EVENT_LEVEL1_MYCHAN,
    TEST_EVENT_LEVEL2_MYCHAN,
    TEST_EVENT_LEVEL3_MYCHAN,
    TEST_EVENT_LEVEL4_MYCHAN,
    TEST_EVENT_LEVEL5_MYCHAN,
    TEST_EVENT_LEVEL6_MYCHAN,
    TEST_EVENT_BYTEARRAY_MYCHAN},
    //provider 2 - Application Channel 2
    {TEST_EVENT_PROV2_C1_L1_DWORD,
    TEST_EVENT_PROV2_C1_L1_DWORDANDSTRING,
    TEST_EVENT_PROV2_C1_L2_SMALLSTRUCT,
    TEST_EVENT_PROV2_C1_L3_DWORDANDSTRINGANDSTRUCT,
    TEST_EVENT_PROV2_C1_L4_BIGSTRUCT,
    TEST_EVENT_PROV2_C1_L4_STRUCTARRAY,
    TEST_EVENT_PROV2_C1_L2_MEDSTRUCT,
    TEST_EVENT_PROV2_C1_L2_BYTEARRAY},
    //provider 2 - test channel 3
    {TEST_EVENT_PROV2_C2_L1_DWORD,
    TEST_EVENT_PROV2_C2_L1_DWORDANDSTRING,
    TEST_EVENT_PROV2_C2_L2_SMALLSTRUCT,
    TEST_EVENT_PROV2_C2_L3_DWORDANDSTRINGANDSTRUCT,
    TEST_EVENT_PROV2_C2_L4_BIGSTRUCT,
    TEST_EVENT_PROV2_C2_L5_STRUCTARRAY,
    TEST_EVENT_PROV2_C2_L2_MEDSTRUCT,
    TEST_EVENT_PROV2_C2_L2_BYTEARRAY},
    //provider 2 - test channel 4
    {TEST_EVENT_PROV2_C3_L1_DWORD,
    TEST_EVENT_PROV2_C3_L1_DWORDANDSTRING,
    TEST_EVENT_PROV2_C3_L2_SMALLSTRUCT,
    TEST_EVENT_PROV2_C3_L3_DWORDANDSTRINGANDSTRUCT,
    TEST_EVENT_PROV2_C3_L4_BIGSTRUCT,
    TEST_EVENT_PROV2_C3_L5_STRUCTARRAY,
    TEST_EVENT_PROV2_C3_L2_MEDSTRUCT,
    TEST_EVENT_PROV2_C3_L2_BYTEARRAY},
    //provider 3 - invalid reg
    {TEST_EVENT_PROV3_C1_DWORD,
    TEST_EVENT_PROV3_C1_DWORD,
    TEST_EVENT_PROV3_C1_DWORD,
    TEST_EVENT_PROV3_C1_DWORD,
    TEST_EVENT_PROV3_C1_DWORD,
    TEST_EVENT_PROV3_C1_DWORD,
    TEST_EVENT_PROV3_C1_DWORD,
    TEST_EVENT_PROV3_C1_DWORD},
    //Provider 0 - invalid channel
    {TEST_EVENT_PROV1_C_INVALID,
    TEST_EVENT_PROV1_C_INVALID,
    TEST_EVENT_PROV1_C_INVALID,
    TEST_EVENT_PROV1_C_INVALID,
    TEST_EVENT_PROV1_C_INVALID,
    TEST_EVENT_PROV1_C_INVALID,
    TEST_EVENT_PROV1_C_INVALID,
    TEST_EVENT_PROV1_C_INVALID},
    //provider 3 - too long channel name test (BVT 2061)
    
    {TEST_EVENT_INVALID_L1_DWORD,
    TEST_EVENT_INVALID_L1_DWORDANDSTRING,
    TEST_EVENT_INVALID_L2_SMALLSTRUCT,
    TEST_EVENT_INVALID_L3_DWORDANDSTRINGANDSTRUCT,
    TEST_EVENT_INVALID_L4_TOOBIG,
    TEST_EVENT_INVALID_L2_STRUCTARRAY,
    TEST_EVENT_INVALID_L2_MEDSTRUCT,
    TEST_EVENT_INVALID_L2_BYTEARRAY},
    //WINDOWSCE_EVENTLOG_TEST_PUBLISHER_APPLICATION
    {TEST_EVENT_PROV4_L1_DWORD,
    TEST_EVENT_PROV4_L1_DWORDANDSTRING,
    TEST_EVENT_PROV4_L2_SMALLSTRUCT,
    TEST_EVENT_PROV4_L3_DWORDANDSTRINGANDSTRUCT,
    TEST_EVENT_PROV4_L4_TOOBIG,
    TEST_EVENT_PROV4_L2_STRUCTARRAY,
    TEST_EVENT_PROV4_L2_MEDSTRUCT,
    TEST_EVENT_PROV4_L2_BYTEARRAY},
    //WINDOWSCE_EVENTLOG_TEST_PUBLISHER_SYSTEM
    {TEST_EVENT_PROV5_L1_DWORD,
    TEST_EVENT_PROV5_L1_DWORDANDSTRING,
    TEST_EVENT_PROV5_L2_SMALLSTRUCT,
    TEST_EVENT_PROV5_L3_DWORDANDSTRINGANDSTRUCT,
    TEST_EVENT_PROV5_L4_TOOBIG,
    TEST_EVENT_PROV5_L2_STRUCTARRAY,
    TEST_EVENT_PROV5_L2_MEDSTRUCT,
    TEST_EVENT_PROV5_L2_BYTEARRAY},
    //WINDOWSCE_EVENTLOG_TEST_PUBLISHER_SECURITY
    {TEST_EVENT_PROV6_L1_DWORD,
    TEST_EVENT_PROV6_L1_DWORDANDSTRING,
    TEST_EVENT_PROV6_L2_SMALLSTRUCT,
    TEST_EVENT_PROV6_L3_DWORDANDSTRINGANDSTRUCT,
    TEST_EVENT_PROV6_L4_TOOBIG,
    TEST_EVENT_PROV6_L2_STRUCTARRAY,
    TEST_EVENT_PROV6_L2_MEDSTRUCT,
    TEST_EVENT_PROV6_L2_BYTEARRAY}
    
};

#define SMALLSTRUCT_SIZEOF_ARRAY        12
struct SmallStruct{
    unsigned short int nShort;
    BYTE arrByte[SMALLSTRUCT_SIZEOF_ARRAY];
};

#define BIGSTRUCT_SIZEOF_ARRAY          TEST_CHANNEL_1_BUFFER_SIZE * 2
struct BigStruct{
    unsigned short int nShort;
    BYTE arrByte[BIGSTRUCT_SIZEOF_ARRAY];
};

#define MEDSTRUCT_SIZEOF_ARRAY 2000//TEST_CHANNEL_1_BUFFER_SIZE - EVENT_OVERHEAD - sizeof(unsigned short int)  + 1 
#define MED_STRUCT_SIZE                 MEDSTRUCT_SIZEOF_ARRAY + 2
struct MedStruct{
    unsigned short int nShort;
    BYTE arrByte[MEDSTRUCT_SIZEOF_ARRAY];
};
#define TEST_BYTES_ARRAY_SIZE           12
const BYTE g_arrTestBytes[] = {170, 255, 0, 170,
                                85, 0, 255, 85,
                                240, 255, 0, 15};

WCHAR *gc_pMyString = L"Hello World, I'm a string";

#endif //_EVENTLOG_GLOBALS_H_
