//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this source code is subject to the terms of the Microsoft shared
// source or premium shared source license agreement under which you licensed
// this source code. If you did not accept the terms of the license agreement,
// you are not authorized to use this source code. For the terms of the license,
// please see the license agreement between you and Microsoft or, if applicable,
// see the SOURCE.RTF on your install media or the root of your tools installation.
// THE SOURCE CODE IS PROVIDED "AS IS", WITH NO WARRANTIES.
//
#pragma once
#include <d3dm.h>
/*
HRESULT CreateTestColors(UINT uiIteration, DWORD *pdwColorFront, DWORD *pdwColorBack);

HRESULT SetupIter(
	UINT uiIteration,
	LPDIRECT3DMOBILEVERTEXBUFFER *ppVB,
	D3DMBLEND SourceBlend,
	D3DMBLEND DestBlend,
	D3DMBLENDOP BlendOp
	);

HRESULT DrawIter(
	UINT uiTestCase,
	UINT uiIteration,
 	D3DMBLEND SourceBlend,
	D3DMBLEND DestBlend,
	D3DMBLENDOP BlendOp
	);

HRESULT VerifyIter(
	UINT uiIteration,
	UINT uiTolerance,
	BYTE Red,
	BYTE Green,
	BYTE Blue,
 	D3DMBLEND SourceBlend,
	D3DMBLEND DestBlend,
	D3DMBLENDOP BlendOp
   );

INT ExecuteTestCase(UINT uiTestCase, UINT uiSkipCount, UINT uiTolerance);
*/

//
// FVF to use for this test case
//
#define D3DQA_NUMVERTS 12
#define D3DMFVF_CUSTOMVERTEX (D3DMFVF_XYZRHW_FLOAT|D3DMFVF_DIFFUSE)
struct CUSTOMVERTEX
{
	float x,y,z,rhw;  // Position
	D3DMCOLOR color;   // Color
};


#define D3DQA_DEPTH_FRONT 0.5f
#define D3DQA_DEPTH_BACK 0.9f







//
// Permutations described in detail, in QA code
//
#define D3DQA_ITERATIONS (9*256)

typedef struct _ALPHAQA {
 	D3DMBLEND SourceBlend;
	D3DMBLEND DestBlend;
	D3DMBLENDOP BlendOp;
} ALPHAQA, *LPALPHAQA;

#define D3DQA_ALPHA_NUMTESTS (121*5)
static ALPHAQA AlphaTests[] = 
{

// Blend Op:  Add  (121 permutations)

	{D3DMBLEND_ZERO        , D3DMBLEND_ZERO            , D3DMBLENDOP_ADD},
	{D3DMBLEND_ZERO        , D3DMBLEND_ONE             , D3DMBLENDOP_ADD},
	{D3DMBLEND_ZERO        , D3DMBLEND_SRCCOLOR        , D3DMBLENDOP_ADD},
	{D3DMBLEND_ZERO        , D3DMBLEND_INVSRCCOLOR     , D3DMBLENDOP_ADD},
	{D3DMBLEND_ZERO        , D3DMBLEND_SRCALPHA        , D3DMBLENDOP_ADD},
	{D3DMBLEND_ZERO        , D3DMBLEND_INVSRCALPHA     , D3DMBLENDOP_ADD},
	{D3DMBLEND_ZERO        , D3DMBLEND_DESTALPHA       , D3DMBLENDOP_ADD},
	{D3DMBLEND_ZERO        , D3DMBLEND_INVDESTALPHA    , D3DMBLENDOP_ADD},
	{D3DMBLEND_ZERO        , D3DMBLEND_DESTCOLOR       , D3DMBLENDOP_ADD},
	{D3DMBLEND_ZERO        , D3DMBLEND_INVDESTCOLOR    , D3DMBLENDOP_ADD},
	{D3DMBLEND_ZERO        , D3DMBLEND_SRCALPHASAT     , D3DMBLENDOP_ADD},

	{D3DMBLEND_ONE         , D3DMBLEND_ZERO            , D3DMBLENDOP_ADD},
	{D3DMBLEND_ONE         , D3DMBLEND_ONE             , D3DMBLENDOP_ADD},
	{D3DMBLEND_ONE         , D3DMBLEND_SRCCOLOR        , D3DMBLENDOP_ADD},
	{D3DMBLEND_ONE         , D3DMBLEND_INVSRCCOLOR     , D3DMBLENDOP_ADD},
	{D3DMBLEND_ONE         , D3DMBLEND_SRCALPHA        , D3DMBLENDOP_ADD},
	{D3DMBLEND_ONE         , D3DMBLEND_INVSRCALPHA     , D3DMBLENDOP_ADD},
	{D3DMBLEND_ONE         , D3DMBLEND_DESTALPHA       , D3DMBLENDOP_ADD},
	{D3DMBLEND_ONE         , D3DMBLEND_INVDESTALPHA    , D3DMBLENDOP_ADD},
	{D3DMBLEND_ONE         , D3DMBLEND_DESTCOLOR       , D3DMBLENDOP_ADD},
	{D3DMBLEND_ONE         , D3DMBLEND_INVDESTCOLOR    , D3DMBLENDOP_ADD},
	{D3DMBLEND_ONE         , D3DMBLEND_SRCALPHASAT     , D3DMBLENDOP_ADD},

	{D3DMBLEND_SRCCOLOR    , D3DMBLEND_ZERO            , D3DMBLENDOP_ADD},
	{D3DMBLEND_SRCCOLOR    , D3DMBLEND_ONE             , D3DMBLENDOP_ADD},
	{D3DMBLEND_SRCCOLOR    , D3DMBLEND_SRCCOLOR        , D3DMBLENDOP_ADD},
	{D3DMBLEND_SRCCOLOR    , D3DMBLEND_INVSRCCOLOR     , D3DMBLENDOP_ADD},
	{D3DMBLEND_SRCCOLOR    , D3DMBLEND_SRCALPHA        , D3DMBLENDOP_ADD},
	{D3DMBLEND_SRCCOLOR    , D3DMBLEND_INVSRCALPHA     , D3DMBLENDOP_ADD},
	{D3DMBLEND_SRCCOLOR    , D3DMBLEND_DESTALPHA       , D3DMBLENDOP_ADD},
	{D3DMBLEND_SRCCOLOR    , D3DMBLEND_INVDESTALPHA    , D3DMBLENDOP_ADD},
	{D3DMBLEND_SRCCOLOR    , D3DMBLEND_DESTCOLOR       , D3DMBLENDOP_ADD},
	{D3DMBLEND_SRCCOLOR    , D3DMBLEND_INVDESTCOLOR    , D3DMBLENDOP_ADD},
	{D3DMBLEND_SRCCOLOR    , D3DMBLEND_SRCALPHASAT     , D3DMBLENDOP_ADD},

	{D3DMBLEND_INVSRCCOLOR , D3DMBLEND_ZERO            , D3DMBLENDOP_ADD},
	{D3DMBLEND_INVSRCCOLOR , D3DMBLEND_ONE             , D3DMBLENDOP_ADD},
	{D3DMBLEND_INVSRCCOLOR , D3DMBLEND_SRCCOLOR        , D3DMBLENDOP_ADD},
	{D3DMBLEND_INVSRCCOLOR , D3DMBLEND_INVSRCCOLOR     , D3DMBLENDOP_ADD},
	{D3DMBLEND_INVSRCCOLOR , D3DMBLEND_SRCALPHA        , D3DMBLENDOP_ADD},
	{D3DMBLEND_INVSRCCOLOR , D3DMBLEND_INVSRCALPHA     , D3DMBLENDOP_ADD},
	{D3DMBLEND_INVSRCCOLOR , D3DMBLEND_DESTALPHA       , D3DMBLENDOP_ADD},
	{D3DMBLEND_INVSRCCOLOR , D3DMBLEND_INVDESTALPHA    , D3DMBLENDOP_ADD},
	{D3DMBLEND_INVSRCCOLOR , D3DMBLEND_DESTCOLOR       , D3DMBLENDOP_ADD},
	{D3DMBLEND_INVSRCCOLOR , D3DMBLEND_INVDESTCOLOR    , D3DMBLENDOP_ADD},
	{D3DMBLEND_INVSRCCOLOR , D3DMBLEND_SRCALPHASAT     , D3DMBLENDOP_ADD},

	{D3DMBLEND_SRCALPHA    , D3DMBLEND_ZERO            , D3DMBLENDOP_ADD},
	{D3DMBLEND_SRCALPHA    , D3DMBLEND_ONE             , D3DMBLENDOP_ADD},
	{D3DMBLEND_SRCALPHA    , D3DMBLEND_SRCCOLOR        , D3DMBLENDOP_ADD},
	{D3DMBLEND_SRCALPHA    , D3DMBLEND_INVSRCCOLOR     , D3DMBLENDOP_ADD},
	{D3DMBLEND_SRCALPHA    , D3DMBLEND_SRCALPHA        , D3DMBLENDOP_ADD},
	{D3DMBLEND_SRCALPHA    , D3DMBLEND_INVSRCALPHA     , D3DMBLENDOP_ADD},
	{D3DMBLEND_SRCALPHA    , D3DMBLEND_DESTALPHA       , D3DMBLENDOP_ADD},
	{D3DMBLEND_SRCALPHA    , D3DMBLEND_INVDESTALPHA    , D3DMBLENDOP_ADD},
	{D3DMBLEND_SRCALPHA    , D3DMBLEND_DESTCOLOR       , D3DMBLENDOP_ADD},
	{D3DMBLEND_SRCALPHA    , D3DMBLEND_INVDESTCOLOR    , D3DMBLENDOP_ADD},
	{D3DMBLEND_SRCALPHA    , D3DMBLEND_SRCALPHASAT     , D3DMBLENDOP_ADD},

	{D3DMBLEND_INVSRCALPHA , D3DMBLEND_ZERO            , D3DMBLENDOP_ADD},
	{D3DMBLEND_INVSRCALPHA , D3DMBLEND_ONE             , D3DMBLENDOP_ADD},
	{D3DMBLEND_INVSRCALPHA , D3DMBLEND_SRCCOLOR        , D3DMBLENDOP_ADD},
	{D3DMBLEND_INVSRCALPHA , D3DMBLEND_INVSRCCOLOR     , D3DMBLENDOP_ADD},
	{D3DMBLEND_INVSRCALPHA , D3DMBLEND_SRCALPHA        , D3DMBLENDOP_ADD},
	{D3DMBLEND_INVSRCALPHA , D3DMBLEND_INVSRCALPHA     , D3DMBLENDOP_ADD},
	{D3DMBLEND_INVSRCALPHA , D3DMBLEND_DESTALPHA       , D3DMBLENDOP_ADD},
	{D3DMBLEND_INVSRCALPHA , D3DMBLEND_INVDESTALPHA    , D3DMBLENDOP_ADD},
	{D3DMBLEND_INVSRCALPHA , D3DMBLEND_DESTCOLOR       , D3DMBLENDOP_ADD},
	{D3DMBLEND_INVSRCALPHA , D3DMBLEND_INVDESTCOLOR    , D3DMBLENDOP_ADD},
	{D3DMBLEND_INVSRCALPHA , D3DMBLEND_SRCALPHASAT     , D3DMBLENDOP_ADD},

	{D3DMBLEND_DESTALPHA   , D3DMBLEND_ZERO            , D3DMBLENDOP_ADD},
	{D3DMBLEND_DESTALPHA   , D3DMBLEND_ONE             , D3DMBLENDOP_ADD},
	{D3DMBLEND_DESTALPHA   , D3DMBLEND_SRCCOLOR        , D3DMBLENDOP_ADD},
	{D3DMBLEND_DESTALPHA   , D3DMBLEND_INVSRCCOLOR     , D3DMBLENDOP_ADD},
	{D3DMBLEND_DESTALPHA   , D3DMBLEND_SRCALPHA        , D3DMBLENDOP_ADD},
	{D3DMBLEND_DESTALPHA   , D3DMBLEND_INVSRCALPHA     , D3DMBLENDOP_ADD},
	{D3DMBLEND_DESTALPHA   , D3DMBLEND_DESTALPHA       , D3DMBLENDOP_ADD},
	{D3DMBLEND_DESTALPHA   , D3DMBLEND_INVDESTALPHA    , D3DMBLENDOP_ADD},
	{D3DMBLEND_DESTALPHA   , D3DMBLEND_DESTCOLOR       , D3DMBLENDOP_ADD},
	{D3DMBLEND_DESTALPHA   , D3DMBLEND_INVDESTCOLOR    , D3DMBLENDOP_ADD},
	{D3DMBLEND_DESTALPHA   , D3DMBLEND_SRCALPHASAT     , D3DMBLENDOP_ADD},

	{D3DMBLEND_INVDESTALPHA, D3DMBLEND_ZERO            , D3DMBLENDOP_ADD},
	{D3DMBLEND_INVDESTALPHA, D3DMBLEND_ONE             , D3DMBLENDOP_ADD},
	{D3DMBLEND_INVDESTALPHA, D3DMBLEND_SRCCOLOR        , D3DMBLENDOP_ADD},
	{D3DMBLEND_INVDESTALPHA, D3DMBLEND_INVSRCCOLOR     , D3DMBLENDOP_ADD},
	{D3DMBLEND_INVDESTALPHA, D3DMBLEND_SRCALPHA        , D3DMBLENDOP_ADD},
	{D3DMBLEND_INVDESTALPHA, D3DMBLEND_INVSRCALPHA     , D3DMBLENDOP_ADD},
	{D3DMBLEND_INVDESTALPHA, D3DMBLEND_DESTALPHA       , D3DMBLENDOP_ADD},
	{D3DMBLEND_INVDESTALPHA, D3DMBLEND_INVDESTALPHA    , D3DMBLENDOP_ADD},
	{D3DMBLEND_INVDESTALPHA, D3DMBLEND_DESTCOLOR       , D3DMBLENDOP_ADD},
	{D3DMBLEND_INVDESTALPHA, D3DMBLEND_INVDESTCOLOR    , D3DMBLENDOP_ADD},
	{D3DMBLEND_INVDESTALPHA, D3DMBLEND_SRCALPHASAT     , D3DMBLENDOP_ADD},

	{D3DMBLEND_DESTCOLOR   , D3DMBLEND_ZERO            , D3DMBLENDOP_ADD},
	{D3DMBLEND_DESTCOLOR   , D3DMBLEND_ONE             , D3DMBLENDOP_ADD},
	{D3DMBLEND_DESTCOLOR   , D3DMBLEND_SRCCOLOR        , D3DMBLENDOP_ADD},
	{D3DMBLEND_DESTCOLOR   , D3DMBLEND_INVSRCCOLOR     , D3DMBLENDOP_ADD},
	{D3DMBLEND_DESTCOLOR   , D3DMBLEND_SRCALPHA        , D3DMBLENDOP_ADD},
	{D3DMBLEND_DESTCOLOR   , D3DMBLEND_INVSRCALPHA     , D3DMBLENDOP_ADD},
	{D3DMBLEND_DESTCOLOR   , D3DMBLEND_DESTALPHA       , D3DMBLENDOP_ADD},
	{D3DMBLEND_DESTCOLOR   , D3DMBLEND_INVDESTALPHA    , D3DMBLENDOP_ADD},
	{D3DMBLEND_DESTCOLOR   , D3DMBLEND_DESTCOLOR       , D3DMBLENDOP_ADD},
	{D3DMBLEND_DESTCOLOR   , D3DMBLEND_INVDESTCOLOR    , D3DMBLENDOP_ADD},
	{D3DMBLEND_DESTCOLOR   , D3DMBLEND_SRCALPHASAT     , D3DMBLENDOP_ADD},

	{D3DMBLEND_INVDESTCOLOR, D3DMBLEND_ZERO            , D3DMBLENDOP_ADD},
	{D3DMBLEND_INVDESTCOLOR, D3DMBLEND_ONE             , D3DMBLENDOP_ADD},
	{D3DMBLEND_INVDESTCOLOR, D3DMBLEND_SRCCOLOR        , D3DMBLENDOP_ADD},
	{D3DMBLEND_INVDESTCOLOR, D3DMBLEND_INVSRCCOLOR     , D3DMBLENDOP_ADD},
	{D3DMBLEND_INVDESTCOLOR, D3DMBLEND_SRCALPHA        , D3DMBLENDOP_ADD},
	{D3DMBLEND_INVDESTCOLOR, D3DMBLEND_INVSRCALPHA     , D3DMBLENDOP_ADD},
	{D3DMBLEND_INVDESTCOLOR, D3DMBLEND_DESTALPHA       , D3DMBLENDOP_ADD},
	{D3DMBLEND_INVDESTCOLOR, D3DMBLEND_INVDESTALPHA    , D3DMBLENDOP_ADD},
	{D3DMBLEND_INVDESTCOLOR, D3DMBLEND_DESTCOLOR       , D3DMBLENDOP_ADD},
	{D3DMBLEND_INVDESTCOLOR, D3DMBLEND_INVDESTCOLOR    , D3DMBLENDOP_ADD},
	{D3DMBLEND_INVDESTCOLOR, D3DMBLEND_SRCALPHASAT     , D3DMBLENDOP_ADD},

	{D3DMBLEND_SRCALPHASAT , D3DMBLEND_ZERO            , D3DMBLENDOP_ADD},
	{D3DMBLEND_SRCALPHASAT , D3DMBLEND_ONE             , D3DMBLENDOP_ADD},
	{D3DMBLEND_SRCALPHASAT , D3DMBLEND_SRCCOLOR        , D3DMBLENDOP_ADD},
	{D3DMBLEND_SRCALPHASAT , D3DMBLEND_INVSRCCOLOR     , D3DMBLENDOP_ADD},
	{D3DMBLEND_SRCALPHASAT , D3DMBLEND_SRCALPHA        , D3DMBLENDOP_ADD},
	{D3DMBLEND_SRCALPHASAT , D3DMBLEND_INVSRCALPHA     , D3DMBLENDOP_ADD},
	{D3DMBLEND_SRCALPHASAT , D3DMBLEND_DESTALPHA       , D3DMBLENDOP_ADD},
	{D3DMBLEND_SRCALPHASAT , D3DMBLEND_INVDESTALPHA    , D3DMBLENDOP_ADD},
	{D3DMBLEND_SRCALPHASAT , D3DMBLEND_DESTCOLOR       , D3DMBLENDOP_ADD},
	{D3DMBLEND_SRCALPHASAT , D3DMBLEND_INVDESTCOLOR    , D3DMBLENDOP_ADD},
	{D3DMBLEND_SRCALPHASAT , D3DMBLEND_SRCALPHASAT     , D3DMBLENDOP_ADD},


// Blend Op:  Subtract  (121 permutations)

	{D3DMBLEND_ZERO        , D3DMBLEND_ZERO            , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_ZERO        , D3DMBLEND_ONE             , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_ZERO        , D3DMBLEND_SRCCOLOR        , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_ZERO        , D3DMBLEND_INVSRCCOLOR     , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_ZERO        , D3DMBLEND_SRCALPHA        , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_ZERO        , D3DMBLEND_INVSRCALPHA     , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_ZERO        , D3DMBLEND_DESTALPHA       , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_ZERO        , D3DMBLEND_INVDESTALPHA    , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_ZERO        , D3DMBLEND_DESTCOLOR       , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_ZERO        , D3DMBLEND_INVDESTCOLOR    , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_ZERO        , D3DMBLEND_SRCALPHASAT     , D3DMBLENDOP_SUBTRACT},

	{D3DMBLEND_ONE         , D3DMBLEND_ZERO            , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_ONE         , D3DMBLEND_ONE             , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_ONE         , D3DMBLEND_SRCCOLOR        , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_ONE         , D3DMBLEND_INVSRCCOLOR     , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_ONE         , D3DMBLEND_SRCALPHA        , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_ONE         , D3DMBLEND_INVSRCALPHA     , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_ONE         , D3DMBLEND_DESTALPHA       , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_ONE         , D3DMBLEND_INVDESTALPHA    , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_ONE         , D3DMBLEND_DESTCOLOR       , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_ONE         , D3DMBLEND_INVDESTCOLOR    , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_ONE         , D3DMBLEND_SRCALPHASAT     , D3DMBLENDOP_SUBTRACT},

	{D3DMBLEND_SRCCOLOR    , D3DMBLEND_ZERO            , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_SRCCOLOR    , D3DMBLEND_ONE             , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_SRCCOLOR    , D3DMBLEND_SRCCOLOR        , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_SRCCOLOR    , D3DMBLEND_INVSRCCOLOR     , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_SRCCOLOR    , D3DMBLEND_SRCALPHA        , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_SRCCOLOR    , D3DMBLEND_INVSRCALPHA     , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_SRCCOLOR    , D3DMBLEND_DESTALPHA       , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_SRCCOLOR    , D3DMBLEND_INVDESTALPHA    , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_SRCCOLOR    , D3DMBLEND_DESTCOLOR       , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_SRCCOLOR    , D3DMBLEND_INVDESTCOLOR    , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_SRCCOLOR    , D3DMBLEND_SRCALPHASAT     , D3DMBLENDOP_SUBTRACT},

	{D3DMBLEND_INVSRCCOLOR , D3DMBLEND_ZERO            , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_INVSRCCOLOR , D3DMBLEND_ONE             , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_INVSRCCOLOR , D3DMBLEND_SRCCOLOR        , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_INVSRCCOLOR , D3DMBLEND_INVSRCCOLOR     , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_INVSRCCOLOR , D3DMBLEND_SRCALPHA        , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_INVSRCCOLOR , D3DMBLEND_INVSRCALPHA     , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_INVSRCCOLOR , D3DMBLEND_DESTALPHA       , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_INVSRCCOLOR , D3DMBLEND_INVDESTALPHA    , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_INVSRCCOLOR , D3DMBLEND_DESTCOLOR       , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_INVSRCCOLOR , D3DMBLEND_INVDESTCOLOR    , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_INVSRCCOLOR , D3DMBLEND_SRCALPHASAT     , D3DMBLENDOP_SUBTRACT},

	{D3DMBLEND_SRCALPHA    , D3DMBLEND_ZERO            , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_SRCALPHA    , D3DMBLEND_ONE             , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_SRCALPHA    , D3DMBLEND_SRCCOLOR        , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_SRCALPHA    , D3DMBLEND_INVSRCCOLOR     , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_SRCALPHA    , D3DMBLEND_SRCALPHA        , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_SRCALPHA    , D3DMBLEND_INVSRCALPHA     , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_SRCALPHA    , D3DMBLEND_DESTALPHA       , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_SRCALPHA    , D3DMBLEND_INVDESTALPHA    , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_SRCALPHA    , D3DMBLEND_DESTCOLOR       , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_SRCALPHA    , D3DMBLEND_INVDESTCOLOR    , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_SRCALPHA    , D3DMBLEND_SRCALPHASAT     , D3DMBLENDOP_SUBTRACT},

	{D3DMBLEND_INVSRCALPHA , D3DMBLEND_ZERO            , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_INVSRCALPHA , D3DMBLEND_ONE             , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_INVSRCALPHA , D3DMBLEND_SRCCOLOR        , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_INVSRCALPHA , D3DMBLEND_INVSRCCOLOR     , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_INVSRCALPHA , D3DMBLEND_SRCALPHA        , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_INVSRCALPHA , D3DMBLEND_INVSRCALPHA     , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_INVSRCALPHA , D3DMBLEND_DESTALPHA       , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_INVSRCALPHA , D3DMBLEND_INVDESTALPHA    , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_INVSRCALPHA , D3DMBLEND_DESTCOLOR       , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_INVSRCALPHA , D3DMBLEND_INVDESTCOLOR    , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_INVSRCALPHA , D3DMBLEND_SRCALPHASAT     , D3DMBLENDOP_SUBTRACT},

	{D3DMBLEND_DESTALPHA   , D3DMBLEND_ZERO            , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_DESTALPHA   , D3DMBLEND_ONE             , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_DESTALPHA   , D3DMBLEND_SRCCOLOR        , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_DESTALPHA   , D3DMBLEND_INVSRCCOLOR     , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_DESTALPHA   , D3DMBLEND_SRCALPHA        , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_DESTALPHA   , D3DMBLEND_INVSRCALPHA     , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_DESTALPHA   , D3DMBLEND_DESTALPHA       , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_DESTALPHA   , D3DMBLEND_INVDESTALPHA    , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_DESTALPHA   , D3DMBLEND_DESTCOLOR       , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_DESTALPHA   , D3DMBLEND_INVDESTCOLOR    , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_DESTALPHA   , D3DMBLEND_SRCALPHASAT     , D3DMBLENDOP_SUBTRACT},

	{D3DMBLEND_INVDESTALPHA, D3DMBLEND_ZERO            , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_INVDESTALPHA, D3DMBLEND_ONE             , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_INVDESTALPHA, D3DMBLEND_SRCCOLOR        , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_INVDESTALPHA, D3DMBLEND_INVSRCCOLOR     , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_INVDESTALPHA, D3DMBLEND_SRCALPHA        , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_INVDESTALPHA, D3DMBLEND_INVSRCALPHA     , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_INVDESTALPHA, D3DMBLEND_DESTALPHA       , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_INVDESTALPHA, D3DMBLEND_INVDESTALPHA    , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_INVDESTALPHA, D3DMBLEND_DESTCOLOR       , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_INVDESTALPHA, D3DMBLEND_INVDESTCOLOR    , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_INVDESTALPHA, D3DMBLEND_SRCALPHASAT     , D3DMBLENDOP_SUBTRACT},

	{D3DMBLEND_DESTCOLOR   , D3DMBLEND_ZERO            , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_DESTCOLOR   , D3DMBLEND_ONE             , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_DESTCOLOR   , D3DMBLEND_SRCCOLOR        , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_DESTCOLOR   , D3DMBLEND_INVSRCCOLOR     , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_DESTCOLOR   , D3DMBLEND_SRCALPHA        , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_DESTCOLOR   , D3DMBLEND_INVSRCALPHA     , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_DESTCOLOR   , D3DMBLEND_DESTALPHA       , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_DESTCOLOR   , D3DMBLEND_INVDESTALPHA    , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_DESTCOLOR   , D3DMBLEND_DESTCOLOR       , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_DESTCOLOR   , D3DMBLEND_INVDESTCOLOR    , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_DESTCOLOR   , D3DMBLEND_SRCALPHASAT     , D3DMBLENDOP_SUBTRACT},

	{D3DMBLEND_INVDESTCOLOR, D3DMBLEND_ZERO            , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_INVDESTCOLOR, D3DMBLEND_ONE             , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_INVDESTCOLOR, D3DMBLEND_SRCCOLOR        , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_INVDESTCOLOR, D3DMBLEND_INVSRCCOLOR     , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_INVDESTCOLOR, D3DMBLEND_SRCALPHA        , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_INVDESTCOLOR, D3DMBLEND_INVSRCALPHA     , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_INVDESTCOLOR, D3DMBLEND_DESTALPHA       , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_INVDESTCOLOR, D3DMBLEND_INVDESTALPHA    , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_INVDESTCOLOR, D3DMBLEND_DESTCOLOR       , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_INVDESTCOLOR, D3DMBLEND_INVDESTCOLOR    , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_INVDESTCOLOR, D3DMBLEND_SRCALPHASAT     , D3DMBLENDOP_SUBTRACT},

	{D3DMBLEND_SRCALPHASAT , D3DMBLEND_ZERO            , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_SRCALPHASAT , D3DMBLEND_ONE             , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_SRCALPHASAT , D3DMBLEND_SRCCOLOR        , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_SRCALPHASAT , D3DMBLEND_INVSRCCOLOR     , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_SRCALPHASAT , D3DMBLEND_SRCALPHA        , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_SRCALPHASAT , D3DMBLEND_INVSRCALPHA     , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_SRCALPHASAT , D3DMBLEND_DESTALPHA       , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_SRCALPHASAT , D3DMBLEND_INVDESTALPHA    , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_SRCALPHASAT , D3DMBLEND_DESTCOLOR       , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_SRCALPHASAT , D3DMBLEND_INVDESTCOLOR    , D3DMBLENDOP_SUBTRACT},
	{D3DMBLEND_SRCALPHASAT , D3DMBLEND_SRCALPHASAT     , D3DMBLENDOP_SUBTRACT},


// Blend Op:  Reverse Subtract  (121 permutations)

	{D3DMBLEND_ZERO        , D3DMBLEND_ZERO            , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_ZERO        , D3DMBLEND_ONE             , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_ZERO        , D3DMBLEND_SRCCOLOR        , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_ZERO        , D3DMBLEND_INVSRCCOLOR     , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_ZERO        , D3DMBLEND_SRCALPHA        , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_ZERO        , D3DMBLEND_INVSRCALPHA     , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_ZERO        , D3DMBLEND_DESTALPHA       , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_ZERO        , D3DMBLEND_INVDESTALPHA    , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_ZERO        , D3DMBLEND_DESTCOLOR       , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_ZERO        , D3DMBLEND_INVDESTCOLOR    , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_ZERO        , D3DMBLEND_SRCALPHASAT     , D3DMBLENDOP_REVSUBTRACT},

	{D3DMBLEND_ONE         , D3DMBLEND_ZERO            , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_ONE         , D3DMBLEND_ONE             , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_ONE         , D3DMBLEND_SRCCOLOR        , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_ONE         , D3DMBLEND_INVSRCCOLOR     , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_ONE         , D3DMBLEND_SRCALPHA        , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_ONE         , D3DMBLEND_INVSRCALPHA     , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_ONE         , D3DMBLEND_DESTALPHA       , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_ONE         , D3DMBLEND_INVDESTALPHA    , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_ONE         , D3DMBLEND_DESTCOLOR       , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_ONE         , D3DMBLEND_INVDESTCOLOR    , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_ONE         , D3DMBLEND_SRCALPHASAT     , D3DMBLENDOP_REVSUBTRACT},

	{D3DMBLEND_SRCCOLOR    , D3DMBLEND_ZERO            , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_SRCCOLOR    , D3DMBLEND_ONE             , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_SRCCOLOR    , D3DMBLEND_SRCCOLOR        , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_SRCCOLOR    , D3DMBLEND_INVSRCCOLOR     , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_SRCCOLOR    , D3DMBLEND_SRCALPHA        , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_SRCCOLOR    , D3DMBLEND_INVSRCALPHA     , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_SRCCOLOR    , D3DMBLEND_DESTALPHA       , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_SRCCOLOR    , D3DMBLEND_INVDESTALPHA    , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_SRCCOLOR    , D3DMBLEND_DESTCOLOR       , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_SRCCOLOR    , D3DMBLEND_INVDESTCOLOR    , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_SRCCOLOR    , D3DMBLEND_SRCALPHASAT     , D3DMBLENDOP_REVSUBTRACT},

	{D3DMBLEND_INVSRCCOLOR , D3DMBLEND_ZERO            , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_INVSRCCOLOR , D3DMBLEND_ONE             , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_INVSRCCOLOR , D3DMBLEND_SRCCOLOR        , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_INVSRCCOLOR , D3DMBLEND_INVSRCCOLOR     , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_INVSRCCOLOR , D3DMBLEND_SRCALPHA        , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_INVSRCCOLOR , D3DMBLEND_INVSRCALPHA     , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_INVSRCCOLOR , D3DMBLEND_DESTALPHA       , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_INVSRCCOLOR , D3DMBLEND_INVDESTALPHA    , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_INVSRCCOLOR , D3DMBLEND_DESTCOLOR       , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_INVSRCCOLOR , D3DMBLEND_INVDESTCOLOR    , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_INVSRCCOLOR , D3DMBLEND_SRCALPHASAT     , D3DMBLENDOP_REVSUBTRACT},

	{D3DMBLEND_SRCALPHA    , D3DMBLEND_ZERO            , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_SRCALPHA    , D3DMBLEND_ONE             , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_SRCALPHA    , D3DMBLEND_SRCCOLOR        , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_SRCALPHA    , D3DMBLEND_INVSRCCOLOR     , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_SRCALPHA    , D3DMBLEND_SRCALPHA        , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_SRCALPHA    , D3DMBLEND_INVSRCALPHA     , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_SRCALPHA    , D3DMBLEND_DESTALPHA       , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_SRCALPHA    , D3DMBLEND_INVDESTALPHA    , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_SRCALPHA    , D3DMBLEND_DESTCOLOR       , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_SRCALPHA    , D3DMBLEND_INVDESTCOLOR    , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_SRCALPHA    , D3DMBLEND_SRCALPHASAT     , D3DMBLENDOP_REVSUBTRACT},

	{D3DMBLEND_INVSRCALPHA , D3DMBLEND_ZERO            , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_INVSRCALPHA , D3DMBLEND_ONE             , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_INVSRCALPHA , D3DMBLEND_SRCCOLOR        , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_INVSRCALPHA , D3DMBLEND_INVSRCCOLOR     , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_INVSRCALPHA , D3DMBLEND_SRCALPHA        , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_INVSRCALPHA , D3DMBLEND_INVSRCALPHA     , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_INVSRCALPHA , D3DMBLEND_DESTALPHA       , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_INVSRCALPHA , D3DMBLEND_INVDESTALPHA    , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_INVSRCALPHA , D3DMBLEND_DESTCOLOR       , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_INVSRCALPHA , D3DMBLEND_INVDESTCOLOR    , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_INVSRCALPHA , D3DMBLEND_SRCALPHASAT     , D3DMBLENDOP_REVSUBTRACT},

	{D3DMBLEND_DESTALPHA   , D3DMBLEND_ZERO            , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_DESTALPHA   , D3DMBLEND_ONE             , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_DESTALPHA   , D3DMBLEND_SRCCOLOR        , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_DESTALPHA   , D3DMBLEND_INVSRCCOLOR     , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_DESTALPHA   , D3DMBLEND_SRCALPHA        , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_DESTALPHA   , D3DMBLEND_INVSRCALPHA     , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_DESTALPHA   , D3DMBLEND_DESTALPHA       , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_DESTALPHA   , D3DMBLEND_INVDESTALPHA    , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_DESTALPHA   , D3DMBLEND_DESTCOLOR       , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_DESTALPHA   , D3DMBLEND_INVDESTCOLOR    , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_DESTALPHA   , D3DMBLEND_SRCALPHASAT     , D3DMBLENDOP_REVSUBTRACT},

	{D3DMBLEND_INVDESTALPHA, D3DMBLEND_ZERO            , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_INVDESTALPHA, D3DMBLEND_ONE             , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_INVDESTALPHA, D3DMBLEND_SRCCOLOR        , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_INVDESTALPHA, D3DMBLEND_INVSRCCOLOR     , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_INVDESTALPHA, D3DMBLEND_SRCALPHA        , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_INVDESTALPHA, D3DMBLEND_INVSRCALPHA     , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_INVDESTALPHA, D3DMBLEND_DESTALPHA       , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_INVDESTALPHA, D3DMBLEND_INVDESTALPHA    , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_INVDESTALPHA, D3DMBLEND_DESTCOLOR       , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_INVDESTALPHA, D3DMBLEND_INVDESTCOLOR    , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_INVDESTALPHA, D3DMBLEND_SRCALPHASAT     , D3DMBLENDOP_REVSUBTRACT},

	{D3DMBLEND_DESTCOLOR   , D3DMBLEND_ZERO            , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_DESTCOLOR   , D3DMBLEND_ONE             , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_DESTCOLOR   , D3DMBLEND_SRCCOLOR        , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_DESTCOLOR   , D3DMBLEND_INVSRCCOLOR     , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_DESTCOLOR   , D3DMBLEND_SRCALPHA        , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_DESTCOLOR   , D3DMBLEND_INVSRCALPHA     , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_DESTCOLOR   , D3DMBLEND_DESTALPHA       , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_DESTCOLOR   , D3DMBLEND_INVDESTALPHA    , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_DESTCOLOR   , D3DMBLEND_DESTCOLOR       , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_DESTCOLOR   , D3DMBLEND_INVDESTCOLOR    , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_DESTCOLOR   , D3DMBLEND_SRCALPHASAT     , D3DMBLENDOP_REVSUBTRACT},

	{D3DMBLEND_INVDESTCOLOR, D3DMBLEND_ZERO            , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_INVDESTCOLOR, D3DMBLEND_ONE             , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_INVDESTCOLOR, D3DMBLEND_SRCCOLOR        , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_INVDESTCOLOR, D3DMBLEND_INVSRCCOLOR     , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_INVDESTCOLOR, D3DMBLEND_SRCALPHA        , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_INVDESTCOLOR, D3DMBLEND_INVSRCALPHA     , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_INVDESTCOLOR, D3DMBLEND_DESTALPHA       , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_INVDESTCOLOR, D3DMBLEND_INVDESTALPHA    , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_INVDESTCOLOR, D3DMBLEND_DESTCOLOR       , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_INVDESTCOLOR, D3DMBLEND_INVDESTCOLOR    , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_INVDESTCOLOR, D3DMBLEND_SRCALPHASAT     , D3DMBLENDOP_REVSUBTRACT},

	{D3DMBLEND_SRCALPHASAT , D3DMBLEND_ZERO            , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_SRCALPHASAT , D3DMBLEND_ONE             , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_SRCALPHASAT , D3DMBLEND_SRCCOLOR        , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_SRCALPHASAT , D3DMBLEND_INVSRCCOLOR     , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_SRCALPHASAT , D3DMBLEND_SRCALPHA        , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_SRCALPHASAT , D3DMBLEND_INVSRCALPHA     , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_SRCALPHASAT , D3DMBLEND_DESTALPHA       , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_SRCALPHASAT , D3DMBLEND_INVDESTALPHA    , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_SRCALPHASAT , D3DMBLEND_DESTCOLOR       , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_SRCALPHASAT , D3DMBLEND_INVDESTCOLOR    , D3DMBLENDOP_REVSUBTRACT},
	{D3DMBLEND_SRCALPHASAT , D3DMBLEND_SRCALPHASAT     , D3DMBLENDOP_REVSUBTRACT},


// Blend Op:  MIN  (121 permutations)

	{D3DMBLEND_ZERO        , D3DMBLEND_ZERO            , D3DMBLENDOP_MIN},
	{D3DMBLEND_ZERO        , D3DMBLEND_ONE             , D3DMBLENDOP_MIN},
	{D3DMBLEND_ZERO        , D3DMBLEND_SRCCOLOR        , D3DMBLENDOP_MIN},
	{D3DMBLEND_ZERO        , D3DMBLEND_INVSRCCOLOR     , D3DMBLENDOP_MIN},
	{D3DMBLEND_ZERO        , D3DMBLEND_SRCALPHA        , D3DMBLENDOP_MIN},
	{D3DMBLEND_ZERO        , D3DMBLEND_INVSRCALPHA     , D3DMBLENDOP_MIN},
	{D3DMBLEND_ZERO        , D3DMBLEND_DESTALPHA       , D3DMBLENDOP_MIN},
	{D3DMBLEND_ZERO        , D3DMBLEND_INVDESTALPHA    , D3DMBLENDOP_MIN},
	{D3DMBLEND_ZERO        , D3DMBLEND_DESTCOLOR       , D3DMBLENDOP_MIN},
	{D3DMBLEND_ZERO        , D3DMBLEND_INVDESTCOLOR    , D3DMBLENDOP_MIN},
	{D3DMBLEND_ZERO        , D3DMBLEND_SRCALPHASAT     , D3DMBLENDOP_MIN},

	{D3DMBLEND_ONE         , D3DMBLEND_ZERO            , D3DMBLENDOP_MIN},
	{D3DMBLEND_ONE         , D3DMBLEND_ONE             , D3DMBLENDOP_MIN},
	{D3DMBLEND_ONE         , D3DMBLEND_SRCCOLOR        , D3DMBLENDOP_MIN},
	{D3DMBLEND_ONE         , D3DMBLEND_INVSRCCOLOR     , D3DMBLENDOP_MIN},
	{D3DMBLEND_ONE         , D3DMBLEND_SRCALPHA        , D3DMBLENDOP_MIN},
	{D3DMBLEND_ONE         , D3DMBLEND_INVSRCALPHA     , D3DMBLENDOP_MIN},
	{D3DMBLEND_ONE         , D3DMBLEND_DESTALPHA       , D3DMBLENDOP_MIN},
	{D3DMBLEND_ONE         , D3DMBLEND_INVDESTALPHA    , D3DMBLENDOP_MIN},
	{D3DMBLEND_ONE         , D3DMBLEND_DESTCOLOR       , D3DMBLENDOP_MIN},
	{D3DMBLEND_ONE         , D3DMBLEND_INVDESTCOLOR    , D3DMBLENDOP_MIN},
	{D3DMBLEND_ONE         , D3DMBLEND_SRCALPHASAT     , D3DMBLENDOP_MIN},

	{D3DMBLEND_SRCCOLOR    , D3DMBLEND_ZERO            , D3DMBLENDOP_MIN},
	{D3DMBLEND_SRCCOLOR    , D3DMBLEND_ONE             , D3DMBLENDOP_MIN},
	{D3DMBLEND_SRCCOLOR    , D3DMBLEND_SRCCOLOR        , D3DMBLENDOP_MIN},
	{D3DMBLEND_SRCCOLOR    , D3DMBLEND_INVSRCCOLOR     , D3DMBLENDOP_MIN},
	{D3DMBLEND_SRCCOLOR    , D3DMBLEND_SRCALPHA        , D3DMBLENDOP_MIN},
	{D3DMBLEND_SRCCOLOR    , D3DMBLEND_INVSRCALPHA     , D3DMBLENDOP_MIN},
	{D3DMBLEND_SRCCOLOR    , D3DMBLEND_DESTALPHA       , D3DMBLENDOP_MIN},
	{D3DMBLEND_SRCCOLOR    , D3DMBLEND_INVDESTALPHA    , D3DMBLENDOP_MIN},
	{D3DMBLEND_SRCCOLOR    , D3DMBLEND_DESTCOLOR       , D3DMBLENDOP_MIN},
	{D3DMBLEND_SRCCOLOR    , D3DMBLEND_INVDESTCOLOR    , D3DMBLENDOP_MIN},
	{D3DMBLEND_SRCCOLOR    , D3DMBLEND_SRCALPHASAT     , D3DMBLENDOP_MIN},

	{D3DMBLEND_INVSRCCOLOR , D3DMBLEND_ZERO            , D3DMBLENDOP_MIN},
	{D3DMBLEND_INVSRCCOLOR , D3DMBLEND_ONE             , D3DMBLENDOP_MIN},
	{D3DMBLEND_INVSRCCOLOR , D3DMBLEND_SRCCOLOR        , D3DMBLENDOP_MIN},
	{D3DMBLEND_INVSRCCOLOR , D3DMBLEND_INVSRCCOLOR     , D3DMBLENDOP_MIN},
	{D3DMBLEND_INVSRCCOLOR , D3DMBLEND_SRCALPHA        , D3DMBLENDOP_MIN},
	{D3DMBLEND_INVSRCCOLOR , D3DMBLEND_INVSRCALPHA     , D3DMBLENDOP_MIN},
	{D3DMBLEND_INVSRCCOLOR , D3DMBLEND_DESTALPHA       , D3DMBLENDOP_MIN},
	{D3DMBLEND_INVSRCCOLOR , D3DMBLEND_INVDESTALPHA    , D3DMBLENDOP_MIN},
	{D3DMBLEND_INVSRCCOLOR , D3DMBLEND_DESTCOLOR       , D3DMBLENDOP_MIN},
	{D3DMBLEND_INVSRCCOLOR , D3DMBLEND_INVDESTCOLOR    , D3DMBLENDOP_MIN},
	{D3DMBLEND_INVSRCCOLOR , D3DMBLEND_SRCALPHASAT     , D3DMBLENDOP_MIN},

	{D3DMBLEND_SRCALPHA    , D3DMBLEND_ZERO            , D3DMBLENDOP_MIN},
	{D3DMBLEND_SRCALPHA    , D3DMBLEND_ONE             , D3DMBLENDOP_MIN},
	{D3DMBLEND_SRCALPHA    , D3DMBLEND_SRCCOLOR        , D3DMBLENDOP_MIN},
	{D3DMBLEND_SRCALPHA    , D3DMBLEND_INVSRCCOLOR     , D3DMBLENDOP_MIN},
	{D3DMBLEND_SRCALPHA    , D3DMBLEND_SRCALPHA        , D3DMBLENDOP_MIN},
	{D3DMBLEND_SRCALPHA    , D3DMBLEND_INVSRCALPHA     , D3DMBLENDOP_MIN},
	{D3DMBLEND_SRCALPHA    , D3DMBLEND_DESTALPHA       , D3DMBLENDOP_MIN},
	{D3DMBLEND_SRCALPHA    , D3DMBLEND_INVDESTALPHA    , D3DMBLENDOP_MIN},
	{D3DMBLEND_SRCALPHA    , D3DMBLEND_DESTCOLOR       , D3DMBLENDOP_MIN},
	{D3DMBLEND_SRCALPHA    , D3DMBLEND_INVDESTCOLOR    , D3DMBLENDOP_MIN},
	{D3DMBLEND_SRCALPHA    , D3DMBLEND_SRCALPHASAT     , D3DMBLENDOP_MIN},

	{D3DMBLEND_INVSRCALPHA , D3DMBLEND_ZERO            , D3DMBLENDOP_MIN},
	{D3DMBLEND_INVSRCALPHA , D3DMBLEND_ONE             , D3DMBLENDOP_MIN},
	{D3DMBLEND_INVSRCALPHA , D3DMBLEND_SRCCOLOR        , D3DMBLENDOP_MIN},
	{D3DMBLEND_INVSRCALPHA , D3DMBLEND_INVSRCCOLOR     , D3DMBLENDOP_MIN},
	{D3DMBLEND_INVSRCALPHA , D3DMBLEND_SRCALPHA        , D3DMBLENDOP_MIN},
	{D3DMBLEND_INVSRCALPHA , D3DMBLEND_INVSRCALPHA     , D3DMBLENDOP_MIN},
	{D3DMBLEND_INVSRCALPHA , D3DMBLEND_DESTALPHA       , D3DMBLENDOP_MIN},
	{D3DMBLEND_INVSRCALPHA , D3DMBLEND_INVDESTALPHA    , D3DMBLENDOP_MIN},
	{D3DMBLEND_INVSRCALPHA , D3DMBLEND_DESTCOLOR       , D3DMBLENDOP_MIN},
	{D3DMBLEND_INVSRCALPHA , D3DMBLEND_INVDESTCOLOR    , D3DMBLENDOP_MIN},
	{D3DMBLEND_INVSRCALPHA , D3DMBLEND_SRCALPHASAT     , D3DMBLENDOP_MIN},

	{D3DMBLEND_DESTALPHA   , D3DMBLEND_ZERO            , D3DMBLENDOP_MIN},
	{D3DMBLEND_DESTALPHA   , D3DMBLEND_ONE             , D3DMBLENDOP_MIN},
	{D3DMBLEND_DESTALPHA   , D3DMBLEND_SRCCOLOR        , D3DMBLENDOP_MIN},
	{D3DMBLEND_DESTALPHA   , D3DMBLEND_INVSRCCOLOR     , D3DMBLENDOP_MIN},
	{D3DMBLEND_DESTALPHA   , D3DMBLEND_SRCALPHA        , D3DMBLENDOP_MIN},
	{D3DMBLEND_DESTALPHA   , D3DMBLEND_INVSRCALPHA     , D3DMBLENDOP_MIN},
	{D3DMBLEND_DESTALPHA   , D3DMBLEND_DESTALPHA       , D3DMBLENDOP_MIN},
	{D3DMBLEND_DESTALPHA   , D3DMBLEND_INVDESTALPHA    , D3DMBLENDOP_MIN},
	{D3DMBLEND_DESTALPHA   , D3DMBLEND_DESTCOLOR       , D3DMBLENDOP_MIN},
	{D3DMBLEND_DESTALPHA   , D3DMBLEND_INVDESTCOLOR    , D3DMBLENDOP_MIN},
	{D3DMBLEND_DESTALPHA   , D3DMBLEND_SRCALPHASAT     , D3DMBLENDOP_MIN},

	{D3DMBLEND_INVDESTALPHA, D3DMBLEND_ZERO            , D3DMBLENDOP_MIN},
	{D3DMBLEND_INVDESTALPHA, D3DMBLEND_ONE             , D3DMBLENDOP_MIN},
	{D3DMBLEND_INVDESTALPHA, D3DMBLEND_SRCCOLOR        , D3DMBLENDOP_MIN},
	{D3DMBLEND_INVDESTALPHA, D3DMBLEND_INVSRCCOLOR     , D3DMBLENDOP_MIN},
	{D3DMBLEND_INVDESTALPHA, D3DMBLEND_SRCALPHA        , D3DMBLENDOP_MIN},
	{D3DMBLEND_INVDESTALPHA, D3DMBLEND_INVSRCALPHA     , D3DMBLENDOP_MIN},
	{D3DMBLEND_INVDESTALPHA, D3DMBLEND_DESTALPHA       , D3DMBLENDOP_MIN},
	{D3DMBLEND_INVDESTALPHA, D3DMBLEND_INVDESTALPHA    , D3DMBLENDOP_MIN},
	{D3DMBLEND_INVDESTALPHA, D3DMBLEND_DESTCOLOR       , D3DMBLENDOP_MIN},
	{D3DMBLEND_INVDESTALPHA, D3DMBLEND_INVDESTCOLOR    , D3DMBLENDOP_MIN},
	{D3DMBLEND_INVDESTALPHA, D3DMBLEND_SRCALPHASAT     , D3DMBLENDOP_MIN},

	{D3DMBLEND_DESTCOLOR   , D3DMBLEND_ZERO            , D3DMBLENDOP_MIN},
	{D3DMBLEND_DESTCOLOR   , D3DMBLEND_ONE             , D3DMBLENDOP_MIN},
	{D3DMBLEND_DESTCOLOR   , D3DMBLEND_SRCCOLOR        , D3DMBLENDOP_MIN},
	{D3DMBLEND_DESTCOLOR   , D3DMBLEND_INVSRCCOLOR     , D3DMBLENDOP_MIN},
	{D3DMBLEND_DESTCOLOR   , D3DMBLEND_SRCALPHA        , D3DMBLENDOP_MIN},
	{D3DMBLEND_DESTCOLOR   , D3DMBLEND_INVSRCALPHA     , D3DMBLENDOP_MIN},
	{D3DMBLEND_DESTCOLOR   , D3DMBLEND_DESTALPHA       , D3DMBLENDOP_MIN},
	{D3DMBLEND_DESTCOLOR   , D3DMBLEND_INVDESTALPHA    , D3DMBLENDOP_MIN},
	{D3DMBLEND_DESTCOLOR   , D3DMBLEND_DESTCOLOR       , D3DMBLENDOP_MIN},
	{D3DMBLEND_DESTCOLOR   , D3DMBLEND_INVDESTCOLOR    , D3DMBLENDOP_MIN},
	{D3DMBLEND_DESTCOLOR   , D3DMBLEND_SRCALPHASAT     , D3DMBLENDOP_MIN},

	{D3DMBLEND_INVDESTCOLOR, D3DMBLEND_ZERO            , D3DMBLENDOP_MIN},
	{D3DMBLEND_INVDESTCOLOR, D3DMBLEND_ONE             , D3DMBLENDOP_MIN},
	{D3DMBLEND_INVDESTCOLOR, D3DMBLEND_SRCCOLOR        , D3DMBLENDOP_MIN},
	{D3DMBLEND_INVDESTCOLOR, D3DMBLEND_INVSRCCOLOR     , D3DMBLENDOP_MIN},
	{D3DMBLEND_INVDESTCOLOR, D3DMBLEND_SRCALPHA        , D3DMBLENDOP_MIN},
	{D3DMBLEND_INVDESTCOLOR, D3DMBLEND_INVSRCALPHA     , D3DMBLENDOP_MIN},
	{D3DMBLEND_INVDESTCOLOR, D3DMBLEND_DESTALPHA       , D3DMBLENDOP_MIN},
	{D3DMBLEND_INVDESTCOLOR, D3DMBLEND_INVDESTALPHA    , D3DMBLENDOP_MIN},
	{D3DMBLEND_INVDESTCOLOR, D3DMBLEND_DESTCOLOR       , D3DMBLENDOP_MIN},
	{D3DMBLEND_INVDESTCOLOR, D3DMBLEND_INVDESTCOLOR    , D3DMBLENDOP_MIN},
	{D3DMBLEND_INVDESTCOLOR, D3DMBLEND_SRCALPHASAT     , D3DMBLENDOP_MIN},

	{D3DMBLEND_SRCALPHASAT , D3DMBLEND_ZERO            , D3DMBLENDOP_MIN},
	{D3DMBLEND_SRCALPHASAT , D3DMBLEND_ONE             , D3DMBLENDOP_MIN},
	{D3DMBLEND_SRCALPHASAT , D3DMBLEND_SRCCOLOR        , D3DMBLENDOP_MIN},
	{D3DMBLEND_SRCALPHASAT , D3DMBLEND_INVSRCCOLOR     , D3DMBLENDOP_MIN},
	{D3DMBLEND_SRCALPHASAT , D3DMBLEND_SRCALPHA        , D3DMBLENDOP_MIN},
	{D3DMBLEND_SRCALPHASAT , D3DMBLEND_INVSRCALPHA     , D3DMBLENDOP_MIN},
	{D3DMBLEND_SRCALPHASAT , D3DMBLEND_DESTALPHA       , D3DMBLENDOP_MIN},
	{D3DMBLEND_SRCALPHASAT , D3DMBLEND_INVDESTALPHA    , D3DMBLENDOP_MIN},
	{D3DMBLEND_SRCALPHASAT , D3DMBLEND_DESTCOLOR       , D3DMBLENDOP_MIN},
	{D3DMBLEND_SRCALPHASAT , D3DMBLEND_INVDESTCOLOR    , D3DMBLENDOP_MIN},
	{D3DMBLEND_SRCALPHASAT , D3DMBLEND_SRCALPHASAT     , D3DMBLENDOP_MIN},


// Blend Op:  MAX  (121 permutations)

	{D3DMBLEND_ZERO        , D3DMBLEND_ZERO            , D3DMBLENDOP_MAX},
	{D3DMBLEND_ZERO        , D3DMBLEND_ONE             , D3DMBLENDOP_MAX},
	{D3DMBLEND_ZERO        , D3DMBLEND_SRCCOLOR        , D3DMBLENDOP_MAX},
	{D3DMBLEND_ZERO        , D3DMBLEND_INVSRCCOLOR     , D3DMBLENDOP_MAX},
	{D3DMBLEND_ZERO        , D3DMBLEND_SRCALPHA        , D3DMBLENDOP_MAX},
	{D3DMBLEND_ZERO        , D3DMBLEND_INVSRCALPHA     , D3DMBLENDOP_MAX},
	{D3DMBLEND_ZERO        , D3DMBLEND_DESTALPHA       , D3DMBLENDOP_MAX},
	{D3DMBLEND_ZERO        , D3DMBLEND_INVDESTALPHA    , D3DMBLENDOP_MAX},
	{D3DMBLEND_ZERO        , D3DMBLEND_DESTCOLOR       , D3DMBLENDOP_MAX},
	{D3DMBLEND_ZERO        , D3DMBLEND_INVDESTCOLOR    , D3DMBLENDOP_MAX},
	{D3DMBLEND_ZERO        , D3DMBLEND_SRCALPHASAT     , D3DMBLENDOP_MAX},

	{D3DMBLEND_ONE         , D3DMBLEND_ZERO            , D3DMBLENDOP_MAX},
	{D3DMBLEND_ONE         , D3DMBLEND_ONE             , D3DMBLENDOP_MAX},
	{D3DMBLEND_ONE         , D3DMBLEND_SRCCOLOR        , D3DMBLENDOP_MAX},
	{D3DMBLEND_ONE         , D3DMBLEND_INVSRCCOLOR     , D3DMBLENDOP_MAX},
	{D3DMBLEND_ONE         , D3DMBLEND_SRCALPHA        , D3DMBLENDOP_MAX},
	{D3DMBLEND_ONE         , D3DMBLEND_INVSRCALPHA     , D3DMBLENDOP_MAX},
	{D3DMBLEND_ONE         , D3DMBLEND_DESTALPHA       , D3DMBLENDOP_MAX},
	{D3DMBLEND_ONE         , D3DMBLEND_INVDESTALPHA    , D3DMBLENDOP_MAX},
	{D3DMBLEND_ONE         , D3DMBLEND_DESTCOLOR       , D3DMBLENDOP_MAX},
	{D3DMBLEND_ONE         , D3DMBLEND_INVDESTCOLOR    , D3DMBLENDOP_MAX},
	{D3DMBLEND_ONE         , D3DMBLEND_SRCALPHASAT     , D3DMBLENDOP_MAX},

	{D3DMBLEND_SRCCOLOR    , D3DMBLEND_ZERO            , D3DMBLENDOP_MAX},
	{D3DMBLEND_SRCCOLOR    , D3DMBLEND_ONE             , D3DMBLENDOP_MAX},
	{D3DMBLEND_SRCCOLOR    , D3DMBLEND_SRCCOLOR        , D3DMBLENDOP_MAX},
	{D3DMBLEND_SRCCOLOR    , D3DMBLEND_INVSRCCOLOR     , D3DMBLENDOP_MAX},
	{D3DMBLEND_SRCCOLOR    , D3DMBLEND_SRCALPHA        , D3DMBLENDOP_MAX},
	{D3DMBLEND_SRCCOLOR    , D3DMBLEND_INVSRCALPHA     , D3DMBLENDOP_MAX},
	{D3DMBLEND_SRCCOLOR    , D3DMBLEND_DESTALPHA       , D3DMBLENDOP_MAX},
	{D3DMBLEND_SRCCOLOR    , D3DMBLEND_INVDESTALPHA    , D3DMBLENDOP_MAX},
	{D3DMBLEND_SRCCOLOR    , D3DMBLEND_DESTCOLOR       , D3DMBLENDOP_MAX},
	{D3DMBLEND_SRCCOLOR    , D3DMBLEND_INVDESTCOLOR    , D3DMBLENDOP_MAX},
	{D3DMBLEND_SRCCOLOR    , D3DMBLEND_SRCALPHASAT     , D3DMBLENDOP_MAX},

	{D3DMBLEND_INVSRCCOLOR , D3DMBLEND_ZERO            , D3DMBLENDOP_MAX},
	{D3DMBLEND_INVSRCCOLOR , D3DMBLEND_ONE             , D3DMBLENDOP_MAX},
	{D3DMBLEND_INVSRCCOLOR , D3DMBLEND_SRCCOLOR        , D3DMBLENDOP_MAX},
	{D3DMBLEND_INVSRCCOLOR , D3DMBLEND_INVSRCCOLOR     , D3DMBLENDOP_MAX},
	{D3DMBLEND_INVSRCCOLOR , D3DMBLEND_SRCALPHA        , D3DMBLENDOP_MAX},
	{D3DMBLEND_INVSRCCOLOR , D3DMBLEND_INVSRCALPHA     , D3DMBLENDOP_MAX},
	{D3DMBLEND_INVSRCCOLOR , D3DMBLEND_DESTALPHA       , D3DMBLENDOP_MAX},
	{D3DMBLEND_INVSRCCOLOR , D3DMBLEND_INVDESTALPHA    , D3DMBLENDOP_MAX},
	{D3DMBLEND_INVSRCCOLOR , D3DMBLEND_DESTCOLOR       , D3DMBLENDOP_MAX},
	{D3DMBLEND_INVSRCCOLOR , D3DMBLEND_INVDESTCOLOR    , D3DMBLENDOP_MAX},
	{D3DMBLEND_INVSRCCOLOR , D3DMBLEND_SRCALPHASAT     , D3DMBLENDOP_MAX},

	{D3DMBLEND_SRCALPHA    , D3DMBLEND_ZERO            , D3DMBLENDOP_MAX},
	{D3DMBLEND_SRCALPHA    , D3DMBLEND_ONE             , D3DMBLENDOP_MAX},
	{D3DMBLEND_SRCALPHA    , D3DMBLEND_SRCCOLOR        , D3DMBLENDOP_MAX},
	{D3DMBLEND_SRCALPHA    , D3DMBLEND_INVSRCCOLOR     , D3DMBLENDOP_MAX},
	{D3DMBLEND_SRCALPHA    , D3DMBLEND_SRCALPHA        , D3DMBLENDOP_MAX},
	{D3DMBLEND_SRCALPHA    , D3DMBLEND_INVSRCALPHA     , D3DMBLENDOP_MAX},
	{D3DMBLEND_SRCALPHA    , D3DMBLEND_DESTALPHA       , D3DMBLENDOP_MAX},
	{D3DMBLEND_SRCALPHA    , D3DMBLEND_INVDESTALPHA    , D3DMBLENDOP_MAX},
	{D3DMBLEND_SRCALPHA    , D3DMBLEND_DESTCOLOR       , D3DMBLENDOP_MAX},
	{D3DMBLEND_SRCALPHA    , D3DMBLEND_INVDESTCOLOR    , D3DMBLENDOP_MAX},
	{D3DMBLEND_SRCALPHA    , D3DMBLEND_SRCALPHASAT     , D3DMBLENDOP_MAX},

	{D3DMBLEND_INVSRCALPHA , D3DMBLEND_ZERO            , D3DMBLENDOP_MAX},
	{D3DMBLEND_INVSRCALPHA , D3DMBLEND_ONE             , D3DMBLENDOP_MAX},
	{D3DMBLEND_INVSRCALPHA , D3DMBLEND_SRCCOLOR        , D3DMBLENDOP_MAX},
	{D3DMBLEND_INVSRCALPHA , D3DMBLEND_INVSRCCOLOR     , D3DMBLENDOP_MAX},
	{D3DMBLEND_INVSRCALPHA , D3DMBLEND_SRCALPHA        , D3DMBLENDOP_MAX},
	{D3DMBLEND_INVSRCALPHA , D3DMBLEND_INVSRCALPHA     , D3DMBLENDOP_MAX},
	{D3DMBLEND_INVSRCALPHA , D3DMBLEND_DESTALPHA       , D3DMBLENDOP_MAX},
	{D3DMBLEND_INVSRCALPHA , D3DMBLEND_INVDESTALPHA    , D3DMBLENDOP_MAX},
	{D3DMBLEND_INVSRCALPHA , D3DMBLEND_DESTCOLOR       , D3DMBLENDOP_MAX},
	{D3DMBLEND_INVSRCALPHA , D3DMBLEND_INVDESTCOLOR    , D3DMBLENDOP_MAX},
	{D3DMBLEND_INVSRCALPHA , D3DMBLEND_SRCALPHASAT     , D3DMBLENDOP_MAX},

	{D3DMBLEND_DESTALPHA   , D3DMBLEND_ZERO            , D3DMBLENDOP_MAX},
	{D3DMBLEND_DESTALPHA   , D3DMBLEND_ONE             , D3DMBLENDOP_MAX},
	{D3DMBLEND_DESTALPHA   , D3DMBLEND_SRCCOLOR        , D3DMBLENDOP_MAX},
	{D3DMBLEND_DESTALPHA   , D3DMBLEND_INVSRCCOLOR     , D3DMBLENDOP_MAX},
	{D3DMBLEND_DESTALPHA   , D3DMBLEND_SRCALPHA        , D3DMBLENDOP_MAX},
	{D3DMBLEND_DESTALPHA   , D3DMBLEND_INVSRCALPHA     , D3DMBLENDOP_MAX},
	{D3DMBLEND_DESTALPHA   , D3DMBLEND_DESTALPHA       , D3DMBLENDOP_MAX},
	{D3DMBLEND_DESTALPHA   , D3DMBLEND_INVDESTALPHA    , D3DMBLENDOP_MAX},
	{D3DMBLEND_DESTALPHA   , D3DMBLEND_DESTCOLOR       , D3DMBLENDOP_MAX},
	{D3DMBLEND_DESTALPHA   , D3DMBLEND_INVDESTCOLOR    , D3DMBLENDOP_MAX},
	{D3DMBLEND_DESTALPHA   , D3DMBLEND_SRCALPHASAT     , D3DMBLENDOP_MAX},

	{D3DMBLEND_INVDESTALPHA, D3DMBLEND_ZERO            , D3DMBLENDOP_MAX},
	{D3DMBLEND_INVDESTALPHA, D3DMBLEND_ONE             , D3DMBLENDOP_MAX},
	{D3DMBLEND_INVDESTALPHA, D3DMBLEND_SRCCOLOR        , D3DMBLENDOP_MAX},
	{D3DMBLEND_INVDESTALPHA, D3DMBLEND_INVSRCCOLOR     , D3DMBLENDOP_MAX},
	{D3DMBLEND_INVDESTALPHA, D3DMBLEND_SRCALPHA        , D3DMBLENDOP_MAX},
	{D3DMBLEND_INVDESTALPHA, D3DMBLEND_INVSRCALPHA     , D3DMBLENDOP_MAX},
	{D3DMBLEND_INVDESTALPHA, D3DMBLEND_DESTALPHA       , D3DMBLENDOP_MAX},
	{D3DMBLEND_INVDESTALPHA, D3DMBLEND_INVDESTALPHA    , D3DMBLENDOP_MAX},
	{D3DMBLEND_INVDESTALPHA, D3DMBLEND_DESTCOLOR       , D3DMBLENDOP_MAX},
	{D3DMBLEND_INVDESTALPHA, D3DMBLEND_INVDESTCOLOR    , D3DMBLENDOP_MAX},
	{D3DMBLEND_INVDESTALPHA, D3DMBLEND_SRCALPHASAT     , D3DMBLENDOP_MAX},

	{D3DMBLEND_DESTCOLOR   , D3DMBLEND_ZERO            , D3DMBLENDOP_MAX},
	{D3DMBLEND_DESTCOLOR   , D3DMBLEND_ONE             , D3DMBLENDOP_MAX},
	{D3DMBLEND_DESTCOLOR   , D3DMBLEND_SRCCOLOR        , D3DMBLENDOP_MAX},
	{D3DMBLEND_DESTCOLOR   , D3DMBLEND_INVSRCCOLOR     , D3DMBLENDOP_MAX},
	{D3DMBLEND_DESTCOLOR   , D3DMBLEND_SRCALPHA        , D3DMBLENDOP_MAX},
	{D3DMBLEND_DESTCOLOR   , D3DMBLEND_INVSRCALPHA     , D3DMBLENDOP_MAX},
	{D3DMBLEND_DESTCOLOR   , D3DMBLEND_DESTALPHA       , D3DMBLENDOP_MAX},
	{D3DMBLEND_DESTCOLOR   , D3DMBLEND_INVDESTALPHA    , D3DMBLENDOP_MAX},
	{D3DMBLEND_DESTCOLOR   , D3DMBLEND_DESTCOLOR       , D3DMBLENDOP_MAX},
	{D3DMBLEND_DESTCOLOR   , D3DMBLEND_INVDESTCOLOR    , D3DMBLENDOP_MAX},
	{D3DMBLEND_DESTCOLOR   , D3DMBLEND_SRCALPHASAT     , D3DMBLENDOP_MAX},

	{D3DMBLEND_INVDESTCOLOR, D3DMBLEND_ZERO            , D3DMBLENDOP_MAX},
	{D3DMBLEND_INVDESTCOLOR, D3DMBLEND_ONE             , D3DMBLENDOP_MAX},
	{D3DMBLEND_INVDESTCOLOR, D3DMBLEND_SRCCOLOR        , D3DMBLENDOP_MAX},
	{D3DMBLEND_INVDESTCOLOR, D3DMBLEND_INVSRCCOLOR     , D3DMBLENDOP_MAX},
	{D3DMBLEND_INVDESTCOLOR, D3DMBLEND_SRCALPHA        , D3DMBLENDOP_MAX},
	{D3DMBLEND_INVDESTCOLOR, D3DMBLEND_INVSRCALPHA     , D3DMBLENDOP_MAX},
	{D3DMBLEND_INVDESTCOLOR, D3DMBLEND_DESTALPHA       , D3DMBLENDOP_MAX},
	{D3DMBLEND_INVDESTCOLOR, D3DMBLEND_INVDESTALPHA    , D3DMBLENDOP_MAX},
	{D3DMBLEND_INVDESTCOLOR, D3DMBLEND_DESTCOLOR       , D3DMBLENDOP_MAX},
	{D3DMBLEND_INVDESTCOLOR, D3DMBLEND_INVDESTCOLOR    , D3DMBLENDOP_MAX},
	{D3DMBLEND_INVDESTCOLOR, D3DMBLEND_SRCALPHASAT     , D3DMBLENDOP_MAX},

	{D3DMBLEND_SRCALPHASAT , D3DMBLEND_ZERO            , D3DMBLENDOP_MAX},
	{D3DMBLEND_SRCALPHASAT , D3DMBLEND_ONE             , D3DMBLENDOP_MAX},
	{D3DMBLEND_SRCALPHASAT , D3DMBLEND_SRCCOLOR        , D3DMBLENDOP_MAX},
	{D3DMBLEND_SRCALPHASAT , D3DMBLEND_INVSRCCOLOR     , D3DMBLENDOP_MAX},
	{D3DMBLEND_SRCALPHASAT , D3DMBLEND_SRCALPHA        , D3DMBLENDOP_MAX},
	{D3DMBLEND_SRCALPHASAT , D3DMBLEND_INVSRCALPHA     , D3DMBLENDOP_MAX},
	{D3DMBLEND_SRCALPHASAT , D3DMBLEND_DESTALPHA       , D3DMBLENDOP_MAX},
	{D3DMBLEND_SRCALPHASAT , D3DMBLEND_INVDESTALPHA    , D3DMBLENDOP_MAX},
	{D3DMBLEND_SRCALPHASAT , D3DMBLEND_DESTCOLOR       , D3DMBLENDOP_MAX},
	{D3DMBLEND_SRCALPHASAT , D3DMBLEND_INVDESTCOLOR    , D3DMBLENDOP_MAX},
	{D3DMBLEND_SRCALPHASAT , D3DMBLEND_SRCALPHASAT     , D3DMBLENDOP_MAX}

};


