//
// Copyright (c) Microsoft Corporation.  All rights reserved.
//
//
// Use of this source code is subject to the terms of the Microsoft shared
// source or premium shared source license agreement under which you licensed
// this source code. If you did not accept the terms of the license agreement,
// you are not authorized to use this source code. For the terms of the license,
// please see the license agreement between you and Microsoft or, if applicable,
// see the SOURCE.RTF on your install media or the root of your tools installation.
// THE SOURCE CODE IS PROVIDED "AS IS", WITH NO WARRANTIES OR INDEMNITIES.
//
////////////////////////////////////////////////////////////////////////////////
//
//  TUXTEST TUX DLL
//  Copyright (c) Microsoft Corporation
//
//  Module: US_QWERTY,h
//          
//
//  Revision History:changed #define values:
//
////////////////////////////////////////////////////////////////////////////////

#include "..\kbddef.h"

// ****************************************************
// US English QWERTY keyboard 
//
//  Num  VK1   VK2    Num   Unicode
testSequence KBDTests_USEnglish[] = 
{
    {1, {0x20, 0x00}, 1,    0x20},      // ' '
    {2, {0x10, 0x31}, 1,    0x21},      // '!'  PS #60468 on SMDK
    {2, {0x10, 0xDE}, 1,    0x22},      // '"'
    {2, {0x10, 0x33}, 1,    0x23},      // '#'
    {2, {0x10, 0x34}, 1,    0x24},      // '$'
    {2, {0x10, 0x35}, 1,    0x25},      // '%'
    {2, {0x10, 0x37}, 1,    0x26},      // '&'
    {1, {0xDE, 0x00}, 1,    0x27},      // '''
    {2, {0x10, 0x39}, 1,    0x28},      // '('
    {2, {0x10, 0x30}, 1,    0x29},      // ')'
    {2, {0x10, 0x38}, 1,    0x2A},      // '*'
    {2, {0x10, 0xBB}, 1,    0x2B},      // '+'
    {1, {0xBC, 0x00}, 1,    0x2C},      // ','
    {1, {0xBD, 0x00}, 1,    0x2D},      // '-'
    {1, {0xBE, 0x00}, 1,    0x2E},      // '.'
    {1, {0xBF, 0x00}, 1,    0X2F},      // '/'
    {1, {0x30, 0x00}, 1,    0x30},      // '0'
    {1, {0x31, 0x00}, 1,    0x31},      // '1'
    {1, {0x32, 0x00}, 1,    0x32},      // '2'
    {1, {0x33, 0x00}, 1,    0X33},      // '3'
    {1, {0x34, 0x00}, 1,    0x34},      // '4'
    {1, {0x35, 0x00}, 1,    0x35},      // '5'
    {1, {0x36, 0x00}, 1,    0x36},      // '6'
    {1, {0x37, 0x00}, 1,    0X37},      // '7'
    {1, {0x38, 0x00}, 1,    0x38},      // '8'
    {1, {0x39, 0x00}, 1,    0X39},      // '9'
    {2, {0x10, 0xBA}, 1,    0X3A},      // ':'
    {1, {0xBA, 0x00}, 1,    0X3B},      // ';'
    {2, {0x10, 0xBC}, 1,    0X3C},      // '<'
    {1, {0xBB, 0x00}, 1,    0X3D},      // '='
    {2, {0x10, 0xBE}, 1,    0X3E},      // '>'
    {2, {0x10, 0xBF}, 1,    0X3F},      // '?'
    {2, {0x10, 0x41}, 1,    0x41},      // 'A'
    {2, {0x10, 0x42}, 1,    0x42},      // 'B'
    {2, {0x10, 0x43}, 1,    0x43},      // 'C'
    {2, {0x10, 0x44}, 1,    0x44},      // 'D'
    {2, {0x10, 0x45}, 1,    0x45},      // 'E'
    {2, {0x10, 0x46}, 1,    0x46},      // 'F'
    {2, {0x10, 0x47}, 1,    0x47},      // 'G'
    {2, {0x10, 0x48}, 1,    0x48},      // 'H'
    {2, {0x10, 0x49}, 1,    0x49},      // 'I'
    {2, {0x10, 0x4A}, 1,    0x4A},      // 'J'
    {2, {0x10, 0x4B}, 1,    0x4B},      // 'K'
    {2, {0x10, 0x4C}, 1,    0x4C},      // 'L'
    {2, {0x10, 0x4D}, 1,    0x4D},      // 'M'
    {2, {0x10, 0x4E}, 1,    0x4E},      // 'N'
    {2, {0x10, 0x4F}, 1,    0x4F},      // 'O'
    {2, {0x10, 0x50}, 1,    0x50},      // 'P'
    {2, {0x10, 0x51}, 1,    0x51},      // 'Q'
    {2, {0x10, 0x52}, 1,    0x52},      // 'R'
    {2, {0x10, 0x53}, 1,    0x53},      // 'S'
    {2, {0x10, 0x54}, 1,    0x54},      // 'T'
    {2, {0x10, 0x55}, 1,    0x55},      // 'U'
    {2, {0x10, 0x56}, 1,    0x56},      // 'V'
    {2, {0x10, 0x57}, 1,    0x57},      // 'W'
    {2, {0x10, 0x58}, 1,    0x58},      // 'X'
    {2, {0x10, 0x59}, 1,    0x59},      // 'Y'
    {2, {0x10, 0x5A}, 1,    0x5A},      // 'Z'
    {1, {0xDB, 0x00}, 1,    0X5B},      // '['
    {1, {0xDC, 0x00}, 1,    0X5C},      // '\'
    {1, {0xDD, 0x00}, 1,    0X5D},      // ']'
    {2, {0x10, 0x36}, 1,    0X5E},      // '^'
    {2, {0x10, 0xBD}, 1,    0X5F},      // '_'
    {1, {0xC0, 0x00}, 1,    0X60},      // '`'
    {1, {0x41, 0x00}, 1,    0x61},      // 'a'
    {1, {0x42, 0x00}, 1,    0x62},      // 'b'
    {1, {0x43, 0x00}, 1,    0x63},      // 'c'
    {1, {0x44, 0x00}, 1,    0x64},      // 'd'
    {1, {0x45, 0x00}, 1,    0x65},      // 'e'
    {1, {0x46, 0x00}, 1,    0x66},      // 'f'
    {1, {0x47, 0x00}, 1,    0x67},      // 'g'
    {1, {0x48, 0x00}, 1,    0x68},      // 'h'
    {1, {0x49, 0x00}, 1,    0x69},      // 'i'
    {1, {0x4A, 0x00}, 1,    0x6A},      // 'j'
    {1, {0x4B, 0x00}, 1,    0x6B},      // 'k'
    {1, {0x4C, 0x00}, 1,    0x6C},      // 'l'
    {1, {0x4D, 0x00}, 1,    0x6D},      // 'm'
    {1, {0x4E, 0x00}, 1,    0x6E},      // 'n'
    {1, {0x4F, 0x00}, 1,    0x6F},      // 'o'
    {1, {0x50, 0x00}, 1,    0x70},      // 'p'
    {1, {0x51, 0x00}, 1,    0x71},      // 'q'
    {1, {0x52, 0x00}, 1,    0x72},      // 'r'
    {1, {0x53, 0x00}, 1,    0x73},      // 's'
    {1, {0x54, 0x00}, 1,    0x74},      // 't'
    {1, {0x55, 0x00}, 1,    0x75},      // 'u'
    {1, {0x56, 0x00}, 1,    0x76},      // 'v'
    {1, {0x57, 0x00}, 1,    0x77},      // 'w'
    {1, {0x58, 0x00}, 1,    0x78},      // 'x'
    {1, {0x59, 0x00}, 1,    0x79},      // 'y'
    {1, {0x5A, 0x00}, 1,    0x7A},      // 'z'
    {2, {0x10, 0xDB}, 1,    0X7B},      // '{'
    {2, {0x10, 0xDC}, 1,    0X7C},      // '|'
    {2, {0x10, 0xDD}, 1,    0X7D},      // '}'
    {2, {0x10, 0xC0}, 1,    0X7E},      // '~'

    // Control chars with CAPSLOCK OFF
    // Row ZXCVBNM 
    {2, {0x11, 90 }, 1, 0x1A },          // Ctrl Z
    {2, {0x11, 88 }, 1,  0x18 },            // Ctrl X
    {2, {0x11, 67 }, 1,  0x03 },            // Ctrl C
    {2, {0x11, 86 }, 1,  0x16 },            // Ctrl V
    {2, {0x11, 66 }, 1,  0x02 },            // Ctrl B
    {2, {0x11, 78 }, 1,  0x0E },            // Ctrl N
    {2, {0x11, 77 }, 1,  0x0D},         // Ctrl M
    //Row ASDFG
    {2, {0x11, 65 }, 1, 0x01 },         // Ctrl A
    {2, {0x11, 83 }, 1, 0x13 },         // Ctrl S
    {2, {0x11, 68 }, 1, 0x04 },         // Ctrl D
    {2, {0x11, 70 }, 1, 0x06 },         // Ctrl F
    {2, {0x11, 71 }, 1, 0x07 },         // Ctrl G
    {2, {0x11, 72 }, 1, 0x08 },         // Ctrl H
    {2, {0x11, 74 }, 1, 0x0A },         // Ctrl J
    {2, {0x11, 75 }, 1, 0x0B },         // Ctrl K
    {2, {0x11, 76 }, 1, 0x0C },         // Ctrl L
    // Row QWERTY
    {2, {0x11, 81 }, 1, 0x11 },         // Ctrl Q
    {2, {0x11, 87 }, 1, 0x17 },         // Ctrl W
    {2, {0x11, 69 }, 1, 0x05 },         // Ctrl E
    {2, {0x11, 82 }, 1, 0x12 },         // Ctrl R
    {2, {0x11, 84 }, 1, 0x14 },         // Ctrl T
    {2, {0x11, 89 }, 1, 0x19 },         // Ctrl Y
    {2, {0x11, 85 }, 1, 0x15 },         // Ctrl U
    {2, {0x11, 73 }, 1, 0x09 },         // Ctrl I
    {2, {0x11, 79 }, 1, 0x0F },         // Ctrl O
    {2, {0x11, 80 }, 1, 0x10 },         // Ctrl P



    //Turn CAPSLOCK ON
    {STATE_CAPSLOCK, {0x10, 0x14 }, 0,  0},


    // With CAPS ON 

    {1, {0x20, 0x00}, 1,    0x20},      // ' '
    {2, {0x10, 0x31}, 1,    0x21},      // '!'  PS #59965
    {2, {0x10, 0xDE}, 1,    0x22},      // '"'
    {2, {0x10, 0x33}, 1,    0x23},      // '#'
    {2, {0x10, 0x34}, 1,    0x24},      // '$'
    {2, {0x10, 0x35}, 1,    0x25},      // '%'
    {2, {0x10, 0x37}, 1,    0x26},      // '&'
    {1, {0xDE, 0x00}, 1,    0x27},      // '''
    {2, {0x10, 0x39}, 1,    0x28},      // '('
    {2, {0x10, 0x30}, 1,    0x29},      // ')'
    {2, {0x10, 0x38}, 1,    0x2A},      // '*'
    {2, {0x10, 0xBB}, 1,    0x2B},      // '+'
    {1, {0xBC, 0x00}, 1,    0x2C},      // ','
    {1, {0xBD, 0x00}, 1,    0x2D},      // '-'
    {1, {0xBE, 0x00}, 1,    0x2E},      // '.'
    {1, {0xBF, 0x00}, 1,    0X2F},      // '/'
    {1, {0x30, 0x00}, 1,    0x30},      // '0'
    {1, {0x31, 0x00}, 1,    0x31},      // '1'
    {1, {0x32, 0x00}, 1,    0x32},      // '2'
    {1, {0x33, 0x00}, 1,    0X33},      // '3'
    {1, {0x34, 0x00}, 1,    0x34},      // '4'
    {1, {0x35, 0x00}, 1,    0x35},      // '5'
    {1, {0x36, 0x00}, 1,    0x36},      // '6'
    {1, {0x37, 0x00}, 1,    0X37},      // '7'
    {1, {0x38, 0x00}, 1,    0x38},      // '8'
    {1, {0x39, 0x00}, 1,    0X39},      // '9'
    {2, {0x10, 0xBA}, 1,    0X3A},      // ':'
    {1, {0xBA, 0x00}, 1,    0X3B},      // ';'
    {2, {0x10, 0xBC}, 1,    0X3C},      // '<'
    {1, {0xBB, 0x00}, 1,    0X3D},      // '='
    {2, {0x10, 0xBE}, 1,    0X3E},      // '>'
    {2, {0x10, 0xBF}, 1,    0X3F},      // '?'
    {2, {0x10, 0x41}, 1,    0x61},      // 'a'  CAPS+shift = unshifted
    {2, {0x10, 0x42}, 1,    0x62},      // 'b'  PS #59965
    {2, {0x10, 0x43}, 1,    0x63},      // 'c'
    {2, {0x10, 0x44}, 1,    0x64},      // 'd'
    {2, {0x10, 0x45}, 1,    0x65},      // 'e'
    {2, {0x10, 0x46}, 1,    0x66},      // 'f'
    {2, {0x10, 0x47}, 1,    0x67},      // 'g'
    {2, {0x10, 0x48}, 1,    0x68},      // 'h'
    {2, {0x10, 0x49}, 1,    0x69},      // 'i'
    {2, {0x10, 0x4A}, 1,    0x6A},      // 'j'
    {2, {0x10, 0x4B}, 1,    0x6B},      // 'k'
    {2, {0x10, 0x4C}, 1,    0x6C},      // 'l'
    {2, {0x10, 0x4D}, 1,    0x6D},      // 'm'
    {2, {0x10, 0x4E}, 1,    0x6E},      // 'n'
    {2, {0x10, 0x4F}, 1,    0x6F},      // 'o'
    {2, {0x10, 0x50}, 1,    0x70},      // 'p'
    {2, {0x10, 0x51}, 1,    0x71},      // 'q'
    {2, {0x10, 0x52}, 1,    0x72},      // 'r'
    {2, {0x10, 0x53}, 1,    0x73},      // 's'
    {2, {0x10, 0x54}, 1,    0x74},      // 't'
    {2, {0x10, 0x55}, 1,    0x75},      // 'u'
    {2, {0x10, 0x56}, 1,    0x76},      // 'v'
    {2, {0x10, 0x57}, 1,    0x77},      // 'w'
    {2, {0x10, 0x58}, 1,    0x78},      // 'x'
    {2, {0x10, 0x59}, 1,    0x79},      // 'y'
    {2, {0x10, 0x5A}, 1,    0x7A},      // 'z'
    {1, {0xDB, 0x00}, 1,    0X5B},      // '['
    {1, {0xDC, 0x00}, 1,    0X5C},      // '\'
    {1, {0xDD, 0x00}, 1,    0X5D},      // ']'
    {2, {0x10, 0x36}, 1,    0X5E},      // '^'
    {2, {0x10, 0xBD}, 1,    0X5F},      // '_'
    {1, {0xC0, 0x00}, 1,    0X60},      // '`'
    {1, {0x41, 0x00}, 1,    0x41},      // 'A'
    {1, {0x42, 0x00}, 1,    0x42},      // 'B'
    {1, {0x43, 0x00}, 1,    0x43},      // 'C'
    {1, {0x44, 0x00}, 1,    0x44},      // 'D'
    {1, {0x45, 0x00}, 1,    0x45},      // 'E'
    {1, {0x46, 0x00}, 1,    0x46},      // 'F'
    {1, {0x47, 0x00}, 1,    0x47},      // 'G'
    {1, {0x48, 0x00}, 1,    0x48},      // 'H'
    {1, {0x49, 0x00}, 1,    0x49},      // 'I'
    {1, {0x4A, 0x00}, 1,    0x4A},      // 'J'
    {1, {0x4B, 0x00}, 1,    0x4B},      // 'K'
    {1, {0x4C, 0x00}, 1,    0x4C},      // 'L'
    {1, {0x4D, 0x00}, 1,    0x4D},      // 'M'
    {1, {0x4E, 0x00}, 1,    0x4E},      // 'N'
    {1, {0x4F, 0x00}, 1,    0x4F},      // 'O'
    {1, {0x50, 0x00}, 1,    0x50},      // 'P'
    {1, {0x51, 0x00}, 1,    0x51},      // 'Q'
    {1, {0x52, 0x00}, 1,    0x52},      // 'R'
    {1, {0x53, 0x00}, 1,    0x53},      // 'S'
    {1, {0x54, 0x00}, 1,    0x54},      // 'T'
    {1, {0x55, 0x00}, 1,    0x55},      // 'U'
    {1, {0x56, 0x00}, 1,    0x56},      // 'V'
    {1, {0x57, 0x00}, 1,    0x57},      // 'W'
    {1, {0x58, 0x00}, 1,    0x58},      // 'X'
    {1, {0x59, 0x00}, 1,    0x59},      // 'Y'
    {1, {0x5A, 0x00}, 1,    0x5A},      // 'Z'
    {2, {0x10, 0xDB}, 1,    0X7B},      // '{'
    {2, {0x10, 0xDC}, 1,    0X7C},      // '|'
    {2, {0x10, 0xDD}, 1,    0X7D},      // '}'
    {2, {0x10, 0xC0}, 1,    0X7E},      // '~'
    {1, {13,   0   }, 1,    13  },      // ENTER
    //  {1, {27,   0   }, 1,    27 },       // Escape key

    // Control chars  with CAPSLOCK on
    // Row ZXCVBNM 
    {2, {0x11, 90 }, 1, 0x1A },
    {2, {0x11, 88 }, 1, 0x18 },
    {2, {0x11, 67 }, 1, 0x03 },
    {2, {0x11, 86 }, 1, 0x16 },
    {2, {0x11, 66 }, 1, 0x02 },
    {2, {0x11, 78 }, 1, 0x0E },
    {2, {0x11, 77 }, 1, 0x0D},
    //Row ASDFG
    {2, {0x11, 65 }, 1, 0x01 },
    {2, {0x11, 83 }, 1, 0x13 },
    {2, {0x11, 68 }, 1, 0x04 },
    {2, {0x11, 70 }, 1, 0x06 },
    {2, {0x11, 71 }, 1, 0x07 },
    {2, {0x11, 72 }, 1, 0x08 },
    {2, {0x11, 74 }, 1, 0x0A },
    {2, {0x11, 75 }, 1, 0x0B },
    {2, {0x11, 76 }, 1, 0x0C },
    // Row QWERTY
    {2, {0x11, 81 }, 1, 0x11 },
    {2, {0x11, 87 }, 1, 0x17 },
    {2, {0x11, 69 }, 1, 0x05 },
    {2, {0x11, 82 }, 1, 0x12 },
    {2, {0x11, 84 }, 1, 0x14 },
    {2, {0x11, 89 }, 1, 0x19 },
    {2, {0x11, 85 }, 1, 0x15 },
    {2, {0x11, 73 }, 1, 0x09 },
    {2, {0x11, 79 }, 1, 0x0F },
    {2, {0x11, 80 }, 1, 0x10 },

    //Turn CAPSLOCK OFF
    {STATE_CAPSLOCK, {0x10, 0x14 }, 0,  0},
};  // end US Keyboard
