/***
*clutil.cxx - Class Lib component-wide utility functions.
*
*  Copyright (C) 1991, Microsoft Corporation.  All Rights Reserved.
*  Information Contained Herein Is Proprietary and Confidential.
*
*Purpose:
*  typelib utility functions
*
*Revision History:
*   [00] 24-Jan-93 RajivK:	Created
*
*Implementation Notes:
*
*****************************************************************************/

#include "typelib.hxx"
#include "silver.hxx"
#include <xstring.h>
#include <time.h>
#include <ctype.h>	    // for isspace() et al.
#include "xctype.h"
#include "eberr.h"


#pragma hdrstop(RTPCHNAME)

#if ID_DEBUG
#undef SZ_FILE_NAME
static char szTlibutilCxx[] = __FILE__;
#define SZ_FILE_NAME szTlibutilCxx
#endif 


// forward declarations for DBCS processing

ACHAR MapDBChar(ACHAR xch, LCID lcid);
unsigned long LHashValOfDBCSName(SYSKIND syskind, LCID lcid, const char FAR* szName);


ALLOC_CODE(LCID) g_lcidTbl[] = {
0x0405,
0x040e,
0x0415,
0x041b,
0x0419,
0x0000, //  We search till here to get the Code Page. Otherwise it defualts
	//  to the code page that contains the remaining language. (1252/1000)
0x0409,
0x040c,
0x0407,
0x0809,
0x0c09,
0x1009,
0x1409,
0x0406,
0x0413,
0x0813,
0x040b,
0x080c,
0x0c0c,
0x100c,
0x0807,
0x0c07,
0x0410,
0x0810,
0x040a,
0x080a,
0x0c0a,
0x041d,
0x0414,
0x0416,
0x0816
};

// Encoding for code pages.
//    Encoding	    CodePage/Platform
//		    WIN      MAC
//	 0	    xxx      xxx // UnknowPlatform and Code Page => Always rehash.
//	 1	    1252     10000
//	 2	    1250     10029
//	 3	    1251     10007
//
//

ALLOC_CODE(USHORT) g_usCPEncoding[] = {
			      // WIN	  MAC
 2,			      // 1250,	 10029
 2,			      // 1250,	 10029
 2,			      // 1250,	 10029
 2,			      // 1250,	 10029
 3,			      // 1251,	 10007
 1,			      // 0000	 00000 // default
 1,			      // 1252,	 10000
 1,			      // 1252,	 10000
 1,			      // 1252,	 10000
 1,			      // 1252,	 10000
 1,			      // 1252,	 10000
 1,			      // 1252,	 10000
 1,			      // 1252,	 10000
 1,			      // 1252,	 10000
 1,			      // 1252,	 10000
 1,			      // 1252,	 10000
 1,			      // 1252,	 10000
 1,			      // 1252,	 10000
 1,			      // 1252,	 10000
 1,			      // 1252,	 10000
 1,			      // 1252,	 10000
 1,			      // 1252,	 10000
 1,			      // 1252,	 10000
 1,			      // 1252,	 10000
 1,			      // 1252,	 10000
 1,			      // 1252,	 10000
 1,			      // 1252,	 10000
 1,			      // 1252,	 10000
 1,			      // 1252,	 10000
 1,			      // 1252,	 10000
 1			      // 1252,	 10000
};





// Define an array for mapping all the characters.
//

ALLOC_CODE(BYTE) g_rgbCodePage1252[] =  {
 0   ,
 1   ,
 2   ,
 3   ,
 4   ,
 5   ,
 6   ,
 7   ,
 8   ,
 9   ,
 10  ,
 11  ,
 12  ,
 13  ,
 14  ,
 15  ,
 16  ,
 17  ,
 18  ,
 19  ,
 20  ,
 21  ,
 22  ,
 23  ,
 24  ,
 25  ,
 26  ,
 27  ,
 28  ,
 29  ,
 30  ,
 31  ,
 32  ,
 33  ,
 34  ,
 35  ,
 36  ,
 37  ,
 38  ,
 39  ,
 40  ,
 41  ,
 42  ,
 43  ,
 44  ,
 45  ,
 46  ,
 0   ,
 48  ,
 49  ,
 50  ,
 51  ,
 52  ,
 53  ,
 54  ,
 55  ,
 56  ,
 57  ,
 58  ,
 59  ,
 60  ,
 61  ,
 62  ,
 63  ,
 64  ,
 65  ,
 66  ,
 67  ,
 68  ,
 69  ,
 70  ,
 71  ,
 72  ,
 73  ,
 74  ,
 75  ,
 76  ,
 77  ,
 78  ,
 79  ,
 80  ,
 81  ,
 82  ,
 83  ,
 84  ,
 85  ,
 86  ,
 86  ,
 88  ,
 85  ,
 90  ,
 91  ,
 92  ,
 93  ,
 94  ,
 95  ,
 96  ,
 65  ,
 66  ,
 67  ,
 68  ,
 69  ,
 70  ,
 71  ,
 72  ,
 73  ,
 74  ,
 75  ,
 76  ,
 77  ,
 78  ,
 79  ,
 80  ,
 81  ,
 82  ,
 83  ,
 84  ,
 85  ,
 86  ,
 86  ,
 88  ,
 85  ,
 90  ,
 123 ,
 124 ,
 125 ,
 126 ,
 127 ,
 127 ,
 127 ,
 130 ,
 70  ,
 132 ,
 133 ,
 134 ,
 135 ,
 127 ,
 137 ,
 83  ,
 139 ,
 140 ,
 127 ,
 127 ,
 127 ,
 127 ,
 145 ,
 146 ,
 147 ,
 148 ,
 149 ,
 150 ,
 150 ,
 152 ,
 153 ,
 83  ,
 155 ,
 140 ,
 127 ,
 127 ,
 85  ,
 160 ,
 161 ,
 162 ,
 163 ,
 164 ,
 165 ,
 166 ,
 167 ,
 168 ,
 169 ,
 65  ,
 171 ,
 172 ,
 150 ,
 174 ,
 175 ,
 176 ,
 177 ,
 50  ,
 51  ,
 180 ,
 181 ,
 182 ,
 183 ,
 184 ,
 49  ,
 79  ,
 187 ,
 188 ,
 189 ,
 190 ,
 191 ,
 65  ,
 65  ,
 65  ,
 65  ,
 65  ,
 65  ,
 65  ,
 67  ,
 69  ,
 69  ,
 69  ,
 69  ,
 73  ,
 73  ,
 73  ,
 73  ,
 68  ,
 78  ,
 79  ,
 79  ,
 79  ,
 79  ,
 79  ,
 215 ,
 79  ,
 85  ,
 85  ,
 85  ,
 85  ,
 85  ,
 222 ,
 223 ,
 65  ,
 65  ,
 65  ,
 65  ,
 65  ,
 65  ,
 65  ,
 67  ,
 69  ,
 69  ,
 69  ,
 69  ,
 73  ,
 73  ,
 73  ,
 73  ,
 68  ,
 78  ,
 79  ,
 79  ,
 79  ,
 79  ,
 79  ,
 247 ,
 79  ,
 85  ,
 85  ,
 85  ,
 85  ,
 85  ,
 222 ,
 85
};

ALLOC_CODE(BYTE) g_rgbCodePage10000[] =  {
 0  ,
 1  ,
 2  ,
 3  ,
 4  ,
 5  ,
 6  ,
 7  ,
 8  ,
 9  ,
 10 ,
 11 ,
 12 ,
 13 ,
 14 ,
 15 ,
 16 ,
 17 ,
 18 ,
 19 ,
 20 ,
 21 ,
 22 ,
 23 ,
 24 ,
 25 ,
 26 ,
 27 ,
 28 ,
 29 ,
 30 ,
 31 ,
 32 ,
 33 ,
 34 ,
 35 ,
 36 ,
 37 ,
 38 ,
 39 ,
 40 ,
 41 ,
 42 ,
 43 ,
 44 ,
 45 ,
 46 ,
 0  ,
 48 ,
 49 ,
 50 ,
 51 ,
 52 ,
 53 ,
 54 ,
 55 ,
 56 ,
 57 ,
 58 ,
 59 ,
 60 ,
 61 ,
 62 ,
 63 ,
 64 ,
 65 ,
 66 ,
 67 ,
 68 ,
 69 ,
 70 ,
 71 ,
 72 ,
 73 ,
 74 ,
 75 ,
 76 ,
 77 ,
 78 ,
 79 ,
 80 ,
 81 ,
 82 ,
 83 ,
 84 ,
 85 ,
 86 ,
 86 ,
 88 ,
 85 ,
 90 ,
 91 ,
 92 ,
 93 ,
 94 ,
 95 ,
 96 ,
 65 ,
 66 ,
 67 ,
 68 ,
 69 ,
 70 ,
 71 ,
 72 ,
 73 ,
 74 ,
 75 ,
 76 ,
 77 ,
 78 ,
 79 ,
 80 ,
 81 ,
 82 ,
 83 ,
 84 ,
 85 ,
 86 ,
 86 ,
 88 ,
 85 ,
 90 ,
 123,
 124,
 125,
 126,
 127,
 65 ,
 65 ,
 67 ,
 69 ,
 78 ,
 79 ,
 85 ,
 65 ,
 65 ,
 65 ,
 65 ,
 65 ,
 65 ,
 67 ,
 69 ,
 69 ,
 69 ,
 69 ,
 73 ,
 73 ,
 73 ,
 73 ,
 78 ,
 79 ,
 79 ,
 79 ,
 79 ,
 79 ,
 85 ,
 85 ,
 85 ,
 85 ,
 160,
 161,
 162,
 163,
 164,
 165,
 166,
 167,
 168,
 169,
 170,
 171,
 172,
 173,
 65 ,
 79 ,
 176,
 177,
 178,
 179,
 180,
 181,
 182,
 183,
 184,
 185,
 186,
 65 ,
 79 ,
 189,
 65 ,
 79 ,
 192,
 193,
 194,
 195,
 70 ,
 197,
 198,
 199,
 200,
 201,
 202,
 65 ,
 65 ,
 79 ,
 206,
 206,
 208,
 208,
 210,
 211,
 212,
 213,
 214,
 215,
 85 ,
 85 ,
 218,
 219,
 220,
 221,
 63 ,
 63 ,
 224,
 225,
 226,
 227,
 228,
 65 ,
 69 ,
 65 ,
 69 ,
 69 ,
 73 ,
 73 ,
 73 ,
 73 ,
 79 ,
 79 ,
 63 ,
 79 ,
 85 ,
 85 ,
 85 ,
 73 ,
 127,
 247,
 127,
 249,
 250,
 251,
 63 ,
 253,
 254,
 127
};

ALLOC_CODE(BYTE) g_rgbCodePage1250[] =  {
0  ,
1  ,
2  ,
3  ,
4  ,
5  ,
6  ,
7  ,
8  ,
9  ,
10 ,
11 ,
12 ,
13 ,
14 ,
15 ,
16 ,
17 ,
18 ,
19 ,
20 ,
21 ,
22 ,
23 ,
24 ,
25 ,
26 ,
27 ,
28 ,
29 ,
30 ,
31 ,
32 ,
33 ,
34 ,
35 ,
36 ,
37 ,
38 ,
39 ,
40 ,
41 ,
42 ,
43 ,
44 ,
45 ,
46 ,
0  ,
48 ,
49 ,
50 ,
51 ,
52 ,
53 ,
54 ,
55 ,
56 ,
57 ,
58 ,
59 ,
60 ,
61 ,
62 ,
63 ,
64 ,
65 ,
66 ,
67 ,
68 ,
69 ,
70 ,
71 ,
72 ,
73 ,
74 ,
75 ,
76 ,
77 ,
78 ,
79 ,
80 ,
81 ,
82 ,
83 ,
84 ,
85 ,
86 ,
87 ,
88 ,
89 ,
90 ,
91 ,
92 ,
93 ,
94 ,
95 ,
96 ,
65 ,
66 ,
67 ,
68 ,
69 ,
70 ,
71 ,
72 ,
73 ,
74 ,
75 ,
76 ,
77 ,
78 ,
79 ,
80 ,
81 ,
82 ,
83 ,
84 ,
85 ,
86 ,
87 ,
88 ,
89 ,
90 ,
123,
124,
125,
126,
127,
127,
127,
130,
127,
132,
133,
134,
135,
127,
137,
83 ,
139,
83 ,
84 ,
90 ,
90 ,
127,
145,
146,
147,
148,
149,
150,
150,
127,
153,
83 ,
155,
83 ,
84 ,
90 ,
90 ,
160,
127,
162,
76 ,
164,
65 ,
166,
167,
168,
169,
83 ,
171,
172,
150,
174,
90 ,
176,
177,
178,
76 ,
180,
181,
182,
183,
184,
65 ,
83 ,
187,
76 ,
189,
76 ,
90 ,
82 ,
65 ,
65 ,
65 ,
65 ,
76 ,
67 ,
67 ,
67 ,
69 ,
69 ,
69 ,
69 ,
73 ,
73 ,
68 ,
208,
78 ,
78 ,
79 ,
79 ,
79 ,
79 ,
215,
82 ,
85 ,
85 ,
85 ,
85 ,
89 ,
84 ,
223,
82 ,
65 ,
65 ,
65 ,
65 ,
76 ,
67 ,
67 ,
67 ,
69 ,
69 ,
69 ,
69 ,
73 ,
73 ,
68 ,
208,
78 ,
78 ,
79 ,
79 ,
79 ,
79 ,
247,
82 ,
85 ,
85 ,
85 ,
85 ,
89 ,
84 ,
255
};

ALLOC_CODE(BYTE) g_rgbCodePage1251[] =  {
0  ,
1  ,
2  ,
3  ,
4  ,
5  ,
6  ,
7  ,
8  ,
9  ,
10 ,
11 ,
12 ,
13 ,
14 ,
15 ,
16 ,
17 ,
18 ,
19 ,
20 ,
21 ,
22 ,
23 ,
24 ,
25 ,
26 ,
27 ,
28 ,
29 ,
30 ,
31 ,
32 ,
33 ,
34 ,
35 ,
36 ,
37 ,
38 ,
39 ,
40 ,
41 ,
42 ,
43 ,
44 ,
45 ,
46 ,
0  ,
48 ,
49 ,
50 ,
51 ,
52 ,
53 ,
54 ,
55 ,
56 ,
57 ,
58 ,
59 ,
60 ,
61 ,
62 ,
63 ,
64 ,
65 ,
66 ,
67 ,
68 ,
69 ,
70 ,
71 ,
72 ,
73 ,
74 ,
75 ,
76 ,
77 ,
78 ,
79 ,
80 ,
81 ,
82 ,
83 ,
84 ,
85 ,
86 ,
87 ,
88 ,
89 ,
90 ,
91 ,
92 ,
93 ,
94 ,
95 ,
96 ,
65 ,
66 ,
67 ,
68 ,
69 ,
70 ,
71 ,
72 ,
73 ,
74 ,
75 ,
76 ,
77 ,
78 ,
79 ,
80 ,
81 ,
82 ,
83 ,
84 ,
85 ,
86 ,
87 ,
88 ,
89 ,
90 ,
123,
124,
125,
126,
127,
127,
127,
130,
70 ,
132,
133,
134,
135,
127,
137,
83 ,
139,
140,
127,
127,
127,
127,
145,
146,
147,
148,
149,
150,
150,
152,
153,
83 ,
155,
140,
127,
127,
89 ,
160,
161,
162,
163,
164,
165,
166,
167,
168,
169,
65 ,
171,
172,
150,
174,
175,
176,
177,
50 ,
51 ,
180,
181,
182,
183,
184,
49 ,
79 ,
187,
188,
189,
190,
191,
65 ,
65 ,
65 ,
65 ,
65 ,
65 ,
198,
67 ,
69 ,
69 ,
69 ,
69 ,
73 ,
73 ,
73 ,
73 ,
208,
78 ,
79 ,
79 ,
79 ,
79 ,
79 ,
215,
79 ,
85 ,
85 ,
85 ,
85 ,
89 ,
222,
223,
65 ,
65 ,
65 ,
65 ,
65 ,
65 ,
198,
67 ,
69 ,
69 ,
69 ,
69 ,
73 ,
73 ,
73 ,
73 ,
208,
78 ,
79 ,
79 ,
79 ,
79 ,
79 ,
247,
79 ,
85 ,
85 ,
85 ,
85 ,
89 ,
222,
89
};

ALLOC_CODE(BYTE) g_rgbCodePage10029[] =  {
0  ,
1  ,
2  ,
3  ,
4  ,
5  ,
6  ,
7  ,
8  ,
9  ,
10 ,
11 ,
12 ,
13 ,
14 ,
15 ,
16 ,
17 ,
18 ,
19 ,
20 ,
21 ,
22 ,
23 ,
24 ,
25 ,
26 ,
27 ,
28 ,
29 ,
30 ,
31 ,
32 ,
33 ,
34 ,
35 ,
36 ,
37 ,
38 ,
39 ,
40 ,
41 ,
42 ,
43 ,
44 ,
45 ,
46 ,
0  ,
48 ,
49 ,
50 ,
51 ,
52 ,
53 ,
54 ,
55 ,
56 ,
57 ,
58 ,
59 ,
60 ,
61 ,
62 ,
63 ,
64 ,
65 ,
66 ,
67 ,
68 ,
69 ,
70 ,
71 ,
72 ,
73 ,
74 ,
75 ,
76 ,
77 ,
78 ,
79 ,
80 ,
81 ,
82 ,
83 ,
84 ,
85 ,
86 ,
87 ,
88 ,
89 ,
90 ,
91 ,
92 ,
93 ,
94 ,
95 ,
96 ,
65 ,
66 ,
67 ,
68 ,
69 ,
70 ,
71 ,
72 ,
73 ,
74 ,
75 ,
76 ,
77 ,
78 ,
79 ,
80 ,
81 ,
82 ,
83 ,
84 ,
85 ,
86 ,
87 ,
88 ,
89 ,
90 ,
123,
124,
125,
126,
127,
65 ,
65 ,
65 ,
69 ,
65 ,
79 ,
85 ,
65 ,
65 ,
67 ,
65 ,
67 ,
67 ,
67 ,
69 ,
90 ,
90 ,
68 ,
73 ,
68 ,
69 ,
69 ,
69 ,
79 ,
69 ,
79 ,
79 ,
79 ,
85 ,
69 ,
69 ,
85 ,
160,
161,
69 ,
163,
164,
165,
166,
167,
168,
169,
170,
69 ,
172,
173,
71 ,
73 ,
73 ,
73 ,
178,
179,
73 ,
75 ,
182,
183,
76 ,
76 ,
76 ,
76 ,
76 ,
76 ,
76 ,
78 ,
78 ,
78 ,
194,
195,
78 ,
78 ,
198,
199,
200,
201,
202,
78 ,
79 ,
79 ,
79 ,
79 ,
208,
208,
210,
211,
212,
213,
214,
215,
79 ,
82 ,
82 ,
82 ,
220,
221,
82 ,
82 ,
82 ,
83 ,
226,
227,
83 ,
83 ,
83 ,
65 ,
84 ,
84 ,
73 ,
90 ,
90 ,
85 ,
79 ,
79 ,
85 ,
85 ,
85 ,
85 ,
85 ,
85 ,
85 ,
85 ,
89 ,
89 ,
75 ,
90 ,
76 ,
76 ,
71 ,
255
};

ALLOC_CODE(BYTE) g_rgbCodePage10007[] =  {
0  ,
1  ,
2  ,
3  ,
4  ,
5  ,
6  ,
7  ,
8  ,
9  ,
10 ,
11 ,
12 ,
13 ,
14 ,
15 ,
16 ,
17 ,
18 ,
19 ,
20 ,
21 ,
22 ,
23 ,
24 ,
25 ,
26 ,
27 ,
28 ,
29 ,
30 ,
31 ,
32 ,
33 ,
34 ,
35 ,
36 ,
37 ,
38 ,
39 ,
40 ,
41 ,
42 ,
43 ,
44 ,
45 ,
46 ,
0  ,
48 ,
49 ,
50 ,
51 ,
52 ,
53 ,
54 ,
55 ,
56 ,
57 ,
58 ,
59 ,
60 ,
61 ,
62 ,
63 ,
64 ,
65 ,
66 ,
67 ,
68 ,
69 ,
70 ,
71 ,
72 ,
73 ,
74 ,
75 ,
76 ,
77 ,
78 ,
79 ,
80 ,
81 ,
82 ,
83 ,
84 ,
85 ,
86 ,
87 ,
88 ,
89 ,
90 ,
91 ,
92 ,
93 ,
94 ,
95 ,
96 ,
65 ,
66 ,
67 ,
68 ,
69 ,
70 ,
71 ,
72 ,
73 ,
74 ,
75 ,
76 ,
77 ,
78 ,
79 ,
80 ,
81 ,
82 ,
83 ,
84 ,
85 ,
86 ,
87 ,
88 ,
89 ,
90 ,
123,
124,
125,
126,
127,
128,
129,
130,
131,
132,
133,
134,
135,
136,
137,
138,
139,
140,
141,
142,
143,
144,
145,
146,
147,
148,
149,
150,
151,
152,
153,
154,
155,
156,
157,
158,
159,
160,
161,
162,
163,
164,
165,
166,
167,
168,
169,
170,
171,
171,
173,
174,
174,
176,
177,
178,
179,
167,
181,
182,
183,
184,
184,
186,
186,
188,
188,
190,
190,
183,
193,
194,
195,
70 ,
197,
198,
199,
200,
201,
202,
203,
203,
205,
205,
193,
208,
208,
210,
211,
212,
213,
214,
215,
216,
216,
218,
218,
220,
221,
221,
159,
128,
129,
130,
131,
132,
133,
134,
135,
136,
137,
138,
139,
140,
141,
142,
143,
144,
145,
146,
147,
148,
149,
150,
151,
152,
153,
154,
155,
156,
157,
158,
159
};

ALLOC_CODE(BYTE) g_rgbCodePageWGreek[] =  {
0  ,
1  ,
2  ,
3  ,
4  ,
5  ,
6  ,
7  ,
8  ,
9  ,
10 ,
11 ,
12 ,
13 ,
14 ,
15 ,
16 ,
17 ,
18 ,
19 ,
20 ,
21 ,
22 ,
23 ,
24 ,
25 ,
26 ,
27 ,
28 ,
29 ,
30 ,
31 ,
32 ,
33 ,
34 ,
35 ,
36 ,
37 ,
38 ,
39 ,
40 ,
41 ,
42 ,
43 ,
44 ,
45 ,
46 ,
47 ,
48 ,
49 ,
50 ,
51 ,
52 ,
53 ,
54 ,
55 ,
56 ,
57 ,
58 ,
59 ,
60 ,
61 ,
62 ,
63 ,
64 ,
65 ,
66 ,
67 ,
68 ,
69 ,
70 ,
71 ,
72 ,
73 ,
74 ,
75 ,
76 ,
77 ,
78 ,
79 ,
80 ,
81 ,
82 ,
83 ,
84 ,
85 ,
86 ,
87 ,
88 ,
89 ,
90 ,
91 ,
92 ,
93 ,
94 ,
95 ,
96 ,
65 ,
66 ,
67 ,
68 ,
69 ,
70 ,
71 ,
72 ,
73 ,
74 ,
75 ,
76 ,
77 ,
78 ,
79 ,
80 ,
81 ,
82 ,
83 ,
84 ,
85 ,
86 ,
87 ,
88 ,
89 ,
90 ,
123,
124,
125,
126,
0  ,
0  ,
0  ,
130,
70 ,
132,
133,
134,
135,
0  ,
137,
0  ,
139,
0  ,
0  ,
0  ,
0  ,
0  ,
145,
146,
147,
148,
149,
45 ,
45 ,
0  ,
153,
0  ,
155,
0  ,
0  ,
0  ,
0  ,
9  ,
161,
162,
163,
164,
165,
166,
167,
168,
169,
0  ,
171,
172,
45 ,
174,
45 ,
176,
177,
50 ,
51 ,
180,
181,
182,
183,
184,
185,
186,
187,
188,
189,
190,
191,
186,
162,
194,
195,
196,
184,
198,
185,
200,
186,
202,
203,
204,
205,
206,
188,
208,
209,
0  ,
211,
212,
190,
214,
215,
216,
191,
186,
190,
162,
184,
185,
186,
190,
162,
194,
195,
196,
184,
198,
185,
200,
186,
202,
203,
204,
205,
206,
188,
208,
209,
211,
211,
212,
190,
214,
215,
216,
191,
186,
190,
188,
190,
191,
0
};

ALLOC_CODE(BYTE) g_rgbCodePageWIceland[] =  {
0  ,
1  ,
2  ,
3  ,
4  ,
5  ,
6  ,
7  ,
8  ,
9  ,
10 ,
11 ,
12 ,
13 ,
14 ,
15 ,
16 ,
17 ,
18 ,
19 ,
20 ,
21 ,
22 ,
23 ,
24 ,
25 ,
26 ,
27 ,
28 ,
29 ,
30 ,
31 ,
32 ,
33 ,
34 ,
35 ,
36 ,
37 ,
38 ,
39 ,
40 ,
41 ,
42 ,
43 ,
44 ,
45 ,
46 ,
47 ,
48 ,
49 ,
50 ,
51 ,
52 ,
53 ,
54 ,
55 ,
56 ,
57 ,
58 ,
59 ,
60 ,
61 ,
62 ,
63 ,
64 ,
65 ,
66 ,
67 ,
68 ,
69 ,
70 ,
71 ,
72 ,
73 ,
74 ,
75 ,
76 ,
77 ,
78 ,
79 ,
80 ,
81 ,
82 ,
83 ,
84 ,
85 ,
86 ,
87 ,
88 ,
89 ,
90 ,
91 ,
92 ,
93 ,
94 ,
95 ,
96 ,
65 ,
66 ,
67 ,
68 ,
69 ,
70 ,
71 ,
72 ,
73 ,
74 ,
75 ,
76 ,
77 ,
78 ,
79 ,
80 ,
81 ,
82 ,
83 ,
84 ,
85 ,
86 ,
87 ,
88 ,
89 ,
90 ,
123,
124,
125,
126,
0  ,
0  ,
0  ,
130,
70 ,
132,
133,
134,
135,
0  ,
137,
83 ,
139,
140,
0  ,
0  ,
0  ,
0  ,
145,
146,
147,
148,
149,
45 ,
45 ,
152,
153,
83 ,
155,
140,
0  ,
0  ,
89 ,
9  ,
161,
162,
163,
164,
165,
166,
167,
168,
169,
65 ,
171,
172,
45 ,
174,
175,
176,
177,
50 ,
51 ,
180,
181,
182,
183,
184,
49 ,
79 ,
187,
188,
189,
190,
191,
65 ,
193,
65 ,
65 ,
65 ,
65 ,
198,
67 ,
69 ,
201,
69 ,
69 ,
73 ,
205,
73 ,
73 ,
208,
78 ,
79 ,
211,
79 ,
79 ,
214,
215,
214,
85 ,
218,
85 ,
85 ,
221,
222,
223,
65 ,
193,
65 ,
65 ,
65 ,
65 ,
198,
67 ,
69 ,
201,
69 ,
69 ,
73 ,
205,
73 ,
73 ,
208,
78 ,
79 ,
211,
79 ,
79 ,
214,
247,
214,
85 ,
218,
85 ,
85 ,
221,
222,
89
};

ALLOC_CODE(BYTE) g_rgbCodePageWTurkish[] =  {
0  ,
1  ,
2  ,
3  ,
4  ,
5  ,
6  ,
7  ,
8  ,
9  ,
10 ,
11 ,
12 ,
13 ,
14 ,
15 ,
16 ,
17 ,
18 ,
19 ,
20 ,
21 ,
22 ,
23 ,
24 ,
25 ,
26 ,
27 ,
28 ,
29 ,
30 ,
31 ,
32 ,
33 ,
34 ,
35 ,
36 ,
37 ,
38 ,
39 ,
40 ,
41 ,
42 ,
43 ,
44 ,
45 ,
46 ,
47 ,
48 ,
49 ,
50 ,
51 ,
52 ,
53 ,
54 ,
55 ,
56 ,
57 ,
58 ,
59 ,
60 ,
61 ,
62 ,
63 ,
64 ,
65 ,
66 ,
67 ,
68 ,
69 ,
70 ,
71 ,
72 ,
73 ,
74 ,
75 ,
76 ,
77 ,
78 ,
79 ,
80 ,
81 ,
82 ,
83 ,
84 ,
85 ,
86 ,
87 ,
88 ,
89 ,
90 ,
91 ,
92 ,
93 ,
94 ,
95 ,
96 ,
65 ,
66 ,
67 ,
68 ,
69 ,
70 ,
71 ,
72 ,
73 ,
74 ,
75 ,
76 ,
77 ,
78 ,
79 ,
80 ,
81 ,
82 ,
83 ,
84 ,
85 ,
86 ,
87 ,
88 ,
89 ,
90 ,
123,
124,
125,
126,
0  ,
0  ,
0  ,
130,
70 ,
132,
133,
134,
135,
0  ,
137,
83 ,
139,
140,
0  ,
0  ,
0  ,
0  ,
145,
146,
147,
148,
149,
45 ,
45 ,
152,
153,
83 ,
155,
140,
0  ,
0  ,
89 ,
9  ,
161,
162,
163,
164,
165,
166,
167,
168,
169,
65 ,
171,
172,
45 ,
174,
175,
176,
177,
50 ,
51 ,
180,
181,
182,
183,
184,
49 ,
79 ,
187,
188,
189,
190,
191,
65 ,
65 ,
65 ,
65 ,
65 ,
65 ,
198,
199,
69 ,
69 ,
69 ,
69 ,
73 ,
73 ,
73 ,
73 ,
208,
78 ,
79 ,
79 ,
79 ,
79 ,
214,
215,
79 ,
85 ,
85 ,
85 ,
220,
221,
222,
223,
65 ,
65 ,
65 ,
65 ,
65 ,
65 ,
198,
199,
69 ,
69 ,
69 ,
69 ,
73 ,
73 ,
73 ,
73 ,
208,
78 ,
79 ,
79 ,
79 ,
79 ,
214,
247,
79 ,
85 ,
85 ,
85 ,
220,
221,
222,
89
};

ALLOC_CODE(BYTE) g_rgbCodePageWNorwegian[] =  {
0  ,
1  ,
2  ,
3  ,
4  ,
5  ,
6  ,
7  ,
8  ,
9  ,
10 ,
11 ,
12 ,
13 ,
14 ,
15 ,
16 ,
17 ,
18 ,
19 ,
20 ,
21 ,
22 ,
23 ,
24 ,
25 ,
26 ,
27 ,
28 ,
29 ,
30 ,
31 ,
32 ,
33 ,
34 ,
35 ,
36 ,
37 ,
38 ,
39 ,
40 ,
41 ,
42 ,
43 ,
44 ,
45 ,
46 ,
47 ,
48 ,
49 ,
50 ,
51 ,
52 ,
53 ,
54 ,
55 ,
56 ,
57 ,
58 ,
59 ,
60 ,
61 ,
62 ,
63 ,
64 ,
65 ,
66 ,
67 ,
68 ,
69 ,
70 ,
71 ,
72 ,
73 ,
74 ,
75 ,
76 ,
77 ,
78 ,
79 ,
80 ,
81 ,
82 ,
83 ,
84 ,
85 ,
86 ,
87 ,
88 ,
89 ,
90 ,
91 ,
92 ,
93 ,
94 ,
95 ,
96 ,
65 ,
66 ,
67 ,
68 ,
69 ,
70 ,
71 ,
72 ,
73 ,
74 ,
75 ,
76 ,
77 ,
78 ,
79 ,
80 ,
81 ,
82 ,
83 ,
84 ,
85 ,
86 ,
87 ,
88 ,
89 ,
90 ,
123,
124,
125,
126,
0  ,
0  ,
0  ,
130,
70 ,
132,
133,
134,
135,
0  ,
137,
83 ,
139,
140,
0  ,
0  ,
0  ,
0  ,
145,
146,
147,
148,
149,
45 ,
45 ,
152,
153,
83 ,
155,
140,
0  ,
0  ,
89 ,
9  ,
161,
162,
163,
164,
165,
166,
167,
168,
169,
65 ,
171,
172,
45 ,
174,
175,
176,
177,
50 ,
51 ,
180,
181,
182,
183,
184,
49 ,
79 ,
187,
188,
189,
190,
191,
65 ,
65 ,
65 ,
65 ,
196,
197,
196,
67 ,
69 ,
69 ,
69 ,
69 ,
73 ,
73 ,
73 ,
73 ,
68 ,
78 ,
79 ,
79 ,
79 ,
79 ,
214,
215,
214,
85 ,
85 ,
85 ,
89 ,
89 ,
222,
223,
65 ,
65 ,
65 ,
65 ,
196,
197,
196,
67 ,
69 ,
69 ,
69 ,
69 ,
73 ,
73 ,
73 ,
73 ,
68 ,
78 ,
79 ,
79 ,
79 ,
79 ,
214,
247,
214,
85 ,
85 ,
85 ,
89 ,
89 ,
222,
89
};

ALLOC_CODE(BYTE) g_rgbCodePageWEngIreland[] =  {
0  ,
1  ,
2  ,
3  ,
4  ,
5  ,
6  ,
7  ,
8  ,
9  ,
10 ,
11 ,
12 ,
13 ,
14 ,
15 ,
16 ,
17 ,
18 ,
19 ,
20 ,
21 ,
22 ,
23 ,
24 ,
25 ,
26 ,
27 ,
28 ,
29 ,
30 ,
31 ,
32 ,
33 ,
34 ,
35 ,
36 ,
37 ,
38 ,
39 ,
40 ,
41 ,
42 ,
43 ,
44 ,
45 ,
46 ,
47 ,
48 ,
49 ,
50 ,
51 ,
52 ,
53 ,
54 ,
55 ,
56 ,
57 ,
58 ,
59 ,
60 ,
61 ,
62 ,
63 ,
64 ,
65 ,
66 ,
67 ,
68 ,
69 ,
70 ,
71 ,
72 ,
73 ,
74 ,
75 ,
76 ,
77 ,
78 ,
79 ,
80 ,
81 ,
82 ,
83 ,
84 ,
85 ,
86 ,
87 ,
88 ,
89 ,
90 ,
91 ,
92 ,
93 ,
94 ,
95 ,
96 ,
65 ,
66 ,
67 ,
68 ,
69 ,
70 ,
71 ,
72 ,
73 ,
74 ,
75 ,
76 ,
77 ,
78 ,
79 ,
80 ,
81 ,
82 ,
83 ,
84 ,
85 ,
86 ,
87 ,
88 ,
89 ,
90 ,
123,
124,
125,
126,
0  ,
0  ,
0  ,
130,
70 ,
132,
133,
134,
135,
0  ,
137,
83 ,
139,
140,
0  ,
0  ,
0  ,
0  ,
145,
146,
147,
148,
149,
45 ,
45 ,
152,
153,
83 ,
155,
140,
0  ,
0  ,
89 ,
9  ,
161,
162,
163,
164,
165,
166,
167,
168,
169,
65 ,
171,
172,
45 ,
174,
175,
176,
177,
50 ,
51 ,
180,
181,
182,
183,
184,
49 ,
79 ,
187,
188,
189,
190,
191,
65 ,
65 ,
65 ,
65 ,
65 ,
65 ,
198,
67 ,
69 ,
69 ,
69 ,
69 ,
73 ,
73 ,
73 ,
73 ,
208,
78 ,
79 ,
79 ,
79 ,
79 ,
79 ,
215,
79 ,
85 ,
85 ,
85 ,
85 ,
89 ,
222,
223,
65 ,
65 ,
65 ,
65 ,
65 ,
65 ,
198,
67 ,
69 ,
69 ,
69 ,
69 ,
73 ,
73 ,
73 ,
73 ,
208,
78 ,
79 ,
79 ,
79 ,
79 ,
79 ,
247,
79 ,
85 ,
85 ,
85 ,
85 ,
89 ,
222,
89
};

ALLOC_CODE(BYTE) g_rgbCodePageMGreek[] =  {
0  ,
1  ,
2  ,
3  ,
4  ,
5  ,
6  ,
7  ,
8  ,
9  ,
10 ,
11 ,
12 ,
13 ,
14 ,
15 ,
16 ,
17 ,
18 ,
19 ,
20 ,
21 ,
22 ,
23 ,
24 ,
25 ,
26 ,
27 ,
28 ,
29 ,
30 ,
31 ,
32 ,
33 ,
34 ,
35 ,
36 ,
37 ,
38 ,
39 ,
40 ,
41 ,
42 ,
43 ,
44 ,
45 ,
46 ,
47 ,
48 ,
49 ,
50 ,
51 ,
52 ,
53 ,
54 ,
55 ,
56 ,
57 ,
58 ,
59 ,
60 ,
61 ,
62 ,
63 ,
64 ,
65 ,
66 ,
67 ,
68 ,
69 ,
70 ,
71 ,
72 ,
73 ,
74 ,
75 ,
76 ,
77 ,
78 ,
79 ,
80 ,
81 ,
82 ,
83 ,
84 ,
85 ,
86 ,
87 ,
88 ,
89 ,
90 ,
91 ,
92 ,
93 ,
94 ,
95 ,
96 ,
65 ,
66 ,
67 ,
68 ,
69 ,
70 ,
71 ,
72 ,
73 ,
74 ,
75 ,
76 ,
77 ,
78 ,
79 ,
80 ,
81 ,
82 ,
83 ,
84 ,
85 ,
86 ,
87 ,
88 ,
89 ,
90 ,
123,
124,
125,
126,
0  ,
65 ,
49 ,
50 ,
69 ,
51 ,
79 ,
85 ,
135,
65 ,
65 ,
65 ,
0  ,
140,
67 ,
69 ,
69 ,
69 ,
69 ,
146,
147,
73 ,
73 ,
150,
151,
152,
79 ,
79 ,
155,
63 ,
85 ,
85 ,
85 ,
160,
161,
162,
163,
164,
165,
166,
167,
168,
169,
170,
171,
172,
173,
174,
175,
176,
177,
178,
179,
180,
181,
182,
183,
184,
171,
186,
187,
188,
189,
190,
191,
176,
193,
194,
195,
196,
197,
198,
199,
200,
201,
9  ,
189,
204,
176,
182,
207,
45 ,
45 ,
210,
211,
212,
213,
214,
184,
171,
195,
189,
182,
184,
171,
195,
191,
189,
176,
181,
190,
162,
182,
188,
161,
184,
171,
165,
186,
164,
187,
193,
195,
166,
191,
196,
170,
198,
163,
191,
170,
204,
189,
183,
171,
189,
171,
189,
63
};

ALLOC_CODE(BYTE) g_rgbCodePageMNorwegian[] =  {
0  ,
1  ,
2  ,
3  ,
4  ,
5  ,
6  ,
7  ,
8  ,
9  ,
10 ,
11 ,
12 ,
13 ,
14 ,
15 ,
16 ,
17 ,
18 ,
19 ,
20 ,
21 ,
22 ,
23 ,
24 ,
25 ,
26 ,
27 ,
28 ,
29 ,
30 ,
31 ,
32 ,
33 ,
34 ,
35 ,
36 ,
37 ,
38 ,
39 ,
40 ,
41 ,
42 ,
43 ,
44 ,
45 ,
46 ,
47 ,
48 ,
49 ,
50 ,
51 ,
52 ,
53 ,
54 ,
55 ,
56 ,
57 ,
58 ,
59 ,
60 ,
61 ,
62 ,
63 ,
64 ,
65 ,
66 ,
67 ,
68 ,
69 ,
70 ,
71 ,
72 ,
73 ,
74 ,
75 ,
76 ,
77 ,
78 ,
79 ,
80 ,
81 ,
82 ,
83 ,
84 ,
85 ,
86 ,
87 ,
88 ,
89 ,
90 ,
91 ,
92 ,
93 ,
94 ,
95 ,
96 ,
65 ,
66 ,
67 ,
68 ,
69 ,
70 ,
71 ,
72 ,
73 ,
74 ,
75 ,
76 ,
77 ,
78 ,
79 ,
80 ,
81 ,
82 ,
83 ,
84 ,
85 ,
86 ,
87 ,
88 ,
89 ,
90 ,
123,
124,
125,
126,
0  ,
128,
129,
67 ,
69 ,
78 ,
133,
89 ,
65 ,
65 ,
65 ,
128,
65 ,
129,
67 ,
69 ,
69 ,
69 ,
69 ,
73 ,
73 ,
73 ,
73 ,
78 ,
79 ,
79 ,
79 ,
133,
79 ,
85 ,
85 ,
85 ,
89 ,
160,
161,
162,
163,
164,
165,
166,
167,
168,
169,
170,
171,
172,
173,
128,
133,
176,
177,
178,
179,
180,
181,
182,
183,
184,
185,
186,
65 ,
79 ,
189,
128,
133,
192,
193,
194,
195,
70 ,
197,
198,
199,
200,
201,
9  ,
65 ,
65 ,
79 ,
206,
206,
45 ,
45 ,
210,
211,
212,
213,
214,
215,
89 ,
89 ,
218,
219,
220,
221,
63 ,
63 ,
224,
225,
226,
227,
228,
65 ,
69 ,
65 ,
69 ,
69 ,
73 ,
73 ,
73 ,
73 ,
79 ,
79 ,
63 ,
79 ,
85 ,
85 ,
85 ,
73 ,
0  ,
247,
0  ,
249,
250,
251,
63 ,
253,
254,
0
};

ALLOC_CODE(BYTE) g_rgbCodePageMEngIreland[] =  {
0  ,
1  ,
2  ,
3  ,
4  ,
5  ,
6  ,
7  ,
8  ,
9  ,
10 ,
11 ,
12 ,
13 ,
14 ,
15 ,
16 ,
17 ,
18 ,
19 ,
20 ,
21 ,
22 ,
23 ,
24 ,
25 ,
26 ,
27 ,
28 ,
29 ,
30 ,
31 ,
32 ,
 33 ,
 34 ,
 35 ,
 36 ,
 37 ,
 38 ,
 39 ,
 40 ,
 41 ,
 42 ,
 43 ,
 44 ,
 45 ,
 46 ,
 47 ,
 48 ,
 49 ,
 50 ,
 51 ,
 52 ,
 53 ,
 54 ,
 55 ,
 56 ,
 57 ,
 58 ,
 59 ,
 60 ,
 61 ,
 62 ,
 63 ,
 64 ,
 65 ,
 66 ,
 67 ,
 68 ,
 69 ,
 70 ,
 71 ,
 72 ,
 73 ,
 74 ,
 75 ,
 76 ,
 77 ,
 78 ,
 79 ,
 80 ,
 81 ,
 82 ,
 83 ,
 84 ,
 85 ,
 86 ,
 87 ,
 88 ,
 89 ,
 90 ,
 91 ,
 92 ,
 93 ,
 94 ,
 95 ,
 96 ,
 65 ,
 66 ,
 67 ,
 68 ,
 69 ,
 70 ,
 71 ,
 72 ,
 73 ,
 74 ,
 75 ,
 76 ,
 77 ,
 78 ,
 79 ,
 80 ,
 81 ,
 82 ,
 83 ,
 84 ,
 85 ,
 86 ,
 87 ,
 88 ,
 89 ,
 90 ,
 123,
 124,
 125,
 126,
 0  ,
 65 ,
 65 ,
 67 ,
 69 ,
 78 ,
 79 ,
 85 ,
 65 ,
 65 ,
 65 ,
 65 ,
 65 ,
 65 ,
 67 ,
 69 ,
 69 ,
 69 ,
 69 ,
 73 ,
 73 ,
 73 ,
 73 ,
 78 ,
 79 ,
 79 ,
 79 ,
 79 ,
 79 ,
 85 ,
 85 ,
 85 ,
 85 ,
 160,
 161,
 162,
 163,
 164,
 165,
 166,
 167,
 168,
 169,
 170,
 171,
 172,
 173,
 174,
 79 ,
 176,
 177,
 178,
 179,
 180,
 181,
 182,
 183,
 184,
 185,
 186,
 65 ,
 79 ,
 189,
 174,
 79 ,
 192,
 193,
 194,
 195,
 70 ,
 197,
 198,
 199,
 200,
 201,
 9  ,
 65 ,
 65 ,
 79 ,
 206,
 206,
 45 ,
 45 ,
 210,
 211,
 212,
 213,
 214,
 215,
 89 ,
 89 ,
 218,
 219,
 220,
 221,
 63 ,
 63 ,
 224,
 225,
 226,
 227,
 228,
 65 ,
 69 ,
 65 ,
 69 ,
 69 ,
 73 ,
 73 ,
 73 ,
 73 ,
 79 ,
 79 ,
 63 ,
 79 ,
 85 ,
 85 ,
 85 ,
 73 ,
 0  ,
 247,
 0  ,
 249,
 250,
 251,
 63 ,
 253,
 254,
 0
};


// This is 2-D table of Code Page Vs. System.
// To get the address of the mapping table to use; Use
// pb = g_prgHashTbl[CodePage][Syskind];
//
ALLOC_CODE(BYTE *)g_prgHashTbl[13][2] = {
    {NULL,		NULL},
    {g_rgbCodePage1252, g_rgbCodePage10000}, // English/European
    {g_rgbCodePage1250, g_rgbCodePage10029},
    {g_rgbCodePage1251, g_rgbCodePage10007},
    {NULL,		NULL},		     // JAPNESE_CP
    {NULL,		NULL},		     // KOREAN_CP
    {NULL,		NULL},		     // CHINESES_CP
    {NULL,		NULL},		     // CHINESET_CP

    // MAC: UNDONE: Tables of Turkish and Icelandic is not available on MAC.
    {g_rgbCodePageWGreek,      g_rgbCodePageMGreek	    }, // GREEK
    {g_rgbCodePageWIceland,    g_rgbCodePageWIceland	    }, // ICELANDIC
    {g_rgbCodePageWTurkish,    g_rgbCodePageWTurkish	    }, // TURKISH
    {g_rgbCodePageWNorwegian,  g_rgbCodePageMNorwegian	    }, // NORWEIGIAN
    {g_rgbCodePageWEngIreland, g_rgbCodePageMEngIreland     }  // ENGLISH(IRELAND)
};

// Following are the code page "codes" for the dbcs world.
#define JAPNESE_CP    0x4
#define KOREAN_CP     0x5
#define CHINESES_CP   0x6
#define CHINESET_CP   0x7

#define GREEK_CP      0x8
#define ICELANDIC_CP  0x9
#define TURKISH_CP    0xa
#define NORWEIGIAN_CP 0xb
#define IRELAND_CP    0xc


/***
*PUBLIC LHashValOfName
*Purpose: This API calculates the hash value depending on the system  and
*	  the lcid that was passed in.
*
*Implementation Notes:
*    Use the table pointed by  pbHashTable to map each character in the
*    szName.
*
*
*Entry:
*	xsz: String whose hash value has to be calculated
*
*Exit:
*   ULONG :   hash value of the passed in string
*
*    31      23  19   15		0
*   |-------|---|----|-------------------|
*   |UNUSED |CP |Sys | wHashVal 	 |
*   |_______|___|____|___________________|
*	       ^   ^
*	       |   |
*	CodePageId Encoding bits for System kind
*
*
*
***********************************************************************/
#pragma optimize("t", on)
#if FV_UNICODE_OLE
STDAPI_(unsigned long) LHashValOfNameSysW(SYSKIND syskind,
					 LCID lcid,
					 LPCOLESTR szName)
{
    // NOTE: We only bother to translate the first 255 chars of the name.
    // NOTE: This should sill get a pretty good hash function, without
    // NOTE: having burn more stack space, or (worse) alloc & free memory
    // NOTE: on this call.
    char szNameA[255+1];

    if (szName == NULL)		// can't return E_INVALIDARG here, so just
	return 0;		// don't crash

    // convert szName from Unicode to Ansi.
    NoAssertRetail (WideCharToMultiByte(CP_ACP,
					0,
					szName,
					-1,
					szNameA,
					255+1,
					NULL,
					NULL) != 0, "");
    szNameA[255] = '\0';	// ensure null-terminated (in case truncated).

    return LHashValOfNameSysA(syskind, lcid, szNameA);
}
#endif 

STDAPI_(unsigned long) LHashValOfNameSysA(SYSKIND syskind,
					 LCID lcid,
					 const char FAR* szName)
{
    ULONG ulHash;		// hash value which accumulates hash
    USHORT uIndex;
    BYTE *pbHashTable;
    USHORT usSystem, usCodePage;
    ULONG uEncoding;

    if (szName == NULL)		// can't return E_INVALIDARG here, so just
	return 0;		// don't crash

    // If DBCS then defer to LHashValOfDBCSName
    if (IsDBCS(lcid))
      return LHashValOfDBCSName(syskind, lcid, szName);

    // Deternine the hash table that should be used.
    //
    // Find the index corresponding to the system passed in.
    usSystem = (syskind == SYS_MAC) ? 1 : 0;

    // Determine the Code page.
    if (lcid == 0x409)
	usCodePage = 1; // English is most likely.
    else switch (lcid) {
      default:
	usCodePage = 1; break;  // default gets US English
      case 0x0419:
	usCodePage = 3; break;
      case 0x0408:
	usCodePage = GREEK_CP; break;
      case 0x040f:
	usCodePage = ICELANDIC_CP; break;
      case 0x041f:
	usCodePage = TURKISH_CP; break;
      case 0x0814:
	usCodePage = NORWEIGIAN_CP; break;
      case 0x1809:
	usCodePage = IRELAND_CP; break;
      case 0x0405:
      case 0x040e:
      case 0x0415:
      case 0x041b:
	usCodePage = 2; break;
      }




    pbHashTable =  g_prgHashTbl[usCodePage][usSystem];

    uEncoding = (ULONG) (((ULONG) ((usCodePage << 4) | usSystem)) << 16);


    // Algorithm: compute 32-bit value by multipling by 37 and adding
    // in the character.  Ignore all overflows.  Then convert to
    // a 16-bit number by moding by 65599 (a prime).

    ulHash = 0xDeadBee;    // arbitrary starting number


    for (;*szName; szName++) {

      // use  pbHashTable[] to map characters
      //

      uIndex = ((BYTE) *szName) & 0x00ff;

      ulHash = ulHash * 37 + pbHashTable[uIndex];

    } // for

    ulHash = ulHash % 65599;

    return (ULONG) (uEncoding | (ulHash & 0x0000FFFF));
}



/***
*LHashValOfDBCSName
*Purpose: Calculates the hash value for strings from DBCS language.
*
*Implementation Notes:
*    Use the table pointed by  pbHashTable to map each character in the
*    szName.
*
*
*Entry:
*   xsz: String whose hash value has to be calculated
*
*Exit:
*   ULONG :   hash value of the passed in string
*
*
***********************************************************************/
unsigned long LHashValOfDBCSName(SYSKIND syskind, LCID lcid, const char FAR* szName)
{
    ULONG ulHash;		// hash value which accumulates hash
    ACHAR xch;
    USHORT uIndex;
    BYTE *pbHashTable;
    USHORT usSystem, usCodePage;
    ULONG uEncoding;

    // UNDONE : for MAC
    //
    // For DBCS characters < 255, the mapping rules are same as CODE page for
    // US english.
    //
    pbHashTable = g_rgbCodePage1252;

    // Find the index corresponding to the system passed in.
    usSystem = (syskind == SYS_MAC) ? 1 : 0;

    // Get the code page.
    switch (PRIMARYLANGID(lcid)) {
    case LANG_JAPANESE:
      usCodePage = JAPNESE_CP;
      break;
    case LANG_KOREAN:
      usCodePage = KOREAN_CP;
      break;
    case LANG_CHINESE:
      switch (SUBLANGID(lcid)) {
      case SUBLANG_CHINESE_TRADITIONAL:
        usCodePage = CHINESET_CP;
        break;
      case SUBLANG_CHINESE_SIMPLIFIED:
        usCodePage = CHINESES_CP;
        break;
      default:
        DebHalt("bad lcid");
      } 
      break;
    default:
      DebHalt("bad lcid");
    }

    uEncoding = (ULONG) (((ULONG) ((usCodePage << 4) | usSystem)) << 16);

    // Algorithm: compute 32-bit value by multipling by 37 and adding
    // in the character.  Ignore all overflows.  Then convert to
    // a 16-bit number by moding by 65599 (a prime).

    ulHash = 0xDeadBee;    // arbitrary starting number

    for (; (xch = xpch((LPSTR)szName)) != '\0'; szName = xstrinc(szName)) {

      // use  pbHashTable[] to map characters
      //

      // If the next character is a double byte character then first map it.
      if ((USHORT)xch > 0xff) {
        xch = MapDBChar(xch, lcid);

        // process the high byte.
        // shift the upper byte down to get the index.
        if (uIndex = (((USHORT) xch & 0xff00) >> 8)) {
	  ulHash = ulHash * 37 + pbHashTable[uIndex];
        }
      }

      // process the low byte.
      uIndex = ((USHORT) xch) & 0x00ff;

      ulHash = ulHash * 37 + pbHashTable[uIndex];

    } // for

    ulHash = ulHash % 65599;

    return (ULONG) (uEncoding | (ulHash & 0x0000FFFF));

}
#pragma optimize("t", )



ALLOC_CODE(ACHAR) m_rgJapneseExcepMap[][2] = {
0x829F,      0x00A7,
0x82A0,      0x00B1,
0x82A1,      0x00A8,
0x82A2,      0x00B2,
0x82A3,      0x00A9,
0x82A4,      0x00B3,
0x82A5,      0x00AA,
0x82A6,      0x00B4,
0x82A7,      0x00AB,
0x82A8,      0x00B5,
0x82A9,      0x00B6,
0x82AA,      0xB6DE,
0x82AB,      0x00B7,
0x82AC,      0xB7DE,
0x82AD,      0x00B8,
0x82AE,      0xB8DE,
0x82AF,      0x00B9,
0x82B0,      0xB9DE,
0x82B1,      0x00BA,
0x82B2,      0xBADE,
0x82B3,      0x00BB,
0x82B4,      0xBBDE,
0x82B5,      0x00BC,
0x82B6,      0xBCDE,
0x82B7,      0x00BD,
0x82B8,      0xBDDE,
0x82B9,      0x00BE,
0x82BA,      0xBEDE,
0x82BB,      0x00BF,
0x82BC,      0xBFDE,
0x82BD,      0x00C0,
0x82BE,      0xC0DE,
0x82BF,      0x00C1,
0x82C0,      0xC1DE,
0x82C1,      0x00AF,
0x82C2,      0x00C2,
0x82C3,      0xC2DE,
0x82C4,      0x00C3,
0x82C5,      0xC3DE,
0x82C6,      0x00C4,
0x82C7,      0xC4DE,
0x82C8,      0x00C5,
0x82C9,      0x00C6,
0x82CA,      0x00C7,
0x82CB,      0x00C8,
0x82CC,      0x00C9,
0x82CD,      0x00CA,
0x82CE,      0xCADE,
0x82CF,      0xCADF,
0x82D0,      0x00CB,
0x82D1,      0xCBDE,
0x82D2,      0xCBDF,
0x82D3,      0x00CC,
0x82D4,      0xCCDE,
0x82D5,      0xCCDF,
0x82D6,      0x00CD,
0x82D7,      0xCDDE,
0x82D8,      0xCDDF,
0x82D9,      0x00CE,
0x82DA,      0xCEDE,
0x82DB,      0xCEDF,
0x82DC,      0x00CF,
0x82DD,      0x00D0,
0x82DE,      0x00D1,
0x82DF,      0x00D2,
0x82E0,      0x00D3,
0x82E1,      0x00AC,
0x82E2,      0x00D4,
0x82E3,      0x00AD,
0x82E4,      0x00D5,
0x82E5,      0x00AE,
0x82E6,      0x00D6,
0x82E7,      0x00D7,
0x82E8,      0x00D8,
0x82E9,      0x00D9,
0x82EA,      0x00DA,
0x82EB,      0x00DB,
0x82EC,      0x838E,
0x82ED,      0x00DC,
0x82EE,      0x8390,
0x82EF,      0x8391,
0x82F0,      0x00A6,
0x82F1,      0x00DD,

0x8340,      0x00A7,
0x8341,      0x00B1,
0x8342,      0x00A8,
0x8343,      0x00B2,
0x8344,      0x00A9,
0x8345,      0x00B3,
0x8346,      0x00AA,
0x8347,      0x00B4,
0x8348,      0x00AB,
0x8349,      0x00B5,
0x834A,      0x00B6,
0x834B,      0xB6DE,
0x834C,      0x00B7,
0x834D,      0xB7DE,
0x834E,      0x00B8,
0x834F,      0xB8DE,
0x8350,      0x00B9,
0x8351,      0xB9DE,
0x8352,      0x00BA,
0x8353,      0xBADE,
0x8354,      0x00BB,
0x8355,      0xBBDE,
0x8356,      0x00BC,
0x8357,      0xBCDE,
0x8358,      0x00BD,
0x8359,      0xBDDE,
0x835A,      0x00BE,
0x835B,      0xBEDE,
0x835C,      0x00BF,
0x835D,      0xBFDE,
0x835E,      0x00C0,
0x835F,      0xC0DE,
0x8360,      0x00C1,
0x8361,      0xC1DE,
0x8362,      0x00AF,
0x8363,      0x00C2,
0x8364,      0xC2DE,
0x8365,      0x00C3,
0x8366,      0xC3DE,
0x8367,      0x00C4,
0x8368,      0xC4DE,
0x8369,      0x00C5,
0x836A,      0x00C6,
0x836B,      0x00C7,
0x836C,      0x00C8,
0x836D,      0x00C9,
0x836E,      0x00CA,
0x836F,      0xCADE,
0x8370,      0xCADF,
0x8371,      0x00CB,
0x8372,      0xCBDE,
0x8373,      0xCBDF,
0x8374,      0x00CC,
0x8375,      0xCCDE,
0x8376,      0xCCDF,
0x8377,      0x00CD,
0x8378,      0xCDDE,
0x8379,      0xCDDF,
0x837A,      0x00CE,
0x837B,      0xCEDE,
0x837C,      0xCEDF,
0x837D,      0x00CF,
0x837E,      0x00D0,
0x8380,      0x00D1,
0x8381,      0x00D2,
0x8382,      0x00D3,
0x8383,      0x00AC,
0x8384,      0x00D4,
0x8385,      0x00AD,
0x8386,      0x00D5,
0x8387,      0x00AE,
0x8388,      0x00D6,
0x8389,      0x00D7,
0x838A,      0x00D8,
0x838B,      0x00D9,
0x838C,      0x00DA,
0x838D,      0x00DB,
0x838E,      0x838E,
0x838F,      0x00DC,
0x8390,      0x8390,
0x8391,      0x8391,
0x8392,      0x00A6,
0x8393,      0x00DD,
0x8394,      0xB3DE,
0x8395,      0x8395,
0x8396,      0x8396,

0x824F,      0x30,
0x8250,      0x31,
0x8251,      0x32,
0x8252,      0x33,
0x8253,      0x34,
0x8254,      0x35,
0x8255,      0x36,
0x8256,      0x37,
0x8257,      0x38,
0x8258,      0x39,
0x8260,      0x41,
0x8261,      0x42,
0x8262,      0x43,
0x8263,      0x44,
0x8264,      0x45,
0x8265,      0x46,
0x8266,      0x47,
0x8267,      0x48,
0x8268,      0x49,
0x8269,      0x4A,
0x826A,      0x4B,
0x826B,      0x4C,
0x826C,      0x4D,
0x826D,      0x4E,
0x826E,      0x4F,
0x826F,      0x50,
0x8270,      0x51,
0x8271,      0x52,
0x8272,      0x53,
0x8273,      0x54,
0x8274,      0x55,
0x8275,      0x56,
0x8276,      0x57,
0x8277,      0x58,
0x8278,      0x59,
0x8279,      0x5A,
0x8151,      0x5F,
0x8281,      0x61,
0x8282,      0x62,
0x8283,      0x63,
0x8284,      0x64,
0x8285,      0x65,
0x8286,      0x66,
0x8287,      0x67,
0x8288,      0x68,
0x8289,      0x69,
0x828A,      0x6A,
0x828B,      0x6B,
0x828C,      0x6C,
0x828D,      0x6D,
0x828E,      0x6E,
0x828F,      0x6F,
0x8290,      0x70,
0x8291,      0x71,
0x8292,      0x72,
0x8293,      0x73,
0x8294,      0x74,
0x8295,      0x75,
0x8296,      0x76,
0x8297,      0x77,
0x8298,      0x78,
0x8299,      0x79,
0x829A,      0x7A,
0x0000,      0x00
};      

ALLOC_CODE(ACHAR) m_rgKoreaExcepMap[][2] = {
0xA3B0,      0x30,
0xA3B1,      0x31,
0xA3B2,      0x32,
0xA3B3,      0x33,
0xA3B4,      0x34,
0xA3B5,      0x35,
0xA3B6,      0x36,
0xA3B7,      0x37,
0xA3B8,      0x38,
0xA3B9,      0x39,
0xA3C1,      0x41,
0xA3C2,      0x42,
0xA3C3,      0x43,
0xA3C4,      0x44,
0xA3C5,      0x45,
0xA3C6,      0x46,
0xA3C7,      0x47,
0xA3C8,      0x48,
0xA3C9,      0x49,
0xA3CA,      0x4A,
0xA3CB,      0x4B,
0xA3CC,      0x4C,
0xA3CD,      0x4D,
0xA3CE,      0x4E,
0xA3CF,      0x4F,
0xA3D0,      0x50,
0xA3D1,      0x51,
0xA3D2,      0x52,
0xA3D3,      0x53,
0xA3D4,      0x54,
0xA3D5,      0x55,
0xA3D6,      0x56,
0xA3D7,      0x57,
0xA3D8,      0x58,
0xA3D9,      0x59,
0xA3DA,      0x5A,
0xA3DF,      0x5F,
0xA3E1,      0x61,
0xA3E2,      0x62,
0xA3E3,      0x63,
0xA3E4,      0x64,
0xA3E5,      0x65,
0xA3E6,      0x66,
0xA3E7,      0x67,
0xA3E8,      0x68,
0xA3E9,      0x69,
0xA3EA,      0x6A,
0xA3EB,      0x6B,
0xA3EC,      0x6C,
0xA3ED,      0x6D,
0xA3EE,      0x6E,
0xA3EF,      0x6F,
0xA3F0,      0x70,
0xA3F1,      0x71,
0xA3F2,      0x72,
0xA3F3,      0x73,
0xA3F4,      0x74,
0xA3F5,      0x75,
0xA3F6,      0x76,
0xA3F7,      0x77,
0xA3F8,      0x78,
0xA3F9,      0x79,
0xA3FA,      0x7A,
0x0000,      0x00
};


ALLOC_CODE(ACHAR) m_rgChinaTExcepMap[][2] = {
0xA2AF,      0x30,
0xA2B0,      0x31,
0xA2B1,      0x32,
0xA2B2,      0x33,
0xA2B3,      0x34,
0xA2B4,      0x35,
0xA2B5,      0x36,
0xA2B6,      0x37,
0xA2B7,      0x38,
0xA2B8,      0x39,
0xA2CF,      0x41,
0xA2D0,      0x42,
0xA2D1,      0x43,
0xA2D2,      0x44,
0xA2D3,      0x45,
0xA2D4,      0x46,
0xA2D5,      0x47,
0xA2D6,      0x48,
0xA2D7,      0x49,
0xA2D8,      0x4A,
0xA2D9,      0x4B,
0xA2DA,      0x4C,
0xA2DB,      0x4D,
0xA2DC,      0x4E,
0xA2DD,      0x4F,
0xA2DE,      0x50,
0xA2DF,      0x51,
0xA2E0,      0x52,
0xA2E1,      0x53,
0xA2E2,      0x54,
0xA2E3,      0x55,
0xA2E4,      0x56,
0xA2E5,      0x57,
0xA2E6,      0x58,
0xA2E7,      0x59,
0xA2E8,      0x5A,
0xA1C5,      0x5F,
0xA2E9,      0x61,
0xA2EA,      0x62,
0xA2EB,      0x63,
0xA2EC,      0x64,
0xA2ED,      0x65,
0xA2EE,      0x66,
0xA2EF,      0x67,
0xA2F0,      0x68,
0xA2F1,      0x69,
0xA2F2,      0x6A,
0xA2F3,      0x6B,
0xA2F4,      0x6C,
0xA2F5,      0x6D,
0xA2F6,      0x6E,
0xA2F7,      0x6F,
0xA2F8,      0x70,
0xA2F9,      0x71,
0xA2FA,      0x72,
0xA2FB,      0x73,
0xA2FC,      0x74,
0xA2FD,      0x75,
0xA2FE,      0x76,
0xA340,      0x77,
0xA341,      0x78,
0xA342,      0x79,
0xA343,      0x7A,
};

ALLOC_CODE(ACHAR) m_rgChinaSExcepMap[][2] = {
0xA3B0,      0x30,
0xA3B1,      0x31,
0xA3B2,      0x32,
0xA3B3,      0x33,
0xA3B4,      0x34,
0xA3B5,      0x35,
0xA3B6,      0x36,
0xA3B7,      0x37,
0xA3B8,      0x38,
0xA3B9,      0x39,
0xA3C1,      0x41,
0xA3C2,      0x42,
0xA3C3,      0x43,
0xA3C4,      0x44,
0xA3C5,      0x45,
0xA3C6,      0x46,
0xA3C7,      0x47,
0xA3C8,      0x48,
0xA3C9,      0x49,
0xA3CA,      0x4A,
0xA3CB,      0x4B,
0xA3CC,      0x4C,
0xA3CD,      0x4D,
0xA3CE,      0x4E,
0xA3CF,      0x4F,
0xA3D0,      0x50,
0xA3D1,      0x51,
0xA3D2,      0x52,
0xA3D3,      0x53,
0xA3D4,      0x54,
0xA3D5,      0x55,
0xA3D6,      0x56,
0xA3D7,      0x57,
0xA3D8,      0x58,
0xA3D9,      0x59,
0xA3DA,      0x5A,
0xA3DF,      0x5F,
0xA3E1,      0x61,
0xA3E2,      0x62,
0xA3E3,      0x63,
0xA3E4,      0x64,
0xA3E5,      0x65,
0xA3E6,      0x66,
0xA3E7,      0x67,
0xA3E8,      0x68,
0xA3E9,      0x69,
0xA3EA,      0x6A,
0xA3EB,      0x6B,
0xA3EC,      0x6C,
0xA3ED,      0x6D,
0xA3EE,      0x6E,
0xA3EF,      0x6F,
0xA3F0,      0x70,
0xA3F1,      0x71,
0xA3F2,      0x72,
0xA3F3,      0x73,
0xA3F4,      0x74,
0xA3F5,      0x75,
0xA3F6,      0x76,
0xA3F7,      0x77,
0xA3F8,      0x78,
0xA3F9,      0x79,
0xA3FA,      0x7A,
};


/***
*MapDBChar
*Purpose: Maps a double byte character to a (1 or 2) single byte character
*
*Implementation Notes:
*    Use the exception tables above for the appropriate language.
*
*Entry:
*   xch: Character to be mapped
*   lcid: LCID of language in use
*
*Exit:
*   returns mapped character
*
*CONSIDER:  there are some optimizations that could be done here
*
***********************************************************************/
ACHAR MapDBChar(ACHAR xch, LCID lcid)
{
    ACHAR * pchException;

    DebAssert(0xff00 & (USHORT)xch, " should a double byte character ");

    // Do language specific mapping.
    switch (PRIMARYLANGID(lcid)) {
    case LANG_JAPANESE:
      // Japan
      pchException = m_rgJapneseExcepMap[0];
      break;
    case LANG_KOREAN:
      // Korea
      pchException = m_rgKoreaExcepMap[0];
      break;
    case LANG_CHINESE:
      switch (SUBLANGID(lcid)) {
      case SUBLANG_CHINESE_TRADITIONAL:
        // China(T)
        pchException = m_rgChinaTExcepMap[0];
        break;
      case SUBLANG_CHINESE_SIMPLIFIED:
        // China(S)
        pchException = m_rgChinaSExcepMap[0];
        break;
      default:
        DebHalt("bad lcid");
      }
      break;
    default:
      DebHalt("bad lcid");
    }

    for (; *pchException != 0x0000 && *pchException != xch; pchException += 2);
    // end of for loop

    if (*pchException == 0x0000)
      return xch;
    else
      return *(pchException+1);

}


//Typelib version support
#include "verstamp.h"
#undef rmm		// Use a fixed number for rmm
#define rmm 02		// UNDONE: this number will change before ship
// keep 'rup' the same as OB's version number for simplicity

STDAPI_(DWORD) OaBuildVersion(void)
{
   // return rmm in the the high word, rup in the low word
   return MAKELONG(rup, rmm);
}
