/*  cmdpif.c - PIF Handling Routines For SCS
 *
 *
 *  Modification History:
 *
 *  Sudeepb 19-Aug-1992 Created
 *  williamh 10-Nov-1992 (1). get params from w386 extention if exist
 *			 (2). null terminate caption
 *  williamh 27-May-1993 almost rewrote for better pif support
 */

#include "cmd.h"
#include <ctype.h>
#include <pif.h>
#include "cmdpif.h"
#include <cmdsvc.h>
#include <softpc.h>
#include <mvdm.h>
#include <oemuni.h>


VOID cmdCheckForPIF (PVDMINFO pvi)
{
PCHAR	pCmdLine = pvi->CmdLine;
PUCHAR	pDot = NULL;
ULONG	index,size;
UCHAR	 ch;
DWORD   dw;
CHAR	lpszEnvDir [] = "=?:";
CHAR	FullPathName[MAX_PATH + 1];
CHAR	* pFilePart;
BOOL	IsPIFFile, IsFromForceDos;

    while (TRUE) {
	// find the last '.' or first delimeter
        index = strcspn (pCmdLine, " .\t\x0d");
	if (pCmdLine[index] != '.') {
	    pCmdLine = &pCmdLine[index];
	    break;
	}
	pDot = &pCmdLine[index];
	pCmdLine = pDot;
	++pCmdLine;
    }


    IsPIFFile = (pDot && !strnicmp(pDot, ".pif", 4));
    // if the command is not a pif file and it is not
    // running on a new console
    if (!IsPIFFile && !DosSessionId)
	goto CleanUpAndReturn;

    // If command line has parameters then we ignore parameters
    // in .pif file.
    // Else we use parameters from .PIF file

    // Checking for command line parameters
    // index != 0 if we have anything > 0
    index = 0;
    pDot = pCmdLine;
    while(*pDot) {
	if(*pDot > ' ') {
	    index++;
	    break;
	}
	pDot++;
    }
    if (IsPIFFile) {
	if (!IsFirstVDM) {
	    // BASE only return app pif file if the app is the first VDM
	    // Here we try to get the pif data.
	    // if we failed to get the pif data or
	    // the pif file is not from forcedos,
	    // just return -- command.com will receive the pif
	    // file and will fail.
	    ch = *pCmdLine;
	    *pCmdLine = '\0';
	    if (strchr(pvi->CmdLine, '\\') == NULL) {
		dw = SearchPathOem(".",
				pvi->CmdLine,
				NULL,
				MAX_PATH + 1,
				FullPathName,
				&pFilePart
			       );
		if (dw == 0 || dw > MAX_PATH)
		    dw = SearchPathOem(NULL,
				       pvi->CmdLine,
				       NULL,
				       MAX_PATH + 1,
				       FullPathName,
				       &pFilePart
				      );
		*pCmdLine = ch;
		if (dw == 0 || dw > MAX_PATH)
		    goto CleanUpAndReturn;
	    }
	    else {
		dw = GetFullPathNameOem(pvi->CmdLine,
					MAX_PATH + 1,
					FullPathName,
					&pFilePart
					);
		if(dw != 0 || dw <= MAX_PATH)
		    dw = GetFileAttributesOem(FullPathName);
		else
		    dw = (DWORD)(-1);

		*pCmdLine = ch;
		if (dw == (DWORD)(-1) || (dw & FILE_ATTRIBUTE_DIRECTORY))
		    goto CleanUpAndReturn;

	    }
	    pfdata.AppHasPIFFile =
	    pfdata.IgnoreStartDirInPIF =
	    pfdata.IgnoreTitleInPIF =
	    pfdata.IgnoreCmdLineInPIF =
	    pfdata.IgnoreConfigAutoexec = 1;
	    if (!GetPIFData(&pfdata, FullPathName))
		goto CleanUpAndReturn;
	}
	// we only run a pif file on two occasions:
	// (1). it is from a new console
	// (2). it is from forcedos.
	if (!DosSessionId && pfdata.SubSysId != SUBSYS_DOS)
	    goto CleanUpAndReturn;

    }
    if (IsFirstVDM) {
	// if this is the first vdm, take cmdline, startupdir and title
	// if they are there
	if (pfdata.StartDir){
	    dw = cmdExpandEnvironmentStrings(NULL,
					     pfdata.StartDir,
					     FullPathName,
					     MAX_PATH + 1
					     );
	    if (dw != 0 &&	dw <= MAX_PATH)
		dw = GetFullPathNameOem(FullPathName,
					MAX_PATH + 1,
					pfdata.StartDir,
					&pFilePart
					);
	    if (dw != 0 && dw <= MAX_PATH)
		dw = GetFileAttributesOem(pfdata.StartDir);
	    else
		dw = 0;
	    if (dw == 0 || dw == 0xFFFFFFFF || !(dw & FILE_ATTRIBUTE_DIRECTORY))
		{
		RcMessageBox(EG_PIF_STARTDIR_ERR,
			     NULL,
			     NULL,
			     RMB_ICON_BANG | RMB_ABORT);
		goto CleanUpAndReturn;
	    }
	    dw = GetShortPathNameOem(pfdata.StartDir, pfdata.StartDir,
				     MAX_PATH + 1);
	    if (dw == 0 || dw > MAX_PATH || dw > 64) {
		RcMessageBox(EG_PIF_STARTDIR_ERR,
			     NULL,
			     NULL,
			     RMB_ICON_BANG | RMB_ABORT);
		goto CleanUpAndReturn;
	    }
	    lpszEnvDir[1] = pfdata.StartDir[0];
	    SetEnvironmentVariableOem(lpszEnvDir, pfdata.StartDir);
	    SetCurrentDirectoryOem(pfdata.StartDir);
	    pvi->CurDrive = toupper(pfdata.StartDir[0]) - 'A';
	}
	if (pfdata.WinTitle) {
	    strcpy(FullPathName, pfdata.WinTitle);
	    dw = cmdExpandEnvironmentStrings(NULL,
					     FullPathName,
					     pfdata.WinTitle,
					     MAX_PATH + 1
					     );
	    pfdata.WinTitle[MAX_PATH] = '\0';
	}
	if (!index && pfdata.CmdLine) {
	    // if the optinal parameter is '?'
	    // prompt the user
	    pDot = pfdata.CmdLine;
	    while (*pDot && *pDot <= ' ')
		pDot++;
	    if (*pDot == '?') {
		pfdata.CmdLine[0] = '\0';
		RcMessageBox(EG_PIF_ASK_CMDLINE,
			     NULL,
			     pfdata.CmdLine,
			     RMB_EDIT | RMB_ICON_INFO | (128 << 16)
			     );
	    }
	    if (*pfdata.CmdLine) {
		strcpy(FullPathName, pfdata.CmdLine);
		dw = cmdExpandEnvironmentStrings(NULL,
						 FullPathName,
						 pfdata.CmdLine,
						 MAX_PATH + 1
						);
	    }
	}


    }

    if(IsPIFFile) {
	strcpy(FullPathName, pfdata.StartFile);
	dw = cmdExpandEnvironmentStrings(NULL,
					 FullPathName,
					 pfdata.StartFile,
					 MAX_PATH + 1
					);
	if (dw != 0 && dw <= MAX_PATH) {
	    // if the exec name has any path character,
	    // do not do any searching
	    if (strchr(pfdata.StartFile, '\\') == NULL) {
		// search from the current directory
		// note that the startup directory specified in
		// the pif file has been set as our current directory
		// when we got here
		dw = SearchPathOem(".",
				   pfdata.StartFile,
				   NULL,
				   MAX_PATH + 1,
				   FullPathName,
				   &pFilePart
				   );
		// if couldn't find the file from the current dir
		// ask win32api help
		if (dw == 0 || dw > MAX_PATH)
		    dw = SearchPathOem(NULL,
				       pfdata.StartFile,
				       NULL,
				       MAX_PATH + 1,
				       FullPathName,
				       &pFilePart
				       );
		// couldn't find the file, give up
		if (dw == 0 || dw > MAX_PATH) {
		    RcMessageBox(EG_PIF_STARTFILE_ERR,
				 NULL, NULL, RMB_ICON_BANG | RMB_ABORT);
		    goto CleanUpAndReturn;
		}
		strncpy(pfdata.StartFile, FullPathName, dw + 1);
	    }
	    dw = GetFileAttributesOem(pfdata.StartFile);
	    if (dw == (DWORD)(-1) || (dw & FILE_ATTRIBUTE_DIRECTORY)) {
		RcMessageBox(EG_PIF_STARTFILE_ERR, NULL, NULL,
			     RMB_ICON_BANG | RMB_ABORT
			     );
		goto CleanUpAndReturn;
	    }
	    //
	    dw = GetShortPathNameOem(pfdata.StartFile, pfdata.StartFile,
				     MAX_PATH + 1);
	    if (dw == 0 || dw > MAX_PATH || dw > 64) {

		RcMessageBox(EG_PIF_STARTFILE_ERR, NULL, NULL,
			     RMB_ICON_BANG | RMB_ABORT
			     );
		goto CleanUpAndReturn;
	    }
	}
    }

    // merge program file name with command tail
    if (IsPIFFile || (!index && pfdata.CmdLine)) {
	if (IsPIFFile) {
	    pFilePart = pfdata.StartFile;
	    dw = strlen(pfdata.StartFile);
	 }
	else {
	    pFilePart = pvi->CmdLine;
	    dw = (DWORD)(pCmdLine - pFilePart);
	}
	strncpy(FullPathName, pFilePart, dw);
	pFilePart = FullPathName + dw;
	if (!index && pfdata.CmdLine) {
	    // pif has optional parameter and the comamnd tail
	    // is empty: optional parameter will be the commad tail
	    *pFilePart ++ = ' ';
	    strcpy(pFilePart, pfdata.CmdLine);
	    strcpy(pFilePart + strlen(pFilePart), "\x0d\x0a");
	}
	else
	    strcpy(pFilePart, pCmdLine);

	if (strlen(FullPathName) > 127) {
	    // too bad, the command line is too long
	    RcMessageBox(EG_PIF_CMDLINE_ERR, NULL, NULL,
			 RMB_ICON_BANG | RMB_ABORT);
	    goto CleanUpAndReturn;
	}
	strcpy(pvi->CmdLine, FullPathName);
	pvi->CmdSize = strlen(FullPathName) + 1;

    }
    if (IsPIFFile)
	// we don't know the binary type at this point.
	*pIsDosBinary = 0;

    if (pfdata.WinTitle)
	SetConsoleTitle(pfdata.WinTitle);

    DontCheckDosBinaryType = (pfdata.SubSysId == SUBSYS_DOS);

CleanUpAndReturn:
    if (pfdata.CmdLine) {
	free(pfdata.CmdLine);
	pfdata.CmdLine = NULL;
    }
    if (pfdata.StartDir) {
	free(pfdata.StartDir);
	pfdata.StartDir = NULL;
    }
    if (pfdata.StartFile) {
	free(pfdata.StartFile);
	pfdata.StartFile = NULL;
    }
    if (pfdata.WinTitle) {
	free(pfdata.WinTitle);
	pfdata.WinTitle = NULL;
    }
    return;

}
