/* 
   ccpu4.h

   Define all Arithmetic/Logical CPU functions.
 */

/*
   static char SccsID[]="@(#)ccpu4.h	1.1 4/3/91 Copyright Insignia Solutions Ltd.";
 */

#ifdef ANSI
IMPORT VOID ADC(ULONG *pop1, ULONG op2, INT op_sz);
IMPORT VOID ADD(ULONG *pop1, ULONG op2, INT op_sz);
IMPORT VOID AND(ULONG *pop1, ULONG op2, INT op_sz);
IMPORT VOID CMP(ULONG op1, ULONG op2, INT op_sz);
IMPORT VOID DEC(ULONG *pop1, INT op_sz);
IMPORT VOID DIV8(ULONG op2);
IMPORT VOID DIV16(ULONG op2);
IMPORT VOID IDIV8(ULONG op2);
IMPORT VOID IDIV16(ULONG op2);
IMPORT VOID IMUL8(ULONG *pop1, ULONG op2);
IMPORT VOID IMUL16(ULONG *pop1, ULONG op2);
IMPORT VOID IMUL16T(ULONG *pop1, ULONG op2, ULONG op3);
IMPORT VOID INC(ULONG *pop1, INT op_sz);
IMPORT VOID MUL8(ULONG *pop1, ULONG op2);
IMPORT VOID MUL16(ULONG *pop1, ULONG op2);
IMPORT VOID NEG(ULONG *pop1, INT op_sz);
IMPORT VOID NOT(ULONG *pop1);
IMPORT VOID OR(ULONG *pop1, ULONG op2, INT op_sz);
IMPORT VOID SBB(ULONG *pop1, ULONG op2, INT op_sz);
IMPORT VOID SUB(ULONG *pop1, ULONG op2, INT op_sz);
IMPORT VOID TEST(ULONG op1, ULONG op2, INT op_sz);
IMPORT VOID XOR(ULONG *pop1, ULONG op2, INT op_sz);
#else
IMPORT VOID ADC();
IMPORT VOID ADD();
IMPORT VOID AND();
IMPORT VOID CMP();
IMPORT VOID DEC();
IMPORT VOID DIV8();
IMPORT VOID DIV16();
IMPORT VOID IDIV8();
IMPORT VOID IDIV16();
IMPORT VOID IMUL8();
IMPORT VOID IMUL16();
IMPORT VOID IMUL16T();
IMPORT VOID INC();
IMPORT VOID MUL8();
IMPORT VOID MUL16();
IMPORT VOID NEG();
IMPORT VOID NOT();
IMPORT VOID OR();
IMPORT VOID SBB();
IMPORT VOID SUB();
IMPORT VOID TEST();
IMPORT VOID XOR();
#endif /* ANSI */
