/*++

Copyright (c) 1990  Microsoft Corporation

Module Name:

    msgbind.c

Abstract:

    Contains the RPC bind and un-bind routines for the Service Controller.

Author:

    Dan Lafferty (danl)     29-May-1991

Environment:

    User Mode -Win32

Revision History:


--*/

//
// INCLUDES
//
#include <nt.h>         // DbgPrint prototype
#include <rpc.h>        // DataTypes and runtime APIs
#include <msgsvc.h>     // generated by the MIDL complier
#include <rpcutil.h>    // NetRpc utils
#include <netlib.h>     // UNUSED macro



/****************************************************************************/
handle_t
MSGSVC_HANDLE_bind (
    MSGSVC_HANDLE   ServerName)

/*++

Routine Description:
    This routine calls a common bind routine that is shared by all services.
    This routine is called from the messenger service client stubs when
    it is necessary to bind to a server.

Arguments:

    ServerName - A pointer to a string containing the name of the server
        to bind with.

Return Value:

    The binding handle is returned to the stub routine.  If the
    binding is unsuccessful, a NULL will be returned.

--*/
{
    handle_t    bindingHandle;
    RPC_STATUS  status;

    status = NetpBindRpc (
                ServerName,
                TEXT("msgsvc"),
                TEXT("Security=Impersonation Dynamic False"),
                &bindingHandle);

#ifdef DEBUG
    DbgPrint("MSGSVC_HANDLE_bind:NetpBindRpc status=%d\n",status);
    DbgPrint("MSGSVC_HANDLE_bind: handle=%d\n",bindingHandle);
#endif

    return( bindingHandle);
}



/****************************************************************************/
void
MSGSVC_HANDLE_unbind (
    MSGSVC_HANDLE   ServerName,
    handle_t        BindingHandle)

/*++

Routine Description:

    This routine calls a common unbind routine that is shared by
    all services.
    This routine is called from the Messenger Service client stubs when
    it is necessary to unbind to a server.


Arguments:

    ServerName - This is the name of the server from which to unbind.

    BindingHandle - This is the binding handle that is to be closed.

Return Value:

    none.

--*/
{
    UNUSED(ServerName);     // This parameter is not used

#ifdef DEBUG
    DbgPrint("MSGSVC_HANDLE_unbind: handle=%d\n",BindingHandle);
#endif

    NetpUnbindRpc ( BindingHandle);
    return;
}

