/*++

Copyright (c) 1992-1993  Microsoft Corporation

Module Name:

    ImpDir.h

Abstract:

    This file contains structures, function prototypes, and definitions
    for the replicator import directory worker routines.

Author:

    John Rogers (JohnRo) 07-Jan-1992

Environment:

    User Mode - Win32
    Portable to any flat, 32-bit environment.  (Uses Win32 typedefs.)
    Requires ANSI C extensions: slash-slash comments, long external names.

Notes:

    You must include LmCons.h and ReplDefs.h before this file.

Revision History:

    07-Jan-1992 JohnRo
        Created.
    09-Jan-1992 JohnRo
        Added ImportDirBuildApiRecord().
        Added IMPORT_DIR_SECTION_NAME equate.
        Added ImportDir{Read,Write}ConfigData.
    16-Jan-1992 JohnRo
        Corrected "Notes" comment above.
    20-Jan-1992 JohnRo
        Netr prototypes are now generated by MIDL and put in repl.h.
    23-Jan-1992 JohnRo
        Clarify units for time parameters.
        Changed IMPORT_DIR_SECTION_NAME.
    27-Jan-1992 JohnRo
        Added ImportDirSetState().
        Changed to use LPTSTR etc.
        Changed to avoid use of client-specific data structure.
    09-Feb-1992 JohnRo
        Added ImportDir{Start,Stop}Repl routines.
    13-Feb-1992 JohnRo
        Moved section name equates to ConfName.h.
    19-Feb-1992 JohnRo
        Added ImportDirIsApiRecordValid() and various other routines.
    21-Feb-1992 JohnRo
        UncMaster parm is optional to ImportDirBuildApiRecord.
    21-Feb-1992 JohnRo
        Changed ImportDirBuildApiRecord() so master name is not a UNC name.
    15-Mar-1992 JohnRo
        Update registry with new values.
    23-Mar-1992 JohnRo
        Added ImportDirReadClientList().
    24-Mar-1992 JohnRo
        UncMaster parm is optional to ImportDirWriteConfigData().
    30-Jul-1992 JohnRo
        Help PC-LINT understand ImportDirIsLevelValid().
    25-Sep-1992 JohnRo
        RAID 5494: repl svc does not maintain time stamp on import startup.
    29-Sep-1992 JohnRo
        RAID 7962: Repl APIs in wrong role kill svc.
        Also fix remote repl admin.
    01-Dec-1992 JohnRo
        RAID 3844: remote NetReplSetInfo uses local machine type.
    13-Apr-1993 JohnRo
        RAID 3107: locking directory over the net gives network path not found.

--*/


#ifndef _IMPDIR_
#define _IMPDIR_


//
// Import dir helper routines and macros:
//


// Allocate one or more API records for an import directory.  Callable whether
// or not the replicator service is started.  (Used in getinfo stub, getinfo
// worker, and enum stub.)
NET_API_STATUS
ImportDirAllocApiRecords (
    IN DWORD Level,
    IN DWORD EntryCount,
    OUT LPBYTE * BufPtr,
    IN OUT LPBYTE *StringLocation       // Points just past top of data.
    );

NET_API_STATUS
ImportDirBuildApiRecord (
    IN DWORD Level,
    IN LPTSTR DirName,
    IN DWORD State,
    IN LPTSTR MasterName OPTIONAL,      // computer name (not UNC).
    IN DWORD TimeOfLastUpdate,          // Seconds since 1970.
    IN DWORD LockCount,
    IN DWORD TimeOfFirstLock,           // Seconds since 1970.
    OUT LPVOID Buffer,
    IN OUT LPBYTE *StringLocation       // Points just past top of data.
    );

// Tells whether or not config data for this directory exists.
// Callable even if the replicator service is not started.
BOOL
ImportDirConfigDataExists (
    IN LPTSTR UncServerName OPTIONAL,
    IN LPTSTR DirName                   // Caller must check dir name syntax.
    );

NET_API_STATUS
ImportDirConfigSetInfo (
    IN LPTSTR UncServerName OPTIONAL,
    IN LPTSTR DirName,
    IN DWORD Level,
    IN LPVOID Buf,
    OUT LPDWORD ParmError OPTIONAL
    );

// Delete config data for this directory.
// Returns NERR_UnknownDevDir if config data doesn't exist for this dir.
// Callable even if the replicator service is not started.
NET_API_STATUS
ImportDirDeleteConfigData (
    IN LPTSTR UncServerName OPTIONAL,
    IN LPTSTR DirName                   // Caller must check dir name syntax.
    );

// Callable even if the replicator service is not started.
NET_API_STATUS
ImportDirEnumApiRecords(
    IN LPTSTR UncServerName OPTIONAL,
    IN DWORD Level,
    OUT LPBYTE * BufPtr,
    IN DWORD PrefMaxSize,
    OUT LPDWORD EntriesRead,
    OUT LPDWORD TotalEntries
    );

// Callable even if the replicator service is not started.
NET_API_STATUS
ImportDirGetApiRecord (
    IN LPTSTR UncServerName OPTIONAL,
    IN LPTSTR DirName,
    IN DWORD Level,
    OUT LPBYTE * BufPtr
    );

BOOL
ImportDirIsApiRecordValid (
    IN DWORD Level,
    IN LPVOID ApiRecord,
    OUT LPDWORD ParmError OPTIONAL
    );

// BOOL
// ImportDirIsLevelValid(
//     IN DWORD Level
//     );
//
#define ImportDirIsLevelValid(Level) \
    /*lint -e506 */  /* don't complain about constant values here */ \
    ( ((Level) <= 1 ) ? TRUE : FALSE ) \
    /*lint +e506 */ \

// Callable whether or not service is started.
// If service is running, assume caller has lock (any kind) on RCGlobalListLock.
NET_API_STATUS
ImportDirLockInRegistry(
    IN LPTSTR UncServerName OPTIONAL,
    IN LPTSTR DirName
    );

// Parse config data for a single import directory.  Callable whether or not
// the replicator service is started.
NET_API_STATUS
ImportDirParseConfigData (
    IN LPTSTR UncServerName OPTIONAL,
    IN LPTSTR KeywordValue,
    OUT LPDWORD StatePtr,
    OUT LPTSTR MasterPtr,
    OUT LPDWORD LastUpdateTimePtr,      // Seconds since 1970.
    OUT LPDWORD LockCountPtr,
    OUT LPDWORD LockTimePtr             // Seconds since 1970.
    );

// Read import dirs into service's client list.
// Only callable as part of the service itself.
NET_API_STATUS
ImportDirReadClientList(
    VOID
    );

// Read config data for a single import directory.  Callable whether or not
// the replicator service is started.
NET_API_STATUS
ImportDirReadConfigData (
    IN LPTSTR UncServerName OPTIONAL,
    IN LPTSTR DirName,
    OUT LPDWORD StatePtr,
    OUT LPTSTR MasterPtr,
    OUT LPDWORD LastUpdateTimePtr,      // Seconds since 1970.
    OUT LPDWORD LockCountPtr,
    OUT LPDWORD LockTimePtr             // Seconds since 1970.
    );

// Change the state for a single import directory.
NET_API_STATUS
ImportDirSetState (
    IN LPTSTR DirName,
    IN DWORD State                      // Must be REPL_STATE_ value.
    );

// Start replicating (importing).
// Called when service starts or user does NetReplSetInfo() and changes role.
NET_API_STATUS
ImportDirStartRepl (
    IN BOOL ServiceIsStarting
    );

// Stop replicating (importing).
// Called when service stops or user does NetReplSetInfo() and changes role.
NET_API_STATUS
ImportDirStopRepl (
    VOID
    );

// Callable whether or not service is started.
// If service is running, assume caller has lock (any kind) on RCGlobalListLock.
NET_API_STATUS
ImportDirUnlockInRegistry(
    IN LPTSTR UncServerName OPTIONAL,
    IN LPTSTR DirName,
    IN DWORD UnlockForce
    );

// Write config data for a single import directory.  Callable whether or not
// the replicator service is started.
NET_API_STATUS
ImportDirWriteConfigData (
    IN LPTSTR UncServerName OPTIONAL,
    IN LPTSTR DirName,
    IN DWORD State,
    IN LPTSTR UncMaster OPTIONAL,
    IN DWORD LastUpdateTime,            // Seconds since 1970.
    IN DWORD LockCount,
    IN DWORD LockTime                   // Seconds since 1970.
    );


#endif // _IMPDIR_
