/*++

Copyright (c) 1993  Microsoft Corporation

Module Name:

    rplbind.c

Abstract:

    Contains the RPC bind and un-bind routines for the Remote (Initial)
    Program Load service.

Author:

    Vladimir Z. Vulovic (vladimv)       27 - July - 1993

Environment:

    User Mode -Win32

Revision History:


--*/

//
// INCLUDES
//
#include <nt.h>         // DbgPrint prototype
#include <rpc.h>        // DataTypes and runtime APIs
#include <rplsvc_c.h>   // generated by the MIDL complier
#include <rpcutil.h>    // NetRpc utils
#include <netlib.h>     // UNUSED macro
#include <rplnames.h>   //  RPL_INTERFACE_NAME



/****************************************************************************/
handle_t
RPL_NAME_bind (
    RPL_NAME        ServerName
    )
/*++

Routine Description:
    This routine calls a common bind routine that is shared by all services.
    This routine is called from the remote boot service client stubs when
    it is necessary to bind to a server.

Arguments:

    ServerName - A pointer to a string containing the name of the server
        to bind with.

Return Value:

    The binding handle is returned to the stub routine.  If the
    binding is unsuccessful, a NULL will be returned.

--*/
{
    handle_t    bindingHandle;
    RPC_STATUS  status;

    status = NetpBindRpc (
                ServerName,
                RPL_INTERFACE_NAME,
                0,
                &bindingHandle);

#ifdef DEBUG
    DbgPrint("RPLSVC_HANDLE_bind:NetpBindRpc status=%d\n",status);
    DbgPrint("RPLSVC_HANDLE_bind: handle=%d\n",bindingHandle);
#endif

    return( bindingHandle);
}



/****************************************************************************/
void
RPL_NAME_unbind (
    RPL_NAME        ServerName,
    handle_t        BindingHandle
    )
/*++

Routine Description:

    This routine calls a common unbind routine that is shared by
    all services.
    This routine is called from the remote boot service client stubs when
    it is necessary to unbind to a server.


Arguments:

    ServerName - This is the name of the server from which to unbind.

    BindingHandle - This is the binding handle that is to be closed.

Return Value:

    none.

--*/
{
    UNUSED(ServerName);     // This parameter is not used

#ifdef DEBUG
    DbgPrint("RPLSVC_HANDLE_unbind: handle=%d\n",BindingHandle);
#endif

    NetpUnbindRpc ( BindingHandle);
    return;
}

