/*++

Copyright (c) 1993  Microsoft Corporation
Copyright (c) 1993  Digital Equipment Corporation

Module Name:

    fwstring.h

Abstract:

    This module contains the extern statements and #defines for
    the firmware English strings.  This is fwstring.h and the
    jzstring.h files concatenated together.

Author:

    David M. Robinson (davidro) 21-May-1993


Revision History:

    7-June-1993	John DeRosa	[DEC]

    Modified for Alpha AXP and Jensen.

--*/

//
// Common strings.
//

extern PCHAR FW_OK_MSG;
extern PCHAR FW_CRLF_MSG;
extern PCHAR FW_ERROR2_MSG;

//
// Firmware strings.
//

extern PCHAR FW_BOOT_MSG;
#define FW_BOOT_MSG_SIZE		5

extern PCHAR FW_INVALID_RESTART_BLOCK_MSG;
extern PCHAR FW_NOT_ENOUGH_ENTRIES_MSG;
extern PCHAR FW_FILESYSTEM_NOT_REQ_MSG;
extern PCHAR FW_UNKNOWN_SECTION_TYPE_MSG;
extern PCHAR FW_UNKNOWN_RELOC_TYPE_MSG;
extern PCHAR FW_UNKNOWN_ROM_MSG;
extern PCHAR FW_DEFAULT_MSG;
extern PCHAR FW_FIRMWARE_UPDATE_SEARCH_MSG;
extern PCHAR FW_NO_BOOT_SELECTIONS_MSG;
extern PCHAR FW_DO_NOT_POWER_OFF_MSG;
extern PCHAR FW_USE_ARROW_AND_ENTER_MSG;
extern PCHAR FW_AUTOBOOT_MSG;
extern PCHAR FW_INTERNAL_ERROR_ENVIRONMENT_VARS_MSG;
extern PCHAR FW_PROGRAM_TO_RUN_MSG;
extern PCHAR FW_PATHNAME_NOT_DEF_MSG;
extern PCHAR FW_PRESS_ANY_KEY_MSG;
extern PCHAR FW_ERROR_CODE_MSG;
extern PCHAR FW_PRESS_ANY_KEY2_MSG;
extern PCHAR FW_INITIALIZING_MSG;
extern PCHAR FW_CONSOLE_IN_ERROR_MSG;
extern PCHAR FW_CONSOLE_TRYING_TO_OPEN_MSG;
extern PCHAR FW_CONSOLE_IN_FAILSAFE_ERROR_MSG;
extern PCHAR FW_CONSOLE_OUT_FAILSAFE_ERROR_MSG;
extern PCHAR FW_CONSOLE_IN_PLEASE_REPAIR_MSG;
extern PCHAR FW_CONSOLE_OUT_PLEASE_REPAIR_MSG;
extern PCHAR FW_CONSOLE_IN_ERROR2_MSG;
extern PCHAR FW_CONSOLE_OUT_ERROR_MSG;
extern PCHAR FW_CONSOLE_OUT_ERROR2_MSG;
extern PCHAR FW_CONTACT_FIELD_SERVICE_MSG;
extern PCHAR FW_SPIN_DISKS_MSG;
extern PCHAR FW_NO_CDROM_DRIVE_MSG;
extern PCHAR FW_WNT_INSTALLATION_ABORTED_MSG;

extern PCHAR FW_MARKING_EISA_BUFFER_MSG;
extern PCHAR FW_MARKING_EISA_BUFFER_ERROR_MSG;

extern PCHAR FW_RED_BANNER_PRESSKEY_MSG;

extern PCHAR FW_SYSTEM_INCONSISTENCY_WARNING_MSG[];
#define FW_SYSTEM_INCONSISTENCY_WARNING_MSG_SIZE	3

extern PCHAR FW_SYSTEM_INCONSISTENCY_WARNING_HOWTOFIX_MSG[];
#define FW_SYSTEM_INCONSISTENCY_WARNING_HOWTOFIX_MSG_SIZE	3

extern PCHAR FW_ERROR_MSG[];


//
// Halt, machine check messages
//

extern PCHAR FW_SYSRQ_MONITOR_MSG;
extern PCHAR FW_FATAL_DMC_MSG;
extern PCHAR FW_FATAL_MCINPALMODE_MSG;
extern PCHAR FW_FATAL_UNKNOWN_MSG;
extern PCHAR FW_FATAL_TAGCNTRL_PE_MSG;
extern PCHAR FW_FATAL_TAG_PE_MSG;
extern PCHAR FW_FATAL_HEACK_MSG;
extern PCHAR FW_FATAL_SEACK_MSG;
extern PCHAR FW_FATAL_ECC_ERROR_MSG;
extern PCHAR FW_FATAL_QWLWLW_MSG;
extern PCHAR FW_FATAL_PE_MSG;
extern PCHAR FW_FATAL_MULTIPLE_EXT_TAG_ERRORS_MSG;
extern PCHAR FW_FATAL_MULTIPLE_FILL_ERRORS_MSG;


//
// Menu types
//

extern PCHAR FW_MENU_BOOT_MSG;
extern PCHAR FW_MENU_SUPPLEMENTARY_MSG;
extern PCHAR FW_MENU_SETUP_MSG;
extern PCHAR FW_MENU_BOOT_SELECTIONS_MSG;


//
// Menu strings
//

extern PCHAR BootMenuChoices[];
extern PCHAR SupplementaryMenuChoices[];
extern PCHAR OperatingSystemSwitchChoices[];
extern PCHAR MachineProblemAreas[];

#define NUMBER_OF_BOOT_CHOICES		4
#define NUMBER_OF_SUPP_CHOICES		6
#define NUMBER_OF_OS_CHOICES  		4
#define NUMBER_OF_MACHINE_PROBLEM_AREAS	8


//
// Monitor Strings.
//

extern PCHAR MON_INVALID_ARGUMENT_COUNT_MSG;
extern PCHAR MON_UNALIGNED_ADDRESS_MSG;
extern PCHAR MON_INVALID_VALUE_MSG;
extern PCHAR MON_INVALID_REGISTER_MSG;
extern PCHAR MON_BAD_IO_OPERATION_MSG;
extern PCHAR MON_NOT_VALID_ADDRESS_MSG;
extern PCHAR MON_INVALID_ADDRESS_RANGE_MSG;
extern PCHAR MON_AVAILABLE_HW_DEVICES_MSG;
extern PCHAR MON_MONITOR_MSG;
extern PCHAR MON_PRESS_H_MSG;
extern PCHAR MON_EXCEPTION_MSG;
extern PCHAR MON_NO_RETURN_MSG;
extern PCHAR MON_RESET_MACHINE_MSG;
extern PCHAR MON_UNRECOGNIZED_COMMAND_MSG;

extern PCHAR MON_HELP_TABLE[];
#define MON_HELP_SIZE 		16

//
// Selftest module strings.
//

extern PCHAR ST_ALL_IO_TO_SERIAL_LINES_MSG;
extern PCHAR ST_BAD_PAGE_SIZE_MSG;
extern PCHAR ST_BAD_MEMORY_SIZE_MSG;
extern PCHAR ST_BAD_CLOCK_PERIOD_MSG;
extern PCHAR ST_EISA_ISP_ERROR_MSG;
extern PCHAR FW_ARC_MULTIBOOT_MSG;
extern PCHAR FW_COPYRIGHT_MSG;

//
// FailSafe Booter strings.  If necessary, this could be an entirely
// separate message file to conserve space.
//

extern PCHAR FSB_MSG;
extern PCHAR FSB_WHY_RUNNING_MSG;
extern PCHAR FSB_FIELD_SERVICE_MSG;
extern PCHAR FSB_LOOKING_FOR_MSG;
extern PCHAR FSB_UPGRADE_ABORTED_MSG;
extern PCHAR FSB_POWER_CYCLE_TO_REBOOT_MSG;


//
// Stubs strings.
//

extern PCHAR ST_RESERVED_ROUTINE_MSG;
extern PCHAR ST_STACK_UNDERFLOW_1_MSG;
extern PCHAR ST_STACK_UNDERFLOW_2_MSG;
extern PCHAR ST_STACK_UNDERFLOW_3_MSG;
extern PCHAR ST_HIT_KEY_FOR_MONITOR_MSG;
extern PCHAR ST_BUGCHECK_MSG;
extern PCHAR ST_ASSERT_MSG;
extern PCHAR ST_HIT_KEY_FOR_REBOOT_MSG;


//
// Definitions for the built-in ROM setup utility
//

#define SS_CRLF_MSG	FW_CRLF_MSG

//
// Prompt strings.
//

extern PCHAR SS_TOO_MANY_BOOT_SELECTIONS;
extern PCHAR SS_COUNTDOWN_MSG;
extern PCHAR SS_OSLOADER_MSG;
extern PCHAR SS_OS_MSG;
extern PCHAR SS_OS_ROOT_MSG;
extern PCHAR SS_BOOT_NAME_MSG;
extern PCHAR SS_INIT_DEBUG_MSG;
extern PCHAR SS_CANT_SET_VARIABLE_MSG;
extern PCHAR SS_NO_SELECTIONS_TO_DELETE_MSG;
extern PCHAR SS_SELECTION_TO_DELETE_MSG;
extern PCHAR SS_ENVIR_FOR_BOOT_MSG;
extern PCHAR SS_FORMAT1_MSG;
extern PCHAR SS_USE_ARROWS_MSG;
extern PCHAR SS_NO_SELECTIONS_TO_EDIT_MSG;
extern PCHAR SS_SELECTION_TO_EDIT_MSG;
extern PCHAR SS_NO_SELECTIONS_TO_REARRANGE_MSG;
extern PCHAR SS_PICK_SELECTION_MSG;
extern PCHAR SS_SHOULD_AUTOBOOT_MSG;
extern PCHAR SS_ENVIRONMENT_VARS_MSG;
extern PCHAR SS_CHECKING_MSG;
extern PCHAR SS_CHECKING_BOOT_SEL_NUMBER_MSG;
extern PCHAR SS_FORMAT2_MSG;
extern PCHAR SS_VARIABLE_NULL_MSG;
extern PCHAR SS_CANT_BE_FOUND_MSG;
extern PCHAR SS_PROBLEMS_FOUND_MSG;
extern PCHAR SS_PROBLEMS_CHOOSE_AN_ACTION_MSG;
extern PCHAR SS_SELECTION_MENU_MSG;
extern PCHAR SS_ECU_WILL_NOW_REBOOT_MSG;
extern PCHAR SS_RESET_TO_FACTORY_DEFAULTS_WARNING_MSG;
extern PCHAR SS_ARE_YOU_SURE_MSG;
extern PCHAR SS_ESCAPE_FROM_SETUP_MSG;
extern PCHAR SS_PRESS_KEY_MSG;
extern PCHAR SS_PRESS_KEY2_MSG;
extern PCHAR SS_NAME_MSG;
extern PCHAR SS_VALUE_MSG;
extern PCHAR SS_NO_NVRAM_SPACE_MSG;
extern PCHAR SS_NVRAM_CHKSUM_MSG;
extern PCHAR SS_ROM_UPDATE_IN_PROGRESS_MSG;
extern PCHAR SS_ROM_UPDATE_FAILED_MSG;
extern PCHAR SS_SELECT_MEDIA_MSG;
extern PCHAR SS_SELECT_MONITOR_RESOLUTION_MSG;
extern PCHAR SS_ENTER_FAT_OR_NTFS_PART_MSG;
extern PCHAR SS_ENTER_PART_MSG;
extern PCHAR SS_SELECT_SYS_PART_MSG;
extern PCHAR SS_SCSI_HD_MSG;
extern PCHAR SS_FL_MSG;
extern PCHAR SS_SCSI_CD_MSG;
extern PCHAR SS_NEW_SYS_PART_MSG;
extern PCHAR SS_LOCATE_SYS_PART_MSG;
extern PCHAR SS_ENTER_SCSI_ID_MSG;
extern PCHAR SS_ENTER_FLOPPY_DRIVE_NUMBER_MSG;
extern PCHAR SS_LOCATE_OS_PART_MSG;
extern PCHAR SS_FLOPPY_SIZE_MSG;
extern PCHAR SS_2ND_FLOPPY_MSG;
extern PCHAR SS_SCSI_HOST_MSG;
extern PCHAR SS_DEFAULT_SYS_PART_MSG;
extern PCHAR SS_ENTER_DATE_MSG;
extern PCHAR SS_ENTER_TIME_MSG;
extern PCHAR SS_ILLEGAL_TIME_MSG;
extern PCHAR SS_PM;
extern PCHAR SS_AM;
extern PCHAR SS_WHICH_OS_QUERY_MSG;
extern PCHAR SS_BOOT_SELECTION_IS_MSG;
extern PCHAR SS_POWER_CYCLE_FOR_NEW_OS_MSG;

extern PCHAR SETUP_HELP_TABLE[];
#define SETUP_HELP_TABLE_SIZE		18

//
// Menus.
//

extern PCHAR ProblemChoices[];
#define NUMBER_OF_PROBLEMS 3

extern PCHAR YesNoChoices[];
#define NUMBER_OF_YES_NO 2

extern PCHAR MediaChoices[];
#define NUMBER_OF_MEDIA 3

extern PCHAR ManageBootSelectionChoices[];
#define NUMBER_OF_SS_MANAGE_BOOT_CHOICES	7

extern PCHAR ResolutionChoices[];
#define NUMBER_OF_RESOLUTIONS 4

extern PCHAR FloppyChoices[];
#define NUMBER_OF_FLOPPIES 3

extern PCHAR Weekday[];

extern PCHAR SetupMenuChoices[];
#define NUMBER_OF_SETUP_MENU_CHOICES 	14

extern PCHAR OperatingSystemNames[];
