/*++

Copyright (c) 1993  Digital Equipment Corporation


Module Name:

    jenfonts.c

Abstract:

    8x16 pixel fonts for the VGA video boot driver.  The normal printing
    ASCII characters were stolen from David Conroy's Beta-machine fonts.

Author:

    John DeRosa		7-May-1992

Revision History:

--*/

#include "fwp.h"

// Undefined characters.
UCHAR VGA8x16Undef[] = {
        0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
        0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
	};

	
//
// Normal ASCII characters 0x20 -- 0x7f (space -- del).  Each byte is one
// scan line, and each character is 2 rows.
//
// The bullet character is in the del slot.
//
UCHAR VGA8x16Chars[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	// ASCII 0x20, space
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,	// ASCII 0x21, !
	0x18, 0x18, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00,
	0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,	// ASCII 0x22, "
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x66, 0x66, 0xFF, 0xFF, 0x66, 0x66,	// ASCII 0x23, #
	0xFF, 0xFF, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00,
	0x18, 0x18, 0x3E, 0x7E, 0x60, 0x60, 0x7C, 0x3E,	// ASCII 0x24, $
	0x06, 0x06, 0x7E, 0x7C, 0x18, 0x18, 0x00, 0x00,
	0x00, 0x00, 0x66, 0x66, 0x6C, 0x0C, 0x18, 0x18,	// ASCII 0x25, %
	0x30, 0x36, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00,
	0x38, 0x7C, 0x6C, 0x6C, 0x38, 0x38, 0x70, 0x70,	// ASCII 0x26, &
	0xDE, 0xDE, 0xCC, 0xCC, 0xFE, 0x76, 0x00, 0x00,
	0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,	// ASCII 0x27, '
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x06, 0x0C, 0x1C, 0x18, 0x18, 0x18,	// ASCII 0x28, (
	0x18, 0x18, 0x18, 0x1C, 0x0C, 0x06, 0x00, 0x00,
	0x00, 0x00, 0x60, 0x30, 0x38, 0x18, 0x18, 0x18,	// ASCII 0x29, )
	0x18, 0x18, 0x18, 0x38, 0x30, 0x60, 0x00, 0x00,
	0x00, 0x00, 0x66, 0x66, 0x3C, 0x3C, 0xFF, 0xFF,	// ASCII 0x2a, *
	0x3C, 0x3C, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x7E, 0x7E,	// ASCII 0x2b, +
	0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	// ASCII 0x2c, ,
	0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x30, 0x20,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7E, 0x7E,	// ASCII 0x2d, -
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	// ASCII 0x2e, .
	0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00,
	0x00, 0x00, 0x06, 0x06, 0x06, 0x0C, 0x0C, 0x18,	// ASCII 0x2f, /
	0x18, 0x30, 0x30, 0x60, 0x60, 0x60, 0x00, 0x00,
	0x00, 0x00, 0x3C, 0x7E, 0x66, 0x66, 0x66, 0x6E,	// ASCII 0x30, 0
	0x76, 0x66, 0x66, 0x66, 0x7E, 0x3C, 0x00, 0x00,
	0x00, 0x00, 0x18, 0x18, 0x38, 0x38, 0x18, 0x18,	// ASCII 0x31, 1
	0x18, 0x18, 0x18, 0x18, 0x7E, 0x7E, 0x00, 0x00,
	0x00, 0x00, 0x3C, 0x7E, 0x66, 0x66, 0x0C, 0x0C,	// ASCII 0x32, 2
	0x18, 0x18, 0x30, 0x30, 0x7E, 0x7E, 0x00, 0x00,
	0x00, 0x00, 0x7E, 0x7E, 0x0C, 0x0C, 0x18, 0x18,	// ASCII 0x33, 3
	0x0C, 0x0C, 0x66, 0x66, 0x7E, 0x3C, 0x00, 0x00,
	0x00, 0x00, 0x0C, 0x0C, 0x1C, 0x1C, 0x3C, 0x3C,	// ASCII 0x34, 4
	0x6C, 0x6C, 0x7E, 0x7E, 0x0C, 0x0C, 0x00, 0x00,
	0x00, 0x00, 0x7E, 0x7E, 0x60, 0x60, 0x7C, 0x7E,	// ASCII 0x35, 5
	0x06, 0x06, 0x06, 0x66, 0x7E, 0x3C, 0x00, 0x00,
	0x00, 0x00, 0x1C, 0x3C, 0x70, 0x60, 0x60, 0x7C,	// ASCII 0x36, 6
	0x7E, 0x66, 0x66, 0x66, 0x7E, 0x3C, 0x00, 0x00,
	0x00, 0x00, 0x7E, 0x7E, 0x06, 0x06, 0x0C, 0x0C,	// ASCII 0x37, 7
	0x18, 0x18, 0x30, 0x30, 0x30, 0x30, 0x00, 0x00,
	0x00, 0x00, 0x3C, 0x7E, 0x66, 0x66, 0x3C, 0x3C,	// ASCII 0x38, 8
	0x66, 0x66, 0x66, 0x66, 0x7E, 0x3C, 0x00, 0x00,
	0x00, 0x00, 0x3C, 0x7E, 0x66, 0x66, 0x7E, 0x3E,	// ASCII 0x39, 9
	0x06, 0x06, 0x06, 0x0E, 0x3C, 0x38, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18,	// ASCII 0x3a, :
	0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x18, 0x18,	// ASCII 0x3b, ;
	0x00, 0x00, 0x18, 0x18, 0x18, 0x18, 0x30, 0x20,
	0x00, 0x00, 0x00, 0x0E, 0x1C, 0x38, 0x70, 0xE0,	// ASCII 0x3c, <
	0x70, 0x38, 0x1C, 0x0E, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x7E, 0x7E, 0x00, 0x00,	// ASCII 0x3d, =
	0x7E, 0x7E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xE0, 0x70, 0x38, 0x1C, 0x0E,	// ASCII 0x3e, >
	0x1C, 0x38, 0x70, 0xE0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x3C, 0x7E, 0x66, 0x66, 0x0C, 0x0C,	// ASCII 0x3f, ?
	0x18, 0x18, 0x18, 0x00, 0x18, 0x18, 0x00, 0x00,
	0x00, 0x00, 0x38, 0x7C, 0xE6, 0xC2, 0xDA, 0xD6,	// ASCII 0x40, @
	0xD6, 0xDC, 0xC0, 0xE2, 0x7E, 0x3C, 0x00, 0x00,
	0x00, 0x00, 0x18, 0x3C, 0x7E, 0x66, 0x66, 0x66,	// ASCII 0x41, A
	0x7E, 0x7E, 0x66, 0x66, 0x66, 0x66, 0x00, 0x00,
	0x00, 0x00, 0x7C, 0x7E, 0x66, 0x66, 0x7E, 0x7C,	// ASCII 0x42, B
	0x66, 0x66, 0x66, 0x66, 0x7E, 0x7C, 0x00, 0x00,
	0x00, 0x00, 0x3C, 0x7E, 0x66, 0x66, 0x60, 0x60,	// ASCII 0x43, C
	0x60, 0x60, 0x66, 0x66, 0x7E, 0x3C, 0x00, 0x00,
	0x00, 0x00, 0x78, 0x7C, 0x6E, 0x66, 0x66, 0x66,	// ASCII 0x44, D
	0x66, 0x66, 0x66, 0x6E, 0x7C, 0x78, 0x00, 0x00,
	0x00, 0x00, 0x7E, 0x7E, 0x60, 0x60, 0x7C, 0x7C,	// ASCII 0x45, E
	0x60, 0x60, 0x60, 0x60, 0x7E, 0x7E, 0x00, 0x00,
	0x00, 0x00, 0x7E, 0x7E, 0x60, 0x60, 0x7C, 0x7C,	// ASCII 0x46, F
	0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x00, 0x00,
	0x00, 0x00, 0x3E, 0x7E, 0x60, 0x60, 0x6E, 0x6E,	// ASCII 0x47, G
	0x66, 0x66, 0x66, 0x66, 0x7E, 0x3C, 0x00, 0x00,
	0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x7E, 0x7E,	// ASCII 0x48, H
	0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x00, 0x00,
	0x00, 0x00, 0x7E, 0x7E, 0x18, 0x18, 0x18, 0x18,	// ASCII 0x49, I
	0x18, 0x18, 0x18, 0x18, 0x7E, 0x7E, 0x00, 0x00,
	0x00, 0x00, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,	// ASCII 0x4a, J
	0x06, 0x06, 0x66, 0x66, 0x7E, 0x3C, 0x00, 0x00,
	0x00, 0x00, 0xCC, 0xCC, 0xD8, 0xD8, 0xF0, 0xF0,	// ASCII 0x4b, K
	0xD8, 0xD8, 0xCC, 0xCC, 0xC6, 0xC6, 0x00, 0x00,
	0x00, 0x00, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,	// ASCII 0x4c, L
	0x60, 0x60, 0x60, 0x60, 0x7E, 0x7E, 0x00, 0x00,
	0x00, 0x00, 0xC6, 0xC6, 0xEE, 0xEE, 0xFE, 0xD6,	// ASCII 0x4d, M
	0xD6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0x00, 0x00,
	0x00, 0x00, 0x66, 0x66, 0x66, 0x76, 0x76, 0x7E,	// ASCII 0x4e, N
	0x7E, 0x6E, 0x6E, 0x66, 0x66, 0x66, 0x00, 0x00,
	0x00, 0x00, 0x3C, 0x7E, 0x66, 0x66, 0x66, 0x66,	// ASCII 0x4f, O
	0x66, 0x66, 0x66, 0x66, 0x7E, 0x3C, 0x00, 0x00,
	0x00, 0x00, 0x7C, 0x7E, 0x66, 0x66, 0x66, 0x66,	// ASCII 0x50, P
	0x7E, 0x7C, 0x60, 0x60, 0x60, 0x60, 0x00, 0x00,
	0x00, 0x00, 0x3C, 0x7E, 0x66, 0x66, 0x66, 0x66,	// ASCII 0x51, Q
	0x66, 0x66, 0x66, 0x6A, 0x7C, 0x36, 0x00, 0x00,
	0x00, 0x00, 0xF8, 0xFC, 0xCC, 0xCC, 0xCC, 0xFC,	// ASCII 0x52, R
	0xF8, 0xD8, 0xCC, 0xCC, 0xC6, 0xC6, 0x00, 0x00,
	0x00, 0x00, 0x3E, 0x7E, 0x60, 0x60, 0x70, 0x38,	// ASCII 0x53, S
	0x1C, 0x0E, 0x06, 0x06, 0x7E, 0x7C, 0x00, 0x00,
	0x00, 0x00, 0x7E, 0x7E, 0x18, 0x18, 0x18, 0x18,	// ASCII 0x54, T
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00,
	0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,	// ASCII 0x55, U
	0x66, 0x66, 0x66, 0x66, 0x7E, 0x3C, 0x00, 0x00,
	0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,	// ASCII 0x56, V
	0x66, 0x66, 0x3C, 0x3C, 0x18, 0x18, 0x00, 0x00,
	0x00, 0x00, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xD6,	// ASCII 0x57, W
	0xD6, 0xFE, 0xFE, 0xEE, 0xC6, 0x82, 0x00, 0x00,
	0x00, 0x00, 0x66, 0x66, 0x66, 0x3C, 0x3C, 0x18,	// ASCII 0x58, X
	0x18, 0x3C, 0x3C, 0x66, 0x66, 0x66, 0x00, 0x00,
	0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x3C, 0x3C,	// ASCII 0x59, Y
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00,
	0x00, 0x00, 0x7E, 0x7E, 0x0C, 0x0C, 0x18, 0x18,	// ASCII 0x5a, Z
	0x30, 0x30, 0x60, 0x60, 0x7E, 0x7E, 0x00, 0x00,
	0x00, 0x00, 0x1E, 0x1E, 0x18, 0x18, 0x18, 0x18,	// ASCII 0x5b, [
	0x18, 0x18, 0x18, 0x18, 0x1E, 0x1E, 0x00, 0x00,
	0x00, 0x00, 0x60, 0x60, 0x60, 0x30, 0x30, 0x18,	// ASCII 0x5c, \ 
	0x18, 0x0C, 0x0C, 0x06, 0x06, 0x06, 0x00, 0x00,
	0x00, 0x00, 0x78, 0x78, 0x18, 0x18, 0x18, 0x18,	// ASCII 0x5d, ]
	0x18, 0x18, 0x18, 0x18, 0x78, 0x78, 0x00, 0x00,
	0x00, 0x10, 0x10, 0x38, 0x38, 0x6C, 0x6C, 0xC6,	// ASCII 0x5e, ^
	0xC6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	// ASCII 0x5f, _
	0x00, 0x00, 0x00, 0x00, 0xFE, 0xFE, 0x00, 0x00,
	0x40, 0x60, 0x70, 0x38, 0x1C, 0x0C, 0x04, 0x00,	// ASCII 0x60, `
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x3E, 0x06,	// ASCII 0x61, a
	0x3E, 0x7E, 0x66, 0x66, 0x7E, 0x3E, 0x00, 0x00,
	0x00, 0x00, 0x60, 0x60, 0x60, 0x7C, 0x7E, 0x66,	// ASCII 0x62, b
	0x66, 0x66, 0x66, 0x66, 0x7E, 0x7C, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x3E, 0x7E, 0x60,	// ASCII 0x63, c
	0x60, 0x60, 0x60, 0x60, 0x7E, 0x3E, 0x00, 0x00,
	0x00, 0x00, 0x06, 0x06, 0x06, 0x3E, 0x7E, 0x66,	// ASCII 0x64, d
	0x66, 0x66, 0x66, 0x66, 0x7E, 0x3E, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x7E, 0x66,	// ASCII 0x65, e
	0x66, 0x7E, 0x60, 0x60, 0x7E, 0x3E, 0x00, 0x00,
	0x00, 0x00, 0x0E, 0x1E, 0x18, 0x18, 0x7E, 0x7E,	// ASCII 0x66, f
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x3E, 0x7E, 0x66,	// ASCII 0x67, g
	0x66, 0x66, 0x66, 0x7E, 0x3E, 0x06, 0x7E, 0x7C,
	0x00, 0x00, 0x60, 0x60, 0x60, 0x7C, 0x7E, 0x66,	// ASCII 0x68, h
	0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x00, 0x00,
	0x00, 0x00, 0x18, 0x18, 0x00, 0x38, 0x38, 0x18,	// ASCII 0x69, i
	0x18, 0x18, 0x18, 0x18, 0x3C, 0x3C, 0x00, 0x00,
	0x00, 0x00, 0x0C, 0x0C, 0x00, 0x0C, 0x0C, 0x0C,	// ASCII 0x6a, j
	0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x7C, 0x78,
	0x00, 0x00, 0xC0, 0xC0, 0xC0, 0xCC, 0xDC, 0xF8,	// ASCII 0x6b, k
	0xF0, 0xF8, 0xD8, 0xCC, 0xCE, 0xC6, 0x00, 0x00,
	0x00, 0x00, 0x38, 0x38, 0x18, 0x18, 0x18, 0x18,	// ASCII 0x6c, l
	0x18, 0x18, 0x18, 0x18, 0x3C, 0x3C, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x6C, 0xFE, 0xFE,	// ASCII 0x6d, m
	0xD6, 0xD6, 0xD6, 0xC6, 0xC6, 0xC6, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x7E, 0x66,	// ASCII 0x6e, n
	0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x7E, 0x66,	// ASCII 0x6f, o
	0x66, 0x66, 0x66, 0x66, 0x7e, 0x3c, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x7e, 0x66,	// ascii 0x70, p
	0x66, 0x66, 0x66, 0x66, 0x7e, 0x7c, 0x60, 0x60,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x7e, 0x66,	// ascii 0x71, q
	0x66, 0x66, 0x66, 0x66, 0x7e, 0x3e, 0x06, 0x06,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x7e, 0x66,	// ascii 0x72, r
	0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x7e, 0x60,	// ascii 0x73, s
	0x70, 0x3c, 0x0e, 0x06, 0x7e, 0x7c, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x18, 0x18, 0x7e, 0x7e, 0x18,	// ascii 0x74, t
	0x18, 0x18, 0x18, 0x18, 0x1e, 0x0e, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x66,	// ascii 0x75, u
	0x66, 0x66, 0x66, 0x66, 0x7e, 0x3e, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x66,	// ascii 0x76, v
	0x66, 0x66, 0x3c, 0x3c, 0x18, 0x18, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0xc6, 0xd6,	// ascii 0x77, w
	0xd6, 0xfe, 0xfe, 0xee, 0xc6, 0x82, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x3c,	// ascii 0x78, x
	0x3c, 0x18, 0x3c, 0x3c, 0x66, 0x66, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x66, 0x66, 0x66,	// ascii 0x79, y
	0x66, 0x66, 0x66, 0x7e, 0x3e, 0x06, 0x7e, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x7e, 0x0c,	// ascii 0x7a, z
	0x18, 0x18, 0x30, 0x30, 0x7e, 0x7e, 0x00, 0x00,
	0x00, 0x0e, 0x18, 0x18, 0x18, 0x18, 0x38, 0xf0,	// ascii 0x7b, {
	0xf0, 0x38, 0x18, 0x18, 0x18, 0x18, 0x0e, 0x00,
	0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,	// ascii 0x7c, |
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00,
	0x00, 0xe0, 0x30, 0x30, 0x30, 0x30, 0x38, 0x1e,	// ascii 0x7d, }
	0x1e, 0x38, 0x30, 0x30, 0x30, 0x30, 0xe0, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x62, 0xf2, 0xbe,	// ascii 0x7e, ~
	0x9c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x3c, 0x3c,	// ascii 0x7f, <bullet>
	0x3c, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

#ifndef FAILSAFE_BOOTER
//
// Line drawing 8x16 characters.  These sit in the character codes
// 0xb3 -- 0xda.
//
UCHAR VGA8x16LineDrawing[] = {

	// ASCII 0xb3
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000

	// ASCII 0xb4
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0xf0,		// 11110000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000

	// ASCII 0xb5
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0xf0,		// 11110000
	0x10,		// 00010000
	0xf0,		// 11110000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000

	// ASCII 0xb6
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0xe8,		// 11101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000

	// ASCII 0xb7
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0xf8,		// 11111000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000

	// ASCII 0xb8
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0xf0,		// 11110000
	0x10,		// 00010000
	0xf0,		// 11110000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000

	// ASCII 0xb9
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0xe8,		// 11101000
	0x08,		// 00001000
	0xe8,		// 11101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000

	// ASCII 0xba
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000

	// ASCII 0xbb
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0xf8,		// 11111000
	0x08,		// 00001000
	0xe8,		// 11101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000

	// ASCII 0xbc
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0xe8,		// 11101000
	0x08,		// 00001000
	0xf8,		// 11111000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000

	// ASCII 0xbd
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0xf8,		// 11111000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000

	// ASCII 0xbe
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0xf0,		// 11110000
	0x10,		// 00010000
	0xf0,		// 11110000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000

	// ASCII 0xbf
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0xf0,		// 11110000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000

	// ASCII 0xc0
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x1f,		// 00011111
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000

	// ASCII 0xc1
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0xff,		// 11111111
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000

	// ASCII 0xc2
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0xff,		// 11111111
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000

	// ASCII 0xc3
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x1f,		// 00011111
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000

	// ASCII 0xc4
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0xff,		// 11111111
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000

	// ASCII 0xc5
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0xff,		// 11111111
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000

	// ASCII 0xc6
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x1f,		// 00011111
	0x10,		// 00010000
	0x1f,		// 00011111
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000

	// ASCII 0xc7
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x2f,		// 00101111
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000

	// ASCII 0xc8
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x2f,		// 00101111
	0x20,		// 00100000
	0x3f,		// 00111111
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000

	// ASCII 0xc9
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x3f,		// 00111111
	0x20,		// 00100000
	0x2f,		// 00101111
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000

	// ASCII 0xca
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0xef,		// 11101111
	0x00,		// 00000000
	0xff,		// 11111111
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000

	// ASCII 0xcb
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0xff,		// 11111111
	0x00,		// 00000000
	0xef,		// 11101111
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000

	// ASCII 0xcc
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x2f,		// 00101111
	0x20,		// 00100000
	0x2f,		// 00101111
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000

	// ASCII 0xcd
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0xff,		// 11111111
	0x00,		// 00000000
	0xff,		// 11111111
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000

	// ASCII 0xce
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0xef,		// 11101111
	0x00,		// 00000000
	0xef,		// 11101111
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000

	// ASCII 0xcf
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0xff,		// 11111111
	0x00,		// 00000000
	0xff,		// 11111111
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000

	// ASCII 0xd0
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0xff,		// 11111111
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000

	// ASCII 0xd1
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0xff,		// 11111111
	0x00,		// 00000000
	0xff,		// 11111111
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000

	// ASCII 0xd2
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0xff,		// 11111111
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000

	// ASCII 0xd3
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x3f,		// 00111111
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000

	// ASCII 0xd4
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x1f,		// 00011111
	0x10,		// 00010000
	0x1f,		// 00011111
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000

	// ASCII 0xd5
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x1f,		// 00011111
	0x10,		// 00010000
	0x1f,		// 00011111
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000

	// ASCII 0xd6
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x3f,		// 00111111
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000

	// ASCII 0xd7
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0xff,		// 11111111
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000
	0x28,		// 00101000

	// ASCII 0xd8
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0xff,		// 11111111
	0x10,		// 00010000
	0xff,		// 11111111
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000

	// ASCII 0xd9
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0xf0,		// 11110000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000

	// ASCII 0xda
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x00,		// 00000000
	0x1f,		// 00011111
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10,		// 00010000
	0x10		// 00010000
};

#endif // ndef FAILSAFE_BOOTER
