//+-------------------------------------------------------------------
//
//  File:	ballscf.cxx
//
//  Contents:	test class factory object implementation
//
//  Classes:	CBallClassFactory
//
//  Functions:
//
//  History:	23-Nov-92   Rickhi	Created
//
//--------------------------------------------------------------------

#include    <pch.cxx>
#pragma     hdrstop
#include    <ballscf.hxx>	//  class definiton
#include    <cballs.hxx>	//  CBalls defines


const GUID CLSID_Balls =
    {0x0000013a,0x0001,0x0008,{0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46}};



//+-------------------------------------------------------------------
//
//  Member:	CBallClassFactory::CBallClassFactory, public
//
//  Algorithm:
//
//  History:	23-Nov-92   Rickhi	Created
//
//--------------------------------------------------------------------

CBallClassFactory::CBallClassFactory(IUnknown *punkOuter) :
    _punkOuter(punkOuter)
{
    ENLIST_TRACKING(CBallClassFactory);
}


//+-------------------------------------------------------------------
//
//  Member:	CBallClassFactory::~CBallClassFactory, public
//
//  Algorithm:
//
//  History:	23-Nov-92	Rickhi	Created
//
//--------------------------------------------------------------------

CBallClassFactory::~CBallClassFactory(void)
{
    //	automatic actions do the rest of the work
}


//+-------------------------------------------------------------------
//
//  Member:	CBallClassFactory::QueryInterface, public
//
//  Algorithm:	if the interface is not one implemented by us,
//		pass the request to the proxy manager
//
//  History:	23-Nov-92	Rickhi	Created
//
//--------------------------------------------------------------------

STDMETHODIMP CBallClassFactory::QueryInterface(REFIID riid, void **ppUnk)
{
    SCODE sc = S_OK;

    if (IsEqualIID(riid, IID_IUnknown) ||
	IsEqualIID(riid, IID_IClassFactory))
    {
	*ppUnk = (void *)(IClassFactory *) this;
	AddRef();
    }
    else
    {
	if (_punkOuter)
	{
	    sc = _punkOuter->QueryInterface(riid, ppUnk);
	}
	else
	{
	    *ppUnk = NULL;
	    sc = E_NOINTERFACE;
	}
    }
    return  sc;
}



//+-------------------------------------------------------------------
//
//  Member:	CBallClassFactory::CreateInstance, public
//
//  Synopsis:	create a new object with the same class
//
//  History:	23-Nov-92   Rickhi	Created
//
//--------------------------------------------------------------------

STDMETHODIMP CBallClassFactory::CreateInstance(IUnknown *punkOuter,
					       REFIID	riid,
					       void	**ppunkObject)
{
    SCODE sc = E_OUTOFMEMORY;

    *ppunkObject = NULL;	//  in case of failure

    //	create a ball object.
    IUnknown *punk = (IUnknown *) new CBallCtrlUnk(punkOuter);

    if (punk)
    {
	//  get the interface the caller wants to use
	sc = punk->QueryInterface(riid, ppunkObject);

	//  release our hold on the ball, since the QI got a hold for
	//  the client.
	punk->Release();
    }

    return  sc;
}



//+-------------------------------------------------------------------
//
//  Member:	CBallClassFactory::LockServer, public
//
//  Synopsis:	create a new object with the same class
//
//  History:	23-Nov-92   Rickhi	Created
//
//--------------------------------------------------------------------

STDMETHODIMP CBallClassFactory::LockServer(BOOL fLock)
{
    if (fLock)
	GlobalRefs(TRUE);
    else
	GlobalRefs(FALSE);

    return  S_OK;
}
