/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 Copyright (c) 1989 Microsoft Corporation

 Module Name:
	
	ccb.hxx

 Abstract:

	Code generation control block.

 Notes:


 History:

 	Aug-15-1993		VibhasC		Created.

 ----------------------------------------------------------------------------*/
#ifndef __CCB_HXX__
#define __CCB_HXX__

#include "nodeskl.hxx"
#include "listhndl.hxx"

#include "stream.hxx"
#include "alstmc.hxx"
#include "resdict.hxx"
#include "dtable.hxx"
#include "frmtstr.hxx"
#include "treg.hxx"
#include "sdesc.hxx"
#include "paddict.hxx"

#include "ndrtypes.h"

#if defined(NTENV)
#define RPC_FAR_PTR  " *"
#else
#define RPC_FAR_PTR  " __RPC_FAR *"
#endif

class CG_NDR;
class CG_HANDLE;
class RESOURCE;
class _expr_node;
class CG_INTERFACE;
class CG_ENCODE_PROC;
class CG_QUALIFIED_POINTER;

//
// some typedefs for entities used within the code gen controller block.
//

typedef unsigned int	PROCNUM;
typedef unsigned long	RPC_FLAGS;

//
// This class is for managing context rundown and generic binding routine 
// indexes used in the Stub Descriptor structure.
//

#define MGR_INDEX_TABLE_SIZE    256

/////////////////////////////////////////////////////////////////////////////
// This definition specifies a context for a registered expr eval routines.
// For some reason I couldn't get it work in cgcommon.hxx (rkk)
/////////////////////////////////////////////////////////////////////////////

typedef struct _EXPR_EVAL_CONTEXT
{
    CG_NDR *        pContainer;
    _expr_node *    pMinExpr;
    _expr_node *    pSizeExpr;
    char *          pRoutineName;
	char *			pPrintPrefix;
    unsigned long   Displacement;
} EXPR_EVAL_CONTEXT;

typedef enum _TYPE_ENCODE_FLAGS
    {
     TYPE_ENCODE_FLAGS_NONE
    ,TYPE_ENCODE_WITH_IMPL_HANDLE
    } TYPE_ENCODE_FLAGS;

typedef struct _TYPE_ENCODE_INFO
    {
    PNAME               pName;
    TYPE_ENCODE_FLAGS   Flags;
    } TYPE_ENCODE_INFO;

typedef enum 
    {
    NDR_AL8 = 0,
    NDR_AL4,
    NDR_AL2_MOD2,
    NDR_AL2_MOD6,
    NDR_ALWC1,
    NDR_ALWC2,
    NDR_ALWC4
    } NDR_ALIGNMENT;

typedef enum
    {
    NDR_NONE = 0,
    NDR_ADD_1,
    NDR_ADD_2,
    NDR_ADD_4,
    NDR_ADD_6,
    NDR_ALIGN_2,
    NDR_ALIGN_4,
    NDR_ALIGN_8
    } NDR_ALIGN_ACTION;

typedef /* NDR_ALIGNMENT */     short NDR_ALIGNMENT_ARRAY[NDR_ALWC4+1];
typedef /* NDR_ALIGN_ACTION */  short NDR_ALIGN_ACTION_ARRAY[NDR_ALWC4+1];

class CCB_RTN_INDEX_MGR
{
private:
	char *		NameId[ MGR_INDEX_TABLE_SIZE ];
	long		NextIndex;

public:

						CCB_RTN_INDEX_MGR()
							{
							//
							// The zeroth entry is reserved or invalid.
							//
							NameId[0] = NULL;
							NextIndex = 1;
							}

	long				Lookup( char * pName );
	char *				Lookup( long Index );

    long                GetIndex()  { return NextIndex; }

	BOOL				IsEmpty()	{ return NextIndex == 1; }
};

/////////////////////////////////////////////////////////////////////////////
//
// This class is a captive class for the code generation controller block.
// Stores running expression stuff for inline stubs.
//
/////////////////////////////////////////////////////////////////////////////

class CCB_EXPRINFO
	{
private:

	_expr_node			*	pSrcExpr;
	_expr_node			*	pDestExpr;

public:

	
	//
	// The constructor.
	//

							CCB_EXPRINFO()
								{
								SetSrcExpression( 0 );
								SetDestExpression( 0 );
								}
	//
	// Get and set methods.
	//
	
	_expr_node			*	SetSrcExpression( _expr_node * pSrc )
								{
								return (pSrcExpr = pSrc);
								}

	_expr_node			*	GetSrcExpression()
								{
								return pSrcExpr;
								}

	_expr_node			*	SetDestExpression( _expr_node * pDest )
								{
								return (pDestExpr = pDest);
								}

	_expr_node			*	GetDestExpression()
								{
								return pDestExpr;
								}
	};
	
/////////////////////////////////////////////////////////////////////////////
//
// This class defines the code generation control block.
//
/////////////////////////////////////////////////////////////////////////////

class CCB
	{
private:

	// Is pointee to be deferred in code generation.

	unsigned long		fDeferPointee	: 1;

	// Has At least one deferred pointee.

	unsigned long		fAtLeastOneDeferredPointee	: 1;

	// This flag indicates memory allocated for the entity being
	// marshalled / unmarshalled.

	unsigned long		fMemoryAllocDone: 1;

	// This flag indicates a reference allocated.

	unsigned long		fRefAllocDone	: 1;

	// This flag indicates a return context

	unsigned long		fReturnContext	: 1;

	// Are we in a callback proc?
	unsigned long		fInCallback 	: 1;

	// Generate a call thru the epv only. Corresponds to the -use_epv
	// on midl command line.

	unsigned long	fMEpV			: 1;

	unsigned long	fNoDefaultEpv	: 1;

	// Generate MIDL 1.0 style names. No mangling.

	unsigned long	fOldNames		: 1;

	// this flag indicates the current mode - 0 for osf, 1 for ms_ext.
	
	unsigned long		Mode		: 2;

	unsigned long		fRpcSSSwitchSet	: 1;

	unsigned long		fMustCheckAllocationError : 1;

    unsigned long       fMustCheckEnum      : 1;

    unsigned long       fMustCheckRef       : 1;

    unsigned long       fMustCheckBounds    : 1;
    
    unsigned long       fMustCheckStubData  : 1;

	unsigned long		fInObjectInterface : 1;

    unsigned long       fInterpretedRoutinesUseGenHandle : 1;

    unsigned long       fExprEvalExternEmitted : 1;
    unsigned long       fQuintupleExternEmitted : 1;
    unsigned long       fRundownExternEmitted : 1;
    unsigned long       fGenericHExternEmitted : 1;

    unsigned long       fSkipFormatStreamGeneration : 1;

	//
	// stream to write the generated code into.
	//

	ISTREAM			*	pStream;

	//
	// optimization options in effect.
	//

	OPTIM_OPTION		OptimOption;

	//
	// Store the current CG_INTERFACE node
	//

	CG_INTERFACE *		pInterfaceCG;

	//
	// Store the interface name.
	//

	PNAME				pInterfaceName;


	//
	// store the interface version.
	//

	unsigned short		MajorVersion;
	unsigned short		MinorVersion;

	//
	// The current procedure number is stored to emit the descriptor structure.
	//

	PROCNUM				CurrentProcNum;


	//
	// Store rpc flags. As of now, this field assumes a value only when
	// datagram specific attributes are applied. Otherwise it is 0. Keep
	// the type of this the same as in the actual rpc_message field.
	//

	RPC_FLAGS			RpcFlags;


	//
	// Keep the default allocation and free routine names. These may
	// be overriden by the parameters / types or procedures depending
	// upon user specifications. Any code generation node which overrides
	// the default names, is responsible for restoring it back.
	// The default allocation routine is midl_user_allocate and the default
	// free is MIDL_user_free for now.
	//

	PNAME				pAllocRtnName;
	PNAME				pFreeRtnName;

	//
	// This is set of names of internal rpc api that we need to call to
	// perform our job. We store these names in order to make it easy to
	// call a different api set if necessary, as long as the stub-runtime
	// call paradigm stays the same.
	//

	PNAME				pGetBufferRtnName;
	PNAME				pSendReceiveRtnName;
	PNAME				pFreeBufferRtnName;


	//
	// The code generation controller block also needs to keep an alignment
	// state machine for the actual code generator to use to keep the running
	// alignment.
	//

	ALSTMC				Al;

	//
	// This field stores the current resource dictionary data base. The
	// data base is NOT owned by this class and must NOT be deleted by this
	// class either.
	//

	RESOURCE_DICT_DATABASE * pResDictDatabase;

	//
	// The standard stub descriptor resource available for use by both the
	// client and server stub.
	//

	RESOURCE			*	pStubDescResource;

	//
	// This field is a class keeping the current expressions to be used during
	// generation pass.
	//

	CCB_EXPRINFO		ExprInfo;


	//
	// These registries represent various types that get registered during
	// code generation, for the purpose of generating the prototypes during
	// header generation.

	TREGISTRY		*	pGenericHandleRegistry;
	TREGISTRY		*	pContextHandleRegistry;

    TREGISTRY       *   pPresentedTypeRegistry;
	TREGISTRY		*	pRepAsWireTypeRegistry;
    TREGISTRY       *   pQuintupleRegistry;

    TREGISTRY       *   pExprEvalRoutineRegistry;

	TREGISTRY		*	pSizingRoutineRegistry;
	TREGISTRY		*	pMarshallRoutineRegistry;
	TREGISTRY		*	pUnMarshallRoutineRegistry;
	TREGISTRY		*	pMemorySizingRoutineRegistry;
	TREGISTRY		*	pFreeRoutineRegistry;
	TREGISTRY       *   pTypeAlignSizeRegistry;
	TREGISTRY       *   pTypeEncodeRegistry;
	TREGISTRY       *   pTypeDecodeRegistry;
	TREGISTRY       *   pProcEncodeDecodeRegistry;
	TREGISTRY		*	pCallAsRoutineRegistry;
	TREGISTRY       *   pNotifyRoutineRegistry;

	// This stores the interface wide implicit handle ID Node.

	node_skl		*	pImplicitHandleIDNode;

	//
	// Current code generation phase.
	//
	CGPHASE				CodeGenPhase;

	//
	// Current code generation side (client/server).
	//
	CGSIDE				CodeGenSide;

	//
	// The type format string.  Shared across mulitple interfaces and identical
	// for client and server.
	//
	FORMAT_STRING *		pFormatString;

	//
	// The proc/param format string.  Used only for fully interpreted stubs.
	//
	FORMAT_STRING *		pProcFormatString;

	// The current embedding context. We increment this to indicate if we are
	// in a top level or embedded context.

	short					EmbeddingLevel;

	// This indicates the ptr indirection level. Each pointer must note its
	// indirection level and then bump this field to indicate to the next
	// pointer its (that pointer's) level.

	short					IndirectionLevel;

	//
	// This field is set by CG_PROC and all procedure CG classes.  It is
	// then used by the array classes when computing their conformance and/or
	// variance descriptions for the new Ndr format strings.
	// 
	CG_NDR *				pCGNodeContext;

	//
	// Param/Field placeholder.
	//
	CG_NDR *				pPlaceholderClass;

	// The stub descriptor structure.

	SDESCMGR				SSDescMgr;

	SDESCMGR				CSDescMgr;

	// Keep track of next wire alignment.

	ALIGNMENT_PROPERTY		NextWireAlignment;

    //
    // New alignment stuff (5-12-94).  Not related to NextWireAlignment, 
    // which was originally going to be used by completely inlined stubs.
    //
    NDR_ALIGNMENT           NdrAlignment;

	RESOURCE		*		PtrToPtrInBuffer;

	//
	// Generic Binding and Context Rundown routine index managers.
	//
	CCB_RTN_INDEX_MGR *		pGenericIndexMgr;
	CCB_RTN_INDEX_MGR *		pContextIndexMgr;

	//
	// Expression evaluation routine index manager.
	//
	CCB_RTN_INDEX_MGR *		pExprEvalIndexMgr;

	//
	// Transmited As routine index manager.
	//
	CCB_RTN_INDEX_MGR *		pTransmitAsIndexMgr;     // prototypes
	CCB_RTN_INDEX_MGR *		pRepAsIndexMgr;          // prototypes

    QuintupleDict *         pQuintupleDictionary;    // routines

    //
    // Dictionary kept for unknown represent as types to do padding
    // and sizing macros.
    //
    RepAsPadExprDict *      pRepAsPadExprDictionary;
    RepAsSizeDict *         pRepAsSizeDictionary;

	// Keep the current prefix to generate the proper code for
	// embedded stuff.

	char		*		pPrefix;

	//
	// These keeps track of the total memory and buffer size of all currently 
	// imbeding structures.  For NDR format string generation, a struct or 
	// array node will check this field when generating it's pointer layout 
	// field so it knows how much to add to its offset fields.
	//
	long					ImbedingMemSize;
	long					ImbedingBufSize;

    CG_QUALIFIED_POINTER *  pCurrentSizePointer;

public:

	//
	// The constructors.
	//

						CCB( PNAME			pGBRtnName,
							 PNAME			pSRRtnName,
							 PNAME			pFBRtnName,
							 OPTIM_OPTION	OptimOption,
							 BOOL			fManagerEpvFlag,
							 BOOL			fNoDefaultEpv,
							 BOOL			fOldNames,
							 unsigned long	Mode,
							 BOOL			fRpcSSSwitchSetInCompiler,
							 BOOL			fMustCheckAllocError,
							 BOOL           fMustCheckRefPtrs,
							 BOOL           fMustCheckEnumValues,
							 BOOL           fMustCheckBoundValues,
							 BOOL           fCheckStubData
							 );

	void                    SetInterpretedRoutinesUseGenHandle()
	                            {
	                            fInterpretedRoutinesUseGenHandle = 1;
	                            }

	BOOL                    GetInterpretedRoutinesUseGenHandle()
	                            {
	                            return (BOOL)(fInterpretedRoutinesUseGenHandle == 1);
	                            }

	BOOL                    GetExprEvalExternEmitted()
	                            {
	                            return (BOOL)(fExprEvalExternEmitted == 1);
	                            }

	void                    SetExprEvalExternEmitted()
	                            {
	                            fExprEvalExternEmitted = 1;
	                            }

	BOOL                    GetQuintupleExternEmitted()
	                            {
	                            return (BOOL)(fQuintupleExternEmitted == 1);
	                            }

	void                    SetQuintupleExternEmitted()
	                            {
	                            fQuintupleExternEmitted = 1;
	                            }

	BOOL                    GetRundownExternEmitted()
	                            {
	                            return (BOOL)(fRundownExternEmitted == 1);
	                            }

	void                    SetRundownExternEmitted()
	                            {
	                            fRundownExternEmitted = 1;
	                            }

	BOOL                    GetGenericHExternEmitted()
	                            {
	                            return (BOOL)(fGenericHExternEmitted == 1);
	                            }

	void                    SetGenericHExternEmitted()
	                            {
	                            fGenericHExternEmitted = 1;
	                            }

	void                    ClearOptionalExternFlags()
	                            {
	                            fExprEvalExternEmitted = 0;
	                            fQuintupleExternEmitted = 0;
	                            fRundownExternEmitted = 0;
	                            fGenericHExternEmitted = 0;
	                            }

	BOOL                    GetSkipFormatStreamGeneration()
	                            {
	                            return (BOOL)(fSkipFormatStreamGeneration == 1);
	                            }

	void                    SetSkipFormatStreamGeneration( BOOL Has )
	                            {
	                            fSkipFormatStreamGeneration = Has ? 1 : 0;
	                            }

    void					SetMustCheckAllocationError( BOOL f )
								{
								fMustCheckAllocationError = f;
								}

	BOOL					MustCheckAllocationError()
								{
								return (BOOL)(fMustCheckAllocationError == 1);
								}

	void					SetMustCheckRef( BOOL f )
								{
								fMustCheckRef = f;
								}

	BOOL					MustCheckRef()
								{
								return (BOOL)(fMustCheckRef == 1);
								}

	void					SetMustCheckEnum( BOOL f )
								{
								fMustCheckEnum = f;
								}

	BOOL					MustCheckEnum()
								{
								return (BOOL)(fMustCheckEnum == 1);
								}

	void					SetMustCheckBounds( BOOL f )
								{
								fMustCheckBounds = f;
								}

	BOOL					MustCheckBounds()
								{
								return (BOOL)(fMustCheckBounds == 1);
								}


	SDESC			*		SetSStubDescriptor( PNAME AllocRtnName,
											   PNAME FreeRtnName,
											   PNAME RundownRtnName )
								{
								return SSDescMgr.Register( AllocRtnName,
												   		  FreeRtnName,
												   		  RundownRtnName );
								}

	SDESC			*		SetCStubDescriptor( PNAME AllocRtnName,
											   PNAME FreeRtnName,
											   PNAME RundownRtnName )
								{
								return CSDescMgr.Register( AllocRtnName,
												   		  FreeRtnName,
												   		  RundownRtnName );
								}
	//
	// Get and set of members.
	//

	void                SetMustCheckStubData( BOOL f )
	                        {
	                        fMustCheckStubData = f;
	                        }

    BOOL                IsMustCheckStubDataSpecified()
                            {
                            return (BOOL) fMustCheckStubData;
                            }

	void				SetRpcSSSwitchSet( BOOL f)
							{
							fRpcSSSwitchSet = f;
							}

	BOOL				IsRpcSSSwitchSet()
							{
							return fRpcSSSwitchSet;
							}

	void				SetMode( unsigned long M )
							{
							Mode = M;
							}

	unsigned long		GetMode()
							{
							return Mode;
							}

	void				SetOldNames( unsigned long Flag )
							{
							fOldNames = Flag;
							} 

	BOOL				IsOldNames()
							{
							return (BOOL)( fOldNames == 1 );
							}

	BOOL				IsMEpV()
							{
							return (BOOL)( fMEpV == 1 );
							}

	BOOL				IsNoDefaultEpv()
							{
							return (BOOL)( fNoDefaultEpv == 1 );
							}

	char			*	SetPrefix( char * pP )
								{
								return (pPrefix = pP);
								}
	char			*	GetPrefix()
								{
								return pPrefix;
								}
	unsigned long			SetReturnContext()
								{
								return (fReturnContext = 1);
								}
	unsigned long			ResetReturnContext()
								{
								return (fReturnContext = 0);
								}

	BOOL					IsReturnContext()
								{
								return (fReturnContext == 1);
								}

	ALIGNMENT_PROPERTY		SetCurAlignmentState( ALIGNMENT_PROPERTY A )
								{
								return Al.SetCurrentState( A );
								}

	ALIGNMENT_PROPERTY		GetCurAlignmentState()
								{
								return Al.GetCurrentState();
								}

	ALIGNMENT_PROPERTY		SetNextWireAlignment( ALIGNMENT_PROPERTY A )
								{
								return (NextWireAlignment = A);
								}

	ALIGNMENT_PROPERTY		GetNextWireAlignment()
								{
								return NextWireAlignment;
								}

    //
    // New alignment stuff (5-12-94).  Not related to the above alignment
    // methods.
    //
    void                    SetNdrAlignment( NDR_ALIGNMENT Align )
                                {
                                NdrAlignment = Align;
                                }

    NDR_ALIGNMENT           GetNdrAlignment()
                                {
                                return NdrAlignment;
                                }

    //
    // Called by every ndr entity before it is (un)marshalled to set the 
    // NdrAlignment correctly.  Returns an action which must be performed
    // before (un)marshalling - an addition, alignment, or nothing.  Most ndr 
    // entities ignore the return since their (un)marshalling is handled by 
    // the engine.
    //
    NDR_ALIGN_ACTION        NdrAlignmentAction( ALIGNMENT_PROPERTY AlignProp );

    //
    // This method is used to set the next alignment state given the wire
    // size of the current ndr entity.  
    //
    void                    SetNextNdrAlignment( long WireSize );

    void                    SetCurrentSizePointer( CG_QUALIFIED_POINTER * pPtr )
                                {
                                pCurrentSizePointer = pPtr;
                                }

    CG_QUALIFIED_POINTER *  GetCurrentSizePointer()
                                {
                                return pCurrentSizePointer;
                                }

	void					SetMemoryAllocDone()
								{
								fMemoryAllocDone = 1;
								}

	void					ResetMemoryAllocDone()
								{
								fMemoryAllocDone = 0;
								}

	void					SetRefAllocDone()
								{
								fRefAllocDone = 1;
								}

	void					ResetRefAllocDone()
								{
								fRefAllocDone = 0;
								}
	
	BOOL					IsMemoryAllocDone()
								{
								return (BOOL)(fMemoryAllocDone == 1);
								}

	BOOL					IsRefAllocDone()
								{
								return (fRefAllocDone == 1);
								}

	unsigned long			SetHasAtLeastOneDeferredPointee()
								{
								return (fAtLeastOneDeferredPointee = 1);
								}

	unsigned long			ResetHasAtLeastOneDeferredPointee()
								{
								return (fAtLeastOneDeferredPointee = 0);
								}

	BOOL					HasAtLeastOneDeferredPointee()
								{
								return (fAtLeastOneDeferredPointee == 1);
								}

	unsigned long			SetDeferPointee()
								{
								return (fDeferPointee = 1);
								}

	unsigned long			ResetDeferPointee()
								{
								return (fDeferPointee = 0);
								}

	BOOL					IsPointeeDeferred()
								{
								return (fDeferPointee == 1);
								}

	void 					ClearInCallback()
								{
								fInCallback = 0;
								}

	void 					SetInCallback()
								{
								fInCallback = 1;
								}

	BOOL					IsInCallback()
								{
								return (fInCallback == 1);
								}

	node_skl		*		SetImplicitHandleIDNode( node_skl * pID )
								{
								return (pImplicitHandleIDNode = pID);
								}

	node_skl		*		GetImplicitHandleIDNode()
								{
								return pImplicitHandleIDNode;
								}

	BOOL					IsInObjectInterface()
								{
								return fInObjectInterface;
								}

	void					SetInObjectInterface( BOOL fInObj )
								{
								fInObjectInterface = fInObj;
								}

	short					ResetEmbeddingLevel()
								{
								return (EmbeddingLevel = 0);
								}

	// bumps up embedding level, but returns the old one.

	short					PushEmbeddingLevel()
								{
								return EmbeddingLevel++;
								}

	// pops embedding level but returns the current one.
	
	short					PopEmbeddingLevel()
								{
								if( EmbeddingLevel > 0 )
									return EmbeddingLevel--;
								else
									return EmbeddingLevel;
								}

	short					GetCurrentEmbeddingLevel()
								{
								return EmbeddingLevel;
								}

	short					SetCurrentEmbeddingLevel( short E)
								{
								return (EmbeddingLevel = E);
								}

	short					ResetIndirectionLevel()
								{
								return (IndirectionLevel = 0);
								}

	// This pushes the indirection level, but returns the current one.

	short					PushIndirectionLevel()
								{
								return IndirectionLevel++;
								}

	// This pops the indirection Level but returns the current one.

	short					PopIndirectionLevel()
								{
								if( IndirectionLevel > 0 )
									return IndirectionLevel--;
								else
									return IndirectionLevel;
								}

	short					GetCurrentIndirectionLevel()
								{
								return IndirectionLevel;
								}


	ISTREAM			*	GetStream()
							{
							return pStream;
							}

	ISTREAM			*	SetStream( ISTREAM * S )
							{
							return (pStream = S);
							}

	void				SetVersion( unsigned short Major,
									unsigned short Minor
								  )
							{
							MajorVersion = Major;
							MinorVersion = Minor;
							}

	void				GetVersion( unsigned short * pMaj,
									unsigned short * pMin
								  )
							{
							if( pMaj ) *pMaj = MajorVersion;
							if( pMin ) *pMin = MinorVersion;
							}

	CG_INTERFACE *		SetInterfaceCG( CG_INTERFACE *pCG )
							{
							return (pInterfaceCG = pCG);
							}

	CG_INTERFACE *		GetInterfaceCG()
							{
							return pInterfaceCG;
							}

	PNAME				SetInterfaceName( PNAME pIN )
							{
							return (pInterfaceName = pIN);
							}

	PNAME				GetInterfaceName()
							{
							return pInterfaceName;
							}

	OPTIM_OPTION		SetOptimOption( OPTIM_OPTION OpO )
							{
							return (OptimOption = OpO);
							}

	OPTIM_OPTION		GetOptimOption() 
							{
							return OptimOption;
							}

	PROCNUM				SetProcNum( unsigned short n )
							{
							return (CurrentProcNum = n);
							}

	PROCNUM				GetProcNum()
							{
							return CurrentProcNum;
							}

	RPC_FLAGS			SetRpcFlags( RPC_FLAGS F )
							{
							return (RpcFlags = F);
							}

	RPC_FLAGS			GetRpcFlags()
							{
							return RpcFlags;
							}

	void				SetAllocFreeRtnNamePair(
							PNAME	pAllocN,
							PNAME	pFreeN )
							{
							pAllocRtnName = pAllocN;
							pFreeRtnName  = pFreeN;
							}

	PNAME				GetAllocRtnName()
							{
							return pAllocRtnName;
							}

	PNAME				GetFreeRtnName()
							{
							return pFreeRtnName;
							}

	long				LookupRundownRoutine( char * pName )
							{
							long		RetCode;
							
							if ( ! strcmp(pName,"") )
								RetCode = INVALID_RUNDOWN_ROUTINE_INDEX;
							else
								RetCode = pContextIndexMgr->Lookup( pName );

							return RetCode;
							}

	BOOL				HasRundownRoutines()
                            {
                        	return ! pContextIndexMgr->IsEmpty();
                            }

    BOOL                HasExprEvalRoutines()
                            {
                        	return ! pExprEvalIndexMgr->IsEmpty();
                            }

    BOOL                HasQuintupleRoutines()
                            {
                        	return GetQuintupleDictionary()->GetCount() != 0;
                            }

	void				OutputRundownRoutineTable();

    void                OutputExprEvalRoutineTable();
    void                OutputRegisteredExprEvalRoutines();

    void                OutputQuintupleTable();
    void                OutputTransmitAsQuintuple( void * pQContext );
    void                OutputRepAsQuintuple( void * pQContext );
    void                OutputQuintupleRoutines();

	void				OutputSimpleRoutineTable( CCB_RTN_INDEX_MGR * pIndexMgr,
                                                  char * TypeName,
                                                  char * VarName );

    void                OutputExternsToMultipleInterfaceTables();
    void                OutputMultipleInterfaceTables();

    CCB_RTN_INDEX_MGR * GetExprEvalIndexMgr()
                            {
                            return pExprEvalIndexMgr;
                            }

    CCB_RTN_INDEX_MGR * GetTransmitAsIndexMgr()
                            {
                            return pTransmitAsIndexMgr;
                            }
    CCB_RTN_INDEX_MGR * GetRepAsIndexMgr()
                            {
                            return pRepAsIndexMgr;
                            }

	long				LookupBindingRoutine( char * pName )
							{
							return pGenericIndexMgr->Lookup( pName );
							}

	void				OutputBindingRoutines();

	BOOL				HasBindingRoutines( CG_HANDLE * pImplicitHandle );

	RESOURCE_DICT_DATABASE * SetResDictDatabase( RESOURCE_DICT_DATABASE * p )
							{
							return ( pResDictDatabase = p );
							}

	RESOURCE_DICT_DATABASE * GetResDictDatabase()
							{
							return pResDictDatabase;
							}

	void				GetListOfLocalResources( ITERATOR& Iter )
							{
							GetResDictDatabase()->
								GetLocalResourceDict()->
									GetListOfResources( Iter );
							}

	void				GetListOfParamResources( ITERATOR& Iter )
							{
							GetResDictDatabase()->
								GetParamResourceDict()->
									GetListOfResources( Iter );
							}

	void				GetListOfTransientResources( ITERATOR& Iter )
							{
							GetResDictDatabase()->
								GetTransientResourceDict()->
									GetListOfResources( Iter );
							}

	RESOURCE	*		GetParamResource( PNAME p )
							{
							return GetResDictDatabase()->
									 GetParamResourceDict()->Search( p );
							}

	RESOURCE	*		GetLocalResource( PNAME p )
							{
							return GetResDictDatabase()->
									 GetLocalResourceDict()->Search( p );
							}

	RESOURCE			*	GetTransientResource( PNAME pResName )
								{
								return 
									   pResDictDatabase->
									   	GetTransientResourceDict()->Search(
															 pResName );
								}

	RESOURCE	*		GetGlobalResource( PNAME p )
							{
							return GetResDictDatabase()->
									 GetLocalResourceDict()->Search( p );
							}

	RESOURCE	*		AddParamResource( PNAME p, node_skl *pT )
							{
							return DoAddResource(
								 	GetResDictDatabase()->
									 GetParamResourceDict(), p, pT );
							}

	RESOURCE	*		AddTransientResource( PNAME p, node_skl *pT )
							{
							return DoAddResource(
								 	GetResDictDatabase()->
									 GetTransientResourceDict(), p, pT );
							}

	void				ClearTransientResourceDict()
							{
							pResDictDatabase->
							  GetTransientResourceDict()->Clear();
							}

	void				ClearParamResourceDict()
							{
							pResDictDatabase->
							  GetParamResourceDict()->Clear();
							}

	RESOURCE			*	DoAddResource( RESOURCE_DICT * pResDict,
										   PNAME		   pName,
										   node_skl		 * pType 
										 );
	//
	// Get one of the standard resources.
	//

	RESOURCE		*	GetStandardResource( STANDARD_RES_ID ResID );


	//
	// This routine sets the names of the stub runtime interface routines.
	// This routine can take any parameter which is 0, and will not overwrite 
	// the runtime routine name for that functionality, allowing the caller to
	// selectively change the runtime routine for a functionality easily.
	// 

	void				SetRuntimeRtnNames(
										PNAME pGBRtnName,
										PNAME pSRRtnName,
										PNAME pFBRtnName )
							{
							if( pGBRtnName ) pGetBufferRtnName = pGBRtnName;
							if( pSRRtnName ) pSendReceiveRtnName = pSRRtnName;
							if( pFBRtnName ) pFreeBufferRtnName = pFBRtnName;
							}

	PNAME				GetGetBufferRtnName()
							{
							return pGetBufferRtnName;
							}

	PNAME				GetSendReceiveRtnName()
							{
							return pSendReceiveRtnName;
							}

	PNAME				GetFreeBufferRtnName()
							{
							return pFreeBufferRtnName;
							}

	_expr_node		*	SetSourceExpression( _expr_node * pSrcExpr )
							{
							return (ExprInfo.SetSrcExpression( pSrcExpr ) );
							}

	_expr_node		*	GetSourceExpression()
							{
							return ExprInfo.GetSrcExpression();
							}

	_expr_node		*	SetDestExpression( _expr_node * pDestExpr )
							{
							return (ExprInfo.SetDestExpression( pDestExpr ) );
							}

	_expr_node		*	GetDestExpression()
							{
							return ExprInfo.GetDestExpression();
							}

	node_skl		*	RegisterGenericHandleType( node_skl * pType )
							{
							return pGenericHandleRegistry->Register( pType );
							}

	node_skl		*	RegisterContextHandleType( node_skl * pType )
							{
							return pContextHandleRegistry->Register( pType );
							}

	node_skl		*	RegisterRepAsWireType( node_skl * pType )
							{
							return pRepAsWireTypeRegistry->Register( pType );
							}
	
	node_skl		*	RegisterPresentedType( node_skl * pType )
							{
							return pPresentedTypeRegistry->Register( pType );
							}
	
	node_skl		*	RegisterExprEvalRoutine( node_skl * pType )
							{
							return pExprEvalRoutineRegistry->Register( pType );
							}

    node_skl        *   RegisterQuintuple( void * pContext )
                            {
                            return pQuintupleRegistry->Register( (node_skl *)pContext );
                            }

    QuintupleDict *     GetQuintupleDictionary()
                            {
                            return pQuintupleDictionary;
                            }

    RepAsPadExprDict *  GetRepAsPadExprDict()
                            {
                            return pRepAsPadExprDictionary;
                            }

    RepAsSizeDict *     GetRepAsSizeDict()
                            {
                            return pRepAsSizeDictionary;
                            }

	node_skl		*	RegisterSizingRoutineForType( node_skl * pType )
							{
							return pSizingRoutineRegistry->Register( pType );
							}
	
	node_skl		*	RegisterMarshallRoutineForType( node_skl * pType )
							{
							return pMarshallRoutineRegistry->Register( pType );
							}
	
	node_skl		*	RegisterUnMarshallRoutineForType( node_skl * pType )
							{
							return pUnMarshallRoutineRegistry->Register( pType );
							}
	
	node_skl		*	RegisterMemorySizingRoutineForType( node_skl * pType )
							{
							return pMemorySizingRoutineRegistry->Register( pType );
							}
	
	node_skl		*	RegisterFreeRoutineForType( node_skl * pType )
							{
							return pFreeRoutineRegistry->Register( pType );
							}

    node_skl    *       RegisterTypeAlignSize( TYPE_ENCODE_INFO * pTEInfo )
                            {
                            // cheat by casting.
                            return pTypeAlignSizeRegistry->Register(
                                                (node_skl *) pTEInfo );
                            }

    node_skl    *       RegisterTypeEncode( TYPE_ENCODE_INFO * pTEInfo )
                            {
                            // cheat by casting.
                            return pTypeEncodeRegistry->Register(
                                                (node_skl *) pTEInfo );
                            }

    node_skl    *       RegisterTypeDecode( TYPE_ENCODE_INFO * pTEInfo )
                            {
                            return pTypeDecodeRegistry->Register(
                                                (node_skl *) pTEInfo );
                            }

	node_skl    *       RegisterEncodeDecodeProc( CG_ENCODE_PROC * pProc )
	                        {
	                        return pProcEncodeDecodeRegistry->Register( 
	                                                        (node_skl *)pProc );
	                        }
	
    node_skl    *       RegisterCallAsRoutine( node_proc * pProc )
                            {
                            return pCallAsRoutineRegistry->Register( pProc );
                            }

    node_skl    *       RegisterNotifyRoutine( node_proc * pProc )
                            {
                            return pNotifyRoutineRegistry->Register( pProc );
                            }

	short				GetListOfGenHdlTypes( ITERATOR& I )
							{
							return pGenericHandleRegistry->GetListOfTypes( I );
							}
	
	short				GetListOfCtxtHdlTypes( ITERATOR& I )
							{
							return pContextHandleRegistry->GetListOfTypes( I );
							}

	short				GetListOfRepAsWireTypes( ITERATOR& I )
							{
							return pRepAsWireTypeRegistry->GetListOfTypes( I );
							}

	short				GetListOfPresentedTypes( ITERATOR& I )
							{
							return pPresentedTypeRegistry->GetListOfTypes( I );
							}
	
	short				GetListOfExprEvalRoutines( ITERATOR& I )
							{
							return pExprEvalRoutineRegistry->GetListOfTypes( I );
							}

    short               GetListOfQuintuples( ITERATOR& I )
                            {
                            return pQuintupleRegistry->GetListOfTypes( I );
                            }

	short				GetListOfSizingRoutineTypes( ITERATOR& I )
							{
							return pSizingRoutineRegistry->GetListOfTypes( I );
							}

	short				GetListOfMarshallingRoutineTypes( ITERATOR& I )
							{
							return pMarshallRoutineRegistry->GetListOfTypes( I );
							}

	short				GetListOfUnMarshallingRoutineTypes( ITERATOR& I )
							{
							return pUnMarshallRoutineRegistry->GetListOfTypes( I );
							}

	short				GetListOfMemorySizingRoutineTypes( ITERATOR& I )
							{
							return pMemorySizingRoutineRegistry->GetListOfTypes( I );
							}

	short				GetListOfFreeRoutineTypes( ITERATOR& I )
							{
							return pFreeRoutineRegistry->GetListOfTypes( I );
							}

    short               GetListOfTypeAlignSizeTypes( ITERATOR&  I )
                            {
							return pTypeAlignSizeRegistry->GetListOfTypes( I );
                            }

    short               GetListOfTypeEncodeTypes( ITERATOR&  I )
                            {
							return pTypeEncodeRegistry->GetListOfTypes( I );
                            }

    short               GetListOfTypeDecodeTypes( ITERATOR&  I )
                            {
							return pTypeDecodeRegistry->GetListOfTypes( I );
                            }
    short               GetListOfEncodeDecodeProcs( ITERATOR& I )
                            {
							return pProcEncodeDecodeRegistry->GetListOfTypes(I);
                            }

    short               GetListOfCallAsRoutines( ITERATOR&  I )
                            {
							return pCallAsRoutineRegistry->GetListOfTypes( I );
                            }

    short               GetListOfNotifyRoutines( ITERATOR&  I )
                            {
							return pNotifyRoutineRegistry->GetListOfTypes( I );
                            }


	//
	// miscellaneous methods.
	//

	void				InitForNewProc(
							PROCNUM			PNum,
							RPC_FLAGS		Flags,
							PNAME			pAllocN,
							PNAME			pFreeN,
							RESOURCE_DICT_DATABASE * pRDDB )
							{
							SetProcNum( PNum );
							SetRpcFlags( Flags );
							SetAllocFreeRtnNamePair( pAllocN, pFreeN );
							SetResDictDatabase( pRDDB );
							ResetAlStMc();
							}

	//
	// Alignment state machine related stuff.
	//

	void				ResetAlStMc()
							{
							Al.SetCurrentState( AL_8 );
							}


	//
	// Given the current and next expected alignment, advance the state 
	// machine and return the action, the buffer size property, and the
	// increment to the buffer.
	//

	ALIGNMENT_PROPERTY		Advance( ALIGNMENT_PROPERTY			A,
									 STM_ACTION				*	pAction,
									 RPC_BUF_SIZE_PROPERTY	*	pBSP,
									 RPC_BUFFER_SIZE		*	pIncr )
								{
								return Al.Advance( A, pAction, pBSP, pIncr );
								}

	//
	// Do exactly what the Advance method did, except change the state of the
	// machine. In other words, predict what would happen if I were to advance.
	//

	ALIGNMENT_PROPERTY		Predict( ALIGNMENT_PROPERTY			A,
									 STM_ACTION				*	pAction,
									 RPC_BUF_SIZE_PROPERTY	*	pBSP,
									 RPC_BUFFER_SIZE		*	pIncr )
								{
								return Al.Predict( A,pAction,pBSP,pIncr);
								}

	//
	// Just position the machine to the next expected alignment. And tell me
	// what I have to do to get to that position.
	//

	RPC_BUFFER_SIZE			Position( ALIGNMENT_PROPERTY	NextAlignment,
									  STM_ACTION		 *	pAction )
								{
								return Al.Position( NextAlignment, pAction );
								}
	//
	// This method generates a mangled name out of the interface and
	// version number. The user provided string is appended to the
	// mangled part. The memory area is allocated by this routine using
	// new, but freed by the caller.
	//

	char			*	GenMangledName();


	//
	// set stub descriptor resource.
	//

	RESOURCE		*	SetStubDescResource();


	RESOURCE		*	GetStubDescResource()
							{
							return pStubDescResource;
							}

	//
	// Set and get the format string.
	//

	void 				SetFormatString( FORMAT_STRING * pFS )
							{
							pFormatString = pFS;
							}

	FORMAT_STRING	*	GetFormatString()
							{
							return pFormatString;
							}

	void 				SetProcFormatString( FORMAT_STRING * pFS )
							{
							pProcFormatString = pFS;
							}

	FORMAT_STRING	*	GetProcFormatString()
							{
							return pProcFormatString;
							}

	//
	// Set and get the code generation phase.
	//
	
	void 				SetCodeGenPhase( CGPHASE phase )
							{
							CodeGenPhase = phase;
							}

	CGPHASE				GetCodeGenPhase()
							{
							return CodeGenPhase;
							}

	//
	// Set and get the code generation side.
	//
	
	void 				SetCodeGenSide( CGSIDE side )
							{
							CodeGenSide = side;
							}

	CGSIDE				GetCodeGenSide()
							{
							return CodeGenSide;
							}

	//
	// Set and Get current code generation node context.
	//
	CG_NDR *			SetCGNodeContext( CG_NDR * pNewCGNodeContext )
							{
							CG_NDR *	pOldCGNodeContext;

							pOldCGNodeContext = pCGNodeContext;
							pCGNodeContext = pNewCGNodeContext;

							return pOldCGNodeContext;
							}

	CG_NDR *			GetCGNodeContext()
							{
							return pCGNodeContext;
							}

	//
	// Set and Get current placeholder class.
	//
	CG_NDR *			SetLastPlaceholderClass( CG_NDR * pNew )
							{
							CG_NDR *	pOld;

							pOld = pPlaceholderClass;
							pPlaceholderClass = pNew;

							return pOld;
							}

	CG_NDR *			GetLastPlaceholderClass()
							{
							return pPlaceholderClass;
							}

	RESOURCE		*	SetPtrToPtrInBuffer( RESOURCE * p)
							{
							return (PtrToPtrInBuffer = p);
							}
	RESOURCE		*	GetPtrToPtrInBuffer()
							{
							return PtrToPtrInBuffer;
							}

	void				SetImbedingMemSize( long Size )
							{
							ImbedingMemSize = Size;
							}

	long				GetImbedingMemSize()
							{
							return ImbedingMemSize;
							}

	void				SetImbedingBufSize( long Size )
							{
							ImbedingBufSize = Size;
							}

	long				GetImbedingBufSize()
							{
							return ImbedingBufSize;
							}
	PNAME				GenTRNameOffLastParam( char * Prefix );
	};

#endif // __CCB_HXX__
