/*
** thand.c
**
** Copyright(C) 1993,1994 Microsoft Corporation.
** All Rights Reserved.
**
** HISTORY:
**      Created: 01/27/94 - MarkRi
**
*/

#include <windows.h>
#include <stdarg.h>
#include <string.h>
#include "hooks.h"
#include "logger.h"

int _fltused = 0;

/*
** Some C functions which are not generated by the traceNT.tt template
*/

/*
**
** Enum Functions
**
*/

int EnumPens(
   GOBJENUMPROC fp,
   LPVOID       lpLogObject,
   LPARAM       lpData
) {
    int    l;

    LogIn( (LPSTR)"ENUMCALL:EnumObjects(PEN) FARPROC+LPLOGPEN+LPSTR+",
        fp, lpLogObject, lpData ) ;

    l = (* fp)( lpLogObject, lpData );

    LogOut( (LPSTR)"ENUMRET:EnumObjects(PEN) int+FARPROC+LPLOGPEN+LPSTR+",
        l, fp, lpLogObject, lpData ) ;

    return( l );

}


int EnumBrushes(
   GOBJENUMPROC fp,
   LPVOID       lpLogObject,
   LPARAM       lpData
) {
    int    l;

    LogIn( (LPSTR)"ENUMCALL:EnumObjects(BRUSH) FARPROC+LPLOGPEN+LPSTR+",
        fp, lpLogObject, lpData ) ;

    l = (*fp)( lpLogObject, lpData );

    LogOut( (LPSTR)"ENUMRET:EnumObjects(BRUSH) int+FARPROC+LPLOGPEN+LPSTR+",
        l, fp, lpLogObject, lpData ) ;

    return( l );

}


int zEnumObjects( HDC pp1, int pp2, FARPROC pp3, LPARAM pp4 )
{
    int r;
    FARPROC fp ;

    /*
    ** Log IN Parameters (No Create/Destroy Checking Yet!)
    */
    LogIn( (LPSTR)"APICALL:EnumObjects HDC+int+FARPROC+LPARAM+",
        pp1, pp2, pp3, pp4 );

    if( pp2 == OBJ_PEN )
      fp = (FARPROC)HookAdd( (FARPROC)EnumPens, (FARPROC)pp3 ) ;
    else
      fp = (FARPROC)HookAdd( (FARPROC)EnumBrushes, (FARPROC)pp3 ) ;

    /*
    ** Call the API!
    */
    r = EnumObjects(pp1,pp2,(GOBJENUMPROC)fp,pp4);
    /*
    ** Log Return Code & OUT Parameters (No Create/Destroy Checking Yet!)
    */
    LogOut( (LPSTR)"APIRET:EnumObjects int+++++",
        r, (short)0, (short)0, (short)0, (short)0 );

    return( r );
}

/*
    9-11-1991   BobK    Added EnumFonts Hook/Callback
*/

int FontCounter(
   FONTENUMPROC     fp,
   CONST LOGFONT    *lpLogFont,
   CONST TEXTMETRIC *lpTextMetrics,
   DWORD            nFontType,
   LPARAM           lpData
) {
    int    l;

    LogIn( (LPSTR)"ENUMCALL:EnumFonts FARPROC+LPLOGFONT+LPTEXTMETRIC+int+DWORD+",
        fp, lpLogFont, lpTextMetrics, nFontType, lpData ) ;

    l = (* fp)( lpLogFont, lpTextMetrics, nFontType, lpData );

    LogOut( (LPSTR)"ENUMRET:EnumFonts int+FARPROC+LPLOGFONT+LPTEXTMETRIC+int+DWORD+",
        l, fp, lpLogFont, lpTextMetrics, nFontType, lpData ) ;

    return( l );

}


int zEnumFonts( HDC pp1, LPSTR pp2, FARPROC pp3, LPARAM pp4 )
{
    int r;
    FARPROC fpCentslessTaker;

    /*
    ** Log IN Parameters (No Create/Destroy Checking Yet!)
    */
    LogIn( (LPSTR)"APICALL:EnumFonts HDC+LPSTR+FARPROC+LPARAM+",
        pp1, pp2, pp3, pp4 );

    /*
        Hook the callback function (a census taker) with our own little twist
    */

    fpCentslessTaker = (FARPROC) HookAdd((FARPROC)FontCounter, (FARPROC) pp3);

    /*
    ** Call the API!
    */
    r = EnumFonts(pp1, pp2, (FONTENUMPROC)fpCentslessTaker, pp4);
    /*
    ** Log Return Code & OUT Parameters (No Create/Destroy Checking Yet!)
    */
    LogOut( (LPSTR)"APIRET:EnumFonts int+++++",
        r, (short)0, (short)0, (short)0, (short)0 );

    return( r );
}

int FamilyCounter(
   FONTENUMPROC     fp,
   CONST LOGFONT    *lpLogFont,
   CONST TEXTMETRIC *lpTextMetrics,
   DWORD            nFontType,
   LPARAM           lpData
) {
    int    l;

    LogIn( (LPSTR)"ENUMCALL:EnumFontFamilies FARPROC+LPLOGFONT+LPTEXTMETRIC+int+DWORD+",
        fp, lpLogFont, lpTextMetrics, nFontType, lpData ) ;

    l = (* fp)( lpLogFont, lpTextMetrics, nFontType, lpData );

    LogOut( (LPSTR)"ENUMRET:EnumFontFamilies int+FARPROC+LPLOGFONT+LPTEXTMETRIC+int+DWORD+",
        l, fp, lpLogFont, lpTextMetrics, nFontType, lpData ) ;

    return( l );

}

int zEnumFontFamilies( HDC pp1, LPCSTR pp2, FONTENUMPROC pp3, LPARAM pp4 )
{
    int r;
    FARPROC fpCentslessTaker;

    /*
    ** Log IN Parameters (No Create/Destroy Checking Yet!)
    */
    LogIn( (LPSTR)"APICALL:EnumFontFamilies HDC+LPSTR+FARPROC+LPARAM+",
        pp1, pp2, pp3, pp4 );

    /*
        Hook the callback function (a census taker) with our own little twist
    */

    fpCentslessTaker = (FARPROC) HookAdd((FARPROC)FamilyCounter, (FARPROC)pp3);

    /*
    ** Call the API!
    */
    r = EnumFontFamilies(pp1,pp2,(FONTENUMPROC)fpCentslessTaker,pp4);
    /*
    ** Log Return Code & OUT Parameters (No Create/Destroy Checking Yet!)
    */
    LogOut( (LPSTR)"APIRET:EnumFontFamilies int+++++",
        r, (short)0, (short)0, (short)0, (short)0 );

    return( r );
}


/******************************************************************************

    The following were added by BobK in June, 1991

    They are hacks required to ensure logging of printing activity is done
    in such a manner that it can be played back on NT.  The primary problems
    are removal of support for almost every Escape call (fine, since Escape
    had come to mean writing device-dependent printing code in a nominally
    device-independent system), and (as well) elimination of application
    banding when printing.

    This requires intervention- massive intervention in the Escape call,
    and a little bit of it in GetDeviceCaps.  The reason this intervention
    is done in logging, is that many apps use Escapes to trigger special
    printer features (such as pattern-filling), instead of using GDI calls.
    We don't want these logged, since the NT versions of the drivers are
    to use such features automatically, thus making them available for all
    apps.

    Change History:

    06-14-1991  BobK    Initial Escape modifications debugged.
    06-15-1991  BobK    GetDeviceCaps interception added
    07-08-1991  BobK    Added changes for specialized Escape Logging

*******************************************************************************/

int zEscape( HDC hDC, int nEscape, int nCount, LPSTR lpInData,
                        LPSTR lpOutData)
{
    int     r;

    switch(nEscape)
      {
        static BOOL bNewFrame = FALSE;

        /*
            The NEXTBAND escape is intercepted, and the printer is made to
            look like a page-at-a-time printer.  We actually call NEWFRAME
            to print the page.  This effectively kills application banding
            at the source.
        */

        case    NEXTBAND:

          /*
            If this is the second of a pair of calls, do a NEWFRAME Escape,
            and return its results, along with an empty rectangle, to the
            caller.
          */

          if    (bNewFrame)
            {
              LogIn( (LPSTR)"APICALL:Escape HDC+int+int+LPSTR++",
                    hDC, NEWFRAME, 0, NULL, (short) 0);

              r = Escape(hDC, NEWFRAME, 0, NULL, NULL);
              SetRectEmpty((LPRECT) lpOutData);
              LogOut( (LPSTR)"APIRET:Escape int+int+LPSTR+", r, NEWFRAME,
                    lpOutData );
            }
          else
          /*
            If this is the first of a pair of calls, determine the media
            size from the HDC via GetDeviceCaps, and return a rectangle the
            size of the page.
          */

            {
              LogIn( (LPSTR)"APICALL:Escape(Intercepted) HDC+int+int+LPSTR++",
                    hDC, nEscape, nCount, lpInData, (short) 0);
              r = TRUE;
              SetRect((LPRECT) lpOutData, 0, 0, GetDeviceCaps(hDC, HORZRES),
                    GetDeviceCaps(hDC, VERTRES));
              LogOut( "APIRET:Escape(Intercepted) int+++++LPRECT+", r,
                    (short) 0, (short) 0, (short) 0, (short) 0, lpOutData );

            }

          bNewFrame = ! bNewFrame;
          return    r;

        case    QUERYESCSUPPORT:

          switch(*(LPINT) lpInData)
            {
              case  NEWFRAME:
              case  ABORTDOC:
              case  SETCOLORTABLE:
              case  GETCOLORTABLE:
              case  SETABORTPROC:
              case  STARTDOC:
              case  ENDDOC:
              case  QUERYESCSUPPORT:

                break;

              default:

                LogIn("APICALL:Escape(QueryBlocked) HDC+int+int+LPSTR++",
                      hDC, nEscape, nCount, lpInData, (short) 0);
                LogOut( (LPSTR)"APIRET:Escape(QueryBlocked) int+++++", 0,
                      (short)0, (short)0, (short)0, (short)0);
                return  0;
            }

          /*    NOTE: QUERYESCSUPPORT calls we think are OK drop through,
                here (hence they are not blocked).  So don't add any code
                before the 'case NEWFRAME' statement.  The following escapes
                have equivalent support in NT.
          */

        case    NEWFRAME:
        case    ABORTDOC:
        case    SETCOLORTABLE:
        case    GETCOLORTABLE:
        case    SETABORTPROC:
        case    STARTDOC:
        case    ENDDOC:

        /*
            The following escapes are allowed, although we deny they exist,
            when queried.  This is because some apps (like a high-volume
            spreadhseet produced by a company in Redmond, WA that will not
            be named herein) simply refuse to print if a printer doesn't
            respond to these escapes, even though they're optional.
        */

        case    GETPHYSPAGESIZE:
        case    GETSCALINGFACTOR:
        case    GETPRINTINGOFFSET:

          if    (nEscape == SETABORTPROC)
            LogIn("APICALL:Escape HDC+int+int+FARPROC++",
                  hDC, nEscape, nCount, lpInData, (short) 0);
          else
            LogIn("APICALL:Escape HDC+int+int+LPSTR++",
                  hDC, nEscape, nCount, lpInData, (short) 0);
          r = Escape(hDC, nEscape, nCount, lpInData, lpOutData);

          LogOut( (LPSTR)"APIRET:Escape int+int+LPSTR+", r, nEscape, lpOutData );

          return    r;

        default:

          LogIn("APICALL:Escape(blocked) HDC+int+int+LPSTR++",
                hDC, nEscape, nCount, lpInData, (short) 0);
          LogOut( (LPSTR)"APIRET:Escape(blocked) int+++++", 0,
                (short)0, (short)0, (short)0, (short)0);
          return    0;
      }

}

int zGetDeviceCaps( HDC pp1, int pp2 )
{
    int r;

    /*
    ** Log IN Parameters (No Create/Destroy Checking Yet!)
    */
    LogIn( (LPSTR)"APICALL:GetDeviceCaps HDC+int+",
        pp1, pp2 );

    /*
    ** Call the API!
    */
    r = GetDeviceCaps(pp1,pp2);

    /*
        This is the extent of our interception- if the device claims to be
        a banding device, don't let the caller know.
    */

    if  (pp2 == RASTERCAPS)
      r &= ~(RC_BANDING);

    /*
    ** Log Return Code & OUT Parameters (No Create/Destroy Checking Yet!)
    */
    LogOut( (LPSTR)"APIRET:GetDeviceCaps int+++",
        r, (short)0, (short)0 );

    return( r );
}


HDC zCreateDCA( LPSTR pp1, LPSTR pp2, LPSTR pp3, CONST DEVMODE *pp4 )
{
    HDC r;

    /*
    ** Log IN Parameters (No Create/Destroy Checking Yet!)
    */
    LogIn( (LPSTR)"APICALL:CreateDCA LPSTR+LPSTR+LPSTR+LPDEVMODE+",
        pp1, pp2, pp3, pp4 );

    /*
    ** Call the API!
    */
    r = CreateDCA(pp1,pp2,pp3,pp4);
    /*
    ** Log Return Code & OUT Parameters (No Create/Destroy Checking Yet!)
    */
    LogOut( (LPSTR)"APIRET:CreateDCA HDC+++++",
        r, (short)0, (short)0, (short)0, (short)0 );

    return( r );
}

HDC zCreateICA( LPSTR pp1, LPSTR pp2, LPSTR pp3, LPDEVMODE pp4 )
{
    HDC r;

    /*
    ** Log IN Parameters (No Create/Destroy Checking Yet!)
    */
    LogIn( (LPSTR)"APICALL:CreateICA LPSTR+LPSTR+LPSTR+LPDEVMODE+",
        pp1, pp2, pp3, pp4 );

    /*
    ** Call the API!
    */
    r = CreateICA(pp1,pp2,pp3,pp4);
    /*
    ** Log Return Code & OUT Parameters (No Create/Destroy Checking Yet!)
    */
    LogOut( (LPSTR)"APIRET:CreateICA HDC+++++",
        r, (short)0, (short)0, (short)0, (short)0 );

    return( r );
}

long zSetBitmapBits( HBITMAP pp1, DWORD pp2, LPSTR pp3 )
{
    long r;

    /*
    ** Log IN Parameters (No Create/Destroy Checking Yet!)
    */
    LogIn( (LPSTR)"APICALL:SetBitmapBits HBITMAP+DWORD+FixedString+",
        pp1, pp2, pp3, pp2 );

    /*
    ** Call the API!
    */
    r = SetBitmapBits(pp1,pp2,pp3);
    /*
    ** Log Return Code & OUT Parameters (No Create/Destroy Checking Yet!)
    */
    LogOut( (LPSTR)"APIRET:SetBitmapBits long++++",
        r, (short)0, (short)0, (short)0 );

    return( r );
}

BOOL zGetCharWidth( HDC pp1, UINT pp2, UINT pp3, LPINT pp4 )
{
    BOOL r;

    /*
    ** Log IN Parameters (No Create/Destroy Checking Yet!)
    */
    LogIn( (LPSTR)"APICALL:GetCharWidth HDC+UINT+UINT++",
        pp1, pp2, pp3, (short)0 );

    /*
    ** Call the API!
    */
    r = GetCharWidth(pp1,pp2,pp3,pp4);
    /*
    ** Log Return Code & OUT Parameters (No Create/Destroy Checking Yet!)
    */
    LogOut( (LPSTR)"APIRET:GetCharWidth BOOL++++ARRAYINT+",
        r, (short)0, (short)0, (short)0, pp4, 1 + pp3 - pp2 );

    return( r );
}

BOOL zExtTextOut( HDC pp1, int pp2, int pp3, WORD pp4, LPRECT pp5, LPSTR pp6, WORD pp7, LPINT pp8 )
{
    BOOL r;

    /*
    ** Log IN Parameters (No Create/Destroy Checking Yet!)
    */
    LogIn( (LPSTR)"APICALL:ExtTextOut HDC+int+int+WORD+LPRECT+LPSTR+WORD+ARRAYINT+",
        pp1, pp2, pp3, pp4, pp5, pp6, pp7, pp8, pp7 );

    /*
    ** Call the API!
    */
    r = ExtTextOut(pp1,pp2,pp3,pp4,pp5,pp6,pp7,pp8);
    /*
    ** Log Return Code & OUT Parameters (No Create/Destroy Checking Yet!)
    */
    LogOut( (LPSTR)"APIRET:ExtTextOut BOOL+++++++++",
        r, (short)0, (short)0, (short)0, (short)0, (short)0, (short)0, (short)0, (short)0 );

    return( r );
}
