/******************************Module*Header*******************************\
* Module Name: pattern.c
*
* Used for creating and destroying the default patterns to be used on this
* device.
*
* Copyright (c) 1992 Microsoft Corporation
\**************************************************************************/

#include "driver.h"

/******************************Public*Data*Struct*************************\
* gaajPat
*
* These are the standard patterns defined Windows, they are used to produce
* hatch brushes, grey brushes etc.
*
\**************************************************************************/

const ULONG gaaulPat[HS_DDI_MAX][8] = {

// Scans have to be DWORD aligned:

    { 0x00,                // ........     HS_HORIZONTAL 0
      0x00,                // ........
      0x00,                // ........
      0xff,                // ********
      0x00,                // ........
      0x00,                // ........
      0x00,                // ........
      0x00 },              // ........

    { 0x08,                // ....*...     HS_VERTICAL 1
      0x08,                // ....*...
      0x08,                // ....*...
      0x08,                // ....*...
      0x08,                // ....*...
      0x08,                // ....*...
      0x08,                // ....*...
      0x08 },              // ....*...

    { 0x80,                // *.......     HS_FDIAGONAL 2
      0x40,                // .*......
      0x20,                // ..*.....
      0x10,                // ...*....
      0x08,                // ....*...
      0x04,                // .....*..
      0x02,                // ......*.
      0x01 },              // .......*

    { 0x01,                // .......*     HS_BDIAGONAL 3
      0x02,                // ......*.
      0x04,                // .....*..
      0x08,                // ....*...
      0x10,                // ...*....
      0x20,                // ..*.....
      0x40,                // .*......
      0x80 },              // *.......

    { 0x08,                // ....*...     HS_CROSS 4
      0x08,                // ....*...
      0x08,                // ....*...
      0xff,                // ********
      0x08,                // ....*...
      0x08,                // ....*...
      0x08,                // ....*...
      0x08 },              // ....*...

    { 0x81,                // *......*     HS_DIAGCROSS 5
      0x42,                // .*....*.
      0x24,                // ..*..*..
      0x18,                // ...**...
      0x18,                // ...**...
      0x24,                // ..*..*..
      0x42,                // .*....*.
      0x81 }               // *......*
};

// Same pattern, repeated in planar format:

const ULONG gaaulPlanarPat[HS_DDI_MAX][8] = {
    { 0x0000,              // ........     HS_HORIZONTAL 0
      0x0000,              // ........
      0x0000,              // ........
      0xffff,              // ********
      0x0000,              // ........
      0x0000,              // ........
      0x0000,              // ........
      0x0000 },            // ........

    { 0x0110,              // ....*...     HS_VERTICAL 1
      0x0110,              // ....*...
      0x0110,              // ....*...
      0x0110,              // ....*...
      0x0110,              // ....*...
      0x0110,              // ....*...
      0x0110,              // ....*...
      0x0110 },            // ....*...

    { 0x1001,              // *.......     HS_FDIAGONAL 2
      0x2002,              // .*......
      0x4004,              // ..*.....
      0x8008,              // ...*....
      0x0110,              // ....*...
      0x0220,              // .....*..
      0x0440,              // ......*.
      0x0880 },            // .......*

    { 0x0880,              // .......*     HS_BDIAGONAL 3
      0x0440,              // ......*.
      0x0220,              // .....*..
      0x0110,              // ....*...
      0x8008,              // ...*....
      0x4004,              // ..*.....
      0x2002,              // .*......
      0x1001 },            // *.......

    { 0x0110,              // ....*...     HS_CROSS 4
      0x0110,              // ....*...
      0x0110,              // ....*...
      0xffff,              // ********
      0x0110,              // ....*...
      0x0110,              // ....*...
      0x0110,              // ....*...
      0x0110 },            // ....*...

    { 0x1881,              // *......*     HS_DIAGCROSS 5
      0x2442,              // .*....*.
      0x4224,              // ..*..*..
      0x8118,              // ...**...
      0x8118,              // ...**...
      0x4224,              // ..*..*..
      0x2442,              // .*....*.
      0x1881 }             // *......*
};



/******************************Public*Routine******************************\
* bInitPatterns
*
* This routine initializes the default patterns.
*
\**************************************************************************/

BOOL bInitPatterns(IN PPDEV ppdev, INT cPatterns)
{
    SIZEL           sizl;
    INT             iLoop;

    sizl.cx = 8;
    sizl.cy = 8;

    for (iLoop = 0; iLoop < cPatterns; iLoop++)
    {
        ppdev->ahbmPat[iLoop] = EngCreateBitmap(sizl,
                                                4,          // DWORD aligned
                                                BMF_1BPP,
                                                BMF_TOPDOWN,
                                                (PULONG) &gaaulPat[iLoop][0]);

        if (ppdev->ahbmPat[iLoop] == (HBITMAP) 0)
        {
        // Set the count created so vDisablePatterns will clean up.

            ppdev->cPatterns = iLoop;
            return(FALSE);
        }
    }

    ppdev->cPatterns = cPatterns;
    return(TRUE);
}

/******************************Public*Routine******************************\
* vDisablePatterns
*
* Delete the standard patterns allocated.
*
\**************************************************************************/

VOID vDisablePatterns(IN PPDEV ppdev)
{
    ULONG ulIndex;

// Erase all patterns.

    for (ulIndex = 0; ulIndex < ppdev->cPatterns; ulIndex++)
    {
        EngDeleteSurface((HSURF) ppdev->ahbmPat[ulIndex]);
    }
}
