//++
//
// Copyright (c) 1992  Microsoft Corporation
//
// Module Name:
//
//    glapi.s
//
// Abstract:
//
//    OpenGL API function entries for alpha
//
// Author:
//
//   Marc Fortier (v-marcf) 21-Mar-1994
//
// Environment:
//
//    User mode only.
//
// Revision History:
//
//--

#include "ksalpha.h"
#include "gdialpha.h"
#include "glapi.h"

// Macro for creating aligned public OpenGL API function
// Do an indirect jump through the OpenGL function dispatch table in the TEB.


#define MAKEOPENGLAPI(Func)			\
	LEAF_ENTRY( Func )			\
	GET_THREAD_ENVIRONMENT_BLOCK;		\
	addl	v0, TeglDispatchTable, t12; 	\
	ldl	t12, INDEX_##Func*4(t12);	\
	jmp	zero, (t12), 0x0;		\
	.end	Func;


MAKEOPENGLAPI( glNewList )
MAKEOPENGLAPI( glEndList )
MAKEOPENGLAPI( glCallList )
MAKEOPENGLAPI( glCallLists)
MAKEOPENGLAPI( glDeleteLists )
MAKEOPENGLAPI( glGenLists )
MAKEOPENGLAPI( glListBase )
MAKEOPENGLAPI( glBegin )
MAKEOPENGLAPI( glBitmap )
MAKEOPENGLAPI( glColor3b )
MAKEOPENGLAPI( glColor3bv )
MAKEOPENGLAPI( glColor3d )
MAKEOPENGLAPI( glColor3dv )
MAKEOPENGLAPI( glColor3f )
MAKEOPENGLAPI( glColor3fv )
MAKEOPENGLAPI( glColor3i )
MAKEOPENGLAPI( glColor3iv )
MAKEOPENGLAPI( glColor3s )
MAKEOPENGLAPI( glColor3sv )
MAKEOPENGLAPI( glColor3ub )
MAKEOPENGLAPI( glColor3ubv )
MAKEOPENGLAPI( glColor3ui )
MAKEOPENGLAPI( glColor3uiv )
MAKEOPENGLAPI( glColor3us )
MAKEOPENGLAPI( glColor3usv )
MAKEOPENGLAPI( glColor4b )
MAKEOPENGLAPI( glColor4bv )
MAKEOPENGLAPI( glColor4d )
MAKEOPENGLAPI( glColor4dv )
MAKEOPENGLAPI( glColor4f )
MAKEOPENGLAPI( glColor4fv )
MAKEOPENGLAPI( glColor4i )
MAKEOPENGLAPI( glColor4iv )
MAKEOPENGLAPI( glColor4s )
MAKEOPENGLAPI( glColor4sv )
MAKEOPENGLAPI( glColor4ub )
MAKEOPENGLAPI( glColor4ubv )
MAKEOPENGLAPI( glColor4ui )
MAKEOPENGLAPI( glColor4uiv )
MAKEOPENGLAPI( glColor4us )
MAKEOPENGLAPI( glColor4usv )
MAKEOPENGLAPI( glEdgeFlag )
MAKEOPENGLAPI( glEdgeFlagv )
MAKEOPENGLAPI( glEnd )
MAKEOPENGLAPI( glIndexd )
MAKEOPENGLAPI( glIndexdv )
MAKEOPENGLAPI( glIndexf )
MAKEOPENGLAPI( glIndexfv )
MAKEOPENGLAPI( glIndexi )
MAKEOPENGLAPI( glIndexiv )
MAKEOPENGLAPI( glIndexs )
MAKEOPENGLAPI( glIndexsv )
MAKEOPENGLAPI( glNormal3b )
MAKEOPENGLAPI( glNormal3bv )
MAKEOPENGLAPI( glNormal3d )
MAKEOPENGLAPI( glNormal3dv )
MAKEOPENGLAPI( glNormal3f )
MAKEOPENGLAPI( glNormal3fv )
MAKEOPENGLAPI( glNormal3i )
MAKEOPENGLAPI( glNormal3iv )
MAKEOPENGLAPI( glNormal3s )
MAKEOPENGLAPI( glNormal3sv )
MAKEOPENGLAPI( glRasterPos2d )
MAKEOPENGLAPI( glRasterPos2dv )
MAKEOPENGLAPI( glRasterPos2f )
MAKEOPENGLAPI( glRasterPos2fv )
MAKEOPENGLAPI( glRasterPos2i )
MAKEOPENGLAPI( glRasterPos2iv )
MAKEOPENGLAPI( glRasterPos2s )
MAKEOPENGLAPI( glRasterPos2sv )
MAKEOPENGLAPI( glRasterPos3d )
MAKEOPENGLAPI( glRasterPos3dv )
MAKEOPENGLAPI( glRasterPos3f )
MAKEOPENGLAPI( glRasterPos3fv )
MAKEOPENGLAPI( glRasterPos3i )
MAKEOPENGLAPI( glRasterPos3iv )
MAKEOPENGLAPI( glRasterPos3s )
MAKEOPENGLAPI( glRasterPos3sv )
MAKEOPENGLAPI( glRasterPos4d )
MAKEOPENGLAPI( glRasterPos4dv )
MAKEOPENGLAPI( glRasterPos4f )
MAKEOPENGLAPI( glRasterPos4fv )
MAKEOPENGLAPI( glRasterPos4i )
MAKEOPENGLAPI( glRasterPos4iv )
MAKEOPENGLAPI( glRasterPos4s )
MAKEOPENGLAPI( glRasterPos4sv )
MAKEOPENGLAPI( glRectd )
MAKEOPENGLAPI( glRectdv )
MAKEOPENGLAPI( glRectf )
MAKEOPENGLAPI( glRectfv )
MAKEOPENGLAPI( glRecti )
MAKEOPENGLAPI( glRectiv )
MAKEOPENGLAPI( glRects )
MAKEOPENGLAPI( glRectsv )
MAKEOPENGLAPI( glTexCoord1d )
MAKEOPENGLAPI( glTexCoord1dv )
MAKEOPENGLAPI( glTexCoord1f )
MAKEOPENGLAPI( glTexCoord1fv )
MAKEOPENGLAPI( glTexCoord1i )
MAKEOPENGLAPI( glTexCoord1iv )
MAKEOPENGLAPI( glTexCoord1s )
MAKEOPENGLAPI( glTexCoord1sv )
MAKEOPENGLAPI( glTexCoord2d )
MAKEOPENGLAPI( glTexCoord2dv )
MAKEOPENGLAPI( glTexCoord2f )
MAKEOPENGLAPI( glTexCoord2fv )
MAKEOPENGLAPI( glTexCoord2i )
MAKEOPENGLAPI( glTexCoord2iv )
MAKEOPENGLAPI( glTexCoord2s )
MAKEOPENGLAPI( glTexCoord2sv )
MAKEOPENGLAPI( glTexCoord3d )
MAKEOPENGLAPI( glTexCoord3dv )
MAKEOPENGLAPI( glTexCoord3f )
MAKEOPENGLAPI( glTexCoord3fv )
MAKEOPENGLAPI( glTexCoord3i )
MAKEOPENGLAPI( glTexCoord3iv )
MAKEOPENGLAPI( glTexCoord3s )
MAKEOPENGLAPI( glTexCoord3sv )
MAKEOPENGLAPI( glTexCoord4d )
MAKEOPENGLAPI( glTexCoord4dv )
MAKEOPENGLAPI( glTexCoord4f )
MAKEOPENGLAPI( glTexCoord4fv )
MAKEOPENGLAPI( glTexCoord4i )
MAKEOPENGLAPI( glTexCoord4iv )
MAKEOPENGLAPI( glTexCoord4s )
MAKEOPENGLAPI( glTexCoord4sv )
MAKEOPENGLAPI( glVertex2d )
MAKEOPENGLAPI( glVertex2dv )
MAKEOPENGLAPI( glVertex2f )
MAKEOPENGLAPI( glVertex2fv )
MAKEOPENGLAPI( glVertex2i )
MAKEOPENGLAPI( glVertex2iv )
MAKEOPENGLAPI( glVertex2s )
MAKEOPENGLAPI( glVertex2sv )
MAKEOPENGLAPI( glVertex3d )
MAKEOPENGLAPI( glVertex3dv )
MAKEOPENGLAPI( glVertex3f )
MAKEOPENGLAPI( glVertex3fv )
MAKEOPENGLAPI( glVertex3i )
MAKEOPENGLAPI( glVertex3iv )
MAKEOPENGLAPI( glVertex3s )
MAKEOPENGLAPI( glVertex3sv )
MAKEOPENGLAPI( glVertex4d )
MAKEOPENGLAPI( glVertex4dv )
MAKEOPENGLAPI( glVertex4f )
MAKEOPENGLAPI( glVertex4fv )
MAKEOPENGLAPI( glVertex4i )
MAKEOPENGLAPI( glVertex4iv )
MAKEOPENGLAPI( glVertex4s )
MAKEOPENGLAPI( glVertex4sv )
MAKEOPENGLAPI( glClipPlane )
MAKEOPENGLAPI( glColorMaterial )
MAKEOPENGLAPI( glCullFace )
MAKEOPENGLAPI( glFogf )
MAKEOPENGLAPI( glFogfv )
MAKEOPENGLAPI( glFogi )
MAKEOPENGLAPI( glFogiv )
MAKEOPENGLAPI( glFrontFace )
MAKEOPENGLAPI( glHint )
MAKEOPENGLAPI( glLightf )
MAKEOPENGLAPI( glLightfv )
MAKEOPENGLAPI( glLighti )
MAKEOPENGLAPI( glLightiv )
MAKEOPENGLAPI( glLightModelf )
MAKEOPENGLAPI( glLightModelfv )
MAKEOPENGLAPI( glLightModeli )
MAKEOPENGLAPI( glLightModeliv )
MAKEOPENGLAPI( glLineStipple )
MAKEOPENGLAPI( glLineWidth )
MAKEOPENGLAPI( glMaterialf )
MAKEOPENGLAPI( glMaterialfv )
MAKEOPENGLAPI( glMateriali )
MAKEOPENGLAPI( glMaterialiv )
MAKEOPENGLAPI( glPointSize )
MAKEOPENGLAPI( glPolygonMode )
MAKEOPENGLAPI( glPolygonStipple )
MAKEOPENGLAPI( glScissor )
MAKEOPENGLAPI( glShadeModel )
MAKEOPENGLAPI( glTexParameterf )
MAKEOPENGLAPI( glTexParameterfv )
MAKEOPENGLAPI( glTexParameteri )
MAKEOPENGLAPI( glTexParameteriv )
MAKEOPENGLAPI( glTexImage1D )
MAKEOPENGLAPI( glTexImage2D )
MAKEOPENGLAPI( glTexEnvf )
MAKEOPENGLAPI( glTexEnvfv )
MAKEOPENGLAPI( glTexEnvi )
MAKEOPENGLAPI( glTexEnviv )
MAKEOPENGLAPI( glTexGend )
MAKEOPENGLAPI( glTexGendv )
MAKEOPENGLAPI( glTexGenf )
MAKEOPENGLAPI( glTexGenfv )
MAKEOPENGLAPI( glTexGeni )
MAKEOPENGLAPI( glTexGeniv )
MAKEOPENGLAPI( glFeedbackBuffer )
MAKEOPENGLAPI( glSelectBuffer )
MAKEOPENGLAPI( glRenderMode )
MAKEOPENGLAPI( glInitNames )
MAKEOPENGLAPI( glLoadName )
MAKEOPENGLAPI( glPassThrough )
MAKEOPENGLAPI( glPopName )
MAKEOPENGLAPI( glPushName )
MAKEOPENGLAPI( glDrawBuffer )
MAKEOPENGLAPI( glClear )
MAKEOPENGLAPI( glClearAccum )
MAKEOPENGLAPI( glClearIndex )
MAKEOPENGLAPI( glClearColor )
MAKEOPENGLAPI( glClearStencil )
MAKEOPENGLAPI( glClearDepth )
MAKEOPENGLAPI( glStencilMask )
MAKEOPENGLAPI( glColorMask )
MAKEOPENGLAPI( glDepthMask )
MAKEOPENGLAPI( glIndexMask )
MAKEOPENGLAPI( glAccum )
MAKEOPENGLAPI( glDisable )
MAKEOPENGLAPI( glEnable )
MAKEOPENGLAPI( glFinish )
MAKEOPENGLAPI( glFlush )
MAKEOPENGLAPI( glPopAttrib )
MAKEOPENGLAPI( glPushAttrib )
MAKEOPENGLAPI( glMap1d )
MAKEOPENGLAPI( glMap1f )
MAKEOPENGLAPI( glMap2d )
MAKEOPENGLAPI( glMap2f )
MAKEOPENGLAPI( glMapGrid1d )
MAKEOPENGLAPI( glMapGrid1f )
MAKEOPENGLAPI( glMapGrid2d )
MAKEOPENGLAPI( glMapGrid2f )
MAKEOPENGLAPI( glEvalCoord1d )
MAKEOPENGLAPI( glEvalCoord1dv )
MAKEOPENGLAPI( glEvalCoord1f )
MAKEOPENGLAPI( glEvalCoord1fv )
MAKEOPENGLAPI( glEvalCoord2d )
MAKEOPENGLAPI( glEvalCoord2dv )
MAKEOPENGLAPI( glEvalCoord2f )
MAKEOPENGLAPI( glEvalCoord2fv )
MAKEOPENGLAPI( glEvalMesh1 )
MAKEOPENGLAPI( glEvalPoint1 )
MAKEOPENGLAPI( glEvalMesh2 )
MAKEOPENGLAPI( glEvalPoint2 )
MAKEOPENGLAPI( glAlphaFunc )
MAKEOPENGLAPI( glBlendFunc )
MAKEOPENGLAPI( glLogicOp )
MAKEOPENGLAPI( glStencilFunc )
MAKEOPENGLAPI( glStencilOp )
MAKEOPENGLAPI( glDepthFunc )
MAKEOPENGLAPI( glPixelZoom )
MAKEOPENGLAPI( glPixelTransferf )
MAKEOPENGLAPI( glPixelTransferi )
MAKEOPENGLAPI( glPixelStoref )
MAKEOPENGLAPI( glPixelStorei )
MAKEOPENGLAPI( glPixelMapfv )
MAKEOPENGLAPI( glPixelMapuiv )
MAKEOPENGLAPI( glPixelMapusv )
MAKEOPENGLAPI( glReadBuffer )
MAKEOPENGLAPI( glCopyPixels )
MAKEOPENGLAPI( glReadPixels )
MAKEOPENGLAPI( glDrawPixels )
MAKEOPENGLAPI( glGetBooleanv )
MAKEOPENGLAPI( glGetClipPlane )
MAKEOPENGLAPI( glGetDoublev )
MAKEOPENGLAPI( glGetError )
MAKEOPENGLAPI( glGetFloatv )
MAKEOPENGLAPI( glGetIntegerv )
MAKEOPENGLAPI( glGetLightfv )
MAKEOPENGLAPI( glGetLightiv )
MAKEOPENGLAPI( glGetMapdv )
MAKEOPENGLAPI( glGetMapfv )
MAKEOPENGLAPI( glGetMapiv )
MAKEOPENGLAPI( glGetMaterialfv )
MAKEOPENGLAPI( glGetMaterialiv )
MAKEOPENGLAPI( glGetPixelMapfv )
MAKEOPENGLAPI( glGetPixelMapuiv )
MAKEOPENGLAPI( glGetPixelMapusv )
MAKEOPENGLAPI( glGetPolygonStipple )
MAKEOPENGLAPI( glGetString )
MAKEOPENGLAPI( glGetTexEnvfv )
MAKEOPENGLAPI( glGetTexEnviv )
MAKEOPENGLAPI( glGetTexGendv )
MAKEOPENGLAPI( glGetTexGenfv )
MAKEOPENGLAPI( glGetTexGeniv )
MAKEOPENGLAPI( glGetTexImage )
MAKEOPENGLAPI( glGetTexParameterfv )
MAKEOPENGLAPI( glGetTexParameteriv )
MAKEOPENGLAPI( glGetTexLevelParameterfv )
MAKEOPENGLAPI( glGetTexLevelParameteriv )
MAKEOPENGLAPI( glIsEnabled )
MAKEOPENGLAPI( glIsList )
MAKEOPENGLAPI( glDepthRange )
MAKEOPENGLAPI( glFrustum )
MAKEOPENGLAPI( glLoadIdentity )
MAKEOPENGLAPI( glLoadMatrixf )
MAKEOPENGLAPI( glLoadMatrixd )
MAKEOPENGLAPI( glMatrixMode )
MAKEOPENGLAPI( glMultMatrixf )
MAKEOPENGLAPI( glMultMatrixd )
MAKEOPENGLAPI( glOrtho )
MAKEOPENGLAPI( glPopMatrix )
MAKEOPENGLAPI( glPushMatrix )
MAKEOPENGLAPI( glRotated )
MAKEOPENGLAPI( glRotatef )
MAKEOPENGLAPI( glScaled )
MAKEOPENGLAPI( glScalef )
MAKEOPENGLAPI( glTranslated )
MAKEOPENGLAPI( glTranslatef )
MAKEOPENGLAPI( glViewport )
