#ifndef __glcpu_h_
#define __glcpu_h_

/*
** Copyright 1991, Silicon Graphics, Inc.
** All Rights Reserved.
**
** This is UNPUBLISHED PROPRIETARY SOURCE CODE of Silicon Graphics, Inc.;
** the contents of this file may not be disclosed to third parties, copied or
** duplicated in any form, in whole or in part, without the prior written
** permission of Silicon Graphics, Inc.
**
** RESTRICTED RIGHTS LEGEND:
** Use, duplication or disclosure by the Government is subject to restrictions
** as set forth in subdivision (c)(1)(ii) of the Rights in Technical Data
** and Computer Software clause at DFARS 252.227-7013, and/or in similar or
** successor clauses in the FAR, DOD or NASA FAR Supplement. Unpublished -
** rights reserved under the Copyright Laws of the United States.
**
** CPU dependent constants.
*/

#ifdef __sgi

#define __GL_BITS_PER_BYTE	8
#define __GL_STIPPLE_MSB	1

typedef union __GLcpuFloatRec {
    float f;
    unsigned long ul;
    struct {
	unsigned int sign : 1;
	unsigned int exponent : 8;
	unsigned int mantissa : 23;
    } field;
} __GLcpuFloat;

#define __GL_FLOAT_MANTISSA_BITS	23
#define __GL_FLOAT_MANTISSA_SHIFT	0
#define __GL_FLOAT_EXPONENT_BIAS	127
#define __GL_FLOAT_EXPONENT_BITS	8
#define __GL_FLOAT_EXPONENT_SHIFT	23
#define __GL_FLOAT_SIGN_SHIFT		31

/* NOTE: if you change fixed.h constants X_BIAS or Y_BIAS, update these! */
/* XXX buzz!  can't do this */
#ifndef LIGHT
#define __GL_BIASFLOAT_FRACTION_BITS	10
#define __GL_BIASFLOAT_INTEGER_BITS	13
#else
#define __GL_BIASFLOAT_FRACTION_BITS	11
#define __GL_BIASFLOAT_INTEGER_BITS	12
#endif

/* NOTE: __glzValue better be unsigned */
#define __GL_Z_SIGN_BIT(z) \
    ((z) >> (sizeof(__GLzValue) * __GL_BITS_PER_BYTE - 1))

#endif /* sgi */

#ifdef NT
#define __GL_STIPPLE_MSB	1
#endif /* NT */

#endif /* __glcpu_h_ */
