/******************************Module*Header*******************************\
* Module Name: ftbm.c
*
* This is a test of the genblt functions
*
* Created: 8-NOV-1990 12:52:00
* Author: Patrick Haluptzok patrickh
*
* Copyright (c) 1990 Microsoft Corporation
*
\**************************************************************************/
#include "precomp.h"
#pragma hdrstop

// This is to create a bitmapinfo structure

typedef struct _BITMAPINFOPAT2
{
    BITMAPINFOHEADER                 bmiHeader;
    RGBQUAD                          bmiColors[20];
} BITMAPINFOPAT2;

typedef struct _BITMAPINFOPAT
{
    BITMAPINFOHEADER                 bmiHeader;
    RGBQUAD                          bmiColors[16];
} BITMAPINFOPAT;

BITMAPINFOPAT bmiPat =
{
    {
        sizeof(BITMAPINFOHEADER),
        32,
        32,
        1,
        1,
        BI_RGB,
        (32 * 32),
        0,
        0,
        2,
        2
    },

    {                               // B    G    R
        { 0,   0,   0x80,0 },       // 1
        { 0,   0x80,0,   0 },       // 2
        { 0,   0,   0,   0 },       // 0
        { 0,   0x80,0x80,0 },       // 3
        { 0x80,0,   0,   0 },       // 4
        { 0x80,0,   0x80,0 },       // 5
        { 0x80,0x80,0,   0 },       // 6
	{ 0x80,0x80,0x80,0 },	    // 7
	{ 0xC0,0xC0,0xC0,0 },	    // 8
        { 0,   0,   0xFF,0 },       // 9
        { 0,   0xFF,0,   0 },       // 10
        { 0,   0xFF,0xFF,0 },       // 11
        { 0xFF,0,   0,   0 },       // 12
        { 0xFF,0,   0xFF,0 },       // 13
        { 0xFF,0xFF,0,   0 },       // 14
        { 0xFF,0xFF,0xFF,0 }        // 15
    }
};

BYTE abColorLines[64 * 64 / 2] =
{
// 0
     0x00,0x00,0x11,0x11,0x22,0x22,0x33,0x33,0x44,0x44,0x55,0x55,0x66,0x66,0x77,0x77,0x88,0x88,0x99,0x99,0xAA,0xAA,0xBB,0xBB,0xCC,0xCC,0xDD,0xDD,0xEE,0xEE,0xFF,0xFF,
     0x00,0x00,0x11,0x11,0x22,0x22,0x33,0x33,0x44,0x44,0x55,0x55,0x66,0x66,0x77,0x77,0x88,0x88,0x99,0x99,0xAA,0xAA,0xBB,0xBB,0xCC,0xCC,0xDD,0xDD,0xEE,0xEE,0xFF,0xFF,
     0x00,0x00,0x11,0x11,0x22,0x22,0x33,0x33,0x44,0x44,0x55,0x55,0x66,0x66,0x77,0x77,0x88,0x88,0x99,0x99,0xAA,0xAA,0xBB,0xBB,0xCC,0xCC,0xDD,0xDD,0xEE,0xEE,0xFF,0xFF,
     0x00,0x00,0x11,0x11,0x22,0x22,0x33,0x33,0x44,0x44,0x55,0x55,0x66,0x66,0x77,0x77,0x88,0x88,0x99,0x99,0xAA,0xAA,0xBB,0xBB,0xCC,0xCC,0xDD,0xDD,0xEE,0xEE,0xFF,0xFF,

     0x00,0x00,0x11,0x11,0x22,0x22,0x33,0x33,0x44,0x44,0x55,0x55,0x66,0x66,0x77,0x77,0x88,0x88,0x99,0x99,0xAA,0xAA,0xBB,0xBB,0xCC,0xCC,0xDD,0xDD,0xEE,0xEE,0xFF,0xFF,
     0x00,0x00,0x11,0x11,0x22,0x22,0x33,0x33,0x44,0x44,0x55,0x55,0x66,0x66,0x77,0x77,0x88,0x88,0x99,0x99,0xAA,0xAA,0xBB,0xBB,0xCC,0xCC,0xDD,0xDD,0xEE,0xEE,0xFF,0xFF,
     0x00,0x00,0x11,0x11,0x22,0x22,0x33,0x33,0x44,0x44,0x55,0x55,0x66,0x66,0x77,0x77,0x88,0x88,0x99,0x99,0xAA,0xAA,0xBB,0xBB,0xCC,0xCC,0xDD,0xDD,0xEE,0xEE,0xFF,0xFF,
     0x00,0x00,0x11,0x11,0x22,0x22,0x33,0x33,0x44,0x44,0x55,0x55,0x66,0x66,0x77,0x77,0x88,0x88,0x99,0x99,0xAA,0xAA,0xBB,0xBB,0xCC,0xCC,0xDD,0xDD,0xEE,0xEE,0xFF,0xFF,
// 8
     0x00,0x00,0x11,0x11,0x22,0x22,0x33,0x33,0x44,0x44,0x55,0x55,0x66,0x66,0x77,0x77,0x88,0x88,0x99,0x99,0xAA,0xAA,0xBB,0xBB,0xCC,0xCC,0xDD,0xDD,0xEE,0xEE,0xFF,0xFF,
     0x00,0x00,0x11,0x11,0x22,0x22,0x33,0x33,0x44,0x44,0x55,0x55,0x66,0x66,0x77,0x77,0x88,0x88,0x99,0x99,0xAA,0xAA,0xBB,0xBB,0xCC,0xCC,0xDD,0xDD,0xEE,0xEE,0xFF,0xFF,
     0x00,0x00,0x11,0x11,0x22,0x22,0x33,0x33,0x44,0x44,0x55,0x55,0x66,0x66,0x77,0x77,0x88,0x88,0x99,0x99,0xAA,0xAA,0xBB,0xBB,0xCC,0xCC,0xDD,0xDD,0xEE,0xEE,0xFF,0xFF,
     0x00,0x00,0x11,0x11,0x22,0x22,0x33,0x33,0x44,0x44,0x55,0x55,0x66,0x66,0x77,0x77,0x88,0x88,0x99,0x99,0xAA,0xAA,0xBB,0xBB,0xCC,0xCC,0xDD,0xDD,0xEE,0xEE,0xFF,0xFF,

     0x00,0x00,0x11,0x11,0x22,0x22,0x33,0x33,0x44,0x44,0x55,0x55,0x66,0x66,0x77,0x77,0x88,0x88,0x99,0x99,0xAA,0xAA,0xBB,0xBB,0xCC,0xCC,0xDD,0xDD,0xEE,0xEE,0xFF,0xFF,
     0x00,0x00,0x11,0x11,0x22,0x22,0x33,0x33,0x44,0x44,0x55,0x55,0x66,0x66,0x77,0x77,0x88,0x88,0x99,0x99,0xAA,0xAA,0xBB,0xBB,0xCC,0xCC,0xDD,0xDD,0xEE,0xEE,0xFF,0xFF,
     0x00,0x00,0x11,0x11,0x22,0x22,0x33,0x33,0x44,0x44,0x55,0x55,0x66,0x66,0x77,0x77,0x88,0x88,0x99,0x99,0xAA,0xAA,0xBB,0xBB,0xCC,0xCC,0xDD,0xDD,0xEE,0xEE,0xFF,0xFF,
     0x00,0x00,0x11,0x11,0x22,0x22,0x33,0x33,0x44,0x44,0x55,0x55,0x66,0x66,0x77,0x77,0x88,0x88,0x99,0x99,0xAA,0xAA,0xBB,0xBB,0xCC,0xCC,0xDD,0xDD,0xEE,0xEE,0xFF,0xFF,
// 16
     0x00,0x00,0x11,0x11,0x22,0x22,0x33,0x33,0x44,0x44,0x55,0x55,0x66,0x66,0x77,0x77,0x88,0x88,0x99,0x99,0xAA,0xAA,0xBB,0xBB,0xCC,0xCC,0xDD,0xDD,0xEE,0xEE,0xFF,0xFF,
     0x00,0x00,0x11,0x11,0x22,0x22,0x33,0x33,0x44,0x44,0x55,0x55,0x66,0x66,0x77,0x77,0x88,0x88,0x99,0x99,0xAA,0xAA,0xBB,0xBB,0xCC,0xCC,0xDD,0xDD,0xEE,0xEE,0xFF,0xFF,
     0x00,0x00,0x11,0x11,0x22,0x22,0x33,0x33,0x44,0x44,0x55,0x55,0x66,0x66,0x77,0x77,0x88,0x88,0x99,0x99,0xAA,0xAA,0xBB,0xBB,0xCC,0xCC,0xDD,0xDD,0xEE,0xEE,0xFF,0xFF,
     0x00,0x00,0x11,0x11,0x22,0x22,0x33,0x33,0x44,0x44,0x55,0x55,0x66,0x66,0x77,0x77,0x88,0x88,0x99,0x99,0xAA,0xAA,0xBB,0xBB,0xCC,0xCC,0xDD,0xDD,0xEE,0xEE,0xFF,0xFF,

     0x00,0x00,0x11,0x11,0x22,0x22,0x33,0x33,0x44,0x44,0x55,0x55,0x66,0x66,0x77,0x77,0x88,0x88,0x99,0x99,0xAA,0xAA,0xBB,0xBB,0xCC,0xCC,0xDD,0xDD,0xEE,0xEE,0xFF,0xFF,
     0x00,0x00,0x11,0x11,0x22,0x22,0x33,0x33,0x44,0x44,0x55,0x55,0x66,0x66,0x77,0x77,0x88,0x88,0x99,0x99,0xAA,0xAA,0xBB,0xBB,0xCC,0xCC,0xDD,0xDD,0xEE,0xEE,0xFF,0xFF,
     0x00,0x00,0x11,0x11,0x22,0x22,0x33,0x33,0x44,0x44,0x55,0x55,0x66,0x66,0x77,0x77,0x88,0x88,0x99,0x99,0xAA,0xAA,0xBB,0xBB,0xCC,0xCC,0xDD,0xDD,0xEE,0xEE,0xFF,0xFF,
     0x00,0x00,0x11,0x11,0x22,0x22,0x33,0x33,0x44,0x44,0x55,0x55,0x66,0x66,0x77,0x77,0x88,0x88,0x99,0x99,0xAA,0xAA,0xBB,0xBB,0xCC,0xCC,0xDD,0xDD,0xEE,0xEE,0xFF,0xFF,
// 24
     0x00,0x00,0x11,0x11,0x22,0x22,0x33,0x33,0x44,0x44,0x55,0x55,0x66,0x66,0x77,0x77,0x88,0x88,0x99,0x99,0xAA,0xAA,0xBB,0xBB,0xCC,0xCC,0xDD,0xDD,0xEE,0xEE,0xFF,0xFF,
     0x00,0x00,0x11,0x11,0x22,0x22,0x33,0x33,0x44,0x44,0x55,0x55,0x66,0x66,0x77,0x77,0x88,0x88,0x99,0x99,0xAA,0xAA,0xBB,0xBB,0xCC,0xCC,0xDD,0xDD,0xEE,0xEE,0xFF,0xFF,
     0x00,0x00,0x11,0x11,0x22,0x22,0x33,0x33,0x44,0x44,0x55,0x55,0x66,0x66,0x77,0x77,0x88,0x88,0x99,0x99,0xAA,0xAA,0xBB,0xBB,0xCC,0xCC,0xDD,0xDD,0xEE,0xEE,0xFF,0xFF,
     0x00,0x00,0x11,0x11,0x22,0x22,0x33,0x33,0x44,0x44,0x55,0x55,0x66,0x66,0x77,0x77,0x88,0x88,0x99,0x99,0xAA,0xAA,0xBB,0xBB,0xCC,0xCC,0xDD,0xDD,0xEE,0xEE,0xFF,0xFF,

     0x00,0x00,0x11,0x11,0x22,0x22,0x33,0x33,0x44,0x44,0x55,0x55,0x66,0x66,0x77,0x77,0x88,0x88,0x99,0x99,0xAA,0xAA,0xBB,0xBB,0xCC,0xCC,0xDD,0xDD,0xEE,0xEE,0xFF,0xFF,
     0x00,0x00,0x11,0x11,0x22,0x22,0x33,0x33,0x44,0x44,0x55,0x55,0x66,0x66,0x77,0x77,0x88,0x88,0x99,0x99,0xAA,0xAA,0xBB,0xBB,0xCC,0xCC,0xDD,0xDD,0xEE,0xEE,0xFF,0xFF,
     0x00,0x00,0x11,0x11,0x22,0x22,0x33,0x33,0x44,0x44,0x55,0x55,0x66,0x66,0x77,0x77,0x88,0x88,0x99,0x99,0xAA,0xAA,0xBB,0xBB,0xCC,0xCC,0xDD,0xDD,0xEE,0xEE,0xFF,0xFF,
     0x00,0x00,0x11,0x11,0x22,0x22,0x33,0x33,0x44,0x44,0x55,0x55,0x66,0x66,0x77,0x77,0x88,0x88,0x99,0x99,0xAA,0xAA,0xBB,0xBB,0xCC,0xCC,0xDD,0xDD,0xEE,0xEE,0xFF,0xFF,
// 32
     0x00,0x00,0x11,0x11,0x22,0x22,0x33,0x33,0x44,0x44,0x55,0x55,0x66,0x66,0x77,0x77,0x88,0x88,0x99,0x99,0xAA,0xAA,0xBB,0xBB,0xCC,0xCC,0xDD,0xDD,0xEE,0xEE,0xFF,0xFF,
     0x00,0x00,0x11,0x11,0x22,0x22,0x33,0x33,0x44,0x44,0x55,0x55,0x66,0x66,0x77,0x77,0x88,0x88,0x99,0x99,0xAA,0xAA,0xBB,0xBB,0xCC,0xCC,0xDD,0xDD,0xEE,0xEE,0xFF,0xFF,
     0x00,0x00,0x11,0x11,0x22,0x22,0x33,0x33,0x44,0x44,0x55,0x55,0x66,0x66,0x77,0x77,0x88,0x88,0x99,0x99,0xAA,0xAA,0xBB,0xBB,0xCC,0xCC,0xDD,0xDD,0xEE,0xEE,0xFF,0xFF,
     0x00,0x00,0x11,0x11,0x22,0x22,0x33,0x33,0x44,0x44,0x55,0x55,0x66,0x66,0x77,0x77,0x88,0x88,0x99,0x99,0xAA,0xAA,0xBB,0xBB,0xCC,0xCC,0xDD,0xDD,0xEE,0xEE,0xFF,0xFF,

     0x00,0x00,0x11,0x11,0x22,0x22,0x33,0x33,0x44,0x44,0x55,0x55,0x66,0x66,0x77,0x77,0x88,0x88,0x99,0x99,0xAA,0xAA,0xBB,0xBB,0xCC,0xCC,0xDD,0xDD,0xEE,0xEE,0xFF,0xFF,
     0x00,0x00,0x11,0x11,0x22,0x22,0x33,0x33,0x44,0x44,0x55,0x55,0x66,0x66,0x77,0x77,0x88,0x88,0x99,0x99,0xAA,0xAA,0xBB,0xBB,0xCC,0xCC,0xDD,0xDD,0xEE,0xEE,0xFF,0xFF,
     0x00,0x00,0x11,0x11,0x22,0x22,0x33,0x33,0x44,0x44,0x55,0x55,0x66,0x66,0x77,0x77,0x88,0x88,0x99,0x99,0xAA,0xAA,0xBB,0xBB,0xCC,0xCC,0xDD,0xDD,0xEE,0xEE,0xFF,0xFF,
     0x00,0x00,0x11,0x11,0x22,0x22,0x33,0x33,0x44,0x44,0x55,0x55,0x66,0x66,0x77,0x77,0x88,0x88,0x99,0x99,0xAA,0xAA,0xBB,0xBB,0xCC,0xCC,0xDD,0xDD,0xEE,0xEE,0xFF,0xFF,
// 40
     0x00,0x00,0x11,0x11,0x22,0x22,0x33,0x33,0x44,0x44,0x55,0x55,0x66,0x66,0x77,0x77,0x88,0x88,0x99,0x99,0xAA,0xAA,0xBB,0xBB,0xCC,0xCC,0xDD,0xDD,0xEE,0xEE,0xFF,0xFF,
     0x00,0x00,0x11,0x11,0x22,0x22,0x33,0x33,0x44,0x44,0x55,0x55,0x66,0x66,0x77,0x77,0x88,0x88,0x99,0x99,0xAA,0xAA,0xBB,0xBB,0xCC,0xCC,0xDD,0xDD,0xEE,0xEE,0xFF,0xFF,
     0x00,0x00,0x11,0x11,0x22,0x22,0x33,0x33,0x44,0x44,0x55,0x55,0x66,0x66,0x77,0x77,0x88,0x88,0x99,0x99,0xAA,0xAA,0xBB,0xBB,0xCC,0xCC,0xDD,0xDD,0xEE,0xEE,0xFF,0xFF,
     0x00,0x00,0x11,0x11,0x22,0x22,0x33,0x33,0x44,0x44,0x55,0x55,0x66,0x66,0x77,0x77,0x88,0x88,0x99,0x99,0xAA,0xAA,0xBB,0xBB,0xCC,0xCC,0xDD,0xDD,0xEE,0xEE,0xFF,0xFF,

     0x00,0x00,0x11,0x11,0x22,0x22,0x33,0x33,0x44,0x44,0x55,0x55,0x66,0x66,0x77,0x77,0x88,0x88,0x99,0x99,0xAA,0xAA,0xBB,0xBB,0xCC,0xCC,0xDD,0xDD,0xEE,0xEE,0xFF,0xFF,
     0x00,0x00,0x11,0x11,0x22,0x22,0x33,0x33,0x44,0x44,0x55,0x55,0x66,0x66,0x77,0x77,0x88,0x88,0x99,0x99,0xAA,0xAA,0xBB,0xBB,0xCC,0xCC,0xDD,0xDD,0xEE,0xEE,0xFF,0xFF,
     0x00,0x00,0x11,0x11,0x22,0x22,0x33,0x33,0x44,0x44,0x55,0x55,0x66,0x66,0x77,0x77,0x88,0x88,0x99,0x99,0xAA,0xAA,0xBB,0xBB,0xCC,0xCC,0xDD,0xDD,0xEE,0xEE,0xFF,0xFF,
     0x00,0x00,0x11,0x11,0x22,0x22,0x33,0x33,0x44,0x44,0x55,0x55,0x66,0x66,0x77,0x77,0x88,0x88,0x99,0x99,0xAA,0xAA,0xBB,0xBB,0xCC,0xCC,0xDD,0xDD,0xEE,0xEE,0xFF,0xFF,
// 48
     0x00,0x00,0x11,0x11,0x22,0x22,0x33,0x33,0x44,0x44,0x55,0x55,0x66,0x66,0x77,0x77,0x88,0x88,0x99,0x99,0xAA,0xAA,0xBB,0xBB,0xCC,0xCC,0xDD,0xDD,0xEE,0xEE,0xFF,0xFF,
     0x00,0x00,0x11,0x11,0x22,0x22,0x33,0x33,0x44,0x44,0x55,0x55,0x66,0x66,0x77,0x77,0x88,0x88,0x99,0x99,0xAA,0xAA,0xBB,0xBB,0xCC,0xCC,0xDD,0xDD,0xEE,0xEE,0xFF,0xFF,
     0x00,0x00,0x11,0x11,0x22,0x22,0x33,0x33,0x44,0x44,0x55,0x55,0x66,0x66,0x77,0x77,0x88,0x88,0x99,0x99,0xAA,0xAA,0xBB,0xBB,0xCC,0xCC,0xDD,0xDD,0xEE,0xEE,0xFF,0xFF,
     0x00,0x00,0x11,0x11,0x22,0x22,0x33,0x33,0x44,0x44,0x55,0x55,0x66,0x66,0x77,0x77,0x88,0x88,0x99,0x99,0xAA,0xAA,0xBB,0xBB,0xCC,0xCC,0xDD,0xDD,0xEE,0xEE,0xFF,0xFF,

     0x00,0x00,0x11,0x11,0x22,0x22,0x33,0x33,0x44,0x44,0x55,0x55,0x66,0x66,0x77,0x77,0x88,0x88,0x99,0x99,0xAA,0xAA,0xBB,0xBB,0xCC,0xCC,0xDD,0xDD,0xEE,0xEE,0xFF,0xFF,
     0x00,0x00,0x11,0x11,0x22,0x22,0x33,0x33,0x44,0x44,0x55,0x55,0x66,0x66,0x77,0x77,0x88,0x88,0x99,0x99,0xAA,0xAA,0xBB,0xBB,0xCC,0xCC,0xDD,0xDD,0xEE,0xEE,0xFF,0xFF,
     0x00,0x00,0x11,0x11,0x22,0x22,0x33,0x33,0x44,0x44,0x55,0x55,0x66,0x66,0x77,0x77,0x88,0x88,0x99,0x99,0xAA,0xAA,0xBB,0xBB,0xCC,0xCC,0xDD,0xDD,0xEE,0xEE,0xFF,0xFF,
     0x00,0x00,0x11,0x11,0x22,0x22,0x33,0x33,0x44,0x44,0x55,0x55,0x66,0x66,0x77,0x77,0x88,0x88,0x99,0x99,0xAA,0xAA,0xBB,0xBB,0xCC,0xCC,0xDD,0xDD,0xEE,0xEE,0xFF,0xFF,
// 56
     0x00,0x00,0x11,0x11,0x22,0x22,0x33,0x33,0x44,0x44,0x55,0x55,0x66,0x66,0x77,0x77,0x88,0x88,0x99,0x99,0xAA,0xAA,0xBB,0xBB,0xCC,0xCC,0xDD,0xDD,0xEE,0xEE,0xFF,0xFF,
     0x00,0x00,0x11,0x11,0x22,0x22,0x33,0x33,0x44,0x44,0x55,0x55,0x66,0x66,0x77,0x77,0x88,0x88,0x99,0x99,0xAA,0xAA,0xBB,0xBB,0xCC,0xCC,0xDD,0xDD,0xEE,0xEE,0xFF,0xFF,
     0x00,0x00,0x11,0x11,0x22,0x22,0x33,0x33,0x44,0x44,0x55,0x55,0x66,0x66,0x77,0x77,0x88,0x88,0x99,0x99,0xAA,0xAA,0xBB,0xBB,0xCC,0xCC,0xDD,0xDD,0xEE,0xEE,0xFF,0xFF,
     0x00,0x00,0x11,0x11,0x22,0x22,0x33,0x33,0x44,0x44,0x55,0x55,0x66,0x66,0x77,0x77,0x88,0x88,0x99,0x99,0xAA,0xAA,0xBB,0xBB,0xCC,0xCC,0xDD,0xDD,0xEE,0xEE,0xFF,0xFF,

     0x00,0x00,0x11,0x11,0x22,0x22,0x33,0x33,0x44,0x44,0x55,0x55,0x66,0x66,0x77,0x77,0x88,0x88,0x99,0x99,0xAA,0xAA,0xBB,0xBB,0xCC,0xCC,0xDD,0xDD,0xEE,0xEE,0xFF,0xFF,
     0x00,0x00,0x11,0x11,0x22,0x22,0x33,0x33,0x44,0x44,0x55,0x55,0x66,0x66,0x77,0x77,0x88,0x88,0x99,0x99,0xAA,0xAA,0xBB,0xBB,0xCC,0xCC,0xDD,0xDD,0xEE,0xEE,0xFF,0xFF,
     0x00,0x00,0x11,0x11,0x22,0x22,0x33,0x33,0x44,0x44,0x55,0x55,0x66,0x66,0x77,0x77,0x88,0x88,0x99,0x99,0xAA,0xAA,0xBB,0xBB,0xCC,0xCC,0xDD,0xDD,0xEE,0xEE,0xFF,0xFF,
     0x00,0x00,0x11,0x11,0x22,0x22,0x33,0x33,0x44,0x44,0x55,0x55,0x66,0x66,0x77,0x77,0x88,0x88,0x99,0x99,0xAA,0xAA,0xBB,0xBB,0xCC,0xCC,0xDD,0xDD,0xEE,0xEE,0xFF,0xFF
// 64
};

BITMAPINFOPAT bmiPat1 =
{
    {
        sizeof(BITMAPINFOHEADER),
        64,
        64,
        1,
        4,
        BI_RGB,
        (64 * 64 / 2),
        0,
        0,
        16,
        16
    },

    {                               // B    G    R
        { 0xFF,0xFF,0xFF,0 },       // 15
        { 0xFF,0xFF,0,   0 },       // 14
        { 0xFF,0,   0xFF,0 },       // 13
        { 0xFF,0,   0,   0 },       // 12
        { 0,   0xFF,0xFF,0 },       // 11
        { 0,   0xFF,0,   0 },       // 10
        { 0,   0,   0xFF,0 },       // 9
        { 0x80,0x80,0x80,0 },       // 8

        { 0xC0,0xC0,0xC0,0 },       // 7
        { 0x80,0x80,0,   0 },       // 6
        { 0x80,0,   0x80,0 },       // 5
        { 0x80,0,   0,   0 },       // 4
        { 0,   0x80,0x80,0 },       // 3
        { 0,   0x80,0,   0 },       // 2
        { 0,   0,   0x80,0 },       // 1
        { 0,   0,   0,   0 }        // 0
    }
};

BITMAPINFOPAT2 bmiPat2 =
{
    {
        sizeof(BITMAPINFOHEADER),
        32,
        32,
        1,
        8,
        BI_RGB,
        32*32,
        0,
        0,
        20,
        20
    },

    {                               // B    G    R
        { 0xFF,0xFF,0xFF,0 },       // 15
        { 0xFF,0xFF,0,   0 },       // 14
        { 0xFF,0,   0xFF,0 },       // 13
        { 0xFF,0,   0,   0 },       // 12
        { 0,   0xFF,0xFF,0 },       // 11
        { 0,   0xFF,0,   0 },       // 10
        { 0,   0,   0xFF,0 },       // 9
        { 0x80,0x80,0x80,0 },       // 8

        { 0xC0,0xC0,0xC0,0 },       // 7
        { 0x80,0x80,0,   0 },       // 6
        { 0x80,0,   0x80,0 },       // 5
        { 0x80,0,   0,   0 },       // 4
        { 0,   0x80,0x80,0 },       // 3
        { 0,   0x80,0,   0 },       // 2
        { 0,   0,   0x80,0 },       // 1
        { 0,   0,   0,   0 },       // 0

        { 0,   0,   0x80,0 },       // 1
        { 0x80,0,   0x80,0 },       // 5
        { 0,   0,   0xFF,0 },       // 9
        { 0xFF,0,   0xFF,0 }        // 13
    }
};

BYTE abColorLines2[32 * 32] =
{
    16,16,16,16,16,16,16,16, 16,16,16,16,16,16,16,16, 16,16,16,16,16,16,16,16, 16,16,16,16,16,16,16,16,
    16,16,16,16,16,16,16,16, 16,16,16,16,16,16,16,16, 16,16,16,16,16,16,16,16, 16,16,16,16,16,16,16,16,
    16,16,16,16,16,16,16,16, 16,16,16,16,16,16,16,16, 16,16,16,16,16,16,16,16, 16,16,16,16,16,16,16,16,
    16,16,16,16,16,16,16,16, 16,16,16,16,16,16,16,16, 16,16,16,16,16,16,16,16, 16,16,16,16,16,16,16,16,
    16,16,16,16,16,16,16,16, 16,16,16,16,16,16,16,16, 16,16,16,16,16,16,16,16, 16,16,16,16,16,16,16,16,
    16,16,16,16,16,16,16,16, 16,16,16,16,16,16,16,16, 16,16,16,16,16,16,16,16, 16,16,16,16,16,16,16,16,
    16,16,16,16,16,16,16,16, 16,16,16,16,16,16,16,16, 16,16,16,16,16,16,16,16, 16,16,16,16,16,16,16,16,
    16,16,16,16,16,16,16,16, 16,16,16,16,16,16,16,16, 16,16,16,16,16,16,16,16, 16,16,16,16,16,16,16,16,

    17,17,17,17,17,17,17,17, 17,17,17,17,17,17,17,17, 17,17,17,17,17,17,17,17, 17,17,17,17,17,17,17,17,
    17,17,17,17,17,17,17,17, 17,17,17,17,17,17,17,17, 17,17,17,17,17,17,17,17, 17,17,17,17,17,17,17,17,
    17,17,17,17,17,17,17,17, 17,17,17,17,17,17,17,17, 17,17,17,17,17,17,17,17, 17,17,17,17,17,17,17,17,
    17,17,17,17,17,17,17,17, 17,17,17,17,17,17,17,17, 17,17,17,17,17,17,17,17, 17,17,17,17,17,17,17,17,
    17,17,17,17,17,17,17,17, 17,17,17,17,17,17,17,17, 17,17,17,17,17,17,17,17, 17,17,17,17,17,17,17,17,
    17,17,17,17,17,17,17,17, 17,17,17,17,17,17,17,17, 17,17,17,17,17,17,17,17, 17,17,17,17,17,17,17,17,
    17,17,17,17,17,17,17,17, 17,17,17,17,17,17,17,17, 17,17,17,17,17,17,17,17, 17,17,17,17,17,17,17,17,
    17,17,17,17,17,17,17,17, 17,17,17,17,17,17,17,17, 17,17,17,17,17,17,17,17, 17,17,17,17,17,17,17,17,

    18,18,18,18,18,18,18,18, 18,18,18,18,18,18,18,18, 18,18,18,18,18,18,18,18, 18,18,18,18,18,18,18,18,
    18,18,18,18,18,18,18,18, 18,18,18,18,18,18,18,18, 18,18,18,18,18,18,18,18, 18,18,18,18,18,18,18,18,
    18,18,18,18,18,18,18,18, 18,18,18,18,18,18,18,18, 18,18,18,18,18,18,18,18, 18,18,18,18,18,18,18,18,
    18,18,18,18,18,18,18,18, 18,18,18,18,18,18,18,18, 18,18,18,18,18,18,18,18, 18,18,18,18,18,18,18,18,
    18,18,18,18,18,18,18,18, 18,18,18,18,18,18,18,18, 18,18,18,18,18,18,18,18, 18,18,18,18,18,18,18,18,
    18,18,18,18,18,18,18,18, 18,18,18,18,18,18,18,18, 18,18,18,18,18,18,18,18, 18,18,18,18,18,18,18,18,
    18,18,18,18,18,18,18,18, 18,18,18,18,18,18,18,18, 18,18,18,18,18,18,18,18, 18,18,18,18,18,18,18,18,
    18,18,18,18,18,18,18,18, 18,18,18,18,18,18,18,18, 18,18,18,18,18,18,18,18, 18,18,18,18,18,18,18,18,

    19,19,19,19,19,19,19,19, 19,19,19,19,19,19,19,19, 19,19,19,19,19,19,19,19, 19,19,19,19,19,19,19,19,
    19,19,19,19,19,19,19,19, 19,19,19,19,19,19,19,19, 19,19,19,19,19,19,19,19, 19,19,19,19,19,19,19,19,
    19,19,19,19,19,19,19,19, 19,19,19,19,19,19,19,19, 19,19,19,19,19,19,19,19, 19,19,19,19,19,19,19,19,
    19,19,19,19,19,19,19,19, 19,19,19,19,19,19,19,19, 19,19,19,19,19,19,19,19, 19,19,19,19,19,19,19,19,
    19,19,19,19,19,19,19,19, 19,19,19,19,19,19,19,19, 19,19,19,19,19,19,19,19, 19,19,19,19,19,19,19,19,
    19,19,19,19,19,19,19,19, 19,19,19,19,19,19,19,19, 19,19,19,19,19,19,19,19, 19,19,19,19,19,19,19,19,
    19,19,19,19,19,19,19,19, 19,19,19,19,19,19,19,19, 19,19,19,19,19,19,19,19, 19,19,19,19,19,19,19,19,
    19,19,19,19,19,19,19,19, 19,19,19,19,19,19,19,19, 19,19,19,19,19,19,19,19, 19,19,19,19,19,19,19,19
};

BYTE abBitCat[] =	 {0xFF, 0xFF, 0xFF, 0xFF,
                          0x80, 0xA2, 0x45, 0x01,
                          0x80, 0xA2, 0x45, 0x01,
                          0x80, 0xA2, 0x45, 0xE1,
                          0x80, 0xA2, 0x45, 0x11,
                          0x80, 0xA2, 0x45, 0x09,
                          0x80, 0x9C, 0x39, 0x09,
                          0x80, 0xC0, 0x03, 0x05,

                          0x80, 0x40, 0x02, 0x05,
                          0x80, 0x40, 0x02, 0x05,
                          0x80, 0x40, 0x02, 0x05,
                          0x80, 0x20, 0x04, 0x05,
                          0x80, 0x20, 0x04, 0x05,
                          0x80, 0x20, 0x04, 0x05,
                          0x80, 0x10, 0x08, 0x05,
                          0x80, 0x10, 0x08, 0x09,

                          0x80, 0x10, 0x08, 0x11,
                          0x80, 0x08, 0x10, 0x21,
                          0x80, 0x08, 0x10, 0xC1,
                          0x80, 0x08, 0x10, 0x09,
                          0x80, 0x07, 0xE0, 0x09,
                          0x80, 0x08, 0x10, 0x09,
                          0x80, 0xFC, 0x3F, 0x09,
                          0x80, 0x09, 0x90, 0x09,

                          0x80, 0xFC, 0x3F, 0x01,
                          0x80, 0x08, 0x10, 0x01,
                          0x80, 0x1A, 0x58, 0x01,
                          0x80, 0x28, 0x14, 0x01,
                          0x80, 0x48, 0x12, 0x01,
                          0x80, 0x8F, 0xF1, 0x01,
                          0x81, 0x04, 0x20, 0x81,
                          0xFF, 0xFF, 0xFF, 0xFF } ;

static BYTE abBigCat[] = {
                          0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                          0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                          0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                          0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                          0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                          0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                          0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                          0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,

                          0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                          0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                          0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                          0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                          0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                          0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                          0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                          0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,

                          0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                          0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                          0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                          0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                          0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                          0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                          0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                          0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,

                          0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                          0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                          0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                          0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                          0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                          0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                          0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
                          0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF};

typedef struct _VGALOGPALETTE
{
    USHORT ident;
    USHORT NumEntries;
    PALETTEENTRY palPalEntry[16];
} VGALOGPALETTE;

VGALOGPALETTE logPalVGA =
{

0x300,  // driver version
16,     // num entries
{
    { 0,   0,   0,   0 },       // 0
    { 0x80,0,   0,   0 },       // 1
    { 0,   0x80,0,   0 },       // 2
    { 0x80,0x80,0,   0 },       // 3
    { 0,   0,   0x80,0 },       // 4
    { 0x80,0,   0x80,0 },       // 5
    { 0,   0x80,0x80,0 },	// 6
    { 0x80,0x80,0x80,0 },	// 7

    { 0xC0,0xC0,0xC0,0 },	// 8
    { 0xFF,0,   0,   0 },       // 9
    { 0,   0xFF,0,   0 },       // 10
    { 0xFF,0xFF,0,   0 },       // 11
    { 0,   0,   0xFF,0 },       // 12
    { 0xFF,0,   0xFF,0 },       // 13
    { 0,   0xFF,0xFF,0 },       // 14
    { 0xFF,0xFF,0xFF,0 }        // 15
}
};

VOID vTestBitmap(HWND hwnd, HDC hdcScreen, RECT* prcl)
{
    HDC hdcClone;
    HBITMAP hbm1Cat, hbm1Cat0, hbm4Lines, hbm4Lines0, hbm8Lines, hbm8Lines0;
    HBITMAP hbm1BigCat, hbm1BigCat0, hbmClone, hbmDefault;
    HDC hdc1Cat, hdc1Cat0, hdc4Lines, hdc4Lines0, hdc8Lines, hdc8Lines0;
    HDC hdc1BigCat, hdc1BigCat0;
    HBRUSH hbrushGreen, hbrDefault, hbrNull;
    HBRUSH hbr1, hbr4, hbr8, hbrHatch, hbrOld;
    HPEN hPen, hPenOld, hPenDefault;
    ULONG ScreenWidth, ScreenHeight;
    HPALETTE hpalVGA, hpalOld;
    ULONG x,ulTemp;
    LOGBRUSH logbrush;
    LOGPEN logpen;

    hwnd = hwnd;
    prcl = prcl;

    hpalVGA = CreatePalette((LOGPALETTE *) &logPalVGA);
    if (hpalVGA == (HPALETTE) 0)
	DbgPrint("ERROR in CreatePalette\n");

    hpalOld = SelectPalette(hdcScreen, hpalVGA, 0);

    if (hpalOld == (HPALETTE) 0)
	DbgPrint("ERROR in CreatePalette1\n");

    RealizePalette(hdcScreen);

    hbrushGreen  = CreateSolidBrush(RGB(0x00,0xff,0x00));

    ScreenWidth  = GetDeviceCaps(hdcScreen, HORZRES);
    ScreenHeight = GetDeviceCaps(hdcScreen, VERTRES);

// We create 6 formats of bitmaps for testing.  2 of each. 1 backup
// so we can refresh after every draw.  The ****0 is the backup.

    hdc1BigCat =   CreateCompatibleDC(hdcScreen);
    hdc1BigCat0 =  CreateCompatibleDC(hdcScreen);
    hdc1Cat  =     CreateCompatibleDC(hdcScreen);
    hdc1Cat0 =     CreateCompatibleDC(hdcScreen);
    hdc4Lines =    CreateCompatibleDC(hdcScreen);
    hdc4Lines0 =   CreateCompatibleDC(hdcScreen);
    hdc8Lines =    CreateCompatibleDC(hdcScreen);
    hdc8Lines0 =   CreateCompatibleDC(hdcScreen);
    hdcClone =     CreateCompatibleDC(hdcScreen);

    if ((hdc1Cat == 0) || (hdcClone == 0) || (hdcScreen == 0))
        DbgPrint("ERROR hdc creation %lu %lu %lu \n", hdcScreen, hdc8Lines0, hdc1Cat);

// Clear the screen

    BitBlt(hdcScreen, 0, 0, ScreenWidth, ScreenHeight, (HDC) 0, 0, 0, WHITENESS);

    bmiPat.bmiHeader.biWidth = 32;

    hbm1Cat = CreateDIBitmap((HDC) 0,
			  (BITMAPINFOHEADER *) &bmiPat,
			  CBM_INIT,
                          abBitCat,
			  (BITMAPINFO *) &bmiPat,
			  DIB_RGB_COLORS);

    if (hbm1Cat == (HBITMAP) 0)
	DbgPrint("Bitmap creation failed\n");

    bmiPat.bmiHeader.biWidth = 128;

    hbm1BigCat = CreateDIBitmap((HDC) 0,
			  (BITMAPINFOHEADER *) &bmiPat,
			  CBM_INIT,
                          abBigCat,
			  (BITMAPINFO *) &bmiPat,
			  DIB_RGB_COLORS);

    if (hbm1BigCat == 0)
	DbgPrint("hbm1BitCat failed\n");

    hbm4Lines = CreateDIBitmap(hdcScreen,
			  (BITMAPINFOHEADER *) &bmiPat1,
			  CBM_INIT | CBM_CREATEDIB,
                          abColorLines,
			  (BITMAPINFO *) &bmiPat1,
			  DIB_RGB_COLORS);

    if (hbm4Lines == 0)
	DbgPrint("hbm4Lines failed\n");

    hbm8Lines = CreateDIBitmap(hdcScreen,
			  (BITMAPINFOHEADER *) &bmiPat2,
			  CBM_INIT | CBM_CREATEDIB,
                          abColorLines2,
			  (BITMAPINFO *) &bmiPat2,
			  DIB_RGB_COLORS);

    if (hbm8Lines == 0)
	DbgPrint("hbm8Lines failed\n");

    hbmDefault = SelectObject(hdc1Cat, hbm1Cat);

    if (hbmDefault == (HBITMAP) 0)
	DbgPrint("hbm Old is invalid\n");

    if (hbmDefault != SelectObject(hdc1BigCat, hbm1BigCat))
	DbgPrint("hbmDefault wrong1\n");

    if (hbmDefault != SelectObject(hdc4Lines, hbm4Lines))
	DbgPrint("hbmDefault wrong2\n");

    if (hbmDefault != SelectObject(hdc8Lines, hbm8Lines))
	DbgPrint("hbmDefault wrong3\n");

    if(!BitBlt(hdcScreen, 0, 200, 32, 32, hdc1Cat, 0, 0, SRCCOPY))
        DbgPrint("ERROR: BitBlt returned FALSE\n");

    if(!BitBlt(hdcScreen, 64, 200, 64, 64, hdc4Lines, 0, 0, SRCCOPY))
        DbgPrint("ERROR: BitBlt returned FALSE\n");

    if(!BitBlt(hdcScreen, 196, 200, 32, 32, hdc8Lines, 0, 0, SRCCOPY))
        DbgPrint("ERROR: BitBlt returned FALSE\n");

    if(!BitBlt(hdcScreen, 0, 264, 128, 32, hdc1BigCat, 0, 0, SRCCOPY))
	DbgPrint("ERROR: BitBlt returned FALSE\n");

// Ok let's throw in some CreateCompatible calls.

    hbm1Cat0 =    CreateCompatibleBitmap(hdc1Cat, 32, 32);
    hbm1BigCat0 = CreateCompatibleBitmap(hdc1BigCat, 128, 32);
    hbm4Lines0 =  CreateCompatibleBitmap(hdc4Lines, 64, 64);
    hbm8Lines0 =  CreateCompatibleBitmap(hdc8Lines, 32, 32);
    hbmClone =	  CreateCompatibleBitmap(hdc8Lines, 320, 320);

    if (hbmDefault != SelectObject(hdc1Cat0, hbm1Cat0))
	DbgPrint("hbmDefault wrong4\n");

    if (hbmDefault != SelectObject(hdc1BigCat0, hbm1BigCat0))
	DbgPrint("hbmDefault wrong5\n");

    if (hbmDefault != SelectObject(hdc4Lines0, hbm4Lines0))
	DbgPrint("hbmDefault wrong6\n");

    if (hbmDefault != SelectObject(hdc8Lines0, hbm8Lines0))
	DbgPrint("hbmDefault wrong7\n");

    if (hbmDefault != SelectObject(hdcClone, hbmClone))
	DbgPrint("hbmDefault wrong8\n");

    hbrDefault = SelectObject(hdcClone, hbrushGreen);
    SelectObject(hdcScreen, hbrushGreen);

    if (hbrDefault == (HBRUSH) 0)
	DbgPrint("ERROR: hbrDefault is invalid\n");

// Really it is blackness.

    PatBlt(hdcClone, 0, 0, 320, 320, WHITENESS);

    if(!BitBlt(hdc1Cat0, 0, 0, 32, 32, hdc1Cat, 0, 0, SRCCOPY))
        DbgPrint("ERROR: BitBlt returned FALSE\n");

    if(!BitBlt(hdc1BigCat0, 0, 0, 128, 32, hdc1BigCat, 0, 0, SRCCOPY))
        DbgPrint("ERROR: BitBlt returned FALSE\n");

    if(!BitBlt(hdc4Lines0, 0, 0, 64, 64, hdc4Lines, 0, 0, SRCCOPY))
        DbgPrint("ERROR: BitBlt returned FALSE\n");

    if(!BitBlt(hdc8Lines0, 0, 0, 32, 32, hdc8Lines, 0, 0, SRCCOPY))
        DbgPrint("ERROR: BitBlt returned FALSE\n");

    BitBlt(hdcClone, 100,100, 64, 64, hdc4Lines, 0, 0, SRCCOPY);

    PatBlt(hdcClone, 0, 0, 100, 100, PATCOPY);

// Ok real quick here let's test if CreateCompatible Bitmap does an
// identity blt to the screen.

    if(!BitBlt(hdcScreen, 32, 200, 32, 32, hdc1Cat0, 0, 0, SRCCOPY))
        DbgPrint("ERROR: BitBlt returned FALSE\n");

    if(!BitBlt(hdcScreen, 128, 200, 64, 64, hdc4Lines0, 0, 0, SRCCOPY))
        DbgPrint("ERROR: BitBlt returned FALSE\n");

    if(!BitBlt(hdcScreen, 228, 200, 32, 32, hdc8Lines0, 0, 0, SRCCOPY))
        DbgPrint("ERROR: BitBlt returned FALSE\n");

    if(!BitBlt(hdcScreen, 128, 264, 128, 32, hdc1BigCat0, 0, 0, SRCCOPY))
        DbgPrint("ERROR: BitBlt returned FALSE\n");

    BitBlt(hdcScreen, 0, 0, 300, 150, hdcClone, 0, 0, SRCCOPY);

    hbr1 = CreatePatternBrush(hbm1Cat);
    hbr4 = CreatePatternBrush(hbm4Lines);
    hbr8 = CreatePatternBrush(hbm8Lines);

    if ((hbr1 == (HBRUSH) NULL) ||
	(hbr4 == (HBRUSH) NULL) ||
	(hbr8 == (HBRUSH) NULL))
    {
	DbgPrint("ERROR hbr1 %lu hbr4 %lu hbr8 %lu \n", hbr1, hbr4, hbr8);
	DbgBreakPoint();
    }

// Test the VGA brushes.

// Test 1 BPP brush

    hbrOld = SelectObject(hdcScreen, hbr1);
    if (hbrOld != hbrushGreen)
	DbgPrint("Error on select of hbr1 for VGA\n");
    PatBlt(hdcScreen, 0, 300, 300, 150, PATCOPY);

// Test 4 BPP brush

    hbrOld = SelectObject(hdcScreen, hbr4);
    if (hbrOld != hbr1)
	DbgPrint("Error on select of hbr4\n");
    PatBlt(hdcScreen, 0, 150, 300, 150, PATCOPY);

// Test 8 BPP brush

    hbrOld = SelectObject(hdcScreen, hbr8);
    if (hbrOld != hbr4)
	DbgPrint("Error on select of hbr8\n");
    PatBlt(hdcScreen, 0, 0, 300, 150, PATCOPY);

// Now test the hatch brush, brush/pen selection, brush/pen deletion.

    SelectObject(hdcScreen, hbrDefault);

    for (x = 0; x < 6; x++)
    {
    // First test brush creation and selection.

	hbrHatch = CreateHatchBrush(x, RGB(0xFF, 0, 0));

	if (hbrHatch == (HBRUSH) NULL)
	{
	    DbgPrint("ERROR hbrHatch loop %lu\n",x);
	}

	hbrOld = SelectObject(hdcScreen, hbrHatch);

	if (hbrOld != hbrDefault)
	    DbgPrint("Error on select of hbrHatch in loop0\n");

	hbrOld = SelectObject(hdcScreen, hbrHatch);

	if (hbrOld != hbrHatch)
	    DbgPrint("Error on select of hbrHatch in loop1\n");

    // Now do some brush output to a bitmap

	PatBlt(hdcScreen, x * 32, x * 20, 50, 50, PATCOPY);

    // Now delete the brush and pen, try to delete the defaults also.

	hbrOld = SelectObject(hdcScreen, hbrDefault);

	if (hbrOld != hbrHatch)
	    DbgPrint("Error on select of hbrDefault in loop11\n");

	if (!DeleteObject(hbrHatch))
	    DbgPrint("Error in loop brush delete\n");
    }

// End of Tests for VGA

// Test 1 BPP brush

    PatBlt(hdcClone, 0, 0, 320, 320, WHITENESS);
    hbrOld = SelectObject(hdcClone, hbr1);
    if (hbrOld != hbrushGreen)
	DbgPrint("Error on select of hbr1 for bitmap\n");
    PatBlt(hdcClone, 0, 0, 300, 150, PATCOPY);
    BitBlt(hdcScreen, 0, 0, 300, 150, hdcClone, 0, 0, SRCCOPY);
    PatBlt(hdcClone, 0, 0, 320, 320, WHITENESS);
    MaskBlt(hdcClone, 0,0,300,150, (HDC) 0, 0, 0, hbm1Cat, 0, 0,
		      0xAAF00000);
    BitBlt(hdcScreen, 300, 0, 300, 150, hdcClone, 0, 0, SRCCOPY);

// Test 4 BPP brush

    PatBlt(hdcClone, 0, 0, 320, 320, WHITENESS);
    hbrOld = SelectObject(hdcClone, hbr4);
    if (hbrOld != hbr1)
	DbgPrint("Error on select of hbr4\n");
    PatBlt(hdcClone, 0, 0,   300, 150, PATCOPY);
    BitBlt(hdcScreen,0, 150, 300, 150, hdcClone, 0, 0, SRCCOPY);
    PatBlt(hdcClone, 0, 0, 320, 320, WHITENESS);
    MaskBlt(hdcClone, 0,0,300,150, (HDC) 0, 0, 0, hbm1Cat, 0, 0,
		      0xAAF00000);
    BitBlt(hdcScreen, 300, 150, 300, 150, hdcClone, 0, 0, SRCCOPY);

// Test 8 BPP brush

    PatBlt(hdcClone, 0, 0, 320, 320, WHITENESS);
    hbrOld = SelectObject(hdcClone, hbr8);
    if (hbrOld != hbr4)
	DbgPrint("Error on select of hbr8\n");
    PatBlt(hdcClone, 0, 0, 300, 150, PATCOPY);
    BitBlt(hdcScreen, 0, 300, 300, 150, hdcClone, 0, 0, SRCCOPY);
    PatBlt(hdcClone, 0, 0, 320, 320, WHITENESS);
    MaskBlt(hdcClone, 0,0,300,150, (HDC) 0, 0, 0, hbm1Cat, 0, 0,
		      0xAAF00000);
    BitBlt(hdcScreen, 300, 300, 300, 150, hdcClone, 0, 0, SRCCOPY);

// Now test the hatch brush, brush/pen selection, brush/pen deletion.

    hPen = CreatePen(PS_NULL, 2, RGB(0, 0xFF, 0));

    if (hPen == (HPEN) NULL)
    {
	DbgPrint("ERROR hpen creation\n");
    }

    hPenDefault = SelectObject(hdcClone, hPen);
    hPenOld = SelectObject(hdcClone, hPenDefault);

    if (hPenOld != hPen)
	DbgPrint("Error on select of hpen in loop1\n");

    if (!DeleteObject(hPen))
	DbgPrint("Failed to delete the hPen 134\n");

    SelectObject(hdcClone, hbrDefault);

    for (x = 0; x < 6; x++)
    {
    // First test brush creation and selection.

	hbrHatch = CreateHatchBrush(x, RGB(0xFF, 0, 0));

	if (hbrHatch == (HBRUSH) NULL)
	{
	    DbgPrint("ERROR hbrHatch loop %lu\n",x);
	}

	hbrOld = SelectObject(hdcClone, hbrHatch);

	if (hbrOld != hbrDefault)
	    DbgPrint("Error on select of hbrHatch in loop0\n");

	hbrOld = SelectObject(hdcClone, hbrHatch);

	if (hbrOld != hbrHatch)
	    DbgPrint("Error on select of hbrHatch in loop1\n");

    // Next test pen creation and selection.

	hPen = CreatePen(PS_SOLID, 2, RGB(0, 0xFF, 0));

	if (hPen == (HPEN) NULL)
	{
	    DbgPrint("ERROR hpen loop %lu\n", x);
	}

	hPenOld = SelectObject(hdcClone, hPen);

	if (hPenOld != hPenDefault)
	    DbgPrint("Error on select of hpen in loop0\n");

	hPenOld = SelectObject(hdcClone, hPen);

	if (hPenOld != hPen)
	    DbgPrint("Error on select of hpen in loop1\n");

    // Make sure GetObject works.

	logbrush.lbStyle = 0;
	logbrush.lbColor = 0;
	logbrush.lbHatch = 0;
	logpen.lopnStyle = 0;
	logpen.lopnWidth.x = 0;
	logpen.lopnColor = 0;

       if (sizeof(LOGBRUSH) != GetObject(hbrHatch, sizeof(LOGBRUSH), &logbrush))
	    DbgPrint("Error return GetObject brush");

	if (logbrush.lbStyle != BS_HATCHED)
	    DbgPrint("ERROR hatched !\n");

	if (logbrush.lbColor != RGB(0xFF, 0, 0))
	    DbgPrint("ERROR color brush\n");

	if (logbrush.lbHatch != x)
	    DbgPrint("ERROR color brush\n");

	ulTemp = GetObject(hPen, sizeof(LOGPEN), &logpen);

	if (sizeof(LOGPEN) != ulTemp)
	    DbgPrint("Error GetObject Pen failed %lu %lu \n", ulTemp, sizeof(LOGPEN));

	if (logpen.lopnStyle != PS_SOLID)
	    DbgPrint("ERROR pen styleadsfd\n");

	if (logpen.lopnWidth.x != 2)
	    DbgPrint("ERROR pen width\n");

	if (logpen.lopnColor != RGB(0, 0xFF, 0))
	    DbgPrint("ERROR wrong pen color\n");

    // Now do some brush output to a bitmap

	PatBlt(hdcClone, 0, 0, 50, 50, PATCOPY);
	BitBlt(hdcScreen, x * 32, x*20, 50, 50, hdcClone, 0, 0, SRCCOPY);

    // Now delete the brush and pen, try to delete the defaults also.

	hbrOld = SelectObject(hdcClone, hbrDefault);
	if (hbrOld != hbrHatch)
	    DbgPrint("Error on select of hbrDefault in loop11\n");

	hPenOld = SelectObject(hdcClone, hPenDefault);
	if (hPenOld != hPen)
	    DbgPrint("Error on select of hpen in loop11\n");

	if (!DeleteObject(hbrHatch))
	    DbgPrint("Error in loop brush delete\n");
	if (!DeleteObject(hbrDefault))
	    DbgPrint("Error in loop brush delete default\n");

	if (!DeleteObject(hPen))
	    DbgPrint("Error in loop pen delete\n");
	if (!DeleteObject(hPenDefault))
	    DbgPrint("Error in loop pen delete default\n");
    }

    hbrNull = GetStockObject(HOLLOW_BRUSH);

    if (hbrNull == (HBRUSH) 0)
	DbgPrint("hbrNull is 0\n");

    logbrush.lbStyle = BS_HOLLOW;

    SelectObject(hdcScreen, hbrNull);

#if 0

// This is what I really want but for now batching always returns TRUE.

    if (FALSE != PatBlt(hdcScreen, 0, 0, 100, 100, PATCOPY))
	DbgPrint("Failed to not fail on Null brush\n");
#endif

    PatBlt(hdcScreen, 0, 0, 400, 400, PATCOPY);

// test for valid brushes.

    if (((HBRUSH) 0) == GetStockObject(BLACK_BRUSH))
	DbgPrint("ERROR GetStockObject brush/pen 1\n");

    SelectObject(hdcScreen, GetStockObject(BLACK_BRUSH));

    PatBlt(hdcScreen, 200, 0, 32, 32, PATCOPY);

    if (((HBRUSH) 0) == GetStockObject(GRAY_BRUSH))
	DbgPrint("ERROR GetStockObject brush/pen 3\n");

    if (GetStockObject(BLACK_BRUSH) != SelectObject(hdcScreen, GetStockObject(GRAY_BRUSH)))
	DbgPrint("Select on Stock object failed\n");

    PatBlt(hdcScreen, 232, 0, 32, 32, PATCOPY);

    if (((HBRUSH) 0) == GetStockObject(LTGRAY_BRUSH))
	DbgPrint("ERROR GetStockObject brush/pen 4\n");

    if (GetStockObject(GRAY_BRUSH) != SelectObject(hdcScreen, GetStockObject(LTGRAY_BRUSH)))
	DbgPrint("Select on Stock object failed\n");

    PatBlt(hdcScreen, 264, 0, 32, 32, PATCOPY);

    if (((HBRUSH) 0) == GetStockObject(WHITE_BRUSH))
	DbgPrint("ERROR GetStockObject brush/pen 2\n");

    if (GetStockObject(LTGRAY_BRUSH) != SelectObject(hdcScreen, GetStockObject(WHITE_BRUSH)))
	DbgPrint("Select on Stock object failed\n");

    PatBlt(hdcScreen, 296, 0, 32, 32, PATCOPY);

    if (((HBRUSH) 0) == GetStockObject(HOLLOW_BRUSH))
	DbgPrint("ERROR GetStockObject brush/pen 5\n");
    if (((HBRUSH) 0) == GetStockObject(NULL_BRUSH))
	DbgPrint("ERROR GetStockObject brush/pen 6\n");

// test for valid pens

    if (((HBRUSH) 0) == GetStockObject(BLACK_PEN))
	DbgPrint("ERROR GetStockObject brush/pen 7\n");
    if (((HBRUSH) 0) == GetStockObject(WHITE_PEN))
	DbgPrint("ERROR GetStockObject brush/pen 8\n");
    if (((HBRUSH) 0) == GetStockObject(NULL_PEN))
	DbgPrint("ERROR GetStockObject brush/pen 9\n");

/*
    DbgPrint("These are the handles %lu %lu %lu\n",
		GetStockObject(BLACK_PEN),
		GetStockObject(WHITE_PEN),
		GetStockObject(NULL_PEN));
*/

    SelectObject(hdcScreen, GetStockObject(BLACK_PEN));

    hPenOld = SelectObject(hdcScreen, GetStockObject(WHITE_PEN));

    if (GetStockObject(BLACK_PEN) != hPenOld)
	DbgPrint("ERROR of select white pen %lu %lu\n",
		       hPenOld, GetStockObject(BLACK_PEN));

    hPenOld = SelectObject(hdcScreen, GetStockObject(NULL_PEN));

    if (GetStockObject(WHITE_PEN) != hPenOld)
	DbgPrint("ERROR of select NULL pen %lu %lu\n",
		       hPenOld, GetStockObject(NULL_PEN));

/*************************************************************************

    Test Solid Brush Output to 8

**************************************************************************/

    SelectObject(hdcScreen, hbrushGreen);
    SelectObject(hdc8Lines, hbrushGreen);

    PatBlt(hdcScreen, 0, 300, 100, 99, PATCOPY);

    PatBlt(hdc8Lines, 0, 0, 9, 8, PATCOPY);

    if(!BitBlt(hdcScreen, 0, 320, 32, 32, hdc8Lines, 0, 0, SRCCOPY))
        DbgPrint("ERROR: BitBlt returned FALSE\n");


    PatBlt(hdc8Lines, 0, 8, 4, 8, PATCOPY);

    if(!BitBlt(hdcScreen, 32, 320, 32, 32, hdc8Lines, 0, 0, SRCCOPY))
        DbgPrint("ERROR: BitBlt returned FALSE\n");


    PatBlt(hdc8Lines, 1, 16, 2, 8, PATCOPY);

    if(!BitBlt(hdcScreen, 64, 320, 32, 32, hdc8Lines, 0, 0, SRCCOPY))
        DbgPrint("ERROR: BitBlt returned FALSE\n");


    PatBlt(hdc8Lines, 2, 24, 4, 8, PATCOPY);

    if(!BitBlt(hdcScreen, 96, 320, 32, 32, hdc8Lines, 0, 0, SRCCOPY))
        DbgPrint("ERROR: BitBlt returned FALSE\n");

    if(!BitBlt(hdc8Lines, 0, 0, 32, 32, hdc8Lines0, 0, 0, SRCCOPY))
        DbgPrint("ERROR: BitBlt returned FALSE\n");

    if(!BitBlt(hdcScreen, 128, 320, 32, 32, hdc8Lines, 0, 0, SRCCOPY))
        DbgPrint("ERROR: BitBlt returned FALSE\n");

/*************************************************************************

    Test Solid Brush Output to 8 generally

**************************************************************************/

    PatBlt(hdc8Lines, 0, 0, 9, 8, 0x00020000);

    if(!BitBlt(hdcScreen, 0, 352, 32, 32, hdc8Lines, 0, 0, SRCCOPY))
        DbgPrint("ERROR: BitBlt returned FALSE\n");


    PatBlt(hdc8Lines, 0, 8, 4, 8, 0x00020000);

    if(!BitBlt(hdcScreen, 32, 352, 32, 32, hdc8Lines, 0, 0, SRCCOPY))
        DbgPrint("ERROR: BitBlt returned FALSE\n");


    PatBlt(hdc8Lines, 1, 16, 2, 8, 0x00020000);

    if(!BitBlt(hdcScreen, 64, 352, 32, 32, hdc8Lines, 0, 0, SRCCOPY))
        DbgPrint("ERROR: BitBlt returned FALSE\n");


    PatBlt(hdc8Lines, 2, 24, 4, 8, 0x00020000);

    if(!BitBlt(hdcScreen, 96, 352, 32, 32, hdc8Lines, 0, 0, SRCCOPY))
        DbgPrint("ERROR: BitBlt returned FALSE\n");


    if(!BitBlt(hdc8Lines, 0, 0, 32, 32, hdc8Lines0, 0, 0, SRCCOPY))
        DbgPrint("ERROR: BitBlt returned FALSE\n");

    if(!BitBlt(hdcScreen, 128, 352, 32, 32, hdc8Lines, 0, 0, SRCCOPY))
        DbgPrint("ERROR: BitBlt returned FALSE\n");

/*********************************************************************

    8 on 8 tests

***********************************************************************/

    if(!BitBlt(hdc8Lines, 8, 16, 8, 8, hdc8Lines0, 16, 0, SRCCOPY))
        DbgPrint("ERROR: BitBlt returned FALSE\n");

    if(!BitBlt(hdcScreen, 0, 256, 32, 32, hdc8Lines, 0, 0, SRCCOPY))
        DbgPrint("ERROR: BitBlt returned FALSE\n");

    if(!BitBlt(hdc8Lines, 24, 24, 8, 8, hdc8Lines, 16, 16, SRCCOPY))
        DbgPrint("ERROR: BitBlt returned FALSE\n");

    if(!BitBlt(hdcScreen, 32, 256, 32, 32, hdc8Lines, 0, 0, SRCCOPY))
        DbgPrint("ERROR: BitBlt returned FALSE\n");

    if(!BitBlt(hdc8Lines, 0, 24, 8, 8, hdc8Lines, 16, 16, SRCCOPY))
        DbgPrint("ERROR: BitBlt returned FALSE\n");

    if(!BitBlt(hdcScreen, 64, 256, 32, 32, hdc8Lines, 0, 0, SRCCOPY))
        DbgPrint("ERROR: BitBlt returned FALSE\n");

    if(!BitBlt(hdc8Lines, 24, 0, 8, 8, hdc8Lines, 16, 16, SRCCOPY))
        DbgPrint("ERROR: BitBlt returned FALSE\n");

    if(!BitBlt(hdcScreen, 96, 256, 32, 32, hdc8Lines, 0, 0, SRCCOPY))
        DbgPrint("ERROR: BitBlt returned FALSE\n");

    if(!BitBlt(hdc8Lines, 0, 0, 8, 8, hdc8Lines, 16, 16, SRCCOPY))
        DbgPrint("ERROR: BitBlt returned FALSE\n");

    if(!BitBlt(hdc8Lines, 16, 16, 8, 8, hdc8Lines, 16, 16, SRCCOPY))
        DbgPrint("ERROR: BitBlt returned FALSE\n");

    if(!BitBlt(hdcScreen, 128, 256, 32, 32, hdc8Lines, 0, 0, SRCCOPY))
        DbgPrint("ERROR: BitBlt returned FALSE\n");

    if(!BitBlt(hdc8Lines, 0, 0, 32, 32, hdc8Lines0, 0, 0, SRCCOPY))
        DbgPrint("ERROR: BitBlt returned FALSE\n");

    if(!BitBlt(hdcScreen, 160, 256, 32, 32, hdc8Lines, 0, 0, SRCCOPY))
        DbgPrint("ERROR: BitBlt returned FALSE\n");

/*********************************************************************

    8 on 8 generally

***********************************************************************/

    if(!BitBlt(hdc8Lines, 8, 16, 8, 8, hdc8Lines0, 16, 0, 0x00010000))
        DbgPrint("ERROR: BitBlt returned FALSE\n");

    if(!BitBlt(hdcScreen, 0, 288, 32, 32, hdc8Lines, 0, 0, SRCCOPY))
        DbgPrint("ERROR: BitBlt returned FALSE\n");

    if(!BitBlt(hdc8Lines, 24, 24, 8, 8, hdc8Lines, 16, 16, 0x00010000))
        DbgPrint("ERROR: BitBlt returned FALSE\n");

    if(!BitBlt(hdcScreen, 32, 288, 32, 32, hdc8Lines, 0, 0, SRCCOPY))
        DbgPrint("ERROR: BitBlt returned FALSE\n");

    if(!BitBlt(hdc8Lines, 0, 24, 8, 8, hdc8Lines, 16, 16, 0x00010000))
        DbgPrint("ERROR: BitBlt returned FALSE\n");

    if(!BitBlt(hdcScreen, 64, 288, 32, 32, hdc8Lines, 0, 0, SRCCOPY))
        DbgPrint("ERROR: BitBlt returned FALSE\n");

    if(!BitBlt(hdc8Lines, 24, 0, 8, 8, hdc8Lines, 16, 16, 0x00010000))
        DbgPrint("ERROR: BitBlt returned FALSE\n");

    if(!BitBlt(hdcScreen, 96, 288, 32, 32, hdc8Lines, 0, 0, SRCCOPY))
        DbgPrint("ERROR: BitBlt returned FALSE\n");

    if(!BitBlt(hdc8Lines, 0, 0, 8, 8, hdc8Lines, 16, 16, 0x00010000))
        DbgPrint("ERROR: BitBlt returned FALSE\n");

    if(!BitBlt(hdc8Lines, 16, 16, 8, 8, hdc8Lines, 16, 16, 0x00010000))
        DbgPrint("ERROR: BitBlt returned FALSE\n");

    if(!BitBlt(hdcScreen, 128, 288, 32, 32, hdc8Lines, 0, 0, SRCCOPY))
        DbgPrint("ERROR: BitBlt returned FALSE\n");

    if(!BitBlt(hdc8Lines, 0, 0, 32, 32, hdc8Lines0, 0, 0, 0x00010000))
        DbgPrint("ERROR: BitBlt returned FALSE\n");

    if(!BitBlt(hdcScreen, 160, 288, 32, 32, hdc8Lines, 0, 0, SRCCOPY))
        DbgPrint("ERROR: BitBlt returned FALSE\n");

/************************************************************************

    Test 1 to 8 blting

*************************************************************************/

    if(!BitBlt(hdc8Lines, 4,4, 16, 16, hdc1Cat, 4, 4, SRCCOPY))
        DbgPrint("ERROR: BitBlt returned FALSE\n");

    if(!BitBlt(hdcScreen, 0, 0, 32, 32, hdc8Lines, 0, 0, SRCCOPY))
        DbgPrint("ERROR: BitBlt returned FALSE\n");

    if(!BitBlt(hdc8Lines, 4, 4, 17, 17, hdc1Cat, 4, 4, SRCCOPY))
        DbgPrint("ERROR: BitBlt returned FALSE\n");

    if(!BitBlt(hdcScreen, 32, 0, 32, 32, hdc8Lines, 0, 0, SRCCOPY))
        DbgPrint("ERROR: BitBlt returned FALSE\n");


    if(!BitBlt(hdc8Lines, 3, 3, 25, 25, hdc1Cat, 3, 3, SRCCOPY))
        DbgPrint("ERROR: BitBlt returned FALSE\n");

    if(!BitBlt(hdcScreen, 64, 0, 32, 32, hdc8Lines, 0, 0, SRCCOPY))
        DbgPrint("ERROR: BitBlt returned FALSE\n");


    if(!BitBlt(hdc8Lines, 3, 3, 26, 26, hdc1Cat, 0, 0, SRCCOPY))
        DbgPrint("ERROR: BitBlt returned FALSE\n");

    if(!BitBlt(hdcScreen, 96, 0, 32, 32, hdc8Lines, 0, 0, SRCCOPY))
        DbgPrint("ERROR: BitBlt returned FALSE\n");


    if(!BitBlt(hdc8Lines, 0, 0, 32, 32, hdc8Lines0, 0, 0, SRCCOPY))
        DbgPrint("ERROR: BitBlt returned FALSE\n");

    if(!BitBlt(hdcScreen, 128, 0, 32, 32, hdc8Lines0, 0, 0, SRCCOPY))
        DbgPrint("ERROR: BitBlt returned FALSE\n");

/************************************************************************

    Test 1 to 8 blting generally

*************************************************************************/

    if(!BitBlt(hdc8Lines, 4,4, 16, 16, hdc1Cat, 4, 4, 0x00010000))
        DbgPrint("ERROR: BitBlt returned FALSE\n");

    if(!BitBlt(hdcScreen, 0, 32, 32, 32, hdc8Lines, 0, 0, SRCCOPY))
        DbgPrint("ERROR: BitBlt returned FALSE\n");


    if(!BitBlt(hdc8Lines, 4, 4, 17, 17, hdc1Cat, 4, 4, 0x00010000))
        DbgPrint("ERROR: BitBlt returned FALSE\n");

    if(!BitBlt(hdcScreen, 32, 32, 32, 32, hdc8Lines, 0, 0, SRCCOPY))
        DbgPrint("ERROR: BitBlt returned FALSE\n");


    if(!BitBlt(hdc8Lines, 3, 3, 25, 25, hdc1Cat, 3, 3, 0x00010000))
        DbgPrint("ERROR: BitBlt returned FALSE\n");

    if(!BitBlt(hdcScreen, 64, 32, 32, 32, hdc8Lines, 0, 0, SRCCOPY))
        DbgPrint("ERROR: BitBlt returned FALSE\n");


    if(!BitBlt(hdc8Lines, 3, 3, 26, 26, hdc1Cat, 0, 0, 0x00010000))
        DbgPrint("ERROR: BitBlt returned FALSE\n");

    if(!BitBlt(hdcScreen, 96, 32, 32, 32, hdc8Lines, 0, 0, SRCCOPY))
        DbgPrint("ERROR: BitBlt returned FALSE\n");


    if(!BitBlt(hdc8Lines, 0, 0, 32, 32, hdc8Lines0, 0, 0, 0x00010000))
        DbgPrint("ERROR: BitBlt returned FALSE\n");

    if(!BitBlt(hdcScreen, 128, 32, 32, 32, hdc8Lines0, 0, 0, SRCCOPY))
        DbgPrint("ERROR: BitBlt returned FALSE\n");

/*************************************************************************

    Test 4 to 8 blting

**************************************************************************/

    if(!BitBlt(hdc8Lines, 4,4, 16, 16, hdc4Lines, 4, 4, SRCCOPY))
        DbgPrint("ERROR: BitBlt returned FALSE\n");

    if(!BitBlt(hdcScreen, 0, 288, 32, 32, hdc8Lines, 0, 0, SRCCOPY))
        DbgPrint("ERROR: BitBlt returned FALSE\n");


    if(!BitBlt(hdc8Lines, 4, 4, 17, 17, hdc4Lines, 4, 4, SRCCOPY))
        DbgPrint("ERROR: BitBlt returned FALSE\n");

    if(!BitBlt(hdcScreen, 32, 288, 32, 32, hdc8Lines, 0, 0, SRCCOPY))
        DbgPrint("ERROR: BitBlt returned FALSE\n");


    if(!BitBlt(hdc8Lines, 3, 3, 25, 25, hdc4Lines, 3, 3, SRCCOPY))
        DbgPrint("ERROR: BitBlt returned FALSE\n");

    if(!BitBlt(hdcScreen, 64, 288, 32, 32, hdc8Lines, 0, 0, SRCCOPY))
        DbgPrint("ERROR: BitBlt returned FALSE\n");


    if(!BitBlt(hdc8Lines, 3, 3, 26, 26, hdc4Lines, 0, 0, SRCCOPY))
        DbgPrint("ERROR: BitBlt returned FALSE\n");

    if(!BitBlt(hdcScreen, 96, 288, 32, 32, hdc8Lines, 0, 0, SRCCOPY))
        DbgPrint("ERROR: BitBlt returned FALSE\n");


    if(!BitBlt(hdc8Lines, 0, 0, 32, 32, hdc8Lines0, 0, 0, SRCCOPY))
        DbgPrint("ERROR: BitBlt returned FALSE\n");

    if(!BitBlt(hdcScreen, 128, 288, 32, 32, hdc8Lines0, 0, 0, SRCCOPY))
        DbgPrint("ERROR: BitBlt returned FALSE\n");

/*************************************************************************

    Test 4 to 8 blting generally.

**************************************************************************/

    if(!BitBlt(hdc8Lines, 4,4, 16, 16, hdc4Lines, 4, 4, 0x00010000))
        DbgPrint("ERROR: BitBlt returned FALSE\n");

    if(!BitBlt(hdcScreen, 0, 320, 32, 32, hdc8Lines, 0, 0, SRCCOPY))
        DbgPrint("ERROR: BitBlt returned FALSE\n");


    if(!BitBlt(hdc8Lines, 4, 4, 17, 17, hdc4Lines, 4, 4, 0x00010000))
        DbgPrint("ERROR: BitBlt returned FALSE\n");

    if(!BitBlt(hdcScreen, 32, 320, 32, 32, hdc8Lines, 0, 0, SRCCOPY))
        DbgPrint("ERROR: BitBlt returned FALSE\n");


    if(!BitBlt(hdc8Lines, 3, 3, 25, 25, hdc4Lines, 3, 3, 0x00010000))
        DbgPrint("ERROR: BitBlt returned FALSE\n");

    if(!BitBlt(hdcScreen, 64, 320, 32, 32, hdc8Lines, 0, 0, SRCCOPY))
        DbgPrint("ERROR: BitBlt returned FALSE\n");


    if(!BitBlt(hdc8Lines, 3, 3, 26, 26, hdc4Lines, 0, 0, 0x00010000))
        DbgPrint("ERROR: BitBlt returned FALSE\n");

    if(!BitBlt(hdcScreen, 96, 320, 32, 32, hdc8Lines, 0, 0, SRCCOPY))
        DbgPrint("ERROR: BitBlt returned FALSE\n");


    if(!BitBlt(hdc8Lines, 0, 0, 32, 32, hdc8Lines0, 0, 0, 0x00010000))
        DbgPrint("ERROR: BitBlt returned FALSE\n");

    if(!BitBlt(hdcScreen, 128, 320, 32, 32, hdc8Lines0, 0, 0, SRCCOPY))
        DbgPrint("ERROR: BitBlt returned FALSE\n");

/*********************************************************************

    MaskBlt solid brush on 8 tests

***********************************************************************/

    PatBlt(hdcClone, 0, 0, 320, 320, WHITENESS);

    MaskBlt(hdcClone, 32, 32, 32, 32, hdc8Lines, 0, 0, hbm1Cat, 0, 0,
		      0xAACC0000);

    BitBlt(hdcScreen, 0, 0, 66, 66, hdcClone, 0, 0, SRCCOPY);

    if(!BitBlt(hdcScreen, 0, 400, 32, 32, hdc1Cat, 0, 0, SRCCOPY))
	DbgPrint("ERROR: BitBlt returned FALSE\n");

// Clean up time, delete it all.

    if (SelectPalette(hdcScreen, hpalOld, 0) != hpalVGA)
	DbgPrint("hpalVGA not given back\n");

    if (!DeleteObject(hpalVGA))
	DbgPrint("failed to delete hpalVGA\n");

    if (hbmClone != SelectObject(hdcClone, hbmDefault))
	DbgPrint("Cleanup hbm 1 wrong\n");
    if (hbm1Cat != SelectObject(hdc1Cat, hbmDefault))
	DbgPrint("Cleanup hbm 2 wrong\n");
    if (hbm1Cat0 != SelectObject(hdc1Cat0, hbmDefault))
	DbgPrint("Cleanup hbm 3 wrong\n");
    if (hbm4Lines != SelectObject(hdc4Lines, hbmDefault))
	DbgPrint("Cleanup hbm 4 wrong\n");
    if (hbm4Lines0 != SelectObject(hdc4Lines0, hbmDefault))
	DbgPrint("Cleanup hbm 5 wrong\n");
    if (hbm8Lines != SelectObject(hdc8Lines, hbmDefault))
	DbgPrint("Cleanup hbm 6 wrong\n");
    if (hbm8Lines0 != SelectObject(hdc8Lines0, hbmDefault))
	DbgPrint("Cleanup hbm 7 wrong\n");
    if (hbm1BigCat != SelectObject(hdc1BigCat, hbmDefault))
	DbgPrint("Cleanup hbm 8 wrong\n");
    if (hbm1BigCat0 != SelectObject(hdc1BigCat0, hbmDefault))
	DbgPrint("Cleanup hbm 9 wrong\n");

    SelectObject(hdc1Cat,hbrDefault);
    SelectObject(hdc1Cat0,hbrDefault);
    SelectObject(hdc4Lines,hbrDefault);
    SelectObject(hdc4Lines0,hbrDefault);
    SelectObject(hdc8Lines,hbrDefault);
    SelectObject(hdc8Lines0,hbrDefault);
    SelectObject(hdc1BigCat,hbrDefault);
    SelectObject(hdc1BigCat0,hbrDefault);
    SelectObject(hdcClone,hbrDefault);
    SelectObject(hdcScreen,hbrDefault);

// Delete DC's

    if (!DeleteDC(hdc1BigCat))
	DbgPrint("Failed to delete hdc 1\n");
    if (!DeleteDC(hdc1BigCat0))
	DbgPrint("Failed to delete hdc 2\n");
    if (!DeleteDC(hdc1Cat))
	DbgPrint("Failed to delete hdc 3\n");
    if (!DeleteDC(hdc1Cat0))
	DbgPrint("Failed to delete hdc 4\n");
    if (!DeleteDC(hdc4Lines))
	DbgPrint("Failed to delete hdc 5\n");
    if (!DeleteDC(hdc4Lines0))
	DbgPrint("Failed to delete hdc 6\n");
    if (!DeleteDC(hdc8Lines))
	DbgPrint("Failed to delete hdc 7\n");
    if (!DeleteDC(hdc8Lines0))
	DbgPrint("Failed to delete hdc 8\n");
    if (!DeleteDC(hdcClone))
	DbgPrint("Failed to delete hdc 9\n");

// Delete Bitmaps

    if (!DeleteObject(hbm1Cat))
	DbgPrint("ERROR failed to delete 1\n");
    if (!DeleteObject(hbm1Cat0))
	DbgPrint("ERROR failed to delete 2\n");
    if (!DeleteObject(hbm4Lines))
	DbgPrint("ERROR failed to delete 3\n");
    if (!DeleteObject(hbm4Lines0))
	DbgPrint("ERROR failed to delete 4\n");
    if (!DeleteObject(hbm8Lines))
	DbgPrint("ERROR failed to delete 5\n");
    if (!DeleteObject(hbm8Lines0))
	DbgPrint("ERROR failed to delete 6\n");
    if (!DeleteObject(hbm1BigCat))
	DbgPrint("ERROR failed to delete 7\n");
    if (!DeleteObject(hbm1BigCat0))
	DbgPrint("ERROR failed to delete 8\n");
    if (!DeleteObject(hbmClone))
	DbgPrint("ERROR failed to delete 9\n");

    if (!DeleteObject(hbmDefault))
	DbgPrint("ERROR deleted default bitmap\n");

// Delete the brushes

    if (!DeleteObject(hbr1))
	DbgPrint("failed to delete pattern brush 1\n");

    if (!DeleteObject(hbr4))
	DbgPrint("failed to delete pattern brush 2\n");

    if (!DeleteObject(hbr8))
	DbgPrint("failed to delete pattern brush 3\n");

    if (!DeleteObject(hbrushGreen))
	DbgPrint("failed to delete pattern brush 4\n");
}
