/*++

Copyright (c) 1992  Microsoft Corporation

Module Name:

    ScOpen.h

Abstract:

    Contains data structures used for Service Controller Handles.
    Also some closely-related prototypes.

Author:

    Dan Lafferty (danl)     20-Jan-1992

Environment:

    User Mode -Win32

Revision History:

    20-Jan-1992     danl
        created
    11-Mar-1992     ritaw
        changed context handle structure
    10-Apr-1992 JohnRo
        Added ScIsValidServiceHandle() and ScCreateServiceHandle().
    15-Apr-1992 JohnRo
        Added ScIsValidScManagerHandle().

--*/


#ifndef SCOPEN_H
#define SCOPEN_H


#include <svcctl.h>     // MIDL generated header file. (SC_RPC_HANDLE)


//
// Signature value in handle
//
#define SC_SIGNATURE               0x6E4F6373  // "scOn" in ASCII.
#define SERVICE_SIGNATURE          0x76724573  // "sErv" in ASCII.

//
// Data associated with each opened context handle
//
typedef struct  _SC_HANDLE_STRUCT{

    DWORD Signature;     // For block identification to detect some app errors
    DWORD AccessGranted; // Access granted to client.
    union {              // Object specific data

        struct {
            LPWSTR DatabaseName;            // Name of database opened
        } ScManagerObject;

        struct {
            LPSERVICE_RECORD ServiceRecord; // Pointer to service record
        } ScServiceObject;

    } Type;

} SC_HANDLE_STRUCT, *LPSC_HANDLE_STRUCT;


//
// FUNCTION PROTOTYPES
//

DWORD
ScCreateServiceHandle(
    IN  LPSERVICE_RECORD ServiceRecord,
    OUT LPSC_HANDLE_STRUCT *ContextHandle
    );

BOOL
ScIsValidScManagerHandle(
    IN  SC_RPC_HANDLE   hScManager
    );

BOOL
ScIsValidServiceHandle(
    IN  SC_RPC_HANDLE   hService
    );


#endif // SCOPEN_H
