/***********************************************************************
* Microsoft Jet
*
* Microsoft Confidential.  Copyright 1991-1992 Microsoft Corporation.
*
* Component:
*
* File: util.c
*
* File Comments:
*
* Revision History:
*
*    [0]  05-Jan-92  richards	Added this header
*
***********************************************************************/

#include "std.h"

#include <string.h>		       /* For memset() */

#ifndef RETAIL
#ifndef DOS
#include <stdarg.h>
#endif	/* !DOS */
#endif	/* !RETAIL */

DeclAssertFile;


static CODECONST(unsigned char) rgbValidName[16] = {
	0xff,			       /* 00-07 No control characters */
	0xff,			       /* 08-0F No control characters */
	0xff,			       /* 10-17 No control characters */
	0xff,			       /* 18-1F No control characters */
	0x02,			       /* 20-27 No ! */
	0x40,			       /* 28-2F No . */
	0x00,			       /* 30-37 */
	0x00,			       /* 38-3F */
	0x00,			       /* 40-47 */
	0x00,			       /* 48-4F */
	0x00,			       /* 50-57 */
	0x28,			       /* 58-5F No [ or ] */
	0x00,			       /* 60-67 */
	0x00,			       /* 68-6F */
	0x00,			       /* 70-77 */
	0x00,			       /* 78-7F */
	};


PUBLIC unsigned EXPORT CchValidateName(char __far *pchName, const char __far *lpchName, unsigned cchName)
{
   char __far	  *pch;
   unsigned	  cch;
   char __far	  *pchLast;
   unsigned char  ch;

   if (*lpchName == ' ')	       /* A name may not begin with a space */
      return(0);

   pch = pchName;
   cch = 0;

   pchLast = pchName;		       /* To detect zero length names */

   while (((ch = (unsigned char) *lpchName++) != '\0') && (cch < cchName))
   {
      /* The name too long check is inside the loop to prevent */
      /* overflowing the output buffer which is only JET_cbNameMost */
      /* characters long.  This means than insignificant trailing */
      /* spaces will trigger an error. */

      if (++cch > JET_cbNameMost)	       /* Name too long */
	 return(0);

#ifndef ANSIAPI
      ch = mpchOemchAnsi[ch];
#endif	/* !ANSIAPI */

      if (ch < 0x80)		       /* Extended characters always valid */
      {
	 if ((rgbValidName[ch >> 3] >> (ch & 0x7)) & 1)
	    return(0);
      }

      *pch++ = (char) ch;

      if (ch != ' ')
	 pchLast = pch; 	       /* Last significant character */
   }

   cch = pchLast - pchName;	       /* Length of significant portion */

   return(cch);
}


#ifdef	PARAMFILL

PUBLIC void EXPORT FillClientBuffer(void __far *pv, unsigned long cb)
{
   if ( pv != NULL )
      memset(pv, 0x52, (size_t) cb);
}			 

#endif	/* PARAMFILL */


#ifndef RETAIL

#ifndef DOS

typedef void (__far *PFNvprintf)(const char __far *, va_list);

struct {
   PFNvprintf pfnvprintf;
} __near pfn = { NULL };


PUBLIC void VARARG DebugPrintf(const char __far *szFmt, ...)
{
   va_list arg_ptr;

   if (pfn.pfnvprintf == NULL)	       /* No op if no callback registered */
      return;

   va_start(arg_ptr, szFmt);
   (*pfn.pfnvprintf)(szFmt, arg_ptr);
   va_end(arg_ptr);
}


	/* The following pragma affects the code generated by the C */
	/* compiler for all FAR functions.  Do NOT place any non-API */
	/* functions beyond this point in this file. */

void JET_API __export JetDBGSetPrintFn(JET_SESID sesid, PFNvprintf pfnParm)
{
   AssertValidSesid(sesid);

   pfn.pfnvprintf = pfnParm;
}


#endif	/* !DOS */

#endif	/* !RETAIL */
