//
// gssessio.cpp : implementation file
//

#include "stdafx.h"

#include "gscfg.h"
#include "gssessio.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

//
// CGopherSessionsPage dialog
//
IMPLEMENT_DYNCREATE(CGopherSessionsPage, INetPropertyPage)

CGopherSessionsPage::CGopherSessionsPage(
    INetPropertySheet * pSheet
    )
    : INetPropertyPage(CGopherSessionsPage::IDD, pSheet, 
        ::GetModuleHandle(GSCFG_DLL_NAME)),
      m_fRegisterChange(FALSE)
{
#ifdef _DEBUG
    afxMemDF |= checkAlwaysMemDF;
#endif // _DEBUG

#if 0 // Keep class wizard happy
    //{{AFX_DATA_INIT(CGopherSessionsPage)
    m_strPassword = _T("");
    m_strUserName = _T("");
    //}}AFX_DATA_INIT

    m_nMaxConnections = 50;
    m_nConnectionTimeOut = 600;

#else

    if ( SingleServerSelected()
        && QueryConfigError() == NO_ERROR )
    {
        m_strUserName = GetInetConfigData()->lpszAnonUserName;
        m_strPassword = GetInetConfigData()->szAnonPassword;
        m_nMaxConnections = GetInetConfigData()->dwMaxConnections;
        m_nConnectionTimeOut = GetInetConfigData()->dwConnectionTimeout;
    }

#endif // 0
}

void
CGopherSessionsPage::DoDataExchange(
    CDataExchange* pDX
    )
{
    INetPropertyPage::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CGopherSessionsPage)
    DDX_Control(pDX, IDC_SPIN_MAX_CONNECTIONS, m_spin_MaxConnections);
    DDX_Control(pDX, IDC_SPIN_CONNECTION_TIMEOUT, m_spin_ConnectionTimeOut);
    DDX_Text(pDX, IDC_EDIT_PASSWORD, m_strPassword);
    DDV_MaxChars(pDX, m_strPassword, 256);
    DDX_Text(pDX, IDC_EDIT_USERNAME, m_strUserName);
    //}}AFX_DATA_MAP

    if (pDX->m_bSaveAndValidate)
    {
        m_nMaxConnections = m_spin_MaxConnections.GetPos();
        m_nConnectionTimeOut = m_spin_ConnectionTimeOut.GetPos();
    }
}


BEGIN_MESSAGE_MAP(CGopherSessionsPage, INetPropertyPage)
    //{{AFX_MSG_MAP(CGopherSessionsPage)
    //}}AFX_MSG_MAP

    ON_EN_CHANGE(IDC_EDIT_CONNECTION_TIMEOUT, OnItemChanged)
    ON_EN_CHANGE(IDC_EDIT_MAX_CONNECTIONS, OnItemChanged)
    ON_EN_CHANGE(IDC_EDIT_PASSWORD, OnItemChanged)
    ON_EN_CHANGE(IDC_EDIT_USERNAME, OnItemChanged)

END_MESSAGE_MAP()


//
// CGopherSessionsPage message handlers
//
BOOL
CGopherSessionsPage::OnInitDialog()
{
    INetPropertyPage::OnInitDialog();

    m_fRegisterChange = FALSE;
    m_spin_MaxConnections.SetRange(0, UD_MAXVAL);
    m_spin_ConnectionTimeOut.SetRange(0, UD_MAXVAL);

    m_spin_MaxConnections.SetPos(m_nMaxConnections );
    m_spin_ConnectionTimeOut.SetPos(m_nConnectionTimeOut);
    m_fRegisterChange = TRUE;

    return TRUE;  // return TRUE unless you set the focus to a control
                  // EXCEPTION: OCX Property Pages should return FALSE
}

NET_API_STATUS
CGopherSessionsPage::SaveInfo(
    BOOL fUpdateData
    )
{
    if (!IsDirty() || (fUpdateData && !UpdateData(TRUE)))
    {
        return NO_ERROR;
    }

    TRACEEOLID(_T("Saving Gopher sessions page now..."));

    NET_API_STATUS err = 0;

    LPTSTR lpszAnonUserName = new TCHAR[m_strUserName.GetLength()+1];
    ::_tcscpy(lpszAnonUserName, m_strUserName);

    CInetAConfigInfo config(GetConfig());
    config.SetValues(
        m_nMaxConnections,
        m_nConnectionTimeOut,
        lpszAnonUserName,
        m_strPassword
        );

    err = config.SetInfo(FALSE);

    delete lpszAnonUserName;

    SetModified(FALSE);

    return err;
}

//
// All EN_CHANGE and BN_CLICKED messages map to
// this function.
//
void
CGopherSessionsPage::OnItemChanged()
{
    if (m_fRegisterChange)
    {
        SetModified(TRUE);
    }
}

