// header for the W3Service object

#define KEYSET_LIST				L"W3_KEY_LIST"
#define KEYSET_PUB_KEY			L"W3_PUBLIC_KEY_%s"
#define KEYSET_PRIV_KEY			L"W3_PRIVATE_KEY_%s"
#define KEYSET_PASSWORD			L"W3_KEY_PASSWORD_%s"
#define KEYSET_DEFAULT			L"Default"

#define	KEY_NAME_BASE			"W3_KEYMAN_KEY_"
#define	KEY_LINKS_SECRET_W		L"W3_KEYMAN_LINKS"
#define	KEYMAN_LINK_DEFAULT		"DEFAULT"

void	DisposeLSAData( PVOID pData );

//--------------------------------------------------------
class CW3KeyService : public CService
	{
	public:
		CW3KeyService();
		~CW3KeyService();
		void LoadKeys( CMachine* pMachine );
		BOOL FCommitChangesNow();

		// create a new key.
		CKey* PNewKey() {return (CKey*)new CW3Key;}

		// get the key on this machine that is set to be the default key
		CW3Key* PGetDefaultKey( void );

		// cached wide machine name
		WCHAR*		m_pszwMachineName;

	protected:
		// initialize basic stuff from machine - must be called from sub-class
		BOOL FInitMachine( void );

		// restore all the keys that are stored on the target machine
		BOOL FRestoreNormalKeys( HANDLE hPolicy );

		// restore a key that was generated by keyset
		BOOL FLoadKeySetKeys( HANDLE hPolicy );

		// store out all the keys to the target machine
		BOOL FWriteOutKeys( HANDLE hPolicy );

		// delete existing keys that the W3 server references (keyset style keys)
		BOOL DeleteAllW3Keys( HANDLE hPolicy );

		// a smarter secret write error box
		void WriteSecretMessageBox( void );

		// helpful utilities for scanning the
		// keys contained by a service object
		CW3Key* GetFirstW3Key()
			{ return (CW3Key*)GetFirstChild(); }
		CW3Key* GetNextW3Key( CW3Key* pKey )
			{ return (CW3Key*)GetNextChild(pKey); }

	private:
		// number of keys READ from the normal secrets
		long	m_nNumKeysRead;

		BOOL	FExpandoHandle( HANDLE* ph, PVOID pData, DWORD cbData );
	};


