/**********************************************************************/
/**			  Microsoft LAN Manager 		     **/
/**		   Copyright(c) Microsoft Corp., 1991		     **/
/**********************************************************************/

/*
    PermStr.hxx

    This file contains the string IDs for the resource strings required by
    the security editor.



    FILE HISTORY:
	Johnl	13-Aug-1991	Created

*/

#ifndef _PERMSTR_HXX_
#define _PERMSTR_HXX_

#include <uimsg.h>

#define BMID_SECURITY_TOOLBAR		   3005

/* LM General permission string IDs
 */
#define    IDS_LM_PERMSTRING_NAMES_BASE    IDS_UI_ACLEDIT_BASE

#define    IDS_GEN_LM_ACCESSNAME_DENY_ALL  (IDS_LM_PERMSTRING_NAMES_BASE+1)
#define    IDS_GEN_LM_ACCESSNAME_SEE_USE   (IDS_LM_PERMSTRING_NAMES_BASE+2)
#define    IDS_GEN_LM_ACCESSNAME_CHANGES   (IDS_LM_PERMSTRING_NAMES_BASE+3)
#define    IDS_GEN_LM_ACCESSNAME_FULL	   (IDS_LM_PERMSTRING_NAMES_BASE+4)

/* LM Special permission string IDs
 */
#define    IDS_LM_ACCESSNAME_READ	   (IDS_LM_PERMSTRING_NAMES_BASE+5)
#define    IDS_LM_ACCESSNAME_WRITE	   (IDS_LM_PERMSTRING_NAMES_BASE+6)
#define    IDS_LM_ACCESSNAME_CREATE	   (IDS_LM_PERMSTRING_NAMES_BASE+7)
#define    IDS_LM_ACCESSNAME_EXEC	   (IDS_LM_PERMSTRING_NAMES_BASE+8)
#define    IDS_LM_ACCESSNAME_DELETE	   (IDS_LM_PERMSTRING_NAMES_BASE+9)
#define    IDS_LM_ACCESSNAME_ATRIB	   (IDS_LM_PERMSTRING_NAMES_BASE+10)
#define    IDS_LM_ACCESSNAME_PERM	   (IDS_LM_PERMSTRING_NAMES_BASE+11)

/* LM Auditting string IDs
 * Note: Create/Write is only used for directories, Write is only used for files.
 */
#define    IDS_LM_AUDIT_NAME_OPEN	   (IDS_LM_PERMSTRING_NAMES_BASE+13)
#define    IDS_LM_AUDIT_NAME_WRITE	   (IDS_LM_PERMSTRING_NAMES_BASE+14)
#define    IDS_LM_AUDIT_NAME_CREATE_WRITE  (IDS_LM_PERMSTRING_NAMES_BASE+16)
#define    IDS_LM_AUDIT_NAME_DELETE	   (IDS_LM_PERMSTRING_NAMES_BASE+17)
#define    IDS_LM_AUDIT_NAME_ACL	   (IDS_LM_PERMSTRING_NAMES_BASE+18)

#define    IDS_LM_NAME_LAST		   (IDS_LM_PERMSTRING_NAMES_BASE+40)


/* String IDs required by the File/dir security editor
 */
#define IDS_FB_SED_BASE 		IDS_LM_NAME_LAST

#define IDS_FILE			(IDS_FB_SED_BASE+1)
#define IDS_DIRECTORY			(IDS_FB_SED_BASE+2)
#define IDS_FILE_MULTI_SEL		(IDS_FB_SED_BASE+3)
#define IDS_DIRECTORY_MULTI_SEL 	(IDS_FB_SED_BASE+4)
#define IDS_OBJTYPE_OBJNAME_SEPARATOR	(IDS_FB_SED_BASE+5)

#define IDS_LM_FILE_PERMISSIONS_TITLE	(IDS_FB_SED_BASE+6)
#define IDS_LM_FILE_AUDITS_TITLE	(IDS_FB_SED_BASE+7)
#define IDS_LM_FILE_SPECIAL_ACCESS_NAME (IDS_FB_SED_BASE+8)

#define IDS_LM_DIR_PERMISSIONS_TITLE	(IDS_FB_SED_BASE+9)
#define IDS_LM_DIR_AUDITS_TITLE 	(IDS_FB_SED_BASE+10)
#define IDS_LM_DIR_ASSIGN_PERM_TITLE	(IDS_FB_SED_BASE+11)
#define IDS_LM_DIR_ASSIGN_AUDIT_TITLE	(IDS_FB_SED_BASE+13)
#define IDS_LM_DIR_SPECIAL_ACCESS_NAME	(IDS_FB_SED_BASE+15)

#define IDS_NT_ASSIGN_FILE_PERM_TITLE   (IDS_FB_SED_BASE+20)
#define IDS_NT_ASSIGN_FILE_AUDITS_TITLE (IDS_FB_SED_BASE+21)
#define IDS_NT_OBJECT_PERMISSIONS_TITLE (IDS_FB_SED_BASE+22)
#define IDS_NT_OBJECT_AUDITS_TITLE	(IDS_FB_SED_BASE+23)
#define IDS_NT_ASSIGN_PERM_TITLE	(IDS_FB_SED_BASE+24)
#define IDS_NT_ASSIGN_AUDITS_TITLE	(IDS_FB_SED_BASE+26)
#define IDS_NT_FILE_SPECIAL_ACCESS	(IDS_FB_SED_BASE+28)
#define IDS_NT_DIR_SPECIAL_ACCESS	(IDS_FB_SED_BASE+29)
#define IDS_NT_NEWOBJ_SPECIAL_ACCESS	(IDS_FB_SED_BASE+30)

#define IERR_MIXED_MULTI_SEL		(IDS_FB_SED_BASE+31)
#define IERR_MULTI_SELECT_AND_CANT_READ (IDS_FB_SED_BASE+32)

/* Help file name
 */
#define IDS_FILE_PERM_HELP_FILE 	(IDS_FB_SED_BASE+33)


/* Title of the Add User/Group permission dialog
 */
#define IDS_ADD_PERM_DIALOG_TITLE	(IDS_FB_SED_BASE+35)

/* The access name assigned to "Non-standard" permissions
 */
#define IDS_GEN_ACCESSNAME_SPECIAL	(IDS_FB_SED_BASE+40)

#define IDS_TREE_APPLY_WARNING		(IDS_FB_SED_BASE+41)
#define IDS_NOT_SPECIFIED_MNEMONIC	(IDS_FB_SED_BASE+42)
#define IDS_NO_ACCESS_MNEMONIC		(IDS_FB_SED_BASE+43)
#define IDS_FULL_ACCESS_MNEMONIC        (IDS_FB_SED_BASE+44)
#define IDS_NOT_MAPPED_MNEMONIC         (IDS_FB_SED_BASE+45)
#define IDS_PERCENT_1                   (IDS_FB_SED_BASE+46)
#define IDS_CLOSE                       (IDS_FB_SED_BASE+47)
#define IDS_DENY_ALL_EVERYONE_WARNING   (IDS_FB_SED_BASE+48)
#define IDS_CANCEL_TASK_APPLY_DLG_TITLE (IDS_FB_SED_BASE+49)
#define IDS_CANCEL_TASK_ON_ERROR_MSG    (IDS_FB_SED_BASE+50)
#define IDS_CANT_FOCUS_ON_LOGGED_ON_DOMAIN (IDS_FB_SED_BASE+51)
#define IDS_BAD_INTERSECTION            (IDS_FB_SED_BASE+52)
#define IDS_AUDIT_OFF_WARNING           (IDS_FB_SED_BASE+53)
#define IDS_NOT_MAPPED_WARNING          (IDS_FB_SED_BASE+54)
#define IDS_CANCEL_TASK_TRAV_ERROR_MSG  (IDS_FB_SED_BASE+55)

//
// Status bar help text
//
#define IDS_FM_HELP_PERMISSION_MENU_ITEM (IDS_FB_SED_BASE+56)
#define IDS_FM_HELP_AUDITING_MENU_ITEM   (IDS_FB_SED_BASE+57)
#define IDS_FM_HELP_OWNER_MENU_ITEM      (IDS_FB_SED_BASE+58)
#define IDS_FM_HELP_SECURITY_MENU        (IDS_FB_SED_BASE+59)

#define    IDS_FB_SED_LAST		(IDS_FB_SED_BASE+60)

/* Take Ownership string IDs
 */
#define IDS_TAKEOWNERSHIP_BASE		(IDS_FB_SED_LAST+1)

#define IDS_X_OBJECTS_SELECTED		(IDS_TAKEOWNERSHIP_BASE+1)
#define IDS_RESOURCE_TITLE		(IDS_TAKEOWNERSHIP_BASE+2)
#define IDS_NO_OWNER			(IDS_TAKEOWNERSHIP_BASE+3)
#define IDS_FILES_AND_DIRS		(IDS_TAKEOWNERSHIP_BASE+4)
#define IERR_OWNER_CANT_VIEW_CAN_EDIT	(IDS_TAKEOWNERSHIP_BASE+5)
#define IERR_OWNER_NOT_NTFS_VOLUME	(IDS_TAKEOWNERSHIP_BASE+6)
#define IERR_OWNER_SOME_FAILED		(IDS_TAKEOWNERSHIP_BASE+7)
#define IDS_OWNER_APPLY_TO_DIR_PROMPT   (IDS_TAKEOWNERSHIP_BASE+8)
#define IDS_OWNER_NUKE_DACL_WARNING     (IDS_TAKEOWNERSHIP_BASE+9)
#define IDS_OWNER_CANT_FIND_OWNR_OR_GRP (IDS_TAKEOWNERSHIP_BASE+10)
#define IDS_OWNER_ACCOUNT_NOT_FOUND     (IDS_TAKEOWNERSHIP_BASE+11)

#define IDS_TAKEOWNERSHIP_LAST          (IDS_TAKEOWNERSHIP_BASE+15)

/* General purpose error message manifests
 */
#define IDS_PERM_IERR_BASE		(IDS_TAKEOWNERSHIP_LAST+1)

#define IERR_CONTINUE_AFTER_USERGROUP_NOT_FOUND (IDS_PERM_IERR_BASE+1)
#define IERR_NOT_NTFS_VOLUME            (IDS_PERM_IERR_BASE+2)
#define IERR_NOTHING_SELECTED           (IDS_PERM_IERR_BASE+3)
#define IERR_TOO_MANY_USERS             (IDS_PERM_IERR_BASE+4)

#endif // _PERMSTR_HXX_
