#ifndef _TCPIPCPL_H_
#define _TCPIPCPL_H_

#define TCH_QUESTION_MARK   TCH('?')

#define ZERO_ADDRESS    SZ("0.0.0.0")
#define FF_ADDRESS      SZ("255.0.0.0")

#define NO_TITLE                999999
#define SZ_TOKEN                SZ("TokenRing")
#define SZ_ETHER                SZ("Ether")
#define SZ_PARAMETERS           SZ("\\Parameters")
#define SZ_ETHERSNAP            SZ("EtherSnap")
#define SZ_UNKNOWN              SZ("Unknown Network Card.")
#define NUMBER                  SZ("0123456789")
#define SEPARATOR               SZ("@")
#define SZ_DOT                  SZ(".")
#define BACK_SLASH              TCH('\\')
#define NULL_CHARACTER          TCH('\0')


//
// Registry key names
//

#define RGAS_GENERIC_CLASS      SZ("GenericClass")
#define RGAS_SZ_NULL            SZ("")
#define RGAS_TCPIP              SZ("Tcpip")
#define RGAS_TCPIP_PARAMETERS   SZ("\\Tcpip\\Parameters")
#define RGAS_DHCP               SZ("DHCP")
#define RGAS_TCPIP_LINKAGE      SZ("\\Tcpip\\linkage")
#define RGAS_OTHER_DEPENDENCIES SZ("OtherDependencies")
#define RGAS_DEPENDONSERVICE    SZ("DependOnService")
#define RGAS_HOSTNAME           SZ("Hostname")
#define RGAS_DEFAULTGATEWAY     SZ("DefaultGateway")
#define RGAS_DOMAIN             SZ("Domain")
#define RGAS_SEARCHLIST         SZ("SearchList")
#define RGAS_NAMESERVER         SZ("NameServer")
#define RGAS_TRANSIENT          SZ("Transient")
#define RGAS_LOOKUPORDER        SZ("DNSLookupOrder")
#define RGAS_DNSENABLEWINS      SZ("DNSEnableWINS")
#define RGAS_NETBT              SZ("NetBT")
#define RGAS_NETBT_SVC_PARAM    SZ("System\\CurrentControlSet\\Services\\NetBT\\Parameters")
#define RGAS_NETBT_PARAMETERS   SZ("\\Netbt\\Parameters")
#define RGAS_NETBT_LINKAGE      SZ("\\Netbt\\Linkage")
#define RGAS_NETBT_ADAPTERS     SZ("\\Netbt\\Adapters")
#define RGAS_BIND1              SZ("Bind")
#define RGAS_BIND2              SZ("OldBind")
#define RGAS_SCOPEID            SZ("ScopeID")
#define RGAS_PARAMETERS_TCPIP   SZ("\\Parameters\\Tcpip")
#define RGAS_TITLE              SZ("Title")
#define RGAS_DESCRIPTION        SZ("Description")
#define RGAS_IPADDRESS          SZ("IPAddress")
#define RGAS_SUBNETMASK         SZ("SubnetMask")
#define RGAS_DHCP_IPADDRESS     SZ("DhcpIPAddress")
#define RGAS_DHCP_SUBNETMASK    SZ("DhcpSubnetMask")
#define RGAS_ADAPTERTYPE        SZ("AdapterType")
#define RGAS_KEEPALIVE          SZ("KeepAlive")
#define RGAS_BROADCASTTYPE      SZ("BroadcastType")
#define RGAS_FORWARDBROADCASTS  SZ("ForwardBroadcasts")
#define RGAS_TRAILERS           SZ("Trailers")
#define RGAS_LMHOSTS            SZ("lmhosts")
#define RGAS_LMHOSTS_PATH       SZ("\\drivers\\etc\\lmhosts")
#define RGAS_HOSTS              SZ("hosts")
#define RGAS_DATABASEPATH       SZ("DataBasePath")
#define RGAS_PERMANENTNAME      SZ("PermanentName")
#define RGAS_MEDIATYPE          SZ("MediaType")
#define RGAS_DEVICE_STREAMS     SZ("\\Device\\Streams\\")
#define RGAS_ENABLE_DHCP        SZ("EnableDHCP")
#define RGAS_NODETYPE           SZ("NodeType")
#define RGAS_PRIMARY_WINS       SZ("NameServer")
#define RGAS_SECONDARY_WINS     SZ("NameServerBackup")
#define RGAS_ENABLE_DNS         SZ("EnableDNS")
#define RGAS_ENABLE_LMHOSTS     SZ("EnableLMHOSTS")
#define RGAS_ENABLE_PROXY       SZ("EnableProxy")
#define RGAS_ENABLE_ROUTER      SZ("IPEnableRouter")
#define RGAS_AUTOIPADDRESS      SZ("AutoIPAddress")
#define RGAS_USEZEROBROADCAST   SZ("UseZeroBroadcast")
#define RGAS_LLINTERFACE        SZ("LLInterface")

#define RGAS_OLD_TCPIP_PARAMETERS     SZ("\\Tcpip\\Parameters")
#define RGAS_SERVICES_HOME            SZ( "SYSTEM\\CurrentControlSet\\Services" )
#define RGAS_SYSTEM_TCPIP_LINKAGE 	  SZ( "System\\CurrentControlSet\\Services\\Tcpip\\Linkage")
#define RGAS_IPRIP 	                  SZ( "System\\CurrentControlSet\\Services\\IPRip")
#define RGAS_RELAY_AGENT              SZ( "System\\CurrentControlSet\\Services\\RelayAgent")
#define RGAS_RELAY_AGENT_SERVICE 	  SZ( "RelayAgent")
#define RGAS_IPRIP_SERVICE 	          SZ( "IPRip")
#define RGAS_NETBIOS_ROUTING          SZ( "NetBiosRouting" )
#define RGAS_WINS_SERVICE             SZ( "SYSTEM\\CurrentControlSet\\Services\\WINS" )
#define RGAS_ADAPTER_HOME             SZ( "SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\NetworkCards")
#define RGAS_BIND_VALUE_NAME          SZ( "Bind" )
#define RGAS_DISABLED_KEY_NAME        SZ( "Disabled" )
#define RGAS_EXPORT_VALUE_NAME        SZ( "Export" )
#define RGAS_ROUTE_VALUE_NAME         SZ( "Route" )
#define RGAS_LINKAGE_NAME             SZ( "Linkage" )
#define RGAS_SERVICE_NAME             SZ( "ServiceName" )
#define RGAS_LMSERVER                 SZ( "LanmanServer" )
#define RGAS_LMWORKSTATION            SZ( "LanmanWorkstation" )
#define RGAS_REG_LOCATION             SZ( "RegLocation" )
#define RGAS_WINNT          SZ("Winnt")
#define RGAS_PRODUCT_TYPE   SZ("ProductType")
#define RGAS_PRODUCT_OPTION SZ("System\\CurrentControlSet\\Control\\ProductOptions" )

#define RGAS_DHCP_SERVER    SZ("System\\CurrentControlSet\\Services\\DHCPServer" )
#define RGAS_DHCP_OPTIONS   SZ("System\\CurrentControlSet\\Services\\DHCP\\Parameters\\Options")
#define RGAS_DHCP_OPTION_IPADDRESS  SZ("System\\CurrentControlSet\\Services\\?\\Parameters\\Tcpip\\DhcpIPAddress")
#define RGAS_DHCP_OPTION_SUBNETMASK SZ("System\\CurrentControlSet\\Services\\?\\Parameters\\Tcpip\\DhcpSubnetMask")
#define RGAS_DHCP_OPTION_NAMESERVERBACKUP SZ("System\\CurrentControlSet\\Services\\NetBT\\Adapters\\?\\DhcpNameServerBackup")
#endif // _TCPIPCPL_H_
