/*****************************************************************************
*
* COPYRIGHT 1993 - COLORADO MEMORY SYSTEMS, INC.
* ALL RIGHTS RESERVED.
*
******************************************************************************
*
* FILE: \SE\DRIVER\DEVICE\JUMBO\SRC\0X11041.C
*
* FUNCTION: cqd_SendByte
*
* PURPOSE: Transmit a command to the tape drive using step pulses
*          generated by the FDC.
*
*          Using the Present Cylinder Number (pcn) of the FDC
*          calculate a New Cylinder Number (ncn) that will make
*          the FDC generate the number of step pulses corresponding
*          to the command byte.
*
*          Execute a Seek with the FDC.
*
*          Sense Interrupt dStatus of the FDC and make sure that the
*          pcn concurs with the ncn, which indicates that the correct
*          number of step pulses were issued.
*
* HISTORY:
*		$Log:   J:\se.vcs\driver\q117cd\src\0x11041.c  $
*
*	   Rev 1.14   20 Apr 1994 16:28:20   BOBLEHMA
*	Added a call to kdi_QIC117ClearIRQ for the case when sleep returns from
*	a timeout, (after the sense interrupt status).  There are cases when the
*	sleep returns from a timeout, but the interrupt in the trakker is still
*	latched and must be cleared.
*
*	   Rev 1.13   23 Feb 1994 17:08:34   KEVINKES
*	Added a reset FDC to the endo fo send byte to clear out any
*	state errors in the controller due to a timeout on the seek
*	interrupt.
*
*	   Rev 1.12   04 Feb 1994 14:27:24   KURTGODW
*	Changed ifdef dbg to if dbg for NT
*
*	   Rev 1.11   27 Jan 1994 15:48:34   KEVINKES
*	Modified debug code.
*
*	   Rev 1.10   21 Jan 1994 18:23:12   KEVINKES
*	Fixed compiler warnings.
*
*	   Rev 1.9   18 Jan 1994 16:19:08   KEVINKES
*	Updated debug code.
*
*	   Rev 1.8   11 Jan 1994 15:20:18   KEVINKES
*	Added call to CLearInterruptEvent.
*
*	   Rev 1.7   13 Dec 1993 16:01:00   KEVINKES
*	Removed the format code.
*
*	   Rev 1.6   23 Nov 1993 18:49:08   KEVINKES
*	Modified CHECKED_DUMP calls for debugging over the serial port.
*
*	   Rev 1.5   15 Nov 1993 16:20:42   KEVINKES
*	Added abort handling.
*
*	   Rev 1.4   12 Nov 1993 13:43:36   KEVINKES
*	Removed the abort code.
*
*	   Rev 1.3   11 Nov 1993 15:20:56   KEVINKES
*	Changed calls to cqd_inp and cqd_outp to kdi_ReadPort and kdi_WritePort.
*	Modified the parameters to these calls.  Changed FDC commands to be
*	defines.
*
*	   Rev 1.2   08 Nov 1993 14:05:58   KEVINKES
*	Removed all bit-field structures, removed all enumerated types, changed
*	all defines to uppercase, and removed all signed data types wherever
*	possible.
*
*	   Rev 1.1   25 Oct 1993 14:24:32   KEVINKES
*	Added a sense interrupt status for timeout errors.
*
*	   Rev 1.0   18 Oct 1993 17:25:40   KEVINKES
*	Initial Revision.
*
*****************************************************************************/
#define FCT_ID 0x11041
#include "include\public\adi_api.h"
#include "include\public\frb_api.h"
#include "include\private\kdi_pub.h"
#include "include\private\cqd_pub.h"
#include "q117cd\include\cqd_defs.h"
#include "q117cd\include\cqd_strc.h"
#include "q117cd\include\cqd_hdr.h"
/*endinclude*/

dStatus cqd_SendByte
(
/* INPUT PARAMETERS:  */

   CqdContextPtr cqd_context,
   dUByte command

/* UPDATE PARAMETERS: */

/* OUTPUT PARAMETERS: */

)
/* COMMENTS: *****************************************************************
*
* DEFINITIONS: *************************************************************/
{

/* DATA: ********************************************************************/

	dStatus status=DONT_PANIC;	/* dStatus or error condition.*/
   SeekCmd seek;
   SnsIntCmd sense_int;
   FDCResult result;
#if DBG
   dBoolean save;
#endif

/* CODE: ********************************************************************/

#if DBG
   /* Lockout commands used to receive the status */
   save = cqd_context->dbg_lockout;
   cqd_context->dbg_lockout = dTRUE;
#endif

   if (command >= MAX_FDC_SEEK) {

#if DBG
   cqd_context->dbg_lockout = save;
#endif
      return kdi_Error(ERR_INVALID_COMMAND, FCT_ID, ERR_SEQ_1);

   }

   if (cqd_context->controller_data.fdc_pcn < MAX_FDC_SEEK) {

      seek.NCN = (dUByte)(cqd_context->controller_data.fdc_pcn + command);

   } else {

      seek.NCN = (dUByte)(cqd_context->controller_data.fdc_pcn - command);

   }

   seek.cmd = FDC_CMD_SEEK;
   seek.drive = (dUByte)cqd_context->device_cfg.drive_select;
   kdi_ResetInterruptEvent(cqd_context->kdi_context);

   if ((status = cqd_ProgramFDC(
                  cqd_context,
                  (dUByte *)&seek,
                  sizeof(seek),
                  dFALSE)) != DONT_PANIC) {

		kdi_ClearInterruptEvent(cqd_context->kdi_context);
#if DBG
   cqd_context->dbg_lockout = save;
#endif
		cqd_ResetFDC(cqd_context);
      return status;

   }

   /* For some unknown reason, we occasionally miss an interrupt. */
   /* Despite the timeout, we still press on as if we received the interrupt. */
   /* Therefore, we go ahead and perform the sense interrupt status.  If */
   /* status register 0 is bad, then we assume that we truly did miss the */
   /* interrupt.  Otherwise, we go on as if nothing happened. */

   status = kdi_Sleep(cqd_context->kdi_context, kdi_wt001s, dTRUE);

	if (kdi_GetErrorType(status) == ERR_KDI_TO_EXPIRED) {

   	sense_int.command = FDC_CMD_SENSE_INT;

      status = cqd_ProgramFDC(cqd_context,
                        (dUByte *)&sense_int,
                        sizeof(SnsIntCmd),
                        dFALSE);

		kdi_QIC117ClearIRQ( cqd_context->kdi_context );
	}

	if (status == DONT_PANIC) {

      if ((status = cqd_ReadFDC(
							cqd_context,
							(dUByte *)&result,
							sizeof(result))) != DONT_PANIC) {

#if DBG
   cqd_context->dbg_lockout = save;
#endif
         return status;

      } else {

         /* If the sense interrupt status is O.K., then proceed as if */
         /* nothing happened. If, however, there is an error returned by */
         /* status register 0, then return a FDCFLT. */

         if (! (result.ST0 & ST0_IC)) {

            /* If we timed out, then we did the sense interrupt status */
            /* without clearing the interrupt from the interrupt controller. */
            /* Since the FDC did not indicate an error, we assume that we */
            /* missed the interrupt and send the EOI. Only needed for an */
            /* 82072. */

            if (kdi_GetInterfaceType(cqd_context->kdi_context) != MICRO_CHANNEL) {

               if (result.ST0 !=
                     (dUByte)(cqd_context->device_cfg.drive_select | ST0_SE)) {

#if DBG
   cqd_context->dbg_lockout = save;
#endif
			    		return kdi_Error(ERR_FDC_FAULT, FCT_ID, ERR_SEQ_1);

               }
            }

            if (seek.NCN != result.PCN) {

#if DBG
   cqd_context->dbg_lockout = save;
#endif
      			return kdi_Error(ERR_CMD_FAULT, FCT_ID, ERR_SEQ_1);

            }

            cqd_context->controller_data.fdc_pcn = result.PCN;

         } else {

#if DBG
   cqd_context->dbg_lockout = save;
#endif
      		return kdi_Error(ERR_FDC_FAULT, FCT_ID, ERR_SEQ_2);

         }

      }

	} else {

      cqd_ResetFDC(cqd_context);

	}

#if DBG
   cqd_context->dbg_lockout = save;
   DBG_ADD_ENTRY(QIC117SHOWMCMDS, (CqdContextPtr)cqd_context, DBG_SEND_BYTE);
   DBG_ADD_ENTRY(QIC117SHOWMCMDS, (CqdContextPtr)cqd_context, (dUByte)command);
#endif

   return status;
}
