/*++

Copyright (c) 1991  Microsoft Corporation

Module Name:

    xxfonts.c

Abstract:

    This module contains the font tables to display characters in a frame
    buffer.

Author:

    David N. Cutler (davec) 27-Apr-1991

Environment:

    Kernel mode

Revision History:

--*/


unsigned char FwUsFont2[1536] = {

        0X00, /* 00000000    */
        0X00, /* 00000000    */
        0X00, /* 00000000    */
        0X00, /* 00000000    */
        0X00, /* 00000000    */
        0X00, /* 00000000    */
        0X00, /* 00000000    */
        0X00, /* 00000000    */
        0X00, /* 00000000    */
        0X00, /* 00000000    */
        0X00, /* 00000000    */
        0X00, /* 00000000    */
        0X00, /* 00000000    */
        0X00, /* 00000000    */
        0X00, /* 00000000    */
        0X00, /* 00000000    */

        0X00, /* 00000000  !  */
        0X00, /* 00000000  !  */
        0X08, /* 00001000  !  */
        0X08, /* 00001000  !  */
        0X08, /* 00001000  !  */
        0X08, /* 00001000  !  */
        0X08, /* 00001000  !  */
        0X08, /* 00001000  !  */
        0X08, /* 00001000  !  */
        0X08, /* 00001000  !  */
        0X00, /* 00000000  !  */
        0X08, /* 00001000  !  */
        0X00, /* 00000000  !  */
        0X00, /* 00000000  !  */
        0X00, /* 00000000  !  */
        0X00, /* 00000000    */

        0X00, /* 00000000  "  */
        0X00, /* 00000000  "  */
        0X24, /* 00100100  "  */
        0X24, /* 00100100  "  */
        0X24, /* 00100100  "  */
        0X00, /* 00000000  "  */
        0X00, /* 00000000  "  */
        0X00, /* 00000000  "  */
        0X00, /* 00000000  "  */
        0X00, /* 00000000  "  */
        0X00, /* 00000000  "  */
        0X00, /* 00000000  "  */
        0X00, /* 00000000  "  */
        0X00, /* 00000000  "  */
        0X00, /* 00000000  "  */
        0X00, /* 00000000    */

        0X00, /* 00000000  #  */
        0X00, /* 00000000  #  */
        0X00, /* 00000000  #  */
        0X12, /* 00010010  #  */
        0X12, /* 00010010  #  */
        0X3f, /* 00111111  #  */
        0X12, /* 00010010  #  */
        0X12, /* 00010010  #  */
        0X3f, /* 00111111  #  */
        0X12, /* 00010010  #  */
        0X12, /* 00010010  #  */
        0X00, /* 00000000  #  */
        0X00, /* 00000000  #  */
        0X00, /* 00000000  #  */
        0X00, /* 00000000  #  */
        0X00, /* 00000000    */

        0X00, /* 00000000  $  */
        0X00, /* 00000000  $  */
        0X00, /* 00000000  $  */
        0X08, /* 00001000  $  */
        0X3e, /* 00111110  $  */
        0X09, /* 00001001  $  */
        0X09, /* 00001001  $  */
        0X3e, /* 00111110  $  */
        0X48, /* 01001000  $  */
        0X48, /* 01001000  $  */
        0X3e, /* 00111110  $  */
        0X08, /* 00001000  $  */
        0X00, /* 00000000  $  */
        0X00, /* 00000000  $  */
        0X00, /* 00000000  $  */
        0X00, /* 00000000    */

        0X00, /* 00000000  %  */
        0X00, /* 00000000  %  */
        0X42, /* 01000010  %  */
        0X25, /* 00100101  %  */
        0X25, /* 00100101  %  */
        0X12, /* 00010010  %  */
        0X08, /* 00001000  %  */
        0X08, /* 00001000  %  */
        0X24, /* 00100100  %  */
        0X52, /* 01010010  %  */
        0X52, /* 01010010  %  */
        0X21, /* 00100001  %  */
        0X00, /* 00000000  %  */
        0X00, /* 00000000  %  */
        0X00, /* 00000000  %  */
        0X00, /* 00000000    */

        0X00, /* 00000000  &  */
        0X00, /* 00000000  &  */
        0X0e, /* 00001110  &  */
        0X11, /* 00010001  &  */
        0X11, /* 00010001  &  */
        0X11, /* 00010001  &  */
        0X0e, /* 00001110  &  */
        0X11, /* 00010001  &  */
        0X51, /* 01010001  &  */
        0X21, /* 00100001  &  */
        0X31, /* 00110001  &  */
        0X4e, /* 01001110  &  */
        0X00, /* 00000000  &  */
        0X00, /* 00000000  &  */
        0X00, /* 00000000  &  */
        0X00, /* 00000000    */

        0X00, /* 00000000  '  */
        0X00, /* 00000000  '  */
        0X38, /* 00111000  '  */
        0X18, /* 00011000  '  */
        0X04, /* 00000100  '  */
        0X00, /* 00000000  '  */
        0X00, /* 00000000  '  */
        0X00, /* 00000000  '  */
        0X00, /* 00000000  '  */
        0X00, /* 00000000  '  */
        0X00, /* 00000000  '  */
        0X00, /* 00000000  '  */
        0X00, /* 00000000  '  */
        0X00, /* 00000000  '  */
        0X00, /* 00000000  '  */
        0X00, /* 00000000    */

        0X00, /* 00000000  (  */
        0X00, /* 00000000  (  */
        0X10, /* 00010000  (  */
        0X08, /* 00001000  (  */
        0X08, /* 00001000  (  */
        0X04, /* 00000100  (  */
        0X04, /* 00000100  (  */
        0X04, /* 00000100  (  */
        0X04, /* 00000100  (  */
        0X08, /* 00001000  (  */
        0X08, /* 00001000  (  */
        0X10, /* 00010000  (  */
        0X00, /* 00000000  (  */
        0X00, /* 00000000  (  */
        0X00, /* 00000000  (  */
        0X00, /* 00000000    */

        0X00, /* 00000000  )  */
        0X00, /* 00000000  )  */
        0X04, /* 00000100  )  */
        0X08, /* 00001000  )  */
        0X08, /* 00001000  )  */
        0X10, /* 00010000  )  */
        0X10, /* 00010000  )  */
        0X10, /* 00010000  )  */
        0X10, /* 00010000  )  */
        0X08, /* 00001000  )  */
        0X08, /* 00001000  )  */
        0X04, /* 00000100  )  */
        0X00, /* 00000000  )  */
        0X00, /* 00000000  )  */
        0X00, /* 00000000  )  */
        0X00, /* 00000000    */

        0X00, /* 00000000  *  */
        0X00, /* 00000000  *  */
        0X00, /* 00000000  *  */
        0X00, /* 00000000  *  */
        0X00, /* 00000000  *  */
        0X22, /* 00100010  *  */
        0X14, /* 00010100  *  */
        0X7f, /* 01111111  *  */
        0X14, /* 00010100  *  */
        0X22, /* 00100010  *  */
        0X00, /* 00000000  *  */
        0X00, /* 00000000  *  */
        0X00, /* 00000000  *  */
        0X00, /* 00000000  *  */
        0X00, /* 00000000  *  */
        0X00, /* 00000000    */

        0X00, /* 00000000  +  */
        0X00, /* 00000000  +  */
        0X00, /* 00000000  +  */
        0X00, /* 00000000  +  */
        0X08, /* 00001000  +  */
        0X08, /* 00001000  +  */
        0X08, /* 00001000  +  */
        0X7f, /* 01111111  +  */
        0X08, /* 00001000  +  */
        0X08, /* 00001000  +  */
        0X08, /* 00001000  +  */
        0X00, /* 00000000  +  */
        0X00, /* 00000000  +  */
        0X00, /* 00000000  +  */
        0X00, /* 00000000  +  */
        0X00, /* 00000000    */

        0X00, /* 00000000  ,  */
        0X00, /* 00000000  ,  */
        0X00, /* 00000000  ,  */
        0X00, /* 00000000  ,  */
        0X00, /* 00000000  ,  */
        0X00, /* 00000000  ,  */
        0X00, /* 00000000  ,  */
        0X00, /* 00000000  ,  */
        0X00, /* 00000000  ,  */
        0X00, /* 00000000  ,  */
        0X1c, /* 00011100  ,  */
        0X0c, /* 00001100  ,  */
        0X02, /* 00000010  ,  */
        0X00, /* 00000000  ,  */
        0X00, /* 00000000  ,  */
        0X00, /* 00000000    */

        0X00, /* 00000000  -  */
        0X00, /* 00000000  -  */
        0X00, /* 00000000  -  */
        0X00, /* 00000000  -  */
        0X00, /* 00000000  -  */
        0X00, /* 00000000  -  */
        0X00, /* 00000000  -  */
        0X7f, /* 01111111  -  */
        0X00, /* 00000000  -  */
        0X00, /* 00000000  -  */
        0X00, /* 00000000  -  */
        0X00, /* 00000000  -  */
        0X00, /* 00000000  -  */
        0X00, /* 00000000  -  */
        0X00, /* 00000000  -  */
        0X00, /* 00000000    */

        0X00, /* 00000000  .  */
        0X00, /* 00000000  .  */
        0X00, /* 00000000  .  */
        0X00, /* 00000000  .  */
        0X00, /* 00000000  .  */
        0X00, /* 00000000  .  */
        0X00, /* 00000000  .  */
        0X00, /* 00000000  .  */
        0X00, /* 00000000  .  */
        0X00, /* 00000000  .  */
        0X08, /* 00001000  .  */
        0X1c, /* 00011100  .  */
        0X08, /* 00001000  .  */
        0X00, /* 00000000  .  */
        0X00, /* 00000000  .  */
        0X00, /* 00000000    */

        0X00, /* 00000000  /  */
        0X00, /* 00000000  /  */
        0X40, /* 01000000  /  */
        0X40, /* 01000000  /  */
        0X20, /* 00100000  /  */
        0X10, /* 00010000  /  */
        0X08, /* 00001000  /  */
        0X04, /* 00000100  /  */
        0X02, /* 00000010  /  */
        0X01, /* 00000001  /  */
        0X01, /* 00000001  /  */
        0X01, /* 00000001  /  */
        0X00, /* 00000000  /  */
        0X00, /* 00000000  /  */
        0X00, /* 00000000  /  */
        0X00, /* 00000000    */

        0X00, /* 00000000  0  */
        0X00, /* 00000000  0  */
        0X0c, /* 00001100  0  */
        0X12, /* 00010010  0  */
        0X21, /* 00100001  0  */
        0X21, /* 00100001  0  */
        0X21, /* 00100001  0  */
        0X21, /* 00100001  0  */
        0X21, /* 00100001  0  */
        0X21, /* 00100001  0  */
        0X12, /* 00010010  0  */
        0X0c, /* 00001100  0  */
        0X00, /* 00000000  0  */
        0X00, /* 00000000  0  */
        0X00, /* 00000000  0  */
        0X00, /* 00000000    */

        0X00, /* 00000000  1  */
        0X00, /* 00000000  1  */
        0X08, /* 00001000  1  */
        0X0c, /* 00001100  1  */
        0X0a, /* 00001010  1  */
        0X08, /* 00001000  1  */
        0X08, /* 00001000  1  */
        0X08, /* 00001000  1  */
        0X08, /* 00001000  1  */
        0X08, /* 00001000  1  */
        0X08, /* 00001000  1  */
        0X3e, /* 00111110  1  */
        0X00, /* 00000000  1  */
        0X00, /* 00000000  1  */
        0X00, /* 00000000  1  */
        0X00, /* 00000000    */

        0X00, /* 00000000  2  */
        0X00, /* 00000000  2  */
        0X3e, /* 00111110  2  */
        0X41, /* 01000001  2  */
        0X41, /* 01000001  2  */
        0X40, /* 01000000  2  */
        0X20, /* 00100000  2  */
        0X10, /* 00010000  2  */
        0X0c, /* 00001100  2  */
        0X02, /* 00000010  2  */
        0X01, /* 00000001  2  */
        0X7f, /* 01111111  2  */
        0X00, /* 00000000  2  */
        0X00, /* 00000000  2  */
        0X00, /* 00000000  2  */
        0X00, /* 00000000    */

        0X00, /* 00000000  3  */
        0X00, /* 00000000  3  */
        0X7f, /* 01111111  3  */
        0X40, /* 01000000  3  */
        0X20, /* 00100000  3  */
        0X10, /* 00010000  3  */
        0X38, /* 00111000  3  */
        0X40, /* 01000000  3  */
        0X40, /* 01000000  3  */
        0X40, /* 01000000  3  */
        0X41, /* 01000001  3  */
        0X3e, /* 00111110  3  */
        0X00, /* 00000000  3  */
        0X00, /* 00000000  3  */
        0X00, /* 00000000  3  */
        0X00, /* 00000000    */

        0X00, /* 00000000  4  */
        0X00, /* 00000000  4  */
        0X20, /* 00100000  4  */
        0X30, /* 00110000  4  */
        0X28, /* 00101000  4  */
        0X24, /* 00100100  4  */
        0X22, /* 00100010  4  */
        0X21, /* 00100001  4  */
        0X7f, /* 01111111  4  */
        0X20, /* 00100000  4  */
        0X20, /* 00100000  4  */
        0X20, /* 00100000  4  */
        0X00, /* 00000000  4  */
        0X00, /* 00000000  4  */
        0X00, /* 00000000  4  */
        0X00, /* 00000000    */

        0X00, /* 00000000  5  */
        0X00, /* 00000000  5  */
        0X7f, /* 01111111  5  */
        0X01, /* 00000001  5  */
        0X01, /* 00000001  5  */
        0X3d, /* 00111101  5  */
        0X43, /* 01000011  5  */
        0X40, /* 01000000  5  */
        0X40, /* 01000000  5  */
        0X40, /* 01000000  5  */
        0X41, /* 01000001  5  */
        0X3e, /* 00111110  5  */
        0X00, /* 00000000  5  */
        0X00, /* 00000000  5  */
        0X00, /* 00000000  5  */
        0X00, /* 00000000    */

        0X00, /* 00000000  6  */
        0X00, /* 00000000  6  */
        0X3c, /* 00111100  6  */
        0X02, /* 00000010  6  */
        0X01, /* 00000001  6  */
        0X01, /* 00000001  6  */
        0X3d, /* 00111101  6  */
        0X43, /* 01000011  6  */
        0X41, /* 01000001  6  */
        0X41, /* 01000001  6  */
        0X41, /* 01000001  6  */
        0X3e, /* 00111110  6  */
        0X00, /* 00000000  6  */
        0X00, /* 00000000  6  */
        0X00, /* 00000000  6  */
        0X00, /* 00000000    */

        0X00, /* 00000000  7  */
        0X00, /* 00000000  7  */
        0X7f, /* 01111111  7  */
        0X40, /* 01000000  7  */
        0X40, /* 01000000  7  */
        0X20, /* 00100000  7  */
        0X10, /* 00010000  7  */
        0X08, /* 00001000  7  */
        0X04, /* 00000100  7  */
        0X04, /* 00000100  7  */
        0X02, /* 00000010  7  */
        0X02, /* 00000010  7  */
        0X00, /* 00000000  7  */
        0X00, /* 00000000  7  */
        0X00, /* 00000000  7  */
        0X00, /* 00000000    */

        0X00, /* 00000000  8  */
        0X00, /* 00000000  8  */
        0X3e, /* 00111110  8  */
        0X41, /* 01000001  8  */
        0X41, /* 01000001  8  */
        0X41, /* 01000001  8  */
        0X3e, /* 00111110  8  */
        0X41, /* 01000001  8  */
        0X41, /* 01000001  8  */
        0X41, /* 01000001  8  */
        0X41, /* 01000001  8  */
        0X3e, /* 00111110  8  */
        0X00, /* 00000000  8  */
        0X00, /* 00000000  8  */
        0X00, /* 00000000  8  */
        0X00, /* 00000000    */

        0X00, /* 00000000  9  */
        0X00, /* 00000000  9  */
        0X3e, /* 00111110  9  */
        0X41, /* 01000001  9  */
        0X41, /* 01000001  9  */
        0X41, /* 01000001  9  */
        0X61, /* 01100001  9  */
        0X5e, /* 01011110  9  */
        0X40, /* 01000000  9  */
        0X40, /* 01000000  9  */
        0X20, /* 00100000  9  */
        0X1e, /* 00011110  9  */
        0X00, /* 00000000  9  */
        0X00, /* 00000000  9  */
        0X00, /* 00000000  9  */
        0X00, /* 00000000    */

        0X00, /* 00000000  :  */
        0X00, /* 00000000  :  */
        0X00, /* 00000000  :  */
        0X00, /* 00000000  :  */
        0X00, /* 00000000  :  */
        0X08, /* 00001000  :  */
        0X1c, /* 00011100  :  */
        0X08, /* 00001000  :  */
        0X00, /* 00000000  :  */
        0X00, /* 00000000  :  */
        0X08, /* 00001000  :  */
        0X1c, /* 00011100  :  */
        0X08, /* 00001000  :  */
        0X00, /* 00000000  :  */
        0X00, /* 00000000  :  */
        0X00, /* 00000000    */

        0X00, /* 00000000  ;  */
        0X00, /* 00000000  ;  */
        0X00, /* 00000000  ;  */
        0X00, /* 00000000  ;  */
        0X00, /* 00000000  ;  */
        0X08, /* 00001000  ;  */
        0X1c, /* 00011100  ;  */
        0X08, /* 00001000  ;  */
        0X00, /* 00000000  ;  */
        0X00, /* 00000000  ;  */
        0X1c, /* 00011100  ;  */
        0X0c, /* 00001100  ;  */
        0X02, /* 00000010  ;  */
        0X00, /* 00000000  ;  */
        0X00, /* 00000000  ;  */
        0X00, /* 00000000    */

        0X00, /* 00000000  <  */
        0X00, /* 00000000  <  */
        0X20, /* 00100000  <  */
        0X10, /* 00010000  <  */
        0X08, /* 00001000  <  */
        0X04, /* 00000100  <  */
        0X02, /* 00000010  <  */
        0X02, /* 00000010  <  */
        0X04, /* 00000100  <  */
        0X08, /* 00001000  <  */
        0X10, /* 00010000  <  */
        0X20, /* 00100000  <  */
        0X00, /* 00000000  <  */
        0X00, /* 00000000  <  */
        0X00, /* 00000000  <  */
        0X00, /* 00000000    */

        0X00, /* 00000000  =  */
        0X00, /* 00000000  =  */
        0X00, /* 00000000  =  */
        0X00, /* 00000000  =  */
        0X00, /* 00000000  =  */
        0X00, /* 00000000  =  */
        0X7f, /* 01111111  =  */
        0X00, /* 00000000  =  */
        0X00, /* 00000000  =  */
        0X7f, /* 01111111  =  */
        0X00, /* 00000000  =  */
        0X00, /* 00000000  =  */
        0X00, /* 00000000  =  */
        0X00, /* 00000000  =  */
        0X00, /* 00000000  =  */
        0X00, /* 00000000    */

        0X00, /* 00000000  >  */
        0X00, /* 00000000  >  */
        0X02, /* 00000010  >  */
        0X04, /* 00000100  >  */
        0X08, /* 00001000  >  */
        0X10, /* 00010000  >  */
        0X20, /* 00100000  >  */
        0X20, /* 00100000  >  */
        0X10, /* 00010000  >  */
        0X08, /* 00001000  >  */
        0X04, /* 00000100  >  */
        0X02, /* 00000010  >  */
        0X00, /* 00000000  >  */
        0X00, /* 00000000  >  */
        0X00, /* 00000000  >  */
        0X00, /* 00000000    */

        0X00, /* 00000000  ?  */
        0X00, /* 00000000  ?  */
        0X3e, /* 00111110  ?  */
        0X41, /* 01000001  ?  */
        0X41, /* 01000001  ?  */
        0X40, /* 01000000  ?  */
        0X20, /* 00100000  ?  */
        0X10, /* 00010000  ?  */
        0X08, /* 00001000  ?  */
        0X08, /* 00001000  ?  */
        0X00, /* 00000000  ?  */
        0X08, /* 00001000  ?  */
        0X00, /* 00000000  ?  */
        0X00, /* 00000000  ?  */
        0X00, /* 00000000  ?  */
        0X00, /* 00000000    */

        0X00, /* 00000000  @  */
        0X00, /* 00000000  @  */
        0X3e, /* 00111110  @  */
        0X41, /* 01000001  @  */
        0X41, /* 01000001  @  */
        0X79, /* 01111001  @  */
        0X45, /* 01000101  @  */
        0X65, /* 01100101  @  */
        0X59, /* 01011001  @  */
        0X01, /* 00000001  @  */
        0X01, /* 00000001  @  */
        0X3e, /* 00111110  @  */
        0X00, /* 00000000  @  */
        0X00, /* 00000000  @  */
        0X00, /* 00000000  @  */
        0X00, /* 00000000    */

        0X00, /* 00000000  A  */
        0X00, /* 00000000  A  */
        0X08, /* 00001000  A  */
        0X14, /* 00010100  A  */
        0X22, /* 00100010  A  */
        0X41, /* 01000001  A  */
        0X41, /* 01000001  A  */
        0X41, /* 01000001  A  */
        0X7f, /* 01111111  A  */
        0X41, /* 01000001  A  */
        0X41, /* 01000001  A  */
        0X41, /* 01000001  A  */
        0X00, /* 00000000  A  */
        0X00, /* 00000000  A  */
        0X00, /* 00000000  A  */
        0X00, /* 00000000    */

        0X00, /* 00000000  B  */
        0X00, /* 00000000  B  */
        0X3f, /* 00111111  B  */
        0X42, /* 01000010  B  */
        0X42, /* 01000010  B  */
        0X42, /* 01000010  B  */
        0X3e, /* 00111110  B  */
        0X42, /* 01000010  B  */
        0X42, /* 01000010  B  */
        0X42, /* 01000010  B  */
        0X42, /* 01000010  B  */
        0X3f, /* 00111111  B  */
        0X00, /* 00000000  B  */
        0X00, /* 00000000  B  */
        0X00, /* 00000000  B  */
        0X00, /* 00000000    */

        0X00, /* 00000000  C  */
        0X00, /* 00000000  C  */
        0X3e, /* 00111110  C  */
        0X41, /* 01000001  C  */
        0X01, /* 00000001  C  */
        0X01, /* 00000001  C  */
        0X01, /* 00000001  C  */
        0X01, /* 00000001  C  */
        0X01, /* 00000001  C  */
        0X01, /* 00000001  C  */
        0X41, /* 01000001  C  */
        0X3e, /* 00111110  C  */
        0X00, /* 00000000  C  */
        0X00, /* 00000000  C  */
        0X00, /* 00000000  C  */
        0X00, /* 00000000    */

        0X00, /* 00000000  D  */
        0X00, /* 00000000  D  */
        0X3f, /* 00111111  D  */
        0X42, /* 01000010  D  */
        0X42, /* 01000010  D  */
        0X42, /* 01000010  D  */
        0X42, /* 01000010  D  */
        0X42, /* 01000010  D  */
        0X42, /* 01000010  D  */
        0X42, /* 01000010  D  */
        0X42, /* 01000010  D  */
        0X3f, /* 00111111  D  */
        0X00, /* 00000000  D  */
        0X00, /* 00000000  D  */
        0X00, /* 00000000  D  */
        0X00, /* 00000000    */

        0X00, /* 00000000  E  */
        0X00, /* 00000000  E  */
        0X7e, /* 01111110  E  */
        0X02, /* 00000010  E  */
        0X02, /* 00000010  E  */
        0X02, /* 00000010  E  */
        0X1e, /* 00011110  E  */
        0X02, /* 00000010  E  */
        0X02, /* 00000010  E  */
        0X02, /* 00000010  E  */
        0X02, /* 00000010  E  */
        0X7e, /* 01111110  E  */
        0X00, /* 00000000  E  */
        0X00, /* 00000000  E  */
        0X00, /* 00000000  E  */
        0X00, /* 00000000    */

        0X00, /* 00000000  F  */
        0X00, /* 00000000  F  */
        0X7e, /* 01111110  F  */
        0X02, /* 00000010  F  */
        0X02, /* 00000010  F  */
        0X02, /* 00000010  F  */
        0X1e, /* 00011110  F  */
        0X02, /* 00000010  F  */
        0X02, /* 00000010  F  */
        0X02, /* 00000010  F  */
        0X02, /* 00000010  F  */
        0X02, /* 00000010  F  */
        0X00, /* 00000000  F  */
        0X00, /* 00000000  F  */
        0X00, /* 00000000  F  */
        0X00, /* 00000000    */

        0X00, /* 00000000  G  */
        0X00, /* 00000000  G  */
        0X3e, /* 00111110  G  */
        0X41, /* 01000001  G  */
        0X01, /* 00000001  G  */
        0X01, /* 00000001  G  */
        0X01, /* 00000001  G  */
        0X71, /* 01110001  G  */
        0X41, /* 01000001  G  */
        0X41, /* 01000001  G  */
        0X41, /* 01000001  G  */
        0X3e, /* 00111110  G  */
        0X00, /* 00000000  G  */
        0X00, /* 00000000  G  */
        0X00, /* 00000000  G  */
        0X00, /* 00000000    */

        0X00, /* 00000000  H  */
        0X00, /* 00000000  H  */
        0X41, /* 01000001  H  */
        0X41, /* 01000001  H  */
        0X41, /* 01000001  H  */
        0X41, /* 01000001  H  */
        0X7f, /* 01111111  H  */
        0X41, /* 01000001  H  */
        0X41, /* 01000001  H  */
        0X41, /* 01000001  H  */
        0X41, /* 01000001  H  */
        0X41, /* 01000001  H  */
        0X00, /* 00000000  H  */
        0X00, /* 00000000  H  */
        0X00, /* 00000000  H  */
        0X00, /* 00000000    */

        0X00, /* 00000000  I  */
        0X00, /* 00000000  I  */
        0X3e, /* 00111110  I  */
        0X08, /* 00001000  I  */
        0X08, /* 00001000  I  */
        0X08, /* 00001000  I  */
        0X08, /* 00001000  I  */
        0X08, /* 00001000  I  */
        0X08, /* 00001000  I  */
        0X08, /* 00001000  I  */
        0X08, /* 00001000  I  */
        0X3e, /* 00111110  I  */
        0X00, /* 00000000  I  */
        0X00, /* 00000000  I  */
        0X00, /* 00000000  I  */
        0X00, /* 00000000    */

        0X00, /* 00000000  J  */
        0X00, /* 00000000  J  */
        0X78, /* 01111000  J  */
        0X20, /* 00100000  J  */
        0X20, /* 00100000  J  */
        0X20, /* 00100000  J  */
        0X20, /* 00100000  J  */
        0X20, /* 00100000  J  */
        0X20, /* 00100000  J  */
        0X20, /* 00100000  J  */
        0X21, /* 00100001  J  */
        0X1e, /* 00011110  J  */
        0X00, /* 00000000  J  */
        0X00, /* 00000000  J  */
        0X00, /* 00000000  J  */
        0X00, /* 00000000    */

        0X00, /* 00000000  K  */
        0X00, /* 00000000  K  */
        0X41, /* 01000001  K  */
        0X21, /* 00100001  K  */
        0X11, /* 00010001  K  */
        0X09, /* 00001001  K  */
        0X07, /* 00000111  K  */
        0X05, /* 00000101  K  */
        0X09, /* 00001001  K  */
        0X11, /* 00010001  K  */
        0X21, /* 00100001  K  */
        0X41, /* 01000001  K  */
        0X00, /* 00000000  K  */
        0X00, /* 00000000  K  */
        0X00, /* 00000000  K  */
        0X00, /* 00000000    */

        0X00, /* 00000000  L  */
        0X00, /* 00000000  L  */
        0X01, /* 00000001  L  */
        0X01, /* 00000001  L  */
        0X01, /* 00000001  L  */
        0X01, /* 00000001  L  */
        0X01, /* 00000001  L  */
        0X01, /* 00000001  L  */
        0X01, /* 00000001  L  */
        0X01, /* 00000001  L  */
        0X01, /* 00000001  L  */
        0X7f, /* 01111111  L  */
        0X00, /* 00000000  L  */
        0X00, /* 00000000  L  */
        0X00, /* 00000000  L  */
        0X00, /* 00000000    */

        0X00, /* 00000000  M  */
        0X00, /* 00000000  M  */
        0X41, /* 01000001  M  */
        0X41, /* 01000001  M  */
        0X63, /* 01100011  M  */
        0X55, /* 01010101  M  */
        0X55, /* 01010101  M  */
        0X49, /* 01001001  M  */
        0X49, /* 01001001  M  */
        0X41, /* 01000001  M  */
        0X41, /* 01000001  M  */
        0X41, /* 01000001  M  */
        0X00, /* 00000000  M  */
        0X00, /* 00000000  M  */
        0X00, /* 00000000  M  */
        0X00, /* 00000000    */

        0X00, /* 00000000  N  */
        0X00, /* 00000000  N  */
        0X41, /* 01000001  N  */
        0X41, /* 01000001  N  */
        0X43, /* 01000011  N  */
        0X45, /* 01000101  N  */
        0X49, /* 01001001  N  */
        0X51, /* 01010001  N  */
        0X61, /* 01100001  N  */
        0X41, /* 01000001  N  */
        0X41, /* 01000001  N  */
        0X41, /* 01000001  N  */
        0X00, /* 00000000  N  */
        0X00, /* 00000000  N  */
        0X00, /* 00000000  N  */
        0X00, /* 00000000    */

        0X00, /* 00000000  O  */
        0X00, /* 00000000  O  */
        0X3e, /* 00111110  O  */
        0X41, /* 01000001  O  */
        0X41, /* 01000001  O  */
        0X41, /* 01000001  O  */
        0X41, /* 01000001  O  */
        0X41, /* 01000001  O  */
        0X41, /* 01000001  O  */
        0X41, /* 01000001  O  */
        0X41, /* 01000001  O  */
        0X3e, /* 00111110  O  */
        0X00, /* 00000000  O  */
        0X00, /* 00000000  O  */
        0X00, /* 00000000  O  */
        0X00, /* 00000000    */

        0X00, /* 00000000  P  */
        0X00, /* 00000000  P  */
        0X3f, /* 00111111  P  */
        0X41, /* 01000001  P  */
        0X41, /* 01000001  P  */
        0X41, /* 01000001  P  */
        0X3f, /* 00111111  P  */
        0X01, /* 00000001  P  */
        0X01, /* 00000001  P  */
        0X01, /* 00000001  P  */
        0X01, /* 00000001  P  */
        0X01, /* 00000001  P  */
        0X00, /* 00000000  P  */
        0X00, /* 00000000  P  */
        0X00, /* 00000000  P  */
        0X00, /* 00000000    */

        0X00, /* 00000000  Q  */
        0X00, /* 00000000  Q  */
        0X3e, /* 00111110  Q  */
        0X41, /* 01000001  Q  */
        0X41, /* 01000001  Q  */
        0X41, /* 01000001  Q  */
        0X41, /* 01000001  Q  */
        0X41, /* 01000001  Q  */
        0X41, /* 01000001  Q  */
        0X49, /* 01001001  Q  */
        0X51, /* 01010001  Q  */
        0X3e, /* 00111110  Q  */
        0X40, /* 01000000  Q  */
        0X00, /* 00000000  Q  */
        0X00, /* 00000000  Q  */
        0X00, /* 00000000    */

        0X00, /* 00000000  R  */
        0X00, /* 00000000  R  */
        0X3f, /* 00111111  R  */
        0X41, /* 01000001  R  */
        0X41, /* 01000001  R  */
        0X41, /* 01000001  R  */
        0X3f, /* 00111111  R  */
        0X09, /* 00001001  R  */
        0X11, /* 00010001  R  */
        0X21, /* 00100001  R  */
        0X41, /* 01000001  R  */
        0X41, /* 01000001  R  */
        0X00, /* 00000000  R  */
        0X00, /* 00000000  R  */
        0X00, /* 00000000  R  */
        0X00, /* 00000000    */

        0X00, /* 00000000  S  */
        0X00, /* 00000000  S  */
        0X3e, /* 00111110  S  */
        0X41, /* 01000001  S  */
        0X01, /* 00000001  S  */
        0X01, /* 00000001  S  */
        0X3e, /* 00111110  S  */
        0X40, /* 01000000  S  */
        0X40, /* 01000000  S  */
        0X40, /* 01000000  S  */
        0X41, /* 01000001  S  */
        0X3e, /* 00111110  S  */
        0X00, /* 00000000  S  */
        0X00, /* 00000000  S  */
        0X00, /* 00000000  S  */
        0X00, /* 00000000    */

        0X00, /* 00000000  T  */
        0X00, /* 00000000  T  */
        0X7f, /* 01111111  T  */
        0X08, /* 00001000  T  */
        0X08, /* 00001000  T  */
        0X08, /* 00001000  T  */
        0X08, /* 00001000  T  */
        0X08, /* 00001000  T  */
        0X08, /* 00001000  T  */
        0X08, /* 00001000  T  */
        0X08, /* 00001000  T  */
        0X08, /* 00001000  T  */
        0X00, /* 00000000  T  */
        0X00, /* 00000000  T  */
        0X00, /* 00000000  T  */
        0X00, /* 00000000    */

        0X00, /* 00000000  U  */
        0X00, /* 00000000  U  */
        0X41, /* 01000001  U  */
        0X41, /* 01000001  U  */
        0X41, /* 01000001  U  */
        0X41, /* 01000001  U  */
        0X41, /* 01000001  U  */
        0X41, /* 01000001  U  */
        0X41, /* 01000001  U  */
        0X41, /* 01000001  U  */
        0X41, /* 01000001  U  */
        0X3e, /* 00111110  U  */
        0X00, /* 00000000  U  */
        0X00, /* 00000000  U  */
        0X00, /* 00000000  U  */
        0X00, /* 00000000    */

        0X00, /* 00000000  V  */
        0X00, /* 00000000  V  */
        0X41, /* 01000001  V  */
        0X41, /* 01000001  V  */
        0X41, /* 01000001  V  */
        0X22, /* 00100010  V  */
        0X22, /* 00100010  V  */
        0X22, /* 00100010  V  */
        0X14, /* 00010100  V  */
        0X14, /* 00010100  V  */
        0X14, /* 00010100  V  */
        0X08, /* 00001000  V  */
        0X00, /* 00000000  V  */
        0X00, /* 00000000  V  */
        0X00, /* 00000000  V  */
        0X00, /* 00000000    */

        0X00, /* 00000000  W  */
        0X00, /* 00000000  W  */
        0X41, /* 01000001  W  */
        0X41, /* 01000001  W  */
        0X41, /* 01000001  W  */
        0X41, /* 01000001  W  */
        0X49, /* 01001001  W  */
        0X49, /* 01001001  W  */
        0X49, /* 01001001  W  */
        0X49, /* 01001001  W  */
        0X55, /* 01010101  W  */
        0X22, /* 00100010  W  */
        0X00, /* 00000000  W  */
        0X00, /* 00000000  W  */
        0X00, /* 00000000  W  */
        0X00, /* 00000000    */

        0X00, /* 00000000  X  */
        0X00, /* 00000000  X  */
        0X41, /* 01000001  X  */
        0X41, /* 01000001  X  */
        0X22, /* 00100010  X  */
        0X14, /* 00010100  X  */
        0X08, /* 00001000  X  */
        0X08, /* 00001000  X  */
        0X14, /* 00010100  X  */
        0X22, /* 00100010  X  */
        0X41, /* 01000001  X  */
        0X41, /* 01000001  X  */
        0X00, /* 00000000  X  */
        0X00, /* 00000000  X  */
        0X00, /* 00000000  X  */
        0X00, /* 00000000    */

        0X00, /* 00000000  Y  */
        0X00, /* 00000000  Y  */
        0X41, /* 01000001  Y  */
        0X41, /* 01000001  Y  */
        0X22, /* 00100010  Y  */
        0X14, /* 00010100  Y  */
        0X08, /* 00001000  Y  */
        0X08, /* 00001000  Y  */
        0X08, /* 00001000  Y  */
        0X08, /* 00001000  Y  */
        0X08, /* 00001000  Y  */
        0X08, /* 00001000  Y  */
        0X00, /* 00000000  Y  */
        0X00, /* 00000000  Y  */
        0X00, /* 00000000  Y  */
        0X00, /* 00000000    */

        0X00, /* 00000000  Z  */
        0X00, /* 00000000  Z  */
        0X7f, /* 01111111  Z  */
        0X40, /* 01000000  Z  */
        0X20, /* 00100000  Z  */
        0X10, /* 00010000  Z  */
        0X08, /* 00001000  Z  */
        0X04, /* 00000100  Z  */
        0X02, /* 00000010  Z  */
        0X01, /* 00000001  Z  */
        0X01, /* 00000001  Z  */
        0X7f, /* 01111111  Z  */
        0X00, /* 00000000  Z  */
        0X00, /* 00000000  Z  */
        0X00, /* 00000000  Z  */
        0X00, /* 00000000    */

        0X00, /* 00000000  [  */
        0X00, /* 00000000  [  */
        0X3c, /* 00111100  [  */
        0X04, /* 00000100  [  */
        0X04, /* 00000100  [  */
        0X04, /* 00000100  [  */
        0X04, /* 00000100  [  */
        0X04, /* 00000100  [  */
        0X04, /* 00000100  [  */
        0X04, /* 00000100  [  */
        0X04, /* 00000100  [  */
        0X3c, /* 00111100  [  */
        0X00, /* 00000000  [  */
        0X00, /* 00000000  [  */
        0X00, /* 00000000  [  */
        0X00, /* 00000000    */

        0X00, /* 00000000  \  */
        0X00, /* 00000000  \  */
        0X01, /* 00000001  \  */
        0X02, /* 00000010  \  */
        0X02, /* 00000010  \  */
        0X04, /* 00000100  \  */
        0X08, /* 00001000  \  */
        0X08, /* 00001000  \  */
        0X10, /* 00010000  \  */
        0X20, /* 00100000  \  */
        0X20, /* 00100000  \  */
        0X40, /* 01000000  \  */
        0X00, /* 00000000  \  */
        0X00, /* 00000000  \  */
        0X00, /* 00000000  \  */
        0X00, /* 00000000    */

        0X00, /* 00000000  ]  */
        0X00, /* 00000000  ]  */
        0X1e, /* 00011110  ]  */
        0X10, /* 00010000  ]  */
        0X10, /* 00010000  ]  */
        0X10, /* 00010000  ]  */
        0X10, /* 00010000  ]  */
        0X10, /* 00010000  ]  */
        0X10, /* 00010000  ]  */
        0X10, /* 00010000  ]  */
        0X10, /* 00010000  ]  */
        0X1e, /* 00011110  ]  */
        0X00, /* 00000000  ]  */
        0X00, /* 00000000  ]  */
        0X00, /* 00000000  ]  */
        0X00, /* 00000000    */

        0X00, /* 00000000  ^  */
        0X00, /* 00000000  ^  */
        0X08, /* 00001000  ^  */
        0X14, /* 00010100  ^  */
        0X22, /* 00100010  ^  */
        0X41, /* 01000001  ^  */
        0X00, /* 00000000  ^  */
        0X00, /* 00000000  ^  */
        0X00, /* 00000000  ^  */
        0X00, /* 00000000  ^  */
        0X00, /* 00000000  ^  */
        0X00, /* 00000000  ^  */
        0X00, /* 00000000  ^  */
        0X00, /* 00000000  ^  */
        0X00, /* 00000000  ^  */
        0X00, /* 00000000    */

        0X00, /* 00000000  _  */
        0X00, /* 00000000  _  */
        0X00, /* 00000000  _  */
        0X00, /* 00000000  _  */
        0X00, /* 00000000  _  */
        0X00, /* 00000000  _  */
        0X00, /* 00000000  _  */
        0X00, /* 00000000  _  */
        0X00, /* 00000000  _  */
        0X00, /* 00000000  _  */
        0X00, /* 00000000  _  */
        0X00, /* 00000000  _  */
        0X7f, /* 01111111  _  */
        0X00, /* 00000000  _  */
        0X00, /* 00000000  _  */
        0X00, /* 00000000    */

        0X00, /* 00000000  `  */
        0X00, /* 00000000  `  */
        0X0e, /* 00001110  `  */
        0X0c, /* 00001100  `  */
        0X10, /* 00010000  `  */
        0X00, /* 00000000  `  */
        0X00, /* 00000000  `  */
        0X00, /* 00000000  `  */
        0X00, /* 00000000  `  */
        0X00, /* 00000000  `  */
        0X00, /* 00000000  `  */
        0X00, /* 00000000  `  */
        0X00, /* 00000000  `  */
        0X00, /* 00000000  `  */
        0X00, /* 00000000  `  */
        0X00, /* 00000000    */

        0X00, /* 00000000  a  */
        0X00, /* 00000000  a  */
        0X00, /* 00000000  a  */
        0X00, /* 00000000  a  */
        0X00, /* 00000000  a  */
        0X3e, /* 00111110  a  */
        0X40, /* 01000000  a  */
        0X40, /* 01000000  a  */
        0X7e, /* 01111110  a  */
        0X41, /* 01000001  a  */
        0X61, /* 01100001  a  */
        0X5e, /* 01011110  a  */
        0X00, /* 00000000  a  */
        0X00, /* 00000000  a  */
        0X00, /* 00000000  a  */
        0X00, /* 00000000    */

        0X00, /* 00000000  b  */
        0X00, /* 00000000  b  */
        0X01, /* 00000001  b  */
        0X01, /* 00000001  b  */
        0X01, /* 00000001  b  */
        0X3d, /* 00111101  b  */
        0X43, /* 01000011  b  */
        0X41, /* 01000001  b  */
        0X41, /* 01000001  b  */
        0X41, /* 01000001  b  */
        0X43, /* 01000011  b  */
        0X3d, /* 00111101  b  */
        0X00, /* 00000000  b  */
        0X00, /* 00000000  b  */
        0X00, /* 00000000  b  */
        0X00, /* 00000000    */

        0X00, /* 00000000  c  */
        0X00, /* 00000000  c  */
        0X00, /* 00000000  c  */
        0X00, /* 00000000  c  */
        0X00, /* 00000000  c  */
        0X3e, /* 00111110  c  */
        0X41, /* 01000001  c  */
        0X01, /* 00000001  c  */
        0X01, /* 00000001  c  */
        0X01, /* 00000001  c  */
        0X41, /* 01000001  c  */
        0X3e, /* 00111110  c  */
        0X00, /* 00000000  c  */
        0X00, /* 00000000  c  */
        0X00, /* 00000000  c  */
        0X00, /* 00000000    */

        0X00, /* 00000000  d  */
        0X00, /* 00000000  d  */
        0X40, /* 01000000  d  */
        0X40, /* 01000000  d  */
        0X40, /* 01000000  d  */
        0X5e, /* 01011110  d  */
        0X61, /* 01100001  d  */
        0X41, /* 01000001  d  */
        0X41, /* 01000001  d  */
        0X41, /* 01000001  d  */
        0X61, /* 01100001  d  */
        0X5e, /* 01011110  d  */
        0X00, /* 00000000  d  */
        0X00, /* 00000000  d  */
        0X00, /* 00000000  d  */
        0X00, /* 00000000    */

        0X00, /* 00000000  e  */
        0X00, /* 00000000  e  */
        0X00, /* 00000000  e  */
        0X00, /* 00000000  e  */
        0X00, /* 00000000  e  */
        0X3e, /* 00111110  e  */
        0X41, /* 01000001  e  */
        0X41, /* 01000001  e  */
        0X7f, /* 01111111  e  */
        0X01, /* 00000001  e  */
        0X01, /* 00000001  e  */
        0X3e, /* 00111110  e  */
        0X00, /* 00000000  e  */
        0X00, /* 00000000  e  */
        0X00, /* 00000000  e  */
        0X00, /* 00000000    */

        0X00, /* 00000000  f  */
        0X00, /* 00000000  f  */
        0X38, /* 00111000  f  */
        0X44, /* 01000100  f  */
        0X44, /* 01000100  f  */
        0X04, /* 00000100  f  */
        0X04, /* 00000100  f  */
        0X1f, /* 00011111  f  */
        0X04, /* 00000100  f  */
        0X04, /* 00000100  f  */
        0X04, /* 00000100  f  */
        0X04, /* 00000100  f  */
        0X00, /* 00000000  f  */
        0X00, /* 00000000  f  */
        0X00, /* 00000000  f  */
        0X00, /* 00000000    */

        0X00, /* 00000000  g  */
        0X00, /* 00000000  g  */
        0X00, /* 00000000  g  */
        0X00, /* 00000000  g  */
        0X00, /* 00000000  g  */
        0X5e, /* 01011110  g  */
        0X21, /* 00100001  g  */
        0X21, /* 00100001  g  */
        0X21, /* 00100001  g  */
        0X1e, /* 00011110  g  */
        0X01, /* 00000001  g  */
        0X3e, /* 00111110  g  */
        0X41, /* 01000001  g  */
        0X41, /* 01000001  g  */
        0X3e, /* 00111110  g  */
        0X00, /* 00000000    */

        0X00, /* 00000000  h  */
        0X00, /* 00000000  h  */
        0X01, /* 00000001  h  */
        0X01, /* 00000001  h  */
        0X01, /* 00000001  h  */
        0X3d, /* 00111101  h  */
        0X43, /* 01000011  h  */
        0X41, /* 01000001  h  */
        0X41, /* 01000001  h  */
        0X41, /* 01000001  h  */
        0X41, /* 01000001  h  */
        0X41, /* 01000001  h  */
        0X00, /* 00000000  h  */
        0X00, /* 00000000  h  */
        0X00, /* 00000000  h  */
        0X00, /* 00000000    */

        0X00, /* 00000000  i  */
        0X00, /* 00000000  i  */
        0X00, /* 00000000  i  */
        0X08, /* 00001000  i  */
        0X00, /* 00000000  i  */
        0X0c, /* 00001100  i  */
        0X08, /* 00001000  i  */
        0X08, /* 00001000  i  */
        0X08, /* 00001000  i  */
        0X08, /* 00001000  i  */
        0X08, /* 00001000  i  */
        0X3e, /* 00111110  i  */
        0X00, /* 00000000  i  */
        0X00, /* 00000000  i  */
        0X00, /* 00000000  i  */
        0X00, /* 00000000    */

        0X00, /* 00000000  j  */
        0X00, /* 00000000  j  */
        0X00, /* 00000000  j  */
        0X20, /* 00100000  j  */
        0X00, /* 00000000  j  */
        0X38, /* 00111000  j  */
        0X20, /* 00100000  j  */
        0X20, /* 00100000  j  */
        0X20, /* 00100000  j  */
        0X20, /* 00100000  j  */
        0X20, /* 00100000  j  */
        0X21, /* 00100001  j  */
        0X21, /* 00100001  j  */
        0X21, /* 00100001  j  */
        0X1e, /* 00011110  j  */
        0X00, /* 00000000    */

        0X00, /* 00000000  k  */
        0X00, /* 00000000  k  */
        0X01, /* 00000001  k  */
        0X01, /* 00000001  k  */
        0X01, /* 00000001  k  */
        0X41, /* 01000001  k  */
        0X31, /* 00110001  k  */
        0X0d, /* 00001101  k  */
        0X03, /* 00000011  k  */
        0X0d, /* 00001101  k  */
        0X31, /* 00110001  k  */
        0X41, /* 01000001  k  */
        0X00, /* 00000000  k  */
        0X00, /* 00000000  k  */
        0X00, /* 00000000  k  */
        0X00, /* 00000000    */

        0X00, /* 00000000  l  */
        0X00, /* 00000000  l  */
        0X0c, /* 00001100  l  */
        0X08, /* 00001000  l  */
        0X08, /* 00001000  l  */
        0X08, /* 00001000  l  */
        0X08, /* 00001000  l  */
        0X08, /* 00001000  l  */
        0X08, /* 00001000  l  */
        0X08, /* 00001000  l  */
        0X08, /* 00001000  l  */
        0X3e, /* 00111110  l  */
        0X00, /* 00000000  l  */
        0X00, /* 00000000  l  */
        0X00, /* 00000000  l  */
        0X00, /* 00000000    */

        0X00, /* 00000000  m  */
        0X00, /* 00000000  m  */
        0X00, /* 00000000  m  */
        0X00, /* 00000000  m  */
        0X00, /* 00000000  m  */
        0X37, /* 00110111  m  */
        0X49, /* 01001001  m  */
        0X49, /* 01001001  m  */
        0X49, /* 01001001  m  */
        0X49, /* 01001001  m  */
        0X49, /* 01001001  m  */
        0X41, /* 01000001  m  */
        0X00, /* 00000000  m  */
        0X00, /* 00000000  m  */
        0X00, /* 00000000  m  */
        0X00, /* 00000000    */

        0X00, /* 00000000  n  */
        0X00, /* 00000000  n  */
        0X00, /* 00000000  n  */
        0X00, /* 00000000  n  */
        0X00, /* 00000000  n  */
        0X3d, /* 00111101  n  */
        0X43, /* 01000011  n  */
        0X41, /* 01000001  n  */
        0X41, /* 01000001  n  */
        0X41, /* 01000001  n  */
        0X41, /* 01000001  n  */
        0X41, /* 01000001  n  */
        0X00, /* 00000000  n  */
        0X00, /* 00000000  n  */
        0X00, /* 00000000  n  */
        0X00, /* 00000000    */

        0X00, /* 00000000  o  */
        0X00, /* 00000000  o  */
        0X00, /* 00000000  o  */
        0X00, /* 00000000  o  */
        0X00, /* 00000000  o  */
        0X3e, /* 00111110  o  */
        0X41, /* 01000001  o  */
        0X41, /* 01000001  o  */
        0X41, /* 01000001  o  */
        0X41, /* 01000001  o  */
        0X41, /* 01000001  o  */
        0X3e, /* 00111110  o  */
        0X00, /* 00000000  o  */
        0X00, /* 00000000  o  */
        0X00, /* 00000000  o  */
        0X00, /* 00000000    */

        0X00, /* 00000000  p  */
        0X00, /* 00000000  p  */
        0X00, /* 00000000  p  */
        0X00, /* 00000000  p  */
        0X00, /* 00000000  p  */
        0X3d, /* 00111101  p  */
        0X43, /* 01000011  p  */
        0X41, /* 01000001  p  */
        0X41, /* 01000001  p  */
        0X41, /* 01000001  p  */
        0X43, /* 01000011  p  */
        0X3d, /* 00111101  p  */
        0X01, /* 00000001  p  */
        0X01, /* 00000001  p  */
        0X01, /* 00000001  p  */
        0X00, /* 00000000    */

        0X00, /* 00000000  q  */
        0X00, /* 00000000  q  */
        0X00, /* 00000000  q  */
        0X00, /* 00000000  q  */
        0X00, /* 00000000  q  */
        0X5e, /* 01011110  q  */
        0X61, /* 01100001  q  */
        0X41, /* 01000001  q  */
        0X41, /* 01000001  q  */
        0X41, /* 01000001  q  */
        0X61, /* 01100001  q  */
        0X5e, /* 01011110  q  */
        0X40, /* 01000000  q  */
        0X40, /* 01000000  q  */
        0X40, /* 01000000  q  */
        0X00, /* 00000000    */

        0X00, /* 00000000  r  */
        0X00, /* 00000000  r  */
        0X00, /* 00000000  r  */
        0X00, /* 00000000  r  */
        0X00, /* 00000000  r  */
        0X39, /* 00111001  r  */
        0X46, /* 01000110  r  */
        0X42, /* 01000010  r  */
        0X02, /* 00000010  r  */
        0X02, /* 00000010  r  */
        0X02, /* 00000010  r  */
        0X02, /* 00000010  r  */
        0X00, /* 00000000  r  */
        0X00, /* 00000000  r  */
        0X00, /* 00000000  r  */
        0X00, /* 00000000    */

        0X00, /* 00000000  s  */
        0X00, /* 00000000  s  */
        0X00, /* 00000000  s  */
        0X00, /* 00000000  s  */
        0X00, /* 00000000  s  */
        0X3e, /* 00111110  s  */
        0X41, /* 01000001  s  */
        0X01, /* 00000001  s  */
        0X3e, /* 00111110  s  */
        0X40, /* 01000000  s  */
        0X41, /* 01000001  s  */
        0X3e, /* 00111110  s  */
        0X00, /* 00000000  s  */
        0X00, /* 00000000  s  */
        0X00, /* 00000000  s  */
        0X00, /* 00000000    */

        0X00, /* 00000000  t  */
        0X00, /* 00000000  t  */
        0X00, /* 00000000  t  */
        0X04, /* 00000100  t  */
        0X04, /* 00000100  t  */
        0X3f, /* 00111111  t  */
        0X04, /* 00000100  t  */
        0X04, /* 00000100  t  */
        0X04, /* 00000100  t  */
        0X04, /* 00000100  t  */
        0X44, /* 01000100  t  */
        0X38, /* 00111000  t  */
        0X00, /* 00000000  t  */
        0X00, /* 00000000  t  */
        0X00, /* 00000000  t  */
        0X00, /* 00000000    */

        0X00, /* 00000000  u  */
        0X00, /* 00000000  u  */
        0X00, /* 00000000  u  */
        0X00, /* 00000000  u  */
        0X00, /* 00000000  u  */
        0X21, /* 00100001  u  */
        0X21, /* 00100001  u  */
        0X21, /* 00100001  u  */
        0X21, /* 00100001  u  */
        0X21, /* 00100001  u  */
        0X21, /* 00100001  u  */
        0X5e, /* 01011110  u  */
        0X00, /* 00000000  u  */
        0X00, /* 00000000  u  */
        0X00, /* 00000000  u  */
        0X00, /* 00000000    */

        0X00, /* 00000000  v  */
        0X00, /* 00000000  v  */
        0X00, /* 00000000  v  */
        0X00, /* 00000000  v  */
        0X00, /* 00000000  v  */
        0X41, /* 01000001  v  */
        0X41, /* 01000001  v  */
        0X22, /* 00100010  v  */
        0X22, /* 00100010  v  */
        0X14, /* 00010100  v  */
        0X14, /* 00010100  v  */
        0X08, /* 00001000  v  */
        0X00, /* 00000000  v  */
        0X00, /* 00000000  v  */
        0X00, /* 00000000  v  */
        0X00, /* 00000000    */

        0X00, /* 00000000  w  */
        0X00, /* 00000000  w  */
        0X00, /* 00000000  w  */
        0X00, /* 00000000  w  */
        0X00, /* 00000000  w  */
        0X41, /* 01000001  w  */
        0X41, /* 01000001  w  */
        0X49, /* 01001001  w  */
        0X49, /* 01001001  w  */
        0X49, /* 01001001  w  */
        0X55, /* 01010101  w  */
        0X22, /* 00100010  w  */
        0X00, /* 00000000  w  */
        0X00, /* 00000000  w  */
        0X00, /* 00000000  w  */
        0X00, /* 00000000    */

        0X00, /* 00000000  x  */
        0X00, /* 00000000  x  */
        0X00, /* 00000000  x  */
        0X00, /* 00000000  x  */
        0X00, /* 00000000  x  */
        0X41, /* 01000001  x  */
        0X22, /* 00100010  x  */
        0X14, /* 00010100  x  */
        0X08, /* 00001000  x  */
        0X14, /* 00010100  x  */
        0X22, /* 00100010  x  */
        0X41, /* 01000001  x  */
        0X00, /* 00000000  x  */
        0X00, /* 00000000  x  */
        0X00, /* 00000000  x  */
        0X00, /* 00000000    */

        0X00, /* 00000000  y  */
        0X00, /* 00000000  y  */
        0X00, /* 00000000  y  */
        0X00, /* 00000000  y  */
        0X00, /* 00000000  y  */
        0X21, /* 00100001  y  */
        0X21, /* 00100001  y  */
        0X21, /* 00100001  y  */
        0X21, /* 00100001  y  */
        0X21, /* 00100001  y  */
        0X31, /* 00110001  y  */
        0X2e, /* 00101110  y  */
        0X20, /* 00100000  y  */
        0X21, /* 00100001  y  */
        0X1e, /* 00011110  y  */
        0X00, /* 00000000    */

        0X00, /* 00000000  z  */
        0X00, /* 00000000  z  */
        0X00, /* 00000000  z  */
        0X00, /* 00000000  z  */
        0X00, /* 00000000  z  */
        0X7f, /* 01111111  z  */
        0X20, /* 00100000  z  */
        0X10, /* 00010000  z  */
        0X08, /* 00001000  z  */
        0X04, /* 00000100  z  */
        0X02, /* 00000010  z  */
        0X7f, /* 01111111  z  */
        0X00, /* 00000000  z  */
        0X00, /* 00000000  z  */
        0X00, /* 00000000  z  */
        0X00, /* 00000000    */

        0X00, /* 00000000  {  */
        0X00, /* 00000000  {  */
        0X70, /* 01110000  {  */
        0X08, /* 00001000  {  */
        0X08, /* 00001000  {  */
        0X10, /* 00010000  {  */
        0X0c, /* 00001100  {  */
        0X0c, /* 00001100  {  */
        0X10, /* 00010000  {  */
        0X08, /* 00001000  {  */
        0X08, /* 00001000  {  */
        0X70, /* 01110000  {  */
        0X00, /* 00000000  {  */
        0X00, /* 00000000  {  */
        0X00, /* 00000000  {  */
        0X00, /* 00000000    */

        0X00, /* 00000000  |  */
        0X00, /* 00000000  |  */
        0X08, /* 00001000  |  */
        0X08, /* 00001000  |  */
        0X08, /* 00001000  |  */
        0X08, /* 00001000  |  */
        0X08, /* 00001000  |  */
        0X08, /* 00001000  |  */
        0X08, /* 00001000  |  */
        0X08, /* 00001000  |  */
        0X08, /* 00001000  |  */
        0X08, /* 00001000  |  */
        0X00, /* 00000000  |  */
        0X00, /* 00000000  |  */
        0X00, /* 00000000  |  */
        0X00, /* 00000000    */

        0X00, /* 00000000  }  */
        0X00, /* 00000000  }  */
        0X07, /* 00000111  }  */
        0X08, /* 00001000  }  */
        0X08, /* 00001000  }  */
        0X04, /* 00000100  }  */
        0X18, /* 00011000  }  */
        0X18, /* 00011000  }  */
        0X04, /* 00000100  }  */
        0X08, /* 00001000  }  */
        0X08, /* 00001000  }  */
        0X07, /* 00000111  }  */
        0X00, /* 00000000  }  */
        0X00, /* 00000000  }  */
        0X00, /* 00000000  }  */
        0X00, /* 00000000    */

        0X00, /* 00000000  ~  */
        0X00, /* 00000000  ~  */
        0X46, /* 01000110  ~  */
        0X49, /* 01001001  ~  */
        0X31, /* 00110001  ~  */
        0X00, /* 00000000  ~  */
        0X00, /* 00000000  ~  */
        0X00, /* 00000000  ~  */
        0X00, /* 00000000  ~  */
        0X00, /* 00000000  ~  */
        0X00, /* 00000000  ~  */
        0X00, /* 00000000  ~  */
        0X00, /* 00000000  ~  */
        0X00, /* 00000000  ~  */
        0X00, /* 00000000  ~  */
        0X00, /* 00000000    */

        0X00, /* 00000000    */
        0X00, /* 00000000    */
        0X00, /* 00000000    */
        0X00, /* 00000000    */
        0X00, /* 00000000    */
        0X18, /* 00011000    */
        0X3c, /* 00111100    */
        0X3c, /* 00111100    */
        0X3c, /* 00111100    */
        0X18, /* 00011000    */
        0X00, /* 00000000    */
        0X00, /* 00000000    */
        0X00, /* 00000000    */
        0X00, /* 00000000    */
        0X00, /* 00000000    */
        0X00, /* 00000000    */
};

